/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.nbcr.opal.manager.pbsTorque;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.TimeZone;

public class Job {
    private String id;
    private String Name = "N/A";
    private String nodes = "N/A";
    private String ppn = "N/A";
    private ArrayList<String> afterany = new ArrayList();
    private ArrayList<String> afterOK = new ArrayList();
    private HashMap<String, String> variables = new HashMap();
    private String SubmitArgs = "N/A";
    private String ctime = "N/A";
    private String qtime = "N/A";
    private String mtime = "N/A";
    private String stime = "N/A";
    private String comp_time = "N/A";
    private String owner = "N/A";
    private String executableFile = "N/A";
    private String wallTime = "N/A";
    private String queue = "N/A";
    private String status = "N/A";
    private String executeNode = "N/A";
    private String ellapsedTime = "N/A";
    private String usedMem = "N/A";
    private String usedcput = "N/A";
    private String errrorPath = "N/A";
    private String outputPath = "N/A";
    private String VariablesList = "N/A";

    public Job(String JobName, String ShellFile) {
        this.Name = JobName;
        this.executableFile = ShellFile;
    }

    public Job() {
    }

    public String queue() throws IOException, InterruptedException, Exception {
        int i;
        StringBuilder excuter = new StringBuilder("qsub ");
        if (!"N/A".equals(this.getNodes()) && !"N/A".equals(this.getPpn())) {
            excuter.append("-l nodes=" + this.getNodes() + ":ppn=" + this.getPpn() + " ");
        } else if (this.getPpn() == null && this.getNodes() != null) {
            excuter.append("-l nodes=" + this.getNodes());
        }
        if (this.afterOK.size() > 0) {
            StringBuilder strOk = new StringBuilder(" -W depend=afterok");
            for (i = 0; i < this.getAfterOK().size(); ++i) {
                strOk.append(":" + this.getAfterOK().get(i));
            }
            excuter.append((CharSequence)strOk);
        }
        if (this.afterany.size() > 0) {
            StringBuilder strAny = new StringBuilder("-W depend=afterany");
            for (i = 0; i < this.getAfterany().size(); ++i) {
                strAny.append(":" + this.getAfterany().get(i));
            }
            excuter.append((CharSequence)strAny);
        }
        if (!"N/A".equals(this.getQueue())) {
            excuter.append("-q " + this.getQueue());
        }
        excuter.append(" " + this.getExecutableFile());
        String st = excuter.toString();
        Process p = Runtime.getRuntime().exec(st);
        p.waitFor();
        BufferedInputStream ef = new BufferedInputStream(p.getErrorStream());
        if (ef.available() > 0) {
            byte[] errdata = new byte[ef.available()];
            ef.read(errdata, 0, ef.available());
            st = new String(errdata);
            ef.close();
            p.getOutputStream().close();
            p.getInputStream().close();
            throw new Exception(st);
        }
        BufferedInputStream b = new BufferedInputStream(p.getInputStream());
        byte[] data = new byte[b.available()];
        b.read(data);
        p.getOutputStream().close();
        p.getErrorStream().close();
        b.close();
        return new String(data).replaceAll("\n", "");
    }

    private void analyzeVariableList(String Variables) {
        String[] vars = Variables.split(",");
        this.variables = new HashMap();
        for (int i = 0; i < vars.length; ++i) {
            String[] couple = vars[i].split("=");
            String header = couple[0].trim();
            String value = couple[1].trim();
            this.variables.put(header, value);
        }
    }

    public static String[] SearchJobsByName(String Name, Boolean ExactMatch) throws IOException, InterruptedException {
        ArrayList<String> FoundJobs = new ArrayList<String>();
        Process p = Runtime.getRuntime().exec("qstat");
        p.waitFor();
        BufferedInputStream ef = new BufferedInputStream(p.getInputStream());
        byte[] data = new byte[ef.available()];
        ef.read(data, 0, ef.available());
        ef.close();
        p.getOutputStream().close();
        p.getErrorStream().close();
        String Result = new String(data);
        String[] Jobs = Result.split("\n");
        for (int i = 2; i < Jobs.length; ++i) {
            String JobName = Jobs[i].substring(25, Jobs[i].indexOf(" ", 26));
            JobName = JobName.trim();
            if (ExactMatch.booleanValue()) {
                if (!JobName.equalsIgnoreCase(Name)) continue;
                FoundJobs.add(Jobs[i].substring(0, Jobs[i].indexOf(" ")));
                continue;
            }
            if (JobName.indexOf(Name) <= -1) continue;
            String JID = Jobs[i].substring(0, Jobs[i].indexOf(" "));
            FoundJobs.add(JID);
        }
        return FoundJobs.toArray(new String[FoundJobs.size()]);
    }

    public static Job getJobById(String id) throws IOException, InterruptedException, Exception {
        String[] Info2 = Job.getJobInfo(id);
        Job j = new Job();
        String header = "";
        String value = "";
        for (int i = 0; i < Info2.length; ++i) {
            String[] line = Info2[i].contains("=") ? Info2[i].split("=", 2) : Info2[i].split(":", 2);
            if (line.length < 2) continue;
            header = line[0].trim();
            value = line[1].trim();
            if (header.equals("Variable_List")) {
                while (Info2[i + 1].startsWith("\t")) {
                    value = value + Info2[i + 1];
                    ++i;
                }
                j.VariablesList = value = value.replaceAll("\t", "");
                j.analyzeVariableList(value);
                continue;
            }
            if ("Job Id".equals(header)) {
                j.setId(value);
                continue;
            }
            if ("Job_Name".equals(header)) {
                j.setName(value);
                continue;
            }
            if ("Job_Owner".equals(header)) {
                j.setOwner(value);
                continue;
            }
            if ("resources_used.cput".equals(header)) {
                j.setUsedcput(value);
                continue;
            }
            if ("resources_used.mem".equals(header)) {
                j.setUsedMem(value);
                continue;
            }
            if ("resources_used.walltime".equals(header)) {
                j.setEllapsedTime(value);
                continue;
            }
            if ("job_state".equals(header)) {
                j.setStatus(value);
                continue;
            }
            if ("queue".equals(header)) {
                j.setQueue(value);
                continue;
            }
            if ("ctime".equals(header)) {
                j.setCtime(value);
                continue;
            }
            if ("qtime".equals(header)) {
                j.setQtime(value);
                continue;
            }
            if ("mtime".equals(header)) {
                j.setMtime(value);
                continue;
            }
            if ("start_time".equals(header)) {
                j.setStime(value);
                continue;
            }
            if ("comp_time".equals(header)) {
                j.setComp_time(value);
                continue;
            }
            if ("exec_host".equals(header)) {
                j.setExecuteNode(value);
                continue;
            }
            if ("Output_Path".equals(header)) {
                if (Info2[i + 1].contains("=") || Info2[i + 1].contains(":")) {
                    j.setOutputPath(value);
                    continue;
                }
                j.setOutputPath(value + Info2[i + 1].trim());
                ++i;
                continue;
            }
            if ("Error_Path".equals(header)) {
                if (Info2[i + 1].contains("=") || Info2[i + 1].contains(":")) {
                    j.setErrrorPath(value);
                    continue;
                }
                String st = Info2[i + 1].trim();
                j.setErrrorPath(value + st);
                ++i;
                continue;
            }
            if (!"submit_args".equals(header)) continue;
            while (i + 1 < Info2.length && Info2[i + 1].startsWith("\t")) {
                value = value + Info2[i + 1];
                ++i;
            }
            value = value.replaceAll("\t", "");
            j.setSubmitArgs(value);
        }
        return j;
    }

    private static String[] getJobInfo(String JobID) throws Exception {
        Process p = Runtime.getRuntime().exec("qstat -f " + JobID);
        p.waitFor();
        BufferedInputStream errStream = new BufferedInputStream(p.getErrorStream());
        if (errStream.available() > 0) {
            byte[] errdata = new byte[errStream.available()];
            errStream.read(errdata, 0, errStream.available());
            p.getOutputStream().close();
            p.getErrorStream().close();
            errStream.close();
            throw new Exception(new String(errdata));
        }
        BufferedInputStream ef = new BufferedInputStream(p.getInputStream());
        byte[] data = new byte[ef.available()];
        ef.read(data, 0, ef.available());
        ef.close();
        p.getOutputStream().close();
        p.getErrorStream().close();
        String Result = new String(data);
        return Result.split("\n");
    }

    public static String getJobStatus(String JobID) throws Exception {
        String[] Info2 = Job.getJobInfo(JobID);
        String header = "";
        String value = "";
        for (int i = 0; i < Info2.length; ++i) {
            String[] line = Info2[i].contains("=") ? Info2[i].split("=", 2) : Info2[i].split(":", 2);
            header = line[0].trim();
            value = line[1].trim();
            if (!"job_state".equals(header)) continue;
            return value;
        }
        return null;
    }

    public static void destroy(String JobID) throws Exception {
        Process p = Runtime.getRuntime().exec("qdel " + JobID);
        p.waitFor();
        BufferedInputStream errStream = new BufferedInputStream(p.getErrorStream());
        if (errStream.available() > 0) {
            byte[] errdata = new byte[errStream.available()];
            errStream.read(errdata, 0, errStream.available());
            p.getOutputStream().close();
            p.getErrorStream().close();
            errStream.close();
            throw new Exception(new String(errdata));
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Job ID: " + this.id + "\n");
        sb.append("Job Name: " + this.Name + "\n");
        sb.append("Job Owner: " + this.owner + "\n");
        sb.append("Job Status: " + this.status + "\n");
        sb.append("Job Queue: " + this.queue + "\n");
        sb.append("\n");
        sb.append("Resources\n");
        sb.append("CPU Time: " + this.usedcput + "\n");
        sb.append("Mem Used: " + this.usedMem + "\n");
        sb.append("Used WallTime: " + this.ellapsedTime + "\n");
        sb.append("execute Node : " + this.executeNode + "\n");
        sb.append("\nTimes:\n");
        sb.append("ctime: " + this.ctime + "\n");
        sb.append("qtime:" + this.qtime + "\n");
        sb.append("mtime: " + this.mtime + "\n");
        sb.append("\n");
        sb.append("Files\n");
        sb.append("Output File: " + this.outputPath + "\n");
        sb.append("Error File: " + this.errrorPath + "\n");
        return sb.toString();
    }

    public String toHTMLString() {
        StringBuffer sb = new StringBuffer("<html>");
        sb.append("Job ID: " + this.id + "<br/>");
        sb.append("Job Name: " + this.Name + "<br/>");
        sb.append("Job Owner: " + this.owner + "<br/>");
        sb.append("Job Status: " + this.status + "<br/>");
        sb.append("Job Queue: " + this.queue + "<br/>");
        sb.append("<br/>");
        sb.append("<b>Resources:</b><br/>");
        sb.append("CPU Time: " + this.usedcput + "<br/>");
        sb.append("Mem Used: " + this.usedMem + "<br/>");
        sb.append("Used WallTime: " + this.ellapsedTime + "<br/>");
        sb.append("execute Node : " + this.executeNode + "<br/>");
        sb.append("<br/>");
        sb.append("<b>Times:</b><br/>");
        sb.append("ctime: " + this.ctime + "<br/>");
        sb.append("qtime:" + this.qtime + "<br/>");
        sb.append("mtime: " + this.mtime + "<br/>");
        sb.append("<b>Files</b><br/>");
        sb.append("Output File: " + this.outputPath + "<br/>");
        sb.append("Error File: " + this.errrorPath + "<br/>");
        sb.append("<b>Submit args:</b>" + this.SubmitArgs + "<br/>");
        String st = "";
        String[] keys = this.variables.keySet().toArray(new String[this.variables.keySet().size()]);
        for (int i = 0; i < keys.length; ++i) {
            st = st + "    " + keys[i] + " : " + this.variables.get(keys[i]) + "<br/>";
        }
        sb.append("<b>VariableList: </b>" + st + "<br/>");
        sb.append("</html>");
        return sb.toString();
    }

    public String getNodes() {
        return this.nodes;
    }

    public void setNodes(String nodes) {
        this.nodes = nodes;
    }

    public String getPpn() {
        return this.ppn;
    }

    public void setPpn(String ppn) {
        this.ppn = ppn;
    }

    public String getExecutableFile() {
        return this.executableFile;
    }

    public void setExecutableFile(String executableFile) {
        this.executableFile = executableFile;
    }

    public String getWallTime() {
        return this.wallTime;
    }

    public void setWallTime(String wallTime) {
        this.wallTime = wallTime;
    }

    public String getQueue() {
        return this.queue;
    }

    public void setQueue(String queue) {
        this.queue = queue;
    }

    public String getExecuteNode() {
        return this.executeNode;
    }

    public void setExecuteNode(String executeNode) {
        this.executeNode = executeNode;
    }

    public String getEllapsedTime() {
        return this.ellapsedTime;
    }

    public void setEllapsedTime(String ellapsedTime) {
        this.ellapsedTime = ellapsedTime;
    }

    public String getUsedMem() {
        return this.usedMem;
    }

    public void setUsedMem(String usedMem) {
        this.usedMem = usedMem;
    }

    public String getUsedcput() {
        return this.usedcput;
    }

    public void setUsedcput(String usedcput) {
        this.usedcput = usedcput;
    }

    public String getErrrorPath() {
        return this.errrorPath;
    }

    public void setErrrorPath(String errrorPath) {
        this.errrorPath = errrorPath;
    }

    public String getOutputPath() {
        return this.outputPath;
    }

    public void setOutputPath(String outputPath) {
        this.outputPath = outputPath;
    }

    public ArrayList<String> getAfterany() {
        return this.afterany;
    }

    public void setAfterany(ArrayList<String> afterany) {
        this.setAfterany(afterany);
    }

    public ArrayList<String> getAfterOK() {
        return this.afterOK;
    }

    public void setAfterOK(ArrayList<String> afterok) {
        this.afterOK = afterok;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.Name;
    }

    public void setName(String Name) {
        this.Name = Name;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getCtime() {
        return this.ctime;
    }

    public String getQtime() {
        return this.qtime;
    }

    public String getMtime() {
        return this.mtime;
    }

    public void setCtime(String ctime) {
        this.ctime = ctime;
    }

    public void setQtime(String qtime) {
        this.qtime = qtime;
    }

    public void setMtime(String mtime) {
        this.mtime = mtime;
    }

    public void setVariables(HashMap<String, String> variables) {
        this.variables = variables;
    }

    public HashMap<String, String> getVariables() {
        return this.variables;
    }

    public Boolean isComplete() {
        if ("C".equals(this.status)) {
            return true;
        }
        return false;
    }

    public String Duration() {
        DateFormat df = DateFormat.getTimeInstance(0);
        df.setTimeZone(TimeZone.getTimeZone("GMT"));
        try {
            Date date1 = df.parse(this.ctime);
            Date date2 = df.parse(this.mtime);
            long remainder = date2.getTime() - date1.getTime();
            return df.format(remainder);
        }
        catch (Exception exp) {
            return null;
        }
    }

    public String getSubmitArgs() {
        return this.SubmitArgs;
    }

    public void setSubmitArgs(String SubmitArgs) {
        this.SubmitArgs = SubmitArgs;
    }

    public String getStime() {
        return this.stime;
    }

    public void setStime(String stime) {
        this.stime = stime;
    }

    public String getComp_time() {
        return this.comp_time;
    }

    public void setComp_time(String comp_time) {
        this.comp_time = comp_time;
    }
}

