/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.nbcr.opal.manager;

import edu.sdsc.nbcr.opal.AppConfigType;
import edu.sdsc.nbcr.opal.AppMetadataInputType;
import edu.sdsc.nbcr.opal.AppMetadataType;
import edu.sdsc.nbcr.opal.AppServiceLocator;
import edu.sdsc.nbcr.opal.AppServicePortType;
import edu.sdsc.nbcr.opal.FaultType;
import edu.sdsc.nbcr.opal.InputFileType;
import edu.sdsc.nbcr.opal.JobInputType;
import edu.sdsc.nbcr.opal.JobOutputType;
import edu.sdsc.nbcr.opal.JobSubOutputType;
import edu.sdsc.nbcr.opal.OutputFileType;
import edu.sdsc.nbcr.opal.StatusOutputType;
import edu.sdsc.nbcr.opal.manager.DRMAAJobManager;
import edu.sdsc.nbcr.opal.manager.JobManagerException;
import edu.sdsc.nbcr.opal.manager.OpalJobManager;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.Vector;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.xml.rpc.ServiceException;
import org.apache.log4j.Logger;

public class MetaServiceJobManager
implements OpalJobManager {
    private static Logger logger = Logger.getLogger((String)DRMAAJobManager.class.getName());
    private Properties props;
    private Properties props_meta;
    private AppConfigType config;
    private StatusOutputType status;
    private String handle;
    private String remoteJobID;
    private String remote_url = null;
    private String remoteBaseURL = null;
    private String workdir = null;
    private AppServicePortType appServicePort;
    private boolean started = false;
    private volatile boolean done = false;

    @Override
    public void initialize(Properties props, AppConfigType config, String handle) throws JobManagerException {
        logger.info((Object)"called");
        this.props = props;
        this.config = config;
        this.handle = handle;
        this.status = new StatusOutputType();
    }

    @Override
    public void destroyJobManager() throws JobManagerException {
    }

    @Override
    public String launchJob(String argList, Integer numproc, String workingDir) throws JobManagerException {
        int arraySize;
        logger.info((Object)"called");
        this.workdir = workingDir;
        if (this.config == null) {
            String msg = "Can't find application configuration - Plugin not initialized correctly";
            logger.error((Object)msg);
            throw new JobManagerException(msg);
        }
        String mscFilePath = this.config.getMetaServiceConfig();
        if (mscFilePath == null) {
            String msg = "metaServiceConfig tag not defined in app config";
            logger.error((Object)msg);
            throw new JobManagerException(msg);
        }
        File file = new File(mscFilePath);
        FileInputStream fis = null;
        BufferedInputStream bis = null;
        DataInputStream dis = null;
        HashMap<String, Integer> url_proc_map = new HashMap<String, Integer>();
        try {
            fis = new FileInputStream(file);
            bis = new BufferedInputStream(fis);
            dis = new DataInputStream(bis);
            while (dis.available() != 0) {
                String line = dis.readLine();
                int pos = line.indexOf(" ");
                if (pos <= 0) continue;
                String url = line.substring(0, pos);
                Integer procs = new Integer(line.substring(pos + 1));
                AppServiceLocator asl = new AppServiceLocator();
                try {
                    this.appServicePort = asl.getAppServicePort(new URL(url));
                    AppMetadataType amt = this.appServicePort.getAppMetadata(new AppMetadataInputType());
                    if (this.config.isParallel()) {
                        if (procs < numproc) continue;
                        url_proc_map.put(url, procs);
                        continue;
                    }
                    url_proc_map.put(url, procs);
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage());
                }
            }
            fis.close();
            bis.close();
            dis.close();
        }
        catch (FileNotFoundException e) {
            logger.error((Object)e.getMessage());
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage());
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
        if (url_proc_map.size() == 0) {
            String msg = "No suitable remote hosts found for the application: ";
            msg = msg + "num procs requested larger than available OR ";
            msg = msg + "num procs unspecified for host in meta service config OR ";
            msg = msg + "no remote hosts defined in meta service config";
            logger.error((Object)msg);
            throw new JobManagerException(msg);
        }
        Set urlset = url_proc_map.entrySet();
        Iterator it = urlset.iterator();
        Random r = new Random();
        Integer rint = Math.abs(r.nextInt() % url_proc_map.size());
        Integer counter = 0;
        while (it.hasNext()) {
            Map.Entry kv = it.next();
            if (counter == rint) {
                this.remote_url = kv.getKey().toString();
                break;
            }
            Integer n = counter;
            Integer n2 = counter = Integer.valueOf(counter + 1);
        }
        logger.info((Object)("Using remote URL: " + this.remote_url));
        String args = this.config.getDefaultArgs();
        if (args == null) {
            args = argList;
        } else {
            String userArgs = argList;
            if (userArgs != null) {
                args = args + " " + userArgs;
            }
        }
        if (args != null) {
            args = args.trim();
        }
        AppServiceLocator asl = new AppServiceLocator();
        JobInputType in = new JobInputType();
        if (args != null) {
            in.setArgList(args);
        }
        if (numproc != null) {
            in.setNumProcs(numproc);
        }
        File dir = new File(workingDir);
        String[] infiles = dir.list();
        Vector<InputFileType> inputFileVector = new Vector<InputFileType>();
        if (dir != null) {
            for (int j = 0; j < infiles.length; ++j) {
                DataHandler dh = new DataHandler((DataSource)new FileDataSource(workingDir + File.separator + infiles[j]));
                InputFileType infile = new InputFileType();
                infile.setName(infiles[j]);
                infile.setAttachment(dh);
                inputFileVector.add(infile);
            }
        }
        if ((arraySize = inputFileVector.size()) > 0) {
            InputFileType[] infileArray = new InputFileType[arraySize];
            for (int k = 0; k < arraySize; ++k) {
                infileArray[k] = (InputFileType)inputFileVector.get(k);
            }
            in.setInputFile(infileArray);
        }
        asl = new AppServiceLocator();
        try {
            this.appServicePort = asl.getAppServicePort(new URL(this.remote_url));
            JobSubOutputType subOut = this.appServicePort.launchJob(in);
            this.remoteJobID = subOut.getJobID();
            StatusOutputType remoteStatus = this.appServicePort.queryStatus(this.remoteJobID);
            this.remoteBaseURL = remoteStatus.getBaseURL().toString();
            logger.info((Object)("LaunchJob Remote Job URL: " + this.remoteBaseURL));
        }
        catch (MalformedURLException e) {
            logger.error((Object)e.getMessage());
        }
        catch (ServiceException e) {
            logger.error((Object)e.getMessage());
        }
        catch (FaultType e) {
            logger.error((Object)e.getMessage());
        }
        catch (RemoteException e) {
            logger.error((Object)e.getMessage());
        }
        this.started = true;
        this.handle = this.remoteBaseURL;
        this.handle = this.remoteJobID;
        return this.handle;
    }

    @Override
    public StatusOutputType waitForActivation() throws JobManagerException {
        logger.info((Object)"called");
        if (!this.started) {
            String msg = "Can't wait for a remote job that hasn't be started";
            logger.error((Object)msg);
            throw new JobManagerException(msg);
        }
        try {
            StatusOutputType status = this.appServicePort.queryStatus(this.remoteJobID);
            int code = this.appServicePort.queryStatus(this.remoteJobID).getCode();
            while (code == 1) {
                status = this.appServicePort.queryStatus(this.remoteJobID);
                code = status.getCode();
                Thread.sleep(3000L);
            }
        }
        catch (RemoteException e) {
            logger.error((Object)("RemoteException in WaitForActivation - " + e.getMessage()));
        }
        catch (Exception e) {
            logger.error((Object)("Exception in WaitForActivation - " + e.getMessage()));
        }
        this.status.setCode(2);
        this.status.setMessage("Job active on remote: <A HREF=" + this.remoteBaseURL + ">" + this.remoteBaseURL + "</A>");
        return this.status;
    }

    @Override
    public StatusOutputType waitForCompletion() throws JobManagerException {
        String smsg;
        logger.info((Object)"called");
        if (!this.started) {
            String msg = "Can't wait for a remote job that hasn't be started";
            logger.error((Object)msg);
            throw new JobManagerException(msg);
        }
        int code = -1;
        try {
            StatusOutputType status = this.appServicePort.queryStatus(this.remoteJobID);
            code = this.appServicePort.queryStatus(this.remoteJobID).getCode();
            while (code != 8 && code != 4) {
                status = this.appServicePort.queryStatus(this.remoteJobID);
                code = status.getCode();
                status.setCode(code);
                Thread.sleep(3000L);
            }
        }
        catch (RemoteException e) {
            logger.error((Object)("RemoteException in WaitForActivation - " + e.getMessage()));
        }
        catch (Exception e) {
            logger.error((Object)("Exception in WaitForActivation - " + e.getMessage()));
        }
        try {
            JobOutputType out = this.appServicePort.getOutputs(this.remoteJobID);
            OutputFileType[] outfile = out.getOutputFile();
            if (outfile != null) {
                String[] relPath = new String[outfile.length];
                for (int j = 0; j < outfile.length; ++j) {
                    String outPath;
                    String u = outfile[j].getUrl().toString();
                    int index = u.indexOf('/' + this.remoteJobID + '/');
                    relPath[j] = u.substring(index + this.remoteJobID.length() + 2);
                    BufferedInputStream in = new BufferedInputStream(new URL(outfile[j].getUrl().toString()).openStream());
                    if (relPath[j].indexOf("/") != -1) {
                        index = relPath[j].lastIndexOf("/");
                        String d = this.workdir + File.separator + relPath[j].substring(0, index);
                        boolean b = new File(d).mkdirs();
                        outPath = this.workdir + File.separator + relPath[j];
                    } else {
                        outPath = this.workdir + File.separator + outfile[j].getName();
                    }
                    FileOutputStream fos = new FileOutputStream(outPath);
                    BufferedOutputStream bout = new BufferedOutputStream(fos, 1024);
                    byte[] data = new byte[1024];
                    int x = 0;
                    while ((x = in.read(data, 0, 1024)) >= 0) {
                        bout.write(data, 0, x);
                    }
                    bout.close();
                    in.close();
                }
            }
            String[] stdfiles = new String[]{"stdout.txt", "stderr.txt"};
            try {
                for (int i = 0; i < stdfiles.length; ++i) {
                    BufferedInputStream in = new BufferedInputStream(new URL(this.remoteBaseURL + "/" + stdfiles[i]).openStream());
                    FileOutputStream fos = new FileOutputStream(this.workdir + File.separator + stdfiles[i]);
                    BufferedOutputStream bout = new BufferedOutputStream(fos, 1024);
                    byte[] data = new byte[1024];
                    int x = 0;
                    while ((x = in.read(data, 0, 1024)) >= 0) {
                        bout.write(data, 0, x);
                    }
                    bout.close();
                    in.close();
                }
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage());
            }
        }
        catch (RemoteException e) {
            logger.error((Object)("RemoteException in WaitForCompletion - " + e.getMessage()));
        }
        catch (Exception e) {
            logger.error((Object)("Exception in WaitForCompletion - " + e.getMessage()));
        }
        if (code == 8) {
            smsg = "Successfully completed on remote: <A HREF=" + this.remoteBaseURL + ">" + this.remoteBaseURL + "</A>";
            logger.info((Object)smsg);
            this.status.setCode(8);
            this.status.setMessage(smsg);
        } else {
            smsg = "Failed on remote: <A HREF=" + this.remoteBaseURL + ">" + this.remoteBaseURL + "</A>";
            logger.info((Object)smsg);
            this.status.setCode(4);
            this.status.setMessage(smsg);
        }
        return this.status;
    }

    @Override
    public StatusOutputType destroyJob() throws JobManagerException {
        try {
            this.appServicePort.destroy(this.remoteJobID);
            logger.info((Object)("Remote job killed on user request: " + this.remoteBaseURL));
            this.status.setCode(4);
            this.status.setMessage("Remote destroyed on user request");
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
        return this.status;
    }
}

