#include <string.h>
#include <stdio.h>
#include "numchk.h"
#include "nifty.h"

#define NNMCK	(64U)

#define maybe(x, y)	\
	candpr[ncand] = nmpr_##x; \
	candck[ncand] = y; \
	ncand++
#define defo(x, y)	\
	surepr[nsure] = nmpr_##x; \
	sureck[nsure] = y; \
	nsure++

#define c(x)	\
	with (nmck_t y = nmck_##x(str, len)) { \
		if (y < 0) { \
			break; \
		} else if (y & 0b1U) { \
			maybe(x, y); \
		} else { \
			defo(x, y); \
		} \
	}
#define g(x)	\
	with (nmck_t y = nmck_##x(str, len)) { \
		if (y < 0) { \
			break; \
		} else { \
			maybe(x, y); \
		} \
	}

#ifdef __INTEL_COMPILER
# pragma warning (disable:2415)
#endif  /* __INTEL_COMPILER */

static size_t ncand;
static void(*candpr[NNMCK])(nmck_t, const char*, size_t);
static nmck_t candck[NNMCK];
static size_t nsure;
static void(*surepr[NNMCK])(nmck_t, const char*, size_t);
static nmck_t sureck[NNMCK];

%%{
	machine numchk;

	upnum = digit | upper;
	lonum = digit | lower;
	check = "_" | "?";
	vowel = "A" | "E" | "I" | "O" | "U";
	consonant = upper - vowel;

	action isin {c(isin)}
	action figi {c(figi)}
	action iban {c(iban)}
	action cusip {c(cusip)}
	action sedol {c(sedol)}
	action lei {c(lei)}
	action gtin {c(gtin)}
	action isbn10 {c(isbn10)}
	action isbn13 {c(isbn13)}
	action credcard {c(credcard)}
	action tfn {c(tfn)}
	action cas {c(cas)}
	action istc {c(istc)}
	action issn8 {c(issn8)}
	action issn13 {c(issn13)}
	action ismn10 {c(ismn10)}
	action ismn13 {c(ismn13)}
	action isni {c(isni)}
	action isan {c(isan)}
	action imo {c(imo)}
	action vin {c(vin)}
	action grid {c(grid)}
	action devatid {c(devatid)}
	action bevatid {c(bevatid)}
	action dkvatid {c(dkvatid)}
	action fivatid {c(fivatid)}
	action frvatid {c(frvatid)}
	action grvatid {c(grvatid)}
	action ievatid {c(ievatid)}
	action itvatid {c(itvatid)}
	action luvatid {c(luvatid)}
	action nlvatid {c(nlvatid)}
	action atvatid {c(atvatid)}
	action plvatid {c(plvatid)}
	action ptvatid {c(ptvatid)}
	action sevatid {c(sevatid)}
	action sivatid {c(sivatid)}
	action esvatid {c(esvatid)}
	action bicc {c(bicc)}
	action bic {c(bic)}
	action wkn {c(wkn)}
	action imei {c(imei)}
	action kennitala {c(kennitala)}
	action tckimlik {c(tckimlik)}
	action aadhaar {c(aadhaar)}
	action titulo_eleitoral {c(titulo_eleitoral)}
	action cpf {c(cpf)}
	action iposan {c(iposan)}
	action npi {c(npi)}
	action abartn {c(abartn)}
	action nhi {c(nhi)}
	action ppsn {c(ppsn)}
	action idnr {c(idnr)}
	action oib {c(oib)}
	action nhs {c(nhs)}

	## generic checks, these will always be candidates
	action luhn {g(luhn)}
	action verhoeff {g(verhoeff)}
	action damm10 {g(damm10)}
	action damm16 {g(damm16)}

	main :=
		upper{2} digit{2} (upnum | ' '){11,42} %iban |
		upper{2} check{2} (upnum | ' '){11,42} %iban |
		upper{2} upnum{9} (digit | check) %isin |
		"BBG" (consonant | digit){8} (digit | check) %figi |
		xdigit{3,}'-'digit{4}'-'xdigit{8}'-'(xdigit | check) %istc |
		xdigit{3,} digit{4} xdigit{8} (xdigit | check) %istc |
		(alnum | "*" | "@" | "#"){8} (digit | check) %cusip |
		(consonant | digit){6} (digit | check) %sedol |
		upnum{18} (digit{2} | check{2}) %lei |
		digit{7,17} (digit | check) %gtin |
		/97[89]/ "-"? digit "-"? digit{4} "-"? digit{4} "-"? (digit | check) %isbn13 |
		digit "-"? digit{4} "-"? digit{4} "-"? (digit | "X" | check) %isbn10 |
		digit{4} "-"? digit{3} (digit | "X" | check) %issn8 |
		"977" digit{4} digit{3} "00" (digit | check) %issn13 |
		"9790" digit{8} (digit | check) %ismn13 |
		"M" "-"? digit{4} "-"? digit{4} "-"? (digit | "X" | check) %ismn10 |
		(digit | " "){12,22} %credcard |
		digit{2,3} " "? digit{3} " "? digit{3} %tfn |
		digit+ "-" digit{2} "-" (digit | check) %cas |
		digit{4} " "? digit{4} " "? digit{4} " "? digit{3} (digit | "X" | check) %isni |
		("ISAN" (" " | "-" | ":")?)? xdigit{4} "-"? xdigit{4} "-"? xdigit{4} "-"? xdigit{4} "-"? (alnum | check) %isan |
		("ISAN" (" " | "-" | ":")?)? xdigit{4} "-"? xdigit{4} "-"? xdigit{4} "-"? xdigit{4} "-"? (alnum | check) "-"? xdigit{4} "-"? xdigit{4} "-"? (alnum | check) %isan |
		("IMO" " "?)? digit{6} (digit | check) %imo |
		upnum{8} (digit | "X" | check) upnum{8} %vin |
		upnum{2} "-"? upnum{5} "-"? upnum{10} "-"? (upnum | check) %grid |
		("DE" " "?)? digit{3} " "? digit{3} " "? digit{2} (digit | check) %devatid |
		("BE" "."?)? digit{3,4} "."? digit{3} "."? digit{1} (digit{2} | check{2}) %bevatid |
		"DK"? digit{7} (digit | check) %dkvatid |
		"FI"? digit{7} (digit | check) %fivatid |
		("FR" " "?)? (digit{2} | check{2}) /[ ,]/? digit{3} /[ ,]/? digit{3} /[ ,]/? digit{3} %frvatid |
		(("GR" | "EL") " "?)? digit{8} (digit | check) %grvatid |
		("IE" " "?)? digit{7} upper? (upper | check) "W"? %ievatid |
		("IE" " "?)? digit (upper | "*" | "+") digit{5} (upper | check) "W"? %ievatid |
		("IT" " "?)? digit{10} (digit | check) %itvatid |
		("LU" " "?)? digit{3} " "? digit{3} " "? (digit{2} | check{2}) %luvatid |
		"NL"? digit{8} (digit | check) "B" digit{2} %nlvatid |
		("AT" " "?)? "U" digit{7} (digit | check) %atvatid |
		("PL" " "?)? digit{3} "-"? digit{3} "-"? digit{2} "-"? digit (digit | check) %plvatid |
		("PL" " "?)? digit{3} "-"? digit{2} "-"? digit{2} "-"? digit{2} (digit | check) %plvatid |
		("PT" " "?)? digit{3} " "? digit{3} " "? digit{2} (digit | check) %ptvatid |
		("SE" " "?)? digit{9} (digit | check) digit{2} %sevatid |
		("SI" " "?)? digit{4} " "? digit{3} (digit | check) %sivatid |
		("ES" " "?)? "A" digit{2} " "? digit{3} " "? digit{2} (digit | check) %esvatid |
		upper{3} ("U" | "J" | "Z") digit{6} (digit | check) %bicc |
		upper{6} upnum{2} upnum? (upnum{3})? %bic |
		upnum{6} %wkn |
		digit{2} "-"? digit{6} "-"? digit{6} "-"? ((digit | check) | digit{2}) %imei |
		digit{6} "-"? digit{2} (digit | check) digit %kennitala |
		digit{9} (digit{2} | check{2}) %tckimlik |
		digit{4} " "? digit{4} " "? digit{3} (digit | check) %aadhaar |
		digit{4} " "? digit{4} " "? digit{2} " "? (digit{2} | check{2}) %titulo_eleitoral |
		digit{3} "."? digit{3} "."? digit{3} "-"? (digit{2} | check{2}) %cpf |
		("10" | "11" | "20" | "30" | "40") digit{4} digit{5} (/[P-Y]/ | check) ("-" digit{2})? %iposan |
		digit{9} (digit | check) %npi |
		digit{8} (digit | check) %abartn |
		upper{3} digit{3} (digit | check) %nhi |
		digit{7} (upper | check) ("/"? /[A-Z ]/)? %ppsn |
		digit{2} " "? digit{3} " "? digit{3} " "? digit{2} (digit | check) %idnr |
		"HR"? digit{10} (digit | check) %oib |
		digit{9} (digit | check) %nhs |

		## generic checks
		digit{2,} %luhn %verhoeff %damm10 |
		xdigit{2,} %damm16 |

		any*;

	write data;
}%%

static int
chck1(const char *str, size_t len)
{
	const char *p = str;
	const char *const pe = str + len;
	const char *const eof = pe;
	int cs;

	%% write init;
	ncand = nsure = 0U;

	%% write exec;
	return 0;
}
