#include <stdbool.h>
#include <stdint.h>

static bool
valid_cc_p(const char cc[static 2U])
{
#define C2I(x)			((x) - 'A')
#define BEGINNING_WITH(x)	[C2I(x)] =
#define ALLOW(x)		(1U << C2I(x))
#define AND			|
	static const uint_fast32_t _cc[] = {
		BEGINNING_WITH('A')	ALLOW('D') AND ALLOW('E') AND ALLOW('G') AND ALLOW('I') AND ALLOW('L') AND ALLOW('M') AND ALLOW('N') AND ALLOW('O') AND ALLOW('Q') AND ALLOW('R') AND ALLOW('S') AND ALLOW('T') AND ALLOW('U') AND ALLOW('W') AND ALLOW('X') AND ALLOW('Z') AND 0U,
		BEGINNING_WITH('B')	ALLOW('A') AND ALLOW('B') AND ALLOW('D') AND ALLOW('E') AND ALLOW('F') AND ALLOW('G') AND ALLOW('H') AND ALLOW('I') AND ALLOW('J') AND ALLOW('L') AND ALLOW('M') AND ALLOW('N') AND ALLOW('O') AND ALLOW('Q') AND ALLOW('R') AND ALLOW('S') AND ALLOW('T') AND ALLOW('V') AND ALLOW('W') AND ALLOW('Y') AND ALLOW('Z') AND 0U,
		BEGINNING_WITH('C')	ALLOW('A') AND ALLOW('C') AND ALLOW('D') AND ALLOW('F') AND ALLOW('G') AND ALLOW('H') AND ALLOW('I') AND ALLOW('K') AND ALLOW('L') AND ALLOW('M') AND ALLOW('N') AND ALLOW('O') AND ALLOW('R') AND ALLOW('S') AND ALLOW('U') AND ALLOW('V') AND ALLOW('W') AND ALLOW('X') AND ALLOW('Y') AND ALLOW('Z') AND 0U,
		BEGINNING_WITH('D')	ALLOW('E') AND ALLOW('J') AND ALLOW('K') AND ALLOW('M') AND ALLOW('O') AND ALLOW('Z') AND 0U,
		BEGINNING_WITH('E')	ALLOW('C') AND ALLOW('E') AND ALLOW('G') AND ALLOW('H') AND ALLOW('R') AND ALLOW('S') AND ALLOW('T') AND 0U,
		BEGINNING_WITH('F')	ALLOW('I') AND ALLOW('J') AND ALLOW('K') AND ALLOW('M') AND ALLOW('O') AND ALLOW('R') AND 0U,
		BEGINNING_WITH('G')	ALLOW('A') AND ALLOW('B') AND ALLOW('D') AND ALLOW('E') AND ALLOW('F') AND ALLOW('G') AND ALLOW('H') AND ALLOW('I') AND ALLOW('L') AND ALLOW('M') AND ALLOW('N') AND ALLOW('P') AND ALLOW('Q') AND ALLOW('R') AND ALLOW('S') AND ALLOW('T') AND ALLOW('U') AND ALLOW('W') AND ALLOW('Y') AND 0U,
		BEGINNING_WITH('H')	ALLOW('K') AND ALLOW('M') AND ALLOW('N') AND ALLOW('R') AND ALLOW('T') AND ALLOW('U') AND 0U,
		BEGINNING_WITH('I')	ALLOW('D') AND ALLOW('E') AND ALLOW('L') AND ALLOW('M') AND ALLOW('N') AND ALLOW('O') AND ALLOW('Q') AND ALLOW('R') AND ALLOW('S') AND ALLOW('T') AND 0U,
		BEGINNING_WITH('J')	ALLOW('E') AND ALLOW('M') AND ALLOW('O') AND ALLOW('P') AND 0U,
		BEGINNING_WITH('K')	ALLOW('E') AND ALLOW('G') AND ALLOW('H') AND ALLOW('I') AND ALLOW('M') AND ALLOW('N') AND ALLOW('P') AND ALLOW('R') AND ALLOW('W') AND ALLOW('Y') AND ALLOW('Z') AND 0U,
		BEGINNING_WITH('L')	ALLOW('A') AND ALLOW('B') AND ALLOW('C') AND ALLOW('I') AND ALLOW('K') AND ALLOW('R') AND ALLOW('S') AND ALLOW('T') AND ALLOW('U') AND ALLOW('V') AND ALLOW('Y') AND 0U,
		BEGINNING_WITH('M')	ALLOW('A') AND ALLOW('C') AND ALLOW('D') AND ALLOW('E') AND ALLOW('F') AND ALLOW('G') AND ALLOW('H') AND ALLOW('K') AND ALLOW('L') AND ALLOW('M') AND ALLOW('N') AND ALLOW('O') AND ALLOW('P') AND ALLOW('Q') AND ALLOW('R') AND ALLOW('S') AND ALLOW('T') AND ALLOW('U') AND ALLOW('V') AND ALLOW('W') AND ALLOW('X') AND ALLOW('Y') AND ALLOW('Z') AND 0U,
		BEGINNING_WITH('N')	ALLOW('A') AND ALLOW('C') AND ALLOW('E') AND ALLOW('F') AND ALLOW('G') AND ALLOW('I') AND ALLOW('L') AND ALLOW('O') AND ALLOW('P') AND ALLOW('R') AND ALLOW('U') AND ALLOW('Z') AND 0U,
		BEGINNING_WITH('O')	ALLOW('M') AND 0U,
		BEGINNING_WITH('P')	ALLOW('A') AND ALLOW('E') AND ALLOW('F') AND ALLOW('G') AND ALLOW('H') AND ALLOW('K') AND ALLOW('L') AND ALLOW('M') AND ALLOW('N') AND ALLOW('R') AND ALLOW('S') AND ALLOW('T') AND ALLOW('W') AND ALLOW('Y') AND 0U,
		BEGINNING_WITH('Q')	ALLOW('A') AND 0U,
		BEGINNING_WITH('R')	ALLOW('E') AND ALLOW('O') AND ALLOW('S') AND ALLOW('U') AND ALLOW('W') AND 0U,
		BEGINNING_WITH('S')	ALLOW('A') AND ALLOW('B') AND ALLOW('C') AND ALLOW('D') AND ALLOW('E') AND ALLOW('G') AND ALLOW('H') AND ALLOW('I') AND ALLOW('J') AND ALLOW('K') AND ALLOW('L') AND ALLOW('M') AND ALLOW('N') AND ALLOW('O') AND ALLOW('R') AND ALLOW('S') AND ALLOW('V') AND ALLOW('X') AND ALLOW('Y') AND ALLOW('Z') AND 0U,
		BEGINNING_WITH('T')	ALLOW('C') AND ALLOW('D') AND ALLOW('F') AND ALLOW('G') AND ALLOW('H') AND ALLOW('J') AND ALLOW('K') AND ALLOW('L') AND ALLOW('M') AND ALLOW('N') AND ALLOW('O') AND ALLOW('R') AND ALLOW('T') AND ALLOW('V') AND ALLOW('W') AND ALLOW('Z') AND 0U,
		BEGINNING_WITH('U')	ALLOW('A') AND ALLOW('G') AND ALLOW('M') AND ALLOW('S') AND ALLOW('Y') AND ALLOW('Z') AND 0U,
		BEGINNING_WITH('V')	ALLOW('A') AND ALLOW('C') AND ALLOW('E') AND ALLOW('G') AND ALLOW('I') AND ALLOW('N') AND ALLOW('U') AND 0U,
		BEGINNING_WITH('W')	ALLOW('F') AND ALLOW('S') AND 0U,
		BEGINNING_WITH('X')	ALLOW('S') AND 0U,
		BEGINNING_WITH('Y')	ALLOW('E') AND ALLOW('T') AND 0U,
		BEGINNING_WITH('Z')	ALLOW('A') AND ALLOW('M') AND ALLOW('W') AND 0U,
	};

	if (cc[0U] >= 'A' && cc[0U] <= 'Z' &&
	    cc[1U] >= 'A' && cc[1U] <= 'Z') {
		return (_cc[C2I(cc[0U])] & ALLOW(cc[1U]));
	}
	return false;
#undef C2I
#undef BEGINNING_WITH
#undef ALLOW
#undef AND
}
