#include <stdbool.h>
#include <stdint.h>

static bool
valid_cc_p(const char cc[static 2U])
{
#define C2I(x)			((x) - 'A')
#define BEGINNING_WITH(x)	[C2I(x)] =
#define ALLOW(x)		(1U << C2I(x))
#define AND			|
	static const uint_fast32_t _cc[] = {
		BEGINNING_WITH('A')	ALLOW('D') AND ALLOW('E') AND ALLOW('L') AND ALLOW('O') AND ALLOW('T') AND ALLOW('Z') AND 0U,
		BEGINNING_WITH('B')	ALLOW('A') AND ALLOW('E') AND ALLOW('F') AND ALLOW('G') AND ALLOW('H') AND ALLOW('I') AND ALLOW('J') AND ALLOW('R') AND 0U,
		BEGINNING_WITH('C')	ALLOW('G') AND ALLOW('H') AND ALLOW('I') AND ALLOW('M') AND ALLOW('R') AND ALLOW('V') AND ALLOW('Y') AND ALLOW('Z') AND 0U,
		BEGINNING_WITH('D')	ALLOW('E') AND ALLOW('K') AND ALLOW('O') AND ALLOW('Z') AND 0U,
		BEGINNING_WITH('E')	ALLOW('E') AND ALLOW('G') AND ALLOW('S') AND 0U,
		BEGINNING_WITH('F')	ALLOW('I') AND ALLOW('O') AND ALLOW('R') AND 0U,
		BEGINNING_WITH('G')	ALLOW('A') AND ALLOW('B') AND ALLOW('E') AND ALLOW('I') AND ALLOW('L') AND ALLOW('R') AND ALLOW('T') AND 0U,
		BEGINNING_WITH('H')	ALLOW('R') AND ALLOW('U') AND 0U,
		BEGINNING_WITH('I')	ALLOW('E') AND ALLOW('L') AND ALLOW('R') AND ALLOW('S') AND ALLOW('T') AND 0U,
		BEGINNING_WITH('J')	ALLOW('O') AND 0U,
		BEGINNING_WITH('K')	ALLOW('W') AND ALLOW('Z') AND 0U,
		BEGINNING_WITH('L')	ALLOW('B') AND ALLOW('I') AND ALLOW('T') AND ALLOW('U') AND ALLOW('V') AND 0U,
		BEGINNING_WITH('M')	ALLOW('C') AND ALLOW('D') AND ALLOW('E') AND ALLOW('G') AND ALLOW('K') AND ALLOW('L') AND ALLOW('R') AND ALLOW('T') AND ALLOW('U') AND ALLOW('Z') AND 0U,
		BEGINNING_WITH('N')	ALLOW('L') AND ALLOW('O') AND 0U,
		BEGINNING_WITH('O')	0U,
		BEGINNING_WITH('P')	ALLOW('K') AND ALLOW('L') AND ALLOW('S') AND ALLOW('T') AND 0U,
		BEGINNING_WITH('Q')	ALLOW('A') AND 0U,
		BEGINNING_WITH('R')	ALLOW('O') AND ALLOW('S') AND 0U,
		BEGINNING_WITH('S')	ALLOW('A') AND ALLOW('E') AND ALLOW('I') AND ALLOW('K') AND ALLOW('M') AND ALLOW('N') AND 0U,
		BEGINNING_WITH('T')	ALLOW('L') AND ALLOW('N') AND ALLOW('R') AND 0U,
		BEGINNING_WITH('U')	ALLOW('A') AND 0U,
		BEGINNING_WITH('V')	ALLOW('G') AND 0U,
		BEGINNING_WITH('W')	0U,
		BEGINNING_WITH('X')	ALLOW('K') AND 0U,
		BEGINNING_WITH('Y')	0U,
		BEGINNING_WITH('Z')	0U,
	};

	if (cc[0U] >= 'A' && cc[0U] <= 'Z' &&
	    cc[1U] >= 'A' && cc[1U] <= 'Z') {
		return (_cc[C2I(cc[0U])] & ALLOW(cc[1U]));
	}
	return false;
#undef C2I
#undef BEGINNING_WITH
#undef ALLOW
#undef AND
}
static unsigned int
cc_len(const char cc[static 2U])
{
#define C2I(x)			((x) - 'A')
#define COUNTRIES_WITH(x)	[C2I(x) * 2U] =
#define THERE_ARE(x)		x
#define AT(x)			, 2U * x
	static uint_fast16_t _offs[] = {
		COUNTRIES_WITH('A') THERE_ARE(6) AT(0),
		COUNTRIES_WITH('B') THERE_ARE(8) AT(6),
		COUNTRIES_WITH('C') THERE_ARE(8) AT(14),
		COUNTRIES_WITH('D') THERE_ARE(4) AT(22),
		COUNTRIES_WITH('E') THERE_ARE(3) AT(26),
		COUNTRIES_WITH('F') THERE_ARE(3) AT(29),
		COUNTRIES_WITH('G') THERE_ARE(7) AT(32),
		COUNTRIES_WITH('H') THERE_ARE(2) AT(39),
		COUNTRIES_WITH('I') THERE_ARE(5) AT(41),
		COUNTRIES_WITH('J') THERE_ARE(1) AT(46),
		COUNTRIES_WITH('K') THERE_ARE(2) AT(47),
		COUNTRIES_WITH('L') THERE_ARE(5) AT(49),
		COUNTRIES_WITH('M') THERE_ARE(10) AT(54),
		COUNTRIES_WITH('N') THERE_ARE(2) AT(64),
		COUNTRIES_WITH('O') THERE_ARE(0) AT(66),
		COUNTRIES_WITH('P') THERE_ARE(4) AT(66),
		COUNTRIES_WITH('Q') THERE_ARE(1) AT(70),
		COUNTRIES_WITH('R') THERE_ARE(2) AT(71),
		COUNTRIES_WITH('S') THERE_ARE(6) AT(73),
		COUNTRIES_WITH('T') THERE_ARE(3) AT(79),
		COUNTRIES_WITH('U') THERE_ARE(1) AT(82),
		COUNTRIES_WITH('V') THERE_ARE(1) AT(83),
		COUNTRIES_WITH('W') THERE_ARE(0) AT(84),
		COUNTRIES_WITH('X') THERE_ARE(1) AT(84),
		COUNTRIES_WITH('Y') THERE_ARE(0) AT(85),
		COUNTRIES_WITH('Z') THERE_ARE(0) AT(85),
	};
	static uint_fast8_t _cc[] = {
		/* A */
		'D', 'E', 'L', 'O', 'T', 'Z', 24, 23, 28, 25, 20, 28, 
		/* B */
		'A', 'E', 'F', 'G', 'H', 'I', 'J', 'R', 20, 16, 27, 22, 22, 16, 28, 29, 
		/* C */
		'G', 'H', 'I', 'M', 'R', 'V', 'Y', 'Z', 27, 21, 28, 27, 21, 25, 28, 24, 
		/* D */
		'E', 'K', 'O', 'Z', 22, 18, 28, 24, 
		/* E */
		'E', 'G', 'S', 20, 27, 24, 
		/* F */
		'I', 'O', 'R', 18, 18, 27, 
		/* G */
		'A', 'B', 'E', 'I', 'L', 'R', 'T', 27, 22, 22, 23, 18, 27, 28, 
		/* H */
		'R', 'U', 21, 28, 
		/* I */
		'E', 'L', 'R', 'S', 'T', 22, 23, 26, 26, 27, 
		/* J */
		'O', 30, 
		/* K */
		'W', 'Z', 30, 20, 
		/* L */
		'B', 'I', 'T', 'U', 'V', 28, 21, 20, 20, 21, 
		/* M */
		'C', 'D', 'E', 'G', 'K', 'L', 'R', 'T', 'U', 'Z', 27, 24, 22, 27, 19, 28, 27, 31, 30, 25, 
		/* N */
		'L', 'O', 18, 15, 
		/* O */
		
		/* P */
		'K', 'L', 'S', 'T', 24, 28, 29, 25, 
		/* Q */
		'A', 29, 
		/* R */
		'O', 'S', 24, 22, 
		/* S */
		'A', 'E', 'I', 'K', 'M', 'N', 24, 24, 19, 24, 27, 28, 
		/* T */
		'L', 'N', 'R', 23, 24, 26, 
		/* U */
		'A', 29, 
		/* V */
		'G', 24, 
		/* W */
		
		/* X */
		'K', 20, 
		/* Y */
		
		/* Z */
		
	};
	const unsigned int off = _offs[C2I(cc[0U]) * 2U + 1U];
	const unsigned int len = _offs[C2I(cc[0U]) * 2U + 0U];
	unsigned i;

	for (i = off; i < off + len; i++) {
		if (_cc[i] == cc[1U]) {
			return _cc[i + len];
		}
	}
	return 0;
#undef C2I
#undef COUNTRIES_WITH
#undef THERE_ARE
#undef AT
}
