from asdl import pybase
from mycpp import mops
from typing import Optional, List, Tuple, Dict, Any, cast, TYPE_CHECKING

if TYPE_CHECKING:
  from _devbuild.gen.syntax_asdl import loc_t, Token, expr_t, word_t, command_t, CompoundWord, DoubleQuoted, ArgList, re_t, redir_loc_t, proc_sig_t, Func
  from _devbuild.gen.value_asdl import value_t, Obj

from _devbuild.gen.id_kind_asdl import Id_t
from _devbuild.gen.id_kind_asdl import Id_str


from asdl import runtime  # For runtime.NO_SPID
from asdl.runtime import NewRecord, NewLeaf, TraversalState
from _devbuild.gen.hnode_asdl import color_e, hnode, hnode_e, hnode_t, Field

class cmd_value_e(object):
  Argv = 1
  Assign = 2

_cmd_value_str = {
  1: 'Argv',
  2: 'Assign',
}

def cmd_value_str(tag, dot=True):
  # type: (int, bool) -> str
  v = _cmd_value_str[tag]
  if dot:
    return "cmd_value.%s" % v
  else:
    return v

class cmd_value_t(pybase.CompoundObj):
  def tag(self):
    # type: () -> int
    return self._type_tag
  pass

class cmd_value(object):
  class Argv(cmd_value_t):
    _type_tag = 1
    __slots__ = ('argv', 'arg_locs', 'is_last_cmd', 'self_obj', 'proc_args')
  
    def __init__(self, argv, arg_locs, is_last_cmd, self_obj, proc_args):
      # type: (List[str], List[CompoundWord], bool, Optional[Obj], Optional[ProcArgs]) -> None
      self.argv = argv
      self.arg_locs = arg_locs
      self.is_last_cmd = is_last_cmd
      self.self_obj = self_obj
      self.proc_args = proc_args
  
    @staticmethod
    def CreateNull(alloc_lists=False):
      # type: () -> cmd_value.Argv
      return cmd_value.Argv([] if alloc_lists else cast('List[str]', None), [] if alloc_lists else cast('List[CompoundWord]', None), False, cast('Optional[Obj]', None), cast('Optional[ProcArgs]', None))
  
    def PrettyTree(self, trav=None):
      # type: (Optional[TraversalState]) -> hnode_t
      trav = trav or TraversalState()
      heap_id = id(self)
      if heap_id in trav.seen:
        return hnode.AlreadySeen(heap_id)
      trav.seen[heap_id] = True
      out_node = NewRecord('cmd_value.Argv')
      L = out_node.fields
  
      if self.argv is not None:  # List
        x0 = hnode.Array([])
        for i0 in self.argv:
          x0.children.append(NewLeaf(i0, color_e.StringConst))
        L.append(Field('argv', x0))
  
      if self.arg_locs is not None:  # List
        x1 = hnode.Array([])
        for i1 in self.arg_locs:
          h = (hnode.Leaf("_", color_e.OtherConst) if i1 is None else
               i1.PrettyTree(trav=trav))
          x1.children.append(h)
        L.append(Field('arg_locs', x1))
  
      x2 = hnode.Leaf('T' if self.is_last_cmd else 'F', color_e.OtherConst)
      L.append(Field('is_last_cmd', x2))
  
      if self.self_obj is not None:  # Optional
        x3 = self.self_obj.PrettyTree(trav=trav)
        L.append(Field('self_obj', x3))
  
      if self.proc_args is not None:  # Optional
        x4 = self.proc_args.PrettyTree(trav=trav)
        L.append(Field('proc_args', x4))
  
      return out_node
  
    def _AbbreviatedTree(self, trav=None):
      # type: (Optional[TraversalState]) -> hnode_t
      trav = trav or TraversalState()
      heap_id = id(self)
      if heap_id in trav.seen:
        return hnode.AlreadySeen(heap_id)
      trav.seen[heap_id] = True
      out_node = NewRecord('cmd_value.Argv')
      L = out_node.fields
      if self.argv is not None:  # List
        x0 = hnode.Array([])
        for i0 in self.argv:
          x0.children.append(NewLeaf(i0, color_e.StringConst))
        L.append(Field('argv', x0))
  
      if self.arg_locs is not None:  # List
        x1 = hnode.Array([])
        for i1 in self.arg_locs:
          h = (hnode.Leaf("_", color_e.OtherConst) if i1 is None else
               i1.AbbreviatedTree(trav=trav))
          x1.children.append(h)
        L.append(Field('arg_locs', x1))
  
      x2 = hnode.Leaf('T' if self.is_last_cmd else 'F', color_e.OtherConst)
      L.append(Field('is_last_cmd', x2))
  
      if self.self_obj is not None:  # Optional
        x3 = self.self_obj.AbbreviatedTree(trav=trav)
        L.append(Field('self_obj', x3))
  
      if self.proc_args is not None:  # Optional
        x4 = self.proc_args.AbbreviatedTree(trav=trav)
        L.append(Field('proc_args', x4))
  
      return out_node
  
    def AbbreviatedTree(self, trav=None):
      # type: (Optional[TraversalState]) -> hnode_t
      return self._AbbreviatedTree(trav=trav)
  
  class Assign(cmd_value_t):
    _type_tag = 2
    __slots__ = ('builtin_id', 'argv', 'arg_locs', 'pairs')
  
    def __init__(self, builtin_id, argv, arg_locs, pairs):
      # type: (int, List[str], List[CompoundWord], List[AssignArg]) -> None
      self.builtin_id = builtin_id
      self.argv = argv
      self.arg_locs = arg_locs
      self.pairs = pairs
  
    @staticmethod
    def CreateNull(alloc_lists=False):
      # type: () -> cmd_value.Assign
      return cmd_value.Assign(-1, [] if alloc_lists else cast('List[str]', None), [] if alloc_lists else cast('List[CompoundWord]', None), [] if alloc_lists else cast('List[AssignArg]', None))
  
    def PrettyTree(self, trav=None):
      # type: (Optional[TraversalState]) -> hnode_t
      trav = trav or TraversalState()
      heap_id = id(self)
      if heap_id in trav.seen:
        return hnode.AlreadySeen(heap_id)
      trav.seen[heap_id] = True
      out_node = NewRecord('cmd_value.Assign')
      L = out_node.fields
  
      x0 = hnode.Leaf(str(self.builtin_id), color_e.OtherConst)
      L.append(Field('builtin_id', x0))
  
      if self.argv is not None:  # List
        x1 = hnode.Array([])
        for i1 in self.argv:
          x1.children.append(NewLeaf(i1, color_e.StringConst))
        L.append(Field('argv', x1))
  
      if self.arg_locs is not None:  # List
        x2 = hnode.Array([])
        for i2 in self.arg_locs:
          h = (hnode.Leaf("_", color_e.OtherConst) if i2 is None else
               i2.PrettyTree(trav=trav))
          x2.children.append(h)
        L.append(Field('arg_locs', x2))
  
      if self.pairs is not None:  # List
        x3 = hnode.Array([])
        for i3 in self.pairs:
          h = (hnode.Leaf("_", color_e.OtherConst) if i3 is None else
               i3.PrettyTree(trav=trav))
          x3.children.append(h)
        L.append(Field('pairs', x3))
  
      return out_node
  
    def _AbbreviatedTree(self, trav=None):
      # type: (Optional[TraversalState]) -> hnode_t
      trav = trav or TraversalState()
      heap_id = id(self)
      if heap_id in trav.seen:
        return hnode.AlreadySeen(heap_id)
      trav.seen[heap_id] = True
      out_node = NewRecord('cmd_value.Assign')
      L = out_node.fields
      x0 = hnode.Leaf(str(self.builtin_id), color_e.OtherConst)
      L.append(Field('builtin_id', x0))
  
      if self.argv is not None:  # List
        x1 = hnode.Array([])
        for i1 in self.argv:
          x1.children.append(NewLeaf(i1, color_e.StringConst))
        L.append(Field('argv', x1))
  
      if self.arg_locs is not None:  # List
        x2 = hnode.Array([])
        for i2 in self.arg_locs:
          h = (hnode.Leaf("_", color_e.OtherConst) if i2 is None else
               i2.AbbreviatedTree(trav=trav))
          x2.children.append(h)
        L.append(Field('arg_locs', x2))
  
      if self.pairs is not None:  # List
        x3 = hnode.Array([])
        for i3 in self.pairs:
          h = (hnode.Leaf("_", color_e.OtherConst) if i3 is None else
               i3.AbbreviatedTree(trav=trav))
          x3.children.append(h)
        L.append(Field('pairs', x3))
  
      return out_node
  
    def AbbreviatedTree(self, trav=None):
      # type: (Optional[TraversalState]) -> hnode_t
      return self._AbbreviatedTree(trav=trav)
  
  pass

class part_value_e(object):
  String = 66
  Array = 2
  ExtGlob = 3

_part_value_str = {
  2: 'Array',
  3: 'ExtGlob',
  66: 'String',
}

def part_value_str(tag, dot=True):
  # type: (int, bool) -> str
  v = _part_value_str[tag]
  if dot:
    return "part_value.%s" % v
  else:
    return v

class part_value_t(pybase.CompoundObj):
  def tag(self):
    # type: () -> int
    return self._type_tag
  pass

class part_value(object):
  class Array(part_value_t):
    _type_tag = 2
    __slots__ = ('strs',)
  
    def __init__(self, strs):
      # type: (List[str]) -> None
      self.strs = strs
  
    @staticmethod
    def CreateNull(alloc_lists=False):
      # type: () -> part_value.Array
      return part_value.Array([] if alloc_lists else cast('List[str]', None))
  
    def PrettyTree(self, trav=None):
      # type: (Optional[TraversalState]) -> hnode_t
      trav = trav or TraversalState()
      heap_id = id(self)
      if heap_id in trav.seen:
        return hnode.AlreadySeen(heap_id)
      trav.seen[heap_id] = True
      out_node = NewRecord('part_value.Array')
      L = out_node.fields
  
      if self.strs is not None:  # List
        x0 = hnode.Array([])
        for i0 in self.strs:
          x0.children.append(NewLeaf(i0, color_e.StringConst))
        L.append(Field('strs', x0))
  
      return out_node
  
    def _AbbreviatedTree(self, trav=None):
      # type: (Optional[TraversalState]) -> hnode_t
      trav = trav or TraversalState()
      heap_id = id(self)
      if heap_id in trav.seen:
        return hnode.AlreadySeen(heap_id)
      trav.seen[heap_id] = True
      out_node = NewRecord('part_value.Array')
      L = out_node.fields
      if self.strs is not None:  # List
        x0 = hnode.Array([])
        for i0 in self.strs:
          x0.children.append(NewLeaf(i0, color_e.StringConst))
        L.append(Field('strs', x0))
  
      return out_node
  
    def AbbreviatedTree(self, trav=None):
      # type: (Optional[TraversalState]) -> hnode_t
      return self._AbbreviatedTree(trav=trav)
  
  class ExtGlob(part_value_t):
    _type_tag = 3
    __slots__ = ('part_vals',)
  
    def __init__(self, part_vals):
      # type: (List[part_value_t]) -> None
      self.part_vals = part_vals
  
    @staticmethod
    def CreateNull(alloc_lists=False):
      # type: () -> part_value.ExtGlob
      return part_value.ExtGlob([] if alloc_lists else cast('List[part_value_t]', None))
  
    def PrettyTree(self, trav=None):
      # type: (Optional[TraversalState]) -> hnode_t
      trav = trav or TraversalState()
      heap_id = id(self)
      if heap_id in trav.seen:
        return hnode.AlreadySeen(heap_id)
      trav.seen[heap_id] = True
      out_node = NewRecord('part_value.ExtGlob')
      L = out_node.fields
  
      if self.part_vals is not None:  # List
        x0 = hnode.Array([])
        for i0 in self.part_vals:
          h = (hnode.Leaf("_", color_e.OtherConst) if i0 is None else
               i0.PrettyTree(trav=trav))
          x0.children.append(h)
        L.append(Field('part_vals', x0))
  
      return out_node
  
    def _AbbreviatedTree(self, trav=None):
      # type: (Optional[TraversalState]) -> hnode_t
      trav = trav or TraversalState()
      heap_id = id(self)
      if heap_id in trav.seen:
        return hnode.AlreadySeen(heap_id)
      trav.seen[heap_id] = True
      out_node = NewRecord('part_value.ExtGlob')
      L = out_node.fields
      if self.part_vals is not None:  # List
        x0 = hnode.Array([])
        for i0 in self.part_vals:
          h = (hnode.Leaf("_", color_e.OtherConst) if i0 is None else
               i0.AbbreviatedTree(trav=trav))
          x0.children.append(h)
        L.append(Field('part_vals', x0))
  
      return out_node
  
    def AbbreviatedTree(self, trav=None):
      # type: (Optional[TraversalState]) -> hnode_t
      return self._AbbreviatedTree(trav=trav)
  
  pass

class coerced_t(pybase.SimpleObj):
  pass

class coerced_e(object):
  Int = coerced_t(1)
  Float = coerced_t(2)
  Neither = coerced_t(3)

_coerced_str = {
  1: 'coerced.Int',
  2: 'coerced.Float',
  3: 'coerced.Neither',
}

def coerced_str(val):
  # type: (coerced_t) -> str
  return _coerced_str[val]

class scope_t(pybase.SimpleObj):
  pass

class scope_e(object):
  Shopt = scope_t(1)
  Dynamic = scope_t(2)
  LocalOrGlobal = scope_t(3)
  LocalOnly = scope_t(4)
  GlobalOnly = scope_t(5)

_scope_str = {
  1: 'scope.Shopt',
  2: 'scope.Dynamic',
  3: 'scope.LocalOrGlobal',
  4: 'scope.LocalOnly',
  5: 'scope.GlobalOnly',
}

def scope_str(val):
  # type: (scope_t) -> str
  return _scope_str[val]

class a_index_e(object):
  Str = 1
  Int = 2

_a_index_str = {
  1: 'Str',
  2: 'Int',
}

def a_index_str(tag, dot=True):
  # type: (int, bool) -> str
  v = _a_index_str[tag]
  if dot:
    return "a_index.%s" % v
  else:
    return v

class a_index_t(pybase.CompoundObj):
  def tag(self):
    # type: () -> int
    return self._type_tag
  pass

class a_index(object):
  class Str(a_index_t):
    _type_tag = 1
    __slots__ = ('s',)
  
    def __init__(self, s):
      # type: (str) -> None
      self.s = s
  
    @staticmethod
    def CreateNull(alloc_lists=False):
      # type: () -> a_index.Str
      return a_index.Str('')
  
    def PrettyTree(self, trav=None):
      # type: (Optional[TraversalState]) -> hnode_t
      trav = trav or TraversalState()
      heap_id = id(self)
      if heap_id in trav.seen:
        return hnode.AlreadySeen(heap_id)
      trav.seen[heap_id] = True
      out_node = NewRecord('a_index.Str')
      L = out_node.fields
  
      x0 = NewLeaf(self.s, color_e.StringConst)
      L.append(Field('s', x0))
  
      return out_node
  
    def _AbbreviatedTree(self, trav=None):
      # type: (Optional[TraversalState]) -> hnode_t
      trav = trav or TraversalState()
      heap_id = id(self)
      if heap_id in trav.seen:
        return hnode.AlreadySeen(heap_id)
      trav.seen[heap_id] = True
      out_node = NewRecord('a_index.Str')
      L = out_node.fields
      x0 = NewLeaf(self.s, color_e.StringConst)
      L.append(Field('s', x0))
  
      return out_node
  
    def AbbreviatedTree(self, trav=None):
      # type: (Optional[TraversalState]) -> hnode_t
      return self._AbbreviatedTree(trav=trav)
  
  class Int(a_index_t):
    _type_tag = 2
    __slots__ = ('i',)
  
    def __init__(self, i):
      # type: (int) -> None
      self.i = i
  
    @staticmethod
    def CreateNull(alloc_lists=False):
      # type: () -> a_index.Int
      return a_index.Int(-1)
  
    def PrettyTree(self, trav=None):
      # type: (Optional[TraversalState]) -> hnode_t
      trav = trav or TraversalState()
      heap_id = id(self)
      if heap_id in trav.seen:
        return hnode.AlreadySeen(heap_id)
      trav.seen[heap_id] = True
      out_node = NewRecord('a_index.Int')
      L = out_node.fields
  
      x0 = hnode.Leaf(str(self.i), color_e.OtherConst)
      L.append(Field('i', x0))
  
      return out_node
  
    def _AbbreviatedTree(self, trav=None):
      # type: (Optional[TraversalState]) -> hnode_t
      trav = trav or TraversalState()
      heap_id = id(self)
      if heap_id in trav.seen:
        return hnode.AlreadySeen(heap_id)
      trav.seen[heap_id] = True
      out_node = NewRecord('a_index.Int')
      L = out_node.fields
      x0 = hnode.Leaf(str(self.i), color_e.OtherConst)
      L.append(Field('i', x0))
  
      return out_node
  
    def AbbreviatedTree(self, trav=None):
      # type: (Optional[TraversalState]) -> hnode_t
      return self._AbbreviatedTree(trav=trav)
  
  pass

class redirect_arg_e(object):
  Path = 1
  CopyFd = 2
  MoveFd = 3
  CloseFd = 4
  HereDoc = 5

_redirect_arg_str = {
  1: 'Path',
  2: 'CopyFd',
  3: 'MoveFd',
  4: 'CloseFd',
  5: 'HereDoc',
}

def redirect_arg_str(tag, dot=True):
  # type: (int, bool) -> str
  v = _redirect_arg_str[tag]
  if dot:
    return "redirect_arg.%s" % v
  else:
    return v

class redirect_arg_t(pybase.CompoundObj):
  def tag(self):
    # type: () -> int
    return self._type_tag
  pass

class redirect_arg__CloseFd(redirect_arg_t):
  _type_tag = 4
  __slots__ = ()

  def __init__(self, ):
    # type: () -> None
    pass

  def PrettyTree(self, trav=None):
    # type: (Optional[TraversalState]) -> hnode_t
    trav = trav or TraversalState()
    heap_id = id(self)
    if heap_id in trav.seen:
      return hnode.AlreadySeen(heap_id)
    trav.seen[heap_id] = True
    out_node = NewRecord('redirect_arg__CloseFd')
    L = out_node.fields

    return out_node

  def _AbbreviatedTree(self, trav=None):
    # type: (Optional[TraversalState]) -> hnode_t
    trav = trav or TraversalState()
    heap_id = id(self)
    if heap_id in trav.seen:
      return hnode.AlreadySeen(heap_id)
    trav.seen[heap_id] = True
    out_node = NewRecord('redirect_arg__CloseFd')
    L = out_node.fields
    return out_node

  def AbbreviatedTree(self, trav=None):
    # type: (Optional[TraversalState]) -> hnode_t
    return self._AbbreviatedTree(trav=trav)

class redirect_arg(object):
  class Path(redirect_arg_t):
    _type_tag = 1
    __slots__ = ('filename',)
  
    def __init__(self, filename):
      # type: (str) -> None
      self.filename = filename
  
    @staticmethod
    def CreateNull(alloc_lists=False):
      # type: () -> redirect_arg.Path
      return redirect_arg.Path('')
  
    def PrettyTree(self, trav=None):
      # type: (Optional[TraversalState]) -> hnode_t
      trav = trav or TraversalState()
      heap_id = id(self)
      if heap_id in trav.seen:
        return hnode.AlreadySeen(heap_id)
      trav.seen[heap_id] = True
      out_node = NewRecord('redirect_arg.Path')
      L = out_node.fields
  
      x0 = NewLeaf(self.filename, color_e.StringConst)
      L.append(Field('filename', x0))
  
      return out_node
  
    def _AbbreviatedTree(self, trav=None):
      # type: (Optional[TraversalState]) -> hnode_t
      trav = trav or TraversalState()
      heap_id = id(self)
      if heap_id in trav.seen:
        return hnode.AlreadySeen(heap_id)
      trav.seen[heap_id] = True
      out_node = NewRecord('redirect_arg.Path')
      L = out_node.fields
      x0 = NewLeaf(self.filename, color_e.StringConst)
      L.append(Field('filename', x0))
  
      return out_node
  
    def AbbreviatedTree(self, trav=None):
      # type: (Optional[TraversalState]) -> hnode_t
      return self._AbbreviatedTree(trav=trav)
  
  class CopyFd(redirect_arg_t):
    _type_tag = 2
    __slots__ = ('target_fd',)
  
    def __init__(self, target_fd):
      # type: (int) -> None
      self.target_fd = target_fd
  
    @staticmethod
    def CreateNull(alloc_lists=False):
      # type: () -> redirect_arg.CopyFd
      return redirect_arg.CopyFd(-1)
  
    def PrettyTree(self, trav=None):
      # type: (Optional[TraversalState]) -> hnode_t
      trav = trav or TraversalState()
      heap_id = id(self)
      if heap_id in trav.seen:
        return hnode.AlreadySeen(heap_id)
      trav.seen[heap_id] = True
      out_node = NewRecord('redirect_arg.CopyFd')
      L = out_node.fields
  
      x0 = hnode.Leaf(str(self.target_fd), color_e.OtherConst)
      L.append(Field('target_fd', x0))
  
      return out_node
  
    def _AbbreviatedTree(self, trav=None):
      # type: (Optional[TraversalState]) -> hnode_t
      trav = trav or TraversalState()
      heap_id = id(self)
      if heap_id in trav.seen:
        return hnode.AlreadySeen(heap_id)
      trav.seen[heap_id] = True
      out_node = NewRecord('redirect_arg.CopyFd')
      L = out_node.fields
      x0 = hnode.Leaf(str(self.target_fd), color_e.OtherConst)
      L.append(Field('target_fd', x0))
  
      return out_node
  
    def AbbreviatedTree(self, trav=None):
      # type: (Optional[TraversalState]) -> hnode_t
      return self._AbbreviatedTree(trav=trav)
  
  class MoveFd(redirect_arg_t):
    _type_tag = 3
    __slots__ = ('target_fd',)
  
    def __init__(self, target_fd):
      # type: (int) -> None
      self.target_fd = target_fd
  
    @staticmethod
    def CreateNull(alloc_lists=False):
      # type: () -> redirect_arg.MoveFd
      return redirect_arg.MoveFd(-1)
  
    def PrettyTree(self, trav=None):
      # type: (Optional[TraversalState]) -> hnode_t
      trav = trav or TraversalState()
      heap_id = id(self)
      if heap_id in trav.seen:
        return hnode.AlreadySeen(heap_id)
      trav.seen[heap_id] = True
      out_node = NewRecord('redirect_arg.MoveFd')
      L = out_node.fields
  
      x0 = hnode.Leaf(str(self.target_fd), color_e.OtherConst)
      L.append(Field('target_fd', x0))
  
      return out_node
  
    def _AbbreviatedTree(self, trav=None):
      # type: (Optional[TraversalState]) -> hnode_t
      trav = trav or TraversalState()
      heap_id = id(self)
      if heap_id in trav.seen:
        return hnode.AlreadySeen(heap_id)
      trav.seen[heap_id] = True
      out_node = NewRecord('redirect_arg.MoveFd')
      L = out_node.fields
      x0 = hnode.Leaf(str(self.target_fd), color_e.OtherConst)
      L.append(Field('target_fd', x0))
  
      return out_node
  
    def AbbreviatedTree(self, trav=None):
      # type: (Optional[TraversalState]) -> hnode_t
      return self._AbbreviatedTree(trav=trav)
  
  CloseFd = redirect_arg__CloseFd()
  
  class HereDoc(redirect_arg_t):
    _type_tag = 5
    __slots__ = ('body',)
  
    def __init__(self, body):
      # type: (str) -> None
      self.body = body
  
    @staticmethod
    def CreateNull(alloc_lists=False):
      # type: () -> redirect_arg.HereDoc
      return redirect_arg.HereDoc('')
  
    def PrettyTree(self, trav=None):
      # type: (Optional[TraversalState]) -> hnode_t
      trav = trav or TraversalState()
      heap_id = id(self)
      if heap_id in trav.seen:
        return hnode.AlreadySeen(heap_id)
      trav.seen[heap_id] = True
      out_node = NewRecord('redirect_arg.HereDoc')
      L = out_node.fields
  
      x0 = NewLeaf(self.body, color_e.StringConst)
      L.append(Field('body', x0))
  
      return out_node
  
    def _AbbreviatedTree(self, trav=None):
      # type: (Optional[TraversalState]) -> hnode_t
      trav = trav or TraversalState()
      heap_id = id(self)
      if heap_id in trav.seen:
        return hnode.AlreadySeen(heap_id)
      trav.seen[heap_id] = True
      out_node = NewRecord('redirect_arg.HereDoc')
      L = out_node.fields
      x0 = NewLeaf(self.body, color_e.StringConst)
      L.append(Field('body', x0))
  
      return out_node
  
    def AbbreviatedTree(self, trav=None):
      # type: (Optional[TraversalState]) -> hnode_t
      return self._AbbreviatedTree(trav=trav)
  
  pass

class wait_status_e(object):
  Proc = 1
  Pipeline = 2
  Cancelled = 3

_wait_status_str = {
  1: 'Proc',
  2: 'Pipeline',
  3: 'Cancelled',
}

def wait_status_str(tag, dot=True):
  # type: (int, bool) -> str
  v = _wait_status_str[tag]
  if dot:
    return "wait_status.%s" % v
  else:
    return v

class wait_status_t(pybase.CompoundObj):
  def tag(self):
    # type: () -> int
    return self._type_tag
  pass

class wait_status(object):
  class Proc(wait_status_t):
    _type_tag = 1
    __slots__ = ('code',)
  
    def __init__(self, code):
      # type: (int) -> None
      self.code = code
  
    @staticmethod
    def CreateNull(alloc_lists=False):
      # type: () -> wait_status.Proc
      return wait_status.Proc(-1)
  
    def PrettyTree(self, trav=None):
      # type: (Optional[TraversalState]) -> hnode_t
      trav = trav or TraversalState()
      heap_id = id(self)
      if heap_id in trav.seen:
        return hnode.AlreadySeen(heap_id)
      trav.seen[heap_id] = True
      out_node = NewRecord('wait_status.Proc')
      L = out_node.fields
  
      x0 = hnode.Leaf(str(self.code), color_e.OtherConst)
      L.append(Field('code', x0))
  
      return out_node
  
    def _AbbreviatedTree(self, trav=None):
      # type: (Optional[TraversalState]) -> hnode_t
      trav = trav or TraversalState()
      heap_id = id(self)
      if heap_id in trav.seen:
        return hnode.AlreadySeen(heap_id)
      trav.seen[heap_id] = True
      out_node = NewRecord('wait_status.Proc')
      L = out_node.fields
      x0 = hnode.Leaf(str(self.code), color_e.OtherConst)
      L.append(Field('code', x0))
  
      return out_node
  
    def AbbreviatedTree(self, trav=None):
      # type: (Optional[TraversalState]) -> hnode_t
      return self._AbbreviatedTree(trav=trav)
  
  class Pipeline(wait_status_t):
    _type_tag = 2
    __slots__ = ('codes',)
  
    def __init__(self, codes):
      # type: (List[int]) -> None
      self.codes = codes
  
    @staticmethod
    def CreateNull(alloc_lists=False):
      # type: () -> wait_status.Pipeline
      return wait_status.Pipeline([] if alloc_lists else cast('List[int]', None))
  
    def PrettyTree(self, trav=None):
      # type: (Optional[TraversalState]) -> hnode_t
      trav = trav or TraversalState()
      heap_id = id(self)
      if heap_id in trav.seen:
        return hnode.AlreadySeen(heap_id)
      trav.seen[heap_id] = True
      out_node = NewRecord('wait_status.Pipeline')
      L = out_node.fields
  
      if self.codes is not None:  # List
        x0 = hnode.Array([])
        for i0 in self.codes:
          x0.children.append(hnode.Leaf(str(i0), color_e.OtherConst))
        L.append(Field('codes', x0))
  
      return out_node
  
    def _AbbreviatedTree(self, trav=None):
      # type: (Optional[TraversalState]) -> hnode_t
      trav = trav or TraversalState()
      heap_id = id(self)
      if heap_id in trav.seen:
        return hnode.AlreadySeen(heap_id)
      trav.seen[heap_id] = True
      out_node = NewRecord('wait_status.Pipeline')
      L = out_node.fields
      if self.codes is not None:  # List
        x0 = hnode.Array([])
        for i0 in self.codes:
          x0.children.append(hnode.Leaf(str(i0), color_e.OtherConst))
        L.append(Field('codes', x0))
  
      return out_node
  
    def AbbreviatedTree(self, trav=None):
      # type: (Optional[TraversalState]) -> hnode_t
      return self._AbbreviatedTree(trav=trav)
  
  class Cancelled(wait_status_t):
    _type_tag = 3
    __slots__ = ('sig_num',)
  
    def __init__(self, sig_num):
      # type: (int) -> None
      self.sig_num = sig_num
  
    @staticmethod
    def CreateNull(alloc_lists=False):
      # type: () -> wait_status.Cancelled
      return wait_status.Cancelled(-1)
  
    def PrettyTree(self, trav=None):
      # type: (Optional[TraversalState]) -> hnode_t
      trav = trav or TraversalState()
      heap_id = id(self)
      if heap_id in trav.seen:
        return hnode.AlreadySeen(heap_id)
      trav.seen[heap_id] = True
      out_node = NewRecord('wait_status.Cancelled')
      L = out_node.fields
  
      x0 = hnode.Leaf(str(self.sig_num), color_e.OtherConst)
      L.append(Field('sig_num', x0))
  
      return out_node
  
    def _AbbreviatedTree(self, trav=None):
      # type: (Optional[TraversalState]) -> hnode_t
      trav = trav or TraversalState()
      heap_id = id(self)
      if heap_id in trav.seen:
        return hnode.AlreadySeen(heap_id)
      trav.seen[heap_id] = True
      out_node = NewRecord('wait_status.Cancelled')
      L = out_node.fields
      x0 = hnode.Leaf(str(self.sig_num), color_e.OtherConst)
      L.append(Field('sig_num', x0))
  
      return out_node
  
    def AbbreviatedTree(self, trav=None):
      # type: (Optional[TraversalState]) -> hnode_t
      return self._AbbreviatedTree(trav=trav)
  
  pass

class flow_t(pybase.SimpleObj):
  pass

class flow_e(object):
  Nothing = flow_t(1)
  Break = flow_t(2)
  Raise = flow_t(3)

_flow_str = {
  1: 'flow.Nothing',
  2: 'flow.Break',
  3: 'flow.Raise',
}

def flow_str(val):
  # type: (flow_t) -> str
  return _flow_str[val]

class span_t(pybase.SimpleObj):
  pass

class span_e(object):
  Black = span_t(1)
  Delim = span_t(2)
  Backslash = span_t(3)

_span_str = {
  1: 'span.Black',
  2: 'span.Delim',
  3: 'span.Backslash',
}

def span_str(val):
  # type: (span_t) -> str
  return _span_str[val]

emit_t = int  # type alias for integer

class emit_i(object):
  Part = 1
  Delim = 2
  Empty = 3
  Escape = 4
  Nothing = 5
  ARRAY_SIZE = 6

_emit_str = {
  1: 'emit.Part',
  2: 'emit.Delim',
  3: 'emit.Empty',
  4: 'emit.Escape',
  5: 'emit.Nothing',
}

def emit_str(val):
  # type: (emit_t) -> str
  return _emit_str[val]

state_t = int  # type alias for integer

class state_i(object):
  Invalid = 1
  Start = 2
  DE_White1 = 3
  DE_Gray = 4
  DE_White2 = 5
  Black = 6
  Backslash = 7
  Done = 8
  ARRAY_SIZE = 9

_state_str = {
  1: 'state.Invalid',
  2: 'state.Start',
  3: 'state.DE_White1',
  4: 'state.DE_Gray',
  5: 'state.DE_White2',
  6: 'state.Black',
  7: 'state.Backslash',
  8: 'state.Done',
}

def state_str(val):
  # type: (state_t) -> str
  return _state_str[val]

char_kind_t = int  # type alias for integer

class char_kind_i(object):
  DE_White = 1
  DE_Gray = 2
  Black = 3
  Backslash = 4
  Sentinel = 5
  ARRAY_SIZE = 6

_char_kind_str = {
  1: 'char_kind.DE_White',
  2: 'char_kind.DE_Gray',
  3: 'char_kind.Black',
  4: 'char_kind.Backslash',
  5: 'char_kind.Sentinel',
}

def char_kind_str(val):
  # type: (char_kind_t) -> str
  return _char_kind_str[val]

class job_state_t(pybase.SimpleObj):
  pass

class job_state_e(object):
  Running = job_state_t(1)
  Done = job_state_t(2)
  Stopped = job_state_t(3)

_job_state_str = {
  1: 'job_state.Running',
  2: 'job_state.Done',
  3: 'job_state.Stopped',
}

def job_state_str(val):
  # type: (job_state_t) -> str
  return _job_state_str[val]

class flag_type_t(pybase.SimpleObj):
  pass

class flag_type_e(object):
  Bool = flag_type_t(1)
  Int = flag_type_t(2)
  Float = flag_type_t(3)
  Str = flag_type_t(4)

_flag_type_str = {
  1: 'flag_type.Bool',
  2: 'flag_type.Int',
  3: 'flag_type.Float',
  4: 'flag_type.Str',
}

def flag_type_str(val):
  # type: (flag_type_t) -> str
  return _flag_type_str[val]

class trace_e(object):
  External = 1
  CommandSub = 2
  ForkWait = 3
  Fork = 4
  PipelinePart = 5
  ProcessSub = 6
  HereDoc = 7

_trace_str = {
  1: 'External',
  2: 'CommandSub',
  3: 'ForkWait',
  4: 'Fork',
  5: 'PipelinePart',
  6: 'ProcessSub',
  7: 'HereDoc',
}

def trace_str(tag, dot=True):
  # type: (int, bool) -> str
  v = _trace_str[tag]
  if dot:
    return "trace.%s" % v
  else:
    return v

class trace_t(pybase.CompoundObj):
  def tag(self):
    # type: () -> int
    return self._type_tag
  pass

class trace__CommandSub(trace_t):
  _type_tag = 2
  __slots__ = ()

  def __init__(self, ):
    # type: () -> None
    pass

  def PrettyTree(self, trav=None):
    # type: (Optional[TraversalState]) -> hnode_t
    trav = trav or TraversalState()
    heap_id = id(self)
    if heap_id in trav.seen:
      return hnode.AlreadySeen(heap_id)
    trav.seen[heap_id] = True
    out_node = NewRecord('trace__CommandSub')
    L = out_node.fields

    return out_node

  def _AbbreviatedTree(self, trav=None):
    # type: (Optional[TraversalState]) -> hnode_t
    trav = trav or TraversalState()
    heap_id = id(self)
    if heap_id in trav.seen:
      return hnode.AlreadySeen(heap_id)
    trav.seen[heap_id] = True
    out_node = NewRecord('trace__CommandSub')
    L = out_node.fields
    return out_node

  def AbbreviatedTree(self, trav=None):
    # type: (Optional[TraversalState]) -> hnode_t
    return self._AbbreviatedTree(trav=trav)

class trace__ForkWait(trace_t):
  _type_tag = 3
  __slots__ = ()

  def __init__(self, ):
    # type: () -> None
    pass

  def PrettyTree(self, trav=None):
    # type: (Optional[TraversalState]) -> hnode_t
    trav = trav or TraversalState()
    heap_id = id(self)
    if heap_id in trav.seen:
      return hnode.AlreadySeen(heap_id)
    trav.seen[heap_id] = True
    out_node = NewRecord('trace__ForkWait')
    L = out_node.fields

    return out_node

  def _AbbreviatedTree(self, trav=None):
    # type: (Optional[TraversalState]) -> hnode_t
    trav = trav or TraversalState()
    heap_id = id(self)
    if heap_id in trav.seen:
      return hnode.AlreadySeen(heap_id)
    trav.seen[heap_id] = True
    out_node = NewRecord('trace__ForkWait')
    L = out_node.fields
    return out_node

  def AbbreviatedTree(self, trav=None):
    # type: (Optional[TraversalState]) -> hnode_t
    return self._AbbreviatedTree(trav=trav)

class trace__Fork(trace_t):
  _type_tag = 4
  __slots__ = ()

  def __init__(self, ):
    # type: () -> None
    pass

  def PrettyTree(self, trav=None):
    # type: (Optional[TraversalState]) -> hnode_t
    trav = trav or TraversalState()
    heap_id = id(self)
    if heap_id in trav.seen:
      return hnode.AlreadySeen(heap_id)
    trav.seen[heap_id] = True
    out_node = NewRecord('trace__Fork')
    L = out_node.fields

    return out_node

  def _AbbreviatedTree(self, trav=None):
    # type: (Optional[TraversalState]) -> hnode_t
    trav = trav or TraversalState()
    heap_id = id(self)
    if heap_id in trav.seen:
      return hnode.AlreadySeen(heap_id)
    trav.seen[heap_id] = True
    out_node = NewRecord('trace__Fork')
    L = out_node.fields
    return out_node

  def AbbreviatedTree(self, trav=None):
    # type: (Optional[TraversalState]) -> hnode_t
    return self._AbbreviatedTree(trav=trav)

class trace__PipelinePart(trace_t):
  _type_tag = 5
  __slots__ = ()

  def __init__(self, ):
    # type: () -> None
    pass

  def PrettyTree(self, trav=None):
    # type: (Optional[TraversalState]) -> hnode_t
    trav = trav or TraversalState()
    heap_id = id(self)
    if heap_id in trav.seen:
      return hnode.AlreadySeen(heap_id)
    trav.seen[heap_id] = True
    out_node = NewRecord('trace__PipelinePart')
    L = out_node.fields

    return out_node

  def _AbbreviatedTree(self, trav=None):
    # type: (Optional[TraversalState]) -> hnode_t
    trav = trav or TraversalState()
    heap_id = id(self)
    if heap_id in trav.seen:
      return hnode.AlreadySeen(heap_id)
    trav.seen[heap_id] = True
    out_node = NewRecord('trace__PipelinePart')
    L = out_node.fields
    return out_node

  def AbbreviatedTree(self, trav=None):
    # type: (Optional[TraversalState]) -> hnode_t
    return self._AbbreviatedTree(trav=trav)

class trace__ProcessSub(trace_t):
  _type_tag = 6
  __slots__ = ()

  def __init__(self, ):
    # type: () -> None
    pass

  def PrettyTree(self, trav=None):
    # type: (Optional[TraversalState]) -> hnode_t
    trav = trav or TraversalState()
    heap_id = id(self)
    if heap_id in trav.seen:
      return hnode.AlreadySeen(heap_id)
    trav.seen[heap_id] = True
    out_node = NewRecord('trace__ProcessSub')
    L = out_node.fields

    return out_node

  def _AbbreviatedTree(self, trav=None):
    # type: (Optional[TraversalState]) -> hnode_t
    trav = trav or TraversalState()
    heap_id = id(self)
    if heap_id in trav.seen:
      return hnode.AlreadySeen(heap_id)
    trav.seen[heap_id] = True
    out_node = NewRecord('trace__ProcessSub')
    L = out_node.fields
    return out_node

  def AbbreviatedTree(self, trav=None):
    # type: (Optional[TraversalState]) -> hnode_t
    return self._AbbreviatedTree(trav=trav)

class trace__HereDoc(trace_t):
  _type_tag = 7
  __slots__ = ()

  def __init__(self, ):
    # type: () -> None
    pass

  def PrettyTree(self, trav=None):
    # type: (Optional[TraversalState]) -> hnode_t
    trav = trav or TraversalState()
    heap_id = id(self)
    if heap_id in trav.seen:
      return hnode.AlreadySeen(heap_id)
    trav.seen[heap_id] = True
    out_node = NewRecord('trace__HereDoc')
    L = out_node.fields

    return out_node

  def _AbbreviatedTree(self, trav=None):
    # type: (Optional[TraversalState]) -> hnode_t
    trav = trav or TraversalState()
    heap_id = id(self)
    if heap_id in trav.seen:
      return hnode.AlreadySeen(heap_id)
    trav.seen[heap_id] = True
    out_node = NewRecord('trace__HereDoc')
    L = out_node.fields
    return out_node

  def AbbreviatedTree(self, trav=None):
    # type: (Optional[TraversalState]) -> hnode_t
    return self._AbbreviatedTree(trav=trav)

class trace(object):
  class External(trace_t):
    _type_tag = 1
    __slots__ = ('argv',)
  
    def __init__(self, argv):
      # type: (List[str]) -> None
      self.argv = argv
  
    @staticmethod
    def CreateNull(alloc_lists=False):
      # type: () -> trace.External
      return trace.External([] if alloc_lists else cast('List[str]', None))
  
    def PrettyTree(self, trav=None):
      # type: (Optional[TraversalState]) -> hnode_t
      trav = trav or TraversalState()
      heap_id = id(self)
      if heap_id in trav.seen:
        return hnode.AlreadySeen(heap_id)
      trav.seen[heap_id] = True
      out_node = NewRecord('trace.External')
      L = out_node.fields
  
      if self.argv is not None:  # List
        x0 = hnode.Array([])
        for i0 in self.argv:
          x0.children.append(NewLeaf(i0, color_e.StringConst))
        L.append(Field('argv', x0))
  
      return out_node
  
    def _AbbreviatedTree(self, trav=None):
      # type: (Optional[TraversalState]) -> hnode_t
      trav = trav or TraversalState()
      heap_id = id(self)
      if heap_id in trav.seen:
        return hnode.AlreadySeen(heap_id)
      trav.seen[heap_id] = True
      out_node = NewRecord('trace.External')
      L = out_node.fields
      if self.argv is not None:  # List
        x0 = hnode.Array([])
        for i0 in self.argv:
          x0.children.append(NewLeaf(i0, color_e.StringConst))
        L.append(Field('argv', x0))
  
      return out_node
  
    def AbbreviatedTree(self, trav=None):
      # type: (Optional[TraversalState]) -> hnode_t
      return self._AbbreviatedTree(trav=trav)
  
  CommandSub = trace__CommandSub()
  
  ForkWait = trace__ForkWait()
  
  Fork = trace__Fork()
  
  PipelinePart = trace__PipelinePart()
  
  ProcessSub = trace__ProcessSub()
  
  HereDoc = trace__HereDoc()
  
  pass

class word_style_t(pybase.SimpleObj):
  pass

class word_style_e(object):
  Expr = word_style_t(1)
  Unquoted = word_style_t(2)
  DQ = word_style_t(3)
  SQ = word_style_t(4)

_word_style_str = {
  1: 'word_style.Expr',
  2: 'word_style.Unquoted',
  3: 'word_style.DQ',
  4: 'word_style.SQ',
}

def word_style_str(val):
  # type: (word_style_t) -> str
  return _word_style_str[val]

class comp_action_t(pybase.SimpleObj):
  pass

class comp_action_e(object):
  Other = comp_action_t(1)
  FileSystem = comp_action_t(2)
  BashFunc = comp_action_t(3)

_comp_action_str = {
  1: 'comp_action.Other',
  2: 'comp_action.FileSystem',
  3: 'comp_action.BashFunc',
}

def comp_action_str(val):
  # type: (comp_action_t) -> str
  return _comp_action_str[val]

class AssignArg(pybase.CompoundObj):
  _type_tag = 64
  __slots__ = ('var_name', 'rval', 'plus_eq', 'blame_word')

  def __init__(self, var_name, rval, plus_eq, blame_word):
    # type: (str, Optional[value_t], bool, CompoundWord) -> None
    self.var_name = var_name
    self.rval = rval
    self.plus_eq = plus_eq
    self.blame_word = blame_word

  @staticmethod
  def CreateNull(alloc_lists=False):
    # type: () -> AssignArg
    return AssignArg('', cast('Optional[value_t]', None), False, cast(CompoundWord, None))

  def PrettyTree(self, trav=None):
    # type: (Optional[TraversalState]) -> hnode_t
    trav = trav or TraversalState()
    heap_id = id(self)
    if heap_id in trav.seen:
      return hnode.AlreadySeen(heap_id)
    trav.seen[heap_id] = True
    out_node = NewRecord('AssignArg')
    L = out_node.fields

    x0 = NewLeaf(self.var_name, color_e.StringConst)
    L.append(Field('var_name', x0))

    if self.rval is not None:  # Optional
      x1 = self.rval.PrettyTree(trav=trav)
      L.append(Field('rval', x1))

    x2 = hnode.Leaf('T' if self.plus_eq else 'F', color_e.OtherConst)
    L.append(Field('plus_eq', x2))

    assert self.blame_word is not None
    x3 = self.blame_word.PrettyTree(trav=trav)
    L.append(Field('blame_word', x3))

    return out_node

  def _AbbreviatedTree(self, trav=None):
    # type: (Optional[TraversalState]) -> hnode_t
    trav = trav or TraversalState()
    heap_id = id(self)
    if heap_id in trav.seen:
      return hnode.AlreadySeen(heap_id)
    trav.seen[heap_id] = True
    out_node = NewRecord('AssignArg')
    L = out_node.fields
    x0 = NewLeaf(self.var_name, color_e.StringConst)
    L.append(Field('var_name', x0))

    if self.rval is not None:  # Optional
      x1 = self.rval.AbbreviatedTree(trav=trav)
      L.append(Field('rval', x1))

    x2 = hnode.Leaf('T' if self.plus_eq else 'F', color_e.OtherConst)
    L.append(Field('plus_eq', x2))

    assert self.blame_word is not None
    x3 = self.blame_word.AbbreviatedTree(trav=trav)
    L.append(Field('blame_word', x3))

    return out_node

  def AbbreviatedTree(self, trav=None):
    # type: (Optional[TraversalState]) -> hnode_t
    return self._AbbreviatedTree(trav=trav)

class ProcArgs(pybase.CompoundObj):
  _type_tag = 65
  __slots__ = ('typed_args', 'pos_args', 'named_args', 'block_arg')

  def __init__(self, typed_args, pos_args, named_args, block_arg):
    # type: (ArgList, Optional[List[value_t]], Optional[Dict[str, value_t]], Optional[value_t]) -> None
    self.typed_args = typed_args
    self.pos_args = pos_args
    self.named_args = named_args
    self.block_arg = block_arg

  @staticmethod
  def CreateNull(alloc_lists=False):
    # type: () -> ProcArgs
    return ProcArgs(cast(ArgList, None), cast('Optional[List[value_t]]', None), cast('Optional[Dict[str, value_t]]', None), cast('Optional[value_t]', None))

  def PrettyTree(self, trav=None):
    # type: (Optional[TraversalState]) -> hnode_t
    trav = trav or TraversalState()
    heap_id = id(self)
    if heap_id in trav.seen:
      return hnode.AlreadySeen(heap_id)
    trav.seen[heap_id] = True
    out_node = NewRecord('ProcArgs')
    L = out_node.fields

    assert self.typed_args is not None
    x0 = self.typed_args.PrettyTree(trav=trav)
    L.append(Field('typed_args', x0))

    if self.pos_args is not None:  # List
      x1 = hnode.Array([])
      for i1 in self.pos_args:
        h = (hnode.Leaf("_", color_e.OtherConst) if i1 is None else
             i1.PrettyTree(trav=trav))
        x1.children.append(h)
      L.append(Field('pos_args', x1))

    if self.named_args is not None:  # Dict
      m = hnode.Leaf("Dict", color_e.OtherConst)
      x2 = hnode.Array([m])
      for k2, v2 in self.named_args.iteritems():
        x2.children.append(NewLeaf(k2, color_e.StringConst))
        x2.children.append(v2.PrettyTree(trav=trav))
      L.append(Field('named_args', x2))

    if self.block_arg is not None:  # Optional
      x3 = self.block_arg.PrettyTree(trav=trav)
      L.append(Field('block_arg', x3))

    return out_node

  def _AbbreviatedTree(self, trav=None):
    # type: (Optional[TraversalState]) -> hnode_t
    trav = trav or TraversalState()
    heap_id = id(self)
    if heap_id in trav.seen:
      return hnode.AlreadySeen(heap_id)
    trav.seen[heap_id] = True
    out_node = NewRecord('ProcArgs')
    L = out_node.fields
    assert self.typed_args is not None
    x0 = self.typed_args.AbbreviatedTree(trav=trav)
    L.append(Field('typed_args', x0))

    if self.pos_args is not None:  # List
      x1 = hnode.Array([])
      for i1 in self.pos_args:
        h = (hnode.Leaf("_", color_e.OtherConst) if i1 is None else
             i1.AbbreviatedTree(trav=trav))
        x1.children.append(h)
      L.append(Field('pos_args', x1))

    if self.named_args is not None:  # Dict
      m = hnode.Leaf("Dict", color_e.OtherConst)
      x2 = hnode.Array([m])
      for k2, v2 in self.named_args.iteritems():
        x2.children.append(NewLeaf(k2, color_e.StringConst))
        x2.children.append(v2.AbbreviatedTree(trav=trav))
      L.append(Field('named_args', x2))

    if self.block_arg is not None:  # Optional
      x3 = self.block_arg.AbbreviatedTree(trav=trav)
      L.append(Field('block_arg', x3))

    return out_node

  def AbbreviatedTree(self, trav=None):
    # type: (Optional[TraversalState]) -> hnode_t
    return self._AbbreviatedTree(trav=trav)

class Piece(part_value_t):
  _type_tag = 66
  __slots__ = ('s', 'quoted', 'do_split')

  def __init__(self, s, quoted, do_split):
    # type: (str, bool, bool) -> None
    self.s = s
    self.quoted = quoted
    self.do_split = do_split

  @staticmethod
  def CreateNull(alloc_lists=False):
    # type: () -> Piece
    return Piece('', False, False)

  def PrettyTree(self, trav=None):
    # type: (Optional[TraversalState]) -> hnode_t
    trav = trav or TraversalState()
    heap_id = id(self)
    if heap_id in trav.seen:
      return hnode.AlreadySeen(heap_id)
    trav.seen[heap_id] = True
    out_node = NewRecord('Piece')
    L = out_node.fields

    x0 = NewLeaf(self.s, color_e.StringConst)
    L.append(Field('s', x0))

    x1 = hnode.Leaf('T' if self.quoted else 'F', color_e.OtherConst)
    L.append(Field('quoted', x1))

    x2 = hnode.Leaf('T' if self.do_split else 'F', color_e.OtherConst)
    L.append(Field('do_split', x2))

    return out_node

  def _AbbreviatedTree(self, trav=None):
    # type: (Optional[TraversalState]) -> hnode_t
    trav = trav or TraversalState()
    heap_id = id(self)
    if heap_id in trav.seen:
      return hnode.AlreadySeen(heap_id)
    trav.seen[heap_id] = True
    out_node = NewRecord('Piece')
    L = out_node.fields
    x0 = NewLeaf(self.s, color_e.StringConst)
    L.append(Field('s', x0))

    x1 = hnode.Leaf('T' if self.quoted else 'F', color_e.OtherConst)
    L.append(Field('quoted', x1))

    x2 = hnode.Leaf('T' if self.do_split else 'F', color_e.OtherConst)
    L.append(Field('do_split', x2))

    return out_node

  def AbbreviatedTree(self, trav=None):
    # type: (Optional[TraversalState]) -> hnode_t
    return self._AbbreviatedTree(trav=trav)

class VarSubState(pybase.CompoundObj):
  _type_tag = 67
  __slots__ = ('join_array', 'is_type_query', 'has_test_op')

  def __init__(self, join_array, is_type_query, has_test_op):
    # type: (bool, bool, bool) -> None
    self.join_array = join_array
    self.is_type_query = is_type_query
    self.has_test_op = has_test_op

  @staticmethod
  def CreateNull(alloc_lists=False):
    # type: () -> VarSubState
    return VarSubState(False, False, False)

  def PrettyTree(self, trav=None):
    # type: (Optional[TraversalState]) -> hnode_t
    trav = trav or TraversalState()
    heap_id = id(self)
    if heap_id in trav.seen:
      return hnode.AlreadySeen(heap_id)
    trav.seen[heap_id] = True
    out_node = NewRecord('VarSubState')
    L = out_node.fields

    x0 = hnode.Leaf('T' if self.join_array else 'F', color_e.OtherConst)
    L.append(Field('join_array', x0))

    x1 = hnode.Leaf('T' if self.is_type_query else 'F', color_e.OtherConst)
    L.append(Field('is_type_query', x1))

    x2 = hnode.Leaf('T' if self.has_test_op else 'F', color_e.OtherConst)
    L.append(Field('has_test_op', x2))

    return out_node

  def _AbbreviatedTree(self, trav=None):
    # type: (Optional[TraversalState]) -> hnode_t
    trav = trav or TraversalState()
    heap_id = id(self)
    if heap_id in trav.seen:
      return hnode.AlreadySeen(heap_id)
    trav.seen[heap_id] = True
    out_node = NewRecord('VarSubState')
    L = out_node.fields
    x0 = hnode.Leaf('T' if self.join_array else 'F', color_e.OtherConst)
    L.append(Field('join_array', x0))

    x1 = hnode.Leaf('T' if self.is_type_query else 'F', color_e.OtherConst)
    L.append(Field('is_type_query', x1))

    x2 = hnode.Leaf('T' if self.has_test_op else 'F', color_e.OtherConst)
    L.append(Field('has_test_op', x2))

    return out_node

  def AbbreviatedTree(self, trav=None):
    # type: (Optional[TraversalState]) -> hnode_t
    return self._AbbreviatedTree(trav=trav)

class Cell(pybase.CompoundObj):
  _type_tag = 68
  __slots__ = ('exported', 'readonly', 'nameref', 'val')

  def __init__(self, exported, readonly, nameref, val):
    # type: (bool, bool, bool, value_t) -> None
    self.exported = exported
    self.readonly = readonly
    self.nameref = nameref
    self.val = val

  @staticmethod
  def CreateNull(alloc_lists=False):
    # type: () -> Cell
    return Cell(False, False, False, cast(value_t, None))

  def PrettyTree(self, trav=None):
    # type: (Optional[TraversalState]) -> hnode_t
    trav = trav or TraversalState()
    heap_id = id(self)
    if heap_id in trav.seen:
      return hnode.AlreadySeen(heap_id)
    trav.seen[heap_id] = True
    out_node = NewRecord('Cell')
    L = out_node.fields

    x0 = hnode.Leaf('T' if self.exported else 'F', color_e.OtherConst)
    L.append(Field('exported', x0))

    x1 = hnode.Leaf('T' if self.readonly else 'F', color_e.OtherConst)
    L.append(Field('readonly', x1))

    x2 = hnode.Leaf('T' if self.nameref else 'F', color_e.OtherConst)
    L.append(Field('nameref', x2))

    assert self.val is not None
    x3 = self.val.PrettyTree(trav=trav)
    L.append(Field('val', x3))

    return out_node

  def _AbbreviatedTree(self, trav=None):
    # type: (Optional[TraversalState]) -> hnode_t
    trav = trav or TraversalState()
    heap_id = id(self)
    if heap_id in trav.seen:
      return hnode.AlreadySeen(heap_id)
    trav.seen[heap_id] = True
    out_node = NewRecord('Cell')
    L = out_node.fields
    x0 = hnode.Leaf('T' if self.exported else 'F', color_e.OtherConst)
    L.append(Field('exported', x0))

    x1 = hnode.Leaf('T' if self.readonly else 'F', color_e.OtherConst)
    L.append(Field('readonly', x1))

    x2 = hnode.Leaf('T' if self.nameref else 'F', color_e.OtherConst)
    L.append(Field('nameref', x2))

    assert self.val is not None
    x3 = self.val.AbbreviatedTree(trav=trav)
    L.append(Field('val', x3))

    return out_node

  def AbbreviatedTree(self, trav=None):
    # type: (Optional[TraversalState]) -> hnode_t
    return self._AbbreviatedTree(trav=trav)

class VTestPlace(pybase.CompoundObj):
  _type_tag = 69
  __slots__ = ('name', 'index')

  def __init__(self, name, index):
    # type: (Optional[str], Optional[a_index_t]) -> None
    self.name = name
    self.index = index

  @staticmethod
  def CreateNull(alloc_lists=False):
    # type: () -> VTestPlace
    return VTestPlace(cast('Optional[str]', None), cast('Optional[a_index_t]', None))

  def PrettyTree(self, trav=None):
    # type: (Optional[TraversalState]) -> hnode_t
    trav = trav or TraversalState()
    heap_id = id(self)
    if heap_id in trav.seen:
      return hnode.AlreadySeen(heap_id)
    trav.seen[heap_id] = True
    out_node = NewRecord('VTestPlace')
    L = out_node.fields

    if self.name is not None:  # Optional
      x0 = NewLeaf(self.name, color_e.StringConst)
      L.append(Field('name', x0))

    if self.index is not None:  # Optional
      x1 = self.index.PrettyTree(trav=trav)
      L.append(Field('index', x1))

    return out_node

  def _AbbreviatedTree(self, trav=None):
    # type: (Optional[TraversalState]) -> hnode_t
    trav = trav or TraversalState()
    heap_id = id(self)
    if heap_id in trav.seen:
      return hnode.AlreadySeen(heap_id)
    trav.seen[heap_id] = True
    out_node = NewRecord('VTestPlace')
    L = out_node.fields
    if self.name is not None:  # Optional
      x0 = NewLeaf(self.name, color_e.StringConst)
      L.append(Field('name', x0))

    if self.index is not None:  # Optional
      x1 = self.index.AbbreviatedTree(trav=trav)
      L.append(Field('index', x1))

    return out_node

  def AbbreviatedTree(self, trav=None):
    # type: (Optional[TraversalState]) -> hnode_t
    return self._AbbreviatedTree(trav=trav)

class RedirValue(pybase.CompoundObj):
  _type_tag = 70
  __slots__ = ('op_id', 'op_loc', 'loc', 'arg')

  def __init__(self, op_id, op_loc, loc, arg):
    # type: (Id_t, loc_t, redir_loc_t, redirect_arg_t) -> None
    self.op_id = op_id
    self.op_loc = op_loc
    self.loc = loc
    self.arg = arg

  @staticmethod
  def CreateNull(alloc_lists=False):
    # type: () -> RedirValue
    return RedirValue(-1, cast(loc_t, None), cast(redir_loc_t, None), cast(redirect_arg_t, None))

  def PrettyTree(self, trav=None):
    # type: (Optional[TraversalState]) -> hnode_t
    trav = trav or TraversalState()
    heap_id = id(self)
    if heap_id in trav.seen:
      return hnode.AlreadySeen(heap_id)
    trav.seen[heap_id] = True
    out_node = NewRecord('RedirValue')
    L = out_node.fields

    x0 = hnode.Leaf(Id_str(self.op_id), color_e.UserType)
    L.append(Field('op_id', x0))

    assert self.op_loc is not None
    x1 = self.op_loc.PrettyTree(trav=trav)
    L.append(Field('op_loc', x1))

    assert self.loc is not None
    x2 = self.loc.PrettyTree(trav=trav)
    L.append(Field('loc', x2))

    assert self.arg is not None
    x3 = self.arg.PrettyTree(trav=trav)
    L.append(Field('arg', x3))

    return out_node

  def _AbbreviatedTree(self, trav=None):
    # type: (Optional[TraversalState]) -> hnode_t
    trav = trav or TraversalState()
    heap_id = id(self)
    if heap_id in trav.seen:
      return hnode.AlreadySeen(heap_id)
    trav.seen[heap_id] = True
    out_node = NewRecord('RedirValue')
    L = out_node.fields
    x0 = hnode.Leaf(Id_str(self.op_id), color_e.UserType)
    L.append(Field('op_id', x0))

    assert self.op_loc is not None
    x1 = self.op_loc.AbbreviatedTree(trav=trav)
    L.append(Field('op_loc', x1))

    assert self.loc is not None
    x2 = self.loc.AbbreviatedTree(trav=trav)
    L.append(Field('loc', x2))

    assert self.arg is not None
    x3 = self.arg.AbbreviatedTree(trav=trav)
    L.append(Field('arg', x3))

    return out_node

  def AbbreviatedTree(self, trav=None):
    # type: (Optional[TraversalState]) -> hnode_t
    return self._AbbreviatedTree(trav=trav)

class StatusArray(pybase.CompoundObj):
  _type_tag = 71
  __slots__ = ('codes', 'locs')

  def __init__(self, codes, locs):
    # type: (Optional[List[int]], Optional[List[loc_t]]) -> None
    self.codes = codes
    self.locs = locs

  @staticmethod
  def CreateNull(alloc_lists=False):
    # type: () -> StatusArray
    return StatusArray(cast('Optional[List[int]]', None), cast('Optional[List[loc_t]]', None))

  def PrettyTree(self, trav=None):
    # type: (Optional[TraversalState]) -> hnode_t
    trav = trav or TraversalState()
    heap_id = id(self)
    if heap_id in trav.seen:
      return hnode.AlreadySeen(heap_id)
    trav.seen[heap_id] = True
    out_node = NewRecord('StatusArray')
    L = out_node.fields

    if self.codes is not None:  # List
      x0 = hnode.Array([])
      for i0 in self.codes:
        x0.children.append(hnode.Leaf(str(i0), color_e.OtherConst))
      L.append(Field('codes', x0))

    if self.locs is not None:  # List
      x1 = hnode.Array([])
      for i1 in self.locs:
        h = (hnode.Leaf("_", color_e.OtherConst) if i1 is None else
             i1.PrettyTree(trav=trav))
        x1.children.append(h)
      L.append(Field('locs', x1))

    return out_node

  def _AbbreviatedTree(self, trav=None):
    # type: (Optional[TraversalState]) -> hnode_t
    trav = trav or TraversalState()
    heap_id = id(self)
    if heap_id in trav.seen:
      return hnode.AlreadySeen(heap_id)
    trav.seen[heap_id] = True
    out_node = NewRecord('StatusArray')
    L = out_node.fields
    if self.codes is not None:  # List
      x0 = hnode.Array([])
      for i0 in self.codes:
        x0.children.append(hnode.Leaf(str(i0), color_e.OtherConst))
      L.append(Field('codes', x0))

    if self.locs is not None:  # List
      x1 = hnode.Array([])
      for i1 in self.locs:
        h = (hnode.Leaf("_", color_e.OtherConst) if i1 is None else
             i1.AbbreviatedTree(trav=trav))
        x1.children.append(h)
      L.append(Field('locs', x1))

    return out_node

  def AbbreviatedTree(self, trav=None):
    # type: (Optional[TraversalState]) -> hnode_t
    return self._AbbreviatedTree(trav=trav)

class CommandStatus(pybase.CompoundObj):
  _type_tag = 72
  __slots__ = ('check_errexit', 'show_code', 'pipe_negated', 'pipe_status',
               'pipe_locs')

  def __init__(self, check_errexit, show_code, pipe_negated, pipe_status,
               pipe_locs):
    # type: (bool, bool, bool, Optional[List[int]], Optional[List[loc_t]]) -> None
    self.check_errexit = check_errexit
    self.show_code = show_code
    self.pipe_negated = pipe_negated
    self.pipe_status = pipe_status
    self.pipe_locs = pipe_locs

  @staticmethod
  def CreateNull(alloc_lists=False):
    # type: () -> CommandStatus
    return CommandStatus(False, False, False, cast('Optional[List[int]]', None), cast('Optional[List[loc_t]]', None))

  def PrettyTree(self, trav=None):
    # type: (Optional[TraversalState]) -> hnode_t
    trav = trav or TraversalState()
    heap_id = id(self)
    if heap_id in trav.seen:
      return hnode.AlreadySeen(heap_id)
    trav.seen[heap_id] = True
    out_node = NewRecord('CommandStatus')
    L = out_node.fields

    x0 = hnode.Leaf('T' if self.check_errexit else 'F', color_e.OtherConst)
    L.append(Field('check_errexit', x0))

    x1 = hnode.Leaf('T' if self.show_code else 'F', color_e.OtherConst)
    L.append(Field('show_code', x1))

    x2 = hnode.Leaf('T' if self.pipe_negated else 'F', color_e.OtherConst)
    L.append(Field('pipe_negated', x2))

    if self.pipe_status is not None:  # List
      x3 = hnode.Array([])
      for i3 in self.pipe_status:
        x3.children.append(hnode.Leaf(str(i3), color_e.OtherConst))
      L.append(Field('pipe_status', x3))

    if self.pipe_locs is not None:  # List
      x4 = hnode.Array([])
      for i4 in self.pipe_locs:
        h = (hnode.Leaf("_", color_e.OtherConst) if i4 is None else
             i4.PrettyTree(trav=trav))
        x4.children.append(h)
      L.append(Field('pipe_locs', x4))

    return out_node

  def _AbbreviatedTree(self, trav=None):
    # type: (Optional[TraversalState]) -> hnode_t
    trav = trav or TraversalState()
    heap_id = id(self)
    if heap_id in trav.seen:
      return hnode.AlreadySeen(heap_id)
    trav.seen[heap_id] = True
    out_node = NewRecord('CommandStatus')
    L = out_node.fields
    x0 = hnode.Leaf('T' if self.check_errexit else 'F', color_e.OtherConst)
    L.append(Field('check_errexit', x0))

    x1 = hnode.Leaf('T' if self.show_code else 'F', color_e.OtherConst)
    L.append(Field('show_code', x1))

    x2 = hnode.Leaf('T' if self.pipe_negated else 'F', color_e.OtherConst)
    L.append(Field('pipe_negated', x2))

    if self.pipe_status is not None:  # List
      x3 = hnode.Array([])
      for i3 in self.pipe_status:
        x3.children.append(hnode.Leaf(str(i3), color_e.OtherConst))
      L.append(Field('pipe_status', x3))

    if self.pipe_locs is not None:  # List
      x4 = hnode.Array([])
      for i4 in self.pipe_locs:
        h = (hnode.Leaf("_", color_e.OtherConst) if i4 is None else
             i4.AbbreviatedTree(trav=trav))
        x4.children.append(h)
      L.append(Field('pipe_locs', x4))

    return out_node

  def AbbreviatedTree(self, trav=None):
    # type: (Optional[TraversalState]) -> hnode_t
    return self._AbbreviatedTree(trav=trav)

class HayNode(pybase.CompoundObj):
  _type_tag = 73
  __slots__ = ('children',)

  def __init__(self, children):
    # type: (Dict[str, HayNode]) -> None
    self.children = children

  @staticmethod
  def CreateNull(alloc_lists=False):
    # type: () -> HayNode
    return HayNode(cast('Dict[str, HayNode]', None))

  def PrettyTree(self, trav=None):
    # type: (Optional[TraversalState]) -> hnode_t
    trav = trav or TraversalState()
    heap_id = id(self)
    if heap_id in trav.seen:
      return hnode.AlreadySeen(heap_id)
    trav.seen[heap_id] = True
    out_node = NewRecord('HayNode')
    L = out_node.fields

    if self.children is not None:  # Dict
      m = hnode.Leaf("Dict", color_e.OtherConst)
      x0 = hnode.Array([m])
      for k0, v0 in self.children.iteritems():
        x0.children.append(NewLeaf(k0, color_e.StringConst))
        x0.children.append(v0.PrettyTree(trav=trav))
      L.append(Field('children', x0))

    return out_node

  def _AbbreviatedTree(self, trav=None):
    # type: (Optional[TraversalState]) -> hnode_t
    trav = trav or TraversalState()
    heap_id = id(self)
    if heap_id in trav.seen:
      return hnode.AlreadySeen(heap_id)
    trav.seen[heap_id] = True
    out_node = NewRecord('HayNode')
    L = out_node.fields
    if self.children is not None:  # Dict
      m = hnode.Leaf("Dict", color_e.OtherConst)
      x0 = hnode.Array([m])
      for k0, v0 in self.children.iteritems():
        x0.children.append(NewLeaf(k0, color_e.StringConst))
        x0.children.append(v0.AbbreviatedTree(trav=trav))
      L.append(Field('children', x0))

    return out_node

  def AbbreviatedTree(self, trav=None):
    # type: (Optional[TraversalState]) -> hnode_t
    return self._AbbreviatedTree(trav=trav)

