#ifndef INCLUDED_DSP
#include "dsp.h"
#define INCLUDED_DSP
#endif


// Library headers.

// PCRaster library headers.

// Module headers.

/**
* Destructor
*/
DSP::~DSP(){
}


/**
* Constructor
*/
DSP::DSP() 
  {
}


void DSP::setDSP(size_t itmx, size_t mxup, size_t mxlow, size_t mxbw, size_t ifreq, double accl, double hclose, bool updated){
  d_itmx = itmx;
  d_mxup = mxup;
  d_mxlow = mxlow;
  d_mxbw = mxbw;
  d_ifreq = ifreq;
  d_mutd4 = 2;
  d_accl = accl;
  d_hclose = hclose;
  d_ipdr4 = 999;
  d_updated = updated;
}


bool DSP::modified() const {
  return d_updated;
}


void DSP::update() {
  d_updated = false;
}


std::ostream& operator<<(std::ostream& os, const DSP& dsp){
  os << "# Generated by PCRaster Modflow\n";
  os << dsp.d_itmx << " " << dsp.d_mxup << " " << dsp.d_mxlow  << " " << dsp.d_mxbw << "\n";
  os << dsp.d_ifreq << " " << dsp.d_mutd4 << " " << dsp.d_accl << " " << dsp.d_hclose << " " << dsp.d_ipdr4 << "\n";
  return os;
}
