<div itemscope itemtype="http://schema.org/Dataset">
  <div itemscope itemprop="includedInDataCatalog" itemtype="http://schema.org/DataCatalog">
    <meta itemprop="name" content="TensorFlow Datasets" />
  </div>
  <meta itemprop="name" content="rlu_atari_checkpoints" />
  <meta itemprop="description" content="RL Unplugged is suite of benchmarks for offline reinforcement learning. The RL&#10;Unplugged is designed around the following considerations: to facilitate ease of&#10;use, we provide the datasets with a unified API which makes it easy for the&#10;practitioner to work with all data in the suite once a general pipeline has been&#10;established.&#10;&#10;The datasets follow the [RLDS format](https://github.com/google-research/rlds)&#10;to represent steps and episodes.&#10;&#10;&#10;We are releasing a large and diverse dataset of gameplay following the protocol&#10;described by [Agarwal et al., 2020](https://arxiv.org/abs/1907.04543), which can&#10;be used to evaluate several discrete offline RL algorithms. The dataset is&#10;generated by running an online DQN agent and recording transitions from its&#10;replay during training with sticky actions&#10;[Machado et al., 2018](https://arxiv.org/abs/1709.06009). As stated in&#10;[Agarwal et al., 2020](https://arxiv.org/abs/1907.04543), for each game we use&#10;data from five runs with 50 million transitions each. We release datasets for 46&#10;Atari games. For details on how the dataset was generated, please refer to the&#10;paper.&#10;&#10;Atari is a standard RL benchmark. We recommend you to try offline RL methods on&#10;Atari if you are interested in comparing your approach to other state of the art&#10;offline RL methods with discrete actions.&#10;&#10;The reward of each step is clipped (obtained with [-1, 1] clipping) and the &#10;episode includes the sum of the clipped reward per episode.&#10;&#10;  Each of the configurations is broken into splits. Splits correspond to&#10;  checkpoints of 1M steps (note that the number of episodes may difer).&#10;  Checkpoints are ordered in time (so checkpoint 0 ran before checkpoint 1).&#10;&#10;To use this dataset:&#10;&#10;```python&#10;import tensorflow_datasets as tfds&#10;&#10;ds = tfds.load(&#x27;rlu_atari_checkpoints&#x27;, split=&#x27;train&#x27;)&#10;for ex in ds.take(4):&#10;  print(ex)&#10;```&#10;&#10;See [the guide](https://www.tensorflow.org/datasets/overview) for more&#10;informations on [tensorflow_datasets](https://www.tensorflow.org/datasets).&#10;&#10;" />
  <meta itemprop="url" content="https://www.tensorflow.org/datasets/catalog/rlu_atari_checkpoints" />
  <meta itemprop="sameAs" content="https://github.com/deepmind/deepmind-research/tree/master/rl_unplugged" />
  <meta itemprop="citation" content="@misc{gulcehre2020rl,&#10;    title={RL Unplugged: Benchmarks for Offline Reinforcement Learning},&#10;    author={Caglar Gulcehre and Ziyu Wang and Alexander Novikov and Tom Le Paine&#10;        and  Sergio Gómez Colmenarejo and Konrad Zolna and Rishabh Agarwal and&#10;        Josh Merel and Daniel Mankowitz and Cosmin Paduraru and Gabriel&#10;        Dulac-Arnold and Jerry Li and Mohammad Norouzi and Matt Hoffman and&#10;        Ofir Nachum and George Tucker and Nicolas Heess and Nando deFreitas},&#10;    year={2020},&#10;    eprint={2006.13888},&#10;    archivePrefix={arXiv},&#10;    primaryClass={cs.LG}&#10;}" />
</div>

# `rlu_atari_checkpoints`


*   **Description**:

RL Unplugged is suite of benchmarks for offline reinforcement learning. The RL
Unplugged is designed around the following considerations: to facilitate ease of
use, we provide the datasets with a unified API which makes it easy for the
practitioner to work with all data in the suite once a general pipeline has been
established.

The datasets follow the [RLDS format](https://github.com/google-research/rlds)
to represent steps and episodes.

We are releasing a large and diverse dataset of gameplay following the protocol
described by [Agarwal et al., 2020](https://arxiv.org/abs/1907.04543), which can
be used to evaluate several discrete offline RL algorithms. The dataset is
generated by running an online DQN agent and recording transitions from its
replay during training with sticky actions
[Machado et al., 2018](https://arxiv.org/abs/1709.06009). As stated in
[Agarwal et al., 2020](https://arxiv.org/abs/1907.04543), for each game we use
data from five runs with 50 million transitions each. We release datasets for 46
Atari games. For details on how the dataset was generated, please refer to the
paper.

Atari is a standard RL benchmark. We recommend you to try offline RL methods on
Atari if you are interested in comparing your approach to other state of the art
offline RL methods with discrete actions.

The reward of each step is clipped (obtained with [-1, 1] clipping) and the
episode includes the sum of the clipped reward per episode.

Each of the configurations is broken into splits. Splits correspond to
checkpoints of 1M steps (note that the number of episodes may difer).
Checkpoints are ordered in time (so checkpoint 0 ran before checkpoint 1).

*   **Homepage**:
    [https://github.com/deepmind/deepmind-research/tree/master/rl_unplugged](https://github.com/deepmind/deepmind-research/tree/master/rl_unplugged)

*   **Source code**:
    [`tfds.rl_unplugged.rlu_atari_checkpoints.RluAtariCheckpoints`](https://github.com/tensorflow/datasets/tree/master/tensorflow_datasets/rl_unplugged/rlu_atari_checkpoints/rlu_atari_checkpoints.py)

*   **Versions**:

    *   `1.0.0`: Initial release.
    *   **`1.1.0`** (default): Removed redundant clipped reward fields.

*   **Download size**: `Unknown size`

*   **Auto-cached**
    ([documentation](https://www.tensorflow.org/datasets/performances#auto-caching)):
    No

*   **Feature structure**:

```python
FeaturesDict({
    'checkpoint_id': int64,
    'episode_id': int64,
    'episode_return': Scalar(shape=(), dtype=float32),
    'steps': Dataset({
        'action': int64,
        'discount': float32,
        'is_first': bool,
        'is_last': bool,
        'is_terminal': bool,
        'observation': Image(shape=(84, 84, 1), dtype=uint8),
        'reward': Scalar(shape=(), dtype=float32),
    }),
})
```

*   **Feature documentation**:

| Feature           | Class        | Shape  | Dtype   | Description | Value   |
:                   :              :        :         :             : range   :
| :---------------- | :----------- | :----- | :------ | :---------- | :------ |
|                   | FeaturesDict |        |         |             |         |
| checkpoint_id     | Tensor       |        | int64   |             |         |
| episode_id        | Tensor       |        | int64   |             |         |
| episode_return    | Scalar       |        | float32 | Sum of the  |         |
:                   :              :        :         : clipped     :         :
:                   :              :        :         : rewards.    :         :
| steps             | Dataset      |        |         |             |         |
| steps/action      | Tensor       |        | int64   |             |         |
| steps/discount    | Tensor       |        | float32 |             |         |
| steps/is_first    | Tensor       |        | bool    |             |         |
| steps/is_last     | Tensor       |        | bool    |             |         |
| steps/is_terminal | Tensor       |        | bool    |             |         |
| steps/observation | Image        | (84,   | uint8   |             |         |
:                   :              : 84, 1) :         :             :         :
| steps/reward      | Scalar       |        | float32 | Clipped     | [-1, 1] |
:                   :              :        :         : reward.     :         :

*   **Supervised keys** (See
    [`as_supervised` doc](https://www.tensorflow.org/datasets/api_docs/python/tfds/load#args)):
    `None`

*   **Figure**
    ([tfds.show_examples](https://www.tensorflow.org/datasets/api_docs/python/tfds/visualization/show_examples)):
    Not supported.

*   **Citation**:

```
@misc{gulcehre2020rl,
    title={RL Unplugged: Benchmarks for Offline Reinforcement Learning},
    author={Caglar Gulcehre and Ziyu Wang and Alexander Novikov and Tom Le Paine
        and  Sergio Gómez Colmenarejo and Konrad Zolna and Rishabh Agarwal and
        Josh Merel and Daniel Mankowitz and Cosmin Paduraru and Gabriel
        Dulac-Arnold and Jerry Li and Mohammad Norouzi and Matt Hoffman and
        Ofir Nachum and George Tucker and Nicolas Heess and Nando deFreitas},
    year={2020},
    eprint={2006.13888},
    archivePrefix={arXiv},
    primaryClass={cs.LG}
}
```


## rlu_atari_checkpoints/Alien_run_1 (default config)

*   **Dataset size**: `73.90 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 1,581
`'checkpoint_01'` | 1,508
`'checkpoint_02'` | 1,485
`'checkpoint_03'` | 1,363
`'checkpoint_04'` | 1,308
`'checkpoint_05'` | 1,315
`'checkpoint_06'` | 1,294
`'checkpoint_07'` | 1,292
`'checkpoint_08'` | 1,280
`'checkpoint_09'` | 1,264
`'checkpoint_10'` | 1,229
`'checkpoint_11'` | 1,212
`'checkpoint_12'` | 1,198
`'checkpoint_13'` | 1,202
`'checkpoint_14'` | 1,211
`'checkpoint_15'` | 1,186
`'checkpoint_16'` | 1,185
`'checkpoint_17'` | 1,184
`'checkpoint_18'` | 1,183
`'checkpoint_19'` | 1,171
`'checkpoint_20'` | 1,136
`'checkpoint_21'` | 1,105
`'checkpoint_22'` | 1,096
`'checkpoint_23'` | 1,089
`'checkpoint_24'` | 1,095
`'checkpoint_25'` | 1,035
`'checkpoint_26'` | 1,075
`'checkpoint_27'` | 1,016
`'checkpoint_28'` | 1,027
`'checkpoint_29'` | 1,004
`'checkpoint_30'` | 1,008
`'checkpoint_31'` | 1,025
`'checkpoint_32'` | 1,096
`'checkpoint_33'` | 1,066
`'checkpoint_34'` | 1,063
`'checkpoint_35'` | 1,000
`'checkpoint_36'` | 993
`'checkpoint_37'` | 984
`'checkpoint_38'` | 974
`'checkpoint_39'` | 960
`'checkpoint_40'` | 944
`'checkpoint_41'` | 959
`'checkpoint_42'` | 959
`'checkpoint_43'` | 949
`'checkpoint_44'` | 963
`'checkpoint_45'` | 949
`'checkpoint_46'` | 952
`'checkpoint_47'` | 912
`'checkpoint_48'` | 918
`'checkpoint_49'` | 942

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):

<!-- mdformat off(HTML should not be auto-formatted) -->

{% framebox %}

<button id="displaydataframe">Display examples...</button>
<div id="dataframecontent" style="overflow-x:auto"></div>
<script>
const url = "https://storage.googleapis.com/tfds-data/visualization/dataframe/rlu_atari_checkpoints-Alien_run_1-1.1.0.html";
const dataButton = document.getElementById('displaydataframe');
dataButton.addEventListener('click', async () => {
  // Disable the button after clicking (dataframe loaded only once).
  dataButton.disabled = true;

  const contentPane = document.getElementById('dataframecontent');
  try {
    const response = await fetch(url);
    // Error response codes don't throw an error, so force an error to show
    // the error message.
    if (!response.ok) throw Error(response.statusText);

    const data = await response.text();
    contentPane.innerHTML = data;
  } catch (e) {
    contentPane.innerHTML =
        'Error loading examples. If the error persist, please open '
        + 'a new issue.';
  }
});
</script>

{% endframebox %}

<!-- mdformat on -->

## rlu_atari_checkpoints/Alien_run_2

*   **Dataset size**: `74.13 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 1,592
`'checkpoint_01'` | 1,541
`'checkpoint_02'` | 1,536
`'checkpoint_03'` | 1,369
`'checkpoint_04'` | 1,260
`'checkpoint_05'` | 1,240
`'checkpoint_06'` | 1,212
`'checkpoint_07'` | 1,204
`'checkpoint_08'` | 1,173
`'checkpoint_09'` | 1,225
`'checkpoint_10'` | 1,196
`'checkpoint_11'` | 1,157
`'checkpoint_12'` | 1,123
`'checkpoint_13'` | 1,113
`'checkpoint_14'` | 1,039
`'checkpoint_15'` | 1,030
`'checkpoint_16'` | 992
`'checkpoint_17'` | 974
`'checkpoint_18'` | 972
`'checkpoint_19'` | 1,039
`'checkpoint_20'` | 1,059
`'checkpoint_21'` | 995
`'checkpoint_22'` | 990
`'checkpoint_23'` | 964
`'checkpoint_24'` | 955
`'checkpoint_25'` | 946
`'checkpoint_26'` | 926
`'checkpoint_27'` | 931
`'checkpoint_28'` | 912
`'checkpoint_29'` | 904
`'checkpoint_30'` | 878
`'checkpoint_31'` | 901
`'checkpoint_32'` | 863
`'checkpoint_33'` | 864
`'checkpoint_34'` | 835
`'checkpoint_35'` | 852
`'checkpoint_36'` | 849
`'checkpoint_37'` | 851
`'checkpoint_38'` | 850
`'checkpoint_39'` | 840
`'checkpoint_40'` | 828
`'checkpoint_41'` | 831
`'checkpoint_42'` | 833
`'checkpoint_43'` | 828
`'checkpoint_44'` | 808
`'checkpoint_45'` | 802
`'checkpoint_46'` | 814
`'checkpoint_47'` | 812
`'checkpoint_48'` | 822
`'checkpoint_49'` | 823

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):

<!-- mdformat off(HTML should not be auto-formatted) -->

{% framebox %}

<button id="displaydataframe">Display examples...</button>
<div id="dataframecontent" style="overflow-x:auto"></div>
<script>
const url = "https://storage.googleapis.com/tfds-data/visualization/dataframe/rlu_atari_checkpoints-Alien_run_2-1.1.0.html";
const dataButton = document.getElementById('displaydataframe');
dataButton.addEventListener('click', async () => {
  // Disable the button after clicking (dataframe loaded only once).
  dataButton.disabled = true;

  const contentPane = document.getElementById('dataframecontent');
  try {
    const response = await fetch(url);
    // Error response codes don't throw an error, so force an error to show
    // the error message.
    if (!response.ok) throw Error(response.statusText);

    const data = await response.text();
    contentPane.innerHTML = data;
  } catch (e) {
    contentPane.innerHTML =
        'Error loading examples. If the error persist, please open '
        + 'a new issue.';
  }
});
</script>

{% endframebox %}

<!-- mdformat on -->

## rlu_atari_checkpoints/Alien_run_3

*   **Dataset size**: `74.02 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 1,624
`'checkpoint_01'` | 1,483
`'checkpoint_02'` | 1,481
`'checkpoint_03'` | 1,401
`'checkpoint_04'` | 1,291
`'checkpoint_05'` | 1,267
`'checkpoint_06'` | 1,202
`'checkpoint_07'` | 1,252
`'checkpoint_08'` | 1,182
`'checkpoint_09'` | 1,169
`'checkpoint_10'` | 1,156
`'checkpoint_11'` | 1,163
`'checkpoint_12'` | 1,122
`'checkpoint_13'` | 1,141
`'checkpoint_14'` | 1,095
`'checkpoint_15'` | 1,104
`'checkpoint_16'` | 1,100
`'checkpoint_17'` | 1,137
`'checkpoint_18'` | 1,156
`'checkpoint_19'` | 1,111
`'checkpoint_20'` | 1,066
`'checkpoint_21'` | 1,077
`'checkpoint_22'` | 1,085
`'checkpoint_23'` | 1,027
`'checkpoint_24'` | 1,034
`'checkpoint_25'` | 1,054
`'checkpoint_26'` | 1,017
`'checkpoint_27'` | 1,021
`'checkpoint_28'` | 1,006
`'checkpoint_29'` | 1,003
`'checkpoint_30'` | 969
`'checkpoint_31'` | 974
`'checkpoint_32'` | 971
`'checkpoint_33'` | 945
`'checkpoint_34'` | 925
`'checkpoint_35'` | 919
`'checkpoint_36'` | 917
`'checkpoint_37'` | 908
`'checkpoint_38'` | 920
`'checkpoint_39'` | 893
`'checkpoint_40'` | 905
`'checkpoint_41'` | 898
`'checkpoint_42'` | 883
`'checkpoint_43'` | 893
`'checkpoint_44'` | 883
`'checkpoint_45'` | 885
`'checkpoint_46'` | 893
`'checkpoint_47'` | 860
`'checkpoint_48'` | 875
`'checkpoint_49'` | 851

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):

<!-- mdformat off(HTML should not be auto-formatted) -->

{% framebox %}

<button id="displaydataframe">Display examples...</button>
<div id="dataframecontent" style="overflow-x:auto"></div>
<script>
const url = "https://storage.googleapis.com/tfds-data/visualization/dataframe/rlu_atari_checkpoints-Alien_run_3-1.1.0.html";
const dataButton = document.getElementById('displaydataframe');
dataButton.addEventListener('click', async () => {
  // Disable the button after clicking (dataframe loaded only once).
  dataButton.disabled = true;

  const contentPane = document.getElementById('dataframecontent');
  try {
    const response = await fetch(url);
    // Error response codes don't throw an error, so force an error to show
    // the error message.
    if (!response.ok) throw Error(response.statusText);

    const data = await response.text();
    contentPane.innerHTML = data;
  } catch (e) {
    contentPane.innerHTML =
        'Error loading examples. If the error persist, please open '
        + 'a new issue.';
  }
});
</script>

{% endframebox %}

<!-- mdformat on -->

## rlu_atari_checkpoints/Alien_run_4

*   **Dataset size**: `74.43 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 1,573
`'checkpoint_01'` | 1,466
`'checkpoint_02'` | 1,512
`'checkpoint_03'` | 1,385
`'checkpoint_04'` | 1,288
`'checkpoint_05'` | 1,307
`'checkpoint_06'` | 1,293
`'checkpoint_07'` | 1,262
`'checkpoint_08'` | 1,218
`'checkpoint_09'` | 1,160
`'checkpoint_10'` | 1,176
`'checkpoint_11'` | 1,154
`'checkpoint_12'` | 1,149
`'checkpoint_13'` | 1,147
`'checkpoint_14'` | 1,129
`'checkpoint_15'` | 1,097
`'checkpoint_16'` | 1,092
`'checkpoint_17'` | 1,089
`'checkpoint_18'` | 1,107
`'checkpoint_19'` | 1,088
`'checkpoint_20'` | 1,100
`'checkpoint_21'` | 1,091
`'checkpoint_22'` | 1,057
`'checkpoint_23'` | 1,062
`'checkpoint_24'` | 1,032
`'checkpoint_25'` | 1,039
`'checkpoint_26'` | 1,022
`'checkpoint_27'` | 1,004
`'checkpoint_28'` | 997
`'checkpoint_29'` | 985
`'checkpoint_30'` | 1,007
`'checkpoint_31'` | 981
`'checkpoint_32'` | 1,028
`'checkpoint_33'` | 1,018
`'checkpoint_34'` | 994
`'checkpoint_35'` | 988
`'checkpoint_36'` | 992
`'checkpoint_37'` | 1,011
`'checkpoint_38'` | 988
`'checkpoint_39'` | 1,003
`'checkpoint_40'` | 997
`'checkpoint_41'` | 1,005
`'checkpoint_42'` | 1,031
`'checkpoint_43'` | 1,020
`'checkpoint_44'` | 1,038
`'checkpoint_45'` | 1,046
`'checkpoint_46'` | 1,009
`'checkpoint_47'` | 1,046
`'checkpoint_48'` | 1,064
`'checkpoint_49'` | 1,058

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):

<!-- mdformat off(HTML should not be auto-formatted) -->

{% framebox %}

<button id="displaydataframe">Display examples...</button>
<div id="dataframecontent" style="overflow-x:auto"></div>
<script>
const url = "https://storage.googleapis.com/tfds-data/visualization/dataframe/rlu_atari_checkpoints-Alien_run_4-1.1.0.html";
const dataButton = document.getElementById('displaydataframe');
dataButton.addEventListener('click', async () => {
  // Disable the button after clicking (dataframe loaded only once).
  dataButton.disabled = true;

  const contentPane = document.getElementById('dataframecontent');
  try {
    const response = await fetch(url);
    // Error response codes don't throw an error, so force an error to show
    // the error message.
    if (!response.ok) throw Error(response.statusText);

    const data = await response.text();
    contentPane.innerHTML = data;
  } catch (e) {
    contentPane.innerHTML =
        'Error loading examples. If the error persist, please open '
        + 'a new issue.';
  }
});
</script>

{% endframebox %}

<!-- mdformat on -->

## rlu_atari_checkpoints/Alien_run_5

*   **Dataset size**: `74.09 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 1,587
`'checkpoint_01'` | 1,526
`'checkpoint_02'` | 1,490
`'checkpoint_03'` | 1,400
`'checkpoint_04'` | 1,301
`'checkpoint_05'` | 1,281
`'checkpoint_06'` | 1,287
`'checkpoint_07'` | 1,228
`'checkpoint_08'` | 1,195
`'checkpoint_09'` | 1,183
`'checkpoint_10'` | 1,172
`'checkpoint_11'` | 1,161
`'checkpoint_12'` | 1,145
`'checkpoint_13'` | 1,146
`'checkpoint_14'` | 1,133
`'checkpoint_15'` | 1,128
`'checkpoint_16'` | 1,121
`'checkpoint_17'` | 1,098
`'checkpoint_18'` | 1,100
`'checkpoint_19'` | 1,095
`'checkpoint_20'` | 1,064
`'checkpoint_21'` | 1,111
`'checkpoint_22'` | 1,094
`'checkpoint_23'` | 1,084
`'checkpoint_24'` | 1,087
`'checkpoint_25'` | 1,045
`'checkpoint_26'` | 1,038
`'checkpoint_27'` | 1,043
`'checkpoint_28'` | 1,024
`'checkpoint_29'` | 1,033
`'checkpoint_30'` | 1,025
`'checkpoint_31'` | 1,027
`'checkpoint_32'` | 1,006
`'checkpoint_33'` | 996
`'checkpoint_34'` | 980
`'checkpoint_35'` | 982
`'checkpoint_36'` | 968
`'checkpoint_37'` | 986
`'checkpoint_38'` | 979
`'checkpoint_39'` | 970
`'checkpoint_40'` | 970
`'checkpoint_41'` | 967
`'checkpoint_42'` | 976
`'checkpoint_43'` | 970
`'checkpoint_44'` | 969
`'checkpoint_45'` | 950
`'checkpoint_46'` | 924
`'checkpoint_47'` | 943
`'checkpoint_48'` | 909
`'checkpoint_49'` | 939

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):

<!-- mdformat off(HTML should not be auto-formatted) -->

{% framebox %}

<button id="displaydataframe">Display examples...</button>
<div id="dataframecontent" style="overflow-x:auto"></div>
<script>
const url = "https://storage.googleapis.com/tfds-data/visualization/dataframe/rlu_atari_checkpoints-Alien_run_5-1.1.0.html";
const dataButton = document.getElementById('displaydataframe');
dataButton.addEventListener('click', async () => {
  // Disable the button after clicking (dataframe loaded only once).
  dataButton.disabled = true;

  const contentPane = document.getElementById('dataframecontent');
  try {
    const response = await fetch(url);
    // Error response codes don't throw an error, so force an error to show
    // the error message.
    if (!response.ok) throw Error(response.statusText);

    const data = await response.text();
    contentPane.innerHTML = data;
  } catch (e) {
    contentPane.innerHTML =
        'Error loading examples. If the error persist, please open '
        + 'a new issue.';
  }
});
</script>

{% endframebox %}

<!-- mdformat on -->

## rlu_atari_checkpoints/Amidar_run_1

*   **Dataset size**: `76.91 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 1,345
`'checkpoint_01'` | 903
`'checkpoint_02'` | 739
`'checkpoint_03'` | 610
`'checkpoint_04'` | 598
`'checkpoint_05'` | 554
`'checkpoint_06'` | 572
`'checkpoint_07'` | 549
`'checkpoint_08'` | 497
`'checkpoint_09'` | 491
`'checkpoint_10'` | 485
`'checkpoint_11'` | 491
`'checkpoint_12'` | 469
`'checkpoint_13'` | 456
`'checkpoint_14'` | 444
`'checkpoint_15'` | 429
`'checkpoint_16'` | 428
`'checkpoint_17'` | 430
`'checkpoint_18'` | 426
`'checkpoint_19'` | 433
`'checkpoint_20'` | 448
`'checkpoint_21'` | 459
`'checkpoint_22'` | 454
`'checkpoint_23'` | 427
`'checkpoint_24'` | 428
`'checkpoint_25'` | 448
`'checkpoint_26'` | 446
`'checkpoint_27'` | 438
`'checkpoint_28'` | 424
`'checkpoint_29'` | 407
`'checkpoint_30'` | 394
`'checkpoint_31'` | 383
`'checkpoint_32'` | 414
`'checkpoint_33'` | 393
`'checkpoint_34'` | 381
`'checkpoint_35'` | 375
`'checkpoint_36'` | 379
`'checkpoint_37'` | 370
`'checkpoint_38'` | 356
`'checkpoint_39'` | 359
`'checkpoint_40'` | 363
`'checkpoint_41'` | 351
`'checkpoint_42'` | 360
`'checkpoint_43'` | 359
`'checkpoint_44'` | 369
`'checkpoint_45'` | 356
`'checkpoint_46'` | 370
`'checkpoint_47'` | 362
`'checkpoint_48'` | 365
`'checkpoint_49'` | 366

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):

<!-- mdformat off(HTML should not be auto-formatted) -->

{% framebox %}

<button id="displaydataframe">Display examples...</button>
<div id="dataframecontent" style="overflow-x:auto"></div>
<script>
const url = "https://storage.googleapis.com/tfds-data/visualization/dataframe/rlu_atari_checkpoints-Amidar_run_1-1.1.0.html";
const dataButton = document.getElementById('displaydataframe');
dataButton.addEventListener('click', async () => {
  // Disable the button after clicking (dataframe loaded only once).
  dataButton.disabled = true;

  const contentPane = document.getElementById('dataframecontent');
  try {
    const response = await fetch(url);
    // Error response codes don't throw an error, so force an error to show
    // the error message.
    if (!response.ok) throw Error(response.statusText);

    const data = await response.text();
    contentPane.innerHTML = data;
  } catch (e) {
    contentPane.innerHTML =
        'Error loading examples. If the error persist, please open '
        + 'a new issue.';
  }
});
</script>

{% endframebox %}

<!-- mdformat on -->

## rlu_atari_checkpoints/Amidar_run_2

*   **Dataset size**: `76.70 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 1,291
`'checkpoint_01'` | 903
`'checkpoint_02'` | 782
`'checkpoint_03'` | 717
`'checkpoint_04'` | 632
`'checkpoint_05'` | 572
`'checkpoint_06'` | 551
`'checkpoint_07'` | 526
`'checkpoint_08'` | 496
`'checkpoint_09'` | 517
`'checkpoint_10'` | 504
`'checkpoint_11'` | 497
`'checkpoint_12'` | 491
`'checkpoint_13'` | 486
`'checkpoint_14'` | 491
`'checkpoint_15'` | 470
`'checkpoint_16'` | 458
`'checkpoint_17'` | 463
`'checkpoint_18'` | 453
`'checkpoint_19'` | 409
`'checkpoint_20'` | 417
`'checkpoint_21'` | 408
`'checkpoint_22'` | 392
`'checkpoint_23'` | 390
`'checkpoint_24'` | 372
`'checkpoint_25'` | 370
`'checkpoint_26'` | 373
`'checkpoint_27'` | 369
`'checkpoint_28'` | 382
`'checkpoint_29'` | 376
`'checkpoint_30'` | 360
`'checkpoint_31'` | 371
`'checkpoint_32'` | 355
`'checkpoint_33'` | 383
`'checkpoint_34'` | 381
`'checkpoint_35'` | 384
`'checkpoint_36'` | 389
`'checkpoint_37'` | 389
`'checkpoint_38'` | 378
`'checkpoint_39'` | 350
`'checkpoint_40'` | 349
`'checkpoint_41'` | 364
`'checkpoint_42'` | 344
`'checkpoint_43'` | 334
`'checkpoint_44'` | 340
`'checkpoint_45'` | 333
`'checkpoint_46'` | 335
`'checkpoint_47'` | 329
`'checkpoint_48'` | 343
`'checkpoint_49'` | 344

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):

<!-- mdformat off(HTML should not be auto-formatted) -->

{% framebox %}

<button id="displaydataframe">Display examples...</button>
<div id="dataframecontent" style="overflow-x:auto"></div>
<script>
const url = "https://storage.googleapis.com/tfds-data/visualization/dataframe/rlu_atari_checkpoints-Amidar_run_2-1.1.0.html";
const dataButton = document.getElementById('displaydataframe');
dataButton.addEventListener('click', async () => {
  // Disable the button after clicking (dataframe loaded only once).
  dataButton.disabled = true;

  const contentPane = document.getElementById('dataframecontent');
  try {
    const response = await fetch(url);
    // Error response codes don't throw an error, so force an error to show
    // the error message.
    if (!response.ok) throw Error(response.statusText);

    const data = await response.text();
    contentPane.innerHTML = data;
  } catch (e) {
    contentPane.innerHTML =
        'Error loading examples. If the error persist, please open '
        + 'a new issue.';
  }
});
</script>

{% endframebox %}

<!-- mdformat on -->

## rlu_atari_checkpoints/Amidar_run_3

*   **Dataset size**: `77.03 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 1,321
`'checkpoint_01'` | 932
`'checkpoint_02'` | 790
`'checkpoint_03'` | 687
`'checkpoint_04'` | 619
`'checkpoint_05'` | 607
`'checkpoint_06'` | 603
`'checkpoint_07'` | 546
`'checkpoint_08'` | 544
`'checkpoint_09'` | 528
`'checkpoint_10'` | 528
`'checkpoint_11'` | 529
`'checkpoint_12'` | 503
`'checkpoint_13'` | 499
`'checkpoint_14'` | 485
`'checkpoint_15'` | 480
`'checkpoint_16'` | 487
`'checkpoint_17'` | 472
`'checkpoint_18'` | 467
`'checkpoint_19'` | 466
`'checkpoint_20'` | 473
`'checkpoint_21'` | 471
`'checkpoint_22'` | 479
`'checkpoint_23'` | 480
`'checkpoint_24'` | 506
`'checkpoint_25'` | 476
`'checkpoint_26'` | 475
`'checkpoint_27'` | 483
`'checkpoint_28'` | 508
`'checkpoint_29'` | 533
`'checkpoint_30'` | 645
`'checkpoint_31'` | 650
`'checkpoint_32'` | 631
`'checkpoint_33'` | 626
`'checkpoint_34'` | 598
`'checkpoint_35'` | 559
`'checkpoint_36'` | 546
`'checkpoint_37'` | 534
`'checkpoint_38'` | 545
`'checkpoint_39'` | 543
`'checkpoint_40'` | 531
`'checkpoint_41'` | 529
`'checkpoint_42'` | 530
`'checkpoint_43'` | 535
`'checkpoint_44'` | 523
`'checkpoint_45'` | 511
`'checkpoint_46'` | 509
`'checkpoint_47'` | 517
`'checkpoint_48'` | 504
`'checkpoint_49'` | 507

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):

<!-- mdformat off(HTML should not be auto-formatted) -->

{% framebox %}

<button id="displaydataframe">Display examples...</button>
<div id="dataframecontent" style="overflow-x:auto"></div>
<script>
const url = "https://storage.googleapis.com/tfds-data/visualization/dataframe/rlu_atari_checkpoints-Amidar_run_3-1.1.0.html";
const dataButton = document.getElementById('displaydataframe');
dataButton.addEventListener('click', async () => {
  // Disable the button after clicking (dataframe loaded only once).
  dataButton.disabled = true;

  const contentPane = document.getElementById('dataframecontent');
  try {
    const response = await fetch(url);
    // Error response codes don't throw an error, so force an error to show
    // the error message.
    if (!response.ok) throw Error(response.statusText);

    const data = await response.text();
    contentPane.innerHTML = data;
  } catch (e) {
    contentPane.innerHTML =
        'Error loading examples. If the error persist, please open '
        + 'a new issue.';
  }
});
</script>

{% endframebox %}

<!-- mdformat on -->

## rlu_atari_checkpoints/Amidar_run_4

*   **Dataset size**: `77.16 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 1,253
`'checkpoint_01'` | 1,001
`'checkpoint_02'` | 647
`'checkpoint_03'` | 591
`'checkpoint_04'` | 600
`'checkpoint_05'` | 601
`'checkpoint_06'` | 558
`'checkpoint_07'` | 541
`'checkpoint_08'` | 513
`'checkpoint_09'` | 517
`'checkpoint_10'` | 512
`'checkpoint_11'` | 511
`'checkpoint_12'` | 503
`'checkpoint_13'` | 491
`'checkpoint_14'` | 498
`'checkpoint_15'` | 506
`'checkpoint_16'` | 508
`'checkpoint_17'` | 510
`'checkpoint_18'` | 498
`'checkpoint_19'` | 492
`'checkpoint_20'` | 501
`'checkpoint_21'` | 498
`'checkpoint_22'` | 488
`'checkpoint_23'` | 521
`'checkpoint_24'` | 487
`'checkpoint_25'` | 490
`'checkpoint_26'` | 485
`'checkpoint_27'` | 480
`'checkpoint_28'` | 473
`'checkpoint_29'` | 468
`'checkpoint_30'` | 469
`'checkpoint_31'` | 484
`'checkpoint_32'` | 460
`'checkpoint_33'` | 492
`'checkpoint_34'` | 520
`'checkpoint_35'` | 478
`'checkpoint_36'` | 524
`'checkpoint_37'` | 538
`'checkpoint_38'` | 509
`'checkpoint_39'` | 552
`'checkpoint_40'` | 570
`'checkpoint_41'` | 540
`'checkpoint_42'` | 560
`'checkpoint_43'` | 516
`'checkpoint_44'` | 498
`'checkpoint_45'` | 477
`'checkpoint_46'` | 445
`'checkpoint_47'` | 452
`'checkpoint_48'` | 441
`'checkpoint_49'` | 449

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):

<!-- mdformat off(HTML should not be auto-formatted) -->

{% framebox %}

<button id="displaydataframe">Display examples...</button>
<div id="dataframecontent" style="overflow-x:auto"></div>
<script>
const url = "https://storage.googleapis.com/tfds-data/visualization/dataframe/rlu_atari_checkpoints-Amidar_run_4-1.1.0.html";
const dataButton = document.getElementById('displaydataframe');
dataButton.addEventListener('click', async () => {
  // Disable the button after clicking (dataframe loaded only once).
  dataButton.disabled = true;

  const contentPane = document.getElementById('dataframecontent');
  try {
    const response = await fetch(url);
    // Error response codes don't throw an error, so force an error to show
    // the error message.
    if (!response.ok) throw Error(response.statusText);

    const data = await response.text();
    contentPane.innerHTML = data;
  } catch (e) {
    contentPane.innerHTML =
        'Error loading examples. If the error persist, please open '
        + 'a new issue.';
  }
});
</script>

{% endframebox %}

<!-- mdformat on -->

## rlu_atari_checkpoints/Amidar_run_5

*   **Dataset size**: `77.42 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 1,271
`'checkpoint_01'` | 970
`'checkpoint_02'` | 775
`'checkpoint_03'` | 673
`'checkpoint_04'` | 603
`'checkpoint_05'` | 580
`'checkpoint_06'` | 571
`'checkpoint_07'` | 539
`'checkpoint_08'` | 520
`'checkpoint_09'` | 515
`'checkpoint_10'` | 525
`'checkpoint_11'` | 525
`'checkpoint_12'` | 515
`'checkpoint_13'` | 509
`'checkpoint_14'` | 494
`'checkpoint_15'` | 474
`'checkpoint_16'` | 468
`'checkpoint_17'` | 466
`'checkpoint_18'` | 449
`'checkpoint_19'` | 456
`'checkpoint_20'` | 439
`'checkpoint_21'` | 424
`'checkpoint_22'` | 443
`'checkpoint_23'` | 458
`'checkpoint_24'` | 447
`'checkpoint_25'` | 439
`'checkpoint_26'` | 444
`'checkpoint_27'` | 429
`'checkpoint_28'` | 413
`'checkpoint_29'` | 431
`'checkpoint_30'` | 428
`'checkpoint_31'` | 428
`'checkpoint_32'` | 404
`'checkpoint_33'` | 389
`'checkpoint_34'` | 412
`'checkpoint_35'` | 411
`'checkpoint_36'` | 408
`'checkpoint_37'` | 413
`'checkpoint_38'` | 429
`'checkpoint_39'` | 467
`'checkpoint_40'` | 536
`'checkpoint_41'` | 542
`'checkpoint_42'` | 587
`'checkpoint_43'` | 590
`'checkpoint_44'` | 572
`'checkpoint_45'` | 572
`'checkpoint_46'` | 541
`'checkpoint_47'` | 544
`'checkpoint_48'` | 550
`'checkpoint_49'` | 539

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):

<!-- mdformat off(HTML should not be auto-formatted) -->

{% framebox %}

<button id="displaydataframe">Display examples...</button>
<div id="dataframecontent" style="overflow-x:auto"></div>
<script>
const url = "https://storage.googleapis.com/tfds-data/visualization/dataframe/rlu_atari_checkpoints-Amidar_run_5-1.1.0.html";
const dataButton = document.getElementById('displaydataframe');
dataButton.addEventListener('click', async () => {
  // Disable the button after clicking (dataframe loaded only once).
  dataButton.disabled = true;

  const contentPane = document.getElementById('dataframecontent');
  try {
    const response = await fetch(url);
    // Error response codes don't throw an error, so force an error to show
    // the error message.
    if (!response.ok) throw Error(response.statusText);

    const data = await response.text();
    contentPane.innerHTML = data;
  } catch (e) {
    contentPane.innerHTML =
        'Error loading examples. If the error persist, please open '
        + 'a new issue.';
  }
});
</script>

{% endframebox %}

<!-- mdformat on -->

## rlu_atari_checkpoints/Assault_run_1

*   **Dataset size**: `28.70 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 1,522
`'checkpoint_01'` | 1,269
`'checkpoint_02'` | 1,100
`'checkpoint_03'` | 1,007
`'checkpoint_04'` | 978
`'checkpoint_05'` | 922
`'checkpoint_06'` | 813
`'checkpoint_07'` | 812
`'checkpoint_08'` | 831
`'checkpoint_09'` | 848
`'checkpoint_10'` | 835
`'checkpoint_11'` | 864
`'checkpoint_12'` | 853
`'checkpoint_13'` | 873
`'checkpoint_14'` | 842
`'checkpoint_15'` | 845
`'checkpoint_16'` | 838
`'checkpoint_17'` | 850
`'checkpoint_18'` | 876
`'checkpoint_19'` | 869
`'checkpoint_20'` | 848
`'checkpoint_21'` | 871
`'checkpoint_22'` | 877
`'checkpoint_23'` | 858
`'checkpoint_24'` | 861
`'checkpoint_25'` | 821
`'checkpoint_26'` | 833
`'checkpoint_27'` | 864
`'checkpoint_28'` | 851
`'checkpoint_29'` | 839
`'checkpoint_30'` | 875
`'checkpoint_31'` | 868
`'checkpoint_32'` | 852
`'checkpoint_33'` | 855
`'checkpoint_34'` | 858
`'checkpoint_35'` | 851
`'checkpoint_36'` | 852
`'checkpoint_37'` | 857
`'checkpoint_38'` | 849
`'checkpoint_39'` | 858
`'checkpoint_40'` | 857
`'checkpoint_41'` | 872
`'checkpoint_42'` | 834
`'checkpoint_43'` | 845
`'checkpoint_44'` | 821
`'checkpoint_45'` | 842
`'checkpoint_46'` | 856
`'checkpoint_47'` | 844
`'checkpoint_48'` | 868
`'checkpoint_49'` | 853

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):

<!-- mdformat off(HTML should not be auto-formatted) -->

{% framebox %}

<button id="displaydataframe">Display examples...</button>
<div id="dataframecontent" style="overflow-x:auto"></div>
<script>
const url = "https://storage.googleapis.com/tfds-data/visualization/dataframe/rlu_atari_checkpoints-Assault_run_1-1.1.0.html";
const dataButton = document.getElementById('displaydataframe');
dataButton.addEventListener('click', async () => {
  // Disable the button after clicking (dataframe loaded only once).
  dataButton.disabled = true;

  const contentPane = document.getElementById('dataframecontent');
  try {
    const response = await fetch(url);
    // Error response codes don't throw an error, so force an error to show
    // the error message.
    if (!response.ok) throw Error(response.statusText);

    const data = await response.text();
    contentPane.innerHTML = data;
  } catch (e) {
    contentPane.innerHTML =
        'Error loading examples. If the error persist, please open '
        + 'a new issue.';
  }
});
</script>

{% endframebox %}

<!-- mdformat on -->

## rlu_atari_checkpoints/Assault_run_2

*   **Dataset size**: `28.62 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 1,533
`'checkpoint_01'` | 1,215
`'checkpoint_02'` | 1,121
`'checkpoint_03'` | 1,027
`'checkpoint_04'` | 997
`'checkpoint_05'` | 832
`'checkpoint_06'` | 819
`'checkpoint_07'` | 760
`'checkpoint_08'` | 855
`'checkpoint_09'` | 804
`'checkpoint_10'` | 796
`'checkpoint_11'` | 843
`'checkpoint_12'` | 858
`'checkpoint_13'` | 854
`'checkpoint_14'` | 885
`'checkpoint_15'` | 869
`'checkpoint_16'` | 924
`'checkpoint_17'` | 940
`'checkpoint_18'` | 903
`'checkpoint_19'` | 882
`'checkpoint_20'` | 871
`'checkpoint_21'` | 877
`'checkpoint_22'` | 899
`'checkpoint_23'` | 931
`'checkpoint_24'` | 939
`'checkpoint_25'` | 926
`'checkpoint_26'` | 897
`'checkpoint_27'` | 894
`'checkpoint_28'` | 916
`'checkpoint_29'` | 922
`'checkpoint_30'` | 932
`'checkpoint_31'` | 926
`'checkpoint_32'` | 891
`'checkpoint_33'` | 881
`'checkpoint_34'` | 882
`'checkpoint_35'` | 910
`'checkpoint_36'` | 911
`'checkpoint_37'` | 897
`'checkpoint_38'` | 897
`'checkpoint_39'` | 910
`'checkpoint_40'` | 908
`'checkpoint_41'` | 924
`'checkpoint_42'` | 933
`'checkpoint_43'` | 933
`'checkpoint_44'` | 938
`'checkpoint_45'` | 923
`'checkpoint_46'` | 936
`'checkpoint_47'` | 928
`'checkpoint_48'` | 929
`'checkpoint_49'` | 936

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):

<!-- mdformat off(HTML should not be auto-formatted) -->

{% framebox %}

<button id="displaydataframe">Display examples...</button>
<div id="dataframecontent" style="overflow-x:auto"></div>
<script>
const url = "https://storage.googleapis.com/tfds-data/visualization/dataframe/rlu_atari_checkpoints-Assault_run_2-1.1.0.html";
const dataButton = document.getElementById('displaydataframe');
dataButton.addEventListener('click', async () => {
  // Disable the button after clicking (dataframe loaded only once).
  dataButton.disabled = true;

  const contentPane = document.getElementById('dataframecontent');
  try {
    const response = await fetch(url);
    // Error response codes don't throw an error, so force an error to show
    // the error message.
    if (!response.ok) throw Error(response.statusText);

    const data = await response.text();
    contentPane.innerHTML = data;
  } catch (e) {
    contentPane.innerHTML =
        'Error loading examples. If the error persist, please open '
        + 'a new issue.';
  }
});
</script>

{% endframebox %}

<!-- mdformat on -->

## rlu_atari_checkpoints/Assault_run_3

*   **Dataset size**: `28.66 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 1,498
`'checkpoint_01'` | 1,238
`'checkpoint_02'` | 1,064
`'checkpoint_03'` | 976
`'checkpoint_04'` | 974
`'checkpoint_05'` | 972
`'checkpoint_06'` | 842
`'checkpoint_07'` | 858
`'checkpoint_08'` | 861
`'checkpoint_09'` | 872
`'checkpoint_10'` | 844
`'checkpoint_11'` | 885
`'checkpoint_12'` | 855
`'checkpoint_13'` | 859
`'checkpoint_14'` | 852
`'checkpoint_15'` | 883
`'checkpoint_16'` | 888
`'checkpoint_17'` | 885
`'checkpoint_18'` | 867
`'checkpoint_19'` | 888
`'checkpoint_20'` | 914
`'checkpoint_21'` | 892
`'checkpoint_22'` | 913
`'checkpoint_23'` | 919
`'checkpoint_24'` | 907
`'checkpoint_25'` | 886
`'checkpoint_26'` | 917
`'checkpoint_27'` | 910
`'checkpoint_28'` | 924
`'checkpoint_29'` | 917
`'checkpoint_30'` | 916
`'checkpoint_31'` | 935
`'checkpoint_32'` | 900
`'checkpoint_33'` | 912
`'checkpoint_34'` | 912
`'checkpoint_35'` | 931
`'checkpoint_36'` | 895
`'checkpoint_37'` | 920
`'checkpoint_38'` | 912
`'checkpoint_39'` | 912
`'checkpoint_40'` | 893
`'checkpoint_41'` | 897
`'checkpoint_42'` | 882
`'checkpoint_43'` | 887
`'checkpoint_44'` | 898
`'checkpoint_45'` | 935
`'checkpoint_46'` | 898
`'checkpoint_47'` | 905
`'checkpoint_48'` | 895
`'checkpoint_49'` | 951

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):

<!-- mdformat off(HTML should not be auto-formatted) -->

{% framebox %}

<button id="displaydataframe">Display examples...</button>
<div id="dataframecontent" style="overflow-x:auto"></div>
<script>
const url = "https://storage.googleapis.com/tfds-data/visualization/dataframe/rlu_atari_checkpoints-Assault_run_3-1.1.0.html";
const dataButton = document.getElementById('displaydataframe');
dataButton.addEventListener('click', async () => {
  // Disable the button after clicking (dataframe loaded only once).
  dataButton.disabled = true;

  const contentPane = document.getElementById('dataframecontent');
  try {
    const response = await fetch(url);
    // Error response codes don't throw an error, so force an error to show
    // the error message.
    if (!response.ok) throw Error(response.statusText);

    const data = await response.text();
    contentPane.innerHTML = data;
  } catch (e) {
    contentPane.innerHTML =
        'Error loading examples. If the error persist, please open '
        + 'a new issue.';
  }
});
</script>

{% endframebox %}

<!-- mdformat on -->

## rlu_atari_checkpoints/Assault_run_4

*   **Dataset size**: `28.64 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 1,558
`'checkpoint_01'` | 1,229
`'checkpoint_02'` | 1,040
`'checkpoint_03'` | 991
`'checkpoint_04'` | 1,007
`'checkpoint_05'` | 924
`'checkpoint_06'` | 844
`'checkpoint_07'` | 814
`'checkpoint_08'` | 795
`'checkpoint_09'` | 811
`'checkpoint_10'` | 815
`'checkpoint_11'` | 816
`'checkpoint_12'` | 821
`'checkpoint_13'` | 838
`'checkpoint_14'` | 893
`'checkpoint_15'` | 837
`'checkpoint_16'` | 838
`'checkpoint_17'` | 884
`'checkpoint_18'` | 914
`'checkpoint_19'` | 872
`'checkpoint_20'` | 910
`'checkpoint_21'` | 922
`'checkpoint_22'` | 873
`'checkpoint_23'` | 892
`'checkpoint_24'` | 892
`'checkpoint_25'` | 902
`'checkpoint_26'` | 912
`'checkpoint_27'` | 905
`'checkpoint_28'` | 881
`'checkpoint_29'` | 914
`'checkpoint_30'` | 915
`'checkpoint_31'` | 876
`'checkpoint_32'` | 929
`'checkpoint_33'` | 908
`'checkpoint_34'` | 888
`'checkpoint_35'` | 906
`'checkpoint_36'` | 897
`'checkpoint_37'` | 885
`'checkpoint_38'` | 880
`'checkpoint_39'` | 861
`'checkpoint_40'` | 888
`'checkpoint_41'` | 892
`'checkpoint_42'` | 906
`'checkpoint_43'` | 933
`'checkpoint_44'` | 871
`'checkpoint_45'` | 876
`'checkpoint_46'` | 942
`'checkpoint_47'` | 926
`'checkpoint_48'` | 890
`'checkpoint_49'` | 904

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):

<!-- mdformat off(HTML should not be auto-formatted) -->

{% framebox %}

<button id="displaydataframe">Display examples...</button>
<div id="dataframecontent" style="overflow-x:auto"></div>
<script>
const url = "https://storage.googleapis.com/tfds-data/visualization/dataframe/rlu_atari_checkpoints-Assault_run_4-1.1.0.html";
const dataButton = document.getElementById('displaydataframe');
dataButton.addEventListener('click', async () => {
  // Disable the button after clicking (dataframe loaded only once).
  dataButton.disabled = true;

  const contentPane = document.getElementById('dataframecontent');
  try {
    const response = await fetch(url);
    // Error response codes don't throw an error, so force an error to show
    // the error message.
    if (!response.ok) throw Error(response.statusText);

    const data = await response.text();
    contentPane.innerHTML = data;
  } catch (e) {
    contentPane.innerHTML =
        'Error loading examples. If the error persist, please open '
        + 'a new issue.';
  }
});
</script>

{% endframebox %}

<!-- mdformat on -->

## rlu_atari_checkpoints/Assault_run_5

*   **Dataset size**: `28.63 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 1,551
`'checkpoint_01'` | 1,165
`'checkpoint_02'` | 1,105
`'checkpoint_03'` | 1,050
`'checkpoint_04'` | 1,004
`'checkpoint_05'` | 960
`'checkpoint_06'` | 807
`'checkpoint_07'` | 835
`'checkpoint_08'` | 804
`'checkpoint_09'` | 803
`'checkpoint_10'` | 783
`'checkpoint_11'` | 790
`'checkpoint_12'` | 830
`'checkpoint_13'` | 796
`'checkpoint_14'` | 837
`'checkpoint_15'` | 845
`'checkpoint_16'` | 874
`'checkpoint_17'` | 873
`'checkpoint_18'` | 881
`'checkpoint_19'` | 849
`'checkpoint_20'` | 891
`'checkpoint_21'` | 891
`'checkpoint_22'` | 893
`'checkpoint_23'` | 863
`'checkpoint_24'` | 869
`'checkpoint_25'` | 883
`'checkpoint_26'` | 920
`'checkpoint_27'` | 905
`'checkpoint_28'` | 897
`'checkpoint_29'` | 892
`'checkpoint_30'` | 900
`'checkpoint_31'` | 913
`'checkpoint_32'` | 931
`'checkpoint_33'` | 876
`'checkpoint_34'` | 879
`'checkpoint_35'` | 873
`'checkpoint_36'` | 859
`'checkpoint_37'` | 926
`'checkpoint_38'` | 893
`'checkpoint_39'` | 943
`'checkpoint_40'` | 885
`'checkpoint_41'` | 871
`'checkpoint_42'` | 898
`'checkpoint_43'` | 915
`'checkpoint_44'` | 889
`'checkpoint_45'` | 886
`'checkpoint_46'` | 864
`'checkpoint_47'` | 922
`'checkpoint_48'` | 890
`'checkpoint_49'` | 924

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):

<!-- mdformat off(HTML should not be auto-formatted) -->

{% framebox %}

<button id="displaydataframe">Display examples...</button>
<div id="dataframecontent" style="overflow-x:auto"></div>
<script>
const url = "https://storage.googleapis.com/tfds-data/visualization/dataframe/rlu_atari_checkpoints-Assault_run_5-1.1.0.html";
const dataButton = document.getElementById('displaydataframe');
dataButton.addEventListener('click', async () => {
  // Disable the button after clicking (dataframe loaded only once).
  dataButton.disabled = true;

  const contentPane = document.getElementById('dataframecontent');
  try {
    const response = await fetch(url);
    // Error response codes don't throw an error, so force an error to show
    // the error message.
    if (!response.ok) throw Error(response.statusText);

    const data = await response.text();
    contentPane.innerHTML = data;
  } catch (e) {
    contentPane.innerHTML =
        'Error loading examples. If the error persist, please open '
        + 'a new issue.';
  }
});
</script>

{% endframebox %}

<!-- mdformat on -->

## rlu_atari_checkpoints/Asterix_run_1

*   **Dataset size**: `46.55 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 3,138
`'checkpoint_01'` | 1,545
`'checkpoint_02'` | 1,231
`'checkpoint_03'` | 1,169
`'checkpoint_04'` | 1,172
`'checkpoint_05'` | 1,167
`'checkpoint_06'` | 1,128
`'checkpoint_07'` | 1,128
`'checkpoint_08'` | 1,136
`'checkpoint_09'` | 1,157
`'checkpoint_10'` | 1,162
`'checkpoint_11'` | 1,111
`'checkpoint_12'` | 1,099
`'checkpoint_13'` | 1,062
`'checkpoint_14'` | 1,068
`'checkpoint_15'` | 1,067
`'checkpoint_16'` | 1,121
`'checkpoint_17'` | 1,147
`'checkpoint_18'` | 1,114
`'checkpoint_19'` | 1,163
`'checkpoint_20'` | 1,149
`'checkpoint_21'` | 1,211
`'checkpoint_22'` | 1,192
`'checkpoint_23'` | 1,132
`'checkpoint_24'` | 1,157
`'checkpoint_25'` | 1,111
`'checkpoint_26'` | 1,146
`'checkpoint_27'` | 1,128
`'checkpoint_28'` | 1,101
`'checkpoint_29'` | 1,161
`'checkpoint_30'` | 1,082
`'checkpoint_31'` | 1,105
`'checkpoint_32'` | 1,079
`'checkpoint_33'` | 1,084
`'checkpoint_34'` | 1,076
`'checkpoint_35'` | 1,051
`'checkpoint_36'` | 1,047
`'checkpoint_37'` | 1,073
`'checkpoint_38'` | 1,063
`'checkpoint_39'` | 1,138
`'checkpoint_40'` | 1,061
`'checkpoint_41'` | 1,057
`'checkpoint_42'` | 1,054
`'checkpoint_43'` | 1,042
`'checkpoint_44'` | 1,056
`'checkpoint_45'` | 1,012
`'checkpoint_46'` | 1,116
`'checkpoint_47'` | 1,036
`'checkpoint_48'` | 1,045
`'checkpoint_49'` | 1,020

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):

<!-- mdformat off(HTML should not be auto-formatted) -->

{% framebox %}

<button id="displaydataframe">Display examples...</button>
<div id="dataframecontent" style="overflow-x:auto"></div>
<script>
const url = "https://storage.googleapis.com/tfds-data/visualization/dataframe/rlu_atari_checkpoints-Asterix_run_1-1.1.0.html";
const dataButton = document.getElementById('displaydataframe');
dataButton.addEventListener('click', async () => {
  // Disable the button after clicking (dataframe loaded only once).
  dataButton.disabled = true;

  const contentPane = document.getElementById('dataframecontent');
  try {
    const response = await fetch(url);
    // Error response codes don't throw an error, so force an error to show
    // the error message.
    if (!response.ok) throw Error(response.statusText);

    const data = await response.text();
    contentPane.innerHTML = data;
  } catch (e) {
    contentPane.innerHTML =
        'Error loading examples. If the error persist, please open '
        + 'a new issue.';
  }
});
</script>

{% endframebox %}

<!-- mdformat on -->

## rlu_atari_checkpoints/Asterix_run_2

*   **Dataset size**: `46.64 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 3,155
`'checkpoint_01'` | 1,460
`'checkpoint_02'` | 1,182
`'checkpoint_03'` | 1,122
`'checkpoint_04'` | 1,111
`'checkpoint_05'` | 1,080
`'checkpoint_06'` | 1,170
`'checkpoint_07'` | 1,162
`'checkpoint_08'` | 1,198
`'checkpoint_09'` | 1,215
`'checkpoint_10'` | 1,130
`'checkpoint_11'` | 1,113
`'checkpoint_12'` | 1,055
`'checkpoint_13'` | 1,046
`'checkpoint_14'` | 1,091
`'checkpoint_15'` | 1,064
`'checkpoint_16'` | 1,087
`'checkpoint_17'` | 1,078
`'checkpoint_18'` | 1,075
`'checkpoint_19'` | 1,080
`'checkpoint_20'` | 1,032
`'checkpoint_21'` | 1,031
`'checkpoint_22'` | 1,064
`'checkpoint_23'` | 1,031
`'checkpoint_24'` | 1,042
`'checkpoint_25'` | 1,112
`'checkpoint_26'` | 1,129
`'checkpoint_27'` | 1,105
`'checkpoint_28'` | 1,077
`'checkpoint_29'` | 1,097
`'checkpoint_30'` | 1,078
`'checkpoint_31'` | 1,118
`'checkpoint_32'` | 1,052
`'checkpoint_33'` | 1,069
`'checkpoint_34'` | 1,084
`'checkpoint_35'` | 1,073
`'checkpoint_36'` | 1,067
`'checkpoint_37'` | 1,102
`'checkpoint_38'` | 1,124
`'checkpoint_39'` | 1,106
`'checkpoint_40'` | 1,059
`'checkpoint_41'` | 1,072
`'checkpoint_42'` | 1,059
`'checkpoint_43'` | 1,082
`'checkpoint_44'` | 1,048
`'checkpoint_45'` | 1,036
`'checkpoint_46'` | 1,068
`'checkpoint_47'` | 1,036
`'checkpoint_48'` | 1,066
`'checkpoint_49'` | 1,058

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):

<!-- mdformat off(HTML should not be auto-formatted) -->

{% framebox %}

<button id="displaydataframe">Display examples...</button>
<div id="dataframecontent" style="overflow-x:auto"></div>
<script>
const url = "https://storage.googleapis.com/tfds-data/visualization/dataframe/rlu_atari_checkpoints-Asterix_run_2-1.1.0.html";
const dataButton = document.getElementById('displaydataframe');
dataButton.addEventListener('click', async () => {
  // Disable the button after clicking (dataframe loaded only once).
  dataButton.disabled = true;

  const contentPane = document.getElementById('dataframecontent');
  try {
    const response = await fetch(url);
    // Error response codes don't throw an error, so force an error to show
    // the error message.
    if (!response.ok) throw Error(response.statusText);

    const data = await response.text();
    contentPane.innerHTML = data;
  } catch (e) {
    contentPane.innerHTML =
        'Error loading examples. If the error persist, please open '
        + 'a new issue.';
  }
});
</script>

{% endframebox %}

<!-- mdformat on -->

## rlu_atari_checkpoints/Asterix_run_3

*   **Dataset size**: `46.45 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 3,178
`'checkpoint_01'` | 1,518
`'checkpoint_02'` | 1,128
`'checkpoint_03'` | 1,128
`'checkpoint_04'` | 1,106
`'checkpoint_05'` | 1,169
`'checkpoint_06'` | 1,152
`'checkpoint_07'` | 1,155
`'checkpoint_08'` | 1,140
`'checkpoint_09'` | 1,153
`'checkpoint_10'` | 1,184
`'checkpoint_11'` | 1,170
`'checkpoint_12'` | 1,166
`'checkpoint_13'` | 1,153
`'checkpoint_14'` | 1,090
`'checkpoint_15'` | 1,085
`'checkpoint_16'` | 1,054
`'checkpoint_17'` | 1,052
`'checkpoint_18'` | 1,072
`'checkpoint_19'` | 1,032
`'checkpoint_20'` | 1,023
`'checkpoint_21'` | 1,004
`'checkpoint_22'` | 1,048
`'checkpoint_23'` | 1,038
`'checkpoint_24'` | 970
`'checkpoint_25'` | 991
`'checkpoint_26'` | 1,035
`'checkpoint_27'` | 1,028
`'checkpoint_28'` | 1,037
`'checkpoint_29'` | 1,094
`'checkpoint_30'` | 1,103
`'checkpoint_31'` | 1,045
`'checkpoint_32'` | 1,097
`'checkpoint_33'` | 1,088
`'checkpoint_34'` | 1,069
`'checkpoint_35'` | 1,090
`'checkpoint_36'` | 1,083
`'checkpoint_37'` | 1,106
`'checkpoint_38'` | 1,159
`'checkpoint_39'` | 1,244
`'checkpoint_40'` | 1,503
`'checkpoint_41'` | 1,684
`'checkpoint_42'` | 1,881
`'checkpoint_43'` | 1,989
`'checkpoint_44'` | 1,849
`'checkpoint_45'` | 2,651
`'checkpoint_46'` | 2,497
`'checkpoint_47'` | 2,443
`'checkpoint_48'` | 2,434
`'checkpoint_49'` | 2,409

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):

<!-- mdformat off(HTML should not be auto-formatted) -->

{% framebox %}

<button id="displaydataframe">Display examples...</button>
<div id="dataframecontent" style="overflow-x:auto"></div>
<script>
const url = "https://storage.googleapis.com/tfds-data/visualization/dataframe/rlu_atari_checkpoints-Asterix_run_3-1.1.0.html";
const dataButton = document.getElementById('displaydataframe');
dataButton.addEventListener('click', async () => {
  // Disable the button after clicking (dataframe loaded only once).
  dataButton.disabled = true;

  const contentPane = document.getElementById('dataframecontent');
  try {
    const response = await fetch(url);
    // Error response codes don't throw an error, so force an error to show
    // the error message.
    if (!response.ok) throw Error(response.statusText);

    const data = await response.text();
    contentPane.innerHTML = data;
  } catch (e) {
    contentPane.innerHTML =
        'Error loading examples. If the error persist, please open '
        + 'a new issue.';
  }
});
</script>

{% endframebox %}

<!-- mdformat on -->

## rlu_atari_checkpoints/Asterix_run_4

*   **Dataset size**: `46.57 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 3,194
`'checkpoint_01'` | 1,506
`'checkpoint_02'` | 1,185
`'checkpoint_03'` | 1,133
`'checkpoint_04'` | 1,151
`'checkpoint_05'` | 1,143
`'checkpoint_06'` | 1,184
`'checkpoint_07'` | 1,192
`'checkpoint_08'` | 1,218
`'checkpoint_09'` | 1,210
`'checkpoint_10'` | 1,189
`'checkpoint_11'` | 1,141
`'checkpoint_12'` | 1,126
`'checkpoint_13'` | 1,092
`'checkpoint_14'` | 1,079
`'checkpoint_15'` | 1,097
`'checkpoint_16'` | 1,071
`'checkpoint_17'` | 1,119
`'checkpoint_18'` | 1,177
`'checkpoint_19'` | 1,160
`'checkpoint_20'` | 1,152
`'checkpoint_21'` | 1,098
`'checkpoint_22'` | 1,117
`'checkpoint_23'` | 1,146
`'checkpoint_24'` | 1,127
`'checkpoint_25'` | 1,089
`'checkpoint_26'` | 1,072
`'checkpoint_27'` | 1,116
`'checkpoint_28'` | 1,090
`'checkpoint_29'` | 1,129
`'checkpoint_30'` | 1,111
`'checkpoint_31'` | 1,067
`'checkpoint_32'` | 1,091
`'checkpoint_33'` | 1,128
`'checkpoint_34'` | 1,075
`'checkpoint_35'` | 1,127
`'checkpoint_36'` | 1,125
`'checkpoint_37'` | 1,056
`'checkpoint_38'` | 1,066
`'checkpoint_39'` | 1,057
`'checkpoint_40'` | 1,067
`'checkpoint_41'` | 1,146
`'checkpoint_42'` | 1,035
`'checkpoint_43'` | 1,086
`'checkpoint_44'` | 1,117
`'checkpoint_45'` | 1,090
`'checkpoint_46'` | 1,064
`'checkpoint_47'` | 1,101
`'checkpoint_48'` | 1,011
`'checkpoint_49'` | 1,008

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):

<!-- mdformat off(HTML should not be auto-formatted) -->

{% framebox %}

<button id="displaydataframe">Display examples...</button>
<div id="dataframecontent" style="overflow-x:auto"></div>
<script>
const url = "https://storage.googleapis.com/tfds-data/visualization/dataframe/rlu_atari_checkpoints-Asterix_run_4-1.1.0.html";
const dataButton = document.getElementById('displaydataframe');
dataButton.addEventListener('click', async () => {
  // Disable the button after clicking (dataframe loaded only once).
  dataButton.disabled = true;

  const contentPane = document.getElementById('dataframecontent');
  try {
    const response = await fetch(url);
    // Error response codes don't throw an error, so force an error to show
    // the error message.
    if (!response.ok) throw Error(response.statusText);

    const data = await response.text();
    contentPane.innerHTML = data;
  } catch (e) {
    contentPane.innerHTML =
        'Error loading examples. If the error persist, please open '
        + 'a new issue.';
  }
});
</script>

{% endframebox %}

<!-- mdformat on -->

## rlu_atari_checkpoints/Asterix_run_5

*   **Dataset size**: `46.60 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 3,179
`'checkpoint_01'` | 1,644
`'checkpoint_02'` | 1,239
`'checkpoint_03'` | 1,201
`'checkpoint_04'` | 1,150
`'checkpoint_05'` | 1,151
`'checkpoint_06'` | 1,132
`'checkpoint_07'` | 1,213
`'checkpoint_08'` | 1,193
`'checkpoint_09'` | 1,205
`'checkpoint_10'` | 1,164
`'checkpoint_11'` | 1,135
`'checkpoint_12'` | 1,086
`'checkpoint_13'` | 1,069
`'checkpoint_14'` | 1,057
`'checkpoint_15'` | 1,040
`'checkpoint_16'` | 1,065
`'checkpoint_17'` | 1,102
`'checkpoint_18'` | 1,091
`'checkpoint_19'` | 1,149
`'checkpoint_20'` | 1,117
`'checkpoint_21'` | 1,095
`'checkpoint_22'` | 1,117
`'checkpoint_23'` | 1,148
`'checkpoint_24'` | 1,115
`'checkpoint_25'` | 1,120
`'checkpoint_26'` | 1,127
`'checkpoint_27'` | 1,113
`'checkpoint_28'` | 1,114
`'checkpoint_29'` | 1,098
`'checkpoint_30'` | 1,046
`'checkpoint_31'` | 1,073
`'checkpoint_32'` | 1,075
`'checkpoint_33'` | 1,118
`'checkpoint_34'` | 1,075
`'checkpoint_35'` | 1,057
`'checkpoint_36'` | 1,072
`'checkpoint_37'` | 1,050
`'checkpoint_38'` | 1,065
`'checkpoint_39'` | 1,083
`'checkpoint_40'` | 1,042
`'checkpoint_41'` | 1,075
`'checkpoint_42'` | 1,094
`'checkpoint_43'` | 1,084
`'checkpoint_44'` | 1,108
`'checkpoint_45'` | 1,143
`'checkpoint_46'` | 1,090
`'checkpoint_47'` | 1,051
`'checkpoint_48'` | 1,154
`'checkpoint_49'` | 1,097

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):

<!-- mdformat off(HTML should not be auto-formatted) -->

{% framebox %}

<button id="displaydataframe">Display examples...</button>
<div id="dataframecontent" style="overflow-x:auto"></div>
<script>
const url = "https://storage.googleapis.com/tfds-data/visualization/dataframe/rlu_atari_checkpoints-Asterix_run_5-1.1.0.html";
const dataButton = document.getElementById('displaydataframe');
dataButton.addEventListener('click', async () => {
  // Disable the button after clicking (dataframe loaded only once).
  dataButton.disabled = true;

  const contentPane = document.getElementById('dataframecontent');
  try {
    const response = await fetch(url);
    // Error response codes don't throw an error, so force an error to show
    // the error message.
    if (!response.ok) throw Error(response.statusText);

    const data = await response.text();
    contentPane.innerHTML = data;
  } catch (e) {
    contentPane.innerHTML =
        'Error loading examples. If the error persist, please open '
        + 'a new issue.';
  }
});
</script>

{% endframebox %}

<!-- mdformat on -->

## rlu_atari_checkpoints/Atlantis_run_1

*   **Dataset size**: `41.46 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 1,109
`'checkpoint_01'` | 1,224
`'checkpoint_02'` | 1,236
`'checkpoint_03'` | 1,177
`'checkpoint_04'` | 983
`'checkpoint_05'` | 746
`'checkpoint_06'` | 552
`'checkpoint_07'` | 447
`'checkpoint_08'` | 385
`'checkpoint_09'` | 289
`'checkpoint_10'` | 156
`'checkpoint_11'` | 104
`'checkpoint_12'` | 103
`'checkpoint_13'` | 55
`'checkpoint_14'` | 39
`'checkpoint_15'` | 38
`'checkpoint_16'` | 38
`'checkpoint_17'` | 38
`'checkpoint_18'` | 38
`'checkpoint_19'` | 38
`'checkpoint_20'` | 38
`'checkpoint_21'` | 38
`'checkpoint_22'` | 38
`'checkpoint_23'` | 38
`'checkpoint_24'` | 38
`'checkpoint_25'` | 39
`'checkpoint_26'` | 38
`'checkpoint_27'` | 38
`'checkpoint_28'` | 38
`'checkpoint_29'` | 38
`'checkpoint_30'` | 38
`'checkpoint_31'` | 38
`'checkpoint_32'` | 38
`'checkpoint_33'` | 38
`'checkpoint_34'` | 38
`'checkpoint_35'` | 38
`'checkpoint_36'` | 38
`'checkpoint_37'` | 38
`'checkpoint_38'` | 38
`'checkpoint_39'` | 38
`'checkpoint_40'` | 38
`'checkpoint_41'` | 38
`'checkpoint_42'` | 38
`'checkpoint_43'` | 38
`'checkpoint_44'` | 38
`'checkpoint_45'` | 38
`'checkpoint_46'` | 38
`'checkpoint_47'` | 38
`'checkpoint_48'` | 39
`'checkpoint_49'` | 38

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):

<!-- mdformat off(HTML should not be auto-formatted) -->

{% framebox %}

<button id="displaydataframe">Display examples...</button>
<div id="dataframecontent" style="overflow-x:auto"></div>
<script>
const url = "https://storage.googleapis.com/tfds-data/visualization/dataframe/rlu_atari_checkpoints-Atlantis_run_1-1.1.0.html";
const dataButton = document.getElementById('displaydataframe');
dataButton.addEventListener('click', async () => {
  // Disable the button after clicking (dataframe loaded only once).
  dataButton.disabled = true;

  const contentPane = document.getElementById('dataframecontent');
  try {
    const response = await fetch(url);
    // Error response codes don't throw an error, so force an error to show
    // the error message.
    if (!response.ok) throw Error(response.statusText);

    const data = await response.text();
    contentPane.innerHTML = data;
  } catch (e) {
    contentPane.innerHTML =
        'Error loading examples. If the error persist, please open '
        + 'a new issue.';
  }
});
</script>

{% endframebox %}

<!-- mdformat on -->

## rlu_atari_checkpoints/Atlantis_run_2

*   **Dataset size**: `41.25 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 1,149
`'checkpoint_01'` | 1,266
`'checkpoint_02'` | 1,235
`'checkpoint_03'` | 1,159
`'checkpoint_04'` | 1,018
`'checkpoint_05'` | 803
`'checkpoint_06'` | 587
`'checkpoint_07'` | 491
`'checkpoint_08'` | 419
`'checkpoint_09'` | 260
`'checkpoint_10'` | 264
`'checkpoint_11'` | 187
`'checkpoint_12'` | 203
`'checkpoint_13'` | 176
`'checkpoint_14'` | 132
`'checkpoint_15'` | 89
`'checkpoint_16'` | 42
`'checkpoint_17'` | 39
`'checkpoint_18'` | 38
`'checkpoint_19'` | 38
`'checkpoint_20'` | 38
`'checkpoint_21'` | 38
`'checkpoint_22'` | 38
`'checkpoint_23'` | 39
`'checkpoint_24'` | 38
`'checkpoint_25'` | 38
`'checkpoint_26'` | 38
`'checkpoint_27'` | 38
`'checkpoint_28'` | 38
`'checkpoint_29'` | 38
`'checkpoint_30'` | 38
`'checkpoint_31'` | 38
`'checkpoint_32'` | 38
`'checkpoint_33'` | 38
`'checkpoint_34'` | 38
`'checkpoint_35'` | 38
`'checkpoint_36'` | 38
`'checkpoint_37'` | 38
`'checkpoint_38'` | 38
`'checkpoint_39'` | 38
`'checkpoint_40'` | 38
`'checkpoint_41'` | 38
`'checkpoint_42'` | 38
`'checkpoint_43'` | 38
`'checkpoint_44'` | 38
`'checkpoint_45'` | 38
`'checkpoint_46'` | 38
`'checkpoint_47'` | 38
`'checkpoint_48'` | 38
`'checkpoint_49'` | 38

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):

<!-- mdformat off(HTML should not be auto-formatted) -->

{% framebox %}

<button id="displaydataframe">Display examples...</button>
<div id="dataframecontent" style="overflow-x:auto"></div>
<script>
const url = "https://storage.googleapis.com/tfds-data/visualization/dataframe/rlu_atari_checkpoints-Atlantis_run_2-1.1.0.html";
const dataButton = document.getElementById('displaydataframe');
dataButton.addEventListener('click', async () => {
  // Disable the button after clicking (dataframe loaded only once).
  dataButton.disabled = true;

  const contentPane = document.getElementById('dataframecontent');
  try {
    const response = await fetch(url);
    // Error response codes don't throw an error, so force an error to show
    // the error message.
    if (!response.ok) throw Error(response.statusText);

    const data = await response.text();
    contentPane.innerHTML = data;
  } catch (e) {
    contentPane.innerHTML =
        'Error loading examples. If the error persist, please open '
        + 'a new issue.';
  }
});
</script>

{% endframebox %}

<!-- mdformat on -->

## rlu_atari_checkpoints/Atlantis_run_3

*   **Dataset size**: `41.48 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 1,068
`'checkpoint_01'` | 1,226
`'checkpoint_02'` | 1,164
`'checkpoint_03'` | 1,059
`'checkpoint_04'` | 818
`'checkpoint_05'` | 668
`'checkpoint_06'` | 572
`'checkpoint_07'` | 404
`'checkpoint_08'` | 239
`'checkpoint_09'` | 110
`'checkpoint_10'` | 117
`'checkpoint_11'` | 104
`'checkpoint_12'` | 77
`'checkpoint_13'` | 52
`'checkpoint_14'` | 43
`'checkpoint_15'` | 38
`'checkpoint_16'` | 38
`'checkpoint_17'` | 38
`'checkpoint_18'` | 38
`'checkpoint_19'` | 38
`'checkpoint_20'` | 38
`'checkpoint_21'` | 39
`'checkpoint_22'` | 38
`'checkpoint_23'` | 39
`'checkpoint_24'` | 38
`'checkpoint_25'` | 38
`'checkpoint_26'` | 39
`'checkpoint_27'` | 39
`'checkpoint_28'` | 38
`'checkpoint_29'` | 38
`'checkpoint_30'` | 38
`'checkpoint_31'` | 38
`'checkpoint_32'` | 38
`'checkpoint_33'` | 38
`'checkpoint_34'` | 38
`'checkpoint_35'` | 38
`'checkpoint_36'` | 38
`'checkpoint_37'` | 38
`'checkpoint_38'` | 38
`'checkpoint_39'` | 38
`'checkpoint_40'` | 38
`'checkpoint_41'` | 38
`'checkpoint_42'` | 38
`'checkpoint_43'` | 38
`'checkpoint_44'` | 38
`'checkpoint_45'` | 38
`'checkpoint_46'` | 38
`'checkpoint_47'` | 39
`'checkpoint_48'` | 38
`'checkpoint_49'` | 38

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):

<!-- mdformat off(HTML should not be auto-formatted) -->

{% framebox %}

<button id="displaydataframe">Display examples...</button>
<div id="dataframecontent" style="overflow-x:auto"></div>
<script>
const url = "https://storage.googleapis.com/tfds-data/visualization/dataframe/rlu_atari_checkpoints-Atlantis_run_3-1.1.0.html";
const dataButton = document.getElementById('displaydataframe');
dataButton.addEventListener('click', async () => {
  // Disable the button after clicking (dataframe loaded only once).
  dataButton.disabled = true;

  const contentPane = document.getElementById('dataframecontent');
  try {
    const response = await fetch(url);
    // Error response codes don't throw an error, so force an error to show
    // the error message.
    if (!response.ok) throw Error(response.statusText);

    const data = await response.text();
    contentPane.innerHTML = data;
  } catch (e) {
    contentPane.innerHTML =
        'Error loading examples. If the error persist, please open '
        + 'a new issue.';
  }
});
</script>

{% endframebox %}

<!-- mdformat on -->

## rlu_atari_checkpoints/Atlantis_run_4

*   **Dataset size**: `41.54 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 1,144
`'checkpoint_01'` | 1,232
`'checkpoint_02'` | 1,285
`'checkpoint_03'` | 1,233
`'checkpoint_04'` | 1,034
`'checkpoint_05'` | 756
`'checkpoint_06'` | 623
`'checkpoint_07'` | 508
`'checkpoint_08'` | 393
`'checkpoint_09'` | 292
`'checkpoint_10'` | 160
`'checkpoint_11'` | 113
`'checkpoint_12'` | 68
`'checkpoint_13'` | 40
`'checkpoint_14'` | 38
`'checkpoint_15'` | 39
`'checkpoint_16'` | 38
`'checkpoint_17'` | 39
`'checkpoint_18'` | 38
`'checkpoint_19'` | 38
`'checkpoint_20'` | 38
`'checkpoint_21'` | 38
`'checkpoint_22'` | 38
`'checkpoint_23'` | 38
`'checkpoint_24'` | 38
`'checkpoint_25'` | 38
`'checkpoint_26'` | 38
`'checkpoint_27'` | 38
`'checkpoint_28'` | 38
`'checkpoint_29'` | 38
`'checkpoint_30'` | 38
`'checkpoint_31'` | 38
`'checkpoint_32'` | 38
`'checkpoint_33'` | 38
`'checkpoint_34'` | 38
`'checkpoint_35'` | 38
`'checkpoint_36'` | 38
`'checkpoint_37'` | 38
`'checkpoint_38'` | 38
`'checkpoint_39'` | 38
`'checkpoint_40'` | 38
`'checkpoint_41'` | 39
`'checkpoint_42'` | 39
`'checkpoint_43'` | 39
`'checkpoint_44'` | 38
`'checkpoint_45'` | 38
`'checkpoint_46'` | 38
`'checkpoint_47'` | 38
`'checkpoint_48'` | 38
`'checkpoint_49'` | 39

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):

<!-- mdformat off(HTML should not be auto-formatted) -->

{% framebox %}

<button id="displaydataframe">Display examples...</button>
<div id="dataframecontent" style="overflow-x:auto"></div>
<script>
const url = "https://storage.googleapis.com/tfds-data/visualization/dataframe/rlu_atari_checkpoints-Atlantis_run_4-1.1.0.html";
const dataButton = document.getElementById('displaydataframe');
dataButton.addEventListener('click', async () => {
  // Disable the button after clicking (dataframe loaded only once).
  dataButton.disabled = true;

  const contentPane = document.getElementById('dataframecontent');
  try {
    const response = await fetch(url);
    // Error response codes don't throw an error, so force an error to show
    // the error message.
    if (!response.ok) throw Error(response.statusText);

    const data = await response.text();
    contentPane.innerHTML = data;
  } catch (e) {
    contentPane.innerHTML =
        'Error loading examples. If the error persist, please open '
        + 'a new issue.';
  }
});
</script>

{% endframebox %}

<!-- mdformat on -->

## rlu_atari_checkpoints/Atlantis_run_5

*   **Dataset size**: `41.48 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 1,132
`'checkpoint_01'` | 1,219
`'checkpoint_02'` | 1,152
`'checkpoint_03'` | 1,008
`'checkpoint_04'` | 920
`'checkpoint_05'` | 707
`'checkpoint_06'` | 583
`'checkpoint_07'` | 472
`'checkpoint_08'` | 379
`'checkpoint_09'` | 274
`'checkpoint_10'` | 172
`'checkpoint_11'` | 107
`'checkpoint_12'` | 102
`'checkpoint_13'` | 75
`'checkpoint_14'` | 43
`'checkpoint_15'` | 38
`'checkpoint_16'` | 39
`'checkpoint_17'` | 38
`'checkpoint_18'` | 38
`'checkpoint_19'` | 38
`'checkpoint_20'` | 38
`'checkpoint_21'` | 38
`'checkpoint_22'` | 38
`'checkpoint_23'` | 39
`'checkpoint_24'` | 39
`'checkpoint_25'` | 39
`'checkpoint_26'` | 39
`'checkpoint_27'` | 39
`'checkpoint_28'` | 38
`'checkpoint_29'` | 38
`'checkpoint_30'` | 39
`'checkpoint_31'` | 39
`'checkpoint_32'` | 38
`'checkpoint_33'` | 38
`'checkpoint_34'` | 39
`'checkpoint_35'` | 39
`'checkpoint_36'` | 38
`'checkpoint_37'` | 38
`'checkpoint_38'` | 38
`'checkpoint_39'` | 39
`'checkpoint_40'` | 39
`'checkpoint_41'` | 38
`'checkpoint_42'` | 38
`'checkpoint_43'` | 38
`'checkpoint_44'` | 38
`'checkpoint_45'` | 39
`'checkpoint_46'` | 38
`'checkpoint_47'` | 38
`'checkpoint_48'` | 38
`'checkpoint_49'` | 39

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):

<!-- mdformat off(HTML should not be auto-formatted) -->

{% framebox %}

<button id="displaydataframe">Display examples...</button>
<div id="dataframecontent" style="overflow-x:auto"></div>
<script>
const url = "https://storage.googleapis.com/tfds-data/visualization/dataframe/rlu_atari_checkpoints-Atlantis_run_5-1.1.0.html";
const dataButton = document.getElementById('displaydataframe');
dataButton.addEventListener('click', async () => {
  // Disable the button after clicking (dataframe loaded only once).
  dataButton.disabled = true;

  const contentPane = document.getElementById('dataframecontent');
  try {
    const response = await fetch(url);
    // Error response codes don't throw an error, so force an error to show
    // the error message.
    if (!response.ok) throw Error(response.statusText);

    const data = await response.text();
    contentPane.innerHTML = data;
  } catch (e) {
    contentPane.innerHTML =
        'Error loading examples. If the error persist, please open '
        + 'a new issue.';
  }
});
</script>

{% endframebox %}

<!-- mdformat on -->

## rlu_atari_checkpoints/BankHeist_run_1

*   **Dataset size**: `71.93 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 1,451
`'checkpoint_01'` | 1,284
`'checkpoint_02'` | 816
`'checkpoint_03'` | 748
`'checkpoint_04'` | 769
`'checkpoint_05'` | 762
`'checkpoint_06'` | 748
`'checkpoint_07'` | 751
`'checkpoint_08'` | 780
`'checkpoint_09'` | 777
`'checkpoint_10'` | 781
`'checkpoint_11'` | 780
`'checkpoint_12'` | 789
`'checkpoint_13'` | 788
`'checkpoint_14'` | 798
`'checkpoint_15'` | 788
`'checkpoint_16'` | 795
`'checkpoint_17'` | 779
`'checkpoint_18'` | 803
`'checkpoint_19'` | 811
`'checkpoint_20'` | 814
`'checkpoint_21'` | 813
`'checkpoint_22'` | 803
`'checkpoint_23'` | 831
`'checkpoint_24'` | 814
`'checkpoint_25'` | 831
`'checkpoint_26'` | 835
`'checkpoint_27'` | 849
`'checkpoint_28'` | 852
`'checkpoint_29'` | 837
`'checkpoint_30'` | 822
`'checkpoint_31'` | 823
`'checkpoint_32'` | 838
`'checkpoint_33'` | 835
`'checkpoint_34'` | 836
`'checkpoint_35'` | 852
`'checkpoint_36'` | 844
`'checkpoint_37'` | 827
`'checkpoint_38'` | 837
`'checkpoint_39'` | 855
`'checkpoint_40'` | 833
`'checkpoint_41'` | 856
`'checkpoint_42'` | 836
`'checkpoint_43'` | 827
`'checkpoint_44'` | 858
`'checkpoint_45'` | 853
`'checkpoint_46'` | 829
`'checkpoint_47'` | 832
`'checkpoint_48'` | 823
`'checkpoint_49'` | 831

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):

<!-- mdformat off(HTML should not be auto-formatted) -->

{% framebox %}

<button id="displaydataframe">Display examples...</button>
<div id="dataframecontent" style="overflow-x:auto"></div>
<script>
const url = "https://storage.googleapis.com/tfds-data/visualization/dataframe/rlu_atari_checkpoints-BankHeist_run_1-1.1.0.html";
const dataButton = document.getElementById('displaydataframe');
dataButton.addEventListener('click', async () => {
  // Disable the button after clicking (dataframe loaded only once).
  dataButton.disabled = true;

  const contentPane = document.getElementById('dataframecontent');
  try {
    const response = await fetch(url);
    // Error response codes don't throw an error, so force an error to show
    // the error message.
    if (!response.ok) throw Error(response.statusText);

    const data = await response.text();
    contentPane.innerHTML = data;
  } catch (e) {
    contentPane.innerHTML =
        'Error loading examples. If the error persist, please open '
        + 'a new issue.';
  }
});
</script>

{% endframebox %}

<!-- mdformat on -->

## rlu_atari_checkpoints/BankHeist_run_2

*   **Dataset size**: `71.93 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 1,440
`'checkpoint_01'` | 1,281
`'checkpoint_02'` | 823
`'checkpoint_03'` | 774
`'checkpoint_04'` | 746
`'checkpoint_05'` | 748
`'checkpoint_06'` | 746
`'checkpoint_07'` | 745
`'checkpoint_08'` | 771
`'checkpoint_09'` | 768
`'checkpoint_10'` | 766
`'checkpoint_11'` | 796
`'checkpoint_12'` | 774
`'checkpoint_13'` | 780
`'checkpoint_14'` | 782
`'checkpoint_15'` | 785
`'checkpoint_16'` | 777
`'checkpoint_17'` | 787
`'checkpoint_18'` | 779
`'checkpoint_19'` | 808
`'checkpoint_20'` | 807
`'checkpoint_21'` | 814
`'checkpoint_22'` | 806
`'checkpoint_23'` | 813
`'checkpoint_24'` | 824
`'checkpoint_25'` | 836
`'checkpoint_26'` | 841
`'checkpoint_27'` | 841
`'checkpoint_28'` | 853
`'checkpoint_29'` | 855
`'checkpoint_30'` | 868
`'checkpoint_31'` | 856
`'checkpoint_32'` | 854
`'checkpoint_33'` | 831
`'checkpoint_34'` | 856
`'checkpoint_35'` | 856
`'checkpoint_36'` | 861
`'checkpoint_37'` | 841
`'checkpoint_38'` | 861
`'checkpoint_39'` | 850
`'checkpoint_40'` | 849
`'checkpoint_41'` | 875
`'checkpoint_42'` | 851
`'checkpoint_43'` | 846
`'checkpoint_44'` | 846
`'checkpoint_45'` | 847
`'checkpoint_46'` | 856
`'checkpoint_47'` | 851
`'checkpoint_48'` | 896
`'checkpoint_49'` | 880

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):

<!-- mdformat off(HTML should not be auto-formatted) -->

{% framebox %}

<button id="displaydataframe">Display examples...</button>
<div id="dataframecontent" style="overflow-x:auto"></div>
<script>
const url = "https://storage.googleapis.com/tfds-data/visualization/dataframe/rlu_atari_checkpoints-BankHeist_run_2-1.1.0.html";
const dataButton = document.getElementById('displaydataframe');
dataButton.addEventListener('click', async () => {
  // Disable the button after clicking (dataframe loaded only once).
  dataButton.disabled = true;

  const contentPane = document.getElementById('dataframecontent');
  try {
    const response = await fetch(url);
    // Error response codes don't throw an error, so force an error to show
    // the error message.
    if (!response.ok) throw Error(response.statusText);

    const data = await response.text();
    contentPane.innerHTML = data;
  } catch (e) {
    contentPane.innerHTML =
        'Error loading examples. If the error persist, please open '
        + 'a new issue.';
  }
});
</script>

{% endframebox %}

<!-- mdformat on -->

## rlu_atari_checkpoints/BankHeist_run_3

*   **Dataset size**: `71.82 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 1,450
`'checkpoint_01'` | 1,355
`'checkpoint_02'` | 1,015
`'checkpoint_03'` | 792
`'checkpoint_04'` | 757
`'checkpoint_05'` | 754
`'checkpoint_06'` | 738
`'checkpoint_07'` | 735
`'checkpoint_08'` | 742
`'checkpoint_09'` | 756
`'checkpoint_10'` | 760
`'checkpoint_11'` | 774
`'checkpoint_12'` | 762
`'checkpoint_13'` | 774
`'checkpoint_14'` | 791
`'checkpoint_15'` | 795
`'checkpoint_16'` | 809
`'checkpoint_17'` | 795
`'checkpoint_18'` | 789
`'checkpoint_19'` | 771
`'checkpoint_20'` | 786
`'checkpoint_21'` | 788
`'checkpoint_22'` | 790
`'checkpoint_23'` | 1,106
`'checkpoint_24'` | 933
`'checkpoint_25'` | 829
`'checkpoint_26'` | 826
`'checkpoint_27'` | 818
`'checkpoint_28'` | 799
`'checkpoint_29'` | 809
`'checkpoint_30'` | 814
`'checkpoint_31'` | 807
`'checkpoint_32'` | 838
`'checkpoint_33'` | 838
`'checkpoint_34'` | 833
`'checkpoint_35'` | 816
`'checkpoint_36'` | 832
`'checkpoint_37'` | 844
`'checkpoint_38'` | 1,055
`'checkpoint_39'` | 861
`'checkpoint_40'` | 895
`'checkpoint_41'` | 934
`'checkpoint_42'` | 1,010
`'checkpoint_43'` | 1,042
`'checkpoint_44'` | 1,045
`'checkpoint_45'` | 979
`'checkpoint_46'` | 993
`'checkpoint_47'` | 981
`'checkpoint_48'` | 967
`'checkpoint_49'` | 976

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):

<!-- mdformat off(HTML should not be auto-formatted) -->

{% framebox %}

<button id="displaydataframe">Display examples...</button>
<div id="dataframecontent" style="overflow-x:auto"></div>
<script>
const url = "https://storage.googleapis.com/tfds-data/visualization/dataframe/rlu_atari_checkpoints-BankHeist_run_3-1.1.0.html";
const dataButton = document.getElementById('displaydataframe');
dataButton.addEventListener('click', async () => {
  // Disable the button after clicking (dataframe loaded only once).
  dataButton.disabled = true;

  const contentPane = document.getElementById('dataframecontent');
  try {
    const response = await fetch(url);
    // Error response codes don't throw an error, so force an error to show
    // the error message.
    if (!response.ok) throw Error(response.statusText);

    const data = await response.text();
    contentPane.innerHTML = data;
  } catch (e) {
    contentPane.innerHTML =
        'Error loading examples. If the error persist, please open '
        + 'a new issue.';
  }
});
</script>

{% endframebox %}

<!-- mdformat on -->

## rlu_atari_checkpoints/BankHeist_run_4

*   **Dataset size**: `71.93 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 1,471
`'checkpoint_01'` | 1,225
`'checkpoint_02'` | 816
`'checkpoint_03'` | 785
`'checkpoint_04'` | 738
`'checkpoint_05'` | 718
`'checkpoint_06'` | 748
`'checkpoint_07'` | 767
`'checkpoint_08'` | 767
`'checkpoint_09'` | 779
`'checkpoint_10'` | 773
`'checkpoint_11'` | 793
`'checkpoint_12'` | 799
`'checkpoint_13'` | 796
`'checkpoint_14'` | 801
`'checkpoint_15'` | 805
`'checkpoint_16'` | 813
`'checkpoint_17'` | 816
`'checkpoint_18'` | 818
`'checkpoint_19'` | 809
`'checkpoint_20'` | 823
`'checkpoint_21'` | 819
`'checkpoint_22'` | 815
`'checkpoint_23'` | 822
`'checkpoint_24'` | 827
`'checkpoint_25'` | 819
`'checkpoint_26'` | 826
`'checkpoint_27'` | 833
`'checkpoint_28'` | 826
`'checkpoint_29'` | 826
`'checkpoint_30'` | 830
`'checkpoint_31'` | 827
`'checkpoint_32'` | 816
`'checkpoint_33'` | 835
`'checkpoint_34'` | 828
`'checkpoint_35'` | 837
`'checkpoint_36'` | 829
`'checkpoint_37'` | 830
`'checkpoint_38'` | 831
`'checkpoint_39'` | 831
`'checkpoint_40'` | 834
`'checkpoint_41'` | 824
`'checkpoint_42'` | 822
`'checkpoint_43'` | 838
`'checkpoint_44'` | 843
`'checkpoint_45'` | 829
`'checkpoint_46'` | 830
`'checkpoint_47'` | 834
`'checkpoint_48'` | 1,105
`'checkpoint_49'` | 1,108

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):

<!-- mdformat off(HTML should not be auto-formatted) -->

{% framebox %}

<button id="displaydataframe">Display examples...</button>
<div id="dataframecontent" style="overflow-x:auto"></div>
<script>
const url = "https://storage.googleapis.com/tfds-data/visualization/dataframe/rlu_atari_checkpoints-BankHeist_run_4-1.1.0.html";
const dataButton = document.getElementById('displaydataframe');
dataButton.addEventListener('click', async () => {
  // Disable the button after clicking (dataframe loaded only once).
  dataButton.disabled = true;

  const contentPane = document.getElementById('dataframecontent');
  try {
    const response = await fetch(url);
    // Error response codes don't throw an error, so force an error to show
    // the error message.
    if (!response.ok) throw Error(response.statusText);

    const data = await response.text();
    contentPane.innerHTML = data;
  } catch (e) {
    contentPane.innerHTML =
        'Error loading examples. If the error persist, please open '
        + 'a new issue.';
  }
});
</script>

{% endframebox %}

<!-- mdformat on -->

## rlu_atari_checkpoints/BankHeist_run_5

*   **Dataset size**: `71.96 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 1,463
`'checkpoint_01'` | 1,310
`'checkpoint_02'` | 908
`'checkpoint_03'` | 788
`'checkpoint_04'` | 745
`'checkpoint_05'` | 735
`'checkpoint_06'` | 731
`'checkpoint_07'` | 746
`'checkpoint_08'` | 760
`'checkpoint_09'` | 769
`'checkpoint_10'` | 770
`'checkpoint_11'` | 774
`'checkpoint_12'` | 802
`'checkpoint_13'` | 799
`'checkpoint_14'` | 797
`'checkpoint_15'` | 809
`'checkpoint_16'` | 796
`'checkpoint_17'` | 796
`'checkpoint_18'` | 788
`'checkpoint_19'` | 798
`'checkpoint_20'` | 800
`'checkpoint_21'` | 808
`'checkpoint_22'` | 820
`'checkpoint_23'` | 811
`'checkpoint_24'` | 810
`'checkpoint_25'` | 815
`'checkpoint_26'` | 821
`'checkpoint_27'` | 929
`'checkpoint_28'` | 848
`'checkpoint_29'` | 821
`'checkpoint_30'` | 797
`'checkpoint_31'` | 812
`'checkpoint_32'` | 802
`'checkpoint_33'` | 824
`'checkpoint_34'` | 815
`'checkpoint_35'` | 824
`'checkpoint_36'` | 839
`'checkpoint_37'` | 824
`'checkpoint_38'` | 834
`'checkpoint_39'` | 843
`'checkpoint_40'` | 827
`'checkpoint_41'` | 849
`'checkpoint_42'` | 855
`'checkpoint_43'` | 847
`'checkpoint_44'` | 849
`'checkpoint_45'` | 861
`'checkpoint_46'` | 872
`'checkpoint_47'` | 873
`'checkpoint_48'` | 852
`'checkpoint_49'` | 869

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):

<!-- mdformat off(HTML should not be auto-formatted) -->

{% framebox %}

<button id="displaydataframe">Display examples...</button>
<div id="dataframecontent" style="overflow-x:auto"></div>
<script>
const url = "https://storage.googleapis.com/tfds-data/visualization/dataframe/rlu_atari_checkpoints-BankHeist_run_5-1.1.0.html";
const dataButton = document.getElementById('displaydataframe');
dataButton.addEventListener('click', async () => {
  // Disable the button after clicking (dataframe loaded only once).
  dataButton.disabled = true;

  const contentPane = document.getElementById('dataframecontent');
  try {
    const response = await fetch(url);
    // Error response codes don't throw an error, so force an error to show
    // the error message.
    if (!response.ok) throw Error(response.statusText);

    const data = await response.text();
    contentPane.innerHTML = data;
  } catch (e) {
    contentPane.innerHTML =
        'Error loading examples. If the error persist, please open '
        + 'a new issue.';
  }
});
</script>

{% endframebox %}

<!-- mdformat on -->

## rlu_atari_checkpoints/BattleZone_run_1

*   **Dataset size**: `57.82 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 641
`'checkpoint_01'` | 629
`'checkpoint_02'` | 627
`'checkpoint_03'` | 557
`'checkpoint_04'` | 483
`'checkpoint_05'` | 535
`'checkpoint_06'` | 506
`'checkpoint_07'` | 530
`'checkpoint_08'` | 647
`'checkpoint_09'` | 513
`'checkpoint_10'` | 516
`'checkpoint_11'` | 524
`'checkpoint_12'` | 511
`'checkpoint_13'` | 491
`'checkpoint_14'` | 512
`'checkpoint_15'` | 483
`'checkpoint_16'` | 427
`'checkpoint_17'` | 464
`'checkpoint_18'` | 417
`'checkpoint_19'` | 457
`'checkpoint_20'` | 461
`'checkpoint_21'` | 466
`'checkpoint_22'` | 440
`'checkpoint_23'` | 429
`'checkpoint_24'` | 432
`'checkpoint_25'` | 474
`'checkpoint_26'` | 425
`'checkpoint_27'` | 418
`'checkpoint_28'` | 392
`'checkpoint_29'` | 426
`'checkpoint_30'` | 450
`'checkpoint_31'` | 432
`'checkpoint_32'` | 441
`'checkpoint_33'` | 392
`'checkpoint_34'` | 425
`'checkpoint_35'` | 414
`'checkpoint_36'` | 485
`'checkpoint_37'` | 516
`'checkpoint_38'` | 453
`'checkpoint_39'` | 469
`'checkpoint_40'` | 455
`'checkpoint_41'` | 469
`'checkpoint_42'` | 494
`'checkpoint_43'` | 464
`'checkpoint_44'` | 429
`'checkpoint_45'` | 434
`'checkpoint_46'` | 467
`'checkpoint_47'` | 429
`'checkpoint_48'` | 455
`'checkpoint_49'` | 458

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):

<!-- mdformat off(HTML should not be auto-formatted) -->

{% framebox %}

<button id="displaydataframe">Display examples...</button>
<div id="dataframecontent" style="overflow-x:auto"></div>
<script>
const url = "https://storage.googleapis.com/tfds-data/visualization/dataframe/rlu_atari_checkpoints-BattleZone_run_1-1.1.0.html";
const dataButton = document.getElementById('displaydataframe');
dataButton.addEventListener('click', async () => {
  // Disable the button after clicking (dataframe loaded only once).
  dataButton.disabled = true;

  const contentPane = document.getElementById('dataframecontent');
  try {
    const response = await fetch(url);
    // Error response codes don't throw an error, so force an error to show
    // the error message.
    if (!response.ok) throw Error(response.statusText);

    const data = await response.text();
    contentPane.innerHTML = data;
  } catch (e) {
    contentPane.innerHTML =
        'Error loading examples. If the error persist, please open '
        + 'a new issue.';
  }
});
</script>

{% endframebox %}

<!-- mdformat on -->

## rlu_atari_checkpoints/BattleZone_run_2

*   **Dataset size**: `57.79 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 623
`'checkpoint_01'` | 603
`'checkpoint_02'` | 625
`'checkpoint_03'` | 613
`'checkpoint_04'` | 568
`'checkpoint_05'` | 573
`'checkpoint_06'` | 475
`'checkpoint_07'` | 461
`'checkpoint_08'` | 490
`'checkpoint_09'` | 580
`'checkpoint_10'` | 500
`'checkpoint_11'` | 604
`'checkpoint_12'` | 566
`'checkpoint_13'` | 545
`'checkpoint_14'` | 547
`'checkpoint_15'` | 525
`'checkpoint_16'` | 504
`'checkpoint_17'` | 491
`'checkpoint_18'` | 508
`'checkpoint_19'` | 490
`'checkpoint_20'` | 509
`'checkpoint_21'` | 537
`'checkpoint_22'` | 497
`'checkpoint_23'` | 507
`'checkpoint_24'` | 556
`'checkpoint_25'` | 521
`'checkpoint_26'` | 522
`'checkpoint_27'` | 493
`'checkpoint_28'` | 573
`'checkpoint_29'` | 548
`'checkpoint_30'` | 568
`'checkpoint_31'` | 558
`'checkpoint_32'` | 493
`'checkpoint_33'` | 450
`'checkpoint_34'` | 536
`'checkpoint_35'` | 572
`'checkpoint_36'` | 527
`'checkpoint_37'` | 522
`'checkpoint_38'` | 436
`'checkpoint_39'` | 491
`'checkpoint_40'` | 528
`'checkpoint_41'` | 518
`'checkpoint_42'` | 516
`'checkpoint_43'` | 506
`'checkpoint_44'` | 489
`'checkpoint_45'` | 388
`'checkpoint_46'` | 556
`'checkpoint_47'` | 492
`'checkpoint_48'` | 444
`'checkpoint_49'` | 480

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):

<!-- mdformat off(HTML should not be auto-formatted) -->

{% framebox %}

<button id="displaydataframe">Display examples...</button>
<div id="dataframecontent" style="overflow-x:auto"></div>
<script>
const url = "https://storage.googleapis.com/tfds-data/visualization/dataframe/rlu_atari_checkpoints-BattleZone_run_2-1.1.0.html";
const dataButton = document.getElementById('displaydataframe');
dataButton.addEventListener('click', async () => {
  // Disable the button after clicking (dataframe loaded only once).
  dataButton.disabled = true;

  const contentPane = document.getElementById('dataframecontent');
  try {
    const response = await fetch(url);
    // Error response codes don't throw an error, so force an error to show
    // the error message.
    if (!response.ok) throw Error(response.statusText);

    const data = await response.text();
    contentPane.innerHTML = data;
  } catch (e) {
    contentPane.innerHTML =
        'Error loading examples. If the error persist, please open '
        + 'a new issue.';
  }
});
</script>

{% endframebox %}

<!-- mdformat on -->

## rlu_atari_checkpoints/BattleZone_run_3

*   **Dataset size**: `57.80 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 674
`'checkpoint_01'` | 665
`'checkpoint_02'` | 623
`'checkpoint_03'` | 607
`'checkpoint_04'` | 452
`'checkpoint_05'` | 522
`'checkpoint_06'` | 493
`'checkpoint_07'` | 522
`'checkpoint_08'` | 500
`'checkpoint_09'` | 541
`'checkpoint_10'` | 574
`'checkpoint_11'` | 496
`'checkpoint_12'` | 564
`'checkpoint_13'` | 512
`'checkpoint_14'` | 484
`'checkpoint_15'` | 482
`'checkpoint_16'` | 459
`'checkpoint_17'` | 506
`'checkpoint_18'` | 486
`'checkpoint_19'` | 446
`'checkpoint_20'` | 462
`'checkpoint_21'` | 424
`'checkpoint_22'` | 490
`'checkpoint_23'` | 472
`'checkpoint_24'` | 467
`'checkpoint_25'` | 520
`'checkpoint_26'` | 456
`'checkpoint_27'` | 483
`'checkpoint_28'` | 501
`'checkpoint_29'` | 495
`'checkpoint_30'` | 468
`'checkpoint_31'` | 494
`'checkpoint_32'` | 444
`'checkpoint_33'` | 498
`'checkpoint_34'` | 500
`'checkpoint_35'` | 433
`'checkpoint_36'` | 495
`'checkpoint_37'` | 465
`'checkpoint_38'` | 424
`'checkpoint_39'` | 470
`'checkpoint_40'` | 452
`'checkpoint_41'` | 489
`'checkpoint_42'` | 416
`'checkpoint_43'` | 505
`'checkpoint_44'` | 515
`'checkpoint_45'` | 469
`'checkpoint_46'` | 427
`'checkpoint_47'` | 478
`'checkpoint_48'` | 458
`'checkpoint_49'` | 428

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):

<!-- mdformat off(HTML should not be auto-formatted) -->

{% framebox %}

<button id="displaydataframe">Display examples...</button>
<div id="dataframecontent" style="overflow-x:auto"></div>
<script>
const url = "https://storage.googleapis.com/tfds-data/visualization/dataframe/rlu_atari_checkpoints-BattleZone_run_3-1.1.0.html";
const dataButton = document.getElementById('displaydataframe');
dataButton.addEventListener('click', async () => {
  // Disable the button after clicking (dataframe loaded only once).
  dataButton.disabled = true;

  const contentPane = document.getElementById('dataframecontent');
  try {
    const response = await fetch(url);
    // Error response codes don't throw an error, so force an error to show
    // the error message.
    if (!response.ok) throw Error(response.statusText);

    const data = await response.text();
    contentPane.innerHTML = data;
  } catch (e) {
    contentPane.innerHTML =
        'Error loading examples. If the error persist, please open '
        + 'a new issue.';
  }
});
</script>

{% endframebox %}

<!-- mdformat on -->

## rlu_atari_checkpoints/BattleZone_run_4

*   **Dataset size**: `57.73 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 614
`'checkpoint_01'` | 615
`'checkpoint_02'` | 603
`'checkpoint_03'` | 536
`'checkpoint_04'` | 514
`'checkpoint_05'` | 505
`'checkpoint_06'` | 500
`'checkpoint_07'` | 528
`'checkpoint_08'` | 524
`'checkpoint_09'` | 484
`'checkpoint_10'` | 493
`'checkpoint_11'` | 525
`'checkpoint_12'` | 457
`'checkpoint_13'` | 405
`'checkpoint_14'` | 477
`'checkpoint_15'` | 428
`'checkpoint_16'` | 410
`'checkpoint_17'` | 431
`'checkpoint_18'` | 468
`'checkpoint_19'` | 393
`'checkpoint_20'` | 453
`'checkpoint_21'` | 361
`'checkpoint_22'` | 407
`'checkpoint_23'` | 424
`'checkpoint_24'` | 469
`'checkpoint_25'` | 449
`'checkpoint_26'` | 460
`'checkpoint_27'` | 367
`'checkpoint_28'` | 446
`'checkpoint_29'` | 399
`'checkpoint_30'` | 385
`'checkpoint_31'` | 415
`'checkpoint_32'` | 418
`'checkpoint_33'` | 484
`'checkpoint_34'` | 471
`'checkpoint_35'` | 494
`'checkpoint_36'` | 415
`'checkpoint_37'` | 404
`'checkpoint_38'` | 431
`'checkpoint_39'` | 438
`'checkpoint_40'` | 442
`'checkpoint_41'` | 410
`'checkpoint_42'` | 391
`'checkpoint_43'` | 396
`'checkpoint_44'` | 440
`'checkpoint_45'` | 404
`'checkpoint_46'` | 407
`'checkpoint_47'` | 429
`'checkpoint_48'` | 443
`'checkpoint_49'` | 388

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):

<!-- mdformat off(HTML should not be auto-formatted) -->

{% framebox %}

<button id="displaydataframe">Display examples...</button>
<div id="dataframecontent" style="overflow-x:auto"></div>
<script>
const url = "https://storage.googleapis.com/tfds-data/visualization/dataframe/rlu_atari_checkpoints-BattleZone_run_4-1.1.0.html";
const dataButton = document.getElementById('displaydataframe');
dataButton.addEventListener('click', async () => {
  // Disable the button after clicking (dataframe loaded only once).
  dataButton.disabled = true;

  const contentPane = document.getElementById('dataframecontent');
  try {
    const response = await fetch(url);
    // Error response codes don't throw an error, so force an error to show
    // the error message.
    if (!response.ok) throw Error(response.statusText);

    const data = await response.text();
    contentPane.innerHTML = data;
  } catch (e) {
    contentPane.innerHTML =
        'Error loading examples. If the error persist, please open '
        + 'a new issue.';
  }
});
</script>

{% endframebox %}

<!-- mdformat on -->

## rlu_atari_checkpoints/BattleZone_run_5

*   **Dataset size**: `57.83 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 639
`'checkpoint_01'` | 649
`'checkpoint_02'` | 588
`'checkpoint_03'` | 527
`'checkpoint_04'` | 495
`'checkpoint_05'` | 486
`'checkpoint_06'` | 514
`'checkpoint_07'` | 555
`'checkpoint_08'` | 494
`'checkpoint_09'` | 550
`'checkpoint_10'` | 531
`'checkpoint_11'` | 509
`'checkpoint_12'` | 521
`'checkpoint_13'` | 573
`'checkpoint_14'` | 495
`'checkpoint_15'` | 474
`'checkpoint_16'` | 549
`'checkpoint_17'` | 510
`'checkpoint_18'` | 504
`'checkpoint_19'` | 517
`'checkpoint_20'` | 535
`'checkpoint_21'` | 463
`'checkpoint_22'` | 481
`'checkpoint_23'` | 516
`'checkpoint_24'` | 496
`'checkpoint_25'` | 565
`'checkpoint_26'` | 524
`'checkpoint_27'` | 480
`'checkpoint_28'` | 476
`'checkpoint_29'` | 497
`'checkpoint_30'` | 482
`'checkpoint_31'` | 413
`'checkpoint_32'` | 471
`'checkpoint_33'` | 493
`'checkpoint_34'` | 486
`'checkpoint_35'` | 530
`'checkpoint_36'` | 460
`'checkpoint_37'` | 506
`'checkpoint_38'` | 462
`'checkpoint_39'` | 480
`'checkpoint_40'` | 468
`'checkpoint_41'` | 477
`'checkpoint_42'` | 488
`'checkpoint_43'` | 500
`'checkpoint_44'` | 511
`'checkpoint_45'` | 496
`'checkpoint_46'` | 441
`'checkpoint_47'` | 530
`'checkpoint_48'` | 497
`'checkpoint_49'` | 543

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):

<!-- mdformat off(HTML should not be auto-formatted) -->

{% framebox %}

<button id="displaydataframe">Display examples...</button>
<div id="dataframecontent" style="overflow-x:auto"></div>
<script>
const url = "https://storage.googleapis.com/tfds-data/visualization/dataframe/rlu_atari_checkpoints-BattleZone_run_5-1.1.0.html";
const dataButton = document.getElementById('displaydataframe');
dataButton.addEventListener('click', async () => {
  // Disable the button after clicking (dataframe loaded only once).
  dataButton.disabled = true;

  const contentPane = document.getElementById('dataframecontent');
  try {
    const response = await fetch(url);
    // Error response codes don't throw an error, so force an error to show
    // the error message.
    if (!response.ok) throw Error(response.statusText);

    const data = await response.text();
    contentPane.innerHTML = data;
  } catch (e) {
    contentPane.innerHTML =
        'Error loading examples. If the error persist, please open '
        + 'a new issue.';
  }
});
</script>

{% endframebox %}

<!-- mdformat on -->

## rlu_atari_checkpoints/BeamRider_run_1

*   **Dataset size**: `43.72 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 725
`'checkpoint_01'` | 712
`'checkpoint_02'` | 565
`'checkpoint_03'` | 269
`'checkpoint_04'` | 307
`'checkpoint_05'` | 362
`'checkpoint_06'` | 343
`'checkpoint_07'` | 333
`'checkpoint_08'` | 320
`'checkpoint_09'` | 330
`'checkpoint_10'` | 318
`'checkpoint_11'` | 320
`'checkpoint_12'` | 324
`'checkpoint_13'` | 316
`'checkpoint_14'` | 326
`'checkpoint_15'` | 320
`'checkpoint_16'` | 308
`'checkpoint_17'` | 313
`'checkpoint_18'` | 293
`'checkpoint_19'` | 291
`'checkpoint_20'` | 309
`'checkpoint_21'` | 304
`'checkpoint_22'` | 307
`'checkpoint_23'` | 304
`'checkpoint_24'` | 291
`'checkpoint_25'` | 306
`'checkpoint_26'` | 299
`'checkpoint_27'` | 295
`'checkpoint_28'` | 300
`'checkpoint_29'` | 299
`'checkpoint_30'` | 287
`'checkpoint_31'` | 303
`'checkpoint_32'` | 294
`'checkpoint_33'` | 299
`'checkpoint_34'` | 293
`'checkpoint_35'` | 293
`'checkpoint_36'` | 294
`'checkpoint_37'` | 305
`'checkpoint_38'` | 313
`'checkpoint_39'` | 312
`'checkpoint_40'` | 303
`'checkpoint_41'` | 298
`'checkpoint_42'` | 299
`'checkpoint_43'` | 279
`'checkpoint_44'` | 302
`'checkpoint_45'` | 305
`'checkpoint_46'` | 291
`'checkpoint_47'` | 301
`'checkpoint_48'` | 310
`'checkpoint_49'` | 313

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):

<!-- mdformat off(HTML should not be auto-formatted) -->

{% framebox %}

<button id="displaydataframe">Display examples...</button>
<div id="dataframecontent" style="overflow-x:auto"></div>
<script>
const url = "https://storage.googleapis.com/tfds-data/visualization/dataframe/rlu_atari_checkpoints-BeamRider_run_1-1.1.0.html";
const dataButton = document.getElementById('displaydataframe');
dataButton.addEventListener('click', async () => {
  // Disable the button after clicking (dataframe loaded only once).
  dataButton.disabled = true;

  const contentPane = document.getElementById('dataframecontent');
  try {
    const response = await fetch(url);
    // Error response codes don't throw an error, so force an error to show
    // the error message.
    if (!response.ok) throw Error(response.statusText);

    const data = await response.text();
    contentPane.innerHTML = data;
  } catch (e) {
    contentPane.innerHTML =
        'Error loading examples. If the error persist, please open '
        + 'a new issue.';
  }
});
</script>

{% endframebox %}

<!-- mdformat on -->

## rlu_atari_checkpoints/BeamRider_run_2

*   **Dataset size**: `43.74 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 739
`'checkpoint_01'` | 715
`'checkpoint_02'` | 504
`'checkpoint_03'` | 236
`'checkpoint_04'` | 315
`'checkpoint_05'` | 387
`'checkpoint_06'` | 322
`'checkpoint_07'` | 344
`'checkpoint_08'` | 328
`'checkpoint_09'` | 337
`'checkpoint_10'` | 320
`'checkpoint_11'` | 322
`'checkpoint_12'` | 311
`'checkpoint_13'` | 319
`'checkpoint_14'` | 301
`'checkpoint_15'` | 312
`'checkpoint_16'` | 304
`'checkpoint_17'` | 301
`'checkpoint_18'` | 302
`'checkpoint_19'` | 302
`'checkpoint_20'` | 295
`'checkpoint_21'` | 315
`'checkpoint_22'` | 294
`'checkpoint_23'` | 303
`'checkpoint_24'` | 296
`'checkpoint_25'` | 303
`'checkpoint_26'` | 306
`'checkpoint_27'` | 296
`'checkpoint_28'` | 287
`'checkpoint_29'` | 297
`'checkpoint_30'` | 281
`'checkpoint_31'` | 282
`'checkpoint_32'` | 277
`'checkpoint_33'` | 291
`'checkpoint_34'` | 298
`'checkpoint_35'` | 277
`'checkpoint_36'` | 290
`'checkpoint_37'` | 299
`'checkpoint_38'` | 286
`'checkpoint_39'` | 310
`'checkpoint_40'` | 293
`'checkpoint_41'` | 291
`'checkpoint_42'` | 288
`'checkpoint_43'` | 310
`'checkpoint_44'` | 293
`'checkpoint_45'` | 291
`'checkpoint_46'` | 283
`'checkpoint_47'` | 283
`'checkpoint_48'` | 299
`'checkpoint_49'` | 303

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):

<!-- mdformat off(HTML should not be auto-formatted) -->

{% framebox %}

<button id="displaydataframe">Display examples...</button>
<div id="dataframecontent" style="overflow-x:auto"></div>
<script>
const url = "https://storage.googleapis.com/tfds-data/visualization/dataframe/rlu_atari_checkpoints-BeamRider_run_2-1.1.0.html";
const dataButton = document.getElementById('displaydataframe');
dataButton.addEventListener('click', async () => {
  // Disable the button after clicking (dataframe loaded only once).
  dataButton.disabled = true;

  const contentPane = document.getElementById('dataframecontent');
  try {
    const response = await fetch(url);
    // Error response codes don't throw an error, so force an error to show
    // the error message.
    if (!response.ok) throw Error(response.statusText);

    const data = await response.text();
    contentPane.innerHTML = data;
  } catch (e) {
    contentPane.innerHTML =
        'Error loading examples. If the error persist, please open '
        + 'a new issue.';
  }
});
</script>

{% endframebox %}

<!-- mdformat on -->

## rlu_atari_checkpoints/BeamRider_run_3

*   **Dataset size**: `43.72 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 727
`'checkpoint_01'` | 697
`'checkpoint_02'` | 522
`'checkpoint_03'` | 251
`'checkpoint_04'` | 286
`'checkpoint_05'` | 343
`'checkpoint_06'` | 355
`'checkpoint_07'` | 344
`'checkpoint_08'` | 304
`'checkpoint_09'` | 320
`'checkpoint_10'` | 313
`'checkpoint_11'` | 328
`'checkpoint_12'` | 329
`'checkpoint_13'` | 311
`'checkpoint_14'` | 309
`'checkpoint_15'` | 306
`'checkpoint_16'` | 302
`'checkpoint_17'` | 312
`'checkpoint_18'` | 301
`'checkpoint_19'` | 319
`'checkpoint_20'` | 305
`'checkpoint_21'` | 324
`'checkpoint_22'` | 302
`'checkpoint_23'` | 322
`'checkpoint_24'` | 300
`'checkpoint_25'` | 312
`'checkpoint_26'` | 310
`'checkpoint_27'` | 325
`'checkpoint_28'` | 315
`'checkpoint_29'` | 312
`'checkpoint_30'` | 307
`'checkpoint_31'` | 292
`'checkpoint_32'` | 305
`'checkpoint_33'` | 303
`'checkpoint_34'` | 321
`'checkpoint_35'` | 308
`'checkpoint_36'` | 319
`'checkpoint_37'` | 301
`'checkpoint_38'` | 308
`'checkpoint_39'` | 298
`'checkpoint_40'` | 315
`'checkpoint_41'` | 308
`'checkpoint_42'` | 318
`'checkpoint_43'` | 326
`'checkpoint_44'` | 322
`'checkpoint_45'` | 303
`'checkpoint_46'` | 298
`'checkpoint_47'` | 325
`'checkpoint_48'` | 312
`'checkpoint_49'` | 311

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):

<!-- mdformat off(HTML should not be auto-formatted) -->

{% framebox %}

<button id="displaydataframe">Display examples...</button>
<div id="dataframecontent" style="overflow-x:auto"></div>
<script>
const url = "https://storage.googleapis.com/tfds-data/visualization/dataframe/rlu_atari_checkpoints-BeamRider_run_3-1.1.0.html";
const dataButton = document.getElementById('displaydataframe');
dataButton.addEventListener('click', async () => {
  // Disable the button after clicking (dataframe loaded only once).
  dataButton.disabled = true;

  const contentPane = document.getElementById('dataframecontent');
  try {
    const response = await fetch(url);
    // Error response codes don't throw an error, so force an error to show
    // the error message.
    if (!response.ok) throw Error(response.statusText);

    const data = await response.text();
    contentPane.innerHTML = data;
  } catch (e) {
    contentPane.innerHTML =
        'Error loading examples. If the error persist, please open '
        + 'a new issue.';
  }
});
</script>

{% endframebox %}

<!-- mdformat on -->

## rlu_atari_checkpoints/BeamRider_run_4

*   **Dataset size**: `43.72 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 730
`'checkpoint_01'` | 688
`'checkpoint_02'` | 534
`'checkpoint_03'` | 263
`'checkpoint_04'` | 298
`'checkpoint_05'` | 366
`'checkpoint_06'` | 360
`'checkpoint_07'` | 324
`'checkpoint_08'` | 328
`'checkpoint_09'` | 321
`'checkpoint_10'` | 298
`'checkpoint_11'` | 314
`'checkpoint_12'` | 299
`'checkpoint_13'` | 308
`'checkpoint_14'` | 305
`'checkpoint_15'` | 309
`'checkpoint_16'` | 300
`'checkpoint_17'` | 295
`'checkpoint_18'` | 301
`'checkpoint_19'` | 316
`'checkpoint_20'` | 294
`'checkpoint_21'` | 306
`'checkpoint_22'` | 304
`'checkpoint_23'` | 303
`'checkpoint_24'` | 292
`'checkpoint_25'` | 290
`'checkpoint_26'` | 296
`'checkpoint_27'` | 298
`'checkpoint_28'` | 294
`'checkpoint_29'` | 301
`'checkpoint_30'` | 310
`'checkpoint_31'` | 312
`'checkpoint_32'` | 294
`'checkpoint_33'` | 299
`'checkpoint_34'` | 306
`'checkpoint_35'` | 299
`'checkpoint_36'` | 300
`'checkpoint_37'` | 312
`'checkpoint_38'` | 302
`'checkpoint_39'` | 300
`'checkpoint_40'` | 295
`'checkpoint_41'` | 290
`'checkpoint_42'` | 297
`'checkpoint_43'` | 304
`'checkpoint_44'` | 308
`'checkpoint_45'` | 324
`'checkpoint_46'` | 311
`'checkpoint_47'` | 304
`'checkpoint_48'` | 304
`'checkpoint_49'` | 310

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):

<!-- mdformat off(HTML should not be auto-formatted) -->

{% framebox %}

<button id="displaydataframe">Display examples...</button>
<div id="dataframecontent" style="overflow-x:auto"></div>
<script>
const url = "https://storage.googleapis.com/tfds-data/visualization/dataframe/rlu_atari_checkpoints-BeamRider_run_4-1.1.0.html";
const dataButton = document.getElementById('displaydataframe');
dataButton.addEventListener('click', async () => {
  // Disable the button after clicking (dataframe loaded only once).
  dataButton.disabled = true;

  const contentPane = document.getElementById('dataframecontent');
  try {
    const response = await fetch(url);
    // Error response codes don't throw an error, so force an error to show
    // the error message.
    if (!response.ok) throw Error(response.statusText);

    const data = await response.text();
    contentPane.innerHTML = data;
  } catch (e) {
    contentPane.innerHTML =
        'Error loading examples. If the error persist, please open '
        + 'a new issue.';
  }
});
</script>

{% endframebox %}

<!-- mdformat on -->

## rlu_atari_checkpoints/BeamRider_run_5

*   **Dataset size**: `43.74 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 732
`'checkpoint_01'` | 740
`'checkpoint_02'` | 566
`'checkpoint_03'` | 251
`'checkpoint_04'` | 291
`'checkpoint_05'` | 359
`'checkpoint_06'` | 328
`'checkpoint_07'` | 347
`'checkpoint_08'` | 323
`'checkpoint_09'` | 319
`'checkpoint_10'` | 330
`'checkpoint_11'` | 312
`'checkpoint_12'` | 316
`'checkpoint_13'` | 321
`'checkpoint_14'` | 304
`'checkpoint_15'` | 288
`'checkpoint_16'` | 313
`'checkpoint_17'` | 312
`'checkpoint_18'` | 307
`'checkpoint_19'` | 294
`'checkpoint_20'` | 295
`'checkpoint_21'` | 302
`'checkpoint_22'` | 301
`'checkpoint_23'` | 288
`'checkpoint_24'` | 294
`'checkpoint_25'` | 293
`'checkpoint_26'` | 307
`'checkpoint_27'` | 298
`'checkpoint_28'` | 290
`'checkpoint_29'` | 300
`'checkpoint_30'` | 287
`'checkpoint_31'` | 286
`'checkpoint_32'` | 298
`'checkpoint_33'` | 292
`'checkpoint_34'` | 285
`'checkpoint_35'` | 281
`'checkpoint_36'` | 294
`'checkpoint_37'` | 285
`'checkpoint_38'` | 290
`'checkpoint_39'` | 284
`'checkpoint_40'` | 291
`'checkpoint_41'` | 278
`'checkpoint_42'` | 292
`'checkpoint_43'` | 292
`'checkpoint_44'` | 288
`'checkpoint_45'` | 290
`'checkpoint_46'` | 293
`'checkpoint_47'` | 275
`'checkpoint_48'` | 278
`'checkpoint_49'` | 296

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):

<!-- mdformat off(HTML should not be auto-formatted) -->

{% framebox %}

<button id="displaydataframe">Display examples...</button>
<div id="dataframecontent" style="overflow-x:auto"></div>
<script>
const url = "https://storage.googleapis.com/tfds-data/visualization/dataframe/rlu_atari_checkpoints-BeamRider_run_5-1.1.0.html";
const dataButton = document.getElementById('displaydataframe');
dataButton.addEventListener('click', async () => {
  // Disable the button after clicking (dataframe loaded only once).
  dataButton.disabled = true;

  const contentPane = document.getElementById('dataframecontent');
  try {
    const response = await fetch(url);
    // Error response codes don't throw an error, so force an error to show
    // the error message.
    if (!response.ok) throw Error(response.statusText);

    const data = await response.text();
    contentPane.innerHTML = data;
  } catch (e) {
    contentPane.innerHTML =
        'Error loading examples. If the error persist, please open '
        + 'a new issue.';
  }
});
</script>

{% endframebox %}

<!-- mdformat on -->

## rlu_atari_checkpoints/Boxing_run_1

*   **Dataset size**: `45.81 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 559
`'checkpoint_01'` | 567
`'checkpoint_02'` | 733
`'checkpoint_03'` | 987
`'checkpoint_04'` | 1,052
`'checkpoint_05'` | 1,079
`'checkpoint_06'` | 1,164
`'checkpoint_07'` | 1,086
`'checkpoint_08'` | 820
`'checkpoint_09'` | 934
`'checkpoint_10'` | 864
`'checkpoint_11'` | 882
`'checkpoint_12'` | 940
`'checkpoint_13'` | 1,027
`'checkpoint_14'` | 1,044
`'checkpoint_15'` | 1,083
`'checkpoint_16'` | 1,136
`'checkpoint_17'` | 1,074
`'checkpoint_18'` | 1,096
`'checkpoint_19'` | 1,055
`'checkpoint_20'` | 1,057
`'checkpoint_21'` | 1,119
`'checkpoint_22'` | 1,119
`'checkpoint_23'` | 1,045
`'checkpoint_24'` | 1,042
`'checkpoint_25'` | 1,080
`'checkpoint_26'` | 1,051
`'checkpoint_27'` | 1,035
`'checkpoint_28'` | 1,038
`'checkpoint_29'` | 1,006
`'checkpoint_30'` | 1,026
`'checkpoint_31'` | 1,010
`'checkpoint_32'` | 1,005
`'checkpoint_33'` | 988
`'checkpoint_34'` | 1,011
`'checkpoint_35'` | 1,025
`'checkpoint_36'` | 995
`'checkpoint_37'` | 1,012
`'checkpoint_38'` | 996
`'checkpoint_39'` | 995
`'checkpoint_40'` | 974
`'checkpoint_41'` | 979
`'checkpoint_42'` | 951
`'checkpoint_43'` | 972
`'checkpoint_44'` | 986
`'checkpoint_45'` | 954
`'checkpoint_46'` | 954
`'checkpoint_47'` | 950
`'checkpoint_48'` | 972
`'checkpoint_49'` | 956

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):

<!-- mdformat off(HTML should not be auto-formatted) -->

{% framebox %}

<button id="displaydataframe">Display examples...</button>
<div id="dataframecontent" style="overflow-x:auto"></div>
<script>
const url = "https://storage.googleapis.com/tfds-data/visualization/dataframe/rlu_atari_checkpoints-Boxing_run_1-1.1.0.html";
const dataButton = document.getElementById('displaydataframe');
dataButton.addEventListener('click', async () => {
  // Disable the button after clicking (dataframe loaded only once).
  dataButton.disabled = true;

  const contentPane = document.getElementById('dataframecontent');
  try {
    const response = await fetch(url);
    // Error response codes don't throw an error, so force an error to show
    // the error message.
    if (!response.ok) throw Error(response.statusText);

    const data = await response.text();
    contentPane.innerHTML = data;
  } catch (e) {
    contentPane.innerHTML =
        'Error loading examples. If the error persist, please open '
        + 'a new issue.';
  }
});
</script>

{% endframebox %}

<!-- mdformat on -->

## rlu_atari_checkpoints/Boxing_run_2

*   **Dataset size**: `45.59 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 559
`'checkpoint_01'` | 588
`'checkpoint_02'` | 773
`'checkpoint_03'` | 987
`'checkpoint_04'` | 1,098
`'checkpoint_05'` | 1,172
`'checkpoint_06'` | 1,218
`'checkpoint_07'` | 1,242
`'checkpoint_08'` | 1,055
`'checkpoint_09'` | 965
`'checkpoint_10'` | 953
`'checkpoint_11'` | 915
`'checkpoint_12'` | 1,062
`'checkpoint_13'` | 1,023
`'checkpoint_14'` | 1,127
`'checkpoint_15'` | 1,154
`'checkpoint_16'` | 1,170
`'checkpoint_17'` | 1,174
`'checkpoint_18'` | 1,162
`'checkpoint_19'` | 1,128
`'checkpoint_20'` | 1,165
`'checkpoint_21'` | 1,161
`'checkpoint_22'` | 1,131
`'checkpoint_23'` | 1,123
`'checkpoint_24'` | 1,147
`'checkpoint_25'` | 1,120
`'checkpoint_26'` | 1,112
`'checkpoint_27'` | 1,141
`'checkpoint_28'` | 1,128
`'checkpoint_29'` | 1,118
`'checkpoint_30'` | 1,125
`'checkpoint_31'` | 1,118
`'checkpoint_32'` | 1,136
`'checkpoint_33'` | 1,106
`'checkpoint_34'` | 1,094
`'checkpoint_35'` | 1,105
`'checkpoint_36'` | 1,108
`'checkpoint_37'` | 1,145
`'checkpoint_38'` | 1,102
`'checkpoint_39'` | 1,111
`'checkpoint_40'` | 1,102
`'checkpoint_41'` | 1,082
`'checkpoint_42'` | 1,082
`'checkpoint_43'` | 1,072
`'checkpoint_44'` | 1,083
`'checkpoint_45'` | 1,050
`'checkpoint_46'` | 1,026
`'checkpoint_47'` | 1,040
`'checkpoint_48'` | 1,046
`'checkpoint_49'` | 1,047

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):

<!-- mdformat off(HTML should not be auto-formatted) -->

{% framebox %}

<button id="displaydataframe">Display examples...</button>
<div id="dataframecontent" style="overflow-x:auto"></div>
<script>
const url = "https://storage.googleapis.com/tfds-data/visualization/dataframe/rlu_atari_checkpoints-Boxing_run_2-1.1.0.html";
const dataButton = document.getElementById('displaydataframe');
dataButton.addEventListener('click', async () => {
  // Disable the button after clicking (dataframe loaded only once).
  dataButton.disabled = true;

  const contentPane = document.getElementById('dataframecontent');
  try {
    const response = await fetch(url);
    // Error response codes don't throw an error, so force an error to show
    // the error message.
    if (!response.ok) throw Error(response.statusText);

    const data = await response.text();
    contentPane.innerHTML = data;
  } catch (e) {
    contentPane.innerHTML =
        'Error loading examples. If the error persist, please open '
        + 'a new issue.';
  }
});
</script>

{% endframebox %}

<!-- mdformat on -->

## rlu_atari_checkpoints/Boxing_run_3

*   **Dataset size**: `45.79 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 559
`'checkpoint_01'` | 566
`'checkpoint_02'` | 724
`'checkpoint_03'` | 1,020
`'checkpoint_04'` | 1,127
`'checkpoint_05'` | 1,061
`'checkpoint_06'` | 868
`'checkpoint_07'` | 907
`'checkpoint_08'` | 924
`'checkpoint_09'` | 974
`'checkpoint_10'` | 1,072
`'checkpoint_11'` | 1,122
`'checkpoint_12'` | 1,143
`'checkpoint_13'` | 1,131
`'checkpoint_14'` | 1,182
`'checkpoint_15'` | 1,176
`'checkpoint_16'` | 1,158
`'checkpoint_17'` | 1,158
`'checkpoint_18'` | 1,144
`'checkpoint_19'` | 1,163
`'checkpoint_20'` | 1,160
`'checkpoint_21'` | 1,151
`'checkpoint_22'` | 1,153
`'checkpoint_23'` | 1,145
`'checkpoint_24'` | 1,135
`'checkpoint_25'` | 1,126
`'checkpoint_26'` | 1,128
`'checkpoint_27'` | 1,115
`'checkpoint_28'` | 1,099
`'checkpoint_29'` | 1,064
`'checkpoint_30'` | 1,083
`'checkpoint_31'` | 1,061
`'checkpoint_32'` | 1,078
`'checkpoint_33'` | 1,066
`'checkpoint_34'` | 1,120
`'checkpoint_35'` | 1,080
`'checkpoint_36'` | 1,061
`'checkpoint_37'` | 1,071
`'checkpoint_38'` | 1,068
`'checkpoint_39'` | 1,066
`'checkpoint_40'` | 1,105
`'checkpoint_41'` | 1,108
`'checkpoint_42'` | 1,082
`'checkpoint_43'` | 1,103
`'checkpoint_44'` | 1,106
`'checkpoint_45'` | 1,081
`'checkpoint_46'` | 1,045
`'checkpoint_47'` | 1,069
`'checkpoint_48'` | 1,043
`'checkpoint_49'` | 1,049

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):

<!-- mdformat off(HTML should not be auto-formatted) -->

{% framebox %}

<button id="displaydataframe">Display examples...</button>
<div id="dataframecontent" style="overflow-x:auto"></div>
<script>
const url = "https://storage.googleapis.com/tfds-data/visualization/dataframe/rlu_atari_checkpoints-Boxing_run_3-1.1.0.html";
const dataButton = document.getElementById('displaydataframe');
dataButton.addEventListener('click', async () => {
  // Disable the button after clicking (dataframe loaded only once).
  dataButton.disabled = true;

  const contentPane = document.getElementById('dataframecontent');
  try {
    const response = await fetch(url);
    // Error response codes don't throw an error, so force an error to show
    // the error message.
    if (!response.ok) throw Error(response.statusText);

    const data = await response.text();
    contentPane.innerHTML = data;
  } catch (e) {
    contentPane.innerHTML =
        'Error loading examples. If the error persist, please open '
        + 'a new issue.';
  }
});
</script>

{% endframebox %}

<!-- mdformat on -->

## rlu_atari_checkpoints/Boxing_run_4

*   **Dataset size**: `45.68 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 559
`'checkpoint_01'` | 569
`'checkpoint_02'` | 785
`'checkpoint_03'` | 1,209
`'checkpoint_04'` | 1,195
`'checkpoint_05'` | 1,240
`'checkpoint_06'` | 1,031
`'checkpoint_07'` | 945
`'checkpoint_08'` | 941
`'checkpoint_09'` | 959
`'checkpoint_10'` | 979
`'checkpoint_11'` | 1,061
`'checkpoint_12'` | 1,105
`'checkpoint_13'` | 1,044
`'checkpoint_14'` | 1,104
`'checkpoint_15'` | 1,120
`'checkpoint_16'` | 1,137
`'checkpoint_17'` | 1,129
`'checkpoint_18'` | 1,109
`'checkpoint_19'` | 1,136
`'checkpoint_20'` | 1,143
`'checkpoint_21'` | 1,119
`'checkpoint_22'` | 1,130
`'checkpoint_23'` | 1,150
`'checkpoint_24'` | 1,159
`'checkpoint_25'` | 1,139
`'checkpoint_26'` | 1,137
`'checkpoint_27'` | 1,117
`'checkpoint_28'` | 1,129
`'checkpoint_29'` | 1,121
`'checkpoint_30'` | 1,068
`'checkpoint_31'` | 1,103
`'checkpoint_32'` | 1,084
`'checkpoint_33'` | 1,084
`'checkpoint_34'` | 1,105
`'checkpoint_35'` | 1,086
`'checkpoint_36'` | 1,101
`'checkpoint_37'` | 1,106
`'checkpoint_38'` | 1,105
`'checkpoint_39'` | 1,088
`'checkpoint_40'` | 1,131
`'checkpoint_41'` | 1,124
`'checkpoint_42'` | 1,129
`'checkpoint_43'` | 1,112
`'checkpoint_44'` | 1,101
`'checkpoint_45'` | 1,102
`'checkpoint_46'` | 1,136
`'checkpoint_47'` | 1,117
`'checkpoint_48'` | 1,080
`'checkpoint_49'` | 1,093

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):

<!-- mdformat off(HTML should not be auto-formatted) -->

{% framebox %}

<button id="displaydataframe">Display examples...</button>
<div id="dataframecontent" style="overflow-x:auto"></div>
<script>
const url = "https://storage.googleapis.com/tfds-data/visualization/dataframe/rlu_atari_checkpoints-Boxing_run_4-1.1.0.html";
const dataButton = document.getElementById('displaydataframe');
dataButton.addEventListener('click', async () => {
  // Disable the button after clicking (dataframe loaded only once).
  dataButton.disabled = true;

  const contentPane = document.getElementById('dataframecontent');
  try {
    const response = await fetch(url);
    // Error response codes don't throw an error, so force an error to show
    // the error message.
    if (!response.ok) throw Error(response.statusText);

    const data = await response.text();
    contentPane.innerHTML = data;
  } catch (e) {
    contentPane.innerHTML =
        'Error loading examples. If the error persist, please open '
        + 'a new issue.';
  }
});
</script>

{% endframebox %}

<!-- mdformat on -->

## rlu_atari_checkpoints/Boxing_run_5

*   **Dataset size**: `45.79 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 559
`'checkpoint_01'` | 560
`'checkpoint_02'` | 561
`'checkpoint_03'` | 579
`'checkpoint_04'` | 699
`'checkpoint_05'` | 959
`'checkpoint_06'` | 1,117
`'checkpoint_07'` | 1,156
`'checkpoint_08'` | 871
`'checkpoint_09'` | 854
`'checkpoint_10'` | 862
`'checkpoint_11'` | 940
`'checkpoint_12'` | 1,009
`'checkpoint_13'` | 1,032
`'checkpoint_14'` | 1,081
`'checkpoint_15'` | 1,051
`'checkpoint_16'` | 1,094
`'checkpoint_17'` | 1,099
`'checkpoint_18'` | 1,145
`'checkpoint_19'` | 1,145
`'checkpoint_20'` | 1,142
`'checkpoint_21'` | 1,173
`'checkpoint_22'` | 1,147
`'checkpoint_23'` | 1,166
`'checkpoint_24'` | 1,158
`'checkpoint_25'` | 1,166
`'checkpoint_26'` | 1,147
`'checkpoint_27'` | 1,103
`'checkpoint_28'` | 1,153
`'checkpoint_29'` | 1,133
`'checkpoint_30'` | 1,161
`'checkpoint_31'` | 1,145
`'checkpoint_32'` | 1,135
`'checkpoint_33'` | 1,112
`'checkpoint_34'` | 1,136
`'checkpoint_35'` | 1,112
`'checkpoint_36'` | 1,109
`'checkpoint_37'` | 1,109
`'checkpoint_38'` | 1,108
`'checkpoint_39'` | 1,093
`'checkpoint_40'` | 1,050
`'checkpoint_41'` | 1,062
`'checkpoint_42'` | 1,065
`'checkpoint_43'` | 1,070
`'checkpoint_44'` | 1,057
`'checkpoint_45'` | 1,038
`'checkpoint_46'` | 1,046
`'checkpoint_47'` | 990
`'checkpoint_48'` | 1,007
`'checkpoint_49'` | 1,001

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):

<!-- mdformat off(HTML should not be auto-formatted) -->

{% framebox %}

<button id="displaydataframe">Display examples...</button>
<div id="dataframecontent" style="overflow-x:auto"></div>
<script>
const url = "https://storage.googleapis.com/tfds-data/visualization/dataframe/rlu_atari_checkpoints-Boxing_run_5-1.1.0.html";
const dataButton = document.getElementById('displaydataframe');
dataButton.addEventListener('click', async () => {
  // Disable the button after clicking (dataframe loaded only once).
  dataButton.disabled = true;

  const contentPane = document.getElementById('dataframecontent');
  try {
    const response = await fetch(url);
    // Error response codes don't throw an error, so force an error to show
    // the error message.
    if (!response.ok) throw Error(response.statusText);

    const data = await response.text();
    contentPane.innerHTML = data;
  } catch (e) {
    contentPane.innerHTML =
        'Error loading examples. If the error persist, please open '
        + 'a new issue.';
  }
});
</script>

{% endframebox %}

<!-- mdformat on -->

## rlu_atari_checkpoints/Breakout_run_1

*   **Dataset size**: `30.66 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 3,466
`'checkpoint_01'` | 2,019
`'checkpoint_02'` | 1,386
`'checkpoint_03'` | 1,039
`'checkpoint_04'` | 873
`'checkpoint_05'` | 784
`'checkpoint_06'` | 754
`'checkpoint_07'` | 733
`'checkpoint_08'` | 736
`'checkpoint_09'` | 783
`'checkpoint_10'` | 744
`'checkpoint_11'` | 708
`'checkpoint_12'` | 711
`'checkpoint_13'` | 703
`'checkpoint_14'` | 703
`'checkpoint_15'` | 744
`'checkpoint_16'` | 681
`'checkpoint_17'` | 705
`'checkpoint_18'` | 735
`'checkpoint_19'` | 712
`'checkpoint_20'` | 718
`'checkpoint_21'` | 708
`'checkpoint_22'` | 679
`'checkpoint_23'` | 696
`'checkpoint_24'` | 707
`'checkpoint_25'` | 719
`'checkpoint_26'` | 698
`'checkpoint_27'` | 714
`'checkpoint_28'` | 713
`'checkpoint_29'` | 711
`'checkpoint_30'` | 721
`'checkpoint_31'` | 755
`'checkpoint_32'` | 739
`'checkpoint_33'` | 740
`'checkpoint_34'` | 748
`'checkpoint_35'` | 695
`'checkpoint_36'` | 739
`'checkpoint_37'` | 753
`'checkpoint_38'` | 735
`'checkpoint_39'` | 768
`'checkpoint_40'` | 747
`'checkpoint_41'` | 762
`'checkpoint_42'` | 745
`'checkpoint_43'` | 808
`'checkpoint_44'` | 776
`'checkpoint_45'` | 775
`'checkpoint_46'` | 772
`'checkpoint_47'` | 740
`'checkpoint_48'` | 758
`'checkpoint_49'` | 781

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):

<!-- mdformat off(HTML should not be auto-formatted) -->

{% framebox %}

<button id="displaydataframe">Display examples...</button>
<div id="dataframecontent" style="overflow-x:auto"></div>
<script>
const url = "https://storage.googleapis.com/tfds-data/visualization/dataframe/rlu_atari_checkpoints-Breakout_run_1-1.1.0.html";
const dataButton = document.getElementById('displaydataframe');
dataButton.addEventListener('click', async () => {
  // Disable the button after clicking (dataframe loaded only once).
  dataButton.disabled = true;

  const contentPane = document.getElementById('dataframecontent');
  try {
    const response = await fetch(url);
    // Error response codes don't throw an error, so force an error to show
    // the error message.
    if (!response.ok) throw Error(response.statusText);

    const data = await response.text();
    contentPane.innerHTML = data;
  } catch (e) {
    contentPane.innerHTML =
        'Error loading examples. If the error persist, please open '
        + 'a new issue.';
  }
});
</script>

{% endframebox %}

<!-- mdformat on -->

## rlu_atari_checkpoints/Breakout_run_2

*   **Dataset size**: `30.62 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 3,426
`'checkpoint_01'` | 2,011
`'checkpoint_02'` | 1,437
`'checkpoint_03'` | 1,039
`'checkpoint_04'` | 877
`'checkpoint_05'` | 793
`'checkpoint_06'` | 764
`'checkpoint_07'` | 769
`'checkpoint_08'` | 787
`'checkpoint_09'` | 794
`'checkpoint_10'` | 745
`'checkpoint_11'` | 749
`'checkpoint_12'` | 714
`'checkpoint_13'` | 733
`'checkpoint_14'` | 726
`'checkpoint_15'` | 708
`'checkpoint_16'` | 726
`'checkpoint_17'` | 711
`'checkpoint_18'` | 691
`'checkpoint_19'` | 685
`'checkpoint_20'` | 669
`'checkpoint_21'` | 692
`'checkpoint_22'` | 701
`'checkpoint_23'` | 683
`'checkpoint_24'` | 678
`'checkpoint_25'` | 702
`'checkpoint_26'` | 692
`'checkpoint_27'` | 728
`'checkpoint_28'` | 718
`'checkpoint_29'` | 747
`'checkpoint_30'` | 747
`'checkpoint_31'` | 740
`'checkpoint_32'` | 727
`'checkpoint_33'` | 748
`'checkpoint_34'` | 753
`'checkpoint_35'` | 763
`'checkpoint_36'` | 742
`'checkpoint_37'` | 794
`'checkpoint_38'` | 772
`'checkpoint_39'` | 765
`'checkpoint_40'` | 813
`'checkpoint_41'` | 763
`'checkpoint_42'` | 762
`'checkpoint_43'` | 790
`'checkpoint_44'` | 774
`'checkpoint_45'` | 806
`'checkpoint_46'` | 781
`'checkpoint_47'` | 790
`'checkpoint_48'` | 788
`'checkpoint_49'` | 778

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):

<!-- mdformat off(HTML should not be auto-formatted) -->

{% framebox %}

<button id="displaydataframe">Display examples...</button>
<div id="dataframecontent" style="overflow-x:auto"></div>
<script>
const url = "https://storage.googleapis.com/tfds-data/visualization/dataframe/rlu_atari_checkpoints-Breakout_run_2-1.1.0.html";
const dataButton = document.getElementById('displaydataframe');
dataButton.addEventListener('click', async () => {
  // Disable the button after clicking (dataframe loaded only once).
  dataButton.disabled = true;

  const contentPane = document.getElementById('dataframecontent');
  try {
    const response = await fetch(url);
    // Error response codes don't throw an error, so force an error to show
    // the error message.
    if (!response.ok) throw Error(response.statusText);

    const data = await response.text();
    contentPane.innerHTML = data;
  } catch (e) {
    contentPane.innerHTML =
        'Error loading examples. If the error persist, please open '
        + 'a new issue.';
  }
});
</script>

{% endframebox %}

<!-- mdformat on -->

## rlu_atari_checkpoints/Breakout_run_3

*   **Dataset size**: `30.65 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 3,394
`'checkpoint_01'` | 1,901
`'checkpoint_02'` | 1,313
`'checkpoint_03'` | 1,034
`'checkpoint_04'` | 906
`'checkpoint_05'` | 815
`'checkpoint_06'` | 778
`'checkpoint_07'` | 749
`'checkpoint_08'` | 744
`'checkpoint_09'` | 813
`'checkpoint_10'` | 758
`'checkpoint_11'` | 734
`'checkpoint_12'` | 758
`'checkpoint_13'` | 706
`'checkpoint_14'` | 742
`'checkpoint_15'` | 780
`'checkpoint_16'` | 740
`'checkpoint_17'` | 738
`'checkpoint_18'` | 730
`'checkpoint_19'` | 713
`'checkpoint_20'` | 707
`'checkpoint_21'` | 714
`'checkpoint_22'` | 690
`'checkpoint_23'` | 699
`'checkpoint_24'` | 744
`'checkpoint_25'` | 725
`'checkpoint_26'` | 690
`'checkpoint_27'` | 714
`'checkpoint_28'` | 721
`'checkpoint_29'` | 742
`'checkpoint_30'` | 710
`'checkpoint_31'` | 714
`'checkpoint_32'` | 714
`'checkpoint_33'` | 709
`'checkpoint_34'` | 718
`'checkpoint_35'` | 716
`'checkpoint_36'` | 694
`'checkpoint_37'` | 740
`'checkpoint_38'` | 728
`'checkpoint_39'` | 746
`'checkpoint_40'` | 716
`'checkpoint_41'` | 753
`'checkpoint_42'` | 740
`'checkpoint_43'` | 765
`'checkpoint_44'` | 748
`'checkpoint_45'` | 798
`'checkpoint_46'` | 788
`'checkpoint_47'` | 781
`'checkpoint_48'` | 741
`'checkpoint_49'` | 763

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):

<!-- mdformat off(HTML should not be auto-formatted) -->

{% framebox %}

<button id="displaydataframe">Display examples...</button>
<div id="dataframecontent" style="overflow-x:auto"></div>
<script>
const url = "https://storage.googleapis.com/tfds-data/visualization/dataframe/rlu_atari_checkpoints-Breakout_run_3-1.1.0.html";
const dataButton = document.getElementById('displaydataframe');
dataButton.addEventListener('click', async () => {
  // Disable the button after clicking (dataframe loaded only once).
  dataButton.disabled = true;

  const contentPane = document.getElementById('dataframecontent');
  try {
    const response = await fetch(url);
    // Error response codes don't throw an error, so force an error to show
    // the error message.
    if (!response.ok) throw Error(response.statusText);

    const data = await response.text();
    contentPane.innerHTML = data;
  } catch (e) {
    contentPane.innerHTML =
        'Error loading examples. If the error persist, please open '
        + 'a new issue.';
  }
});
</script>

{% endframebox %}

<!-- mdformat on -->

## rlu_atari_checkpoints/Breakout_run_4

*   **Dataset size**: `30.66 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 3,558
`'checkpoint_01'` | 1,782
`'checkpoint_02'` | 1,281
`'checkpoint_03'` | 955
`'checkpoint_04'` | 873
`'checkpoint_05'` | 784
`'checkpoint_06'` | 847
`'checkpoint_07'` | 812
`'checkpoint_08'` | 825
`'checkpoint_09'` | 792
`'checkpoint_10'` | 764
`'checkpoint_11'` | 729
`'checkpoint_12'` | 729
`'checkpoint_13'` | 722
`'checkpoint_14'` | 730
`'checkpoint_15'` | 716
`'checkpoint_16'` | 719
`'checkpoint_17'` | 712
`'checkpoint_18'` | 717
`'checkpoint_19'` | 695
`'checkpoint_20'` | 703
`'checkpoint_21'` | 704
`'checkpoint_22'` | 694
`'checkpoint_23'` | 701
`'checkpoint_24'` | 682
`'checkpoint_25'` | 696
`'checkpoint_26'` | 679
`'checkpoint_27'` | 712
`'checkpoint_28'` | 707
`'checkpoint_29'` | 724
`'checkpoint_30'` | 751
`'checkpoint_31'` | 742
`'checkpoint_32'` | 777
`'checkpoint_33'` | 719
`'checkpoint_34'` | 758
`'checkpoint_35'` | 751
`'checkpoint_36'` | 754
`'checkpoint_37'` | 768
`'checkpoint_38'` | 769
`'checkpoint_39'` | 745
`'checkpoint_40'` | 753
`'checkpoint_41'` | 745
`'checkpoint_42'` | 701
`'checkpoint_43'` | 760
`'checkpoint_44'` | 768
`'checkpoint_45'` | 722
`'checkpoint_46'` | 729
`'checkpoint_47'` | 726
`'checkpoint_48'` | 756
`'checkpoint_49'` | 753

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):

<!-- mdformat off(HTML should not be auto-formatted) -->

{% framebox %}

<button id="displaydataframe">Display examples...</button>
<div id="dataframecontent" style="overflow-x:auto"></div>
<script>
const url = "https://storage.googleapis.com/tfds-data/visualization/dataframe/rlu_atari_checkpoints-Breakout_run_4-1.1.0.html";
const dataButton = document.getElementById('displaydataframe');
dataButton.addEventListener('click', async () => {
  // Disable the button after clicking (dataframe loaded only once).
  dataButton.disabled = true;

  const contentPane = document.getElementById('dataframecontent');
  try {
    const response = await fetch(url);
    // Error response codes don't throw an error, so force an error to show
    // the error message.
    if (!response.ok) throw Error(response.statusText);

    const data = await response.text();
    contentPane.innerHTML = data;
  } catch (e) {
    contentPane.innerHTML =
        'Error loading examples. If the error persist, please open '
        + 'a new issue.';
  }
});
</script>

{% endframebox %}

<!-- mdformat on -->

## rlu_atari_checkpoints/Breakout_run_5

*   **Dataset size**: `30.71 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 3,490
`'checkpoint_01'` | 1,825
`'checkpoint_02'` | 1,372
`'checkpoint_03'` | 1,055
`'checkpoint_04'` | 915
`'checkpoint_05'` | 796
`'checkpoint_06'` | 775
`'checkpoint_07'` | 767
`'checkpoint_08'` | 794
`'checkpoint_09'` | 768
`'checkpoint_10'` | 746
`'checkpoint_11'` | 723
`'checkpoint_12'` | 716
`'checkpoint_13'` | 719
`'checkpoint_14'` | 728
`'checkpoint_15'` | 680
`'checkpoint_16'` | 727
`'checkpoint_17'` | 708
`'checkpoint_18'` | 749
`'checkpoint_19'` | 723
`'checkpoint_20'` | 740
`'checkpoint_21'` | 711
`'checkpoint_22'` | 737
`'checkpoint_23'` | 719
`'checkpoint_24'` | 727
`'checkpoint_25'` | 713
`'checkpoint_26'` | 723
`'checkpoint_27'` | 712
`'checkpoint_28'` | 730
`'checkpoint_29'` | 748
`'checkpoint_30'` | 732
`'checkpoint_31'` | 716
`'checkpoint_32'` | 760
`'checkpoint_33'` | 725
`'checkpoint_34'` | 704
`'checkpoint_35'` | 731
`'checkpoint_36'` | 732
`'checkpoint_37'` | 711
`'checkpoint_38'` | 760
`'checkpoint_39'` | 768
`'checkpoint_40'` | 716
`'checkpoint_41'` | 764
`'checkpoint_42'` | 717
`'checkpoint_43'` | 700
`'checkpoint_44'` | 724
`'checkpoint_45'` | 740
`'checkpoint_46'` | 751
`'checkpoint_47'` | 744
`'checkpoint_48'` | 729
`'checkpoint_49'` | 743

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):

<!-- mdformat off(HTML should not be auto-formatted) -->

{% framebox %}

<button id="displaydataframe">Display examples...</button>
<div id="dataframecontent" style="overflow-x:auto"></div>
<script>
const url = "https://storage.googleapis.com/tfds-data/visualization/dataframe/rlu_atari_checkpoints-Breakout_run_5-1.1.0.html";
const dataButton = document.getElementById('displaydataframe');
dataButton.addEventListener('click', async () => {
  // Disable the button after clicking (dataframe loaded only once).
  dataButton.disabled = true;

  const contentPane = document.getElementById('dataframecontent');
  try {
    const response = await fetch(url);
    // Error response codes don't throw an error, so force an error to show
    // the error message.
    if (!response.ok) throw Error(response.statusText);

    const data = await response.text();
    contentPane.innerHTML = data;
  } catch (e) {
    contentPane.innerHTML =
        'Error loading examples. If the error persist, please open '
        + 'a new issue.';
  }
});
</script>

{% endframebox %}

<!-- mdformat on -->

## rlu_atari_checkpoints/Carnival_run_1

*   **Dataset size**: `33.58 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 1,949
`'checkpoint_01'` | 1,435
`'checkpoint_02'` | 1,159
`'checkpoint_03'` | 1,086
`'checkpoint_04'` | 1,147
`'checkpoint_05'` | 1,200
`'checkpoint_06'` | 1,454
`'checkpoint_07'` | 1,955
`'checkpoint_08'` | 2,812
`'checkpoint_09'` | 4,007
`'checkpoint_10'` | 4,482
`'checkpoint_11'` | 4,673
`'checkpoint_12'` | 4,840
`'checkpoint_13'` | 4,947
`'checkpoint_14'` | 5,033
`'checkpoint_15'` | 5,182
`'checkpoint_16'` | 5,228
`'checkpoint_17'` | 5,253
`'checkpoint_18'` | 5,283
`'checkpoint_19'` | 5,243
`'checkpoint_20'` | 5,215
`'checkpoint_21'` | 5,216
`'checkpoint_22'` | 5,177
`'checkpoint_23'` | 5,210
`'checkpoint_24'` | 5,148
`'checkpoint_25'` | 5,166
`'checkpoint_26'` | 5,161
`'checkpoint_27'` | 5,122
`'checkpoint_28'` | 5,153
`'checkpoint_29'` | 5,154
`'checkpoint_30'` | 5,181
`'checkpoint_31'` | 5,189
`'checkpoint_32'` | 5,201
`'checkpoint_33'` | 5,178
`'checkpoint_34'` | 5,191
`'checkpoint_35'` | 5,179
`'checkpoint_36'` | 5,177
`'checkpoint_37'` | 5,192
`'checkpoint_38'` | 5,175
`'checkpoint_39'` | 5,196
`'checkpoint_40'` | 5,200
`'checkpoint_41'` | 5,193
`'checkpoint_42'` | 5,169
`'checkpoint_43'` | 5,198
`'checkpoint_44'` | 5,203
`'checkpoint_45'` | 5,173
`'checkpoint_46'` | 5,158
`'checkpoint_47'` | 5,139
`'checkpoint_48'` | 5,144

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):

<!-- mdformat off(HTML should not be auto-formatted) -->

{% framebox %}

<button id="displaydataframe">Display examples...</button>
<div id="dataframecontent" style="overflow-x:auto"></div>
<script>
const url = "https://storage.googleapis.com/tfds-data/visualization/dataframe/rlu_atari_checkpoints-Carnival_run_1-1.1.0.html";
const dataButton = document.getElementById('displaydataframe');
dataButton.addEventListener('click', async () => {
  // Disable the button after clicking (dataframe loaded only once).
  dataButton.disabled = true;

  const contentPane = document.getElementById('dataframecontent');
  try {
    const response = await fetch(url);
    // Error response codes don't throw an error, so force an error to show
    // the error message.
    if (!response.ok) throw Error(response.statusText);

    const data = await response.text();
    contentPane.innerHTML = data;
  } catch (e) {
    contentPane.innerHTML =
        'Error loading examples. If the error persist, please open '
        + 'a new issue.';
  }
});
</script>

{% endframebox %}

<!-- mdformat on -->

## rlu_atari_checkpoints/Carnival_run_2

*   **Dataset size**: `33.69 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 1,975
`'checkpoint_01'` | 1,446
`'checkpoint_02'` | 1,133
`'checkpoint_03'` | 1,111
`'checkpoint_04'` | 1,259
`'checkpoint_05'` | 1,573
`'checkpoint_06'` | 2,039
`'checkpoint_07'` | 2,868
`'checkpoint_08'` | 3,877
`'checkpoint_09'` | 4,337
`'checkpoint_10'` | 4,576
`'checkpoint_11'` | 4,823
`'checkpoint_12'` | 4,934
`'checkpoint_13'` | 5,037
`'checkpoint_14'` | 5,077
`'checkpoint_15'` | 5,152
`'checkpoint_16'` | 5,181
`'checkpoint_17'` | 5,192
`'checkpoint_18'` | 5,203
`'checkpoint_19'` | 5,197
`'checkpoint_20'` | 5,191
`'checkpoint_21'` | 5,194
`'checkpoint_22'` | 5,223
`'checkpoint_23'` | 5,252
`'checkpoint_24'` | 5,242
`'checkpoint_25'` | 5,248
`'checkpoint_26'` | 5,206
`'checkpoint_27'` | 5,190
`'checkpoint_28'` | 5,215
`'checkpoint_29'` | 5,203
`'checkpoint_30'` | 5,224
`'checkpoint_31'` | 5,188
`'checkpoint_32'` | 5,198
`'checkpoint_33'` | 5,180
`'checkpoint_34'` | 5,170
`'checkpoint_35'` | 5,163
`'checkpoint_36'` | 5,207
`'checkpoint_37'` | 5,211
`'checkpoint_38'` | 5,156
`'checkpoint_39'` | 5,146
`'checkpoint_40'` | 5,123
`'checkpoint_41'` | 5,131
`'checkpoint_42'` | 5,134
`'checkpoint_43'` | 5,141
`'checkpoint_44'` | 5,172
`'checkpoint_45'` | 5,146
`'checkpoint_46'` | 5,118
`'checkpoint_47'` | 5,123
`'checkpoint_48'` | 5,136

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):

<!-- mdformat off(HTML should not be auto-formatted) -->

{% framebox %}

<button id="displaydataframe">Display examples...</button>
<div id="dataframecontent" style="overflow-x:auto"></div>
<script>
const url = "https://storage.googleapis.com/tfds-data/visualization/dataframe/rlu_atari_checkpoints-Carnival_run_2-1.1.0.html";
const dataButton = document.getElementById('displaydataframe');
dataButton.addEventListener('click', async () => {
  // Disable the button after clicking (dataframe loaded only once).
  dataButton.disabled = true;

  const contentPane = document.getElementById('dataframecontent');
  try {
    const response = await fetch(url);
    // Error response codes don't throw an error, so force an error to show
    // the error message.
    if (!response.ok) throw Error(response.statusText);

    const data = await response.text();
    contentPane.innerHTML = data;
  } catch (e) {
    contentPane.innerHTML =
        'Error loading examples. If the error persist, please open '
        + 'a new issue.';
  }
});
</script>

{% endframebox %}

<!-- mdformat on -->

## rlu_atari_checkpoints/Carnival_run_3

*   **Dataset size**: `33.59 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 1,954
`'checkpoint_01'` | 1,455
`'checkpoint_02'` | 1,093
`'checkpoint_03'` | 1,137
`'checkpoint_04'` | 1,350
`'checkpoint_05'` | 1,556
`'checkpoint_06'` | 2,157
`'checkpoint_07'` | 3,252
`'checkpoint_08'` | 4,124
`'checkpoint_09'` | 4,404
`'checkpoint_10'` | 4,635
`'checkpoint_11'` | 4,845
`'checkpoint_12'` | 4,962
`'checkpoint_13'` | 5,079
`'checkpoint_14'` | 5,131
`'checkpoint_15'` | 5,172
`'checkpoint_16'` | 5,200
`'checkpoint_17'` | 5,248
`'checkpoint_18'` | 5,257
`'checkpoint_19'` | 5,236
`'checkpoint_20'` | 5,255
`'checkpoint_21'` | 5,221
`'checkpoint_22'` | 5,227
`'checkpoint_23'` | 5,244
`'checkpoint_24'` | 5,253
`'checkpoint_25'` | 5,228
`'checkpoint_26'` | 5,246
`'checkpoint_27'` | 5,250
`'checkpoint_28'` | 5,260
`'checkpoint_29'` | 5,232
`'checkpoint_30'` | 5,236
`'checkpoint_31'` | 5,229
`'checkpoint_32'` | 5,216
`'checkpoint_33'` | 5,193
`'checkpoint_34'` | 5,223
`'checkpoint_35'` | 5,226
`'checkpoint_36'` | 5,208
`'checkpoint_37'` | 5,204
`'checkpoint_38'` | 5,206
`'checkpoint_39'` | 5,177
`'checkpoint_40'` | 5,200
`'checkpoint_41'` | 5,200
`'checkpoint_42'` | 5,156
`'checkpoint_43'` | 5,142
`'checkpoint_44'` | 5,098
`'checkpoint_45'` | 5,118
`'checkpoint_46'` | 5,129
`'checkpoint_47'` | 5,183
`'checkpoint_48'` | 5,162

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):

<!-- mdformat off(HTML should not be auto-formatted) -->

{% framebox %}

<button id="displaydataframe">Display examples...</button>
<div id="dataframecontent" style="overflow-x:auto"></div>
<script>
const url = "https://storage.googleapis.com/tfds-data/visualization/dataframe/rlu_atari_checkpoints-Carnival_run_3-1.1.0.html";
const dataButton = document.getElementById('displaydataframe');
dataButton.addEventListener('click', async () => {
  // Disable the button after clicking (dataframe loaded only once).
  dataButton.disabled = true;

  const contentPane = document.getElementById('dataframecontent');
  try {
    const response = await fetch(url);
    // Error response codes don't throw an error, so force an error to show
    // the error message.
    if (!response.ok) throw Error(response.statusText);

    const data = await response.text();
    contentPane.innerHTML = data;
  } catch (e) {
    contentPane.innerHTML =
        'Error loading examples. If the error persist, please open '
        + 'a new issue.';
  }
});
</script>

{% endframebox %}

<!-- mdformat on -->

## rlu_atari_checkpoints/Carnival_run_4

*   **Dataset size**: `33.60 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 1,940
`'checkpoint_01'` | 1,471
`'checkpoint_02'` | 1,087
`'checkpoint_03'` | 1,047
`'checkpoint_04'` | 1,062
`'checkpoint_05'` | 1,283
`'checkpoint_06'` | 1,687
`'checkpoint_07'` | 2,217
`'checkpoint_08'` | 2,865
`'checkpoint_09'` | 3,557
`'checkpoint_10'` | 4,211
`'checkpoint_11'` | 4,503
`'checkpoint_12'` | 4,644
`'checkpoint_13'` | 4,793
`'checkpoint_14'` | 4,931
`'checkpoint_15'` | 5,009
`'checkpoint_16'` | 5,064
`'checkpoint_17'` | 5,097
`'checkpoint_18'` | 5,138
`'checkpoint_19'` | 5,159
`'checkpoint_20'` | 5,202
`'checkpoint_21'` | 5,212
`'checkpoint_22'` | 5,206
`'checkpoint_23'` | 5,228
`'checkpoint_24'` | 5,241
`'checkpoint_25'` | 5,238
`'checkpoint_26'` | 5,249
`'checkpoint_27'` | 5,223
`'checkpoint_28'` | 5,245
`'checkpoint_29'` | 5,240
`'checkpoint_30'` | 5,214
`'checkpoint_31'` | 5,238
`'checkpoint_32'` | 5,272
`'checkpoint_33'` | 5,275
`'checkpoint_34'` | 5,219
`'checkpoint_35'` | 5,255
`'checkpoint_36'` | 5,257
`'checkpoint_37'` | 5,269
`'checkpoint_38'` | 5,282
`'checkpoint_39'` | 5,271
`'checkpoint_40'` | 5,252
`'checkpoint_41'` | 5,240
`'checkpoint_42'` | 5,227
`'checkpoint_43'` | 5,238
`'checkpoint_44'` | 5,226
`'checkpoint_45'` | 5,209
`'checkpoint_46'` | 5,197
`'checkpoint_47'` | 5,204
`'checkpoint_48'` | 5,213

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):

<!-- mdformat off(HTML should not be auto-formatted) -->

{% framebox %}

<button id="displaydataframe">Display examples...</button>
<div id="dataframecontent" style="overflow-x:auto"></div>
<script>
const url = "https://storage.googleapis.com/tfds-data/visualization/dataframe/rlu_atari_checkpoints-Carnival_run_4-1.1.0.html";
const dataButton = document.getElementById('displaydataframe');
dataButton.addEventListener('click', async () => {
  // Disable the button after clicking (dataframe loaded only once).
  dataButton.disabled = true;

  const contentPane = document.getElementById('dataframecontent');
  try {
    const response = await fetch(url);
    // Error response codes don't throw an error, so force an error to show
    // the error message.
    if (!response.ok) throw Error(response.statusText);

    const data = await response.text();
    contentPane.innerHTML = data;
  } catch (e) {
    contentPane.innerHTML =
        'Error loading examples. If the error persist, please open '
        + 'a new issue.';
  }
});
</script>

{% endframebox %}

<!-- mdformat on -->

## rlu_atari_checkpoints/Carnival_run_5

*   **Dataset size**: `34.51 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 1,956
`'checkpoint_01'` | 1,410
`'checkpoint_02'` | 1,151
`'checkpoint_03'` | 1,092
`'checkpoint_04'` | 1,133
`'checkpoint_05'` | 1,429
`'checkpoint_06'` | 1,606
`'checkpoint_07'` | 1,868
`'checkpoint_08'` | 2,262
`'checkpoint_09'` | 2,723
`'checkpoint_10'` | 3,540
`'checkpoint_11'` | 4,137
`'checkpoint_12'` | 4,402
`'checkpoint_13'` | 4,597
`'checkpoint_14'` | 4,771
`'checkpoint_15'` | 4,912
`'checkpoint_16'` | 5,067
`'checkpoint_17'` | 5,211
`'checkpoint_18'` | 5,246
`'checkpoint_19'` | 5,292
`'checkpoint_20'` | 5,290
`'checkpoint_21'` | 5,278
`'checkpoint_22'` | 5,314
`'checkpoint_23'` | 5,319
`'checkpoint_24'` | 5,304
`'checkpoint_25'` | 5,385
`'checkpoint_26'` | 5,359
`'checkpoint_27'` | 5,368
`'checkpoint_28'` | 5,369
`'checkpoint_29'` | 5,358
`'checkpoint_30'` | 5,312
`'checkpoint_31'` | 5,298
`'checkpoint_32'` | 5,321
`'checkpoint_33'` | 5,325
`'checkpoint_34'` | 5,337
`'checkpoint_35'` | 5,326
`'checkpoint_36'` | 5,322
`'checkpoint_37'` | 5,348
`'checkpoint_38'` | 5,343
`'checkpoint_39'` | 5,334
`'checkpoint_40'` | 5,324
`'checkpoint_41'` | 5,316
`'checkpoint_42'` | 5,324
`'checkpoint_43'` | 5,329
`'checkpoint_44'` | 5,344
`'checkpoint_45'` | 5,328
`'checkpoint_46'` | 5,339
`'checkpoint_47'` | 5,357
`'checkpoint_48'` | 5,352

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):

<!-- mdformat off(HTML should not be auto-formatted) -->

{% framebox %}

<button id="displaydataframe">Display examples...</button>
<div id="dataframecontent" style="overflow-x:auto"></div>
<script>
const url = "https://storage.googleapis.com/tfds-data/visualization/dataframe/rlu_atari_checkpoints-Carnival_run_5-1.1.0.html";
const dataButton = document.getElementById('displaydataframe');
dataButton.addEventListener('click', async () => {
  // Disable the button after clicking (dataframe loaded only once).
  dataButton.disabled = true;

  const contentPane = document.getElementById('dataframecontent');
  try {
    const response = await fetch(url);
    // Error response codes don't throw an error, so force an error to show
    // the error message.
    if (!response.ok) throw Error(response.statusText);

    const data = await response.text();
    contentPane.innerHTML = data;
  } catch (e) {
    contentPane.innerHTML =
        'Error loading examples. If the error persist, please open '
        + 'a new issue.';
  }
});
</script>

{% endframebox %}

<!-- mdformat on -->

## rlu_atari_checkpoints/Centipede_run_1

*   **Dataset size**: `35.78 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 1,431
`'checkpoint_01'` | 1,530
`'checkpoint_02'` | 1,618
`'checkpoint_03'` | 1,859
`'checkpoint_04'` | 1,796
`'checkpoint_05'` | 1,722
`'checkpoint_06'` | 2,278
`'checkpoint_07'` | 2,416
`'checkpoint_08'` | 2,430
`'checkpoint_09'` | 2,396
`'checkpoint_10'` | 2,203
`'checkpoint_11'` | 2,130
`'checkpoint_12'` | 2,156
`'checkpoint_13'` | 2,181
`'checkpoint_14'` | 2,206
`'checkpoint_15'` | 2,169
`'checkpoint_16'` | 2,197
`'checkpoint_17'` | 2,232
`'checkpoint_18'` | 2,247
`'checkpoint_19'` | 2,112
`'checkpoint_20'` | 2,078
`'checkpoint_21'` | 1,982
`'checkpoint_22'` | 1,958
`'checkpoint_23'` | 1,916
`'checkpoint_24'` | 1,854
`'checkpoint_25'` | 1,814
`'checkpoint_26'` | 1,790
`'checkpoint_27'` | 1,793
`'checkpoint_28'` | 1,744
`'checkpoint_29'` | 1,754
`'checkpoint_30'` | 1,705
`'checkpoint_31'` | 1,722
`'checkpoint_32'` | 1,746
`'checkpoint_33'` | 1,745
`'checkpoint_34'` | 1,712
`'checkpoint_35'` | 1,714
`'checkpoint_36'` | 1,695
`'checkpoint_37'` | 1,716
`'checkpoint_38'` | 1,720
`'checkpoint_39'` | 1,722
`'checkpoint_40'` | 1,724
`'checkpoint_41'` | 1,714
`'checkpoint_42'` | 1,728
`'checkpoint_43'` | 1,728
`'checkpoint_44'` | 1,707
`'checkpoint_45'` | 1,711
`'checkpoint_46'` | 1,719
`'checkpoint_47'` | 1,712
`'checkpoint_48'` | 1,722
`'checkpoint_49'` | 1,715

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):

<!-- mdformat off(HTML should not be auto-formatted) -->

{% framebox %}

<button id="displaydataframe">Display examples...</button>
<div id="dataframecontent" style="overflow-x:auto"></div>
<script>
const url = "https://storage.googleapis.com/tfds-data/visualization/dataframe/rlu_atari_checkpoints-Centipede_run_1-1.1.0.html";
const dataButton = document.getElementById('displaydataframe');
dataButton.addEventListener('click', async () => {
  // Disable the button after clicking (dataframe loaded only once).
  dataButton.disabled = true;

  const contentPane = document.getElementById('dataframecontent');
  try {
    const response = await fetch(url);
    // Error response codes don't throw an error, so force an error to show
    // the error message.
    if (!response.ok) throw Error(response.statusText);

    const data = await response.text();
    contentPane.innerHTML = data;
  } catch (e) {
    contentPane.innerHTML =
        'Error loading examples. If the error persist, please open '
        + 'a new issue.';
  }
});
</script>

{% endframebox %}

<!-- mdformat on -->

## rlu_atari_checkpoints/Centipede_run_2

*   **Dataset size**: `35.67 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 1,407
`'checkpoint_01'` | 1,510
`'checkpoint_02'` | 1,643
`'checkpoint_03'` | 1,797
`'checkpoint_04'` | 1,842
`'checkpoint_05'` | 1,937
`'checkpoint_06'` | 2,002
`'checkpoint_07'` | 2,428
`'checkpoint_08'` | 2,702
`'checkpoint_09'` | 2,639
`'checkpoint_10'` | 2,472
`'checkpoint_11'` | 2,270
`'checkpoint_12'` | 2,331
`'checkpoint_13'` | 2,305
`'checkpoint_14'` | 2,240
`'checkpoint_15'` | 2,166
`'checkpoint_16'` | 2,118
`'checkpoint_17'` | 2,127
`'checkpoint_18'` | 2,172
`'checkpoint_19'` | 2,191
`'checkpoint_20'` | 2,156
`'checkpoint_21'` | 2,187
`'checkpoint_22'` | 2,153
`'checkpoint_23'` | 2,193
`'checkpoint_24'` | 2,178
`'checkpoint_25'` | 2,166
`'checkpoint_26'` | 2,147
`'checkpoint_27'` | 2,151
`'checkpoint_28'` | 2,123
`'checkpoint_29'` | 2,090
`'checkpoint_30'` | 2,089
`'checkpoint_31'` | 2,099
`'checkpoint_32'` | 2,078
`'checkpoint_33'` | 2,063
`'checkpoint_34'` | 2,114
`'checkpoint_35'` | 2,092
`'checkpoint_36'` | 2,123
`'checkpoint_37'` | 2,119
`'checkpoint_38'` | 2,129
`'checkpoint_39'` | 2,068
`'checkpoint_40'` | 2,057
`'checkpoint_41'` | 2,054
`'checkpoint_42'` | 2,078
`'checkpoint_43'` | 2,039
`'checkpoint_44'` | 2,097
`'checkpoint_45'` | 2,012
`'checkpoint_46'` | 2,050
`'checkpoint_47'` | 2,098
`'checkpoint_48'` | 2,067
`'checkpoint_49'` | 2,061

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):

<!-- mdformat off(HTML should not be auto-formatted) -->

{% framebox %}

<button id="displaydataframe">Display examples...</button>
<div id="dataframecontent" style="overflow-x:auto"></div>
<script>
const url = "https://storage.googleapis.com/tfds-data/visualization/dataframe/rlu_atari_checkpoints-Centipede_run_2-1.1.0.html";
const dataButton = document.getElementById('displaydataframe');
dataButton.addEventListener('click', async () => {
  // Disable the button after clicking (dataframe loaded only once).
  dataButton.disabled = true;

  const contentPane = document.getElementById('dataframecontent');
  try {
    const response = await fetch(url);
    // Error response codes don't throw an error, so force an error to show
    // the error message.
    if (!response.ok) throw Error(response.statusText);

    const data = await response.text();
    contentPane.innerHTML = data;
  } catch (e) {
    contentPane.innerHTML =
        'Error loading examples. If the error persist, please open '
        + 'a new issue.';
  }
});
</script>

{% endframebox %}

<!-- mdformat on -->

## rlu_atari_checkpoints/Centipede_run_3

*   **Dataset size**: `35.68 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 1,377
`'checkpoint_01'` | 1,478
`'checkpoint_02'` | 1,478
`'checkpoint_03'` | 1,653
`'checkpoint_04'` | 1,884
`'checkpoint_05'` | 1,911
`'checkpoint_06'` | 2,399
`'checkpoint_07'` | 2,939
`'checkpoint_08'` | 2,842
`'checkpoint_09'` | 2,195
`'checkpoint_10'` | 2,051
`'checkpoint_11'` | 1,999
`'checkpoint_12'` | 1,990
`'checkpoint_13'` | 2,108
`'checkpoint_14'` | 2,117
`'checkpoint_15'` | 2,162
`'checkpoint_16'` | 2,205
`'checkpoint_17'` | 2,249
`'checkpoint_18'` | 2,444
`'checkpoint_19'` | 2,452
`'checkpoint_20'` | 2,408
`'checkpoint_21'` | 2,393
`'checkpoint_22'` | 2,262
`'checkpoint_23'` | 2,187
`'checkpoint_24'` | 2,129
`'checkpoint_25'` | 2,214
`'checkpoint_26'` | 2,198
`'checkpoint_27'` | 2,162
`'checkpoint_28'` | 2,193
`'checkpoint_29'` | 2,224
`'checkpoint_30'` | 2,180
`'checkpoint_31'` | 2,164
`'checkpoint_32'` | 2,182
`'checkpoint_33'` | 2,145
`'checkpoint_34'` | 2,185
`'checkpoint_35'` | 2,158
`'checkpoint_36'` | 2,169
`'checkpoint_37'` | 2,175
`'checkpoint_38'` | 2,142
`'checkpoint_39'` | 2,158
`'checkpoint_40'` | 2,136
`'checkpoint_41'` | 2,079
`'checkpoint_42'` | 2,083
`'checkpoint_43'` | 2,039
`'checkpoint_44'` | 2,036
`'checkpoint_45'` | 1,903
`'checkpoint_46'` | 1,873
`'checkpoint_47'` | 1,902
`'checkpoint_48'` | 1,979
`'checkpoint_49'` | 1,974

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):

<!-- mdformat off(HTML should not be auto-formatted) -->

{% framebox %}

<button id="displaydataframe">Display examples...</button>
<div id="dataframecontent" style="overflow-x:auto"></div>
<script>
const url = "https://storage.googleapis.com/tfds-data/visualization/dataframe/rlu_atari_checkpoints-Centipede_run_3-1.1.0.html";
const dataButton = document.getElementById('displaydataframe');
dataButton.addEventListener('click', async () => {
  // Disable the button after clicking (dataframe loaded only once).
  dataButton.disabled = true;

  const contentPane = document.getElementById('dataframecontent');
  try {
    const response = await fetch(url);
    // Error response codes don't throw an error, so force an error to show
    // the error message.
    if (!response.ok) throw Error(response.statusText);

    const data = await response.text();
    contentPane.innerHTML = data;
  } catch (e) {
    contentPane.innerHTML =
        'Error loading examples. If the error persist, please open '
        + 'a new issue.';
  }
});
</script>

{% endframebox %}

<!-- mdformat on -->

## rlu_atari_checkpoints/Centipede_run_4

*   **Dataset size**: `35.94 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 1,415
`'checkpoint_01'` | 1,597
`'checkpoint_02'` | 1,840
`'checkpoint_03'` | 1,743
`'checkpoint_04'` | 1,698
`'checkpoint_05'` | 1,909
`'checkpoint_06'` | 1,909
`'checkpoint_07'` | 1,929
`'checkpoint_08'` | 1,983
`'checkpoint_09'` | 2,111
`'checkpoint_10'` | 2,071
`'checkpoint_11'` | 2,105
`'checkpoint_12'` | 2,108
`'checkpoint_13'` | 2,135
`'checkpoint_14'` | 2,137
`'checkpoint_15'` | 2,101
`'checkpoint_16'` | 2,158
`'checkpoint_17'` | 2,174
`'checkpoint_18'` | 2,180
`'checkpoint_19'` | 2,097
`'checkpoint_20'` | 2,090
`'checkpoint_21'` | 2,078
`'checkpoint_22'` | 2,053
`'checkpoint_23'` | 2,068
`'checkpoint_24'` | 2,080
`'checkpoint_25'` | 2,051
`'checkpoint_26'` | 2,096
`'checkpoint_27'` | 2,014
`'checkpoint_28'` | 2,001
`'checkpoint_29'` | 2,008
`'checkpoint_30'` | 1,982
`'checkpoint_31'` | 1,975
`'checkpoint_32'` | 2,010
`'checkpoint_33'` | 1,965
`'checkpoint_34'` | 2,010
`'checkpoint_35'` | 2,031
`'checkpoint_36'` | 2,029
`'checkpoint_37'` | 2,016
`'checkpoint_38'` | 1,998
`'checkpoint_39'` | 1,978
`'checkpoint_40'` | 1,989
`'checkpoint_41'` | 1,946
`'checkpoint_42'` | 2,016
`'checkpoint_43'` | 1,974
`'checkpoint_44'` | 2,012
`'checkpoint_45'` | 1,996
`'checkpoint_46'` | 1,942
`'checkpoint_47'` | 1,961
`'checkpoint_48'` | 1,954
`'checkpoint_49'` | 1,952

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):

<!-- mdformat off(HTML should not be auto-formatted) -->

{% framebox %}

<button id="displaydataframe">Display examples...</button>
<div id="dataframecontent" style="overflow-x:auto"></div>
<script>
const url = "https://storage.googleapis.com/tfds-data/visualization/dataframe/rlu_atari_checkpoints-Centipede_run_4-1.1.0.html";
const dataButton = document.getElementById('displaydataframe');
dataButton.addEventListener('click', async () => {
  // Disable the button after clicking (dataframe loaded only once).
  dataButton.disabled = true;

  const contentPane = document.getElementById('dataframecontent');
  try {
    const response = await fetch(url);
    // Error response codes don't throw an error, so force an error to show
    // the error message.
    if (!response.ok) throw Error(response.statusText);

    const data = await response.text();
    contentPane.innerHTML = data;
  } catch (e) {
    contentPane.innerHTML =
        'Error loading examples. If the error persist, please open '
        + 'a new issue.';
  }
});
</script>

{% endframebox %}

<!-- mdformat on -->

## rlu_atari_checkpoints/Centipede_run_5

*   **Dataset size**: `35.95 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 1,391
`'checkpoint_01'` | 1,453
`'checkpoint_02'` | 1,508
`'checkpoint_03'` | 1,794
`'checkpoint_04'` | 1,656
`'checkpoint_05'` | 1,623
`'checkpoint_06'` | 1,836
`'checkpoint_07'` | 1,834
`'checkpoint_08'` | 1,827
`'checkpoint_09'` | 1,814
`'checkpoint_10'` | 1,811
`'checkpoint_11'` | 1,721
`'checkpoint_12'` | 1,749
`'checkpoint_13'` | 1,709
`'checkpoint_14'` | 1,729
`'checkpoint_15'` | 1,778
`'checkpoint_16'` | 1,756
`'checkpoint_17'` | 1,732
`'checkpoint_18'` | 1,746
`'checkpoint_19'` | 1,732
`'checkpoint_20'` | 1,736
`'checkpoint_21'` | 1,757
`'checkpoint_22'` | 1,785
`'checkpoint_23'` | 1,762
`'checkpoint_24'` | 1,769
`'checkpoint_25'` | 1,741
`'checkpoint_26'` | 1,786
`'checkpoint_27'` | 1,766
`'checkpoint_28'` | 1,759
`'checkpoint_29'` | 1,762
`'checkpoint_30'` | 1,789
`'checkpoint_31'` | 1,755
`'checkpoint_32'` | 1,719
`'checkpoint_33'` | 1,719
`'checkpoint_34'` | 1,717
`'checkpoint_35'` | 1,717
`'checkpoint_36'` | 1,734
`'checkpoint_37'` | 1,723
`'checkpoint_38'` | 1,763
`'checkpoint_39'` | 1,737
`'checkpoint_40'` | 1,752
`'checkpoint_41'` | 1,747
`'checkpoint_42'` | 1,744
`'checkpoint_43'` | 1,721
`'checkpoint_44'` | 1,747
`'checkpoint_45'` | 1,773
`'checkpoint_46'` | 1,708
`'checkpoint_47'` | 1,730
`'checkpoint_48'` | 1,721
`'checkpoint_49'` | 1,731

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):

<!-- mdformat off(HTML should not be auto-formatted) -->

{% framebox %}

<button id="displaydataframe">Display examples...</button>
<div id="dataframecontent" style="overflow-x:auto"></div>
<script>
const url = "https://storage.googleapis.com/tfds-data/visualization/dataframe/rlu_atari_checkpoints-Centipede_run_5-1.1.0.html";
const dataButton = document.getElementById('displaydataframe');
dataButton.addEventListener('click', async () => {
  // Disable the button after clicking (dataframe loaded only once).
  dataButton.disabled = true;

  const contentPane = document.getElementById('dataframecontent');
  try {
    const response = await fetch(url);
    // Error response codes don't throw an error, so force an error to show
    // the error message.
    if (!response.ok) throw Error(response.statusText);

    const data = await response.text();
    contentPane.innerHTML = data;
  } catch (e) {
    contentPane.innerHTML =
        'Error loading examples. If the error persist, please open '
        + 'a new issue.';
  }
});
</script>

{% endframebox %}

<!-- mdformat on -->

## rlu_atari_checkpoints/ChopperCommand_run_1

*   **Dataset size**: `40.01 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 2,212
`'checkpoint_01'` | 1,807
`'checkpoint_02'` | 1,831
`'checkpoint_03'` | 1,513
`'checkpoint_04'` | 1,364
`'checkpoint_05'` | 1,278
`'checkpoint_06'` | 1,244
`'checkpoint_07'` | 1,256
`'checkpoint_08'` | 1,369
`'checkpoint_09'` | 1,254
`'checkpoint_10'` | 1,242
`'checkpoint_11'` | 1,324
`'checkpoint_12'` | 1,321
`'checkpoint_13'` | 1,239
`'checkpoint_14'` | 1,304
`'checkpoint_15'` | 1,231
`'checkpoint_16'` | 1,307
`'checkpoint_17'` | 1,233
`'checkpoint_18'` | 1,343
`'checkpoint_19'` | 1,366
`'checkpoint_20'` | 1,407
`'checkpoint_21'` | 1,415
`'checkpoint_22'` | 1,444
`'checkpoint_23'` | 1,480
`'checkpoint_24'` | 1,414
`'checkpoint_25'` | 1,459
`'checkpoint_26'` | 1,479
`'checkpoint_27'` | 1,536
`'checkpoint_28'` | 1,448
`'checkpoint_29'` | 1,363
`'checkpoint_30'` | 1,406
`'checkpoint_31'` | 1,298
`'checkpoint_32'` | 1,340
`'checkpoint_33'` | 1,381
`'checkpoint_34'` | 1,312
`'checkpoint_35'` | 1,268
`'checkpoint_36'` | 1,331
`'checkpoint_37'` | 1,329
`'checkpoint_38'` | 1,362
`'checkpoint_39'` | 1,332
`'checkpoint_40'` | 1,297
`'checkpoint_41'` | 1,402
`'checkpoint_42'` | 1,358
`'checkpoint_43'` | 1,285
`'checkpoint_44'` | 1,319
`'checkpoint_45'` | 1,335
`'checkpoint_46'` | 1,401
`'checkpoint_47'` | 1,349
`'checkpoint_48'` | 1,327
`'checkpoint_49'` | 1,343

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):

<!-- mdformat off(HTML should not be auto-formatted) -->

{% framebox %}

<button id="displaydataframe">Display examples...</button>
<div id="dataframecontent" style="overflow-x:auto"></div>
<script>
const url = "https://storage.googleapis.com/tfds-data/visualization/dataframe/rlu_atari_checkpoints-ChopperCommand_run_1-1.1.0.html";
const dataButton = document.getElementById('displaydataframe');
dataButton.addEventListener('click', async () => {
  // Disable the button after clicking (dataframe loaded only once).
  dataButton.disabled = true;

  const contentPane = document.getElementById('dataframecontent');
  try {
    const response = await fetch(url);
    // Error response codes don't throw an error, so force an error to show
    // the error message.
    if (!response.ok) throw Error(response.statusText);

    const data = await response.text();
    contentPane.innerHTML = data;
  } catch (e) {
    contentPane.innerHTML =
        'Error loading examples. If the error persist, please open '
        + 'a new issue.';
  }
});
</script>

{% endframebox %}

<!-- mdformat on -->

## rlu_atari_checkpoints/ChopperCommand_run_2

*   **Dataset size**: `40.16 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 2,139
`'checkpoint_01'` | 1,802
`'checkpoint_02'` | 1,703
`'checkpoint_03'` | 1,606
`'checkpoint_04'` | 1,366
`'checkpoint_05'` | 1,125
`'checkpoint_06'` | 982
`'checkpoint_07'` | 1,117
`'checkpoint_08'` | 1,113
`'checkpoint_09'` | 1,303
`'checkpoint_10'` | 1,257
`'checkpoint_11'` | 1,273
`'checkpoint_12'` | 1,275
`'checkpoint_13'` | 1,255
`'checkpoint_14'` | 1,340
`'checkpoint_15'` | 1,359
`'checkpoint_16'` | 1,254
`'checkpoint_17'` | 1,267
`'checkpoint_18'` | 1,238
`'checkpoint_19'` | 1,299
`'checkpoint_20'` | 1,264
`'checkpoint_21'` | 1,230
`'checkpoint_22'` | 1,201
`'checkpoint_23'` | 1,227
`'checkpoint_24'` | 1,149
`'checkpoint_25'` | 1,227
`'checkpoint_26'` | 1,353
`'checkpoint_27'` | 1,262
`'checkpoint_28'` | 1,289
`'checkpoint_29'` | 1,332
`'checkpoint_30'` | 1,311
`'checkpoint_31'` | 1,319
`'checkpoint_32'` | 1,347
`'checkpoint_33'` | 1,395
`'checkpoint_34'` | 1,341
`'checkpoint_35'` | 1,341
`'checkpoint_36'` | 1,417
`'checkpoint_37'` | 1,382
`'checkpoint_38'` | 1,344
`'checkpoint_39'` | 1,368
`'checkpoint_40'` | 1,370
`'checkpoint_41'` | 1,356
`'checkpoint_42'` | 1,351
`'checkpoint_43'` | 1,321
`'checkpoint_44'` | 1,332
`'checkpoint_45'` | 1,353
`'checkpoint_46'` | 1,320
`'checkpoint_47'` | 1,296
`'checkpoint_48'` | 1,296
`'checkpoint_49'` | 1,271

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):

<!-- mdformat off(HTML should not be auto-formatted) -->

{% framebox %}

<button id="displaydataframe">Display examples...</button>
<div id="dataframecontent" style="overflow-x:auto"></div>
<script>
const url = "https://storage.googleapis.com/tfds-data/visualization/dataframe/rlu_atari_checkpoints-ChopperCommand_run_2-1.1.0.html";
const dataButton = document.getElementById('displaydataframe');
dataButton.addEventListener('click', async () => {
  // Disable the button after clicking (dataframe loaded only once).
  dataButton.disabled = true;

  const contentPane = document.getElementById('dataframecontent');
  try {
    const response = await fetch(url);
    // Error response codes don't throw an error, so force an error to show
    // the error message.
    if (!response.ok) throw Error(response.statusText);

    const data = await response.text();
    contentPane.innerHTML = data;
  } catch (e) {
    contentPane.innerHTML =
        'Error loading examples. If the error persist, please open '
        + 'a new issue.';
  }
});
</script>

{% endframebox %}

<!-- mdformat on -->

## rlu_atari_checkpoints/ChopperCommand_run_3

*   **Dataset size**: `40.16 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 2,194
`'checkpoint_01'` | 1,921
`'checkpoint_02'` | 1,807
`'checkpoint_03'` | 1,538
`'checkpoint_04'` | 1,255
`'checkpoint_05'` | 1,202
`'checkpoint_06'` | 1,127
`'checkpoint_07'` | 1,297
`'checkpoint_08'` | 1,208
`'checkpoint_09'` | 1,165
`'checkpoint_10'` | 1,071
`'checkpoint_11'` | 1,196
`'checkpoint_12'` | 1,324
`'checkpoint_13'` | 1,339
`'checkpoint_14'` | 1,399
`'checkpoint_15'` | 1,374
`'checkpoint_16'` | 1,348
`'checkpoint_17'` | 1,357
`'checkpoint_18'` | 1,336
`'checkpoint_19'` | 1,457
`'checkpoint_20'` | 1,449
`'checkpoint_21'` | 1,452
`'checkpoint_22'` | 1,275
`'checkpoint_23'` | 1,340
`'checkpoint_24'` | 1,393
`'checkpoint_25'` | 1,385
`'checkpoint_26'` | 1,310
`'checkpoint_27'` | 1,296
`'checkpoint_28'` | 1,246
`'checkpoint_29'` | 1,328
`'checkpoint_30'` | 1,388
`'checkpoint_31'` | 1,377
`'checkpoint_32'` | 1,325
`'checkpoint_33'` | 1,295
`'checkpoint_34'` | 1,298
`'checkpoint_35'` | 1,314
`'checkpoint_36'` | 1,410
`'checkpoint_37'` | 1,276
`'checkpoint_38'` | 1,358
`'checkpoint_39'` | 1,423
`'checkpoint_40'` | 1,341
`'checkpoint_41'` | 1,381
`'checkpoint_42'` | 1,305
`'checkpoint_43'` | 1,333
`'checkpoint_44'` | 1,249
`'checkpoint_45'` | 1,175
`'checkpoint_46'` | 1,280
`'checkpoint_47'` | 1,444
`'checkpoint_48'` | 1,367
`'checkpoint_49'` | 1,345

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):

<!-- mdformat off(HTML should not be auto-formatted) -->

{% framebox %}

<button id="displaydataframe">Display examples...</button>
<div id="dataframecontent" style="overflow-x:auto"></div>
<script>
const url = "https://storage.googleapis.com/tfds-data/visualization/dataframe/rlu_atari_checkpoints-ChopperCommand_run_3-1.1.0.html";
const dataButton = document.getElementById('displaydataframe');
dataButton.addEventListener('click', async () => {
  // Disable the button after clicking (dataframe loaded only once).
  dataButton.disabled = true;

  const contentPane = document.getElementById('dataframecontent');
  try {
    const response = await fetch(url);
    // Error response codes don't throw an error, so force an error to show
    // the error message.
    if (!response.ok) throw Error(response.statusText);

    const data = await response.text();
    contentPane.innerHTML = data;
  } catch (e) {
    contentPane.innerHTML =
        'Error loading examples. If the error persist, please open '
        + 'a new issue.';
  }
});
</script>

{% endframebox %}

<!-- mdformat on -->

## rlu_atari_checkpoints/ChopperCommand_run_4

*   **Dataset size**: `40.24 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 2,228
`'checkpoint_01'` | 1,798
`'checkpoint_02'` | 1,842
`'checkpoint_03'` | 1,606
`'checkpoint_04'` | 1,331
`'checkpoint_05'` | 1,303
`'checkpoint_06'` | 1,225
`'checkpoint_07'` | 1,253
`'checkpoint_08'` | 1,069
`'checkpoint_09'` | 1,178
`'checkpoint_10'` | 1,264
`'checkpoint_11'` | 1,324
`'checkpoint_12'` | 1,313
`'checkpoint_13'` | 1,345
`'checkpoint_14'` | 1,333
`'checkpoint_15'` | 1,419
`'checkpoint_16'` | 1,296
`'checkpoint_17'` | 1,378
`'checkpoint_18'` | 1,431
`'checkpoint_19'` | 1,503
`'checkpoint_20'` | 1,431
`'checkpoint_21'` | 1,380
`'checkpoint_22'` | 1,467
`'checkpoint_23'` | 1,349
`'checkpoint_24'` | 1,335
`'checkpoint_25'` | 1,272
`'checkpoint_26'` | 1,280
`'checkpoint_27'` | 1,265
`'checkpoint_28'` | 1,309
`'checkpoint_29'` | 1,330
`'checkpoint_30'` | 1,205
`'checkpoint_31'` | 1,269
`'checkpoint_32'` | 1,201
`'checkpoint_33'` | 1,248
`'checkpoint_34'` | 1,271
`'checkpoint_35'` | 1,262
`'checkpoint_36'` | 1,268
`'checkpoint_37'` | 1,262
`'checkpoint_38'` | 1,277
`'checkpoint_39'` | 1,294
`'checkpoint_40'` | 1,243
`'checkpoint_41'` | 1,215
`'checkpoint_42'` | 1,343
`'checkpoint_43'` | 1,290
`'checkpoint_44'` | 1,351
`'checkpoint_45'` | 1,371
`'checkpoint_46'` | 1,413
`'checkpoint_47'` | 1,387
`'checkpoint_48'` | 1,300
`'checkpoint_49'` | 1,358

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):

<!-- mdformat off(HTML should not be auto-formatted) -->

{% framebox %}

<button id="displaydataframe">Display examples...</button>
<div id="dataframecontent" style="overflow-x:auto"></div>
<script>
const url = "https://storage.googleapis.com/tfds-data/visualization/dataframe/rlu_atari_checkpoints-ChopperCommand_run_4-1.1.0.html";
const dataButton = document.getElementById('displaydataframe');
dataButton.addEventListener('click', async () => {
  // Disable the button after clicking (dataframe loaded only once).
  dataButton.disabled = true;

  const contentPane = document.getElementById('dataframecontent');
  try {
    const response = await fetch(url);
    // Error response codes don't throw an error, so force an error to show
    // the error message.
    if (!response.ok) throw Error(response.statusText);

    const data = await response.text();
    contentPane.innerHTML = data;
  } catch (e) {
    contentPane.innerHTML =
        'Error loading examples. If the error persist, please open '
        + 'a new issue.';
  }
});
</script>

{% endframebox %}

<!-- mdformat on -->

## rlu_atari_checkpoints/ChopperCommand_run_5

*   **Dataset size**: `40.33 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 2,184
`'checkpoint_01'` | 1,852
`'checkpoint_02'` | 1,766
`'checkpoint_03'` | 1,525
`'checkpoint_04'` | 1,298
`'checkpoint_05'` | 1,142
`'checkpoint_06'` | 1,094
`'checkpoint_07'` | 1,252
`'checkpoint_08'` | 1,290
`'checkpoint_09'` | 1,284
`'checkpoint_10'` | 1,254
`'checkpoint_11'` | 1,229
`'checkpoint_12'` | 1,168
`'checkpoint_13'` | 1,295
`'checkpoint_14'` | 1,334
`'checkpoint_15'` | 1,373
`'checkpoint_16'` | 1,326
`'checkpoint_17'` | 1,313
`'checkpoint_18'` | 1,247
`'checkpoint_19'` | 1,308
`'checkpoint_20'` | 1,314
`'checkpoint_21'` | 1,347
`'checkpoint_22'` | 1,327
`'checkpoint_23'` | 1,432
`'checkpoint_24'` | 1,403
`'checkpoint_25'` | 1,420
`'checkpoint_26'` | 1,288
`'checkpoint_27'` | 1,291
`'checkpoint_28'` | 1,318
`'checkpoint_29'` | 1,361
`'checkpoint_30'` | 1,330
`'checkpoint_31'` | 1,202
`'checkpoint_32'` | 1,282
`'checkpoint_33'` | 1,234
`'checkpoint_34'` | 1,358
`'checkpoint_35'` | 1,132
`'checkpoint_36'` | 1,306
`'checkpoint_37'` | 1,249
`'checkpoint_38'` | 1,356
`'checkpoint_39'` | 1,394
`'checkpoint_40'` | 1,350
`'checkpoint_41'` | 1,293
`'checkpoint_42'` | 1,312
`'checkpoint_43'` | 1,343
`'checkpoint_44'` | 1,443
`'checkpoint_45'` | 1,340
`'checkpoint_46'` | 1,338
`'checkpoint_47'` | 1,385
`'checkpoint_48'` | 1,417
`'checkpoint_49'` | 1,339

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):

<!-- mdformat off(HTML should not be auto-formatted) -->

{% framebox %}

<button id="displaydataframe">Display examples...</button>
<div id="dataframecontent" style="overflow-x:auto"></div>
<script>
const url = "https://storage.googleapis.com/tfds-data/visualization/dataframe/rlu_atari_checkpoints-ChopperCommand_run_5-1.1.0.html";
const dataButton = document.getElementById('displaydataframe');
dataButton.addEventListener('click', async () => {
  // Disable the button after clicking (dataframe loaded only once).
  dataButton.disabled = true;

  const contentPane = document.getElementById('dataframecontent');
  try {
    const response = await fetch(url);
    // Error response codes don't throw an error, so force an error to show
    // the error message.
    if (!response.ok) throw Error(response.statusText);

    const data = await response.text();
    contentPane.innerHTML = data;
  } catch (e) {
    contentPane.innerHTML =
        'Error loading examples. If the error persist, please open '
        + 'a new issue.';
  }
});
</script>

{% endframebox %}

<!-- mdformat on -->

## rlu_atari_checkpoints/CrazyClimber_run_1

*   **Dataset size**: `51.22 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 295
`'checkpoint_01'` | 282
`'checkpoint_02'` | 250
`'checkpoint_03'` | 223
`'checkpoint_04'` | 222
`'checkpoint_05'` | 249
`'checkpoint_06'` | 241
`'checkpoint_07'` | 258
`'checkpoint_08'` | 250
`'checkpoint_09'` | 252
`'checkpoint_10'` | 252
`'checkpoint_11'` | 257
`'checkpoint_12'` | 252
`'checkpoint_13'` | 251
`'checkpoint_14'` | 254
`'checkpoint_15'` | 248
`'checkpoint_16'` | 252
`'checkpoint_17'` | 251
`'checkpoint_18'` | 255
`'checkpoint_19'` | 239
`'checkpoint_20'` | 240
`'checkpoint_21'` | 241
`'checkpoint_22'` | 250
`'checkpoint_23'` | 244
`'checkpoint_24'` | 248
`'checkpoint_25'` | 242
`'checkpoint_26'` | 246
`'checkpoint_27'` | 252
`'checkpoint_28'` | 249
`'checkpoint_29'` | 248
`'checkpoint_30'` | 252
`'checkpoint_31'` | 247
`'checkpoint_32'` | 249
`'checkpoint_33'` | 247
`'checkpoint_34'` | 248
`'checkpoint_35'` | 249
`'checkpoint_36'` | 253
`'checkpoint_37'` | 251
`'checkpoint_38'` | 253
`'checkpoint_39'` | 252
`'checkpoint_40'` | 252
`'checkpoint_41'` | 254
`'checkpoint_42'` | 260
`'checkpoint_43'` | 254
`'checkpoint_44'` | 256
`'checkpoint_45'` | 255
`'checkpoint_46'` | 252
`'checkpoint_47'` | 259
`'checkpoint_48'` | 258
`'checkpoint_49'` | 253

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):

<!-- mdformat off(HTML should not be auto-formatted) -->

{% framebox %}

<button id="displaydataframe">Display examples...</button>
<div id="dataframecontent" style="overflow-x:auto"></div>
<script>
const url = "https://storage.googleapis.com/tfds-data/visualization/dataframe/rlu_atari_checkpoints-CrazyClimber_run_1-1.1.0.html";
const dataButton = document.getElementById('displaydataframe');
dataButton.addEventListener('click', async () => {
  // Disable the button after clicking (dataframe loaded only once).
  dataButton.disabled = true;

  const contentPane = document.getElementById('dataframecontent');
  try {
    const response = await fetch(url);
    // Error response codes don't throw an error, so force an error to show
    // the error message.
    if (!response.ok) throw Error(response.statusText);

    const data = await response.text();
    contentPane.innerHTML = data;
  } catch (e) {
    contentPane.innerHTML =
        'Error loading examples. If the error persist, please open '
        + 'a new issue.';
  }
});
</script>

{% endframebox %}

<!-- mdformat on -->

## rlu_atari_checkpoints/CrazyClimber_run_2

*   **Dataset size**: `51.68 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 319
`'checkpoint_01'` | 297
`'checkpoint_02'` | 277
`'checkpoint_03'` | 273
`'checkpoint_04'` | 267
`'checkpoint_05'` | 260
`'checkpoint_06'` | 255
`'checkpoint_07'` | 249
`'checkpoint_08'` | 248
`'checkpoint_09'` | 250
`'checkpoint_10'` | 255
`'checkpoint_11'` | 243
`'checkpoint_12'` | 252
`'checkpoint_13'` | 256
`'checkpoint_14'` | 255
`'checkpoint_15'` | 252
`'checkpoint_16'` | 254
`'checkpoint_17'` | 250
`'checkpoint_18'` | 254
`'checkpoint_19'` | 259
`'checkpoint_20'` | 252
`'checkpoint_21'` | 252
`'checkpoint_22'` | 248
`'checkpoint_23'` | 250
`'checkpoint_24'` | 244
`'checkpoint_25'` | 252
`'checkpoint_26'` | 250
`'checkpoint_27'` | 254
`'checkpoint_28'` | 255
`'checkpoint_29'` | 257
`'checkpoint_30'` | 252
`'checkpoint_31'` | 256
`'checkpoint_32'` | 250
`'checkpoint_33'` | 253
`'checkpoint_34'` | 256
`'checkpoint_35'` | 256
`'checkpoint_36'` | 254
`'checkpoint_37'` | 251
`'checkpoint_38'` | 253
`'checkpoint_39'` | 254
`'checkpoint_40'` | 251
`'checkpoint_41'` | 256
`'checkpoint_42'` | 253
`'checkpoint_43'` | 251
`'checkpoint_44'` | 266
`'checkpoint_45'` | 258
`'checkpoint_46'` | 258
`'checkpoint_47'` | 255
`'checkpoint_48'` | 249
`'checkpoint_49'` | 262

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):

<!-- mdformat off(HTML should not be auto-formatted) -->

{% framebox %}

<button id="displaydataframe">Display examples...</button>
<div id="dataframecontent" style="overflow-x:auto"></div>
<script>
const url = "https://storage.googleapis.com/tfds-data/visualization/dataframe/rlu_atari_checkpoints-CrazyClimber_run_2-1.1.0.html";
const dataButton = document.getElementById('displaydataframe');
dataButton.addEventListener('click', async () => {
  // Disable the button after clicking (dataframe loaded only once).
  dataButton.disabled = true;

  const contentPane = document.getElementById('dataframecontent');
  try {
    const response = await fetch(url);
    // Error response codes don't throw an error, so force an error to show
    // the error message.
    if (!response.ok) throw Error(response.statusText);

    const data = await response.text();
    contentPane.innerHTML = data;
  } catch (e) {
    contentPane.innerHTML =
        'Error loading examples. If the error persist, please open '
        + 'a new issue.';
  }
});
</script>

{% endframebox %}

<!-- mdformat on -->

## rlu_atari_checkpoints/CrazyClimber_run_3

*   **Dataset size**: `51.19 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 299
`'checkpoint_01'` | 309
`'checkpoint_02'` | 281
`'checkpoint_03'` | 269
`'checkpoint_04'` | 263
`'checkpoint_05'` | 268
`'checkpoint_06'` | 267
`'checkpoint_07'` | 249
`'checkpoint_08'` | 224
`'checkpoint_09'` | 257
`'checkpoint_10'` | 248
`'checkpoint_11'` | 241
`'checkpoint_12'` | 248
`'checkpoint_13'` | 236
`'checkpoint_14'` | 250
`'checkpoint_15'` | 236
`'checkpoint_16'` | 249
`'checkpoint_17'` | 240
`'checkpoint_18'` | 247
`'checkpoint_19'` | 234
`'checkpoint_20'` | 246
`'checkpoint_21'` | 252
`'checkpoint_22'` | 250
`'checkpoint_23'` | 249
`'checkpoint_24'` | 253
`'checkpoint_25'` | 241
`'checkpoint_26'` | 249
`'checkpoint_27'` | 247
`'checkpoint_28'` | 248
`'checkpoint_29'` | 254
`'checkpoint_30'` | 247
`'checkpoint_31'` | 247
`'checkpoint_32'` | 247
`'checkpoint_33'` | 251
`'checkpoint_34'` | 253
`'checkpoint_35'` | 244
`'checkpoint_36'` | 248
`'checkpoint_37'` | 246
`'checkpoint_38'` | 251
`'checkpoint_39'` | 247
`'checkpoint_40'` | 246
`'checkpoint_41'` | 247
`'checkpoint_42'` | 250
`'checkpoint_43'` | 249
`'checkpoint_44'` | 250
`'checkpoint_45'` | 246
`'checkpoint_46'` | 256
`'checkpoint_47'` | 253
`'checkpoint_48'` | 252
`'checkpoint_49'` | 253

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):

<!-- mdformat off(HTML should not be auto-formatted) -->

{% framebox %}

<button id="displaydataframe">Display examples...</button>
<div id="dataframecontent" style="overflow-x:auto"></div>
<script>
const url = "https://storage.googleapis.com/tfds-data/visualization/dataframe/rlu_atari_checkpoints-CrazyClimber_run_3-1.1.0.html";
const dataButton = document.getElementById('displaydataframe');
dataButton.addEventListener('click', async () => {
  // Disable the button after clicking (dataframe loaded only once).
  dataButton.disabled = true;

  const contentPane = document.getElementById('dataframecontent');
  try {
    const response = await fetch(url);
    // Error response codes don't throw an error, so force an error to show
    // the error message.
    if (!response.ok) throw Error(response.statusText);

    const data = await response.text();
    contentPane.innerHTML = data;
  } catch (e) {
    contentPane.innerHTML =
        'Error loading examples. If the error persist, please open '
        + 'a new issue.';
  }
});
</script>

{% endframebox %}

<!-- mdformat on -->

## rlu_atari_checkpoints/CrazyClimber_run_4

*   **Dataset size**: `51.11 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 296
`'checkpoint_01'` | 300
`'checkpoint_02'` | 281
`'checkpoint_03'` | 272
`'checkpoint_04'` | 264
`'checkpoint_05'` | 247
`'checkpoint_06'` | 242
`'checkpoint_07'` | 252
`'checkpoint_08'` | 248
`'checkpoint_09'` | 255
`'checkpoint_10'` | 248
`'checkpoint_11'` | 244
`'checkpoint_12'` | 239
`'checkpoint_13'` | 242
`'checkpoint_14'` | 232
`'checkpoint_15'` | 250
`'checkpoint_16'` | 242
`'checkpoint_17'` | 245
`'checkpoint_18'` | 243
`'checkpoint_19'` | 249
`'checkpoint_20'` | 247
`'checkpoint_21'` | 256
`'checkpoint_22'` | 254
`'checkpoint_23'` | 251
`'checkpoint_24'` | 252
`'checkpoint_25'` | 250
`'checkpoint_26'` | 244
`'checkpoint_27'` | 247
`'checkpoint_28'` | 236
`'checkpoint_29'` | 236
`'checkpoint_30'` | 243
`'checkpoint_31'` | 253
`'checkpoint_32'` | 247
`'checkpoint_33'` | 243
`'checkpoint_34'` | 239
`'checkpoint_35'` | 221
`'checkpoint_36'` | 252
`'checkpoint_37'` | 249
`'checkpoint_38'` | 216
`'checkpoint_39'` | 193
`'checkpoint_40'` | 245
`'checkpoint_41'` | 249
`'checkpoint_42'` | 248
`'checkpoint_43'` | 253
`'checkpoint_44'` | 243
`'checkpoint_45'` | 252
`'checkpoint_46'` | 255
`'checkpoint_47'` | 254
`'checkpoint_48'` | 248
`'checkpoint_49'` | 247

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):

<!-- mdformat off(HTML should not be auto-formatted) -->

{% framebox %}

<button id="displaydataframe">Display examples...</button>
<div id="dataframecontent" style="overflow-x:auto"></div>
<script>
const url = "https://storage.googleapis.com/tfds-data/visualization/dataframe/rlu_atari_checkpoints-CrazyClimber_run_4-1.1.0.html";
const dataButton = document.getElementById('displaydataframe');
dataButton.addEventListener('click', async () => {
  // Disable the button after clicking (dataframe loaded only once).
  dataButton.disabled = true;

  const contentPane = document.getElementById('dataframecontent');
  try {
    const response = await fetch(url);
    // Error response codes don't throw an error, so force an error to show
    // the error message.
    if (!response.ok) throw Error(response.statusText);

    const data = await response.text();
    contentPane.innerHTML = data;
  } catch (e) {
    contentPane.innerHTML =
        'Error loading examples. If the error persist, please open '
        + 'a new issue.';
  }
});
</script>

{% endframebox %}

<!-- mdformat on -->

## rlu_atari_checkpoints/CrazyClimber_run_5

*   **Dataset size**: `51.30 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 290
`'checkpoint_01'` | 271
`'checkpoint_02'` | 235
`'checkpoint_03'` | 249
`'checkpoint_04'` | 245
`'checkpoint_05'` | 245
`'checkpoint_06'` | 246
`'checkpoint_07'` | 238
`'checkpoint_08'` | 233
`'checkpoint_09'` | 243
`'checkpoint_10'` | 241
`'checkpoint_11'` | 240
`'checkpoint_12'` | 244
`'checkpoint_13'` | 241
`'checkpoint_14'` | 246
`'checkpoint_15'` | 245
`'checkpoint_16'` | 250
`'checkpoint_17'` | 249
`'checkpoint_18'` | 252
`'checkpoint_19'` | 244
`'checkpoint_20'` | 250
`'checkpoint_21'` | 245
`'checkpoint_22'` | 253
`'checkpoint_23'` | 254
`'checkpoint_24'` | 254
`'checkpoint_25'` | 253
`'checkpoint_26'` | 252
`'checkpoint_27'` | 246
`'checkpoint_28'` | 243
`'checkpoint_29'` | 252
`'checkpoint_30'` | 245
`'checkpoint_31'` | 247
`'checkpoint_32'` | 248
`'checkpoint_33'` | 248
`'checkpoint_34'` | 251
`'checkpoint_35'` | 251
`'checkpoint_36'` | 254
`'checkpoint_37'` | 252
`'checkpoint_38'` | 253
`'checkpoint_39'` | 251
`'checkpoint_40'` | 253
`'checkpoint_41'` | 256
`'checkpoint_42'` | 249
`'checkpoint_43'` | 254
`'checkpoint_44'` | 254
`'checkpoint_45'` | 254
`'checkpoint_46'` | 251
`'checkpoint_47'` | 251
`'checkpoint_48'` | 253
`'checkpoint_49'` | 255

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):

<!-- mdformat off(HTML should not be auto-formatted) -->

{% framebox %}

<button id="displaydataframe">Display examples...</button>
<div id="dataframecontent" style="overflow-x:auto"></div>
<script>
const url = "https://storage.googleapis.com/tfds-data/visualization/dataframe/rlu_atari_checkpoints-CrazyClimber_run_5-1.1.0.html";
const dataButton = document.getElementById('displaydataframe');
dataButton.addEventListener('click', async () => {
  // Disable the button after clicking (dataframe loaded only once).
  dataButton.disabled = true;

  const contentPane = document.getElementById('dataframecontent');
  try {
    const response = await fetch(url);
    // Error response codes don't throw an error, so force an error to show
    // the error message.
    if (!response.ok) throw Error(response.statusText);

    const data = await response.text();
    contentPane.innerHTML = data;
  } catch (e) {
    contentPane.innerHTML =
        'Error loading examples. If the error persist, please open '
        + 'a new issue.';
  }
});
</script>

{% endframebox %}

<!-- mdformat on -->

## rlu_atari_checkpoints/DemonAttack_run_1

*   **Dataset size**: `24.09 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 1,218
`'checkpoint_01'` | 625
`'checkpoint_02'` | 550
`'checkpoint_03'` | 429
`'checkpoint_04'` | 462
`'checkpoint_05'` | 458
`'checkpoint_06'` | 427
`'checkpoint_07'` | 443
`'checkpoint_08'` | 419
`'checkpoint_09'` | 420
`'checkpoint_10'` | 442
`'checkpoint_11'` | 447
`'checkpoint_12'` | 449
`'checkpoint_13'` | 501
`'checkpoint_14'` | 449
`'checkpoint_15'` | 438
`'checkpoint_16'` | 444
`'checkpoint_17'` | 417
`'checkpoint_18'` | 406
`'checkpoint_19'` | 451
`'checkpoint_20'` | 455
`'checkpoint_21'` | 442
`'checkpoint_22'` | 394
`'checkpoint_23'` | 397
`'checkpoint_24'` | 408
`'checkpoint_25'` | 418
`'checkpoint_26'` | 425
`'checkpoint_27'` | 430
`'checkpoint_28'` | 426
`'checkpoint_29'` | 408
`'checkpoint_30'` | 405
`'checkpoint_31'` | 443
`'checkpoint_32'` | 420
`'checkpoint_33'` | 435
`'checkpoint_34'` | 445
`'checkpoint_35'` | 425
`'checkpoint_36'` | 433
`'checkpoint_37'` | 440
`'checkpoint_38'` | 395
`'checkpoint_39'` | 392
`'checkpoint_40'` | 421
`'checkpoint_41'` | 385
`'checkpoint_42'` | 386
`'checkpoint_43'` | 432
`'checkpoint_44'` | 422
`'checkpoint_45'` | 393
`'checkpoint_46'` | 424
`'checkpoint_47'` | 412
`'checkpoint_48'` | 419
`'checkpoint_49'` | 413

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):

<!-- mdformat off(HTML should not be auto-formatted) -->

{% framebox %}

<button id="displaydataframe">Display examples...</button>
<div id="dataframecontent" style="overflow-x:auto"></div>
<script>
const url = "https://storage.googleapis.com/tfds-data/visualization/dataframe/rlu_atari_checkpoints-DemonAttack_run_1-1.1.0.html";
const dataButton = document.getElementById('displaydataframe');
dataButton.addEventListener('click', async () => {
  // Disable the button after clicking (dataframe loaded only once).
  dataButton.disabled = true;

  const contentPane = document.getElementById('dataframecontent');
  try {
    const response = await fetch(url);
    // Error response codes don't throw an error, so force an error to show
    // the error message.
    if (!response.ok) throw Error(response.statusText);

    const data = await response.text();
    contentPane.innerHTML = data;
  } catch (e) {
    contentPane.innerHTML =
        'Error loading examples. If the error persist, please open '
        + 'a new issue.';
  }
});
</script>

{% endframebox %}

<!-- mdformat on -->

## rlu_atari_checkpoints/DemonAttack_run_2

*   **Dataset size**: `24.23 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 1,203
`'checkpoint_01'` | 556
`'checkpoint_02'` | 520
`'checkpoint_03'` | 456
`'checkpoint_04'` | 455
`'checkpoint_05'` | 447
`'checkpoint_06'` | 424
`'checkpoint_07'` | 412
`'checkpoint_08'` | 438
`'checkpoint_09'` | 441
`'checkpoint_10'` | 471
`'checkpoint_11'` | 434
`'checkpoint_12'` | 461
`'checkpoint_13'` | 433
`'checkpoint_14'` | 433
`'checkpoint_15'` | 436
`'checkpoint_16'` | 420
`'checkpoint_17'` | 397
`'checkpoint_18'` | 374
`'checkpoint_19'` | 374
`'checkpoint_20'` | 344
`'checkpoint_21'` | 357
`'checkpoint_22'` | 371
`'checkpoint_23'` | 357
`'checkpoint_24'` | 392
`'checkpoint_25'` | 383
`'checkpoint_26'` | 370
`'checkpoint_27'` | 344
`'checkpoint_28'` | 342
`'checkpoint_29'` | 359
`'checkpoint_30'` | 360
`'checkpoint_31'` | 328
`'checkpoint_32'` | 345
`'checkpoint_33'` | 336
`'checkpoint_34'` | 355
`'checkpoint_35'` | 342
`'checkpoint_36'` | 351
`'checkpoint_37'` | 326
`'checkpoint_38'` | 338
`'checkpoint_39'` | 325
`'checkpoint_40'` | 310
`'checkpoint_41'` | 344
`'checkpoint_42'` | 326
`'checkpoint_43'` | 322
`'checkpoint_44'` | 314
`'checkpoint_45'` | 315
`'checkpoint_46'` | 313
`'checkpoint_47'` | 311
`'checkpoint_48'` | 302
`'checkpoint_49'` | 303

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):

<!-- mdformat off(HTML should not be auto-formatted) -->

{% framebox %}

<button id="displaydataframe">Display examples...</button>
<div id="dataframecontent" style="overflow-x:auto"></div>
<script>
const url = "https://storage.googleapis.com/tfds-data/visualization/dataframe/rlu_atari_checkpoints-DemonAttack_run_2-1.1.0.html";
const dataButton = document.getElementById('displaydataframe');
dataButton.addEventListener('click', async () => {
  // Disable the button after clicking (dataframe loaded only once).
  dataButton.disabled = true;

  const contentPane = document.getElementById('dataframecontent');
  try {
    const response = await fetch(url);
    // Error response codes don't throw an error, so force an error to show
    // the error message.
    if (!response.ok) throw Error(response.statusText);

    const data = await response.text();
    contentPane.innerHTML = data;
  } catch (e) {
    contentPane.innerHTML =
        'Error loading examples. If the error persist, please open '
        + 'a new issue.';
  }
});
</script>

{% endframebox %}

<!-- mdformat on -->

## rlu_atari_checkpoints/DemonAttack_run_3

*   **Dataset size**: `24.22 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 1,265
`'checkpoint_01'` | 596
`'checkpoint_02'` | 437
`'checkpoint_03'` | 406
`'checkpoint_04'` | 399
`'checkpoint_05'` | 449
`'checkpoint_06'` | 427
`'checkpoint_07'` | 423
`'checkpoint_08'` | 424
`'checkpoint_09'` | 434
`'checkpoint_10'` | 401
`'checkpoint_11'` | 438
`'checkpoint_12'` | 375
`'checkpoint_13'` | 447
`'checkpoint_14'` | 423
`'checkpoint_15'` | 415
`'checkpoint_16'` | 431
`'checkpoint_17'` | 408
`'checkpoint_18'` | 407
`'checkpoint_19'` | 397
`'checkpoint_20'` | 383
`'checkpoint_21'` | 399
`'checkpoint_22'` | 365
`'checkpoint_23'` | 380
`'checkpoint_24'` | 390
`'checkpoint_25'` | 380
`'checkpoint_26'` | 381
`'checkpoint_27'` | 372
`'checkpoint_28'` | 366
`'checkpoint_29'` | 354
`'checkpoint_30'` | 337
`'checkpoint_31'` | 341
`'checkpoint_32'` | 337
`'checkpoint_33'` | 348
`'checkpoint_34'` | 344
`'checkpoint_35'` | 343
`'checkpoint_36'` | 353
`'checkpoint_37'` | 338
`'checkpoint_38'` | 324
`'checkpoint_39'` | 329
`'checkpoint_40'` | 317
`'checkpoint_41'` | 318
`'checkpoint_42'` | 315
`'checkpoint_43'` | 329
`'checkpoint_44'` | 329
`'checkpoint_45'` | 334
`'checkpoint_46'` | 335
`'checkpoint_47'` | 329
`'checkpoint_48'` | 331
`'checkpoint_49'` | 314

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):

<!-- mdformat off(HTML should not be auto-formatted) -->

{% framebox %}

<button id="displaydataframe">Display examples...</button>
<div id="dataframecontent" style="overflow-x:auto"></div>
<script>
const url = "https://storage.googleapis.com/tfds-data/visualization/dataframe/rlu_atari_checkpoints-DemonAttack_run_3-1.1.0.html";
const dataButton = document.getElementById('displaydataframe');
dataButton.addEventListener('click', async () => {
  // Disable the button after clicking (dataframe loaded only once).
  dataButton.disabled = true;

  const contentPane = document.getElementById('dataframecontent');
  try {
    const response = await fetch(url);
    // Error response codes don't throw an error, so force an error to show
    // the error message.
    if (!response.ok) throw Error(response.statusText);

    const data = await response.text();
    contentPane.innerHTML = data;
  } catch (e) {
    contentPane.innerHTML =
        'Error loading examples. If the error persist, please open '
        + 'a new issue.';
  }
});
</script>

{% endframebox %}

<!-- mdformat on -->

## rlu_atari_checkpoints/DemonAttack_run_4

*   **Dataset size**: `24.02 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 1,213
`'checkpoint_01'` | 678
`'checkpoint_02'` | 538
`'checkpoint_03'` | 494
`'checkpoint_04'` | 393
`'checkpoint_05'` | 469
`'checkpoint_06'` | 463
`'checkpoint_07'` | 442
`'checkpoint_08'` | 473
`'checkpoint_09'` | 484
`'checkpoint_10'` | 449
`'checkpoint_11'` | 485
`'checkpoint_12'` | 481
`'checkpoint_13'` | 487
`'checkpoint_14'` | 530
`'checkpoint_15'` | 455
`'checkpoint_16'` | 464
`'checkpoint_17'` | 473
`'checkpoint_18'` | 485
`'checkpoint_19'` | 508
`'checkpoint_20'` | 483
`'checkpoint_21'` | 464
`'checkpoint_22'` | 450
`'checkpoint_23'` | 458
`'checkpoint_24'` | 460
`'checkpoint_25'` | 399
`'checkpoint_26'` | 411
`'checkpoint_27'` | 439
`'checkpoint_28'` | 453
`'checkpoint_29'` | 418
`'checkpoint_30'` | 446
`'checkpoint_31'` | 412
`'checkpoint_32'` | 400
`'checkpoint_33'` | 434
`'checkpoint_34'` | 405
`'checkpoint_35'` | 404
`'checkpoint_36'` | 421
`'checkpoint_37'` | 441
`'checkpoint_38'` | 437
`'checkpoint_39'` | 450
`'checkpoint_40'` | 432
`'checkpoint_41'` | 455
`'checkpoint_42'` | 444
`'checkpoint_43'` | 405
`'checkpoint_44'` | 429
`'checkpoint_45'` | 427
`'checkpoint_46'` | 421
`'checkpoint_47'` | 425
`'checkpoint_48'` | 423
`'checkpoint_49'` | 381

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):

<!-- mdformat off(HTML should not be auto-formatted) -->

{% framebox %}

<button id="displaydataframe">Display examples...</button>
<div id="dataframecontent" style="overflow-x:auto"></div>
<script>
const url = "https://storage.googleapis.com/tfds-data/visualization/dataframe/rlu_atari_checkpoints-DemonAttack_run_4-1.1.0.html";
const dataButton = document.getElementById('displaydataframe');
dataButton.addEventListener('click', async () => {
  // Disable the button after clicking (dataframe loaded only once).
  dataButton.disabled = true;

  const contentPane = document.getElementById('dataframecontent');
  try {
    const response = await fetch(url);
    // Error response codes don't throw an error, so force an error to show
    // the error message.
    if (!response.ok) throw Error(response.statusText);

    const data = await response.text();
    contentPane.innerHTML = data;
  } catch (e) {
    contentPane.innerHTML =
        'Error loading examples. If the error persist, please open '
        + 'a new issue.';
  }
});
</script>

{% endframebox %}

<!-- mdformat on -->

## rlu_atari_checkpoints/DemonAttack_run_5

*   **Dataset size**: `23.86 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 1,219
`'checkpoint_01'` | 683
`'checkpoint_02'` | 541
`'checkpoint_03'` | 465
`'checkpoint_04'` | 499
`'checkpoint_05'` | 498
`'checkpoint_06'` | 444
`'checkpoint_07'` | 473
`'checkpoint_08'` | 450
`'checkpoint_09'` | 482
`'checkpoint_10'` | 472
`'checkpoint_11'` | 484
`'checkpoint_12'` | 460
`'checkpoint_13'` | 484
`'checkpoint_14'` | 462
`'checkpoint_15'` | 451
`'checkpoint_16'` | 523
`'checkpoint_17'` | 516
`'checkpoint_18'` | 487
`'checkpoint_19'` | 478
`'checkpoint_20'` | 501
`'checkpoint_21'` | 505
`'checkpoint_22'` | 462
`'checkpoint_23'` | 477
`'checkpoint_24'` | 484
`'checkpoint_25'` | 531
`'checkpoint_26'` | 492
`'checkpoint_27'` | 466
`'checkpoint_28'` | 493
`'checkpoint_29'` | 472
`'checkpoint_30'` | 497
`'checkpoint_31'` | 505
`'checkpoint_32'` | 514
`'checkpoint_33'` | 521
`'checkpoint_34'` | 552
`'checkpoint_35'` | 522
`'checkpoint_36'` | 474
`'checkpoint_37'` | 507
`'checkpoint_38'` | 518
`'checkpoint_39'` | 553
`'checkpoint_40'` | 539
`'checkpoint_41'` | 519
`'checkpoint_42'` | 535
`'checkpoint_43'` | 483
`'checkpoint_44'` | 532
`'checkpoint_45'` | 496
`'checkpoint_46'` | 530
`'checkpoint_47'` | 549
`'checkpoint_48'` | 598
`'checkpoint_49'` | 505

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):

<!-- mdformat off(HTML should not be auto-formatted) -->

{% framebox %}

<button id="displaydataframe">Display examples...</button>
<div id="dataframecontent" style="overflow-x:auto"></div>
<script>
const url = "https://storage.googleapis.com/tfds-data/visualization/dataframe/rlu_atari_checkpoints-DemonAttack_run_5-1.1.0.html";
const dataButton = document.getElementById('displaydataframe');
dataButton.addEventListener('click', async () => {
  // Disable the button after clicking (dataframe loaded only once).
  dataButton.disabled = true;

  const contentPane = document.getElementById('dataframecontent');
  try {
    const response = await fetch(url);
    // Error response codes don't throw an error, so force an error to show
    // the error message.
    if (!response.ok) throw Error(response.statusText);

    const data = await response.text();
    contentPane.innerHTML = data;
  } catch (e) {
    contentPane.innerHTML =
        'Error loading examples. If the error persist, please open '
        + 'a new issue.';
  }
});
</script>

{% endframebox %}

<!-- mdformat on -->

## rlu_atari_checkpoints/DoubleDunk_run_1

*   **Dataset size**: `49.40 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 455
`'checkpoint_01'` | 211
`'checkpoint_02'` | 225
`'checkpoint_03'` | 207
`'checkpoint_04'` | 211
`'checkpoint_05'` | 229
`'checkpoint_06'` | 215
`'checkpoint_07'` | 211
`'checkpoint_08'` | 211
`'checkpoint_09'` | 196
`'checkpoint_10'` | 205
`'checkpoint_11'` | 210
`'checkpoint_12'` | 216
`'checkpoint_13'` | 211
`'checkpoint_14'` | 209
`'checkpoint_15'` | 193
`'checkpoint_16'` | 184
`'checkpoint_17'` | 203
`'checkpoint_18'` | 196
`'checkpoint_19'` | 214
`'checkpoint_20'` | 246
`'checkpoint_21'` | 259
`'checkpoint_22'` | 275
`'checkpoint_23'` | 285
`'checkpoint_24'` | 316
`'checkpoint_25'` | 327
`'checkpoint_26'` | 343
`'checkpoint_27'` | 353
`'checkpoint_28'` | 352
`'checkpoint_29'` | 338
`'checkpoint_30'` | 333
`'checkpoint_31'` | 337
`'checkpoint_32'` | 335
`'checkpoint_33'` | 342
`'checkpoint_34'` | 341
`'checkpoint_35'` | 341
`'checkpoint_36'` | 347
`'checkpoint_37'` | 354
`'checkpoint_38'` | 340
`'checkpoint_39'` | 345
`'checkpoint_40'` | 341
`'checkpoint_41'` | 346
`'checkpoint_42'` | 327
`'checkpoint_43'` | 338
`'checkpoint_44'` | 357
`'checkpoint_45'` | 342
`'checkpoint_46'` | 348
`'checkpoint_47'` | 360
`'checkpoint_48'` | 355
`'checkpoint_49'` | 358

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):

<!-- mdformat off(HTML should not be auto-formatted) -->

{% framebox %}

<button id="displaydataframe">Display examples...</button>
<div id="dataframecontent" style="overflow-x:auto"></div>
<script>
const url = "https://storage.googleapis.com/tfds-data/visualization/dataframe/rlu_atari_checkpoints-DoubleDunk_run_1-1.1.0.html";
const dataButton = document.getElementById('displaydataframe');
dataButton.addEventListener('click', async () => {
  // Disable the button after clicking (dataframe loaded only once).
  dataButton.disabled = true;

  const contentPane = document.getElementById('dataframecontent');
  try {
    const response = await fetch(url);
    // Error response codes don't throw an error, so force an error to show
    // the error message.
    if (!response.ok) throw Error(response.statusText);

    const data = await response.text();
    contentPane.innerHTML = data;
  } catch (e) {
    contentPane.innerHTML =
        'Error loading examples. If the error persist, please open '
        + 'a new issue.';
  }
});
</script>

{% endframebox %}

<!-- mdformat on -->

## rlu_atari_checkpoints/DoubleDunk_run_2

*   **Dataset size**: `49.37 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 449
`'checkpoint_01'` | 242
`'checkpoint_02'` | 193
`'checkpoint_03'` | 205
`'checkpoint_04'` | 213
`'checkpoint_05'` | 218
`'checkpoint_06'` | 211
`'checkpoint_07'` | 206
`'checkpoint_08'` | 218
`'checkpoint_09'` | 195
`'checkpoint_10'` | 203
`'checkpoint_11'` | 207
`'checkpoint_12'` | 212
`'checkpoint_13'` | 235
`'checkpoint_14'` | 214
`'checkpoint_15'` | 224
`'checkpoint_16'` | 296
`'checkpoint_17'` | 227
`'checkpoint_18'` | 237
`'checkpoint_19'` | 229
`'checkpoint_20'` | 245
`'checkpoint_21'` | 307
`'checkpoint_22'` | 316
`'checkpoint_23'` | 350
`'checkpoint_24'` | 353
`'checkpoint_25'` | 348
`'checkpoint_26'` | 364
`'checkpoint_27'` | 368
`'checkpoint_28'` | 372
`'checkpoint_29'` | 352
`'checkpoint_30'` | 348
`'checkpoint_31'` | 370
`'checkpoint_32'` | 360
`'checkpoint_33'` | 363
`'checkpoint_34'` | 360
`'checkpoint_35'` | 361
`'checkpoint_36'` | 358
`'checkpoint_37'` | 350
`'checkpoint_38'` | 358
`'checkpoint_39'` | 362
`'checkpoint_40'` | 340
`'checkpoint_41'` | 348
`'checkpoint_42'` | 357
`'checkpoint_43'` | 346
`'checkpoint_44'` | 350
`'checkpoint_45'` | 337
`'checkpoint_46'` | 350
`'checkpoint_47'` | 347
`'checkpoint_48'` | 351
`'checkpoint_49'` | 352

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):

<!-- mdformat off(HTML should not be auto-formatted) -->

{% framebox %}

<button id="displaydataframe">Display examples...</button>
<div id="dataframecontent" style="overflow-x:auto"></div>
<script>
const url = "https://storage.googleapis.com/tfds-data/visualization/dataframe/rlu_atari_checkpoints-DoubleDunk_run_2-1.1.0.html";
const dataButton = document.getElementById('displaydataframe');
dataButton.addEventListener('click', async () => {
  // Disable the button after clicking (dataframe loaded only once).
  dataButton.disabled = true;

  const contentPane = document.getElementById('dataframecontent');
  try {
    const response = await fetch(url);
    // Error response codes don't throw an error, so force an error to show
    // the error message.
    if (!response.ok) throw Error(response.statusText);

    const data = await response.text();
    contentPane.innerHTML = data;
  } catch (e) {
    contentPane.innerHTML =
        'Error loading examples. If the error persist, please open '
        + 'a new issue.';
  }
});
</script>

{% endframebox %}

<!-- mdformat on -->

## rlu_atari_checkpoints/DoubleDunk_run_3

*   **Dataset size**: `49.33 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 447
`'checkpoint_01'` | 228
`'checkpoint_02'` | 219
`'checkpoint_03'` | 207
`'checkpoint_04'` | 194
`'checkpoint_05'` | 208
`'checkpoint_06'` | 203
`'checkpoint_07'` | 204
`'checkpoint_08'` | 205
`'checkpoint_09'` | 218
`'checkpoint_10'` | 182
`'checkpoint_11'` | 175
`'checkpoint_12'` | 185
`'checkpoint_13'` | 227
`'checkpoint_14'` | 211
`'checkpoint_15'` | 242
`'checkpoint_16'` | 259
`'checkpoint_17'` | 250
`'checkpoint_18'` | 247
`'checkpoint_19'` | 288
`'checkpoint_20'` | 301
`'checkpoint_21'` | 314
`'checkpoint_22'` | 301
`'checkpoint_23'` | 321
`'checkpoint_24'` | 322
`'checkpoint_25'` | 308
`'checkpoint_26'` | 310
`'checkpoint_27'` | 310
`'checkpoint_28'` | 314
`'checkpoint_29'` | 315
`'checkpoint_30'` | 328
`'checkpoint_31'` | 332
`'checkpoint_32'` | 329
`'checkpoint_33'` | 330
`'checkpoint_34'` | 327
`'checkpoint_35'` | 317
`'checkpoint_36'` | 331
`'checkpoint_37'` | 326
`'checkpoint_38'` | 334
`'checkpoint_39'` | 338
`'checkpoint_40'` | 333
`'checkpoint_41'` | 332
`'checkpoint_42'` | 336
`'checkpoint_43'` | 336
`'checkpoint_44'` | 336
`'checkpoint_45'` | 338
`'checkpoint_46'` | 328
`'checkpoint_47'` | 335
`'checkpoint_48'` | 336
`'checkpoint_49'` | 340

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):

<!-- mdformat off(HTML should not be auto-formatted) -->

{% framebox %}

<button id="displaydataframe">Display examples...</button>
<div id="dataframecontent" style="overflow-x:auto"></div>
<script>
const url = "https://storage.googleapis.com/tfds-data/visualization/dataframe/rlu_atari_checkpoints-DoubleDunk_run_3-1.1.0.html";
const dataButton = document.getElementById('displaydataframe');
dataButton.addEventListener('click', async () => {
  // Disable the button after clicking (dataframe loaded only once).
  dataButton.disabled = true;

  const contentPane = document.getElementById('dataframecontent');
  try {
    const response = await fetch(url);
    // Error response codes don't throw an error, so force an error to show
    // the error message.
    if (!response.ok) throw Error(response.statusText);

    const data = await response.text();
    contentPane.innerHTML = data;
  } catch (e) {
    contentPane.innerHTML =
        'Error loading examples. If the error persist, please open '
        + 'a new issue.';
  }
});
</script>

{% endframebox %}

<!-- mdformat on -->

## rlu_atari_checkpoints/DoubleDunk_run_4

*   **Dataset size**: `49.36 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 424
`'checkpoint_01'` | 241
`'checkpoint_02'` | 214
`'checkpoint_03'` | 236
`'checkpoint_04'` | 235
`'checkpoint_05'` | 234
`'checkpoint_06'` | 205
`'checkpoint_07'` | 206
`'checkpoint_08'` | 232
`'checkpoint_09'` | 216
`'checkpoint_10'` | 228
`'checkpoint_11'` | 231
`'checkpoint_12'` | 233
`'checkpoint_13'` | 207
`'checkpoint_14'` | 223
`'checkpoint_15'` | 215
`'checkpoint_16'` | 226
`'checkpoint_17'` | 226
`'checkpoint_18'` | 238
`'checkpoint_19'` | 259
`'checkpoint_20'` | 240
`'checkpoint_21'` | 289
`'checkpoint_22'` | 317
`'checkpoint_23'` | 327
`'checkpoint_24'` | 309
`'checkpoint_25'` | 319
`'checkpoint_26'` | 343
`'checkpoint_27'` | 334
`'checkpoint_28'` | 318
`'checkpoint_29'` | 353
`'checkpoint_30'` | 334
`'checkpoint_31'` | 343
`'checkpoint_32'` | 339
`'checkpoint_33'` | 330
`'checkpoint_34'` | 333
`'checkpoint_35'` | 323
`'checkpoint_36'` | 325
`'checkpoint_37'` | 338
`'checkpoint_38'` | 331
`'checkpoint_39'` | 343
`'checkpoint_40'` | 335
`'checkpoint_41'` | 348
`'checkpoint_42'` | 354
`'checkpoint_43'` | 340
`'checkpoint_44'` | 364
`'checkpoint_45'` | 353
`'checkpoint_46'` | 350
`'checkpoint_47'` | 360
`'checkpoint_48'` | 340
`'checkpoint_49'` | 339

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):

<!-- mdformat off(HTML should not be auto-formatted) -->

{% framebox %}

<button id="displaydataframe">Display examples...</button>
<div id="dataframecontent" style="overflow-x:auto"></div>
<script>
const url = "https://storage.googleapis.com/tfds-data/visualization/dataframe/rlu_atari_checkpoints-DoubleDunk_run_4-1.1.0.html";
const dataButton = document.getElementById('displaydataframe');
dataButton.addEventListener('click', async () => {
  // Disable the button after clicking (dataframe loaded only once).
  dataButton.disabled = true;

  const contentPane = document.getElementById('dataframecontent');
  try {
    const response = await fetch(url);
    // Error response codes don't throw an error, so force an error to show
    // the error message.
    if (!response.ok) throw Error(response.statusText);

    const data = await response.text();
    contentPane.innerHTML = data;
  } catch (e) {
    contentPane.innerHTML =
        'Error loading examples. If the error persist, please open '
        + 'a new issue.';
  }
});
</script>

{% endframebox %}

<!-- mdformat on -->

## rlu_atari_checkpoints/DoubleDunk_run_5

*   **Dataset size**: `49.38 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 447
`'checkpoint_01'` | 234
`'checkpoint_02'` | 195
`'checkpoint_03'` | 217
`'checkpoint_04'` | 202
`'checkpoint_05'` | 222
`'checkpoint_06'` | 216
`'checkpoint_07'` | 206
`'checkpoint_08'` | 210
`'checkpoint_09'` | 210
`'checkpoint_10'` | 211
`'checkpoint_11'` | 219
`'checkpoint_12'` | 205
`'checkpoint_13'` | 207
`'checkpoint_14'` | 212
`'checkpoint_15'` | 200
`'checkpoint_16'` | 221
`'checkpoint_17'` | 238
`'checkpoint_18'` | 245
`'checkpoint_19'` | 267
`'checkpoint_20'` | 292
`'checkpoint_21'` | 296
`'checkpoint_22'` | 294
`'checkpoint_23'` | 291
`'checkpoint_24'` | 333
`'checkpoint_25'` | 328
`'checkpoint_26'` | 329
`'checkpoint_27'` | 347
`'checkpoint_28'` | 358
`'checkpoint_29'` | 355
`'checkpoint_30'` | 340
`'checkpoint_31'` | 364
`'checkpoint_32'` | 357
`'checkpoint_33'` | 353
`'checkpoint_34'` | 349
`'checkpoint_35'` | 350
`'checkpoint_36'` | 351
`'checkpoint_37'` | 345
`'checkpoint_38'` | 347
`'checkpoint_39'` | 348
`'checkpoint_40'` | 363
`'checkpoint_41'` | 350
`'checkpoint_42'` | 347
`'checkpoint_43'` | 328
`'checkpoint_44'` | 337
`'checkpoint_45'` | 336
`'checkpoint_46'` | 340
`'checkpoint_47'` | 335
`'checkpoint_48'` | 337
`'checkpoint_49'` | 334

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):

<!-- mdformat off(HTML should not be auto-formatted) -->

{% framebox %}

<button id="displaydataframe">Display examples...</button>
<div id="dataframecontent" style="overflow-x:auto"></div>
<script>
const url = "https://storage.googleapis.com/tfds-data/visualization/dataframe/rlu_atari_checkpoints-DoubleDunk_run_5-1.1.0.html";
const dataButton = document.getElementById('displaydataframe');
dataButton.addEventListener('click', async () => {
  // Disable the button after clicking (dataframe loaded only once).
  dataButton.disabled = true;

  const contentPane = document.getElementById('dataframecontent');
  try {
    const response = await fetch(url);
    // Error response codes don't throw an error, so force an error to show
    // the error message.
    if (!response.ok) throw Error(response.statusText);

    const data = await response.text();
    contentPane.innerHTML = data;
  } catch (e) {
    contentPane.innerHTML =
        'Error loading examples. If the error persist, please open '
        + 'a new issue.';
  }
});
</script>

{% endframebox %}

<!-- mdformat on -->

## rlu_atari_checkpoints/Enduro_run_1

*   **Dataset size**: `56.76 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 296
`'checkpoint_01'` | 148
`'checkpoint_02'` | 121
`'checkpoint_03'` | 123
`'checkpoint_04'` | 146
`'checkpoint_05'` | 136
`'checkpoint_06'` | 124
`'checkpoint_07'` | 123
`'checkpoint_08'` | 116
`'checkpoint_09'` | 110
`'checkpoint_10'` | 108
`'checkpoint_11'` | 104
`'checkpoint_12'` | 110
`'checkpoint_13'` | 102
`'checkpoint_14'` | 104
`'checkpoint_15'` | 112
`'checkpoint_16'` | 100
`'checkpoint_17'` | 101
`'checkpoint_18'` | 106
`'checkpoint_19'` | 100
`'checkpoint_20'` | 98
`'checkpoint_21'` | 96
`'checkpoint_22'` | 100
`'checkpoint_23'` | 106
`'checkpoint_24'` | 99
`'checkpoint_25'` | 98
`'checkpoint_26'` | 101
`'checkpoint_27'` | 105
`'checkpoint_28'` | 97
`'checkpoint_29'` | 100
`'checkpoint_30'` | 101
`'checkpoint_31'` | 107
`'checkpoint_32'` | 97
`'checkpoint_33'` | 96
`'checkpoint_34'` | 98
`'checkpoint_35'` | 99
`'checkpoint_36'` | 104
`'checkpoint_37'` | 110
`'checkpoint_38'` | 102
`'checkpoint_39'` | 108
`'checkpoint_40'` | 105
`'checkpoint_41'` | 109
`'checkpoint_42'` | 110
`'checkpoint_43'` | 108
`'checkpoint_44'` | 113
`'checkpoint_45'` | 114
`'checkpoint_46'` | 109
`'checkpoint_47'` | 119
`'checkpoint_48'` | 120
`'checkpoint_49'` | 115

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):

<!-- mdformat off(HTML should not be auto-formatted) -->

{% framebox %}

<button id="displaydataframe">Display examples...</button>
<div id="dataframecontent" style="overflow-x:auto"></div>
<script>
const url = "https://storage.googleapis.com/tfds-data/visualization/dataframe/rlu_atari_checkpoints-Enduro_run_1-1.1.0.html";
const dataButton = document.getElementById('displaydataframe');
dataButton.addEventListener('click', async () => {
  // Disable the button after clicking (dataframe loaded only once).
  dataButton.disabled = true;

  const contentPane = document.getElementById('dataframecontent');
  try {
    const response = await fetch(url);
    // Error response codes don't throw an error, so force an error to show
    // the error message.
    if (!response.ok) throw Error(response.statusText);

    const data = await response.text();
    contentPane.innerHTML = data;
  } catch (e) {
    contentPane.innerHTML =
        'Error loading examples. If the error persist, please open '
        + 'a new issue.';
  }
});
</script>

{% endframebox %}

<!-- mdformat on -->

## rlu_atari_checkpoints/Enduro_run_2

*   **Dataset size**: `56.75 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 293
`'checkpoint_01'` | 142
`'checkpoint_02'` | 112
`'checkpoint_03'` | 110
`'checkpoint_04'` | 136
`'checkpoint_05'` | 125
`'checkpoint_06'` | 120
`'checkpoint_07'` | 109
`'checkpoint_08'` | 105
`'checkpoint_09'` | 114
`'checkpoint_10'` | 101
`'checkpoint_11'` | 104
`'checkpoint_12'` | 104
`'checkpoint_13'` | 101
`'checkpoint_14'` | 102
`'checkpoint_15'` | 100
`'checkpoint_16'` | 103
`'checkpoint_17'` | 107
`'checkpoint_18'` | 102
`'checkpoint_19'` | 103
`'checkpoint_20'` | 100
`'checkpoint_21'` | 104
`'checkpoint_22'` | 103
`'checkpoint_23'` | 108
`'checkpoint_24'` | 101
`'checkpoint_25'` | 113
`'checkpoint_26'` | 99
`'checkpoint_27'` | 99
`'checkpoint_28'` | 100
`'checkpoint_29'` | 101
`'checkpoint_30'` | 97
`'checkpoint_31'` | 102
`'checkpoint_32'` | 107
`'checkpoint_33'` | 114
`'checkpoint_34'` | 106
`'checkpoint_35'` | 105
`'checkpoint_36'` | 107
`'checkpoint_37'` | 113
`'checkpoint_38'` | 107
`'checkpoint_39'` | 104
`'checkpoint_40'` | 114
`'checkpoint_41'` | 114
`'checkpoint_42'` | 106
`'checkpoint_43'` | 122
`'checkpoint_44'` | 109
`'checkpoint_45'` | 121
`'checkpoint_46'` | 125
`'checkpoint_47'` | 111
`'checkpoint_48'` | 116
`'checkpoint_49'` | 121

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):

<!-- mdformat off(HTML should not be auto-formatted) -->

{% framebox %}

<button id="displaydataframe">Display examples...</button>
<div id="dataframecontent" style="overflow-x:auto"></div>
<script>
const url = "https://storage.googleapis.com/tfds-data/visualization/dataframe/rlu_atari_checkpoints-Enduro_run_2-1.1.0.html";
const dataButton = document.getElementById('displaydataframe');
dataButton.addEventListener('click', async () => {
  // Disable the button after clicking (dataframe loaded only once).
  dataButton.disabled = true;

  const contentPane = document.getElementById('dataframecontent');
  try {
    const response = await fetch(url);
    // Error response codes don't throw an error, so force an error to show
    // the error message.
    if (!response.ok) throw Error(response.statusText);

    const data = await response.text();
    contentPane.innerHTML = data;
  } catch (e) {
    contentPane.innerHTML =
        'Error loading examples. If the error persist, please open '
        + 'a new issue.';
  }
});
</script>

{% endframebox %}

<!-- mdformat on -->

## rlu_atari_checkpoints/Enduro_run_3

*   **Dataset size**: `56.76 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 294
`'checkpoint_01'` | 141
`'checkpoint_02'` | 119
`'checkpoint_03'` | 119
`'checkpoint_04'` | 137
`'checkpoint_05'` | 157
`'checkpoint_06'` | 135
`'checkpoint_07'` | 117
`'checkpoint_08'` | 116
`'checkpoint_09'` | 110
`'checkpoint_10'` | 104
`'checkpoint_11'` | 108
`'checkpoint_12'` | 107
`'checkpoint_13'` | 107
`'checkpoint_14'` | 102
`'checkpoint_15'` | 110
`'checkpoint_16'` | 112
`'checkpoint_17'` | 98
`'checkpoint_18'` | 99
`'checkpoint_19'` | 101
`'checkpoint_20'` | 112
`'checkpoint_21'` | 98
`'checkpoint_22'` | 99
`'checkpoint_23'` | 95
`'checkpoint_24'` | 111
`'checkpoint_25'` | 99
`'checkpoint_26'` | 108
`'checkpoint_27'` | 109
`'checkpoint_28'` | 107
`'checkpoint_29'` | 106
`'checkpoint_30'` | 112
`'checkpoint_31'` | 109
`'checkpoint_32'` | 104
`'checkpoint_33'` | 111
`'checkpoint_34'` | 105
`'checkpoint_35'` | 114
`'checkpoint_36'` | 111
`'checkpoint_37'` | 102
`'checkpoint_38'` | 104
`'checkpoint_39'` | 107
`'checkpoint_40'` | 113
`'checkpoint_41'` | 125
`'checkpoint_42'` | 123
`'checkpoint_43'` | 109
`'checkpoint_44'` | 113
`'checkpoint_45'` | 115
`'checkpoint_46'` | 114
`'checkpoint_47'` | 118
`'checkpoint_48'` | 109
`'checkpoint_49'` | 114

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):

<!-- mdformat off(HTML should not be auto-formatted) -->

{% framebox %}

<button id="displaydataframe">Display examples...</button>
<div id="dataframecontent" style="overflow-x:auto"></div>
<script>
const url = "https://storage.googleapis.com/tfds-data/visualization/dataframe/rlu_atari_checkpoints-Enduro_run_3-1.1.0.html";
const dataButton = document.getElementById('displaydataframe');
dataButton.addEventListener('click', async () => {
  // Disable the button after clicking (dataframe loaded only once).
  dataButton.disabled = true;

  const contentPane = document.getElementById('dataframecontent');
  try {
    const response = await fetch(url);
    // Error response codes don't throw an error, so force an error to show
    // the error message.
    if (!response.ok) throw Error(response.statusText);

    const data = await response.text();
    contentPane.innerHTML = data;
  } catch (e) {
    contentPane.innerHTML =
        'Error loading examples. If the error persist, please open '
        + 'a new issue.';
  }
});
</script>

{% endframebox %}

<!-- mdformat on -->

## rlu_atari_checkpoints/Enduro_run_4

*   **Dataset size**: `56.76 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 299
`'checkpoint_01'` | 145
`'checkpoint_02'` | 114
`'checkpoint_03'` | 105
`'checkpoint_04'` | 135
`'checkpoint_05'` | 124
`'checkpoint_06'` | 114
`'checkpoint_07'` | 115
`'checkpoint_08'` | 117
`'checkpoint_09'` | 112
`'checkpoint_10'` | 102
`'checkpoint_11'` | 99
`'checkpoint_12'` | 104
`'checkpoint_13'` | 99
`'checkpoint_14'` | 98
`'checkpoint_15'` | 99
`'checkpoint_16'` | 100
`'checkpoint_17'` | 110
`'checkpoint_18'` | 106
`'checkpoint_19'` | 99
`'checkpoint_20'` | 107
`'checkpoint_21'` | 102
`'checkpoint_22'` | 105
`'checkpoint_23'` | 105
`'checkpoint_24'` | 98
`'checkpoint_25'` | 102
`'checkpoint_26'` | 110
`'checkpoint_27'` | 100
`'checkpoint_28'` | 103
`'checkpoint_29'` | 111
`'checkpoint_30'` | 112
`'checkpoint_31'` | 107
`'checkpoint_32'` | 104
`'checkpoint_33'` | 108
`'checkpoint_34'` | 106
`'checkpoint_35'` | 101
`'checkpoint_36'` | 108
`'checkpoint_37'` | 102
`'checkpoint_38'` | 105
`'checkpoint_39'` | 100
`'checkpoint_40'` | 104
`'checkpoint_41'` | 112
`'checkpoint_42'` | 114
`'checkpoint_43'` | 116
`'checkpoint_44'` | 107
`'checkpoint_45'` | 110
`'checkpoint_46'` | 114
`'checkpoint_47'` | 108
`'checkpoint_48'` | 107
`'checkpoint_49'` | 117

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):

<!-- mdformat off(HTML should not be auto-formatted) -->

{% framebox %}

<button id="displaydataframe">Display examples...</button>
<div id="dataframecontent" style="overflow-x:auto"></div>
<script>
const url = "https://storage.googleapis.com/tfds-data/visualization/dataframe/rlu_atari_checkpoints-Enduro_run_4-1.1.0.html";
const dataButton = document.getElementById('displaydataframe');
dataButton.addEventListener('click', async () => {
  // Disable the button after clicking (dataframe loaded only once).
  dataButton.disabled = true;

  const contentPane = document.getElementById('dataframecontent');
  try {
    const response = await fetch(url);
    // Error response codes don't throw an error, so force an error to show
    // the error message.
    if (!response.ok) throw Error(response.statusText);

    const data = await response.text();
    contentPane.innerHTML = data;
  } catch (e) {
    contentPane.innerHTML =
        'Error loading examples. If the error persist, please open '
        + 'a new issue.';
  }
});
</script>

{% endframebox %}

<!-- mdformat on -->

## rlu_atari_checkpoints/Enduro_run_5

*   **Dataset size**: `56.74 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 296
`'checkpoint_01'` | 143
`'checkpoint_02'` | 111
`'checkpoint_03'` | 107
`'checkpoint_04'` | 133
`'checkpoint_05'` | 133
`'checkpoint_06'` | 111
`'checkpoint_07'` | 118
`'checkpoint_08'` | 112
`'checkpoint_09'` | 111
`'checkpoint_10'` | 120
`'checkpoint_11'` | 106
`'checkpoint_12'` | 102
`'checkpoint_13'` | 109
`'checkpoint_14'` | 115
`'checkpoint_15'` | 111
`'checkpoint_16'` | 98
`'checkpoint_17'` | 108
`'checkpoint_18'` | 106
`'checkpoint_19'` | 101
`'checkpoint_20'` | 105
`'checkpoint_21'` | 107
`'checkpoint_22'` | 121
`'checkpoint_23'` | 113
`'checkpoint_24'` | 109
`'checkpoint_25'` | 109
`'checkpoint_26'` | 108
`'checkpoint_27'` | 105
`'checkpoint_28'` | 109
`'checkpoint_29'` | 107
`'checkpoint_30'` | 114
`'checkpoint_31'` | 104
`'checkpoint_32'` | 116
`'checkpoint_33'` | 108
`'checkpoint_34'` | 104
`'checkpoint_35'` | 114
`'checkpoint_36'` | 102
`'checkpoint_37'` | 106
`'checkpoint_38'` | 107
`'checkpoint_39'` | 116
`'checkpoint_40'` | 112
`'checkpoint_41'` | 107
`'checkpoint_42'` | 105
`'checkpoint_43'` | 118
`'checkpoint_44'` | 113
`'checkpoint_45'` | 112
`'checkpoint_46'` | 112
`'checkpoint_47'` | 123
`'checkpoint_48'` | 120
`'checkpoint_49'` | 118

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):

<!-- mdformat off(HTML should not be auto-formatted) -->

{% framebox %}

<button id="displaydataframe">Display examples...</button>
<div id="dataframecontent" style="overflow-x:auto"></div>
<script>
const url = "https://storage.googleapis.com/tfds-data/visualization/dataframe/rlu_atari_checkpoints-Enduro_run_5-1.1.0.html";
const dataButton = document.getElementById('displaydataframe');
dataButton.addEventListener('click', async () => {
  // Disable the button after clicking (dataframe loaded only once).
  dataButton.disabled = true;

  const contentPane = document.getElementById('dataframecontent');
  try {
    const response = await fetch(url);
    // Error response codes don't throw an error, so force an error to show
    // the error message.
    if (!response.ok) throw Error(response.statusText);

    const data = await response.text();
    contentPane.innerHTML = data;
  } catch (e) {
    contentPane.innerHTML =
        'Error loading examples. If the error persist, please open '
        + 'a new issue.';
  }
});
</script>

{% endframebox %}

<!-- mdformat on -->

## rlu_atari_checkpoints/FishingDerby_run_1

*   **Dataset size**: `63.57 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 542
`'checkpoint_01'` | 547
`'checkpoint_02'` | 582
`'checkpoint_03'` | 610
`'checkpoint_04'` | 607
`'checkpoint_05'` | 563
`'checkpoint_06'` | 585
`'checkpoint_07'` | 575
`'checkpoint_08'` | 566
`'checkpoint_09'` | 571
`'checkpoint_10'` | 573
`'checkpoint_11'` | 599
`'checkpoint_12'` | 584
`'checkpoint_13'` | 580
`'checkpoint_14'` | 584
`'checkpoint_15'` | 577
`'checkpoint_16'` | 576
`'checkpoint_17'` | 582
`'checkpoint_18'` | 574
`'checkpoint_19'` | 577
`'checkpoint_20'` | 580
`'checkpoint_21'` | 571
`'checkpoint_22'` | 577
`'checkpoint_23'` | 568
`'checkpoint_24'` | 579
`'checkpoint_25'` | 572
`'checkpoint_26'` | 561
`'checkpoint_27'` | 570
`'checkpoint_28'` | 555
`'checkpoint_29'` | 559
`'checkpoint_30'` | 556
`'checkpoint_31'` | 552
`'checkpoint_32'` | 560
`'checkpoint_33'` | 557
`'checkpoint_34'` | 561
`'checkpoint_35'` | 562
`'checkpoint_36'` | 558
`'checkpoint_37'` | 548
`'checkpoint_38'` | 554
`'checkpoint_39'` | 564
`'checkpoint_40'` | 553
`'checkpoint_41'` | 560
`'checkpoint_42'` | 560
`'checkpoint_43'` | 558
`'checkpoint_44'` | 554
`'checkpoint_45'` | 554
`'checkpoint_46'` | 554
`'checkpoint_47'` | 545
`'checkpoint_48'` | 549
`'checkpoint_49'` | 548

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):

<!-- mdformat off(HTML should not be auto-formatted) -->

{% framebox %}

<button id="displaydataframe">Display examples...</button>
<div id="dataframecontent" style="overflow-x:auto"></div>
<script>
const url = "https://storage.googleapis.com/tfds-data/visualization/dataframe/rlu_atari_checkpoints-FishingDerby_run_1-1.1.0.html";
const dataButton = document.getElementById('displaydataframe');
dataButton.addEventListener('click', async () => {
  // Disable the button after clicking (dataframe loaded only once).
  dataButton.disabled = true;

  const contentPane = document.getElementById('dataframecontent');
  try {
    const response = await fetch(url);
    // Error response codes don't throw an error, so force an error to show
    // the error message.
    if (!response.ok) throw Error(response.statusText);

    const data = await response.text();
    contentPane.innerHTML = data;
  } catch (e) {
    contentPane.innerHTML =
        'Error loading examples. If the error persist, please open '
        + 'a new issue.';
  }
});
</script>

{% endframebox %}

<!-- mdformat on -->

## rlu_atari_checkpoints/FishingDerby_run_2

*   **Dataset size**: `63.57 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 542
`'checkpoint_01'` | 544
`'checkpoint_02'` | 577
`'checkpoint_03'` | 602
`'checkpoint_04'` | 611
`'checkpoint_05'` | 564
`'checkpoint_06'` | 554
`'checkpoint_07'` | 572
`'checkpoint_08'` | 572
`'checkpoint_09'` | 570
`'checkpoint_10'` | 576
`'checkpoint_11'` | 571
`'checkpoint_12'` | 583
`'checkpoint_13'` | 566
`'checkpoint_14'` | 569
`'checkpoint_15'` | 554
`'checkpoint_16'` | 558
`'checkpoint_17'` | 559
`'checkpoint_18'` | 564
`'checkpoint_19'` | 562
`'checkpoint_20'` | 556
`'checkpoint_21'` | 563
`'checkpoint_22'` | 567
`'checkpoint_23'` | 556
`'checkpoint_24'` | 558
`'checkpoint_25'` | 555
`'checkpoint_26'` | 555
`'checkpoint_27'` | 557
`'checkpoint_28'` | 553
`'checkpoint_29'` | 556
`'checkpoint_30'` | 560
`'checkpoint_31'` | 555
`'checkpoint_32'` | 548
`'checkpoint_33'` | 559
`'checkpoint_34'` | 555
`'checkpoint_35'` | 556
`'checkpoint_36'` | 548
`'checkpoint_37'` | 551
`'checkpoint_38'` | 552
`'checkpoint_39'` | 554
`'checkpoint_40'` | 554
`'checkpoint_41'` | 548
`'checkpoint_42'` | 551
`'checkpoint_43'` | 548
`'checkpoint_44'` | 547
`'checkpoint_45'` | 550
`'checkpoint_46'` | 542
`'checkpoint_47'` | 540
`'checkpoint_48'` | 550
`'checkpoint_49'` | 548

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):

<!-- mdformat off(HTML should not be auto-formatted) -->

{% framebox %}

<button id="displaydataframe">Display examples...</button>
<div id="dataframecontent" style="overflow-x:auto"></div>
<script>
const url = "https://storage.googleapis.com/tfds-data/visualization/dataframe/rlu_atari_checkpoints-FishingDerby_run_2-1.1.0.html";
const dataButton = document.getElementById('displaydataframe');
dataButton.addEventListener('click', async () => {
  // Disable the button after clicking (dataframe loaded only once).
  dataButton.disabled = true;

  const contentPane = document.getElementById('dataframecontent');
  try {
    const response = await fetch(url);
    // Error response codes don't throw an error, so force an error to show
    // the error message.
    if (!response.ok) throw Error(response.statusText);

    const data = await response.text();
    contentPane.innerHTML = data;
  } catch (e) {
    contentPane.innerHTML =
        'Error loading examples. If the error persist, please open '
        + 'a new issue.';
  }
});
</script>

{% endframebox %}

<!-- mdformat on -->

## rlu_atari_checkpoints/FishingDerby_run_3

*   **Dataset size**: `63.56 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 540
`'checkpoint_01'` | 538
`'checkpoint_02'` | 616
`'checkpoint_03'` | 627
`'checkpoint_04'` | 606
`'checkpoint_05'` | 601
`'checkpoint_06'` | 564
`'checkpoint_07'` | 579
`'checkpoint_08'` | 597
`'checkpoint_09'` | 583
`'checkpoint_10'` | 586
`'checkpoint_11'` | 582
`'checkpoint_12'` | 590
`'checkpoint_13'` | 587
`'checkpoint_14'` | 579
`'checkpoint_15'` | 580
`'checkpoint_16'` | 576
`'checkpoint_17'` | 574
`'checkpoint_18'` | 581
`'checkpoint_19'` | 579
`'checkpoint_20'` | 585
`'checkpoint_21'` | 585
`'checkpoint_22'` | 586
`'checkpoint_23'` | 580
`'checkpoint_24'` | 573
`'checkpoint_25'` | 577
`'checkpoint_26'` | 568
`'checkpoint_27'` | 569
`'checkpoint_28'` | 569
`'checkpoint_29'` | 563
`'checkpoint_30'` | 555
`'checkpoint_31'` | 566
`'checkpoint_32'` | 569
`'checkpoint_33'` | 566
`'checkpoint_34'` | 555
`'checkpoint_35'` | 552
`'checkpoint_36'` | 556
`'checkpoint_37'` | 561
`'checkpoint_38'` | 557
`'checkpoint_39'` | 554
`'checkpoint_40'` | 557
`'checkpoint_41'` | 552
`'checkpoint_42'` | 558
`'checkpoint_43'` | 553
`'checkpoint_44'` | 549
`'checkpoint_45'` | 549
`'checkpoint_46'` | 549
`'checkpoint_47'` | 551
`'checkpoint_48'` | 550
`'checkpoint_49'` | 554

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):

<!-- mdformat off(HTML should not be auto-formatted) -->

{% framebox %}

<button id="displaydataframe">Display examples...</button>
<div id="dataframecontent" style="overflow-x:auto"></div>
<script>
const url = "https://storage.googleapis.com/tfds-data/visualization/dataframe/rlu_atari_checkpoints-FishingDerby_run_3-1.1.0.html";
const dataButton = document.getElementById('displaydataframe');
dataButton.addEventListener('click', async () => {
  // Disable the button after clicking (dataframe loaded only once).
  dataButton.disabled = true;

  const contentPane = document.getElementById('dataframecontent');
  try {
    const response = await fetch(url);
    // Error response codes don't throw an error, so force an error to show
    // the error message.
    if (!response.ok) throw Error(response.statusText);

    const data = await response.text();
    contentPane.innerHTML = data;
  } catch (e) {
    contentPane.innerHTML =
        'Error loading examples. If the error persist, please open '
        + 'a new issue.';
  }
});
</script>

{% endframebox %}

<!-- mdformat on -->

## rlu_atari_checkpoints/FishingDerby_run_4

*   **Dataset size**: `63.59 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 543
`'checkpoint_01'` | 544
`'checkpoint_02'` | 558
`'checkpoint_03'` | 594
`'checkpoint_04'` | 618
`'checkpoint_05'` | 609
`'checkpoint_06'` | 565
`'checkpoint_07'` | 572
`'checkpoint_08'` | 571
`'checkpoint_09'` | 560
`'checkpoint_10'` | 573
`'checkpoint_11'` | 563
`'checkpoint_12'` | 560
`'checkpoint_13'` | 557
`'checkpoint_14'` | 563
`'checkpoint_15'` | 561
`'checkpoint_16'` | 554
`'checkpoint_17'` | 558
`'checkpoint_18'` | 556
`'checkpoint_19'` | 557
`'checkpoint_20'` | 555
`'checkpoint_21'` | 562
`'checkpoint_22'` | 556
`'checkpoint_23'` | 560
`'checkpoint_24'` | 561
`'checkpoint_25'` | 551
`'checkpoint_26'` | 561
`'checkpoint_27'` | 552
`'checkpoint_28'` | 548
`'checkpoint_29'` | 549
`'checkpoint_30'` | 551
`'checkpoint_31'` | 557
`'checkpoint_32'` | 557
`'checkpoint_33'` | 553
`'checkpoint_34'` | 546
`'checkpoint_35'` | 545
`'checkpoint_36'` | 557
`'checkpoint_37'` | 548
`'checkpoint_38'` | 546
`'checkpoint_39'` | 550
`'checkpoint_40'` | 544
`'checkpoint_41'` | 539
`'checkpoint_42'` | 536
`'checkpoint_43'` | 538
`'checkpoint_44'` | 534
`'checkpoint_45'` | 540
`'checkpoint_46'` | 534
`'checkpoint_47'` | 544
`'checkpoint_48'` | 541
`'checkpoint_49'` | 535

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):

<!-- mdformat off(HTML should not be auto-formatted) -->

{% framebox %}

<button id="displaydataframe">Display examples...</button>
<div id="dataframecontent" style="overflow-x:auto"></div>
<script>
const url = "https://storage.googleapis.com/tfds-data/visualization/dataframe/rlu_atari_checkpoints-FishingDerby_run_4-1.1.0.html";
const dataButton = document.getElementById('displaydataframe');
dataButton.addEventListener('click', async () => {
  // Disable the button after clicking (dataframe loaded only once).
  dataButton.disabled = true;

  const contentPane = document.getElementById('dataframecontent');
  try {
    const response = await fetch(url);
    // Error response codes don't throw an error, so force an error to show
    // the error message.
    if (!response.ok) throw Error(response.statusText);

    const data = await response.text();
    contentPane.innerHTML = data;
  } catch (e) {
    contentPane.innerHTML =
        'Error loading examples. If the error persist, please open '
        + 'a new issue.';
  }
});
</script>

{% endframebox %}

<!-- mdformat on -->

## rlu_atari_checkpoints/FishingDerby_run_5

*   **Dataset size**: `63.58 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 542
`'checkpoint_01'` | 546
`'checkpoint_02'` | 545
`'checkpoint_03'` | 571
`'checkpoint_04'` | 612
`'checkpoint_05'` | 603
`'checkpoint_06'` | 591
`'checkpoint_07'` | 565
`'checkpoint_08'` | 558
`'checkpoint_09'` | 561
`'checkpoint_10'` | 561
`'checkpoint_11'` | 569
`'checkpoint_12'` | 562
`'checkpoint_13'` | 563
`'checkpoint_14'` | 563
`'checkpoint_15'` | 558
`'checkpoint_16'` | 565
`'checkpoint_17'` | 561
`'checkpoint_18'` | 566
`'checkpoint_19'` | 559
`'checkpoint_20'` | 561
`'checkpoint_21'` | 559
`'checkpoint_22'` | 559
`'checkpoint_23'` | 558
`'checkpoint_24'` | 562
`'checkpoint_25'` | 562
`'checkpoint_26'` | 560
`'checkpoint_27'` | 555
`'checkpoint_28'` | 553
`'checkpoint_29'` | 558
`'checkpoint_30'` | 545
`'checkpoint_31'` | 557
`'checkpoint_32'` | 547
`'checkpoint_33'` | 545
`'checkpoint_34'` | 553
`'checkpoint_35'` | 547
`'checkpoint_36'` | 545
`'checkpoint_37'` | 548
`'checkpoint_38'` | 545
`'checkpoint_39'` | 545
`'checkpoint_40'` | 545
`'checkpoint_41'` | 538
`'checkpoint_42'` | 535
`'checkpoint_43'` | 543
`'checkpoint_44'` | 545
`'checkpoint_45'` | 541
`'checkpoint_46'` | 544
`'checkpoint_47'` | 550
`'checkpoint_48'` | 542
`'checkpoint_49'` | 543

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):

<!-- mdformat off(HTML should not be auto-formatted) -->

{% framebox %}

<button id="displaydataframe">Display examples...</button>
<div id="dataframecontent" style="overflow-x:auto"></div>
<script>
const url = "https://storage.googleapis.com/tfds-data/visualization/dataframe/rlu_atari_checkpoints-FishingDerby_run_5-1.1.0.html";
const dataButton = document.getElementById('displaydataframe');
dataButton.addEventListener('click', async () => {
  // Disable the button after clicking (dataframe loaded only once).
  dataButton.disabled = true;

  const contentPane = document.getElementById('dataframecontent');
  try {
    const response = await fetch(url);
    // Error response codes don't throw an error, so force an error to show
    // the error message.
    if (!response.ok) throw Error(response.statusText);

    const data = await response.text();
    contentPane.innerHTML = data;
  } catch (e) {
    contentPane.innerHTML =
        'Error loading examples. If the error persist, please open '
        + 'a new issue.';
  }
});
</script>

{% endframebox %}

<!-- mdformat on -->

## rlu_atari_checkpoints/Freeway_run_1

*   **Dataset size**: `50.94 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 488
`'checkpoint_01'` | 489
`'checkpoint_02'` | 488
`'checkpoint_03'` | 489
`'checkpoint_04'` | 488
`'checkpoint_05'` | 489
`'checkpoint_06'` | 488
`'checkpoint_07'` | 489
`'checkpoint_08'` | 489
`'checkpoint_09'` | 488
`'checkpoint_10'` | 489
`'checkpoint_11'` | 488
`'checkpoint_12'` | 489
`'checkpoint_13'` | 488
`'checkpoint_14'` | 489
`'checkpoint_15'` | 489
`'checkpoint_16'` | 488
`'checkpoint_17'` | 489
`'checkpoint_18'` | 488
`'checkpoint_19'` | 489
`'checkpoint_20'` | 488
`'checkpoint_21'` | 489
`'checkpoint_22'` | 489
`'checkpoint_23'` | 488
`'checkpoint_24'` | 489
`'checkpoint_25'` | 488
`'checkpoint_26'` | 489
`'checkpoint_27'` | 488
`'checkpoint_28'` | 489
`'checkpoint_29'` | 489
`'checkpoint_30'` | 488
`'checkpoint_31'` | 489
`'checkpoint_32'` | 488
`'checkpoint_33'` | 489
`'checkpoint_34'` | 488
`'checkpoint_35'` | 489
`'checkpoint_36'` | 488
`'checkpoint_37'` | 489
`'checkpoint_38'` | 489
`'checkpoint_39'` | 488
`'checkpoint_40'` | 489
`'checkpoint_41'` | 488
`'checkpoint_42'` | 489
`'checkpoint_43'` | 488
`'checkpoint_44'` | 489
`'checkpoint_45'` | 489
`'checkpoint_46'` | 488
`'checkpoint_47'` | 489
`'checkpoint_48'` | 488
`'checkpoint_49'` | 489

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):

<!-- mdformat off(HTML should not be auto-formatted) -->

{% framebox %}

<button id="displaydataframe">Display examples...</button>
<div id="dataframecontent" style="overflow-x:auto"></div>
<script>
const url = "https://storage.googleapis.com/tfds-data/visualization/dataframe/rlu_atari_checkpoints-Freeway_run_1-1.1.0.html";
const dataButton = document.getElementById('displaydataframe');
dataButton.addEventListener('click', async () => {
  // Disable the button after clicking (dataframe loaded only once).
  dataButton.disabled = true;

  const contentPane = document.getElementById('dataframecontent');
  try {
    const response = await fetch(url);
    // Error response codes don't throw an error, so force an error to show
    // the error message.
    if (!response.ok) throw Error(response.statusText);

    const data = await response.text();
    contentPane.innerHTML = data;
  } catch (e) {
    contentPane.innerHTML =
        'Error loading examples. If the error persist, please open '
        + 'a new issue.';
  }
});
</script>

{% endframebox %}

<!-- mdformat on -->

## rlu_atari_checkpoints/Freeway_run_2

*   **Dataset size**: `50.95 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 488
`'checkpoint_01'` | 489
`'checkpoint_02'` | 488
`'checkpoint_03'` | 489
`'checkpoint_04'` | 488
`'checkpoint_05'` | 489
`'checkpoint_06'` | 488
`'checkpoint_07'` | 489
`'checkpoint_08'` | 489
`'checkpoint_09'` | 488
`'checkpoint_10'` | 489
`'checkpoint_11'` | 488
`'checkpoint_12'` | 489
`'checkpoint_13'` | 488
`'checkpoint_14'` | 489
`'checkpoint_15'` | 489
`'checkpoint_16'` | 488
`'checkpoint_17'` | 489
`'checkpoint_18'` | 488
`'checkpoint_19'` | 489
`'checkpoint_20'` | 488
`'checkpoint_21'` | 489
`'checkpoint_22'` | 489
`'checkpoint_23'` | 488
`'checkpoint_24'` | 489
`'checkpoint_25'` | 488
`'checkpoint_26'` | 489
`'checkpoint_27'` | 488
`'checkpoint_28'` | 489
`'checkpoint_29'` | 489
`'checkpoint_30'` | 488
`'checkpoint_31'` | 489
`'checkpoint_32'` | 488
`'checkpoint_33'` | 489
`'checkpoint_34'` | 488
`'checkpoint_35'` | 489
`'checkpoint_36'` | 488
`'checkpoint_37'` | 489
`'checkpoint_38'` | 489
`'checkpoint_39'` | 488
`'checkpoint_40'` | 489
`'checkpoint_41'` | 488
`'checkpoint_42'` | 489
`'checkpoint_43'` | 488
`'checkpoint_44'` | 489
`'checkpoint_45'` | 489
`'checkpoint_46'` | 488
`'checkpoint_47'` | 489
`'checkpoint_48'` | 488
`'checkpoint_49'` | 489

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):

<!-- mdformat off(HTML should not be auto-formatted) -->

{% framebox %}

<button id="displaydataframe">Display examples...</button>
<div id="dataframecontent" style="overflow-x:auto"></div>
<script>
const url = "https://storage.googleapis.com/tfds-data/visualization/dataframe/rlu_atari_checkpoints-Freeway_run_2-1.1.0.html";
const dataButton = document.getElementById('displaydataframe');
dataButton.addEventListener('click', async () => {
  // Disable the button after clicking (dataframe loaded only once).
  dataButton.disabled = true;

  const contentPane = document.getElementById('dataframecontent');
  try {
    const response = await fetch(url);
    // Error response codes don't throw an error, so force an error to show
    // the error message.
    if (!response.ok) throw Error(response.statusText);

    const data = await response.text();
    contentPane.innerHTML = data;
  } catch (e) {
    contentPane.innerHTML =
        'Error loading examples. If the error persist, please open '
        + 'a new issue.';
  }
});
</script>

{% endframebox %}

<!-- mdformat on -->

## rlu_atari_checkpoints/Freeway_run_3

*   **Dataset size**: `50.99 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 488
`'checkpoint_01'` | 489
`'checkpoint_02'` | 488
`'checkpoint_03'` | 489
`'checkpoint_04'` | 488
`'checkpoint_05'` | 489
`'checkpoint_06'` | 488
`'checkpoint_07'` | 489
`'checkpoint_08'` | 489
`'checkpoint_09'` | 488
`'checkpoint_10'` | 489
`'checkpoint_11'` | 488
`'checkpoint_12'` | 489
`'checkpoint_13'` | 488
`'checkpoint_14'` | 489
`'checkpoint_15'` | 489
`'checkpoint_16'` | 488
`'checkpoint_17'` | 489
`'checkpoint_18'` | 488
`'checkpoint_19'` | 489
`'checkpoint_20'` | 488
`'checkpoint_21'` | 489
`'checkpoint_22'` | 489
`'checkpoint_23'` | 488
`'checkpoint_24'` | 489
`'checkpoint_25'` | 488
`'checkpoint_26'` | 489
`'checkpoint_27'` | 488
`'checkpoint_28'` | 489
`'checkpoint_29'` | 489
`'checkpoint_30'` | 488
`'checkpoint_31'` | 489
`'checkpoint_32'` | 488
`'checkpoint_33'` | 489
`'checkpoint_34'` | 488
`'checkpoint_35'` | 489
`'checkpoint_36'` | 488
`'checkpoint_37'` | 489
`'checkpoint_38'` | 489
`'checkpoint_39'` | 488
`'checkpoint_40'` | 489
`'checkpoint_41'` | 488
`'checkpoint_42'` | 489
`'checkpoint_43'` | 488
`'checkpoint_44'` | 489
`'checkpoint_45'` | 489
`'checkpoint_46'` | 488
`'checkpoint_47'` | 489
`'checkpoint_48'` | 488
`'checkpoint_49'` | 489

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):

<!-- mdformat off(HTML should not be auto-formatted) -->

{% framebox %}

<button id="displaydataframe">Display examples...</button>
<div id="dataframecontent" style="overflow-x:auto"></div>
<script>
const url = "https://storage.googleapis.com/tfds-data/visualization/dataframe/rlu_atari_checkpoints-Freeway_run_3-1.1.0.html";
const dataButton = document.getElementById('displaydataframe');
dataButton.addEventListener('click', async () => {
  // Disable the button after clicking (dataframe loaded only once).
  dataButton.disabled = true;

  const contentPane = document.getElementById('dataframecontent');
  try {
    const response = await fetch(url);
    // Error response codes don't throw an error, so force an error to show
    // the error message.
    if (!response.ok) throw Error(response.statusText);

    const data = await response.text();
    contentPane.innerHTML = data;
  } catch (e) {
    contentPane.innerHTML =
        'Error loading examples. If the error persist, please open '
        + 'a new issue.';
  }
});
</script>

{% endframebox %}

<!-- mdformat on -->

## rlu_atari_checkpoints/Freeway_run_4

*   **Dataset size**: `51.00 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 488
`'checkpoint_01'` | 489
`'checkpoint_02'` | 488
`'checkpoint_03'` | 489
`'checkpoint_04'` | 488
`'checkpoint_05'` | 489
`'checkpoint_06'` | 488
`'checkpoint_07'` | 489
`'checkpoint_08'` | 489
`'checkpoint_09'` | 488
`'checkpoint_10'` | 489
`'checkpoint_11'` | 488
`'checkpoint_12'` | 489
`'checkpoint_13'` | 488
`'checkpoint_14'` | 489
`'checkpoint_15'` | 489
`'checkpoint_16'` | 488
`'checkpoint_17'` | 489
`'checkpoint_18'` | 488
`'checkpoint_19'` | 489
`'checkpoint_20'` | 488
`'checkpoint_21'` | 489
`'checkpoint_22'` | 489
`'checkpoint_23'` | 488
`'checkpoint_24'` | 489
`'checkpoint_25'` | 488
`'checkpoint_26'` | 489
`'checkpoint_27'` | 488
`'checkpoint_28'` | 489
`'checkpoint_29'` | 489
`'checkpoint_30'` | 488
`'checkpoint_31'` | 489
`'checkpoint_32'` | 488
`'checkpoint_33'` | 489
`'checkpoint_34'` | 488
`'checkpoint_35'` | 489
`'checkpoint_36'` | 488
`'checkpoint_37'` | 489
`'checkpoint_38'` | 489
`'checkpoint_39'` | 488
`'checkpoint_40'` | 489
`'checkpoint_41'` | 488
`'checkpoint_42'` | 489
`'checkpoint_43'` | 488
`'checkpoint_44'` | 489
`'checkpoint_45'` | 489
`'checkpoint_46'` | 488
`'checkpoint_47'` | 489
`'checkpoint_48'` | 488
`'checkpoint_49'` | 489

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):

<!-- mdformat off(HTML should not be auto-formatted) -->

{% framebox %}

<button id="displaydataframe">Display examples...</button>
<div id="dataframecontent" style="overflow-x:auto"></div>
<script>
const url = "https://storage.googleapis.com/tfds-data/visualization/dataframe/rlu_atari_checkpoints-Freeway_run_4-1.1.0.html";
const dataButton = document.getElementById('displaydataframe');
dataButton.addEventListener('click', async () => {
  // Disable the button after clicking (dataframe loaded only once).
  dataButton.disabled = true;

  const contentPane = document.getElementById('dataframecontent');
  try {
    const response = await fetch(url);
    // Error response codes don't throw an error, so force an error to show
    // the error message.
    if (!response.ok) throw Error(response.statusText);

    const data = await response.text();
    contentPane.innerHTML = data;
  } catch (e) {
    contentPane.innerHTML =
        'Error loading examples. If the error persist, please open '
        + 'a new issue.';
  }
});
</script>

{% endframebox %}

<!-- mdformat on -->

## rlu_atari_checkpoints/Freeway_run_5

*   **Dataset size**: `50.54 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 488
`'checkpoint_01'` | 489
`'checkpoint_02'` | 488
`'checkpoint_03'` | 489
`'checkpoint_04'` | 488
`'checkpoint_05'` | 489
`'checkpoint_06'` | 488
`'checkpoint_07'` | 489
`'checkpoint_08'` | 489
`'checkpoint_09'` | 488
`'checkpoint_10'` | 489
`'checkpoint_11'` | 488
`'checkpoint_12'` | 489
`'checkpoint_13'` | 488
`'checkpoint_14'` | 489
`'checkpoint_15'` | 489
`'checkpoint_16'` | 488
`'checkpoint_17'` | 489
`'checkpoint_18'` | 488
`'checkpoint_19'` | 489
`'checkpoint_20'` | 488
`'checkpoint_21'` | 489
`'checkpoint_22'` | 489
`'checkpoint_23'` | 488
`'checkpoint_24'` | 489
`'checkpoint_25'` | 488
`'checkpoint_26'` | 489
`'checkpoint_27'` | 488
`'checkpoint_28'` | 489
`'checkpoint_29'` | 489
`'checkpoint_30'` | 488
`'checkpoint_31'` | 489
`'checkpoint_32'` | 488
`'checkpoint_33'` | 489
`'checkpoint_34'` | 488
`'checkpoint_35'` | 489
`'checkpoint_36'` | 488
`'checkpoint_37'` | 489
`'checkpoint_38'` | 489
`'checkpoint_39'` | 488
`'checkpoint_40'` | 489
`'checkpoint_41'` | 488
`'checkpoint_42'` | 489
`'checkpoint_43'` | 488
`'checkpoint_44'` | 489
`'checkpoint_45'` | 489
`'checkpoint_46'` | 488
`'checkpoint_47'` | 489
`'checkpoint_48'` | 488
`'checkpoint_49'` | 489

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):

<!-- mdformat off(HTML should not be auto-formatted) -->

{% framebox %}

<button id="displaydataframe">Display examples...</button>
<div id="dataframecontent" style="overflow-x:auto"></div>
<script>
const url = "https://storage.googleapis.com/tfds-data/visualization/dataframe/rlu_atari_checkpoints-Freeway_run_5-1.1.0.html";
const dataButton = document.getElementById('displaydataframe');
dataButton.addEventListener('click', async () => {
  // Disable the button after clicking (dataframe loaded only once).
  dataButton.disabled = true;

  const contentPane = document.getElementById('dataframecontent');
  try {
    const response = await fetch(url);
    // Error response codes don't throw an error, so force an error to show
    // the error message.
    if (!response.ok) throw Error(response.statusText);

    const data = await response.text();
    contentPane.innerHTML = data;
  } catch (e) {
    contentPane.innerHTML =
        'Error loading examples. If the error persist, please open '
        + 'a new issue.';
  }
});
</script>

{% endframebox %}

<!-- mdformat on -->

## rlu_atari_checkpoints/Frostbite_run_1

*   **Dataset size**: `57.03 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 1,971
`'checkpoint_01'` | 1,936
`'checkpoint_02'` | 1,771
`'checkpoint_03'` | 1,577
`'checkpoint_04'` | 1,488
`'checkpoint_05'` | 1,488
`'checkpoint_06'` | 1,444
`'checkpoint_07'` | 1,407
`'checkpoint_08'` | 1,409
`'checkpoint_09'` | 1,482
`'checkpoint_10'` | 1,317
`'checkpoint_11'` | 2,016
`'checkpoint_12'` | 1,965
`'checkpoint_13'` | 1,673
`'checkpoint_14'` | 1,353
`'checkpoint_15'` | 1,331
`'checkpoint_16'` | 1,237
`'checkpoint_17'` | 1,225
`'checkpoint_18'` | 1,181
`'checkpoint_19'` | 1,209
`'checkpoint_20'` | 1,251
`'checkpoint_21'` | 1,252
`'checkpoint_22'` | 1,139
`'checkpoint_23'` | 1,112
`'checkpoint_24'` | 1,055
`'checkpoint_25'` | 1,009
`'checkpoint_26'` | 954
`'checkpoint_27'` | 987
`'checkpoint_28'` | 975
`'checkpoint_29'` | 994
`'checkpoint_30'` | 1,116
`'checkpoint_31'` | 1,186
`'checkpoint_32'` | 1,241
`'checkpoint_33'` | 1,257
`'checkpoint_34'` | 1,300
`'checkpoint_35'` | 1,489
`'checkpoint_36'` | 1,578
`'checkpoint_37'` | 1,741
`'checkpoint_38'` | 1,304
`'checkpoint_39'` | 1,234
`'checkpoint_40'` | 1,189
`'checkpoint_41'` | 1,354
`'checkpoint_42'` | 1,710
`'checkpoint_43'` | 1,112
`'checkpoint_44'` | 1,100
`'checkpoint_45'` | 1,049
`'checkpoint_46'` | 933
`'checkpoint_47'` | 1,100
`'checkpoint_48'` | 1,571
`'checkpoint_49'` | 1,319

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):

<!-- mdformat off(HTML should not be auto-formatted) -->

{% framebox %}

<button id="displaydataframe">Display examples...</button>
<div id="dataframecontent" style="overflow-x:auto"></div>
<script>
const url = "https://storage.googleapis.com/tfds-data/visualization/dataframe/rlu_atari_checkpoints-Frostbite_run_1-1.1.0.html";
const dataButton = document.getElementById('displaydataframe');
dataButton.addEventListener('click', async () => {
  // Disable the button after clicking (dataframe loaded only once).
  dataButton.disabled = true;

  const contentPane = document.getElementById('dataframecontent');
  try {
    const response = await fetch(url);
    // Error response codes don't throw an error, so force an error to show
    // the error message.
    if (!response.ok) throw Error(response.statusText);

    const data = await response.text();
    contentPane.innerHTML = data;
  } catch (e) {
    contentPane.innerHTML =
        'Error loading examples. If the error persist, please open '
        + 'a new issue.';
  }
});
</script>

{% endframebox %}

<!-- mdformat on -->

## rlu_atari_checkpoints/Frostbite_run_2

*   **Dataset size**: `56.26 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 1,969
`'checkpoint_01'` | 1,659
`'checkpoint_02'` | 1,570
`'checkpoint_03'` | 1,497
`'checkpoint_04'` | 833
`'checkpoint_05'` | 1,052
`'checkpoint_06'` | 1,260
`'checkpoint_07'` | 1,455
`'checkpoint_08'` | 1,392
`'checkpoint_09'` | 1,372
`'checkpoint_10'` | 1,300
`'checkpoint_11'` | 1,371
`'checkpoint_12'` | 1,267
`'checkpoint_13'` | 1,341
`'checkpoint_14'` | 1,226
`'checkpoint_15'` | 1,295
`'checkpoint_16'` | 1,386
`'checkpoint_17'` | 1,520
`'checkpoint_18'` | 1,474
`'checkpoint_19'` | 1,238
`'checkpoint_20'` | 1,196
`'checkpoint_21'` | 1,143
`'checkpoint_22'` | 1,290
`'checkpoint_23'` | 1,317
`'checkpoint_24'` | 1,350
`'checkpoint_25'` | 1,581
`'checkpoint_26'` | 1,498
`'checkpoint_27'` | 1,328
`'checkpoint_28'` | 1,374
`'checkpoint_29'` | 1,470
`'checkpoint_30'` | 1,892
`'checkpoint_31'` | 1,612
`'checkpoint_32'` | 1,103
`'checkpoint_33'` | 1,199
`'checkpoint_34'` | 1,162
`'checkpoint_35'` | 1,288
`'checkpoint_36'` | 1,235
`'checkpoint_37'` | 1,147
`'checkpoint_38'` | 1,212
`'checkpoint_39'` | 1,072
`'checkpoint_40'` | 1,187
`'checkpoint_41'` | 1,300
`'checkpoint_42'` | 1,605
`'checkpoint_43'` | 1,596
`'checkpoint_44'` | 1,684
`'checkpoint_45'` | 1,530
`'checkpoint_46'` | 1,428
`'checkpoint_47'` | 1,481
`'checkpoint_48'` | 1,574
`'checkpoint_49'` | 1,834

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):

<!-- mdformat off(HTML should not be auto-formatted) -->

{% framebox %}

<button id="displaydataframe">Display examples...</button>
<div id="dataframecontent" style="overflow-x:auto"></div>
<script>
const url = "https://storage.googleapis.com/tfds-data/visualization/dataframe/rlu_atari_checkpoints-Frostbite_run_2-1.1.0.html";
const dataButton = document.getElementById('displaydataframe');
dataButton.addEventListener('click', async () => {
  // Disable the button after clicking (dataframe loaded only once).
  dataButton.disabled = true;

  const contentPane = document.getElementById('dataframecontent');
  try {
    const response = await fetch(url);
    // Error response codes don't throw an error, so force an error to show
    // the error message.
    if (!response.ok) throw Error(response.statusText);

    const data = await response.text();
    contentPane.innerHTML = data;
  } catch (e) {
    contentPane.innerHTML =
        'Error loading examples. If the error persist, please open '
        + 'a new issue.';
  }
});
</script>

{% endframebox %}

<!-- mdformat on -->

## rlu_atari_checkpoints/Frostbite_run_3

*   **Dataset size**: `56.57 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 1,952
`'checkpoint_01'` | 1,702
`'checkpoint_02'` | 1,513
`'checkpoint_03'` | 911
`'checkpoint_04'` | 930
`'checkpoint_05'` | 1,089
`'checkpoint_06'` | 882
`'checkpoint_07'` | 1,400
`'checkpoint_08'` | 1,450
`'checkpoint_09'` | 1,564
`'checkpoint_10'` | 1,126
`'checkpoint_11'` | 1,056
`'checkpoint_12'` | 957
`'checkpoint_13'` | 1,390
`'checkpoint_14'` | 1,383
`'checkpoint_15'` | 1,442
`'checkpoint_16'` | 1,445
`'checkpoint_17'` | 1,494
`'checkpoint_18'` | 1,507
`'checkpoint_19'` | 1,459
`'checkpoint_20'` | 1,487
`'checkpoint_21'` | 1,472
`'checkpoint_22'` | 1,400
`'checkpoint_23'` | 1,322
`'checkpoint_24'` | 1,431
`'checkpoint_25'` | 1,419
`'checkpoint_26'` | 1,298
`'checkpoint_27'` | 1,346
`'checkpoint_28'` | 1,412
`'checkpoint_29'` | 1,387
`'checkpoint_30'` | 1,295
`'checkpoint_31'` | 1,328
`'checkpoint_32'` | 1,282
`'checkpoint_33'` | 1,342
`'checkpoint_34'` | 1,231
`'checkpoint_35'` | 1,295
`'checkpoint_36'` | 1,265
`'checkpoint_37'` | 1,338
`'checkpoint_38'` | 1,192
`'checkpoint_39'` | 1,201
`'checkpoint_40'` | 1,115
`'checkpoint_41'` | 1,146
`'checkpoint_42'` | 1,134
`'checkpoint_43'` | 992
`'checkpoint_44'` | 1,376
`'checkpoint_45'` | 1,218
`'checkpoint_46'` | 1,291
`'checkpoint_47'` | 1,308
`'checkpoint_48'` | 1,339
`'checkpoint_49'` | 1,379

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):

<!-- mdformat off(HTML should not be auto-formatted) -->

{% framebox %}

<button id="displaydataframe">Display examples...</button>
<div id="dataframecontent" style="overflow-x:auto"></div>
<script>
const url = "https://storage.googleapis.com/tfds-data/visualization/dataframe/rlu_atari_checkpoints-Frostbite_run_3-1.1.0.html";
const dataButton = document.getElementById('displaydataframe');
dataButton.addEventListener('click', async () => {
  // Disable the button after clicking (dataframe loaded only once).
  dataButton.disabled = true;

  const contentPane = document.getElementById('dataframecontent');
  try {
    const response = await fetch(url);
    // Error response codes don't throw an error, so force an error to show
    // the error message.
    if (!response.ok) throw Error(response.statusText);

    const data = await response.text();
    contentPane.innerHTML = data;
  } catch (e) {
    contentPane.innerHTML =
        'Error loading examples. If the error persist, please open '
        + 'a new issue.';
  }
});
</script>

{% endframebox %}

<!-- mdformat on -->

## rlu_atari_checkpoints/Frostbite_run_4

*   **Dataset size**: `56.79 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 1,981
`'checkpoint_01'` | 1,663
`'checkpoint_02'` | 1,424
`'checkpoint_03'` | 1,417
`'checkpoint_04'` | 1,399
`'checkpoint_05'` | 1,367
`'checkpoint_06'` | 1,258
`'checkpoint_07'` | 1,219
`'checkpoint_08'` | 1,397
`'checkpoint_09'` | 1,465
`'checkpoint_10'` | 1,382
`'checkpoint_11'` | 1,281
`'checkpoint_12'` | 1,147
`'checkpoint_13'` | 1,151
`'checkpoint_14'` | 1,112
`'checkpoint_15'` | 1,048
`'checkpoint_16'` | 1,153
`'checkpoint_17'` | 1,145
`'checkpoint_18'` | 1,145
`'checkpoint_19'` | 1,168
`'checkpoint_20'` | 1,107
`'checkpoint_21'` | 1,162
`'checkpoint_22'` | 1,107
`'checkpoint_23'` | 1,188
`'checkpoint_24'` | 1,287
`'checkpoint_25'` | 1,240
`'checkpoint_26'` | 1,532
`'checkpoint_27'` | 1,086
`'checkpoint_28'` | 1,098
`'checkpoint_29'` | 1,069
`'checkpoint_30'` | 1,000
`'checkpoint_31'` | 1,774
`'checkpoint_32'` | 1,663
`'checkpoint_33'` | 1,144
`'checkpoint_34'` | 1,195
`'checkpoint_35'` | 958
`'checkpoint_36'` | 934
`'checkpoint_37'` | 948
`'checkpoint_38'` | 929
`'checkpoint_39'` | 1,280
`'checkpoint_40'` | 1,785
`'checkpoint_41'` | 1,617
`'checkpoint_42'` | 1,483
`'checkpoint_43'` | 1,565
`'checkpoint_44'` | 990
`'checkpoint_45'` | 1,464
`'checkpoint_46'` | 1,645
`'checkpoint_47'` | 1,561
`'checkpoint_48'` | 2,153
`'checkpoint_49'` | 1,864

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):

<!-- mdformat off(HTML should not be auto-formatted) -->

{% framebox %}

<button id="displaydataframe">Display examples...</button>
<div id="dataframecontent" style="overflow-x:auto"></div>
<script>
const url = "https://storage.googleapis.com/tfds-data/visualization/dataframe/rlu_atari_checkpoints-Frostbite_run_4-1.1.0.html";
const dataButton = document.getElementById('displaydataframe');
dataButton.addEventListener('click', async () => {
  // Disable the button after clicking (dataframe loaded only once).
  dataButton.disabled = true;

  const contentPane = document.getElementById('dataframecontent');
  try {
    const response = await fetch(url);
    // Error response codes don't throw an error, so force an error to show
    // the error message.
    if (!response.ok) throw Error(response.statusText);

    const data = await response.text();
    contentPane.innerHTML = data;
  } catch (e) {
    contentPane.innerHTML =
        'Error loading examples. If the error persist, please open '
        + 'a new issue.';
  }
});
</script>

{% endframebox %}

<!-- mdformat on -->

## rlu_atari_checkpoints/Frostbite_run_5

*   **Dataset size**: `56.58 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 1,944
`'checkpoint_01'` | 1,875
`'checkpoint_02'` | 1,498
`'checkpoint_03'` | 1,180
`'checkpoint_04'` | 1,518
`'checkpoint_05'` | 1,355
`'checkpoint_06'` | 1,275
`'checkpoint_07'` | 1,464
`'checkpoint_08'` | 1,321
`'checkpoint_09'` | 1,332
`'checkpoint_10'` | 1,333
`'checkpoint_11'` | 1,284
`'checkpoint_12'` | 1,329
`'checkpoint_13'` | 1,356
`'checkpoint_14'` | 1,266
`'checkpoint_15'` | 1,225
`'checkpoint_16'` | 1,236
`'checkpoint_17'` | 1,172
`'checkpoint_18'` | 1,098
`'checkpoint_19'` | 1,211
`'checkpoint_20'` | 1,193
`'checkpoint_21'` | 1,192
`'checkpoint_22'` | 1,205
`'checkpoint_23'` | 1,130
`'checkpoint_24'` | 1,155
`'checkpoint_25'` | 1,237
`'checkpoint_26'` | 1,196
`'checkpoint_27'` | 1,239
`'checkpoint_28'` | 1,134
`'checkpoint_29'` | 1,179
`'checkpoint_30'` | 1,217
`'checkpoint_31'` | 1,149
`'checkpoint_32'` | 1,322
`'checkpoint_33'` | 1,189
`'checkpoint_34'` | 1,231
`'checkpoint_35'` | 1,229
`'checkpoint_36'` | 1,235
`'checkpoint_37'` | 1,234
`'checkpoint_38'` | 1,250
`'checkpoint_39'` | 1,250
`'checkpoint_40'` | 1,379
`'checkpoint_41'` | 1,369
`'checkpoint_42'` | 1,460
`'checkpoint_43'` | 1,283
`'checkpoint_44'` | 1,285
`'checkpoint_45'` | 1,320
`'checkpoint_46'` | 1,417
`'checkpoint_47'` | 1,516
`'checkpoint_48'` | 1,368
`'checkpoint_49'` | 1,393

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):

<!-- mdformat off(HTML should not be auto-formatted) -->

{% framebox %}

<button id="displaydataframe">Display examples...</button>
<div id="dataframecontent" style="overflow-x:auto"></div>
<script>
const url = "https://storage.googleapis.com/tfds-data/visualization/dataframe/rlu_atari_checkpoints-Frostbite_run_5-1.1.0.html";
const dataButton = document.getElementById('displaydataframe');
dataButton.addEventListener('click', async () => {
  // Disable the button after clicking (dataframe loaded only once).
  dataButton.disabled = true;

  const contentPane = document.getElementById('dataframecontent');
  try {
    const response = await fetch(url);
    // Error response codes don't throw an error, so force an error to show
    // the error message.
    if (!response.ok) throw Error(response.statusText);

    const data = await response.text();
    contentPane.innerHTML = data;
  } catch (e) {
    contentPane.innerHTML =
        'Error loading examples. If the error persist, please open '
        + 'a new issue.';
  }
});
</script>

{% endframebox %}

<!-- mdformat on -->

## rlu_atari_checkpoints/Gopher_run_1

*   **Dataset size**: `36.31 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 1,003
`'checkpoint_01'` | 847
`'checkpoint_02'` | 725
`'checkpoint_03'` | 654
`'checkpoint_04'` | 649
`'checkpoint_05'` | 613
`'checkpoint_06'` | 627
`'checkpoint_07'` | 633
`'checkpoint_08'` | 621
`'checkpoint_09'` | 600
`'checkpoint_10'` | 569
`'checkpoint_11'` | 539
`'checkpoint_12'` | 529
`'checkpoint_13'` | 491
`'checkpoint_14'` | 469
`'checkpoint_15'` | 440
`'checkpoint_16'` | 431
`'checkpoint_17'` | 420
`'checkpoint_18'` | 410
`'checkpoint_19'` | 423
`'checkpoint_20'` | 422
`'checkpoint_21'` | 411
`'checkpoint_22'` | 391
`'checkpoint_23'` | 417
`'checkpoint_24'` | 412
`'checkpoint_25'` | 413
`'checkpoint_26'` | 392
`'checkpoint_27'` | 418
`'checkpoint_28'` | 410
`'checkpoint_29'` | 413
`'checkpoint_30'` | 414
`'checkpoint_31'` | 415
`'checkpoint_32'` | 421
`'checkpoint_33'` | 441
`'checkpoint_34'` | 404
`'checkpoint_35'` | 409
`'checkpoint_36'` | 418
`'checkpoint_37'` | 419
`'checkpoint_38'` | 409
`'checkpoint_39'` | 429
`'checkpoint_40'` | 420
`'checkpoint_41'` | 416
`'checkpoint_42'` | 434
`'checkpoint_43'` | 438
`'checkpoint_44'` | 441
`'checkpoint_45'` | 432
`'checkpoint_46'` | 432
`'checkpoint_47'` | 431
`'checkpoint_48'` | 430
`'checkpoint_49'` | 427

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):
    Only shown for the first 100 configs.

## rlu_atari_checkpoints/Gopher_run_2

*   **Dataset size**: `36.35 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 1,024
`'checkpoint_01'` | 872
`'checkpoint_02'` | 725
`'checkpoint_03'` | 672
`'checkpoint_04'` | 640
`'checkpoint_05'` | 622
`'checkpoint_06'` | 609
`'checkpoint_07'` | 598
`'checkpoint_08'` | 575
`'checkpoint_09'` | 542
`'checkpoint_10'` | 540
`'checkpoint_11'` | 509
`'checkpoint_12'` | 458
`'checkpoint_13'` | 456
`'checkpoint_14'` | 461
`'checkpoint_15'` | 428
`'checkpoint_16'` | 417
`'checkpoint_17'` | 409
`'checkpoint_18'` | 414
`'checkpoint_19'` | 421
`'checkpoint_20'` | 436
`'checkpoint_21'` | 413
`'checkpoint_22'` | 405
`'checkpoint_23'` | 408
`'checkpoint_24'` | 417
`'checkpoint_25'` | 419
`'checkpoint_26'` | 401
`'checkpoint_27'` | 405
`'checkpoint_28'` | 408
`'checkpoint_29'` | 414
`'checkpoint_30'` | 385
`'checkpoint_31'` | 417
`'checkpoint_32'` | 406
`'checkpoint_33'` | 399
`'checkpoint_34'` | 400
`'checkpoint_35'` | 386
`'checkpoint_36'` | 404
`'checkpoint_37'` | 390
`'checkpoint_38'` | 374
`'checkpoint_39'` | 408
`'checkpoint_40'` | 395
`'checkpoint_41'` | 399
`'checkpoint_42'` | 392
`'checkpoint_43'` | 399
`'checkpoint_44'` | 427
`'checkpoint_45'` | 432
`'checkpoint_46'` | 423
`'checkpoint_47'` | 411
`'checkpoint_48'` | 400
`'checkpoint_49'` | 426

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):
    Only shown for the first 100 configs.

## rlu_atari_checkpoints/Gopher_run_3

*   **Dataset size**: `36.33 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 973
`'checkpoint_01'` | 840
`'checkpoint_02'` | 691
`'checkpoint_03'` | 682
`'checkpoint_04'` | 656
`'checkpoint_05'` | 646
`'checkpoint_06'` | 625
`'checkpoint_07'` | 624
`'checkpoint_08'` | 618
`'checkpoint_09'` | 600
`'checkpoint_10'` | 548
`'checkpoint_11'` | 514
`'checkpoint_12'` | 477
`'checkpoint_13'` | 470
`'checkpoint_14'` | 436
`'checkpoint_15'` | 441
`'checkpoint_16'` | 417
`'checkpoint_17'` | 427
`'checkpoint_18'` | 433
`'checkpoint_19'` | 426
`'checkpoint_20'` | 423
`'checkpoint_21'` | 431
`'checkpoint_22'` | 411
`'checkpoint_23'` | 428
`'checkpoint_24'` | 384
`'checkpoint_25'` | 419
`'checkpoint_26'` | 409
`'checkpoint_27'` | 407
`'checkpoint_28'` | 429
`'checkpoint_29'` | 427
`'checkpoint_30'` | 414
`'checkpoint_31'` | 422
`'checkpoint_32'` | 437
`'checkpoint_33'` | 408
`'checkpoint_34'` | 418
`'checkpoint_35'` | 427
`'checkpoint_36'` | 430
`'checkpoint_37'` | 429
`'checkpoint_38'` | 439
`'checkpoint_39'` | 440
`'checkpoint_40'` | 436
`'checkpoint_41'` | 423
`'checkpoint_42'` | 423
`'checkpoint_43'` | 413
`'checkpoint_44'` | 418
`'checkpoint_45'` | 418
`'checkpoint_46'` | 422
`'checkpoint_47'` | 425
`'checkpoint_48'` | 443
`'checkpoint_49'` | 441

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):
    Only shown for the first 100 configs.

## rlu_atari_checkpoints/Gopher_run_4

*   **Dataset size**: `36.33 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 958
`'checkpoint_01'` | 816
`'checkpoint_02'` | 724
`'checkpoint_03'` | 694
`'checkpoint_04'` | 669
`'checkpoint_05'` | 649
`'checkpoint_06'` | 626
`'checkpoint_07'` | 605
`'checkpoint_08'` | 593
`'checkpoint_09'` | 554
`'checkpoint_10'` | 529
`'checkpoint_11'` | 489
`'checkpoint_12'` | 458
`'checkpoint_13'` | 420
`'checkpoint_14'` | 429
`'checkpoint_15'` | 443
`'checkpoint_16'` | 422
`'checkpoint_17'` | 410
`'checkpoint_18'` | 408
`'checkpoint_19'` | 396
`'checkpoint_20'` | 398
`'checkpoint_21'` | 389
`'checkpoint_22'` | 406
`'checkpoint_23'` | 400
`'checkpoint_24'` | 396
`'checkpoint_25'` | 400
`'checkpoint_26'` | 416
`'checkpoint_27'` | 399
`'checkpoint_28'` | 391
`'checkpoint_29'` | 392
`'checkpoint_30'` | 387
`'checkpoint_31'` | 412
`'checkpoint_32'` | 400
`'checkpoint_33'` | 389
`'checkpoint_34'` | 391
`'checkpoint_35'` | 391
`'checkpoint_36'` | 395
`'checkpoint_37'` | 404
`'checkpoint_38'` | 419
`'checkpoint_39'` | 418
`'checkpoint_40'` | 395
`'checkpoint_41'` | 414
`'checkpoint_42'` | 395
`'checkpoint_43'` | 404
`'checkpoint_44'` | 415
`'checkpoint_45'` | 411
`'checkpoint_46'` | 420
`'checkpoint_47'` | 423
`'checkpoint_48'` | 421
`'checkpoint_49'` | 432

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):
    Only shown for the first 100 configs.

## rlu_atari_checkpoints/Gopher_run_5

*   **Dataset size**: `36.32 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 981
`'checkpoint_01'` | 838
`'checkpoint_02'` | 718
`'checkpoint_03'` | 686
`'checkpoint_04'` | 657
`'checkpoint_05'` | 651
`'checkpoint_06'` | 642
`'checkpoint_07'` | 632
`'checkpoint_08'` | 605
`'checkpoint_09'` | 588
`'checkpoint_10'` | 572
`'checkpoint_11'` | 563
`'checkpoint_12'` | 541
`'checkpoint_13'` | 517
`'checkpoint_14'` | 485
`'checkpoint_15'` | 480
`'checkpoint_16'` | 444
`'checkpoint_17'` | 460
`'checkpoint_18'` | 442
`'checkpoint_19'` | 426
`'checkpoint_20'` | 437
`'checkpoint_21'` | 413
`'checkpoint_22'` | 434
`'checkpoint_23'` | 400
`'checkpoint_24'` | 403
`'checkpoint_25'` | 409
`'checkpoint_26'` | 406
`'checkpoint_27'` | 403
`'checkpoint_28'` | 397
`'checkpoint_29'` | 419
`'checkpoint_30'` | 394
`'checkpoint_31'` | 396
`'checkpoint_32'` | 410
`'checkpoint_33'` | 395
`'checkpoint_34'` | 429
`'checkpoint_35'` | 395
`'checkpoint_36'` | 405
`'checkpoint_37'` | 397
`'checkpoint_38'` | 395
`'checkpoint_39'` | 402
`'checkpoint_40'` | 410
`'checkpoint_41'` | 366
`'checkpoint_42'` | 406
`'checkpoint_43'` | 421
`'checkpoint_44'` | 414
`'checkpoint_45'` | 402
`'checkpoint_46'` | 437
`'checkpoint_47'` | 395
`'checkpoint_48'` | 402
`'checkpoint_49'` | 416

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):
    Only shown for the first 100 configs.

## rlu_atari_checkpoints/Gravitar_run_1

*   **Dataset size**: `33.91 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 1,772
`'checkpoint_01'` | 1,625
`'checkpoint_02'` | 1,579
`'checkpoint_03'` | 1,500
`'checkpoint_04'` | 1,462
`'checkpoint_05'` | 1,502
`'checkpoint_06'` | 1,537
`'checkpoint_07'` | 1,549
`'checkpoint_08'` | 1,553
`'checkpoint_09'` | 1,532
`'checkpoint_10'` | 1,550
`'checkpoint_11'` | 1,532
`'checkpoint_12'` | 1,528
`'checkpoint_13'` | 1,525
`'checkpoint_14'` | 1,522
`'checkpoint_15'` | 1,532
`'checkpoint_16'` | 1,563
`'checkpoint_17'` | 1,573
`'checkpoint_18'` | 1,568
`'checkpoint_19'` | 1,543
`'checkpoint_20'` | 1,585
`'checkpoint_21'` | 1,544
`'checkpoint_22'` | 1,540
`'checkpoint_23'` | 1,525
`'checkpoint_24'` | 1,526
`'checkpoint_25'` | 1,503
`'checkpoint_26'` | 1,498
`'checkpoint_27'` | 1,503
`'checkpoint_28'` | 1,515
`'checkpoint_29'` | 1,539
`'checkpoint_30'` | 1,512
`'checkpoint_31'` | 1,527
`'checkpoint_32'` | 1,540
`'checkpoint_33'` | 1,514
`'checkpoint_34'` | 1,509
`'checkpoint_35'` | 1,524
`'checkpoint_36'` | 1,514
`'checkpoint_37'` | 1,529
`'checkpoint_38'` | 1,520
`'checkpoint_39'` | 1,505
`'checkpoint_40'` | 1,543
`'checkpoint_41'` | 1,551
`'checkpoint_42'` | 1,532
`'checkpoint_43'` | 1,527
`'checkpoint_44'` | 1,522
`'checkpoint_45'` | 1,556
`'checkpoint_46'` | 1,538
`'checkpoint_47'` | 1,561
`'checkpoint_48'` | 1,544

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):
    Only shown for the first 100 configs.

## rlu_atari_checkpoints/Gravitar_run_2

*   **Dataset size**: `33.67 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 1,723
`'checkpoint_01'` | 1,606
`'checkpoint_02'` | 1,543
`'checkpoint_03'` | 1,520
`'checkpoint_04'` | 1,470
`'checkpoint_05'` | 1,477
`'checkpoint_06'` | 1,508
`'checkpoint_07'` | 1,529
`'checkpoint_08'` | 1,559
`'checkpoint_09'` | 1,554
`'checkpoint_10'` | 1,512
`'checkpoint_11'` | 1,517
`'checkpoint_12'` | 1,544
`'checkpoint_13'` | 1,510
`'checkpoint_14'` | 1,558
`'checkpoint_15'` | 1,512
`'checkpoint_16'` | 1,532
`'checkpoint_17'` | 1,538
`'checkpoint_18'` | 1,563
`'checkpoint_19'` | 1,529
`'checkpoint_20'` | 1,516
`'checkpoint_21'` | 1,511
`'checkpoint_22'` | 1,503
`'checkpoint_23'` | 1,506
`'checkpoint_24'` | 1,510
`'checkpoint_25'` | 1,515
`'checkpoint_26'` | 1,516
`'checkpoint_27'` | 1,512
`'checkpoint_28'` | 1,556
`'checkpoint_29'` | 1,530
`'checkpoint_30'` | 1,535
`'checkpoint_31'` | 1,534
`'checkpoint_32'` | 1,532
`'checkpoint_33'` | 1,504
`'checkpoint_34'` | 1,507
`'checkpoint_35'` | 1,530
`'checkpoint_36'` | 1,516
`'checkpoint_37'` | 1,508
`'checkpoint_38'` | 1,520
`'checkpoint_39'` | 1,502
`'checkpoint_40'` | 1,520
`'checkpoint_41'` | 1,489
`'checkpoint_42'` | 1,522
`'checkpoint_43'` | 1,509
`'checkpoint_44'` | 1,508
`'checkpoint_45'` | 1,495
`'checkpoint_46'` | 1,495
`'checkpoint_47'` | 1,506
`'checkpoint_48'` | 1,508

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):
    Only shown for the first 100 configs.

## rlu_atari_checkpoints/Gravitar_run_3

*   **Dataset size**: `33.11 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 1,734
`'checkpoint_01'` | 1,625
`'checkpoint_02'` | 1,569
`'checkpoint_03'` | 1,491
`'checkpoint_04'` | 1,447
`'checkpoint_05'` | 1,515
`'checkpoint_06'` | 1,521
`'checkpoint_07'` | 1,512
`'checkpoint_08'` | 1,540
`'checkpoint_09'` | 1,509
`'checkpoint_10'` | 1,513
`'checkpoint_11'` | 1,523
`'checkpoint_12'` | 1,519
`'checkpoint_13'` | 1,498
`'checkpoint_14'` | 1,512
`'checkpoint_15'` | 1,506
`'checkpoint_16'` | 1,482
`'checkpoint_17'` | 1,485
`'checkpoint_18'` | 1,508
`'checkpoint_19'` | 1,517
`'checkpoint_20'` | 1,514
`'checkpoint_21'` | 1,486
`'checkpoint_22'` | 1,482
`'checkpoint_23'` | 1,515
`'checkpoint_24'` | 1,513
`'checkpoint_25'` | 1,503
`'checkpoint_26'` | 1,509
`'checkpoint_27'` | 1,500
`'checkpoint_28'` | 1,499
`'checkpoint_29'` | 1,500
`'checkpoint_30'` | 1,512
`'checkpoint_31'` | 1,474
`'checkpoint_32'` | 1,485
`'checkpoint_33'` | 1,485
`'checkpoint_34'` | 1,473
`'checkpoint_35'` | 1,512
`'checkpoint_36'` | 1,507
`'checkpoint_37'` | 1,523
`'checkpoint_38'` | 1,555
`'checkpoint_39'` | 1,509
`'checkpoint_40'` | 1,515
`'checkpoint_41'` | 1,521
`'checkpoint_42'` | 1,514
`'checkpoint_43'` | 1,504
`'checkpoint_44'` | 1,514
`'checkpoint_45'` | 1,533
`'checkpoint_46'` | 1,526
`'checkpoint_47'` | 1,545
`'checkpoint_48'` | 1,508

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):
    Only shown for the first 100 configs.

## rlu_atari_checkpoints/Gravitar_run_4

*   **Dataset size**: `33.16 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 1,716
`'checkpoint_01'` | 1,614
`'checkpoint_02'` | 1,538
`'checkpoint_03'` | 1,461
`'checkpoint_04'` | 1,477
`'checkpoint_05'` | 1,503
`'checkpoint_06'` | 1,548
`'checkpoint_07'` | 1,563
`'checkpoint_08'` | 1,530
`'checkpoint_09'` | 1,546
`'checkpoint_10'` | 1,525
`'checkpoint_11'` | 1,523
`'checkpoint_12'` | 1,515
`'checkpoint_13'` | 1,516
`'checkpoint_14'` | 1,512
`'checkpoint_15'` | 1,536
`'checkpoint_16'` | 1,514
`'checkpoint_17'` | 1,542
`'checkpoint_18'` | 1,511
`'checkpoint_19'` | 1,507
`'checkpoint_20'` | 1,513
`'checkpoint_21'` | 1,550
`'checkpoint_22'` | 1,501
`'checkpoint_23'` | 1,499
`'checkpoint_24'` | 1,514
`'checkpoint_25'` | 1,503
`'checkpoint_26'` | 1,513
`'checkpoint_27'` | 1,527
`'checkpoint_28'` | 1,507
`'checkpoint_29'` | 1,514
`'checkpoint_30'` | 1,514
`'checkpoint_31'` | 1,494
`'checkpoint_32'` | 1,504
`'checkpoint_33'` | 1,488
`'checkpoint_34'` | 1,520
`'checkpoint_35'` | 1,515
`'checkpoint_36'` | 1,522
`'checkpoint_37'` | 1,522
`'checkpoint_38'` | 1,513
`'checkpoint_39'` | 1,528
`'checkpoint_40'` | 1,547
`'checkpoint_41'` | 1,527
`'checkpoint_42'` | 1,526
`'checkpoint_43'` | 1,530
`'checkpoint_44'` | 1,569
`'checkpoint_45'` | 1,542
`'checkpoint_46'` | 1,537
`'checkpoint_47'` | 1,511
`'checkpoint_48'` | 1,519

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):
    Only shown for the first 100 configs.

## rlu_atari_checkpoints/Gravitar_run_5

*   **Dataset size**: `33.48 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 1,722
`'checkpoint_01'` | 1,589
`'checkpoint_02'` | 1,532
`'checkpoint_03'` | 1,469
`'checkpoint_04'` | 1,481
`'checkpoint_05'` | 1,470
`'checkpoint_06'` | 1,486
`'checkpoint_07'` | 1,506
`'checkpoint_08'` | 1,518
`'checkpoint_09'` | 1,546
`'checkpoint_10'` | 1,506
`'checkpoint_11'` | 1,543
`'checkpoint_12'` | 1,531
`'checkpoint_13'` | 1,540
`'checkpoint_14'` | 1,527
`'checkpoint_15'` | 1,531
`'checkpoint_16'` | 1,535
`'checkpoint_17'` | 1,512
`'checkpoint_18'` | 1,515
`'checkpoint_19'` | 1,506
`'checkpoint_20'` | 1,538
`'checkpoint_21'` | 1,529
`'checkpoint_22'` | 1,526
`'checkpoint_23'` | 1,505
`'checkpoint_24'` | 1,447
`'checkpoint_25'` | 1,464
`'checkpoint_26'` | 1,460
`'checkpoint_27'` | 1,494
`'checkpoint_28'` | 1,508
`'checkpoint_29'` | 1,480
`'checkpoint_30'` | 1,471
`'checkpoint_31'` | 1,488
`'checkpoint_32'` | 1,521
`'checkpoint_33'` | 1,499
`'checkpoint_34'` | 1,475
`'checkpoint_35'` | 1,474
`'checkpoint_36'` | 1,527
`'checkpoint_37'` | 1,496
`'checkpoint_38'` | 1,501
`'checkpoint_39'` | 1,538
`'checkpoint_40'` | 1,488
`'checkpoint_41'` | 1,495
`'checkpoint_42'` | 1,501
`'checkpoint_43'` | 1,507
`'checkpoint_44'` | 1,512
`'checkpoint_45'` | 1,515
`'checkpoint_46'` | 1,516
`'checkpoint_47'` | 1,503
`'checkpoint_48'` | 1,500

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):
    Only shown for the first 100 configs.

## rlu_atari_checkpoints/Hero_run_1

*   **Dataset size**: `46.65 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 1,016
`'checkpoint_01'` | 574
`'checkpoint_02'` | 700
`'checkpoint_03'` | 700
`'checkpoint_04'` | 831
`'checkpoint_05'` | 982
`'checkpoint_06'` | 1,099
`'checkpoint_07'` | 1,202
`'checkpoint_08'` | 923
`'checkpoint_09'` | 814
`'checkpoint_10'` | 619
`'checkpoint_11'` | 580
`'checkpoint_12'` | 544
`'checkpoint_13'` | 724
`'checkpoint_14'` | 711
`'checkpoint_15'` | 782
`'checkpoint_16'` | 826
`'checkpoint_17'` | 793
`'checkpoint_18'` | 832
`'checkpoint_19'` | 865
`'checkpoint_20'` | 869
`'checkpoint_21'` | 910
`'checkpoint_22'` | 903
`'checkpoint_23'` | 908
`'checkpoint_24'` | 969
`'checkpoint_25'` | 951
`'checkpoint_26'` | 947
`'checkpoint_27'` | 975
`'checkpoint_28'` | 944
`'checkpoint_29'` | 911
`'checkpoint_30'` | 773
`'checkpoint_31'` | 722
`'checkpoint_32'` | 729
`'checkpoint_33'` | 785
`'checkpoint_34'` | 780
`'checkpoint_35'` | 819
`'checkpoint_36'` | 900
`'checkpoint_37'` | 921
`'checkpoint_38'` | 990
`'checkpoint_39'` | 943
`'checkpoint_40'` | 847
`'checkpoint_41'` | 819
`'checkpoint_42'` | 833
`'checkpoint_43'` | 838
`'checkpoint_44'` | 623
`'checkpoint_45'` | 796
`'checkpoint_46'` | 723
`'checkpoint_47'` | 741
`'checkpoint_48'` | 733
`'checkpoint_49'` | 742

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):
    Only shown for the first 100 configs.

## rlu_atari_checkpoints/Hero_run_2

*   **Dataset size**: `46.45 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 982
`'checkpoint_01'` | 569
`'checkpoint_02'` | 586
`'checkpoint_03'` | 740
`'checkpoint_04'` | 770
`'checkpoint_05'` | 982
`'checkpoint_06'` | 852
`'checkpoint_07'` | 935
`'checkpoint_08'` | 1,124
`'checkpoint_09'` | 882
`'checkpoint_10'` | 571
`'checkpoint_11'` | 596
`'checkpoint_12'` | 622
`'checkpoint_13'` | 625
`'checkpoint_14'` | 650
`'checkpoint_15'` | 745
`'checkpoint_16'` | 831
`'checkpoint_17'` | 737
`'checkpoint_18'` | 841
`'checkpoint_19'` | 896
`'checkpoint_20'` | 857
`'checkpoint_21'` | 918
`'checkpoint_22'` | 923
`'checkpoint_23'` | 925
`'checkpoint_24'` | 841
`'checkpoint_25'` | 799
`'checkpoint_26'` | 805
`'checkpoint_27'` | 775
`'checkpoint_28'` | 736
`'checkpoint_29'` | 704
`'checkpoint_30'` | 743
`'checkpoint_31'` | 374
`'checkpoint_32'` | 399
`'checkpoint_33'` | 559
`'checkpoint_34'` | 738
`'checkpoint_35'` | 702
`'checkpoint_36'` | 678
`'checkpoint_37'` | 448
`'checkpoint_38'` | 622
`'checkpoint_39'` | 607
`'checkpoint_40'` | 546
`'checkpoint_41'` | 580
`'checkpoint_42'` | 632
`'checkpoint_43'` | 673
`'checkpoint_44'` | 730
`'checkpoint_45'` | 757
`'checkpoint_46'` | 762
`'checkpoint_47'` | 776
`'checkpoint_48'` | 770
`'checkpoint_49'` | 765

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):
    Only shown for the first 100 configs.

## rlu_atari_checkpoints/Hero_run_3

*   **Dataset size**: `46.66 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 1,017
`'checkpoint_01'` | 518
`'checkpoint_02'` | 621
`'checkpoint_03'` | 758
`'checkpoint_04'` | 870
`'checkpoint_05'` | 1,056
`'checkpoint_06'` | 715
`'checkpoint_07'` | 702
`'checkpoint_08'` | 572
`'checkpoint_09'` | 553
`'checkpoint_10'` | 586
`'checkpoint_11'` | 704
`'checkpoint_12'` | 802
`'checkpoint_13'` | 896
`'checkpoint_14'` | 907
`'checkpoint_15'` | 931
`'checkpoint_16'` | 919
`'checkpoint_17'` | 920
`'checkpoint_18'` | 853
`'checkpoint_19'` | 946
`'checkpoint_20'` | 912
`'checkpoint_21'` | 827
`'checkpoint_22'` | 801
`'checkpoint_23'` | 880
`'checkpoint_24'` | 853
`'checkpoint_25'` | 898
`'checkpoint_26'` | 899
`'checkpoint_27'` | 906
`'checkpoint_28'` | 943
`'checkpoint_29'` | 923
`'checkpoint_30'` | 964
`'checkpoint_31'` | 952
`'checkpoint_32'` | 944
`'checkpoint_33'` | 962
`'checkpoint_34'` | 945
`'checkpoint_35'` | 951
`'checkpoint_36'` | 968
`'checkpoint_37'` | 901
`'checkpoint_38'` | 831
`'checkpoint_39'` | 862
`'checkpoint_40'` | 610
`'checkpoint_41'` | 623
`'checkpoint_42'` | 734
`'checkpoint_43'` | 675
`'checkpoint_44'` | 797
`'checkpoint_45'` | 755
`'checkpoint_46'` | 772
`'checkpoint_47'` | 686
`'checkpoint_48'` | 605
`'checkpoint_49'` | 700

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):
    Only shown for the first 100 configs.

## rlu_atari_checkpoints/Hero_run_4

*   **Dataset size**: `46.67 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 1,173
`'checkpoint_01'` | 558
`'checkpoint_02'` | 593
`'checkpoint_03'` | 640
`'checkpoint_04'` | 635
`'checkpoint_05'` | 671
`'checkpoint_06'` | 775
`'checkpoint_07'` | 866
`'checkpoint_08'` | 906
`'checkpoint_09'` | 1,072
`'checkpoint_10'` | 594
`'checkpoint_11'` | 740
`'checkpoint_12'` | 606
`'checkpoint_13'` | 574
`'checkpoint_14'` | 706
`'checkpoint_15'` | 749
`'checkpoint_16'` | 819
`'checkpoint_17'` | 893
`'checkpoint_18'` | 912
`'checkpoint_19'` | 932
`'checkpoint_20'` | 842
`'checkpoint_21'` | 864
`'checkpoint_22'` | 818
`'checkpoint_23'` | 859
`'checkpoint_24'` | 900
`'checkpoint_25'` | 915
`'checkpoint_26'` | 809
`'checkpoint_27'` | 828
`'checkpoint_28'` | 893
`'checkpoint_29'` | 934
`'checkpoint_30'` | 952
`'checkpoint_31'` | 984
`'checkpoint_32'` | 966
`'checkpoint_33'` | 948
`'checkpoint_34'` | 929
`'checkpoint_35'` | 876
`'checkpoint_36'` | 821
`'checkpoint_37'` | 861
`'checkpoint_38'` | 907
`'checkpoint_39'` | 908
`'checkpoint_40'` | 917
`'checkpoint_41'` | 779
`'checkpoint_42'` | 847
`'checkpoint_43'` | 545
`'checkpoint_44'` | 592
`'checkpoint_45'` | 701
`'checkpoint_46'` | 920
`'checkpoint_47'` | 800
`'checkpoint_48'` | 753
`'checkpoint_49'` | 675

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):
    Only shown for the first 100 configs.

## rlu_atari_checkpoints/Hero_run_5

*   **Dataset size**: `46.74 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 953
`'checkpoint_01'` | 742
`'checkpoint_02'` | 663
`'checkpoint_03'` | 844
`'checkpoint_04'` | 861
`'checkpoint_05'` | 1,170
`'checkpoint_06'` | 843
`'checkpoint_07'` | 672
`'checkpoint_08'` | 590
`'checkpoint_09'` | 539
`'checkpoint_10'` | 690
`'checkpoint_11'` | 656
`'checkpoint_12'` | 687
`'checkpoint_13'` | 667
`'checkpoint_14'` | 870
`'checkpoint_15'` | 877
`'checkpoint_16'` | 909
`'checkpoint_17'` | 972
`'checkpoint_18'` | 957
`'checkpoint_19'` | 978
`'checkpoint_20'` | 753
`'checkpoint_21'` | 857
`'checkpoint_22'` | 955
`'checkpoint_23'` | 564
`'checkpoint_24'` | 607
`'checkpoint_25'` | 689
`'checkpoint_26'` | 839
`'checkpoint_27'` | 761
`'checkpoint_28'` | 911
`'checkpoint_29'` | 975
`'checkpoint_30'` | 1,015
`'checkpoint_31'` | 1,019
`'checkpoint_32'` | 1,022
`'checkpoint_33'` | 996
`'checkpoint_34'` | 980
`'checkpoint_35'` | 966
`'checkpoint_36'` | 991
`'checkpoint_37'` | 975
`'checkpoint_38'` | 995
`'checkpoint_39'` | 981
`'checkpoint_40'` | 988
`'checkpoint_41'` | 986
`'checkpoint_42'` | 971
`'checkpoint_43'` | 1,006
`'checkpoint_44'` | 998
`'checkpoint_45'` | 980
`'checkpoint_46'` | 995
`'checkpoint_47'` | 1,010
`'checkpoint_48'` | 995
`'checkpoint_49'` | 987

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):
    Only shown for the first 100 configs.

## rlu_atari_checkpoints/IceHockey_run_1

*   **Dataset size**: `37.09 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 291
`'checkpoint_01'` | 301
`'checkpoint_02'` | 306
`'checkpoint_03'` | 309
`'checkpoint_04'` | 312
`'checkpoint_05'` | 314
`'checkpoint_06'` | 312
`'checkpoint_07'` | 313
`'checkpoint_08'` | 317
`'checkpoint_09'` | 312
`'checkpoint_10'` | 316
`'checkpoint_11'` | 317
`'checkpoint_12'` | 314
`'checkpoint_13'` | 317
`'checkpoint_14'` | 316
`'checkpoint_15'` | 319
`'checkpoint_16'` | 319
`'checkpoint_17'` | 318
`'checkpoint_18'` | 321
`'checkpoint_19'` | 322
`'checkpoint_20'` | 321
`'checkpoint_21'` | 325
`'checkpoint_22'` | 321
`'checkpoint_23'` | 322
`'checkpoint_24'` | 321
`'checkpoint_25'` | 319
`'checkpoint_26'` | 320
`'checkpoint_27'` | 320
`'checkpoint_28'` | 318
`'checkpoint_29'` | 319
`'checkpoint_30'` | 318
`'checkpoint_31'` | 320
`'checkpoint_32'` | 318
`'checkpoint_33'` | 316
`'checkpoint_34'` | 315
`'checkpoint_35'` | 314
`'checkpoint_36'` | 313
`'checkpoint_37'` | 313
`'checkpoint_38'` | 310
`'checkpoint_39'` | 309
`'checkpoint_40'` | 307
`'checkpoint_41'` | 306
`'checkpoint_42'` | 310
`'checkpoint_43'` | 306
`'checkpoint_44'` | 306
`'checkpoint_45'` | 304
`'checkpoint_46'` | 300
`'checkpoint_47'` | 293
`'checkpoint_48'` | 287
`'checkpoint_49'` | 286

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):
    Only shown for the first 100 configs.

## rlu_atari_checkpoints/IceHockey_run_2

*   **Dataset size**: `37.09 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 291
`'checkpoint_01'` | 299
`'checkpoint_02'` | 308
`'checkpoint_03'` | 306
`'checkpoint_04'` | 310
`'checkpoint_05'` | 316
`'checkpoint_06'` | 313
`'checkpoint_07'` | 312
`'checkpoint_08'` | 315
`'checkpoint_09'` | 314
`'checkpoint_10'` | 315
`'checkpoint_11'` | 318
`'checkpoint_12'` | 319
`'checkpoint_13'` | 319
`'checkpoint_14'` | 320
`'checkpoint_15'` | 319
`'checkpoint_16'` | 321
`'checkpoint_17'` | 318
`'checkpoint_18'` | 319
`'checkpoint_19'` | 321
`'checkpoint_20'` | 320
`'checkpoint_21'` | 319
`'checkpoint_22'` | 323
`'checkpoint_23'` | 321
`'checkpoint_24'` | 320
`'checkpoint_25'` | 318
`'checkpoint_26'` | 319
`'checkpoint_27'` | 319
`'checkpoint_28'` | 317
`'checkpoint_29'` | 318
`'checkpoint_30'` | 316
`'checkpoint_31'` | 316
`'checkpoint_32'` | 316
`'checkpoint_33'` | 316
`'checkpoint_34'` | 314
`'checkpoint_35'` | 310
`'checkpoint_36'` | 311
`'checkpoint_37'` | 308
`'checkpoint_38'` | 307
`'checkpoint_39'` | 305
`'checkpoint_40'` | 307
`'checkpoint_41'` | 307
`'checkpoint_42'` | 307
`'checkpoint_43'` | 306
`'checkpoint_44'` | 305
`'checkpoint_45'` | 303
`'checkpoint_46'` | 299
`'checkpoint_47'` | 301
`'checkpoint_48'` | 295
`'checkpoint_49'` | 294

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):
    Only shown for the first 100 configs.

## rlu_atari_checkpoints/IceHockey_run_3

*   **Dataset size**: `37.18 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 292
`'checkpoint_01'` | 295
`'checkpoint_02'` | 303
`'checkpoint_03'` | 307
`'checkpoint_04'` | 309
`'checkpoint_05'` | 314
`'checkpoint_06'` | 315
`'checkpoint_07'` | 311
`'checkpoint_08'` | 315
`'checkpoint_09'` | 316
`'checkpoint_10'` | 317
`'checkpoint_11'` | 321
`'checkpoint_12'` | 318
`'checkpoint_13'` | 317
`'checkpoint_14'` | 318
`'checkpoint_15'` | 316
`'checkpoint_16'` | 320
`'checkpoint_17'` | 319
`'checkpoint_18'` | 318
`'checkpoint_19'` | 318
`'checkpoint_20'` | 322
`'checkpoint_21'` | 319
`'checkpoint_22'` | 317
`'checkpoint_23'` | 314
`'checkpoint_24'` | 313
`'checkpoint_25'` | 309
`'checkpoint_26'` | 307
`'checkpoint_27'` | 307
`'checkpoint_28'` | 301
`'checkpoint_29'` | 299
`'checkpoint_30'` | 297
`'checkpoint_31'` | 298
`'checkpoint_32'` | 293
`'checkpoint_33'` | 295
`'checkpoint_34'` | 291
`'checkpoint_35'` | 291
`'checkpoint_36'` | 290
`'checkpoint_37'` | 288
`'checkpoint_38'` | 285
`'checkpoint_39'` | 287
`'checkpoint_40'` | 284
`'checkpoint_41'` | 284
`'checkpoint_42'` | 285
`'checkpoint_43'` | 282
`'checkpoint_44'` | 286
`'checkpoint_45'` | 287
`'checkpoint_46'` | 288
`'checkpoint_47'` | 286
`'checkpoint_48'` | 285
`'checkpoint_49'` | 283

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):
    Only shown for the first 100 configs.

## rlu_atari_checkpoints/IceHockey_run_4

*   **Dataset size**: `37.16 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 292
`'checkpoint_01'` | 299
`'checkpoint_02'` | 307
`'checkpoint_03'` | 312
`'checkpoint_04'` | 313
`'checkpoint_05'` | 314
`'checkpoint_06'` | 316
`'checkpoint_07'` | 315
`'checkpoint_08'` | 314
`'checkpoint_09'` | 316
`'checkpoint_10'` | 315
`'checkpoint_11'` | 315
`'checkpoint_12'` | 317
`'checkpoint_13'` | 315
`'checkpoint_14'` | 316
`'checkpoint_15'` | 316
`'checkpoint_16'` | 319
`'checkpoint_17'` | 319
`'checkpoint_18'` | 319
`'checkpoint_19'` | 316
`'checkpoint_20'` | 315
`'checkpoint_21'` | 319
`'checkpoint_22'` | 317
`'checkpoint_23'` | 317
`'checkpoint_24'` | 315
`'checkpoint_25'` | 313
`'checkpoint_26'` | 314
`'checkpoint_27'` | 315
`'checkpoint_28'` | 313
`'checkpoint_29'` | 310
`'checkpoint_30'` | 312
`'checkpoint_31'` | 310
`'checkpoint_32'` | 312
`'checkpoint_33'` | 308
`'checkpoint_34'` | 309
`'checkpoint_35'` | 305
`'checkpoint_36'` | 304
`'checkpoint_37'` | 302
`'checkpoint_38'` | 298
`'checkpoint_39'` | 298
`'checkpoint_40'` | 296
`'checkpoint_41'` | 294
`'checkpoint_42'` | 290
`'checkpoint_43'` | 289
`'checkpoint_44'` | 287
`'checkpoint_45'` | 283
`'checkpoint_46'` | 285
`'checkpoint_47'` | 282
`'checkpoint_48'` | 282
`'checkpoint_49'` | 283

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):
    Only shown for the first 100 configs.

## rlu_atari_checkpoints/IceHockey_run_5

*   **Dataset size**: `37.18 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 290
`'checkpoint_01'` | 297
`'checkpoint_02'` | 308
`'checkpoint_03'` | 308
`'checkpoint_04'` | 309
`'checkpoint_05'` | 308
`'checkpoint_06'` | 308
`'checkpoint_07'` | 310
`'checkpoint_08'` | 312
`'checkpoint_09'` | 312
`'checkpoint_10'` | 315
`'checkpoint_11'` | 314
`'checkpoint_12'` | 312
`'checkpoint_13'` | 314
`'checkpoint_14'` | 317
`'checkpoint_15'` | 315
`'checkpoint_16'` | 316
`'checkpoint_17'` | 314
`'checkpoint_18'` | 314
`'checkpoint_19'` | 317
`'checkpoint_20'` | 321
`'checkpoint_21'` | 316
`'checkpoint_22'` | 312
`'checkpoint_23'` | 312
`'checkpoint_24'` | 309
`'checkpoint_25'` | 313
`'checkpoint_26'` | 313
`'checkpoint_27'` | 311
`'checkpoint_28'` | 309
`'checkpoint_29'` | 309
`'checkpoint_30'` | 308
`'checkpoint_31'` | 309
`'checkpoint_32'` | 307
`'checkpoint_33'` | 311
`'checkpoint_34'` | 306
`'checkpoint_35'` | 306
`'checkpoint_36'` | 303
`'checkpoint_37'` | 303
`'checkpoint_38'` | 297
`'checkpoint_39'` | 297
`'checkpoint_40'` | 298
`'checkpoint_41'` | 294
`'checkpoint_42'` | 292
`'checkpoint_43'` | 294
`'checkpoint_44'` | 291
`'checkpoint_45'` | 289
`'checkpoint_46'` | 288
`'checkpoint_47'` | 285
`'checkpoint_48'` | 287
`'checkpoint_49'` | 287

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):
    Only shown for the first 100 configs.

## rlu_atari_checkpoints/Jamesbond_run_1

*   **Dataset size**: `35.02 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 1,753
`'checkpoint_01'` | 1,499
`'checkpoint_02'` | 1,356
`'checkpoint_03'` | 1,204
`'checkpoint_04'` | 969
`'checkpoint_05'` | 867
`'checkpoint_06'` | 878
`'checkpoint_07'` | 838
`'checkpoint_08'` | 832
`'checkpoint_09'` | 867
`'checkpoint_10'` | 788
`'checkpoint_11'` | 736
`'checkpoint_12'` | 683
`'checkpoint_13'` | 640
`'checkpoint_14'` | 608
`'checkpoint_15'` | 612
`'checkpoint_16'` | 614
`'checkpoint_17'` | 597
`'checkpoint_18'` | 596
`'checkpoint_19'` | 585
`'checkpoint_20'` | 580
`'checkpoint_21'` | 587
`'checkpoint_22'` | 582
`'checkpoint_23'` | 587
`'checkpoint_24'` | 581
`'checkpoint_25'` | 578
`'checkpoint_26'` | 586
`'checkpoint_27'` | 583
`'checkpoint_28'` | 583
`'checkpoint_29'` | 580
`'checkpoint_30'` | 570
`'checkpoint_31'` | 568
`'checkpoint_32'` | 582
`'checkpoint_33'` | 582
`'checkpoint_34'` | 575
`'checkpoint_35'` | 568
`'checkpoint_36'` | 575
`'checkpoint_37'` | 568
`'checkpoint_38'` | 572
`'checkpoint_39'` | 575
`'checkpoint_40'` | 575
`'checkpoint_41'` | 573
`'checkpoint_42'` | 577
`'checkpoint_43'` | 571
`'checkpoint_44'` | 573
`'checkpoint_45'` | 566
`'checkpoint_46'` | 570
`'checkpoint_47'` | 568
`'checkpoint_48'` | 567
`'checkpoint_49'` | 567

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):
    Only shown for the first 100 configs.

## rlu_atari_checkpoints/Jamesbond_run_2

*   **Dataset size**: `35.04 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 1,766
`'checkpoint_01'` | 1,568
`'checkpoint_02'` | 1,412
`'checkpoint_03'` | 1,138
`'checkpoint_04'` | 879
`'checkpoint_05'` | 836
`'checkpoint_06'` | 697
`'checkpoint_07'` | 818
`'checkpoint_08'` | 816
`'checkpoint_09'` | 753
`'checkpoint_10'` | 721
`'checkpoint_11'` | 717
`'checkpoint_12'` | 641
`'checkpoint_13'` | 704
`'checkpoint_14'` | 672
`'checkpoint_15'` | 670
`'checkpoint_16'` | 691
`'checkpoint_17'` | 679
`'checkpoint_18'` | 696
`'checkpoint_19'` | 712
`'checkpoint_20'` | 670
`'checkpoint_21'` | 693
`'checkpoint_22'` | 691
`'checkpoint_23'` | 709
`'checkpoint_24'` | 697
`'checkpoint_25'` | 677
`'checkpoint_26'` | 696
`'checkpoint_27'` | 679
`'checkpoint_28'` | 671
`'checkpoint_29'` | 675
`'checkpoint_30'` | 664
`'checkpoint_31'` | 661
`'checkpoint_32'` | 644
`'checkpoint_33'` | 680
`'checkpoint_34'` | 653
`'checkpoint_35'` | 639
`'checkpoint_36'` | 664
`'checkpoint_37'` | 660
`'checkpoint_38'` | 657
`'checkpoint_39'` | 664
`'checkpoint_40'` | 666
`'checkpoint_41'` | 672
`'checkpoint_42'` | 670
`'checkpoint_43'` | 670
`'checkpoint_44'` | 661
`'checkpoint_45'` | 677
`'checkpoint_46'` | 673
`'checkpoint_47'` | 681
`'checkpoint_48'` | 656
`'checkpoint_49'` | 671

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):
    Only shown for the first 100 configs.

## rlu_atari_checkpoints/Jamesbond_run_3

*   **Dataset size**: `35.19 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 1,706
`'checkpoint_01'` | 1,430
`'checkpoint_02'` | 1,352
`'checkpoint_03'` | 1,326
`'checkpoint_04'` | 864
`'checkpoint_05'` | 739
`'checkpoint_06'` | 730
`'checkpoint_07'` | 692
`'checkpoint_08'` | 682
`'checkpoint_09'` | 664
`'checkpoint_10'` | 638
`'checkpoint_11'` | 626
`'checkpoint_12'` | 613
`'checkpoint_13'` | 598
`'checkpoint_14'` | 607
`'checkpoint_15'` | 606
`'checkpoint_16'` | 605
`'checkpoint_17'` | 593
`'checkpoint_18'` | 591
`'checkpoint_19'` | 593
`'checkpoint_20'` | 572
`'checkpoint_21'` | 570
`'checkpoint_22'` | 566
`'checkpoint_23'` | 551
`'checkpoint_24'` | 556
`'checkpoint_25'` | 563
`'checkpoint_26'` | 568
`'checkpoint_27'` | 555
`'checkpoint_28'` | 565
`'checkpoint_29'` | 592
`'checkpoint_30'` | 594
`'checkpoint_31'` | 603
`'checkpoint_32'` | 588
`'checkpoint_33'` | 593
`'checkpoint_34'` | 624
`'checkpoint_35'` | 597
`'checkpoint_36'` | 617
`'checkpoint_37'` | 614
`'checkpoint_38'` | 610
`'checkpoint_39'` | 604
`'checkpoint_40'` | 608
`'checkpoint_41'` | 600
`'checkpoint_42'` | 593
`'checkpoint_43'` | 593
`'checkpoint_44'` | 594
`'checkpoint_45'` | 594
`'checkpoint_46'` | 599
`'checkpoint_47'` | 594
`'checkpoint_48'` | 582
`'checkpoint_49'` | 577

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):
    Only shown for the first 100 configs.

## rlu_atari_checkpoints/Jamesbond_run_4

*   **Dataset size**: `34.99 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 1,695
`'checkpoint_01'` | 1,510
`'checkpoint_02'` | 1,423
`'checkpoint_03'` | 1,250
`'checkpoint_04'` | 966
`'checkpoint_05'` | 909
`'checkpoint_06'` | 913
`'checkpoint_07'` | 850
`'checkpoint_08'` | 845
`'checkpoint_09'` | 778
`'checkpoint_10'` | 716
`'checkpoint_11'` | 690
`'checkpoint_12'` | 669
`'checkpoint_13'` | 650
`'checkpoint_14'` | 643
`'checkpoint_15'` | 642
`'checkpoint_16'` | 624
`'checkpoint_17'` | 626
`'checkpoint_18'` | 615
`'checkpoint_19'` | 611
`'checkpoint_20'` | 617
`'checkpoint_21'` | 615
`'checkpoint_22'` | 608
`'checkpoint_23'` | 598
`'checkpoint_24'` | 591
`'checkpoint_25'` | 589
`'checkpoint_26'` | 592
`'checkpoint_27'` | 595
`'checkpoint_28'` | 597
`'checkpoint_29'` | 596
`'checkpoint_30'` | 591
`'checkpoint_31'` | 587
`'checkpoint_32'` | 581
`'checkpoint_33'` | 574
`'checkpoint_34'` | 576
`'checkpoint_35'` | 579
`'checkpoint_36'` | 580
`'checkpoint_37'` | 587
`'checkpoint_38'` | 573
`'checkpoint_39'` | 574
`'checkpoint_40'` | 580
`'checkpoint_41'` | 576
`'checkpoint_42'` | 574
`'checkpoint_43'` | 584
`'checkpoint_44'` | 587
`'checkpoint_45'` | 589
`'checkpoint_46'` | 588
`'checkpoint_47'` | 588
`'checkpoint_48'` | 579
`'checkpoint_49'` | 582

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):
    Only shown for the first 100 configs.

## rlu_atari_checkpoints/Jamesbond_run_5

*   **Dataset size**: `35.11 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 1,684
`'checkpoint_01'` | 1,478
`'checkpoint_02'` | 1,293
`'checkpoint_03'` | 1,067
`'checkpoint_04'` | 977
`'checkpoint_05'` | 918
`'checkpoint_06'` | 807
`'checkpoint_07'` | 710
`'checkpoint_08'` | 661
`'checkpoint_09'` | 637
`'checkpoint_10'` | 622
`'checkpoint_11'` | 622
`'checkpoint_12'` | 615
`'checkpoint_13'` | 614
`'checkpoint_14'` | 606
`'checkpoint_15'` | 598
`'checkpoint_16'` | 596
`'checkpoint_17'` | 595
`'checkpoint_18'` | 586
`'checkpoint_19'` | 587
`'checkpoint_20'` | 588
`'checkpoint_21'` | 581
`'checkpoint_22'` | 584
`'checkpoint_23'` | 581
`'checkpoint_24'` | 584
`'checkpoint_25'` | 592
`'checkpoint_26'` | 583
`'checkpoint_27'` | 581
`'checkpoint_28'` | 585
`'checkpoint_29'` | 584
`'checkpoint_30'` | 578
`'checkpoint_31'` | 575
`'checkpoint_32'` | 579
`'checkpoint_33'` | 578
`'checkpoint_34'` | 579
`'checkpoint_35'` | 581
`'checkpoint_36'` | 585
`'checkpoint_37'` | 577
`'checkpoint_38'` | 570
`'checkpoint_39'` | 568
`'checkpoint_40'` | 574
`'checkpoint_41'` | 572
`'checkpoint_42'` | 567
`'checkpoint_43'` | 571
`'checkpoint_44'` | 571
`'checkpoint_45'` | 571
`'checkpoint_46'` | 573
`'checkpoint_47'` | 567
`'checkpoint_48'` | 570
`'checkpoint_49'` | 557

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):
    Only shown for the first 100 configs.

## rlu_atari_checkpoints/Kangaroo_run_1

*   **Dataset size**: `55.07 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 2,215
`'checkpoint_01'` | 1,974
`'checkpoint_02'` | 1,723
`'checkpoint_03'` | 1,497
`'checkpoint_04'` | 1,164
`'checkpoint_05'` | 1,053
`'checkpoint_06'` | 829
`'checkpoint_07'` | 634
`'checkpoint_08'` | 625
`'checkpoint_09'` | 521
`'checkpoint_10'` | 443
`'checkpoint_11'` | 417
`'checkpoint_12'` | 393
`'checkpoint_13'` | 359
`'checkpoint_14'` | 338
`'checkpoint_15'` | 325
`'checkpoint_16'` | 324
`'checkpoint_17'` | 314
`'checkpoint_18'` | 316
`'checkpoint_19'` | 314
`'checkpoint_20'` | 309
`'checkpoint_21'` | 317
`'checkpoint_22'` | 313
`'checkpoint_23'` | 317
`'checkpoint_24'` | 305
`'checkpoint_25'` | 299
`'checkpoint_26'` | 309
`'checkpoint_27'` | 312
`'checkpoint_28'` | 327
`'checkpoint_29'` | 333
`'checkpoint_30'` | 345
`'checkpoint_31'` | 345
`'checkpoint_32'` | 332
`'checkpoint_33'` | 338
`'checkpoint_34'` | 322
`'checkpoint_35'` | 337
`'checkpoint_36'` | 322
`'checkpoint_37'` | 338
`'checkpoint_38'` | 333
`'checkpoint_39'` | 333
`'checkpoint_40'` | 319
`'checkpoint_41'` | 339
`'checkpoint_42'` | 354
`'checkpoint_43'` | 380
`'checkpoint_44'` | 338
`'checkpoint_45'` | 339
`'checkpoint_46'` | 351
`'checkpoint_47'` | 322
`'checkpoint_48'` | 363
`'checkpoint_49'` | 379

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):
    Only shown for the first 100 configs.

## rlu_atari_checkpoints/Kangaroo_run_2

*   **Dataset size**: `54.60 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 2,089
`'checkpoint_01'` | 1,906
`'checkpoint_02'` | 1,818
`'checkpoint_03'` | 1,765
`'checkpoint_04'` | 1,527
`'checkpoint_05'` | 1,159
`'checkpoint_06'` | 974
`'checkpoint_07'` | 879
`'checkpoint_08'` | 734
`'checkpoint_09'` | 635
`'checkpoint_10'` | 570
`'checkpoint_11'` | 444
`'checkpoint_12'` | 442
`'checkpoint_13'` | 375
`'checkpoint_14'` | 369
`'checkpoint_15'` | 387
`'checkpoint_16'` | 327
`'checkpoint_17'` | 299
`'checkpoint_18'` | 321
`'checkpoint_19'` | 298
`'checkpoint_20'` | 292
`'checkpoint_21'` | 297
`'checkpoint_22'` | 293
`'checkpoint_23'` | 291
`'checkpoint_24'` | 285
`'checkpoint_25'` | 287
`'checkpoint_26'` | 292
`'checkpoint_27'` | 295
`'checkpoint_28'` | 296
`'checkpoint_29'` | 299
`'checkpoint_30'` | 283
`'checkpoint_31'` | 288
`'checkpoint_32'` | 301
`'checkpoint_33'` | 295
`'checkpoint_34'` | 297
`'checkpoint_35'` | 315
`'checkpoint_36'` | 305
`'checkpoint_37'` | 309
`'checkpoint_38'` | 297
`'checkpoint_39'` | 319
`'checkpoint_40'` | 317
`'checkpoint_41'` | 298
`'checkpoint_42'` | 315
`'checkpoint_43'` | 327
`'checkpoint_44'` | 345
`'checkpoint_45'` | 329
`'checkpoint_46'` | 329
`'checkpoint_47'` | 306
`'checkpoint_48'` | 309
`'checkpoint_49'` | 299

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):
    Only shown for the first 100 configs.

## rlu_atari_checkpoints/Kangaroo_run_3

*   **Dataset size**: `54.54 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 2,112
`'checkpoint_01'` | 1,959
`'checkpoint_02'` | 1,772
`'checkpoint_03'` | 1,740
`'checkpoint_04'` | 1,677
`'checkpoint_05'` | 1,477
`'checkpoint_06'` | 1,293
`'checkpoint_07'` | 1,175
`'checkpoint_08'` | 952
`'checkpoint_09'` | 767
`'checkpoint_10'` | 533
`'checkpoint_11'` | 455
`'checkpoint_12'` | 424
`'checkpoint_13'` | 396
`'checkpoint_14'` | 433
`'checkpoint_15'` | 360
`'checkpoint_16'` | 311
`'checkpoint_17'` | 309
`'checkpoint_18'` | 319
`'checkpoint_19'` | 318
`'checkpoint_20'` | 305
`'checkpoint_21'` | 292
`'checkpoint_22'` | 292
`'checkpoint_23'` | 293
`'checkpoint_24'` | 297
`'checkpoint_25'` | 293
`'checkpoint_26'` | 287
`'checkpoint_27'` | 286
`'checkpoint_28'` | 290
`'checkpoint_29'` | 294
`'checkpoint_30'` | 296
`'checkpoint_31'` | 330
`'checkpoint_32'` | 312
`'checkpoint_33'` | 327
`'checkpoint_34'` | 337
`'checkpoint_35'` | 345
`'checkpoint_36'` | 366
`'checkpoint_37'` | 365
`'checkpoint_38'` | 351
`'checkpoint_39'` | 365
`'checkpoint_40'` | 355
`'checkpoint_41'` | 360
`'checkpoint_42'` | 360
`'checkpoint_43'` | 360
`'checkpoint_44'` | 364
`'checkpoint_45'` | 363
`'checkpoint_46'` | 360
`'checkpoint_47'` | 361
`'checkpoint_48'` | 352
`'checkpoint_49'` | 344

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):
    Only shown for the first 100 configs.

## rlu_atari_checkpoints/Kangaroo_run_4

*   **Dataset size**: `55.21 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 2,083
`'checkpoint_01'` | 1,927
`'checkpoint_02'` | 1,739
`'checkpoint_03'` | 1,540
`'checkpoint_04'` | 1,365
`'checkpoint_05'` | 1,130
`'checkpoint_06'` | 900
`'checkpoint_07'` | 680
`'checkpoint_08'` | 506
`'checkpoint_09'` | 438
`'checkpoint_10'` | 418
`'checkpoint_11'` | 341
`'checkpoint_12'` | 312
`'checkpoint_13'` | 298
`'checkpoint_14'` | 296
`'checkpoint_15'` | 295
`'checkpoint_16'` | 290
`'checkpoint_17'` | 295
`'checkpoint_18'` | 296
`'checkpoint_19'` | 288
`'checkpoint_20'` | 288
`'checkpoint_21'` | 287
`'checkpoint_22'` | 293
`'checkpoint_23'` | 297
`'checkpoint_24'` | 301
`'checkpoint_25'` | 290
`'checkpoint_26'` | 295
`'checkpoint_27'` | 297
`'checkpoint_28'` | 303
`'checkpoint_29'` | 299
`'checkpoint_30'` | 300
`'checkpoint_31'` | 303
`'checkpoint_32'` | 298
`'checkpoint_33'` | 305
`'checkpoint_34'` | 300
`'checkpoint_35'` | 306
`'checkpoint_36'` | 307
`'checkpoint_37'` | 291
`'checkpoint_38'` | 298
`'checkpoint_39'` | 297
`'checkpoint_40'` | 300
`'checkpoint_41'` | 303
`'checkpoint_42'` | 306
`'checkpoint_43'` | 303
`'checkpoint_44'` | 307
`'checkpoint_45'` | 310
`'checkpoint_46'` | 326
`'checkpoint_47'` | 313
`'checkpoint_48'` | 312
`'checkpoint_49'` | 323

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):
    Only shown for the first 100 configs.

## rlu_atari_checkpoints/Kangaroo_run_5

*   **Dataset size**: `54.37 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 2,031
`'checkpoint_01'` | 1,874
`'checkpoint_02'` | 1,744
`'checkpoint_03'` | 1,643
`'checkpoint_04'` | 1,311
`'checkpoint_05'` | 1,050
`'checkpoint_06'` | 789
`'checkpoint_07'` | 553
`'checkpoint_08'` | 503
`'checkpoint_09'` | 421
`'checkpoint_10'` | 466
`'checkpoint_11'` | 438
`'checkpoint_12'` | 398
`'checkpoint_13'` | 388
`'checkpoint_14'` | 369
`'checkpoint_15'` | 407
`'checkpoint_16'` | 398
`'checkpoint_17'` | 433
`'checkpoint_18'` | 388
`'checkpoint_19'` | 369
`'checkpoint_20'` | 345
`'checkpoint_21'` | 317
`'checkpoint_22'` | 314
`'checkpoint_23'` | 311
`'checkpoint_24'` | 312
`'checkpoint_25'` | 299
`'checkpoint_26'` | 305
`'checkpoint_27'` | 312
`'checkpoint_28'` | 309
`'checkpoint_29'` | 329
`'checkpoint_30'` | 327
`'checkpoint_31'` | 316
`'checkpoint_32'` | 340
`'checkpoint_33'` | 310
`'checkpoint_34'` | 310
`'checkpoint_35'` | 320
`'checkpoint_36'` | 323
`'checkpoint_37'` | 306
`'checkpoint_38'` | 302
`'checkpoint_39'` | 304
`'checkpoint_40'` | 312
`'checkpoint_41'` | 310
`'checkpoint_42'` | 317
`'checkpoint_43'` | 317
`'checkpoint_44'` | 342
`'checkpoint_45'` | 351
`'checkpoint_46'` | 327
`'checkpoint_47'` | 337
`'checkpoint_48'` | 335
`'checkpoint_49'` | 336

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):
    Only shown for the first 100 configs.

## rlu_atari_checkpoints/Krull_run_1

*   **Dataset size**: `90.36 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 677
`'checkpoint_01'` | 709
`'checkpoint_02'` | 760
`'checkpoint_03'` | 771
`'checkpoint_04'` | 779
`'checkpoint_05'` | 766
`'checkpoint_06'` | 760
`'checkpoint_07'` | 769
`'checkpoint_08'` | 766
`'checkpoint_09'` | 762
`'checkpoint_10'` | 764
`'checkpoint_11'` | 763
`'checkpoint_12'` | 760
`'checkpoint_13'` | 757
`'checkpoint_14'` | 758
`'checkpoint_15'` | 758
`'checkpoint_16'` | 765
`'checkpoint_17'` | 757
`'checkpoint_18'` | 764
`'checkpoint_19'` | 768
`'checkpoint_20'` | 772
`'checkpoint_21'` | 767
`'checkpoint_22'` | 764
`'checkpoint_23'` | 764
`'checkpoint_24'` | 770
`'checkpoint_25'` | 762
`'checkpoint_26'` | 764
`'checkpoint_27'` | 763
`'checkpoint_28'` | 759
`'checkpoint_29'` | 765
`'checkpoint_30'` | 762
`'checkpoint_31'` | 753
`'checkpoint_32'` | 757
`'checkpoint_33'` | 755
`'checkpoint_34'` | 766
`'checkpoint_35'` | 767
`'checkpoint_36'` | 765
`'checkpoint_37'` | 761
`'checkpoint_38'` | 763
`'checkpoint_39'` | 760
`'checkpoint_40'` | 761
`'checkpoint_41'` | 754
`'checkpoint_42'` | 763
`'checkpoint_43'` | 764
`'checkpoint_44'` | 754
`'checkpoint_45'` | 763
`'checkpoint_46'` | 764
`'checkpoint_47'` | 759
`'checkpoint_48'` | 756
`'checkpoint_49'` | 759

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):
    Only shown for the first 100 configs.

## rlu_atari_checkpoints/Krull_run_2

*   **Dataset size**: `90.41 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 678
`'checkpoint_01'` | 720
`'checkpoint_02'` | 765
`'checkpoint_03'` | 767
`'checkpoint_04'` | 765
`'checkpoint_05'` | 772
`'checkpoint_06'` | 760
`'checkpoint_07'` | 762
`'checkpoint_08'` | 772
`'checkpoint_09'` | 767
`'checkpoint_10'` | 769
`'checkpoint_11'` | 759
`'checkpoint_12'` | 768
`'checkpoint_13'` | 760
`'checkpoint_14'` | 767
`'checkpoint_15'` | 773
`'checkpoint_16'` | 767
`'checkpoint_17'` | 758
`'checkpoint_18'` | 754
`'checkpoint_19'` | 768
`'checkpoint_20'` | 766
`'checkpoint_21'` | 759
`'checkpoint_22'` | 766
`'checkpoint_23'` | 760
`'checkpoint_24'` | 759
`'checkpoint_25'` | 764
`'checkpoint_26'` | 765
`'checkpoint_27'` | 762
`'checkpoint_28'` | 760
`'checkpoint_29'` | 759
`'checkpoint_30'` | 765
`'checkpoint_31'` | 760
`'checkpoint_32'` | 761
`'checkpoint_33'` | 760
`'checkpoint_34'` | 763
`'checkpoint_35'` | 761
`'checkpoint_36'` | 770
`'checkpoint_37'` | 768
`'checkpoint_38'` | 758
`'checkpoint_39'` | 757
`'checkpoint_40'` | 763
`'checkpoint_41'` | 761
`'checkpoint_42'` | 763
`'checkpoint_43'` | 762
`'checkpoint_44'` | 752
`'checkpoint_45'` | 756
`'checkpoint_46'` | 764
`'checkpoint_47'` | 757
`'checkpoint_48'` | 760
`'checkpoint_49'` | 759

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):
    Only shown for the first 100 configs.

## rlu_atari_checkpoints/Krull_run_3

*   **Dataset size**: `90.27 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 699
`'checkpoint_01'` | 731
`'checkpoint_02'` | 777
`'checkpoint_03'` | 777
`'checkpoint_04'` | 769
`'checkpoint_05'` | 770
`'checkpoint_06'` | 770
`'checkpoint_07'` | 768
`'checkpoint_08'` | 776
`'checkpoint_09'` | 779
`'checkpoint_10'` | 764
`'checkpoint_11'` | 766
`'checkpoint_12'` | 768
`'checkpoint_13'` | 774
`'checkpoint_14'` | 757
`'checkpoint_15'` | 762
`'checkpoint_16'` | 767
`'checkpoint_17'` | 770
`'checkpoint_18'` | 774
`'checkpoint_19'` | 768
`'checkpoint_20'` | 767
`'checkpoint_21'` | 764
`'checkpoint_22'` | 776
`'checkpoint_23'` | 756
`'checkpoint_24'` | 765
`'checkpoint_25'` | 758
`'checkpoint_26'` | 762
`'checkpoint_27'` | 769
`'checkpoint_28'` | 760
`'checkpoint_29'` | 771
`'checkpoint_30'` | 767
`'checkpoint_31'` | 759
`'checkpoint_32'` | 764
`'checkpoint_33'` | 766
`'checkpoint_34'` | 771
`'checkpoint_35'` | 767
`'checkpoint_36'` | 763
`'checkpoint_37'` | 766
`'checkpoint_38'` | 766
`'checkpoint_39'` | 756
`'checkpoint_40'` | 761
`'checkpoint_41'` | 754
`'checkpoint_42'` | 764
`'checkpoint_43'` | 764
`'checkpoint_44'` | 759
`'checkpoint_45'` | 764
`'checkpoint_46'` | 765
`'checkpoint_47'` | 761
`'checkpoint_48'` | 768
`'checkpoint_49'` | 765

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):
    Only shown for the first 100 configs.

## rlu_atari_checkpoints/Krull_run_4

*   **Dataset size**: `90.38 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 631
`'checkpoint_01'` | 732
`'checkpoint_02'` | 760
`'checkpoint_03'` | 767
`'checkpoint_04'` | 767
`'checkpoint_05'` | 768
`'checkpoint_06'` | 765
`'checkpoint_07'` | 777
`'checkpoint_08'` | 769
`'checkpoint_09'` | 765
`'checkpoint_10'` | 774
`'checkpoint_11'` | 766
`'checkpoint_12'` | 760
`'checkpoint_13'` | 766
`'checkpoint_14'` | 767
`'checkpoint_15'` | 756
`'checkpoint_16'` | 760
`'checkpoint_17'` | 767
`'checkpoint_18'` | 766
`'checkpoint_19'` | 769
`'checkpoint_20'` | 760
`'checkpoint_21'` | 758
`'checkpoint_22'` | 757
`'checkpoint_23'` | 757
`'checkpoint_24'` | 765
`'checkpoint_25'` | 762
`'checkpoint_26'` | 764
`'checkpoint_27'` | 762
`'checkpoint_28'` | 761
`'checkpoint_29'` | 760
`'checkpoint_30'` | 763
`'checkpoint_31'` | 759
`'checkpoint_32'` | 766
`'checkpoint_33'` | 761
`'checkpoint_34'` | 758
`'checkpoint_35'` | 759
`'checkpoint_36'` | 762
`'checkpoint_37'` | 763
`'checkpoint_38'` | 748
`'checkpoint_39'` | 763
`'checkpoint_40'` | 757
`'checkpoint_41'` | 759
`'checkpoint_42'` | 762
`'checkpoint_43'` | 758
`'checkpoint_44'` | 760
`'checkpoint_45'` | 760
`'checkpoint_46'` | 759
`'checkpoint_47'` | 761
`'checkpoint_48'` | 763
`'checkpoint_49'` | 761

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):
    Only shown for the first 100 configs.

## rlu_atari_checkpoints/Krull_run_5

*   **Dataset size**: `90.39 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 703
`'checkpoint_01'` | 738
`'checkpoint_02'` | 774
`'checkpoint_03'` | 765
`'checkpoint_04'` | 767
`'checkpoint_05'` | 773
`'checkpoint_06'` | 771
`'checkpoint_07'` | 760
`'checkpoint_08'` | 767
`'checkpoint_09'` | 758
`'checkpoint_10'` | 756
`'checkpoint_11'` | 753
`'checkpoint_12'` | 763
`'checkpoint_13'` | 758
`'checkpoint_14'` | 760
`'checkpoint_15'` | 767
`'checkpoint_16'` | 758
`'checkpoint_17'` | 765
`'checkpoint_18'` | 771
`'checkpoint_19'` | 760
`'checkpoint_20'` | 765
`'checkpoint_21'` | 772
`'checkpoint_22'` | 767
`'checkpoint_23'` | 764
`'checkpoint_24'` | 771
`'checkpoint_25'` | 757
`'checkpoint_26'` | 765
`'checkpoint_27'` | 769
`'checkpoint_28'` | 762
`'checkpoint_29'` | 762
`'checkpoint_30'` | 758
`'checkpoint_31'` | 769
`'checkpoint_32'` | 761
`'checkpoint_33'` | 769
`'checkpoint_34'` | 762
`'checkpoint_35'` | 759
`'checkpoint_36'` | 759
`'checkpoint_37'` | 751
`'checkpoint_38'` | 760
`'checkpoint_39'` | 763
`'checkpoint_40'` | 766
`'checkpoint_41'` | 763
`'checkpoint_42'` | 768
`'checkpoint_43'` | 775
`'checkpoint_44'` | 762
`'checkpoint_45'` | 762
`'checkpoint_46'` | 764
`'checkpoint_47'` | 769
`'checkpoint_48'` | 768
`'checkpoint_49'` | 760

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):
    Only shown for the first 100 configs.

## rlu_atari_checkpoints/KungFuMaster_run_1

*   **Dataset size**: `61.89 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 899
`'checkpoint_01'` | 451
`'checkpoint_02'` | 386
`'checkpoint_03'` | 390
`'checkpoint_04'` | 398
`'checkpoint_05'` | 372
`'checkpoint_06'` | 365
`'checkpoint_07'` | 368
`'checkpoint_08'` | 361
`'checkpoint_09'` | 364
`'checkpoint_10'` | 368
`'checkpoint_11'` | 371
`'checkpoint_12'` | 376
`'checkpoint_13'` | 371
`'checkpoint_14'` | 371
`'checkpoint_15'` | 372
`'checkpoint_16'` | 369
`'checkpoint_17'` | 378
`'checkpoint_18'` | 385
`'checkpoint_19'` | 389
`'checkpoint_20'` | 392
`'checkpoint_21'` | 378
`'checkpoint_22'` | 384
`'checkpoint_23'` | 383
`'checkpoint_24'` | 393
`'checkpoint_25'` | 389
`'checkpoint_26'` | 383
`'checkpoint_27'` | 387
`'checkpoint_28'` | 399
`'checkpoint_29'` | 396
`'checkpoint_30'` | 403
`'checkpoint_31'` | 391
`'checkpoint_32'` | 388
`'checkpoint_33'` | 381
`'checkpoint_34'` | 386
`'checkpoint_35'` | 395
`'checkpoint_36'` | 382
`'checkpoint_37'` | 381
`'checkpoint_38'` | 368
`'checkpoint_39'` | 373
`'checkpoint_40'` | 373
`'checkpoint_41'` | 359
`'checkpoint_42'` | 363
`'checkpoint_43'` | 369
`'checkpoint_44'` | 364
`'checkpoint_45'` | 364
`'checkpoint_46'` | 367
`'checkpoint_47'` | 363
`'checkpoint_48'` | 356
`'checkpoint_49'` | 346

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):
    Only shown for the first 100 configs.

## rlu_atari_checkpoints/KungFuMaster_run_2

*   **Dataset size**: `61.74 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 796
`'checkpoint_01'` | 420
`'checkpoint_02'` | 388
`'checkpoint_03'` | 399
`'checkpoint_04'` | 383
`'checkpoint_05'` | 385
`'checkpoint_06'` | 395
`'checkpoint_07'` | 391
`'checkpoint_08'` | 373
`'checkpoint_09'` | 374
`'checkpoint_10'` | 375
`'checkpoint_11'` | 366
`'checkpoint_12'` | 374
`'checkpoint_13'` | 370
`'checkpoint_14'` | 379
`'checkpoint_15'` | 374
`'checkpoint_16'` | 375
`'checkpoint_17'` | 375
`'checkpoint_18'` | 370
`'checkpoint_19'` | 376
`'checkpoint_20'` | 431
`'checkpoint_21'` | 865
`'checkpoint_22'` | 468
`'checkpoint_23'` | 379
`'checkpoint_24'` | 368
`'checkpoint_25'` | 369
`'checkpoint_26'` | 369
`'checkpoint_27'` | 366
`'checkpoint_28'` | 351
`'checkpoint_29'` | 350
`'checkpoint_30'` | 359
`'checkpoint_31'` | 401
`'checkpoint_32'` | 1,109
`'checkpoint_33'` | 949
`'checkpoint_34'` | 887
`'checkpoint_35'` | 623
`'checkpoint_36'` | 462
`'checkpoint_37'` | 408
`'checkpoint_38'` | 342
`'checkpoint_39'` | 321
`'checkpoint_40'` | 319
`'checkpoint_41'` | 328
`'checkpoint_42'` | 320
`'checkpoint_43'` | 314
`'checkpoint_44'` | 325
`'checkpoint_45'` | 314
`'checkpoint_46'` | 301
`'checkpoint_47'` | 311
`'checkpoint_48'` | 312
`'checkpoint_49'` | 308

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):
    Only shown for the first 100 configs.

## rlu_atari_checkpoints/KungFuMaster_run_3

*   **Dataset size**: `61.77 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 770
`'checkpoint_01'` | 410
`'checkpoint_02'` | 396
`'checkpoint_03'` | 377
`'checkpoint_04'` | 381
`'checkpoint_05'` | 377
`'checkpoint_06'` | 380
`'checkpoint_07'` | 378
`'checkpoint_08'` | 369
`'checkpoint_09'` | 367
`'checkpoint_10'` | 359
`'checkpoint_11'` | 359
`'checkpoint_12'` | 360
`'checkpoint_13'` | 365
`'checkpoint_14'` | 354
`'checkpoint_15'` | 366
`'checkpoint_16'` | 359
`'checkpoint_17'` | 364
`'checkpoint_18'` | 367
`'checkpoint_19'` | 359
`'checkpoint_20'` | 365
`'checkpoint_21'` | 371
`'checkpoint_22'` | 390
`'checkpoint_23'` | 458
`'checkpoint_24'` | 414
`'checkpoint_25'` | 382
`'checkpoint_26'` | 370
`'checkpoint_27'` | 388
`'checkpoint_28'` | 722
`'checkpoint_29'` | 644
`'checkpoint_30'` | 801
`'checkpoint_31'` | 509
`'checkpoint_32'` | 444
`'checkpoint_33'` | 403
`'checkpoint_34'` | 399
`'checkpoint_35'` | 395
`'checkpoint_36'` | 380
`'checkpoint_37'` | 388
`'checkpoint_38'` | 386
`'checkpoint_39'` | 380
`'checkpoint_40'` | 381
`'checkpoint_41'` | 390
`'checkpoint_42'` | 377
`'checkpoint_43'` | 384
`'checkpoint_44'` | 377
`'checkpoint_45'` | 374
`'checkpoint_46'` | 380
`'checkpoint_47'` | 368
`'checkpoint_48'` | 381
`'checkpoint_49'` | 373

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):
    Only shown for the first 100 configs.

## rlu_atari_checkpoints/KungFuMaster_run_4

*   **Dataset size**: `62.00 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 848
`'checkpoint_01'` | 430
`'checkpoint_02'` | 380
`'checkpoint_03'` | 366
`'checkpoint_04'` | 372
`'checkpoint_05'` | 376
`'checkpoint_06'` | 360
`'checkpoint_07'` | 363
`'checkpoint_08'` | 358
`'checkpoint_09'` | 370
`'checkpoint_10'` | 370
`'checkpoint_11'` | 369
`'checkpoint_12'` | 378
`'checkpoint_13'` | 367
`'checkpoint_14'` | 363
`'checkpoint_15'` | 364
`'checkpoint_16'` | 370
`'checkpoint_17'` | 366
`'checkpoint_18'` | 362
`'checkpoint_19'` | 374
`'checkpoint_20'` | 377
`'checkpoint_21'` | 378
`'checkpoint_22'` | 376
`'checkpoint_23'` | 368
`'checkpoint_24'` | 389
`'checkpoint_25'` | 391
`'checkpoint_26'` | 376
`'checkpoint_27'` | 378
`'checkpoint_28'` | 363
`'checkpoint_29'` | 365
`'checkpoint_30'` | 366
`'checkpoint_31'` | 355
`'checkpoint_32'` | 348
`'checkpoint_33'` | 358
`'checkpoint_34'` | 360
`'checkpoint_35'` | 355
`'checkpoint_36'` | 349
`'checkpoint_37'` | 354
`'checkpoint_38'` | 345
`'checkpoint_39'` | 341
`'checkpoint_40'` | 333
`'checkpoint_41'` | 341
`'checkpoint_42'` | 351
`'checkpoint_43'` | 354
`'checkpoint_44'` | 346
`'checkpoint_45'` | 356
`'checkpoint_46'` | 351
`'checkpoint_47'` | 355
`'checkpoint_48'` | 353
`'checkpoint_49'` | 362

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):
    Only shown for the first 100 configs.

## rlu_atari_checkpoints/KungFuMaster_run_5

*   **Dataset size**: `61.99 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 839
`'checkpoint_01'` | 441
`'checkpoint_02'` | 412
`'checkpoint_03'` | 401
`'checkpoint_04'` | 402
`'checkpoint_05'` | 392
`'checkpoint_06'` | 382
`'checkpoint_07'` | 376
`'checkpoint_08'` | 368
`'checkpoint_09'` | 368
`'checkpoint_10'` | 373
`'checkpoint_11'` | 380
`'checkpoint_12'` | 377
`'checkpoint_13'` | 379
`'checkpoint_14'` | 371
`'checkpoint_15'` | 374
`'checkpoint_16'` | 381
`'checkpoint_17'` | 381
`'checkpoint_18'` | 371
`'checkpoint_19'` | 366
`'checkpoint_20'` | 377
`'checkpoint_21'` | 370
`'checkpoint_22'` | 365
`'checkpoint_23'` | 362
`'checkpoint_24'` | 355
`'checkpoint_25'` | 355
`'checkpoint_26'` | 347
`'checkpoint_27'` | 346
`'checkpoint_28'` | 356
`'checkpoint_29'` | 346
`'checkpoint_30'` | 346
`'checkpoint_31'` | 351
`'checkpoint_32'` | 347
`'checkpoint_33'` | 344
`'checkpoint_34'` | 339
`'checkpoint_35'` | 344
`'checkpoint_36'` | 347
`'checkpoint_37'` | 332
`'checkpoint_38'` | 340
`'checkpoint_39'` | 336
`'checkpoint_40'` | 342
`'checkpoint_41'` | 348
`'checkpoint_42'` | 348
`'checkpoint_43'` | 347
`'checkpoint_44'` | 338
`'checkpoint_45'` | 336
`'checkpoint_46'` | 352
`'checkpoint_47'` | 349
`'checkpoint_48'` | 344
`'checkpoint_49'` | 337

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):
    Only shown for the first 100 configs.

## rlu_atari_checkpoints/MsPacman_run_1

*   **Dataset size**: `75.55 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 1,473
`'checkpoint_01'` | 1,130
`'checkpoint_02'` | 1,017
`'checkpoint_03'` | 979
`'checkpoint_04'` | 971
`'checkpoint_05'` | 926
`'checkpoint_06'` | 900
`'checkpoint_07'` | 879
`'checkpoint_08'` | 885
`'checkpoint_09'` | 874
`'checkpoint_10'` | 845
`'checkpoint_11'` | 870
`'checkpoint_12'` | 872
`'checkpoint_13'` | 878
`'checkpoint_14'` | 859
`'checkpoint_15'` | 866
`'checkpoint_16'` | 851
`'checkpoint_17'` | 829
`'checkpoint_18'` | 843
`'checkpoint_19'` | 816
`'checkpoint_20'` | 781
`'checkpoint_21'` | 817
`'checkpoint_22'` | 800
`'checkpoint_23'` | 784
`'checkpoint_24'` | 767
`'checkpoint_25'` | 766
`'checkpoint_26'` | 726
`'checkpoint_27'` | 760
`'checkpoint_28'` | 756
`'checkpoint_29'` | 753
`'checkpoint_30'` | 763
`'checkpoint_31'` | 740
`'checkpoint_32'` | 759
`'checkpoint_33'` | 769
`'checkpoint_34'` | 771
`'checkpoint_35'` | 778
`'checkpoint_36'` | 781
`'checkpoint_37'` | 765
`'checkpoint_38'` | 767
`'checkpoint_39'` | 781
`'checkpoint_40'` | 807
`'checkpoint_41'` | 790
`'checkpoint_42'` | 815
`'checkpoint_43'` | 819
`'checkpoint_44'` | 801
`'checkpoint_45'` | 775
`'checkpoint_46'` | 786
`'checkpoint_47'` | 831
`'checkpoint_48'` | 792
`'checkpoint_49'` | 812

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):
    Only shown for the first 100 configs.

## rlu_atari_checkpoints/MsPacman_run_2

*   **Dataset size**: `75.64 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 1,464
`'checkpoint_01'` | 1,140
`'checkpoint_02'` | 1,023
`'checkpoint_03'` | 989
`'checkpoint_04'` | 989
`'checkpoint_05'` | 967
`'checkpoint_06'` | 959
`'checkpoint_07'` | 951
`'checkpoint_08'` | 936
`'checkpoint_09'` | 928
`'checkpoint_10'` | 937
`'checkpoint_11'` | 912
`'checkpoint_12'` | 887
`'checkpoint_13'` | 870
`'checkpoint_14'` | 875
`'checkpoint_15'` | 851
`'checkpoint_16'` | 824
`'checkpoint_17'` | 835
`'checkpoint_18'` | 804
`'checkpoint_19'` | 791
`'checkpoint_20'` | 767
`'checkpoint_21'` | 773
`'checkpoint_22'` | 802
`'checkpoint_23'` | 784
`'checkpoint_24'` | 813
`'checkpoint_25'` | 801
`'checkpoint_26'` | 803
`'checkpoint_27'` | 808
`'checkpoint_28'` | 796
`'checkpoint_29'` | 768
`'checkpoint_30'` | 788
`'checkpoint_31'` | 766
`'checkpoint_32'` | 774
`'checkpoint_33'` | 824
`'checkpoint_34'` | 786
`'checkpoint_35'` | 781
`'checkpoint_36'` | 775
`'checkpoint_37'` | 772
`'checkpoint_38'` | 776
`'checkpoint_39'` | 738
`'checkpoint_40'` | 786
`'checkpoint_41'` | 752
`'checkpoint_42'` | 769
`'checkpoint_43'` | 756
`'checkpoint_44'` | 778
`'checkpoint_45'` | 728
`'checkpoint_46'` | 752
`'checkpoint_47'` | 806
`'checkpoint_48'` | 769
`'checkpoint_49'` | 759

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):
    Only shown for the first 100 configs.

## rlu_atari_checkpoints/MsPacman_run_3

*   **Dataset size**: `75.75 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 1,476
`'checkpoint_01'` | 1,138
`'checkpoint_02'` | 1,039
`'checkpoint_03'` | 1,027
`'checkpoint_04'` | 1,014
`'checkpoint_05'` | 964
`'checkpoint_06'` | 948
`'checkpoint_07'` | 918
`'checkpoint_08'` | 928
`'checkpoint_09'` | 918
`'checkpoint_10'` | 898
`'checkpoint_11'` | 862
`'checkpoint_12'` | 867
`'checkpoint_13'` | 846
`'checkpoint_14'` | 843
`'checkpoint_15'` | 841
`'checkpoint_16'` | 826
`'checkpoint_17'` | 844
`'checkpoint_18'` | 832
`'checkpoint_19'` | 812
`'checkpoint_20'` | 768
`'checkpoint_21'` | 782
`'checkpoint_22'` | 816
`'checkpoint_23'` | 779
`'checkpoint_24'` | 795
`'checkpoint_25'` | 755
`'checkpoint_26'` | 749
`'checkpoint_27'` | 768
`'checkpoint_28'` | 784
`'checkpoint_29'` | 749
`'checkpoint_30'` | 760
`'checkpoint_31'` | 762
`'checkpoint_32'` | 754
`'checkpoint_33'` | 765
`'checkpoint_34'` | 716
`'checkpoint_35'` | 756
`'checkpoint_36'` | 745
`'checkpoint_37'` | 735
`'checkpoint_38'` | 737
`'checkpoint_39'` | 730
`'checkpoint_40'` | 754
`'checkpoint_41'` | 721
`'checkpoint_42'` | 724
`'checkpoint_43'` | 721
`'checkpoint_44'` | 711
`'checkpoint_45'` | 705
`'checkpoint_46'` | 733
`'checkpoint_47'` | 737
`'checkpoint_48'` | 701
`'checkpoint_49'` | 736

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):
    Only shown for the first 100 configs.

## rlu_atari_checkpoints/MsPacman_run_4

*   **Dataset size**: `75.39 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 1,473
`'checkpoint_01'` | 1,146
`'checkpoint_02'` | 1,059
`'checkpoint_03'` | 1,031
`'checkpoint_04'` | 1,028
`'checkpoint_05'` | 986
`'checkpoint_06'` | 976
`'checkpoint_07'` | 942
`'checkpoint_08'` | 951
`'checkpoint_09'` | 911
`'checkpoint_10'` | 903
`'checkpoint_11'` | 888
`'checkpoint_12'` | 873
`'checkpoint_13'` | 836
`'checkpoint_14'` | 852
`'checkpoint_15'` | 833
`'checkpoint_16'` | 809
`'checkpoint_17'` | 824
`'checkpoint_18'` | 817
`'checkpoint_19'` | 815
`'checkpoint_20'` | 818
`'checkpoint_21'` | 806
`'checkpoint_22'` | 785
`'checkpoint_23'` | 801
`'checkpoint_24'` | 790
`'checkpoint_25'` | 784
`'checkpoint_26'` | 787
`'checkpoint_27'` | 788
`'checkpoint_28'` | 778
`'checkpoint_29'` | 764
`'checkpoint_30'` | 775
`'checkpoint_31'` | 770
`'checkpoint_32'` | 777
`'checkpoint_33'` | 789
`'checkpoint_34'` | 759
`'checkpoint_35'` | 756
`'checkpoint_36'` | 754
`'checkpoint_37'` | 785
`'checkpoint_38'` | 754
`'checkpoint_39'` | 764
`'checkpoint_40'` | 755
`'checkpoint_41'` | 732
`'checkpoint_42'` | 743
`'checkpoint_43'` | 745
`'checkpoint_44'` | 761
`'checkpoint_45'` | 752
`'checkpoint_46'` | 730
`'checkpoint_47'` | 742
`'checkpoint_48'` | 746
`'checkpoint_49'` | 740

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):
    Only shown for the first 100 configs.

## rlu_atari_checkpoints/MsPacman_run_5

*   **Dataset size**: `75.43 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 1,469
`'checkpoint_01'` | 1,083
`'checkpoint_02'` | 1,034
`'checkpoint_03'` | 1,014
`'checkpoint_04'` | 978
`'checkpoint_05'` | 944
`'checkpoint_06'` | 946
`'checkpoint_07'` | 927
`'checkpoint_08'` | 896
`'checkpoint_09'` | 901
`'checkpoint_10'` | 901
`'checkpoint_11'` | 913
`'checkpoint_12'` | 892
`'checkpoint_13'` | 910
`'checkpoint_14'` | 865
`'checkpoint_15'` | 882
`'checkpoint_16'` | 872
`'checkpoint_17'` | 861
`'checkpoint_18'` | 855
`'checkpoint_19'` | 864
`'checkpoint_20'` | 903
`'checkpoint_21'` | 874
`'checkpoint_22'` | 884
`'checkpoint_23'` | 882
`'checkpoint_24'` | 860
`'checkpoint_25'` | 896
`'checkpoint_26'` | 816
`'checkpoint_27'` | 842
`'checkpoint_28'` | 797
`'checkpoint_29'` | 792
`'checkpoint_30'` | 788
`'checkpoint_31'` | 799
`'checkpoint_32'` | 778
`'checkpoint_33'` | 766
`'checkpoint_34'` | 759
`'checkpoint_35'` | 787
`'checkpoint_36'` | 767
`'checkpoint_37'` | 740
`'checkpoint_38'` | 784
`'checkpoint_39'` | 756
`'checkpoint_40'` | 766
`'checkpoint_41'` | 755
`'checkpoint_42'` | 729
`'checkpoint_43'` | 759
`'checkpoint_44'` | 761
`'checkpoint_45'` | 762
`'checkpoint_46'` | 778
`'checkpoint_47'` | 745
`'checkpoint_48'` | 751
`'checkpoint_49'` | 748

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):
    Only shown for the first 100 configs.

## rlu_atari_checkpoints/NameThisGame_run_1

*   **Dataset size**: `60.81 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 428
`'checkpoint_01'` | 305
`'checkpoint_02'` | 292
`'checkpoint_03'` | 279
`'checkpoint_04'` | 257
`'checkpoint_05'` | 258
`'checkpoint_06'` | 261
`'checkpoint_07'` | 252
`'checkpoint_08'` | 249
`'checkpoint_09'` | 251
`'checkpoint_10'` | 251
`'checkpoint_11'` | 255
`'checkpoint_12'` | 252
`'checkpoint_13'` | 233
`'checkpoint_14'` | 243
`'checkpoint_15'` | 234
`'checkpoint_16'` | 228
`'checkpoint_17'` | 220
`'checkpoint_18'` | 221
`'checkpoint_19'` | 221
`'checkpoint_20'` | 228
`'checkpoint_21'` | 220
`'checkpoint_22'` | 213
`'checkpoint_23'` | 205
`'checkpoint_24'` | 207
`'checkpoint_25'` | 204
`'checkpoint_26'` | 207
`'checkpoint_27'` | 207
`'checkpoint_28'` | 206
`'checkpoint_29'` | 202
`'checkpoint_30'` | 206
`'checkpoint_31'` | 198
`'checkpoint_32'` | 203
`'checkpoint_33'` | 197
`'checkpoint_34'` | 206
`'checkpoint_35'` | 201
`'checkpoint_36'` | 203
`'checkpoint_37'` | 206
`'checkpoint_38'` | 198
`'checkpoint_39'` | 200
`'checkpoint_40'` | 201
`'checkpoint_41'` | 198
`'checkpoint_42'` | 200
`'checkpoint_43'` | 198
`'checkpoint_44'` | 201
`'checkpoint_45'` | 202
`'checkpoint_46'` | 202
`'checkpoint_47'` | 199
`'checkpoint_48'` | 195
`'checkpoint_49'` | 200

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):
    Only shown for the first 100 configs.

## rlu_atari_checkpoints/NameThisGame_run_2

*   **Dataset size**: `60.87 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 403
`'checkpoint_01'` | 288
`'checkpoint_02'` | 308
`'checkpoint_03'` | 309
`'checkpoint_04'` | 289
`'checkpoint_05'` | 269
`'checkpoint_06'` | 266
`'checkpoint_07'` | 279
`'checkpoint_08'` | 265
`'checkpoint_09'` | 263
`'checkpoint_10'` | 256
`'checkpoint_11'` | 258
`'checkpoint_12'` | 250
`'checkpoint_13'` | 252
`'checkpoint_14'` | 233
`'checkpoint_15'` | 228
`'checkpoint_16'` | 227
`'checkpoint_17'` | 229
`'checkpoint_18'` | 226
`'checkpoint_19'` | 215
`'checkpoint_20'` | 221
`'checkpoint_21'` | 217
`'checkpoint_22'` | 211
`'checkpoint_23'` | 210
`'checkpoint_24'` | 203
`'checkpoint_25'` | 210
`'checkpoint_26'` | 209
`'checkpoint_27'` | 207
`'checkpoint_28'` | 205
`'checkpoint_29'` | 208
`'checkpoint_30'` | 210
`'checkpoint_31'` | 209
`'checkpoint_32'` | 204
`'checkpoint_33'` | 204
`'checkpoint_34'` | 203
`'checkpoint_35'` | 208
`'checkpoint_36'` | 205
`'checkpoint_37'` | 208
`'checkpoint_38'` | 204
`'checkpoint_39'` | 208
`'checkpoint_40'` | 198
`'checkpoint_41'` | 201
`'checkpoint_42'` | 204
`'checkpoint_43'` | 203
`'checkpoint_44'` | 202
`'checkpoint_45'` | 201
`'checkpoint_46'` | 207
`'checkpoint_47'` | 207
`'checkpoint_48'` | 200
`'checkpoint_49'` | 206

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):
    Only shown for the first 100 configs.

## rlu_atari_checkpoints/NameThisGame_run_3

*   **Dataset size**: `60.68 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 403
`'checkpoint_01'` | 297
`'checkpoint_02'` | 305
`'checkpoint_03'` | 307
`'checkpoint_04'` | 280
`'checkpoint_05'` | 272
`'checkpoint_06'` | 262
`'checkpoint_07'` | 272
`'checkpoint_08'` | 273
`'checkpoint_09'` | 261
`'checkpoint_10'` | 257
`'checkpoint_11'` | 247
`'checkpoint_12'` | 246
`'checkpoint_13'` | 242
`'checkpoint_14'` | 231
`'checkpoint_15'` | 233
`'checkpoint_16'` | 232
`'checkpoint_17'` | 230
`'checkpoint_18'` | 230
`'checkpoint_19'` | 216
`'checkpoint_20'` | 217
`'checkpoint_21'` | 215
`'checkpoint_22'` | 210
`'checkpoint_23'` | 208
`'checkpoint_24'` | 201
`'checkpoint_25'` | 199
`'checkpoint_26'` | 197
`'checkpoint_27'` | 202
`'checkpoint_28'` | 198
`'checkpoint_29'` | 199
`'checkpoint_30'` | 201
`'checkpoint_31'` | 199
`'checkpoint_32'` | 193
`'checkpoint_33'` | 198
`'checkpoint_34'` | 193
`'checkpoint_35'` | 194
`'checkpoint_36'` | 199
`'checkpoint_37'` | 196
`'checkpoint_38'` | 195
`'checkpoint_39'` | 192
`'checkpoint_40'` | 195
`'checkpoint_41'` | 194
`'checkpoint_42'` | 194
`'checkpoint_43'` | 190
`'checkpoint_44'` | 196
`'checkpoint_45'` | 198
`'checkpoint_46'` | 200
`'checkpoint_47'` | 198
`'checkpoint_48'` | 194
`'checkpoint_49'` | 199

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):
    Only shown for the first 100 configs.

## rlu_atari_checkpoints/NameThisGame_run_4

*   **Dataset size**: `60.97 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 413
`'checkpoint_01'` | 303
`'checkpoint_02'` | 319
`'checkpoint_03'` | 303
`'checkpoint_04'` | 269
`'checkpoint_05'` | 273
`'checkpoint_06'` | 260
`'checkpoint_07'` | 267
`'checkpoint_08'` | 258
`'checkpoint_09'` | 265
`'checkpoint_10'` | 260
`'checkpoint_11'` | 271
`'checkpoint_12'` | 272
`'checkpoint_13'` | 261
`'checkpoint_14'` | 254
`'checkpoint_15'` | 261
`'checkpoint_16'` | 258
`'checkpoint_17'` | 258
`'checkpoint_18'` | 256
`'checkpoint_19'` | 251
`'checkpoint_20'` | 243
`'checkpoint_21'` | 241
`'checkpoint_22'` | 241
`'checkpoint_23'` | 244
`'checkpoint_24'` | 241
`'checkpoint_25'` | 232
`'checkpoint_26'` | 225
`'checkpoint_27'` | 230
`'checkpoint_28'` | 230
`'checkpoint_29'` | 224
`'checkpoint_30'` | 229
`'checkpoint_31'` | 227
`'checkpoint_32'` | 225
`'checkpoint_33'` | 217
`'checkpoint_34'` | 214
`'checkpoint_35'` | 213
`'checkpoint_36'` | 215
`'checkpoint_37'` | 215
`'checkpoint_38'` | 215
`'checkpoint_39'` | 217
`'checkpoint_40'` | 224
`'checkpoint_41'` | 216
`'checkpoint_42'` | 219
`'checkpoint_43'` | 225
`'checkpoint_44'` | 219
`'checkpoint_45'` | 214
`'checkpoint_46'` | 221
`'checkpoint_47'` | 214
`'checkpoint_48'` | 220
`'checkpoint_49'` | 217

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):
    Only shown for the first 100 configs.

## rlu_atari_checkpoints/NameThisGame_run_5

*   **Dataset size**: `61.11 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 403
`'checkpoint_01'` | 297
`'checkpoint_02'` | 293
`'checkpoint_03'` | 329
`'checkpoint_04'` | 305
`'checkpoint_05'` | 299
`'checkpoint_06'` | 292
`'checkpoint_07'` | 277
`'checkpoint_08'` | 280
`'checkpoint_09'` | 286
`'checkpoint_10'` | 272
`'checkpoint_11'` | 264
`'checkpoint_12'` | 273
`'checkpoint_13'` | 260
`'checkpoint_14'` | 260
`'checkpoint_15'` | 264
`'checkpoint_16'` | 256
`'checkpoint_17'` | 243
`'checkpoint_18'` | 242
`'checkpoint_19'` | 239
`'checkpoint_20'` | 241
`'checkpoint_21'` | 239
`'checkpoint_22'` | 236
`'checkpoint_23'` | 235
`'checkpoint_24'` | 231
`'checkpoint_25'` | 235
`'checkpoint_26'` | 236
`'checkpoint_27'` | 236
`'checkpoint_28'` | 229
`'checkpoint_29'` | 232
`'checkpoint_30'` | 237
`'checkpoint_31'` | 232
`'checkpoint_32'` | 234
`'checkpoint_33'` | 227
`'checkpoint_34'` | 227
`'checkpoint_35'` | 229
`'checkpoint_36'` | 224
`'checkpoint_37'` | 222
`'checkpoint_38'` | 231
`'checkpoint_39'` | 223
`'checkpoint_40'` | 233
`'checkpoint_41'` | 227
`'checkpoint_42'` | 230
`'checkpoint_43'` | 223
`'checkpoint_44'` | 221
`'checkpoint_45'` | 218
`'checkpoint_46'` | 217
`'checkpoint_47'` | 217
`'checkpoint_48'` | 215
`'checkpoint_49'` | 212

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):
    Only shown for the first 100 configs.

## rlu_atari_checkpoints/Phoenix_run_1

*   **Dataset size**: `27.14 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 1,319
`'checkpoint_01'` | 812
`'checkpoint_02'` | 309
`'checkpoint_03'` | 372
`'checkpoint_04'` | 441
`'checkpoint_05'` | 529
`'checkpoint_06'` | 461
`'checkpoint_07'` | 449
`'checkpoint_08'` | 492
`'checkpoint_09'` | 438
`'checkpoint_10'` | 509
`'checkpoint_11'` | 434
`'checkpoint_12'` | 541
`'checkpoint_13'` | 522
`'checkpoint_14'` | 558
`'checkpoint_15'` | 576
`'checkpoint_16'` | 575
`'checkpoint_17'` | 610
`'checkpoint_18'` | 615
`'checkpoint_19'` | 638
`'checkpoint_20'` | 628
`'checkpoint_21'` | 630
`'checkpoint_22'` | 563
`'checkpoint_23'` | 585
`'checkpoint_24'` | 627
`'checkpoint_25'` | 633
`'checkpoint_26'` | 689
`'checkpoint_27'` | 684
`'checkpoint_28'` | 706
`'checkpoint_29'` | 669
`'checkpoint_30'` | 648
`'checkpoint_31'` | 668
`'checkpoint_32'` | 685
`'checkpoint_33'` | 596
`'checkpoint_34'` | 628
`'checkpoint_35'` | 651
`'checkpoint_36'` | 594
`'checkpoint_37'` | 608
`'checkpoint_38'` | 590
`'checkpoint_39'` | 602
`'checkpoint_40'` | 617
`'checkpoint_41'` | 660
`'checkpoint_42'` | 610
`'checkpoint_43'` | 595
`'checkpoint_44'` | 597
`'checkpoint_45'` | 631
`'checkpoint_46'` | 672
`'checkpoint_47'` | 665
`'checkpoint_48'` | 639
`'checkpoint_49'` | 671

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):
    Only shown for the first 100 configs.

## rlu_atari_checkpoints/Phoenix_run_2

*   **Dataset size**: `27.27 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 1,246
`'checkpoint_01'` | 569
`'checkpoint_02'` | 226
`'checkpoint_03'` | 452
`'checkpoint_04'` | 344
`'checkpoint_05'` | 402
`'checkpoint_06'` | 323
`'checkpoint_07'` | 390
`'checkpoint_08'` | 477
`'checkpoint_09'` | 470
`'checkpoint_10'` | 498
`'checkpoint_11'` | 521
`'checkpoint_12'` | 384
`'checkpoint_13'` | 527
`'checkpoint_14'` | 530
`'checkpoint_15'` | 641
`'checkpoint_16'` | 674
`'checkpoint_17'` | 606
`'checkpoint_18'` | 615
`'checkpoint_19'` | 600
`'checkpoint_20'` | 574
`'checkpoint_21'` | 541
`'checkpoint_22'` | 618
`'checkpoint_23'` | 568
`'checkpoint_24'` | 541
`'checkpoint_25'` | 511
`'checkpoint_26'` | 523
`'checkpoint_27'` | 601
`'checkpoint_28'` | 617
`'checkpoint_29'` | 544
`'checkpoint_30'` | 643
`'checkpoint_31'` | 619
`'checkpoint_32'` | 661
`'checkpoint_33'` | 675
`'checkpoint_34'` | 641
`'checkpoint_35'` | 604
`'checkpoint_36'` | 457
`'checkpoint_37'` | 576
`'checkpoint_38'` | 541
`'checkpoint_39'` | 604
`'checkpoint_40'` | 538
`'checkpoint_41'` | 542
`'checkpoint_42'` | 523
`'checkpoint_43'` | 532
`'checkpoint_44'` | 537
`'checkpoint_45'` | 487
`'checkpoint_46'` | 548
`'checkpoint_47'` | 522
`'checkpoint_48'` | 537
`'checkpoint_49'` | 551

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):
    Only shown for the first 100 configs.

## rlu_atari_checkpoints/Phoenix_run_3

*   **Dataset size**: `27.63 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 1,260
`'checkpoint_01'` | 596
`'checkpoint_02'` | 264
`'checkpoint_03'` | 361
`'checkpoint_04'` | 446
`'checkpoint_05'` | 397
`'checkpoint_06'` | 483
`'checkpoint_07'` | 501
`'checkpoint_08'` | 462
`'checkpoint_09'` | 433
`'checkpoint_10'` | 557
`'checkpoint_11'` | 521
`'checkpoint_12'` | 603
`'checkpoint_13'` | 592
`'checkpoint_14'` | 567
`'checkpoint_15'` | 596
`'checkpoint_16'` | 637
`'checkpoint_17'` | 687
`'checkpoint_18'` | 650
`'checkpoint_19'` | 607
`'checkpoint_20'` | 618
`'checkpoint_21'` | 519
`'checkpoint_22'` | 401
`'checkpoint_23'` | 538
`'checkpoint_24'` | 555
`'checkpoint_25'` | 599
`'checkpoint_26'` | 391
`'checkpoint_27'` | 415
`'checkpoint_28'` | 425
`'checkpoint_29'` | 579
`'checkpoint_30'` | 481
`'checkpoint_31'` | 559
`'checkpoint_32'` | 584
`'checkpoint_33'` | 462
`'checkpoint_34'` | 436
`'checkpoint_35'` | 637
`'checkpoint_36'` | 619
`'checkpoint_37'` | 542
`'checkpoint_38'` | 501
`'checkpoint_39'` | 533
`'checkpoint_40'` | 552
`'checkpoint_41'` | 572
`'checkpoint_42'` | 601
`'checkpoint_43'` | 598
`'checkpoint_44'` | 565
`'checkpoint_45'` | 539
`'checkpoint_46'` | 618
`'checkpoint_47'` | 614
`'checkpoint_48'` | 608
`'checkpoint_49'` | 536

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):
    Only shown for the first 100 configs.

## rlu_atari_checkpoints/Phoenix_run_4

*   **Dataset size**: `27.22 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 1,330
`'checkpoint_01'` | 494
`'checkpoint_02'` | 187
`'checkpoint_03'` | 395
`'checkpoint_04'` | 381
`'checkpoint_05'` | 382
`'checkpoint_06'` | 342
`'checkpoint_07'` | 418
`'checkpoint_08'` | 439
`'checkpoint_09'` | 392
`'checkpoint_10'` | 418
`'checkpoint_11'` | 412
`'checkpoint_12'` | 506
`'checkpoint_13'` | 506
`'checkpoint_14'` | 580
`'checkpoint_15'` | 541
`'checkpoint_16'` | 428
`'checkpoint_17'` | 552
`'checkpoint_18'` | 602
`'checkpoint_19'` | 652
`'checkpoint_20'` | 689
`'checkpoint_21'` | 686
`'checkpoint_22'` | 714
`'checkpoint_23'` | 708
`'checkpoint_24'` | 699
`'checkpoint_25'` | 692
`'checkpoint_26'` | 708
`'checkpoint_27'` | 694
`'checkpoint_28'` | 602
`'checkpoint_29'` | 666
`'checkpoint_30'` | 649
`'checkpoint_31'` | 650
`'checkpoint_32'` | 589
`'checkpoint_33'` | 622
`'checkpoint_34'` | 571
`'checkpoint_35'` | 650
`'checkpoint_36'` | 723
`'checkpoint_37'` | 714
`'checkpoint_38'` | 702
`'checkpoint_39'` | 659
`'checkpoint_40'` | 655
`'checkpoint_41'` | 656
`'checkpoint_42'` | 672
`'checkpoint_43'` | 716
`'checkpoint_44'` | 582
`'checkpoint_45'` | 732
`'checkpoint_46'` | 724
`'checkpoint_47'` | 727
`'checkpoint_48'` | 670
`'checkpoint_49'` | 685

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):
    Only shown for the first 100 configs.

## rlu_atari_checkpoints/Phoenix_run_5

*   **Dataset size**: `27.16 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 1,310
`'checkpoint_01'` | 570
`'checkpoint_02'` | 275
`'checkpoint_03'` | 469
`'checkpoint_04'` | 435
`'checkpoint_05'` | 470
`'checkpoint_06'` | 463
`'checkpoint_07'` | 502
`'checkpoint_08'` | 480
`'checkpoint_09'` | 467
`'checkpoint_10'` | 542
`'checkpoint_11'` | 536
`'checkpoint_12'` | 581
`'checkpoint_13'` | 536
`'checkpoint_14'` | 574
`'checkpoint_15'` | 541
`'checkpoint_16'` | 564
`'checkpoint_17'` | 445
`'checkpoint_18'` | 553
`'checkpoint_19'` | 660
`'checkpoint_20'` | 550
`'checkpoint_21'` | 585
`'checkpoint_22'` | 611
`'checkpoint_23'` | 613
`'checkpoint_24'` | 706
`'checkpoint_25'` | 685
`'checkpoint_26'` | 683
`'checkpoint_27'` | 687
`'checkpoint_28'` | 749
`'checkpoint_29'` | 758
`'checkpoint_30'` | 719
`'checkpoint_31'` | 735
`'checkpoint_32'` | 715
`'checkpoint_33'` | 655
`'checkpoint_34'` | 758
`'checkpoint_35'` | 734
`'checkpoint_36'` | 743
`'checkpoint_37'` | 711
`'checkpoint_38'` | 728
`'checkpoint_39'` | 674
`'checkpoint_40'` | 592
`'checkpoint_41'` | 578
`'checkpoint_42'` | 632
`'checkpoint_43'` | 638
`'checkpoint_44'` | 666
`'checkpoint_45'` | 597
`'checkpoint_46'` | 665
`'checkpoint_47'` | 685
`'checkpoint_48'` | 669
`'checkpoint_49'` | 687

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):
    Only shown for the first 100 configs.

## rlu_atari_checkpoints/Pong_run_1

*   **Dataset size**: `20.86 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 706
`'checkpoint_01'` | 339
`'checkpoint_02'` | 269
`'checkpoint_03'` | 271
`'checkpoint_04'` | 340
`'checkpoint_05'` | 375
`'checkpoint_06'` | 393
`'checkpoint_07'` | 431
`'checkpoint_08'` | 450
`'checkpoint_09'` | 470
`'checkpoint_10'` | 475
`'checkpoint_11'` | 485
`'checkpoint_12'` | 485
`'checkpoint_13'` | 478
`'checkpoint_14'` | 485
`'checkpoint_15'` | 478
`'checkpoint_16'` | 485
`'checkpoint_17'` | 488
`'checkpoint_18'` | 491
`'checkpoint_19'` | 491
`'checkpoint_20'` | 492
`'checkpoint_21'` | 492
`'checkpoint_22'` | 493
`'checkpoint_23'` | 497
`'checkpoint_24'` | 489
`'checkpoint_25'` | 477
`'checkpoint_26'` | 468
`'checkpoint_27'` | 471
`'checkpoint_28'` | 490
`'checkpoint_29'` | 481
`'checkpoint_30'` | 466
`'checkpoint_31'` | 468
`'checkpoint_32'` | 471
`'checkpoint_33'` | 466
`'checkpoint_34'` | 467
`'checkpoint_35'` | 466
`'checkpoint_36'` | 469
`'checkpoint_37'` | 473
`'checkpoint_38'` | 473
`'checkpoint_39'` | 477
`'checkpoint_40'` | 478
`'checkpoint_41'` | 483
`'checkpoint_42'` | 486
`'checkpoint_43'` | 476
`'checkpoint_44'` | 476
`'checkpoint_45'` | 482
`'checkpoint_46'` | 482
`'checkpoint_47'` | 482
`'checkpoint_48'` | 483
`'checkpoint_49'` | 480

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):
    Only shown for the first 100 configs.

## rlu_atari_checkpoints/Pong_run_2

*   **Dataset size**: `21.13 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 679
`'checkpoint_01'` | 295
`'checkpoint_02'` | 222
`'checkpoint_03'` | 231
`'checkpoint_04'` | 245
`'checkpoint_05'` | 263
`'checkpoint_06'` | 279
`'checkpoint_07'` | 292
`'checkpoint_08'` | 311
`'checkpoint_09'` | 319
`'checkpoint_10'` | 324
`'checkpoint_11'` | 318
`'checkpoint_12'` | 335
`'checkpoint_13'` | 322
`'checkpoint_14'` | 328
`'checkpoint_15'` | 331
`'checkpoint_16'` | 321
`'checkpoint_17'` | 328
`'checkpoint_18'` | 344
`'checkpoint_19'` | 332
`'checkpoint_20'` | 338
`'checkpoint_21'` | 332
`'checkpoint_22'` | 346
`'checkpoint_23'` | 339
`'checkpoint_24'` | 339
`'checkpoint_25'` | 329
`'checkpoint_26'` | 328
`'checkpoint_27'` | 335
`'checkpoint_28'` | 350
`'checkpoint_29'` | 345
`'checkpoint_30'` | 346
`'checkpoint_31'` | 344
`'checkpoint_32'` | 336
`'checkpoint_33'` | 340
`'checkpoint_34'` | 341
`'checkpoint_35'` | 345
`'checkpoint_36'` | 354
`'checkpoint_37'` | 359
`'checkpoint_38'` | 353
`'checkpoint_39'` | 355
`'checkpoint_40'` | 359
`'checkpoint_41'` | 358
`'checkpoint_42'` | 360
`'checkpoint_43'` | 358
`'checkpoint_44'` | 359
`'checkpoint_45'` | 363
`'checkpoint_46'` | 351
`'checkpoint_47'` | 359
`'checkpoint_48'` | 360
`'checkpoint_49'` | 362

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):
    Only shown for the first 100 configs.

## rlu_atari_checkpoints/Pong_run_3

*   **Dataset size**: `21.09 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 762
`'checkpoint_01'` | 296
`'checkpoint_02'` | 302
`'checkpoint_03'` | 290
`'checkpoint_04'` | 322
`'checkpoint_05'` | 348
`'checkpoint_06'` | 364
`'checkpoint_07'` | 371
`'checkpoint_08'` | 369
`'checkpoint_09'` | 379
`'checkpoint_10'` | 377
`'checkpoint_11'` | 371
`'checkpoint_12'` | 372
`'checkpoint_13'` | 384
`'checkpoint_14'` | 374
`'checkpoint_15'` | 377
`'checkpoint_16'` | 379
`'checkpoint_17'` | 376
`'checkpoint_18'` | 384
`'checkpoint_19'` | 386
`'checkpoint_20'` | 388
`'checkpoint_21'` | 384
`'checkpoint_22'` | 380
`'checkpoint_23'` | 368
`'checkpoint_24'` | 376
`'checkpoint_25'` | 379
`'checkpoint_26'` | 378
`'checkpoint_27'` | 365
`'checkpoint_28'` | 373
`'checkpoint_29'` | 361
`'checkpoint_30'` | 379
`'checkpoint_31'` | 378
`'checkpoint_32'` | 371
`'checkpoint_33'` | 371
`'checkpoint_34'` | 367
`'checkpoint_35'` | 385
`'checkpoint_36'` | 389
`'checkpoint_37'` | 375
`'checkpoint_38'` | 373
`'checkpoint_39'` | 375
`'checkpoint_40'` | 371
`'checkpoint_41'` | 374
`'checkpoint_42'` | 356
`'checkpoint_43'` | 335
`'checkpoint_44'` | 338
`'checkpoint_45'` | 338
`'checkpoint_46'` | 340
`'checkpoint_47'` | 346
`'checkpoint_48'` | 345
`'checkpoint_49'` | 352

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):
    Only shown for the first 100 configs.

## rlu_atari_checkpoints/Pong_run_4

*   **Dataset size**: `21.11 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 693
`'checkpoint_01'` | 264
`'checkpoint_02'` | 186
`'checkpoint_03'` | 175
`'checkpoint_04'` | 227
`'checkpoint_05'` | 236
`'checkpoint_06'` | 241
`'checkpoint_07'` | 243
`'checkpoint_08'` | 258
`'checkpoint_09'` | 281
`'checkpoint_10'` | 281
`'checkpoint_11'` | 289
`'checkpoint_12'` | 287
`'checkpoint_13'` | 302
`'checkpoint_14'` | 314
`'checkpoint_15'` | 317
`'checkpoint_16'` | 312
`'checkpoint_17'` | 324
`'checkpoint_18'` | 336
`'checkpoint_19'` | 343
`'checkpoint_20'` | 348
`'checkpoint_21'` | 348
`'checkpoint_22'` | 360
`'checkpoint_23'` | 368
`'checkpoint_24'` | 365
`'checkpoint_25'` | 368
`'checkpoint_26'` | 366
`'checkpoint_27'` | 360
`'checkpoint_28'` | 362
`'checkpoint_29'` | 383
`'checkpoint_30'` | 381
`'checkpoint_31'` | 382
`'checkpoint_32'` | 380
`'checkpoint_33'` | 379
`'checkpoint_34'` | 381
`'checkpoint_35'` | 375
`'checkpoint_36'` | 376
`'checkpoint_37'` | 378
`'checkpoint_38'` | 378
`'checkpoint_39'` | 380
`'checkpoint_40'` | 380
`'checkpoint_41'` | 373
`'checkpoint_42'` | 378
`'checkpoint_43'` | 381
`'checkpoint_44'` | 379
`'checkpoint_45'` | 380
`'checkpoint_46'` | 372
`'checkpoint_47'` | 370
`'checkpoint_48'` | 386
`'checkpoint_49'` | 386

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):
    Only shown for the first 100 configs.

## rlu_atari_checkpoints/Pong_run_5

*   **Dataset size**: `20.90 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 732
`'checkpoint_01'` | 339
`'checkpoint_02'` | 271
`'checkpoint_03'` | 293
`'checkpoint_04'` | 335
`'checkpoint_05'` | 357
`'checkpoint_06'` | 383
`'checkpoint_07'` | 400
`'checkpoint_08'` | 415
`'checkpoint_09'` | 434
`'checkpoint_10'` | 446
`'checkpoint_11'` | 443
`'checkpoint_12'` | 456
`'checkpoint_13'` | 458
`'checkpoint_14'` | 456
`'checkpoint_15'` | 468
`'checkpoint_16'` | 466
`'checkpoint_17'` | 462
`'checkpoint_18'` | 474
`'checkpoint_19'` | 475
`'checkpoint_20'` | 472
`'checkpoint_21'` | 474
`'checkpoint_22'` | 474
`'checkpoint_23'` | 479
`'checkpoint_24'` | 478
`'checkpoint_25'` | 474
`'checkpoint_26'` | 484
`'checkpoint_27'` | 485
`'checkpoint_28'` | 480
`'checkpoint_29'` | 483
`'checkpoint_30'` | 486
`'checkpoint_31'` | 488
`'checkpoint_32'` | 490
`'checkpoint_33'` | 484
`'checkpoint_34'` | 489
`'checkpoint_35'` | 492
`'checkpoint_36'` | 495
`'checkpoint_37'` | 495
`'checkpoint_38'` | 499
`'checkpoint_39'` | 506
`'checkpoint_40'` | 501
`'checkpoint_41'` | 495
`'checkpoint_42'` | 497
`'checkpoint_43'` | 497
`'checkpoint_44'` | 500
`'checkpoint_45'` | 506
`'checkpoint_46'` | 499
`'checkpoint_47'` | 501
`'checkpoint_48'` | 505
`'checkpoint_49'` | 497

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):
    Only shown for the first 100 configs.

## rlu_atari_checkpoints/Pooyan_run_1

*   **Dataset size**: `55.36 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 1,074
`'checkpoint_01'` | 508
`'checkpoint_02'` | 659
`'checkpoint_03'` | 684
`'checkpoint_04'` | 652
`'checkpoint_05'` | 621
`'checkpoint_06'` | 623
`'checkpoint_07'` | 633
`'checkpoint_08'` | 629
`'checkpoint_09'` | 630
`'checkpoint_10'` | 634
`'checkpoint_11'` | 613
`'checkpoint_12'` | 613
`'checkpoint_13'` | 585
`'checkpoint_14'` | 586
`'checkpoint_15'` | 577
`'checkpoint_16'` | 560
`'checkpoint_17'` | 560
`'checkpoint_18'` | 558
`'checkpoint_19'` | 565
`'checkpoint_20'` | 559
`'checkpoint_21'` | 550
`'checkpoint_22'` | 582
`'checkpoint_23'` | 556
`'checkpoint_24'` | 565
`'checkpoint_25'` | 558
`'checkpoint_26'` | 557
`'checkpoint_27'` | 555
`'checkpoint_28'` | 562
`'checkpoint_29'` | 534
`'checkpoint_30'` | 555
`'checkpoint_31'` | 576
`'checkpoint_32'` | 558
`'checkpoint_33'` | 559
`'checkpoint_34'` | 563
`'checkpoint_35'` | 575
`'checkpoint_36'` | 575
`'checkpoint_37'` | 572
`'checkpoint_38'` | 564
`'checkpoint_39'` | 560
`'checkpoint_40'` | 566
`'checkpoint_41'` | 565
`'checkpoint_42'` | 597
`'checkpoint_43'` | 588
`'checkpoint_44'` | 543
`'checkpoint_45'` | 582
`'checkpoint_46'` | 586
`'checkpoint_47'` | 563
`'checkpoint_48'` | 535
`'checkpoint_49'` | 547

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):
    Only shown for the first 100 configs.

## rlu_atari_checkpoints/Pooyan_run_2

*   **Dataset size**: `55.28 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 1,047
`'checkpoint_01'` | 559
`'checkpoint_02'` | 762
`'checkpoint_03'` | 703
`'checkpoint_04'` | 648
`'checkpoint_05'` | 638
`'checkpoint_06'` | 619
`'checkpoint_07'` | 624
`'checkpoint_08'` | 611
`'checkpoint_09'` | 614
`'checkpoint_10'` | 582
`'checkpoint_11'` | 602
`'checkpoint_12'` | 595
`'checkpoint_13'` | 600
`'checkpoint_14'` | 588
`'checkpoint_15'` | 562
`'checkpoint_16'` | 573
`'checkpoint_17'` | 568
`'checkpoint_18'` | 576
`'checkpoint_19'` | 590
`'checkpoint_20'` | 579
`'checkpoint_21'` | 554
`'checkpoint_22'` | 603
`'checkpoint_23'` | 573
`'checkpoint_24'` | 588
`'checkpoint_25'` | 563
`'checkpoint_26'` | 560
`'checkpoint_27'` | 573
`'checkpoint_28'` | 582
`'checkpoint_29'` | 578
`'checkpoint_30'` | 581
`'checkpoint_31'` | 579
`'checkpoint_32'` | 566
`'checkpoint_33'` | 619
`'checkpoint_34'` | 601
`'checkpoint_35'` | 609
`'checkpoint_36'` | 591
`'checkpoint_37'` | 598
`'checkpoint_38'` | 595
`'checkpoint_39'` | 543
`'checkpoint_40'` | 553
`'checkpoint_41'` | 573
`'checkpoint_42'` | 558
`'checkpoint_43'` | 565
`'checkpoint_44'` | 568
`'checkpoint_45'` | 556
`'checkpoint_46'` | 573
`'checkpoint_47'` | 553
`'checkpoint_48'` | 582
`'checkpoint_49'` | 563

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):
    Only shown for the first 100 configs.

## rlu_atari_checkpoints/Pooyan_run_3

*   **Dataset size**: `55.26 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 1,044
`'checkpoint_01'` | 572
`'checkpoint_02'` | 709
`'checkpoint_03'` | 656
`'checkpoint_04'` | 666
`'checkpoint_05'` | 631
`'checkpoint_06'` | 613
`'checkpoint_07'` | 593
`'checkpoint_08'` | 595
`'checkpoint_09'` | 605
`'checkpoint_10'` | 600
`'checkpoint_11'` | 565
`'checkpoint_12'` | 579
`'checkpoint_13'` | 573
`'checkpoint_14'` | 610
`'checkpoint_15'` | 623
`'checkpoint_16'` | 597
`'checkpoint_17'` | 599
`'checkpoint_18'` | 610
`'checkpoint_19'` | 599
`'checkpoint_20'` | 571
`'checkpoint_21'` | 610
`'checkpoint_22'` | 610
`'checkpoint_23'` | 596
`'checkpoint_24'` | 591
`'checkpoint_25'` | 573
`'checkpoint_26'` | 617
`'checkpoint_27'` | 594
`'checkpoint_28'` | 599
`'checkpoint_29'` | 582
`'checkpoint_30'` | 589
`'checkpoint_31'` | 607
`'checkpoint_32'` | 612
`'checkpoint_33'` | 588
`'checkpoint_34'` | 568
`'checkpoint_35'` | 600
`'checkpoint_36'` | 602
`'checkpoint_37'` | 586
`'checkpoint_38'` | 604
`'checkpoint_39'` | 595
`'checkpoint_40'` | 548
`'checkpoint_41'` | 606
`'checkpoint_42'` | 576
`'checkpoint_43'` | 524
`'checkpoint_44'` | 555
`'checkpoint_45'` | 567
`'checkpoint_46'` | 582
`'checkpoint_47'` | 562
`'checkpoint_48'` | 557
`'checkpoint_49'` | 557

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):
    Only shown for the first 100 configs.

## rlu_atari_checkpoints/Pooyan_run_4

*   **Dataset size**: `55.38 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 1,017
`'checkpoint_01'` | 525
`'checkpoint_02'` | 563
`'checkpoint_03'` | 505
`'checkpoint_04'` | 515
`'checkpoint_05'` | 607
`'checkpoint_06'` | 608
`'checkpoint_07'` | 613
`'checkpoint_08'` | 618
`'checkpoint_09'` | 585
`'checkpoint_10'` | 605
`'checkpoint_11'` | 581
`'checkpoint_12'` | 626
`'checkpoint_13'` | 583
`'checkpoint_14'` | 580
`'checkpoint_15'` | 570
`'checkpoint_16'` | 582
`'checkpoint_17'` | 595
`'checkpoint_18'` | 589
`'checkpoint_19'` | 578
`'checkpoint_20'` | 557
`'checkpoint_21'` | 572
`'checkpoint_22'` | 563
`'checkpoint_23'` | 581
`'checkpoint_24'` | 562
`'checkpoint_25'` | 584
`'checkpoint_26'` | 569
`'checkpoint_27'` | 587
`'checkpoint_28'` | 593
`'checkpoint_29'` | 583
`'checkpoint_30'` | 566
`'checkpoint_31'` | 583
`'checkpoint_32'` | 571
`'checkpoint_33'` | 579
`'checkpoint_34'` | 585
`'checkpoint_35'` | 566
`'checkpoint_36'` | 591
`'checkpoint_37'` | 565
`'checkpoint_38'` | 561
`'checkpoint_39'` | 562
`'checkpoint_40'` | 574
`'checkpoint_41'` | 577
`'checkpoint_42'` | 549
`'checkpoint_43'` | 595
`'checkpoint_44'` | 545
`'checkpoint_45'` | 581
`'checkpoint_46'` | 603
`'checkpoint_47'` | 575
`'checkpoint_48'` | 596
`'checkpoint_49'` | 594

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):
    Only shown for the first 100 configs.

## rlu_atari_checkpoints/Pooyan_run_5

*   **Dataset size**: `55.33 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 1,042
`'checkpoint_01'` | 489
`'checkpoint_02'` | 596
`'checkpoint_03'` | 682
`'checkpoint_04'` | 648
`'checkpoint_05'` | 653
`'checkpoint_06'` | 609
`'checkpoint_07'` | 596
`'checkpoint_08'` | 627
`'checkpoint_09'` | 626
`'checkpoint_10'` | 623
`'checkpoint_11'` | 579
`'checkpoint_12'` | 627
`'checkpoint_13'` | 595
`'checkpoint_14'` | 601
`'checkpoint_15'` | 596
`'checkpoint_16'` | 597
`'checkpoint_17'` | 586
`'checkpoint_18'` | 591
`'checkpoint_19'` | 575
`'checkpoint_20'` | 616
`'checkpoint_21'` | 594
`'checkpoint_22'` | 616
`'checkpoint_23'` | 600
`'checkpoint_24'` | 562
`'checkpoint_25'` | 619
`'checkpoint_26'` | 575
`'checkpoint_27'` | 580
`'checkpoint_28'` | 564
`'checkpoint_29'` | 579
`'checkpoint_30'` | 588
`'checkpoint_31'` | 603
`'checkpoint_32'` | 586
`'checkpoint_33'` | 576
`'checkpoint_34'` | 583
`'checkpoint_35'` | 573
`'checkpoint_36'` | 586
`'checkpoint_37'` | 587
`'checkpoint_38'` | 578
`'checkpoint_39'` | 571
`'checkpoint_40'` | 567
`'checkpoint_41'` | 563
`'checkpoint_42'` | 537
`'checkpoint_43'` | 563
`'checkpoint_44'` | 573
`'checkpoint_45'` | 533
`'checkpoint_46'` | 548
`'checkpoint_47'` | 556
`'checkpoint_48'` | 539
`'checkpoint_49'` | 558

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):
    Only shown for the first 100 configs.

## rlu_atari_checkpoints/Qbert_run_1

*   **Dataset size**: `96.76 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 2,211
`'checkpoint_01'` | 1,255
`'checkpoint_02'` | 1,380
`'checkpoint_03'` | 1,482
`'checkpoint_04'` | 1,181
`'checkpoint_05'` | 1,088
`'checkpoint_06'` | 1,136
`'checkpoint_07'` | 1,067
`'checkpoint_08'` | 1,039
`'checkpoint_09'` | 967
`'checkpoint_10'` | 953
`'checkpoint_11'` | 919
`'checkpoint_12'` | 894
`'checkpoint_13'` | 900
`'checkpoint_14'` | 872
`'checkpoint_15'` | 865
`'checkpoint_16'` | 881
`'checkpoint_17'` | 857
`'checkpoint_18'` | 870
`'checkpoint_19'` | 845
`'checkpoint_20'` | 872
`'checkpoint_21'` | 853
`'checkpoint_22'` | 858
`'checkpoint_23'` | 866
`'checkpoint_24'` | 859
`'checkpoint_25'` | 856
`'checkpoint_26'` | 838
`'checkpoint_27'` | 850
`'checkpoint_28'` | 858
`'checkpoint_29'` | 846
`'checkpoint_30'` | 881
`'checkpoint_31'` | 850
`'checkpoint_32'` | 884
`'checkpoint_33'` | 861
`'checkpoint_34'` | 910
`'checkpoint_35'` | 890
`'checkpoint_36'` | 875
`'checkpoint_37'` | 878
`'checkpoint_38'` | 832
`'checkpoint_39'` | 889
`'checkpoint_40'` | 824
`'checkpoint_41'` | 871
`'checkpoint_42'` | 867
`'checkpoint_43'` | 868
`'checkpoint_44'` | 867
`'checkpoint_45'` | 857
`'checkpoint_46'` | 870
`'checkpoint_47'` | 866
`'checkpoint_48'` | 884
`'checkpoint_49'` | 893

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):
    Only shown for the first 100 configs.

## rlu_atari_checkpoints/Qbert_run_2

*   **Dataset size**: `97.08 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 2,241
`'checkpoint_01'` | 1,276
`'checkpoint_02'` | 1,675
`'checkpoint_03'` | 1,287
`'checkpoint_04'` | 1,193
`'checkpoint_05'` | 1,194
`'checkpoint_06'` | 1,176
`'checkpoint_07'` | 1,210
`'checkpoint_08'` | 1,160
`'checkpoint_09'` | 995
`'checkpoint_10'` | 982
`'checkpoint_11'` | 935
`'checkpoint_12'` | 888
`'checkpoint_13'` | 848
`'checkpoint_14'` | 872
`'checkpoint_15'` | 845
`'checkpoint_16'` | 880
`'checkpoint_17'` | 854
`'checkpoint_18'` | 837
`'checkpoint_19'` | 838
`'checkpoint_20'` | 824
`'checkpoint_21'` | 825
`'checkpoint_22'` | 787
`'checkpoint_23'` | 818
`'checkpoint_24'` | 816
`'checkpoint_25'` | 822
`'checkpoint_26'` | 797
`'checkpoint_27'` | 810
`'checkpoint_28'` | 819
`'checkpoint_29'` | 811
`'checkpoint_30'` | 789
`'checkpoint_31'` | 796
`'checkpoint_32'` | 796
`'checkpoint_33'` | 785
`'checkpoint_34'` | 797
`'checkpoint_35'` | 771
`'checkpoint_36'` | 799
`'checkpoint_37'` | 816
`'checkpoint_38'` | 829
`'checkpoint_39'` | 820
`'checkpoint_40'` | 806
`'checkpoint_41'` | 836
`'checkpoint_42'` | 798
`'checkpoint_43'` | 798
`'checkpoint_44'` | 809
`'checkpoint_45'` | 808
`'checkpoint_46'` | 784
`'checkpoint_47'` | 796
`'checkpoint_48'` | 813
`'checkpoint_49'` | 821

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):
    Only shown for the first 100 configs.

## rlu_atari_checkpoints/Qbert_run_3

*   **Dataset size**: `97.26 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 2,181
`'checkpoint_01'` | 1,312
`'checkpoint_02'` | 1,696
`'checkpoint_03'` | 1,293
`'checkpoint_04'` | 1,070
`'checkpoint_05'` | 1,194
`'checkpoint_06'` | 1,137
`'checkpoint_07'` | 1,062
`'checkpoint_08'` | 1,016
`'checkpoint_09'` | 974
`'checkpoint_10'` | 916
`'checkpoint_11'` | 907
`'checkpoint_12'` | 921
`'checkpoint_13'` | 876
`'checkpoint_14'` | 854
`'checkpoint_15'` | 936
`'checkpoint_16'` | 908
`'checkpoint_17'` | 858
`'checkpoint_18'` | 847
`'checkpoint_19'` | 828
`'checkpoint_20'` | 821
`'checkpoint_21'` | 818
`'checkpoint_22'` | 817
`'checkpoint_23'` | 824
`'checkpoint_24'` | 809
`'checkpoint_25'` | 842
`'checkpoint_26'` | 854
`'checkpoint_27'` | 836
`'checkpoint_28'` | 825
`'checkpoint_29'` | 883
`'checkpoint_30'` | 843
`'checkpoint_31'` | 830
`'checkpoint_32'` | 852
`'checkpoint_33'` | 820
`'checkpoint_34'` | 858
`'checkpoint_35'` | 807
`'checkpoint_36'` | 788
`'checkpoint_37'` | 831
`'checkpoint_38'` | 824
`'checkpoint_39'` | 826
`'checkpoint_40'` | 788
`'checkpoint_41'` | 832
`'checkpoint_42'` | 842
`'checkpoint_43'` | 864
`'checkpoint_44'` | 836
`'checkpoint_45'` | 845
`'checkpoint_46'` | 843
`'checkpoint_47'` | 843
`'checkpoint_48'` | 849
`'checkpoint_49'` | 839

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):
    Only shown for the first 100 configs.

## rlu_atari_checkpoints/Qbert_run_4

*   **Dataset size**: `97.13 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 2,276
`'checkpoint_01'` | 1,381
`'checkpoint_02'` | 1,523
`'checkpoint_03'` | 1,661
`'checkpoint_04'` | 1,245
`'checkpoint_05'` | 1,206
`'checkpoint_06'` | 1,117
`'checkpoint_07'` | 1,095
`'checkpoint_08'` | 961
`'checkpoint_09'` | 977
`'checkpoint_10'` | 912
`'checkpoint_11'` | 918
`'checkpoint_12'` | 923
`'checkpoint_13'` | 922
`'checkpoint_14'` | 849
`'checkpoint_15'` | 857
`'checkpoint_16'` | 853
`'checkpoint_17'` | 869
`'checkpoint_18'` | 832
`'checkpoint_19'` | 856
`'checkpoint_20'` | 855
`'checkpoint_21'` | 840
`'checkpoint_22'` | 844
`'checkpoint_23'` | 849
`'checkpoint_24'` | 835
`'checkpoint_25'` | 818
`'checkpoint_26'` | 836
`'checkpoint_27'` | 851
`'checkpoint_28'` | 805
`'checkpoint_29'` | 836
`'checkpoint_30'` | 824
`'checkpoint_31'` | 864
`'checkpoint_32'` | 857
`'checkpoint_33'` | 833
`'checkpoint_34'` | 829
`'checkpoint_35'` | 831
`'checkpoint_36'` | 829
`'checkpoint_37'` | 825
`'checkpoint_38'` | 820
`'checkpoint_39'` | 861
`'checkpoint_40'` | 850
`'checkpoint_41'` | 846
`'checkpoint_42'` | 843
`'checkpoint_43'` | 862
`'checkpoint_44'` | 847
`'checkpoint_45'` | 827
`'checkpoint_46'` | 821
`'checkpoint_47'` | 865
`'checkpoint_48'` | 835
`'checkpoint_49'` | 841

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):
    Only shown for the first 100 configs.

## rlu_atari_checkpoints/Qbert_run_5

*   **Dataset size**: `96.93 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 2,179
`'checkpoint_01'` | 1,299
`'checkpoint_02'` | 1,550
`'checkpoint_03'` | 1,485
`'checkpoint_04'` | 1,109
`'checkpoint_05'` | 1,108
`'checkpoint_06'` | 1,071
`'checkpoint_07'` | 1,066
`'checkpoint_08'` | 967
`'checkpoint_09'` | 925
`'checkpoint_10'` | 933
`'checkpoint_11'` | 942
`'checkpoint_12'` | 973
`'checkpoint_13'` | 900
`'checkpoint_14'` | 852
`'checkpoint_15'` | 864
`'checkpoint_16'` | 855
`'checkpoint_17'` | 831
`'checkpoint_18'` | 831
`'checkpoint_19'` | 816
`'checkpoint_20'` | 826
`'checkpoint_21'` | 803
`'checkpoint_22'` | 815
`'checkpoint_23'` | 839
`'checkpoint_24'` | 821
`'checkpoint_25'` | 848
`'checkpoint_26'` | 810
`'checkpoint_27'` | 774
`'checkpoint_28'` | 802
`'checkpoint_29'` | 810
`'checkpoint_30'` | 782
`'checkpoint_31'` | 816
`'checkpoint_32'` | 815
`'checkpoint_33'` | 777
`'checkpoint_34'` | 838
`'checkpoint_35'` | 804
`'checkpoint_36'` | 832
`'checkpoint_37'` | 806
`'checkpoint_38'` | 835
`'checkpoint_39'` | 823
`'checkpoint_40'` | 851
`'checkpoint_41'` | 829
`'checkpoint_42'` | 809
`'checkpoint_43'` | 842
`'checkpoint_44'` | 816
`'checkpoint_45'` | 801
`'checkpoint_46'` | 834
`'checkpoint_47'` | 813
`'checkpoint_48'` | 837
`'checkpoint_49'` | 835

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):
    Only shown for the first 100 configs.

## rlu_atari_checkpoints/Riverraid_run_1

*   **Dataset size**: `48.46 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 1,595
`'checkpoint_01'` | 1,385
`'checkpoint_02'` | 1,317
`'checkpoint_03'` | 1,201
`'checkpoint_04'` | 963
`'checkpoint_05'` | 924
`'checkpoint_06'` | 916
`'checkpoint_07'` | 861
`'checkpoint_08'` | 857
`'checkpoint_09'` | 800
`'checkpoint_10'` | 760
`'checkpoint_11'` | 732
`'checkpoint_12'` | 733
`'checkpoint_13'` | 730
`'checkpoint_14'` | 718
`'checkpoint_15'` | 720
`'checkpoint_16'` | 687
`'checkpoint_17'` | 690
`'checkpoint_18'` | 684
`'checkpoint_19'` | 673
`'checkpoint_20'` | 653
`'checkpoint_21'` | 675
`'checkpoint_22'` | 673
`'checkpoint_23'` | 646
`'checkpoint_24'` | 662
`'checkpoint_25'` | 646
`'checkpoint_26'` | 664
`'checkpoint_27'` | 652
`'checkpoint_28'` | 629
`'checkpoint_29'` | 651
`'checkpoint_30'` | 656
`'checkpoint_31'` | 656
`'checkpoint_32'` | 635
`'checkpoint_33'` | 647
`'checkpoint_34'` | 650
`'checkpoint_35'` | 648
`'checkpoint_36'` | 671
`'checkpoint_37'` | 663
`'checkpoint_38'` | 654
`'checkpoint_39'` | 651
`'checkpoint_40'` | 655
`'checkpoint_41'` | 625
`'checkpoint_42'` | 640
`'checkpoint_43'` | 640
`'checkpoint_44'` | 668
`'checkpoint_45'` | 644
`'checkpoint_46'` | 649
`'checkpoint_47'` | 665
`'checkpoint_48'` | 658
`'checkpoint_49'` | 664

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):
    Only shown for the first 100 configs.

## rlu_atari_checkpoints/Riverraid_run_2

*   **Dataset size**: `48.62 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 1,670
`'checkpoint_01'` | 1,356
`'checkpoint_02'` | 1,371
`'checkpoint_03'` | 1,313
`'checkpoint_04'` | 1,157
`'checkpoint_05'` | 964
`'checkpoint_06'` | 920
`'checkpoint_07'` | 890
`'checkpoint_08'` | 889
`'checkpoint_09'` | 842
`'checkpoint_10'` | 830
`'checkpoint_11'` | 797
`'checkpoint_12'` | 759
`'checkpoint_13'` | 698
`'checkpoint_14'` | 715
`'checkpoint_15'` | 685
`'checkpoint_16'` | 708
`'checkpoint_17'` | 671
`'checkpoint_18'` | 694
`'checkpoint_19'` | 676
`'checkpoint_20'` | 665
`'checkpoint_21'` | 696
`'checkpoint_22'` | 642
`'checkpoint_23'` | 667
`'checkpoint_24'` | 661
`'checkpoint_25'` | 642
`'checkpoint_26'` | 656
`'checkpoint_27'` | 649
`'checkpoint_28'` | 646
`'checkpoint_29'` | 645
`'checkpoint_30'` | 657
`'checkpoint_31'` | 642
`'checkpoint_32'` | 633
`'checkpoint_33'` | 637
`'checkpoint_34'` | 645
`'checkpoint_35'` | 649
`'checkpoint_36'` | 633
`'checkpoint_37'` | 653
`'checkpoint_38'` | 631
`'checkpoint_39'` | 644
`'checkpoint_40'` | 643
`'checkpoint_41'` | 626
`'checkpoint_42'` | 641
`'checkpoint_43'` | 633
`'checkpoint_44'` | 646
`'checkpoint_45'` | 637
`'checkpoint_46'` | 643
`'checkpoint_47'` | 637
`'checkpoint_48'` | 675
`'checkpoint_49'` | 619

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):
    Only shown for the first 100 configs.

## rlu_atari_checkpoints/Riverraid_run_3

*   **Dataset size**: `48.60 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 1,612
`'checkpoint_01'` | 1,351
`'checkpoint_02'` | 1,340
`'checkpoint_03'` | 1,252
`'checkpoint_04'` | 1,051
`'checkpoint_05'` | 964
`'checkpoint_06'` | 962
`'checkpoint_07'` | 891
`'checkpoint_08'` | 886
`'checkpoint_09'` | 870
`'checkpoint_10'` | 842
`'checkpoint_11'` | 819
`'checkpoint_12'` | 776
`'checkpoint_13'` | 749
`'checkpoint_14'` | 740
`'checkpoint_15'` | 722
`'checkpoint_16'` | 721
`'checkpoint_17'` | 706
`'checkpoint_18'` | 694
`'checkpoint_19'` | 698
`'checkpoint_20'` | 666
`'checkpoint_21'` | 674
`'checkpoint_22'` | 676
`'checkpoint_23'` | 670
`'checkpoint_24'` | 666
`'checkpoint_25'` | 673
`'checkpoint_26'` | 633
`'checkpoint_27'` | 654
`'checkpoint_28'` | 633
`'checkpoint_29'` | 671
`'checkpoint_30'` | 642
`'checkpoint_31'` | 657
`'checkpoint_32'` | 657
`'checkpoint_33'` | 637
`'checkpoint_34'` | 617
`'checkpoint_35'` | 635
`'checkpoint_36'` | 659
`'checkpoint_37'` | 653
`'checkpoint_38'` | 647
`'checkpoint_39'` | 632
`'checkpoint_40'` | 639
`'checkpoint_41'` | 631
`'checkpoint_42'` | 634
`'checkpoint_43'` | 623
`'checkpoint_44'` | 653
`'checkpoint_45'` | 635
`'checkpoint_46'` | 641
`'checkpoint_47'` | 641
`'checkpoint_48'` | 641
`'checkpoint_49'` | 650

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):
    Only shown for the first 100 configs.

## rlu_atari_checkpoints/Riverraid_run_4

*   **Dataset size**: `47.73 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 1,652
`'checkpoint_01'` | 1,368
`'checkpoint_02'` | 1,338
`'checkpoint_03'` | 1,274
`'checkpoint_04'` | 1,117
`'checkpoint_05'` | 999
`'checkpoint_06'` | 940
`'checkpoint_07'` | 890
`'checkpoint_08'` | 868
`'checkpoint_09'` | 843
`'checkpoint_10'` | 832
`'checkpoint_11'` | 754
`'checkpoint_12'` | 739
`'checkpoint_13'` | 716
`'checkpoint_14'` | 727
`'checkpoint_15'` | 691
`'checkpoint_16'` | 686
`'checkpoint_17'` | 682
`'checkpoint_18'` | 671
`'checkpoint_19'` | 674
`'checkpoint_20'` | 664
`'checkpoint_21'` | 665
`'checkpoint_22'` | 662
`'checkpoint_23'` | 657
`'checkpoint_24'` | 648
`'checkpoint_25'` | 650
`'checkpoint_26'` | 663
`'checkpoint_27'` | 651
`'checkpoint_28'` | 623
`'checkpoint_29'` | 674
`'checkpoint_30'` | 724
`'checkpoint_31'` | 1,175
`'checkpoint_32'` | 1,457
`'checkpoint_33'` | 1,494
`'checkpoint_34'` | 1,677
`'checkpoint_35'` | 2,337
`'checkpoint_36'` | 1,397
`'checkpoint_37'` | 1,299
`'checkpoint_38'` | 1,124
`'checkpoint_39'` | 2,126
`'checkpoint_40'` | 2,521
`'checkpoint_41'` | 1,911
`'checkpoint_42'` | 3,231
`'checkpoint_43'` | 2,902
`'checkpoint_44'` | 2,537
`'checkpoint_45'` | 2,689
`'checkpoint_46'` | 2,707
`'checkpoint_47'` | 2,623
`'checkpoint_48'` | 2,346
`'checkpoint_49'` | 1,657

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):
    Only shown for the first 100 configs.

## rlu_atari_checkpoints/Riverraid_run_5

*   **Dataset size**: `48.49 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 1,579
`'checkpoint_01'` | 1,386
`'checkpoint_02'` | 1,361
`'checkpoint_03'` | 1,233
`'checkpoint_04'` | 1,038
`'checkpoint_05'` | 987
`'checkpoint_06'` | 945
`'checkpoint_07'` | 913
`'checkpoint_08'` | 879
`'checkpoint_09'` | 871
`'checkpoint_10'` | 831
`'checkpoint_11'` | 791
`'checkpoint_12'` | 765
`'checkpoint_13'` | 727
`'checkpoint_14'` | 695
`'checkpoint_15'` | 705
`'checkpoint_16'` | 685
`'checkpoint_17'` | 694
`'checkpoint_18'` | 685
`'checkpoint_19'` | 651
`'checkpoint_20'` | 665
`'checkpoint_21'` | 673
`'checkpoint_22'` | 661
`'checkpoint_23'` | 651
`'checkpoint_24'` | 666
`'checkpoint_25'` | 627
`'checkpoint_26'` | 635
`'checkpoint_27'` | 631
`'checkpoint_28'` | 648
`'checkpoint_29'` | 644
`'checkpoint_30'` | 641
`'checkpoint_31'` | 648
`'checkpoint_32'` | 634
`'checkpoint_33'` | 622
`'checkpoint_34'` | 646
`'checkpoint_35'` | 651
`'checkpoint_36'` | 661
`'checkpoint_37'` | 646
`'checkpoint_38'` | 635
`'checkpoint_39'` | 663
`'checkpoint_40'` | 648
`'checkpoint_41'` | 649
`'checkpoint_42'` | 649
`'checkpoint_43'` | 653
`'checkpoint_44'` | 660
`'checkpoint_45'` | 652
`'checkpoint_46'` | 642
`'checkpoint_47'` | 633
`'checkpoint_48'` | 654
`'checkpoint_49'` | 614

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):
    Only shown for the first 100 configs.

## rlu_atari_checkpoints/RoadRunner_run_1

*   **Dataset size**: `41.72 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 2,938
`'checkpoint_01'` | 1,248
`'checkpoint_02'` | 1,007
`'checkpoint_03'` | 938
`'checkpoint_04'` | 939
`'checkpoint_05'` | 846
`'checkpoint_06'` | 816
`'checkpoint_07'` | 860
`'checkpoint_08'` | 906
`'checkpoint_09'` | 866
`'checkpoint_10'` | 886
`'checkpoint_11'` | 883
`'checkpoint_12'` | 845
`'checkpoint_13'` | 857
`'checkpoint_14'` | 854
`'checkpoint_15'` | 873
`'checkpoint_16'` | 861
`'checkpoint_17'` | 875
`'checkpoint_18'` | 882
`'checkpoint_19'` | 846
`'checkpoint_20'` | 803
`'checkpoint_21'` | 854
`'checkpoint_22'` | 885
`'checkpoint_23'` | 844
`'checkpoint_24'` | 880
`'checkpoint_25'` | 848
`'checkpoint_26'` | 874
`'checkpoint_27'` | 851
`'checkpoint_28'` | 839
`'checkpoint_29'` | 883
`'checkpoint_30'` | 871
`'checkpoint_31'` | 872
`'checkpoint_32'` | 878
`'checkpoint_33'` | 909
`'checkpoint_34'` | 883
`'checkpoint_35'` | 808
`'checkpoint_36'` | 878
`'checkpoint_37'` | 838
`'checkpoint_38'` | 825
`'checkpoint_39'` | 831
`'checkpoint_40'` | 782
`'checkpoint_41'` | 823
`'checkpoint_42'` | 903
`'checkpoint_43'` | 813
`'checkpoint_44'` | 852
`'checkpoint_45'` | 828
`'checkpoint_46'` | 807
`'checkpoint_47'` | 843
`'checkpoint_48'` | 828
`'checkpoint_49'` | 810

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):
    Only shown for the first 100 configs.

## rlu_atari_checkpoints/RoadRunner_run_2

*   **Dataset size**: `41.66 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 3,190
`'checkpoint_01'` | 1,272
`'checkpoint_02'` | 1,060
`'checkpoint_03'` | 984
`'checkpoint_04'` | 961
`'checkpoint_05'` | 965
`'checkpoint_06'` | 989
`'checkpoint_07'` | 957
`'checkpoint_08'` | 955
`'checkpoint_09'` | 946
`'checkpoint_10'` | 949
`'checkpoint_11'` | 955
`'checkpoint_12'` | 918
`'checkpoint_13'` | 871
`'checkpoint_14'` | 857
`'checkpoint_15'` | 877
`'checkpoint_16'` | 897
`'checkpoint_17'` | 911
`'checkpoint_18'` | 940
`'checkpoint_19'` | 934
`'checkpoint_20'` | 856
`'checkpoint_21'` | 787
`'checkpoint_22'` | 777
`'checkpoint_23'` | 830
`'checkpoint_24'` | 828
`'checkpoint_25'` | 970
`'checkpoint_26'` | 953
`'checkpoint_27'` | 955
`'checkpoint_28'` | 943
`'checkpoint_29'` | 930
`'checkpoint_30'` | 909
`'checkpoint_31'` | 867
`'checkpoint_32'` | 892
`'checkpoint_33'` | 876
`'checkpoint_34'` | 804
`'checkpoint_35'` | 906
`'checkpoint_36'` | 897
`'checkpoint_37'` | 894
`'checkpoint_38'` | 900
`'checkpoint_39'` | 899
`'checkpoint_40'` | 854
`'checkpoint_41'` | 916
`'checkpoint_42'` | 810
`'checkpoint_43'` | 819
`'checkpoint_44'` | 791
`'checkpoint_45'` | 814
`'checkpoint_46'` | 831
`'checkpoint_47'` | 806
`'checkpoint_48'` | 835
`'checkpoint_49'` | 910

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):
    Only shown for the first 100 configs.

## rlu_atari_checkpoints/RoadRunner_run_3

*   **Dataset size**: `41.70 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 2,883
`'checkpoint_01'` | 1,313
`'checkpoint_02'` | 1,034
`'checkpoint_03'` | 923
`'checkpoint_04'` | 888
`'checkpoint_05'` | 946
`'checkpoint_06'` | 947
`'checkpoint_07'` | 959
`'checkpoint_08'` | 910
`'checkpoint_09'` | 946
`'checkpoint_10'` | 917
`'checkpoint_11'` | 965
`'checkpoint_12'` | 949
`'checkpoint_13'` | 893
`'checkpoint_14'` | 932
`'checkpoint_15'` | 886
`'checkpoint_16'` | 838
`'checkpoint_17'` | 842
`'checkpoint_18'` | 850
`'checkpoint_19'` | 861
`'checkpoint_20'` | 873
`'checkpoint_21'` | 877
`'checkpoint_22'` | 866
`'checkpoint_23'` | 877
`'checkpoint_24'` | 820
`'checkpoint_25'` | 793
`'checkpoint_26'` | 890
`'checkpoint_27'` | 819
`'checkpoint_28'` | 823
`'checkpoint_29'` | 867
`'checkpoint_30'` | 846
`'checkpoint_31'` | 752
`'checkpoint_32'` | 818
`'checkpoint_33'` | 834
`'checkpoint_34'` | 810
`'checkpoint_35'` | 819
`'checkpoint_36'` | 827
`'checkpoint_37'` | 812
`'checkpoint_38'` | 854
`'checkpoint_39'` | 813
`'checkpoint_40'` | 777
`'checkpoint_41'` | 826
`'checkpoint_42'` | 883
`'checkpoint_43'` | 869
`'checkpoint_44'` | 812
`'checkpoint_45'` | 827
`'checkpoint_46'` | 788
`'checkpoint_47'` | 836
`'checkpoint_48'` | 898
`'checkpoint_49'` | 924

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):
    Only shown for the first 100 configs.

## rlu_atari_checkpoints/RoadRunner_run_4

*   **Dataset size**: `41.70 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 3,060
`'checkpoint_01'` | 1,327
`'checkpoint_02'` | 1,029
`'checkpoint_03'` | 982
`'checkpoint_04'` | 944
`'checkpoint_05'` | 925
`'checkpoint_06'` | 935
`'checkpoint_07'` | 937
`'checkpoint_08'` | 933
`'checkpoint_09'` | 921
`'checkpoint_10'` | 939
`'checkpoint_11'` | 936
`'checkpoint_12'` | 936
`'checkpoint_13'` | 925
`'checkpoint_14'` | 915
`'checkpoint_15'` | 877
`'checkpoint_16'` | 876
`'checkpoint_17'` | 869
`'checkpoint_18'` | 878
`'checkpoint_19'` | 871
`'checkpoint_20'` | 871
`'checkpoint_21'` | 898
`'checkpoint_22'` | 873
`'checkpoint_23'` | 874
`'checkpoint_24'` | 863
`'checkpoint_25'` | 885
`'checkpoint_26'` | 823
`'checkpoint_27'` | 819
`'checkpoint_28'` | 840
`'checkpoint_29'` | 782
`'checkpoint_30'` | 833
`'checkpoint_31'` | 807
`'checkpoint_32'` | 829
`'checkpoint_33'` | 846
`'checkpoint_34'` | 897
`'checkpoint_35'` | 915
`'checkpoint_36'` | 886
`'checkpoint_37'` | 882
`'checkpoint_38'` | 875
`'checkpoint_39'` | 880
`'checkpoint_40'` | 802
`'checkpoint_41'` | 776
`'checkpoint_42'` | 772
`'checkpoint_43'` | 732
`'checkpoint_44'` | 703
`'checkpoint_45'` | 772
`'checkpoint_46'` | 863
`'checkpoint_47'` | 870
`'checkpoint_48'` | 847
`'checkpoint_49'` | 809

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):
    Only shown for the first 100 configs.

## rlu_atari_checkpoints/RoadRunner_run_5

*   **Dataset size**: `41.73 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 2,852
`'checkpoint_01'` | 1,202
`'checkpoint_02'` | 1,083
`'checkpoint_03'` | 1,010
`'checkpoint_04'` | 921
`'checkpoint_05'` | 789
`'checkpoint_06'` | 896
`'checkpoint_07'` | 754
`'checkpoint_08'` | 842
`'checkpoint_09'` | 824
`'checkpoint_10'` | 865
`'checkpoint_11'` | 810
`'checkpoint_12'` | 879
`'checkpoint_13'` | 832
`'checkpoint_14'` | 895
`'checkpoint_15'` | 922
`'checkpoint_16'` | 946
`'checkpoint_17'` | 921
`'checkpoint_18'` | 905
`'checkpoint_19'` | 880
`'checkpoint_20'` | 873
`'checkpoint_21'` | 866
`'checkpoint_22'` | 852
`'checkpoint_23'` | 776
`'checkpoint_24'` | 787
`'checkpoint_25'` | 759
`'checkpoint_26'` | 849
`'checkpoint_27'` | 873
`'checkpoint_28'` | 768
`'checkpoint_29'` | 778
`'checkpoint_30'` | 768
`'checkpoint_31'` | 801
`'checkpoint_32'` | 783
`'checkpoint_33'` | 862
`'checkpoint_34'` | 896
`'checkpoint_35'` | 837
`'checkpoint_36'` | 814
`'checkpoint_37'` | 848
`'checkpoint_38'` | 773
`'checkpoint_39'` | 798
`'checkpoint_40'` | 776
`'checkpoint_41'` | 839
`'checkpoint_42'` | 882
`'checkpoint_43'` | 909
`'checkpoint_44'` | 851
`'checkpoint_45'` | 959
`'checkpoint_46'` | 906
`'checkpoint_47'` | 907
`'checkpoint_48'` | 911
`'checkpoint_49'` | 873

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):
    Only shown for the first 100 configs.

## rlu_atari_checkpoints/Robotank_run_1

*   **Dataset size**: `47.20 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 365
`'checkpoint_01'` | 368
`'checkpoint_02'` | 349
`'checkpoint_03'` | 319
`'checkpoint_04'` | 309
`'checkpoint_05'` | 297
`'checkpoint_06'` | 265
`'checkpoint_07'` | 243
`'checkpoint_08'` | 215
`'checkpoint_09'` | 195
`'checkpoint_10'` | 191
`'checkpoint_11'` | 185
`'checkpoint_12'` | 180
`'checkpoint_13'` | 179
`'checkpoint_14'` | 171
`'checkpoint_15'` | 164
`'checkpoint_16'` | 162
`'checkpoint_17'` | 161
`'checkpoint_18'` | 161
`'checkpoint_19'` | 156
`'checkpoint_20'` | 161
`'checkpoint_21'` | 158
`'checkpoint_22'` | 155
`'checkpoint_23'` | 157
`'checkpoint_24'` | 157
`'checkpoint_25'` | 154
`'checkpoint_26'` | 149
`'checkpoint_27'` | 150
`'checkpoint_28'` | 150
`'checkpoint_29'` | 148
`'checkpoint_30'` | 145
`'checkpoint_31'` | 147
`'checkpoint_32'` | 141
`'checkpoint_33'` | 143
`'checkpoint_34'` | 146
`'checkpoint_35'` | 148
`'checkpoint_36'` | 148
`'checkpoint_37'` | 147
`'checkpoint_38'` | 147
`'checkpoint_39'` | 154
`'checkpoint_40'` | 150
`'checkpoint_41'` | 151
`'checkpoint_42'` | 148
`'checkpoint_43'` | 152
`'checkpoint_44'` | 152
`'checkpoint_45'` | 148
`'checkpoint_46'` | 150
`'checkpoint_47'` | 149
`'checkpoint_48'` | 153
`'checkpoint_49'` | 151

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):
    Only shown for the first 100 configs.

## rlu_atari_checkpoints/Robotank_run_2

*   **Dataset size**: `47.28 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 352
`'checkpoint_01'` | 374
`'checkpoint_02'` | 354
`'checkpoint_03'` | 321
`'checkpoint_04'` | 293
`'checkpoint_05'` | 272
`'checkpoint_06'` | 271
`'checkpoint_07'` | 236
`'checkpoint_08'` | 216
`'checkpoint_09'` | 199
`'checkpoint_10'` | 190
`'checkpoint_11'` | 185
`'checkpoint_12'` | 179
`'checkpoint_13'` | 176
`'checkpoint_14'` | 172
`'checkpoint_15'` | 173
`'checkpoint_16'` | 163
`'checkpoint_17'` | 160
`'checkpoint_18'` | 152
`'checkpoint_19'` | 153
`'checkpoint_20'` | 144
`'checkpoint_21'` | 148
`'checkpoint_22'` | 144
`'checkpoint_23'` | 146
`'checkpoint_24'` | 147
`'checkpoint_25'` | 141
`'checkpoint_26'` | 146
`'checkpoint_27'` | 144
`'checkpoint_28'` | 144
`'checkpoint_29'` | 149
`'checkpoint_30'` | 149
`'checkpoint_31'` | 148
`'checkpoint_32'` | 144
`'checkpoint_33'` | 148
`'checkpoint_34'` | 146
`'checkpoint_35'` | 149
`'checkpoint_36'` | 148
`'checkpoint_37'` | 149
`'checkpoint_38'` | 151
`'checkpoint_39'` | 152
`'checkpoint_40'` | 149
`'checkpoint_41'` | 149
`'checkpoint_42'` | 144
`'checkpoint_43'` | 145
`'checkpoint_44'` | 147
`'checkpoint_45'` | 147
`'checkpoint_46'` | 148
`'checkpoint_47'` | 148
`'checkpoint_48'` | 148
`'checkpoint_49'` | 147

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):
    Only shown for the first 100 configs.

## rlu_atari_checkpoints/Robotank_run_3

*   **Dataset size**: `47.31 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 367
`'checkpoint_01'` | 371
`'checkpoint_02'` | 350
`'checkpoint_03'` | 304
`'checkpoint_04'` | 294
`'checkpoint_05'` | 286
`'checkpoint_06'` | 288
`'checkpoint_07'` | 253
`'checkpoint_08'` | 227
`'checkpoint_09'` | 217
`'checkpoint_10'` | 210
`'checkpoint_11'` | 195
`'checkpoint_12'` | 188
`'checkpoint_13'` | 176
`'checkpoint_14'` | 170
`'checkpoint_15'` | 178
`'checkpoint_16'` | 168
`'checkpoint_17'` | 168
`'checkpoint_18'` | 163
`'checkpoint_19'` | 161
`'checkpoint_20'` | 154
`'checkpoint_21'` | 154
`'checkpoint_22'` | 155
`'checkpoint_23'` | 156
`'checkpoint_24'` | 154
`'checkpoint_25'` | 155
`'checkpoint_26'` | 150
`'checkpoint_27'` | 144
`'checkpoint_28'` | 150
`'checkpoint_29'` | 149
`'checkpoint_30'` | 153
`'checkpoint_31'` | 153
`'checkpoint_32'` | 149
`'checkpoint_33'` | 149
`'checkpoint_34'` | 152
`'checkpoint_35'` | 151
`'checkpoint_36'` | 149
`'checkpoint_37'` | 147
`'checkpoint_38'` | 150
`'checkpoint_39'` | 146
`'checkpoint_40'` | 148
`'checkpoint_41'` | 145
`'checkpoint_42'` | 149
`'checkpoint_43'` | 150
`'checkpoint_44'` | 149
`'checkpoint_45'` | 150
`'checkpoint_46'` | 147
`'checkpoint_47'` | 145
`'checkpoint_48'` | 150
`'checkpoint_49'` | 148

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):
    Only shown for the first 100 configs.

## rlu_atari_checkpoints/Robotank_run_4

*   **Dataset size**: `47.35 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 371
`'checkpoint_01'` | 353
`'checkpoint_02'` | 347
`'checkpoint_03'` | 323
`'checkpoint_04'` | 303
`'checkpoint_05'` | 292
`'checkpoint_06'` | 263
`'checkpoint_07'` | 231
`'checkpoint_08'` | 211
`'checkpoint_09'` | 202
`'checkpoint_10'` | 190
`'checkpoint_11'` | 178
`'checkpoint_12'` | 178
`'checkpoint_13'` | 178
`'checkpoint_14'` | 173
`'checkpoint_15'` | 169
`'checkpoint_16'` | 163
`'checkpoint_17'` | 161
`'checkpoint_18'` | 156
`'checkpoint_19'` | 154
`'checkpoint_20'` | 159
`'checkpoint_21'` | 157
`'checkpoint_22'` | 149
`'checkpoint_23'` | 150
`'checkpoint_24'` | 147
`'checkpoint_25'` | 149
`'checkpoint_26'` | 144
`'checkpoint_27'` | 147
`'checkpoint_28'` | 144
`'checkpoint_29'` | 146
`'checkpoint_30'` | 149
`'checkpoint_31'` | 150
`'checkpoint_32'` | 152
`'checkpoint_33'` | 153
`'checkpoint_34'` | 148
`'checkpoint_35'` | 147
`'checkpoint_36'` | 151
`'checkpoint_37'` | 149
`'checkpoint_38'` | 151
`'checkpoint_39'` | 151
`'checkpoint_40'` | 152
`'checkpoint_41'` | 150
`'checkpoint_42'` | 151
`'checkpoint_43'` | 148
`'checkpoint_44'` | 148
`'checkpoint_45'` | 150
`'checkpoint_46'` | 152
`'checkpoint_47'` | 148
`'checkpoint_48'` | 151
`'checkpoint_49'` | 150

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):
    Only shown for the first 100 configs.

## rlu_atari_checkpoints/Robotank_run_5

*   **Dataset size**: `47.13 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 360
`'checkpoint_01'` | 367
`'checkpoint_02'` | 345
`'checkpoint_03'` | 317
`'checkpoint_04'` | 298
`'checkpoint_05'` | 281
`'checkpoint_06'` | 287
`'checkpoint_07'` | 270
`'checkpoint_08'` | 241
`'checkpoint_09'` | 223
`'checkpoint_10'` | 206
`'checkpoint_11'` | 194
`'checkpoint_12'` | 192
`'checkpoint_13'` | 191
`'checkpoint_14'` | 184
`'checkpoint_15'` | 184
`'checkpoint_16'` | 184
`'checkpoint_17'` | 177
`'checkpoint_18'` | 168
`'checkpoint_19'` | 169
`'checkpoint_20'` | 163
`'checkpoint_21'` | 162
`'checkpoint_22'` | 157
`'checkpoint_23'` | 152
`'checkpoint_24'` | 154
`'checkpoint_25'` | 146
`'checkpoint_26'` | 147
`'checkpoint_27'` | 147
`'checkpoint_28'` | 145
`'checkpoint_29'` | 149
`'checkpoint_30'` | 146
`'checkpoint_31'` | 149
`'checkpoint_32'` | 152
`'checkpoint_33'` | 150
`'checkpoint_34'` | 152
`'checkpoint_35'` | 149
`'checkpoint_36'` | 150
`'checkpoint_37'` | 149
`'checkpoint_38'` | 149
`'checkpoint_39'` | 149
`'checkpoint_40'` | 147
`'checkpoint_41'` | 150
`'checkpoint_42'` | 147
`'checkpoint_43'` | 150
`'checkpoint_44'` | 146
`'checkpoint_45'` | 150
`'checkpoint_46'` | 147
`'checkpoint_47'` | 149
`'checkpoint_48'` | 150
`'checkpoint_49'` | 148

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):
    Only shown for the first 100 configs.

## rlu_atari_checkpoints/Seaquest_run_1

*   **Dataset size**: `40.70 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 1,325
`'checkpoint_01'` | 961
`'checkpoint_02'` | 892
`'checkpoint_03'` | 846
`'checkpoint_04'` | 930
`'checkpoint_05'` | 926
`'checkpoint_06'` | 927
`'checkpoint_07'` | 851
`'checkpoint_08'` | 706
`'checkpoint_09'` | 732
`'checkpoint_10'` | 718
`'checkpoint_11'` | 710
`'checkpoint_12'` | 722
`'checkpoint_13'` | 641
`'checkpoint_14'` | 612
`'checkpoint_15'` | 561
`'checkpoint_16'` | 656
`'checkpoint_17'` | 633
`'checkpoint_18'` | 620
`'checkpoint_19'` | 611
`'checkpoint_20'` | 593
`'checkpoint_21'` | 600
`'checkpoint_22'` | 613
`'checkpoint_23'` | 609
`'checkpoint_24'` | 589
`'checkpoint_25'` | 574
`'checkpoint_26'` | 576
`'checkpoint_27'` | 634
`'checkpoint_28'` | 651
`'checkpoint_29'` | 624
`'checkpoint_30'` | 619
`'checkpoint_31'` | 609
`'checkpoint_32'` | 597
`'checkpoint_33'` | 572
`'checkpoint_34'` | 589
`'checkpoint_35'` | 641
`'checkpoint_36'` | 723
`'checkpoint_37'` | 655
`'checkpoint_38'` | 732
`'checkpoint_39'` | 719
`'checkpoint_40'` | 673
`'checkpoint_41'` | 603
`'checkpoint_42'` | 565
`'checkpoint_43'` | 566
`'checkpoint_44'` | 560
`'checkpoint_45'` | 548
`'checkpoint_46'` | 570
`'checkpoint_47'` | 562
`'checkpoint_48'` | 562
`'checkpoint_49'` | 564

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):
    Only shown for the first 100 configs.

## rlu_atari_checkpoints/Seaquest_run_2

*   **Dataset size**: `41.63 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 1,390
`'checkpoint_01'` | 1,104
`'checkpoint_02'` | 1,055
`'checkpoint_03'` | 912
`'checkpoint_04'` | 752
`'checkpoint_05'` | 680
`'checkpoint_06'` | 595
`'checkpoint_07'` | 569
`'checkpoint_08'` | 614
`'checkpoint_09'` | 628
`'checkpoint_10'` | 618
`'checkpoint_11'` | 679
`'checkpoint_12'` | 690
`'checkpoint_13'` | 723
`'checkpoint_14'` | 737
`'checkpoint_15'` | 676
`'checkpoint_16'` | 638
`'checkpoint_17'` | 579
`'checkpoint_18'` | 547
`'checkpoint_19'` | 568
`'checkpoint_20'` | 562
`'checkpoint_21'` | 566
`'checkpoint_22'` | 591
`'checkpoint_23'` | 568
`'checkpoint_24'` | 548
`'checkpoint_25'` | 561
`'checkpoint_26'` | 559
`'checkpoint_27'` | 573
`'checkpoint_28'` | 591
`'checkpoint_29'` | 603
`'checkpoint_30'` | 630
`'checkpoint_31'` | 650
`'checkpoint_32'` | 582
`'checkpoint_33'` | 666
`'checkpoint_34'` | 621
`'checkpoint_35'` | 626
`'checkpoint_36'` | 621
`'checkpoint_37'` | 583
`'checkpoint_38'` | 605
`'checkpoint_39'` | 588
`'checkpoint_40'` | 628
`'checkpoint_41'` | 593
`'checkpoint_42'` | 599
`'checkpoint_43'` | 600
`'checkpoint_44'` | 597
`'checkpoint_45'` | 573
`'checkpoint_46'` | 568
`'checkpoint_47'` | 613
`'checkpoint_48'` | 589
`'checkpoint_49'` | 598

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):
    Only shown for the first 100 configs.

## rlu_atari_checkpoints/Seaquest_run_3

*   **Dataset size**: `41.72 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 1,388
`'checkpoint_01'` | 1,030
`'checkpoint_02'` | 1,043
`'checkpoint_03'` | 930
`'checkpoint_04'` | 833
`'checkpoint_05'` | 818
`'checkpoint_06'` | 747
`'checkpoint_07'` | 677
`'checkpoint_08'` | 715
`'checkpoint_09'` | 768
`'checkpoint_10'` | 828
`'checkpoint_11'` | 741
`'checkpoint_12'` | 655
`'checkpoint_13'` | 656
`'checkpoint_14'` | 741
`'checkpoint_15'` | 773
`'checkpoint_16'` | 795
`'checkpoint_17'` | 804
`'checkpoint_18'` | 818
`'checkpoint_19'` | 707
`'checkpoint_20'` | 642
`'checkpoint_21'` | 654
`'checkpoint_22'` | 652
`'checkpoint_23'` | 592
`'checkpoint_24'` | 593
`'checkpoint_25'` | 573
`'checkpoint_26'` | 588
`'checkpoint_27'` | 603
`'checkpoint_28'` | 565
`'checkpoint_29'` | 580
`'checkpoint_30'` | 642
`'checkpoint_31'` | 573
`'checkpoint_32'` | 612
`'checkpoint_33'` | 577
`'checkpoint_34'` | 634
`'checkpoint_35'` | 696
`'checkpoint_36'` | 667
`'checkpoint_37'` | 691
`'checkpoint_38'` | 676
`'checkpoint_39'` | 643
`'checkpoint_40'` | 693
`'checkpoint_41'` | 664
`'checkpoint_42'` | 690
`'checkpoint_43'` | 692
`'checkpoint_44'` | 687
`'checkpoint_45'` | 673
`'checkpoint_46'` | 687
`'checkpoint_47'` | 646
`'checkpoint_48'` | 684
`'checkpoint_49'` | 626

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):
    Only shown for the first 100 configs.

## rlu_atari_checkpoints/Seaquest_run_4

*   **Dataset size**: `41.59 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 1,300
`'checkpoint_01'` | 1,030
`'checkpoint_02'` | 1,012
`'checkpoint_03'` | 938
`'checkpoint_04'` | 904
`'checkpoint_05'` | 917
`'checkpoint_06'` | 809
`'checkpoint_07'` | 709
`'checkpoint_08'` | 616
`'checkpoint_09'` | 613
`'checkpoint_10'` | 679
`'checkpoint_11'` | 757
`'checkpoint_12'` | 837
`'checkpoint_13'` | 781
`'checkpoint_14'` | 715
`'checkpoint_15'` | 623
`'checkpoint_16'` | 626
`'checkpoint_17'` | 604
`'checkpoint_18'` | 574
`'checkpoint_19'` | 585
`'checkpoint_20'` | 610
`'checkpoint_21'` | 639
`'checkpoint_22'` | 561
`'checkpoint_23'` | 560
`'checkpoint_24'` | 589
`'checkpoint_25'` | 583
`'checkpoint_26'` | 603
`'checkpoint_27'` | 611
`'checkpoint_28'` | 568
`'checkpoint_29'` | 574
`'checkpoint_30'` | 602
`'checkpoint_31'` | 597
`'checkpoint_32'` | 611
`'checkpoint_33'` | 610
`'checkpoint_34'` | 625
`'checkpoint_35'` | 646
`'checkpoint_36'` | 723
`'checkpoint_37'` | 664
`'checkpoint_38'` | 665
`'checkpoint_39'` | 655
`'checkpoint_40'` | 696
`'checkpoint_41'` | 677
`'checkpoint_42'` | 657
`'checkpoint_43'` | 659
`'checkpoint_44'` | 680
`'checkpoint_45'` | 673
`'checkpoint_46'` | 677
`'checkpoint_47'` | 704
`'checkpoint_48'` | 665
`'checkpoint_49'` | 684

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):
    Only shown for the first 100 configs.

## rlu_atari_checkpoints/Seaquest_run_5

*   **Dataset size**: `41.70 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 1,305
`'checkpoint_01'` | 977
`'checkpoint_02'` | 886
`'checkpoint_03'` | 792
`'checkpoint_04'` | 735
`'checkpoint_05'` | 721
`'checkpoint_06'` | 784
`'checkpoint_07'` | 767
`'checkpoint_08'` | 712
`'checkpoint_09'` | 677
`'checkpoint_10'` | 633
`'checkpoint_11'` | 607
`'checkpoint_12'` | 590
`'checkpoint_13'` | 604
`'checkpoint_14'` | 636
`'checkpoint_15'` | 624
`'checkpoint_16'` | 588
`'checkpoint_17'` | 650
`'checkpoint_18'` | 629
`'checkpoint_19'` | 613
`'checkpoint_20'` | 576
`'checkpoint_21'` | 617
`'checkpoint_22'` | 635
`'checkpoint_23'` | 629
`'checkpoint_24'` | 690
`'checkpoint_25'` | 686
`'checkpoint_26'` | 696
`'checkpoint_27'` | 625
`'checkpoint_28'` | 585
`'checkpoint_29'` | 637
`'checkpoint_30'` | 641
`'checkpoint_31'` | 663
`'checkpoint_32'` | 648
`'checkpoint_33'` | 629
`'checkpoint_34'` | 606
`'checkpoint_35'` | 599
`'checkpoint_36'` | 577
`'checkpoint_37'` | 575
`'checkpoint_38'` | 596
`'checkpoint_39'` | 552
`'checkpoint_40'` | 572
`'checkpoint_41'` | 544
`'checkpoint_42'` | 547
`'checkpoint_43'` | 560
`'checkpoint_44'` | 571
`'checkpoint_45'` | 606
`'checkpoint_46'` | 610
`'checkpoint_47'` | 581
`'checkpoint_48'` | 602
`'checkpoint_49'` | 598

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):
    Only shown for the first 100 configs.

## rlu_atari_checkpoints/SpaceInvaders_run_1

*   **Dataset size**: `49.70 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 1,743
`'checkpoint_01'` | 1,292
`'checkpoint_02'` | 969
`'checkpoint_03'` | 984
`'checkpoint_04'` | 960
`'checkpoint_05'` | 917
`'checkpoint_06'` | 818
`'checkpoint_07'` | 737
`'checkpoint_08'` | 691
`'checkpoint_09'` | 692
`'checkpoint_10'` | 668
`'checkpoint_11'` | 595
`'checkpoint_12'` | 624
`'checkpoint_13'` | 603
`'checkpoint_14'` | 573
`'checkpoint_15'` | 552
`'checkpoint_16'` | 557
`'checkpoint_17'` | 524
`'checkpoint_18'` | 531
`'checkpoint_19'` | 511
`'checkpoint_20'` | 533
`'checkpoint_21'` | 520
`'checkpoint_22'` | 497
`'checkpoint_23'` | 486
`'checkpoint_24'` | 479
`'checkpoint_25'` | 502
`'checkpoint_26'` | 467
`'checkpoint_27'` | 513
`'checkpoint_28'` | 472
`'checkpoint_29'` | 472
`'checkpoint_30'` | 469
`'checkpoint_31'` | 507
`'checkpoint_32'` | 502
`'checkpoint_33'` | 514
`'checkpoint_34'` | 497
`'checkpoint_35'` | 488
`'checkpoint_36'` | 507
`'checkpoint_37'` | 501
`'checkpoint_38'` | 497
`'checkpoint_39'` | 477
`'checkpoint_40'` | 480
`'checkpoint_41'` | 472
`'checkpoint_42'` | 491
`'checkpoint_43'` | 476
`'checkpoint_44'` | 481
`'checkpoint_45'` | 500
`'checkpoint_46'` | 492
`'checkpoint_47'` | 513
`'checkpoint_48'` | 503
`'checkpoint_49'` | 484

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):
    Only shown for the first 100 configs.

## rlu_atari_checkpoints/SpaceInvaders_run_2

*   **Dataset size**: `50.03 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 1,847
`'checkpoint_01'` | 1,313
`'checkpoint_02'` | 1,017
`'checkpoint_03'` | 1,030
`'checkpoint_04'` | 966
`'checkpoint_05'` | 909
`'checkpoint_06'` | 829
`'checkpoint_07'` | 780
`'checkpoint_08'` | 738
`'checkpoint_09'` | 721
`'checkpoint_10'` | 675
`'checkpoint_11'` | 649
`'checkpoint_12'` | 640
`'checkpoint_13'` | 621
`'checkpoint_14'` | 603
`'checkpoint_15'` | 583
`'checkpoint_16'` | 597
`'checkpoint_17'` | 583
`'checkpoint_18'` | 612
`'checkpoint_19'` | 568
`'checkpoint_20'` | 559
`'checkpoint_21'` | 547
`'checkpoint_22'` | 538
`'checkpoint_23'` | 550
`'checkpoint_24'` | 524
`'checkpoint_25'` | 524
`'checkpoint_26'` | 536
`'checkpoint_27'` | 545
`'checkpoint_28'` | 516
`'checkpoint_29'` | 518
`'checkpoint_30'` | 518
`'checkpoint_31'` | 558
`'checkpoint_32'` | 553
`'checkpoint_33'` | 537
`'checkpoint_34'` | 559
`'checkpoint_35'` | 538
`'checkpoint_36'` | 547
`'checkpoint_37'` | 567
`'checkpoint_38'` | 541
`'checkpoint_39'` | 538
`'checkpoint_40'` | 554
`'checkpoint_41'` | 533
`'checkpoint_42'` | 538
`'checkpoint_43'` | 557
`'checkpoint_44'` | 557
`'checkpoint_45'` | 540
`'checkpoint_46'` | 542
`'checkpoint_47'` | 538
`'checkpoint_48'` | 552
`'checkpoint_49'` | 529

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):
    Only shown for the first 100 configs.

## rlu_atari_checkpoints/SpaceInvaders_run_3

*   **Dataset size**: `49.92 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 1,707
`'checkpoint_01'` | 1,305
`'checkpoint_02'` | 941
`'checkpoint_03'` | 973
`'checkpoint_04'` | 891
`'checkpoint_05'` | 832
`'checkpoint_06'` | 744
`'checkpoint_07'` | 734
`'checkpoint_08'` | 727
`'checkpoint_09'` | 681
`'checkpoint_10'` | 657
`'checkpoint_11'` | 595
`'checkpoint_12'` | 589
`'checkpoint_13'` | 581
`'checkpoint_14'` | 571
`'checkpoint_15'` | 556
`'checkpoint_16'` | 548
`'checkpoint_17'` | 530
`'checkpoint_18'` | 524
`'checkpoint_19'` | 510
`'checkpoint_20'` | 509
`'checkpoint_21'` | 493
`'checkpoint_22'` | 501
`'checkpoint_23'` | 519
`'checkpoint_24'` | 492
`'checkpoint_25'` | 472
`'checkpoint_26'` | 498
`'checkpoint_27'` | 493
`'checkpoint_28'` | 474
`'checkpoint_29'` | 472
`'checkpoint_30'` | 506
`'checkpoint_31'` | 469
`'checkpoint_32'` | 493
`'checkpoint_33'` | 504
`'checkpoint_34'` | 484
`'checkpoint_35'` | 500
`'checkpoint_36'` | 512
`'checkpoint_37'` | 522
`'checkpoint_38'` | 519
`'checkpoint_39'` | 518
`'checkpoint_40'` | 518
`'checkpoint_41'` | 524
`'checkpoint_42'` | 542
`'checkpoint_43'` | 518
`'checkpoint_44'` | 526
`'checkpoint_45'` | 529
`'checkpoint_46'` | 538
`'checkpoint_47'` | 539
`'checkpoint_48'` | 542
`'checkpoint_49'` | 527

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):
    Only shown for the first 100 configs.

## rlu_atari_checkpoints/SpaceInvaders_run_4

*   **Dataset size**: `49.90 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 1,724
`'checkpoint_01'` | 1,281
`'checkpoint_02'` | 1,049
`'checkpoint_03'` | 1,005
`'checkpoint_04'` | 949
`'checkpoint_05'` | 969
`'checkpoint_06'` | 891
`'checkpoint_07'` | 776
`'checkpoint_08'` | 734
`'checkpoint_09'` | 675
`'checkpoint_10'` | 687
`'checkpoint_11'` | 654
`'checkpoint_12'` | 644
`'checkpoint_13'` | 654
`'checkpoint_14'` | 602
`'checkpoint_15'` | 595
`'checkpoint_16'` | 578
`'checkpoint_17'` | 582
`'checkpoint_18'` | 565
`'checkpoint_19'` | 572
`'checkpoint_20'` | 559
`'checkpoint_21'` | 587
`'checkpoint_22'` | 577
`'checkpoint_23'` | 539
`'checkpoint_24'` | 559
`'checkpoint_25'` | 543
`'checkpoint_26'` | 555
`'checkpoint_27'` | 544
`'checkpoint_28'` | 544
`'checkpoint_29'` | 560
`'checkpoint_30'` | 528
`'checkpoint_31'` | 523
`'checkpoint_32'` | 524
`'checkpoint_33'` | 524
`'checkpoint_34'` | 536
`'checkpoint_35'` | 524
`'checkpoint_36'` | 565
`'checkpoint_37'` | 539
`'checkpoint_38'` | 541
`'checkpoint_39'` | 518
`'checkpoint_40'` | 543
`'checkpoint_41'` | 560
`'checkpoint_42'` | 582
`'checkpoint_43'` | 564
`'checkpoint_44'` | 551
`'checkpoint_45'` | 527
`'checkpoint_46'` | 553
`'checkpoint_47'` | 541
`'checkpoint_48'` | 556
`'checkpoint_49'` | 535

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):
    Only shown for the first 100 configs.

## rlu_atari_checkpoints/SpaceInvaders_run_5

*   **Dataset size**: `49.92 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 1,713
`'checkpoint_01'` | 1,283
`'checkpoint_02'` | 933
`'checkpoint_03'` | 974
`'checkpoint_04'` | 970
`'checkpoint_05'` | 914
`'checkpoint_06'` | 872
`'checkpoint_07'` | 808
`'checkpoint_08'` | 718
`'checkpoint_09'` | 717
`'checkpoint_10'` | 711
`'checkpoint_11'` | 691
`'checkpoint_12'` | 696
`'checkpoint_13'` | 688
`'checkpoint_14'` | 668
`'checkpoint_15'` | 653
`'checkpoint_16'` | 625
`'checkpoint_17'` | 634
`'checkpoint_18'` | 598
`'checkpoint_19'` | 571
`'checkpoint_20'` | 562
`'checkpoint_21'` | 570
`'checkpoint_22'` | 560
`'checkpoint_23'` | 539
`'checkpoint_24'` | 525
`'checkpoint_25'` | 532
`'checkpoint_26'` | 538
`'checkpoint_27'` | 555
`'checkpoint_28'` | 500
`'checkpoint_29'` | 551
`'checkpoint_30'` | 535
`'checkpoint_31'` | 512
`'checkpoint_32'` | 534
`'checkpoint_33'` | 542
`'checkpoint_34'` | 523
`'checkpoint_35'` | 557
`'checkpoint_36'` | 533
`'checkpoint_37'` | 524
`'checkpoint_38'` | 517
`'checkpoint_39'` | 527
`'checkpoint_40'` | 516
`'checkpoint_41'` | 518
`'checkpoint_42'` | 520
`'checkpoint_43'` | 511
`'checkpoint_44'` | 516
`'checkpoint_45'` | 522
`'checkpoint_46'` | 540
`'checkpoint_47'` | 515
`'checkpoint_48'` | 509
`'checkpoint_49'` | 497

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):
    Only shown for the first 100 configs.

## rlu_atari_checkpoints/StarGunner_run_1

*   **Dataset size**: `22.65 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 1,062
`'checkpoint_01'` | 1,193
`'checkpoint_02'` | 1,161
`'checkpoint_03'` | 1,268
`'checkpoint_04'` | 1,383
`'checkpoint_05'` | 1,574
`'checkpoint_06'` | 1,753
`'checkpoint_07'` | 2,103
`'checkpoint_08'` | 2,251
`'checkpoint_09'` | 2,204
`'checkpoint_10'` | 2,168
`'checkpoint_11'` | 2,035
`'checkpoint_12'` | 1,874
`'checkpoint_13'` | 1,789
`'checkpoint_14'` | 1,776
`'checkpoint_15'` | 1,704
`'checkpoint_16'` | 1,651
`'checkpoint_17'` | 1,610
`'checkpoint_18'` | 1,492
`'checkpoint_19'` | 1,482
`'checkpoint_20'` | 1,450
`'checkpoint_21'` | 1,357
`'checkpoint_22'` | 1,219
`'checkpoint_23'` | 1,135
`'checkpoint_24'` | 999
`'checkpoint_25'` | 904
`'checkpoint_26'` | 809
`'checkpoint_27'` | 689
`'checkpoint_28'` | 596
`'checkpoint_29'` | 588
`'checkpoint_30'` | 504
`'checkpoint_31'` | 491
`'checkpoint_32'` | 473
`'checkpoint_33'` | 456
`'checkpoint_34'` | 427
`'checkpoint_35'` | 415
`'checkpoint_36'` | 412
`'checkpoint_37'` | 392
`'checkpoint_38'` | 400
`'checkpoint_39'` | 391
`'checkpoint_40'` | 395
`'checkpoint_41'` | 373
`'checkpoint_42'` | 360
`'checkpoint_43'` | 364
`'checkpoint_44'` | 370
`'checkpoint_45'` | 370
`'checkpoint_46'` | 359
`'checkpoint_47'` | 357
`'checkpoint_48'` | 351

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):
    Only shown for the first 100 configs.

## rlu_atari_checkpoints/StarGunner_run_2

*   **Dataset size**: `22.94 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 1,098
`'checkpoint_01'` | 1,187
`'checkpoint_02'` | 1,152
`'checkpoint_03'` | 1,338
`'checkpoint_04'` | 1,484
`'checkpoint_05'` | 1,506
`'checkpoint_06'` | 1,691
`'checkpoint_07'` | 1,932
`'checkpoint_08'` | 2,143
`'checkpoint_09'` | 2,086
`'checkpoint_10'` | 2,007
`'checkpoint_11'` | 1,838
`'checkpoint_12'` | 1,740
`'checkpoint_13'` | 1,651
`'checkpoint_14'` | 1,518
`'checkpoint_15'` | 1,390
`'checkpoint_16'` | 1,309
`'checkpoint_17'` | 1,210
`'checkpoint_18'` | 1,034
`'checkpoint_19'` | 858
`'checkpoint_20'` | 730
`'checkpoint_21'` | 632
`'checkpoint_22'` | 590
`'checkpoint_23'` | 514
`'checkpoint_24'` | 463
`'checkpoint_25'` | 470
`'checkpoint_26'` | 433
`'checkpoint_27'` | 374
`'checkpoint_28'` | 368
`'checkpoint_29'` | 369
`'checkpoint_30'` | 361
`'checkpoint_31'` | 349
`'checkpoint_32'` | 362
`'checkpoint_33'` | 348
`'checkpoint_34'` | 350
`'checkpoint_35'` | 339
`'checkpoint_36'` | 353
`'checkpoint_37'` | 351
`'checkpoint_38'` | 344
`'checkpoint_39'` | 343
`'checkpoint_40'` | 356
`'checkpoint_41'` | 338
`'checkpoint_42'` | 340
`'checkpoint_43'` | 332
`'checkpoint_44'` | 335
`'checkpoint_45'` | 328
`'checkpoint_46'` | 329
`'checkpoint_47'` | 323
`'checkpoint_48'` | 328

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):
    Only shown for the first 100 configs.

## rlu_atari_checkpoints/StarGunner_run_3

*   **Dataset size**: `22.85 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 1,096
`'checkpoint_01'` | 1,178
`'checkpoint_02'` | 1,188
`'checkpoint_03'` | 1,162
`'checkpoint_04'` | 1,365
`'checkpoint_05'` | 1,505
`'checkpoint_06'` | 1,779
`'checkpoint_07'` | 1,956
`'checkpoint_08'` | 2,019
`'checkpoint_09'` | 2,008
`'checkpoint_10'` | 1,744
`'checkpoint_11'` | 1,667
`'checkpoint_12'` | 1,561
`'checkpoint_13'` | 1,436
`'checkpoint_14'` | 1,389
`'checkpoint_15'` | 1,403
`'checkpoint_16'` | 1,388
`'checkpoint_17'` | 1,300
`'checkpoint_18'` | 1,308
`'checkpoint_19'` | 1,234
`'checkpoint_20'` | 1,148
`'checkpoint_21'` | 1,039
`'checkpoint_22'` | 887
`'checkpoint_23'` | 786
`'checkpoint_24'` | 651
`'checkpoint_25'` | 553
`'checkpoint_26'` | 486
`'checkpoint_27'` | 454
`'checkpoint_28'` | 420
`'checkpoint_29'` | 414
`'checkpoint_30'` | 397
`'checkpoint_31'` | 385
`'checkpoint_32'` | 381
`'checkpoint_33'` | 372
`'checkpoint_34'` | 374
`'checkpoint_35'` | 364
`'checkpoint_36'` | 353
`'checkpoint_37'` | 343
`'checkpoint_38'` | 346
`'checkpoint_39'` | 358
`'checkpoint_40'` | 341
`'checkpoint_41'` | 352
`'checkpoint_42'` | 347
`'checkpoint_43'` | 348
`'checkpoint_44'` | 345
`'checkpoint_45'` | 352
`'checkpoint_46'` | 340
`'checkpoint_47'` | 346
`'checkpoint_48'` | 347

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):
    Only shown for the first 100 configs.

## rlu_atari_checkpoints/StarGunner_run_4

*   **Dataset size**: `22.62 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 1,104
`'checkpoint_01'` | 1,173
`'checkpoint_02'` | 1,125
`'checkpoint_03'` | 1,181
`'checkpoint_04'` | 1,373
`'checkpoint_05'` | 1,529
`'checkpoint_06'` | 1,696
`'checkpoint_07'` | 1,780
`'checkpoint_08'` | 1,884
`'checkpoint_09'` | 1,988
`'checkpoint_10'` | 2,088
`'checkpoint_11'` | 2,058
`'checkpoint_12'` | 1,923
`'checkpoint_13'` | 1,858
`'checkpoint_14'` | 1,782
`'checkpoint_15'` | 1,676
`'checkpoint_16'` | 1,620
`'checkpoint_17'` | 1,596
`'checkpoint_18'` | 1,524
`'checkpoint_19'` | 1,456
`'checkpoint_20'` | 1,418
`'checkpoint_21'` | 1,247
`'checkpoint_22'` | 1,171
`'checkpoint_23'` | 1,072
`'checkpoint_24'` | 950
`'checkpoint_25'` | 843
`'checkpoint_26'` | 743
`'checkpoint_27'` | 664
`'checkpoint_28'` | 599
`'checkpoint_29'` | 569
`'checkpoint_30'` | 563
`'checkpoint_31'` | 553
`'checkpoint_32'` | 485
`'checkpoint_33'` | 500
`'checkpoint_34'` | 478
`'checkpoint_35'` | 492
`'checkpoint_36'` | 470
`'checkpoint_37'` | 455
`'checkpoint_38'` | 435
`'checkpoint_39'` | 437
`'checkpoint_40'` | 439
`'checkpoint_41'` | 430
`'checkpoint_42'` | 445
`'checkpoint_43'` | 436
`'checkpoint_44'` | 436
`'checkpoint_45'` | 422
`'checkpoint_46'` | 431
`'checkpoint_47'` | 402
`'checkpoint_48'` | 398

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):
    Only shown for the first 100 configs.

## rlu_atari_checkpoints/StarGunner_run_5

*   **Dataset size**: `22.75 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 1,075
`'checkpoint_01'` | 1,172
`'checkpoint_02'` | 1,160
`'checkpoint_03'` | 1,248
`'checkpoint_04'` | 1,543
`'checkpoint_05'` | 1,660
`'checkpoint_06'` | 1,775
`'checkpoint_07'` | 2,014
`'checkpoint_08'` | 2,164
`'checkpoint_09'` | 2,325
`'checkpoint_10'` | 2,335
`'checkpoint_11'` | 2,274
`'checkpoint_12'` | 2,106
`'checkpoint_13'` | 1,911
`'checkpoint_14'` | 1,715
`'checkpoint_15'` | 1,612
`'checkpoint_16'` | 1,593
`'checkpoint_17'` | 1,511
`'checkpoint_18'` | 1,388
`'checkpoint_19'` | 1,242
`'checkpoint_20'` | 1,139
`'checkpoint_21'` | 1,043
`'checkpoint_22'` | 874
`'checkpoint_23'` | 773
`'checkpoint_24'` | 692
`'checkpoint_25'` | 652
`'checkpoint_26'` | 551
`'checkpoint_27'` | 546
`'checkpoint_28'` | 506
`'checkpoint_29'` | 462
`'checkpoint_30'` | 447
`'checkpoint_31'` | 423
`'checkpoint_32'` | 401
`'checkpoint_33'` | 399
`'checkpoint_34'` | 382
`'checkpoint_35'` | 379
`'checkpoint_36'` | 382
`'checkpoint_37'` | 367
`'checkpoint_38'` | 371
`'checkpoint_39'` | 378
`'checkpoint_40'` | 363
`'checkpoint_41'` | 358
`'checkpoint_42'` | 368
`'checkpoint_43'` | 360
`'checkpoint_44'` | 360
`'checkpoint_45'` | 355
`'checkpoint_46'` | 362
`'checkpoint_47'` | 351
`'checkpoint_48'` | 357

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):
    Only shown for the first 100 configs.

## rlu_atari_checkpoints/TimePilot_run_1

*   **Dataset size**: `41.48 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 636
`'checkpoint_01'` | 760
`'checkpoint_02'` | 1,021
`'checkpoint_03'` | 1,060
`'checkpoint_04'` | 1,105
`'checkpoint_05'` | 1,117
`'checkpoint_06'` | 1,098
`'checkpoint_07'` | 1,024
`'checkpoint_08'` | 961
`'checkpoint_09'` | 935
`'checkpoint_10'` | 927
`'checkpoint_11'` | 921
`'checkpoint_12'` | 968
`'checkpoint_13'` | 954
`'checkpoint_14'` | 856
`'checkpoint_15'` | 860
`'checkpoint_16'` | 860
`'checkpoint_17'` | 905
`'checkpoint_18'` | 918
`'checkpoint_19'` | 905
`'checkpoint_20'` | 895
`'checkpoint_21'` | 891
`'checkpoint_22'` | 877
`'checkpoint_23'` | 968
`'checkpoint_24'` | 996
`'checkpoint_25'` | 954
`'checkpoint_26'` | 945
`'checkpoint_27'` | 981
`'checkpoint_28'` | 956
`'checkpoint_29'` | 955
`'checkpoint_30'` | 1,006
`'checkpoint_31'` | 983
`'checkpoint_32'` | 969
`'checkpoint_33'` | 993
`'checkpoint_34'` | 949
`'checkpoint_35'` | 958
`'checkpoint_36'` | 972
`'checkpoint_37'` | 997
`'checkpoint_38'` | 999
`'checkpoint_39'` | 1,012
`'checkpoint_40'` | 1,018
`'checkpoint_41'` | 1,000
`'checkpoint_42'` | 996
`'checkpoint_43'` | 942
`'checkpoint_44'` | 983
`'checkpoint_45'` | 988
`'checkpoint_46'` | 981
`'checkpoint_47'` | 950
`'checkpoint_48'` | 955
`'checkpoint_49'` | 995

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):
    Only shown for the first 100 configs.

## rlu_atari_checkpoints/TimePilot_run_2

*   **Dataset size**: `41.38 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 647
`'checkpoint_01'` | 784
`'checkpoint_02'` | 962
`'checkpoint_03'` | 1,052
`'checkpoint_04'` | 1,026
`'checkpoint_05'` | 990
`'checkpoint_06'` | 1,020
`'checkpoint_07'` | 1,018
`'checkpoint_08'` | 1,075
`'checkpoint_09'` | 1,062
`'checkpoint_10'` | 1,039
`'checkpoint_11'` | 1,037
`'checkpoint_12'` | 1,031
`'checkpoint_13'` | 998
`'checkpoint_14'` | 976
`'checkpoint_15'` | 929
`'checkpoint_16'` | 922
`'checkpoint_17'` | 946
`'checkpoint_18'` | 985
`'checkpoint_19'` | 995
`'checkpoint_20'` | 1,001
`'checkpoint_21'` | 998
`'checkpoint_22'` | 997
`'checkpoint_23'` | 995
`'checkpoint_24'` | 999
`'checkpoint_25'` | 1,029
`'checkpoint_26'` | 1,023
`'checkpoint_27'` | 1,003
`'checkpoint_28'` | 1,008
`'checkpoint_29'` | 983
`'checkpoint_30'` | 979
`'checkpoint_31'` | 987
`'checkpoint_32'` | 971
`'checkpoint_33'` | 962
`'checkpoint_34'` | 947
`'checkpoint_35'` | 942
`'checkpoint_36'` | 910
`'checkpoint_37'` | 914
`'checkpoint_38'` | 933
`'checkpoint_39'` | 966
`'checkpoint_40'` | 916
`'checkpoint_41'` | 942
`'checkpoint_42'` | 952
`'checkpoint_43'` | 941
`'checkpoint_44'` | 889
`'checkpoint_45'` | 872
`'checkpoint_46'` | 916
`'checkpoint_47'` | 919
`'checkpoint_48'` | 901
`'checkpoint_49'` | 927

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):
    Only shown for the first 100 configs.

## rlu_atari_checkpoints/TimePilot_run_3

*   **Dataset size**: `41.65 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 643
`'checkpoint_01'` | 738
`'checkpoint_02'` | 986
`'checkpoint_03'` | 1,079
`'checkpoint_04'` | 1,045
`'checkpoint_05'` | 1,052
`'checkpoint_06'` | 1,043
`'checkpoint_07'` | 1,038
`'checkpoint_08'` | 1,006
`'checkpoint_09'` | 904
`'checkpoint_10'` | 921
`'checkpoint_11'` | 948
`'checkpoint_12'` | 899
`'checkpoint_13'` | 976
`'checkpoint_14'` | 930
`'checkpoint_15'` | 910
`'checkpoint_16'` | 926
`'checkpoint_17'` | 911
`'checkpoint_18'` | 910
`'checkpoint_19'` | 907
`'checkpoint_20'` | 888
`'checkpoint_21'` | 882
`'checkpoint_22'` | 902
`'checkpoint_23'` | 894
`'checkpoint_24'` | 876
`'checkpoint_25'` | 882
`'checkpoint_26'` | 897
`'checkpoint_27'` | 849
`'checkpoint_28'` | 946
`'checkpoint_29'` | 956
`'checkpoint_30'` | 971
`'checkpoint_31'` | 947
`'checkpoint_32'` | 957
`'checkpoint_33'` | 909
`'checkpoint_34'` | 943
`'checkpoint_35'` | 953
`'checkpoint_36'` | 954
`'checkpoint_37'` | 932
`'checkpoint_38'` | 931
`'checkpoint_39'` | 937
`'checkpoint_40'` | 925
`'checkpoint_41'` | 914
`'checkpoint_42'` | 923
`'checkpoint_43'` | 899
`'checkpoint_44'` | 905
`'checkpoint_45'` | 889
`'checkpoint_46'` | 900
`'checkpoint_47'` | 871
`'checkpoint_48'` | 882
`'checkpoint_49'` | 895

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):
    Only shown for the first 100 configs.

## rlu_atari_checkpoints/TimePilot_run_4

*   **Dataset size**: `41.68 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 650
`'checkpoint_01'` | 704
`'checkpoint_02'` | 972
`'checkpoint_03'` | 966
`'checkpoint_04'` | 978
`'checkpoint_05'` | 990
`'checkpoint_06'` | 998
`'checkpoint_07'` | 1,049
`'checkpoint_08'` | 1,031
`'checkpoint_09'` | 994
`'checkpoint_10'` | 931
`'checkpoint_11'` | 966
`'checkpoint_12'` | 927
`'checkpoint_13'` | 901
`'checkpoint_14'` | 942
`'checkpoint_15'` | 898
`'checkpoint_16'` | 899
`'checkpoint_17'` | 893
`'checkpoint_18'` | 939
`'checkpoint_19'` | 909
`'checkpoint_20'` | 917
`'checkpoint_21'` | 893
`'checkpoint_22'` | 926
`'checkpoint_23'` | 880
`'checkpoint_24'` | 891
`'checkpoint_25'` | 912
`'checkpoint_26'` | 964
`'checkpoint_27'` | 949
`'checkpoint_28'` | 966
`'checkpoint_29'` | 941
`'checkpoint_30'` | 955
`'checkpoint_31'` | 943
`'checkpoint_32'` | 932
`'checkpoint_33'` | 911
`'checkpoint_34'` | 890
`'checkpoint_35'` | 884
`'checkpoint_36'` | 930
`'checkpoint_37'` | 908
`'checkpoint_38'` | 923
`'checkpoint_39'` | 911
`'checkpoint_40'` | 924
`'checkpoint_41'` | 875
`'checkpoint_42'` | 911
`'checkpoint_43'` | 932
`'checkpoint_44'` | 941
`'checkpoint_45'` | 918
`'checkpoint_46'` | 899
`'checkpoint_47'` | 883
`'checkpoint_48'` | 920
`'checkpoint_49'` | 895

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):
    Only shown for the first 100 configs.

## rlu_atari_checkpoints/TimePilot_run_5

*   **Dataset size**: `41.52 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 646
`'checkpoint_01'` | 697
`'checkpoint_02'` | 959
`'checkpoint_03'` | 1,016
`'checkpoint_04'` | 1,093
`'checkpoint_05'` | 1,127
`'checkpoint_06'` | 1,132
`'checkpoint_07'` | 1,096
`'checkpoint_08'` | 1,088
`'checkpoint_09'` | 1,089
`'checkpoint_10'` | 1,020
`'checkpoint_11'` | 1,027
`'checkpoint_12'` | 1,002
`'checkpoint_13'` | 996
`'checkpoint_14'` | 980
`'checkpoint_15'` | 969
`'checkpoint_16'` | 948
`'checkpoint_17'` | 927
`'checkpoint_18'` | 945
`'checkpoint_19'` | 953
`'checkpoint_20'` | 938
`'checkpoint_21'` | 995
`'checkpoint_22'` | 976
`'checkpoint_23'` | 985
`'checkpoint_24'` | 989
`'checkpoint_25'` | 944
`'checkpoint_26'` | 935
`'checkpoint_27'` | 914
`'checkpoint_28'` | 935
`'checkpoint_29'` | 934
`'checkpoint_30'` | 918
`'checkpoint_31'` | 932
`'checkpoint_32'` | 919
`'checkpoint_33'` | 905
`'checkpoint_34'` | 909
`'checkpoint_35'` | 929
`'checkpoint_36'` | 920
`'checkpoint_37'` | 941
`'checkpoint_38'` | 894
`'checkpoint_39'` | 930
`'checkpoint_40'` | 904
`'checkpoint_41'` | 926
`'checkpoint_42'` | 897
`'checkpoint_43'` | 911
`'checkpoint_44'` | 937
`'checkpoint_45'` | 919
`'checkpoint_46'` | 893
`'checkpoint_47'` | 917
`'checkpoint_48'` | 931
`'checkpoint_49'` | 937

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):
    Only shown for the first 100 configs.

## rlu_atari_checkpoints/UpNDown_run_1

*   **Dataset size**: `100.18 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 1,604
`'checkpoint_01'` | 991
`'checkpoint_02'` | 715
`'checkpoint_03'` | 690
`'checkpoint_04'` | 625
`'checkpoint_05'` | 643
`'checkpoint_06'` | 655
`'checkpoint_07'` | 627
`'checkpoint_08'` | 616
`'checkpoint_09'` | 641
`'checkpoint_10'` | 651
`'checkpoint_11'` | 615
`'checkpoint_12'` | 656
`'checkpoint_13'` | 612
`'checkpoint_14'` | 696
`'checkpoint_15'` | 642
`'checkpoint_16'` | 658
`'checkpoint_17'` | 643
`'checkpoint_18'` | 684
`'checkpoint_19'` | 623
`'checkpoint_20'` | 627
`'checkpoint_21'` | 645
`'checkpoint_22'` | 675
`'checkpoint_23'` | 624
`'checkpoint_24'` | 656
`'checkpoint_25'` | 623
`'checkpoint_26'` | 681
`'checkpoint_27'` | 607
`'checkpoint_28'` | 690
`'checkpoint_29'` | 649
`'checkpoint_30'` | 629
`'checkpoint_31'` | 625
`'checkpoint_32'` | 655
`'checkpoint_33'` | 666
`'checkpoint_34'` | 674
`'checkpoint_35'` | 696
`'checkpoint_36'` | 669
`'checkpoint_37'` | 676
`'checkpoint_38'` | 680
`'checkpoint_39'` | 641
`'checkpoint_40'` | 636
`'checkpoint_41'` | 667
`'checkpoint_42'` | 645
`'checkpoint_43'` | 645
`'checkpoint_44'` | 649
`'checkpoint_45'` | 650
`'checkpoint_46'` | 694
`'checkpoint_47'` | 591
`'checkpoint_48'` | 636
`'checkpoint_49'` | 659

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):
    Only shown for the first 100 configs.

## rlu_atari_checkpoints/UpNDown_run_2

*   **Dataset size**: `99.74 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 1,546
`'checkpoint_01'` | 962
`'checkpoint_02'` | 682
`'checkpoint_03'` | 626
`'checkpoint_04'` | 611
`'checkpoint_05'` | 637
`'checkpoint_06'` | 655
`'checkpoint_07'` | 624
`'checkpoint_08'` | 635
`'checkpoint_09'` | 647
`'checkpoint_10'` | 635
`'checkpoint_11'` | 613
`'checkpoint_12'` | 611
`'checkpoint_13'` | 618
`'checkpoint_14'` | 577
`'checkpoint_15'` | 616
`'checkpoint_16'` | 628
`'checkpoint_17'` | 668
`'checkpoint_18'` | 638
`'checkpoint_19'` | 626
`'checkpoint_20'` | 646
`'checkpoint_21'` | 665
`'checkpoint_22'` | 638
`'checkpoint_23'` | 682
`'checkpoint_24'` | 598
`'checkpoint_25'` | 650
`'checkpoint_26'` | 669
`'checkpoint_27'` | 616
`'checkpoint_28'` | 679
`'checkpoint_29'` | 608
`'checkpoint_30'` | 660
`'checkpoint_31'` | 677
`'checkpoint_32'` | 624
`'checkpoint_33'` | 667
`'checkpoint_34'` | 647
`'checkpoint_35'` | 682
`'checkpoint_36'` | 675
`'checkpoint_37'` | 631
`'checkpoint_38'` | 636
`'checkpoint_39'` | 632
`'checkpoint_40'` | 686
`'checkpoint_41'` | 623
`'checkpoint_42'` | 608
`'checkpoint_43'` | 694
`'checkpoint_44'` | 653
`'checkpoint_45'` | 672
`'checkpoint_46'` | 639
`'checkpoint_47'` | 675
`'checkpoint_48'` | 667
`'checkpoint_49'` | 713

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):
    Only shown for the first 100 configs.

## rlu_atari_checkpoints/UpNDown_run_3

*   **Dataset size**: `99.85 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 1,594
`'checkpoint_01'` | 989
`'checkpoint_02'` | 796
`'checkpoint_03'` | 638
`'checkpoint_04'` | 636
`'checkpoint_05'` | 638
`'checkpoint_06'` | 622
`'checkpoint_07'` | 660
`'checkpoint_08'` | 669
`'checkpoint_09'` | 674
`'checkpoint_10'` | 619
`'checkpoint_11'` | 631
`'checkpoint_12'` | 661
`'checkpoint_13'` | 651
`'checkpoint_14'` | 641
`'checkpoint_15'` | 628
`'checkpoint_16'` | 631
`'checkpoint_17'` | 612
`'checkpoint_18'` | 613
`'checkpoint_19'` | 620
`'checkpoint_20'` | 652
`'checkpoint_21'` | 637
`'checkpoint_22'` | 652
`'checkpoint_23'` | 640
`'checkpoint_24'` | 600
`'checkpoint_25'` | 620
`'checkpoint_26'` | 618
`'checkpoint_27'` | 651
`'checkpoint_28'` | 687
`'checkpoint_29'` | 659
`'checkpoint_30'` | 649
`'checkpoint_31'` | 632
`'checkpoint_32'` | 716
`'checkpoint_33'` | 624
`'checkpoint_34'` | 607
`'checkpoint_35'` | 627
`'checkpoint_36'` | 625
`'checkpoint_37'` | 649
`'checkpoint_38'` | 620
`'checkpoint_39'` | 618
`'checkpoint_40'` | 649
`'checkpoint_41'` | 684
`'checkpoint_42'` | 618
`'checkpoint_43'` | 657
`'checkpoint_44'` | 651
`'checkpoint_45'` | 614
`'checkpoint_46'` | 613
`'checkpoint_47'` | 636
`'checkpoint_48'` | 635
`'checkpoint_49'` | 662

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):
    Only shown for the first 100 configs.

## rlu_atari_checkpoints/UpNDown_run_4

*   **Dataset size**: `99.97 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 1,581
`'checkpoint_01'` | 975
`'checkpoint_02'` | 713
`'checkpoint_03'` | 695
`'checkpoint_04'` | 678
`'checkpoint_05'` | 646
`'checkpoint_06'` | 621
`'checkpoint_07'` | 651
`'checkpoint_08'` | 624
`'checkpoint_09'` | 646
`'checkpoint_10'` | 634
`'checkpoint_11'` | 610
`'checkpoint_12'` | 576
`'checkpoint_13'` | 573
`'checkpoint_14'` | 629
`'checkpoint_15'` | 641
`'checkpoint_16'` | 578
`'checkpoint_17'` | 625
`'checkpoint_18'` | 596
`'checkpoint_19'` | 628
`'checkpoint_20'` | 612
`'checkpoint_21'` | 635
`'checkpoint_22'` | 621
`'checkpoint_23'` | 635
`'checkpoint_24'` | 607
`'checkpoint_25'` | 603
`'checkpoint_26'` | 643
`'checkpoint_27'` | 659
`'checkpoint_28'` | 583
`'checkpoint_29'` | 653
`'checkpoint_30'` | 638
`'checkpoint_31'` | 591
`'checkpoint_32'` | 629
`'checkpoint_33'` | 630
`'checkpoint_34'` | 652
`'checkpoint_35'` | 593
`'checkpoint_36'` | 608
`'checkpoint_37'` | 635
`'checkpoint_38'` | 615
`'checkpoint_39'` | 622
`'checkpoint_40'` | 612
`'checkpoint_41'` | 625
`'checkpoint_42'` | 687
`'checkpoint_43'` | 621
`'checkpoint_44'` | 747
`'checkpoint_45'` | 664
`'checkpoint_46'` | 718
`'checkpoint_47'` | 643
`'checkpoint_48'` | 652
`'checkpoint_49'` | 665

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):
    Only shown for the first 100 configs.

## rlu_atari_checkpoints/UpNDown_run_5

*   **Dataset size**: `100.06 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 1,566
`'checkpoint_01'` | 980
`'checkpoint_02'` | 694
`'checkpoint_03'` | 655
`'checkpoint_04'` | 623
`'checkpoint_05'` | 644
`'checkpoint_06'` | 643
`'checkpoint_07'` | 681
`'checkpoint_08'` | 669
`'checkpoint_09'` | 606
`'checkpoint_10'` | 647
`'checkpoint_11'` | 661
`'checkpoint_12'` | 626
`'checkpoint_13'` | 603
`'checkpoint_14'` | 623
`'checkpoint_15'` | 598
`'checkpoint_16'` | 666
`'checkpoint_17'` | 666
`'checkpoint_18'` | 611
`'checkpoint_19'` | 606
`'checkpoint_20'` | 628
`'checkpoint_21'` | 615
`'checkpoint_22'` | 622
`'checkpoint_23'` | 674
`'checkpoint_24'` | 602
`'checkpoint_25'` | 603
`'checkpoint_26'` | 684
`'checkpoint_27'` | 643
`'checkpoint_28'` | 649
`'checkpoint_29'` | 631
`'checkpoint_30'` | 643
`'checkpoint_31'` | 625
`'checkpoint_32'` | 699
`'checkpoint_33'` | 633
`'checkpoint_34'` | 601
`'checkpoint_35'` | 631
`'checkpoint_36'` | 627
`'checkpoint_37'` | 650
`'checkpoint_38'` | 617
`'checkpoint_39'` | 642
`'checkpoint_40'` | 687
`'checkpoint_41'` | 642
`'checkpoint_42'` | 666
`'checkpoint_43'` | 643
`'checkpoint_44'` | 666
`'checkpoint_45'` | 718
`'checkpoint_46'` | 695
`'checkpoint_47'` | 628
`'checkpoint_48'` | 691
`'checkpoint_49'` | 768

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):
    Only shown for the first 100 configs.

## rlu_atari_checkpoints/VideoPinball_run_1

*   **Dataset size**: `71.74 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 797
`'checkpoint_01'` | 893
`'checkpoint_02'` | 786
`'checkpoint_03'` | 593
`'checkpoint_04'` | 447
`'checkpoint_05'` | 401
`'checkpoint_06'` | 179
`'checkpoint_07'` | 166
`'checkpoint_08'` | 166
`'checkpoint_09'` | 157
`'checkpoint_10'` | 148
`'checkpoint_11'` | 118
`'checkpoint_12'` | 127
`'checkpoint_13'` | 136
`'checkpoint_14'` | 119
`'checkpoint_15'` | 105
`'checkpoint_16'` | 126
`'checkpoint_17'` | 187
`'checkpoint_18'` | 167
`'checkpoint_19'` | 162
`'checkpoint_20'` | 176
`'checkpoint_21'` | 155
`'checkpoint_22'` | 142
`'checkpoint_23'` | 185
`'checkpoint_24'` | 174
`'checkpoint_25'` | 164
`'checkpoint_26'` | 185
`'checkpoint_27'` | 171
`'checkpoint_28'` | 164
`'checkpoint_29'` | 173
`'checkpoint_30'` | 204
`'checkpoint_31'` | 225
`'checkpoint_32'` | 187
`'checkpoint_33'` | 164
`'checkpoint_34'` | 208
`'checkpoint_35'` | 164
`'checkpoint_36'` | 216
`'checkpoint_37'` | 184
`'checkpoint_38'` | 242
`'checkpoint_39'` | 175
`'checkpoint_40'` | 221
`'checkpoint_41'` | 230
`'checkpoint_42'` | 222
`'checkpoint_43'` | 215
`'checkpoint_44'` | 218
`'checkpoint_45'` | 266
`'checkpoint_46'` | 145
`'checkpoint_47'` | 348
`'checkpoint_48'` | 309
`'checkpoint_49'` | 225

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):
    Only shown for the first 100 configs.

## rlu_atari_checkpoints/VideoPinball_run_2

*   **Dataset size**: `71.43 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 868
`'checkpoint_01'` | 873
`'checkpoint_02'` | 892
`'checkpoint_03'` | 630
`'checkpoint_04'` | 508
`'checkpoint_05'` | 518
`'checkpoint_06'` | 527
`'checkpoint_07'` | 420
`'checkpoint_08'` | 233
`'checkpoint_09'` | 172
`'checkpoint_10'` | 173
`'checkpoint_11'` | 170
`'checkpoint_12'` | 161
`'checkpoint_13'` | 158
`'checkpoint_14'` | 152
`'checkpoint_15'` | 172
`'checkpoint_16'` | 158
`'checkpoint_17'` | 155
`'checkpoint_18'` | 151
`'checkpoint_19'` | 148
`'checkpoint_20'` | 156
`'checkpoint_21'` | 176
`'checkpoint_22'` | 203
`'checkpoint_23'` | 232
`'checkpoint_24'` | 214
`'checkpoint_25'` | 238
`'checkpoint_26'` | 234
`'checkpoint_27'` | 302
`'checkpoint_28'` | 369
`'checkpoint_29'` | 473
`'checkpoint_30'` | 594
`'checkpoint_31'` | 698
`'checkpoint_32'` | 722
`'checkpoint_33'` | 694
`'checkpoint_34'` | 661
`'checkpoint_35'` | 651
`'checkpoint_36'` | 626
`'checkpoint_37'` | 637
`'checkpoint_38'` | 734
`'checkpoint_39'` | 693
`'checkpoint_40'` | 685
`'checkpoint_41'` | 694
`'checkpoint_42'` | 693
`'checkpoint_43'` | 755
`'checkpoint_44'` | 747
`'checkpoint_45'` | 735
`'checkpoint_46'` | 732
`'checkpoint_47'` | 750
`'checkpoint_48'` | 747
`'checkpoint_49'` | 784

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):
    Only shown for the first 100 configs.

## rlu_atari_checkpoints/VideoPinball_run_3

*   **Dataset size**: `71.04 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 839
`'checkpoint_01'` | 898
`'checkpoint_02'` | 856
`'checkpoint_03'` | 757
`'checkpoint_04'` | 537
`'checkpoint_05'` | 510
`'checkpoint_06'` | 502
`'checkpoint_07'` | 264
`'checkpoint_08'` | 186
`'checkpoint_09'` | 185
`'checkpoint_10'` | 185
`'checkpoint_11'` | 165
`'checkpoint_12'` | 132
`'checkpoint_13'` | 138
`'checkpoint_14'` | 137
`'checkpoint_15'` | 146
`'checkpoint_16'` | 130
`'checkpoint_17'` | 131
`'checkpoint_18'` | 128
`'checkpoint_19'` | 169
`'checkpoint_20'` | 143
`'checkpoint_21'` | 157
`'checkpoint_22'` | 178
`'checkpoint_23'` | 286
`'checkpoint_24'` | 394
`'checkpoint_25'` | 528
`'checkpoint_26'` | 564
`'checkpoint_27'` | 499
`'checkpoint_28'` | 416
`'checkpoint_29'` | 594
`'checkpoint_30'` | 579
`'checkpoint_31'` | 551
`'checkpoint_32'` | 549
`'checkpoint_33'` | 547
`'checkpoint_34'` | 687
`'checkpoint_35'` | 623
`'checkpoint_36'` | 580
`'checkpoint_37'` | 618
`'checkpoint_38'` | 864
`'checkpoint_39'` | 889
`'checkpoint_40'` | 805
`'checkpoint_41'` | 857
`'checkpoint_42'` | 874
`'checkpoint_43'` | 763
`'checkpoint_44'` | 794
`'checkpoint_45'` | 786
`'checkpoint_46'` | 805
`'checkpoint_47'` | 798
`'checkpoint_48'` | 773
`'checkpoint_49'` | 757

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):
    Only shown for the first 100 configs.

## rlu_atari_checkpoints/VideoPinball_run_4

*   **Dataset size**: `71.72 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 856
`'checkpoint_01'` | 897
`'checkpoint_02'` | 909
`'checkpoint_03'` | 840
`'checkpoint_04'` | 652
`'checkpoint_05'` | 522
`'checkpoint_06'` | 244
`'checkpoint_07'` | 149
`'checkpoint_08'` | 187
`'checkpoint_09'` | 203
`'checkpoint_10'` | 147
`'checkpoint_11'` | 203
`'checkpoint_12'` | 182
`'checkpoint_13'` | 185
`'checkpoint_14'` | 219
`'checkpoint_15'` | 188
`'checkpoint_16'` | 167
`'checkpoint_17'` | 192
`'checkpoint_18'` | 191
`'checkpoint_19'` | 231
`'checkpoint_20'` | 181
`'checkpoint_21'` | 214
`'checkpoint_22'` | 187
`'checkpoint_23'` | 199
`'checkpoint_24'` | 180
`'checkpoint_25'` | 208
`'checkpoint_26'` | 208
`'checkpoint_27'` | 153
`'checkpoint_28'` | 197
`'checkpoint_29'` | 150
`'checkpoint_30'` | 172
`'checkpoint_31'` | 257
`'checkpoint_32'` | 201
`'checkpoint_33'` | 178
`'checkpoint_34'` | 241
`'checkpoint_35'` | 224
`'checkpoint_36'` | 158
`'checkpoint_37'` | 234
`'checkpoint_38'` | 205
`'checkpoint_39'` | 250
`'checkpoint_40'` | 218
`'checkpoint_41'` | 239
`'checkpoint_42'` | 249
`'checkpoint_43'` | 250
`'checkpoint_44'` | 238
`'checkpoint_45'` | 265
`'checkpoint_46'` | 242
`'checkpoint_47'` | 221
`'checkpoint_48'` | 257
`'checkpoint_49'` | 269

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):
    Only shown for the first 100 configs.

## rlu_atari_checkpoints/VideoPinball_run_5

*   **Dataset size**: `71.74 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 840
`'checkpoint_01'` | 898
`'checkpoint_02'` | 833
`'checkpoint_03'` | 776
`'checkpoint_04'` | 622
`'checkpoint_05'` | 516
`'checkpoint_06'` | 465
`'checkpoint_07'` | 248
`'checkpoint_08'` | 158
`'checkpoint_09'` | 137
`'checkpoint_10'` | 173
`'checkpoint_11'` | 154
`'checkpoint_12'` | 149
`'checkpoint_13'` | 116
`'checkpoint_14'` | 150
`'checkpoint_15'` | 106
`'checkpoint_16'` | 122
`'checkpoint_17'` | 127
`'checkpoint_18'` | 153
`'checkpoint_19'` | 136
`'checkpoint_20'` | 160
`'checkpoint_21'` | 166
`'checkpoint_22'` | 128
`'checkpoint_23'` | 127
`'checkpoint_24'` | 172
`'checkpoint_25'` | 182
`'checkpoint_26'` | 179
`'checkpoint_27'` | 222
`'checkpoint_28'` | 190
`'checkpoint_29'` | 287
`'checkpoint_30'` | 207
`'checkpoint_31'` | 156
`'checkpoint_32'` | 210
`'checkpoint_33'` | 145
`'checkpoint_34'` | 230
`'checkpoint_35'` | 173
`'checkpoint_36'` | 228
`'checkpoint_37'` | 241
`'checkpoint_38'` | 252
`'checkpoint_39'` | 223
`'checkpoint_40'` | 275
`'checkpoint_41'` | 306
`'checkpoint_42'` | 295
`'checkpoint_43'` | 169
`'checkpoint_44'` | 276
`'checkpoint_45'` | 220
`'checkpoint_46'` | 257
`'checkpoint_47'` | 165
`'checkpoint_48'` | 277
`'checkpoint_49'` | 242

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):
    Only shown for the first 100 configs.

## rlu_atari_checkpoints/WizardOfWor_run_1

*   **Dataset size**: `60.51 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 1,032
`'checkpoint_01'` | 1,105
`'checkpoint_02'` | 1,107
`'checkpoint_03'` | 939
`'checkpoint_04'` | 821
`'checkpoint_05'` | 744
`'checkpoint_06'` | 715
`'checkpoint_07'` | 662
`'checkpoint_08'` | 654
`'checkpoint_09'` | 655
`'checkpoint_10'` | 645
`'checkpoint_11'` | 648
`'checkpoint_12'` | 634
`'checkpoint_13'` | 667
`'checkpoint_14'` | 677
`'checkpoint_15'` | 669
`'checkpoint_16'` | 695
`'checkpoint_17'` | 697
`'checkpoint_18'` | 717
`'checkpoint_19'` | 711
`'checkpoint_20'` | 737
`'checkpoint_21'` | 734
`'checkpoint_22'` | 760
`'checkpoint_23'` | 728
`'checkpoint_24'` | 755
`'checkpoint_25'` | 732
`'checkpoint_26'` | 735
`'checkpoint_27'` | 738
`'checkpoint_28'` | 739
`'checkpoint_29'` | 744
`'checkpoint_30'` | 754
`'checkpoint_31'` | 754
`'checkpoint_32'` | 760
`'checkpoint_33'` | 746
`'checkpoint_34'` | 728
`'checkpoint_35'` | 729
`'checkpoint_36'` | 778
`'checkpoint_37'` | 765
`'checkpoint_38'` | 790
`'checkpoint_39'` | 763
`'checkpoint_40'` | 763
`'checkpoint_41'` | 785
`'checkpoint_42'` | 772
`'checkpoint_43'` | 755
`'checkpoint_44'` | 783
`'checkpoint_45'` | 795
`'checkpoint_46'` | 770
`'checkpoint_47'` | 787
`'checkpoint_48'` | 771
`'checkpoint_49'` | 743

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):
    Only shown for the first 100 configs.

## rlu_atari_checkpoints/WizardOfWor_run_2

*   **Dataset size**: `60.47 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 998
`'checkpoint_01'` | 995
`'checkpoint_02'` | 558
`'checkpoint_03'` | 444
`'checkpoint_04'` | 471
`'checkpoint_05'` | 825
`'checkpoint_06'` | 868
`'checkpoint_07'` | 835
`'checkpoint_08'` | 782
`'checkpoint_09'` | 720
`'checkpoint_10'` | 743
`'checkpoint_11'` | 988
`'checkpoint_12'` | 946
`'checkpoint_13'` | 953
`'checkpoint_14'` | 853
`'checkpoint_15'` | 780
`'checkpoint_16'` | 751
`'checkpoint_17'` | 816
`'checkpoint_18'` | 769
`'checkpoint_19'` | 768
`'checkpoint_20'` | 772
`'checkpoint_21'` | 794
`'checkpoint_22'` | 791
`'checkpoint_23'` | 815
`'checkpoint_24'` | 862
`'checkpoint_25'` | 812
`'checkpoint_26'` | 771
`'checkpoint_27'` | 777
`'checkpoint_28'` | 787
`'checkpoint_29'` | 764
`'checkpoint_30'` | 759
`'checkpoint_31'` | 751
`'checkpoint_32'` | 737
`'checkpoint_33'` | 783
`'checkpoint_34'` | 803
`'checkpoint_35'` | 763
`'checkpoint_36'` | 757
`'checkpoint_37'` | 737
`'checkpoint_38'` | 743
`'checkpoint_39'` | 735
`'checkpoint_40'` | 747
`'checkpoint_41'` | 736
`'checkpoint_42'` | 760
`'checkpoint_43'` | 734
`'checkpoint_44'` | 767
`'checkpoint_45'` | 788
`'checkpoint_46'` | 781
`'checkpoint_47'` | 760
`'checkpoint_48'` | 784
`'checkpoint_49'` | 772

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):
    Only shown for the first 100 configs.

## rlu_atari_checkpoints/WizardOfWor_run_3

*   **Dataset size**: `60.47 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 1,023
`'checkpoint_01'` | 966
`'checkpoint_02'` | 892
`'checkpoint_03'` | 916
`'checkpoint_04'` | 850
`'checkpoint_05'` | 812
`'checkpoint_06'` | 739
`'checkpoint_07'` | 708
`'checkpoint_08'` | 701
`'checkpoint_09'` | 670
`'checkpoint_10'` | 651
`'checkpoint_11'` | 698
`'checkpoint_12'` | 719
`'checkpoint_13'` | 745
`'checkpoint_14'` | 816
`'checkpoint_15'` | 801
`'checkpoint_16'` | 819
`'checkpoint_17'` | 997
`'checkpoint_18'` | 925
`'checkpoint_19'` | 868
`'checkpoint_20'` | 902
`'checkpoint_21'` | 905
`'checkpoint_22'` | 929
`'checkpoint_23'` | 895
`'checkpoint_24'` | 894
`'checkpoint_25'` | 890
`'checkpoint_26'` | 918
`'checkpoint_27'` | 1,281
`'checkpoint_28'` | 1,445
`'checkpoint_29'` | 1,423
`'checkpoint_30'` | 1,108
`'checkpoint_31'` | 1,000
`'checkpoint_32'` | 867
`'checkpoint_33'` | 910
`'checkpoint_34'` | 928
`'checkpoint_35'` | 918
`'checkpoint_36'` | 1,092
`'checkpoint_37'` | 1,117
`'checkpoint_38'` | 954
`'checkpoint_39'` | 967
`'checkpoint_40'` | 1,013
`'checkpoint_41'` | 1,001
`'checkpoint_42'` | 950
`'checkpoint_43'` | 1,022
`'checkpoint_44'` | 1,001
`'checkpoint_45'` | 1,142
`'checkpoint_46'` | 1,121
`'checkpoint_47'` | 1,141
`'checkpoint_48'` | 1,228
`'checkpoint_49'` | 1,240

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):
    Only shown for the first 100 configs.

## rlu_atari_checkpoints/WizardOfWor_run_4

*   **Dataset size**: `60.10 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 1,104
`'checkpoint_01'` | 1,002
`'checkpoint_02'` | 843
`'checkpoint_03'` | 878
`'checkpoint_04'` | 863
`'checkpoint_05'` | 793
`'checkpoint_06'` | 757
`'checkpoint_07'` | 743
`'checkpoint_08'` | 739
`'checkpoint_09'` | 799
`'checkpoint_10'` | 779
`'checkpoint_11'` | 760
`'checkpoint_12'` | 763
`'checkpoint_13'` | 809
`'checkpoint_14'` | 789
`'checkpoint_15'` | 750
`'checkpoint_16'` | 768
`'checkpoint_17'` | 749
`'checkpoint_18'` | 762
`'checkpoint_19'` | 820
`'checkpoint_20'` | 907
`'checkpoint_21'` | 993
`'checkpoint_22'` | 969
`'checkpoint_23'` | 1,001
`'checkpoint_24'` | 927
`'checkpoint_25'` | 951
`'checkpoint_26'` | 872
`'checkpoint_27'` | 930
`'checkpoint_28'` | 924
`'checkpoint_29'` | 978
`'checkpoint_30'` | 1,037
`'checkpoint_31'` | 977
`'checkpoint_32'` | 967
`'checkpoint_33'` | 884
`'checkpoint_34'` | 926
`'checkpoint_35'` | 940
`'checkpoint_36'` | 1,031
`'checkpoint_37'` | 1,025
`'checkpoint_38'` | 1,017
`'checkpoint_39'` | 1,096
`'checkpoint_40'` | 1,070
`'checkpoint_41'` | 1,045
`'checkpoint_42'` | 1,078
`'checkpoint_43'` | 1,080
`'checkpoint_44'` | 1,070
`'checkpoint_45'` | 1,081
`'checkpoint_46'` | 1,078
`'checkpoint_47'` | 1,059
`'checkpoint_48'` | 1,026
`'checkpoint_49'` | 1,082

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):
    Only shown for the first 100 configs.

## rlu_atari_checkpoints/WizardOfWor_run_5

*   **Dataset size**: `60.80 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 1,066
`'checkpoint_01'` | 1,077
`'checkpoint_02'` | 919
`'checkpoint_03'` | 983
`'checkpoint_04'` | 837
`'checkpoint_05'` | 767
`'checkpoint_06'` | 772
`'checkpoint_07'` | 766
`'checkpoint_08'` | 935
`'checkpoint_09'` | 942
`'checkpoint_10'` | 874
`'checkpoint_11'` | 821
`'checkpoint_12'` | 782
`'checkpoint_13'` | 777
`'checkpoint_14'` | 746
`'checkpoint_15'` | 776
`'checkpoint_16'` | 703
`'checkpoint_17'` | 723
`'checkpoint_18'` | 704
`'checkpoint_19'` | 717
`'checkpoint_20'` | 732
`'checkpoint_21'` | 770
`'checkpoint_22'` | 727
`'checkpoint_23'` | 808
`'checkpoint_24'` | 818
`'checkpoint_25'` | 1,048
`'checkpoint_26'` | 959
`'checkpoint_27'` | 854
`'checkpoint_28'` | 944
`'checkpoint_29'` | 825
`'checkpoint_30'` | 857
`'checkpoint_31'` | 880
`'checkpoint_32'` | 876
`'checkpoint_33'` | 945
`'checkpoint_34'` | 1,034
`'checkpoint_35'` | 1,158
`'checkpoint_36'` | 1,408
`'checkpoint_37'` | 1,326
`'checkpoint_38'` | 1,302
`'checkpoint_39'` | 1,165
`'checkpoint_40'` | 1,124
`'checkpoint_41'` | 1,171
`'checkpoint_42'` | 1,094
`'checkpoint_43'` | 694
`'checkpoint_44'` | 627
`'checkpoint_45'` | 772
`'checkpoint_46'` | 869
`'checkpoint_47'` | 846
`'checkpoint_48'` | 727
`'checkpoint_49'` | 857

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):
    Only shown for the first 100 configs.

## rlu_atari_checkpoints/YarsRevenge_run_1

*   **Dataset size**: `69.21 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 2,116
`'checkpoint_01'` | 1,625
`'checkpoint_02'` | 1,441
`'checkpoint_03'` | 1,466
`'checkpoint_04'` | 1,506
`'checkpoint_05'` | 1,478
`'checkpoint_06'` | 1,444
`'checkpoint_07'` | 1,393
`'checkpoint_08'` | 1,379
`'checkpoint_09'` | 1,285
`'checkpoint_10'` | 1,174
`'checkpoint_11'` | 1,267
`'checkpoint_12'` | 1,222
`'checkpoint_13'` | 1,069
`'checkpoint_14'` | 1,117
`'checkpoint_15'` | 1,083
`'checkpoint_16'` | 1,027
`'checkpoint_17'` | 1,065
`'checkpoint_18'` | 992
`'checkpoint_19'` | 1,081
`'checkpoint_20'` | 1,061
`'checkpoint_21'` | 1,105
`'checkpoint_22'` | 990
`'checkpoint_23'` | 949
`'checkpoint_24'` | 1,100
`'checkpoint_25'` | 1,007
`'checkpoint_26'` | 1,043
`'checkpoint_27'` | 1,118
`'checkpoint_28'` | 1,035
`'checkpoint_29'` | 1,071
`'checkpoint_30'` | 1,023
`'checkpoint_31'` | 1,021
`'checkpoint_32'` | 1,019
`'checkpoint_33'` | 956
`'checkpoint_34'` | 977
`'checkpoint_35'` | 927
`'checkpoint_36'` | 1,058
`'checkpoint_37'` | 940
`'checkpoint_38'` | 875
`'checkpoint_39'` | 792
`'checkpoint_40'` | 966
`'checkpoint_41'` | 1,009
`'checkpoint_42'` | 956
`'checkpoint_43'` | 961
`'checkpoint_44'` | 1,007
`'checkpoint_45'` | 969
`'checkpoint_46'` | 1,030
`'checkpoint_47'` | 911
`'checkpoint_48'` | 975
`'checkpoint_49'` | 901

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):
    Only shown for the first 100 configs.

## rlu_atari_checkpoints/YarsRevenge_run_2

*   **Dataset size**: `70.15 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 2,112
`'checkpoint_01'` | 1,621
`'checkpoint_02'` | 1,462
`'checkpoint_03'` | 1,443
`'checkpoint_04'` | 1,317
`'checkpoint_05'` | 1,241
`'checkpoint_06'` | 1,345
`'checkpoint_07'` | 1,340
`'checkpoint_08'` | 1,324
`'checkpoint_09'` | 1,395
`'checkpoint_10'` | 1,476
`'checkpoint_11'` | 1,354
`'checkpoint_12'` | 1,348
`'checkpoint_13'` | 1,213
`'checkpoint_14'` | 1,149
`'checkpoint_15'` | 1,126
`'checkpoint_16'` | 1,131
`'checkpoint_17'` | 1,158
`'checkpoint_18'` | 957
`'checkpoint_19'` | 1,061
`'checkpoint_20'` | 1,025
`'checkpoint_21'` | 1,023
`'checkpoint_22'` | 1,084
`'checkpoint_23'` | 1,018
`'checkpoint_24'` | 975
`'checkpoint_25'` | 1,049
`'checkpoint_26'` | 1,013
`'checkpoint_27'` | 876
`'checkpoint_28'` | 903
`'checkpoint_29'` | 979
`'checkpoint_30'` | 1,042
`'checkpoint_31'` | 988
`'checkpoint_32'` | 922
`'checkpoint_33'` | 1,069
`'checkpoint_34'` | 952
`'checkpoint_35'` | 895
`'checkpoint_36'` | 910
`'checkpoint_37'` | 1,003
`'checkpoint_38'` | 908
`'checkpoint_39'` | 981
`'checkpoint_40'` | 1,021
`'checkpoint_41'` | 1,014
`'checkpoint_42'` | 1,054
`'checkpoint_43'` | 1,051
`'checkpoint_44'` | 975
`'checkpoint_45'` | 952
`'checkpoint_46'` | 884
`'checkpoint_47'` | 989
`'checkpoint_48'` | 1,092
`'checkpoint_49'` | 1,005

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):
    Only shown for the first 100 configs.

## rlu_atari_checkpoints/YarsRevenge_run_3

*   **Dataset size**: `70.41 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 2,096
`'checkpoint_01'` | 1,620
`'checkpoint_02'` | 1,479
`'checkpoint_03'` | 1,522
`'checkpoint_04'` | 1,455
`'checkpoint_05'` | 1,424
`'checkpoint_06'` | 1,393
`'checkpoint_07'` | 1,321
`'checkpoint_08'` | 1,485
`'checkpoint_09'` | 1,272
`'checkpoint_10'` | 1,426
`'checkpoint_11'` | 1,335
`'checkpoint_12'` | 1,209
`'checkpoint_13'` | 1,086
`'checkpoint_14'` | 1,077
`'checkpoint_15'` | 1,112
`'checkpoint_16'` | 1,160
`'checkpoint_17'` | 992
`'checkpoint_18'` | 1,062
`'checkpoint_19'` | 1,094
`'checkpoint_20'` | 1,054
`'checkpoint_21'` | 1,096
`'checkpoint_22'` | 1,148
`'checkpoint_23'` | 1,054
`'checkpoint_24'` | 1,040
`'checkpoint_25'` | 1,078
`'checkpoint_26'` | 1,006
`'checkpoint_27'` | 1,014
`'checkpoint_28'` | 977
`'checkpoint_29'` | 1,032
`'checkpoint_30'` | 888
`'checkpoint_31'` | 908
`'checkpoint_32'` | 1,032
`'checkpoint_33'` | 1,080
`'checkpoint_34'` | 1,012
`'checkpoint_35'` | 1,074
`'checkpoint_36'` | 1,091
`'checkpoint_37'` | 1,141
`'checkpoint_38'` | 1,051
`'checkpoint_39'` | 1,096
`'checkpoint_40'` | 975
`'checkpoint_41'` | 1,070
`'checkpoint_42'` | 1,097
`'checkpoint_43'` | 1,014
`'checkpoint_44'` | 1,025
`'checkpoint_45'` | 1,116
`'checkpoint_46'` | 982
`'checkpoint_47'` | 1,051
`'checkpoint_48'` | 1,090
`'checkpoint_49'` | 1,098

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):
    Only shown for the first 100 configs.

## rlu_atari_checkpoints/YarsRevenge_run_4

*   **Dataset size**: `69.32 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 2,247
`'checkpoint_01'` | 1,800
`'checkpoint_02'` | 1,520
`'checkpoint_03'` | 1,543
`'checkpoint_04'` | 1,418
`'checkpoint_05'` | 1,339
`'checkpoint_06'` | 1,458
`'checkpoint_07'` | 1,287
`'checkpoint_08'` | 1,355
`'checkpoint_09'` | 1,410
`'checkpoint_10'` | 1,305
`'checkpoint_11'` | 1,147
`'checkpoint_12'` | 1,173
`'checkpoint_13'` | 1,076
`'checkpoint_14'` | 1,223
`'checkpoint_15'` | 1,105
`'checkpoint_16'` | 1,104
`'checkpoint_17'` | 1,016
`'checkpoint_18'` | 1,156
`'checkpoint_19'` | 934
`'checkpoint_20'` | 1,040
`'checkpoint_21'` | 1,022
`'checkpoint_22'` | 1,024
`'checkpoint_23'` | 1,017
`'checkpoint_24'` | 930
`'checkpoint_25'` | 1,116
`'checkpoint_26'` | 1,005
`'checkpoint_27'` | 1,099
`'checkpoint_28'` | 942
`'checkpoint_29'` | 1,051
`'checkpoint_30'` | 970
`'checkpoint_31'` | 958
`'checkpoint_32'` | 859
`'checkpoint_33'` | 1,044
`'checkpoint_34'` | 952
`'checkpoint_35'` | 1,088
`'checkpoint_36'` | 1,089
`'checkpoint_37'` | 1,047
`'checkpoint_38'` | 1,051
`'checkpoint_39'` | 991
`'checkpoint_40'` | 912
`'checkpoint_41'` | 969
`'checkpoint_42'` | 926
`'checkpoint_43'` | 993
`'checkpoint_44'` | 976
`'checkpoint_45'` | 903
`'checkpoint_46'` | 937
`'checkpoint_47'` | 862
`'checkpoint_48'` | 902
`'checkpoint_49'` | 1,001

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):
    Only shown for the first 100 configs.

## rlu_atari_checkpoints/YarsRevenge_run_5

*   **Dataset size**: `71.13 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 2,248
`'checkpoint_01'` | 1,458
`'checkpoint_02'` | 1,448
`'checkpoint_03'` | 1,517
`'checkpoint_04'` | 1,400
`'checkpoint_05'` | 1,241
`'checkpoint_06'` | 1,293
`'checkpoint_07'` | 1,530
`'checkpoint_08'` | 1,424
`'checkpoint_09'` | 1,456
`'checkpoint_10'` | 1,401
`'checkpoint_11'` | 1,410
`'checkpoint_12'` | 1,320
`'checkpoint_13'` | 1,157
`'checkpoint_14'` | 1,052
`'checkpoint_15'` | 1,032
`'checkpoint_16'` | 1,109
`'checkpoint_17'` | 1,101
`'checkpoint_18'` | 1,064
`'checkpoint_19'` | 1,035
`'checkpoint_20'` | 1,169
`'checkpoint_21'` | 990
`'checkpoint_22'` | 1,020
`'checkpoint_23'` | 1,073
`'checkpoint_24'` | 1,069
`'checkpoint_25'` | 968
`'checkpoint_26'` | 1,141
`'checkpoint_27'` | 1,043
`'checkpoint_28'` | 1,107
`'checkpoint_29'` | 1,107
`'checkpoint_30'` | 1,029
`'checkpoint_31'` | 943
`'checkpoint_32'` | 1,088
`'checkpoint_33'` | 975
`'checkpoint_34'` | 999
`'checkpoint_35'` | 1,086
`'checkpoint_36'` | 1,027
`'checkpoint_37'` | 1,093
`'checkpoint_38'` | 866
`'checkpoint_39'` | 1,024
`'checkpoint_40'` | 885
`'checkpoint_41'` | 973
`'checkpoint_42'` | 979
`'checkpoint_43'` | 1,026
`'checkpoint_44'` | 925
`'checkpoint_45'` | 1,029
`'checkpoint_46'` | 952
`'checkpoint_47'` | 916
`'checkpoint_48'` | 1,033
`'checkpoint_49'` | 1,044

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):
    Only shown for the first 100 configs.

## rlu_atari_checkpoints/Zaxxon_run_1

*   **Dataset size**: `38.87 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 1,098
`'checkpoint_01'` | 1,101
`'checkpoint_02'` | 1,079
`'checkpoint_03'` | 1,022
`'checkpoint_04'` | 980
`'checkpoint_05'` | 931
`'checkpoint_06'` | 867
`'checkpoint_07'` | 825
`'checkpoint_08'` | 802
`'checkpoint_09'` | 721
`'checkpoint_10'` | 694
`'checkpoint_11'` | 682
`'checkpoint_12'` | 647
`'checkpoint_13'` | 622
`'checkpoint_14'` | 619
`'checkpoint_15'` | 572
`'checkpoint_16'` | 617
`'checkpoint_17'` | 571
`'checkpoint_18'` | 577
`'checkpoint_19'` | 571
`'checkpoint_20'` | 550
`'checkpoint_21'` | 546
`'checkpoint_22'` | 552
`'checkpoint_23'` | 533
`'checkpoint_24'` | 542
`'checkpoint_25'` | 516
`'checkpoint_26'` | 515
`'checkpoint_27'` | 541
`'checkpoint_28'` | 535
`'checkpoint_29'` | 527
`'checkpoint_30'` | 532
`'checkpoint_31'` | 538
`'checkpoint_32'` | 514
`'checkpoint_33'` | 509
`'checkpoint_34'` | 519
`'checkpoint_35'` | 514
`'checkpoint_36'` | 508
`'checkpoint_37'` | 502
`'checkpoint_38'` | 495
`'checkpoint_39'` | 502
`'checkpoint_40'` | 515
`'checkpoint_41'` | 512
`'checkpoint_42'` | 508
`'checkpoint_43'` | 487
`'checkpoint_44'` | 483
`'checkpoint_45'` | 506
`'checkpoint_46'` | 501
`'checkpoint_47'` | 526
`'checkpoint_48'` | 504
`'checkpoint_49'` | 516

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):
    Only shown for the first 100 configs.

## rlu_atari_checkpoints/Zaxxon_run_2

*   **Dataset size**: `39.03 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 1,088
`'checkpoint_01'` | 1,078
`'checkpoint_02'` | 1,054
`'checkpoint_03'` | 1,060
`'checkpoint_04'` | 1,041
`'checkpoint_05'` | 1,046
`'checkpoint_06'` | 1,041
`'checkpoint_07'` | 1,030
`'checkpoint_08'` | 1,006
`'checkpoint_09'` | 987
`'checkpoint_10'` | 941
`'checkpoint_11'` | 894
`'checkpoint_12'` | 781
`'checkpoint_13'` | 714
`'checkpoint_14'` | 692
`'checkpoint_15'` | 683
`'checkpoint_16'` | 681
`'checkpoint_17'` | 651
`'checkpoint_18'` | 646
`'checkpoint_19'` | 632
`'checkpoint_20'` | 591
`'checkpoint_21'` | 587
`'checkpoint_22'` | 585
`'checkpoint_23'` | 574
`'checkpoint_24'` | 578
`'checkpoint_25'` | 573
`'checkpoint_26'` | 542
`'checkpoint_27'` | 534
`'checkpoint_28'` | 521
`'checkpoint_29'` | 506
`'checkpoint_30'` | 499
`'checkpoint_31'` | 493
`'checkpoint_32'` | 459
`'checkpoint_33'` | 480
`'checkpoint_34'` | 492
`'checkpoint_35'` | 498
`'checkpoint_36'` | 482
`'checkpoint_37'` | 489
`'checkpoint_38'` | 482
`'checkpoint_39'` | 502
`'checkpoint_40'` | 498
`'checkpoint_41'` | 516
`'checkpoint_42'` | 494
`'checkpoint_43'` | 506
`'checkpoint_44'` | 530
`'checkpoint_45'` | 525
`'checkpoint_46'` | 515
`'checkpoint_47'` | 511
`'checkpoint_48'` | 503
`'checkpoint_49'` | 507

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):
    Only shown for the first 100 configs.

## rlu_atari_checkpoints/Zaxxon_run_3

*   **Dataset size**: `38.83 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 1,067
`'checkpoint_01'` | 1,048
`'checkpoint_02'` | 1,064
`'checkpoint_03'` | 1,049
`'checkpoint_04'` | 1,023
`'checkpoint_05'` | 988
`'checkpoint_06'` | 922
`'checkpoint_07'` | 802
`'checkpoint_08'` | 698
`'checkpoint_09'` | 655
`'checkpoint_10'` | 654
`'checkpoint_11'` | 628
`'checkpoint_12'` | 569
`'checkpoint_13'` | 595
`'checkpoint_14'` | 579
`'checkpoint_15'` | 601
`'checkpoint_16'` | 579
`'checkpoint_17'` | 545
`'checkpoint_18'` | 546
`'checkpoint_19'` | 581
`'checkpoint_20'` | 561
`'checkpoint_21'` | 569
`'checkpoint_22'` | 579
`'checkpoint_23'` | 594
`'checkpoint_24'` | 564
`'checkpoint_25'` | 633
`'checkpoint_26'` | 576
`'checkpoint_27'` | 558
`'checkpoint_28'` | 554
`'checkpoint_29'` | 549
`'checkpoint_30'` | 539
`'checkpoint_31'` | 548
`'checkpoint_32'` | 534
`'checkpoint_33'` | 521
`'checkpoint_34'` | 521
`'checkpoint_35'` | 537
`'checkpoint_36'` | 502
`'checkpoint_37'` | 510
`'checkpoint_38'` | 511
`'checkpoint_39'` | 498
`'checkpoint_40'` | 504
`'checkpoint_41'` | 523
`'checkpoint_42'` | 541
`'checkpoint_43'` | 527
`'checkpoint_44'` | 530
`'checkpoint_45'` | 501
`'checkpoint_46'` | 511
`'checkpoint_47'` | 482
`'checkpoint_48'` | 507
`'checkpoint_49'` | 489

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):
    Only shown for the first 100 configs.

## rlu_atari_checkpoints/Zaxxon_run_4

*   **Dataset size**: `39.13 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 1,072
`'checkpoint_01'` | 1,046
`'checkpoint_02'` | 1,020
`'checkpoint_03'` | 996
`'checkpoint_04'` | 946
`'checkpoint_05'` | 917
`'checkpoint_06'` | 831
`'checkpoint_07'` | 717
`'checkpoint_08'` | 707
`'checkpoint_09'` | 680
`'checkpoint_10'` | 663
`'checkpoint_11'` | 650
`'checkpoint_12'` | 632
`'checkpoint_13'` | 616
`'checkpoint_14'` | 592
`'checkpoint_15'` | 605
`'checkpoint_16'` | 589
`'checkpoint_17'` | 542
`'checkpoint_18'` | 565
`'checkpoint_19'` | 572
`'checkpoint_20'` | 593
`'checkpoint_21'` | 571
`'checkpoint_22'` | 599
`'checkpoint_23'` | 602
`'checkpoint_24'` | 592
`'checkpoint_25'` | 625
`'checkpoint_26'` | 668
`'checkpoint_27'` | 643
`'checkpoint_28'` | 661
`'checkpoint_29'` | 696
`'checkpoint_30'` | 651
`'checkpoint_31'` | 639
`'checkpoint_32'` | 596
`'checkpoint_33'` | 634
`'checkpoint_34'` | 592
`'checkpoint_35'` | 587
`'checkpoint_36'` | 595
`'checkpoint_37'` | 594
`'checkpoint_38'` | 577
`'checkpoint_39'` | 572
`'checkpoint_40'` | 584
`'checkpoint_41'` | 560
`'checkpoint_42'` | 561
`'checkpoint_43'` | 583
`'checkpoint_44'` | 568
`'checkpoint_45'` | 547
`'checkpoint_46'` | 560
`'checkpoint_47'` | 563
`'checkpoint_48'` | 548
`'checkpoint_49'` | 543

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):
    Only shown for the first 100 configs.

## rlu_atari_checkpoints/Zaxxon_run_5

*   **Dataset size**: `37.57 GiB`

*   **Splits**:

Split             | Examples
:---------------- | -------:
`'checkpoint_00'` | 1,100
`'checkpoint_01'` | 1,102
`'checkpoint_02'` | 1,115
`'checkpoint_03'` | 1,109
`'checkpoint_04'` | 1,106
`'checkpoint_05'` | 1,111
`'checkpoint_06'` | 1,107
`'checkpoint_07'` | 1,095
`'checkpoint_08'` | 1,104
`'checkpoint_09'` | 1,110
`'checkpoint_10'` | 1,107
`'checkpoint_11'` | 1,091
`'checkpoint_12'` | 1,068
`'checkpoint_13'` | 1,094
`'checkpoint_14'` | 1,051
`'checkpoint_15'` | 1,053
`'checkpoint_16'` | 1,080
`'checkpoint_17'` | 1,068
`'checkpoint_18'` | 1,070
`'checkpoint_19'` | 1,083
`'checkpoint_20'` | 1,050
`'checkpoint_21'` | 1,055
`'checkpoint_22'` | 1,061
`'checkpoint_23'` | 1,063
`'checkpoint_24'` | 1,041
`'checkpoint_25'` | 1,026
`'checkpoint_26'` | 1,071
`'checkpoint_27'` | 1,037
`'checkpoint_28'` | 993
`'checkpoint_29'` | 996
`'checkpoint_30'` | 860
`'checkpoint_31'` | 741
`'checkpoint_32'` | 724
`'checkpoint_33'` | 701
`'checkpoint_34'` | 672
`'checkpoint_35'` | 657
`'checkpoint_36'` | 650
`'checkpoint_37'` | 647
`'checkpoint_38'` | 636
`'checkpoint_39'` | 622
`'checkpoint_40'` | 596
`'checkpoint_41'` | 576
`'checkpoint_42'` | 545
`'checkpoint_43'` | 580
`'checkpoint_44'` | 568
`'checkpoint_45'` | 566
`'checkpoint_46'` | 544
`'checkpoint_47'` | 539
`'checkpoint_48'` | 536
`'checkpoint_49'` | 524

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):
    Only shown for the first 100 configs.
