<div itemscope itemtype="http://schema.org/Dataset">
  <div itemscope itemprop="includedInDataCatalog" itemtype="http://schema.org/DataCatalog">
    <meta itemprop="name" content="TensorFlow Datasets" />
  </div>
  <meta itemprop="name" content="wiki_dialog" />
  <meta itemprop="description" content="WikiDialog is a large dataset of synthetically generated information-seeking&#10;conversations. Each conversation in the dataset contains two speakers grounded&#10;in a passage from English Wikipedia: one speaker’s utterances consist of exact&#10;sentences from the passage; the other speaker is generated by a large language&#10;model.&#10;&#10;To use this dataset:&#10;&#10;```python&#10;import tensorflow_datasets as tfds&#10;&#10;ds = tfds.load(&#x27;wiki_dialog&#x27;, split=&#x27;train&#x27;)&#10;for ex in ds.take(4):&#10;  print(ex)&#10;```&#10;&#10;See [the guide](https://www.tensorflow.org/datasets/overview) for more&#10;informations on [tensorflow_datasets](https://www.tensorflow.org/datasets).&#10;&#10;" />
  <meta itemprop="url" content="https://www.tensorflow.org/datasets/catalog/wiki_dialog" />
  <meta itemprop="sameAs" content="https://github.com/google-research/dialog-inpainting#wikidialog-oq" />
  <meta itemprop="citation" content="@inproceedings{dai2022dialoginpainting,&#10;  title={Dialog Inpainting: Turning Documents to Dialogs},&#10;  author={Dai, Zhuyun and Chaganty, Arun Tejasvi and Zhao, Vincent and Amini, Aida and Green, Mike and Rashid, Qazi and Guu, Kelvin},&#10;  booktitle={International Conference on Machine Learning (ICML)},&#10;  year={2022},&#10;  organization={PMLR}&#10;}" />
</div>

# `wiki_dialog`


*   **Description**:

WikiDialog is a large dataset of synthetically generated information-seeking
conversations. Each conversation in the dataset contains two speakers grounded
in a passage from English Wikipedia: one speaker’s utterances consist of exact
sentences from the passage; the other speaker is generated by a large language
model.

*   **Config description**: WikiDialog generated from the dialog inpainter
    finetuned on OR-QuAC and QReCC. `OQ` stands for OR-QuAC and QReCC.

*   **Homepage**:
    [https://github.com/google-research/dialog-inpainting#wikidialog-oq](https://github.com/google-research/dialog-inpainting#wikidialog-oq)

*   **Source code**:
    [`tfds.text.wiki_dialog.WikiDialog`](https://github.com/tensorflow/datasets/tree/master/tensorflow_datasets/text/wiki_dialog/wiki_dialog.py)

*   **Versions**:

    *   **`1.0.0`** (default): Initial release.

*   **Download size**: `7.04 GiB`

*   **Dataset size**: `36.58 GiB`

*   **Auto-cached**
    ([documentation](https://www.tensorflow.org/datasets/performances#auto-caching)):
    No

*   **Splits**:

Split          | Examples
:------------- | ---------:
`'train'`      | 11,264,129
`'validation'` | 113,822

*   **Feature structure**:

```python
FeaturesDict({
    'author_num': Sequence(int32),
    'passage': Text(shape=(), dtype=string),
    'pid': Text(shape=(), dtype=string),
    'sentences': Sequence(Text(shape=(), dtype=string)),
    'title': Text(shape=(), dtype=string),
    'utterances': Sequence(Text(shape=(), dtype=string)),
})
```

*   **Feature documentation**:

Feature    | Class            | Shape   | Dtype  | Description
:--------- | :--------------- | :------ | :----- | :----------
           | FeaturesDict     |         |        |
author_num | Sequence(Tensor) | (None,) | int32  |
passage    | Text             |         | string |
pid        | Text             |         | string |
sentences  | Sequence(Text)   | (None,) | string |
title      | Text             |         | string |
utterances | Sequence(Text)   | (None,) | string |

*   **Supervised keys** (See
    [`as_supervised` doc](https://www.tensorflow.org/datasets/api_docs/python/tfds/load#args)):
    `None`

*   **Figure**
    ([tfds.show_examples](https://www.tensorflow.org/datasets/api_docs/python/tfds/visualization/show_examples)):
    Not supported.

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):

<!-- mdformat off(HTML should not be auto-formatted) -->

{% framebox %}

<button id="displaydataframe">Display examples...</button>
<div id="dataframecontent" style="overflow-x:auto"></div>
<script>
const url = "https://storage.googleapis.com/tfds-data/visualization/dataframe/wiki_dialog-OQ-1.0.0.html";
const dataButton = document.getElementById('displaydataframe');
dataButton.addEventListener('click', async () => {
  // Disable the button after clicking (dataframe loaded only once).
  dataButton.disabled = true;

  const contentPane = document.getElementById('dataframecontent');
  try {
    const response = await fetch(url);
    // Error response codes don't throw an error, so force an error to show
    // the error message.
    if (!response.ok) throw Error(response.statusText);

    const data = await response.text();
    contentPane.innerHTML = data;
  } catch (e) {
    contentPane.innerHTML =
        'Error loading examples. If the error persist, please open '
        + 'a new issue.';
  }
});
</script>

{% endframebox %}

<!-- mdformat on -->

*   **Citation**:

```
@inproceedings{dai2022dialoginpainting,
  title={Dialog Inpainting: Turning Documents to Dialogs},
  author={Dai, Zhuyun and Chaganty, Arun Tejasvi and Zhao, Vincent and Amini, Aida and Green, Mike and Rashid, Qazi and Guu, Kelvin},
  booktitle={International Conference on Machine Learning (ICML)},
  year={2022},
  organization={PMLR}
}
```


## wiki_dialog/OQ (default config)
