# cail2018

References:

*   [Code](https://github.com/huggingface/datasets/blob/master/datasets/cail2018)
*   [Huggingface](https://huggingface.co/datasets/cail2018)



Use the following command to load this dataset in TFDS:

```python
ds = tfds.load('huggingface:cail2018')
```

*   **Description**:

```
In this paper, we introduce Chinese AI and Law challenge dataset (CAIL2018),
the first large-scale Chinese legal dataset for judgment prediction. CAIL contains more than 2.6 million
criminal cases published by the Supreme People's Court of China, which are several times larger than other
datasets in existing works on judgment prediction. Moreover, the annotations of judgment results are more
detailed and rich. It consists of applicable law articles, charges, and prison terms, which are expected
to be inferred according to the fact descriptions of cases. For comparison, we implement several conventional
text classification baselines for judgment prediction and experimental results show that it is still a
challenge for current models to predict the judgment results of legal cases, especially on prison terms.
To help the researchers make improvements on legal judgment prediction.
```

*   **License**: No known license
*   **Version**: 1.0.0
*   **Splits**:

Split  | Examples
:----- | -------:
`'exercise_contest_test'` | 32508
`'exercise_contest_train'` | 154592
`'exercise_contest_valid'` | 17131
`'final_test'` | 35922
`'first_stage_test'` | 217016
`'first_stage_train'` | 1710856

*   **Features**:

```json
{
    "fact": {
        "dtype": "string",
        "id": null,
        "_type": "Value"
    },
    "relevant_articles": {
        "feature": {
            "dtype": "int32",
            "id": null,
            "_type": "Value"
        },
        "length": -1,
        "id": null,
        "_type": "Sequence"
    },
    "accusation": {
        "feature": {
            "dtype": "string",
            "id": null,
            "_type": "Value"
        },
        "length": -1,
        "id": null,
        "_type": "Sequence"
    },
    "punish_of_money": {
        "dtype": "float32",
        "id": null,
        "_type": "Value"
    },
    "criminals": {
        "feature": {
            "dtype": "string",
            "id": null,
            "_type": "Value"
        },
        "length": -1,
        "id": null,
        "_type": "Sequence"
    },
    "death_penalty": {
        "dtype": "bool",
        "id": null,
        "_type": "Value"
    },
    "imprisonment": {
        "dtype": "float32",
        "id": null,
        "_type": "Value"
    },
    "life_imprisonment": {
        "dtype": "bool",
        "id": null,
        "_type": "Value"
    }
}
```


