# consumer-finance-complaints

References:

*   [Code](https://github.com/huggingface/datasets/blob/master/datasets/consumer-finance-complaints)
*   [Huggingface](https://huggingface.co/datasets/consumer-finance-complaints)



Use the following command to load this dataset in TFDS:

```python
ds = tfds.load('huggingface:consumer-finance-complaints')
```

*   **Description**:

```
The Consumer Complaint Database is a collection of complaints about consumer financial products and services that we sent to companies for response. Complaints are published after the company responds, confirming a commercial relationship with the consumer, or after 15 days, whichever comes first. Complaints referred to other regulators, such as complaints about depository institutions with less than $10 billion in assets, are not published in the Consumer Complaint Database. The database generally updates daily.
There are multiple Text Classification problems that can be solved with this dataset:
- Complaint Type Identification
- Complaint Sub-Product Identification
- Complaint from vulnerable or Service-person
```

*   **License**: https://cfpb.github.io/source-code-policy/
*   **Version**: 0.0.0
*   **Splits**:

Split  | Examples
:----- | -------:
`'train'` | 2455765

*   **Features**:

```json
{
    "Date Received": {
        "dtype": "timestamp[s]",
        "id": null,
        "_type": "Value"
    },
    "Product": {
        "num_classes": 18,
        "names": [
            "Credit reporting, credit repair services, or other personal consumer reports",
            "Debt collection",
            "Mortgage",
            "Credit card or prepaid card",
            "Checking or savings account",
            "Credit reporting",
            "Student loan",
            "Money transfer, virtual currency, or money service",
            "Credit card",
            "Vehicle loan or lease",
            "Bank account or service",
            "Payday loan, title loan, or personal loan",
            "Consumer Loan",
            "Payday loan",
            "Money transfers",
            "Prepaid card",
            "Other financial service",
            "Virtual currency"
        ],
        "names_file": null,
        "id": null,
        "_type": "ClassLabel"
    },
    "Sub Product": {
        "num_classes": 77,
        "names": [
            "Credit reporting",
            "General-purpose credit card or charge card",
            "Checking account",
            "Other debt",
            "Second mortgage",
            "Conventional home mortgage",
            "I do not know",
            "Credit card debt",
            "Medical debt",
            "Federal student loan servicing",
            "FHA mortgage",
            "Conventional fixed mortgage",
            "Loan",
            "Other (i.e. phone, health club, etc.)",
            "Store credit card",
            "Installment loan",
            "Credit card",
            "Medical",
            "Mobile or digital wallet",
            "Private student loan",
            "Non-federal student loan",
            "Domestic (US) money transfer",
            "VA mortgage",
            "Vehicle loan",
            "Auto debt",
            "Payday loan",
            "Conventional adjustable mortgage (ARM)",
            "Other personal consumer report",
            "Payday loan debt",
            "Savings account",
            "Virtual currency",
            "Other bank product/service",
            "Other type of mortgage",
            "Other banking product or service",
            "Other mortgage",
            "International money transfer",
            "Lease",
            "General-purpose prepaid card",
            "Home equity loan or line of credit (HELOC)",
            "Government benefit card",
            "Mortgage debt",
            "Personal line of credit",
            "Home equity loan or line of credit",
            "Federal student loan debt",
            "Private student loan debt",
            "Credit repair services",
            "Title loan",
            "Auto",
            "Vehicle lease",
            "Mortgage",
            "Reverse mortgage",
            "General purpose card",
            "CD (Certificate of Deposit)",
            "Federal student loan",
            "Payroll card",
            "Debt settlement",
            "Check cashing service",
            "Traveler's check or cashier's check",
            "Gift card",
            "(CD) Certificate of deposit",
            "Money order",
            "Foreign currency exchange",
            "Refund anticipation check",
            "Gift or merchant card",
            "Cashing a check without an account",
            "ID prepaid card",
            "Mobile wallet",
            "Government benefit payment card",
            "Pawn loan",
            "Other special purpose card",
            "Check cashing",
            "Credit repair",
            "Traveler\u2019s/Cashier\u2019s checks",
            "Transit card",
            "Student prepaid card",
            "Electronic Benefit Transfer / EBT card",
            ""
        ],
        "names_file": null,
        "id": null,
        "_type": "ClassLabel"
    },
    "Issue": {
        "dtype": "string",
        "id": null,
        "_type": "Value"
    },
    "Sub Issue": {
        "dtype": "string",
        "id": null,
        "_type": "Value"
    },
    "Complaint Text": {
        "dtype": "string",
        "id": null,
        "_type": "Value"
    },
    "Company Public Response": {
        "dtype": "string",
        "id": null,
        "_type": "Value"
    },
    "Company": {
        "dtype": "string",
        "id": null,
        "_type": "Value"
    },
    "State": {
        "dtype": "string",
        "id": null,
        "_type": "Value"
    },
    "Zip Code": {
        "dtype": "string",
        "id": null,
        "_type": "Value"
    },
    "Tags": {
        "num_classes": 4,
        "names": [
            "Servicemember",
            "Older American",
            "Older American, Servicemember",
            ""
        ],
        "names_file": null,
        "id": null,
        "_type": "ClassLabel"
    },
    "Consumer Consent Provided": {
        "dtype": "string",
        "id": null,
        "_type": "Value"
    },
    "Submitted via": {
        "dtype": "string",
        "id": null,
        "_type": "Value"
    },
    "Date Sent To Company": {
        "dtype": "string",
        "id": null,
        "_type": "Value"
    },
    "Company Response To Consumer": {
        "dtype": "string",
        "id": null,
        "_type": "Value"
    },
    "Timely Response": {
        "dtype": "string",
        "id": null,
        "_type": "Value"
    },
    "Consumer Disputed": {
        "dtype": "string",
        "id": null,
        "_type": "Value"
    },
    "Complaint ID": {
        "dtype": "string",
        "id": null,
        "_type": "Value"
    }
}
```


