# greek_legal_code

References:

*   [Code](https://github.com/huggingface/datasets/blob/master/datasets/greek_legal_code)
*   [Huggingface](https://huggingface.co/datasets/greek_legal_code)


## volume


Use the following command to load this dataset in TFDS:

```python
ds = tfds.load('huggingface:greek_legal_code/volume')
```

*   **Description**:

```
Greek_Legal_Code contains 47k classified legal resources from Greek Legislation. Its origin is “Permanent Greek Legislation Code - Raptarchis”,
a collection of Greek legislative documents classified into multi-level (from broader to more specialized) categories.
```

*   **License**: CC BY-SA (Creative Commons / Attribution-ShareAlike)
*   **Version**: 1.0.0
*   **Splits**:

Split  | Examples
:----- | -------:
`'test'` | 9516
`'train'` | 28536
`'validation'` | 9511

*   **Features**:

```json
{
    "text": {
        "dtype": "string",
        "id": null,
        "_type": "Value"
    },
    "label": {
        "num_classes": 47,
        "names": [
            "\u039a\u039f\u0399\u039d\u03a9\u039d\u0399\u039a\u0397 \u03a0\u03a1\u039f\u039d\u039f\u0399\u0391",
            "\u0393\u0395\u03a9\u03a1\u0393\u0399\u039a\u0397 \u039d\u039f\u039c\u039f\u0398\u0395\u03a3\u0399\u0391",
            "\u03a1\u0391\u0394\u0399\u039f\u03a6\u03a9\u039d\u0399\u0391 \u039a\u0391\u0399 \u03a4\u03a5\u03a0\u039f\u03a3",
            "\u0392\u0399\u039f\u039c\u0397\u03a7\u0391\u039d\u0399\u039a\u0397 \u039d\u039f\u039c\u039f\u0398\u0395\u03a3\u0399\u0391",
            "\u03a5\u0393\u0395\u0399\u039f\u039d\u039f\u039c\u0399\u039a\u0397 \u039d\u039f\u039c\u039f\u0398\u0395\u03a3\u0399\u0391",
            "\u03a0\u039f\u039b\u0395\u039c\u0399\u039a\u039f \u039d\u0391\u03a5\u03a4\u0399\u039a\u039f",
            "\u03a4\u0391\u03a7\u03a5\u0394\u03a1\u039f\u039c\u0395\u0399\u0391 - \u03a4\u0397\u039b\u0395\u03a0\u0399\u039a\u039f\u0399\u039d\u03a9\u039d\u0399\u0395\u03a3",
            "\u0394\u0391\u03a3\u0397 \u039a\u0391\u0399 \u039a\u03a4\u0397\u039d\u039f\u03a4\u03a1\u039f\u03a6\u0399\u0391",
            "\u0395\u039b\u0395\u0393\u039a\u03a4\u0399\u039a\u039f \u03a3\u03a5\u039d\u0395\u0394\u03a1\u0399\u039f \u039a\u0391\u0399 \u03a3\u03a5\u039d\u03a4\u0391\u039e\u0395\u0399\u03a3",
            "\u03a0\u039f\u039b\u0395\u039c\u0399\u039a\u0397 \u0391\u0395\u03a1\u039f\u03a0\u039f\u03a1\u0399\u0391",
            "\u039d\u039f\u039c\u0399\u039a\u0391 \u03a0\u03a1\u039f\u03a3\u03a9\u03a0\u0391 \u0394\u0397\u039c\u039f\u03a3\u0399\u039f\u03a5 \u0394\u0399\u039a\u0391\u0399\u039f\u03a5",
            "\u039d\u039f\u039c\u039f\u0398\u0395\u03a3\u0399\u0391 \u0391\u039d\u03a9\u039d\u03a5\u039c\u03a9\u039d \u0395\u03a4\u0391\u0399\u03a1\u0395\u0399\u03a9\u039d \u03a4\u03a1\u0391\u03a0\u0395\u0396\u03a9\u039d \u039a\u0391\u0399 \u03a7\u03a1\u0397\u039c\u0391\u03a4\u0399\u03a3\u03a4\u0397\u03a1\u0399\u03a9\u039d",
            "\u03a0\u039f\u039b\u0399\u03a4\u0399\u039a\u0397 \u0391\u0395\u03a1\u039f\u03a0\u039f\u03a1\u0399\u0391",
            "\u0395\u039c\u039c\u0395\u03a3\u0397 \u03a6\u039f\u03a1\u039f\u039b\u039f\u0393\u0399\u0391",
            "\u039a\u039f\u0399\u039d\u03a9\u039d\u0399\u039a\u0395\u03a3 \u0391\u03a3\u03a6\u0391\u039b\u0399\u03a3\u0395\u0399\u03a3",
            "\u039d\u039f\u039c\u039f\u0398\u0395\u03a3\u0399\u0391 \u0394\u0397\u039c\u03a9\u039d \u039a\u0391\u0399 \u039a\u039f\u0399\u039d\u039f\u03a4\u0397\u03a4\u03a9\u039d",
            "\u039d\u039f\u039c\u039f\u0398\u0395\u03a3\u0399\u0391 \u0395\u03a0\u0399\u039c\u0395\u039b\u0397\u03a4\u0397\u03a1\u0399\u03a9\u039d \u03a3\u03a5\u039d\u0395\u03a4\u0391\u0399\u03a1\u0399\u03a3\u039c\u03a9\u039d \u039a\u0391\u0399 \u03a3\u03a9\u039c\u0391\u03a4\u0395\u0399\u03a9\u039d",
            "\u0394\u0397\u039c\u039f\u03a3\u0399\u0391 \u0395\u03a1\u0393\u0391",
            "\u0394\u0399\u039f\u0399\u039a\u0397\u03a3\u0397 \u0394\u0399\u039a\u0391\u0399\u039f\u03a3\u03a5\u039d\u0397\u03a3",
            "\u0391\u03a3\u03a6\u0391\u039b\u0399\u03a3\u03a4\u0399\u039a\u0391 \u03a4\u0391\u039c\u0395\u0399\u0391",
            "\u0395\u039a\u039a\u039b\u0397\u03a3\u0399\u0391\u03a3\u03a4\u0399\u039a\u0397 \u039d\u039f\u039c\u039f\u0398\u0395\u03a3\u0399\u0391",
            "\u0395\u039a\u03a0\u0391\u0399\u0394\u0395\u03a5\u03a4\u0399\u039a\u0397 \u039d\u039f\u039c\u039f\u0398\u0395\u03a3\u0399\u0391",
            "\u0394\u0397\u039c\u039f\u03a3\u0399\u039f \u039b\u039f\u0393\u0399\u03a3\u03a4\u0399\u039a\u039f",
            "\u03a4\u0395\u039b\u03a9\u039d\u0395\u0399\u0391\u039a\u0397 \u039d\u039f\u039c\u039f\u0398\u0395\u03a3\u0399\u0391",
            "\u03a3\u03a5\u0393\u039a\u039f\u0399\u039d\u03a9\u039d\u0399\u0395\u03a3",
            "\u0395\u0398\u039d\u0399\u039a\u0397 \u0391\u039c\u03a5\u039d\u0391",
            "\u03a3\u03a4\u03a1\u0391\u03a4\u039f\u03a3 \u039e\u0397\u03a1\u0391\u03a3",
            "\u0391\u0393\u039f\u03a1\u0391\u039d\u039f\u039c\u0399\u039a\u0397 \u039d\u039f\u039c\u039f\u0398\u0395\u03a3\u0399\u0391",
            "\u0394\u0397\u039c\u039f\u03a3\u0399\u039f\u0399 \u03a5\u03a0\u0391\u039b\u039b\u0397\u039b\u039f\u0399",
            "\u03a0\u0395\u03a1\u0399\u039f\u03a5\u03a3\u0399\u0391 \u0394\u0397\u039c\u039f\u03a3\u0399\u039f\u03a5 \u039a\u0391\u0399 \u039d\u039f\u039c\u0399\u03a3\u039c\u0391",
            "\u039f\u0399\u039a\u039f\u039d\u039f\u039c\u0399\u039a\u0397 \u0394\u0399\u039f\u0399\u039a\u0397\u03a3\u0397",
            "\u039b\u0399\u039c\u0395\u039d\u0399\u039a\u0397 \u039d\u039f\u039c\u039f\u0398\u0395\u03a3\u0399\u0391",
            "\u0391\u03a3\u03a4\u0399\u039a\u0397 \u039d\u039f\u039c\u039f\u0398\u0395\u03a3\u0399\u0391",
            "\u03a0\u039f\u039b\u0399\u03a4\u0399\u039a\u0397 \u0394\u0399\u039a\u039f\u039d\u039f\u039c\u0399\u0391",
            "\u0394\u0399\u03a0\u039b\u03a9\u039c\u0391\u03a4\u0399\u039a\u0397 \u039d\u039f\u039c\u039f\u0398\u0395\u03a3\u0399\u0391",
            "\u0394\u0399\u039f\u0399\u039a\u0397\u03a4\u0399\u039a\u0397 \u039d\u039f\u039c\u039f\u0398\u0395\u03a3\u0399\u0391",
            "\u0391\u039c\u0395\u03a3\u0397 \u03a6\u039f\u03a1\u039f\u039b\u039f\u0393\u0399\u0391",
            "\u03a4\u03a5\u03a0\u039f\u03a3 \u039a\u0391\u0399 \u03a4\u039f\u03a5\u03a1\u0399\u03a3\u039c\u039f\u03a3",
            "\u0395\u0398\u039d\u0399\u039a\u0397 \u039f\u0399\u039a\u039f\u039d\u039f\u039c\u0399\u0391",
            "\u0391\u03a3\u03a4\u03a5\u039d\u039f\u039c\u0399\u039a\u0397 \u039d\u039f\u039c\u039f\u0398\u0395\u03a3\u0399\u0391",
            "\u0391\u0393\u03a1\u039f\u03a4\u0399\u039a\u0397 \u039d\u039f\u039c\u039f\u0398\u0395\u03a3\u0399\u0391",
            "\u0395\u03a1\u0393\u0391\u03a4\u0399\u039a\u0397 \u039d\u039f\u039c\u039f\u0398\u0395\u03a3\u0399\u0391",
            "\u03a0\u039f\u0399\u039d\u0399\u039a\u0397 \u039d\u039f\u039c\u039f\u0398\u0395\u03a3\u0399\u0391",
            "\u0395\u039c\u03a0\u039f\u03a1\u0399\u039a\u0397 \u039d\u039f\u039c\u039f\u0398\u0395\u03a3\u0399\u0391",
            "\u0395\u03a0\u0399\u03a3\u03a4\u0397\u039c\u0395\u03a3 \u039a\u0391\u0399 \u03a4\u0395\u03a7\u039d\u0395\u03a3",
            "\u0395\u039c\u03a0\u039f\u03a1\u0399\u039a\u0397 \u039d\u0391\u03a5\u03a4\u0399\u039b\u0399\u0391",
            "\u03a3\u03a5\u039d\u03a4\u0391\u0393\u039c\u0391\u03a4\u0399\u039a\u0397 \u039d\u039f\u039c\u039f\u0398\u0395\u03a3\u0399\u0391"
        ],
        "names_file": null,
        "id": null,
        "_type": "ClassLabel"
    }
}
```



## chapter


Use the following command to load this dataset in TFDS:

```python
ds = tfds.load('huggingface:greek_legal_code/chapter')
```

*   **Description**:

```
Greek_Legal_Code contains 47k classified legal resources from Greek Legislation. Its origin is “Permanent Greek Legislation Code - Raptarchis”,
a collection of Greek legislative documents classified into multi-level (from broader to more specialized) categories.
```

*   **License**: CC BY-SA (Creative Commons / Attribution-ShareAlike)
*   **Version**: 1.0.0
*   **Splits**:

Split  | Examples
:----- | -------:
`'test'` | 9516
`'train'` | 28536
`'validation'` | 9511

*   **Features**:

```json
{
    "text": {
        "dtype": "string",
        "id": null,
        "_type": "Value"
    },
    "label": {
        "num_classes": 389,
        "names": [
            "\u039c\u0395\u03a4\u0391\u039b\u039b\u0395\u0399\u0391 \u039a\u0391\u0399 \u039f\u03a1\u03a5\u03a7\u0395\u0399\u0391",
            "\u03a3\u03a4\u0391\u03a4\u0399\u03a9\u03a4\u0399\u039a\u0395\u03a3 \u03a3\u03a7\u039f\u039b\u0395\u03a3",
            "\u03a0\u0391\u03a1\u039f\u03a7\u0395\u03a3 \u0391\u039d\u0395\u03a1\u0393\u0399\u0391\u03a3",
            "\u03a3\u0399\u0394\u0397\u03a1\u039f\u0394\u03a1\u039f\u039c\u0399\u039a\u0391 \u0394\u0399\u039a\u03a4\u03a5\u0391",
            "\u0395\u0399\u0394\u0399\u039a\u0391 \u03a3\u03a4\u03a1\u0391\u03a4\u0399\u03a9\u03a4\u0399\u039a\u0391 \u0391\u0394\u0399\u039a\u0397\u039c\u0391\u03a4\u0391",
            "\u039a\u03a1\u0391\u03a4\u0399\u039a\u0395\u03a3 \u03a0\u03a1\u039f\u039c\u0397\u0398\u0395\u0399\u0395\u03a3",
            "\u0391\u0393\u03a1\u039f\u03a4\u0399\u039a\u0397 \u0391\u03a0\u039f\u039a\u0391\u03a4\u0391\u03a3\u03a4\u0391\u03a3\u0397",
            "\u0391\u039e\u0399\u03a9\u039c\u0391\u03a4\u0399\u039a\u039f\u0399 \u03a0\u039f\u039b\u0395\u039c\u0399\u039a\u039f\u03a5 \u039d\u0391\u03a5\u03a4\u0399\u039a\u039f\u03a5",
            "\u03a3\u03a7\u0395\u0394\u0399\u0391 \u03a0\u039f\u039b\u0395\u03a9\u039d",
            "\u03a3\u03a5\u039a\u0391",
            "\u03a0\u03a1\u039f\u039b\u0397\u03a8\u0399\u03a3 \u039a\u0391\u0399 \u0394\u0399\u03a9\u039e\u0399\u03a3 \u03a4\u039f\u03a5 \u0395\u0393\u039a\u039b\u0397\u039c\u0391\u03a4\u039f\u03a3",
            "\u0394\u0399\u0395\u0398\u039d\u0395\u0399\u03a3 \u039c\u0395\u03a4\u0391\u03a6\u039f\u03a1\u0395\u03a3",
            "\u0393\u0395\u039d\u0399\u039a\u0397 \u03a3\u03a5\u0393\u039a\u039f\u0399\u039d\u03a9\u039d\u0399\u0391 \u039a\u0391\u0399 \u0394\u0399\u0391\u03a4\u0391\u039e\u0395\u0399\u03a3",
            "\u039a\u039b\u0397\u03a1\u039f\u039d\u039f\u039c\u0399\u039a\u039f \u0394\u0399\u039a\u0391\u0399\u039f",
            "\u039a\u039f\u0399\u039d\u03a9\u039d\u0399\u039a\u0397 \u0391\u039d\u03a4\u0399\u039b\u0397\u03a8\u0397",
            "\u039d\u0391\u03a5\u03a4\u0399\u039b\u0399\u0391\u039a\u0395\u03a3 \u03a3\u0397\u039c\u0391\u039d\u03a3\u0395\u0399\u03a3",
            "\u0394\u0399\u0395\u0398\u039d\u0395\u03a3 \u03a0\u039f\u0399\u039d\u0399\u039a\u039f \u0394\u0399\u039a\u0391\u0399\u039f",
            "\u0391\u03a3\u03a6\u0391\u039b\u0399\u03a3\u03a4\u0399\u039a\u039f\u0399 \u039f\u03a1\u0393\u0391\u039d\u0399\u03a3\u039c\u039f\u0399 \u0395.\u039d",
            "\u03a3\u03a9\u039c\u0391\u03a4\u0399\u039a\u0397 \u0391\u0393\u03a9\u0393\u0397",
            "\u03a3\u03a0\u039f\u03a1\u039f\u03a0\u0391\u03a1\u0391\u0393\u03a9\u0393\u0397",
            "\u03a5\u03a0\u0397\u03a1\u0395\u03a3\u0399\u0391\u0399 \u0394\u0397\u039c\u039f\u03a3\u0399\u03a9\u039d \u0395\u03a1\u0393\u03a9\u039d",
            "\u03a4\u0391\u039c\u0395\u0399\u0391 \u03a3\u03a5\u039d\u03a4\u0391\u039e\u0395\u03a9\u039d \u03a4\u03a1\u0391\u03a0\u0395\u0396\u03a9\u039d",
            "\u03a0\u03a5\u03a1\u039f\u03a3\u0392\u0395\u03a3\u03a4\u0399\u039a\u039f \u03a3\u03a9\u039c\u0391",
            "\u0394\u0399\u0391\u03a6\u039f\u03a1\u0395\u03a3 \u0392\u0399\u039f\u039c\u0397\u03a7\u0391\u039d\u0399\u0395\u03a3",
            "\u0395\u039a\u03a4\u0395\u039b\u0395\u03a3\u0397 \u039a\u0391\u0399 \u03a3\u03a5\u039d\u0395\u03a0\u0395\u0399\u0395\u03a3 \u03a4\u0397\u03a3 \u03a0\u039f\u0399\u039d\u0397\u03a3",
            "\u0394\u0399\u0395\u0398\u039d\u0395\u0399\u03a3 \u0391\u03a3\u03a6\u0391\u039b\u0399\u03a3\u03a4\u0399\u039a\u0395\u03a3 \u03a3\u03a5\u039c\u0392\u0391\u03a3\u0395\u0399\u03a3",
            "\u039d\u039f\u039c\u039f\u0398\u0395\u03a3\u0399\u0391",
            "\u0392\u0391\u039c\u0392\u0391\u039a\u0399",
            "\u03a0\u0391\u03a1\u039f\u03a7\u0395\u03a3 \u03a3\u03a5\u039d\u03a4\u0391\u039e\u0395\u03a9\u039d",
            "\u039d\u039f\u039c\u0399\u03a3\u039c\u0391",
            "\u03a3\u03a5\u039c\u0392\u0391\u03a3\u0397 \u039d\u0391\u03a5\u03a4\u0399\u039a\u0397\u03a3 \u0395\u03a1\u0393\u0391\u03a3\u0399\u0391\u03a3",
            "\u039f\u03a1\u0393\u0391\u039d\u0399\u03a3\u039c\u039f\u038a \u039a\u039f\u0399\u039d\u03a9\u039d\u0399\u039a\u0389\u03a3 \u0391\u03a3\u03a6\u0391\u039b\u038a\u03a3\u0395\u03a9\u03a3",
            "\u0391\u0393\u03a1\u039f\u03a4\u0399\u039a\u0397 \u0391\u03a3\u03a6\u0391\u039b\u0395\u0399\u0391",
            "\u03a5\u0393\u0395\u0399\u039f\u039d\u039f\u039c\u0399\u039a\u039f\u03a3 \u0395\u039b\u0395\u0393\u03a7\u039f\u03a3 \u0395\u0399\u03a3\u0395\u03a1\u03a7\u039f\u039c\u0395\u039d\u03a9\u039d",
            "\u039c\u039f\u03a5\u03a3\u0395\u0399\u0391 \u039a\u0391\u0399 \u03a3\u03a5\u039b\u039b\u039f\u0393\u0395\u03a3",
            "\u03a0\u03a1\u039f\u03a3\u03a9\u03a0\u0399\u039a\u039f \u0399.\u039a.\u0391",
            "\u039e\u0395\u039d\u039f\u0394\u039f\u03a7\u0395\u0399\u0391",
            "\u039a\u03a1\u0391\u03a4\u0399\u039a\u0397 \u0391\u03a3\u03a6\u0391\u039b\u0395\u0399\u0391",
            "\u03a3\u03a5\u039d\u0395\u03a4\u0391\u0399\u03a1\u0399\u03a3\u039c\u039f\u0399",
            "\u03a0\u039f\u039b\u03a5\u0395\u0398\u039d\u0395\u0399\u03a3 \u03a3\u03a5\u039c\u03a6\u03a9\u039d\u0399\u0395\u03a3",
            "\u0395\u03a4\u0395\u03a1\u039f\u0394\u039f\u039e\u039f\u0399",
            "\u039c\u0395\u03a3\u0397 \u0395\u039a\u03a0\u0391\u0399\u0394\u0395\u03a5\u03a3\u0399\u03a3",
            "\u0393\u0395\u03a9\u03a1\u0393\u0399\u039a\u039f\u0399 \u039f\u03a1\u0393\u0391\u039d\u0399\u03a3\u039c\u039f\u0399",
            "\u0393\u0395\u039d\u0399\u039a\u039f \u039b\u039f\u0393\u0399\u03a3\u03a4\u0397\u03a1\u0399\u039f",
            "\u03a1\u03a5\u0398\u039c\u0399\u03a3\u0397 \u03a4\u0397\u03a3 \u0391\u0393\u039f\u03a1\u0391\u03a3 \u0395\u03a1\u0393\u0391\u03a3\u0399\u0391\u03a3",
            "\u03a0\u0391\u03a1\u039f\u03a7\u039f\u0399 \u039a\u0399\u039d\u0397\u03a4\u03a9\u039d \u03a4\u0397\u039b\u0395\u03a0\u0399\u039a\u039f\u0399\u039d\u03a9\u039d\u0399\u03a9\u039d",
            "\u0395\u039c\u03a0\u03a1\u0391\u0393\u039c\u0391\u03a4\u039f\u03a3 \u0391\u03a3\u03a6\u0391\u039b\u0395\u0399\u0391",
            "\u03a6\u039f\u03a1\u039f\u039b\u039f\u0393\u0399\u0391 \u0391\u039a\u0391\u0398\u0391\u03a1\u0399\u03a3\u03a4\u039f\u03a5 \u03a0\u03a1\u039f\u03a3\u039f\u0394\u039f\u03a5",
            "\u039a\u03a4\u0397\u039c\u0391\u03a4\u0399\u039a\u0395\u03a3 \u03a4\u03a1\u0391\u03a0\u0395\u0396\u0395\u03a3",
            "\u03a3\u03a4\u0391\u03a4\u0399\u03a3\u03a4\u0399\u039a\u0397",
            "\u039a\u0395\u03a1\u0391\u0399\u0395\u03a3 \u2013 \u03a3\u03a4\u0391\u0398\u039c\u039f\u0399 \u039a\u0395\u03a1\u0391\u0399\u03a9\u039d",
            "\u03a0\u039f\u0399\u039d\u0399\u039a\u039f\u03a3 \u039d\u039f\u039c\u039f\u03a3",
            "\u039c\u0395\u03a3\u0391 \u0394\u0399\u0394\u0391\u03a3\u039a\u0391\u039b\u0399\u0391\u03a3",
            "\u0395\u039c\u03a0\u039f\u03a1\u0399\u039f \u03a6\u0391\u03a1\u039c\u0391\u039a\u03a9\u039d",
            "\u0394\u0399\u0391\u03a6\u039f\u03a1\u0391",
            "\u0394\u0397\u039c\u039f\u03a3\u0399\u0391 \u039a\u03a4\u0397\u039c\u0391\u03a4\u0391",
            "\u0395\u0399\u03a3\u03a6\u039f\u03a1\u0395\u03a3 \u0399.\u039a.\u0391",
            "\u039a\u0391\u03a4\u0391\u0393\u0393\u0395\u039b\u0399\u0391 \u03a3\u03a5\u039c\u0392\u0391\u03a3\u0395\u03a9\u03a3 \u0395\u03a1\u0393\u0391\u03a3\u0399\u0391\u03a3",
            "\u03a0\u03a1\u039f\u03a3\u03a9\u03a0\u0399\u039a\u039f \u03a0\u039f\u039b\u0399\u03a4\u0399\u039a\u0397\u03a3 \u0391\u0395\u03a1\u039f\u03a0\u039f\u03a1\u0399\u0391\u03a3",
            "\u0394\u0397\u039c\u039f\u03a3\u0399\u039f \u03a7\u03a1\u0395\u039f\u03a3",
            "\u0391\u03a0\u039f\u03a4\u0391\u039c\u0399\u0395\u03a5\u03a3\u0397",
            "\u0391\u039b\u039b\u039f\u0398\u03a1\u0397\u03a3\u039a\u039f\u0399",
            "\u03a0\u039b\u039f\u0397\u0393\u0399\u039a\u0397 \u03a5\u03a0\u0397\u03a1\u0395\u03a3\u0399\u0391",
            "\u03a4\u03a5\u03a0\u039f\u03a3 \u039a\u0391\u0399 \u03a0\u039b\u0397\u03a1\u039f\u03a6\u039f\u03a1\u0399\u0395\u03a3",
            "\u03a4\u03a1\u039f\u03a0\u039f\u03a0\u039f\u0399\u0397\u03a3\u0397 \u039a\u0391\u0399 \u039a\u0391\u03a4\u0391\u03a1\u0393\u0397\u03a3\u0397 \u03a4\u0397\u03a3 \u03a0\u039f\u0399\u039d\u0397\u03a3",
            "\u0391\u03a3\u03a6\u0391\u039b\u0399\u03a3\u03a4\u0399\u039a\u0391 \u03a4\u0391\u039c\u0395\u0399\u0391 \u03a4\u03a5\u03a0\u039f\u03a5",
            "\u039f\u0399\u039a\u039f\u0393\u0395\u039d\u0395\u0399\u0391\u039a\u039f \u0394\u0399\u039a\u0391\u0399\u039f",
            "\u0394\u0399\u039f\u0399\u039a\u0397\u03a3\u0397 \u0395\u0398\u039d\u0399\u039a\u0397\u03a3 \u039f\u0399\u039a\u039f\u039d\u039f\u039c\u0399\u0391\u03a3",
            "\u03a5\u03a0\u039f\u03a5\u03a1\u0393\u0395\u0399\u039f \u0395\u0398\u039d\u0399\u039a\u0397\u03a3 \u0391\u039c\u03a5\u039d\u0391\u03a3",
            "\u0394\u0399\u0395\u0398\u039d\u0395\u0399\u03a3 \u03a3\u03a5\u039c\u0392\u0391\u03a3\u0395\u0399\u03a3 \u03a0\u03a1\u039f\u039d\u039f\u0399\u0391\u03a3",
            "\u03a0\u03a1\u039f\u03a3\u03a9\u03a0\u0399\u039a\u039f \u03a4\u03a9\u039d \u0394\u0399\u039a\u0391\u03a3\u03a4\u0397\u03a1\u0399\u03a9\u039d",
            "\u03a0\u03a1\u039f\u03a3\u03a4\u0391\u03a3\u0399\u0391 \u03a0\u03a1\u039f\u03a3\u03a9\u03a0\u03a9\u039d \u0395\u0399\u0394\u0399\u039a\u03a9\u039d \u039a\u0391\u03a4\u0397\u0393\u039f\u03a1\u0399\u03a9\u039d",
            "\u03a0\u0391\u03a1\u039f\u03a7\u0395\u03a3 \u0391\u03a3\u0398\u0395\u039d\u0395\u0399\u0391\u03a3",
            "\u039c\u0395\u03a4\u0391\u039d\u0391\u03a3\u03a4\u0395\u03a5\u03a3\u0397",
            "\u03a5\u03a0\u039f\u03a5\u03a1\u0393\u0395\u0399\u039f \u03a0\u0391\u0399\u0394\u0395\u0399\u0391\u03a3",
            "\u0391\u03a3\u03a6\u0391\u039b\u0395\u0399\u0391 \u039d\u0391\u03a5\u03a3\u0399\u03a0\u039b\u039f\u03aa\u0391\u03a3",
            "\u039f\u0394\u039f\u03a0\u039f\u0399\u03aa\u0391",
            "\u03a3\u03a4\u03a1\u0391\u03a4\u039f\u0394\u0399\u039a\u0395\u0399\u0391",
            "\u039c\u0399\u03a3\u0398\u03a9\u03a3\u0397",
            "\u0395\u0399\u03a3\u03a0\u03a1\u0391\u039e\u0397 \u0394\u0397\u039c\u039f\u03a3\u0399\u03a9\u039d \u0395\u03a3\u039f\u0394\u03a9\u039d",
            "\u039f\u03a0\u039b\u0399\u03a4\u0395\u03a3 \u039a\u0391\u0399 \u0391\u039d\u0398\u03a5\u03a0\u0391\u03a3\u03a0\u0399\u03a3\u03a4\u0395\u03a3",
            "\u039f\u03a1\u0393\u0391\u039d\u0399\u03a3\u039c\u039f\u03a3 \u03a4\u0397\u039b\u0395\u03a0\u0399\u039a\u039f\u0399\u039d\u03a9\u039d\u0399\u03a9\u039d \u0395\u039b\u039b\u0391\u0394\u0391\u03a3 (\u039f.\u03a4.\u0395.)",
            "\u038c\u03a1\u0393\u0391\u039d\u0391 \u0386\u03a3\u039a\u0397\u03a3\u0397\u03a3 \u0394\u0399\u0391\u03a7\u0395\u0399\u03a1\u0399\u03a3\u03a4\u0399\u039a\u039f\u038e \u0395\u039b\u0388\u0393\u03a7\u039f\u03a5 \u039f\u03a1\u0393\u0391\u039d\u0399\u03a3\u039c\u038f\u039d \u039a\u0391\u0399 \u0395\u03a0\u0399\u03a7\u0395\u0399\u03a1\u0389\u03a3\u0395\u03a9\u039d",
            "\u03a0\u039f\u0399\u039d\u0399\u039a\u0397 \u039d\u039f\u039c\u039f\u0398\u0395\u03a3\u0399\u0391 \u03a4\u03a5\u03a0\u039f\u03a5",
            "\u0395\u039e\u0391\u0393\u03a9\u0393\u0399\u039a\u039f \u0395\u039c\u03a0\u039f\u03a1\u0399\u039f",
            "\u0391\u0395\u03a1\u039f\u03a0\u039f\u03a1\u0399\u039a\u0395\u03a3 \u03a3\u03a5\u039c\u0392\u0391\u03a3\u0395\u0399\u03a3",
            "\u0393\u0395\u03a9\u03a1\u0393\u0399\u039a\u039f\u0399 \u03a3\u03a5\u039d\u0395\u03a4\u0391\u0399\u03a1\u0399\u03a3\u039c\u039f\u0399 \u0391\u0393\u03a1\u039f\u03a4\u0399\u039a\u0395\u03a3 \u03a3\u03a5\u039d\u0395\u03a4\u0391\u0399\u03a1\u0399\u03a3\u03a4\u0399\u039a\u0395\u03a3 \u039f\u03a1\u0393\u0391\u039d\u03a9\u03a3\u0395\u0399\u03a3",
            "\u039f\u0399\u039a\u039f\u039d\u039f\u039c\u0399\u039a\u0395\u03a3 \u03a5\u03a0\u0397\u03a1\u0395\u03a3\u0399\u0395\u03a3",
            "\u039f\u03a7\u03a5\u03a1\u03a9\u03a3\u0395\u0399\u03a3",
            "\u0395\u039a\u03a4\u0391\u039a\u03a4\u039f\u0399 \u03a0\u039f\u0399\u039d\u0399\u039a\u039f\u0399 \u039d\u039f\u039c\u039f\u0399",
            "\u0395\u039a\u03a4\u0395\u039b\u0395\u03a3\u0397",
            "\u0394\u0399\u039f\u0399\u039a\u0397\u03a4\u0399\u039a\u039f\u0399 \u039a\u0391\u039d\u039f\u039d\u0399\u03a3\u039c\u039f\u0399",
            "\u03a5\u0394\u03a1\u0391\u03a5\u039b\u0399\u039a\u0391 \u0395\u03a1\u0393\u0391",
            "\u0391\u03a3\u03a6\u0391\u039b\u0399\u03a3\u03a4\u0399\u039a\u0391 \u03a4\u0391\u039c\u0395\u0399\u0391 \u0394\u0397\u039c\u039f\u03a3\u0399\u03a9\u039d \u03a5\u03a0\u0391\u039b\u039b\u0397\u039b\u03a9\u039d",
            "\u0395\u039a\u039a\u0391\u0398\u0391\u03a1\u0399\u03a3\u0395\u0399\u03a3 \u0394\u0397\u039c\u039f\u03a3\u0399\u03a9\u039d \u03a5\u03a0\u0391\u039b\u039b\u0397\u039b\u03a9\u039d",
            "\u0394\u0399\u039f\u0399\u039a\u0397\u03a3\u0397 \u0395\u039c\u03a0\u039f\u03a1\u0399\u039a\u039f\u03a5 \u039d\u0391\u03a5\u03a4\u0399\u039a\u039f\u03a5",
            "\u0391\u039d\u03a9\u03a4\u0391\u03a4\u039f \u0395\u0399\u0394\u0399\u039a\u039f \u0394\u0399\u039a\u0391\u03a3\u03a4\u0397\u03a1\u0399\u039f",
            "\u0391\u03a1\u03a4\u039f\u03a3",
            "\u0395\u0399\u03a3\u0391\u0393\u03a9\u0393\u0399\u039a\u039f \u0395\u039c\u03a0\u039f\u03a1\u0399\u039f",
            "\u0391\u039b\u0399\u0395\u0399\u0391",
            "\u0395\u039a\u039a\u039b\u0397\u03a3\u0399\u0391\u03a3\u03a4\u0399\u039a\u0397 \u03a0\u0395\u03a1\u0399\u039f\u03a5\u03a3\u0399\u0391",
            "\u0394\u0399\u0391\u03a6\u039f\u03a1\u0391 \u0394\u0397\u039c\u039f\u03a3\u0399\u0391 \u0395\u03a1\u0393\u0391",
            "\u039c\u039f\u039d\u0395\u03a3",
            "\u03a0\u03a1\u039f\u0395\u0394\u03a1\u039f\u03a3 \u03a4\u0397\u03a3 \u0394\u0397\u039c\u039f\u039a\u03a1\u0391\u03a4\u0399\u0391\u03a3 \u039a\u0391\u0399 \u03a0\u03a1\u039f\u0395\u0394\u03a1\u0399\u0391 \u03a4\u0397\u03a3 \u0394\u0397\u039c\u039f\u039a\u03a1\u0391\u03a4\u0399\u0391\u03a3",
            "\u03a0\u039f\u039b\u03a5\u0395\u0398\u039d\u0395\u0399\u03a3 \u039f\u03a1\u0393\u0391\u039d\u0399\u03a3\u039c\u039f\u0399",
            "\u0391\u03a1\u03a7\u0391\u0399\u039f\u03a4\u0397\u03a4\u0395\u03a3",
            "\u039d\u0391\u039f\u0399 \u039a\u0391\u0399 \u039b\u0395\u0399\u03a4\u039f\u03a5\u03a1\u0393\u039f\u0399 \u0391\u03a5\u03a4\u03a9\u039d",
            "\u0395\u039a\u039a\u039b\u0397\u03a3\u0399\u0391\u03a3\u03a4\u0399\u039a\u0397 \u0395\u039a\u03a0\u0391\u0399\u0394\u0395\u03a5\u03a3\u0397",
            "\u0395\u039d\u0399\u03a3\u03a7\u03a5\u03a3\u0399\u03a3 \u03a4\u0397\u03a3 \u0393\u0395\u03a9\u03a1\u0393\u0399\u0391\u03a3",
            "\u0395\u039a\u0398\u0395\u03a3\u0395\u0399\u03a3",
            "\u03a0\u03a1\u039f\u03a3\u03a4\u0391\u03a3\u0399\u0391 \u03a4\u03a9\u039d \u03a3\u03a5\u039d\u0391\u039b\u039b\u0391\u0393\u03a9\u039d",
            "\u0391\u03a3\u03a6\u0391\u039b\u0399\u03a3\u0397",
            "\u039a\u03a4\u0397\u039d\u039f\u03a4\u03a1\u039f\u03a6\u0399\u0391",
            "\u0395\u039a\u03a0\u0391\u0399\u0394\u0395\u03a5\u03a4\u0399\u039a\u0391 \u03a4\u0395\u039b\u0397",
            "\u0394\u0399\u039f\u0399\u039a\u0397\u03a3\u0397 \u0395\u039a\u03a0\u0391\u0399\u0394\u0395\u03a5\u03a3\u0395\u03a9\u03a3",
            "\u03a4\u0391\u039c\u0395\u0399\u039f \u03a0\u0391\u03a1\u0391\u039a\u0391\u03a4\u0391\u0398\u0397\u039a\u03a9\u039d \u039a\u0391\u0399 \u0394\u0391\u039d\u0395\u0399\u03a9\u039d",
            "\u0391\u0393\u0391\u0398\u039f\u0395\u03a1\u0393\u0391 \u0399\u0394\u03a1\u03a5\u039c\u0391\u03a4\u0391",
            "\u03a6\u039f\u03a1\u039f\u039b\u039f\u0393\u0399\u039a\u0391 \u0394\u0399\u039a\u0391\u03a3\u03a4\u0397\u03a1\u0399\u0391",
            "\u03a6\u039f\u03a1\u039f\u0399 \u039a\u0391\u03a4\u0391\u039d\u0391\u039b\u03a9\u03a3\u0395\u03a9\u03a3",
            "\u0392\u0399\u0392\u039b\u0399\u039f\u0398\u0397\u039a\u0395\u03a3-\u03a0\u03a1\u039f\u03a3\u03a4\u0391\u03a3\u0399\u0391 \u0392\u0399\u0392\u039b\u0399\u039f\u03a5-\u0394\u0399\u0391\u0394\u039f\u03a3\u0397 \u039b\u039f\u0393\u039f\u03a4\u0395\u03a7\u039d\u0399\u0391\u03a3",
            "\u03a4\u0397\u039b\u0395\u03a0\u0399\u039a\u039f\u0399\u039d\u03a9\u039d\u0399\u0391\u039a\u0395\u03a3 \u039a\u0391\u0399 \u03a4\u0391\u03a7\u03a5\u0394\u03a1\u039f\u039c\u0399\u039a\u0395\u03a3 \u03a3\u03a5\u039c\u0392\u0391\u03a3\u0395\u0399\u03a3",
            "\u0399\u0394\u0399\u03a9\u03a4\u0399\u039a\u0397 \u0395\u039a\u03a0\u0391\u0399\u0394\u0395\u03a5\u03a3\u0397",
            "\u03a4\u0397\u039b\u0395\u03a0\u0399\u039a\u039f\u0399\u039d\u03a9\u039d\u0399\u0395\u03a3",
            "\u0391\u03a3\u03a5\u03a1\u039c\u0391\u03a4\u039f\u03a3",
            "\u0391\u03a0\u039f\u0394\u039f\u03a7\u0395\u03a3 \u0394\u0397\u039c\u039f\u03a3\u0399\u03a9\u039d \u03a5\u03a0\u0391\u039b\u039b\u0397\u03a9\u039d",
            "\u03a5\u0393\u0395\u0399\u039f\u039d\u039f\u039c\u0399\u039a\u0397 \u03a5\u03a0\u0397\u03a1\u0395\u03a3\u0399\u0391 \u03a3\u03a4\u03a1\u0391\u03a4\u039f\u03a5",
            "\u03a6\u0391\u03a1\u039c\u0391\u039a\u0395\u0399\u0391",
            "\u0394\u0397\u039c\u039f\u03a3\u0399\u039f \u039b\u039f\u0393\u0399\u03a3\u03a4\u0399\u039a\u039f",
            "\u039d\u0391\u03a5\u03a4\u0399\u039a\u0397 \u0395\u039a\u03a0\u0391\u0399\u0394\u0395\u03a5\u03a3\u0397",
            "\u0395\u039e\u03a5\u03a0\u0397\u03a1\u0395\u03a4\u0397\u03a3\u0397 \u03a0\u039f\u039b\u0399\u03a4\u0399\u039a\u0397\u03a3 \u0391\u0395\u03a1\u039f\u03a0\u039f\u03a1\u0399\u0391\u03a3",
            "\u03a0\u0391\u03a1\u039f\u03a7\u0395\u03a3 \u0399.\u039a.\u0391",
            "\u0393\u0395\u039d\u0399\u039a\u0391 \u03a5\u0393\u0395\u0399\u039f\u039d\u039f\u039c\u0399\u039a\u0391 \u039c\u0395\u03a4\u03a1\u0391",
            "\u0395\u039a\u039c\u0395\u03a4\u0391\u039b\u039b\u0395\u03a5\u03a3\u0397 \u0398\u0391\u039b\u0391\u03a3\u03a3\u0399\u03a9\u039d \u03a3\u03a5\u0393\u039a\u039f\u0399\u039d\u03a9\u039d\u0399\u03a9\u039d",
            "\u03a0\u03a1\u039f\u03a3\u03a9\u03a0\u0399\u039a\u039f \u03a4\u0391\u03a7\u03a5\u0394\u03a1\u039f\u039c\u0395\u0399\u03a9\u039d",
            "\u0395\u039a\u03a4\u0395\u039b\u0395\u03a3\u03a4\u0399\u039a\u0397 \u0395\u039e\u039f\u03a5\u03a3\u0399\u0391",
            "\u03a3\u03a5\u03a3\u03a4\u0391\u03a3\u0397 \u039a\u0391\u0399 \u0395\u0394\u03a1\u0391 \u03a4\u039f\u03a5 \u039a\u03a1\u0391\u03a4\u039f\u03a5\u03a3",
            "\u03a6\u039f\u03a1\u039f\u039b\u039f\u0393\u0399\u0391 \u0394\u0399\u0391\u03a3\u039a\u0395\u0394\u0391\u03a3\u0395\u03a9\u039d",
            "\u03a4\u0397\u039b\u0395\u03a6\u03a9\u039d\u0391",
            "\u03a3\u03a4\u03a1\u0391\u03a4\u039f\u039b\u039f\u0393\u0399\u0391",
            "\u0395\u039a\u03a0\u0391\u0399\u0394\u0395\u03a5\u03a3\u0397 \u0395\u03a1\u0393\u0391\u03a4\u03a9\u039d",
            "\u03a5\u03a0\u039f\u03a5\u03a1\u0393\u0395\u0399\u039f \u03a0\u039f\u039b\u0399\u03a4\u0399\u03a3\u039c\u039f\u03a5",
            "\u03a6\u039f\u03a1\u039f\u039b\u039f\u0393\u0399\u0391 \u039f\u0399\u039d\u039f\u03a0\u039d\u0395\u03a5\u039c\u0391\u03a4\u03a9\u0394\u03a9\u039d \u03a0\u039f\u03a4\u03a9\u039d",
            "\u03a5\u03a0\u039f\u03a5\u03a1\u0393\u0395\u0399\u039f \u0393\u0395\u03a9\u03a1\u0393\u0399\u0391\u03a3",
            "\u03a3\u03a9\u039c\u0391\u03a4\u0395\u0399\u0391",
            "\u0395\u0399\u0394\u0399\u039a\u0395\u03a3 \u039c\u039f\u03a1\u03a6\u0395\u03a3 \u0391\u03a0\u0391\u03a3\u03a7\u039f\u039b\u0397\u03a3\u0397\u03a3",
            "\u03a5\u03a0\u039f\u03a5\u03a1\u0393\u0395\u0399\u039f \u0394\u0399\u039a\u0391\u0399\u039f\u03a3\u03a5\u039d\u0397\u03a3",
            "\u039d\u0391\u03a5\u03a4\u0399\u039b\u0399\u0391\u039a\u039f\u0399 \u039f\u03a1\u0393\u0391\u039d\u0399\u03a3\u039c\u039f\u0399",
            "\u03a4\u039f\u03a5\u03a1\u0399\u03a3\u039c\u039f\u03a3",
            "\u039a\u0391\u03a0\u039d\u039f\u03a3",
            "\u03a0\u03a1\u039f\u03a3\u03a4\u0391\u03a3\u0399\u0391 \u0397\u0398\u03a9\u039d",
            "\u0395\u0399\u0394\u0399\u039a\u0395\u03a3 \u03a5\u03a0\u0397\u03a1\u0395\u03a3\u0399\u0395\u03a3 \u039d\u0391\u03a5\u03a4\u0399\u039a\u039f\u03a5",
            "\u0391\u03a0\u039f\u0394\u039f\u03a7\u0395\u03a3 \u03a3\u03a4\u03a1\u0391\u03a4\u0399\u03a9\u03a4\u0399\u039a\u03a9\u039d",
            "\u03a0\u03a1\u039f\u039d\u039f\u0399\u0391 \u03a0\u039b\u0397\u03a1\u03a9\u039c\u0391\u03a4\u03a9\u039d \u0395.\u039d",
            "\u0395\u0399\u0394\u0399\u039a\u0395\u03a3 \u0394\u0399\u0391\u03a4\u0391\u039e\u0395\u0399\u03a3 \u03a0\u0395\u03a1\u0399 \u0391\u039d\u03a9\u039d.\u0395\u03a4\u0391\u0399\u03a1\u0395\u0399\u03a9\u039d",
            "\u0394\u0397\u039c\u039f\u03a3\u0399\u0391 \u0394\u0399\u039f\u0399\u039a\u0397\u03a3\u0397",
            "\u03a4\u039f\u03a0\u0399\u039a\u0391 \u03a3\u03a7\u0395\u0394\u0399\u0391 \u03a0\u039f\u039b\u0395\u03a9\u039d",
            "\u03a0\u03a1\u039f\u03a3\u03a4\u0391\u03a3\u0399\u0391 \u03a0\u0391\u0399\u0394\u0399\u039a\u0397\u03a3 \u0397\u039b\u0399\u039a\u0399\u0391\u03a3",
            "\u0395\u039b\u039b\u0397\u039d\u0399\u039a\u0397 \u0391\u03a3\u03a4\u03a5\u039d\u039f\u039c\u0399\u0391",
            "\u039b\u0399\u039c\u0395\u039d\u0399\u039a\u039f \u03a3\u03a9\u039c\u0391",
            "\u03a4\u039f\u03a5\u03a1\u0399\u03a3\u03a4\u0399\u039a\u0397 \u0391\u03a3\u03a4\u03a5\u039d\u039f\u039c\u0399\u0391",
            "\u0392\u0399\u039f\u039c\u0397\u03a7\u0391\u039d\u0399\u0391",
            "\u03a3\u03a7\u039f\u039b\u0395\u03a3 \u03a0\u0391\u039d\u0395\u03a0\u0399\u03a3\u03a4\u0397\u039c\u0399\u039f\u03a5 \u0391\u0398\u0397\u039d\u03a9\u039d",
            "\u0391\u03a3\u03a6\u0391\u039b\u0399\u03a3\u03a4\u0399\u039a\u039f\u0399 \u039f\u03a1\u0393\u0391\u039d\u0399\u03a3\u039c\u039f\u0399 \u03a3\u03a4\u03a1\u0391\u03a4\u039f\u03a5",
            "\u0391\u039b\u03a5\u039a\u0395\u03a3",
            "\u0395\u03a3\u03a9\u03a4\u0395\u03a1\u0399\u039a\u039f \u0395\u039c\u03a0\u039f\u03a1\u0399\u039f",
            "\u0395\u0398\u039d\u0399\u039a\u039f \u03a3\u03a5\u03a3\u03a4\u0397\u039c\u0391 \u03a5\u0393\u0395\u0399\u0391\u03a3",
            "\u039d\u039f\u039c\u039f\u0398\u0395\u03a4\u0399\u039a\u0397 \u0395\u039e\u039f\u03a5\u03a3\u0399\u0391",
            "\u0394\u0399\u039f\u0399\u039a\u0397\u03a3H \u039a\u039f\u0399\u039d\u03a9\u039dIK\u0397\u03a3 \u03a0\u03a1\u039f\u039d\u039f\u0399\u0391\u03a3",
            "\u03a0\u039b\u0397\u03a1\u03a9\u039c\u0391\u03a4\u0391",
            "\u039c\u0391\u0398\u0397\u03a4\u0399\u039a\u0397 \u03a0\u03a1\u039f\u039d\u039f\u0399\u0391",
            "\u0394\u0399\u039f\u0399\u039a\u0397\u03a3\u0397 \u03a4\u03a5\u03a0\u039f\u03a5 \u039a\u0391\u0399 \u03a4\u039f\u03a5\u03a1\u0399\u03a3\u039c\u039f\u03a5",
            "\u0395\u03a0\u039f\u0399\u039a\u0399\u03a3\u039c\u039f\u03a3",
            "\u03a4\u03a1\u039f\u03a7\u0399\u039f\u0394\u03a1\u039f\u039c\u039f\u0399",
            "\u0395\u03a0\u0391\u0393\u0393\u0395\u039b\u039c\u0391\u03a4\u0399\u039a\u0397 \u0395\u039a\u03a0\u0391\u0399\u0394\u0395\u03a5\u03a3\u0397",
            "\u0391\u0395\u03a1\u039f\u03a0\u039f\u03a1\u0399\u039a\u0397 \u0395\u039a\u03a0\u0391\u0399\u0394\u0395\u03a5\u03a3\u0397",
            "\u03a5\u03a0\u039f\u03a5\u03a1\u0393\u0395\u0399\u039f \u0395\u0398\u039d\u0399\u039a\u0397\u03a3 \u039f\u0399\u039a\u039f\u039d\u039f\u039c\u0399\u0391\u03a3",
            "\u0398\u0395\u0391\u03a4\u03a1\u039f",
            "\u03a5\u0394\u03a1\u0395\u03a5\u03a3\u0397",
            "\u0394\u0399\u0395\u0398\u039d\u0395\u0399\u03a3 \u03a3\u03a4\u03a1\u0391\u03a4\u0399\u03a9\u03a4\u0399\u039a\u0395\u03a3 \u03a3\u03a5\u039c\u0392\u0391\u03a3\u0395\u0399\u03a3",
            "\u0395\u0398\u039d\u0399\u039a\u039f \u039c\u0395\u03a4\u03a3\u039f\u0392\u0399\u039f \u03a0\u039f\u039b\u03a5\u03a4\u0395\u03a7\u039d\u0395\u0399\u039f",
            "\u03a5\u03a0\u039f\u03a5\u03a1\u0393\u0395\u0399\u039f \u0395\u039e\u03a9\u03a4\u0395\u03a1\u0399\u039a\u03a9\u039d",
            "\u0395\u03a5\u03a1\u03a9\u03a0\u0391\u03aa\u039a\u039f\u0399 \u03a0\u039f\u039b\u03a5\u0395\u0398\u039d\u0395\u0399\u03a3 \u039f\u03a1\u0393\u0391\u039d\u0399\u03a3\u039c\u039f\u0399",
            "\u0395\u039b\u0395\u03a5\u0398\u0395\u03a1\u0399\u0391 \u03a4\u0397\u03a3 \u0395\u03a1\u0393\u0391\u03a3\u0399\u0391\u03a3",
            "\u03a5\u03a0\u039f\u03a5\u03a1\u0393\u0395\u0399\u039f \u0395\u03a3\u03a9\u03a4\u0395\u03a1\u0399\u039a\u03a9\u039d \u0394\u0397\u039c.\u0394\u0399\u039f\u0399\u039a\u0397\u03a3\u0397\u03a3 \u039a\u0391\u0399 \u0391\u03a0\u039f\u039a\u0395\u039d\u03a4\u03a1\u03a9\u03a3\u0397\u03a3",
            "\u0394\u0399\u0391\u03a6\u039f\u03a1\u0395\u03a3 \u0395\u039d\u039f\u03a7\u0399\u039a\u0395\u03a3 \u03a3\u03a7\u0395\u03a3\u0395\u0399\u03a3",
            "\u039b\u0397\u039e\u0399\u0391\u03a1\u03a7\u0395\u0399\u0391",
            "\u0395\u0399\u0394\u0399\u039a\u039f\u0399 \u039a\u0391\u039d\u039f\u039d\u0399\u03a3\u039c\u039f\u0399",
            "\u03a4\u0395\u039b\u03a9\u039d\u0395\u0399\u0391\u039a\u0395\u03a3 \u03a3\u03a5\u039c\u0392\u0391\u03a3\u0395\u0399\u03a3",
            "\u039d\u0391\u03a5\u03a4\u0399\u039a\u039f \u03a0\u039f\u0399\u039d\u0399\u039a\u039f \u0394\u0399\u039a\u0391\u0399\u039f",
            "\u03a3\u03a4\u0395\u0393\u0391\u03a3\u0397 \u0394\u0397\u039c\u039f\u03a3\u0399\u03a9\u039d \u03a5\u03a0\u0397\u03a1\u0395\u03a3\u0399\u03a9\u039d",
            "\u03a0\u039b\u0397\u03a1\u03a9\u039c\u0391\u03a4\u0391 \u03a0\u039f\u039b\u0395\u039c\u0399\u039a\u039f\u03a5 \u039d\u0391\u03a5\u03a4\u0399\u039a\u039f\u03a5",
            "\u03a3\u03a5\u039d\u03a4\u0391\u0393\u039c\u0391\u03a4\u0399\u039a\u039f\u03a3 \u03a7\u0391\u03a1\u03a4\u0397\u03a3",
            "\u0397\u039b\u0395\u039a\u03a4\u03a1\u0399\u03a3\u039c\u039f\u03a3",
            "\u0391\u03a3\u03a6\u0391\u039b\u0399\u03a3\u03a4\u0399\u039a\u0391 \u0394\u0399\u039a\u0391\u03a3\u03a4\u0397\u03a1\u0399\u0391",
            "\u039b\u0395\u03a3\u03a7\u0395\u03a3 \u0395\u039b\u039b\u0397\u039d\u0399\u039a\u0397\u03a3 \u0391\u03a3\u03a4\u03a5\u039d\u039f\u039c\u0399\u0391\u03a3",
            "\u03a5\u03a0\u039f\u03a5\u03a1\u0393\u0395\u0399\u039f \u0394\u0397\u039c\u039f\u03a3\u0399\u0391\u03a3 TA\u039e\u0397\u03a3",
            "\u0395\u039a\u03a4\u0395\u039b\u0395\u03a3 \u0394\u0397\u039c\u039f\u03a3\u0399\u03a9\u039d \u0395\u03a1\u0393\u03a9\u039d",
            "\u03a0\u0391\u039d\u0395\u03a0\u0399\u03a3\u03a4\u0397\u039c\u0399\u039f \u0398\u0395\u03a3\u03a3\u0391\u039b\u039f\u039d\u0399\u039a\u0397\u03a3",
            "\u0394\u0391\u03a3\u0399\u039a\u0397 \u039d\u039f\u039c\u039f\u0398\u0395\u03a3\u0399\u0391",
            "\u0395\u0399\u0394\u0399\u039a\u0395\u03a3 \u0391\u039d\u03a9\u03a4\u0391\u03a4\u0395\u03a3 \u03a3\u03a7\u039f\u039b\u0395\u03a3",
            "\u0395\u0394\u0391\u03a6\u039f\u03a3 \u03a4\u039f\u03a5 \u0395\u039b\u039b\u0397\u039d\u0399\u039a\u039f\u03a5 \u039a\u03a1\u0391\u03a4\u039f\u03a5\u03a3",
            "\u0394\u0399\u039a\u0397\u0393\u039f\u03a1\u039f\u0399",
            "\u0394\u0399\u039a\u0391\u0399\u039f \u03a4\u03a9\u039d \u03a0\u03a1\u039f\u03a3\u03a9\u03a0\u03a9\u039d",
            "\u0394\u0399\u039f\u0399\u039a\u0397\u03a3\u0397 \u03a4\u0391\u03a7\u03a5\u0394\u03a1\u039f\u039c\u0399\u039a\u0397\u03a3, \u03a4\u0397\u039b\u0395\u0393\u03a1\u0391\u03a6\u0399\u039a\u0397\u03a3",
            "\u03a3\u03a7\u039f\u039b\u0399\u039a\u0391 \u039a\u03a4\u0399\u03a1\u0399\u0391 \u039a\u0391\u0399 \u03a4\u0391\u039c\u0395\u0399\u0391",
            "\u0391\u0395\u03a1\u039f\u039b\u0399\u039c\u0395\u039d\u0395\u03a3",
            "\u03a5\u03a0\u039f\u0398\u0397\u039a\u039f\u03a6\u03a5\u039b\u0391\u039a\u0395\u0399\u0391",
            "\u0391\u03a3\u03a6\u0391\u039b\u0399\u03a3\u03a4\u0399\u039a\u0391 \u03a4\u0391\u039c\u0395\u0399\u0391 \u03a0\u03a1\u039f\u03a3\u03a9\u03a0\u0399\u039a\u039f\u03a5 \u03a5\u03a0\u039f\u03a5\u03a1\u0393\u0395\u0399\u039f\u03a5 \u0394\u0397\u039c\u039f\u03a3\u0399\u0391\u03a3 \u03a4\u0391\u039e\u0397\u03a3",
            "\u0394\u0399\u0391\u03a7\u0395\u0399\u03a1\u0399\u03a3\u0395\u0399\u03a3 \u03a4\u039f\u03a5 \u0394\u0397\u039c\u039f\u03a3\u0399\u039f\u03a5",
            "\u0395\u039c\u03a0\u03a1\u0391\u0393\u039c\u0391\u03a4\u039f \u0394\u0399\u039a\u0391\u0399\u039f",
            "\u03a6\u039f\u03a1\u03a4\u039f\u0395\u039a\u03a6\u039f\u03a1\u03a4\u03a9\u03a3\u0395\u0399\u03a3",
            "\u0391\u039d\u03a9\u039d\u03a5\u039c\u0395\u03a3 \u0395\u03a4\u0391\u0399\u03a1\u0395\u0399\u0395\u03a3",
            "\u0395\u0399\u0394\u0399\u039a\u039f\u0399 \u0395\u03a0\u0399\u03a3\u0399\u03a4\u0399\u03a3\u03a4\u0399\u039a\u039f\u0399 \u039d\u039f\u039c\u039f\u0399",
            "\u0395\u039a\u039a\u039b\u0397\u03a3\u0399\u0395\u03a3 \u0391\u039b\u039b\u039f\u0394\u0391\u03a0\u0397\u03a3",
            "\u0394\u0399\u0395\u0398\u039d\u0395\u0399\u03a3 \u03a3\u03a5\u039c\u0392\u0391\u03a3\u0395\u0399\u03a3",
            "\u039f\u03a1\u0393\u0391\u039d\u0399\u03a3\u039c\u039f\u03a3 \u0391\u03a3\u03a6\u0391\u039b\u0399\u03a3\u0397\u03a3 \u0395\u039b\u0395\u03a5\u0398\u0395\u03a1\u03a9\u039d \u0395\u03a0\u0391\u0393\u0393\u0395\u039b\u039c\u0391\u03a4\u0399\u03a9\u039d",
            "\u0391\u03a3\u03a6\u0391\u039b\u0395\u0399\u0391 \u0391\u0395\u03a1\u039f\u03a0\u039b\u039f\u03aa\u0391\u03a3",
            "\u03a4\u0391\u039c\u0395\u0399\u0391 \u0391\u03a3\u03a6\u0391\u039b\u0399\u03a3\u0395\u03a9\u03a3 \u039a\u0391\u0399 \u0391\u03a1\u03a9\u0393\u0397\u03a3",
            "\u0391\u039d\u03a9\u03a4\u0391\u03a4\u0397 \u0395\u039a\u03a0\u0391\u0399\u0394\u0395\u03a5\u03a3\u0397",
            "\u03a0\u039f\u039b\u0395\u039c\u0399\u039a\u0397 \u0394\u0399\u0391\u0398\u0395\u03a3\u0399\u039c\u039f\u03a4\u0397\u03a4\u0391",
            "\u03a0\u039f\u0399\u039d\u0399\u039a\u039f \u039a\u0391\u0399 \u03a0\u0395\u0399\u0398\u0391\u03a1\u03a7\u0399\u039a\u039f \u0394\u0399\u039a\u0391\u0399\u039f",
            "\u03a6\u039f\u03a1\u039f\u039b\u039f\u0393\u0399\u0391 \u0395\u03a0\u0399\u03a4\u0397\u0394\u0395\u03a5\u039c\u0391\u03a4\u039f\u03a3",
            "\u0395\u039a\u03a4\u0391\u039a\u03a4\u0395\u03a3 \u03a6\u039f\u03a1\u039f\u039b\u039f\u0393\u0399\u0395\u03a3",
            "\u03a0\u039f\u0399\u039d\u0399\u039a\u0397 \u0394\u0399\u039a\u039f\u039d\u039f\u039c\u0399\u0391",
            "\u03a3\u03a4\u039f\u0399\u03a7\u0395\u0399\u03a9\u0394\u0397\u03a3 \u0395\u039a\u03a0\u0391\u0399\u0394\u0395\u03a5\u03a3\u0397",
            "\u03a3\u03a5\u039c\u0392\u039f\u03a5\u039b\u0399\u039f \u0395\u03a0\u0399\u039a\u03a1\u0391\u03a4\u0395\u0399\u0391\u03a3 \u039a\u0391\u0399 \u0394\u0399\u039f\u0399\u039a\u0397\u03a4\u0399\u039a\u0391 \u0394\u0399\u039a\u0391\u03a3\u03a4\u0397\u03a1\u0399\u0391",
            "\u039d\u039f\u039c\u0399\u039a\u0391 \u03a0\u03a1\u039f\u03a3\u03a9\u03a0\u0391 \u039a\u0391\u0399 \u0395\u039a\u039c\u0395\u03a4\u0391\u039b\u039b\u0395\u03a5\u03a3\u0395\u0399\u03a3",
            "\u039f\u0399\u039a\u039f\u039d\u039f\u039c\u0399\u039a\u0397 \u0394\u0399\u039f\u0399\u039a\u0397\u03a3\u0397 \u039d\u0391\u03a5\u03a4\u0399\u039a\u039f\u03a5",
            "\u03a4\u03a5\u03a0\u039f\u03a3",
            "\u03a4\u0391\u039c\u0395\u0399\u039f \u0391\u03a3\u03a6\u0391\u039b\u0399\u03a3\u0395\u03a9\u03a3 \u0395\u03a0\u0391\u0393\u0393\u0395\u039b\u039c\u0391\u03a4\u0399\u03a9\u039d",
            "\u03a0\u0391\u039d\u0395\u03a0\u0399\u03a3\u03a4\u0397\u039c\u0399\u039f \u0399\u03a9\u0391\u039d\u039d\u0399\u039d\u03a9\u039d",
            "\u03a7\u03a1\u0395\u03a9\u0393\u03a1\u0391\u03a6\u0391",
            "\u03a0\u03a1\u039f\u03aa\u039f\u039d\u03a4\u0391 \u0395\u039b\u0391\u0399\u0391\u03a3",
            "\u0395\u039a\u039a\u039b\u0397\u03a3\u0399\u0391 \u0399\u039f\u039d\u0399\u03a9\u039d \u039d\u0397\u03a3\u03a9\u039d",
            "\u0394\u0399\u039f\u0399\u039a\u0397\u03a3H \u03a5\u0393\u0399\u0395\u0399\u039d\u0397\u03a3",
            "\u0391\u0395\u03a1\u039f\u03a0\u039f\u03a1\u0399\u039a\u039f \u03a0\u039f\u0399\u039d\u0399\u039a\u039f \u0394\u0399\u039a\u0391\u0399\u039f",
            "\u039a\u0391\u03a4\u0391\u03a0\u039f\u039b\u0395\u039c\u0397\u03a3\u0397 \u039d\u039f\u03a3\u03a9\u039d \u039a\u0391\u03a4\u2019 \u0399\u0394\u0399\u0391\u039d",
            "\u0395\u0399\u0394\u0399\u039a\u039f\u0399 \u03a0\u039f\u0399\u039d\u0399\u039a\u039f\u0399 \u039d\u039f\u039c\u039f\u0399",
            "\u0398\u0397\u03a1\u0391",
            "\u03a5\u0393\u0399\u0395\u0399\u039d\u0397 \u039a\u0391\u0399 \u0391\u03a3\u03a6\u0391\u039b\u0395\u0399\u0391 \u0395\u03a1\u0393\u0391\u0396\u039f\u039c\u0395\u039d\u03a9\u039d",
            "\u0394\u0399\u039f\u0399\u039a\u0397\u03a3\u0397 \u03a3\u03a5\u0393\u039a\u039f\u0399\u039d\u03a9\u039d\u0399\u03a9\u039d",
            "\u0391\u03a0\u039f\u03a3\u03a4\u039f\u039b\u0399\u039a\u0397 \u0394\u0399\u0391\u039a\u039f\u039d\u0399\u0391 \u0395\u039a\u039a\u039b\u0397\u03a3\u0399\u0391\u03a3 \u03a4\u0397\u03a3 \u0395\u039b\u039b\u0391\u0394\u039f\u03a3",
            "\u03a0\u03a1\u039f\u03a3\u03a9\u03a1\u0399\u039d\u0395\u03a3 \u0391\u03a4\u0395\u039b\u0395\u0399\u0395\u03a3",
            "\u03a4\u0391\u03a7\u03a5\u0394\u03a1\u039f\u039c\u0399\u039a\u0391 \u03a4\u0391\u039c\u0399\u0395\u03a5\u03a4\u0397\u03a1\u0399\u0391",
            "\u0391\u039d\u03a9\u03a4\u0391\u03a4\u0397 \u03a3\u03a7\u039f\u039b\u0397 \u039a\u0391\u039b\u03a9\u039d \u03a4\u0395\u03a7\u039d\u03a9\u039d",
            "\u0394\u0399\u039f\u0399\u039a\u0397\u03a3\u0397 \u0395\u03a1\u0393\u0391\u03a3\u0399\u0391\u03a3",
            "\u0391\u0393\u0399\u039f\u039d \u039f\u03a1\u039f\u03a3",
            "\u03a3\u03a7\u039f\u039b\u0395\u03a3 \u03a0. \u039d\u0391\u03a5\u03a4\u0399\u039a\u039f\u03a5",
            "\u03a4\u03a1\u0391\u03a0\u0395\u0396\u0395\u03a3",
            "\u0395\u039b\u0395\u0393\u03a7\u039f\u03a3 \u039a\u0399\u039d\u0397\u03a3\u0395\u03a9\u03a3 \u039c\u0395 \u03a4\u039f \u0395\u039e\u03a9\u03a4\u0395\u03a1\u0399\u039a\u039f",
            "\u0395\u0399\u0394\u0399\u039a\u0391\u0399 \u039a\u0391\u03a4\u0397\u0393\u039f\u03a1\u0399\u0391\u0399 \u03a0\u039b\u039f\u0399\u03a9\u039d",
            "\u0393\u0395\u03a9\u03a1\u0393\u0399\u039a\u0397 \u03a5\u0393\u0399\u0395\u0399\u039d\u0397",
            "\u0395\u039e\u039f\u0394\u0391 \u03a0\u039f\u0399\u039d\u0399\u039a\u0397\u03a3 \u0394\u0399\u0391\u0394\u0399\u039a\u0391\u03a3\u0399\u0391\u03a3",
            "\u0395\u03a1\u0393\u0391\u03a3\u0399\u0391 \u0393\u03a5\u039d\u0391\u0399\u039a\u03a9\u039d \u039a\u0391\u0399 \u0391\u039d\u0397\u039b\u0399\u039a\u03a9\u039d",
            "\u0394\u0399\u039f\u0399\u039a\u0397\u03a3\u0397 \u0395\u03a6\u039f\u0394\u0399\u0391\u03a3\u039c\u039f\u03a5",
            "\u0395\u039c\u03a0\u039f\u03a1\u0399\u039a\u0391 \u0395\u03a0\u0391\u0393\u0393\u0395\u039b\u039c\u0391\u03a4\u0391",
            "\u0395\u039a\u03a4\u0395\u039b\u03a9\u039d\u0399\u03a3\u03a4\u0395\u03a3",
            "\u03a6\u039f\u03a1\u039f\u039b\u039f\u0393\u0399\u0391 \u039a\u039b\u0397\u03a1\u039f\u039d\u039f\u039c\u0399\u03a9\u039d, \u0394\u03a9\u03a1\u0395\u03a9\u039d \u039a\u039b\u03a0",
            "\u039f\u03a1\u0393\u0391\u039d\u0399\u03a3\u039c\u039f\u0399 \u03a5\u03a0\u039f\u03a5\u03a1\u0393\u0395\u0399\u039f\u03a5 \u0395\u03a1\u0393\u0391\u03a3\u0399\u0391\u03a3",
            "\u0395\u039d\u0399\u03a3\u03a7\u03a5\u03a3\u0397 \u0395\u03a0\u0399\u03a3\u03a4\u0397\u039c\u03a9\u039d \u039a\u0391\u0399 \u03a4\u0395\u03a7\u039d\u03a9\u039d",
            "\u0394\u0399\u0391\u03a6\u039f\u03a1\u039f\u0399 \u03a6\u039f\u03a1\u039f\u039b\u039f\u0393\u0399\u039a\u039f\u0399 \u039d\u039f\u039c\u039f\u0399",
            "\u03a4\u0395\u03a7\u039d\u0399\u039a\u0395\u03a3 \u03a0\u03a1\u039f\u0394\u0399\u0391\u0393\u03a1\u0391\u03a6\u0395\u03a3",
            "\u039c\u0397\u03a4\u03a1\u03a9\u0391 \u0394\u0397\u039c\u039f\u03a4\u03a9\u039d",
            "\u039a\u0391\u03a4\u0391\u03a3\u03a4\u0391\u03a3\u0397 \u0394\u0397\u039c\u039f\u03a3\u0399\u03a9\u039d \u03a5\u03a0\u0391\u039b\u039b\u0397\u039b\u03a9\u039d",
            "\u03a0\u03a1\u039f\u03a3\u03a9\u03a0\u0399\u039a\u039f\u039d \u0394\u0397\u039c\u03a9\u039d \u039a\u0391\u0399 \u039a\u039f\u0399\u039d\u039f\u03a4\u0397\u03a4\u03a9\u039d",
            "\u03a5\u0393\u0395\u0399\u039f\u039d\u039f\u039c\u0399\u039a\u0397 \u0391\u039d\u03a4\u0399\u039b\u0397\u03a8\u0397",
            "\u03a4\u0395\u039b\u0397 \u03a7\u0391\u03a1\u03a4\u039f\u03a3\u0397\u039c\u039f\u03a5",
            "\u03a3\u03a4\u03a1\u0391\u03a4\u0399\u03a9\u03a4\u0399\u039a\u039f\u0399 \u0393\u0395\u039d\u0399\u039a\u0391",
            "\u039b\u0399\u039c\u0395\u039d\u0399\u039a\u0395\u03a3 \u0391\u03a1\u03a7\u0395\u03a3",
            "\u0395\u039b\u0395\u0393\u03a7\u039f\u03a3 \u039a\u03a5\u039a\u039b\u039f\u03a6\u039f\u03a1\u0399\u0391\u03a3",
            "\u03a4\u0391\u039c\u0395\u0399\u039f \u03a3\u03a5\u039d\u03a4\u0391\u039e\u0395\u03a9\u03a3 \u039a\u0391\u0399 \u0391\u03a5\u03a4\u0391\u03a3\u03a6\u0391\u039b\u0399\u03a3\u0395\u03a9\u03a3 \u03a5\u0393\u0395\u0399\u039f\u039d\u039f\u039c\u0399\u039a\u03a9\u039d",
            "\u03a0\u039f\u039b\u0399\u03a4\u0399\u039a\u0397 \u039a\u0391\u0399 \u039f\u0399\u039a\u039f\u039d\u039f\u039c\u0399\u039a\u0397 \u0395\u03a0\u0399\u03a3\u03a4\u03a1\u0391\u03a4\u0395\u03a5\u03a3\u0397",
            "\u03a4\u0397\u039b\u0395\u0393\u03a1\u0391\u03a6\u039f\u0399",
            "\u03a3\u0395\u0399\u03a3\u039c\u039f\u03a0\u039b\u0397\u039a\u03a4\u039f\u0399",
            "\u0399\u0391\u039c\u0391\u03a4\u0399\u039a\u0395\u03a3 \u03a0\u0397\u0393\u0395\u03a3",
            "\u0399\u0394\u0399\u03a9\u03a4\u0399\u039a\u039f \u039d\u0391\u03a5\u03a4\u0399\u039a\u039f \u0394\u0399\u039a\u0391\u0399\u039f",
            "\u0394\u0399\u0395\u0398\u039d\u0395\u0399\u03a3 \u03a5\u0393\u0395\u0399\u039f\u039d\u039f\u039c\u0399\u039a\u0395\u03a3 \u03a3\u03a5\u039c\u0392\u0391\u03a3\u0395\u0399\u03a3",
            "\u039d\u039f\u039c\u0399\u039a\u0391 \u03a0\u03a1\u039f\u03a3\u03a9\u03a0\u0391 \u0394\u0397\u039c\u039f\u03a3\u0399\u039f\u03a5 \u0394\u0399\u039a\u0391\u0399\u039f\u03a5",
            "\u0395\u039a\u039a\u039b\u0397\u03a3\u0399\u0391 \u039a\u03a1\u0397\u03a4\u0397\u03a3",
            "\u03a0\u03a1\u039f\u03a3\u03a4\u0391\u03a3\u0399\u0391 \u039d\u039f\u039c\u0399\u03a3\u039c\u0391\u03a4\u039f\u03a3",
            "\u03a0\u03a1\u039f\u03a3\u03a4\u0391\u03a3\u0399\u0391 \u03a0\u03a1\u039f\u03aa\u039f\u039d\u03a4\u03a9\u039d \u0391\u039c\u03a0\u0395\u039b\u039f\u03a5",
            "\u0391\u039d\u0391\u03a0\u0397\u03a1\u039f\u0399 \u039a\u0391\u0399 \u0398\u03a5\u039c\u0391\u03a4\u0391 \u03a0\u039f\u039b\u0395\u039c\u039f\u03a5",
            "\u03a0\u0391\u03a1\u039f\u03a7\u0395\u03a3 \u0394\u0399\u0391\u03a6\u039f\u03a1\u0395\u03a3",
            "\u03a4\u039f\u03a0\u0399\u039a\u0397 \u0391\u03a5\u03a4\u039f\u0394\u0399\u039f\u0399\u039a\u0397\u03a3\u0397",
            "O\u03a1\u0393\u0391\u039d\u03a9\u03a3\u0397 \u03a3\u03a4\u03a1\u0391\u03a4\u039f\u03a5 \u039e\u0397\u03a1\u0391\u03a3",
            "\u0394\u0399\u0391\u039a\u039f\u03a0\u0395\u03a3 \u03a4\u0397\u03a3 \u0395\u03a1\u0393\u0391\u03a3\u0399\u0391\u03a3",
            "\u039f\u03a1\u0393\u0391\u039d\u0399\u03a3\u039c\u039f\u03a3 \u03a0\u039f\u039b\u0395\u039c\u0399\u039a\u0397\u03a3 \u0391\u0395\u03a1\u039f\u03a0\u039f\u03a1\u0399\u0391\u03a3",
            "\u0395\u03a0\u0399\u039c\u0395\u039b\u0397\u03a4\u0397\u03a1\u0399\u0391",
            "\u0395\u039a\u039a\u039b\u0397\u03a3\u0399\u0391 \u03a4\u0397\u03a3 \u0395\u039b\u039b\u0391\u0394\u039f\u03a3",
            "\u039d\u0391\u03a1\u039a\u03a9\u03a4\u0399\u039a\u0391",
            "\u0395\u039a\u039c\u0395\u03a4\u0391\u039b\u039b\u0395\u03a5\u03a3\u0397 \u03a4\u0391\u03a7\u03a5\u0394\u03a1\u039f\u039c\u0395\u0399\u03a9\u039d",
            "\u039c\u039f\u03a5\u03a3\u0399\u039a\u0397",
            "\u039d\u039f\u039c\u0391\u03a1\u03a7\u0399\u0395\u03a3",
            "\u03a0\u03a1\u039f\u03a3\u03a9\u03a0\u0399\u039a\u039f \u03a0\u039f\u039b\u0395\u039c\u0399\u039a\u039f\u03a5 \u039d\u0391\u03a5\u03a4\u0399\u039a\u039f\u03a5",
            "\u0393\u0395\u039d\u0399\u039a\u039f \u03a7\u0397\u039c\u0395\u0399\u039f \u03a4\u039f\u03a5 \u039a\u03a1\u0391\u03a4\u039f\u03a5\u03a3",
            "\u039a\u03a1\u0391\u03a4\u0399\u039a\u0397",
            "\u0394\u0399\u039f\u0399\u039a\u0397\u03a3\u0397 \u03a0\u039f\u039b\u0395\u039c\u0399\u039a\u039f\u03a5 \u039d\u0391\u03a5\u03a4\u0399\u039a\u039f\u03a5",
            "\u03a0\u0391\u03a1\u039f\u03a7\u039f\u0399 \u03a3\u03a4\u0391\u0398\u0395\u03a1\u03a9\u039d \u0397\u039b\u0395\u039a\u03a4\u03a1\u039f\u039d\u0399\u039a\u03a9\u039d \u0395\u03a0\u0399\u039a\u039f\u0399\u039d\u03a9\u039d\u0399\u03a9\u039d",
            "\u0395\u03a0\u0391\u0393\u0393\u0395\u039b\u039c\u0391\u03a4\u0399\u039a\u039f\u03a3 \u039a\u0399\u039d\u0394\u03a5\u039d\u039f\u03a3",
            "\u0395\u039d\u039f\u03a7\u0395\u03a3 \u03a3\u0395 \u03a7\u03a1\u03a5\u03a3\u039f \u039a\u0391\u0399 \u03a3\u03a5\u039d\u0391\u039b\u039b\u0391\u0393\u039c\u0391",
            "\u0399\u03a0\u03a0\u039f\u03a0\u0391\u03a1\u0391\u0393\u03a9\u0393\u0397",
            "\u0391\u03a5\u03a4\u039f\u039a\u0399\u039d\u0397\u03a4\u0391",
            "\u0391\u0393\u039f\u03a1\u0391\u039d\u039f\u039c\u0399\u039a\u0395\u03a3 \u0394\u0399\u0391\u03a4\u0391\u039e\u0395\u0399\u03a3",
            "\u03a0\u03a1\u039f\u03a3\u03a6\u03a5\u0393\u0395\u03a3",
            "\u0394\u0399\u0391\u03a6\u039f\u03a1\u0391 \u03a3\u03a4\u03a1\u0391\u03a4\u0399\u03a9\u03a4\u0399\u039a\u0391 \u0398\u0395\u039c\u0391\u03a4\u0391",
            "\u0393\u0395\u039d. \u0393\u03a1\u0391\u039c\u039c. \u0392\u0399\u039f\u039c\u0397\u03a7\u0391\u039d\u0399\u0391\u03a3 - \u0393\u0395\u039d. \u0393\u03a1\u0391\u039c\u039c. \u0395\u03a1\u0395\u03a5\u039d\u0391\u03a3 \u039a\u0391\u0399 \u03a4\u0395\u03a7\u039d\u039f\u039b\u039f\u0393\u0399\u0391\u03a3",
            "\u0394\u0399\u0391\u039c\u0395\u03a4\u0391\u039a\u039f\u039c\u0399\u03a3\u0397",
            "\u0394\u0399\u039a\u0391\u0399\u039f\u03a3\u03a4\u0391\u03a3\u0399\u039f",
            "\u03a5\u0394\u0391\u03a4\u0391",
            "\u03a6\u039f\u03a1\u039f\u039b\u039f\u0393\u0399\u039a\u0395\u03a3 \u0394\u0399\u0395\u03a5\u039a\u039f\u039b\u03a5\u039d\u03a3\u0395\u0399\u03a3 \u039a\u0391\u0399 \u0391\u03a0\u0391\u039b\u039b\u0391\u0393\u0395\u03a3",
            "\u039c\u039f\u039d\u039f\u03a0\u03a9\u039b\u0399\u0391",
            "\u0395\u0399\u0394\u0399\u039a\u0395\u03a3 \u0394\u0399\u0391\u0394\u0399\u039a\u0391\u03a3\u0399\u0395\u03a3",
            "\u03a0\u03a1\u039f\u039d\u039f\u0399\u0391 \u0393\u0399\u0391 \u03a4\u039f\u03a5\u03a3 \u03a3\u03a4\u03a1\u0391\u03a4\u0399\u03a9\u03a4\u0399\u039a\u039f\u03a5\u03a3",
            "\u03a0\u039f\u039b\u0399\u03a4\u0399\u039a\u0397 \u0394\u0399\u039a\u039f\u039d\u039f\u039c\u0399\u0391",
            "\u039f\u03a1\u0393\u0391\u039d\u03a9\u03a3\u0397 \u03a7\u03a1\u039f\u039d\u039f\u03a5 \u0395\u03a1\u0393\u0391\u03a3\u0399\u0391\u03a3",
            "\u03a0\u03a1\u039f\u03a3\u03a9\u03a0\u0399\u039a\u039f \u03a4\u03a5\u03a0\u039f\u03a5",
            "\u0394\u0399\u039a\u0391\u03a3\u03a4\u0399\u039a\u039f\u0399 \u0395\u03a0\u0399\u039c\u0395\u039b\u0397\u03a4\u0395\u03a3",
            "\u039b\u039f\u03a5\u03a4\u03a1\u039f\u03a0\u039f\u039b\u0395\u0399\u03a3",
            "\u03a4\u0395\u039b\u03a9\u039d\u0395\u0399\u0391\u039a\u039f\u03a3 \u039a\u03a9\u0394\u0399\u039a\u0391\u03a3",
            "\u03a4\u0391\u039c\u0395\u0399\u039f \u03a3\u03a5\u039d\u03a4\u0391\u039e\u0395\u03a9\u039d \u039d\u039f\u039c\u0399\u039a\u03a9\u039d",
            "\u0394\u0399\u0391\u03a6\u039f\u03a1\u039f\u0399 \u03a4\u0395\u039b\u03a9\u039d\u0395\u0399\u0391\u039a\u039f\u0399 \u039d\u039f\u039c\u039f\u0399",
            "\u0394\u0399\u039f\u0399\u039a\u0397\u03a3\u0397 \u03a0\u039f\u039b\u0399\u03a4\u0399\u039a\u0397\u03a3 \u0391\u0395\u03a1\u039f\u03a0\u039f\u03a1\u0399\u0391\u03a3",
            "\u0391\u0395\u03a1\u039f\u03a0\u039f\u03a1\u0399\u039a\u0395\u03a3 \u0395\u039a\u039c\u0395\u03a4\u0391\u039b\u039b\u0395\u03a5\u03a3\u0395\u0399\u03a3",
            "\u0395\u039c\u03a0\u039f\u03a1\u0399\u039a\u0395\u03a3 \u03a0\u03a1\u0391\u039e\u0395\u0399\u03a3",
            "\u0394\u0399\u039a\u0391\u03a3\u03a4\u0397\u03a1\u0399\u0391",
            "\u0392\u0391\u03a3\u0399\u039b\u0395\u0399\u0391 \u039a\u0391\u0399 \u0391\u039d\u03a4\u0399\u0392\u0391\u03a3\u0399\u039b\u0395\u0399\u0391",
            "\u03a0\u03a1\u039f\u03a3\u03a9\u03a0\u0399\u039a\u039f \u03a0\u039f\u039b\u0395\u039c\u0399\u039a\u0397\u03a3 \u0391\u0395\u03a1\u039f\u03a0\u039f\u03a1\u0399\u0391\u03a3",
            "\u03a0\u03a1\u039f\u03a3\u03a4\u0391\u03a3\u0399\u0391 \u039a\u0391\u0399 \u039a\u0399\u039d\u0397\u03a4\u03a1\u0391 \u0399\u0394\u0399\u03a9\u03a4\u0399\u039a\u03a9\u039d \u0395\u03a0\u0395\u039d\u0394\u03a5\u03a3\u0395\u03a9\u039d",
            "\u0392\u0391\u03a3\u0399\u039b\u0399\u039a\u0391 \u0399\u0394\u03a1\u03a5\u039c\u0391\u03a4\u0391",
            "\u03a3\u0399\u0394\u0397\u03a1\u039f\u0394\u03a1\u039f\u039c\u039f\u0399 \u0393\u0395\u039d\u0399\u039a\u0391",
            "\u03a0\u039d\u0395\u03a5\u039c\u0391\u03a4\u0399\u039a\u0397 \u0399\u0394\u0399\u039f\u039a\u03a4\u0397\u03a3\u0399\u0391",
            "\u0394\u0399\u0391\u03a6\u039f\u03a1\u0391 \u0391\u03a3\u03a6\u0391\u039b\u0399\u03a3\u03a4\u0399\u039a\u0391 \u03a4\u0391\u039c\u0395\u0399\u0391",
            "\u03a5\u0393\u0395\u0399\u039f\u039d\u039f\u039c\u0399\u039a\u0391 \u0395\u03a0\u0391\u0393\u0393\u0395\u039b\u039c\u0391\u03a4\u0391",
            "\u03a6\u039f\u03a1\u039f\u039b\u039f\u0393\u0399\u0391 \u039a\u0391\u03a0\u039d\u039f\u03a5",
            "\u039f\u0399\u039a\u039f\u039d\u039f\u039c\u0399\u039a\u0397 \u0394\u0399\u039f\u0399\u039a\u0397\u03a3\u0397",
            "\u03a7\u03a9\u03a1\u039f\u03a6\u03a5\u039b\u0391\u039a\u0397",
            "\u03a4\u0395\u039b\u03a9\u039d\u0395\u0399\u0391\u039a\u0397 \u03a5\u03a0\u0397\u03a1\u0395\u03a3\u0399\u0391",
            "\u03a0\u0391\u039d\u0395\u03a0\u0399\u03a3\u03a4\u0397\u039c\u0399\u039f \u03a0\u0391\u03a4\u03a1\u03a9\u039d",
            "\u03a4\u0391\u039c\u0395\u0399\u039f \u0395\u03a0\u0399\u039a\u039f\u03a5\u03a1\u0399\u039a\u0397\u03a3 \u0391\u03a3\u03a6\u0391\u039b\u0399\u03a3\u0395\u03a9\u03a3 \u0391\u03a3\u03a6\u0391\u039b\u0399\u03a3\u03a4\u03a9\u039d",
            "\u0391\u03a3\u03a6\u0391\u039b\u0399\u03a3\u03a4\u0399\u039a\u039f\u0399 \u039f\u03a1\u0393\u0391\u039d\u0399\u03a3\u039c\u039f\u0399",
            "\u03a3\u03a4\u03a1\u0391\u03a4\u0399\u03a9\u03a4\u0399\u039a\u0391 \u0395\u03a1\u0393\u0391 \u039a\u0391\u0399 \u03a0\u03a1\u039f\u039c\u0397\u0398\u0395\u0399\u0395\u03a3",
            "\u03a5\u03a0\u039f\u039d\u039f\u039c\u039f\u0399",
            "\u03a6\u039f\u03a1\u039f\u039b\u039f\u0393\u0399\u0391 \u039a\u0395\u03a6\u0391\u039b\u0391\u0399\u039f\u03a5",
            "\u0395\u03a4\u0391\u0399\u03a1\u0395\u0399\u0395\u03a3 \u03a0\u0395\u03a1\u0399\u03a9\u03a1\u0399\u03a3\u039c\u0395\u039d\u0397\u03a3 \u0395\u03a5\u0398\u03a5\u039d\u0397\u03a3",
            "\u03a5\u03a0\u039f\u03a5\u03a1\u0393\u0395\u038a\u039f \u039a\u039f\u0399\u039d\u03a9\u039d\u0399\u039a\u038f\u039d \u0391\u03a3\u03a6\u0391\u039b\u038a\u03a3\u0395\u03a9\u039d",
            "\u03a3\u03a5\u039c\u0392\u039f\u039b\u0391\u0399\u039f\u0393\u03a1\u0391\u03a6\u039f\u0399",
            "\u03a4\u0391\u039c\u0395\u0399\u039f \u0391\u03a3\u03a6\u0391\u039b\u0399\u03a3\u0395\u03a9\u03a3 \u0391\u03a1\u03a4\u0395\u03a1\u0393\u0391\u03a4\u03a9\u039d",
            "\u0395\u03a1\u0393\u0391 \u039a\u0391\u0399 \u03a0\u03a1\u039f\u039c\u0397\u0398\u0395\u0399\u0395\u03a3 \u0394\u0397\u039c\u03a9\u039d \u039a\u0391\u0399 \u039a\u039f\u0399\u039d\u039f\u03a4\u0397\u03a4\u03a9\u039d",
            "\u0395\u039b\u0395\u0393\u039a\u03a4\u0399\u039a\u039f \u03a3\u03a5\u039d\u0395\u0394\u03a1\u0399\u039f",
            "\u0394\u0399\u0391\u03a6\u039f\u03a1\u0391 \u0395\u03a0\u0399\u03a3\u03a4\u0397\u039c\u039f\u039d\u0399\u039a\u0391 \u0399\u0394\u03a1\u03a5\u039c\u0391\u03a4\u0391",
            "\u0391\u039e\u0399\u03a9\u039c\u0391\u03a4\u0399\u039a\u039f\u0399 \u0395\u039d\u039f\u03a0\u039b\u03a9\u039d \u0394\u03a5\u039d\u0391\u039c\u0395\u03a9\u039d",
            "\u03a4\u0391\u039c\u0395\u0399\u039f \u0391\u03a3\u03a6\u0391\u039b\u0399\u03a3\u0395\u03a9\u03a3 \u0395\u039c\u03a0\u039f\u03a1\u03a9\u039d (\u03a4.\u0391.\u0395)",
            "\u03a3\u03a4\u03a1\u0391\u03a4\u0399\u03a9\u03a4\u0399\u039a\u0397 \u03a0\u039f\u0399\u039d\u0399\u039a\u0397",
            "\u03a6\u039f\u03a1\u039f\u039b\u039f\u0393\u0399\u0391 \u039f\u0399\u039d\u039f\u03a0\u039d\u0395\u03a5\u039c\u0391\u03a4\u039f\u03a3",
            "\u039f\u03a1\u0393\u0391\u039d\u0399\u03a3\u039c\u039f\u03a3 \u0393\u0395\u03a9\u03a1\u0393\u0399\u039a\u03a9\u039d \u0391\u03a3\u03a6\u0391\u039b\u0399\u03a3\u0395\u03a9\u039d",
            "\u03a3\u03a5\u039b\u039b\u039f\u0393\u0399\u039a\u0395\u03a3 \u03a3\u03a5\u039c\u0392\u0391\u03a3\u0395\u0399\u03a3 \u0395\u03a1\u0393\u0391\u03a3\u0399\u0391\u03a3",
            "\u03a7\u03a1\u0397\u039c\u0391\u03a4\u0399\u03a3\u03a4\u0397\u03a1\u0399\u0391",
            "\u03a0\u039f\u039b\u0399\u03a4\u0399\u039a\u0391\u0399 \u039a\u0391\u0399 \u03a3\u03a4\u03a1\u0391\u03a4\u0399\u03a9\u03a4\u0399\u039a\u0391\u0399 \u03a3\u03a5\u039d\u03a4\u0391\u039e\u0395\u0399\u03a3",
            "\u039a\u039f\u0399\u039d\u03a9\u039d\u0399\u039a\u0397  \u03a3\u03a4\u0395\u0393\u0391\u03a3\u03a4\u0399\u039a\u0397 \u03a3\u03a5\u039d\u0394\u03a1\u039f\u039c\u0397",
            "\u039a\u0391\u03a4\u039f\u03a7\u03a5\u03a1\u03a9\u03a3\u0397 \u0395\u03a0\u0391\u0393\u0393\u0395\u039b\u039c\u0391\u03a4\u03a9\u039d",
            "\u03a6\u039f\u03a1\u039f\u039b\u039f\u0393\u0399\u0391 \u039a\u0391\u0398\u0391\u03a1\u0391\u03a3 \u03a0\u03a1\u039f\u03a3\u039f\u0394\u039f\u03a5",
            "\u03a0\u0395\u03a1\u0399\u03a6\u0395\u03a1\u0395\u0399\u0395\u03a3",
            "\u0395\u039a\u039a\u039b\u0397\u03a3\u0399\u0391\u03a3\u03a4\u0399\u039a\u0397 \u0394\u0399\u039a\u0391\u0399\u039f\u03a3\u03a5\u039d\u0397",
            "\u03a5\u03a0\u039f\u03a5\u03a1\u0393\u0395\u0399\u039f \u039f\u0399\u039a\u039f\u039d\u039f\u039c\u0399\u039a\u03a9\u039d",
            "\u0395\u0398\u039d\u0399\u039a\u0391 \u039a\u039b\u0397\u03a1\u039f\u0394\u039f\u03a4\u0397\u039c\u0391\u03a4\u0391",
            "\u0395\u0393\u0393\u0395\u0399\u039f\u0392\u0395\u039b\u03a4\u0399\u03a9\u03a4\u0399\u039a\u0391 \u0395\u03a1\u0393\u0391",
            "\u039b\u0399\u039c\u0395\u039d\u0395\u03a3",
            "\u03a6\u03a5\u039b\u0391\u039a\u0395\u03a3",
            "\u0393\u0395\u03a9\u03a1\u0393\u0399\u039a\u0397 \u0395\u039a\u03a0\u0391\u0399\u0394\u0395\u03a5\u03a3\u0397",
            "\u03a0\u039b\u0397\u03a1\u03a9\u039c\u0397 \u0395\u03a1\u0393\u0391\u03a3\u0399\u0391\u03a3",
            "\u0395\u039c\u03a0\u039f\u03a1\u0399\u039a\u039f\u03a3 \u039d\u039f\u039c\u039f\u03a3",
            "\u0399\u0394\u03a1\u03a5\u039c\u0391 \u039a\u039f\u0399\u039d\u03a9\u039d\u0399\u039a\u03a9\u039d \u0391\u03a3\u03a6\u0391\u039b\u0399\u03a3\u0395\u03a9\u039d",
            "\u0391\u03a3\u03a6\u0391\u039b\u0399\u03a3\u03a4\u0399\u039a\u0391 \u03a4\u0391\u039c\u0395\u0399\u0391 \u03a4\u03a1\u0391\u03a0\u0395\u0396\u03a9\u039d",
            "\u0395\u0399\u0394\u0399\u039a\u039f\u0399 \u0391\u0393\u03a1\u039f\u03a4\u0399\u039a\u039f\u0399 \u039d\u039f\u039c\u039f\u0399",
            "\u0394\u0399\u0395\u0398\u039d\u0395\u0399\u03a3 \u0394\u0399\u039a\u039f\u039d\u039f\u039c\u0399\u039a\u0395\u03a3 \u03a3\u03a5\u039c\u0392\u0391\u03a3\u0395\u0399\u03a3",
            "\u03a5\u03a0\u039f\u03a5\u03a1\u0393\u0395\u0399\u0391 \u039c\u0391\u039a\u0395\u0394\u039f\u039d\u0399\u0391\u03a3\u2013\u0398\u03a1\u0391\u039a\u0397\u03a3, \u0391\u0399\u0393\u0391\u0399\u039f\u03a5 \u039a.\u039b.\u03a0",
            "\u0391\u03a3\u03a4\u03a5\u039d\u039f\u039c\u0399\u039a\u039f\u038a \u03a3\u039a\u038e\u039b\u039f\u0399",
            "\u0394\u0399\u0391\u03a6\u039f\u03a1\u0391 \u0398\u0395\u039c\u0391\u03a4\u0391",
            "\u0395\u039a\u0394\u039f\u03a3\u0397 \u0395\u0393\u039a\u039b\u0397\u039c\u0391\u03a4\u0399\u03a9\u039d",
            "\u0391\u0393\u039f\u03a1\u0391\u039d\u039f\u039c\u0399\u0391",
            "\u0394\u0399\u039a\u0391\u03a3\u03a4\u0399\u039a\u039f \u03a4\u039f\u03a5 \u0394\u0397\u039c\u039f\u03a3\u0399\u039f\u03a5",
            "\u0391\u03a3\u03a4\u0399\u039a\u039f\u03a3 \u039a\u03a9\u0394\u0399\u039a\u0391\u03a3",
            "\u03a4\u0395\u039b\u03a9\u039d\u0395\u0399\u0391\u039a\u0395\u03a3 \u0391\u03a4\u0395\u039b\u0395\u0399\u0395\u03a3",
            "\u0391\u0393\u03a1\u039f\u03a4\u0399\u039a\u0395\u03a3 \u039c\u0399\u03a3\u0398\u03a9\u03a3\u0395\u0399\u03a3",
            "\u039b\u0395\u03a9\u03a6\u039f\u03a1\u0395\u0399\u0391",
            "\u0393\u0395\u039d\u0399\u039a\u039f\u0399 \u0395\u03a0\u0399\u03a3\u0399\u03a4\u0399\u03a3\u03a4\u0399\u039a\u039f\u0399 \u039d\u039f\u039c\u039f\u0399",
            "\u0391\u03a3\u03a4\u03a5\u039d\u039f\u039c\u0399\u0391 \u03a0\u039f\u039b\u0395\u03a9\u039d",
            "\u039c\u0397\u03a7\u0391\u039d\u0399\u039a\u039f\u0399 \u039a\u0391\u0399 \u0395\u03a1\u0393\u039f\u039b\u0391\u0392\u039f\u0399",
            "\u03a0\u039f\u039b\u0395\u039c\u0399\u039a\u0395\u03a3 \u03a3\u03a5\u039d\u03a4\u0391\u039e\u0395\u0399\u03a3"
        ],
        "names_file": null,
        "id": null,
        "_type": "ClassLabel"
    }
}
```



## subject


Use the following command to load this dataset in TFDS:

```python
ds = tfds.load('huggingface:greek_legal_code/subject')
```

*   **Description**:

```
Greek_Legal_Code contains 47k classified legal resources from Greek Legislation. Its origin is “Permanent Greek Legislation Code - Raptarchis”,
a collection of Greek legislative documents classified into multi-level (from broader to more specialized) categories.
```

*   **License**: CC BY-SA (Creative Commons / Attribution-ShareAlike)
*   **Version**: 1.0.0
*   **Splits**:

Split  | Examples
:----- | -------:
`'test'` | 9516
`'train'` | 28536
`'validation'` | 9511

*   **Features**:

```json
{
    "text": {
        "dtype": "string",
        "id": null,
        "_type": "Value"
    },
    "label": {
        "num_classes": 2285,
        "names": [
            "\u039c\u0395\u03a4\u039f\u03a7\u0399\u039a\u039f \u03a4\u0391\u039c\u0395\u0399\u039f \u03a0.\u039d",
            "\u039c\u0395\u03a4\u0391\u039d\u0391\u03a3\u03a4\u0395\u03a5\u03a3\u0397 \u03a3\u03a4\u039f \u0392\u0395\u039b\u0393\u0399\u039f",
            "\u039d\u0391\u03a5\u03a4\u0399\u039a\u0395\u03a3 \u03a6\u03a5\u039b\u0391\u039a\u0395\u03a3",
            "\u039a\u0391\u039d\u039f\u039d\u0399\u03a3\u039c\u039f\u03a3 \u0395\u039a\u03a4\u0395\u039b\u0395\u03a3\u0395\u03a9\u03a3 \u03a3\u03a4\u03a1\u0391\u03a4\u0399\u03a9\u03a4\u0399\u039a\u03a9\u039d \u0395\u03a1\u0393\u03a9\u039d",
            "\u0394\u0399\u039f\u0399\u039a\u0397\u03a4\u0399\u039a\u0397 \u039a\u0391\u0399 \u039f\u0399\u039a\u039f\u039d\u039f\u039c\u0399\u039a\u0397 \u03a5\u03a0\u0397\u03a1\u0395\u03a3\u0399\u0391",
            "\u0391\u03a3\u039a\u0397\u03a3\u0397 \u03a0\u039f\u0399\u039d\u0399\u039a\u0397\u03a3 \u0391\u0393\u03a9\u0393\u0397\u03a3",
            "\u039a\u0391\u039d\u039f\u039d\u0399\u03a3\u039c\u039f\u03a3 \u0395\u03a3\u03a9\u03a4\u0395\u03a1\u0399\u039a\u0397\u03a3 \u03a5\u03a0\u0397\u03a1\u0395\u03a3\u0399\u0391\u03a3 \u0395\u03a0\u0399\u0392\u0391\u03a4\u0397\u0393\u03a9\u039d \u03a0\u039b\u039f\u0399\u03a9\u039d",
            "\u039a\u03a9\u0394\u0399\u039a\u0391\u03a3 \u03a0\u039f\u039b\u0399\u03a4\u0399\u039a\u0397\u03a3 \u0394\u0399\u039a\u039f\u039d\u039f\u039c\u0399\u0391\u03a3 - \u03a0\u0391\u039b\u0391\u0399\u039f\u03a3",
            "\u039a\u0391\u03a4\u0391\u03a3\u03a4\u0391\u03a4\u0399\u039a\u039f \u03a4\u0391\u039c\u0395\u0399\u039f\u03a5 \u0391\u03a3\u03a6\u0391\u039b\u0399\u03a3\u0395\u03a9\u03a3 \u0395\u039c\u03a0\u039f\u03a1\u03a9\u039d (\u03a4.\u0391.\u0395)",
            "\u039c\u0397\u03a7\u0391\u039d\u039f\u039b\u039f\u0393\u039f\u0399, \u0397\u039b\u0395\u039a\u03a4\u03a1\u039f\u039b\u039f\u0393\u039f\u0399, \u039d\u0391\u03a5\u03a0\u0397\u0393\u039f\u0399 \u039a\u0391\u0399 \u039c\u0397\u03a7\u0391\u039d\u039f\u0394\u0397\u0393\u039f\u0399",
            "\u03a3\u03a4\u0395\u0393\u0391\u03a3\u0397 \u03a0\u0391\u03a1\u0391\u03a0\u0397\u0393\u039c\u0391\u03a4\u039f\u03a5\u03a7\u03a9\u039d",
            "\u039d\u039f\u039c\u0399\u03a3\u039c\u0391\u03a4\u0399\u039a\u0397 \u0395\u03a0\u0399\u03a4\u03a1\u039f\u03a0\u0397",
            "\u03a0\u0395\u03a1\u0399\u03a6\u0395\u03a1\u0395\u0399\u0391\u039a\u0391 \u03a4\u0391\u039c\u0395\u0399\u0391",
            "\u039c\u0397\u03a4\u03a1\u03a9\u0391 \u0391\u03a1\u03a1\u0395\u039d\u03a9\u039d",
            "\u0394\u0399\u039a\u0391\u03a3\u03a4\u0399\u039a\u0395\u03a3 \u0394\u0399\u0391\u039a\u039f\u03a0\u0395\u03a3",
            "\u03a3\u03a5\u039c\u03a6\u03a9\u039d\u0399\u0391 \u03a0\u0395\u03a1\u0399 \u03a0\u03a1\u039f\u039e\u0395\u039d\u0399\u039a\u03a9\u039d \u03a3\u03a7\u0395\u03a3\u0395\u03a9\u039d",
            "\u03a0\u0391\u039b\u0391\u0399\u039f\u0399 \u0391\u03a3\u03a4\u0399\u039a\u039f\u0399 \u039a\u03a9\u0394\u0399\u039a\u0395\u03a3",
            "\u039a\u039b\u0391\u0394\u039f\u03a3 \u0395\u03a0\u0399\u039a\u039f\u03a5\u03a1\u0399\u039a\u0397\u03a3 \u0391\u03a3\u03a6\u0391\u039b\u0399\u03a3\u0395\u03a9\u03a3 \u0394\u0399\u039a\u0397\u0393\u039f\u03a1\u03a9\u039d (\u039a.\u0395.\u0391.\u0394.)",
            "\u039f\u0399\u039a\u039f\u039d\u039f\u039c\u0399\u039a\u0395\u03a3 \u0391\u03a1\u039c\u039f\u0394\u0399\u039f\u03a4\u0397\u03a4\u0395\u03a3 \u03a3\u03a4\u03a1\u0391\u03a4\u0399\u03a9\u03a4\u0399\u039a\u03a9\u039d \u0391\u03a1\u03a7\u03a9\u039d",
            "\u03a5\u03a0\u039f\u039d\u039f\u039c\u039f\u0399 \u0398\u0395\u03a3\u03a3\u0391\u039b\u039f\u039d\u0399\u039a\u0397\u03a3",
            "\u0394\u0399\u0391\u03a6\u039f\u03a1\u0391 \u03a5\u0394\u03a1\u0391\u03a5\u039b\u0399\u039a\u0391 \u03a4\u0391\u039c\u0395\u0399\u0391",
            "\u0395\u039b\u0395\u0393\u03a7\u039f\u03a3 \u0398\u0395\u0391\u03a4\u03a1\u0399\u039a\u03a9\u039d \u0395\u03a1\u0393\u03a9\u039d \u039a\u0391\u0399 \u0394\u0399\u03a3\u039a\u03a9\u039d",
            "\u03a5\u03a0\u0397\u03a1\u0395\u03a3\u0399\u0391 \u0399\u03a0\u03a0\u039f\u03a0\u0391\u03a1\u0391\u0393\u03a9\u0393\u0397\u03a3",
            "\u03a3\u03a9\u039c\u0391\u03a4\u0399\u039a\u0397 \u0391\u0393\u03a9\u0393\u0397",
            "\u0395\u039a\u0394\u0399\u039a\u0391\u03a3\u0397 \u03a4\u0395\u039b\u03a9\u039d\u0395\u0399\u0391\u039a\u03a9\u039d \u03a0\u0391\u03a1\u0391\u0392\u0391\u03a3\u0395\u03a9\u039d",
            "\u039a\u0399\u039d\u0397\u03a4\u03a1\u0391 \u0399\u0394\u0399\u03a9\u03a4\u0399\u039a\u03a9\u039d \u0395\u03a0\u0395\u039d\u0394\u03a5\u03a3\u0395\u03a9\u039d \u03a3\u03a4\u0397\u039d \u03a0\u0395\u03a1\u0399\u03a6\u0395\u03a1\u0395\u0399\u0391",
            "\u039c\u0395\u039b\u0397 \u039f\u0399\u039a\u039f\u0393\u0395\u039d\u0395\u0399\u0391\u03a3 \u0391\u03a3\u03a6\u0391\u039b\u0399\u03a3\u039c\u0395\u039d\u03a9\u039d",
            "\u039a\u0395\u03a1\u039c\u0391\u03a4\u0391",
            "\u0395\u03a0\u0399\u0394\u039f\u039c\u0391 \u0391\u039d\u0391\u03a0\u03a1\u039f\u03a3\u0391\u03a1\u039c\u039f\u0393\u0397\u03a3",
            "\u0395\u039a\u03a4\u0395\u039b\u0395\u03a3\u0397 \u0394\u0391\u03a3\u0399\u039a\u03a9\u039d \u0395\u03a1\u0393\u03a9\u039d",
            "\u039b\u0399\u03a0\u0391\u03a3\u039c\u0391\u03a4\u0391",
            "\u0395\u03a0\u0399\u03a7\u039f\u03a1\u0397\u0393\u0397\u03a3\u0397 \u03a3\u03a0\u039f\u03a5\u0394\u0391\u03a3\u03a4\u03a9\u039d \u03a4\u0395\u039a\u039d\u03a9\u039d \u0395\u03a1\u0393\u0391\u0396\u039f\u039c\u0395\u039d\u03a9\u039d",
            "\u03a0\u03a1\u039f\u03a3\u03a4\u0391\u03a3\u0399\u0391 \u039f\u0399\u039d\u039f\u03a5",
            "\u03a0\u03a4\u0397\u03a4\u0399\u039a\u039f \u039a\u0391\u0399 \u039a\u0391\u03a4\u0391\u0394\u03a5\u03a4\u0399\u039a\u039f \u0395\u03a0\u0399\u0394\u039f\u039c\u0391",
            "\u03a4\u0391\u039c\u0395\u0399\u039f \u0395\u03a0\u0399\u039a\u039f\u03a5\u03a1\u0399\u039a\u0397\u03a3 \u0391\u03a3\u03a6\u0391\u039b\u0399\u03a3\u0395\u03a9\u03a3 \u03a5\u03a0\u0391\u039b\u039b\u0397\u039b\u03a9\u039d \u0395\u039c\u03a0\u039f\u03a1\u0399\u039a\u03a9\u039d \u039a\u0391\u03a4\u0391\u03a3\u03a4\u0397\u039c\u0391\u03a4\u03a9\u039d (\u03a4.\u0395.\u0391.\u03a5.\u0395.\u039a.)",
            "\u0395\u039a\u039a\u039f\u039a\u039a\u0399\u03a3\u0397 \u0392\u0391\u039c\u0392\u0391\u039a\u039f\u03a3",
            "\u039c\u039f\u039d\u039f\u03a0\u03a9\u039b\u0399\u039f \u039a\u0399\u039d\u0399\u039d\u039f\u03a5",
            "\u0399\u039d\u03a3\u03a4\u0399\u03a4\u039f\u03a5\u03a4\u0391 \u0394\u0399\u0395\u0398\u039d\u039f\u03a5\u03a3 \u0394\u0399\u039a\u0391\u0399\u039f\u03a5",
            "\u0399\u0391\u03a0\u03a9\u039d\u0399\u0391 \u2013 \u0399\u039d\u0394\u0399\u0391 \u2013\u0399\u039f\u03a1\u0394\u0391\u039d\u0399\u0391 \u039a.\u039b\u03a0",
            "\u0395\u03a0\u0399\u0394\u039f\u039c\u0391 \u03a3\u03a4\u039f\u039b\u0397\u03a3",
            "\u0391\u039d\u0391\u0393\u039d\u03a9\u03a1\u0399\u03a3\u0395\u0399\u03a3",
            "\u03a4\u0391\u039c\u0395\u0399\u039f \u03a0\u03a1\u039f\u039d\u039f\u0399\u0391\u03a3 \u0395\u03a1\u0393\u039f\u039b\u0397\u03a0\u03a4\u03a9\u039d",
            "\u0391\u039d\u0391\u03a3\u03a4\u039f\u039b\u0397 \u03a4\u0397\u03a3 \u03a0\u039f\u0399\u039d\u0397\u03a3",
            "\u03a0\u039f\u03a4\u0391\u039c\u039f\u03a0\u039b\u039f\u0399\u0391",
            "\u0395\u0399\u0394\u0399\u039a\u0397 \u03a4\u0395\u039b\u03a9\u039d\u0395\u0399\u0391\u039a\u0397 \u03a0\u0391\u03a1\u0391\u039a\u039f\u039b\u039f\u03a5\u0398\u0397\u03a3\u0397",
            "\u0395\u03a0\u0399\u0398\u0395\u03a9\u03a1\u0397\u03a3\u0397 \u03a6\u0391\u03a1\u039c\u0391\u039a\u0395\u0399\u03a9\u039d",
            "\u03a3\u03a5\u039d\u03a4\u0391\u039e\u0395\u0399\u03a3 \u0398\u03a5\u039c\u0391\u03a4\u03a9\u039d \u0395\u0398\u039d\u0399\u039a\u03a9\u039d",
            "\u0391\u03a0\u039b\u039f\u03a0\u039f\u0399\u0397\u03a3\u0397 \u03a4\u0395\u039b\u03a9\u039d\u0395\u0399\u0391\u039a\u03a9\u039d \u0394\u0399\u0391\u03a4\u03a5\u03a0\u03a9\u03a3\u0395\u03a9\u039d",
            "\u039a\u039b\u0391\u0394\u039f\u03a3 \u0391\u03a3\u0398\u0395\u039d\u0395\u0399\u0391\u03a3 \u03a4.\u0391.\u039a.\u0395",
            "\u03a5\u03a0\u0397\u03a1\u0395\u03a3\u0399\u0391 \u03a5\u03a0\u039f\u0394\u039f\u03a7\u0397\u03a3 \u03a0\u039b\u039f\u0399\u03a9\u039d \u039a\u0391\u0399 \u03a0\u039f\u039b\u0395\u039c\u0399\u039a\u0397 \u03a7\u03a1\u0397\u03a3\u0397 \u039b\u0399\u039c\u0395\u039d\u03a9\u039d",
            "\u03a6\u0391\u03a1\u039c\u0391\u039a\u0395\u0399\u039f \u03a0\u039f\u039b\u0395\u039c\u0399\u039a\u039f\u03a5 \u039d\u0391\u03a5\u03a4\u0399\u039a\u039f\u03a5",
            "\u03a4\u0391\u039c\u0395\u0399\u039f \u0391\u03a0\u039f\u039a\u0391\u03a4\u0391\u03a3\u03a4\u0391\u03a3\u0395\u03a9\u03a3 \u03a0\u03a1\u039f\u03a3\u03a6\u03a5\u0393\u03a9\u039d \u03a3\u03a5\u039c\u0392\u039f\u03a5\u039b\u0399\u039f\u03a5 \u03a4\u0397\u03a3 \u0395\u03a5\u03a1\u03a9\u03a0\u0397\u03a3",
            "\u039d\u0391\u03a5\u03a4\u0399\u039a\u0395\u03a3 \u0395\u03a4\u0391\u0399\u03a1\u0395\u0399\u0395\u03a3",
            "\u0399\u03a3\u03a1\u0391\u0397\u039b\u0399\u03a4\u0399\u039a\u0395\u03a3 \u039a\u039f\u0399\u039d\u039f\u03a4\u0397\u03a4\u0395\u03a3",
            "\u03a3\u0395\u0399\u03a3\u039c\u039f\u03a0\u039b\u0397\u039a\u03a4\u039f\u0399  \u03a3\u03a4\u0395\u03a1\u0395\u0391\u03a3 \u0395\u039b\u039b\u0391\u0394\u0391\u03a3 (\u0391\u03a4\u03a4\u0399\u039a\u0397\u03a3, \u0392\u039f\u0399\u03a9\u03a4\u0399\u0391\u03a3 \u039a.\u039b.\u03a0.)",
            "\u0394\u0399\u0391\u03a6\u039f\u03a1\u0395\u03a3 \u03a3\u03a7\u039f\u039b\u0395\u03a3 \u03a0.\u039d",
            "\u03a4\u0391\u039c\u0395\u0399\u039f \u03a0\u03a1\u039f\u039d\u039f\u0399\u0391\u03a3 \u03a0\u03a1\u039f\u03a3\u03a9\u03a0\u0399\u039a\u039f\u03a5 \u0395\u039c\u03a0\u039f\u03a1.\u039a\u0391\u0399 \u0392\u0399\u039f\u039c.- \u0395\u03a0\u0391\u0393\u0393\u0395\u039b. \u039a\u0391\u0399 \u0392\u0399\u039f\u03a4\u0395\u03a7\u039d. \u0395\u03a0\u0399\u039c\u0395\u039b\u0397\u03a4\u0397\u03a1\u0399\u03a9\u039d \u03a4\u039f\u03a5 \u039a\u03a1\u0391\u03a4\u039f\u03a5\u03a3",
            "\u0395\u0398\u039d\u0399\u039a\u0397 \u039a\u03a4\u0397\u039c\u0391\u03a4\u0399\u039a\u0397 \u03a4\u03a1\u0391\u03a0\u0395\u0396\u0391",
            "\u039d\u0391\u03a5\u03a4\u0399\u039a\u039f\u0399 \u0391\u039a\u039f\u039b\u039f\u03a5\u0398\u039f\u0399",
            "\u0394\u0397\u039c\u039f\u03a3\u0399\u0395\u03a3 \u039d\u0391\u03a5\u03a4\u0399\u039a\u0395\u03a3 \u03a3\u03a7\u039f\u039b\u0395\u03a3",
            "\u039c\u0399\u039a\u03a1\u039f\u03a6\u03a9\u03a4\u039f\u0393\u03a1\u0391\u03a6\u0399\u0395\u03a3",
            "\u039a\u0391\u03a4\u0391\u03a3\u03a4\u0391\u03a4\u0399\u039a\u039f\u0399 \u039d\u039f\u039c\u039f\u0399-\u03a4.\u03a3.\u0391.\u03a5",
            "\u039a\u0391\u03a4\u0391\u03a3\u03a4\u0391\u03a3\u0397 \u0391\u039e\u0399\u03a9\u039c\u0391\u03a4\u0399\u039a\u03a9\u039d \u03a0.\u039d",
            "\u0395\u039b\u039b\u0397\u039d\u0399\u039a\u0391 \u03a3\u03a7\u039f\u039b\u0395\u0399\u0391 \u0391\u039b\u039b\u039f\u0394\u0391\u03a0\u0397\u03a3",
            "\u039f\u03a1\u0393\u0391\u039d\u0399\u03a3\u039c\u039f\u03a3 \u039f\u0399\u039a\u039f\u039d\u039f\u039c\u0399\u039a\u0397\u03a3",
            "\u0395\u0398\u039d\u0399\u039a\u0397 \u03a4\u03a1\u0391\u03a0\u0395\u0396\u0391 \u03a4\u0397\u03a3 \u0395\u039b\u039b\u0391\u0394\u039f\u03a3",
            "\u0393\u0395\u039d\u0399\u039a\u0395\u03a3 \u0394\u0399\u0391\u03a4\u0391\u039e\u0395\u0399\u03a3 \u039d.\u03a0.\u0394.\u0394",
            "\u03a0\u03a1\u039f\u03a3\u03a9\u03a0\u0399\u039a\u039f \u039c\u0395 \u03a3\u03a7\u0395\u03a3\u0397 \u0399\u0394\u0399\u03a9\u03a4\u0399\u039a\u039f\u03a5 \u0394\u0399\u039a\u0391\u0399\u039f\u03a5",
            "\u03a4\u0391\u039c\u0395\u0399\u039f \u0395\u03a0\u0399\u039a\u039f\u03a5\u03a1\u0399\u039a\u0397\u03a3 \u0391\u03a3\u03a6\u0391\u039b\u0399\u03a3\u0395\u03a9\u03a3 \u03a0\u03a1\u039f\u03a3\u03a9\u03a0\u0399\u039a\u039f\u03a5 \u0395\u03a4\u0391\u0399\u03a1\u0395\u0399\u0391\u03a3 \u03a5\u0394\u03a1\u0395\u03a5\u03a3\u0397\u03a3 \u039a\u0391\u0399 \u0391\u03a0\u039f\u03a7\u0395\u03a4\u0395\u03a5\u03a3\u0397\u03a3 \u03a0\u03a1\u03a9\u03a4\u0395\u03a5\u039f\u03a5\u03a3\u0397\u03a3 (\u03a4.\u0395.\u0391.\u03a0.\u0395.\u03a5.\u0391.\u03a0.)",
            "\u03a3\u03a9\u039c\u0391 \u039f\u0399\u039a\u039f\u039d\u039f\u039c\u0399\u039a\u039f\u03a5 \u0395\u039b\u0395\u0393\u03a7\u039f\u03a5",
            "\u03a3\u03a5\u039c\u0392\u0391\u03a3\u0397 \u03a0\u0395\u03a1\u0399 \u0394\u0399\u0395\u039a\u0394\u0399\u039a\u0397\u03a3\u0395\u03a9\u03a3 \u0394\u0399\u0391\u03a4\u03a1\u039f\u03a6\u0397\u03a3",
            "\u0399\u03a3\u039f\u03a4\u0397\u03a4\u0391 \u03a4\u03a9\u039d \u0394\u03a5\u039f \u03a6\u03a5\u039b\u03a9\u039d",
            "\u03a4\u0391\u039c\u0395\u0399\u039f \u0391\u03a1\u03a9\u0393\u0397\u03a3 \u039a\u0391\u0399 \u0395\u03a0\u0399\u039a\u039f\u03a5\u03a1\u0399\u039a\u039f \u03a4\u0391\u039c\u0395\u0399\u039f",
            "\u03a4\u039f\u03a5\u03a1\u0399\u03a3\u03a4\u0399\u039a\u039f \u0394\u0395\u039b\u03a4\u0399\u039f",
            "\u0394\u0399\u0391\u03a6\u039f\u03a1\u039f\u0399 \u039d\u039f\u039c\u039f\u0399",
            "\u039f\u03a1\u0393\u0391\u039d\u0399\u03a3\u039c\u039f\u03a3 \u039b\u0399\u039c\u0395\u039d\u039f\u03a3 \u03a0\u0395\u0399\u03a1\u0391\u0399\u03a9\u03a3 \u0391\u039d\u03a9\u039d\u03a5\u039c\u0397 \u0395\u03a4\u0391\u0399\u03a1\u0399\u0391",
            "\u0395\u039a\u039a\u0391\u0398\u0391\u03a1\u0399\u03a3\u0399\u03a3 \u0394\u0399\u039f\u03a1\u0399\u03a3\u039c\u03a9\u039d \u039a\u0391\u0399 \u03a0\u03a1\u039f\u0391\u0393\u03a9\u0393\u03a9\u039d \u039a\u0391\u03a4\u039f\u03a7\u0397\u03a3",
            "\u03a4\u0391\u039e\u0399\u039d\u039f\u039c\u0397\u03a3\u0397 \u0392\u0391\u039c\u0392\u0391\u039a\u039f\u03a3",
            "\u03a0\u03a1\u03a5\u03a4\u0391\u039d\u0395\u0399\u03a3 \u039a\u0391\u0399 \u039a\u039f\u03a3\u039c\u0397\u03a4\u039f\u03a1\u0395\u03a3",
            "\u03a5\u03a0\u0397\u03a1\u0395\u03a3\u0399\u0391\u039a\u039f \u03a3\u03a5\u039c\u0392\u039f\u03a5\u039b\u0399\u039f \u0395\u039a\u039a\u039b\u0397\u03a3\u0399\u0391\u03a3\u03a4\u0399\u039a\u0397\u03a3 \u0395\u039a\u03a0\u0391\u0399\u0394\u0395\u03a5\u03a3\u0397\u03a3",
            "\u03a9\u03a1\u0395\u03a3 \u0395\u03a1\u0393\u0391\u03a3\u0399\u0391\u03a3 \u03a3\u03a4\u0397\u039d \u0392\u0399\u039f\u039c\u0397\u03a7\u0391\u039d\u0399\u0391 \u039a\u0391\u0399 \u0392\u0399\u039f\u03a4\u0395\u03a7\u039d\u0399\u0391",
            "\u03a7\u0391\u03a1\u03a4\u0397\u03a3 \u039f\u03a1\u0393\u0391\u039d\u0399\u03a3\u039c\u039f\u03a5 \u039f\u0399\u039a\u039f\u039d\u039f\u039c\u0399\u039a\u0397\u03a3 \u03a3\u03a5\u039d\u0395\u03a1\u0393\u0391\u03a3\u0399\u0391\u03a3",
            "\u0393\u03a5\u039c\u039d\u0391\u03a3\u0399\u039f \u0391\u03a0\u039f\u0394\u0397\u039c\u03a9\u039d \u0395\u039b\u039b\u0397\u039d\u039f\u03a0\u0391\u0399\u0394\u03a9\u039d",
            "\u039a\u0391\u039d\u039f\u039d\u0399\u03a3\u039c\u039f\u03a3 \u0391\u03a3\u0398\u0395\u039d\u0395\u0399\u0391\u03a3",
            "\u0395\u039a\u0394\u039f\u03a3\u0395\u0399\u03a3 \u03a5\u03a0\u039f\u03a5\u03a1\u0393\u0395\u0399\u039f\u03a5 \u0395\u039c\u03a0\u039f\u03a1\u0399\u039a\u0397\u03a3 \u039d\u0391\u03a5\u03a4\u0399\u039b\u0399\u0391\u03a3",
            "\u03a0\u039b\u0397\u03a4\u03a4\u039f\u039c\u0395\u039d\u039f\u0399 \u0391\u03a0\u039f \u0398\u0395\u039f\u039c\u0397\u039d\u0399\u0395\u03a3 \u039a\u0391\u0399 \u0391\u039b\u039b\u0391 \u0395\u039a\u03a4\u0391\u039a\u03a4\u0391 \u0393\u0395\u0393\u039f\u039d\u039f\u03a4\u0391",
            "\u03a9\u03a1\u0395\u03a3 \u0395\u03a1\u0393\u0391\u03a3\u0399\u0391\u03a3 \u03a0\u03a1\u039f\u03a3\u03a9\u03a0\u0399\u039a\u039f\u03a5",
            "\u0393\u0395\u03a9\u039c\u0397\u039b\u0391",
            "\u03a6\u039f\u03a1\u039f\u039b\u039f\u0393\u0399\u0391 \u0391\u039d\u0391\u03a4\u0399\u039c\u0397\u03a3\u0397\u03a3 \u0391\u039a\u0399\u039d\u0397\u03a4\u03a9\u039d",
            "\u03a0\u0391\u039d\u03a9\u039b\u0397\u03a3",
            "\u03a3\u03a7\u039f\u039b\u0395\u03a3 \u039d\u0397\u03a0\u0399\u0391\u0393\u03a9\u0393\u03a9\u039d",
            "\u03a6\u0391\u03a1\u039c\u0391\u039a\u0391\u03a0\u039f\u0398\u0397\u039a\u0395\u03a3",
            "\u03a6\u03a1\u039f\u039d\u03a4\u0399\u03a3\u03a4\u0397\u03a1\u0399\u0391 \u039d\u039f\u039c\u0399\u039a\u03a9\u039d \u03a3\u03a0\u039f\u03a5\u0394\u03a9\u039d",
            "\u039f\u0399\u039a\u039f\u0393\u0395\u039d\u0395\u0399\u0391\u039a\u0391 \u0395\u03a0\u0399\u0394\u039f\u039c\u0391\u03a4\u0391 \u039c\u0399\u03a3\u0398\u03a9\u03a4\u03a9\u039d",
            "\u0397\u039b\u0395\u039a\u03a4\u03a1\u039f\u039a\u0399\u039d\u0397\u03a4\u0391 \u039b\u0395\u03a9\u03a6\u039f\u03a1\u0395\u0399\u0391 \u0391\u0398\u0397\u039d\u03a9\u039d \u2013 \u03a0\u0395\u0399\u03a1\u0391\u0399\u03a9\u03a3 (\u0397.\u039b.\u03a0.\u0391.\u03a0.)",
            "\u0391\u03a3\u03a4\u0399\u039a\u0391 \u0394\u0399\u039a\u0391\u0399\u03a9\u039c\u0391\u03a4\u0391 \u0391\u039b\u039b\u039f\u0394\u0391\u03a0\u03a9\u039d",
            "\u03a0\u039f\u039b\u0399\u03a4\u0399\u039a\u039f \u03a0\u03a1\u039f\u03a3\u03a9\u03a0\u0399\u039a\u039f \u0391\u0395\u03a1\u039f\u03a0\u039f\u03a1\u0399\u0391\u03a3",
            "\u0394\u0399\u039a\u0391\u03a3\u03a4\u0399\u039a\u0397 \u0395\u039a\u03a0\u03a1\u039f\u03a3\u03a9\u03a0\u0397\u03a3\u0397 \u0399.\u039a.\u0391",
            "\u03a5\u0393\u0395\u0399\u039f\u039d\u039f\u039c\u0399\u039a\u0397 \u03a5\u03a0\u0397\u03a1\u0395\u03a3\u0399\u0391 \u03a0.\u03a3",
            "\u03a5\u0393\u0395\u0399\u039f\u039d\u039f\u039c\u0399\u039a\u039f\u0399 \u03a3\u03a4\u0391\u0398\u039c\u039f\u0399",
            "\u0399\u0395\u03a1\u0391\u03a1\u03a7\u0399\u0391 \u039a\u0391\u0399 \u03a0\u03a1\u039f\u0391\u0393\u03a9\u0393\u0395\u03a3 \u039c\u039f\u039d\u0399\u039c\u03a9\u039d \u03a5\u03a0\u0391\u039e\u0399\u03a9\u039c\u0391\u03a4\u0399\u039a\u03a9\u039d \u039a\u0391\u0399 \u0391\u039d\u0398\u03a5\u03a0\u0391\u03a3\u03a0\u0399\u03a3\u03a4\u03a9\u039d",
            "\u03a4\u0391\u039c\u0395\u0399\u039f \u0395\u03a0\u0399\u039a\u039f\u03a5\u03a1\u0399\u039a\u0397\u03a3 \u0391\u03a3\u03a6\u0391\u039b\u0399\u03a3\u0395\u03a9\u03a3 \u0395\u03a1\u0393\u0391\u03a4\u039f\u03a4\u0395\u03a7\u039d\u0399\u03a4\u03a9\u039d \u039a\u0391\u0399 \u03a5\u03a0\u0391\u039b\u039b\u0397\u039b\u03a9\u039d \u0394\u0395\u03a1\u039c\u0391\u03a4\u039f\u03a3 \u0395\u039b\u039b\u0391\u0394\u0391\u03a3 (\u03a4.\u0395.\u0391.\u0395.\u03a5.\u0394.\u0395.)",
            "\u03a0\u03a1\u0391\u03a4\u0397\u03a1\u0399\u0391 \u0391\u03a1\u03a4\u039f\u03a5",
            "\u03a0\u039b\u0397\u03a1\u03a9\u039c\u0397 \u039c\u0395 \u0395\u03a0\u0399\u03a4\u0391\u0393\u0397",
            "\u03a4\u0395\u03a7\u039d\u0399\u039a\u0397 \u0395\u039a\u039c\u0395\u03a4\u0391\u039b\u039b\u0395\u03a5\u03a3\u0397 \u0395\u039b\u0399\u039a\u039f\u03a0\u03a4\u0395\u03a1\u03a9\u039d",
            "\u0394\u0399\u0395\u0398\u039d\u0395\u0399\u03a3 \u03a4\u0391\u03a7\u03a5\u0394\u03a1\u039f\u039c\u0399\u039a\u0395\u03a3 \u03a3\u03a5\u039c\u0392\u0391\u03a3\u0395\u0399\u03a3",
            "\u0394\u0399\u039a\u0391\u03a3\u03a4\u0399\u039a\u039f\u0399 \u0391\u039d\u03a4\u0399\u03a0\u03a1\u039f\u03a3\u03a9\u03a0\u039f\u0399 \u03a4\u039f\u03a5 \u0394\u0397\u039c\u039f\u03a3\u0399\u039f\u03a5",
            "\u03a9\u03a1\u0395\u03a3 \u0395\u03a1\u0393\u0391\u03a3\u0399\u0391\u03a3 \u03a3\u0395 \u0394\u0399\u0391\u03a6\u039f\u03a1\u0391 \u0395\u03a0\u0391\u0393\u0393\u0395\u039b\u039c\u0391\u03a4\u0391",
            "\u0394\u0399\u0395\u03a5\u0398\u03a5\u039d\u03a3\u0397 \u039a\u03a4\u0397\u039d\u039f\u03a4\u03a1\u039f\u03a6\u0399\u0391\u03a3",
            "\u0395\u03a0\u0399\u0398\u0395\u03a9\u03a1\u0397\u03a3\u0397 \u03a3\u03a6\u0391\u0393\u0399\u03a9\u039d",
            "\u03a0\u039b\u03a9\u0399\u039c\u039f\u03a4\u0397\u03a4\u0391 \u0391\u0395\u03a1\u039f\u03a3\u039a\u0391\u03a6\u03a9\u039d",
            "\u0391\u0393\u039f\u03a1\u0391\u039d\u039f\u039c\u0399\u039a\u039f\u03a3 \u039a\u03a9\u0394\u0399\u039a\u0391\u03a3",
            "\u0394\u0399\u0395\u0398\u039d\u0395\u0399\u03a3 \u039c\u0395\u03a4\u0391\u03a6\u039f\u03a1\u0395\u03a3 \u0395\u03a0\u0399\u0392\u0391\u03a4\u03a9\u039d \u039a\u0391\u0399 \u0395\u039c\u03a0\u039f\u03a1\u0395\u03a5\u039c\u0391\u03a4\u03a9\u039d",
            "\u03a0\u03a1\u039f\u039c\u0397\u0398\u0395\u0399\u0395\u03a3",
            "\u0394\u0399\u0391\u03a6\u039f\u03a1\u0395\u03a3 \u0394\u0399\u0391\u03a4\u0391\u039e\u0395\u0399\u03a3",
            "\u0394\u0399\u0391\u0399\u03a4\u0397\u03a3\u0399\u0391 \u03a3\u03a5\u039b\u039b\u039f\u0393\u0399\u039a\u03a9\u039d \u0394\u0399\u0391\u03a6\u039f\u03a1\u03a9\u039d - \u039c\u0395\u03a3\u039f\u039b\u0391\u0392\u0397\u03a4\u0395\u03a3 \u0394\u0399\u0391\u0399\u03a4\u0397\u03a4\u0395\u03a3",
            "\u03a3\u039f\u03a5\u039b\u03a4\u0391\u039d\u0399\u039d\u0391",
            "\u039c\u0395\u03a4\u0391\u0393\u03a1\u0391\u03a6\u0397",
            "\u0395\u0399\u03a3\u0391\u0393\u03a9\u0393\u0397 \u0395\u03a0\u0399\u03a3\u03a4\u0397\u039c\u039f\u039d\u0399\u039a\u039f\u03a5 \u03a5\u039b\u0399\u039a\u039f\u03a5",
            "\u0394\u0399\u0391\u03a1\u0398\u03a1\u03a9\u03a3\u0397 \u03a5\u03a0\u0397\u03a1\u0395\u03a3\u0399\u03a9\u039d  \u039f.\u0393.\u0391",
            "\u0394\u0399\u039a\u0391\u03a3\u03a4\u0399\u039a\u039f\u0399 \u039b\u0395\u0399\u03a4\u039f\u03a5\u03a1\u0393\u039f\u0399 - \u0395\u0398\u039d\u0399\u039a\u0397 \u03a3\u03a7\u039f\u039b\u0397 \u0394\u0399\u039a\u0391\u03a3\u03a4\u03a9\u039d",
            "\u03a0\u0399\u03a3\u03a4\u039f\u03a0\u039f\u0399\u0397\u03a4\u0399\u039a\u0391 \u039a\u0391\u0399 \u0394\u0399\u039a\u0391\u0399\u039f\u039b\u039f\u0393\u0397\u03a4\u0399\u039a\u0391",
            "\u0391\u03a3\u039a\u0397\u03a3\u0397 \u0399\u0391\u03a4\u03a1\u0399\u039a\u039f\u03a5 \u0395\u03a0\u0391\u0393\u0393\u0395\u039b\u039c\u0391\u03a4\u039f\u03a3",
            "\u03a3\u03a5\u039d\u0395\u03a4\u0391\u0399\u03a1\u0399\u03a3\u039c\u039f\u0399 \u0394\u0397\u039c\u039f\u03a3\u0399\u03a9\u039d \u03a5\u03a0\u0391\u039b\u039b\u0397\u039b\u03a9\u039d",
            "\u03a3\u03a7\u039f\u039b\u0397 \u0395\u03a0\u0399\u03a3\u03a4\u0397\u039c\u03a9\u039d \u03a5\u0393\u0395\u0399\u0391\u03a3 \u03a0\u0391\u039d\u039c\u0399\u039f\u03a5 \u03a0\u0391\u03a4\u03a1\u03a9\u039d",
            "\u0391\u039b\u039b\u039f\u0394\u0391\u03a0\u0395\u03a3 \u039d\u0391\u03a5\u03a4\u0399\u039b\u0399\u0391\u039a\u0395\u03a3 \u0395\u03a0\u0399\u03a7\u0395\u0399\u03a1\u0397\u03a3\u0395\u0399\u03a3",
            "\u039b\u0391\u03a4\u039f\u039c\u0395\u0399\u0391",
            "\u0395\u039a\u039c\u0395\u03a4\u0391\u039b\u039b\u0395\u03a5\u03a3\u0397 \u0399\u0391\u039c\u0391\u03a4\u0399\u039a\u03a9\u039d \u03a0\u0397\u0393\u03a9\u039d",
            "\u03a0\u03a9\u039b\u0397\u03a3\u0397 \u03a7\u03a1\u0395\u03a9\u0393\u03a1\u0391\u03a6\u03a9\u039d \u039c\u0395 \u0394\u039f\u03a3\u0395\u0399\u03a3",
            "\u039d\u039f\u039c\u039f\u0398\u0395\u03a3\u0399\u0391 \u03a0\u0395\u03a1\u0399 \u03a4\u03a1\u0391\u03a0\u0395\u0396\u03a9\u039d (\u0393\u0395\u039d\u0399\u039a\u0391)",
            "\u0395\u0399\u0394\u0399\u039a\u0391 \u039c\u0395\u03a4\u0391\u039b\u039b\u0395\u0399\u0391",
            "Y\u03a0\u039f\u03a5\u03a1\u0393\u0395\u0399\u039f \u03a5\u0393\u0399\u0395\u0399\u039d\u0397\u03a3",
            "\u039b\u0397\u039e\u0399\u0391\u03a1\u03a7\u0399\u039a\u0395\u03a3 \u03a0\u03a1\u0391\u039e\u0395\u0399\u03a3",
            "\u0393\u0395\u039d\u0399\u039a\u0395\u03a3 \u0394\u0399\u0391\u03a4\u0391\u039e\u0395\u0399\u03a3 \u0393\u0399\u0391 \u03a4\u039f\u039d \u03a4\u03a5\u03a0\u039f",
            "\u0395\u0398\u039d\u0399\u039a\u039f \u03a3\u03a5\u03a3\u03a4\u0397\u039c\u0391 \u0395\u03a0\u0391\u0393\u0393\u0395\u039b\u039c\u0391\u03a4\u0399\u039a\u0397\u03a3 \u0395\u039a\u03a0\u0391\u0399\u0394\u0395\u03a5\u03a3\u0397\u03a3-\u039a\u0391\u03a4\u0391\u03a1\u03a4\u0399\u03a3\u0397\u03a3",
            "\u0391\u03a1\u039f\u03a5\u03a1\u0391\u0399\u039f\u0399 \u039a\u0391\u0399 \u0391\u039a\u03a1\u0399\u0394\u0395\u03a3",
            "\u03a0\u03a1\u039f\u03a3\u03a4\u0391\u03a3\u0399\u0391 \u03a6\u03a5\u039c\u0391\u03a4\u0399\u039a\u03a9\u039d \u039d\u0391\u03a5\u03a4\u0399\u039a\u03a9\u039d",
            "\u0391\u03a0\u039f\u03a1\u03a1\u0397\u03a4\u039f \u0395\u03a0\u0399\u03a3\u03a4\u039f\u039b\u03a9\u039d \u039a\u0391\u0399 \u0395\u03a0\u0399\u039a\u039f\u0399\u039d\u03a9\u039d\u0399\u03a9\u039d",
            "\u03a0\u039f\u03a1\u0398\u039c\u0395\u0399\u0391 \u039a\u0391\u0399 \u039f\u03a7\u0397\u039c\u0391\u03a4\u0391\u0393\u03a9\u0393\u0391",
            "\u039c\u0395\u03a4\u03a1\u0391 \u0395\u039e\u039f\u0399\u039a\u039f\u039d\u039f\u039c\u0397\u03a3\u0397\u03a3 \u0395\u039d\u0395\u03a1\u0393\u0395\u0399\u0391\u03a3",
            "\u03a3\u03a4\u039f\u0399\u03a7\u0395\u0399\u0391 \u03a0\u03a1\u039f\u03a3\u03a9\u03a0\u0399\u039a\u039f\u03a5 \u0394\u0397\u039c\u039f\u03a3\u0399\u03a9\u039d \u03a5\u03a0\u0397\u03a1\u0395\u03a3\u0399\u03a9\u039d \u039a\u0391\u0399 \u039d.\u03a0.\u0394.\u0394",
            "\u03a0\u0391\u0393\u0399\u0395\u03a3 \u0391\u039c\u039f\u0399\u0392\u0395\u03a3 \u0394\u0399\u039a\u0397\u0393\u039f\u03a1\u03a9\u039d",
            "\u039f\u03a1\u0393\u0391\u039d\u0399\u03a3\u039c\u039f\u03a3 \u03a3\u03a7\u039f\u039b\u0397\u03a3 \u0395\u03a5\u0395\u039b\u03a0\u0399\u0394\u03a9\u039d",
            "\u039f\u0399\u039a\u039f\u039d\u039f\u039c\u0399\u039a\u039f \u0395\u03a0\u0399\u039c\u0395\u039b\u0397\u03a4\u0397\u03a1\u0399\u039f \u03a4\u0397\u03a3 \u0395\u039b\u039b\u0391\u0394\u0391\u03a3",
            "\u0393\u03a1\u0391\u03a6\u0395\u0399\u0391 \u0395\u03a5\u03a1\u0395\u03a3\u0395\u03a9\u03a3 \u0395\u03a1\u0393\u0391\u03a3\u0399\u0391\u03a3",
            "\u0394\u0399\u0391\u03a6\u0397\u039c\u0399\u03a3\u0395\u0399\u03a3",
            "\u0394\u0399\u0391\u03a6\u039f\u03a1\u0395\u03a3 \u03a5\u03a0\u039f\u03a4\u03a1\u039f\u03a6\u0399\u0395\u03a3",
            "\u03a6\u039f\u03a1\u03a4\u0397\u0393\u0391 \u0391\u039a\u03a4\u039f\u03a0\u039b\u039f\u0399\u039a\u0391 \u03a0\u039b\u039f\u0399\u0391 (\u039cS) \u039c\u0395\u03a7\u03a1\u0399 500 \u039a.\u039f.\u03a7",
            "\u0395\u03a0\u0399\u03a4\u03a1\u039f\u03a0\u0397 \u03a3\u03a5\u039d\u0395\u03a1\u0393\u0391\u03a3\u0399\u0391\u03a3 UNICEF",
            "\u03a5\u0393\u0399\u0395\u0399\u039d\u0397 \u0398\u0395\u03a1\u0395\u03a4\u03a1\u03a9\u039d",
            "\u0395\u03a0\u0399\u03a3\u03a4\u0397\u039c\u039f\u039d\u0399\u039a\u0397 \u0395\u03a1\u0395\u03a5\u039d\u0391 \u039a\u0391\u0399 \u03a4\u0395\u03a7\u039d\u039f\u039b\u039f\u0393\u0399\u0391",
            "\u0391\u03a0\u0391\u0393\u039f\u03a1\u0395\u03a5\u03a3\u0395\u0399\u03a3 \u0395\u039e\u0391\u0393\u03a9\u0393\u0397\u03a3",
            "\u0391\u039c\u03a0\u0395\u039b\u039f\u03a5\u03a1\u0393\u0399\u039a\u039f \u039a\u03a4\u0397\u039c\u0391\u03a4\u039f\u039b\u039f\u0393\u0399\u039f",
            "\u03a5\u03a0\u039f\u03a5\u03a1\u0393\u0395\u0399\u039f \u03a5\u0393\u0395\u0399\u0391\u03a3 \u039a\u0391\u0399 \u03a0\u03a1\u039f\u039d\u039f\u0399\u0391\u03a3",
            "\u0394\u0399\u0395\u0398\u039d\u0397\u03a3 \u039d\u0391\u03a5\u03a4\u0399\u039b\u0399\u0391\u039a\u039f\u03a3 \u039f\u03a1\u0393\u0391\u039d\u0399\u03a3\u039c\u039f\u03a3",
            "\u0394\u0399\u0395\u03a5\u0398\u03a5\u039d\u03a3\u0397 \u03a4\u0395\u039b\u03a9\u039d\u0395\u0399\u0391\u039a\u039f\u03a5 \u0395\u039b\u0395\u0393\u03a7\u039f\u03a5",
            "\u0394\u0395\u039b\u03a4\u0399\u0391 \u03a4\u0391\u03a5\u03a4\u039f\u03a4\u0397\u03a4\u039f\u03a3 \u03a0. \u039d\u0391\u03a5\u03a4\u0399\u039a\u039f\u03a5",
            "\u0391\u039d\u03a9\u03a4\u0391\u03a4\u0397 \u03a5\u0393\u0395\u0399\u039f\u039d\u039f\u039c\u0399\u039a\u0397 \u0395\u03a0\u0399\u03a4\u03a1\u039f\u03a0\u0397",
            "\u03a0\u03a1\u039f\u03a3\u03a4\u0391\u03a3\u0399\u0391 \u0395\u03a6\u0395\u0394\u03a1\u03a9\u039d \u0391\u039e\u0399\u03a9\u039c\u0391\u03a4\u0399\u039a\u03a9\u039d, \u0391\u039d\u0391\u03a0\u0397\u03a1\u03a9\u039d \u03a0\u039f\u039b\u0395\u039c\u039f\u03a5 \u039a\u0391\u0399 \u0391\u0393\u03a9\u039d\u0399\u03a3\u03a4\u03a9\u039d \u0395\u0398\u039d. \u0391\u039d\u03a4\u0399\u03a3\u03a4\u0391\u03a3\u0397\u03a3",
            "\u03a6\u039f\u03a1\u039f\u0399 \u03a5\u03a0\u0395\u03a1 \u03a4\u03a1\u0399\u03a4\u03a9\u039d",
            "\u0391\u0393\u03a1\u039f\u039b\u0397\u03a8\u0399\u0395\u03a3 \u0399\u039f\u039d\u0399\u03a9\u039d \u039d\u0397\u03a3\u0399\u03a9\u039d",
            "\u03a4\u0391\u039c\u0395\u0399\u039f \u0395\u03a0\u0399\u039a\u039f\u03a5\u03a1\u0399\u039a\u0397\u03a3 \u0391\u03a3\u03a6\u0391\u039b\u0399\u03a3\u0395\u03a9\u03a3 \u03a5\u03a0\u0391\u039b\u039b\u0397\u039b\u03a9\u039d \u0395\u039c\u03a0\u039f\u03a1\u0399\u039f\u03a5 \u03a4\u03a1\u039f\u03a6\u0399\u039c\u03a9\u039d (\u03a4.\u0395.\u0391.\u03a5.\u0395.\u03a4)",
            "\u0391\u039d\u03a9\u03a4\u0391\u03a4\u039f \u0395\u0399\u0394\u0399\u039a\u039f \u0394\u0399\u039a\u0391\u03a3\u03a4\u0397\u03a1\u0399\u039f",
            "\u0395\u0399\u03a3\u0391\u0393\u03a9\u0393\u0397 \u0393\u03a5\u039d\u0391\u0399\u039a\u03a9\u039d \u03a3\u03a4\u0399\u03a3 \u0391\u039d\u03a9\u03a4\u0391\u03a4\u0395\u03a3 \u03a3\u03a4\u03a1\u0391\u03a4\u0399\u03a9\u03a4\u0399\u039a\u0395\u03a3 \u03a3\u03a7\u039f\u039b\u0395\u03a3",
            "\u03a3\u03a7\u039f\u039b\u0397 \u0391\u039e\u0399\u03a9\u039c\u0391\u03a4\u0399\u039a\u03a9\u039d \u039d\u039f\u03a3\u0397\u039b\u0395\u03a5\u03a4\u0399\u039a\u0397\u03a3 (\u03a3.\u0391.\u039d.)",
            "\u0394\u0399\u0391\u0394\u0399\u039a\u0391\u03a3\u0399\u0391 \u0394\u0399\u039f\u0399\u039a\u0397\u03a4\u0399\u039a\u03a9\u039d \u0394\u0399\u039a\u0391\u03a3\u03a4\u0397\u03a1\u0399\u03a9\u039d",
            "\u03a0\u03a1\u039f\u03a3\u03a4\u0391\u03a3\u0399\u0391 \u0395\u03a1\u0393\u0391\u0396\u039f\u039c\u0395\u039d\u039f\u03a5 \u03a0\u0391\u0399\u0394\u0399\u039f\u03a5",
            "\u0391\u039c\u039d\u0397\u03a3\u03a4\u0399\u0391",
            "\u03a3\u03a7\u039f\u039b\u0395\u03a3 \u039a\u0391\u039b\u039b\u0399\u03a4\u0395\u03a7\u039d\u0399\u039a\u0397\u03a3 \u0395\u039a\u03a0\u0391\u0399\u0394\u0395\u03a5\u03a3\u0397\u03a3",
            "\u03a7\u0391\u03a1\u0397 \u039a\u0391\u0399 \u039c\u0395\u03a4\u03a1\u0399\u0391\u03a3\u039c\u039f\u03a3",
            "\u03a4\u03a5\u03a6\u039b\u039f\u0399",
            "\u03a3\u03a5\u039c\u0392\u039f\u03a5\u039b\u0399\u039f \u03a4\u0397\u03a3 \u0395\u03a5\u03a1\u03a9\u03a0\u0397\u03a3",
            "\u0395\u03a1\u0393\u039f\u03a3\u03a4\u0391\u03a3\u0399\u0391 \u0395\u039a\u03a1\u0397\u039a\u03a4\u0399\u039a\u03a9\u039d \u03a5\u039b\u03a9\u039d",
            "\u039c\u0397\u03a4\u03a1\u03a9\u0391 \u03a0. \u039d\u0391\u03a5\u03a4\u0399\u039a\u039f\u03a5",
            "\u03a5\u0393\u03a1\u0397 \u0391\u039c\u039c\u03a9\u039d\u0399\u0391",
            "\u03a0\u0395\u0399\u03a1\u0391\u039c\u0391\u03a4\u0399\u039a\u0391 \u03a3\u03a7\u039f\u039b\u0395\u0399\u0391",
            "\u03a4\u0391\u039c\u0395\u0399\u039f \u03a0\u03a1\u039f\u039d\u039f\u0399\u0391\u03a3 \u0391\u039e\u0399\u03a9\u039c\u0391\u03a4\u0399\u039a\u03a9\u039d \u0395.\u039d",
            "\u0395\u03a0\u0391\u0393\u0393\u0395\u039b\u039c\u0391\u03a4\u0399\u039a\u039f\u03a3 \u03a0\u03a1\u039f\u03a3\u0391\u039d\u0391\u03a4\u039f\u039b\u0399\u03a3\u039c\u039f\u03a3 \u039a\u0391\u0399 \u039a\u0391\u03a4\u0391\u03a1\u03a4\u0399\u03a3\u0397",
            "\u03a4\u0395\u039b\u03a9\u039d\u0395\u0399\u0391\u039a\u0397 \u0395\u03a0\u0399\u0392\u039b\u0395\u03a8\u0397",
            "\u03a0\u03a1\u039f\u03a3\u03a9\u03a1\u0399\u039d\u0395\u03a3 \u0395\u03a5\u03a1\u03a9\u03a0\u0391\u0399\u039a\u0395\u03a3 \u03a3\u03a5\u039c\u03a6\u03a9\u039d\u0399\u0395\u03a3",
            "\u039c\u039f\u039d\u039f\u03a0\u03a9\u039b\u0399\u039f \u03a0\u0391\u0399\u0393\u039d\u0399\u039f\u03a7\u0391\u03a1\u03a4\u03a9\u039d",
            "\u039b\u0395\u0399\u03a4\u039f\u03a5\u03a1\u0393\u0399\u0391 \u03a4\u039f\u03a5\u03a1\u0399\u03a3\u03a4\u0399\u039a\u0397\u03a3 \u0391\u03a3\u03a4\u03a5\u039d\u039f\u039c\u0399\u0391\u03a3",
            "\u0395\u039a\u03a0\u039f\u0399\u0397\u03a3\u0397 \u0395\u039a\u039a\u039b\u0397\u03a3\u0399\u0391\u03a3\u03a4\u0399\u039a\u03a9\u039d \u039a\u0399\u039d\u0397\u03a4\u03a9\u039d \u039a\u0391\u0399 \u0391\u039a\u0399\u039d\u0397\u03a4\u03a9\u039d",
            "\u03a3\u03a5\u039b\u039b\u039f\u0393\u0399\u039a\u0395\u03a3 \u03a3\u03a5\u039c\u0392\u0391\u03a3\u0395\u0399\u03a3 (\u0393\u0395\u039d\u0399\u039a\u0391)",
            "\u039f\u0394\u039f\u0399\u03a0\u039f\u03a1\u0399\u039a\u0391 \u039a\u0391\u0399 \u0391\u03a0\u039f\u0396\u0397\u039c\u0399\u03a9\u03a3\u0395\u0399\u03a3 \u0395\u039a\u03a4\u039f\u03a3 \u0395\u0394\u03a1\u0391\u03a3",
            "\u03a3\u03a4\u0395\u0393\u0391\u03a3\u03a4\u0399\u039a\u0397 \u0391\u03a0\u039f\u039a\u0391\u03a4\u0391\u03a3\u03a4\u0391\u03a3\u0397 \u03a0\u03a1\u039f\u03a3\u03a6\u03a5\u0393\u03a9\u039d",
            "\u0391\u039d\u03a9\u03a4\u0391\u03a4\u0391 \u03a3\u03a5\u039c\u0392\u039f\u03a5\u039b\u0399\u0391 \u0395\u039a\u03a0\u0391\u0399\u0394\u0395\u03a5\u03a3\u0395\u03a9\u03a3",
            "\u0391\u03a1\u03a7\u0395\u0399\u0391 \u03a5\u03a0\u039f\u03a5\u03a1\u0393\u0395\u0399\u039f\u03a5 \u039f\u0399\u039a\u039f\u039d\u039f\u039c\u0399\u039a\u03a9\u039d",
            "\u0393\u0395\u039d\u0399\u039a\u0397 \u0393\u03a1\u0391\u039c\u039c\u0391\u03a4\u0395\u0399\u0391 \u03a5\u03a0\u039f\u03a5\u03a1\u0393\u0399\u039a\u039f\u03a5 \u03a3\u03a5\u039c\u0392\u039f\u03a5\u039b\u0399\u039f\u03a5",
            "\u03a0\u0395\u03a1\u0399\u03a0\u03a4\u0395\u03a1\u0391 \u0391\u039d\u0391\u03a0\u0397\u03a1\u03a9\u039d \u03a0\u039f\u039b\u0395\u039c\u039f\u03a5",
            "\u0395\u03a0\u0391\u0393\u0393\u0395\u039b\u039c\u0391\u03a4\u0399\u039a\u0395\u03a3 \u039f\u03a1\u0393\u0391\u039d\u03a9\u03a3\u0395\u0399\u03a3 \u0395\u039c\u03a0\u039f\u03a1\u03a9\u039d, \u0392\u0399\u039f\u03a4\u0395\u03a7\u039d\u03a9\u039d \u039a\u0391\u0399 \u039b\u039f\u0399\u03a0\u03a9\u039d \u0395\u03a0\u0391\u0393\u0393\u0395\u039b\u039c\u0391\u03a4\u0399\u03a9\u039d",
            "\u0399\u0394\u0399\u03a9\u03a4\u0399\u039a\u039f\u0399 \u03a3\u03a4\u0391\u0398\u039c\u039f\u0399 \u03a0\u0391\u03a1\u0391\u0393\u03a9\u0393\u0397\u03a3 \u0397\u039b\u0395\u039a\u03a4\u03a1\u0399\u039a\u0397\u03a3 \u0395\u039d\u0395\u03a1\u0393\u0395\u0399\u0391\u03a3",
            "\u0398\u0395\u0391\u03a4\u03a1\u0399\u039a\u0391 \u0395\u03a1\u0393\u0391",
            "\u039c\u0395 \u03a4\u0397 \u039d\u0395\u0391 \u0396\u0397\u039b\u0391\u039d\u0394\u0399\u0391",
            "\u03a6\u039f\u03a1\u039f\u03a3 \u039a\u0391\u03a4\u0391\u039d\u0391\u039b\u03a9\u03a3\u0395\u03a9\u03a3 \u03a3\u0391\u039a\u03a7\u0391\u03a1\u0395\u03a9\u03a3",
            "\u039d\u039f\u039c\u0391\u03a1\u03a7\u0399\u0391\u039a\u0391 \u03a4\u0391\u039c\u0395\u0399\u0391",
            "\u0391\u0393\u03a9\u0393\u0395\u03a3 \u039a\u0391\u039a\u039f\u0394\u0399\u039a\u0399\u0391\u03a3",
            "\u039a\u03a9\u0394\u0399\u039a\u0391\u03a3 \u03a6\u039f\u03a1\u039f\u039b\u039f\u0393\u0399\u039a\u0397\u03a3 \u0394\u0399\u039a\u039f\u039d\u039f\u039c\u0399\u0391\u03a3",
            "\u0391\u03a4\u039f\u039c\u0391 \u0392\u0391\u03a1\u0399\u0391 \u039d\u039f\u0397\u03a4\u0399\u039a\u0391 \u039a\u0391\u0398\u03a5\u03a3\u03a4\u0395\u03a1\u0397\u039c\u0395\u039d\u0391",
            "\u039c\u0395 \u03a4\u0397 \u03a3\u039f\u03a5\u0397\u0394\u0399\u0391",
            "\u0391\u0395\u03a1\u039f\u039d\u0391\u03a5\u03a4\u0399\u039a\u0397 \u039c\u0395\u03a4\u0395\u03a9\u03a1\u039f\u039b\u039f\u0393\u0399\u0391",
            "\u0399\u0394\u0399\u03a9\u03a4\u0399\u039a\u0395\u03a3 \u03a3\u03a7\u039f\u039b\u0395\u03a3 \u0393\u03a5\u039c\u039d\u0391\u03a3\u03a4\u0399\u039a\u0397\u03a3",
            "\u03a0\u0395\u03a1\u0399\u039f\u03a5\u03a3\u0399\u0391 \u0394\u0397\u039c\u03a9\u039d \u039a\u0391\u0399 \u039a\u039f\u0399\u039d\u039f\u03a4\u0397\u03a4\u03a9\u039d",
            "\u0391\u0393\u039f\u03a1\u0391\u03a0\u03a9\u039b\u0397\u03a3\u0399\u0395\u03a3 \u039a\u0391\u03a4\u039f\u03a7\u0397\u03a3",
            "\u0395\u039a\u039a\u039b\u0397\u03a3\u0399\u0391 \u03a0\u0391\u03a1\u0399\u03a3\u0399\u03a9\u039d",
            "\u0394\u0399\u0395\u0398\u039d\u0395\u0399\u03a3 \u03a3\u03a5\u039c\u0392\u0391\u03a3\u0395\u0399\u03a3 \u03a0\u03a1\u039f\u03a3\u03a4\u0391\u03a3\u0399\u0391\u03a3 \u03a6\u03a5\u03a4\u03a9\u039d",
            "\u039a\u0391\u03a4\u039f\u03a7\u03a5\u03a1\u03a9\u03a3\u0397 \u0398\u03a1\u0397\u03a3\u039a\u0395\u03a5\u03a4\u0399\u039a\u0397\u03a3 \u0395\u039b\u0395\u03a5\u0398\u0395\u03a1\u0399\u0391\u03a3",
            "\u03a5\u0393\u0395\u0399\u039f\u039d\u039f\u039c\u0399\u039a\u0397 \u0395\u039e\u0395\u03a4\u0391\u03a3\u0397 \u039c\u0397 \u0399\u03a0\u03a4\u0391\u039c\u0395\u039d\u039f\u03a5 \u03a0\u03a1\u039f\u03a3\u03a9\u03a0\u0399\u039a\u039f\u03a5",
            "\u03a3\u03a5\u039d\u03a4\u0391\u039e\u0395\u0399\u03a3 \u0398\u03a5\u039c\u0391\u03a4\u03a9\u039d \u03a0\u039f\u039b\u0395\u039c\u039f\u03a5 1940",
            "\u03a5\u0394\u03a1\u0391\u03a5\u039b\u0399\u039a\u0395\u03a3 \u0395\u0393\u039a\u0391\u03a4\u0391\u03a3\u03a4\u0391\u03a3\u0395\u0399\u03a3",
            "\u039a\u039f\u0399\u039d\u03a9\u039d\u0399\u039a\u039f\u0399 \u039b\u0395\u0399\u03a4\u039f\u03a5\u03a1\u0393\u039f\u0399 - \u039a\u039f\u0399\u039d\u03a9\u039d\u0399\u039a\u039f\u0399 \u03a3\u03a5\u039c\u0392\u039f\u03a5\u039b\u039f\u0399",
            "\u0394\u0399\u0391\u03a6\u039f\u03a1\u0395\u03a3 \u03a0\u03a1\u039f\u03a3\u03a9\u03a1\u0399\u039d\u0395\u03a3 \u0391\u03a4\u0395\u039b\u0395\u0399\u0395\u03a3",
            "\u039f\u0399\u039a\u039f\u039d\u039f\u039c\u0399\u039a\u0397 \u0394\u0399\u0391\u03a7\u0395\u0399\u03a1\u0399\u03a3\u0397 \u039a\u0391\u0399 \u039b\u039f\u0393\u0399\u03a3\u03a4\u0399\u039a\u039f",
            "\u0395\u039e\u0397\u039b\u0395\u039a\u03a4\u03a1\u0399\u03a3\u039c\u039f\u03a3 \u039d\u0397\u03a3\u03a9\u039d",
            "\u0395\u039a\u03a0\u0391\u0399\u0394\u0395\u03a5\u03a3\u0397 \u03a3\u03a4\u0395\u039b\u0395\u03a7\u03a9\u039d",
            "\u03a9\u03a1\u0395\u03a3 \u0395\u03a1\u0393\u0391\u03a3\u0399\u0391\u03a3 \u039a\u0391\u03a4\u0391\u03a3\u03a4\u0397\u039c\u0391\u03a4\u03a9\u039d \u039a\u0391\u0399 \u0393\u03a1\u0391\u03a6\u0395\u0399\u03a9\u039d",
            "\u0397\u039c\u0395\u03a1\u039f\u039b\u039f\u0393\u0399\u039f \u0393\u0395\u03a6\u03a5\u03a1\u0391\u03a3",
            "\u03a0\u03a1\u039f\u03a3\u03a4\u0391\u03a3\u0399\u0391 \u03a4\u0397\u03a3 \u03a3\u03a4\u0391\u03a6\u0399\u0394\u0391\u03a3",
            "\u03a0\u0391\u039b\u0391\u0399\u039f\u0399 \u0394\u0399\u039a\u039f\u039d\u039f\u039c\u0399\u039a\u039f\u0399 \u039d\u039f\u039c\u039f\u0399",
            "\u03a4\u0391\u039c\u0395\u0399\u039f \u0395\u03a0\u0399\u039a. \u0391\u03a3\u03a6\u0391\u039b\u0399\u03a3\u0395\u03a9\u03a3 \u03a0\u03a1\u039f\u03a3\u03a9\u03a0\u0399\u039a\u039f\u03a5 \u039f\u03a1\u0393\u0391\u039d\u0399\u03a3\u039c\u03a9\u039d \u039a\u039f\u0399\u039d\u03a9\u039d\u0399\u039a\u0397\u03a3 \u0391\u03a3\u03a6\u0391\u039b\u0399\u03a3\u0395\u03a9\u03a3 (\u03a4.\u0395.\u0391.\u03a0.\u039f.\u039a.\u0391.)",
            "\u03a0\u0391\u03a1\u039f\u03a7\u0395\u03a3 \u03a5\u0393\u0395\u0399\u0391\u03a3 \u0391\u03a3\u03a6\u0391\u039b\u0399\u03a3\u03a4\u0399\u039a\u03a9\u039d \u039f\u03a1\u0393\u0391\u039d\u0399\u03a3\u039c\u03a9\u039d",
            "\u03a0\u039b\u0391\u039d\u039f\u0394\u0399\u039f\u0399 \u0399\u03a7\u0398\u03a5\u039f\u03a0\u03a9\u039b\u0395\u03a3",
            "\u0394\u0399\u0391\u03a6\u039f\u03a1\u039f\u0399 \u039d\u039f\u039c\u039f\u0399 \u03a0\u0395\u03a1\u0399 \u0391\u039e\u0399\u03a9\u039c\u0391\u03a4\u0399\u039a\u03a9\u039d \u03a0.\u039d",
            "\u03a5\u03a0\u039f\u03a7\u03a1\u0395\u03a9\u03a3\u0395\u0399\u03a3 \u0395\u03a6\u039f\u03a0\u039b\u0399\u03a3\u03a4\u03a9\u039d \u03a3\u0395 \u0391\u03a3\u0398\u0395\u039d\u0395\u0399\u0391 \u0397 \u0398\u0391\u039d\u0391\u03a4\u039f \u039d\u0391\u03a5\u03a4\u0399\u039a\u03a9\u039d",
            "\u03a0\u03a1\u039f\u03a3\u03a4\u0391\u03a3\u0399\u0391 \u039a\u0391\u03a4\u0391 \u03a4\u0397\u03a3 \u0391\u03a3\u0398\u0395\u039d\u0395\u0399\u0391\u03a3",
            "\u0393\u0395\u039d\u0399\u039a\u0391 \u03a0\u0395\u03a1\u0399 \u03a3\u03a7\u0395\u0394\u0399\u03a9\u039d \u03a0\u039f\u039b\u0395\u03a9\u039d",
            "\u0395\u039e\u0391\u0399\u03a1\u0395\u03a3\u0395\u0399\u03a3 \u0391\u03a0\u039f \u03a4\u0397\u039d \u0395\u03a1\u0393\u0391\u03a4\u0399\u039a\u0397 \u039d\u039f\u039c\u039f\u0398\u0395\u03a3\u0399\u0391",
            "\u0391\u0393\u03a1\u039f\u03a4\u0399\u039a\u039f \u039a\u03a4\u0397\u039c\u0391\u03a4\u039f\u039b\u039f\u0393\u0399\u039f",
            "\u03a3\u03a5\u039d\u03a4\u0391\u0393\u039c\u0391\u03a4\u0399\u039a\u0395\u03a3 \u0394\u0399\u0391\u03a4\u0391\u039e\u0395\u0399\u03a3 \u0395\u039a\u039a\u039b\u0397\u03a3\u0399\u0391\u03a3 \u03a4\u0397\u03a3 \u0395\u039b\u039b\u0391\u0394\u039f\u03a3",
            "\u03a0\u0391\u039d\u0391\u0393\u0399\u039f\u03a3 \u03a4\u0391\u03a6\u039f\u03a3",
            "\u03a3\u03a5\u039d\u0395\u03a1\u0393\u0395\u0399\u0391 \u03a0. \u039d\u0391\u03a5\u03a4\u0399\u039a\u039f\u03a5",
            "\u0395\u03a0\u0399\u0398\u0395\u03a9\u03a1\u0397\u03a3\u0399\u03a3 \u03a3\u03a4\u03a1\u0391\u03a4\u039f\u03a5",
            "\u03a3\u03a5\u039d\u0398\u0395\u03a3\u0397 \u03a0\u039b\u0397\u03a1\u03a9\u039c\u0391\u03a4\u03a9\u039d",
            "\u039f\u03a1\u0393\u0391\u039d\u0399\u03a3\u039c\u039f\u03a3 \u0395\u03a1\u0393\u0391\u03a4\u0399\u039a\u0397\u03a3 \u0395\u03a3\u03a4\u0399\u0391\u03a3",
            "\u0394\u0399\u0391\u03a6\u039f\u03a1\u0391 \u03a5\u0394\u03a1\u0391\u03a5\u039b\u0399\u039a\u0391 \u0395\u03a1\u0393\u0391",
            "\u0394\u0399\u039a\u0391\u0399\u03a9\u039c\u0391 \u03a4\u039f\u03a5 \u03a3\u03a5\u039d\u0395\u03a1\u03a7\u0395\u03a3\u0398\u0391\u0399",
            "\u039a\u039f\u0399\u039d\u03a9\u039d\u0399\u039a\u039f\u03a0\u039f\u0399\u0397\u03a3\u0397 - \u0391\u03a0\u039f\u039a\u03a1\u0391\u03a4\u0399\u039a\u039f\u03a0\u039f\u0399\u0397\u03a3\u0397 \u0395\u03a0\u0399\u03a7\u0395\u0399\u03a1\u0397\u03a3\u0395\u03a9\u039d \u0394\u0397\u039c\u039f\u03a3\u0399\u039f\u03a5 \u03a7\u0391\u03a1\u0391\u039a\u03a4\u0397\u03a1\u0391",
            "\u039b\u0391\u0399\u039a\u0397 \u039a\u0391\u03a4\u039f\u0399\u039a\u0399\u0391",
            "\u03a6\u039f\u03a1\u039f\u039b\u039f\u0393\u0399\u0391 \u039a\u0395\u03a1\u0394\u03a9\u039d",
            "\u03a4\u0395\u03a7\u039d\u0399\u039a\u0397 \u03a5\u03a0\u0397\u03a1\u0395\u03a3\u0399\u0391",
            "\u039c\u0395\u03a4\u0395\u039a\u03a0\u0391\u0399\u0394\u0395\u03a5\u03a3\u0397 \u0394\u0397\u039c\u039f\u0394\u0399\u0394\u0391\u03a3\u039a\u0391\u039b\u03a9\u039d",
            "\u03a3\u03a5\u039d\u03a4\u0391\u039e\u0395\u0399\u03a3 \u03a5\u03a0\u039f\u03a5\u03a1\u0393\u03a9\u039d \u039a\u0391\u0399 \u0392\u039f\u03a5\u039b\u0395\u03a5\u03a4\u03a9\u039d",
            "\u039f\u03a1\u0399\u039f \u0397\u039b\u0399\u039a\u0399\u0391\u03a3",
            "\u03a3\u03a4\u03a1\u0391\u03a4\u0399\u03a9\u03a4\u0399\u039a\u0395\u03a3 \u03a0\u03a1\u039f\u039c\u0397\u0398\u0395\u0399\u0395\u03a3",
            "\u0391\u03a0\u039f\u03a3\u03a4\u039f\u039b\u0391\u0399 \u0395\u039e\u03a9\u03a4\u0395\u03a1\u0399\u039a\u039f\u03a5",
            "\u03a6\u039f\u03a1\u039f\u039b\u039f\u0393\u0399\u0391 \u0391\u039a\u0399\u039d\u0397\u03a4\u0397\u03a3 \u03a0\u0395\u03a1\u0399\u039f\u03a5\u03a3\u0399\u0391\u03a3",
            "\u03a7\u03a1\u039f\u039d\u039f\u03a3 \u0395\u03a1\u0393\u0391\u03a3\u0399\u0391\u03a3 - \u0391\u0394\u0395\u0399\u0395\u03a3 \u03a0\u03a1\u039f\u03a3\u03a9\u03a0\u0399\u039a\u039f\u03a5 \u0395\u039b\u039b\u0397\u039d\u0399\u039a\u0397\u03a3 \u0391\u03a3\u03a4\u03a5\u039d\u039f\u039c\u0399\u0391\u03a3",
            "\u039d\u0391\u03a5\u03a4\u0399\u039a\u0391 \u0395\u03a1\u0393\u0391 \u039a\u0391\u0399 \u03a0\u03a1\u039f\u039c\u0397\u0398\u0395\u0399\u0395\u03a3",
            "\u039f\u0399\u039a\u039f\u039d\u039f\u039c\u0399\u039a\u0397 \u0394\u0399\u039f\u0399\u039a\u0397\u03a3\u0397 \u039a\u0391\u0399 \u039b\u039f\u0393\u0399\u03a3\u03a4\u0399\u039a\u039f",
            "\u0394\u0391\u03a3\u039c\u039f\u039b\u039f\u0393\u0399\u039a\u0395\u03a3 \u03a3\u03a5\u039c\u0392\u0391\u03a3\u0395\u0399\u03a3",
            "\u03a4\u0391\u039c\u0395\u0399\u039f \u0391\u03a3\u03a6\u0391\u039b\u0399\u03a3\u0395\u03a9\u03a3 \u03a7\u03a1\u0397\u039c\u0391\u03a4\u0399\u03a3\u03a4\u03a9\u039d ,\u039c\u0395\u03a3\u0399\u03a4\u03a9\u039d,\u0391\u039d\u03a4\u0399\u039a\u03a1\u03a5\u03a3\u03a4\u03a9\u039d \u039a\u0391\u0399 \u03a5\u03a0\u0391\u039b\u039b\u0397\u039b\u03a9\u039d \u03a7\u03a1\u0397\u039c\u0391\u03a4\u0399\u03a3\u03a4\u0397\u03a1\u0399\u039f\u03a5 \u0391\u0398\u0397\u039d\u03a9\u039d (\u03a4.\u0391.\u03a7.\u039c.\u0391.)",
            "\u039a\u03a1\u0391\u03a4\u0399\u039a\u0397 \u03a3\u03a7\u039f\u039b\u0397 \u039f\u03a1\u03a7\u0397\u03a3\u03a4\u0399\u039a\u0397\u03a3 \u03a4\u0395\u03a7\u039d\u0397\u03a3",
            "\u0395\u0398\u039d\u0399\u039a\u0397 \u039b\u03a5\u03a1\u0399\u039a\u0397 \u03a3\u039a\u0397\u039d\u0397",
            "\u0391\u0395\u03a1\u039f\u039d\u0391\u03a5\u03a4\u0399\u039a\u0395\u03a3 \u03a4\u0397\u039b\u0395\u03a0\u0399\u039a\u039f\u0399\u039d\u03a9\u039d\u0399\u0395\u03a3",
            "\u039a\u0395\u039d\u03a4\u03a1\u039f \u0392\u0399\u039f\u03a4\u0395\u03a7\u039d\u0399\u039a\u0397\u03a3 \u0391\u039d\u0391\u03a0\u03a4\u03a5\u039e\u0397\u03a3",
            "\u0391\u03a1\u03a7\u0391\u0399\u039f\u039b\u039f\u0393\u0399\u039a\u039f \u039c\u039f\u03a5\u03a3\u0395\u0399\u039f",
            "\u03a5\u03a0\u0395\u03a1\u03a9\u039a\u0395\u0391\u039d\u0395\u0399\u0391",
            "\u0394\u0391\u03a3\u0397",
            "\u0391\u03a3\u039a\u0397\u03a3\u0397 \u039a\u03a4\u0397\u039d\u0399\u0391\u03a4\u03a1\u0399\u039a\u039f\u03a5 \u0395\u03a0\u0391\u0393\u0393\u0395\u039b\u039c\u0391\u03a4\u039f\u03a3",
            "\u039a\u03a4\u0397\u03a3\u0397 \u039a\u0391\u0399 \u0391\u03a0\u03a9\u039b\u0395\u0399\u0391",
            "\u03a1\u0391\u0394\u0399\u039f\u03a4\u0397\u039b\u0395\u0393\u03a1\u0391\u03a6\u0399\u039a\u0397 \u03a5\u03a0\u0397\u03a1\u0395\u03a3\u0399\u0391",
            "\u0391\u0395\u03a1\u039f\u039b\u0399\u039c\u0395\u039d\u0391\u03a3 \u0391\u0398\u0397\u039d\u03a9\u039d",
            "\u03a0\u03a1\u03a9\u03a4\u039f\u0392\u0391\u0398\u039c\u0399\u0391 \u0395\u039a\u03a0\u0391\u0399\u0394\u0395\u03a5\u03a3\u0397",
            "\u03a3\u03a4\u0395\u039b\u0395\u03a7\u039f\u03a3 \u0395\u03a6\u0395\u0394\u03a1\u03a9\u039d \u0391\u039e\u0399\u03a9\u039c\u0391\u03a4\u0399\u039a\u03a9\u039d",
            "\u03a0\u03a4\u03a9\u03a7\u0395\u03a5\u03a3\u0397 \u039a\u0391\u0399 \u03a3\u03a5\u039c\u0392\u0399\u0392\u0391\u03a3\u039c\u039f\u03a3",
            "\u03a0\u039f\u039b\u0399\u03a4\u0399\u039a\u039f\u03a3 \u0393\u0391\u039c\u039f\u03a3",
            "\u0399\u0394\u0399\u03a9\u03a4\u0399\u039a\u0397 \u0395\u03a0\u0399\u03a7\u0395\u0399\u03a1\u0397\u03a3\u0397 \u0391\u03a3\u03a6\u0391\u039b\u0399\u03a3\u0395\u03a9\u03a3",
            "\u03a0\u039b\u039f\u0399\u0391 \u03a0\u039f\u039b\u0395\u039c\u0399\u039a\u039f\u03a5 \u039d\u0391\u03a5\u03a4\u0399\u039a\u039f\u03a5",
            "\u0399\u0391\u03a4\u03a1\u0399\u039a\u0395\u03a3 \u0391\u039c\u039f\u0399\u0392\u0395\u03a3",
            "\u0395\u039b\u039b\u0397\u039d\u0399\u039a\u039f\u03a3 \u0395\u03a1\u03a5\u0398\u03a1\u039f\u03a3 \u03a3\u03a4\u0391\u03a5\u03a1\u039f\u03a3",
            "\u0391\u039d\u03a9\u039c\u0391\u039b\u0395\u03a3 \u039a\u0391\u03a4\u0391\u0398\u0395\u03a3\u0395\u0399\u03a3 \u03a3\u0395 \u03a7\u03a1\u03a5\u03a3\u039f",
            "\u03a3\u03a5\u039c\u0392\u039f\u03a5\u039b\u0399\u039f \u03a4\u0399\u039c\u0397\u03a3 \u0391\u039e\u0399\u03a9\u039c\u0391\u03a4\u0399\u039a\u03a9\u039d \u03a0.\u039d",
            "\u0394\u0399\u0391\u03a6\u039f\u03a1\u039f\u0399 \u0391\u03a1\u0394\u0395\u03a5\u03a4\u0399\u039a\u039f\u0399 \u039d\u039f\u039c\u039f\u0399",
            "\u039a\u03a5\u0392\u0395\u03a1\u039d\u0397\u03a4\u0399\u039a\u039f\u03a3 \u0395\u03a0\u0399\u03a4\u03a1\u039f\u03a0\u039f\u03a3",
            "\u0395\u039a\u03a4\u0395\u039b\u0395\u03a3\u0397 \u03a3\u03a5\u0393\u039a\u039f\u0399\u039d\u03a9\u039d\u0399\u0391\u039a\u03a9\u039d \u0395\u03a1\u0393\u03a9\u039d",
            "\u03a4\u0391\u039c\u0395\u0399\u039f \u03a3\u03a5\u039d\u03a4\u0391\u039e\u0395\u03a9\u039d \u039a\u0391\u0399 \u0391\u03a1\u03a9\u0393\u0397\u03a3",
            "\u0394\u0391\u03a3\u0399\u039a\u0395\u03a3 \u039c\u0395\u03a4\u0391\u03a6\u039f\u03a1\u0395\u03a3",
            "\u039c\u0395 \u03a4\u0397 \u0394\u0397\u039c\u039f\u039a\u03a1\u0391\u03a4\u0399\u0391 \u03a4\u039f\u03a5 \u039a\u0395\u039c\u03a0\u0395\u039a",
            "\u0395\u03a0\u0391\u039d\u0395\u039e\u0391\u0393\u039f\u039c\u0395\u039d\u0391 \u039c\u0395 \u0395\u0393\u0393\u03a5\u0397\u03a3\u0397",
            "\u0394\u0399\u0391\u039d\u039f\u039c\u0397 \u0397\u039b\u0395\u039a\u03a4\u03a1\u0399\u039a\u0397\u03a3 \u0395\u039d\u0395\u03a1\u0393\u0395\u0399\u0391\u03a3",
            "\u0391\u03a1\u03a3\u0397 \u03a3\u03a5\u0393\u039a\u03a1\u039f\u03a5\u03a3\u0395\u03a9\u03a3 \u039a\u0391\u0398\u0397\u039a\u039f\u039d\u03a4\u03a9\u039d",
            "\u0395\u039a\u03a0\u0391\u0399\u0394\u0395\u03a5\u03a4\u0399\u039a\u0391 \u03a0\u039b\u039f\u0399\u0391",
            "\u039a\u0395\u039d\u03a4\u03a1\u039f \u039c\u0395\u03a4\u0391\u03a6\u03a1\u0391\u03a3\u0397\u03a3",
            "\u0395\u0399\u03a3\u03a6\u039f\u03a1\u0395\u03a3 \u039a\u0391\u0399 \u039d\u0391\u03a5\u039b\u03a9\u03a3\u0395\u0399\u03a3",
            "\u039c\u0395\u03a4\u0395\u0393\u0393\u03a1\u0391\u03a6\u0395\u03a3 \u03a6\u039f\u0399\u03a4\u0397\u03a4\u03a9\u039d \u0391\u039d\u03a9\u03a4. \u0395\u039a\u03a0\u0391\u0399\u0394\u0395\u03a5\u03a4\u0399\u039a\u03a9\u039d \u0399\u0394\u03a1\u03a5\u039c\u0391\u03a4\u03a9\u039d",
            "\u03a4\u039c\u0397\u039c\u0391\u03a4\u0391 \u0395\u03a0\u0399\u03a3\u03a4\u0397\u039c\u0397\u03a3 \u03a6\u03a5\u03a3\u0399\u039a\u0397\u03a3 \u0391\u0393\u03a9\u0393\u0397\u03a3 - \u0391\u0398\u039b\u0397\u03a4\u0399\u03a3\u039c\u039f\u03a5",
            "\u03a8\u03a5\u03a7\u0399\u0391\u03a4\u03a1\u0395\u0399\u0391",
            "\u03a6\u039f\u03a1\u039f\u039b\u039f\u0393\u0399\u0391 \u039a\u0395\u03a6\u0391\u039b\u0391\u0399\u039f\u03a5 \u0391\u039d\u03a9\u039d. \u0395\u03a4\u0391\u0399\u03a1\u0395\u0399\u03a9\u039d",
            "\u03a4\u03a5\u03a0\u039f\u0399 \u03a3\u03a5\u039c\u0392\u039f\u039b\u0391\u0399\u03a9\u039d",
            "\u039a\u0391\u039d\u039f\u039d\u0399\u03a3\u039c\u039f\u03a3 \u0395\u03a0\u0399\u0398\u0395\u03a9\u03a1\u0397\u03a3\u0395\u03a9\u03a3",
            "\u039c\u039f\u03a5\u03a3\u0395\u0399\u039f \u0395\u039b\u039b\u0397\u039d\u0399\u039a\u0397\u03a3 \u039b\u0391\u0399\u039a\u0397\u03a3 \u03a4\u0395\u03a7\u039d\u0397\u03a3",
            "\u03a0\u0391\u039d\u0395\u03a0\u0399\u03a3\u03a4\u0397\u039c\u0399\u039f \u03a0\u0395\u039b\u039f\u03a0\u039f\u039d\u039d\u0397\u03a3\u039f\u03a5",
            "\u039f\u03a1\u0393\u0391\u039d\u0399\u03a3\u039c\u039f\u03a3 \u0395\u03a1\u0393\u0391\u03a4\u0399\u039a\u0397\u03a3 \u039a\u0391\u03a4\u039f\u0399\u039a\u0399\u0391\u03a3",
            "\u0391\u03a3\u03a6\u0391\u039b\u0395\u0399\u0391 \u0395\u03a1\u0393\u0391\u0396\u039f\u039c\u0395\u039d\u03a9\u039d \u03a3\u0395 \u039f\u0399\u039a\u039f\u0394\u039f\u039c\u0395\u03a3",
            "\u03a3\u03a4\u0395\u0393\u0391\u039d\u0397 \u03a5\u03a0\u039f\u0394\u0399\u0391\u0399\u03a1\u0395\u03a3\u0397 \u03a0\u039b\u039f\u0399\u03a9\u039d",
            "\u0394\u0399\u039f\u0399\u039a\u0397\u03a3\u0397 \u03a0\u03a1\u03a9\u03a4\u0395\u03a5\u039f\u03a5\u03a3\u0397\u03a3",
            "\u0394\u0399\u0394\u0391\u039a\u03a4\u039f\u03a1\u0399\u039a\u0395\u03a3 - \u039c\u0395\u03a4\u0391\u03a0\u03a4\u03a5\u03a7\u0399\u0391\u039a\u0395\u03a3 \u03a3\u03a0\u039f\u03a5\u0394\u0395\u03a3 \u0395\u0398\u039d\u0399\u039a\u039f\u03a5 \u039c\u0395\u03a4\u03a3\u039f\u0392\u0399\u039f\u03a5",
            "\u0395\u0399\u03a3\u03a6\u039f\u03a1\u0391 \u039a\u0391\u03a4\u039f\u03a7\u03a9\u039d \u0395\u0399\u0394\u03a9\u039d \u03a0\u03a1\u03a9\u03a4\u0397\u03a3 \u0391\u039d\u0391\u0393\u039a\u0397\u03a3",
            "\u0394\u0399\u0391\u03a6\u039f\u03a1\u039f\u0399 \u0394\u0399\u039a\u039f\u039d\u039f\u039c\u0399\u039a\u039f\u0399 \u039d\u039f\u039c\u039f\u0399",
            "\u0394\u0399\u0395\u0398\u039d\u0395\u0399\u03a3 \u039b\u0399\u039c\u0395\u039d\u0399\u039a\u0395\u03a3 \u03a3\u03a5\u039c\u0392\u0391\u03a3\u0395\u0399\u03a3",
            "\u03a5\u0393\u0395\u0399\u039f\u039d\u039f\u039c\u0399\u039a\u0397 \u03a5\u03a0\u0397\u03a1\u0395\u03a3\u0399\u0391 \u0395\u039b.\u0391\u03a3",
            "\u0395\u039b\u039b\u0397\u039d\u0399\u039a\u0391 \u03a4\u0391\u03a7\u03a5\u0394\u03a1\u039f\u039c\u0395\u0399\u0391 (\u0395\u039b.\u03a4\u0391)",
            "\u039c\u0399\u03a3\u0398\u039f\u0399 \u039a\u0391\u0399 \u0395\u03a0\u0399\u0394\u039f\u039c\u0391\u03a4\u0391 \u03a0. \u039d\u0391\u03a5\u03a4\u0399\u039a\u039f\u03a5",
            "\u0393\u0395\u03a9\u03a1\u0393\u0399\u039a\u0391 \u03a4\u0391\u039c\u0395\u0399\u0391",
            "\u0391\u03a4\u0395\u039b\u0395\u0399\u0395\u03a3 \u03a5\u03a0\u0395\u03a1 \u039c\u0395\u03a4\u0391\u039b\u039b\u0395\u03a5\u03a4\u0399\u039a\u03a9\u039d \u0395\u03a0\u0399\u03a7\u0395\u0399\u03a1\u0397\u03a3\u0395\u03a9\u039d",
            "\u0391\u03a0\u039f\u0392\u0391\u03a1\u039f",
            "\u03a4\u0391\u039c\u0395\u0399\u039f \u0395\u03a0\u0399\u039a\u039f\u03a5\u03a1\u0399\u039a\u0397\u03a3 \u0391\u03a3\u03a6\u0391\u039b\u0399\u03a3\u0395\u03a9\u03a3 \u0395\u039a\u03a0\u03a1\u039f\u03a3\u03a9\u03a0\u03a9\u039d \u039a\u0391\u0399 \u03a5\u03a0\u0391\u039b\u039b\u0397\u039b\u03a9\u039d",
            "\u039a\u03a9\u0394\u0399\u039a\u0391\u03a3 \u03a0\u0395\u03a1\u0399 \u0394\u0399\u039a\u0397\u0393\u039f\u03a1\u03a9\u039d",
            "\u0399\u0395\u03a1\u0391\u03a1\u03a7\u0399\u0391 \u039a\u0391\u0399 \u03a0\u03a1\u039f\u0392\u0399\u0392\u0391\u03a3\u039c\u039f\u0399",
            "\u0399\u03a3\u03a1\u0391\u0397\u039b\u0399\u03a4\u0395\u03a3",
            "\u03a3\u03a9\u039c\u0391 \u039a\u03a4\u0397\u039d\u0399\u0391\u03a4\u03a1\u0399\u039a\u039f",
            "\u039d\u039f\u03a1\u0392\u0397\u0393\u0399\u0391 - \u039d\u0395\u0391 \u0396\u0397\u039b\u0391\u039d\u0394\u0399\u0391 \u2013 \u039d\u0399\u0393\u0397\u03a1\u0399\u0391 \u039a.\u039b\u03a0",
            "\u0395\u039d\u03a4\u03a5\u03a0\u0391 \u039a\u0391\u0399 \u0392\u0399\u0392\u039b\u0399\u039f\u0398\u0397\u039a\u0395\u03a3 \u039d\u0391\u03a5\u03a4\u0399\u039a\u039f\u03a5",
            "\u03a5\u03a0\u039f\u03a5\u03a1\u0393\u0395\u0399\u039f \u03a4\u03a5\u03a0\u039f\u03a5 \u039a\u0391\u0399 \u039c\u0395\u03a3\u03a9\u039d \u039c\u0391\u0396\u0399\u039a\u0397\u03a3 \u0395\u039d\u0397\u039c\u0395\u03a1\u03a9\u03a3\u0397\u03a3",
            "\u039d\u0391\u03a5\u03a4\u0399\u039a\u0395\u03a3 \u03a0\u0395\u0399\u0398\u0391\u03a1\u03a7\u0399\u039a\u0395\u03a3 \u03a0\u039f\u0399\u039d\u0395\u03a3",
            "\u039c\u0399\u03a3\u0398\u03a9\u03a3\u0395\u0399\u03a3 \u0391\u0393\u03a1\u039f\u03a4\u0399\u039a\u03a9\u039d \u0391\u039a\u0399\u039d\u0397\u03a4\u03a9\u039d",
            "\u0394\u0399\u0391\u03a6\u039f\u03a1\u039f\u0399 \u03a3\u03a5\u039d\u0395\u03a4\u0391\u0399\u03a1\u0399\u03a3\u039c\u039f\u0399",
            "\u0391\u0393\u03a1\u039f\u03a4\u0399\u039a\u0397 \u03a0\u0399\u03a3\u03a4\u0397",
            "\u039b\u0391\u0399\u039a\u0395\u03a3 \u0391\u0393\u039f\u03a1\u0395\u03a3-\u03a4\u0391\u039c\u0395\u0399\u039f \u039b\u0391\u0399\u039a\u03a9\u039d \u0391\u0393\u039f\u03a1\u03a9\u039d",
            "\u039a\u0391\u039d\u039f\u039d\u0399\u03a3\u039c\u039f\u03a3 \u03a0\u0395\u0399\u0398\u0391\u03a1\u03a7\u0399\u0391\u03a3 \u03a7\u03a9\u03a1\u039f\u03a6\u03a5\u039b\u0391\u039a\u0397\u03a3",
            "\u0391\u0394\u0399\u039a\u0397\u039c\u0391\u03a4\u0391 \u039a\u0391\u03a4\u0391 \u03a4\u0397\u03a3 \u0394\u0397\u039c\u039f\u03a3\u0399\u0391\u03a3 \u0391\u03a3\u03a6\u0391\u039b\u0395\u0399\u0391\u03a3",
            "\u0395\u039d\u039f\u0399\u039a\u0399\u0391\u03a3\u0397 \u03a6\u039f\u03a1\u039f\u03a5 \u0394\u0397\u039c\u039f\u03a3\u0399\u03a9\u039d \u0398\u0395\u0391\u039c\u0391\u03a4\u03a9\u039d",
            "\u0395\u03a5\u03a1\u03a9\u03a0\u0391\u0399\u039a\u0397 \u03a3\u03a5\u039c\u0392\u0391\u03a3\u0397 \u039a\u039f\u0399\u039d\u03a9\u039d\u0399\u039a\u0397\u03a3 \u039a\u0391\u0399 \u0399\u0391\u03a4\u03a1\u0399\u039a\u0397\u03a3 \u0391\u039d\u03a4\u0399\u039b\u0397\u03a8\u0395\u03a9\u03a3",
            "\u0395\u03a0\u0399\u0392\u0391\u03a4\u0397\u0393\u0391 \u0391\u0395\u03a1\u039f\u03a3\u03a4\u03a1\u03a9\u039c\u039d\u0391 \u039f\u03a7\u0397\u039c\u0391\u03a4\u0391",
            "\u0395\u03a6\u0395\u0394\u03a1\u039f\u0399",
            "\u03a3\u03a4\u03a1\u0391\u03a4\u0399\u03a9\u03a4\u0399\u039a\u0395\u03a3 \u039b\u0395\u03a3\u03a7\u0395\u03a3",
            "\u03a0\u03a1\u039f\u03a3\u03a9\u03a0\u0399\u039a\u039f \u03a6\u03a5\u039b\u0391\u039a\u03a9\u039d",
            "\u0391\u039d\u0391\u0398\u0395\u03a9\u03a1\u0397\u03a3\u0397 \u03a4\u0399\u039c\u03a9\u039d",
            "\u039c\u0391\u039b\u0391\u039a\u0399\u0391 \u039a\u0391\u0399 \u039c\u0391\u039b\u0391\u039a\u039f\u03a3\u03a4\u03a1\u0391\u039a\u0391",
            "\u039a\u03a9\u0394\u0399\u039a\u0391\u03a3 \u0394\u0397\u039c\u039f\u03a3\u0399\u039f\u03a5 \u039d\u0391\u03a5\u03a4\u0399\u039a\u039f\u03a5 \u0394\u0399\u039a\u0391\u0399\u039f\u03a5",
            "\u0394\u0399\u0391\u03a6\u039f\u03a1\u0391 \u03a3\u03a9\u039c\u0391\u03a4\u0395\u0399\u0391",
            "\u0393\u0395\u039d\u0399\u039a\u0395\u03a3 \u0394\u0399\u0391\u03a4\u0391\u039e\u0395\u0399\u03a3",
            "\u039a\u03a9\u0394\u0399\u039a\u039f\u03a0\u039f\u0399\u0397\u03a3\u0397 \u0391\u0393\u039f\u03a1\u0391\u039d\u039f\u039c\u0399\u039a\u03a9\u039d \u0394\u0399\u0391\u03a4\u0391\u039e\u0395\u03a9\u039d",
            "\u0395\u039a\u03a0\u0391\u0399\u0394\u0395\u03a5\u03a3\u0397 \u03a3\u03a4\u0397\u039d \u0391\u039b\u039b\u039f\u0394\u0391\u03a0\u0397",
            "\u0394\u0399\u0394\u0391\u039a\u03a4\u0399\u039a\u0391 \u0392\u0399\u0392\u039b\u0399\u0391",
            "\u03a3\u03a5\u039d\u03a4\u0391\u039e\u0399\u039f\u0394\u039f\u03a4\u0399\u039a\u0391 \u039a\u0391\u0399 \u0391\u03a3\u03a6\u0391\u039b\u0399\u03a3\u03a4\u0399\u039a\u0391 \u0398\u0395\u039c\u0391\u03a4\u0391 \u03a0\u03a1\u039f\u03a3\u03a9\u03a0\u0399\u039a\u039f\u03a5 \u039d.\u03a0.\u0394.\u0394",
            "\u0395\u03a0\u0399\u0394\u039f\u039c\u0391 \u039f\u0399\u039a\u039f\u0393\u0395\u039d\u0395\u0399\u03a9\u039d \u03a3\u03a4\u03a1\u0391\u03a4\u0399\u03a9\u03a4\u0399\u039a\u03a9\u039d \u0395\u039e\u0391\u03a6\u0391\u039d\u0399\u03a3\u0398\u0395\u039d\u03a4\u03a9\u039d \u039a\u0391\u0399 \u0391\u0399\u03a7\u039c\u0391\u039b\u03a9\u03a4\u03a9\u039d",
            "\u0394\u0399\u0395\u0398\u039d\u0395\u0399\u03a3 \u03a3\u03a5\u039c\u0392\u0391\u03a3\u0395\u0399\u03a3",
            "\u039a\u0395\u039d\u03a4\u03a1\u039f \u0394\u0399\u03a0\u039b\u03a9\u039c\u0391\u03a4\u0399\u039a\u03a9\u039d \u03a3\u03a0\u039f\u03a5\u0394\u03a9\u039d",
            "\u0393\u0395\u039d. \u0394\u0399\u0395\u03a5\u0398\u03a5\u039d\u03a3\u0397 \u03a4\u03a5\u03a0\u039f\u03a5 \u039a\u0391\u0399 \u03a0\u039b\u0397\u03a1\u039f\u03a6\u039f\u03a1\u0399\u03a9\u039d",
            "\u0391\u03a1\u03a7\u0395\u0399\u0391 \u03a4\u0395\u039b\u03a9\u039d\u0395\u0399\u0391\u039a\u03a9\u039d \u0391\u03a1\u03a7\u03a9\u039d",
            "\u0395\u0399\u0394\u0399\u039a\u0395\u03a3 \u03a4\u0399\u039c\u0395\u03a3 \u039a\u0391\u03a5\u03a3\u0399\u039c\u03a9\u039d",
            "\u03a3\u03a4\u0395\u0393\u0397 \u03a5\u0393\u0395\u0399\u039f\u039d\u039f\u039c\u0399\u039a\u03a9\u039d",
            "\u0393\u0395\u039d\u0399\u039a\u0391 \u03a0\u0395\u03a1\u0399 \u03a3\u03a5\u039c\u0392\u039f\u039b\u0391\u0399\u039f\u0393\u03a1\u0391\u03a6\u03a9\u039d",
            "\u0392\u039f\u03a5\u039b\u0397",
            "\u0395\u03a0\u0399\u039b\u039f\u0393\u0397 & \u0391\u039e\u0399\u039f\u039b\u039f\u0393\u0397\u03a3\u0397 \u0391\u03a3\u03a4\u03a5\u039d\u039f\u039c\u0399\u039a\u039f\u03a5 \u03a0\u03a1\u039f\u03a3\u03a9\u03a0\u0399\u039a\u039f\u03a5 \u0395\u039b.\u0391\u03a3",
            "\u03a7\u039f\u0399\u03a1\u039f\u03a4\u03a1\u039f\u03a6\u0399\u0391",
            "\u03a6\u039f\u03a1\u039f\u03a3 \u039a\u0391\u03a4\u0391\u039d\u0391\u039b\u03a9\u03a3\u0395\u03a9\u03a3 \u03a0\u0395\u03a4\u03a1\u0395\u039b\u0391\u0399\u039f\u0395\u0399\u0394\u03a9\u039d",
            "\u0395\u03a0\u0399\u0392\u039f\u039b\u0397 \u03a4\u0395\u039b\u03a9\u039d\u0399\u0391\u039a\u03a9\u039d \u0394\u0391\u03a3\u039c\u03a9\u039d",
            "\u0391\u0395\u03a1\u039f\u03a0\u039f\u03a1\u0399\u039a\u0397 \u03a3\u03a4\u03a1\u0391\u03a4\u039f\u039b\u039f\u0393\u0399\u0391",
            "\u0394\u0399\u0395\u0398\u039d\u0395\u0399\u03a3 \u03a3\u03a5\u039c\u0392\u0391\u03a3\u0395\u0399\u03a3 \u0393\u0399\u0391 \u03a4\u0391 \u039d\u0391\u03a1\u039a\u03a9\u03a4\u0399\u039a\u0391",
            "\u0394\u0399\u0391\u03a6\u039f\u03a1\u0395\u03a3 \u03a4\u03a1\u0391\u03a0\u0395\u0396\u0395\u03a3",
            "\u039f\u0399\u039d\u039f\u039b\u039f\u0393\u039f\u0399",
            "\u03a4\u0395\u039b\u03a9\u039d\u039f\u03a6\u03a5\u039b\u0391\u039a\u0397",
            "\u03a4\u0391\u039c\u0395\u0399\u039f \u0395\u0398\u039d\u0399\u039a\u0397\u03a3 \u0391\u039c\u03a5\u039d\u0391\u03a3 (T.E\u0398.A.) - \u0395\u0398\u039d\u0399\u039a\u0397 \u0395\u03a0\u0399\u03a4\u03a1\u039f\u03a0\u0397 \u0395\u039e\u039f\u03a0\u039b\u0399\u03a3\u039c\u039f\u03a5 \u0395\u039d\u039f\u03a0\u039b\u03a9\u039d \u0394\u03a5\u039d\u0391\u039c\u0395\u03a9\u039d (\u0395.\u0395.\u0395.\u0395.\u0394.)",
            "\u0395\u039a\u03a4\u0395\u039b\u0395\u03a3\u0397 \u03a4\u0397\u03a3 \u03a0\u039f\u0399\u039d\u0397\u03a3",
            "\u0399\u03a3\u039f\u039b\u039f\u0393\u0399\u03a3\u039c\u039f\u0399 \u0391\u039d\u03a9\u039d\u03a5\u039c\u03a9\u039d \u0395\u03a4\u0391\u0399\u03a1\u0395\u0399\u03a9\u039d",
            "\u0391\u03a1\u03a7\u0399\u03a4\u0395\u039a\u03a4\u039f\u039d\u0399\u039a\u039f\u0399 \u0394\u0399\u0391\u0393\u03a9\u039d\u0399\u03a3\u039c\u039f\u0399",
            "\u039a\u0391\u03a4\u0391\u03a1\u0393\u0397\u03a3\u0397 \u03a6\u03a5\u039b\u0395\u03a4\u0399\u039a\u03a9\u039d \u0394\u0399\u0391\u039a\u03a1\u0399\u03a3\u0395\u03a9\u039d",
            "\u0395\u03a0\u0391\u0393\u0393\u0395\u039b\u039c\u0391\u03a4\u0399\u039a\u0391 \u0394\u0399\u039a\u0391\u0399\u03a9\u039c\u0391\u03a4\u0391 \u0391\u03a0\u039f\u03a6\u039f\u0399\u03a4\u03a9\u039d",
            "\u039c\u039f\u039d\u0391\u03a3\u03a4\u0397\u03a1\u0399\u0391\u039a\u0397  \u03a0\u0395\u03a1\u0399\u039f\u03a5\u03a3\u0399\u0391   \u03a3\u0391\u039c\u039f\u03a5",
            "\u03a3\u03a5\u039d\u03a4\u0391\u039e\u0397 \u0394\u0397\u039c\u039f\u03a4\u0399\u039a\u03a9\u039d \u039a\u0391\u0399 \u039a\u039f\u0399\u039d\u039f\u03a4\u0399\u039a\u03a9\u039d \u03a5\u03a0\u0391\u039b\u039b\u0397\u039b\u03a9\u039d",
            "\u039f\u0399\u039a\u039f\u039d\u039f\u039c\u0399\u039a\u0395\u03a3 \u0395\u03a6\u039f\u03a1\u0399\u0395\u03a3",
            "\u03a6\u03a1\u039f\u039d\u03a4\u0399\u03a3\u03a4\u0397\u03a1\u0399\u0391 \u0395\u03a6\u0391\u03a1\u039c\u039f\u0393\u03a9\u039d",
            "\u039d\u039f\u039c\u0391\u03a1\u03a7\u0399\u0395\u03a3 \u0391\u03a4\u03a4\u0399\u039a\u0397\u03a3",
            "\u03a6\u03a5\u039c\u0391\u03a4\u0399\u03a9\u03a3\u0397",
            "\u0395\u039b\u0395\u0393\u03a7\u039f\u03a3 \u0391\u039d\u0391\u03a4\u0399\u039c\u0397\u03a3\u0395\u03a9\u039d",
            "\u0391\u03a4\u0395\u039b\u0395\u0399\u0395\u03a3 \u03a5\u03a0\u0395\u03a1 \u03a4\u0397\u03a3 \u039d\u0391\u03a5\u03a4\u0399\u039b\u0399\u0391\u03a3",
            "\u039a\u03a9\u03a6\u0391\u039b\u0391\u039b\u039f\u0399",
            "\u0399\u0391\u03a4\u03a1\u0399\u039a\u0397 \u0394\u0395\u039f\u039d\u03a4\u039f\u039b\u039f\u0393\u0399\u0391",
            "\u0395\u039e\u039f\u0394\u0391 \u0394\u0397\u039c\u039f\u03a3\u0399\u0391\u03a3 \u0391\u03a3\u03a6\u0391\u039b\u0395\u0399\u0391\u03a3",
            "\u039c\u0395 \u03a4\u0397\u039d \u0391\u03a1\u0393\u0395\u039d\u03a4\u0399\u039d\u0397",
            "\u039a\u039b\u0391\u0394\u039f\u03a3 \u03a5\u0393\u0395\u0399\u039f\u039d\u039f\u039c\u0399\u039a\u0397\u03a3 \u03a0\u0395\u03a1\u0399\u0398\u0391\u039b\u03a8\u0397\u03a3 \u03a4.\u0391.\u0395",
            "\u03a5\u03a0\u0397\u03a1\u0395\u03a3\u0399\u0391 \u0395\u039a\u039a\u0391\u0398\u0391\u03a1\u0399\u03a3\u0395\u03a9\u03a3 \u039d\u0391\u03a1\u039a\u039f\u03a0\u0395\u0394\u0399\u03a9\u039d",
            "\u03a4\u0391\u039c\u0395\u0399\u039f \u0391\u03a1\u03a9\u0393\u0397\u03a3 \u03a5\u03a0\u0391\u039b\u039b\u0397\u039b\u03a9\u039d \u0391\u03a3\u03a4\u03a5\u039d\u039f\u039c\u0399\u0391\u03a3 \u03a0\u039f\u039b\u0395\u03a9\u039d \u03a4.\u0391.\u03a5.\u0391.\u03a0",
            "\u03a0\u03a1\u039f\u03a3\u03a4\u0391\u03a3\u0399\u0391 \u0394\u0397\u039c\u039f\u03a3\u0399\u03a9\u039d \u039a\u03a4\u0397\u039c\u0391\u03a4\u03a9\u039d",
            "\u0392\u0399\u0392\u039b\u0399\u0391 \u0395\u039d\u0394\u0399\u039a\u03a9\u039d \u039c\u0395\u03a3\u03a9\u039d",
            "\u0395\u039b\u039b\u0397\u039d\u0399\u039a\u039f\u03a3 \u039f\u03a1\u0393\u0391\u039d\u0399\u03a3\u039c\u039f\u03a3 \u039c\u0399\u039a\u03a1\u039f\u039c\u0395\u03a3\u0391\u0399\u03a9\u039d \u039c\u0395\u03a4\u0391\u03a0\u039f\u0399\u0397\u03a4\u0399\u039a\u03a9\u039d \u0395\u03a0\u0399\u03a7\u0395\u0399\u03a1\u0397\u03a3\u0395\u03a9\u039d \u039a\u0391\u0399 \u03a7\u0395\u0399\u03a1\u039f\u03a4\u0395\u03a7\u039d\u0399\u0391\u03a3",
            "\u0394\u0397\u039c\u039f\u03a3\u0399\u039f\u0393\u03a1\u0391\u03a6\u0399\u039a\u039f\u03a3 \u03a7\u0391\u03a1\u03a4\u0397\u03a3",
            "\u03a6\u039f\u03a1\u039f\u03a3 \u0393\u0391\u039c\u0399\u039a\u03a9\u039d \u03a3\u03a5\u039c\u03a6\u03a9\u039d\u03a9\u039d \u0399\u03a3\u03a1\u0391\u0397\u039b\u0399\u03a4\u03a9\u039d",
            "\u03a5\u03a0\u039f\u03a4\u03a1\u039f\u03a6\u0399\u0391\u0399 \u039a\u03a4\u0397\u039d\u0399\u0391\u03a4\u03a1\u0399\u039a\u0397\u03a3",
            "\u0391\u03a0\u039f\u0394\u039f\u03a7\u0395\u03a3 \u03a0\u03a1\u039f\u03a3\u03a9\u03a0\u0399\u039a\u039f\u03a5 \u0399\u0394\u0399\u03a9\u03a4\u0399\u039a\u039f\u03a5 \u0394\u0399\u039a\u0391\u0399\u039f\u03a5",
            "\u0395\u03a0\u0399\u0392\u0391\u03a4\u0397\u0393\u0391 \u0391\u039a\u03a4\u039f\u03a0\u039b\u039f\u0399\u039a\u0391 \u03a0\u039b\u039f\u0399\u0391",
            "\u03a0\u0391\u039b\u0391\u0399\u039f\u0399 \u0394\u0397\u039c\u039f\u03a3\u0399\u039f\u03a5\u03a0\u0391\u039b\u039b\u0397\u039b\u0399\u039a\u039f\u0399 \u039d\u039f\u039c\u039f\u0399",
            "\u039a\u03a9\u0394\u0399\u039a\u0391\u03a3 \u03a0\u0395\u03a1\u0399 \u039a\u039b\u0397\u03a1\u039f\u0394\u039f\u03a4\u0397\u039c\u0391\u03a4\u03a9\u039d",
            "\u039f\u0399\u039a\u039f\u039d\u039f\u039c\u0399\u039a\u0397 \u0395\u03a0\u0399\u0398\u0395\u03a9\u03a1\u0397\u03a3\u0397",
            "\u039a\u03a4\u0397\u039c\u0391\u03a4\u039f\u0393\u03a1\u0391\u03a6\u0397\u03a3\u0397 \u0394\u0391\u03a3\u03a9\u039d",
            "\u039f\u03a1\u0393\u0391\u039d\u0399\u039a\u0395\u03a3 \u0398\u0395\u03a3\u0395\u0399\u03a3",
            "\u03a0\u0395\u03a1\u0399\u039f\u03a1\u0399\u03a3\u039c\u039f\u03a3 \u03a7\u03a1\u0397\u03a3\u0397\u03a3 \u039f\u03a1\u0399\u03a3\u039c\u0395\u039d\u03a9\u039d \u03a3\u03a5\u039c\u0392\u0391\u03a4\u0399\u039a\u03a9\u039d \u039f\u03a0\u039b\u03a9\u039d",
            "\u0391\u0393\u0399\u039f\u039d \u039f\u03a1\u039f\u03a3",
            "\u039a\u03a5\u03a1\u03a9\u03a3\u0395\u0399\u03a3 \u03a6\u039f\u03a1\u039f\u039b\u039f\u0393\u0399\u039a\u03a9\u039d \u03a0\u0391\u03a1\u0391\u0392\u0391\u03a3\u0395\u03a9\u039d",
            "\u039a\u0391\u03a4\u0391\u03a3\u03a4\u0391\u03a3\u0397 \u03a0\u03a1\u039f\u03a3\u03a9\u03a0\u0399\u039a\u039f\u03a5 \u039f.\u0393.\u0391",
            "\u0395\u03a0\u0391\u039d\u0391\u03a0\u0391\u03a4\u03a1\u0399\u03a3\u039c\u039f\u03a3 \u039a\u0395\u03a6\u0391\u039b\u0391\u0399\u03a9\u039d",
            "\u039c\u0391\u0398\u0397\u03a4\u0395\u03a3 \u03a4\u0395\u03a7\u039d\u0399\u03a4\u0395\u03a3",
            "\u0394\u0399\u0391\u0392\u0399\u0392\u0391\u03a3\u0395\u0399\u03a3",
            "\u0395\u039c\u039c\u0399\u03a3\u0398\u039f\u0399 \u039a\u0391\u0399 \u03a0\u039f\u0399\u039d\u0399\u039a\u039f\u0399 \u0394\u0399\u039a. \u0395\u03a0\u0399\u039c\u0395\u039b\u0397\u03a4\u0395\u03a3",
            "\u03a3\u03a5\u039c\u0392\u0391\u03a3\u0395\u0399\u03a3 \u0394\u0399\u039a\u0391\u03a3\u03a4\u0399\u039a\u0397\u03a3 \u03a3\u03a5\u039d\u0394\u03a1\u039f\u039c\u0397\u03a3",
            "\u0394\u0397\u039c\u039f\u03a3\u0399\u0391 \u0395\u03a0\u0399\u03a7\u0395\u0399\u03a1\u0397\u03a3\u0397 \u03a0\u0395\u03a4\u03a1\u0395\u039b\u0391\u0399\u039f\u03a5",
            "\u0395\u039b\u039b\u0397\u039d\u0399\u039a\u0397 \u03a4\u03a1\u0391\u03a0\u0395\u0396\u0391 \u0392\u0399\u039f\u039c\u0397\u03a7\u0391\u039d\u0399\u039a\u0397\u03a3 \u0391\u039d\u0391\u03a0\u03a4\u03a5\u039e\u0395\u03a9\u03a3 \u0391\u039d\u03a9\u039d\u03a5\u039c\u039f\u03a3 \u0395\u03a4\u0391\u0399\u03a1\u0395\u0399\u0391 (\u0395.\u03a4.\u0392.\u0391.  \u0391.\u0395.)",
            "\u0395\u0399\u0394\u0399\u039a\u039f\u03a4\u0397\u03a4\u0395\u03a3 \u039a\u0391\u0399 \u03a4\u03a1\u039f\u03a0\u039f\u03a3 \u0395\u0399\u03a3\u039f\u0394\u039f\u03a5 \u03a3\u03a4\u0395\u039b\u0395\u03a7\u03a9\u039d",
            "\u03a0\u03a1\u039f\u03a3\u03a4\u0391\u03a3\u0399\u0391 \u0395\u03a1\u0393\u0391\u0396\u039f\u039c\u0395\u039d\u03a9\u039d \u03a3\u03a4\u0397\u039d \u0397\u039c\u0395\u0394\u0391\u03a0\u0397 - \u03a3\u03a9\u039c\u0391 \u0395\u03a0\u0399\u0398\u0395\u03a9\u03a1\u0397\u03a3\u0397\u03a3 \u0395\u03a1\u0393\u0391\u03a3\u0399\u0391\u03a3",
            "\u0399\u039d\u03a3\u03a4\u0399\u03a4\u039f\u03a5\u03a4\u039f \u03a9\u039a\u0395\u0391\u039d\u039f\u0393\u03a1\u0391\u03a6\u0399\u039a\u03a9\u039d \u039a\u0391\u0399 \u0391\u039b\u0399\u0395\u03a5\u03a4\u0399\u039a\u03a9\u039d \u0395\u03a1\u0395\u03a5\u039d\u03a9\u039d",
            "\u0395\u039b\u0395\u0393\u03a7\u039f\u03a3 \u0391\u03a0\u039f\u039b\u03a5\u03a3\u0395\u03a9\u039d \u039c\u0399\u03a3\u0398\u03a9\u03a4\u03a9\u039d",
            "\u03a0\u0391\u039d\u0395\u039b\u039b\u0397\u039d\u0399\u0391 \u0395\u039a\u0398\u0395\u03a3\u0397 \u039b\u0391\u039c\u0399\u0391\u03a3",
            "\u039a\u03a5\u03a1\u0399\u0391\u039a\u0397 \u0391\u03a1\u0393\u0399\u0391 \u039a\u0391\u0399 \u0391\u039b\u039b\u0395\u03a3 \u03a5\u03a0\u039f\u03a7\u03a1\u0395\u03a9\u03a4\u0399\u039a\u0395\u03a3 \u0391\u03a1\u0393\u0399\u0395\u03a3",
            "\u039a\u039b\u0391\u0394\u039f\u03a3 \u03a5\u0393\u0395\u0399\u0391\u03a3 \u039f.\u0391.\u0395.\u0395",
            "\u039f\u03a1\u039a\u039f\u03a3 \u03a3\u03a4\u03a1\u0391\u03a4\u0399\u03a9\u03a4\u0399\u039a\u03a9\u039d",
            "\u0395\u039c\u03a0\u039f\u03a1\u0399\u039a\u0391 \u0392\u0399\u0392\u039b\u0399\u0391",
            "\u03a5\u0393\u0395\u0399\u039f\u039d\u039f\u039c\u0399\u039a\u0395\u03a3 \u0395\u03a0\u0399\u03a4\u03a1\u039f\u03a0\u0395\u03a3 \u0395\u039d\u039f\u03a0\u039b\u03a9\u039d \u0394\u03a5\u039d\u0391\u039c\u0395\u03a9\u039d",
            "\u0391\u0393\u0399\u039f\u03a3 \u0392\u0399\u039a\u0395\u039d\u03a4\u0399\u039f\u03a3-\u0393\u03a1\u0395\u039d\u0391\u0394\u0399\u039d\u039f\u0399, \u0391\u0393\u0399\u039f\u03a3 \u039c\u0391\u03a1\u0399\u039d\u039f\u03a3 \u039a.\u039b\u03a0",
            "\u0391\u03a0\u039f\u0396\u0397\u039c\u0399\u03a9\u03a3\u0397 \u0394\u0399\u0391\u03a4\u0395\u039b\u0395\u03a3\u0391\u039d\u03a4\u03a9\u039d \u03a0\u03a1\u03a9\u0398\u03a5\u03a0\u039f\u03a5\u03a1\u0393\u03a9\u039d",
            "\u0391\u03a3\u03a6\u0391\u039b\u0399\u03a3\u0397 \u039b\u039f\u0393\u039f\u03a4\u0395\u03a7\u039d\u03a9\u039d \u039a\u0391\u0399 \u039a\u0391\u039b\u039b\u0399\u03a4\u0395\u03a7\u039d\u03a9\u039d",
            "\u03a0\u0395\u0399\u0398\u0391\u03a1\u03a7\u0399\u039a\u0391 \u03a3\u03a5\u039c\u0392\u039f\u03a5\u039b\u0399\u0391",
            "\u0395\u03a4\u0391\u0399\u03a1\u0399\u0395\u03a3 \u03a7\u03a1\u0397\u039c\u0391\u03a4\u039f\u0394\u039f\u03a4\u0399\u039a\u0397\u03a3 \u039c\u0399\u03a3\u0398\u03a9\u03a3\u0397\u03a3",
            "\u039a\u039f\u0399\u039d\u03a9\u039d\u0399\u039a\u0397 \u03a5\u03a0\u0397\u03a1\u0395\u03a3\u0399\u0391 \u03a6\u03a5\u039b\u0391\u039a\u03a9\u039d",
            "\u039a\u0391\u039d\u039f\u039d\u0399\u03a3\u039c\u039f\u03a3 \u03a5\u03a0\u0397\u03a1\u0395\u03a3\u0399\u03a9\u039d \u0391\u0393\u03a1\u039f\u03a6\u03a5\u039b\u0391\u039a\u0397\u03a3",
            "\u0391\u03a3\u03a6\u0391\u039b\u0399\u03a3\u0397 \u03a3\u03a4\u039f \u0399\u039a\u0391",
            "\u0395\u039c\u03a0\u039f\u03a1\u0399\u039a\u039f\u0399 \u03a3\u03a5\u039c\u0392\u039f\u03a5\u039b\u039f\u0399 \u039a\u0391\u0399 \u0391\u039a\u039f\u039b\u039f\u03a5\u0398\u039f\u0399",
            "\u0395\u03a0\u0399\u039a\u039f\u03a5\u03a1\u039f\u0399 \u03a0\u0391\u03a1\u0391\u03a4\u0397\u03a1\u0397\u03a4\u0395\u03a3",
            "\u03a5\u03a0\u039f\u03a4\u03a1\u039f\u03a6\u0399\u0395\u03a3",
            "\u039a\u0395\u039d\u03a4\u03a1\u039f \u03a0\u03a1\u039f\u0393\u03a1\u0391\u039c\u039c\u0391\u03a4\u0399\u03a3\u039c\u039f\u03a5",
            "\u03a0\u03a1\u03a9\u03a4\u0395\u03a3 \u03a5\u039b\u0395\u03a3 \u03a3\u039f\u039a\u039f\u039b\u0391\u03a4\u039f\u03a0\u039f\u0399\u0399\u0391\u03a3",
            "\u0395\u03a0\u0399\u03a4\u03a1\u039f\u03a0\u0397 \u039a\u0397\u03a0\u03a9\u039d \u039a\u0391\u0399 \u0394\u0395\u039d\u0394\u03a1\u039f\u03a3\u03a4\u039f\u0399\u03a7\u0399\u03a9\u039d",
            "\u039a\u0399\u039d\u0397\u03a4\u039f \u0395\u03a0\u0399\u03a3\u0397\u039c\u0391",
            "\u03a3\u03a5\u039d\u0394\u0399\u039a\u0391\u039b\u0399\u03a3\u039c\u039f\u03a3 \u0394\u0397\u039c\u039f\u03a3\u0399\u03a9\u039d \u03a5\u03a0\u0391\u039b\u039b\u0397\u039b\u03a9\u039d",
            "\u03a4\u0391\u039c\u0395\u0399\u039f \u03a0\u03a1\u039f\u039d\u039f\u0399\u0391\u03a3 \u03a0.\u039d",
            "\u039f\u03a1\u0393\u0391\u039d\u0399\u039a\u0395\u03a3 \u0394\u0399\u0391\u03a4\u0391\u039e\u0395\u0399\u03a3 \u03a4\u0391\u039c\u0395\u0399\u039f\u03a5 \u03a0\u0391\u03a1\u0391\u039a\u0391\u03a4\u0391\u0398\u0397\u039a\u03a9\u039d \u039a\u0391\u0399 \u0394\u0391\u039d\u0395\u0399\u03a9\u039d",
            "\u0391\u0394\u0395\u0399\u0395\u03a3 \u0397\u039d\u0399\u039f\u03a7\u0399\u0391\u03a3",
            "\u03a5\u03a0\u0397\u03a1\u0395\u03a3\u0399\u0391 \u03a0\u03a1\u039f\u0393\u03a1\u0391\u039c\u039c\u0391\u03a4\u0399\u03a3\u039c\u039f\u03a5 \u039a\u0391\u0399 \u039c\u0395\u039b\u0395\u03a4\u03a9\u039d",
            "\u039a\u03a1\u0391\u03a4\u0399\u039a\u0391 \u0391\u03a5\u03a4\u039f\u039a\u0399\u039d\u0397\u03a4\u0391",
            "\u0391\u03a4\u039f\u039c\u0399\u039a\u0397 \u039a\u0391\u03a4\u0391\u0393\u0393\u0395\u039b\u0399\u0391 \u03a3\u03a5\u039c\u0392\u0391\u03a3\u0395\u03a9\u03a3 \u0395\u03a1\u0393\u0391\u03a3\u0399\u0391\u03a3",
            "\u03a0\u039f\u039b\u03a5\u03a4\u0395\u039a\u039d\u039f\u0399",
            "\u0399\u03a3\u03a4\u039f\u03a1\u0399\u039a\u039f \u0391\u03a1\u03a7\u0395\u0399\u039f \u039c\u0391\u039a\u0395\u0394\u039f\u039d\u0399\u0391\u03a3",
            "\u0391\u03a3\u03a6\u0391\u039b\u0399\u03a3\u0397 \u0391\u03a5\u03a4\u039f\u039a\u0399\u039d\u0397\u03a4\u0399\u039a\u03a9\u039d \u0391\u03a4\u03a5\u03a7\u0397\u039c\u0391\u03a4\u03a9\u039d",
            "\u0394\u0391\u039d\u0395\u0399\u0391 \u0395\u03a3\u03a9\u03a4\u0395\u03a1\u0399\u039a\u0391",
            "\u0395\u039a\u039a\u039b\u0397\u03a3\u0399\u0391 \u039a\u03a1\u0397\u03a4\u0397\u03a3",
            "\u03a6\u039f\u03a1\u039f\u039b\u039f\u0393\u0399\u0391 \u03a3\u03a4\u0391\u03a6\u0399\u0394\u0391\u03a3",
            "\u0395\u039a\u03a0\u0391\u0399\u0394\u0395\u03a5\u03a4\u0399\u039a\u0395\u03a3 \u0391\u0394\u0395\u0399\u0395\u03a3",
            "\u0391\u0395\u03a1\u039f\u0394\u0399\u039a\u0395\u0399\u0391",
            "\u0395\u03a0\u0399\u0394\u039f\u039c\u0391 \u0391\u03a3\u0398\u0395\u039d\u0395\u0399\u0391\u03a3",
            "\u0398\u0395\u03a3\u0395\u0399\u03a3 \u03a3\u03a5\u039c\u0392\u039f\u039b\u0391\u0399\u039f\u0393\u03a1\u0391\u03a6\u03a9\u039d",
            "\u0391\u0393\u039f\u03a1\u0391 \u03a3\u03a5\u039d\u0391\u039b\u039b\u0391\u0393\u039c\u0391\u03a4\u039f\u03a3",
            "\u039d\u039f\u039c\u0399\u039a\u039f \u03a3\u03a5\u039c\u0392\u039f\u03a5\u039b\u0399\u039f \u03a4\u039f\u03a5 \u039a\u03a1\u0391\u03a4\u039f\u03a5\u03a3 (\u039d.\u03a3.\u039a.)",
            "\u03a6\u039f\u03a1\u039f\u039b\u039f\u0393\u0399\u0391 \u039c\u0395\u03a4\u0391\u0392\u0399\u0392\u0391\u03a3\u0397\u03a3",
            "\u03a3\u03a5\u039c\u0392\u039f\u03a5\u039b\u0399\u0391 - \u0395\u03a0\u0399\u03a4\u03a1\u039f\u03a0\u0395\u03a3 - \u0399\u039d\u03a3\u03a4\u0399\u03a4\u039f\u03a5\u03a4\u0391 \u0395\u03a1\u0393\u0391\u03a3\u0399\u0391\u03a3 \u039a\u0391\u0399 \u039a\u039f\u0399\u039d\u03a9\u039d\u0399\u039a\u03a9\u039d \u0391\u03a3\u03a6\u0391\u039b\u0399\u03a3\u0395\u03a9\u039d",
            "\u03a4\u0395\u039b\u0397 \u0395\u0399\u03a3\u0399\u03a4\u0397\u03a1\u0399\u03a9\u039d \u039a\u0391\u0399 \u039a\u039f\u039c\u0399\u03a3\u03a4\u03a1\u03a9\u039d",
            "\u039f\u0399\u039a\u039f\u039d\u039f\u039c\u0399\u039a\u0397 \u03a5\u03a0\u0397\u03a1\u0395\u03a3\u0399\u0391 \u03a5\u0393\u0395\u0399\u039f\u039d\u039f\u039c\u0399\u039a\u039f\u03a5 \u03a3\u03a9\u039c\u0391\u03a4\u039f\u03a3",
            "\u03a0\u03a1\u039f\u03a3\u03a9\u03a0\u0399\u039a\u039f \u03a3\u03a9\u039c\u0391\u03a4\u03a9\u039d \u0391\u03a3\u03a6\u0391\u039b\u0395\u0399\u0391\u03a3 \u039c\u0395 \u03a3\u03a7\u0395\u03a3\u0397 \u0399\u0394\u0399\u03a9\u03a4\u0399\u039a\u039f\u03a5 \u0394\u0399\u039a\u0391\u0399\u039f\u03a5",
            "\u0391\u03a1\u03a4\u0395\u03a1\u0393\u0391\u03a4\u0395\u03a3",
            "\u0395\u03a5\u039a\u039f\u039b\u0399\u0395\u03a3 \u03a3\u0395 \u03a6\u039f\u0399\u03a4\u0397\u03a4\u0395\u03a3",
            "\u03a3\u03a5\u039d\u0395\u03a4\u0391\u0399\u03a1\u0399\u03a3\u039c\u039f\u0399 \u039a\u039f\u0399\u039d\u0397\u03a3 \u03a7\u039f\u03a1\u03a4\u039f\u039d\u039f\u039c\u0397\u03a3 \u039a\u0391\u0399 \u03a3\u03a5\u039d\u0399\u0394\u0399\u039f\u039a\u03a4\u0397\u03a3\u0399\u0391\u03a3",
            "\u03a4\u0391\u039c\u0395\u0399\u039f \u0391\u03a3\u03a6\u0391\u039b\u0399\u03a3\u0395\u03a9\u03a3 \u03a0\u03a1\u039f\u03a3\u03a9\u03a0\u0399\u039a\u039f\u03a5 \u03a0\u0395\u03a1\u0399\u03a6\u0395\u03a1\u0395\u0399\u0391\u039a\u039f\u03a5 \u0393\u0395\u039d\u0399\u039a\u039f\u03a5 \u039d\u039f\u03a3\u039f\u039a\u039f\u039c\u0395\u0399\u039f\u03a5 \u039f \u0395\u03a5\u0391\u0393\u0393\u0395\u039b\u0399\u03a3\u039c\u039f\u03a3",
            "\u03a0\u03a1\u039f\u03a3\u039a\u039f\u03a0\u0399\u03a3\u039c\u039f\u03a3",
            "\u03a3\u03a5\u039c\u0392\u039f\u03a5\u039b\u0399\u0391 \u0395\u03a0\u0391\u0393\u0393\u0395\u039b\u039c\u0391\u03a4\u0399\u039a\u0397\u03a3 \u039a\u0391\u0399 \u03a4\u0395\u03a7\u039d\u0399\u039a\u0397\u03a3 \u0395\u039a\u03a0\u0391\u0399\u0394\u0395\u03a5\u03a3\u0395\u03a9\u03a3",
            "\u039a\u03a1\u0391\u03a4\u0399\u039a\u039f\u03a3 \u039f\u03a1\u0393\u0391\u039d\u0399\u03a3\u039c\u039f\u03a3 \u039c\u0397\u03a7\u0391\u039d\u0397\u039c\u0391\u03a4\u03a9\u039d \u0394\u0397\u039c\u039f\u03a3\u0399\u03a9\u039d \u0395\u03a1\u0393\u03a9\u039d",
            "\u0391\u03a4\u039f\u039c\u0399\u039a\u0391 \u0395\u0393\u0393\u03a1\u0391\u03a6\u0391 \u0391\u039d\u0398\u03a5\u03a0\u0391\u03a3\u03a0\u0399\u03a3\u03a4\u03a9\u039d-\u03a5\u03a0\u0391\u039e\u0399\u03a9\u039c\u0391\u03a4\u0399\u039a\u03a9\u039d",
            "\u0394\u0399\u0391\u03a6\u039f\u03a1\u0395\u03a3 \u03a3\u03a7\u039f\u039b\u0395\u03a3",
            "\u0392\u0399\u0392\u039b\u0399\u0391 \u0394\u0397\u039c\u039f\u03a3\u0399\u0395\u03a5\u03a3\u0395\u03a9\u03a3 \u0394\u0399\u0391\u0398\u0397\u039a\u03a9\u039d",
            "\u039a\u0391\u039d\u039f\u039d\u0399\u03a3\u039c\u039f\u0399 \u03a0\u03a1\u039f\u03a3\u03a9\u03a0\u0399\u039a\u039f\u03a5 \u03a3\u03a5\u0393\u039a\u039f\u0399\u039d\u03a9\u039d\u0399\u0391\u039a\u03a9\u039d \u0395\u03a0\u0399\u03a7\u0395\u0399\u03a1\u0397\u03a3\u0395\u03a9\u039d",
            "\u03a4\u039f\u03a5\u03a1\u0399\u03a3\u03a4\u0399\u039a\u039f\u0399 \u03a4\u039f\u03a0\u039f\u0399",
            "\u0399\u039d\u03a3\u03a4\u0399\u03a4\u039f\u03a5\u03a4\u039f \u039e\u0395\u039d\u03a9\u039d \u0393\u039b\u03a9\u03a3\u03a3\u03a9\u039d \u039a\u0391\u0399 \u03a6\u0399\u039b\u039f\u039b\u039f\u0393\u0399\u03a9\u039d",
            "\u039a\u0391\u03a0\u039d\u039f\u03a0\u03a9\u039b\u0395\u03a3",
            "\u0391\u0393\u03a9\u0393\u0395\u03a3 \u0393\u0399\u0391\u03a4\u03a1\u03a9\u039d",
            "\u03a3\u03a5\u03a3\u03a4\u0391\u03a3\u0397 \u039a\u0391\u0399 \u0391\u03a0\u039f\u0394\u039f\u03a3\u0397 \u03a0\u0391\u03a1\u0391\u039a\u0391\u03a4\u0391\u0398\u0397\u039a\u03a9\u039d \u0391\u03a0\u039f \u03a4.\u03a0. \u039a\u0391\u0399 \u0394",
            "\u0391\u0394\u0399\u039a\u0397\u039c\u0391\u03a4\u0391 \u0394\u0399\u0391\u03a0\u03a1\u0391\u03a4\u03a4\u039f\u039c\u0395\u039d\u0391 \u03a3\u03a4\u0391 \u039a\u03a1\u0391\u03a4\u0397-\u039c\u0395\u039b\u0397",
            "\u0391\u039d\u0391\u03a3\u03a4\u039f\u039b\u0395\u03a3 \u03a4\u039f\u03a5 \u03a3\u03a5\u039d\u03a4\u0391\u0393\u039c\u0391\u03a4\u039f\u03a3 - \u039a\u0391\u03a4\u0391\u03a3\u03a4\u0391\u03a3\u0397 \u03a0\u039f\u039b\u0399\u039f\u03a1\u039a\u0399\u0391\u03a3",
            "\u03a3\u03a5\u039c\u0392\u0391\u03a3\u0395\u0399\u03a3 \u03a0\u0391\u03a1\u039f\u03a7\u0397\u03a3 \u0391\u03a3\u03a6\u0391\u039b\u0395\u0399\u0391\u03a3 (\u0395\u039d\u0395\u03a7\u03a5\u03a1\u039f, \u03a5\u03a0\u039f\u0398\u0397\u039a\u0397 \u039a.\u039b\u03a0.)",
            "\u03a4\u0391\u039c\u0395\u0399\u039f \u0391\u03a3\u03a6\u0391\u039b\u0399\u03a3\u0395\u03a9\u03a3\u039d\u0391\u03a5\u03a4\u0399\u039a\u03a9\u039d \u03a0\u03a1\u0391\u039a\u03a4\u039f\u03a1\u03a9\u039d \u039a\u0391\u0399 \u03a5\u03a0\u0391\u039b\u039b\u0397\u039b\u03a9\u039d (\u03a4.\u0391.\u039d.\u03a0.\u03a5.)",
            "\u0391\u039d\u03a9\u03a4\u0391\u03a4\u039f \u03a3\u03a5\u0393\u039a\u039f\u0399\u039d\u03a9\u039d\u0399\u0391\u039a\u039f \u03a3\u03a5\u039c\u0392\u039f\u03a5\u039b\u0399\u039f",
            "\u03a0\u03a1\u0395\u0392\u0395\u039d\u03a4\u039f\u03a1\u0399\u0391",
            "\u0391\u039d\u0391\u0392\u039f\u039b\u0397 \u03a3\u03a4\u03a1\u0391\u03a4\u0395\u03a5\u03a3\u0395\u03a9\u03a3",
            "\u0395\u0399\u0394\u0399\u039a\u0391 \u039b\u0397\u039e\u0399\u0391\u03a1\u03a7\u0395\u0399\u0391",
            "\u0393\u0395\u03a9\u03a4\u0395\u03a7\u039d\u0399\u039a\u039f \u0395\u03a0\u0399\u039c\u0395\u039b\u0397\u03a4\u0397\u03a1\u0399\u039f",
            "\u03a5\u0393\u0395\u0399\u039f\u039d\u039f\u039c\u0399\u039a\u0391 \u0394\u0399\u039a\u0391\u0399\u03a9\u039c\u0391\u03a4\u0391",
            "\u03a4\u0391\u039c\u0395\u0399\u039f \u0395\u03a0\u0399\u039a\u039f\u03a5\u03a1\u0399\u039a\u0397\u03a3 \u0391\u03a3\u03a6\u0391\u039b\u0399\u03a3\u0397\u03a3 \u0395\u039a\u03a0\u0391\u0399\u0394\u0395\u03a5\u03a4\u0399\u039a\u03a9\u039d",
            "\u039a\u0391\u0396\u0391\u039a\u03a3\u03a4\u0391\u039d \u2013 \u039a\u0391\u039c\u0395\u03a1\u039f\u03a5\u039d \u2013 \u039a\u0391\u039d\u0391\u0394\u0391\u03a3 \u039a.\u039b\u03a0",
            "\u03a3\u03a5\u039d\u03a4\u0391\u039e\u0395\u0399\u03a3 \u0398\u03a5\u039c\u0391\u03a4\u03a9\u039d \u0391\u03a0\u039f \u03a4\u039f\u039d \u0391\u039c\u0391\u03a7\u039f \u03a0\u039b\u0397\u0398\u03a5\u03a3\u039c\u039f",
            "\u03a6\u0399\u039b\u039f\u03a3\u039f\u03a6\u0399\u039a\u0397 \u03a3\u03a7\u039f\u039b\u0397",
            "\u0395\u039a\u03a4\u0395\u039b\u03a9\u039d\u0399\u03a3\u039c\u039f\u03a3 \u03a4\u0391\u03a7\u03a5\u0394\u03a1\u039f\u039c\u0399\u039a\u03a9\u039d \u0394\u0395\u039c\u0391\u03a4\u03a9\u039d",
            "\u03a5\u0394\u03a1\u0395\u03a5\u03a3\u0397 \u0398\u0395\u03a3\u03a3\u0391\u039b\u039f\u039d\u0399\u039a\u0397\u03a3",
            "\u03a3\u03a5\u039c\u03a6\u03a9\u039d\u0399\u0395\u03a3 \u03a0\u0395\u03a1\u0399 \u03a0\u039b\u03a9\u03a4\u03a9\u039d \u039f\u0394\u03a9\u039d",
            "\u0391\u039d\u0391\u039a\u0397\u03a1\u03a5\u039e\u0397 \u03a4\u0397\u03a3 \u0391\u039d\u0395\u039e\u0391\u03a1\u03a4\u0397\u03a3\u0399\u0391\u03a3",
            "\u0395\u03a0\u0399\u03a4\u03a1\u039f\u03a0\u0397 \u039f\u039b\u03a5\u039c\u03a0\u0399\u0391\u039a\u03a9\u039d \u0391\u0393\u03a9\u039d\u03a9\u039d",
            "\u039f\u0399\u039d\u039f\u03a0\u0391\u03a1\u0391\u0393\u03a9\u0393\u0397 \u0391\u03a4\u03a4\u0399\u039a\u039f\u0392\u039f\u0399\u03a9\u03a4\u0399\u0391\u03a3",
            "\u0395\u039a\u03a0\u03a4\u03a9\u03a3\u0395\u0399\u03a3 \u03a5\u03a0\u0395\u03a1 \u0395\u039e\u0391\u0393\u03a9\u0393\u0395\u03a9\u039d",
            "\u03a6\u039f\u03a1\u039f\u039b\u039f\u0393\u0399\u0391 \u039a\u039b\u0397\u03a1\u039f\u039d\u039f\u039c\u0399\u03a9\u039d, \u0394\u03a9\u03a1\u0395\u03a9\u039d, \u0393\u039f\u039d\u0399\u039a\u03a9\u039d \u03a0\u0391\u03a1\u039f\u03a7\u03a9\u039d",
            "\u039f\u03a1\u03a6\u0391\u039d\u039f\u03a4\u03a1\u039f\u03a6\u0395\u0399\u0391 \u039a\u0391\u0399 \u039f\u0399\u039a\u039f\u03a4\u03a1\u039f\u03a6\u0395\u0399\u0391",
            "\u039c\u0395 \u03a4\u0397\u039d \u039f\u03a5\u03a1\u0391\u0393\u039f\u03a5\u0391\u0397",
            "\u039c\u0395 \u03a4\u0397\u039d \u0391\u03a5\u03a3\u03a4\u03a1\u0399\u0391\u039a\u0397",
            "\u0394\u0399\u0391\u03a6\u039f\u03a1\u039f\u0399 \u03a6\u039f\u03a1\u039f\u0399 \u039a\u0391\u03a4\u0391\u039d\u0391\u039b\u03a9\u03a3\u0395\u03a9\u03a3",
            "\u0394\u0399\u0395\u03a5\u0398\u03a5\u039d\u03a3\u0397 \u0395\u03a6\u0395\u0394\u03a1\u03a9\u039d - \u03a0\u039f\u039b\u0395\u039c\u0399\u03a3\u03a4\u03a9\u039d - \u0391\u0393\u03a9\u039d\u0399\u03a3\u03a4\u03a9\u039d",
            "\u0391\u0393\u03a1\u039f\u03a4\u0399\u039a\u0395\u03a3 \u039f\u0399\u039a\u039f\u039a\u03a5\u03a1\u0399\u039a\u0395\u03a3 \u03a3\u03a7\u039f\u039b\u0395\u03a3",
            "\u039e\u03a5\u039b\u0395\u0399\u0391",
            "\u0392\u0399\u0392\u039b\u0399\u0391\u03a1\u0399\u0391 \u03a5\u0393\u0395\u0399\u0391\u03a3 \u0395\u03a1\u0393\u0391\u03a4\u03a9\u039d",
            "\u03a3\u03a7\u039f\u039b\u0397 \u0391\u039e\u0399\u03a9\u039c\u0391\u03a4\u0399\u039a\u03a9\u039d \u03a3\u03a4\u03a1\u0391\u03a4\u0399\u03a9\u03a4\u0399\u039a\u03a9\u039d \u03a5\u03a0\u0397\u03a1\u0395\u03a3\u0399\u03a9\u039d",
            "\u039d\u039f\u039c\u0391\u03a1\u03a7\u0399\u0391\u039a\u0395\u03a3 \u039a\u0391\u0399 \u0394\u0397\u039c\u039f\u03a4\u0399\u039a\u0395\u03a3 \u0395\u039a\u039b\u039f\u0393\u0395\u03a3",
            "\u0395\u0393\u0393\u03a5\u0397\u03a3\u0395\u0399\u03a3 \u039a\u0391\u0399 \u0394\u0391\u039d\u0395\u0399\u0391 \u03a4\u039f\u03a5 \u0394\u0397\u039c\u039f\u03a3\u0399\u039f\u03a5",
            "\u03a5\u03a0\u039f\u03a5\u03a1\u0393\u0395\u0399\u039f \u0391\u039d\u0391\u03a0\u03a4\u03a5\u039e\u0397\u03a3",
            "\u03a4\u0391\u039a\u03a4\u0399\u039a\u0391 \u0394\u0399\u039f\u0399\u039a\u0397\u03a4\u0399\u039a\u0391 \u0394\u0399\u039a\u0391\u03a3\u03a4\u0397\u03a1\u0399\u0391 - \u0393\u0395\u039d\u0399\u039a\u0395\u03a3 \u0394\u0399\u0391\u03a4\u0391\u039e\u0395\u0399\u03a3",
            "\u03a4\u03a1\u039f\u03a6\u039f\u0394\u039f\u03a3\u0399\u0391 \u03a0\u039b\u0397\u03a1\u03a9\u039c\u0391\u03a4\u03a9\u039d \u03a0\u039b\u039f\u0399\u03a9\u039d",
            "\u0394\u0399\u0391\u03a6\u039f\u03a1\u039f\u0399 \u039b\u0399\u039c\u0395\u039d\u0395\u03a3 \u039a\u0391\u0399 \u039b\u0399\u039c\u0395\u039d\u0399\u039a\u0391 \u03a4\u0391\u039c\u0395\u0399\u0391",
            "\u0397\u039b\u0395\u039a\u03a4\u03a1\u0399\u039a\u0395\u03a3 \u0395\u039a\u039c\u0395\u03a4\u0391\u039b\u039b\u0395\u03a5\u03a3\u0395\u0399\u03a3",
            "\u03a0\u03a1\u039f\u03a5\u03a0\u039f\u0398\u0395\u03a3\u0395\u0399\u03a3 \u0391\u03a3\u039a\u0397\u03a3\u0397\u03a3 \u0394\u0399\u0391\u03a6\u039f\u03a1\u03a9\u039d \u0395\u03a0\u0391\u0393\u0393\u0395\u039b\u039c\u0391\u03a4\u03a9\u039d",
            "\u03a4\u0395\u039b\u03a9\u039d\u0395\u0399\u0391\u039a\u0397 \u03a5\u03a0\u0397\u03a1\u0395\u03a3\u0399\u0391 \u0391\u0395\u03a1\u039f\u03a3\u039a\u0391\u03a6\u03a9\u039d",
            "\u0395\u03a0\u0399\u03a4\u03a1\u039f\u03a0\u0397 \u0394\u0391\u03a3\u039c\u039f\u039b\u039f\u0393\u0399\u039f\u03a5",
            "\u039d\u0391\u03a5\u03a0\u0397\u0393\u0395\u0399\u0391 \u03a0. \u039d\u0391\u03a5\u03a4\u0399\u039a\u039f\u03a5",
            "\u0392\u0399\u039f\u039c\u0397\u03a7\u0391\u039d\u0399\u039a\u0395\u03a3 \u039a\u0391\u0399 \u0395\u03a0\u0399\u03a7\u0395\u0399\u03a1\u0397\u039c\u0391\u03a4\u0399\u039a\u0395\u03a3 \u03a0\u0395\u03a1\u0399\u039f\u03a7\u0395\u03a3",
            "\u0399\u0391\u03a4\u03a1\u039f\u0394\u0399\u039a\u0391\u03a3\u03a4\u0395\u03a3",
            "\u0391\u0398\u039b\u0397\u03a4\u0399\u03a3\u039c\u039f\u03a3 \u0395\u039d\u039f\u03a0\u039b\u03a9\u039d \u0394\u03a5\u039d\u0391\u039c\u0395\u03a9\u039d",
            "\u039f\u03a1\u0393\u0391\u039d\u0399\u03a3\u039c\u039f\u03a3 \u03a3\u03a5\u039a\u03a9\u039d",
            "\u039a\u0391\u039d\u039f\u039d\u0399\u03a3\u039c\u039f\u03a3 \u0391\u03a3\u0398\u0395\u039d\u0395\u0399\u0391\u03a3 \u03a4\u0391\u039c\u0395\u0399\u039f\u03a5 \u03a3\u03a5\u039d\u03a4\u0391\u039e\u0395\u03a9\u039d \u0395\u03a6\u0397\u039c\u0395\u03a1\u0399\u0394\u039f\u03a0\u03a9\u039b\u03a9\u039d \u039a\u0391\u0399 \u03a5\u03a0\u0391\u039b\u039b\u0397\u039b\u03a9\u039d \u03a0\u03a1\u0391\u039a\u03a4\u039f\u03a1\u0395\u0399\u03a9\u039d (\u03a4.\u03a3.\u0395.\u03a5.\u03a0.)",
            "\u0391\u0394\u0395\u0399\u0395\u03a3 \u039c\u0399\u03a3\u0398\u03a9\u03a4\u03a9\u039d",
            "\u03a0\u03a1\u039f\u03a3\u03a4\u0391\u03a3\u0399\u0391 \u039a\u0395\u03a6\u0391\u039b\u0391\u0399\u03a9\u039d \u0395\u039e\u03a9\u03a4\u0395\u03a1\u0399\u039a\u039f\u03a5",
            "\u0391\u03a0\u039f\u0394\u0395\u0399\u039a\u03a4\u0399\u039a\u0391 \u03a6\u039f\u03a1\u039f\u039b\u039f\u0393\u0399\u039a\u0397\u03a3 \u0395\u039d\u0397\u039c\u0395\u03a1\u039f\u03a4\u0397\u03a4\u0391\u03a3",
            "\u039f\u03a1\u0393\u0391\u039d\u03a9\u03a3\u0397 \u039a\u0391\u0399 \u039b\u0395\u0399\u03a4\u039f\u03a5\u03a1\u0393\u0399\u0391 \u03a4\u03a9\u039d \u03a4\u0397\u039b\u0395\u03a0\u0399\u039a\u039f\u0399\u039d\u03a9\u039d\u0399\u03a9\u039d \u0395\u0398\u039d\u0399\u039a\u0397 \u0395\u03a0\u0399\u03a4\u03a1\u039f\u03a0\u0397 \u03a4\u0397\u039b\u0395\u03a0\u0399\u039a\u039f\u0399\u039d\u03a9\u039d\u0399\u03a9\u039d \u039a\u0391\u0399 \u03a4\u0391\u03a7\u03a5\u0394\u03a1\u039f\u039c\u0395\u0399\u03a9\u039d (\u0395.\u0395.\u03a4.\u03a4.)",
            "\u03a0\u03a1\u039f\u03a3\u03a9\u03a0\u0399\u039a\u039f \u039f.\u03a4.\u0395",
            "\u0392\u0391\u03a3\u0399\u039b\u0399\u039a\u0391 \u0399\u0394\u03a1\u03a5\u039c\u0391\u03a4\u0391",
            "\u0391\u03a0\u039f\u039a\u0391\u03a4\u0391\u03a3\u03a4\u0391\u03a3\u0397 \u03a0\u039b\u0397\u0393\u0395\u039d\u03a4\u03a9\u039d \u0391\u03a0\u039f \u0395\u039a\u03a1\u0397\u039e\u0397 \u03a0\u039b\u039f\u0399\u039f\u03a5 \u03a3\u03a4\u0397\u039d \u039a\u03a1\u0397\u03a4\u0397",
            "\u0395\u039a\u039c\u0395\u03a4\u0391\u039b\u039b\u0395\u03a5\u03a3\u0397 \u0394\u03a5\u039d\u0391\u039c\u0395\u03a9\u03a3 \u03a1\u0395\u039f\u039d\u03a4\u03a9\u039d \u03a5\u0394\u0391\u03a4\u03a9\u039d",
            "\u039a\u0391\u039a\u039f\u03a5\u03a1\u0393\u0399\u039f\u0394\u0399\u039a\u0395\u0399\u0391",
            "\u039a\u0395\u039d\u03a4\u03a1\u0399\u039a\u0395\u03a3 \u0391\u0393\u039f\u03a1\u0395\u03a3 \u0391\u039b\u039b\u03a9\u039d \u03a0\u039f\u039b\u0395\u03a9\u039d",
            "\u03a4\u0391\u039c\u0395\u0399\u039f \u0391\u039b\u039b\u0397\u039b\u039f\u0392\u039f\u0397\u0398\u0395\u0399\u0391\u03a3 \u03a0.\u039d",
            "\u0395\u039a\u039b\u039f\u0393\u0399\u039a\u039f\u0399 \u039a\u0391\u03a4\u0391\u039b\u039f\u0393\u039f\u0399 \u039a\u0391\u0399 \u0392\u0399\u0392\u039b\u0399\u0391\u03a1\u0399\u0391",
            "\u03a5\u03a0\u0397\u03a1\u0395\u03a3\u0399\u0391 \u0395\u0393\u0393\u0395\u0399\u03a9\u039d \u0392\u0395\u039b\u03a4\u0399\u03a9\u03a3\u0395\u03a9\u039d",
            "\u03a4\u039f\u03a5\u03a1\u0399\u03a3\u03a4\u0399\u039a\u0397 \u0391\u039d\u0391\u03a0\u03a4\u03a5\u039e\u0397",
            "\u039d\u039f\u039c\u039f\u0398\u0395\u03a3\u0399\u0391 \u03a0\u0395\u03a1\u0399 \u03a3\u03a5\u039c\u0392\u0391\u03a3\u0395\u03a9\u03a3 \u0395\u03a1\u0393\u0391\u03a3\u0399\u0391\u03a3",
            "\u0395\u039b\u0395\u0393\u03a7\u039f\u03a3 \u0395\u039a\u03a1\u0397\u039a\u03a4\u0399\u039a\u03a9\u039d \u03a5\u039b\u03a9\u039d",
            "\u039c\u0391\u039a\u0395\u0394\u039f\u039d\u0399\u039a\u039f\u0399 \u03a3\u0399\u0394\u0397\u03a1\u039f\u0394\u03a1\u039f\u039c\u039f\u0399",
            "\u0394\u0399\u0395\u03a5\u039a\u039f\u039b\u03a5\u039d\u03a3\u0395\u0399\u03a3 \u03a3\u0395 \u0394\u0397\u039c\u039f\u03a3\u0399\u039f\u03a5\u03a3 \u03a5\u03a0\u0391\u039b\u039b\u0397\u039b\u039f\u03a5\u03a3",
            "\u03a3\u03a4\u03a1\u0391\u03a4\u0399\u03a9\u03a4\u0399\u039a\u0395\u03a3 \u03a5\u03a0\u039f\u03a7\u03a1\u0395\u03a9\u03a3\u0395\u0399\u03a3 \u0395\u03a0\u0391\u039d\u0391\u03a0\u0391\u03a4\u03a1\u0399\u0396\u039f\u039c\u0395\u039d\u03a9\u039d",
            "\u0394\u0399\u0391\u039a\u03a1\u0399\u03a3\u0397 \u0395\u039c\u03a0\u039f\u03a1\u0399\u039a\u03a9\u039d \u03a0\u03a1\u0391\u039e\u0395\u03a9\u039d",
            "\u039f\u03a1\u0393\u0391\u039d\u0399\u03a3\u039c\u039f\u03a3 \u0395\u039b\u039b\u0397\u039d\u0399\u039a\u03a9\u039d \u0393\u0395\u03a9\u03a1\u0393\u0399\u039a\u03a9\u039d \u0391\u03a3\u03a6\u0391\u039b\u0399\u03a3\u0395\u03a9\u039d (\u0395.\u039b.\u0393.\u0391.)",
            "\u0395\u039e\u03a9\u03a3\u03a7\u039f\u039b\u0399\u039a\u0397 \u03a3\u03a9\u039c\u0391\u03a4\u0399\u039a\u0397 \u0391\u0393\u03a9\u0393\u0397",
            "\u0394\u03a1\u0391\u03a7\u039c\u039f\u03a0\u039f\u0399\u0397\u03a3\u0397",
            "\u039c\u0395 \u03a4\u0397 \u0392\u03a1\u0391\u0396\u0399\u039b\u0399\u0391",
            "\u0395\u039a\u039a\u039b\u0397\u03a3\u0399\u0391\u03a3\u03a4\u0399\u039a\u0397 \u0391\u039a\u0391\u0394\u0397\u039c\u0399\u0391",
            "\u0391\u039d\u03a4\u0391\u039b\u039b\u0391\u0393\u0397 \u0398\u0395\u03a1\u0391\u03a0\u0395\u03a5\u03a4\u0399\u039a\u03a9\u039d \u039f\u03a5\u03a3\u0399\u03a9\u039d",
            "\u0393\u0391\u039b\u039b\u0399\u0391, \u0393\u0395\u03a1\u039c\u0391\u039d\u0399\u0391 \u039a.\u039b\u03a0",
            "\u039d\u039f\u039c\u039f\u03a0\u0391\u03a1\u0391\u03a3\u039a\u0395\u03a5\u0391\u03a3\u03a4\u0399\u039a\u0395\u03a3 \u0395\u03a0\u0399\u03a4\u03a1\u039f\u03a0\u0395\u03a3",
            "\u039a\u03a5\u0392\u0395\u03a1\u039d\u0395\u0399\u039f \u0398\u0395\u03a3\u03a3\u0391\u039b\u039f\u039d\u0399\u039a\u0397\u03a3",
            "\u03a3\u03a4\u03a1\u0391\u03a4\u0399\u03a9\u03a4\u0399\u039a\u039f\u0399 \u0391\u039a\u039f\u039b\u039f\u03a5\u0398\u039f\u0399",
            "\u0394\u0399\u0391\u0398\u0395\u03a3\u0397 \u0391\u03a0\u039f\u03a3\u03a4\u03a1\u0391\u0393\u0393\u0399\u0396\u039f\u039c\u0395\u039d\u03a9\u039d \u0393\u0391\u0399\u03a9\u039d",
            "\u0393\u0395\u039d\u0399\u039a\u0395\u03a3 \u0394\u0399\u0391\u03a4\u0391\u039e\u0395\u0399\u03a3 \u0393\u0399\u0391 \u03a1\u0391\u0394\u0399\u039f\u03a6\u03a9\u039d\u0399\u0391 \u2013 \u03a4\u0397\u039b\u0395\u039f\u03a1\u0391\u03a3\u0397",
            "\u0393\u039d\u03a9\u039c\u039f\u0394\u039f\u03a4\u0399\u039a\u039f \u03a3\u03a5\u039c\u0392\u039f\u03a5\u039b\u0399\u039f \u03a6\u0391\u03a1\u039c\u0391\u039a\u03a9\u039d",
            "\u03a3\u03a5\u039c\u0392\u0391\u03a3\u0395\u0399\u03a3 \u0394\u0399\u0391\u03a6\u039f\u03a1\u0395\u03a3",
            "\u03a0\u03a1\u0391\u039e\u0395\u0399\u03a3 \u039a\u0391\u03a4\u0391 \u03a4\u0397\u03a3 \u0391\u03a3\u03a6\u0391\u039b\u0395\u0399\u0391\u03a3 \u03a4\u0397\u03a3 \u0391\u0395\u03a1\u039f\u03a0\u039f\u03a1\u0399\u0391\u03a3",
            "\u0399\u0391\u03a4\u03a1\u039f\u0399 \u0399\u0391\u039c\u0391\u03a4\u0399\u039a\u03a9\u039d \u03a0\u0397\u0393\u03a9\u039d",
            "\u039a\u0395\u039d\u03a4\u03a1\u0399\u039a\u039f \u03a3\u03a5\u039c\u0392\u039f\u03a5\u039b\u0399\u039f \u03a5\u0393\u0395\u0399\u0391\u03a3 (\u039a\u0395.\u03a3.\u03a5.)",
            "\u0391\u039d\u03a9\u03a4\u0391\u03a4\u039f \u03a3\u03a5\u039c\u0392\u039f\u03a5\u039b\u0399\u039f \u0394\u0397\u039c\u039f\u03a3\u0399\u03a9\u039d \u03a5\u03a0\u0391\u039b\u039b\u0397\u039b\u03a9\u039d",
            "\u03a5\u03a0\u039f\u03a5\u03a1\u0393\u0395\u0399\u039f \u0395\u039d\u0395\u03a1\u0393\u0395\u0399\u0391\u03a3 \u039a\u0391\u0399 \u03a6\u03a5\u03a3\u0399\u039a\u03a9\u039d \u03a0\u039f\u03a1\u03a9\u039d",
            "\u03a4\u0395\u03a7\u039d\u0399\u039a\u0397 \u0395\u039a\u039c\u0395\u03a4\u0391\u039b\u039b\u0395\u03a5\u03a3\u0397 \u0395\u039b\u0391\u03a6\u03a1\u03a9\u039d \u0391\u0395\u03a1\u039f\u03a0\u039b\u0391\u039d\u03a9\u039d \u0394.\u03a7",
            "\u03a0\u039f\u039b\u03a5\u0395\u0398\u039d\u0395\u0399\u03a3 \u039c\u039f\u03a1\u03a6\u03a9\u03a4\u0399\u039a\u0395\u03a3 \u03a3\u03a5\u039c\u03a6\u03a9\u039d\u0399\u0395\u03a3",
            "\u0395\u039a\u03a0\u0391\u0399\u0394\u0395\u03a5\u03a3\u0397 \u039b.\u03a3",
            "\u03a0\u03a1\u039f\u03a3\u03a4\u0391\u03a3\u0399\u0391 \u0395\u039b\u0395\u03a5\u0398\u0395\u03a1\u039f\u03a5 \u0391\u039d\u03a4\u0391\u0393\u03a9\u039d\u0399\u03a3\u039c\u039f\u03a5",
            "\u0395\u0398\u039d\u0399\u039a\u0397 \u0395\u03a0\u0399\u03a4\u03a1\u039f\u03a0\u0397 \u0394\u0399\u0395\u0398\u039d\u039f\u03a5\u03a3 \u0395\u039c\u03a0\u039f\u03a1\u0399\u039a\u039f\u03a5 \u0395\u03a0\u0399\u039c\u0395\u039b\u0397\u03a4\u0397\u03a1\u0399\u039f\u03a5",
            "\u039f\u03a1\u0393\u0391\u039d\u0399\u03a3\u039c\u039f\u03a3",
            "\u03a4\u0395\u039b\u03a9\u039d\u0395\u0399\u0391\u039a\u0395\u03a3 \u03a0\u0391\u03a1\u0391\u039a\u0391\u03a4\u0391\u0398\u0397\u039a\u0395\u03a3",
            "\u0395\u039b\u0395\u0393\u03a7\u039f\u03a3 \u039f\u03a1\u0393\u0391\u039d\u0399\u03a3\u039c\u03a9\u039d \u039a\u039f\u0399\u039d\u03a9\u039d\u0399\u039a\u0397\u03a3 \u03a0\u039f\u039b\u0399\u03a4\u0399\u039a\u0397\u03a3",
            "\u0395\u039d\u03a9\u03a3\u0395\u0399\u03a3 \u0391\u03a0\u039f\u03a3\u03a4\u03a1\u0391\u03a4\u03a9\u039d \u0391\u039e\u0399\u03a9\u039c\u0391\u03a4\u0399\u039a\u03a9\u039d \u0395\u039d\u039f\u03a0\u039b\u03a9\u039d \u0394\u03a5\u039d\u0391\u039c\u0395\u03a9\u039d",
            "\u03a6\u03a5\u039b\u039b\u0391 \u03a0\u039f\u0399\u039f\u03a4\u0397\u03a4\u0391\u03a3 \u0391\u039e\u0399\u03a9\u039c\u0391\u03a4\u0399\u039a\u03a9\u039d \u03a0.\u039d",
            "\u0399\u039d\u03a3\u03a4\u0399\u03a4\u039f\u03a5\u03a4\u039f \u0393\u0395\u03a9\u039b\u039f\u0393\u0399\u039a\u03a9\u039d \u039a\u0391\u0399 \u039c\u0395\u03a4\u0391\u039b\u039b\u0395\u03a5\u03a4\u0399\u039a\u03a9\u039d \u0395\u03a1\u0395\u03a5\u039d\u03a9\u039d",
            "\u039b\u0391\u039f\u0393\u03a1\u0391\u03a6\u0399\u039a\u039f \u039a\u0391\u0399 \u0395\u0398\u039d\u039f\u039b\u039f\u0393\u0399\u039a\u039f \u039c\u039f\u03a5\u03a3\u0395\u0399\u039f \u039c\u0391\u039a\u0395\u0394\u039f\u039d\u0399\u0391\u03a3 - \u0398\u03a1\u0391\u039a\u0397\u03a3",
            "\u03a0\u03a1\u03a9\u03a4\u0395\u03a3 \u03a5\u039b\u0395\u03a3 \u03a4\u0391\u03a0\u0397\u03a4\u039f\u03a5\u03a1\u0393\u0399\u0391\u03a3",
            "\u03a0\u0391\u039d\u0395\u03a0\u0399\u03a3\u03a4\u0397\u039c\u0399\u039f \u039a\u03a1\u0397\u03a4\u0397\u03a3",
            "\u039a\u03a9\u0394\u0399\u039a\u0391\u03a3 \u039f\u0394\u0399\u039a\u0397\u03a3 \u039a\u03a5\u039a\u039b\u039f\u03a6\u039f\u03a1\u0399\u0391\u03a3",
            "\u03a6\u0391\u03a1\u039c\u0391\u039a\u0395\u03a5\u03a4\u0399\u039a\u0397 \u03a0\u0395\u03a1\u0399\u0398\u0391\u039b\u03a8\u0397",
            "\u039c\u0395\u039b\u0395\u03a4\u0395\u03a3 \u03a0\u03a1\u039f\u0393\u03a1\u0391\u039c\u039c\u0391\u03a4\u039f\u03a3 \u0394\u0397\u039c\u039f\u03a3\u0399\u03a9\u039d \u0395\u03a0\u0395\u039d\u0394\u03a5\u03a3\u0395\u03a9\u039d",
            "\u0395\u03a0\u0399\u0394\u039f\u03a3\u0397 \u0394\u0399\u0391 \u03a4\u039f\u03a5 \u03a4\u0391\u03a7\u03a5\u0394\u03a1\u039f\u039c\u0395\u0399\u039f\u03a5",
            "\u03a0\u0391\u039d\u0395\u03a0\u0399\u03a3\u03a4\u0397\u039c\u0399\u039f \u0398\u03a1\u0391\u039a\u0397\u03a3",
            "\u0397\u0398\u0399\u039a\u0395\u03a3 \u0391\u039c\u039f\u0399\u0392\u0395\u03a3",
            "\u0394\u0397\u039c\u039f\u03a3\u0399\u0391 \u039a\u03a4\u0397\u039c\u0391\u03a4\u0391 \u03a3\u03a4\u0397 \u0394\u03a9\u0394\u0395\u039a\u0391\u039d\u0397\u03a3\u039f",
            "\u03a3\u03a5\u039c\u0392\u0391\u03a3\u0395\u0399\u03a3 \u0394\u0399\u039a\u0391\u03a3\u03a4\u0399\u039a\u0397\u03a3 \u0391\u039d\u03a4\u0399\u039b\u0397\u03a8\u0395\u03a9\u03a3",
            "\u03a0\u0395\u03a1\u0399\u039f\u03a1\u0399\u03a3\u039c\u039f\u0399 \u0391\u039b\u0399\u0395\u0399\u0391\u03a3",
            "\u03a0\u03a5\u03a1\u0397\u039d\u0399\u039a\u0395\u03a3 \u0395\u0393\u039a\u0391\u03a4\u0391\u03a3\u03a4\u0391\u03a3\u0395\u0399\u03a3",
            "\u03a9\u03a1\u0395\u03a3 \u0395\u03a1\u0393\u0391\u03a3\u0399\u0391\u03a3 \u03a0\u03a1\u039f\u03a3\u03a9\u03a0\u0399\u039a\u039f\u03a5 \u0391\u03a5\u03a4\u039f\u039a\u0399\u039d\u0397\u03a4\u03a9\u039d",
            "\u0395\u0393\u0393\u03a1\u0391\u03a6\u0395\u03a3, \u0395\u039e\u0395\u03a4\u0391\u03a3\u0395\u0399\u03a3, \u0391\u039d\u0391\u039b\u03a5\u03a4\u0399\u039a\u0391 \u03a0\u03a1\u039f\u0393\u03a1\u0391\u039c\u039c\u0391\u03a4\u0391",
            "\u0394\u0399\u039a\u0391\u0399\u03a9\u039c\u0391\u03a4\u0391 \u03a4\u0395\u039b\u03a9\u039d\u0395\u0399\u0391\u039a\u03a9\u039d \u0395\u03a1\u0393\u0391\u03a3\u0399\u03a9\u039d",
            "\u03a4\u0391\u039c\u0395\u0399\u039f \u0391\u03a3\u03a6\u0391\u039b\u0399\u03a3\u0395\u03a9\u03a3 \u0391\u03a5\u03a4\u039f\u039a\u0399\u039d\u0397\u03a4\u0399\u03a3\u03a4\u03a9\u039d (\u03a4.\u03a3.\u0391.)",
            "\u03a4\u0397\u039b\u0395\u03a6\u03a9\u039d\u0399\u039a\u039f\u03a3 \u039a\u0391\u039d\u039f\u039d\u0399\u03a3\u039c\u039f\u03a3",
            "\u03a6\u039f\u03a1\u039f\u039b\u039f\u0393\u0399\u0391 \u0391\u03a3\u03a6\u0391\u039b\u0399\u03a3\u03a4\u03a1\u03a9\u039d",
            "\u0394\u0399\u0395\u0398\u039d\u0397\u03a3 \u03a5\u0394\u03a1\u039f\u0393\u03a1\u0391\u03a6\u0399\u039a\u039f\u03a3 \u039f\u03a1\u0393\u0391\u039d\u0399\u03a3\u039c\u039f\u03a3",
            "\u0395\u03a0\u0391\u03a1\u03a7\u0399\u0395\u03a3",
            "\u0391\u0393\u03a1\u039f\u03a4. \u0391\u03a0\u039f\u039a\u0391\u03a4\u0391\u03a3\u03a4\u0391\u03a3\u0397 \u03a0\u03a1\u039f\u03a3\u03a6\u03a5\u0393\u03a9\u039d",
            "\u0393\u0395\u039d\u0399\u039a\u0391 \u0393\u0399\u0391 \u03a4\u0391 \u0398\u0395\u0391\u03a4\u03a1\u0391",
            "\u03a3\u03a5\u039c\u0392\u0391\u03a3\u0395\u0399\u03a3 \u0394\u0399\u03a9\u039e\u0395\u03a9\u03a3 \u039b\u0391\u0398\u03a1\u0395\u039c\u03a0\u039f\u03a1\u0399\u039f\u03a5",
            "\u039c\u0397\u03a7\u0391\u039d\u0395\u03a3 \u03a0\u03a1\u039f\u03a0\u039b\u0397\u03a1\u03a9\u039c\u0397\u03a3 \u03a4\u0395\u039b\u03a9\u039d",
            "\u039f\u03a1\u0393\u0391\u039d\u0399\u03a3\u039c\u039f\u03a3 \u039a\u03a1\u0391\u03a4\u0399\u039a\u03a9\u039d \u0398\u0395\u0391\u03a4\u03a1\u03a9\u039d",
            "\u039a\u0395\u039d\u03a4\u03a1\u039f \u0397\u039b\u0395\u039a\u03a4\u03a1\u039f\u039d\u0399\u039a\u039f\u03a5 \u03a5\u03a0\u039f\u039b\u039f\u0393\u0399\u03a3\u03a4\u039f\u03a5 \u039a\u039f\u0399\u039d\u03a9\u039d\u0399\u039a\u03a9\u039d \u03a5\u03a0\u0397\u03a1\u0395\u03a3\u0399\u03a9\u039d",
            "\u03a6\u039f\u03a1\u039f\u03a3 \u03a0\u03a1\u039f\u03a3\u03a4\u0399\u0398\u0395\u039c\u0395\u039d\u0397\u03a3 \u0391\u039e\u0399\u0391\u03a3",
            "\u03a4\u0391\u039c\u0395\u0399\u0391 \u0391\u03a1\u03a9\u0393\u0397\u03a3 \u03a4\u03a4\u03a4. \u03a5\u03a0\u0391\u039b\u039b\u0397\u039b\u03a9\u039d",
            "\u03a3\u03a9\u039c\u0391 \u039f\u03a1\u039a\u03a9\u03a4\u03a9\u039d \u0395\u039b\u0395\u0393\u039a\u03a4\u03a9\u039d \u039b\u039f\u0393\u0399\u03a3\u03a4\u03a9\u039d (\u03a3.\u039f.\u0395.\u039b.), \u0395\u03a0\u0399\u03a4\u03a1\u039f\u03a0\u0397 \u039b\u039f\u0393\u0399\u03a3\u03a4\u0399\u039a\u0397\u03a3 \u03a4\u03a5\u03a0\u039f\u03a0\u039f\u0399\u0397\u03a3\u0397\u03a3 \u039a\u0391\u0399 \u0395\u039b\u0395\u0393\u03a7\u03a9\u039d (\u0395.\u039b.\u03a4.\u0395.)",
            "\u0391\u0393\u03a1\u039f\u03a4\u0399\u039a\u0391 \u039d\u0397\u03a0\u0399\u039f\u03a4\u03a1\u039f\u03a6\u0395\u0399\u0391",
            "\u03a3\u03a7\u0395\u0394\u0399\u039f \u03a0\u039f\u039b\u0395\u03a9\u03a3 \u0391\u0398\u0397\u039d\u03a9\u039d \u03a0\u0395\u0399\u03a1\u0391\u0399\u03a9\u03a3",
            "\u039c\u0399\u03a3\u0398\u03a9\u03a3\u0395\u0399\u03a3 \u0391\u039a\u0399\u039d\u0397\u03a4\u03a9\u039d \u039f.\u0394.\u0395.\u03a0",
            "\u0395\u039b\u0395\u0393\u03a7\u039f\u03a3 \u03a3\u03a0\u039f\u03a1\u039f\u03a0\u0391\u03a1\u0391\u0393\u03a9\u0393\u0397\u03a3",
            "\u0391\u039c\u03a5\u039d\u03a4\u0399\u039a\u0395\u03a3 \u03a0\u0395\u03a1\u0399\u039f\u03a7\u0395\u03a3 \u039a\u0391\u0399 \u039d. \u039f\u03a7\u03a5\u03a1\u0391",
            "\u039f\u0394\u039f\u0399\u03a0\u039f\u03a1\u0399\u039a\u0391",
            "\u03a0\u039f\u03a1\u039f\u0399 \u039f\u03a1\u0393\u0391\u039d\u0399\u03a3\u039c\u03a9\u039d \u03a4\u039f\u03a5\u03a1\u0399\u03a3\u039c\u039f\u03a5",
            "\u0394\u0399\u0395\u0398\u039d\u0395\u03a3 \u0394\u0399\u039a\u0391\u03a3\u03a4\u0397\u03a1\u0399\u039f",
            "\u039f\u0399\u039a\u039f\u039d\u039f\u039c\u0399\u039a\u0397 \u039c\u0395\u03a1\u0399\u039c\u039d\u0391 \u0395\u039d\u039f\u03a0\u039b\u03a9\u039d \u0394\u03a5\u039d\u0391\u039c\u0395\u03a9\u039d",
            "\u0393\u0395\u039d\u0399\u039a\u039f \u039d\u039f\u03a3\u039f\u039a\u039f\u039c\u0395\u0399\u039f \u0395\u039c\u03a0\u039f\u03a1\u0399\u039a\u039f\u03a5 \u039d\u0391\u03a5\u03a4\u0399\u039a\u039f\u03a5",
            "\u039d\u039f\u039c\u0399\u039a\u0397 \u0392\u039f\u0397\u0398\u0395\u0399\u0391 \u03a3\u0395 \u03a0\u039f\u039b\u0399\u03a4\u0395\u03a3 \u03a7\u0391\u039c\u0397\u039b\u039f\u03a5 \u0395\u0399\u03a3\u039f\u0394\u0397\u039c\u0391\u03a4\u039f\u03a3",
            "\u03a3\u03a5\u039c\u0392\u039f\u039b\u0391\u0399\u039f\u0393\u03a1\u0391\u03a6\u0399\u039a\u039f\u0399 \u03a3\u03a5\u039b\u039b\u039f\u0393\u039f\u0399",
            "\u03a5\u03a0\u039f\u03a5\u03a1\u0393\u0395\u0399\u039f \u03a3\u03a4\u03a1\u0391\u03a4\u0399\u03a9\u03a4\u0399\u039a\u03a9\u039d",
            "\u03a0\u03a1\u039f\u03a3\u03a9\u03a0\u0399\u039a\u039f \u0395.\u039c.\u03a0",
            "\u03a5\u03a0\u039f\u03a5\u03a1\u0393\u0395\u0399\u039f \u0395\u03a1\u0393\u0391\u03a3\u0399\u0391\u03a3",
            "\u0391\u0393\u039f\u039d\u0395\u03a3 \u0393\u03a1\u0391\u039c\u039c\u0395\u03a3",
            "\u039c\u039f\u039d\u039f\u03a0\u03a9\u039b\u0399\u039f \u03a0\u0395\u03a4\u03a1\u0395\u039b\u0391\u0399\u039f\u03a5",
            "\u03a0\u03a1\u039f\u039b\u0397\u03a8\u0397 \u03a1\u03a5\u03a0\u0391\u039d\u03a3\u0397\u03a3 \u03a4\u0397\u03a3 \u0398\u0391\u039b\u0391\u03a3\u03a3\u0391\u03a3",
            "\u03a7\u03a9\u03a1\u0399\u039a\u0397 \u0394\u0399\u039a\u0391\u0399\u039f\u0394\u039f\u03a3\u0399\u0391 \u03a4\u0395\u039b\u03a9\u039d\u0395\u0399\u0391\u039a\u03a9\u039d \u0391\u03a1\u03a7\u03a9\u039d",
            "\u0395\u03a0\u0391\u0393\u0393\u0395\u039b\u039c\u0391\u03a4\u0399\u039a\u0391 \u03a3\u03a9\u039c\u0391\u03a4\u0395\u0399\u0391",
            "\u03a5\u03a0\u0397\u03a1\u0395\u03a3\u0399\u0391 \u0391\u0393\u03a1\u039f\u03a4\u0399\u039a\u0397\u03a3 \u0391\u03a3\u03a6\u0391\u039b\u0395\u0399\u0391\u03a3",
            "\u0391\u039e\u0399\u039f\u03a0\u039f\u0399\u0397\u03a3\u0397 \u0395\u039a\u039a\u039b\u0397\u03a3\u0399\u0391\u03a3\u03a4\u0399\u039a\u0397\u03a3 \u03a0\u0395\u03a1\u0399\u039f\u03a5\u03a3\u0399\u0391\u03a3",
            "\u0395\u039c\u03a0\u039f\u03a1\u0399\u039a\u039f\u0399 \u0391\u039d\u03a4\u0399\u03a0\u03a1\u039f\u03a3\u03a9\u03a0\u039f\u0399",
            "\u0395\u039d\u03a9\u03a3\u0395\u0399\u03a3 \u0395\u03a6\u0395\u0394\u03a1\u03a9\u039d \u0391\u039e\u0399\u03a9\u039c\u0391\u03a4\u0399\u039a\u03a9\u039d",
            "\u0391\u03a4\u0395\u039b\u0395\u0399\u0395\u03a3 \u03a5\u03a0\u0395\u03a1 \u03a4\u0397\u03a3 \u0392\u0399\u039f\u039c\u0397\u03a7\u0391\u039d\u0399\u0391\u03a3",
            "\u039b\u039f\u0393\u0399\u03a3\u03a4\u0399\u039a\u039f \u0395\u0399\u0394\u0399\u039a\u03a9\u039d \u03a4\u0391\u039c\u0395\u0399\u03a9\u039d \u039d.\u03a0.\u0394.\u0394",
            "\u03a3\u03a5\u039c\u0392\u0391\u03a3\u0397 \u0393\u0399\u0391 \u0394\u0395\u0399\u0393\u039c\u0391\u03a4\u0391 \u039a\u039b\u03a0",
            "\u0395\u03a1\u0393\u039f\u039b\u0397\u03a0\u03a4\u0395\u03a3 \u0394\u0397\u039c\u039f\u03a3\u0399\u03a9\u039d \u0395\u03a1\u0393\u03a9\u039d",
            "\u0395\u03a0\u0391\u039d\u0395\u03a0\u039f\u0399\u039a\u0399\u03a3\u039c\u039f\u03a3 \u03a0\u0391\u03a1\u0391\u039c\u0395\u0398\u039f\u03a1\u0399\u03a9\u039d \u03a0\u0395\u03a1\u0399\u039f\u03a7\u03a9\u039d",
            "\u03a6\u0391\u03a1\u0399\u039a\u0391 \u03a4\u0395\u039b\u0397",
            "\u039b\u0391\u03a4\u039f\u039c\u0395\u0399\u0391 \u039c\u0391\u03a1\u039c\u0391\u03a1\u03a9\u039d",
            "\u03a0\u039f\u03a3\u039f\u03a3\u03a4\u039f \u03a3\u03a5\u039c\u039c\u0395\u03a4\u039f\u03a7\u0397\u03a3 \u0391\u03a3\u03a6\u0391\u039b\u0399\u03a3\u039c\u0395\u039d\u03a9\u039d",
            "\u0391\u03a3\u03a6\u0391\u039b\u0395\u0399\u0391 \u0391\u039d\u0398\u03a1\u03a9\u03a0\u0399\u039d\u0397\u03a3 \u0396\u03a9\u0397\u03a3 \u03a3\u03a4\u0397 \u0398\u0391\u039b\u0391\u03a3\u03a3\u0391",
            "\u039f\u03a1\u0393\u0391\u039d\u0399\u039a\u039f\u0399 \u039d\u039f\u039c\u039f\u0399 \u03a0\u0395\u03a1\u0399 \u03a6\u03a5\u039b\u0391\u039a\u03a9\u039d",
            "\u039b\u0391\u0398\u03a1\u0395\u039c\u03a0\u039f\u03a1\u0399\u0391",
            "\u0391\u03a3\u03a6\u0391\u039b\u0399\u03a3\u03a4\u0399\u039a\u0395\u03a3 \u0394\u0399\u0391\u03a4\u0391\u039e\u0395\u0399\u03a3 \u0393\u0395\u039d\u0399\u039a\u0391",
            "\u0395\u0399\u03a3\u0391\u0393\u03a9\u0393\u0397 \u03a7\u039b\u03a9\u03a1\u0399\u039a\u039f\u03a5 \u039a\u0391\u039b\u0399\u039f\u03a5",
            "\u0399\u039d\u03a3\u03a4\u0399\u03a4\u039f\u03a5\u03a4\u039f \u0393\u0395\u03a9\u03a0\u039f\u039d\u0399\u039a\u03a9\u039d \u0395\u03a0\u0399\u03a3\u03a4\u0397\u039c\u03a9\u039d",
            "\u0395\u03a0\u0399\u0394\u039f\u039c\u0391 \u03a0\u0391\u03a3\u03a7\u0391 - \u03a7\u03a1\u0399\u03a3\u03a4\u039f\u03a5\u0393\u0395\u039d\u039d\u03a9\u039d",
            "\u0393\u0395\u03a9\u03a1\u0393\u0399\u039a\u039f\u0399 \u03a3\u03a5\u039d\u0395\u03a4\u0391\u0399\u03a1\u0399\u03a3\u039c\u039f\u0399 \u0391\u039b\u039b\u0397\u039b\u0391\u03a3\u03a6\u0391\u039b\u0395\u0399\u0391\u03a3",
            "\u039f\u03a1\u0393\u0391\u039d\u0399\u03a3\u039c\u039f\u03a3 \u03a6\u039f\u03a1\u039f\u039b\u039f\u0393\u0399\u039a\u03a9\u039d \u0394\u0399\u039a\u0391\u03a3\u03a4\u0397\u03a1\u0399\u03a9\u039d",
            "\u0395\u03a0\u0399\u0394\u039f\u03a3\u0397",
            "\u0399\u0394\u03a1\u03a5\u039c\u0391 \u039a\u03a1\u0391\u03a4\u0399\u039a\u03a9\u039d \u03a5\u03a0\u039f\u03a4\u03a1\u039f\u03a6\u0399\u03a9\u039d",
            "\u03a5\u0393\u0395\u0399\u039f\u039d\u039f\u039c\u0399\u039a\u039f\u03a3 \u039a\u0391\u039d\u039f\u039d\u0399\u03a3\u039c\u039f\u03a3 \u0391\u0395\u03a1\u039f\u03a5\u0393\u0395\u0399\u039f\u039d\u039f\u039c\u0395\u0399\u03a9\u039d",
            "\u039f\u03a6\u0395\u0399\u039b\u0395\u03a3 \u03a0\u03a1\u039f\u03a3 \u03a4\u039f \u0394\u0397\u039c\u039f\u03a3\u0399\u039f",
            "\u03a0\u03a1\u0391\u039a\u03a4\u039f\u03a1\u0395\u0399\u0391 \u0395\u0399\u0394\u0397\u03a3\u0395\u03a9\u039d",
            "\u0395\u039b\u0395\u0393\u03a7\u039f\u03a3 \u039a\u0391\u0399 \u0395\u03a0\u039f\u03a0\u03a4\u0395\u0399\u0391 \u039e\u0395\u039d\u039f\u0394\u039f\u03a7\u0395\u0399\u03a9\u039d \u039a\u039b\u03a0",
            "\u039a\u039f\u0399\u039d\u0391 \u03a4\u0391\u039c\u0395\u0399\u0391 \u0395\u039a\u039c\u0395\u03a4\u0391\u039b\u039b\u0395\u03a5\u03a3\u0395\u03a9\u03a3 \u039b\u0395\u03a9\u03a6\u039f\u03a1\u0395\u0399\u03a9\u039d (\u039a.\u03a4.\u0395.\u039b.)",
            "\u039a\u0391\u03a4\u03a9\u03a4\u0391\u03a4\u0391 \u039f\u03a1\u0399\u0391 \u039c\u0399\u03a3\u0398\u03a9\u039d \u039a\u0391\u0399 \u0397\u039c\u0395\u03a1\u039f\u039c\u0399\u03a3\u0398\u0399\u03a9\u039d",
            "\u03a3\u03a5\u039d\u03a4\u0397\u03a1\u0397\u03a4\u0399\u039a\u0397 \u039a\u0391\u03a4\u0391\u03a3\u03a7\u0395\u03a3\u0397 \u03a0\u039b\u039f\u0399\u03a9\u039d",
            "\u03a5\u03a0\u0397\u03a1\u0395\u03a3\u0399\u0391 \u03a0\u03a1\u039f\u03a3\u03a4\u0391\u03a3\u0399\u0391\u03a3 \u0395\u03a1\u0393\u0391\u0396\u039f\u039c\u0395\u039d\u03a9\u039d \u03a3\u03a4\u0397\u039d \u0391\u039b\u039b\u039f\u0394\u0391\u03a0\u0397",
            "\u0395\u03a5\u03a1\u03a9\u03a0\u0391\u0399\u039a\u039f\u03a3 \u039f\u03a1\u0393\u0391\u039d\u0399\u03a3\u039c\u039f\u03a3 \u03a0\u03a5\u03a1\u0397\u039d\u0399\u039a\u03a9\u039d \u0395\u03a1\u0395\u03a5\u039d\u03a9\u039d",
            "\u0392\u0399\u0392\u039b\u0399\u0391 \u0393\u0395\u03a9\u03a1\u0393\u0399\u039a\u03a9\u039d \u03a3\u03a5\u039d\u0395\u03a4\u0391\u0399\u03a1\u0399\u03a3\u039c\u03a9\u039d",
            "\u03a0\u039f\u039b\u0399\u03a4\u0399\u039a\u0395\u03a3 \u039a\u0391\u0399 \u03a3\u03a4\u03a1\u0391\u03a4\u0399\u03a9\u03a4\u0399\u039a\u0395\u03a3 \u03a3\u03a5\u039d\u03a4\u0391\u039e\u0395\u0399\u03a3",
            "\u039c\u0395\u03a4\u0391\u03a4\u03a1\u039f\u03a0\u0397 \u039c\u0395\u03a4\u039f\u03a7\u03a9\u039d \u03a3\u0395 \u039f\u039d\u039f\u039c\u0391\u03a3\u03a4\u0399\u039a\u0395\u03a3",
            "\u0395\u0399\u0394\u0399\u039a\u039f\u0399 \u03a6\u03a1\u039f\u03a5\u03a1\u039f\u0399",
            "\u03a5\u03a0\u0397\u03a1\u0395\u03a3\u0399\u0391 \u0395\u0398\u039d\u0399\u039a\u0397\u03a3 \u0391\u03a3\u03a6\u0391\u039b\u0395\u0399\u0391\u03a3",
            "\u03a1\u03a5\u0398\u039c\u0399\u03a3\u03a4\u0399\u039a\u039f\u03a3 \u03a6\u039f\u03a1\u039f\u03a3",
            "\u039b\u0399\u039c\u0391\u039d\u0399 \u0397\u03a1\u0391\u039a\u039b\u0395\u0399\u039f\u03a5 \u039a\u03a1\u0397\u03a4\u0397\u03a3 \u039a\u0391\u0399",
            "\u0395\u039a\u039a\u039b\u0397\u03a3\u0399\u0391\u03a3\u03a4\u0399\u039a\u0395\u03a3 \u03a5\u03a0\u039f\u03a4\u03a1\u039f\u03a6\u0399\u0395\u03a3",
            "\u03a6\u039f\u03a1\u039f\u039b\u039f\u0393\u0399\u0391 \u039f\u0399\u039d\u039f\u03a5",
            "\u0394\u0399\u0395\u0398\u039d\u0397\u03a3 \u03a5\u0393\u0395\u0399\u039f\u039d\u039f\u039c\u0399\u039a\u0397 \u03a3\u03a5\u039c\u0392\u0391\u03a3\u0397 \u0391\u0395\u03a1\u039f\u039d\u0391\u03a5\u03a4\u0399\u039b\u0399\u0391\u03a3",
            "\u03a4\u0391\u039c\u0395\u0399\u039f \u0391\u03a1\u03a9\u0393\u0397\u03a3 \u03a5\u03a0\u0391\u039b\u039b\u0397\u039b\u03a9\u039d",
            "\u039a\u039f\u0399\u039d\u03a9\u039d\u0399\u039a\u0397 \u0391\u03a3\u03a6\u0391\u039b\u0399\u03a3\u0397 \u0391\u0393\u03a1\u039f\u03a4\u03a9\u039d",
            "\u039a\u03a5\u03a1\u039f\u03a3 \u03a3\u03a5\u039c\u0392\u039f\u039b\u0391\u0399\u039f\u0393\u03a1\u0391\u03a6\u0399\u039a\u03a9\u039d \u03a0\u03a1\u0391\u039e\u0395\u03a9\u039d",
            "\u03a6\u039f\u03a1\u039f\u039b\u039f\u0393\u0399\u0391 \u03a5\u03a0\u0395\u03a1\u0391\u039e\u0399\u0391\u03a3 \u0391\u039a\u0399\u039d\u0397\u03a4\u03a9\u039d",
            "\u039d\u0397\u03a0\u0399\u0391\u0393\u03a9\u0393\u0395\u0399\u0391",
            "\u0395\u039a\u0398\u0395\u039c\u0391\u03a4\u0391 \u039a\u0391\u0399 \u0394\u0395\u0399\u0393\u039c\u0391\u03a4\u0391",
            "\u03a5\u0393\u0395\u0399\u039f\u039d\u039f\u039c\u0399\u039a\u039f \u03a3\u03a9\u039c\u0391 \u0391\u0395\u03a1\u039f\u03a0\u039f\u03a1\u0399\u0391\u03a3",
            "\u03a0\u039b\u0397\u03a1\u03a9\u039c\u0397 \u039c\u0399\u03a3\u0398\u03a9\u039d \u039a\u0391\u0399 \u0397\u039c\u0395\u03a1\u039f\u039c\u0399\u03a3\u0398\u0399\u03a9\u039d",
            "\u039a\u03a9\u0394\u0399\u039a\u0391\u03a3 \u03a6\u039f\u03a1\u039f\u039b\u039f\u0393\u0399\u0391\u03a3 \u039a\u0391\u03a0\u039d\u039f\u03a5",
            "\u039f\u03a1\u0399\u0391",
            "\u0394\u0399\u039a\u0391\u0399\u039f\u03a3\u03a4\u0391\u03a3\u0399\u0391 \u03a3\u0395\u0399\u03a3\u039c\u039f\u03a0\u0391\u0398\u03a9\u039d, \u03a0\u03a5\u03a1\u039f\u03a0\u0391\u0398\u03a9\u039d, \u03a0\u03a1\u039f\u03a3\u03a6\u03a5\u0393\u03a9\u039d \u039a\u039b\u03a0",
            "\u03a7\u03a1\u0395\u0397 \u039a\u039b\u0397\u03a1\u039f\u039d\u039f\u039c\u0399\u03a9\u039d",
            "\u03a0\u03a1\u039f\u03a3\u03a9\u03a0\u0399\u039a\u039f\u039d \u0399\u0394\u03a1\u03a5\u039c\u0391\u03a4\u03a9\u039d \u03a0\u0391\u0399\u0394\u0399\u039a\u0397\u03a3 \u03a0\u03a1\u039f\u03a3\u03a4\u0391\u03a3\u0399\u0391\u03a3",
            "\u039c\u0399\u03a3\u0398\u03a9\u03a3\u0395\u0399\u03a3 \u039a\u0391\u0399 \u0391\u0393\u039f\u03a1\u0395\u03a3",
            "\u03a0\u0391\u039b\u0391\u0399\u039f\u03a4\u0395\u03a1\u0391\u0399 \u0395\u039a\u039a\u0391\u0398\u0391\u03a1\u0399\u03a3\u0395\u0399\u03a3",
            "\u039f\u0399\u039a\u039f\u039d\u039f\u039c\u0399\u039a\u0397 \u0391\u03a0\u039f\u039a\u0391\u03a4\u0391\u03a3\u03a4\u0391\u03a3\u0397 \u0391\u0393\u03a1\u039f\u03a4\u03a9\u039d",
            "\u0391\u03a0\u0391\u039b\u039b\u039f\u03a4\u03a1\u0399\u03a9\u03a3\u0395\u0399\u03a3 \u0393\u0399\u0391 \u0394\u0397\u039c\u039f\u03a4\u0399\u039a\u0391 \u039a\u0391\u0399 \u039a\u039f\u0399\u039d\u039f\u03a4\u0399\u039a\u0391 \u0395\u03a1\u0393\u0391",
            "\u039c\u0397\u03a4\u03a1\u03a9\u039f \u0391\u0393\u03a1\u039f\u03a4\u03a9\u039d",
            "\u039a\u0391\u039d\u039f\u039d\u0399\u03a3\u039c\u039f\u03a3 \u0394\u0399\u0395\u03a5\u039a\u039f\u039b\u03a5\u039d\u03a3\u0395\u03a9\u039d",
            "\u039a\u03a1\u0391\u03a4\u0399\u039a\u039f \u0395\u03a1\u0393\u039f\u03a3\u03a4\u0391\u03a3\u0399\u039f \u0391\u0395\u03a1\u039f\u03a0\u039b\u0391\u039d\u03a9\u039d",
            "\u0395\u03a0\u0391\u0393\u0393\u0395\u039b\u039c\u0391\u03a4\u0399\u039a\u0391 \u0395\u039d\u0394\u0395\u0399\u039a\u03a4\u0399\u039a\u0391",
            "\u0391\u03a5\u0398\u0391\u0399\u03a1\u0395\u03a4\u0395\u03a3 \u039a\u0391\u03a4\u0391\u03a3\u039a\u0395\u03a5\u0395\u03a3",
            "\u0395\u0393\u039a\u0391\u03a4\u0391\u039b\u0395\u039b\u0395\u0399\u039c\u039c\u0395\u039d\u0395\u03a3 \u0395\u039a\u03a4\u0391\u03a3\u0395\u0399\u03a3",
            "\u03a5\u03a0\u039f\u03a5\u03a1\u0393\u0395\u0399\u039f \u0394\u0397\u039c\u039f\u03a3\u0399\u03a9\u039d \u0384\u0395\u03a1\u0393\u03a9\u039d",
            "\u03a0\u03a1\u039f\u039d\u039f\u0399\u0391 \u0392. \u0395\u039b\u039b\u0391\u0394\u039f\u03a3",
            "\u0394\u0399\u039a\u0391\u03a3\u03a4\u0399\u039a\u039f \u0395\u039d\u03a3\u0397\u039c\u039f - \u0391\u0393\u03a9\u0393\u039f\u03a3\u0397\u039c\u039f",
            "\u03a4\u0391\u03a7\u03a5\u0394\u03a1\u039f\u039c\u0399\u039a\u0397 \u0391\u039d\u03a4\u0391\u03a0\u039f\u039a\u03a1\u0399\u03a3\u0397",
            "\u0395\u03a3\u03a9\u03a4\u0395\u03a1\u0399\u039a\u0397 \u039d\u039f\u039c\u039f\u0398\u0395\u03a3\u0399\u0391",
            "\u03a6\u039f\u03a1\u039f\u039b\u039f\u0393\u0399\u0391 \u03a4\u03a3\u0399\u0393\u0391\u03a1\u039f\u03a7\u0391\u03a1\u03a4\u039f\u03a5",
            "\u039f\u03a1\u0393\u0391\u039d\u0399\u039a\u0395\u03a3 \u0398\u0395\u03a3\u0395\u0399\u03a3 \u0391\u039e\u0399\u03a9\u039c\u0391\u03a4\u0399\u039a\u03a9\u039d",
            "\u039c\u0391\u0399\u0395\u03a5\u03a4\u0399\u039a\u0397 \u03a0\u0395\u03a1\u0399\u0398\u0391\u039b\u03a8\u0397",
            "\u0391\u0394\u0395\u0399\u0395\u03a3 \u03a3\u03a4\u03a1\u0391\u03a4\u0399\u03a9\u03a4\u0399\u039a\u03a9\u039d",
            "\u039f\u03a1\u0393\u0391\u039d\u0399\u039a\u0395\u03a3 \u0394\u0399\u0391\u03a4\u0391\u039e\u0395\u0399\u03a3 \u0395\u039b\u039b\u0397\u039d\u0399\u039a\u0397\u03a3 \u0391\u03a3\u03a4\u03a5\u039d\u039f\u039c\u0399\u0391\u03a3",
            "\u03a0\u039f\u0399\u039d\u0399\u039a\u039f\u03a3 \u039a\u0391\u0399 \u03a0\u0395\u0399\u0398\u0391\u03a1\u03a7\u0399\u039a\u039f\u03a3 \u039a\u03a9\u0394\u0399\u039a\u0391\u03a3",
            "\u0391\u039d\u03a5\u03a0\u039f\u03a4\u0391\u039a\u03a4\u039f\u0399",
            "\u0394\u0399\u0395\u03a5\u0398\u03a5\u039d\u03a3\u0397 \u03a4\u0395\u039b\u03a9\u039d\u0395\u0399\u03a9\u039d \u0398\u0395\u03a3\u03a3\u0391\u039b\u039f\u039d\u0399\u039a\u0397\u03a3",
            "\u03a0\u0395\u03a1\u0399\u03a6\u0395\u03a1\u0395\u0399\u0395\u03a3 \u039b\u0399\u039c\u0395\u039d\u0399\u039a\u03a9\u039d \u0391\u03a1\u03a7\u03a9\u039d",
            "\u0391\u03a3\u03a6\u0391\u039b\u0399\u03a3\u0397 \u039a\u0391\u0399 \u0395\u0399\u03a3\u03a0\u03a1\u0391\u039e\u0397 \u03a0\u039f\u03a1\u03a9\u039d \u03a4.\u0395.\u0392.\u0395",
            "\u03a3\u0399\u0394\u0397\u03a1\u039f\u03a3",
            "\u0393\u0395\u039d\u0399\u039a\u0397 \u0393\u03a1\u0391\u039c\u039c\u0391\u03a4\u0395\u0399\u0391 \u0395\u039c\u03a0\u039f\u03a1\u0399\u039f\u03a5",
            "\u0394\u0399\u0391\u03a7\u0395\u0399\u03a1\u0399\u03a3\u0397 \u0399\u03a3\u03a1\u0391\u0397\u039b\u0399\u03a4\u0399\u039a\u03a9\u039d \u03a0\u0395\u03a1\u039f\u03a5\u03a3\u0399\u03a9\u039d",
            "\u039b\u0399\u03a0\u039f\u03a4\u0391\u039e\u0399\u0391",
            "\u0392\u0391\u03a1\u0395\u0391 \u039a\u0391\u0399 \u0391\u039d\u0398\u03a5\u0393\u0399\u0395\u0399\u039d\u0391 \u0395\u03a0\u0391\u0393\u0393\u0395\u039b\u039c\u0391\u03a4\u0391",
            "\u0395\u0399\u0394\u0399\u039a\u039f \u03a4\u0391\u039c\u0395\u0399\u039f \u039c\u0397\u03a7\u0391\u039d\u0397\u039c\u0391\u03a4\u03a9\u039d",
            "\u039b\u0395\u03a9\u03a6\u039f\u03a1\u0395\u0399\u0391 \u03a0\u0395\u03a1\u0399\u039f\u03a7\u0397\u03a3 \u03a0\u03a1\u03a9\u03a4\u0395\u03a5\u039f\u03a5\u03a3\u0391\u03a3",
            "\u0391\u039d\u0391\u039c\u039f\u03a1\u03a6\u03a9\u03a4\u0399\u039a\u0391 \u039a\u0391\u03a4\u0391\u03a3\u03a4\u0397\u039c\u0391\u03a4\u0391",
            "\u03a5\u0393\u0395\u0399\u039f\u039d\u039f\u039c\u0399\u039a\u039f \u03a3\u03a9\u039c\u0391",
            "\u039f\u03a1\u0393\u0391\u039d\u0399\u03a3\u039c\u039f\u03a3 \u03a5\u03a0\u039f\u03a5\u03a1\u0393\u0395\u0399\u039f\u03a5 \u0395\u03a1\u0393\u0391\u03a3\u0399\u0391\u03a3",
            "\u0394\u0399\u03a9\u03a1\u03a5\u0393\u0391 \u039a\u039f\u03a1\u0399\u039d\u0398\u039f\u03a5",
            "\u03a0\u0395\u03a1\u0399\u0398\u0391\u039b\u03a8\u0397 \u03a6\u03a5\u039c\u0391\u03a4\u0399\u039a\u03a9\u039d \u0391\u03a3\u03a6\u0391\u039b\u0399\u03a3\u039c\u0395\u039d\u03a9\u039d",
            "\u039a\u039f\u0399\u039d\u03a9\u039d\u0399\u039a\u039f\u03a3 \u0395\u039b\u0395\u0393\u03a7\u039f\u03a3 \u0394\u0399\u039f\u0399\u039a\u0397\u03a3\u0397\u03a3 - \u0391\u039d\u03a4\u0399\u0393\u03a1\u0391\u03a6\u0395\u0399\u039f\u039a\u03a1\u0391\u03a4\u0399\u039a\u0391 \u039c\u0395\u03a4\u03a1\u0391 -\u0395\u039a\u039a\u0391\u0398\u0391\u03a1\u0399\u03a3\u0397 \u0391\u03a1\u03a7\u0395\u0399\u03a9\u039d",
            "\u0392\u0399\u0392\u039b\u0399\u0391 \u03a5\u03a0\u039f\u0398\u0395\u03a3\u0395\u03a9\u039d \u0395\u039a\u039f\u03a5\u03a3\u0399\u0391\u03a3 \u0394\u0399\u039a\u0391\u0399\u039f\u0394\u039f\u03a3\u0399\u0391\u03a3",
            "\u0396\u0391\u03a7\u0391\u03a1\u0397",
            "\u0392\u039f\u03a1\u0395\u0399\u039f\u0391\u03a4\u039b\u0391\u039d\u03a4\u0399\u039a\u0397 \u0391\u039c\u03a5\u039d\u03a4\u0399\u039a\u0397 \u039f\u03a1\u0393\u0391\u039d\u03a9\u03a3\u0397 (\u039d.\u0391.\u03a4.\u039f)",
            "\u03a4\u0391\u039c\u0395\u0399\u039f \u03a3\u03a5\u039d\u03a4\u0391\u039e\u0395\u03a9\u039d \u03a0\u03a1\u039f\u03a3\u03a9\u03a0\u0399\u039a\u039f\u03a5 \u0395\u03a4\u0391\u0399\u03a1\u0395\u0399\u0391\u03a3 \u0393\u0395\u039d\u0399\u039a\u03a9\u039d \u0391\u03a0\u039f\u0398\u0397\u039a\u03a9\u039d",
            "\u039d\u039f\u039c\u0399\u039a\u0397 \u039a\u0391\u03a4\u0391\u03a3\u03a4\u0391\u03a3\u0397 \u03a0\u03a1\u039f\u03a3\u03a6\u03a5\u0393\u03a9\u039d",
            "\u0394\u0399\u039a\u0391\u03a3\u03a4\u0397\u03a1\u0399\u039f \u039b\u0395\u0399\u03a9\u039d",
            "\u0394\u0399\u0395\u0398\u039d\u0397\u03a3 \u039f\u03a1\u0393\u0391\u039d\u03a9\u03a3\u0397 \u0395\u03a1\u0393\u0391\u03a3\u0399\u0391\u03a3",
            "\u03a0\u03a1\u039f\u039c\u0397\u0398\u0395\u0399\u0395\u03a3\u2013\u039c\u0399\u03a3\u0398\u03a9\u03a3\u0395\u0399\u03a3\u2013\u0395\u03a1\u0393\u0391 \u039f.\u0393.\u0391",
            "\u03a0\u0395\u03a1\u0399\u0398\u0391\u039b\u03a8\u0397 \u03a0\u03a1\u039f\u03a3\u03a9\u03a0\u0399\u039a\u039f\u03a5 \u039f.\u0393.\u0391",
            "\u03a7\u039f\u03a1\u0397\u0393\u0397\u03a3\u0397 \u0394\u0391\u039d\u0395\u0399\u03a9\u039d \u0391\u03a0\u039f \u03a4.\u03a0. \u039a\u0391\u0399 \u0394\u0391\u039d\u0395\u0399\u03a9\u039d",
            "\u03a4\u0395\u039b\u039f\u03a3 \u0395\u03a0\u0399\u03a4\u0397\u0394\u0395\u03a5\u039c\u0391\u03a4\u039f\u03a3",
            "\u0395\u039b\u0395\u03a5\u0398\u0395\u03a1\u0391 \u03a4\u0395\u039b\u03a9\u039d\u0395\u0399\u0391\u039a\u0391 \u03a3\u03a5\u0393\u039a\u03a1\u039f\u03a4\u0397\u039c\u0391\u03a4\u0391",
            "\u03a6\u039f\u03a1\u039f\u039b\u039f\u0393\u0399\u039a\u0391 \u039a\u0399\u039d\u0397\u03a4\u03a1\u0391 \u03a3\u03a5\u0393\u03a7\u03a9\u039d\u0395\u03a5\u03a3\u0395\u03a9\u03a3 \u0397 \u039c\u0395\u03a4\u0391\u03a4\u03a1\u039f\u03a0\u0397\u03a3 \u0395\u03a0\u0399\u03a7\u0395\u0399\u03a1\u0397\u03a3\u0395\u03a9\u039d",
            "\u039a\u0391\u03a4\u0391\u03a3\u03a4\u0391\u03a4\u0399\u039a\u0395\u03a3 \u0394\u0399\u0391\u03a4\u0391\u039e\u0395\u0399\u03a3 T.E.B.E",
            "\u039d\u0391\u03a5\u03a4\u0399\u039a\u039f \u0395\u03a0\u0399\u039c\u0395\u039b\u0397\u03a4\u0397\u03a1\u0399\u039f",
            "\u03a0\u03a1\u039f\u03a3\u03a9\u03a0\u0399\u039a\u039f \u03a5.\u0395.\u039d",
            "\u039b\u0395\u0399\u03a4\u039f\u03a5\u03a1\u0393\u039f\u0399 \u039c\u0395\u03a3\u0397\u03a3 \u0395\u039a\u03a0\u0391\u0399\u0394\u0395\u03a5\u03a3\u0397\u03a3",
            "\u039a\u039f\u0399\u039d\u039f\u03a0\u03a1\u0391\u039e\u0399\u0391 \u0393\u0395\u03a9\u03a1\u0393\u0399\u039a\u03a9\u039d \u03a3\u03a5\u039d\u0395\u03a4\u0391\u0399\u03a1\u0399\u03a3\u039c\u03a9\u039d",
            "\u03a4\u0391\u039c\u0395\u0399\u039f \u0391\u03a3\u03a6\u0391\u039b\u0399\u03a3\u0395\u03a9\u03a3 \u0395\u03a0\u0399\u03a7\u0395\u0399\u03a1\u0397\u039c\u0391\u03a4\u0399\u03a9\u039d \u039a\u0399\u039d\u0397\u039c\u0391\u03a4\u039f\u0393\u03a1\u0391\u03a6\u039f\u03a5",
            "\u0392\u039f\u03a3\u039a\u039f\u03a4\u039f\u03a0\u039f\u0399",
            "\u0395\u03a0\u0399\u03a4\u039f\u039a\u0399\u0391 \u03a4\u03a1\u0391\u03a0\u0395\u0396\u03a9\u039d",
            "\u039a\u0391\u03a0\u039d\u0399\u039a\u039f\u0399 \u039f\u03a1\u0393\u0391\u039d\u0399\u03a3\u039c\u039f\u0399",
            "\u03a3\u03a4\u0391\u0398\u039c\u039f\u0399 \u0391\u03a5\u03a4\u039f\u039a\u0399\u039d\u0397\u03a4\u03a9\u039d",
            "\u0395\u03a5\u039b\u039f\u0393\u0399\u0391",
            "\u03a0\u0395\u03a1\u0399\u03a6\u0395\u03a1\u0395\u0399\u0391\u039a\u0395\u03a3 \u03a5\u03a0\u0397\u03a1\u0395\u03a3\u0399\u0395\u03a3 \u03a5\u03a0\u039f\u03a5\u03a1\u0393\u0395\u0399\u039f\u03a5 \u0392\u0399\u039f\u039c\u0397\u03a7\u0391\u039d\u0399\u0391\u03a3",
            "\u03a4\u0391\u039c\u0395\u0399\u039f \u0391\u0395\u03a1\u039f\u03a0\u039f\u03a1\u0399\u039a\u0397\u03a3 \u0391\u039c\u03a5\u039d\u0391\u03a3",
            "\u039f\u03a1\u0393\u0391\u039d\u0399\u03a3\u039c\u039f\u03a3 \u039a\u0395\u039d\u03a4\u03a1\u0399\u039a\u0397\u03a3 \u03a5\u03a0\u0397\u03a1\u0395\u03a3\u0399\u0391\u03a3",
            "\u03a4\u0391\u039c\u0395\u0399\u039f \u0395\u03a1\u0393\u0391\u03a3\u0399\u0391\u03a3 \u0397\u0398\u039f\u03a0\u039f\u0399\u03a9\u039d",
            "\u03a4\u0395\u039b\u03a9\u039d\u0399\u03a3\u039c\u039f\u03a3 \u0395\u0399\u0394\u03a9\u039d \u0391\u03a4\u039f\u039c\u0399\u039a\u0397\u03a3 \u03a7\u03a1\u0397\u03a3\u0395\u03a9\u03a3",
            "\u03a6\u039f\u03a1\u039f\u039b\u039f\u0393\u0399\u0391 \u03a0\u03a1\u039f\u03a3\u039f\u0394\u039f\u03a5 \u0391\u03a0\u039f \u03a0\u039b\u039f\u0399\u0391",
            "\u0394\u0399\u039f\u0399\u039a\u0397\u03a4\u0399\u039a\u0397 \u0394\u0399\u0391\u0399\u03a1\u0395\u03a3\u0397\u03a3",
            "\u039f\u03a1\u0393\u0391\u039d\u0399\u03a3\u039c\u039f\u03a3 \u0391\u03a5\u03a4\u039f\u039a\u0399\u039d\u0397\u03a4\u039f\u0394\u03a1\u039f\u039c\u0399\u03a9\u039d \u0395\u039b\u039b\u0391\u0394\u039f\u03a3 (\u039f.\u0391.\u0395.)",
            "\u0395\u0398\u039d\u0399\u039a\u039f \u039a\u0395\u039d\u03a4\u03a1\u039f \u0391\u039c\u0395\u03a3\u0397\u03a3 \u0392\u039f\u0397\u0398\u0395\u0399\u0391\u03a3 (\u0395.\u039a.\u0391.\u0392.)",
            "\u0393\u039d\u03a9\u039c\u039f\u0394\u039f\u03a4\u0399\u039a\u039f \u03a3\u03a5\u039c\u0392\u039f\u03a5\u039b\u0399\u039f \u039f\u0399\u039a\u039f\u039d\u039f\u039c\u0399\u039a\u0397\u03a3 \u0391\u039d\u0391\u03a0\u03a4\u03a5\u039e\u0397\u03a3",
            "\u0394\u0399\u0391\u0398\u0397\u039a\u0397",
            "\u0391\u0393\u03a9\u0393\u0395\u03a3 \u0394\u0399\u0391\u03a4\u03a1\u039f\u03a6\u0397\u03a3",
            "\u03a6\u0391\u03a1\u039c\u0391\u039a\u0395\u03a5\u03a4\u0399\u039a\u039f\u0399 \u03a3\u03a5\u039b\u039b\u039f\u0393\u039f\u0399",
            "\u03a4\u0391\u039c\u0395\u0399\u039f \u03a3\u03a5\u039d\u03a4\u0391\u039e\u0395\u03a9\u039d \u039a\u0391\u0399  \u0395\u03a0\u0399\u039a\u039f\u03a5\u03a1\u0399\u039a\u0397\u03a3 \u0391\u03a3\u03a6\u0391\u039b\u0399\u03a3\u0395\u03a9\u03a3 \u03a0\u03a1\u039f\u03a3\u03a9\u03a0\u0399\u039a\u039f\u03a5 \u0393\u0395\u03a9\u03a1\u0393\u0399\u039a\u03a9\u039d \u03a3\u03a5\u039d\u0395\u03a4\u0391\u0399\u03a1\u0399\u03a3\u03a4\u0399\u039a\u03a9\u039d \u039f\u03a1\u0393\u0391\u039d\u03a9\u03a3\u0395\u03a9\u039d (\u03a4.\u03a3.\u0395.\u0391.\u03a0.\u0393.\u03a3.\u039f)",
            "\u0395\u03a0\u0399\u0394\u039f\u039c\u0391\u03a4\u0391 \u0394\u0399\u0391\u03a6\u039f\u03a1\u0391",
            "\u03a0\u0395\u0399\u0398\u0391\u03a1\u03a7\u0399\u039a\u039f \u0394\u0399\u039a\u0391\u0399\u039f",
            "\u03a4\u0391\u039c\u0395\u0399\u039f \u0395\u03a0\u0399\u039a\u039f\u03a5\u03a1\u0399\u039a\u0397\u03a3 \u0391\u03a3\u03a6\u0391\u039b\u0399\u03a3\u0395\u03a9\u03a3 \u03a7\u0397\u039c\u0399\u039a\u03a9\u039d (\u03a4.\u0395.\u0391.\u03a7)",
            "\u03a0\u03a1\u039f\u0391\u0393\u03a9\u0393\u0395\u03a3 \u039a\u0391\u0399 \u03a0\u03a1\u039f\u03a3\u039f\u039d\u03a4\u0391 \u03a0\u03a5\u03a1\u039f\u03a3\u0392\u0395\u03a3\u03a4\u0399\u039a\u039f\u03a5 \u03a0\u03a1\u039f\u03a3\u03a9\u03a0\u0399\u039a\u039f\u03a5",
            "\u039f\u0394\u039f\u0399\u03a0\u039f\u03a1\u0399\u039a\u0391 \u0395\u039e\u039f\u0394\u0391 \u03a0\u03a1\u039f\u03a3\u03a9\u03a0\u0399\u039a\u039f\u03a5 \u03a3\u03a9\u039c\u0391\u03a4\u03a9\u039d \u0391\u03a3\u03a6\u0391\u039b\u0395\u0399\u0391\u03a3",
            "\u039d\u039f\u03a3\u0397\u039b\u0395\u03a5\u03a4\u0399\u039a\u0391 \u0399\u0394\u03a1\u03a5\u039c\u0391\u03a4\u0391 \u039a\u0391\u03a4\u2019 \u0399\u0394\u0399\u0391\u039d",
            "\u03a0\u03a1\u039f\u03a3\u03a4\u0391\u03a3\u0399\u0391 \u039a\u0391\u03a4\u0391 \u03a4\u0397\u03a3 \u03a6\u03a5\u039b\u039b\u039f\u039e\u0397\u03a1\u0391\u03a3",
            "\u039f\u03a1\u0393\u0391\u039d\u0399\u03a3\u039c\u039f\u03a3  \u03a4\u0391\u039c\u0395\u0399\u039f\u03a5  \u039d\u039f\u039c\u0399\u039a\u03a9\u039d",
            "\u03a0\u03a1\u0391\u03a4\u0397\u03a1\u0399\u0391 \u03a5\u0393\u03a1\u03a9\u039d \u039a\u0391\u03a5\u03a3\u0399\u039c\u03a9\u039d",
            "\u0398\u03a1\u0397\u03a3\u039a\u0395\u03a5\u03a4\u0399\u039a\u039f \u03a3\u03a9\u039c\u0391 \u0395\u039d\u039f\u03a0\u039b\u03a9\u039d \u0394\u03a5\u039d\u0391\u039c\u0395\u03a9\u039d",
            "\u0394\u0399\u0391\u0394\u0399\u039a\u0391\u03a3\u0399\u0391 \u0391\u039d\u0391\u0393\u039a\u0391\u03a3\u03a4\u0399\u039a\u03a9\u039d \u0391\u03a0\u0391\u039b\u039b\u039f\u03a4\u03a1\u0399\u03a9\u03a3\u0395\u03a9\u039d \u0391\u039a\u0399\u039d\u0397\u03a4\u03a9\u039d",
            "\u0394\u0399\u0395\u03a1\u039c\u0397\u039d\u0395\u0399\u03a3",
            "\u03a3\u03a7\u0395\u0394\u0399\u0391 \u0391\u039b\u039b\u03a9\u039d \u03a0\u039f\u039b\u0395\u03a9\u039d",
            "\u03a4\u0391\u039c\u0395\u0399\u039f \u0391\u039b\u039b\u0397\u039b\u039f\u0392\u039f\u0397\u0398\u0395\u0399\u0391\u03a3 \u03a3\u03a4\u03a1\u0391\u03a4\u0399\u03a9\u03a4\u0399\u039a\u03a9\u039d \u0391\u0395\u03a1\u039f\u03a0\u039f\u03a1\u0399\u0391\u03a3",
            "\u0397\u039c\u0395\u03a1\u039f\u039b\u039f\u0393\u0399\u039f \u039c\u0397\u03a7\u0391\u039d\u0397\u03a3",
            "\u039a\u0395\u039d\u03a4\u03a1\u039f \u0395\u039b\u039b\u0397\u039d\u0399\u039a\u0397\u03a3 \u0393\u039b\u03a9\u03a3\u03a3\u0391\u03a3",
            "\u03a9\u03a1\u0395\u03a3 \u0395\u03a1\u0393\u0391\u03a3\u0399\u0391\u03a3 \u03a3\u0395 \u0391\u03a1\u03a4\u039f\u03a0\u039f\u0399\u0395\u0399\u0391",
            "\u0393\u0395\u039d\u0399\u039a\u0397 \u0393\u03a1\u0391\u039c\u039c\u0391\u03a4\u0395\u0399\u0391",
            "\u039c\u0395\u03a4\u0391\u03a6\u03a1\u0391\u03a3\u03a4\u0399\u039a\u0391 \u0393\u03a1\u0391\u03a6\u0395\u0399\u0391",
            "\u03a0\u03a1\u039f\u0394\u0399\u0391\u0393\u03a1\u0391\u03a6\u0395\u03a3 \u039c\u0395\u039b\u0395\u03a4\u03a9\u039d",
            "\u03a3\u03a5\u039d\u03a4\u0391\u039e\u0395\u0399\u03a3 \u0398\u03a5\u039c\u0391\u03a4\u03a9\u039d \u0395\u0398\u039d\u0399\u039a\u0397\u03a3",
            "\u03a4\u0391\u039c\u0395\u0399\u039f \u03a0\u03a1\u039f\u039d\u039f\u0399\u0391\u03a3 \u03a3\u03a5\u039c\u0392\u039f\u039b\u0391\u0399\u039f\u0393\u03a1\u0391\u03a6\u03a9\u039d",
            "\u0399\u0391\u03a4\u03a1\u039f\u0394\u0399\u039a\u0391\u03a3\u03a4\u0399\u039a\u0397 \u0391\u039c\u039f\u0399\u0392\u0397",
            "\u0395\u03a6\u039f\u03a1\u0399\u0395\u03a3 \u039a\u0391\u03a0\u039d\u039f\u03a5 \u2013 \u039a\u0391\u03a0\u039d\u0395\u03a1\u0393\u039f\u03a3\u03a4\u0391\u03a3\u0399\u0391",
            "\u03a0\u039f\u0399\u039c\u039d\u0399\u039f\u03a3\u03a4\u0391\u03a3\u0399\u0391",
            "\u039a\u0395\u039d\u03a4\u03a1\u0391 \u0395\u03a1\u0395\u03a5\u039d\u0391\u03a3 - \u0395\u03a1\u0395\u03a5\u039d\u0397\u03a4\u0399\u039a\u0391 \u0399\u039d\u03a3\u03a4\u0399\u03a4\u039f\u03a5\u03a4\u0391",
            "\u03a4\u0391\u039c\u0395\u0399\u0391 \u03a0\u03a1\u039f\u039d\u039f\u0399\u0391\u03a3 \u0394\u0399\u039a\u0397\u0393\u039f\u03a1\u03a9\u039d",
            "\u039f\u0399\u039d\u039f\u03a0\u0391\u03a1\u0391\u0393\u03a9\u0393\u0397 \u03a3\u0391\u039c\u039f\u03a5",
            "\u0399\u039c\u0391\u03a4\u0399\u03a3\u039c\u039f\u03a3 \u03a0. \u039d\u0391\u03a5\u03a4\u0399\u039a\u039f\u03a5",
            "\u039c\u0397\u03a7\u0391\u039d\u0399\u039a\u039f\u0399,\u0391\u03a1\u03a7\u0399\u03a4\u0395\u039a\u03a4\u039f\u039d\u0395\u03a3,\u03a4\u039f\u03a0\u039f\u0393\u03a1\u0391\u03a6\u039f\u0399",
            "\u03a0\u0391\u039d\u03a4\u0395\u0399\u039f \u03a0\u0391\u039d\u0395\u03a0\u0399\u03a3\u03a4\u0397\u039c\u0399\u039f \u039a\u039f\u0399\u039d\u03a9\u039d\u0399\u039a\u03a9\u039d \u039a\u0391\u0399 \u03a0\u039f\u039b\u0399\u03a4\u0399\u039a\u03a9\u039d \u0395\u03a0\u0399\u03a3\u03a4\u0397\u039c\u03a9\u039d",
            "\u039d\u0395\u039f\u0399 \u03a7\u03a1\u0397\u039c\u0391\u03a4\u039f\u03a0\u0399\u03a3\u03a4\u03a9\u03a4\u0399\u039a\u039f\u0399 \u0398\u0395\u03a3\u039c\u039f\u0399",
            "\u03a5\u03a0\u0397\u03a1\u0395\u03a3\u0399\u0391 \u03a0\u039f\u039b\u0399\u03a4\u0399\u039a\u0397\u03a3 \u0391\u0395\u03a1\u039f\u03a0\u039f\u03a1\u0399\u0391\u03a3",
            "\u039f\u03a1\u0393\u0391\u039d\u0399\u03a3\u039c\u039f\u03a3 \u03a5\u03a0\u039f\u0398\u0397\u039a\u039f\u03a6\u03a5\u039b\u0391\u039a\u0395\u0399\u03a9\u039d",
            "\u0391\u03a4\u03a5\u03a7\u0397\u039c\u0391\u03a4\u0391 \u03a3\u0395 \u0394\u0397\u039c\u039f\u03a3\u0399\u0391 \u0395\u03a1\u0393\u0391",
            "\u0391\u03a1\u0395\u0399\u039f\u03a3 \u03a0\u0391\u0393\u039f\u03a3",
            "\u03a5\u03a0\u0391\u0393\u03a9\u0393\u0397 \u03a3\u0395 \u0391\u03a3\u03a6\u0391\u039b\u0399\u03a3\u0397 \u039a\u0391\u0399",
            "\u0394\u0399\u0395\u0398\u039d\u0395\u0399\u03a3 \u03a3\u0399\u0394\u0397\u03a1\u039f\u0394\u03a1\u039f\u039c\u0399\u039a\u0395\u03a3 \u039c\u0395\u03a4\u0391\u03a6\u039f\u03a1\u0395\u03a3\u0394\u0399\u0395\u03a5\u03a1\u03a9\u03a0\u0391\u0399\u039a\u039f \u03a3\u0399\u0394\u0397\u03a1\u039f\u0394\u03a1\u039f\u039c\u0399\u039a\u039f \u03a3\u03a5\u03a3\u03a4\u0397\u039c\u0391",
            "\u039f\u0399\u039a\u039f\u039d\u039f\u039c\u0399\u039a\u0397 \u0395\u03a0\u0399\u0398\u0395\u03a9\u03a1\u0397\u03a3\u0397 \u03a0. \u039d\u0391\u03a5\u03a4\u0399\u039a\u039f\u03a5",
            "\u0391\u039d\u0391\u03a0\u03a4\u03a5\u039e\u0399\u0391\u039a\u0397 \u039a\u0391\u0399 \u0392\u0399\u039f\u039c\u0397\u03a7\u0391\u039d\u0399\u039a\u0397 \u03a0\u039f\u039b\u0399\u03a4\u0399\u039a\u0397",
            "\u0392\u0395\u0392\u0391\u0399\u03a9\u03a3\u0397 \u039a\u0391\u0399 \u0395\u0399\u03a3\u03a0\u03a1\u0391\u039e\u0397 \u03a0\u039f\u0399\u039d\u0399\u039a\u03a9\u039d \u0395\u039e\u039f\u0394\u03a9\u039d",
            "\u039d\u0391\u03a5\u03a4\u0399\u039a\u039f \u03a7\u0397\u039c\u0395\u0399\u039f",
            "\u039b\u0391\u03a7\u0395\u0399\u0391",
            "\u03a4\u03a1\u039f\u03a7\u0399\u039f\u0394\u03a1\u039f\u039c\u039f\u0399 \u0391\u0398\u0397\u039d\u03a9\u039d \u2013 \u03a0\u0395\u0399\u03a1\u0391\u0399\u03a9\u03a3",
            "\u03a4\u0391\u039c\u0395\u0399\u039f  \u03a0\u03a1\u039f\u039d\u039f\u0399\u0391\u03a3 \u03a0\u03a1\u039f\u03a3\u03a9\u03a0\u0399\u039a\u039f\u03a5 \u0395\u03a4\u0391\u0399\u03a1\u0395\u0399\u03a9\u039d \u039b\u0399\u03a0\u0391\u03a3\u039c\u0391\u03a4\u03a9\u039d \u03a4\u0391.\u03a0.\u03a0.\u0395.\u039b",
            "\u0394\u0399\u0395\u03a5\u039a\u039f\u039b\u03a5\u039d\u03a3\u0395\u0399\u03a3 \u0393\u0399\u0391 \u0391\u039d\u039f\u0399\u039a\u039f\u0394\u039f\u039c\u0397\u03a3\u0397",
            "\u0391\u0393\u039f\u03a1\u0391\u03a0\u03a9\u039b\u0397\u03a3\u0399\u0391 \u039a\u0391\u03a0\u039d\u039f\u03a5",
            "\u03a0\u0395\u03a1\u0399 \u039f\u03a1\u03a9\u039d \u0395\u03a1\u0393\u0391\u03a3\u0399\u0391\u03a3 \u03a0\u03a1\u039f\u03a3\u03a9\u03a0\u0399\u039a\u039f\u03a5 \u0394\u0399\u0395\u0398\u039d\u03a9\u039d \u039c\u0395\u03a4\u0391\u03a6\u039f\u03a1\u03a9\u039d",
            "\u0391\u039b\u0399\u0395\u03a5\u03a4\u0399\u039a\u039f\u03a3 \u039a\u03a9\u0394\u0399\u039a\u0391\u03a3",
            "\u03a3\u03a5\u039c\u0392\u039f\u03a5\u039b\u0399\u0391 \u039a\u0391\u0399 \u0395\u03a0\u0399\u03a4\u03a1\u039f\u03a0\u0395\u03a3",
            "\u03a0\u0395\u03a1\u0399\u03a6\u0395\u03a1\u0395\u0399\u0391\u039a\u0395\u03a3 \u03a5\u03a0\u0397\u03a1\u0395\u03a3\u0399\u0395\u03a3 \u03a5\u03a0\u039f\u03a5\u03a1\u0393\u0395\u0399\u039f\u03a5 \u039f\u0399\u039a\u039f\u039d\u039f\u039c\u0399\u039a\u03a9\u039d",
            "\u03a3\u03a5\u039c\u0392\u0391\u03a3\u0395\u0399\u03a3 \u03a0\u0395\u03a1\u0399 \u0391\u03a3\u0395\u039c\u039d\u03a9\u039d \u0394\u0397\u039c\u039f\u03a3\u0399\u0395\u03a5\u039c\u0391\u03a4\u03a9\u039d",
            "\u0393\u0395\u03a9\u03a1\u0393\u0399\u039a\u039f\u0399 \u03a3\u03a4\u0391\u0398\u039c\u039f\u0399",
            "\u039d\u0391\u039e\u0399\u03a9\u03a4\u0399\u039a\u0397 \u03a3\u039c\u03a5\u03a1\u0399\u0394\u0391",
            "\u0391\u039d\u0391\u03a3\u03a4\u039f\u039b\u0397 \u03a0\u03a1\u039f\u03a3\u0395\u039b\u0395\u03a5\u03a3\u0395\u03a9\u03a3 \u0395\u03a6\u0395\u0394\u03a1\u03a9\u039d",
            "\u0395\u039a\u03a0\u0391\u0399\u0394\u0395\u03a5\u03a3\u0397 \u03a7\u03a9\u03a1\u039f\u03a6\u03a5\u039b\u0391\u039a\u0397\u03a3",
            "\u0391\u03a3\u03a6\u0391\u039b\u0399\u03a3\u0397 \u0395\u039e\u0391\u0393\u03a9\u0393\u0399\u039a\u03a9\u039d \u03a0\u0399\u03a3\u03a4\u03a9\u03a3\u0395\u03a9\u039d",
            "\u0398\u0395\u03a1\u0391\u03a0\u0391\u0399\u039d\u0399\u0394\u0395\u03a3 \u0391\u039d\u0391\u03a0\u0397\u03a1\u03a9\u039d \u03a0\u039f\u039b\u0395\u039c\u039f\u03a5",
            "\u0395\u03a0\u0399\u03a4\u03a1\u039f\u03a0\u0397 \u0391\u03a4\u039f\u039c\u0399\u039a\u0397\u03a3 \u0395\u039d\u0395\u03a1\u0393\u0395\u0399\u0391\u03a3",
            "\u039a\u0391\u039d\u039f\u039d\u0399\u03a3\u039c\u039f\u03a3 \u0391\u03a3\u03a4\u03a5\u039d\u039f\u039c\u0399\u0391\u03a3 \u03a0\u039f\u039b\u0395\u03a9\u039d",
            "\u03a6\u03a5\u039b\u039b\u0391 \u03a0\u039f\u0399\u039f\u03a4\u0397\u03a4\u0391\u03a3 \u03a5\u03a0\u0391\u039e\u0399\u03a9\u039c\u0391\u03a4\u0399\u039a\u03a9\u039d \u03a0.\u039d",
            "\u0395\u03a0\u0399\u0398\u0395\u03a9\u03a1\u0397\u03a3\u0395\u0399\u03a3 \u039a\u03a4\u0397\u039d\u0399\u0391\u03a4\u03a1\u0399\u039a\u0397\u03a3",
            "\u039c\u0395\u03a1\u0399\u039a\u0397 \u0391\u03a0\u0391\u03a3\u03a7\u039f\u039b\u0397\u03a3\u0397 - \u03a6\u0391\u03a3\u039f\u039d - \u03a4\u0397\u039b\u0395\u03a1\u0393\u0391\u03a3\u0399\u0391 \u039a\u0391\u03a4\u2019 \u039f\u0399\u039a\u039f\u039d \u0391\u03a0\u0391\u03a3\u03a7\u039f\u039b\u0397\u03a3\u0397",
            "\u0397\u039b\u0395\u039a\u03a4\u03a1\u0399\u039a\u0397 \u0395\u03a4\u0391\u0399\u03a1\u0395\u0399\u0391 \u0391\u0398\u0397\u039d\u03a9\u039d - \u03a0\u0395\u0399\u03a1\u0391\u0399\u03a9\u03a3",
            "\u03a0\u03a1\u039f\u039a\u0391\u03a4\u0391\u03a3\u039a\u0395\u03a5\u0391\u03a3\u039c\u0395\u039d\u0391\u0399 \u039f\u0399\u039a\u0399\u0391\u0399",
            "\u03a4\u03a1\u0391\u03a0\u0395\u0396\u0391 \u03a4\u0397\u03a3 \u0395\u039b\u039b\u0391\u0394\u039f\u03a3",
            "\u03a3\u03a5\u039c\u03a6\u03a9\u039d\u0399\u0395\u03a3 \u03a0\u03a1\u039f\u03a3\u03a4\u0391\u03a3\u0399\u0391\u03a3 \u03a4\u039f\u03a5 \u03a0\u0395\u03a1\u0399\u0392\u0391\u039b\u039b\u039f\u039d\u03a4\u039f\u03a3",
            "\u039b\u0399\u0393\u039d\u0399\u03a4\u0397\u03a3",
            "\u03a4\u0391\u039c\u0395\u0399\u039f \u0395\u03a0\u0391\u0393\u0393\u0395\u039b\u039c\u0391\u03a4\u0399\u039a\u0397\u03a3 \u0391\u03a3\u03a6\u0391\u039b\u0399\u03a3\u0397\u03a3 \u03a0\u03a1\u039f\u03a3\u03a9\u03a0\u0399\u039a\u039f\u03a5 \u0395\u039b\u03a4\u0391",
            "\u039c\u0395\u039b\u0395\u03a4\u0395\u03a3 \u03a4\u0395\u03a7\u039d\u0399\u039a\u03a9\u039d \u0395\u03a1\u0393\u03a9\u039d",
            "\u03a0\u039b\u0397\u03a1\u03a9\u039c\u0391\u03a4\u0391 \u0391\u0395\u03a1\u039f\u03a3\u039a\u0391\u03a6\u03a9\u039d",
            "\u0395\u039e\u0391\u0393\u03a9\u0393\u0397 \u03a3\u03a4\u0391\u03a6\u0399\u0394\u0391\u03a3",
            "\u03a4\u0391\u039c\u0395\u0399\u039f\u039d \u03a0\u03a1\u039f\u039d\u039f\u0399\u0391\u03a3 \u0394\u0397\u039c\u039f\u03a3\u0399\u03a9\u039d \u03a5\u03a0\u0391\u039b\u039b\u0397\u039b\u03a9\u039d",
            "\u0394\u0399\u0391\u03a7\u0395\u0399\u03a1\u0399\u03a3\u0397 \u03a0\u0395\u03a1\u0399\u039f\u03a5\u03a3\u0399\u0391\u03a3",
            "\u039f\u03a1\u0393\u0391\u039d\u0399\u039a\u039f\u0399 \u039d\u039f\u039c\u039f\u0399",
            "\u03a5\u03a0\u0397\u03a1\u0395\u03a3\u0399\u0395\u03a3 \u0391\u0399\u039c\u039f\u0394\u039f\u03a3\u0399\u0391\u03a3",
            "\u03a3\u03a9\u039c\u0391\u03a4\u0395\u0399\u0391 \u0394\u0397\u039c\u039f\u03a3\u0399\u03a9\u039d \u03a5\u03a0\u0391\u039b\u039b\u0397\u039b\u03a9\u039d",
            "\u03a0\u0395\u0396\u039f\u0394\u03a1\u039f\u039c\u0399\u0391",
            "\u0394\u0399\u0391\u0398\u0395\u03a3\u0397 \u0391\u03a0\u039f\u03a1\u03a1\u0399\u039c\u039c\u0391\u03a4\u03a9\u039d",
            "\u03a4\u03a1\u039f\u03a7\u0399\u039f\u0394\u03a1\u039f\u039c\u039f\u0399 \u0398\u0395\u03a3\u03a3\u0391\u039b\u039f\u039d\u0399\u039a\u0397\u03a3",
            "\u0393\u0395\u039d\u0399\u039a\u0397 \u0394\u0399\u0395\u03a5\u0398\u03a5\u039d\u03a3\u0397 \u0394\u0397\u039c\u039f\u03a3\u0399\u039f\u03a5 \u039b\u039f\u0393\u0399\u03a3\u03a4\u0399\u039a\u039f\u03a5",
            "\u03a1\u03a5\u039c\u039f\u03a5\u039b\u039a\u0391 - \u039b\u0391\u039d\u03a4\u0396\u0395\u03a3",
            "\u03a0\u0395\u03a4\u03a1\u0395\u039b\u0391\u0399\u039f\u0395\u0399\u0394\u0397",
            "\u0393\u0395\u039d\u0399\u039a\u0391 \u0391\u03a1\u03a7\u0395\u0399\u0391 \u03a4\u039f\u03a5 \u039a\u03a1\u0391\u03a4\u039f\u03a5\u03a3",
            "\u039a\u0391\u03a4\u0391\u03a3\u03a4\u0391\u03a4\u0399\u039a\u0395\u03a3 \u0394\u0399\u0391\u03a4\u0391\u039e\u0395\u0399\u03a3 \u039f.\u03a4.\u0395. - \u03a3\u03a7\u0395\u03a3\u0395\u0399\u03a3 \u039f.\u03a4.\u0395. \u039c\u0395 \u0391\u039b\u039b\u039f\u03a5\u03a3 \u03a0\u0391\u03a1\u039f\u03a7\u039f\u03a5\u03a3",
            "\u03a5\u03a0\u0397\u03a1\u0395\u03a3\u0399\u0391 \u0391\u03a5\u03a4\u039f\u039a\u0399\u039d\u0397\u03a4\u03a9\u039d",
            "\u0391\u039a\u0391\u0394\u0397\u039c\u0399\u0391 \u0391\u0398\u0397\u039d\u03a9\u039d",
            "\u039c\u039f\u039d\u039f\u03a0\u03a9\u039b\u0399\u039f \u0396\u0391\u03a7\u0391\u03a1\u0399\u039d\u0397\u03a3",
            "\u039f\u0399\u039a\u0399\u03a3\u03a4\u0399\u039a\u0395\u03a3 \u03a0\u0395\u03a1\u0399\u039f\u03a7\u0395\u03a3",
            "\u0391\u03a4\u0395\u039b\u0395\u0399\u0395\u03a3 \u03a5\u03a0\u0395\u03a1 \u03a4\u0397\u03a3 \u0391\u039b\u0399\u0395\u0399\u0391\u03a3",
            "\u0394\u0399\u0391\u03a6\u039f\u03a1\u0395\u03a3 \u0395\u039a\u03a4\u0391\u039a\u03a4\u0395\u03a3 \u03a6\u039f\u03a1\u039f\u039b\u039f\u0393\u0399\u0395\u03a3",
            "\u0392\u0399\u0392\u039b\u0399\u0391 \u0394\u0397\u039c\u03a9\u039d \u039a\u0391\u0399 \u039a\u039f\u0399\u039d\u039f\u03a4\u0397\u03a4\u03a9\u039d",
            "\u0395\u03a1\u0393\u0391\u03a4\u0399\u039a\u0391 \u0391\u03a4\u03a5\u03a7\u0397\u039c\u0391\u03a4\u0391",
            "\u039d\u039f\u03a3\u0397\u039b\u0395\u03a5\u03a4\u0395\u03a3",
            "\u03a3\u03a5\u039d\u0394\u0399\u039a\u0391\u039b\u0399\u03a3\u03a4\u0399\u039a\u0395\u03a3 \u0395\u039b\u0395\u03a5\u0398\u0395\u03a1\u0399\u0395\u03a3",
            "\u0395\u0398\u039d\u0399\u039a\u039f \u03a3\u03a5\u039c\u0392\u039f\u03a5\u039b\u0399\u039f \u0395\u039d\u0395\u03a1\u0393\u0395\u0399\u0391\u03a3",
            "\u03a4\u0391\u039c\u0395\u0399\u039f \u0395\u03a0\u0399\u039a\u039f\u03a5\u03a1\u0399\u039a\u0397\u03a3 \u0391\u03a3\u03a6\u0391\u039b\u0399\u03a3\u0395\u03a9\u03a3 \u0395\u03a1\u0393\u0391\u03a4\u039f\u03a4\u0395\u03a7\u039d\u0399\u03a4\u03a9\u039d \u03a5\u0391\u039b\u039f\u03a5\u03a1\u0393\u03a9\u039d",
            "\u0391\u0393\u03a9\u0393\u0395\u03a3 \u0391\u03a3\u03a6\u0391\u039b\u0399\u03a3\u03a4\u03a1\u03a9\u039d",
            "\u03a3\u03a9\u039c\u0391\u03a4\u0395\u039c\u03a0\u039f\u03a1\u0399\u0391 \u0393\u03a5\u039d\u0391\u0399\u039a\u03a9\u039d",
            "\u0391\u03a4\u0395\u039b\u0395\u0399\u0395\u03a3 \u0395\u03a1\u0393\u03a9\u039d \u0391\u039c\u03a5\u039d\u03a4\u0399\u039a\u039f\u03a5 \u03a0\u03a1\u039f\u0393\u03a1\u0391\u039c\u039c\u0391\u03a4\u039f\u03a3",
            "\u03a4\u0395\u03a7\u039d\u0399\u039a\u0397 \u0395\u039a\u03a0\u0391\u0399\u0394\u0395\u03a5\u03a3\u0397 \u0391\u039e\u0399\u03a9\u039c\u0391\u03a4\u0399\u039a\u03a9\u039d \u03a3\u0395 \u0391\u039d\u03a9\u03a4\u0391\u03a4\u0395\u03a3 \u03a3\u03a7\u039f\u039b\u0395\u03a3",
            "\u0394\u0399\u039a\u0391\u0399\u03a9\u039c\u0391\u03a4\u0391 \u039a\u0397\u03a1\u03a5\u039a\u03a9\u039d \u039a\u039b\u03a0",
            "\u0393\u0395\u039d\u0399\u039a\u0395\u03a3 \u0394\u0399\u0391\u03a4\u0391\u039e\u0395\u0399\u03a3 \u03a4\u0391\u039c\u0395\u0399\u039f\u03a5 \u039d\u039f\u039c\u0399\u039a\u03a9\u039d",
            "\u039d\u0391\u03a5\u03a4\u0395\u03a3 \u039a\u0391\u0399 \u039b\u0399\u039c\u0395\u039d\u039f\u03a6\u03a5\u039b\u0391\u039a\u0395\u03a3",
            "\u03a0\u0391\u039d\u0395\u03a0\u0399\u03a3\u03a4\u0397\u039c\u0399\u0391\u039a\u0397 \u03a3\u03a7\u039f\u039b\u0397 \u0391\u0393\u03a1\u0399\u039d\u0399\u039f\u03a5",
            "\u03a0\u039f\u039b\u03a5\u03a4\u0395\u03a7\u039d\u0399\u039a\u0397 \u03a3\u03a7\u039f\u039b\u0397",
            "\u039c\u0395\u0399\u03a9\u03a3\u0397 \u0395\u0399\u03a3\u03a6\u039f\u03a1\u03a9\u039d",
            "\u039a\u0395\u039d\u03a4\u03a1\u0391 \u039b\u0397\u03a8\u0395\u03a9\u03a3 \u03a4\u0399\u039c\u03a9\u039d \u03a3\u03a6\u0391\u0393\u0395\u0399\u03a9\u039d",
            "\u0391\u03a0\u039f\u0394\u0397\u039c\u0399\u0391 \u03a3\u03a4\u03a1\u0391\u03a4\u0395\u03a5\u03a3\u0399\u039c\u03a9\u039d",
            "\u03a4\u0391\u039c\u0395\u0399\u039f \u0395\u03a0\u0399\u039a\u039f\u03a5\u03a1\u0399\u039a\u0397\u03a3 \u0391\u03a3\u03a6\u0391\u039b\u0399\u03a3\u0395\u03a9\u03a3 \u03a0\u03a1\u039f\u039d\u039f\u0399\u0391\u03a3 \u039a\u0391\u0399 \u039a\u039f\u0399\u039d\u0397\u03a3 \u0394\u0399\u0391\u039d\u039f\u039c\u0397\u03a3 \u03a0\u03a9\u039b\u0397\u03a4\u03a9\u039d \u0392\u0395\u039d\u0396\u0399\u039d\u0397\u03a3 \u0391\u0398\u0397\u039d\u03a9\u039d - \u03a0\u0395\u0399\u03a1\u0391\u0399\u03a9\u03a3 \u039a\u0391\u0399 \u03a0\u0395\u03a1\u0399\u03a7\u03a9\u03a1\u03a9\u039d",
            "\u0399\u0391\u03a4\u03a1\u039f\u03a6\u0391\u03a1\u039c\u0391\u039a\u0395\u03a5\u03a4\u0399\u039a\u0397 \u03a0\u0395\u03a1\u0399\u0398\u0391\u039b\u03a8\u0397",
            "\u039d\u039f\u03a3\u0397\u039b\u0395\u03a5\u03a4\u0399\u039a\u0391 \u0399\u0394\u03a1\u03a5\u039c\u0391\u03a4\u0391",
            "\u0393\u0395\u039d\u0399\u039a\u0391 \u03a0\u0395\u03a1\u0399 \u039c\u039f\u03a5\u03a3\u0395\u0399\u03a9\u039d",
            "\u0391\u03a3\u03a6\u0391\u039b\u0395\u0399\u0391 \u039f\u03a7\u03a5\u03a1\u03a9\u039d \u0398\u0395\u03a3\u0395\u03a9\u039d",
            "\u0393\u0395\u03a9\u03a1\u0393\u0399\u039a\u0391 \u039c\u0397\u03a7\u0391\u039d\u0397\u039c\u0391\u03a4\u0391",
            "\u03a4\u0391\u039c\u0395\u0399\u0391 \u03a3\u03a5\u039d\u0395\u03a1\u0393\u0391\u03a3\u0399\u0391\u03a3",
            "\u0399\u0394\u0399\u03a9\u03a4\u0399\u039a\u0395\u03a3 \u039a\u039b\u0399\u039d\u0399\u039a\u0395\u03a3 \u039a\u0391\u0399 \u0395\u03a1\u0393\u0391\u03a3\u03a4\u0397\u03a1\u0399\u0391",
            "\u03a5\u0393\u0395\u0399\u039f\u039d\u039f\u039c\u0399\u039a\u0397 \u0395\u039e\u0395\u03a4\u0391\u03a3\u0397 \u0399\u03a0\u03a4\u0391\u039c\u0395\u039d\u03a9\u039d",
            "\u0394\u0399\u0391\u03a6\u039f\u03a1\u0395\u03a3 \u0391\u0395\u03a1\u039f\u03a0\u039f\u03a1\u0399\u039a\u0395\u03a3 \u03a3\u03a7\u039f\u039b\u0395\u03a3",
            "\u0393\u03a5\u039d\u0391\u0399\u039a\u0395\u03a3 \u039d\u039f\u03a3\u039f\u039a\u039f\u039c\u039f\u0399",
            "\u03a6\u039f\u0399\u03a4\u0397\u03a3\u0397, \u0392\u0391\u0398\u039c\u039f\u039b\u039f\u0393\u0399\u0391, \u0395\u039e\u0395\u03a4\u0391\u03a3\u0395\u0399\u03a3 \u039a\u039b\u03a0. \u0391.\u03a3.\u039a.\u03a4",
            "\u03a3\u0395\u0399\u03a3\u039c\u039f\u03a0\u039b\u0397\u039a\u03a4\u039f\u0399 \u0394\u0399\u0391\u03a6\u039f\u03a1\u039f\u0399",
            "\u039f\u03a1\u0393\u0391\u039d\u0399\u03a3\u039c\u039f\u03a3 \u03a5\u03a0\u039f\u03a5\u03a1\u0393\u0395\u0399\u039f\u03a5 \u0393\u0395\u03a9\u03a1\u0393\u0399\u0391\u03a3",
            "\u039a\u03a9\u0394\u0399\u039a\u039f\u03a0\u039f\u0399\u0397\u03a3\u0397 \u03a4\u0397\u03a3 \u039d\u039f\u039c\u039f\u0398\u0395\u03a3\u0399\u0391\u03a3",
            "\u039c\u0395\u03a4\u0391 \u03a4\u0397\u03a3 \u0393\u0391\u039b\u039b\u0399\u0391\u03a3",
            "\u0393\u0395\u03a9\u0393\u03a1\u0391\u03a6\u0399\u039a\u0397 \u03a5\u03a0\u0397\u03a1\u0395\u03a3\u0399\u0391 \u03a3\u03a4\u03a1\u0391\u03a4\u039f\u03a5",
            "\u0395\u0399\u0394\u0397 \u03a0\u0391\u03a1\u0391\u0394\u0399\u0394\u039f\u039c\u0395\u039d\u0391 \u03a3\u03a4\u0397\u039d \u0395\u039b\u0395\u03a5\u0398\u0395\u03a1\u0397 \u03a7\u03a1\u0397\u03a3\u0397",
            "\u039c\u039f\u039d\u039f\u03a0\u03a9\u039b\u0399\u039f \u03a3\u03a0\u0399\u03a1\u03a4\u03a9\u039d",
            "\u039a\u0391\u03a4\u0391\u03a3\u03a4\u0391\u03a4\u0399\u039a\u039f\u039d \u03a4.\u0391.\u039a.\u0395",
            "\u0395\u03a0\u0399\u039a\u039f\u03a5\u03a1\u0399\u039a\u039f \u03a4\u0391\u039c\u0395\u0399\u039f \u03a5\u03a0\u0391\u039b\u039b\u0397\u039b\u03a9\u039d \u0391\u03a3\u03a4\u03a5\u039d\u039f\u039c\u0399\u0391\u03a3 \u03a0\u039f\u039b\u0395\u03a9\u039d (\u0395.\u03a4.\u03a5.\u0391.\u03a0.)",
            "\u039c\u0399\u03a3\u0398\u039f\u0394\u039f\u03a3\u0399\u0391 \u0399\u0395\u03a1\u0395\u03a9\u039d \u2013 \u0395\u039d\u039f\u03a1\u0399\u0391\u039a\u0397 \u0395\u0399\u03a3\u03a6\u039f\u03a1\u0391",
            "\u03a5\u0393\u0395\u0399\u039f\u039d\u039f\u039c\u0399\u039a\u039f\u03a3 \u039a\u0391\u039d\u039f\u039d\u0399\u03a3\u039c\u039f\u03a3",
            "\u039d\u039f\u039c\u039f\u03a3 \u03a0\u0395\u03a1\u0399 \u039a\u03a4\u0397\u039c\u0391\u03a4\u0399\u039a\u03a9\u039d \u03a4\u03a1\u0391\u03a0\u0395\u0396\u03a9\u039d",
            "\u0394\u0399\u0395\u0398\u039d\u0397\u03a3 \u03a3\u03a5\u039c\u0392\u0391\u03a3\u0397 \u03a0\u0395\u03a1\u0399 \u03a5\u0394\u03a1\u0391\u03a5\u039b\u0399\u039a\u03a9\u039d \u0394\u03a5\u039d\u0391\u039c\u0395\u03a9\u039d",
            "\u0391\u039d\u0391\u03a0\u0397\u03a1\u039f\u0399 \u0391\u039e\u0399\u03a9\u039c\u0391\u03a4\u0399\u039a\u039f\u0399 \u039a\u0391\u0399 \u039f\u03a0\u039b\u0399\u03a4\u0395\u03a3 \u0395\u0399\u03a1\u0397\u039d\u0399\u039a\u0397\u03a3 \u03a0\u0395\u03a1\u0399\u039f\u0394\u039f\u03a5",
            "\u03a0\u039f\u0399\u039d\u0399\u039a\u0397 \u039a\u0391\u0399 \u03a0\u0395\u0399\u0398\u0391\u03a1\u03a7\u0399\u039a\u0397 \u0394\u03a9\u03a3\u0399\u0394\u0399\u039a\u0399\u0391 \u039b.\u03a3",
            "\u0394\u0391\u03a3\u0399\u039a\u039f \u03a0\u03a1\u039f\u03a3\u03a9\u03a0\u0399\u039a\u039f",
            "\u0391\u039f\u03a0\u039b\u0397 \u0398\u0397\u03a4\u0395\u0399\u0391-\u0391\u039d\u03a4\u0399\u03a1\u03a1\u0397\u03a3\u0399\u0395\u03a3 \u03a3\u03a5\u039d\u0395\u0399\u0394\u0397\u03a3\u0397\u03a3",
            "\u039d\u0395\u039f\u0399 \u03a0\u03a1\u039f\u03a3\u03a6\u03a5\u0393\u0395\u03a3",
            "\u03a4\u0395\u03a7\u039d\u0399\u039a\u0395\u03a3 \u03a5\u03a0\u0397\u03a1\u0395\u03a3\u0399\u0395\u03a3 \u03a3\u03a4\u03a1\u0391\u03a4\u039f\u03a5",
            "\u039c\u0395\u03a4\u039f\u03a7\u0399\u039a\u039f \u03a4\u0391\u039c\u0395\u0399\u039f \u03a0\u039f\u039b\u0399\u03a4\u0399\u039a\u03a9\u039d \u03a5\u03a0\u0391\u039b\u039b\u0397\u039b\u03a9\u039d",
            "\u03a0\u03a1\u039f\u03a3\u03a9\u03a0\u0399\u039a\u039f \u0399\u0394\u0399\u03a9\u03a4\u0399\u039a\u039f\u03a5 \u0394\u0399\u039a\u0391\u0399\u039f\u03a5",
            "\u039a\u03a9\u0394\u0399\u039a\u0391\u03a3 \u0391\u0393\u03a1\u039f\u03a4\u0399\u039a\u0397\u03a3 \u0391\u03a3\u03a6\u0391\u039b\u0395\u0399\u0391\u03a3",
            "\u039f\u03a1\u0393\u0391\u039d\u0399\u039a\u0395\u03a3 \u0394\u0399\u0391\u03a4\u0391\u039e\u0395\u0399\u03a3 \u0391\u03a0\u039f\u03a3\u03a4\u039f\u039b\u0399\u039a\u0397\u03a3 \u0394\u0399\u0391\u039a\u039f\u039d\u0399\u0391\u03a3",
            "\u03a5\u03a0\u039f\u03a5\u03a1\u0393\u0395\u0399\u039f \u0391\u0399\u0393\u0391\u0399\u039f\u03a5",
            "\u0393\u0391\u039c\u039f\u0399  \u0394\u03a9\u0394\u0395\u039a\u0391\u039d\u0397\u03a3\u039f\u03a5",
            "\u03a9\u03a1\u0395\u03a3 \u0395\u03a1\u0393\u0391\u03a3\u0399\u0391\u03a3 \u039a\u03a1\u0395\u039f\u03a0\u03a9\u039b\u0395\u0399\u03a9\u039d",
            "\u039a\u03a9\u0394\u0399\u039a\u0391\u03a3 \u03a4\u0395\u039b\u03a9\u039d \u03a7\u0391\u03a1\u03a4\u039f\u03a3\u0397\u039c\u039f\u03a5",
            "\u0394\u0395\u039b\u03a4\u0399\u039f \u0391\u039d\u03a9\u039d\u03a5\u039c\u03a9\u039d \u0395\u03a4\u0391\u0399\u03a1\u0395\u0399\u03a9\u039d",
            "\u0391\u03a1\u039c\u039f\u0394\u0399\u039f\u03a4\u0397\u03a4\u0391 \u039d\u039f\u039c\u0391\u03a1\u03a7\u0397 \u03a3\u0395 \u0395\u03a1\u0393\u0391\u03a4\u0399\u039a\u0391 \u0396\u0397\u03a4\u0397\u039c\u0391\u03a4\u0391",
            "\u03a4\u03a1\u039f\u03a6\u039f\u0394\u039f\u03a3\u0399\u0391 \u03a0. \u039d\u0391\u03a5\u03a4\u0399\u039a\u039f\u03a5",
            "\u03a3\u03a5\u039c\u03a6\u03a9\u039d\u0399\u0391 \u03a0\u0395\u03a1\u0399 \u0394\u0399\u03a0\u039b\u03a9\u039c\u0391\u03a4\u0399\u039a\u03a9\u039d \u03a3\u03a7\u0395\u03a3\u0395\u03a9\u039d",
            "\u0395\u03a6\u0395\u0394\u03a1\u039f\u0399 \u039a\u0391\u0399 \u0395\u03a0\u0399\u039a\u039f\u03a5\u03a1\u039f\u0399 \u0391\u039e\u0399\u03a9\u039c\u0391\u03a4\u0399\u039a\u039f\u0399 \u03a0.\u039d",
            "\u03a4\u039f\u03a5\u03a1\u0399\u03a3\u03a4\u0399\u039a\u0395\u03a3 \u0395\u03a0\u0399\u03a7\u0395\u0399\u03a1\u0397\u03a3\u0395\u0399\u03a3",
            "\u0394\u0399\u0395\u0398\u039d\u0395\u03a3 \u03a0\u039f\u0399\u039d\u0399\u039a\u039f \u0394\u0399\u039a\u0391\u03a3\u03a4\u0397\u03a1\u0399\u039f",
            "\u0394\u0399\u039f\u0399\u039a\u0397\u03a4\u0399\u039a\u0395\u03a3 \u03a0\u03a1\u0391\u039e\u0395\u0399\u03a3",
            "\u039d\u039f\u03a3\u039f\u039a\u039f\u039c\u0395\u0399\u0391 \u03a0\u039f\u039b\u0395\u039c\u0399\u039a\u039f\u03a5 \u039d\u0391\u03a5\u03a4\u0399\u039a\u039f\u03a5",
            "\u03a3\u03a5\u039c\u0392\u039f\u03a5\u039b\u0399\u039f \u03a7\u0391\u039b\u03a5\u0392\u0391",
            "\u03a4\u0395\u039c\u0391\u03a7\u0399\u03a3\u039c\u039f\u03a3 \u039a\u03a1\u0395\u0391\u03a4\u03a9\u039d",
            "\u0395\u039b\u0395\u0393\u03a7\u039f\u03a3 \u039a\u0391\u03a4\u039f\u03a7\u0397\u03a3 \u039f\u03a0\u039b\u03a9\u039d",
            "\u0391\u039d\u0391\u03a0\u03a1\u039f\u03a3\u0391\u03a1\u039c\u039f\u0393\u0395\u03a3 \u03a4\u0397\u03a3 \u0394\u03a1\u0391\u03a7\u039c\u0397\u03a3",
            "\u0395\u03a6\u039f\u0394\u0399\u0391\u03a3\u039c\u039f\u03a3 \u03a0\u039b\u039f\u0399\u03a9\u039d",
            "\u03a3\u0395\u0399\u03a3\u039c\u039f\u03a0\u039b\u0397\u039a\u03a4\u039f\u0399 \u0399\u039f\u039d\u0399\u03a9\u039d \u039d\u0397\u03a3\u03a9\u039d",
            "\u0394\u0397\u039c\u039f\u03a3\u0399\u0391 \u0395\u03a0\u0399\u03a7\u0395\u0399\u03a1\u0397\u03a3\u0397 \u039a\u0399\u039d\u0397\u03a4\u03a9\u039d \u0391\u039e\u0399\u03a9\u039d \u0391\u039d\u03a9\u039d\u03a5\u039c\u0397 \u0395\u03a4\u0391\u0399\u03a1\u0395\u0399\u0391 (\u0394.\u0395.\u039a.\u0391. \u0391.\u0395.)",
            "\u0395\u03a4\u0391\u0399\u03a1\u0395\u0399\u0391 \u2013 \u0395\u03a5\u03a1\u03a9\u03a0\u0391\u0399\u039a\u039f\u03a3 \u039f\u039c\u0399\u039b\u039f\u03a3",
            "\u0394\u0399\u0395\u03a5\u0398\u03a5\u039d\u03a3\u0397 \u0391\u039b\u0399\u0395\u0399\u0391\u03a3",
            "\u0395\u03a0\u0399\u039c\u0395\u039b\u0397\u03a4\u0397\u03a1\u0399\u039f \u03a4\u039f\u03a5\u03a1\u0399\u03a3\u03a4\u0399\u039a\u03a9\u039d \u039a\u0391\u03a4\u0391\u03a3\u03a4\u0397\u039c\u0391\u03a4\u03a9\u039d",
            "\u0394\u0399\u0395\u0398\u039d\u0395\u0399\u03a3 \u03a3\u03a5\u039c\u0392\u0391\u03a3\u0395\u0399\u03a3 \u0395\u039b\u0391\u0399\u039f\u039b\u0391\u0394\u039f\u03a5",
            "\u03a0\u03a4\u0397\u03a4\u0399\u039a\u0397 \u0399\u039a\u0391\u039d\u039f\u03a4\u0397\u03a4\u0391",
            "\u0395\u039a\u039a\u039b\u0397\u03a3\u0399\u0391\u03a3\u03a4\u0399\u039a\u0395\u03a3 \u03a3\u03a7\u039f\u039b\u0395\u03a3",
            "\u0394\u0399\u0391\u03a4\u0399\u039c\u0397\u03a3\u0397 \u0399\u0391\u03a4\u03a1\u0399\u039a\u03a9\u039d \u03a0\u03a1\u0391\u039e\u0395\u03a9\u039d",
            "\u0391\u0394\u0399\u039a\u0397\u039c\u0391\u03a4\u0391 \u03a4\u03a5\u03a0\u039f\u03a5",
            "\u0395\u039e\u0391\u039d\u0398\u0397\u039c\u0391\u03a4\u0399\u039a\u039f\u03a3 \u03a4\u03a5\u03a6\u039f\u03a3",
            "\u039f\u0399\u039a\u039f\u03a3 \u039d\u0391\u03a5\u03a4\u039f\u03a5",
            "\u039c\u0391\u03a3\u03a4\u0399\u03a7\u0391",
            "\u03a3\u03a5\u039b\u039b\u039f\u0393\u039f\u0399 \u039a\u0391\u0399 \u039f\u039c\u039f\u03a3\u03a0\u039f\u039d\u0394\u0399\u0391 \u0394\u0399\u039a\u0391\u03a3\u03a4\u0399\u039a\u03a9\u039d \u0395\u03a0\u0399\u039c\u0395\u039b\u0397\u03a4\u03a9\u039d",
            "\u0395\u039c\u03a0\u039f\u03a1\u0399\u039a\u0391 \u039a\u0391\u0399 \u0392\u0399\u039f\u039c\u0397\u03a7\u0391\u039d\u0399\u039a\u0391 \u03a3\u0397\u039c\u0391\u03a4\u0391",
            "\u039f\u03a1\u0393\u0391\u039d\u03a9\u03a3\u0397 \u039a\u0391\u0399 \u039b\u0395\u0399\u03a4\u039f\u03a5\u03a1\u0393\u0399\u0391 \u0391\u039d\u03a9\u03a4\u0391\u03a4\u03a9\u039d \u0395\u039a\u03a0\u0391\u0399\u0394\u0395\u03a5\u03a4\u0399\u039a\u03a9\u039d \u0399\u0394\u03a1\u03a5\u039c\u0391\u03a4\u03a9\u039d",
            "\u03a5\u0393\u0395\u0399\u039f\u039d\u039f\u039c\u0399\u039a\u0397 \u0391\u03a0\u039f\u0398\u0397\u039a\u0397",
            "\u0393\u0395\u039d. \u0394\u0399\u0395\u03a5\u0398\u03a5\u039d\u03a3\u0397 \u03a0\u039f\u0399\u039d\u0399\u039a\u0397\u03a3 \u0394\u0399\u039a\u0391\u0399\u039f\u03a3\u03a5\u039d\u0397\u03a3",
            "\u0391\u0395\u03a1\u039f\u03a0\u039f\u03a1\u0399\u039a\u039f \u0394\u0399\u039a\u0391\u0399\u039f",
            "\u039c\u0395\u039b\u0395\u03a4\u0397 \u039a\u0391\u0399 \u0395\u03a0\u0399\u0392\u039b\u0395\u03a8\u0397 \u039c\u0397\u03a7\u0391\u039d\u039f\u039b\u039f\u0393\u0399\u039a\u03a9\u039d \u0395\u0393\u039a\u0391\u03a4\u0391\u03a3\u03a4\u0391\u03a3\u0395\u03a9\u039d",
            "\u0391\u0398\u0395\u039c\u0399\u03a4\u039f\u03a3 \u0391\u039d\u03a4\u0391\u0393\u03a9\u039d\u0399\u03a3\u039c\u039f\u03a3",
            "\u03a0\u039f\u039b\u0395\u039c\u0399\u039a\u0397 \u0394\u0399\u0391\u0398\u0395\u03a3\u0399\u039c\u039f\u03a4\u0397\u03a4\u0391",
            "\u039b\u0395\u03a3\u03a7\u0395\u03a3 \u039a\u0391\u0399 \u03a0\u03a1\u0391\u03a4\u0397\u03a1\u0399\u0391 \u0395\u039b.\u0391\u03a3",
            "\u039a\u0391\u03a5\u03a3\u0399\u039c\u0391",
            "\u03a5\u0393\u0395\u0399\u039f\u039d\u039f\u039c\u0399\u039a\u0391 \u039c\u0395\u03a4\u03a1\u0391",
            "\u039a\u0391\u03a4\u0391\u03a3\u03a4\u0391\u03a3\u0397 \u0391\u039e\u0399\u03a9\u039c\u0391\u03a4\u0399\u039a\u03a9\u039d",
            "\u0395\u0399\u03a3\u03a0\u03a1\u0391\u039e\u0397 \u03a0\u039f\u03a1\u03a9\u039d \u03a4\u0391\u039c\u0395\u0399\u039f\u03a5 \u039d\u039f\u039c\u0399\u039a\u03a9\u039d",
            "\u0394\u0399\u039f\u0399\u039a\u0397\u03a4\u0399\u039a\u0397 \u03a1\u03a5\u0398\u039c\u0399\u03a3\u0397 \u0391\u03a0\u039f\u0394\u039f\u03a7\u03a9\u039d \u039a\u0391\u0399 \u039f\u03a1\u03a9\u039d \u0395\u03a1\u0393\u0391\u03a3\u0399\u0391\u03a3",
            "\u0393\u0395\u039d\u0399\u039a\u0397 \u0394\u0399\u0395\u03a5\u0398\u03a5\u039d\u03a3\u0397 \u03a4\u0391\u03a7\u03a5\u0394\u03a1\u039f\u039c\u0395\u0399\u03a9\u039d",
            "\u039f\u03a1\u0393\u0391\u039d\u0399\u03a3\u039c\u039f\u03a3 \u039b\u0399\u039c\u0395\u039d\u039f\u03a3 \u0398\u0395\u03a3\u03a3\u0391\u039b\u039f\u039d\u0399\u039a\u0397\u03a3 \u0391\u039d\u03a9\u039d\u03a5\u039c\u0397 \u0395\u03a4\u0391\u0399\u03a1\u0399\u0391 (\u039f.\u039b.\u0398. \u0391.\u0395.)",
            "\u03a3\u03a7\u039f\u039b\u0397 \u0395\u0398\u039d\u0399\u039a\u0397\u03a3 \u0391\u039c\u03a5\u039d\u0391\u03a3",
            "\u039a\u0391\u0398\u039f\u039b\u0399\u039a\u039f\u0399",
            "\u0395\u039a\u039a\u039b\u0397\u03a3\u0399\u0391\u03a3\u03a4\u0399\u039a\u0391 \u039c\u039f\u03a5\u03a3\u0395\u0399\u0391",
            "\u0394\u0399\u0395\u0398\u039d\u0397\u03a3 \u0395\u039a\u0398\u0395\u03a3\u0397 \u0398\u0395\u03a3\u03a3\u0391\u039b\u039f\u039d\u0399\u039a\u0397\u03a3 \u0391.\u0395. \u2013 XELEXPO \u0391.\u0395",
            "\u0395\u03a5\u0395\u03a1\u0393\u0395\u03a4\u0399\u039a\u039f\u03a3 \u03a5\u03a0\u039f\u039b\u039f\u0393\u0399\u03a3\u039c\u039f\u03a3 \u0397\u039c\u0395\u03a1\u03a9\u039d \u0395\u03a1\u0393\u0391\u03a3\u0399\u0391\u03a3",
            "\u0395\u0399\u03a3\u03a6\u039f\u03a1\u0391 \u0395\u03a0\u0391\u0393\u0393\u0395\u039b\u039c\u0391\u03a4\u0399\u039a\u039f\u03a5 \u039a\u0399\u039d\u0394\u03a5\u039d\u039f\u03a5",
            "\u0391\u03a0\u0391\u039b\u039b\u039f\u03a4\u03a1\u0399\u03a9\u03a3\u0395\u0399\u03a3 \u0393\u0399\u0391 \u03a4\u039f\u03a5\u03a1\u0399\u03a3\u03a4\u0399\u039a\u039f\u03a5\u03a3 \u03a3\u039a\u039f\u03a0\u039f\u03a5\u03a3",
            "\u0391\u03a0\u039f\u039b\u03a5\u039c\u0391\u039d\u03a4\u0397\u03a1\u0399\u0391",
            "\u0395\u039a\u03a0\u039f\u0399\u0397\u03a3\u0397 \u03a0\u039b\u039f\u0399\u03a9\u039d \u0394\u0397\u039c\u039f\u03a3\u0399\u039f\u03a5",
            "\u0394\u0399\u0391\u039a\u039f\u039d\u039f\u0399",
            "\u03a5\u0394\u03a1\u0395\u03a5\u03a3\u0397 \u0394\u0399\u0391\u03a6\u039f\u03a1\u03a9\u039d \u03a0\u039f\u039b\u0395\u03a9\u039d",
            "\u03a0\u03a1\u03a9\u03a4\u0395\u03a3 \u03a5\u039b\u0395\u03a3 \u039a\u039b\u03a9\u03a3\u03a4\u039f\u03a5\u03a6\u0391\u039d\u03a4\u039f\u03a5\u03a1\u0393\u0399\u0391\u03a3",
            "\u03a8\u0395\u03a5\u0394\u0397\u03a3 \u0392\u0395\u0392\u0391\u0399\u03a9\u03a3\u0397 \u0395\u039d\u03a9\u03a0\u0399\u039f\u039d \u0391\u03a1\u03a7\u0397\u03a3",
            "\u0391\u03a0\u03a9\u039b\u0395\u03a3\u0398\u0395\u0399\u03a3\u0395\u03a3 \u039a\u0391\u0399 \u03a0\u0391\u03a1\u0391\u0393\u03a1\u0391\u03a6\u0395\u0399\u03a3\u0395\u03a3 \u0391\u039e\u0399\u0395\u03a3",
            "\u03a6\u039f\u0399\u03a4\u0397\u03a4\u0399\u039a\u0397 \u039b\u0395\u03a3\u03a7\u0397",
            "\u03a4\u0391\u039c\u0395\u0399\u039f \u03a5\u0393\u0395\u0399\u0391\u03a3 \u03a4\u0391\u03a7\u03a5\u0394\u03a1\u039f\u039c\u0399\u039a\u039f\u03a5 \u03a0\u03a1\u039f\u03a3\u03a9\u03a0\u0399\u039a\u039f\u03a5",
            "\u0395\u039b\u0395\u0393\u03a7\u039f\u03a3 \u0394\u0395\u039d\u0394\u03a1\u03a9\u0394\u03a9\u039d \u039a\u0391\u039b\u039b\u0399\u0395\u03a1\u0393\u0395\u0399\u03a9\u039d",
            "\u039a\u0391\u03a4\u0391\u03a0\u039f\u039b\u0395\u039c\u0397\u03a3\u0397 \u0391\u039d\u0391\u039b\u03a6\u0391\u0392\u0397\u03a4\u0399\u03a3\u039c\u039f\u03a5\u039b\u0391\u0399\u039a\u0397 \u0395\u03a0\u0399\u039c\u039f\u03a1\u03a6\u03a9\u03a3\u0397",
            "\u0395\u03a0\u0399\u039a\u039f\u03a5\u03a1\u0399\u039a\u039f\u03a3 \u039f\u03a1\u0393\u0391\u039d\u0399\u03a3\u039c\u039f\u03a3 \u039c\u0395\u03a4\u0391\u03a6\u039f\u03a1\u03a9\u039d",
            "\u03a6\u039f\u0399\u03a4\u0397\u03a4\u0399\u039a\u0395\u03a3 \u039b\u0395\u03a3\u03a7\u0395\u03a3",
            "\u0394\u0399\u0395\u0398\u039d\u0395\u0399\u03a3 \u03a3\u03a5\u039c\u0392\u0391\u03a3\u0395\u0399\u03a3 \u0393\u0399\u0391 \u03a4\u0397\u039d \u03a0\u03a1\u039f\u03a3\u03a4\u0391\u03a3\u0399\u0391 \u03a4\u03a9\u039d \u0395\u03a1\u0393\u0391\u0396\u039f\u039c\u0395\u039d\u03a9\u039d \u0393\u03a5\u039d\u0391\u0399\u039a\u03a9\u039d",
            "\u039b\u0397\u03a3\u03a4\u0395\u0399\u0391",
            "\u0391\u0393\u03a9\u0393\u0395\u03a3 \u0391\u03a0\u039f \u03a3\u03a5\u039d\u0391\u039b\u039b\u0391\u0393\u039c\u0391\u03a4\u0399\u039a\u0395\u03a3 \u039a\u0391\u0399 \u0393\u03a1\u0391\u039c\u039c\u0391\u03a4\u0399\u0391",
            "\u0395\u039a\u039c\u0399\u03a3\u0398\u03a9\u03a3\u0397 \u0394\u0397\u039c\u039f\u03a3\u0399\u03a9\u039d \u039c\u0395\u03a4\u0391\u039b\u039b\u0395\u0399\u03a9\u039d",
            "\u039a\u039f\u039b\u03a5\u039c\u0392\u0397\u03a4\u0399\u039a\u0395\u03a3 \u0394\u0395\u039e\u0391\u039c\u0395\u039d\u0395\u03a3",
            "\u0395\u03a1\u0391\u039d\u039f\u0399 \u039a\u0391\u0399 \u039b\u0391\u03a7\u0395\u0399\u039f\u03a6\u039f\u03a1\u039f\u0399 \u0397 \u03a6\u0399\u039b\u0391\u039d\u0398\u03a1\u03a9\u03a0\u0399\u039a\u0395\u03a3  \u0391\u0393\u039f\u03a1\u0395\u03a3",
            "\u03a0\u03a1\u039f\u03a3\u03a4\u0391\u03a3\u0399\u0391 \u0395\u03a0\u0399\u0392\u0391\u03a4\u0397\u0393\u039f\u03a5 \u039d\u0391\u03a5\u03a4\u0399\u039b\u0399\u0391\u03a3",
            "\u0393\u0395\u039d\u0399\u039a\u039f\u0399 \u039d\u039f\u039c\u039f\u0399 \u03a0\u0395\u03a1\u0399 \u039e\u0395\u039d\u039f\u0394\u039f\u03a7\u0395\u0399\u03a9\u039d-\u0395\u03a0\u0399\u03a0\u039b. \u0394\u03a9\u039c\u0391\u03a4\u0399\u03a9\u039d \u039a\u039b\u03a0",
            "\u0399\u0395\u03a1\u0391\u03a1\u03a7\u0399\u0391 \u039a\u0391\u0399 \u03a0\u03a1\u039f\u0391\u0393\u03a9\u0393\u0395\u03a3 \u0391\u039e\u0399\u03a9\u039c\u0391\u03a4\u0399\u039a\u03a9\u039d",
            "\u03a3\u03a5\u039d\u0395\u03a1\u0393\u0391\u03a4\u0395\u03a3 (\u0393\u03a1\u0391\u039c\u039c\u0391\u03a4\u0395\u0399\u03a3) \u0392\u039f\u03a5\u039b\u0395\u03a5\u03a4\u03a9\u039d-\u0395\u03a5\u03a1\u03a9\u0392\u039f\u03a5\u039b\u0395\u03a5\u03a4\u03a9\u039d",
            "\u03a3\u03a7\u039f\u039b\u0397 \u0399\u039a\u0391\u03a1\u03a9\u039d",
            "\u039f\u03a1\u0393\u0391\u039d\u0399\u03a3\u039c\u039f\u03a3 \u03a3\u0399\u0394\u0397\u03a1\u039f\u0394\u03a1\u039f\u039c\u03a9\u039d \u0395\u039b\u039b\u0391\u0394\u039f\u03a3 (\u039f.\u03a3.\u0395.)\u03a3\u0399\u0394\u0397\u03a1\u039f\u0394\u03a1\u039f\u039c\u0399\u039a\u0395\u03a3 \u0395\u03a0\u0399\u03a7\u0395\u0399\u03a1\u0397\u03a3\u0395\u0399\u03a3",
            "\u03a5\u0393\u0395\u0399\u039f\u039d\u039f\u039c\u0399\u039a\u039f\u03a3 \u039a\u0391\u039d\u039f\u039d\u0399\u03a3\u039c\u039f\u03a3 \u039a\u0391\u03a4\u0391 \u0398\u0391\u039b\u0391\u03a3\u03a3\u0391\u039d \u039a\u0391\u0399 \u039a\u0391\u03a4\u0391 \u039e\u0397\u03a1\u0391\u039d",
            "\u039a\u0391\u039d\u039f\u039d\u0399\u03a3\u039c\u039f\u03a3 \u039c\u0395\u03a4\u0391\u039b\u039b\u0395\u03a5\u03a4\u0399\u039a\u03a9\u039d \u0395\u03a1\u0393\u0391\u03a3\u0399\u03a9\u039d",
            "\u0391\u03a0\u039f\u03a6\u03a5\u0393\u0397 \u03a3\u03a5\u0393\u039a\u03a1\u039f\u03a5\u03a3\u0395\u03a9\u039d",
            "\u03a4\u039f\u039c\u0391\u03a4\u039f\u03a0\u0391\u03a1\u0391\u0393\u03a9\u0393\u0397",
            "\u0394\u0399\u0391\u03a6\u039f\u03a1\u0395\u03a3 \u0394\u0399\u0391\u03a4\u0391\u039e\u0395\u0399\u03a3 \u0393\u0399\u0391 \u03a4\u0391 \u0391\u03a5\u03a4\u039f\u039a\u0399\u039d\u0397\u03a4\u0391",
            "\u039a\u0391\u03a4\u0391\u03a4\u0391\u039e\u0397 \u0393\u03a5\u039d\u0391\u0399\u039a\u03a9\u039d \u03a3\u03a4\u039f \u039b.\u03a3",
            "\u0395\u03a4\u0391\u0399\u03a1\u0395\u0399\u0395\u03a3 \u0394\u0399\u039f\u0399\u039a\u039f\u03a5\u039c\u0395\u039d\u0395\u03a3 \u0391\u03a0\u039f \u03a4\u039f\u03a5\u03a3 \u03a0\u0399\u03a3\u03a4\u03a9\u03a4\u0395\u03a3",
            "\u0392\u0391\u039b\u039a\u0391\u039d\u0399\u039a\u0395\u03a3 \u03a3\u03a5\u039c\u03a6\u03a9\u039d\u0399\u0395\u03a3",
            "\u039c\u0395\u03a4\u0391\u03a6\u039f\u03a1\u0391 \u03a3\u03a5\u039d\u03a4\u0395\u039b\u0395\u03a3\u03a4\u0397 \u0394\u039f\u039c\u0397\u03a3\u0397\u03a3",
            "\u03a0\u03a1\u039f\u039c\u0397\u0398\u0395\u03a5\u03a4\u0399\u039a\u039f\u03a3 \u039f\u03a1\u0393\u0391\u039d\u0399\u03a3\u039c\u039f\u03a3 \u03a0.\u039d",
            "\u03a0\u03a1\u039f\u03a3\u03a9\u03a0\u0399\u039a\u039f \u03a6\u0391\u03a1\u039c\u0391\u039a\u0395\u0399\u03a9\u039d",
            "\u0394\u0399\u0394\u0391\u03a3\u039a\u039f\u039c\u0395\u039d\u0391 \u039c\u0391\u0398\u0397\u039c\u0391\u03a4\u0391",
            "\u0395\u039a\u039b\u039f\u0393\u0397 \u0392\u039f\u03a5\u039b\u0395\u03a5\u03a4\u03a9\u039d - \u0395\u03a5\u03a1\u03a9\u0392\u039f\u03a5\u039b\u0395\u03a5\u03a4\u03a9\u039d",
            "\u03a6\u0391\u03a1\u039c\u0391\u039a\u039f\u03a0\u039f\u0399\u039f\u0399",
            "\u03a3\u03a4\u03a1\u0391\u03a4\u0399\u03a9\u03a4\u0399\u039a\u0391 \u03a0\u03a1\u0391\u03a4\u0397\u03a1\u0399\u0391",
            "\u039a\u0391\u03a1\u039a\u0399\u039d\u039f\u03a3",
            "\u03a4\u0391\u039c\u0395\u0399\u039f \u0395\u03a0\u0399\u039a\u039f\u03a5\u03a1\u0399\u039a\u0397\u03a3 \u0391\u03a3\u03a6\u0391\u039b\u0399\u03a3\u0395\u03a9\u03a3 \u03a0\u03a1\u039f\u03a3\u03a9\u03a0\u0399\u039a\u039f\u03a5 \u0391.\u0395. \u039f\u0399\u039d\u039f\u03a0\u039f\u0399\u0399\u0391\u03a3, \u0396\u03a5\u0398\u039f\u03a0\u039f\u0399\u0399\u0391\u03a3 \u039a\u0391\u0399 \u039f\u0399\u039d\u039f\u03a0\u039d\u0395\u03a5\u039c\u0391\u03a4\u039f\u03a0\u039f\u0399\u0399\u0391\u03a3",
            "\u03a7\u0395\u0399\u03a1\u0399\u03a3\u03a4\u0395\u03a3 \u0391\u03a3\u03a5\u03a1\u039c\u0391\u03a4\u039f\u03a5",
            "\u03a0\u039f\u039b\u0399\u03a4\u0399\u039a\u0397 \u0395\u03a0\u0399\u03a3\u03a4\u03a1\u0391\u03a4\u0395\u03a5\u03a3\u0397-\u03a0\u0391\u039b\u039b\u0391\u0399\u039a\u0397 \u0391\u039c\u03a5\u039d\u0391",
            "\u039f\u03a1\u0393\u0391\u039d\u0399\u03a3\u039c\u039f\u0399 \u0395\u0393\u0393\u0395\u0399\u03a9\u039d \u0392\u0395\u039b\u03a4\u0399\u03a9\u03a3\u0395\u03a9\u039d",
            "\u039f\u039c\u039f\u0393\u0395\u039d\u0395\u0399\u03a3 \u03a0\u0391\u039b\u039b\u0399\u039d\u039f\u03a3\u03a4\u039f\u03a5\u039d\u03a4\u0395\u03a3",
            "\u0395\u03a5\u03a1\u03a9\u03a0\u0391\u0399\u039a\u039f\u03a3 \u039a\u039f\u0399\u039d\u03a9\u039d\u0399\u039a\u039f\u03a3 \u03a7\u0391\u03a1\u03a4\u0397\u03a3",
            "\u039f\u03a1\u0393\u0391\u039d\u0399\u039a\u0395\u03a3 \u0394\u0399\u0391\u03a4\u0391\u039e\u0395\u0399\u03a3",
            "\u0395\u039e\u0391\u0399\u03a1\u0395\u03a3\u0397 \u0394\u0399\u039a\u0391\u03a3\u03a4\u03a9\u039d",
            "\u0393\u0395\u039d\u0399\u039a\u0395\u03a3 \u0395\u03a0\u0399\u0398\u0395\u03a9\u03a1\u0397\u03a3\u0395\u0399\u03a3 \u2013 \u0394\u0399\u0395\u03a5\u0398\u03a5\u039d\u03a3\u0395\u0399\u03a3 \u03a3\u03a4\u039f\u0399\u03a7\u0395\u0399\u03a9\u0394\u039f\u03a5\u03a3 \u0395\u039a\u03a0\u0391\u0399\u0394\u0395\u03a5\u03a3\u0397\u03a3",
            "\u039a\u0391\u039d\u039f\u039d\u0399\u03a3\u039c\u039f\u03a3 \u0395\u03a0\u0399\u0398\u0395\u03a9\u03a1\u0397\u03a3\u0395\u03a9\u03a3 \u039a\u0391\u0399 \u0391\u03a3\u03a6\u0391\u039b\u0395\u0399\u0391\u03a3",
            "\u03a4\u0391\u039c\u0395\u0399\u039f \u03a0\u03a1\u039f\u039d\u039f\u0399\u0391\u03a3 \u03a0\u03a1\u039f\u03a3\u03a9\u03a0\u0399\u039a\u039f\u03a5 \u0391\u03a5\u03a4\u039f\u039d\u039f\u039c\u039f\u03a5 \u03a3\u03a4\u0391\u03a6\u0399\u0394\u0399\u039a\u039f\u03a5 \u039f\u03a1\u0393\u0391\u039d\u0399\u03a3\u039c\u039f\u03a5 (\u03a4.\u0391.\u03a0.\u0391.\u03a3.\u039f)",
            "\u03a4\u0391\u039c\u0395\u0399\u039f\u039d \u03a0\u03a1\u039f\u039d\u039f\u0399\u0391\u03a3 \u039f\u03a1\u0398\u039f\u0394\u039f\u039e\u039f\u03a5 \u0395\u03a6\u0397\u039c\u0395\u03a1\u0399\u0391\u039a\u039f\u03a5",
            "\u03a3\u03a7\u039f\u039b\u0399\u039a\u0397 \u03a3\u03a9\u039c\u0391\u03a4\u0399\u039a\u0397 \u0391\u0393\u03a9\u0393\u0397",
            "\u039a\u0395\u039d\u03a4\u03a1\u039f \u03a0\u0391\u03a1\u0391\u0393\u03a9\u0393\u0399\u039a\u039f\u03a4\u0397\u03a4\u0391\u03a3",
            "\u03a4\u0391\u039c\u0395\u0399\u039f \u0391\u03a3\u03a6\u0391\u039b\u0399\u03a3\u0395\u03a9\u03a3 \u0399\u0394\u0399\u039f\u039a\u03a4\u0397\u03a4\u03a9\u039d",
            "\u0392\u039f\u03a3\u039a\u0397 \u0395\u039d\u03a4\u039f\u03a3 \u0394\u0391\u03a3\u03a9\u039d",
            "\u0395\u039b\u0395\u0393\u03a7\u039f\u03a3 \u0395\u039e\u0391\u0393\u039f\u039c\u0395\u039d\u03a9\u039d \u0393\u0395\u03a9\u03a1\u0393\u0399\u039a\u03a9\u039d \u03a0\u03a1\u039f\u0399\u039f\u039d\u03a4\u03a9\u039d",
            "\u03a0\u0391\u0399\u0394\u0391\u0393\u03a9\u0393\u0399\u039a\u0391 \u03a4\u039c\u0397\u039c\u0391\u03a4\u0391 \u0391.\u0395.\u0399",
            "\u03a5\u03a0\u039f\u03a4\u03a1\u039f\u03a6\u0399\u0395\u03a3 \u039a\u039b\u0397\u03a1\u039f\u0394\u039f\u03a4\u0397\u039c\u0391\u03a4\u039f\u03a3 \u03a0. \u0392\u0391\u03a3\u03a3\u0391\u039d\u0397",
            "\u0391\u03a4\u03a5\u03a7\u0397\u039c\u0391 \u0391\u03a0\u039f \u0394\u039f\u039b\u039f \u03a4\u039f\u03a5 \u0395\u03a1\u0393\u039f\u0394\u039f\u03a4\u0397",
            "\u0392\u03a5\u0396\u0391\u039d\u03a4\u0399\u039d\u039f \u039a\u0391\u0399 \u03a7\u03a1\u0399\u03a3\u03a4\u0399\u0391\u039d\u0399\u039a\u039f \u039c\u039f\u03a5\u03a3\u0395\u0399\u039f",
            "\u0395\u0399\u03a1\u0397\u039d\u0395\u03a5\u03a4\u0399\u039a\u0395\u03a3 \u0391\u03a0\u039f\u03a3\u03a4\u039f\u039b\u0395\u03a3",
            "\u03a5\u0393\u0395\u0399\u039f\u039d\u039f\u039c\u0399\u039a\u039f\u03a3 \u0384\u0395\u039b\u0395\u0393\u03a7\u039f\u03a3 \u0395\u0399\u03a3\u0395\u03a1\u03a7\u039f\u039c\u0395\u039d\u03a9\u039d",
            "\u039f\u03a1\u039a\u039f\u03a3 \u03a4\u039f\u03a5 \u03a0\u039f\u039b\u0399\u03a4\u0397",
            "\u03a5\u0393\u0395\u0399\u039f\u039d\u039f\u039c\u0399\u039a\u0397 \u03a0\u0395\u03a1\u0399\u0398\u0391\u039b\u03a8\u0397 \u03a3\u03a0\u039f\u03a5\u0394\u0391\u03a3\u03a4\u03a9\u039d",
            "\u03a0\u0391\u03a1\u0391\u03a7\u0391\u03a1\u0391\u039e\u0397 \u039a\u0391\u0399 \u039a\u0399\u0392\u0394\u0397\u039b\u0399\u0391",
            "\u0394\u0399\u0391\u039c\u0395\u03a1\u0399\u03a3\u039c\u0391\u03a4\u0391 \u03a0\u039b\u039f\u0399\u0391\u03a1\u03a7\u03a9\u039d \u039a\u0391\u0399 \u03a0\u039b\u0397\u03a1\u03a9\u039c\u0391\u03a4\u03a9\u039d",
            "\u039a\u039b\u0391\u0394\u039f\u03a3 \u0391\u03a1\u03a9\u0393\u0397\u03a3 \u03a4.\u0391.\u039a.\u0395",
            "\u039f\u03a1\u0393\u0391\u039d\u0399\u03a3\u039c\u039f\u03a3 \u0392\u0391\u039c\u0392\u0391\u039a\u039f\u03a3",
            "\u039d\u039f\u03a3\u0397\u039b\u0395\u0399\u0391 \u03a3\u03a4\u03a1\u0391\u03a4\u0399\u03a9\u03a4\u0399\u039a\u03a9\u039d",
            "\u03a4\u0391\u039c\u0395\u0399\u039f \u0391\u03a3\u03a6\u0391\u039b\u0399\u03a3\u0395\u03a9\u03a3",
            "\u03a0\u039f\u039b\u03a5\u0395\u0398\u039d\u0395\u0399\u03a3 \u0391\u0395\u03a1\u039f\u03a0\u039f\u03a1\u0399\u039a\u0395\u03a3 \u03a3\u03a5\u039c\u0392\u0391\u03a3\u0395\u0399\u03a3",
            "\u039d\u0391\u03a5\u03a4\u0399\u039a\u039f \u0391\u03a0\u039f\u039c\u0391\u03a7\u0399\u039a\u039f \u03a4\u0391\u039c\u0395\u0399\u039f",
            "\u03a5\u0393\u0399\u0395\u0399\u039d\u0397 \u0391\u03a1\u03a4\u039f\u03a0\u039f\u0399\u0395\u0399\u03a9\u039d",
            "\u039d\u039f\u039c\u0391\u03a1\u03a7\u0399\u0391\u039a\u0391 \u03a3\u03a5\u039c\u0392\u039f\u03a5\u039b\u0399\u0391",
            "\u039b\u0395\u03a3\u03a7\u0397 \u0391\u039e\u0399\u03a9\u039c\u0391\u03a4\u0399\u039a\u03a9\u039d \u03a0.\u039d",
            "\u039a\u0391\u03a4\u03a9\u03a4\u0395\u03a1\u039f \u0394\u0399\u0394\u0391\u039a\u03a4\u0399\u039a\u039f \u03a0\u03a1\u039f\u03a3\u03a9\u03a0\u0399\u039a\u039f",
            "\u0393\u0395\u039d\u0399\u039a\u0391 \u03a0\u0395\u03a1\u0399 \u039a\u03a5\u039a\u039b\u039f\u03a6\u039f\u03a1\u0399\u0391\u03a3 \u0391\u03a5\u03a4\u039f\u039a\u0399\u039d\u0397\u03a4\u03a9\u039d",
            "\u03a4\u0391\u039c\u0395\u0399\u039f \u039d\u039f\u03a3\u0397\u039b\u0395\u0399\u0391\u03a3 \u03a3\u03a0\u039f\u03a5\u0394\u0391\u03a3\u03a4\u03a9\u039d",
            "\u0395\u03a0\u0391\u0393\u0393\u0395\u039b\u039c\u0391\u03a4\u0399\u039a\u0391 \u039a\u0391\u0399 \u0392\u0399\u039f\u03a4\u0395\u03a7\u039d\u0399\u039a\u0391 \u0395\u03a0\u0399\u039c\u0395\u039b\u0397\u03a4\u0397\u03a1\u0399\u0391",
            "\u0391\u039a\u03a4\u039f\u03a0\u039b\u039f\u0399\u0391",
            "\u03a0\u03a1\u039f\u03a3\u03a4\u0391\u03a3\u0399\u0391 \u0391\u039b\u0399\u0395\u0399\u0391\u03a3",
            "\u039c\u0395 \u03a4\u0397 \u039d\u039f\u03a1\u0392\u0397\u0393\u0399\u0391",
            "\u0397\u0398\u0399\u039a\u0395\u03a3 \u0391\u039c\u039f\u0399\u0392\u0395\u03a3 \u03a0\u03a1\u039f\u03a3\u03a9\u03a0\u0399\u039a\u039f\u03a5 (\u0384\u0395\u039d\u039f\u03a0\u039b\u039f\u03a5-\u03a0\u039f\u039b\u0399\u03a4\u0399\u039a\u039f\u03a5) \u03a5\u03a0\u039f\u03a5\u03a1\u0393\u0395\u0399\u039f\u03a5 \u0394\u0397\u039c\u039f\u03a3\u0399\u0391\u03a3 \u03a4\u0391\u039e\u0397\u03a3",
            "\u039b\u0395\u03a9\u03a6\u039f\u03a1\u0395\u0399\u0391 \u0399\u0394\u0399\u03a9\u03a4\u0399\u039a\u0397\u03a3 \u03a7\u03a1\u0397\u03a3\u0395\u03a9\u03a3",
            "\u0395\u03a1\u0393\u0391\u03a4\u0399\u039a\u0395\u03a3 \u0394\u0399\u0391\u03a6\u039f\u03a1\u0395\u03a3",
            "\u03a1\u0391\u0394\u0399\u039f\u0397\u039b\u0395\u039a\u03a4\u03a1\u039f\u039b\u039f\u0393\u039f\u0399-\u03a1\u0391\u0394\u0399\u039f\u03a4\u0395\u03a7\u039d\u0399\u03a4\u0395\u03a3",
            "\u03a0\u03a1\u039f\u0393\u039d\u03a9\u03a3\u03a4\u0399\u039a\u0391 \u03a0\u039f\u0394\u039f\u03a3\u03a6\u0391\u0399\u03a1\u039f\u03a5",
            "\u03a4\u0391\u039c\u0395\u0399\u039f \u03a3\u03a5\u039d\u03a4\u0391\u039e\u0395\u03a9\u039d \u039a\u0391\u0399 \u03a0\u03a1\u039f\u039d\u039f\u0399\u0391\u03a3 \u03a0\u03a1\u039f\u03a3\u03a9\u03a0\u0399\u039a\u039f\u03a5 \u03a4\u0397\u03a3 \u0391\u0393\u03a1\u039f\u03a4\u0399\u039a\u0397\u03a3 \u03a4\u03a1\u0391\u03a0\u0395\u0396\u0391\u03a3 \u03a4\u0397\u03a3 \u0395\u039b\u039b\u0391\u0394\u0391\u03a3 (\u03a4.\u03a3.\u03a0. \u2013 \u0391.\u03a4.\u0395.)",
            "\u03a5\u0394\u03a1\u0395\u03a5\u03a3\u0397 \u039b\u0395\u039a\u0391\u039d\u039f\u03a0\u0395\u0394\u0399\u039f\u03a5 \u0391\u0398\u0397\u039d\u03a9\u039d",
            "\u03a4\u03a1\u0391\u03a0\u0395\u0396\u0391 \u039f\u03a6\u0398\u0391\u039b\u039c\u03a9\u039d",
            "\u0395\u0398\u039d\u0399\u039a\u039f \u039a\u0395\u039d\u03a4\u03a1\u039f \u03a7\u0391\u03a1\u03a4\u03a9\u039d \u039a\u0391\u0399 \u03a7\u0391\u03a1\u03a4\u039f\u0393\u03a1\u0391\u03a6\u0399\u039a\u0397\u03a3 \u039a\u039b\u0397\u03a1\u039f\u039d\u039f\u039c\u0399\u0391\u03a3 - \u0395\u0398\u039d\u0399\u039a\u0397 \u03a7\u0391\u03a1\u03a4\u039f\u0398\u0397\u039a\u0397",
            "\u039a\u0391\u039d\u039f\u039d\u0399\u03a3\u039c\u039f\u0399 \u0391\u03a0\u039f\u03a6\u03a5\u0393\u0397\u03a3 \u03a3\u03a5\u0393\u039a\u03a1\u039f\u03a5\u03a3\u0395\u03a9\u039d",
            "\u0393\u03a1\u0391\u03a6\u0395\u0399\u039f \u0395\u0393\u039a\u039b\u0397\u039c\u0391\u03a4\u0399\u03a9\u039d \u03a0\u039f\u039b\u0395\u039c\u039f\u03a5",
            "\u0391\u0393\u03a1\u039f\u03a4\u0399\u039a\u0395\u03a3 \u03a3\u03a5\u039d\u0394\u0399\u039a\u0391\u039b\u0399\u03a3\u03a4\u0399\u039a\u0395\u03a3 \u039f\u03a1\u0393\u0391\u039d\u03a9\u03a3\u0395\u0399\u03a3",
            "\u03a4\u0391\u03a5\u03a4\u039f\u03a4\u0397\u03a4\u0395\u03a3",
            "\u0394\u0391\u03a3\u0399\u039a\u039f\u0399 \u03a3\u03a5\u039d\u0395\u03a4\u0391\u0399\u03a1\u0399\u03a3\u039c\u039f\u0399",
            "\u03a3\u03a5\u039c\u0392\u039f\u039b\u0391\u0399\u039f\u0393\u03a1\u0391\u03a6\u0399\u039a\u0391 \u0394\u0399\u039a\u0391\u0399\u03a9\u039c\u0391\u03a4\u0391",
            "\u0399\u0394\u0399\u039f\u039a\u03a4\u0397\u03a3\u0399\u0391 \u039a\u0391\u03a4\u2019 \u039f\u03a1\u039f\u03a6\u039f",
            "\u03a3\u03a7\u039f\u039b\u0399\u039a\u0391 \u03a4\u0391\u039c\u0395\u0399\u0391",
            "\u0391\u03a1\u03a7\u0395\u0399\u039f\u03a6\u03a5\u039b\u0391\u039a\u0395\u0399\u0391 \u0394\u0399\u0391\u03a6\u039f\u03a1\u0391",
            "\u0391\u03a0\u039f\u0396\u0397\u039c\u0399\u03a9\u03a3\u0397 \u0391\u039d\u03a4\u0391\u039b\u039b\u0391\u039e\u0399\u039c\u03a9\u039d",
            "\u03a3\u03a7\u039f\u039b\u0399\u039a\u0391 \u039a\u03a4\u0399\u03a1\u0399\u0391",
            "\u03a6\u039f\u03a1\u039f\u039b\u039f\u0393\u0399\u0391 \u039f\u0399\u039a\u039f\u0394\u039f\u039c\u03a9\u039d",
            "\u03a0\u03a1\u039f\u03a4\u03a5\u03a0\u0391 \u0394\u0397\u039c\u039f\u03a4\u0399\u039a\u0391",
            "\u03a0\u03a1\u03a9\u03a4\u0395\u03a3 \u03a5\u039b\u0395\u03a3 \u0392\u03a5\u03a1\u03a3\u039f\u0394\u0395\u03a8\u0399\u0391\u03a3 - \u0394\u0395\u03a1\u039c\u0391\u03a4\u0391",
            "\u03a3\u03a5\u039c\u0392\u0399\u0392\u0391\u03a3\u039c\u039f\u03a3 \u039a\u0391\u0399 \u0394\u0399\u0391\u0399\u03a4\u0397\u03a3\u0399\u0391",
            "\u039a\u0391\u03a4\u0391\u03a3\u03a4\u0391\u03a3\u0397 \u0394\u0397\u039c\u039f\u03a4\u0399\u039a\u03a9\u039d \u039a\u0391\u0399 \u039a\u039f\u0399\u039d\u039f\u03a4\u0399\u039a\u03a9\u039d \u03a5\u03a0\u0391\u039b\u039b\u0397\u039b\u03a9\u039d",
            "\u0395\u03a3\u039f\u0394\u0391 \u0394\u0397\u039c\u03a9\u039d \u039a\u0391\u0399 \u039a\u039f\u0399\u039d\u039f\u03a4\u0397\u03a4\u03a9\u039d",
            "\u03a3\u03a4\u0391\u0394\u0399\u0391 \u039a\u0391\u0399 \u0393\u03a5\u039c\u039d\u0391\u03a3\u03a4\u0397\u03a1\u0399\u0391",
            "\u039a\u039f\u0399\u039d\u0397 \u0391\u0393\u03a1\u039f\u03a4\u0399\u039a\u0397 \u03a0\u039f\u039b\u0399\u03a4\u0399\u039a\u0397",
            "\u0391\u03a4\u039f\u039c\u0391 \u039c\u0395 \u0395\u0399\u0394\u0399\u039a\u0395\u03a3 \u0391\u039d\u0391\u0393\u039a\u0395\u03a3 - \u03a5\u03a0\u0395\u03a1\u0397\u039b\u0399\u039a\u0395\u03a3 - \u03a7\u03a1\u039f\u039d\u0399\u0391 \u03a0\u0391\u03a3\u03a7\u039f\u039d\u03a4\u0395\u03a3",
            "\u0395\u039a\u039a\u039b\u0397\u03a3\u0399\u0391\u03a3\u03a4\u0399\u039a\u0391 \u0394\u0399\u039a\u0391\u03a3\u03a4\u0397\u03a1\u0399\u0391",
            "\u03a3\u03a5\u039c\u0392\u0391\u03a3\u0395\u0399\u03a3 \u0393\u0399\u0391 \u03a4\u0397\u039d \u0391\u03a0\u039f\u03a6\u03a5\u0393\u0397 \u0394\u0399\u03a0\u039b\u0397\u03a3 \u03a6\u039f\u03a1\u039f\u039b\u039f\u0393\u0399\u0391\u03a3",
            "\u03a0\u03a1\u039f\u03a3\u03a4\u0391\u03a3\u0399\u0391 \u0392\u0391\u039c\u0392\u0391\u039a\u039f\u03a0\u0391\u03a1\u0391\u0393\u03a9\u0393\u0397\u03a3",
            "\u039d\u0391\u03a5\u03a4\u0399\u039a\u0397 \u03a3\u03a4\u03a1\u0391\u03a4\u039f\u039b\u039f\u0393\u0399\u0391",
            "\u039d\u039f\u03a3\u039f\u039a\u039f\u039c\u0395\u0399\u0391\u039a\u0397 \u03a0\u0395\u03a1\u0399\u0398\u0391\u039b\u03a8\u0397 \u0391\u03a3\u03a6\u0391\u039b\u0399\u03a3\u039c\u0395\u039d\u03a9\u039d \u039f.\u0393.\u0391",
            "\u03a6\u03a5\u03a3\u0399\u039a\u0391 \u039f\u03a1\u0393\u0391\u039d\u0399\u039a\u0391 \u039b\u0399\u03a0\u0391\u03a3\u039c\u0391\u03a4\u0391",
            "\u03a4\u0391\u039c\u0395\u0399\u039f \u0395\u03a0\u0399\u039a\u039f\u03a5\u03a1\u0399\u039a\u0397\u03a3 \u0391\u03a3\u03a6\u0391\u039b\u0399\u03a3\u0395\u03a9\u03a3 \u039c\u0399\u03a3\u0398\u03a9\u03a4\u03a9\u039d \u0395\u03a3\u03a4\u0399\u0391\u03a4\u039f\u03a1\u0399\u03a9\u039d, \u0396\u0391\u03a7\u0391\u03a1\u039f\u03a0\u039b\u0391\u03a3\u03a4\u0395\u0399\u03a9\u039d, \u039a\u0391\u03a6\u0395\u039d\u0395\u0399\u03a9\u039d \u039a.\u039b\u03a0. (\u03a4.\u0395.\u0391.\u039c.\u0395.\u0396.)",
            "\u03a4\u0395\u03a7\u039d\u0399\u039a\u0391\u0399 \u03a5\u03a0\u0397\u03a1\u0395\u03a3\u0399\u0391\u0399",
            "\u03a3\u03a5\u0393\u039a\u0395\u039d\u03a4\u03a1\u03a9\u03a3\u0397 \u03a0\u03a1\u039f\u0399\u039f\u039d\u03a4\u03a9\u039d",
            "\u03a5\u0394\u03a1\u039f\u0393\u03a1\u0391\u03a6\u0399\u039a\u0397 \u03a5\u03a0\u0397\u03a1\u0395\u03a3\u0399\u0391",
            "\u03a5\u03a0\u0397\u03a1\u0395\u03a3\u0399\u0391 \u0395\u039b\u0395\u0393\u03a7\u039f\u03a5 \u039a\u0391\u03a4\u0391\u03a3\u039a\u0395\u03a5\u0397\u03a3 \u0391\u039e\u0399\u03a9\u039d \u03a4\u039f\u03a5 \u0394\u0397\u039c\u039f\u03a3\u0399\u039f\u03a5",
            "\u0395\u03a0\u0399\u03a3\u039a\u039f\u03a0\u0399\u039a\u0391 \u0393\u03a1\u0391\u03a6\u0395\u0399\u0391",
            "\u0392\u0395\u039b\u0393\u0399\u039f, \u0392\u0395\u039d\u0395\u0396\u039f\u03a5\u0395\u039b\u0391 \u039a.\u039b\u03a0",
            "\u0394\u0397\u039c\u039f\u03a4\u0399\u039a\u039f\u03a3 \u039a\u0391\u0399 \u039a\u039f\u0399\u039d\u039f\u03a4\u0399\u039a\u039f\u03a3 \u039a\u03a9\u0394\u0399\u039a\u0391\u03a3",
            "\u03a0\u03a1\u039f\u0394\u039f\u03a3\u0399\u0391",
            "\u039c\u0399\u03a3\u0398\u039f\u03a3 \u0394\u0397\u039c\u039f\u03a3\u0399\u03a9\u039d \u03a5\u03a0\u0391\u039b\u039b\u0397\u039b\u03a9\u039d",
            "\u03a0\u039f\u039b\u0399\u03a4\u0399\u039a\u039f \u03a0\u03a1\u039f\u03a3\u03a9\u03a0\u0399\u039a\u039f \u039d\u0391\u03a5\u03a4\u0399\u039a\u039f\u03a5",
            "\u0391\u039d\u0391\u0396\u0397\u03a4\u0397\u03a3\u0397 \u039a\u0391\u0399 \u0394\u0399\u0391\u03a6\u03a5\u039b\u0391\u039e\u0397 \u0391\u03a1\u03a7\u0391\u0399\u039f\u03a4\u0397\u03a4\u03a9\u039d",
            "\u0391\u0394\u0395\u0399\u0395\u03a3 \u039b\u0399\u0391\u039d\u0399\u039a\u0397\u03a3 \u03a0\u03a9\u039b\u0397\u03a3\u0397\u03a3 \u03a4\u03a3\u0399\u0393\u0391\u03a1\u03a9\u039d \u039a\u0391\u0399 \u0395\u0399\u0394\u03a9\u039d \u039c\u039f\u039d\u039f\u03a0\u03a9\u039b\u0399\u039f\u03a5",
            "\u0395\u03a0\u039f\u03a0\u03a4\u0399\u039a\u0391 \u039c\u0395\u03a3\u0391 \u0394\u0399\u0394\u0391\u03a3\u039a\u0391\u039b\u0399\u0391\u03a3",
            "\u0395\u039a\u039b\u039f\u0393\u039f\u0394\u0399\u039a\u0395\u0399\u0391",
            "\u039f.\u0393.\u0391 \u039a\u0391\u03a4\u0391\u03a3\u03a4\u0391\u03a4\u0399\u039a\u0395\u03a3 \u0394\u0399\u0391\u03a4\u0391\u039e\u0395\u0399\u03a3",
            "\u0399\u039d\u03a3\u03a4\u0399\u03a4\u039f\u03a5\u03a4\u039f \u03a5\u0393\u0395\u0399\u0391\u03a3 \u03a4\u039f\u03a5 \u03a0\u0391\u0399\u0394\u0399\u039f\u03a5",
            "\u03a3\u03a7\u039f\u039b\u0397 \u0398\u0395\u03a4\u0399\u039a\u03a9\u039d \u0395\u03a0\u0399\u03a3\u03a4\u0397\u039c\u03a9\u039d \u03a0\u0391\u039d\u0395\u03a0\u0399\u03a3\u03a4\u0397\u039c\u0399\u039f\u03a5 \u03a0\u0391\u03a4\u03a1\u03a9\u039d",
            "\u0395\u03a3\u03a0\u0395\u03a1\u0399\u0394\u039f\u0395\u0399\u0394\u0397-\u039f\u03a0\u03a9\u03a1\u039f\u039a\u0397\u03a0\u0395\u03a5\u03a4\u0399\u039a\u0391",
            "\u0395\u03a0\u0399\u0394\u039f\u039c\u0391\u03a4\u0391 \u03a3\u03a4\u03a1\u0391\u03a4\u0395\u03a5\u039f\u039c\u0395\u039d\u03a9\u039d",
            "\u03a0\u03a1\u039f\u039b\u0397\u03a8\u0397 \u0395\u03a1\u0393\u0391\u03a4\u0399\u039a\u03a9\u039d \u0391\u03a4\u03a5\u03a7\u0397\u039c\u0391\u03a4\u03a9\u039d \u03a4\u03a9\u039d \u039d\u0391\u03a5\u03a4\u0399\u039a\u03a9\u039d",
            "\u03a5\u03a0\u0397\u03a1\u0395\u03a3\u0399\u0391 \u0391\u03a0\u039f\u039c\u0391\u0393\u039d\u0397\u03a4\u0399\u03a3\u0395\u03a9\u03a3 \u03a0\u039b\u039f\u0399\u03a9\u039d",
            "\u0394\u0399\u0391\u03a6\u039f\u03a1\u0395\u03a3 \u0395\u0399\u0394\u0399\u039a\u0395\u03a3 \u0394\u0399\u0391\u0394\u0399\u039a\u0391\u03a3\u0399\u0395\u03a3",
            "\u0393\u0395\u039d\u0399\u039a\u0397 \u0394\u0399\u0395\u03a5\u0398\u03a5\u039d\u03a3\u0397 \u03a4\u0397\u039b\u0395\u03a0\u0399\u039a\u039f\u0399\u039d\u03a9\u039d\u0399\u03a9\u039d",
            "\u0395\u0398\u039d\u0399\u039a\u0397 \u03a5\u03a0\u0397\u03a1\u0395\u03a3\u0399\u0391 \u03a0\u039b\u0397\u03a1\u039f\u03a6\u039f\u03a1\u0399\u03a9\u039d (\u0395.\u03a5.\u03a0.)",
            "\u03a4\u0391\u039c\u0395\u0399\u039f \u0395\u03a0\u0399\u039a\u039f\u03a5\u03a1\u0399\u039a\u0397\u03a3 \u0391\u03a3\u03a6\u0391\u039b\u0399\u03a3\u0395\u03a9\u03a3 \u039c\u0399\u03a3\u0398\u03a9\u03a4\u03a9\u039d (T.E.A.M)",
            "\u0391\u03a3\u03a6\u0391\u039b\u0399\u03a3\u0397 \u039a\u0391\u03a4\u0391 \u03a4\u0397\u03a3 \u0391\u039d\u0395\u03a1\u0393\u0399\u0391\u03a3 - \u039f\u03a1\u0393\u0391\u039d\u0399\u03a3\u039c\u039f\u03a3 \u0391\u03a0\u0391\u03a3\u03a7\u039f\u039b\u0397\u03a3\u0397\u03a3 \u0395\u03a1\u0393\u0391\u03a4\u0399\u039a\u039f\u03a5 \u0394\u03a5\u039d\u0391\u039c\u0399\u039a\u039f\u03a5",
            "\u03a3\u03a9\u039c\u0391\u03a4\u0399\u039a\u0397 \u0399\u039a\u0391\u039d\u039f\u03a4\u0397\u03a4\u0391 \u03a0\u03a1\u039f\u03a3\u03a9\u03a0\u0399\u039a\u039f\u03a5 \u03a3\u03a4\u03a1\u0391\u03a4\u0395\u03a5\u039c\u0391\u03a4\u039f\u03a3",
            "\u039f\u0399\u039a\u039f\u039d\u039f\u039c\u0399\u039a\u0397 \u03a5\u03a0\u0397\u03a1\u0395\u03a3\u0399\u0391 \u03a0. \u039d\u0391\u03a5\u03a4\u0399\u039a\u039f\u03a5",
            "\u0394\u0391\u03a3\u0399\u039a\u0397 \u03a6\u039f\u03a1\u039f\u039b\u039f\u0393\u0399\u0391",
            "\u0391\u03a4\u0395\u039b\u0395\u0399\u0395\u03a3 \u03a5\u03a0\u0395\u03a1 \u03a4\u0397\u03a3 \u039a\u03a4\u0397\u039d\u039f\u03a4\u03a1\u039f\u03a6\u0399\u0391\u03a3, \u039c\u0395\u039b\u0399\u03a3\u03a3\u039f\u039a\u039f\u039c\u0399\u0391\u03a3 \u039a.\u039b.\u03a0",
            "\u03a0\u039f\u039b\u0399\u03a4\u0399\u039a\u0391 \u0394\u0399\u039a\u0391\u0399\u03a9\u039c\u0391\u03a4\u0391 \u03a4\u03a9\u039d \u0393\u03a5\u039d\u0391\u0399\u039a\u03a9\u039d",
            "\u039c\u0395\u03a4\u0391\u0398\u0395\u03a3\u0395\u0399\u03a3 \u0395\u039a\u03a0\u0391\u0399\u0394\u0395\u03a5\u03a4\u0399\u039a\u03a9\u039d",
            "\u0394\u0399\u0395\u0398\u039d\u0395\u03a3 \u039a\u0395\u039d\u03a4\u03a1\u039f \u03a5\u03a0\u039f\u039b\u039f\u0393\u0399\u03a3\u039c\u039f\u03a5",
            "\u0394\u0399\u0391\u03a7\u0395\u0399\u03a1\u0399\u03a3\u0397 \u0394\u0391\u03a3\u03a9\u039d",
            "\u0394\u039f\u03a5\u039b\u0395\u0399\u0391",
            "\u039c\u0395 \u03a4\u0397 \u03a0\u039f\u039b\u03a9\u039d\u0399\u0391",
            "\u0391\u039d\u0391\u0394\u0399\u0391\u039d\u039f\u039c\u0397 \u039a\u03a4\u0397\u039c\u0391\u03a4\u03a9\u039d",
            "\u03a5\u03a0\u039f\u0391\u03a0\u0391\u03a3\u03a7\u039f\u039b\u039f\u03a5\u039c\u0395\u039d\u039f\u0399 \u039c\u0399\u03a3\u0398\u03a9\u03a4\u039f\u0399",
            "\u039f\u03a1\u0393\u0391\u039d\u0399\u03a3\u039c\u039f\u0399 \u03a0\u03a1\u03a9\u0397\u039d \u03a5.\u0392.\u0395.\u03a4. - \u0393.\u0393.\u0392. - \u0393.\u0393.\u0395.\u03a4",
            "\u03a0\u0391\u039d\u0395\u03a0\u0399\u03a3\u03a4\u0397\u039c\u0399\u0391\u039a\u0397 \u0392\u0399\u0392\u039b\u0399\u039f\u0398\u0397\u039a\u0397 \u0391\u0398\u0397\u039d\u03a9\u039d",
            "\u03a4\u0391\u039c\u0395\u0399\u039f \u0391\u03a3\u03a6\u0391\u039b\u0399\u03a3\u0395\u03a9\u03a3 \u03a0\u03a1\u039f\u03a3\u03a9\u03a0\u0399\u039a\u039f\u03a5 \u0391\u03a3\u03a6\u0391\u039b\u0399\u03a3\u03a4.\u0395\u03a4\u0391\u0399\u03a1\u0395\u0399\u0391\u03a3 \u0397 \u0395\u0398\u039d\u0399\u039a\u0397 (\u03a4.\u0391.\u03a0.\u0391.\u0395. \u0397 \u0395\u0398\u039d\u0399\u039a\u0397)",
            "\u03a4\u0395\u039b\u0397 \u03a3\u03a7\u039f\u039b\u0391\u0396\u039f\u03a5\u03a3\u03a9\u039d \u039a\u039b\u0397\u03a1\u039f\u039d\u039f\u039c\u0399\u03a9\u039d",
            "\u039e\u0395\u039d\u0395\u03a3 \u0393\u039b\u03a9\u03a3\u03a3\u0395\u03a3",
            "\u039a\u0391\u03a4\u0391\u03a3\u039a\u0397\u039d\u03a9\u03a3\u0395\u0399\u03a3 - \u03a0\u0391\u0399\u0394\u0399\u039a\u0395\u03a3 \u0395\u039e\u039f\u03a7\u0395\u03a3",
            "\u0394\u0399\u039a\u0391\u03a3\u03a4\u0397\u03a1\u0399\u0391 \u0391\u039d\u0397\u039b\u0399\u039a\u03a9\u039d",
            "\u03a3\u03a5\u039c\u0392\u0391\u03a3\u0395\u0399\u03a3 \u0395\u039a\u03a4\u0395\u039b\u0395\u03a3\u0395\u03a9\u03a3 \u0391\u039b\u039b\u039f\u0394\u0391\u03a0\u03a9\u039d \u0391\u03a0\u039f\u03a6\u0391\u03a3\u0395\u03a9\u039d",
            "\u03a6\u039f\u03a1\u039f\u03a3 \u0395\u0399\u03a3\u039f\u0394\u0397\u039c\u0391\u03a4\u039f\u03a3 \u039d\u039f\u039c\u0399\u039a\u03a9\u039d \u03a0\u03a1\u039f\u03a3\u03a9\u03a0\u03a9\u039d",
            "\u0398\u0395\u03a9\u03a1\u0397\u03a4\u0399\u039a\u0391 \u039a\u0391\u0399 \u0399\u03a3\u03a4\u039f\u03a1\u0399\u039a\u0391 \u039c\u0391\u0398\u0397\u039c\u0391\u03a4\u0391",
            "\u0391\u03a6\u03a1\u039f\u0394\u0399\u03a3\u0399\u0391",
            "\u03a6\u0391\u03a1\u039f\u0399",
            "\u0394\u0397\u039c\u039f\u03a3\u0399\u039f\u0393\u03a1\u0391\u03a6\u0399\u039a\u039f \u0395\u03a0\u0391\u0393\u0393\u0395\u039b\u039c\u0391",
            "\u039a\u0391\u03a4\u0391\u03a3\u03a4\u0391\u03a4\u0399\u039a\u039f\u03a3 \u039d\u039f\u039c\u039f\u03a3 \u0395\u039a\u039a\u039b\u0397\u03a3\u0399\u0391\u03a3 \u03a4\u0397\u03a3 \u0395\u039b\u039b\u0391\u0394\u039f\u03a3",
            "\u0395\u039b\u0395\u0393\u03a7\u039f\u03a3 \u03a3\u039a\u039f\u03a0\u0399\u039c\u039f\u03a4\u0397\u03a4\u0391\u03a3 \u0399\u0394\u03a1\u03a5\u03a3\u0395\u03a9\u03a3 \u0392\u0399\u039f\u039c\u0397\u03a7\u0391\u039d\u0399\u03a9\u039d",
            "\u0393\u03a5\u039c\u039d\u0391\u03a3\u0399\u0391 \u039a\u0391\u0399 \u039b\u03a5\u039a\u0395\u0399\u0391",
            "\u0391\u0395\u03a1\u039f\u039d\u0391\u03a5\u03a4\u0399\u039a\u0395\u03a3 \u03a0\u039b\u0397\u03a1\u039f\u03a6\u039f\u03a1\u0399\u0395\u03a3",
            "\u039a\u0391\u03a4\u0391\u03a3\u03a4\u0391\u03a3\u0397 \u03a5\u03a0\u0391\u039e\u0399\u03a9\u039c\u0391\u03a4\u0399\u039a\u03a9\u039d \u03a0.\u039d",
            "\u03a5\u03a0\u039f\u03a5\u03a1\u0393\u0395\u0399\u039f \u03a7\u03a9\u03a1\u039f\u03a4\u0391\u039e\u0399\u0391\u03a3",
            "\u0395\u039a\u03a4\u0395\u039b\u0395\u03a3\u0397 \u0384\u0395\u03a1\u0393\u03a9\u039d",
            "\u039c\u0399\u03a3\u0398\u039f\u0394\u039f\u03a3\u0399\u0391 \u03a5\u03a0\u0391\u039b\u039b\u0397\u039b\u03a9\u039d \u03a3\u0395 \u0395\u03a0\u0399\u03a3\u03a4\u03a1\u0391\u03a4\u0395\u03a5\u03a3\u0397",
            "\u039a\u039f\u0399\u039c\u0397\u03a4\u0397\u03a1\u0399\u0391",
            "\u0391\u03a3\u03a6\u0391\u039b\u0399\u03a3\u03a4\u0399\u039a\u039f\u03a3 \u039f\u03a1\u0393\u0391\u039d\u0399\u03a3\u039c\u039f\u03a3 \u039a\u0399\u039d\u0394\u03a5\u039d\u03a9\u039d \u03a0\u039f\u039b\u0395\u039c\u039f\u03a5",
            "\u03a3\u03a5\u039c\u03a6\u03a9\u039d\u0399\u0391 \u0393\u0399\u0391 \u0391\u039d\u0399\u0398\u0391\u0393\u0395\u039d\u0395\u0399\u03a3",
            "\u039d\u039f\u039c\u0391\u03a1\u03a7\u0399\u0391\u039a\u0397 \u0391\u03a5\u03a4\u039f\u0394\u0399\u039f\u0399\u039a\u0397\u03a3\u0397",
            "\u03a3\u03a7\u039f\u039b\u0397 \u03a4\u039f\u03a5\u03a1\u0399\u03a3\u03a4\u0399\u039a\u03a9\u039d \u0395\u03a0\u0391\u0393\u0393\u0395\u039b\u039c\u0391\u03a4\u03a9\u039d",
            "\u03a4\u0391\u039c\u0395\u0399\u039f \u0395\u03a0\u0399\u039a\u039f\u03a5\u03a1\u0399\u039a\u0397\u03a3 \u0391\u03a3\u03a6\u0391\u039b\u0399\u03a3\u0395\u03a9\u03a3 \u039c\u0399\u03a3\u0398\u03a9\u03a4\u03a9\u039d \u03a0\u0391\u03a1\u0391\u0393\u03a9\u0393\u0397\u03a3 \u039a\u0391\u0399 \u0395\u039c\u03a0\u039f\u03a1\u0399\u0391\u03a3 \u039f\u03a0\u03a9\u03a1\u039f\u039a\u0397\u03a0\u0395\u03a5\u03a4\u0399\u039a\u03a9\u039d",
            "\u0391\u03a0\u039f\u039b\u03a5\u039c\u0391\u039d\u03a3\u0397 \u03a5\u0394\u0391\u03a4\u03a9\u039d",
            "\u03a0\u039f\u039b\u0395\u039f\u0394\u039f\u039c\u0399\u039a\u0395\u03a3 \u0395\u03a0\u0399\u03a4\u03a1\u039f\u03a0\u0395\u03a3",
            "\u039f\u03a1\u0393\u0391\u039d\u0399\u03a3\u039c\u039f\u03a3 \u0395\u039a\u0394\u039f\u03a3\u0395\u03a9\u03a3 \u03a3\u03a7\u039f\u039b\u0399\u039a\u03a9\u039d \u0392\u0399\u0392\u039b\u0399\u03a9\u039d",
            "\u03a5\u03a0\u0391\u039b\u039b\u0397\u039b\u039f\u0399 \u039d\u039f\u039c. \u03a0\u03a1\u039f\u03a3\u03a9\u03a0\u03a9\u039d \u0394\u0397\u039c\u039f\u03a3\u0399\u039f\u03a5 \u0394\u0399\u039a\u0391\u0399\u039f\u03a5",
            "\u0391\u039d\u03a4\u0399\u03a3\u03a4\u0391\u0398\u039c\u0399\u03a3\u03a4\u0399\u039a\u0397 \u0395\u0399\u03a3\u03a6\u039f\u03a1\u0391",
            "\u03a0\u03a1\u039f\u03a3\u03a9\u03a0\u0399\u039a\u039f \u0399\u0394\u0399\u03a9\u03a4\u0399\u039a\u03a9\u039d \u0395\u039a\u03a0\u0391\u0399\u0394\u0395\u03a5\u03a4\u0397\u03a1\u0399\u03a9\u039d",
            "\u0394\u0399\u0395\u0398\u039d\u0395\u0399\u03a3 \u03a3\u03a5\u039c\u0392\u0391\u03a3\u0395\u0399\u03a3 \u0393\u0399\u0391 \u03a4\u0391 \u0391\u03a5\u03a4\u039f\u039a\u0399\u039d\u0397\u03a4\u0391",
            "\u0395\u039e\u03a9\u03a3\u03a7\u039f\u039b\u0399\u039a\u0397 \u0391\u0393\u03a9\u0393\u0397",
            "\u0391\u03a3\u03a6\u0391\u039b\u0399\u03a3\u03a4\u0399\u039a\u0397 \u0391\u03a1\u039c\u039f\u0394\u0399\u039f\u03a4\u0397\u03a4\u0391",
            "\u0395\u039b\u0399\u0395\u03a3 \u039a\u0391\u0399 \u0395\u039b\u0391\u0399\u0391",
            "\u0393\u0391\u039c\u039f\u0399 \u0399\u03a3\u03a1\u0391\u0397\u039b\u0399\u03a4\u03a9\u039d",
            "\u03a4\u0391\u039c\u0395\u0399\u039f \u0391\u03a1\u03a4\u039f\u03a5",
            "\u039a\u0391\u039d\u039f\u039d\u0399\u03a3\u039c\u039f\u03a3 \u0395\u03a0\u0399\u03a4\u03a1\u039f\u03a0\u03a9\u039d",
            "\u03a3\u03a5\u039c\u0392\u0391\u03a3\u0397 \u039a\u0391\u03a4\u0391 \u0394\u0391\u0393\u039a\u0395\u0399\u039f\u03a5",
            "\u0395\u0398\u039d\u0399\u039a\u039f\u0399 \u0394\u03a1\u03a5\u039c\u039f\u0399",
            "\u0391\u03a0\u0391\u039b\u039b\u0391\u0393\u0395\u03a3 \u03a4\u0395\u039b\u03a9\u039d \u03a7\u0391\u03a1\u03a4\u039f\u03a3\u0397\u039c\u039f\u03a5",
            "\u0394\u0399\u0395\u0398\u039d\u0397\u03a3 \u039f\u03a1\u0393\u0391\u039d\u0399\u03a3\u039c\u039f\u03a3 \u0391\u039d\u0391\u03a0\u03a4\u03a5\u039e\u0395\u03a9\u03a3",
            "\u039a\u0391\u039d\u039f\u039d\u0399\u03a3\u039c\u039f\u03a3 \u0395\u03a1\u0393\u0391\u03a3\u0399\u0391\u03a3 \u0395\u03a0\u0399 \u03a6\u039f\u03a1\u03a4\u0397\u0393\u03a9\u039d \u03a0\u039b\u039f\u0399\u03a9\u039d",
            "\u039b\u03a5\u03a3\u03a3\u0391",
            "\u0391\u0393\u03a1\u039f\u039a\u03a4\u0397\u039c\u0391",
            "\u039a\u0391\u0398\u0397\u0393\u0397\u03a4\u0395\u03a3 \u039a\u0391\u0399 \u03a5\u03a6\u0397\u0393\u0397\u03a4\u0395\u03a3",
            "\u03a0\u0391\u0399\u0394\u0399\u039a\u039f\u0399 - \u0392\u03a1\u0395\u03a6\u039f\u039d\u0397\u03a0\u0399\u0391\u039a\u039f\u0399 \u03a3\u03a4\u0391\u0398\u039c\u039f\u0399",
            "\u039a\u0395\u039d\u03a4\u03a1\u039f \u0392\u03a5\u0396\u0391\u039d\u03a4\u0399\u039d\u03a9\u039d \u0395\u03a1\u0395\u03a5\u039d\u03a9\u039d",
            "\u0399\u0394\u03a1\u03a5\u03a3\u0397 \u0395\u039b\u0395\u03a5\u0398\u0395\u03a1\u0397\u03a3 \u0396\u03a9\u039d\u0397\u03a3 \u03a3\u0395 \u0394\u0399\u0391\u03a6\u039f\u03a1\u0391 \u039b\u0399\u039c\u0391\u039d\u0399\u0391 \u03a4\u0397\u03a3 \u03a7\u03a9\u03a1\u0391\u03a3",
            "\u03a3\u03a7\u039f\u039b\u0399\u039a\u0391 \u039b\u0395\u03a9\u03a6\u039f\u03a1\u0395\u0399\u0391",
            "\u03a3\u03a6\u0391\u0393\u0395\u0399\u0391",
            "\u0395\u03a0\u0399\u039a\u03a5\u03a1\u03a9\u03a3\u0397 \u039d\u039f\u039c\u039f\u0398\u0395\u03a4\u0397\u039c\u0391\u03a4\u03a9\u039d",
            "\u0395\u0393\u0393\u03a1\u0391\u03a6\u0391 \u03a4\u0391\u03a5\u03a4\u039f\u03a4\u0397\u03a4\u0391\u03a3 \u039d\u0391\u03a5\u03a4\u0399\u039a\u03a9\u039d",
            "\u0391\u03a4\u039f\u039c\u0399\u039a\u0391 \u0394\u0399\u039a\u0391\u0399\u03a9\u039c\u0391\u03a4\u0391 - \u0394\u0395\u0394\u039f\u039c\u0395\u039d\u0391 \u03a0\u03a1\u039f\u03a3\u03a9\u03a0\u0399\u039a\u039f\u03a5 \u03a7\u0391\u03a1\u0391\u039a\u03a4\u0397\u03a1\u0391",
            "\u0399\u0391\u03a4\u03a1\u039f\u03a6\u0391\u03a1\u039c\u0391\u039a\u0395\u03a5\u03a4\u0399\u039a\u0397 - \u039d\u039f\u03a3\u039f\u039a\u039f\u039c\u0395\u0399\u0391\u039a\u0397 \u03a0\u0395\u03a1\u0399\u0398\u0391\u039b\u03a8\u0397 - \u0395\u039e\u039f\u0394\u0391 \u039a\u0397\u0394\u0395\u0399\u0391\u03a3",
            "\u03a5\u03a0\u0397\u03a1\u0395\u03a3\u0399\u0391 \u0394\u0399\u0391\u03a7\u0395\u0399\u03a1\u0399\u03a3\u0395\u03a9\u03a3 \u0391\u039d\u03a4\u0391\u039b\u039b\u0391\u039e\u0399\u039c\u03a9\u039d \u039a\u03a4\u0397\u039c\u0391\u03a4\u03a9\u039d",
            "\u03a3\u03a4\u039f\u039b\u0395\u03a3 \u03a0\u03a1\u039f\u03a3\u03a9\u03a0\u0399\u039a\u039f\u03a5 \u039b.\u03a3",
            "\u03a0\u0395\u03a1\u0399\u03a6\u03a1\u0391\u039e\u0397 \u039f\u0399\u039a\u039f\u03a0\u0395\u0394\u03a9\u039d",
            "\u03a3\u0399\u0394\u0397\u03a1\u039f\u0394\u03a1\u039f\u039c\u039f\u0399 \u0391\u03a4\u03a4\u0399\u039a\u0397\u03a3",
            "\u03a4\u03a1\u0391\u03a7\u03a9\u039c\u0391\u03a4\u0391",
            "\u039d\u0391\u03a5\u0391\u0393\u0399\u0391-\u039d\u0391\u03a5\u0391\u0393\u0399\u0391\u0399\u03a1\u0395\u03a3\u0397",
            "\u03a5\u03a0\u039f\u039c\u0397\u03a7\u0391\u039d\u0399\u039a\u039f\u0399",
            "\u03a4\u0391\u0399\u039d\u0399\u039f\u0398\u0397\u039a\u0397 \u03a4\u0397\u03a3 \u0395\u039b\u039b\u0391\u0394\u039f\u03a3",
            "\u039a\u0391\u039d\u039f\u039d\u0399\u03a3\u039c\u039f\u03a3 \u03a4\u0397\u039b\u0395\u0393\u03a1\u0391\u03a6\u0399\u039a\u0397\u03a3 \u03a5\u03a0\u0397\u03a1\u0395\u03a3\u0399\u0391\u03a3",
            "\u03a3\u03a5\u039d\u03a4\u0391\u039e\u0395\u0399\u03a3 \u0398\u03a5\u039c\u0391\u03a4\u03a9\u039d \u03a4\u03a1\u039f\u039c\u039f\u039a\u03a1\u0391\u03a4\u0399\u0391\u03a3",
            "\u039a\u0391\u039d\u039f\u039d\u0399\u03a3\u039c\u039f\u03a3 \u03a0\u03a5\u03a1\u0399\u039c\u0391\u03a7\u039f\u03a5 \u03a0\u03a1\u039f\u03a3\u03a4\u0391\u03a3\u0399\u0391\u03a3 \u0395\u03a0\u0399\u0392\u0391\u03a4\u0397\u0393\u03a9\u039d \u03a0\u039b\u039f\u0399\u03a9\u039d",
            "\u0391\u03a4\u039f\u039c\u0399\u039a\u0391 \u0392\u0399\u0392\u039b\u0399\u0391\u03a1\u0399\u0391",
            "\u0395\u03a0\u0391\u0393\u0393\u0395\u039b\u039c\u0391\u03a4\u0399\u039a\u0391 \u0392\u0399\u0392\u039b\u0399\u0391\u03a1\u0399\u0391 \u0391\u03a1\u03a4\u0395\u03a1\u0393\u0391\u03a4\u03a9\u039d \u039a\u039b\u03a0",
            "\u03a6\u039f\u03a1\u039f\u039b\u039f\u0393\u0399\u0391 \u0391\u039c\u03a5\u039b\u039f\u03a3\u0399\u03a1\u039f\u03a0\u0399\u039f\u03a5, \u03a3\u03a4\u0391\u03a6\u0399\u0394\u0399\u039d\u0397\u03a3 \u039a\u039b\u03a0",
            "\u039c\u039f\u03a5\u03a3\u0395\u0399\u039f \u0395\u039b\u039b\u0397\u039d\u0399\u039a\u03a9\u039d \u039b\u0391\u0399\u039a\u03a9\u039d \u039f\u03a1\u0393\u0391\u039d\u03a9\u039d",
            "\u0395\u03a0\u0399\u039a\u039f\u03a5\u03a1\u0399\u039a\u039f \u03a4\u0391\u039c\u0395\u0399\u039f \u03a0\u03a1\u039f\u039d\u039f\u0399\u0391\u03a3 \u039a\u0391\u0399 \u03a0\u0395\u03a1\u0399\u0398\u0391\u039b\u03a8\u0395\u03a9\u03a3 \u03a0\u03a1\u039f\u03a3\u03a9\u03a0\u0399\u039a\u039f\u03a5 \u0395\u039b\u039b\u0397\u039d. \u0397\u039b\u0395\u039a\u03a4\u03a1. \u0395\u03a4\u0391\u0399\u03a1\u0399\u0391\u03a3 (\u0395.\u0397.\u0395.)",
            "\u03a4\u0391\u039c\u0395\u0399\u0391 \u039c\u039f\u039d\u0399\u039c\u03a9\u039d \u039f\u0394\u039f\u03a3\u03a4\u03a1\u03a9\u039c\u0391\u03a4\u03a9\u039d",
            "\u039f\u03a1\u0393\u0391\u039d\u0399\u039a\u0395\u03a3 \u0398\u0395\u03a3\u0395\u0399\u03a3 \u0391\u039e\u0399\u03a9\u039c\u0391\u03a4\u0399\u039a\u03a9\u039d \u03a0.\u039d",
            "\u03a4\u0391\u039c\u0395\u0399\u039f \u03a3\u03a5\u039d\u03a4\u0391\u039e\u0395\u03a9\u039d \u03a0\u03a1\u039f\u03a3\u03a9\u03a0\u0399\u039a\u039f\u03a5 \u03a4\u03a1\u0391\u03a0\u0395\u0396\u0391\u03a3 \u0391\u0398\u0397\u039d\u03a9\u039d",
            "\u03a0\u039f\u039b\u0399\u039f\u039c\u03a5\u0395\u039b\u0399\u03a4\u0399\u0394\u0391",
            "\u03a0\u03a1\u039f\u0391\u0393\u03a9\u0393\u0391\u0399 \u0391\u039e\u0399\u03a9\u039c\u0391\u03a4\u0399\u039a\u03a9\u039d \u03a7\u03a9\u03a1\u039f\u03a6\u03a5\u039b\u0391\u039a\u0397\u03a3",
            "\u0395\u03a0\u0399\u0394\u039f\u039c\u0391 \u0391\u0394\u0395\u0399\u0391\u03a3",
            "\u0395\u039e\u0395\u03a4\u0391\u03a3\u0395\u0399\u03a3 \u0393\u0399\u0391 \u03a4\u0397\u039d \u03a0\u03a1\u039f\u03a3\u039b\u0397\u03a8\u0397 \u03a0\u03a1\u039f\u03a3\u03a9\u03a0\u0399\u039a\u039f\u03a5",
            "\u0395\u039b\u0395\u0393\u03a7\u039f\u03a3 \u0395\u039e\u0391\u0393\u03a9\u0393\u0399\u039a\u039f\u03a5 \u0395\u039c\u03a0\u039f\u03a1\u0399\u039f\u03a5",
            "\u03a1\u0391\u0394\u0399\u039f\u03a6\u03a9\u039d\u0399\u039a\u039f\u0399 \u03a3\u03a4\u0391\u0398\u039c\u039f\u0399",
            "\u039a\u0391\u039d\u039f\u039d\u0399\u03a3\u039c\u039f\u03a3 \u0394\u0399\u039f\u0399\u039a\u0397\u03a4\u0399\u039a\u0397\u03a3 \u039f\u03a1\u0393\u0391\u039d\u03a9\u03a3\u0395\u03a9\u03a3 \u03a4.\u03a3.\u0391.\u03a5",
            "\u03a6.\u039a.\u03a0. \u0391\u039d\u03a9\u039d\u03a5\u039c\u03a9\u039d \u0395\u03a4\u0391\u0399\u03a1\u0395\u0399\u03a9\u039d",
            "\u0394\u0399\u0391\u03a6\u039f\u03a1\u039f\u0399 \u03a0\u039f\u039b\u03a5\u0395\u0398\u039d\u0395\u0399\u03a3 \u039f\u03a1\u0393\u0391\u039d\u0399\u03a3\u039c\u039f\u0399",
            "\u03a7\u039f\u039b\u0395\u03a1\u0391",
            "E\u039d\u0399\u0391\u0399\u039f\u03a3 \u0394\u0397\u039c\u039f\u03a3\u0399\u039f\u0393\u03a1\u0391\u03a6\u0399\u039a\u039f\u03a3 \u039f\u03a1\u0393\u0391\u039d\u0399\u03a3\u039c\u039f\u03a3",
            "\u0391\u03a4\u0395\u039b\u0395\u0399\u0395\u03a3 \u0394\u0397\u039c\u039f\u03a3\u0399\u03a9\u039d \u03a5\u03a0\u0397\u03a1\u0395\u03a3\u0399\u03a9\u039d",
            "\u03a4\u0391\u039c\u0395\u0399\u039f \u03a0\u03a1\u039f\u039d\u039f\u0399\u0391\u03a3 \u039c\u0397\u03a7\u0391\u039d\u039f\u0394\u0397\u0393\u03a9\u039d \u039f\u0394\u039f\u03a3\u03a4\u03a1\u03a9\u03a4\u0397\u03a1\u03a9\u039d \u039a\u039b\u03a0",
            "\u039d\u039f\u03a3\u039f\u039a\u039f\u039c\u039f\u0399",
            "\u039d\u039f\u03a3\u039f\u039a\u039f\u039c\u0395\u0399\u0391 \u03a6\u03a5\u039b\u0391\u039a\u03a9\u039d",
            "\u0391\u03a0\u039f\u039a\u0391\u03a4\u0391\u03a3\u03a4\u0391\u03a3\u0397 \u039a\u03a4\u0397\u039d\u039f\u03a4\u03a1\u039f\u03a6\u03a9\u039d",
            "\u03a4\u0395\u039b\u0397 \u039a\u0391\u0399 \u0395\u0399\u03a3\u03a6\u039f\u03a1\u0395\u03a3",
            "\u0391\u039a\u0391\u03a4\u0391\u03a3\u03a7\u0395\u03a4\u0391",
            "\u039e\u0395\u039d\u039f\u0394\u039f\u03a7\u0395\u0399\u0391\u039a\u039f \u0395\u03a0\u0399\u039c\u0395\u039b\u0397\u03a4\u0397\u03a1\u0399\u039f \u03a4\u0397\u03a3 \u0395\u039b\u039b\u0391\u0394\u0391\u03a3",
            "\u0394\u0397\u039c\u039f\u03a4\u039f\u039b\u039f\u0393\u0399\u0391",
            "\u03a3\u03a4\u0391\u03a4\u0399\u03a3\u03a4\u0399\u039a\u0397 \u03a5\u03a0\u0397\u03a1\u0395\u03a3\u0399\u0391",
            "\u039a\u03a1\u0391\u03a4\u0399\u039a\u039f \u0395\u03a1\u0393\u0391\u03a3\u03a4\u0397\u03a1\u0399\u039f \u0395\u039b\u0395\u0393\u03a7\u039f\u03a5 \u03a6\u0391\u03a1\u039c\u0391\u039a\u03a9\u039d",
            "\u0391\u0395\u03a1\u039f\u03a0\u039f\u03a1\u0399\u039a\u0397 \u0391\u03a3\u03a4\u03a5\u039d\u039f\u039c\u0399\u0391",
            "\u0395\u039a\u03a4\u0391\u039a\u03a4\u0395\u03a3 \u0395\u0399\u03a3\u03a6\u039f\u03a1\u0395\u03a3",
            "\u03a3\u03a5\u039d\u03a4\u0391\u039e\u0395\u0399\u03a3 \u03a5\u03a0\u0391\u039b\u039b\u0397\u039b\u03a9\u039d \u03a4.\u03a4.\u03a4",
            "\u039c\u0395\u03a4\u03a1\u0391 \u039a\u0391\u03a4\u0391 \u03a4\u0397\u03a3 \u03a6\u039f\u03a1\u039f\u0394\u0399\u0391\u03a6\u03a5\u0393\u0397\u03a3",
            "\u0395\u0394\u0391\u03a6\u0399\u039a\u0397 \u0395\u03a0\u0395\u039a\u03a4\u0391\u03a3\u0397 \u039d\u039f\u039c\u039f\u0398\u0395\u03a3\u0399\u0391\u03a3",
            "\u039c\u0399\u039a\u03a1\u039f\u0394\u0399\u0391\u03a6\u039f\u03a1\u0395\u03a3",
            "\u03a4\u0391\u03a4\u0396\u0399\u039a\u0399\u03a3\u03a4\u0391\u039d \u2013 \u03a4\u0391\u03a5\u039b\u0391\u039d\u0394\u0397 \u2013 \u03a4\u039f\u03a5\u03a1\u039a\u0399\u0391 \u039a.\u039b\u03a0",
            "\u03a3\u03a5\u039c\u0392\u0391\u03a3\u0397 \u0394\u0399\u0395\u0398\u039d\u039f\u03a5\u03a3 \u039c\u0395\u03a4\u0391\u03a6\u039f\u03a1\u0391\u03a3 \u0395\u039c\u03a0\u039f\u03a1\u0395\u03a5\u039c\u0391\u03a4\u03a9\u039d \u039f\u0394\u0399\u039a\u03a9\u03a3",
            "\u039a\u03a9\u0394\u0399\u039a\u0391\u03a3 \u0399\u0394\u0399\u03a9\u03a4\u0399\u039a\u039f\u03a5 \u039d\u0391\u03a5\u03a4\u0399\u039a\u039f\u03a5 \u0394\u0399\u039a\u0391\u0399\u039f\u03a5",
            "\u039a\u0395\u039d\u03a4\u03a1\u0391 \u0393\u0395\u03a9\u03a1\u0393\u0399\u039a\u0397\u03a3 \u0395\u039a\u03a0\u0391\u0399\u0394\u0395\u03a5\u03a3\u0397\u03a3-\u039f.\u0393.\u0395.\u0395.\u039a.\u0391",
            "\u03a4\u0391\u039c\u0395\u0399\u039f \u0395\u03a0\u0399\u039a\u039f\u03a5\u03a1\u0399\u039a\u0397\u03a3 \u0391\u03a3\u03a6\u0391\u039b\u0399\u03a3\u0395\u03a9\u03a3 \u03a0\u03a1\u039f\u03a3\u03a9\u03a0\u0399\u039a\u039f\u03a5 \u0399\u0394\u03a1\u03a5\u039c\u0391\u03a4\u03a9\u039d \u0395\u039c\u03a0\u039f\u03a1\u0399\u039a\u039f\u03a5 \u039d\u0391\u03a5\u03a4\u0399\u039a\u039f\u03a5",
            "\u0393\u03a1\u0391\u03a6\u0395\u0399\u039f \u0394\u0399\u0391\u03a1\u039a\u0397 \u039a\u03a9\u0394\u0399\u039a\u0391 \u039d\u039f\u039c\u039f\u0398\u0395\u03a3\u0399\u0391\u03a3",
            "\u0395\u03a1\u0395\u03a5\u039d\u0391 \u0399\u0394\u0399\u03a9\u03a4\u0399\u039a\u03a9\u039d \u039c\u0395\u03a4\u0391\u039b\u039b\u0395\u0399\u03a9\u039d",
            "\u0394\u0399\u0395\u03a5\u0398\u03a5\u039d\u03a3\u0397 \u0394\u0397\u039c\u039f\u03a3\u0399\u03a9\u039d \u0395\u03a1\u0393\u03a9\u039d \u0391\u0395\u03a1\u039f\u03a0\u039f\u03a1\u0399\u0391\u03a3",
            "\u03a0\u0395\u03a1\u0399 \u039d\u039f\u039c\u0391\u03a1\u03a7\u03a9\u039d",
            "\u03a3\u03a5\u039d\u03a4\u0391\u039e\u0395\u0399\u03a3 \u0398\u03a5\u039c\u0391\u03a4\u03a9\u039d \u0391\u03a0\u039f \u0395\u03a3\u03a9\u03a4\u0395\u03a1\u0399\u039a\u0395\u03a3 \u0394\u0399\u0391\u039c\u0391\u03a7\u0395\u03a3",
            "\u0394\u0399\u0391\u03a7\u0395\u0399\u03a1\u0399\u03a3\u0397 \u0395\u03a6\u039f\u0394\u0399\u03a9\u039d \u0395\u039e\u03a9\u03a4\u0395\u03a1\u0399\u039a\u039f\u03a5",
            "\u039f\u03a1\u0393\u0391\u039d\u03a9\u03a3\u0397 \u03a5\u03a0\u0397\u03a1\u0395\u03a3\u0399\u03a9\u039d \u03a0\u039f\u039b\u0395\u039c\u0399\u039a\u039f\u03a5 \u039d\u0391\u03a5\u03a4\u0399\u039a\u039f\u03a5",
            "\u03a6\u039f\u03a1\u03a4\u0397\u0393\u0391 \u03a0\u039b\u039f\u0399\u0391 \u0391\u039d\u03a9 \u03a4\u03a9\u039d 4.500 \u03a4\u039f\u039d\u039d\u03a9\u039d",
            "\u03a1\u0391\u0394\u0399\u039f\u03a4\u0397\u039b\u0395\u0393\u03a1\u0391\u03a6\u0399\u039a\u0397 \u03a5\u03a0\u0397\u03a1\u0395\u03a3\u0399\u0391 \u03a0\u039b\u039f\u0399\u03a9\u039d",
            "\u0395\u03a0\u0391\u0393\u0393\u0395\u039b\u039c\u0391\u03a4\u0399\u039a\u0395\u03a3 \u03a3\u03a7\u039f\u039b\u0395\u03a3",
            "\u0394\u0399\u0391\u03a6\u039f\u03a1\u0395\u03a3 \u0392\u0399\u039f\u039c\u0397\u03a7\u0391\u039d\u0399\u0395\u03a3",
            "\u03a3\u03a5\u039d\u03a4\u0397\u03a1\u0397\u03a3\u0397 \u0391\u0395\u03a1\u039f\u03a3\u039a\u0391\u03a6\u03a9\u039d",
            "\u039f\u039b\u03a5\u039c\u03a0\u0399\u0391\u039a\u0397 \u0391\u0395\u03a1\u039f\u03a0\u039f\u03a1\u0399\u0391",
            "\u039f\u03a1\u0393\u0391\u039d\u0399\u03a3\u039c\u039f\u03a3 \u03a7\u03a9\u03a1\u039f\u03a6\u03a5\u039b\u0391\u039a\u0397\u03a3",
            "\u03a0\u0395\u03a1\u0399\u0398\u0391\u039b\u03a8\u0397 \u03a6\u03a5\u039c\u0391\u03a4\u0399\u039a\u03a9\u039d \u03a4\u0391\u03a7\u03a5\u0394\u03a1\u039f\u039c\u0399\u039a\u03a9\u039d \u03a5\u03a0\u0391\u039b\u039b\u0397\u039b\u03a9\u039d",
            "\u039f\u03a1\u0393\u0391\u039d\u0399\u03a3\u039c\u039f\u03a3 \u03a7\u03a1\u0397\u039c\u0391\u03a4\u039f\u0394\u039f\u03a4\u0397\u03a3\u0397\u03a3 \u039f\u0399\u039a\u039f\u039d\u039f\u039c\u0399\u039a\u0397\u03a3 \u0391\u039d\u0391\u03a0\u03a4\u03a5\u039e\u0397\u03a3",
            "\u03a0\u03a1\u03a9\u03a4\u0395\u03a3 \u03a5\u039b\u0395\u03a3 \u039e\u03a5\u039b\u0399\u039d\u03a9\u039d \u0392\u0391\u03a1\u0395\u039b\u0399\u03a9\u039d",
            "\u03a4\u0391\u039c\u0395\u0399\u039f \u0391\u03a3\u03a6\u0391\u039b\u0399\u03a3\u0395\u03a9\u03a3 \u03a4\u0395\u03a7\u039d\u0399\u039a\u03a9\u039d \u03a4\u03a5\u03a0\u039f\u03a5 \u0391\u0398\u0397\u039d\u03a9\u039d (\u03a4.\u0391.\u03a4.\u03a4.\u0391.)",
            "\u03a0\u03a1\u039f\u03a0\u0391\u03a1\u0391\u03a3\u039a\u0395\u03a5\u0391\u03a3\u03a4\u0399\u039a\u0397 \u03a3\u03a7\u039f\u039b\u0397 \u039a\u0391\u039b\u03a9\u039d \u03a4\u0395\u03a7\u039d\u03a9\u039d \u03a4\u0397\u039d\u039f\u03a5",
            "\u039f\u0399\u039a\u039f\u039d\u039f\u039c\u0399\u039a\u0395\u03a3 \u0391\u039d\u03a4\u0399\u03a0\u03a1\u039f\u03a3\u03a9\u03a0\u0395\u0399\u0395\u03a3 \u0395\u039e\u03a9\u03a4\u0395\u03a1\u0399\u039a\u039f\u03a5",
            "\u039a\u0391\u039b\u039b\u0399\u03a4\u0395\u03a7\u039d\u0399\u039a\u039f\u0399 \u03a3\u03a4\u0391\u0398\u039c\u039f\u0399",
            "\u03a3\u03a5\u039c\u0392\u0391\u03a3\u0395\u0399\u03a3 \u0393\u0399\u0391 \u03a4\u0397 \u0392\u0399\u0391 \u03a4\u03a9\u039d",
            "\u03a0\u03a1\u039f\u03a3\u03a4\u0391\u03a3\u0399\u0391 \u0391\u039c\u03a0\u0395\u039b\u039f\u03a5\u03a1\u0393\u0399\u039a\u0397\u03a3 \u03a0\u0391\u03a1\u0391\u0393\u03a9\u0393\u0397\u03a3",
            "\u0394\u0399\u0391\u03a6\u039f\u03a1\u0391 \u0391\u0394\u0399\u039a\u0397\u039c\u0391\u03a4\u0391",
            "\u0391\u03a3\u03a4\u03a5\u039d\u039f\u039c\u0399\u0391 \u039a\u0391\u0399 \u0391\u03a3\u03a6\u0391\u039b\u0395\u0399\u0391 \u03a3\u0399\u0394\u0397\u03a1\u039f\u0394\u03a1\u039f\u039c\u03a9\u039d",
            "\u039c\u0395\u03a4\u039f\u03a7\u0399\u039a\u039f \u03a4\u0391\u039c\u0395\u0399\u039f \u0392\u0391\u03a3\u0399\u039b\u0399\u039a\u0397\u03a3 \u0391\u0395\u03a1\u039f\u03a0\u039f\u03a1\u0399\u0391\u03a3",
            "\u03a5\u03a0\u039f\u0398\u0397\u039a\u0397 \u039c\u0397\u03a7\u0391\u039d\u0399\u039a\u03a9\u039d \u0395\u0393\u039a\u0391\u03a4\u0391\u03a3\u03a4\u0391\u03a3\u0395\u03a9\u039d",
            "\u0395\u03a5\u0398\u03a5\u039d\u0397 \u0391\u03a0\u039f \u03a4\u2019\u0391\u03a5\u03a4\u039f\u039a\u0399\u039d\u0397\u03a4\u0391",
            "\u03a0\u03a1\u039f\u03a3\u03a4\u0391\u03a3\u0399\u0391 \u039c\u0397\u03a4\u03a1\u039f\u03a4\u0397\u03a4\u039f\u03a3 \u039a\u0391\u0399 \u0392\u03a1\u0395\u03a6\u03a9\u039d",
            "\u039c\u0395 \u03a4\u0397 \u03a6\u0399\u039b\u0391\u039d\u0394\u0399\u0391",
            "\u0395\u03a0\u0391\u03a1\u03a7\u0399\u0391\u039a\u039f\u03a3 \u03a4\u03a5\u03a0\u039f\u03a3",
            "\u0395\u03a0\u0399\u0398\u0395\u03a9\u03a1\u0397\u03a3\u0397 \u03a4\u0395\u039b\u03a9\u039d\u0395\u0399\u03a9\u039d",
            "\u0395\u03a0\u0399\u03a4\u03a1\u039f\u03a0\u0395\u0399\u0395\u03a3 \u03a4\u039f\u03a0\u03a9\u039d\u03a5\u039c\u0399\u03a9\u039d",
            "\u039c\u0395\u03a4\u0391\u039d\u0391\u03a3\u03a4\u0395\u03a5\u03a3\u0397 \u039a\u0391\u0399 \u0391\u03a0\u039f\u0394\u0397\u039c\u0399\u0391",
            "\u0394\u0399\u039a\u0397\u0393\u039f\u03a1\u0399\u039a\u039f\u0399 \u03a3\u03a5\u039b\u039b\u039f\u0393\u039f\u0399",
            "\u03a0\u03a1\u039f\u03a3\u03a9\u03a0\u0399\u039a\u039f \u03a5\u03a0\u039f\u03a5\u03a1\u0393\u0395\u0399\u039f\u03a5 \u0393\u0395\u03a9\u03a1\u0393\u0399\u0391\u03a3",
            "\u03a4\u039c\u0397\u039c\u0391 \u039f\u0399\u039a\u039f\u039d\u039f\u039c\u0399\u039a\u03a9\u039d \u0395\u03a0\u0399\u03a3\u03a4\u0397\u039c\u03a9\u039d \u03a0\u0391\u039d\u039c\u0399\u039f\u03a5 \u03a0\u0391\u03a4\u03a1\u03a9\u039d",
            "\u039c\u0391\u039b\u0391\u039a\u03a4\u0395\u03a3",
            "\u0395\u039b\u0391\u0399\u0391",
            "\u0391\u03a4\u039f\u039c\u0399\u039a\u0391 \u0395\u0393\u0393\u03a1\u0391\u03a6\u0391 \u0391\u039e\u0399\u03a9\u039c\u0391\u03a4\u0399\u039a\u03a9\u039d",
            "\u0391\u0393\u03a1\u039f\u03a4\u0399\u039a\u0397 \u03a4\u03a1\u0391\u03a0\u0395\u0396\u0391 \u03a4\u0397\u03a3 \u0395\u039b\u039b\u0391\u0394\u039f\u03a3",
            "\u039f\u03a0\u03a4\u0399\u039a\u039f\u0399 - \u039a\u0391\u03a4\u0391\u03a3\u03a4\u0397\u039c\u0391\u03a4\u0391 \u039f\u03a0\u03a4\u0399\u039a\u03a9\u039d \u0395\u0399\u0394\u03a9\u039d",
            "\u0394\u0397\u039c\u039f\u03a3\u0399\u0395\u03a3 \u0395\u03a0\u0395\u039d\u0394\u03a5\u03a3\u0395\u0399\u03a3",
            "\u039a\u03a1\u0391\u03a4\u0399\u039a\u0397 \u039f\u03a1\u03a7\u0397\u03a3\u03a4\u03a1\u0391 \u0398\u0395\u03a3\u03a3\u0391\u039b\u039f\u039d\u0399\u039a\u0397\u03a3",
            "\u039d\u0397\u039f\u039b\u039f\u0393\u0399\u0391-\u03a5\u03a0\u039f\u0398\u0397\u039a\u039f\u039b\u039f\u0393\u0399\u0391-\u03a3\u0397\u039c\u0391\u03a4\u039f\u039b\u039f\u0393\u0397\u03a3\u0397",
            "\u03a4\u0391\u039c\u0395\u0399\u039f \u03a3\u03a5\u039d\u03a4\u0391\u039e\u0395\u03a9\u039d \u03a0\u03a1\u039f\u03a3\u03a9\u03a0\u0399\u039a\u039f\u03a5 \u0395\u03a4\u0391\u0399\u03a1\u0395\u0399\u0391\u03a3 \u0394\u0399\u0391\u03a7\u0395\u0399\u03a1\u0399\u03a3\u0395\u03a9\u03a3 \u0395\u0399\u0394\u03a9\u039d \u039c\u039f\u039d\u039f\u03a0\u03a9\u039b\u0399\u039f\u03a5 (\u03a4.\u0391.\u03a0.-\u0395.\u0394.\u0395.\u039c.\u0395.)",
            "\u0395\u0399\u03a3\u03a0\u03a1\u0391\u039e\u0397 \u0391\u039e\u0399\u03a9\u039d",
            "\u03a5\u0393\u0395\u0399\u039f\u039d\u039f\u039c\u0399\u039a\u039f\u03a3 \u0395\u039b\u0395\u0393\u03a7\u039f\u03a3 \u03a4\u03a1\u039f\u03a6\u0399\u039c\u03a9\u039d-\u03a0\u039f\u03a4\u03a9\u039d-\u039d\u0395\u03a1\u03a9\u039d",
            "\u039b\u039f\u0393\u0399\u03a3\u03a4\u0395\u03a3 - \u03a6\u039f\u03a1\u039f\u03a4\u0395\u03a7\u039d\u0399\u039a\u039f\u0399",
            "\u0395\u0399\u0394\u0399\u039a\u0395\u03a3 \u0394\u0399\u039a\u039f\u039d\u039f\u039c\u0399\u039a\u0395\u03a3 \u0394\u0399\u0391\u03a4\u0391\u039e\u0395\u0399\u03a3 \u0393\u0399\u0391 \u03a4\u039f \u0394\u0397\u039c\u039f\u03a3\u0399\u039f",
            "\u03a3\u03a7\u039f\u039b\u0395\u03a3 \u03a3\u03a9\u039c\u0391\u03a4\u03a9\u039d \u0391\u03a3\u03a6\u0391\u039b\u0395\u0399\u0391\u03a3",
            "\u03a4\u0391\u039c\u0395\u0399\u039f\u039d \u039a\u039f\u0399\u039d\u03a9\u03a6\u0395\u039b\u03a9\u039d \u0395\u03a1\u0393\u03a9\u039d \u039b\u0395\u03a5\u039a\u0391\u0394\u039f\u03a3",
            "\u0395\u0399\u0394\u0399\u039a\u0397 \u0391\u0393\u03a9\u0393\u0397, \u0395\u0399\u0394\u0399\u039a\u0397 \u0395\u03a0\u0391\u0393\u0393\u0395\u039b\u039c\u0391\u03a4\u0399\u039a\u0397",
            "\u03a5\u03a0\u0397\u03a1\u0395\u03a3\u0399\u0391 \u039a\u03a1\u0391\u03a4\u0399\u039a\u03a9\u039d \u03a0\u03a1\u039f\u039c\u0397\u0398\u0395\u0399\u03a9\u039d",
            "\u039f\u0399\u039d\u039f\u039b\u039f\u0393\u0399\u039a\u0391 \u0399\u0394\u03a1\u03a5\u039c\u0391\u03a4\u0391",
            "\u03a3\u03a5\u039d\u0398\u0397\u039a\u0395\u03a3 \u0395\u039a\u0394\u039f\u03a3\u0395\u03a9\u03a3",
            "\u0391\u039e\u0399\u03a9\u039c\u0391\u03a4\u0399\u039a\u039f\u0399 \u039a\u0391\u0399 \u03a5\u03a0\u0391\u039e\u0399\u03a9\u039c\u0391\u03a4\u0399\u039a\u039f\u0399 \u039b.\u03a3",
            "\u03a5\u0393\u0395\u0399\u039f\u039d\u039f\u039c\u0399\u039a\u0397 \u0395\u039e\u0395\u03a4\u0391\u03a3\u0397 \u03a0\u03a1\u039f\u03a3\u03a9\u03a0\u0399\u039a\u039f\u03a5",
            "\u039e\u0395\u039d\u0391 \u03a3\u03a7\u039f\u039b\u0395\u0399\u0391 \u0397\u039c\u0395\u0394\u0391\u03a0\u0397\u03a3",
            "\u0395.\u03a3.\u03a5.-\u0393\u0395\u039d\u0399\u039a\u0395\u03a3 \u0394\u0399\u0391\u03a4\u0391\u039e\u0395\u0399\u03a3",
            "\u03a4\u0391\u039c\u0395\u0399\u0391 \u0395\u03a6\u0391\u03a1\u039c\u039f\u0393\u0397\u03a3 \u03a3\u03a7\u0395\u0394\u0399\u03a9\u039d \u03a0\u039f\u039b\u0395\u03a9\u039d",
            "\u03a3\u03a5\u039d\u0395\u03a4\u0391\u0399\u03a1\u0399\u03a3\u039c\u039f\u0399 \u03a3\u03a4\u03a1\u0391\u03a4\u0399\u03a9\u03a4\u0399\u039a\u03a9\u039d \u0395\u0399\u0394\u03a9\u039d",
            "\u03a3\u03a5\u039d\u0398\u0397\u039a\u0397 \u03a0\u0395\u03a1\u0399 \u0394\u0399\u0391\u03a3\u03a4\u0397\u039c\u0391\u03a4\u039f\u03a3",
            "\u0394\u0399\u0391\u03a7\u0395\u0399\u03a1\u0399\u03a3\u0397 \u0391\u039d\u03a4\u0391\u039b\u039b\u0391\u039e\u0399\u039c\u03a9\u039d \u039a\u03a4\u0397\u039c\u0391\u03a4\u03a9\u039d",
            "\u03a0\u03a1\u039f\u03a3\u03a9\u03a0\u0399\u039a\u039f\u039d \u0394\u0399\u039f\u0399\u039a\u0397\u03a3\u0395\u03a9\u03a3",
            "\u03a3\u03a7\u039f\u039b\u0397 \u0395\u039a\u03a0\u03a4\u0399\u039a\u03a9\u039d \u039b\u0395\u0399\u03a4\u039f\u03a5\u03a1\u0393\u03a9\u039d",
            "\u03a4\u0391\u039c\u0395\u0399\u039f \u0391\u03a3\u03a6\u0391\u039b\u0399\u03a3\u0395\u03a9\u03a3 \u039e\u0395\u039d\u039f\u0394\u039f\u03a7\u039f\u03a5\u03a0\u0391\u039b\u039b\u0397\u039b\u03a9\u039d (\u03a4.\u0391.\u039e.\u03a5.)",
            "\u03a3\u03a9\u039c\u0391\u03a4\u0399\u039a\u0397 \u0399\u039a\u0391\u039d\u039f\u03a4\u0397\u03a4\u0391 \u0391\u039e\u0399\u03a9\u039c\u0391\u03a4\u0399\u039a\u03a9\u039d",
            "\u0392\u0395\u0392\u0391\u0399\u03a9\u03a3\u0397 \u0395\u03a3\u039f\u0394\u03a9\u039d \u0394\u0397\u039c\u039f\u03a3\u0399\u039f\u03a5 \u0391\u03a0\u039f \u039c\u0395\u03a4\u0391\u039b\u039b\u0395\u0399\u0391 \u039a\u0391\u0399 \u039b\u0391\u03a4\u039f\u039c\u0395\u0399\u0391",
            "\u0394\u0399\u0391\u03a6\u039f\u03a1\u039f\u0399 \u0395\u03a0\u039f\u0399\u039a\u0399\u03a3\u03a4\u0399\u039a\u039f\u0399 \u039d\u039f\u039c\u039f\u0399",
            "\u0395\u03a0\u0399\u039a\u039f\u03a5\u03a1\u0399\u039a\u039f \u03a4\u0391\u039c\u0395\u0399\u039f \u0391\u03a3\u03a6\u0391\u039b\u0399\u03a3\u0395\u03a9\u03a3 \u039a\u03a1\u0395\u039f\u03a0\u03a9\u039b\u03a9\u039d \u039a\u0391\u0399 \u0395\u03a1\u0393\u0391\u03a4\u039f\u03a5\u03a0\u0391\u039b\u039b\u0397\u039b\u03a9\u039d \u039a\u03a1\u0395\u0391\u03a4\u039f\u03a3 (\u0395.\u03a4.\u0391.\u039a.\u0395.\u039a)",
            "\u039f\u0399\u039a\u039f\u039d\u039f\u039c\u0399\u039a\u039f \u03a0\u0391\u039d\u0395\u03a0\u0399\u03a3\u03a4\u0397\u039c\u0399\u039f \u0391\u0398\u0397\u039d\u03a9\u039d",
            "\u0393\u0395\u039d\u0399\u039a\u0395\u03a3 \u0391\u03a0\u039f\u0398\u0397\u039a\u0395\u03a3",
            "\u03a4\u0391\u039c\u0395\u0399\u0391\u039a\u0397 \u03a5\u03a0\u0397\u03a1\u0395\u03a3\u0399\u0391",
            "\u0393\u0395\u039d\u0399\u039a\u0395\u03a3 \u0394\u0399\u0391\u03a4\u0391\u039e\u0395\u0399\u03a3 \u03a0\u0395\u03a1\u0399 \u0391\u039d\u03a9\u039d\u03a5\u039c\u03a9\u039d \u0395\u03a4\u0391\u0399\u03a1\u0395\u0399\u03a9\u039d",
            "\u03a4\u039f\u039c\u0395\u0391\u03a3 \u0395\u03a0\u0399\u039a\u039f\u03a5\u03a1\u0399\u039a\u0397\u03a3 \u0391\u03a3\u03a6\u0391\u039b\u0399\u03a3\u0395\u03a9\u03a3 \u039c\u0399\u03a3\u0398\u03a9\u03a4\u03a9\u039d (\u0399\u039a\u0391-\u03a4\u0395\u0391\u039c)\u0395\u0399\u0394\u0399\u039a\u039f\u03a3 \u03a4\u039f\u039c\u0395\u0391\u03a3 \u0395\u03a0\u0399\u039a\u039f\u03a5\u03a1\u0399\u039a\u0397\u03a3 \u0391\u03a3\u03a6\u0391\u039b\u0399\u03a3\u0395\u03a9\u03a3 \u039c\u0399\u03a3\u0398\u03a9\u03a4\u03a9\u039d (\u0399\u039a\u0391-\u0395\u03a4\u0395\u0391\u039c)",
            "\u0392\u0391\u03a1\u0392\u0391\u039a\u0395\u0399\u039f \u039b\u03a5\u039a\u0395\u0399\u039f",
            "\u039a\u03a9\u0394\u0399\u039a\u0391\u03a3 \u0394\u0399\u039a\u03a9\u039d \u03a4\u039f\u03a5 \u0394\u0397\u039c\u039f\u03a3\u0399\u039f\u03a5",
            "\u0394\u0399\u0395\u0398\u039d\u0395\u03a3 \u03a4\u0391\u039c\u0395\u0399\u039f\u039d \u03a0\u0395\u03a1\u0399\u0398\u0391\u039b\u03a8\u0395\u03a9\u03a3 \u03a4\u039f\u03a5 \u03a0\u0391\u0399\u0394\u0399\u039f\u03a5",
            "\u03a3\u0399\u0394\u0397\u03a1\u039f\u0394\u03a1\u039f\u039c\u039f\u0399 \u0395\u039b\u039b\u0397\u039d\u0399\u039a\u039f\u03a5 \u039a\u03a1\u0391\u03a4\u039f\u03a5\u03a3",
            "\u0391\u03a1\u0394\u0395\u03a5\u03a3\u0395\u0399\u03a3",
            "\u03a4\u0391\u039c\u0395\u0399\u039f \u0391\u03a1\u03a7\u0391\u0399\u039f\u039b\u039f\u0393\u0399\u039a\u03a9\u039d \u03a0\u039f\u03a1\u03a9\u039d \u039a\u0391\u0399 \u0391\u03a0\u0391\u039b\u039b\u039f\u03a4\u03a1\u0399\u03a9\u03a3\u0395\u03a9\u039d",
            "\u0399\u0394\u03a1\u03a5\u039c\u0391 \u0392\u03a5\u0396\u0391\u039d\u03a4\u0399\u039d\u0397\u03a3 \u039c\u039f\u03a5\u03a3\u0399\u039a\u039f\u039b\u039f\u0393\u0399\u0391\u03a3",
            "\u039a\u03a5\u0392\u0395\u03a1\u039d\u0397\u03a4\u0399\u039a\u039f \u03a3\u03a5\u039c\u0392\u039f\u03a5\u039b\u0399\u039f \u0395\u039b\u0395\u0393\u03a7\u039f\u03a5 \u03a4\u0399\u039c\u03a9\u039d",
            "\u0395\u0399\u0394\u0399\u039a\u039f \u03a4\u0391\u039c\u0395\u0399\u039f \u0395\u03a0\u039f\u0399\u039a\u0399\u03a3\u039c\u039f\u03a5",
            "\u039a\u03a4\u0397\u039c\u0391\u03a4\u039f\u039b\u039f\u0393\u0399\u0391 \u0394\u0397\u039c\u03a9\u039d \u039a\u0391\u0399 \u039a\u039f\u0399\u039d\u039f\u03a4\u0397\u03a4\u03a9\u039d",
            "\u039a\u0391\u03a4\u0391\u03a3\u039a\u0395\u03a5\u0397 \u03a3\u03a4\u0391\u03a6\u0399\u0394\u0399\u039d\u0397\u03a3",
            "\u0394\u0399\u0395\u0398\u039d\u0397\u03a3 \u03a5\u0393\u0395\u0399\u039f\u039d\u039f\u039c\u0399\u039a\u039f\u03a3 \u039a\u0391\u039d\u039f\u039d\u0399\u03a3\u039c\u039f\u03a3",
            "\u0395\u03a0\u0395\u03a4\u0397\u03a1\u0399\u0394\u0391",
            "\u03a0\u0391\u0393\u039a\u039f\u03a3\u039c\u0399\u039f\u03a3 \u039f\u03a1\u0393\u0391\u039d\u0399\u03a3\u039c\u039f\u03a3 \u03a4\u039f\u03a5\u03a1\u0399\u03a3\u039c\u039f\u03a5",
            "\u0395\u039d\u0399\u03a3\u03a7\u03a5\u03a3\u0397 \u0391\u03a0\u03a1\u039f\u03a3\u03a4\u0391\u03a4\u0395\u03a5\u03a4\u03a9\u039d \u03a0\u0391\u0399\u0394\u0399\u03a9\u039d",
            "\u0394\u0399\u0391\u03a6\u039f\u03a1\u039f\u0399 \u0395\u03a0\u0399\u03a3\u0399\u03a4\u0399\u03a3\u03a4\u0399\u039a\u039f\u0399 \u039d\u039f\u039c\u039f\u0399",
            "\u0394\u0399\u03a0\u039b\u03a9\u039c\u0391\u03a4\u0399\u039a\u0395\u03a3 \u0391\u03a4\u0395\u039b\u0395\u0399\u0395\u03a3",
            "\u039c\u0395\u03a4\u0391 \u03a4\u039f\u03a5 \u0392\u0395\u039b\u0393\u0399\u039f\u03a5",
            "\u039a\u0391\u039d\u039d\u0391\u0392\u0399\u03a3",
            "\u0395\u039a\u03a4\u0395\u039b\u0395\u03a3\u0397",
            "\u03a4\u039f\u03a5\u03a1\u0399\u03a3\u03a4\u0399\u039a\u0395\u03a3 \u0395\u0393\u039a\u0391\u03a4\u0391\u03a3\u03a4\u0391\u03a3\u0395\u0399\u03a3 \u03a1\u039f\u0394\u039f\u03a5",
            "\u03a0\u039f\u0399\u039d\u0399\u039a\u039f \u039c\u0397\u03a4\u03a1\u03a9\u039f",
            "\u0391\u039d\u03a9\u039c\u0391\u039b\u0395\u03a3 \u0394\u0399\u039a\u0391\u0399\u039f\u03a0\u03a1\u0391\u039e\u0399\u0395\u03a3 \u0394\u03a9\u0394\u0395\u039a\u0391\u039d\u0397\u03a3\u039f\u03a5",
            "\u0395\u039c\u03a0\u039f\u03a1\u0399\u039a\u0391 \u039a\u0391\u0399 \u0392\u0399\u039f\u039c\u0397\u03a7\u0391\u039d\u0399\u039a\u0391 \u0395\u03a0\u0399\u039c\u0395\u039b\u0397\u03a4\u0397\u03a1\u0399\u0391",
            "\u03a3\u03a5\u039d\u03a4\u039f\u039d\u0399\u03a3\u039c\u039f\u03a3 \u03a0\u03a1\u039f\u0393\u03a1\u0391\u039c\u039c\u0391\u03a4\u03a9\u039d \u039a\u0391\u0399 \u0395\u03a1\u0393\u0391\u03a3\u0399\u03a9\u039d \u039f\u0394\u03a9\u039d \u039a\u0391\u0399 \u0395\u03a1\u0393\u03a9\u039d \u039a\u039f\u0399\u039d\u0397\u03a3 \u03a9\u03a6\u0395\u039b\u0395\u0399\u0391\u03a3",
            "\u03a0\u03a1\u039f\u03a3\u03a9\u03a0\u0399\u039a\u039f \u039e\u0395\u039d\u039f\u0394\u039f\u03a7\u0395\u0399\u03a9\u039d",
            "\u0399\u039d\u03a3\u03a4\u0399\u03a4\u039f\u03a5\u03a4\u039f \u03a6\u03a5\u03a3\u0399\u039a\u0397\u03a3 \u03a4\u039f\u03a5 \u03a3\u03a4\u0395\u03a1\u0395\u039f\u03a5 \u03a6\u039b\u039f\u0399\u039f\u03a5 \u03a4\u0397\u03a3 \u0393\u0397\u03a3",
            "\u0395\u03a0\u0399\u039a\u0399\u039d\u0394\u03a5\u039d\u0395\u03a3 \u039f\u0399\u039a\u039f\u0394\u039f\u039c\u0395\u03a3",
            "\u0391\u03a1\u03a7\u0395\u0399\u0391 \u0394\u0399\u039a\u0391\u03a3\u03a4\u0397\u03a1\u0399\u03a9\u039d",
            "\u03a3\u039a\u039f\u03a0\u039f\u0392\u039f\u039b\u0397",
            "\u0391\u03a0\u039f\u039d\u039f\u039c\u0397 \u03a3\u03a5\u039d\u03a4\u0391\u039e\u0395\u03a9\u039d \u03a4\u0391\u039c\u0395\u0399\u039f\u03a5 \u039d\u039f\u039c\u0399\u039a\u03a9\u039d",
            "\u03a3\u0397\u03a1\u039f\u03a4\u03a1\u039f\u03a6\u0399\u0391",
            "\u0395\u03a3\u03a9\u03a4\u0395\u03a1\u0399\u039a\u039f\u03a3 \u039a\u0391\u039d\u039f\u039d\u0399\u03a3\u039c\u039f\u03a3",
            "\u03a0\u03a1\u039f\u03a3\u03a4\u0391\u03a3\u0399\u0391 \u03a4\u0397\u03a3 \u039a\u03a4\u0397\u039d\u039f\u03a4\u03a1\u039f\u03a6\u0399\u0391\u03a3",
            "\u03a7\u0391\u03a1\u03a4\u0397\u03a3",
            "\u03a5\u03a0\u0397\u03a1\u0395\u03a3\u0399\u0391 \u0395\u0393\u039a\u039b\u0397\u039c\u0391\u03a4\u039f\u039b\u039f\u0393\u0399\u039a\u03a9\u039d \u0391\u039d\u0391\u0396\u0397\u03a4\u0397\u03a3\u0395\u03a9\u039d",
            "\u03a5\u0393\u0395\u0399\u039f\u039d\u039f\u039c\u0399\u039a\u0397 \u03a0\u0395\u03a1\u0399\u0398\u0391\u039b\u03a8\u0397 \u0392\u039f\u03a5\u039b\u0395\u03a5\u03a4\u03a9\u039d",
            "\u0394\u0399\u039a\u0391\u0399\u039f\u03a3\u03a4\u0391\u03a3\u0399\u039f \u03a0\u039f\u039b\u0395\u039c\u039f\u03a5 1940",
            "\u03a7\u0397\u039c\u0395\u0399\u039f \u03a3\u03a4\u03a1\u0391\u03a4\u039f\u03a5",
            "\u0395\u03a0\u0391\u03a1\u03a7\u0399\u0391\u039a\u0395\u03a3 \u0393\u0395\u039d\u0399\u039a\u0395\u03a3 \u03a3\u03a5\u039d\u0395\u039b\u0395\u03a5\u03a3\u0395\u0399\u03a3",
            "\u039b\u039f\u0393\u0391\u03a1\u0399\u0391\u03a3\u039c\u039f\u03a3 \u0391\u03a1\u03a9\u0393\u0397\u03a3 \u039f\u0399\u039a\u039f\u0393\u0395\u039d\u0395\u0399\u03a9\u039d \u03a3\u03a4\u03a1\u0391\u03a4\u0399\u03a9\u03a4\u0399\u039a\u03a9\u039d \u0395\u039d\u039f\u03a0\u039b\u03a9\u039d \u0394\u03a5\u039d\u0391\u039c\u0395\u03a9\u039d",
            "\u039a\u0391\u03a4\u2019 \u0399\u0394\u0399\u0391\u039d \u039d\u0391\u039f\u0399",
            "\u03a0\u039b\u0397\u03a1\u03a9\u039c\u0397 \u039c\u0395 \u0395\u03a0\u0399\u03a4\u0391\u0393\u0395\u03a3",
            "\u0395\u0398\u039d\u0399\u039a\u0395\u03a3 \u03a3\u03a5\u039b\u039b\u039f\u0393\u0399\u039a\u0395\u03a3 \u03a3\u03a5\u039c\u0392\u0391\u03a3\u0395\u0399\u03a3",
            "\u03a3\u03a9\u039c\u0391 \u03a3\u03a4\u03a1\u0391\u03a4\u039f\u039b\u039f\u0393\u0399\u0391\u03a3",
            "\u039f\u0394\u039f\u039d\u03a4\u0399\u0391\u03a4\u03a1\u039f\u0399",
            "\u03a4\u0391\u039c\u0395\u0399\u039f \u0395\u0398\u039d\u0399\u039a\u039f\u03a5 \u03a3\u03a4\u039f\u039b\u039f\u03a5",
            "\u03a3\u03a5\u039c\u03a0\u039b\u0397\u03a1\u03a9\u039c\u0391\u03a4\u0399\u039a\u0395\u03a3 \u03a0\u0391\u03a1\u039f\u03a7\u0395\u03a3 \u039c\u0397\u03a4\u03a1\u039f\u03a4\u0397\u03a4\u0391\u03a3",
            "\u039c\u0395\u03a4\u0391\u03a4\u03a1\u0395\u03a8\u0399\u039c\u039f\u03a4\u0397\u03a4\u0391 \u039a\u0391\u03a4\u0391\u0398\u0395\u03a3\u0395\u03a9\u039d",
            "\u03a0\u03a4\u0397\u039d\u039f\u03a4\u03a1\u039f\u03a6\u0399\u0391",
            "\u03a0\u03a4\u03a5\u03a7\u0399\u039f\u03a5\u03a7\u039f\u0399 \u0391\u039b\u039b\u039f\u0394\u0391\u03a0\u03a9\u039d \u03a0\u0391\u039d\u0395\u03a0\u0399\u03a3\u03a4\u0397\u039c\u0399\u03a9\u039d - \u0394\u0399\u0391\u03a0\u0391\u039d\u0395\u03a0\u0399\u03a3\u03a4\u0397\u039c\u0399\u0391\u039a\u039f \u039a\u0395\u039d\u03a4\u03a1\u039f \u0391\u039d\u0391\u0393\u039d\u03a9\u03a1\u0399\u03a3\u0395\u03a9\u03a3",
            "\u03a6\u039f\u03a1\u03a4\u0397\u0393\u0391 \u0391\u03a5\u03a4\u039f\u039a\u0399\u039d\u0397\u03a4\u0391",
            "\u03a5\u03a0\u0397\u03a1\u0395\u03a3\u0399\u0391 \u039c\u0397\u03a7\u0391\u039d\u0399\u039a\u0397\u03a3 \u039a\u0391\u039b\u039b\u0399\u0395\u03a1\u0393\u0395\u0399\u0391\u03a3",
            "\u0395\u039b\u0395\u0393\u03a7\u039f\u03a3 \u039a\u0399\u039d\u0397\u039c\u0391\u03a4\u039f\u0393\u03a1\u0391\u03a6\u03a9\u039d",
            "\u0394\u0397\u039c\u039f\u03a3\u0399\u039f\u0393\u03a1\u0391\u03a6\u0399\u039a\u0395\u03a3 \u039f\u03a1\u0393\u0391\u039d\u03a9\u03a3\u0395\u0399\u03a3",
            "\u039d\u0391\u03a5\u03a4\u0399\u039b\u0399\u0391\u039a\u0395\u03a3 \u03a4\u03a1\u0391\u03a0\u0395\u0396\u0395\u03a3",
            "\u039b\u0395\u0399\u03a4\u039f\u03a5\u03a1\u0393\u0399\u0391 \u03a5\u0394\u03a1\u039f\u0398\u0395\u03a1\u0391\u03a0\u0395\u03a5\u03a4\u0397\u03a1\u0399\u03a9\u039d",
            "\u03a3\u03a5\u039c\u0392\u039f\u03a5\u039b\u0399\u039f \u0395\u039c\u03a0\u039f\u03a1\u0399\u039a\u0397\u03a3 \u039d\u0391\u03a5\u03a4\u0399\u039b\u0399\u0391\u03a3",
            "\u0395\u0393\u0393\u0395\u0399\u039f\u03a3 \u03a6\u039f\u03a1\u039f\u039b\u039f\u0393\u0399\u0391 \u039a\u0391\u03a0\u039d\u039f\u03a5",
            "\u03a4\u0395\u039b\u039f\u03a3 \u0391\u0394\u0395\u0399\u03a9\u039d \u039f\u0399\u039a\u039f\u0394\u039f\u039c\u03a9\u039d",
            "\u0395\u0398\u039d\u0399\u039a\u039f\u03a4\u0397\u03a4\u0391 \u03a0\u039b\u039f\u0399\u03a9\u039d",
            "\u03a0\u039f\u039b\u0399\u03a4\u0399\u039a\u0391 \u039a\u039f\u039c\u039c\u0391\u03a4\u0391",
            "\u03a3\u03a7\u039f\u039b\u0397 \u0398\u0395\u03a4\u0399\u039a\u03a9\u039d \u0395\u03a0\u0399\u03a3\u03a4\u0397\u039c\u03a9\u039d",
            "\u039d\u0397\u039f\u0393\u039d\u03a9\u039c\u039f\u039d\u0395\u03a3",
            "\u0394\u0399\u0391\u03a6\u039f\u03a1\u039f\u0399 \u03a0\u039f\u0399\u039d\u0399\u039a\u039f\u0399 \u039d\u039f\u039c\u039f\u0399",
            "\u03a0\u03a1\u039f\u03a3\u03a9\u03a1\u0399\u039d\u0397 \u0391\u03a0\u039f\u039b\u03a5\u03a3\u0397",
            "\u03a4\u0391\u039c\u0395\u0399\u039f \u0391\u039b\u039b\u0397\u039b\u039f\u0392\u039f\u0397\u0398\u0395\u0399\u0391\u03a3 \u03a3\u03a4\u03a1\u0391\u03a4\u039f\u03a5 \u039e\u0397\u03a1\u0391\u03a3",
            "\u03a5\u03a0\u0391\u039e\u0399\u03a9\u039c\u0391\u03a4\u0399\u039a\u039f\u0399 \u0391\u0395\u03a1\u039f\u03a0\u039f\u03a1\u0399\u0391\u03a3",
            "\u03a6\u039f\u03a1\u039f\u039b\u039f\u0393\u0399\u0391 \u03a7\u03a1\u0397\u039c\u0391\u03a4\u0399\u03a3\u03a4\u0397\u03a1\u0399\u0391\u039a\u03a9\u039d \u03a3\u03a5\u039c\u0392\u0391\u03a3\u0395\u03a9\u039d",
            "\u03a0\u03a4\u03a5\u03a7\u0399\u0391 \u0399\u03a0\u03a4\u0391\u039c\u0395\u039d\u039f\u03a5 \u03a0\u03a1\u039f\u03a3\u03a9\u03a0\u0399\u039a\u039f\u03a5",
            "\u039a\u03a1\u0395\u0391\u03a4\u0391 \u03a3\u0395 \u03a0\u0391\u039a\u0395\u03a4\u0391",
            "\u0395\u039b\u0395\u0393\u03a7\u039f\u03a3 \u039f\u03a0\u039b\u039f\u03a6\u039f\u03a1\u0399\u0391\u03a3",
            "\u0391\u039d\u0391\u03a3\u03a4\u039f\u039b\u0395\u03a3 \u0394\u0397\u039c\u039f\u03a3\u0399\u039f\u03a5 \u03a7\u03a1\u0395\u039f\u03a5\u03a3",
            "\u0397\u039b\u0395\u039a\u03a4\u03a1\u0399\u039a\u039f\u0399 \u03a3\u0399\u0394\u0397\u03a1\u039f\u0394\u03a1\u039f\u039c\u039f\u0399 \u0391\u0398\u0397\u039d\u03a9\u039d-\u03a0\u0395\u0399\u03a1\u0391\u0399\u03a9\u03a3 (\u0397.\u03a3.\u0391.\u03a0)",
            "\u0394\u0399\u0391\u0398\u0395\u03a3\u0397 \u039b\u03a5\u039c\u0391\u03a4\u03a9\u039d \u039a\u0391\u0399 \u0391\u03a0\u039f\u0392\u039b\u0397\u03a4\u03a9\u039d",
            "\u0395\u03a0\u0399\u0398\u0395\u03a9\u03a1\u0397\u03a3\u0397 \u03a4\u0395\u03a7\u039d\u0399\u039a\u0397\u03a3 \u0395\u039a\u03a0\u0391\u0399\u0394\u0395\u03a5\u03a3\u0397\u03a3",
            "\u03a4\u0395\u039b\u0397 \u0391\u0394\u0395\u0399\u03a9\u039d \u0395\u039e\u0391\u0393\u03a9\u0393\u0397\u03a3",
            "\u03a0\u03a1\u039f\u0399\u039f\u039d\u03a4\u0391 \u0393\u0391\u039b\u0391\u039a\u03a4\u039f\u03a3",
            "\u0393\u0395\u03a9\u03a1\u0393\u0399\u039a\u0391 \u0395\u03a0\u0399\u039c\u0395\u039b\u0397\u03a4\u0397\u03a1\u0399\u0391",
            "\u0399\u0395\u03a1\u0391\u03a1\u03a7\u0399\u039a\u039f\u03a3 \u0384\u0395\u039b\u0395\u0393\u03a7\u039f\u03a3",
            "\u03a3\u03a4\u03a1\u0391\u03a4\u0399\u03a9\u03a4\u0399\u039a\u0395\u03a3 \u03a6\u03a5\u039b\u0391\u039a\u0395\u03a3",
            "\u03a4\u0391\u039c\u0395\u0399\u039f \u0395\u03a0\u0399\u039a. \u0391\u03a3\u03a6\u0391\u039b\u0399\u03a3\u0395\u03a9\u03a3 \u03a5\u03a0\u0391\u039b\u039b\u0397\u039b\u03a9\u039d \u039a\u0391\u03a0\u039d\u0395\u039c\u03a0\u039f\u03a1\u0399\u039a\u03a9\u039d \u0395\u03a0\u0399\u03a7\u0395\u0399\u03a1\u0397\u03a3\u0395\u03a9\u039d",
            "\u03a4\u0391\u039c\u0395\u0399\u039f \u03a0\u03a1\u039f\u039d\u039f\u0399\u0391\u03a3 \u039a\u0391\u0399 \u0395\u03a0\u0399\u039a\u039f\u03a5\u03a1\u0399\u039a\u0397\u03a3 \u0391\u03a3\u03a6\u0391\u039b\u0399\u03a3\u0395\u03a9\u03a3 \u03a0\u03a1\u039f\u03a3\u03a9\u03a0\u0399\u039a\u039f\u03a5 \u0399\u03a0\u03a0\u039f\u0394\u03a1\u039f\u039c\u0399\u03a9\u039d (\u03a4.\u0391.\u03a0.\u0395.\u0391.\u03a0.\u0399.)",
            "\u0391\u03a0\u039f\u03a7\u03a9\u03a1\u0397\u03a4\u0397\u03a1\u0399\u0391",
            "\u03a6\u039f\u03a1\u039f\u03a3 \u0395\u0399\u03a3\u039f\u0394\u0397\u039c\u0391\u03a4\u039f\u03a3 \u03a6\u03a5\u03a3\u0399\u039a\u03a9\u039d \u039a\u0391\u0399 \u039d\u039f\u039c\u0399\u039a\u03a9\u039d \u03a0\u03a1\u039f\u03a3\u03a9\u03a0\u03a9\u039d",
            "\u039a\u0391\u03a4\u0391\u03a3\u03a4\u0391\u03a4\u0399\u039a\u0395\u03a3 \u0394\u0399\u0391\u03a4\u0391\u039e\u0395\u0399\u03a3 \u03a0\u0391\u03a1\u039f\u03a7\u03a9\u039d",
            "\u0391\u03a4\u03a4\u0399\u039a\u039f \u039c\u0395\u03a4\u03a1\u039f",
            "\u0392\u039f\u03a5\u03a3\u03a4\u0391\u03a3\u0399\u0391",
            "\u0391\u03a0\u039f\u03a3\u03a4\u03a1\u0391\u03a4\u0395\u0399\u0395\u03a3 - \u0395\u03a0\u0391\u039d\u0391\u03a6\u039f\u03a1\u0395\u03a3",
            "\u03a4\u03a1\u0391\u03a0\u0395\u0396\u0399\u03a4\u0399\u039a\u0391 \u0394\u0391\u039d\u0395\u0399\u0391 \u03a3\u0395 \u03a7\u03a1\u03a5\u03a3\u039f \u039a\u039b\u03a0",
            "\u0394\u0399\u039a\u0391\u0399\u039f\u03a3\u03a4\u0391\u03a3\u0399\u039f \u03a0\u039f\u039b\u0395\u039c\u03a9\u039d",
            "\u0395\u0398\u039d\u0399\u039a\u039f \u0391\u03a3\u03a4\u0395\u03a1\u039f\u03a3\u039a\u039f\u03a0\u0395\u0399\u039f",
            "\u0399\u0394\u0399\u03a9\u03a4\u0399\u039a\u0395\u03a3 \u0395\u03a0\u0399\u03a7\u0395\u0399\u03a1\u0397\u03a3\u0395\u0399\u03a3 \u03a0\u0391\u03a1\u039f\u03a7\u0397\u03a3 \u03a5\u03a0\u0397\u03a1\u0395\u03a3\u0399\u03a9\u039d \u0391\u03a3\u03a6\u0391\u039b\u0395\u0399\u0391\u03a3",
            "\u0394\u0391\u039d\u0395\u0399\u0391 \u0395\u039e\u03a9\u03a4\u0395\u03a1\u0399\u039a\u0391",
            "\u03a0\u039d\u0395\u03a5\u039c\u0391\u03a4\u0399\u039a\u039f \u039a\u0395\u039d\u03a4\u03a1\u039f \u0391\u0398\u0397\u039d\u03a9\u039d",
            "\u0391\u03a0\u039f\u03a3\u0392\u0395\u03a3\u0395\u0399\u03a3",
            "\u0394\u0399\u0391\u03a6\u039f\u03a1\u039f\u0399 \u039f\u0399\u039d\u0399\u039a\u039f\u0399 \u039a\u0391\u0399 \u03a3\u03a4\u0391\u03a6\u0399\u0394\u0399\u039a\u039f\u0399 \u039d\u039f\u039c\u039f\u0399",
            "\u0391\u039a\u0391\u0394\u0397\u039c\u0399\u0391 \u03a3\u03a9\u039c\u0391\u03a4\u0399\u039a\u0397\u03a3 \u0391\u0393\u03a9\u0393\u0397\u03a3",
            "\u0391\u039c\u039c\u039f\u039b\u0397\u03a8\u0399\u0391",
            "\u03a0\u03a1\u039f\u03a3\u03a9\u03a0\u0399\u039a\u039f \u03a0\u039b\u039f\u0397\u0393\u0399\u039a\u0397\u03a3 \u03a5\u03a0\u0397\u03a1\u0395\u03a3\u0399\u0391\u03a3",
            "\u0397\u0398\u0399\u039a\u0395\u03a3 \u0391\u039c\u039f\u0399\u0392\u0395\u03a3 \u0391\u0395\u03a1\u039f\u03a0\u039f\u03a1\u0399\u0391\u03a3",
            "\u039a\u03a9\u0394\u0399\u039a\u0391\u03a3 \u03a6\u039f\u03a1\u039f\u039b\u039f\u0393\u0399\u0391\u03a3 \u039f\u0399\u039d\u039f\u03a0\u039d\u0395\u03a5\u039c\u0391\u03a4\u039f\u03a3",
            "\u039b\u0399\u039c\u0395\u039d\u0399\u039a\u0391 \u03a4\u0391\u039c\u0395\u0399\u0391 \u2013 \u039b\u0399\u039c\u0395\u039d\u0399\u039a\u0391 \u0395\u03a1\u0393\u0391",
            "\u03a4\u0391\u039c\u0395\u0399\u039f \u0395\u03a0\u0399\u039a. \u0391\u03a3\u03a6\u0391\u039b\u0399\u03a3\u0395\u03a9\u03a3 \u03a5\u03a0\u0391\u039b\u039b\u0397\u039b\u03a9\u039d \u0395\u0398\u039d\u0399\u039a\u039f\u03a5 \u039f\u03a1\u0393\u0391\u039d\u0399\u03a3\u039c\u039f\u03a5 \u039a\u0391\u03a0\u039d\u039f\u03a5  (\u03a4.\u0395.\u0391.\u03a5\u0395.\u039f.\u039a)",
            "\u0395\u039b\u0395\u0393\u03a7\u039f\u03a3 \u03a4\u0397\u03a3 \u03a0\u0399\u03a3\u03a4\u0395\u03a9\u03a3",
            "\u03a3\u03a4\u03a1\u0391\u03a4\u0399\u03a9\u03a4\u0399\u039a\u0397 \u03a3\u03a7\u039f\u039b\u0397 \u0391\u039e\u0399\u03a9\u039c\u0391\u03a4\u0399\u039a\u03a9\u039d \u03a3\u03a9\u039c\u0391\u03a4\u03a9\u039d",
            "\u0392\u039f\u0397\u0398\u0397\u03a4\u0399\u039a\u0391 \u03a0\u03a1\u039f\u03a3\u03a9\u03a0\u0391 \u03a4\u0397\u03a3 \u0394\u0399\u039a\u0397\u03a3",
            "\u039f\u03a1\u0393\u0391\u039d\u0399\u03a3\u039c\u039f\u03a3 \u03a3\u03a7\u039f\u039b\u0399\u039a\u03a9\u039d \u039a\u03a4\u0399\u03a1\u0399\u03a9\u039d",
            "\u0392\u0399\u039f\u039c\u0397\u03a7\u0391\u039d\u0399\u0395\u03a3 \u0394\u03a9\u0394\u0395\u039a\u0391\u039d\u0397\u03a3\u039f\u03a5",
            "\u03a5\u0393\u0399\u0395\u0399\u039d\u0397 \u039a\u0391\u0399 \u0391\u03a3\u03a6\u0391\u039b\u0395\u0399\u0391 \u03a7\u03a9\u03a1\u03a9\u039d \u0395\u03a1\u0393\u0391\u03a3\u0399\u0391\u03a3 \u039a\u0391\u0399 \u0395\u03a1\u0393\u0391\u0396\u039f\u039c\u0395\u039d\u03a9\u039d",
            "\u039c\u0395\u03a4\u0391\u03a4\u03a1\u039f\u03a0\u0397 \u03a4\u0397\u03a3 \u03a0\u039f\u0399\u039d\u0397\u03a3",
            "\u0391\u03a5\u03a4\u039f\u039d\u039f\u039c\u039f\u03a3 \u039f\u0399\u039a\u039f\u0394\u039f\u039c\u0399\u039a\u039f\u03a3 \u039f\u03a1\u0393\u0391\u039d\u0399\u03a3\u039c\u039f\u03a3 \u0391\u039e\u0399\u03a9\u039c\u0391\u03a4\u0399\u039a\u03a9\u039d",
            "\u039f\u0394\u0399\u039a\u0395\u03a3 \u039c\u0395\u03a4\u0391\u03a6\u039f\u03a1\u0395\u03a3-\u039c\u0395\u03a4\u0391\u03a6\u039f\u03a1\u0395\u0399\u03a3",
            "\u0391\u03a1\u039c\u0391 \u0398\u0395\u03a3\u03a0\u0399\u0394\u039f\u03a3",
            "\u0394\u0397\u039c\u039f\u03a4\u0399\u039a\u0391 & \u039a\u039f\u0399\u039d\u039f\u03a4\u0399\u039a\u0391",
            "\u03a0\u0395\u03a1\u0399\u03a6\u0395\u03a1\u0395\u0399\u0391\u039a\u0395\u03a3 \u03a5\u03a0\u0397\u03a1\u0395\u03a3\u0399\u0395\u03a3",
            "\u03a3\u03a7\u039f\u039b\u0397 \u0391\u039d\u0398\u03a1\u03a9\u03a0\u0399\u03a3\u03a4\u0399\u039a\u03a9\u039d \u039a\u0391\u0399 \u039a\u039f\u0399\u039d\u03a9\u039d\u0399\u039a\u03a9\u039d \u0395\u03a0\u0399\u03a3\u03a4\u0397\u039c\u03a9\u039d",
            "\u03a3\u03a4\u03a1\u0391\u03a4\u0395\u03a5\u039f\u039c\u0395\u039d\u039f\u0399 \u03a6\u039f\u0399\u03a4\u0397\u03a4\u0391\u0399",
            "\u0393\u0395\u039d\u0399\u039a\u0391",
            "\u039a\u0391\u03a4\u0391\u03a0\u039f\u039b\u0395\u039c\u0397\u03a3\u0397 \u0395\u03a0\u0399\u0396\u03a9\u039f\u03a4\u0399\u03a9\u039d",
            "\u039f\u03a1\u0393\u0391\u039d\u0399\u03a3\u039c\u039f\u03a3 \u0394\u0399\u039f\u0399\u039a\u0397\u03a3\u0395\u03a9\u03a3 \u0395\u039a\u039a\u039b\u0397\u03a3\u0399\u0391\u03a3\u03a4\u0399\u039a\u0397\u03a3 \u039a\u0391\u0399 \u039c\u039f\u039d\u0391\u03a3\u03a4\u0397\u03a1\u0399\u0391\u039a\u0397\u03a3 \u03a0\u0395\u03a1\u0399\u039f\u03a5\u03a3\u0399\u0391\u03a3",
            "\u0391\u03a0\u0391\u0393\u039f\u03a1\u0395\u03a5\u03a3\u0397 \u03a7\u03a1\u0397\u03a3\u0397\u03a3 \u0395\u03a0\u0399\u0392\u039b\u0391\u0392\u03a9\u039d \u039f\u03a5\u03a3\u0399\u03a9\u039d",
            "\u03a8\u03a5\u03a7\u039f\u039b\u039f\u0393\u039f\u0399",
            "\u03a0\u03a5\u03a1\u0391\u03a3\u03a6\u0391\u039b\u0395\u0399\u0391 \u0395\u03a0\u0399\u03a7\u0395\u0399\u03a1\u0397\u03a3\u0395\u03a9\u039d \u039a\u0391\u0399 \u0391\u03a0\u039f\u0398\u0397\u039a\u03a9\u039d",
            "\u0391\u03a0\u039f\u039a\u0391\u03a4\u0391\u03a3\u03a4\u0391\u03a3\u0399\u03a3 \u0391\u03a0\u039f\u03a1\u03a9\u039d \u039a\u039f\u03a1\u0391\u03a3\u0399\u0394\u03a9\u039d",
            "\u039c\u0395 \u03a4\u0397 \u0392\u0395\u039d\u0395\u0396\u039f\u03a5\u0395\u039b\u0391",
            "\u0394\u0399\u039a\u0391\u0399\u039f \u03a4\u03a9\u039d \u03a3\u03a5\u039d\u0398\u0397\u039a\u03a9\u039d",
            "\u039a\u03a4\u0397\u039d\u0399\u0391\u03a4\u03a1\u0399\u039a\u0391 \u039c\u0399\u039a\u03a1\u039f\u0392\u0399\u039f\u039b\u039f\u0393\u0399\u039a\u0391 \u0395\u03a1\u0393\u0391\u03a3\u03a4\u0397\u03a1\u0399\u0391",
            "\u0395\u03a1\u0393\u0391\u03a3\u03a4\u0397\u03a1\u0399\u0391",
            "\u039a\u0391\u039d\u039f\u039d\u0399\u03a3\u039c\u039f\u0399 TELEX \u039a\u0391\u0399 TELEFAX",
            "\u039f\u03a0\u039b\u0391 \u039a\u0391\u0399 \u03a3\u03a9\u039c\u0391\u03a4\u0391 \u03a3\u03a4\u03a1\u0391\u03a4\u039f\u03a5 \u039e\u0397\u03a1\u0391\u03a3",
            "\u0395\u039a\u03a0\u0391\u0399\u0394\u0395\u03a5\u03a3\u0397 \u03a4\u0391\u03a7\u03a5\u0394\u03a1\u039f\u039c\u0399\u039a\u03a9\u039d \u03a5\u03a0\u0391\u039b\u039b\u0397\u039b\u03a9\u039d",
            "\u03a4\u0399\u039c\u039f\u039b\u039f\u0393\u0399\u0391 \u03a0\u0391\u03a1\u039f\u03a7\u03a9\u039d",
            "\u039c\u039f\u03a5\u03a3\u039f\u03a5\u039b\u039c\u0391\u039d\u0399\u039a\u0395\u03a3 \u039a\u039f\u0399\u039d\u039f\u03a4\u0397\u03a4\u0395\u03a3",
            "\u03a3\u03a4\u03a1\u0391\u03a4\u0399\u03a9\u03a4\u0399\u039a\u0391 \u0395\u03a1\u0393\u0391 \u0395\u039d \u0393\u0395\u039d\u0395\u0399",
            "\u03a3\u03a4\u03a1\u0391\u03a4\u0399\u03a9\u03a4\u0399\u039a\u0391 \u039d\u039f\u03a3\u039f\u039a\u039f\u039c\u0395\u0399\u0391",
            "\u0394\u0399\u039f\u0399\u039a\u0397\u03a3\u0397 \u0394\u0397\u039c\u039f\u03a3\u0399\u03a9\u039d \u039a\u03a4\u0397\u039c\u0391\u03a4\u03a9\u039d \u2013",
            "\u0395\u0399\u0394\u0399\u039a\u0395\u03a3 \u03a4\u0399\u039c\u0395\u03a3 \u039a\u0391\u03a5\u03a3\u0399\u039c\u03a9\u039d \u039a\u0391\u0399 \u0397\u039b\u0395\u039a\u03a4\u03a1\u0399\u039a\u0397\u03a3 \u0395\u039d\u0395\u03a1\u0393\u0395\u0399\u0391\u03a3",
            "\u0395\u0393\u0393\u03a1\u0391\u03a6\u0397 \u03a3\u03a0\u039f\u03a5\u0394\u0391\u03a3\u03a4\u03a9\u039d",
            "\u0394\u0397\u039c\u039f\u03a4\u0399\u039a\u0391-\u039a\u039f\u0399\u039d\u039f\u03a4\u0399\u039a\u0391 \u0394\u0391\u03a3\u0397 \u039a\u0391\u0399 \u039a\u0397\u03a0\u039f\u0399",
            "\u0394\u0397\u039c\u039f\u03a3\u0399\u0391 \u0395\u03a0\u0399\u03a7\u0395\u0399\u03a1\u0397\u03a3\u0397 \u03a0\u039f\u039b\u0395\u039f\u0394\u039f\u039c\u0399\u0391\u03a3 \u039a\u0391\u0399 \u03a3\u03a4\u0395\u0393\u0391\u03a3\u0395\u03a9\u03a3",
            "\u03a3\u03a5\u039d\u03a4\u0391\u039e\u0399\u039f\u0394\u039f\u03a4\u0397\u03a3\u0397 \u03a0\u03a1\u039f\u03a3\u03a9\u03a0\u0399\u039a\u039f\u03a5 \u0399.\u039a.\u0391",
            "\u0395\u039e\u0395\u03a4\u0391\u03a3\u03a4\u0399\u039a\u0395\u03a3 \u0395\u03a0\u0399\u03a4\u03a1\u039f\u03a0\u0395\u03a3 \u0392\u039f\u03a5\u039b\u0397\u03a3",
            "\u039c\u0395\u03a4\u03a1\u0391 \u039a\u0391\u03a4\u0391 \u03a4\u03a9\u039d \u03a0\u03a5\u03a1\u039a\u0391\u0399\u03a9\u039d \u0394\u0391\u03a3\u03a9\u039d",
            "\u03a5\u03a0\u039f\u03a5\u03a1\u0393\u0395\u0399\u039f \u0395\u0398\u039d\u0399\u039a\u0397\u03a3 \u039f\u0399\u039a\u039f\u039d\u039f\u039c\u0399\u0391\u03a3",
            "\u03a3\u03a5\u0393\u039a\u0395\u039d\u03a4\u03a1\u03a9\u03a3\u0397 \u03a0\u0395\u03a1\u0399\u039f\u03a5\u03a3\u0399\u0391\u03a3 \u03a4\u039f\u03a5 \u0394\u0397\u039c\u039f\u03a3\u0399\u039f\u03a5",
            "\u039a\u0391\u03a4\u0391\u03a3\u039a\u0395\u03a5\u0397 \u039a\u0391\u0399 \u03a3\u03a5\u039d\u03a4\u0397\u03a1\u0397\u03a3\u0397 \u039f\u0394\u03a9\u039d",
            "\u03a4\u0395\u039b\u03a9\u039d\u0395\u0399\u0391\u039a\u0391 \u039a\u03a4\u0399\u03a1\u0399\u0391",
            "\u03a4\u0391\u039c\u0395\u0399\u039f \u03a3\u03a5\u039d\u03a4\u0391\u039e\u0395\u03a9\u039d \u0395\u039a\u03a4\u0395\u039b\u03a9\u039d\u0399\u03a3\u03a4\u03a9\u039d (\u03a4.\u03a3.\u0395.)",
            "\u039a\u0391\u0398\u0397\u0393\u0397\u03a4\u0399\u039a\u0395\u03a3 \u0395\u0394\u03a1\u0395\u03a3",
            "\u039d\u0391\u03a5\u03a4\u0399\u039a\u0397 \u0395\u03a1\u0393\u0391\u03a3\u0399\u0391 \u039d\u0395\u03a9\u039d",
            "\u0395\u039a\u03a4\u0395\u039b\u0395\u03a3\u0397 \u0398\u0391\u039d\u0391\u03a4\u0399\u039a\u0397\u03a3 \u03a0\u039f\u0399\u039d\u0397\u03a3",
            "\u0395\u03a0\u0399\u0398\u0395\u03a9\u03a1\u0397\u03a3\u0397 \u03a0\u039b\u039f\u0399\u03a9\u039d",
            "\u0394\u0399\u03a0\u039b\u03a9\u039c\u0391\u03a4\u0391 \u039a\u0391\u0399 \u0391\u0394\u0395\u0399\u0395\u03a3 \u039d\u0391\u03a5\u03a4\u0399\u039a\u0397\u03a3 \u0399\u039a\u0391\u039d\u039f\u03a4\u0397\u03a4\u0391\u03a3",
            "\u0399\u03a3\u03a4\u039f\u03a1\u0399\u039a\u039f \u039a\u0391\u0399 \u0395\u0398\u039d\u039f\u039b\u039f\u0393\u0399\u039a\u039f \u039c\u039f\u03a5\u03a3\u0395\u0399\u039f",
            "\u03a0\u03a1\u039f\u03a3\u03a4\u0391\u03a3\u0399\u0391 \u0395\u03a1\u0393\u0391\u0396\u039f\u039c\u0395\u039d\u0397\u03a3 \u039d\u0395\u0391\u03a3",
            "\u03a5\u03a0\u0397\u03a1\u0395\u03a3\u0399\u0391 \u0395\u03a0\u0399\u039c\u0395\u039b\u0397\u03a4\u03a9\u039d \u0391\u039d\u0397\u039b\u0399\u039a\u03a9\u039d",
            "\u0391\u03a3\u03a4\u0399\u039a\u0397 \u0395\u03a5\u0398\u03a5\u039d\u0397 \u0391\u03a0\u039f \u03a0\u03a5\u03a1\u0397\u039d\u0399\u039a\u0397 \u0395\u039d\u0395\u03a1\u0393\u0395\u0399\u0391",
            "\u039a\u03a9\u0394\u0399\u039a\u0391\u03a3 \u03a6\u039f\u03a1\u039f\u039b\u039f\u0393\u0399\u0391\u03a3 \u039a\u0391\u0398\u0391\u03a1\u0391\u03a3 \u03a0\u03a1\u039f\u03a3\u039f\u0394\u039f\u03a5",
            "\u0395\u03a0\u0399\u0398\u0395\u03a9\u03a1\u0397\u03a3\u0397 \u03a5.\u0395.\u039d",
            "\u039a\u0391\u03a4\u0391\u0393\u0393\u0395\u039b\u0399\u0391 \u03a3\u03a5\u039c\u0392\u0391\u03a3\u0395\u03a9\u03a3 \u0395\u03a1\u0393\u0391\u03a3\u0399\u0391\u03a3 \u03a3\u03a5\u039d\u0394\u0399\u039a\u0391\u039b\u0399\u03a3\u03a4\u0399\u039a\u03a9\u039d \u03a3\u03a4\u0395\u039b\u0395\u03a7\u03a9\u039d",
            "\u03a5\u0393\u0395\u0399\u039f\u039d\u039f\u039c\u0399\u039a\u0395\u03a3 \u0394\u0399\u0391\u03a4\u0391\u039e\u0395\u0399\u03a3",
            "\u0394\u0399\u0394\u0391\u03a3\u039a\u0391\u039b\u0395\u0399\u039f \u039c\u0395\u03a3\u0397\u03a3 \u0395\u039a\u03a0\u0391\u0399\u0394\u0395\u03a5\u03a3\u0397\u03a3",
            "\u03a5\u03a0\u039f\u0392\u03a1\u03a5\u03a7\u0399\u0391",
            "\u03a5\u03a0\u0397\u03a1\u0395\u03a3\u0399\u0391 \u0391\u03a0\u03a9\u039b\u0395\u0399\u03a9\u039d, \u039d\u0395\u039a\u03a1\u039f\u03a4\u0391\u03a6\u0395\u0399\u03a9\u039d \u039a\u039b\u03a0",
            "\u0391\u0393\u03a1\u039f\u03a4. \u0391\u03a0\u039f\u039a\u0391\u03a4\u0391\u03a3\u03a4\u0391\u03a3\u0397 \u03a3\u03a4\u0391  \u0394\u03a9\u0394\u0395\u039a\u0391\u039d\u0397\u03a3\u0391",
            "\u0395\u0399\u0394\u0399\u039a\u0395\u03a3 \u0391\u03a0\u0391\u039b\u039b\u039f\u03a4\u03a1\u0399\u03a9\u03a3\u0395\u0399\u03a3",
            "\u03a3\u03a4\u0395\u0393\u0391\u03a3\u0397 \u03a4\u0391\u03a7\u03a5\u0394\u03a1\u039f\u039c\u0399\u039a\u03a9\u039d \u03a5\u03a0\u0397\u03a1\u0395\u03a3\u0399\u03a9\u039d",
            "\u0394\u0399\u0391\u039c\u0395\u03a4\u0391\u039a\u039f\u039c\u0399\u03a3\u0397 \u039d\u0391\u03a1\u039a\u03a9\u03a4\u0399\u039a\u03a9\u039d",
            "\u039c\u0395\u03a4\u0391\u039c\u039f\u03a3\u03a7\u0395\u03a5\u03a3\u0397 \u0392\u0399\u039f\u039b\u039f\u0393\u0399\u039a\u03a9\u039d \u039f\u03a5\u03a3\u0399\u03a9\u039d",
            "\u0392\u03a1\u0391\u0392\u0395\u0399\u0391 \u039a\u0391\u0399 \u03a7\u039f\u03a1\u0397\u0393\u0399\u0395\u03a3",
            "\u0395\u03a5\u03a1\u03a9\u03a0\u0391\u0399\u039a\u0397 \u039c\u039f\u03a1\u03a6\u03a9\u03a4\u0399\u039a\u0397 \u03a3\u03a5\u039c\u0392\u0391\u03a3\u0397",
            "\u03a4\u0391\u039c\u0395\u0399\u039f \u0395\u03a0\u0399\u039a\u039f\u03a5\u03a1\u0399\u039a\u0397\u03a3 \u0391\u03a3\u03a6\u0391\u039b\u0399\u03a3\u0395\u03a9\u03a3 \u03a0\u03a1\u039f\u03a3\u03a9\u03a0\u0399\u039a\u039f\u03a5 \u0395\u039b\u039b\u0397\u039d. \u0395\u03a1\u03a5\u0398\u03a1\u039f\u03a5 \u03a3\u03a4\u0391\u03a5\u03a1\u039f\u03a5 (\u03a4.\u0395.\u0391.\u03a0.\u0395.\u0395.\u03a3.)",
            "\u0391\u03a4\u0395\u039b\u0395\u0399\u0395\u03a3 \u0395\u0399\u0394\u03a9\u039d \u0392\u039f\u0397\u0398\u0395\u0399\u0391\u03a3",
            "\u0395\u039a\u03a4\u0395\u039b\u0395\u03a3\u0397 \u0395\u03a1\u0393\u03a9\u039d \u039f\u03a7\u03a5\u03a1\u03a9\u03a3\u0397\u03a3",
            "\u03a1\u039f\u03a5\u0391\u039d\u03a4\u0391 \u2013 \u03a1\u039f\u03a5\u039c\u0391\u039d\u0399\u0391 \u039a.\u039b\u03a0",
            "\u039c\u039f\u039d\u0399\u039c\u0395\u03a3 \u0391\u039d\u03a4\u0399\u03a0\u03a1\u039f\u03a3\u03a9\u03a0\u0395\u0399\u0395\u03a3",
            "\u03a0\u03a1\u039f\u03a3\u03a4\u0391\u03a3\u0399\u0391 \u0395\u03a6\u0395\u0394\u03a1\u03a9\u039d \u0399\u03a0\u03a4\u0391\u039c\u0395\u039d\u03a9\u039d",
            "\u03a4\u03a1\u0391\u03a0\u0395\u0396\u0395\u03a3 \u0395\u039e\u03a9\u03a4\u0395\u03a1\u0399\u039a\u039f\u03a5 \u0395\u039c\u03a0\u039f\u03a1\u0399\u039f\u03a5",
            "\u0399\u0391\u03a4\u03a1\u0399\u039a\u039f\u039d \u03a0\u03a1\u039f\u03a3\u03a9\u03a0\u0399\u039a\u039f\u039d \u0394\u0397\u039c\u039f\u03a3\u0399\u039f\u03a5 \u039a\u0391\u0399 \u039d.\u03a0.\u0394.\u0394",
            "\u0394\u0399\u0391\u03a6\u039f\u03a1\u0391  \u039c\u039f\u039d\u0391\u03a3\u03a4\u0397\u03a1\u0399\u0391",
            "\u0395\u03a4\u0391\u0399\u03a1\u0395\u0399\u0395\u03a3 \u0395\u03a0\u0395\u039d\u0394\u03a5\u03a3\u0395\u03a9\u039d - \u03a7\u0391\u03a1\u03a4\u039f\u03a6\u03a5\u039b\u0391\u039a\u0399\u039f\u03a5 \u039a\u0391\u0399 \u0391\u039c\u039f\u0399\u0392\u0391\u0399\u03a9\u039d \u039a\u0395\u03a6\u0391\u039b\u0391\u0399\u03a9\u039d",
            "\u0391\u039d\u0391\u0393\u039d\u03a9\u03a1\u0399\u03a3\u0397 \u03a4\u0397\u03a3 \u0395\u039b\u039b\u0397\u039d\u0399\u039a\u0397\u03a3 \u03a0\u039f\u039b\u0399\u03a4\u0395\u0399\u0391\u03a3",
            "\u0394\u0399\u0395\u0398\u039d\u0397\u03a3 \u03a3\u03a5\u039c\u0392\u0391\u03a3\u0397",
            "\u039b\u0399\u039c\u0395\u039d\u0391\u03a1\u03a7\u0395\u0399\u0391",
            "\u03a3\u0395\u0399\u03a3\u039c\u039f\u03a0\u039b\u0397\u039a\u03a4\u039f\u0399 \u0398\u0395\u03a3\u03a3\u0391\u039b\u0399\u0391\u03a3",
            "\u03a3\u03a4\u03a1\u0391\u03a4\u0395\u03a5\u03a3\u0397 \u0393\u03a5\u039d\u0391\u0399\u039a\u03a9\u039d",
            "\u03a3\u03a4\u03a1\u0391\u03a4\u0399\u03a9\u03a4\u0399\u039a\u0397 \u03a5\u03a0\u0397\u03a1\u0395\u03a3\u0399\u0391 \u039a\u0391\u03a4\u0391\u03a3\u039a\u0395\u03a5\u0397\u03a3 \u0395\u03a1\u0393\u03a9\u039d \u0391\u039d\u0391\u03a3\u03a5\u0393\u039a\u03a1\u039f\u03a4\u0397\u03a3\u0397\u03a3",
            "\u03a0\u03a1\u039f\u03a3\u03a4\u0391\u03a3\u0399\u0391 \u03a4\u0397\u03a3 \u03a4\u0399\u039c\u0397\u03a3 \u03a4\u039f\u03a5 \u03a0\u039f\u039b\u0399\u03a4\u0399\u039a\u039f\u03a5 \u039a\u039f\u03a3\u039c\u039f\u03a5",
            "\u0395\u03a0\u0399\u039c\u039f\u03a1\u03a6\u03a9\u03a3\u0397 \u039b\u0395\u0399\u03a4\u039f\u03a5\u03a1\u0393\u03a9\u039d \u039c.\u0395",
            "\u0395\u039d\u0399\u03a3\u03a7\u03a5\u03a3\u0397 \u0395\u039e\u0391\u0393\u03a9\u0393\u0397\u03a3",
            "\u0397\u039b\u0395\u039a\u03a4\u03a1\u039f\u03a6\u03a9\u03a4\u0399\u03a3\u039c\u039f\u03a3 \u0394\u0399\u0391\u03a6\u039f\u03a1\u03a9\u039d \u03a0\u039f\u039b\u0395\u03a9\u039d",
            "\u039c\u0395 \u03a4\u0399\u03a3 \u039a\u0391\u03a4\u03a9 \u03a7\u03a9\u03a1\u0395\u03a3",
            "\u039d\u0391\u03a5\u03a0\u0397\u0393\u039f\u03a5\u039c\u0395\u039d\u0391 \u03a0\u039b\u039f\u0399\u0391-\u039d\u0391\u03a5\u03a0\u0397\u0393\u039f\u0395\u03a0\u0399\u03a3\u039a\u0395\u03a5\u0391\u03a3\u03a4\u0399\u039a\u0395\u03a3",
            "\u0395\u039b\u0395\u0393\u03a7\u039f\u03a3 \u03a0\u03a9\u039b\u0397\u03a3\u0395\u03a9\u039d \u0395\u03a0\u0399 \u03a0\u0399\u03a3\u03a4\u03a9\u03a3\u0395\u0399",
            "\u0395\u039b\u0395\u0393\u03a7\u039f\u03a3 \u0392\u0399\u039f\u039c\u0397\u03a7\u0391\u039d\u0399\u039a\u03a9\u039d \u0395\u0393\u039a\u0391\u03a4\u0391\u03a3\u03a4\u0391\u03a3\u0395\u03a9\u039d",
            "\u0394\u0399\u0395\u0398\u039d\u0397\u03a3 \u039f\u0399\u039a\u039f\u039d\u039f\u039c\u0399\u039a\u0397 \u0395\u03a0\u0399\u03a4\u03a1\u039f\u03a0\u0397",
            "\u0393\u03a1\u0391\u03a6\u0395\u0399\u0391 \u0395\u03a5\u03a1\u0395\u03a3\u0397\u03a3 \u0395\u03a1\u0393\u0391\u03a3\u0399\u0391\u03a3 - \u03a3\u03a5\u039c\u0392\u039f\u03a5\u039b\u039f\u0399 \u0395\u03a1\u0393\u0391\u03a3\u0399\u0391\u03a3",
            "\u039c\u039f\u039d\u039f\u03a0\u03a9\u039b\u0399\u039f \u039d\u0391\u03a1\u039a\u03a9\u03a4\u0399\u039a\u03a9\u039d",
            "\u0391\u03a0\u0391\u039b\u039b\u0391\u0393\u0395\u03a3 \u03a6\u039f\u03a1\u039f\u039b\u039f\u0393\u0399\u0391\u03a3 \u039a\u039b\u0397\u03a1\u039f\u039d\u039f\u039c\u0399\u03a9\u039d",
            "\u03a0\u0391\u0393\u039a\u039f\u03a3\u039c\u0399\u0391 \u039f\u03a1\u0393\u0391\u039d\u03a9\u03a3\u0397 \u03a5\u0393\u0395\u0399\u0391\u03a3",
            "\u0395\u0398\u039d\u0399\u039a\u039f \u0399\u0394\u03a1\u03a5\u039c\u0391 \u0395\u03a1\u0395\u03a5\u039d\u03a9\u039d",
            "\u039d\u039f\u039c\u039f\u0398\u0395\u03a3\u0399\u0391 \u03a0\u0395\u03a1\u0399 \u03a3\u03a5\u039b\u039b\u039f\u0393\u0399\u039a\u0397\u03a3 \u03a3\u03a5\u039c\u0392\u0391\u03a3\u0395\u03a9\u03a3",
            "\u0395\u0398\u039d\u0399\u039a\u039f\u03a3 \u039f\u03a1\u0393\u0391\u039d\u0399\u03a3\u039c\u039f\u03a3 \u03a6\u0391\u03a1\u039c\u0391\u039a\u03a9\u039d",
            "\u0394\u0399\u0391\u03a6\u039f\u03a1\u0391 \u0393\u03a5\u039c\u039d\u0391\u03a3\u0399\u0391 & \u039b\u03a5\u039a\u0395\u0399\u0391",
            "\u039e\u0395\u039d\u0395\u03a3 \u03a3\u03a7\u039f\u039b\u0395\u03a3 \u0393\u0395\u03a9\u03a0\u039f\u039d\u0399\u0391\u03a3 \u039a\u0391\u0399 \u0394\u0391\u03a3\u039f\u039b\u039f\u0393\u0399\u0391\u03a3",
            "\u03a0\u03a1\u039f\u03a3\u03a4\u0391\u03a3\u0399\u0391 \u0391\u039d\u0395\u03a1\u0393\u03a9\u039d",
            "\u03a6\u0399\u039b\u0391\u039d\u0398\u03a1\u03a9\u03a0\u0399\u039a\u0391 \u039a\u0391\u03a4\u0391\u03a3\u03a4\u0397\u039c\u0391\u03a4\u0391 \u039a\u0395\u03a6\u0391\u039b\u039b\u0397\u039d\u0399\u0391\u03a3",
            "\u039a\u0391\u039d\u039f\u039d\u0399\u03a3\u039c\u039f\u03a3 \u03a0\u0391\u03a1\u039f\u03a7\u03a9\u039d \u03a4.\u0395.\u0392.\u0395",
            "\u03a9\u0394\u0395\u0399\u0391 \u039a\u039b\u03a0. \u039c\u039f\u03a5\u03a3\u0399\u039a\u0391 \u0399\u0394\u03a1\u03a5\u039c\u0391\u03a4\u0391",
            "\u03a0\u03a1\u039f\u03a3\u039a\u03a5\u039d\u0397\u039c\u0391\u03a4\u0399\u039a\u0391 \u0399\u0394\u03a1\u03a5\u039c\u0391\u03a4\u0391",
            "\u03a4\u0391\u039c\u0395\u0399\u039f \u0395\u03a0\u0399\u039a\u039f\u03a5\u03a1\u0399\u039a\u0397\u03a3 \u0391\u03a3\u03a6\u0391\u039b\u0399\u03a3\u0395\u03a9\u03a3 \u03a0\u03a1\u039f\u03a3\u03a9\u03a0\u0399\u039a\u039f\u03a5 \u0391\u039d\u03a9\u039d. \u03a5\u0394\u03a1\u039f\u0397\u039b\u0395\u039a\u03a4\u03a1. \u0395\u03a4. \u0393\u039b\u0391\u03a5\u039a\u039f\u03a3",
            "\u03a0\u03a1\u0395\u03a3\u0392\u0395\u0399\u0395\u03a3 \u039a\u0391\u0399 \u03a0\u03a1\u039f\u039e\u0395\u039d\u0395\u0399\u0391",
            "\u03a5\u03a0\u039f\u03a5\u03a1\u0393\u0395\u0399\u0391 \u03a4\u03a5\u03a0\u039f\u03a5 \u039a\u0391\u0399 \u03a4\u039f\u03a5\u03a1\u0399\u03a3\u039c\u039f\u03a5",
            "\u0396\u03a9\u039d\u0395\u03a3 \u0395\u039d\u0395\u03a1\u0393\u039f\u03a5 \u03a0\u039f\u039b\u0395\u039f\u0394\u039f\u039c\u0399\u0391\u03a3",
            "\u0395\u039a\u039a\u039b\u0397\u03a3\u0399\u0391 \u0399\u039f\u039d\u0399\u03a9\u039d \u039d\u0397\u03a3\u03a9\u039d",
            "\u0395\u03a0\u0399\u03a4\u03a1\u039f\u03a0\u0391\u0399 \u0391\u03a3\u03a6\u0391\u039b\u0395\u0399\u0391\u03a3",
            "\u03a5\u03a0\u039f\u03a5\u03a1\u0393\u039f\u0399",
            "\u03a0\u039f\u0399\u039d\u0399\u039a\u0397 \u0394\u0399\u0391\u03a4\u0399\u039c\u0397\u03a3\u0397",
            "\u03a4\u0391\u039c\u0395\u0399\u039f \u0391\u03a3\u03a6\u0391\u039b\u0399\u03a3\u0395\u03a9\u03a3 \u0395\u03a1\u0393\u0391\u03a4\u03a9\u039d \u039a\u0395\u03a1\u0391\u039c\u039f\u03a0\u039f\u0399\u03a9\u039d",
            "\u03a0\u03a1\u03a9\u03a4\u0395\u03a3 \u03a5\u039b\u0395\u03a3 \u03a0\u0391\u0399\u0393\u039d\u0399\u039f\u03a7\u0391\u03a1\u03a4\u03a9\u039d",
            "\u039a\u03a1\u03a5\u03a0\u03a4\u039f\u0393\u03a1\u0391\u03a6\u0399\u039a\u0397 \u03a5\u03a0\u0397\u03a1\u0395\u03a3\u0399\u0391",
            "\u0394\u0399\u0395\u0398\u039d\u0397\u03a3 \u0395\u03a0\u0399\u03a4\u03a1\u039f\u03a0\u0397 \u03a0\u03a1\u039f\u03a3\u03a9\u03a0\u0399\u039a\u0397\u03a3 \u039a\u0391\u03a4\u0391\u03a3\u03a4\u0391\u03a3\u0395\u03a9\u03a3",
            "\u0395\u039b\u0395\u0393\u03a7\u039f\u03a3 \u0397\u039b\u0395\u039a\u03a4\u03a1\u0399\u039a\u03a9\u039d \u0395\u0393\u039a\u0391\u03a4\u0391\u03a3\u03a4\u0391\u03a3\u0395\u03a9\u039d",
            "\u0394\u0399\u0391\u03a7\u0395\u0399\u03a1\u0399\u03a3\u0397 \u0399\u0394\u03a1\u03a5\u039c\u0391\u03a4\u03a9\u039d \u039a\u0391\u0399 \u039a\u039b\u0397\u03a1\u039f\u0394\u039f\u03a4\u0397\u039c\u0391\u03a4\u03a9\u039d",
            "\u03a4\u0395\u039b\u03a9\u039d\u0395\u0399\u0391\u039a\u0397 \u03a3\u03a4\u0391\u03a4\u0399\u03a3\u03a4\u0399\u039a\u0397",
            "\u0399\u0394\u0399\u03a9\u03a4\u0399\u039a\u0395\u03a3 \u039d\u0391\u03a5\u03a4\u0399\u039a\u0395\u03a3 \u03a3\u03a7\u039f\u039b\u0395\u03a3",
            "\u0391\u0395\u03a1\u039f\u03a0\u039f\u03a1\u0399\u039a\u0391 \u0391\u03a4\u03a5\u03a7\u0397\u039c\u0391\u03a4\u0391",
            "\u0391\u039d\u03a9\u03a4\u0395\u03a1\u039f \u0394\u0399\u0394\u0391\u039a\u03a4\u0399\u039a\u039f \u03a0\u03a1\u039f\u03a3\u03a9\u03a0\u0399\u039a\u039f",
            "\u0394\u0399\u0391\u03a6\u039f\u03a1\u039f\u0399 \u0394\u0399\u039f\u0399\u039a\u0397\u03a4\u0399\u039a\u039f\u0399 \u0395\u03a1\u0393\u0391\u03a4\u0399\u039a\u039f\u0399 \u039d\u039f\u039c\u039f\u0399",
            "\u03a3\u03a5\u039c\u0392\u039f\u03a5\u039b\u0399\u039f \u0393\u0395\u03a9\u0393\u03a1\u0391\u03a6\u0399\u039a\u03a9\u039d \u03a5\u03a0\u0397\u03a1\u0395\u03a3\u0399\u03a9\u039d",
            "\u0395\u039a\u039a\u039b\u0397\u03a3\u0399\u0391\u03a3\u03a4\u0399\u039a\u0395\u03a3 \u0392\u0399\u0392\u039b\u0399\u039f\u0398\u0397\u039a\u0395\u03a3",
            "\u03a4\u039c\u0397\u039c\u0391 \u0395\u03a0\u0399\u03a3\u03a4\u0397\u039c\u0397\u03a3 \u03a6\u03a5\u03a3\u0399\u039a\u0397\u03a3 \u0391\u0393\u03a9\u0393\u0397\u03a3 \u039a\u0391\u0399 \u0391\u0398\u039b\u0397\u03a4\u0399\u03a3\u039c\u039f\u03a5",
            "\u03a0\u0395\u03a1\u0399\u039f\u03a1\u0399\u03a3\u039c\u039f\u03a3 \u03a3\u03a5\u039d\u0398\u0395\u03a3\u0395\u03a9\u03a3 \u03a5\u03a0\u0397\u03a1\u0395\u03a3\u0399\u03a9\u039d",
            "\u03a4\u0391\u039c\u0395\u0399\u0391 \u0395\u03a0\u0391\u03a1\u03a7\u0399\u0391\u039a\u0397\u03a3 \u039f\u0394\u039f\u03a0\u039f\u0399\u0399\u0391\u03a3",
            "\u03a4\u0399\u039c\u039f\u039b\u039f\u0393\u0399\u0391 \u039f.\u03a4.\u0395 - \u039a\u039f\u03a3\u03a4\u039f\u039b\u039f\u0393\u0397\u03a3\u0397 \u03a5\u03a0\u0397\u03a1\u0395\u03a3\u0399\u03a9\u039d \u039f.\u03a4.\u0395",
            "\u0395\u0398\u039d\u0399\u039a\u0397 \u0392\u0399\u0392\u039b\u0399\u039f\u0398\u0397\u039a\u0397",
            "\u0394\u0397\u039c\u039f\u03a3\u0399\u0395\u03a3 \u03a3\u03a7\u039f\u039b\u0395\u03a3 \u03a5\u03a0\u039f\u039c\u0397\u03a7\u0391\u039d\u0399\u039a\u03a9\u039d",
            "\u0391\u039d\u0391\u03a6\u039f\u03a1\u0395\u03a3 \u03a0\u03a1\u039f\u03a3 \u03a4\u0399\u03a3 \u0391\u03a1\u03a7\u0395\u03a3",
            "\u039a\u03a1\u0391\u03a4\u0399\u039a\u0397 \u0395\u039a\u039c\u0395\u03a4\u0391\u039b\u039b\u0395\u03a5\u03a3\u0397 \u039b\u0395\u03a9\u03a6\u039f\u03a1\u0395\u0399\u0391\u039a\u03a9\u039d \u0393\u03a1\u0391\u039c\u039c\u03a9\u039d",
            "\u0394\u0399\u0391\u03a6\u039f\u03a1\u0391 \u0395\u03a0\u0399\u0394\u039f\u039c\u0391\u03a4\u0391",
            "\u0399\u0394\u0399\u03a9\u03a4\u0399\u039a\u0397 \u0391\u0395\u03a1\u039f\u03a0\u039f\u03a1\u0399\u0391 \u2013 \u0391\u0395\u03a1\u039f\u039b\u0395\u03a3\u03a7\u0395\u03a3",
            "\u03a4\u039c\u0397\u039c\u0391 \u0394\u0399\u039f\u0399\u039a\u0397\u03a4\u0399\u039a\u0397\u03a3 \u03a4\u03a9\u039d \u0395\u03a0\u0399\u03a7\u0395\u0399\u03a1\u0397\u03a3\u0395\u03a9\u039d",
            "\u0394\u0399\u0395\u0398\u039d\u0395\u0399\u03a3 \u0391\u0395\u03a1\u039f\u03a0\u039f\u03a1\u0399\u039a\u0395\u03a3 \u03a3\u03a5\u039c\u0392\u0391\u03a3\u0395\u0399\u03a3",
            "\u03a0\u03a1\u039f\u0399\u039a\u039f\u0394\u039f\u03a4\u0397\u03a3\u0395\u0399\u03a3 \u0395\u039e \u0395\u0398\u039d\u0399\u039a\u03a9\u039d \u0393\u0391\u0399\u03a9\u039d",
            "\u0394\u0399\u039f\u03a1\u0398\u03a9\u03a3\u0397 \u0391\u03a3\u03a5\u039c\u03a6\u03a9\u039d\u0399\u03a9\u039d",
            "\u0395\u03a0\u0399\u03a4\u03a1\u039f\u03a0\u0397 \u0394\u0399\u039f\u0399\u039a\u0397\u03a3\u0395\u03a9\u03a3",
            "\u039c\u0395\u03a4\u0391 \u03a4\u0397\u03a3 \u0393\u0395\u03a1\u039c\u0391\u039d\u0399\u0391\u03a3",
            "\u039f\u0399\u039a\u039f\u0394\u039f\u039c\u0399\u039a\u039f\u0399 \u03a3\u03a5\u039d\u0395\u03a4\u0391\u0399\u03a1\u0399\u03a3\u039c\u039f\u0399",
            "\u039a\u0391\u03a4\u0391\u03a3\u03a4\u0391\u03a4\u0399\u039a\u039f\u0399 \u039d\u039f\u039c\u039f\u0399",
            "\u0391\u039e\u0399\u03a9\u039c\u0391\u03a4\u0399\u039a\u039f\u0399 \u0393\u03a1\u0391\u03a6\u0395\u0399\u039f\u03a5",
            "\u039a\u0391\u039d\u039f\u039d\u0399\u03a3\u039c\u039f\u03a3 \u0395\u039d\u0391\u0395\u03a1\u0399\u039f\u03a5 \u039a\u03a5\u039a\u039b\u039f\u03a6\u039f\u03a1\u0399\u0391\u03a3",
            "\u0394\u0399\u0391\u03a7\u0395\u0399\u03a1\u0399\u03a3\u0397 \u039a\u0391\u03a5\u03a3\u0399\u039c\u03a9\u039d",
            "\u039f\u039c\u039f\u039b\u039f\u0393\u0399\u0391\u039a\u0391 \u0394\u0391\u039d\u0395\u0399\u0391",
            "\u0395\u03a1\u0393\u0391",
            "\u03a3\u03a7\u039f\u039b\u0397 \u039d\u0391\u03a5\u03a4\u0399\u039a\u03a9\u039d \u0394\u039f\u039a\u0399\u039c\u03a9\u039d",
            "\u03a0\u03a9\u039b\u0397\u03a3\u0397 \u03a6\u0391\u03a1\u039c\u0391\u039a\u03a9\u039d \u0391\u03a0\u039f \u0399\u0391\u03a4\u03a1\u039f\u03a5\u03a3",
            "\u03a3\u0397\u039c\u0391\u03a4\u0391 \u0395\u0398\u039d\u0399\u039a\u039f\u03a4\u0397\u03a4\u0391\u03a3 \u039a\u0391\u0399 \u039d\u0397\u039f\u039b\u039f\u0393\u0397\u03a3\u0395\u03a9\u03a3",
            "\u039b\u0395\u0399\u03a4\u039f\u03a5\u03a1\u0393\u039f\u0399 \u03a3\u03a4\u039f\u0399\u03a7\u0395\u0399\u03a9\u0394\u039f\u03a5\u03a3",
            "\u0395\u03a6\u0395\u03a4\u0395\u0399\u0391 \u039a\u0391\u0399 \u03a0\u03a1\u03a9\u03a4\u039f\u0394\u0399\u039a\u0395\u0399\u0391",
            "\u03a5\u03a0\u039f\u03a5\u03a1\u0393\u0395\u0399\u039f \u03a0\u03a1\u039f\u0395\u0394\u03a1\u0399\u0391\u03a3 \u039a\u03a5\u0392\u0395\u03a1\u039d\u0397\u03a3\u0395\u03a9\u03a3",
            "\u039c\u039f\u03a1\u03a6\u03a9\u03a4\u0399\u039a\u039f\u03a3 \u2013 \u039a\u0399\u039d\u0397\u039c\u0391\u03a4\u039f\u0393\u03a1\u0391\u03a6\u039f\u03a3",
            "\u039a\u0391\u03a4\u0391\u039c\u0395\u03a4\u03a1\u0397\u03a3\u0397 \u03a7\u03a9\u03a1\u0397\u03a4\u0399\u039a\u039f\u03a4\u0397\u03a4\u0391\u03a3",
            "\u03a6\u03a9\u03a4\u0391\u0395\u03a1\u0399\u039f",
            "\u03a0\u0391\u0398\u0397\u03a4\u0399\u039a\u0397 \u0391\u0395\u03a1\u0391\u039c\u03a5\u039d\u0391",
            "\u03a0\u03a1\u039f\u03a3\u03a9\u03a0\u0399\u039a\u039f \u039d\u039f\u03a3\u0397\u039b\u0395\u03a5\u03a4\u0399\u039a\u03a9\u039d \u0399\u0394\u03a1\u03a5\u039c\u0391\u03a4\u03a9\u039d",
            "\u039c\u0395 \u03a4\u0397\u039d \u039a\u03a5\u03a0\u03a1\u039f",
            "\u039a\u039f\u039b\u039b\u0397\u0393\u039f\u0399 (\u0395\u03a0\u0399\u039c\u039f\u03a1\u03a4\u039f\u0399 \u039a\u0391\u039b\u039b\u0399\u0395\u03a1\u0393\u0397\u03a4\u0395\u03a3)",
            "\u03a4\u0391\u039c\u0395\u0399\u039f \u0391\u03a1\u03a9\u0393\u0397\u03a3 \u039b.\u03a3",
            "\u0399\u03a7\u0398\u03a5\u039f\u03a3\u039a\u0391\u039b\u0395\u03a3",
            "\u03a3\u03a7\u0397\u039c\u0391 \u039a\u0391\u0399 \u03a4\u0399\u039c\u0397 \u03a0\u03a9\u039b\u0397\u03a3\u0397\u03a3 \u0395\u03a6\u0397\u039c\u0395\u03a1\u0399\u0394\u03a9\u039d",
            "\u03a5\u0399\u039f\u0398\u0395\u03a3\u0399\u0391",
            "\u0395\u039a\u03a4\u0395\u039b\u0395\u03a3\u0397 \u0395\u03a1\u0393\u03a9\u039d \u0391\u03a1\u039c\u039f\u0394\u0399\u039f\u03a4\u0397\u03a4\u0391\u03a3 \u0395\u039a\u039a\u039b\u0397\u03a3\u0399\u0391\u03a3",
            "\u03a4\u0391\u039c\u0395\u0399\u039f \u03a3\u03a5\u039d\u03a4\u0391\u039e\u0395\u03a9\u039d \u03a0\u03a1\u039f\u03a3\u03a9\u03a0\u0399\u039a\u039f\u03a5",
            "\u0394\u0399\u0391\u03a6\u039f\u03a1\u0395\u03a3 \u0395\u03a5\u03a1\u03a9\u03a0\u0391\u0399\u039a\u0395\u03a3 \u03a3\u03a5\u039c\u03a6\u03a9\u039d\u0399\u0395\u03a3",
            "\u0395\u0393\u0393\u0395\u0399\u039f\u03a3 \u03a6\u039f\u03a1\u039f\u039b\u039f\u0393\u0399\u0391",
            "\u03a0\u0391\u0399\u0394\u0391\u0393\u03a9\u0393\u0399\u039a\u0395\u03a3 \u0391\u039a\u0391\u0394\u0397\u039c\u0399\u0395\u03a3",
            "\u03a4\u0391\u039c\u0395\u0399\u039f \u03a0\u03a1\u039f\u039d\u039f\u0399\u0391\u03a3 \u0395\u03a1\u0393\u0391\u03a4\u039f\u03a5\u03a0\u0391\u039b\u039b\u0397\u039b\u03a9\u039d \u039c\u0395\u03a4\u0391\u039b\u039b\u039f\u03a5 (\u03a4\u0391.\u03a0.\u0395.\u039c.)",
            "\u03a4\u0395\u03a7\u039d\u0399\u039a\u0397 \u0395\u039a\u039c\u0395\u03a4\u0391\u039b\u039b\u0395\u03a5\u03a3\u0397 \u0391\u0395\u03a1\u039f\u03a3\u039a\u0391\u03a6\u03a9\u039d",
            "\u0395\u039d\u03a9\u03a3\u0397 \u0391\u03a0\u039f\u03a3\u03a4\u03a1\u0391\u03a4\u03a9\u039d \u0391\u039e\u0399\u03a9\u039c\u0391\u03a4\u0399\u039a\u03a9\u039d \u0392.\u0391",
            "\u0391\u03a3\u03a6\u0391\u039b\u0399\u03a3\u0397 \u0395\u03a1\u0393\u0391\u03a4\u03a9\u039d \u0393\u0395\u03a9\u03a1\u0393\u0399\u0391\u03a3",
            "\u039f\u03a1\u0393\u0391\u039d\u03a9\u03a3\u0397 \u039a\u0391\u039b\u039b\u0399\u03a4\u0395\u03a7\u039d\u0399\u039a\u03a9\u039d \u0395\u039a\u0394\u0397\u039b\u03a9\u03a3\u0395\u03a9\u039d-\u03a6\u0395\u03a3\u03a4\u0399\u0392\u0391\u039b",
            "\u03a0\u0395\u03a1\u0399\u039f\u03a5\u03a3\u0399\u0391\u039a\u0395\u03a3 \u03a3\u03a5\u039d\u0395\u03a0\u0395\u0399\u0395\u03a3 \u03a4\u0397\u03a3 \u03a0\u039f\u0399\u039d\u0397\u03a3",
            "\u03a4\u0397\u039b\u0395\u0393\u03a1\u0391\u03a6\u0399\u039a\u0397 \u0391\u039d\u03a4\u0391\u03a0\u039f\u039a\u03a1\u0399\u03a3\u0397",
            "\u0395\u03a0\u0399\u0398\u0395\u03a9\u03a1\u0397\u03a3\u0397 \u0394\u0397\u039c\u039f\u03a3\u0399\u03a9\u039d \u03a5\u03a0\u039f\u039b\u039f\u0393\u03a9\u039d",
            "\u039c\u0395 \u03a4\u039f\u039d \u039a\u0391\u039d\u0391\u0394\u0391",
            "\u0391\u039b\u039b\u0397\u039b\u039f\u0393\u03a1\u0391\u03a6\u0399\u0391 \u03a5.\u0395.\u039d",
            "\u03a4\u0395\u03a7\u039d\u0399\u039a\u039f \u03a0\u03a1\u039f\u03a3\u03a9\u03a0\u0399\u039a\u039f \u0391\u0395\u03a1\u039f\u03a0\u039f\u03a1\u0399\u0391\u03a3",
            "\u039a\u039b\u0391\u0394\u039f\u03a3 \u0391\u03a5\u03a4\u039f\u03a4\u0395\u039b\u03a9\u03a3 \u0391\u03a0\u0391\u03a3\u03a7\u039f\u039b\u039f\u03a5\u039c\u0395\u039d\u03a9\u039d, \u0395\u039b\u0395\u03a5\u0398\u0395\u03a1\u03a9\u039d \u039a\u0391\u0399 \u0391\u039d\u0395\u039e\u0391\u03a1\u03a4\u0397\u03a4\u03a9\u039d",
            "\u03a3\u03a7\u039f\u039b\u0395\u0399\u0391 \u0392\u0391\u03a1\u03a5\u039a\u039f\u03a9\u039d \u0397 \u039a\u03a9\u03a6\u03a9\u039d",
            "\u03a4\u0391\u039c\u0395\u0399\u039f \u03a0\u03a1\u039f\u039d\u039f\u0399\u0391\u03a3 \u039a\u0391\u03a4\u03a9\u03a4\u0395\u03a1\u03a9\u039d \u03a0\u039b\u0397\u03a1\u03a9\u039c\u0391\u03a4\u03a9\u039d \u0395.\u039d",
            "\u03a4\u039f\u03a5\u03a1\u0399\u03a3\u03a4\u0399\u039a\u0391 \u03a0\u039b\u039f\u0399\u0391 - \u03a3\u039a\u0391\u03a6\u0397 \u0391\u039d\u0391\u03a8\u03a5\u03a7\u0397\u03a3 - \u03a4\u039f\u03a5\u03a1\u0399\u03a3\u03a4\u0399\u039a\u039f\u0399 \u039b\u0399\u039c\u0395\u039d\u0395\u03a3 (\u039c\u0391\u03a1\u0399\u039d\u0395\u03a3)",
            "\u0395\u03a0\u0399\u0394\u039f\u039c\u0391\u03a4\u0391 \u0395\u039f\u03a1\u03a4\u03a9\u039d \u03a7\u03a1\u0399\u03a3\u03a4\u039f\u03a5\u0393\u0395\u039d\u039d\u03a9\u039d \u039a\u0391\u0399 \u03a0\u0391\u03a3\u03a7\u0391",
            "\u0395\u03a0\u0399\u039c\u0395\u039b\u0397\u03a4\u0397\u03a1\u0399\u0391 - \u0393\u0395\u039d\u0399\u039a\u0395\u03a3 \u0394\u0399\u0391\u03a4\u0391\u039e\u0395\u0399\u03a3",
            "\u03a5\u03a0\u039f\u03a5\u03a1\u0393\u0395\u0399\u039f \u0395\u03a1\u0395\u03a5\u039d\u0391\u03a3 \u039a\u0391\u0399 \u03a4\u0395\u03a7\u039d\u039f\u039b\u039f\u0393\u0399\u0391\u03a3",
            "\u03a3\u03a4\u0395\u0393\u0391\u03a3\u0397 \u0391\u039e\u0399\u03a9\u039c\u0391\u03a4\u0399\u039a\u03a9\u039d",
            "\u03a0\u0391\u03a1\u0391\u03a1\u03a4\u0397\u039c\u0391\u03a4\u0391 \u0393\u0395\u039d\u0399\u039a\u039f\u03a5 \u03a7\u0397\u039c\u0395\u0399\u039f\u03a5",
            "\u039a\u0391\u0398\u0391\u03a1\u0399\u03a3\u03a4\u03a1\u0399\u0395\u03a3",
            "\u039a\u0391\u039d\u039f\u039d\u0399\u03a3\u039c\u039f\u03a3 \u039d\u0391\u03a5\u03a4\u039f\u0394\u0399\u039a\u0395\u0399\u039f\u03a5",
            "\u0391\u039c\u039f\u0399\u0392\u0395\u03a3 \u039c\u0397\u03a7\u0391\u039d\u0399\u039a\u03a9\u039d",
            "\u0395\u03a0\u0399\u039c\u039f\u03a1\u03a6\u03a9\u03a3\u0397 \u0394\u0397\u039c\u039f\u03a3\u0399\u03a9\u039d \u03a5\u03a0\u0391\u039b\u039b\u0397\u039b\u03a9\u039d",
            "\u039a\u0391\u039d\u039f\u039d\u0399\u03a3\u039c\u039f\u0399 \u0395\u03a0\u0399\u0392\u0391\u03a4\u0397\u0393\u03a9\u039d \u03a0\u039b\u039f\u0399\u03a9\u039d",
            "\u03a4\u0391\u039c\u0395\u0399\u039f \u03a3\u03a5\u039d\u03a4\u0391\u039e\u0395\u03a9\u039d \u03a0\u03a1\u039f\u03a3\u03a9\u03a0\u0399\u039a\u039f\u03a5 \u0395\u03a4\u0391\u0399\u03a1\u0399\u0391\u03a3 \u0395\u039b\u039b. \u039a\u0391\u039b\u03a5\u039a\u039f\u03a0\u039f\u0399\u0395\u0399\u039f\u03a5-\u03a0\u03a5\u03a1\u0399\u03a4\u0399\u0394\u039f\u03a0\u039f\u0399\u0395\u0399\u039f\u03a5",
            "\u03a0\u03a1\u039f\u03a3\u03a9\u03a0\u0399\u039a\u039f \u03a4\u03a1\u0391\u03a0\u0395\u0396\u03a9\u039d",
            "\u039b\u03a5\u03a3\u03a3\u0399\u0391\u03a4\u03a1\u0395\u0399\u0391",
            "\u03a3\u03a5\u039d\u039f\u03a1\u0399\u0391\u039a\u0395\u03a3 \u03a5\u0393\u0395\u0399\u039f\u039d\u039f\u039c\u0399\u039a\u0395\u03a3 \u03a3\u03a5\u039c\u0392\u0391\u03a3\u0395\u0399\u03a3",
            "\u03a0\u039f\u039b\u0395\u039c\u0399\u039a\u039f \u039c\u039f\u03a5\u03a3\u0395\u0399\u039f",
            "\u039a\u0391\u0398\u0397\u039a\u039f\u039d\u03a4\u0391 \u03a4\u0395\u039b\u03a9\u039d\u0395\u0399\u0391\u039a\u03a9\u039d \u03a5\u03a0\u0391\u039b\u039b\u0397\u039b\u03a9\u039d",
            "\u0395\u03a0\u0395\u039a\u03a4\u0391\u03a3\u0397 \u03a4\u0397\u03a3 \u0391\u03a3\u03a6\u0391\u039b\u0399\u03a3\u0395\u03a9\u03a3",
            "\u03a6\u039f\u03a1\u039f\u039b\u039f\u0393\u0399\u039a\u0395\u03a3 \u0391\u03a0\u0391\u039b\u039b\u0391\u0393\u0395\u03a3",
            "\u0395\u03a0\u0399\u0394\u039f\u039c\u0391 \u03a3\u03a4\u03a1\u0391\u03a4\u0395\u03a5\u03a3\u0397\u03a3",
            "\u0394\u0399\u0391\u03a1\u039a\u0397 \u03a3\u03a4\u03a1\u0391\u03a4\u039f\u0394\u0399\u039a\u0395\u0399\u0391",
            "\u03a3\u03a5\u039d\u03a4\u0391\u039e\u0399\u039f\u0394\u039f\u03a4\u0397\u03a3\u0397 \u03a0\u03a1\u039f\u03a3\u03a9\u03a0\u0399\u039a\u039f\u03a5 \u039f.\u0393.\u0391",
            "\u0391\u03a3\u03a4\u03a5\u039d\u039f\u039c\u0399\u0391 \u0395\u039c\u03a0\u039f\u03a1\u0399\u039a\u0397\u03a3 \u039d\u0391\u03a5\u03a4\u0399\u039b\u0399\u0391\u03a3",
            "\u03a6\u03a1\u039f\u039d\u03a4\u0399\u03a3\u03a4\u0395\u03a3 \u039c\u039f\u039d\u0391\u0394\u03a9\u039d",
            "\u0391\u03a1\u0391\u0392\u039f\u03a3\u0399\u03a4\u039f\u03a3",
            "\u039c\u0397\u03a4\u03a1\u039f\u03a0\u039f\u039b\u0395\u0399\u03a3",
            "\u03a6\u0399\u039b\u0391\u039d\u0398\u03a1\u03a9\u03a0\u0399\u039a\u0391 \u03a3\u03a9\u039c\u0391\u03a4\u0395\u0399\u0391",
            "\u0394\u0399\u0391\u03a6\u039f\u03a1\u039f\u0399 \u03a0\u039f\u039b\u03a5\u0395\u0398\u039d\u0395\u0399\u03a3 \u03a3\u03a5\u039c\u0392\u0391\u03a3\u0395\u0399\u03a3",
            "\u0395\u039e\u03a5\u0393\u0399\u0391\u039d\u03a4\u0399\u039a\u0391 \u0395\u03a1\u0393\u0391",
            "\u03a6\u03a5\u039b\u039b\u0391 \u03a0\u039f\u0399\u039f\u03a4\u0397\u03a4\u0391\u03a3 \u039d\u0391\u03a5\u03a4\u03a9\u039d",
            "\u03a6\u0399\u039b\u0391\u039d\u0398\u03a1\u03a9\u03a0\u0399\u039a\u0391 \u0399\u0394\u03a1\u03a5\u039c\u0391\u03a4\u0391 \u039a\u0391\u0399 \u03a3\u03a9\u039c\u0391\u03a4\u0395\u0399\u0391",
            "\u0395\u03a3\u03a4\u0399\u0391 \u039d\u0391\u03a5\u03a4\u0399\u039a\u03a9\u039d",
            "\u0393\u039b\u03a5\u039a\u0391 \u039a\u0391\u0399 \u039a\u039f\u039d\u03a3\u0395\u03a1\u0392\u0395\u03a3",
            "\u03a0\u03a1\u039f\u03a3\u03a4\u0391\u03a3\u0399\u0391 \u03a5\u03a0\u039f\u0392\u03a1\u03a5\u03a7\u0399\u03a9\u039d \u039a\u0391\u039b\u03a9\u0394\u0399\u03a9\u039d",
            "\u0395\u03a0\u0395\u039e\u0395\u03a1\u0393\u0391\u03a3\u0399\u0391 \u039a\u0391\u0399 \u0395\u039c\u03a0\u039f\u03a1\u0399\u0391 \u03a3\u03a5\u039a\u03a9\u039d",
            "\u03a7\u0391\u03a1\u039f\u039a\u039f\u03a0\u0395\u0399\u039f",
            "\u0394\u0399\u0391\u039c\u0395\u03a4\u0391\u039a\u039f\u039c\u0399\u03a3\u0397 \u03a3\u03a4\u0397\u039d \u0391\u039b\u0392\u0391\u039d\u0399\u0391",
            "\u0395\u03a0\u0399\u0398\u0395\u03a9\u03a1\u0397\u03a3\u0397 \u03a6\u03a5\u039b\u0391\u039a\u03a9\u039d",
            "\u0394\u0399\u0395\u0398\u039d\u0395\u0399\u03a3 \u03a3\u03a5\u039c\u0392\u0391\u03a3\u0395\u0399\u03a3 \u03a0\u0395\u03a1\u0399 \u039a\u03a5\u03a1\u0399\u0391\u039a\u0397\u03a3 \u0391\u03a1\u0393\u0399\u0391\u03a3",
            "\u039a\u0399\u039d\u0397\u039c\u0391\u03a4\u039f\u0393\u03a1\u0391\u03a6\u0399\u039a\u0397 \u0392\u0399\u039f\u039c\u0397\u03a7\u0391\u039d\u0399\u0391",
            "\u03a0\u0399\u03a3\u03a4\u039f\u03a0\u039f\u0399\u0397\u03a4\u0399\u039a\u0391 \u03a0\u03a1\u039f\u0395\u039b\u0395\u03a5\u03a3\u0395\u03a9\u03a3",
            "\u03a4\u039f\u03a5\u03a1\u0399\u03a3\u03a4\u0399\u039a\u0397 \u03a0\u03a1\u039f\u03a0\u0391\u0393\u0391\u039d\u0394\u0391",
            "\u0395\u0399\u03a3\u03a6\u039f\u03a1\u0391 \u0395\u0399\u03a3\u0391\u0393\u03a9\u0393\u0395\u03a9\u039d",
            "\u039a\u0391\u0396\u0399\u039d\u039f",
            "\u039c\u0395 \u03a4\u0397\u039d \u0395\u039b\u0392\u0395\u03a4\u0399\u0391",
            "\u0394\u0399\u039a\u0391\u03a3\u03a4\u0399\u039a\u039f\u0399 \u0395\u03a0\u0399\u039c\u0395\u039b\u0397\u03a4\u0395\u03a3",
            "\u039a\u03a9\u0394\u0399\u039a\u0391\u03a3 \u03a0\u039f\u0399\u039d\u0399\u039a\u0397\u03a3 \u0394\u0399\u039a\u039f\u039d\u039f\u039c\u0399\u0391\u03a3",
            "\u03a4\u039f\u03a0\u0399\u039a\u0395\u03a3 \u0394\u0399\u039f\u0399\u039a\u0397\u03a4\u0399\u039a\u0395\u03a3 \u0395\u03a0\u0399\u03a4\u03a1\u039f\u03a0\u0395\u03a3",
            "\u0395\u03a4\u0391\u0399\u03a1\u0395\u0399\u0395\u03a3 \u039a\u0395\u03a6\u0391\u039b\u0391\u0399\u039f\u03a0\u039f\u0399\u0397\u03a3\u0395\u03a9\u03a3",
            "\u039f\u03a1\u03a5\u0396\u0391",
            "\u0394\u0399\u039f\u0399\u039a\u0397\u03a4\u0399\u039a\u039f \u03a3\u03a5\u039c\u0392\u039f\u03a5\u039b\u0399\u039f \u039f.\u0393.\u0391",
            "\u0395\u039a\u03a0\u0391\u0399\u0394\u0395\u03a5\u03a4\u0399\u039a\u039f \u03a0\u03a1\u039f\u03a3\u03a9\u03a0\u0399\u039a\u039f \u03a3\u03a7\u039f\u039b\u03a9\u039d \u03a0.\u039d",
            "\u0392\u0391\u03a3\u0399\u039b\u0395\u0399\u0391 \u039a\u0391\u0399 \u0391\u039d\u03a4\u0399\u0392\u0391\u03a3\u0399\u039b\u0395\u0399\u0391",
            "\u03a5\u03a0\u0397\u03a1\u0395\u03a3\u0399\u0391 \u03a3\u03a4\u0399\u03a3 \u0395\u03a0\u0391\u03a1\u03a7\u0399\u0395\u03a3 \u03a4.\u03a0. \u039a\u0391\u0399 \u0394",
            "\u0393\u0395\u03a9\u03a1\u0393\u0399\u039a\u0395\u03a3 \u0392\u0399\u039f\u039c\u0397\u03a7\u0391\u039d\u0399\u0395\u03a3",
            "\u0392\u039f\u03a5\u039b\u0395\u03a5\u03a4\u0397\u03a1\u0399\u039f",
            "\u03a0\u039f\u03a1\u0398\u039c\u0395\u0399\u0391",
            "\u0395\u039a\u03a4\u0395\u039b\u0395\u03a3\u0397 \u03a5\u0394\u03a1\u0391\u03a5\u039b\u0399\u039a\u03a9\u039d \u0395\u03a1\u0393\u03a9\u039d",
            "\u0399\u039d\u03a3\u03a4\u0399\u03a4\u039f\u03a5\u03a4\u0391 \u039a\u03a1\u0397\u03a4\u0399\u039a\u039f\u03a5 \u0394\u0399\u039a\u0391\u0399\u039f\u03a5 - \u0391\u0399\u0393\u0391\u0399\u039f\u03a5 \u039a\u0391\u0399 \u0394\u0399\u0391\u03a6\u039f\u03a1\u0391 \u0395\u03a1\u0395\u03a5\u039d\u0397\u03a4\u0399\u039a\u0391 \u039a\u0395\u039d\u03a4\u03a1\u0391",
            "\u0391\u03a4\u0395\u039b\u0395\u0399\u0395\u03a3 \u0394\u0399\u0391\u03a6\u039f\u03a1\u0395\u03a3",
            "\u039a\u0395\u039d\u03a4\u03a1\u0391 \u03a0\u0391\u03a1\u0391\u0398\u0395\u03a1\u0399\u03a3\u039c\u039f\u03a5 -",
            "\u03a3\u03a7\u039f\u039b\u0395\u03a3 \u0391\u0395\u03a1\u039f\u03a0\u039f\u03a1\u0399\u0391\u03a3",
            "\u039b\u0395\u03a0\u03a1\u0391",
            "\u0391\u0399\u03a3\u0398\u0397\u03a4\u0399\u039a\u039f\u0399",
            "\u0395\u039a\u039a\u0391\u0398\u0391\u03a1\u0399\u03a3\u0397 \u03a0\u039f\u0399\u039d\u0399\u039a\u03a9\u039d \u0395\u039e\u039f\u0394\u03a9\u039d",
            "\u0393\u0395\u039d. \u039f\u0399\u039a\u039f\u0394\u039f\u039c\u0399\u039a\u039f\u03a3 \u039a\u0391\u039d\u039f\u039d\u0399\u03a3\u039c\u039f\u03a3",
            "\u0395\u039b\u0395\u0393\u03a7\u039f\u03a3 \u0394\u0391\u03a0\u0391\u039d\u03a9\u039d \u03a4\u039f\u03a5 \u039a\u03a1\u0391\u03a4\u039f\u03a5\u03a3",
            "\u03a0\u0395\u03a4\u03a1\u0395\u039b\u0391\u0399\u039f\u039a\u0399\u039d\u0397\u03a4\u0391 \u039a\u0391\u0399 \u0399\u03a3\u03a4\u0399\u039f\u03a6\u039f\u03a1\u0391",
            "\u039a\u0391\u039b\u039b\u0399\u0395\u03a1\u0393\u0395\u0399\u0391 \u039a\u0391\u03a0\u039d\u039f\u03a5",
            "\u0394\u0399\u039f\u0399\u039a\u0397\u03a3\u0397  \u039c\u039f\u039d\u0391\u03a3\u03a4\u0397\u03a1\u0399\u03a9\u039d",
            "\u039a\u03a4\u0397\u039d\u0399\u0391\u03a4\u03a1\u0399\u039a\u0391 \u0399\u0394\u0399\u039f\u03a3\u039a\u0395\u03a5\u0391\u03a3\u039c\u0391\u03a4\u0391",
            "\u039c\u039f\u039d\u0399\u039c\u039f\u0399 \u039a\u0391\u0399 \u0395\u0398\u0395\u039b\u039f\u039d\u03a4\u0395\u03a3",
            "\u03a6\u039f\u03a1\u039f\u039b\u039f\u0393\u0399\u0391 \u039a\u0395\u03a1\u0394\u03a9\u039d \u0395\u0399\u03a3\u0391\u0393\u03a9\u0393\u0395\u03a9\u039d",
            "\u0391\u0393\u03a9\u0393\u0395\u03a3 \u0395\u039e\u03a9\u03a3\u0395\u03a9\u03a3 \u039c\u0399\u03a3\u0398\u03a9\u03a4\u03a9\u039d",
            "\u039f\u03a1\u0393\u0391\u039d\u03a9\u03a3\u0397 \u0395\u039e\u03a9\u03a4\u0395\u03a1\u0399\u039a\u039f\u03a5 \u0395\u039c\u03a0\u039f\u03a1\u0399\u039f\u03a5",
            "\u0391\u0393\u03a9\u0393\u0395\u03a3 \u039c\u0397\u03a7\u0391\u039d\u0399\u039a\u03a9\u039d",
            "\u039d\u0391\u03a5\u03a4\u0399\u039a\u0397 \u03a3\u03a7\u039f\u039b\u0397 \u03a0\u039f\u039b\u0395\u039c\u039f\u03a5",
            "\u039c\u0395\u03a4\u0391\u03a6\u039f\u03a1\u0391 \u0398\u0395\u03a3\u0395\u03a9\u039d",
            "\u0395\u0399\u03a3\u0391\u0393\u03a9\u0393\u0397 \u0395\u03a0\u0391\u0393\u0393\u0395\u039b\u039c\u0391\u03a4\u0399\u039a\u039f\u03a5 \u03a5\u039b\u0399\u039a\u039f\u03a5",
            "\u03a3\u03a5\u0393\u039a\u03a1\u039f\u03a4\u0397\u03a3\u0397 \u039a\u0391\u0399 \u039b\u0395\u0399\u03a4\u039f\u03a5\u03a1\u0393\u0399\u0391",
            "\u03a4\u0391\u039c\u0395\u0399\u039f \u0395\u03a0\u0399\u039a\u039f\u03a5\u03a1\u0399\u039a\u0397\u03a3 \u0391\u03a3\u03a6\u0391\u039b\u0399\u03a3\u0395\u03a9\u03a3 \u03a0\u03a1\u039f\u03a3\u03a9\u03a0\u0399\u039a\u039f\u03a5 \u0391\u0395\u03a1\u039f\u03a0\u039f\u03a1\u0399\u039a\u03a9\u039d \u0395\u03a0\u0399\u03a7\u0395\u0399\u03a1\u0397\u03a3\u0395\u03a9\u039d (T.\u0395.\u0391.\u03a0.\u0391.\u0395.)",
            "\u03a3\u03a5\u039b\u039b\u039f\u0393\u0397 \u039a\u0391\u0399 \u0394\u0399\u0391\u039a\u0399\u039d\u0397\u03a3\u0397 \u03a0\u0395\u03a4\u03a1\u0395\u039b\u0391\u0399\u039f\u0395\u0399\u0394\u03a9\u039d \u0395\u03a1\u039c\u0391\u03a4\u03a9\u039d",
            "\u039a\u0395\u039d\u03a4\u03a1\u0391 \u0391\u0394\u03a5\u039d\u0391\u03a4\u0399\u03a3\u039c\u0391\u03a4\u039f\u03a3 \u2013 \u0394\u0399\u0391\u0399\u03a4\u039f\u039b\u039f\u0393\u0399\u0391\u03a3",
            "\u039f\u039c\u0391\u0394\u0399\u039a\u0397 \u039a\u0391\u03a4\u0391\u0393\u0393\u0395\u039b\u0399\u0391 \u03a3\u03a5\u039c\u0392\u0391\u03a3\u0395\u03a9\u03a3 \u0395\u03a1\u0393\u0391\u03a3\u0399\u0391\u03a3",
            "\u0394\u0399\u0391\u03a6\u039f\u03a1\u0391 \u039c\u039f\u03a5\u03a3\u0395\u0399\u0391",
            "\u0392\u0395\u0392\u0391\u0399\u03a9\u03a3\u0397 \u039a\u0391\u0399 \u0395\u0399\u03a3\u03a0\u03a1\u0391\u039e\u0397 \u0395\u03a3\u039f\u0394\u03a9\u039d",
            "\u0393\u03a1\u0391\u03a6\u0395\u0399\u0391 \u03a4\u03a5\u03a0\u039f\u03a5",
            "\u0394\u0399\u039f\u0399\u039a\u0397\u03a4\u0399\u039a\u039f \u03a0\u03a1\u039f\u03a3\u03a9\u03a0\u0399\u039a\u039f",
            "\u03a3\u03a5\u039d\u0395\u03a1\u0393\u0395\u0399\u0391 \u0395\u03a0\u0399\u03a3\u039a\u0395\u03a5\u03a9\u039d",
            "\u03a4\u0391\u039c\u0395\u0399\u039f \u0395\u03a0\u0399\u039a\u039f\u03a5\u03a1\u0399\u039a\u0397\u03a3 \u0391\u03a3\u03a6\u0391\u039b\u0399\u03a3\u0397\u03a3 \u03a0\u03a1\u039f\u039d\u039f\u0399\u0391\u03a3 \u039a\u0391\u0399 \u0391\u03a3\u0398\u0395\u039d\u0395\u0399\u0391\u03a3 \u0395\u03a1\u0393\u0391\u0396\u039f\u039c\u0395\u039d\u03a9\u039d \u03a3\u03a4\u0391 \u039b\u0399\u039c\u0391\u039d\u0399\u0391 (\u03a4.\u0395.\u0391.\u03a0.\u0391.\u0395.\u039b.)",
            "\u0391\u03a3\u03a6\u0391\u039b\u0399\u03a3\u0397 \u039a\u0391\u03a0\u039d\u0395\u03a1\u0393\u0391\u03a4\u03a9\u039d",
            "\u0391\u039d\u03a4\u0399\u03a3\u0397\u039a\u03a9\u039c\u0391\u03a4\u0391 (\u0395\u039e\u0391\u0393\u039f\u03a1\u0391 \u0398\u0397\u03a4\u0395\u0399\u0391\u03a3)",
            "\u03a1\u03a5\u039c\u039f\u03a5\u039b\u039a\u039f\u03a5\u039c\u0395\u039d\u0391 \u039f\u03a7\u0397\u039c\u0391\u03a4\u0391",
            "\u039d\u039f\u039c\u039f\u0399 \u0391\u039d\u0391\u03a6\u0395\u03a1\u039f\u039c\u0395\u039d\u039f\u0399 \u03a3\u0395 \u03a0\u039f\u039b\u039b\u0395\u03a3 \u03a6\u039f\u03a1\u039f\u039b\u039f\u0393\u0399\u0395\u03a3",
            "\u039f\u0399\u039a\u039f\u03a3\u03a5\u03a3\u03a4\u0397\u039c\u0391\u03a4\u0391\u2013\u0392\u0399\u039f\u03a4\u039f\u03a0\u039f\u0399",
            "\u03a0\u03a1\u039f\u03a3\u03a4\u0391\u03a3\u0399\u0391 \u03a0\u03a1\u039f\u03a3\u03a9\u03a0\u03a9\u039d",
            "\u0395\u0398\u039d\u0399\u039a\u039f \u03a4\u03a5\u03a0\u039f\u0393\u03a1\u0391\u03a6\u0395\u0399\u039f",
            "\u0394\u0399\u039a\u0391\u03a3\u03a4\u0399\u039a\u0391 \u039a\u0391\u03a4\u0391\u03a3\u03a4\u0397\u039c\u0391\u03a4\u0391",
            "\u03a0\u03a1\u039f\u03a3\u03a4\u0391\u03a3\u0399\u0391 \u0392\u0399\u0392\u039b\u0399\u039f\u03a5-\u0395\u0398\u039d\u0399\u039a\u039f \u039a\u0395\u039d\u03a4\u03a1\u039f \u0392\u0399\u0392\u039b\u0399\u039f\u03a5-\u039b\u039f\u0393\u039f\u03a4\u0395\u03a7\u039d\u0399\u0391",
            "\u0394\u0391\u03a3\u039c\u039f\u0399 \u0391\u039d\u03a4\u0399\u039d\u03a4\u0391\u039c\u03a0\u0399\u0393\u039a",
            "\u0394\u0391\u03a3\u0397 \u03a0\u0391\u03a1\u0391\u039c\u0395\u0398\u039f\u03a1\u0399\u03a9\u039d \u03a0\u0395\u03a1\u0399\u039f\u03a7\u03a9\u039d",
            "\u0398\u0395\u039f\u039b\u039f\u0393\u0399\u039a\u0397 \u03a3\u03a7\u039f\u039b\u0397",
            "\u039f\u03a1\u039f\u0399 - \u03a0\u03a1\u039f\u0394\u0399\u0391\u0393\u03a1\u0391\u03a6\u0395\u03a3 \u03a4\u03a5\u03a0\u039f\u03a0\u039f\u0399\u0397\u03a3\u0397\u03a3",
            "\u03a6\u039f\u03a1\u039f\u039b\u039f\u0393\u0399\u0391 \u0392\u03a5\u039d\u0397\u03a3 \u039a\u0391\u0399 \u0396\u03a5\u0398\u039f\u03a5",
            "\u0391\u03a0\u039f\u0398\u0397\u039a\u0397 \u039a\u03a4\u0397\u039d\u0399\u0391\u03a4\u03a1\u0399\u039a\u03a9\u039d \u0395\u03a6\u039f\u0394\u0399\u03a9\u039d",
            "\u03a0\u0391\u03a1\u039f\u03a7\u0397 \u03a4\u0397\u039b\u0395\u03a6\u03a9\u039d\u0399\u039a\u03a9\u039d \u03a3\u03a5\u039d\u0394\u0395\u03a3\u0395\u03a9\u039d",
            "\u03a0\u0391\u03a1\u0391\u03a7\u03a9\u03a1\u0397\u03a3\u0397 \u0399\u0391\u039c\u0391\u03a4\u0399\u039a\u03a9\u039d \u03a0\u0397\u0393\u03a9\u039d",
            "\u039c\u0391\u0398\u0397\u03a4\u0399\u039a\u0391 \u03a3\u03a5\u03a3\u03a3\u0399\u03a4\u0399\u0391",
            "\u03a0\u03a1\u039f\u03a3\u039b\u0397\u03a8\u0397 \u0395\u03a6\u0395\u0394\u03a1\u03a9\u039d, \u0391\u039d\u0391\u03a0\u0397\u03a1\u03a9\u039d \u03a0\u039f\u039b\u0395\u039c\u039f\u03a5, \u03a0\u039f\u039b\u03a5\u03a4\u0395\u039a\u039d\u03a9\u039d \u039a\u0391\u0399 \u0391\u039b\u039b\u03a9\u039d \u0391\u03a4\u039f\u039c\u03a9\u039d \u039c\u0395 \u0395\u0399\u0394\u0399\u039a\u0395\u03a3 \u0391\u039d\u0391\u0393\u039a\u0395\u03a3",
            "\u0395\u03a1\u03a4 \u2013 3",
            "\u03a3\u03a7\u039f\u039b\u0397 \u03a0\u039f\u039b\u0395\u039c\u039f\u03a5 \u0391\u0395\u03a1\u039f\u03a0\u039f\u03a1\u0399\u0391\u03a3",
            "\u03a4\u039f\u03a0\u039f\u0398\u0395\u03a4\u0397\u03a3\u0395\u0399\u03a3 - \u039c\u0395\u03a4\u0391\u03a4\u0391\u039e\u0395\u0399\u03a3",
            "\u0394\u0399\u0395\u0398\u039d\u0395\u0399\u03a3 \u03a3\u03a5\u039c\u0392\u0391\u03a3\u0395\u0399\u03a3 \u03a0\u03a1\u039f\u03a3\u03a4\u0391\u03a3\u0399\u0391\u03a3",
            "\u03a6\u03a5\u03a3\u0399\u039a\u039f \u0391\u0395\u03a1\u0399\u039f",
            "\u03a4\u0395\u03a7\u039d\u0399\u039a\u0391 \u0395\u03a1\u0393\u0391",
            "\u0394\u0399\u03a0\u039b\u03a9\u039c\u0391\u03a4\u039f\u03a5\u03a7\u039f\u0399 \u0391\u039d\u03a9\u03a4\u0391\u03a4\u03a9\u039d",
            "\u0395\u0398\u039d\u0399\u039a\u039f \u039d\u039f\u039c\u0399\u03a3\u039c\u0391\u03a4\u0399\u039a\u039f \u039c\u039f\u03a5\u03a3\u0395\u0399\u039f",
            "\u039f\u0399\u039a\u039f\u039d\u039f\u039c\u0399\u039a\u0397 \u0391\u03a3\u03a4\u03a5\u039d\u039f\u039c\u0399\u0391 \u03a3\u03a4\u0397 \u0398\u0391\u039b\u0391\u03a3\u03a3\u0391",
            "\u0391\u03a3\u03a6\u0391\u039b\u0395\u0399\u0391, \u039b\u0395\u0399\u03a4\u039f\u03a5\u03a1\u0393\u0399\u0391 \u039a\u0391\u0399 \u0395\u039a\u039c\u0395\u03a4\u0391\u039b\u039b\u0395\u03a5\u03a3\u0397",
            "\u0395\u0399\u0394\u0399\u039a\u0391 \u03a0\u03a1\u039f\u039d\u039f\u039c\u0399\u0391 \u0391\u039d\u03a9\u039d\u03a5\u039c\u03a9\u039d \u0395\u03a4\u0391\u0399\u03a1\u0395\u0399\u03a9\u039d",
            "\u0393\u03a1\u0391\u039c\u039c\u0391\u03a4\u0395\u0399\u0391 \u03a4\u03a9\u039d \u0394\u0399\u039a\u0391\u03a3\u03a4\u0397\u03a1\u0399\u03a9\u039d \u039a\u0391\u0399 \u0395\u0399\u03a3\u0391\u0393\u0393\u0395\u039b\u0399\u03a9\u039d",
            "\u0391\u039b\u0399\u03a0\u0391\u03a3\u03a4\u0391",
            "\u0395\u03a0\u0399\u0394\u039f\u03a3\u0397 \u0394\u0399\u039a\u039f\u0393\u03a1\u0391\u03a6\u03a9\u039d",
            "\u039a\u0395\u039d\u03a4\u03a1\u0399\u039a\u039f \u03a4\u0391\u039c\u0395\u0399\u039f \u0393\u0395\u03a9\u03a1\u0393\u0399\u0391\u03a3",
            "\u03a3\u03a4\u03a1\u0391\u03a4\u0399\u03a9\u03a4\u0399\u039a\u0391 \u03a3\u03a5\u039c\u0392\u039f\u03a5\u039b\u0399\u0391",
            "\u03a4\u0391\u039c\u0395\u0399\u0391\u039a\u0397 \u03a5\u03a0\u0397\u03a1\u0395\u03a3\u0399\u0391 \u03a4\u0395\u039b\u03a9\u039d\u0395\u0399\u03a9\u039d",
            "\u039d\u039f\u03a3\u0397\u039b\u0395\u03a5\u03a4\u0399\u039a\u039f \u0399\u0394\u03a1\u03a5\u039c\u0391 \u039c.\u03a4.\u03a3",
            "\u0394\u0399\u039a\u0391\u0399\u039f \u0398\u0391\u039b\u0391\u03a3\u03a3\u0391\u03a3-\u03a5\u03a6\u0391\u039b\u039f\u039a\u03a1\u0397\u03a0\u0399\u0394\u0391",
            "\u0395\u0399\u0394\u0399\u039a\u039f\u03a3 \u03a6\u039f\u03a1\u039f\u03a3 \u039a\u0391\u03a4\u0391\u039d\u0391\u039b\u03a9\u03a3\u0397\u03a3",
            "\u039c\u0395\u0399\u039f\u039d\u039f\u03a4\u0399\u039a\u0391 \u03a3\u03a7\u039f\u039b\u0395\u0399\u0391",
            "\u0393\u03a1\u0391\u03a6\u0395\u0399\u0391 \u0395\u039c\u03a0\u039f\u03a1\u0399\u039a\u03a9\u039d \u03a0\u039b\u0397\u03a1\u039f\u03a6\u039f\u03a1\u0399\u03a9\u039d",
            "\u03a3\u03a5\u039d\u03a4\u039f\u039d\u0399\u03a3\u03a4\u0399\u039a\u039f\u039d \u03a3\u03a5\u039c\u0392\u039f\u03a5\u039b\u0399\u039f\u039d \u039d\u0395\u03a9\u039d \u03a0\u03a1\u039f\u03a3\u03a6\u03a5\u0393\u03a9\u039d",
            "\u03a0\u0395\u03a1\u0399\u0398\u0391\u039b\u03a8\u0397 \u0391\u03a0\u039f\u03a1\u03a9\u039d \u039a\u0391\u0399 \u0391\u039d\u0391\u03a3\u03a6\u0391\u039b\u0399\u03a3\u03a4\u03a9\u039d",
            "\u03a6\u039f\u03a1\u039f\u039b\u039f\u0393\u0399\u0391 \u039a\u0395\u039d\u03a4\u03a1\u03a9\u039d \u0394\u0399\u0391\u03a3\u039a\u0395\u0394\u0391\u03a3\u0395\u03a9\u03a3 \u039a\u0391\u0399 \u03a0\u039f\u039b\u03a5\u03a4\u0395\u039b\u0395\u0399\u0391\u03a3",
            "\u03a3\u03a0\u039f\u0393\u0393\u0391\u039b\u0399\u0395\u03a5\u03a4\u0399\u039a\u0391 \u2013 \u0394\u03a5\u03a4\u0395\u03a3",
            "\u0394\u0399\u0395\u0398\u039d\u0395\u03a3 \u039d\u039f\u039c\u0399\u03a3\u039c\u0391\u03a4\u0399\u039a\u039f \u03a4\u0391\u039c\u0395\u0399\u039f",
            "\u0392\u0399\u0392\u039b\u0399\u039f \u0394\u0399\u0395\u039a\u0394\u0399\u039a\u0397\u03a3\u0395\u03a9\u039d",
            "\u0395\u0393\u039a\u0391\u03a4\u0391\u03a3\u03a4\u0391\u03a3\u0397 - \u039b\u0395\u0399\u03a4\u039f\u03a5\u03a1\u0393\u0399\u0391 \u039a\u0391\u03a4\u0391\u03a3\u039a\u0395\u03a5\u03a9\u039d \u039a\u0395\u03a1\u0391\u0399\u03a9\u039d",
            "\u0395\u039d\u03a9\u03a3\u0397 \u0394\u0397\u039c\u03a9\u039d \u039a\u0391\u0399 \u039a\u039f\u0399\u039d\u039f\u03a4\u0397\u03a4\u03a9\u039d",
            "\u039b\u039f\u0393\u0399\u03a3\u03a4\u0399\u039a\u039f\u03a3 \u039a\u0391\u0399 \u039f\u0399\u039a\u039f\u039d\u039f\u039c\u0399\u039a\u039f\u03a3 \u039a\u0391\u039d\u039f\u039d\u0399\u03a3\u039c\u039f\u03a3",
            "\u039a\u0391\u03a4\u03a9\u03a4\u0395\u03a1\u0391 \u039f\u03a1\u0393\u0391\u039d\u0391 \u03a3\u03a9\u039c\u0391\u03a4\u03a9\u039d \u0391\u03a3\u03a6\u0391\u039b\u0395\u0399\u0391\u03a3",
            "\u03a5\u03a0\u039f\u03a5\u03a1\u0393\u0395\u0399\u039f \u0395\u039c\u03a0\u039f\u03a1\u0399\u039a\u0397\u03a3 \u039d\u0391\u03a5\u03a4\u0399\u039b\u0399\u0391\u03a3",
            "\u039f\u03a1\u0393\u0391\u039d\u0399\u03a3\u039c\u039f\u03a3 \u0395\u039b\u0395\u0393\u039a\u03a4\u0399\u039a\u039f\u03a5 \u03a3\u03a5\u039d\u0395\u0394\u03a1\u0399\u039f\u03a5",
            "\u0391\u0393\u039f\u03a1\u0395\u03a3 \u0391\u0393\u03a1\u039f\u03a4\u0399\u039a\u03a9\u039d \u03a0\u03a1\u039f\u0399\u039f\u039d\u03a4\u03a9\u039d",
            "\u03a4\u0391\u039c\u0395\u0399\u039f \u0395\u03a0\u0399\u039a\u039f\u03a5\u03a1\u0399\u039a\u0397\u03a3 \u0391\u03a3\u03a6\u0391\u039b\u0399\u03a3\u0395\u03a9\u03a3 \u039c\u0399\u03a3\u0398\u03a9\u03a4\u03a9\u039d \u039a\u039b\u03a9\u03a3\u03a4\u039f\u03a5\u03a6\u0391\u039d\u03a4\u039f\u03a5\u03a1\u0393\u0399\u0391\u03a3",
            "\u039e\u0395\u039d\u0391\u0393\u039f\u0399 \u039a\u0391\u0399 \u0394\u0399\u0395\u03a1\u039c\u0397\u039d\u0395\u0399\u03a3",
            "\u03a0\u039f\u039b\u0395\u039c\u0399\u039a\u0395\u03a3 \u03a3\u03a5\u039d\u03a4\u0391\u039e\u0395\u0399\u03a3",
            "\u0391\u03a3\u03a4\u0399\u039a\u0395\u03a3 \u03a3\u03a5\u0393\u039a\u039f\u0399\u039d\u03a9\u039d\u0399\u0395\u03a3 \u0391\u0398\u0397\u039d\u03a9\u039d-\u03a0\u0395\u0399\u03a1\u0391\u0399\u03a9\u03a3 \u039a\u0391\u0399 \u03a0\u0395\u03a1\u0399\u03a7\u03a9\u03a1\u03a9\u039d-\u039f.\u0391.\u03a3.\u0391",
            "\u039a\u0391\u03a4\u0391\u03a3\u03a4\u0391\u03a4\u0399\u039a\u0395\u03a3 \u0394\u0399\u0391\u03a4\u0391\u039e\u0395\u0399\u03a3 \u03a4\u0391\u039c\u0395\u0399\u039f\u03a5 \u0391\u03a3\u03a6\u0391\u039b\u0399\u03a3\u0395\u03a9\u03a3 \u0391\u03a1\u03a4\u0395\u03a1\u0393\u0391\u03a4\u03a9\u039d \u039a.\u039b.\u03a0",
            "\u0391\u03a4\u03a5\u03a7\u0397\u039c\u0391\u03a4\u0391 \u03a3\u0395 \u039c\u0395\u03a4\u0391\u039b\u039b\u0395\u0399\u0391 \u039a\u039b\u03a0",
            "\u03a6\u039f\u03a1\u039f\u039b\u039f\u0393\u0399\u0391 \u03a0\u039f\u039b\u0395\u039c\u0399\u039a\u03a9\u039d \u039a\u0395\u03a1\u0394\u03a9\u039d",
            "\u03a3\u03a7\u0395\u0394\u0399\u039f \u03a0\u039f\u039b\u0395\u03a9\u03a3 \u0398\u0395\u03a3\u03a3\u0391\u039b\u039f\u039d\u0399\u039a\u0397\u03a3",
            "\u039f\u0399\u039a\u039f\u039d\u039f\u039c\u0399\u039a\u0397 \u0394\u0399\u039f\u0399\u039a\u0397\u03a3\u0397 \u0391\u0393\u03a1\u039f\u03a4. \u0391\u03a3\u03a6\u0391\u039b\u0395\u0399\u0391\u03a3",
            "\u039a\u03a1\u0391\u03a4\u0399\u039a\u039f \u03a9\u0394\u0395\u0399\u039f \u0398\u0395\u03a3\u03a3\u0391\u039b\u039f\u039d\u0399\u039a\u0397\u03a3",
            "\u039a\u0395\u039d\u03a4\u03a1\u0391 \u0391\u039d\u03a9\u03a4\u0395\u03a1\u0397\u03a3 \u03a4\u0395\u03a7\u039d\u0399\u039a\u0397\u03a3 \u0395\u039a\u03a0\u0391\u0399\u0394\u0395\u03a5\u03a3\u0397\u03a3 (\u039a.A.\u03a4.\u0395.)",
            "\u03a4\u0397\u039b\u0395\u03a6\u03a9\u039d\u0399\u039a\u0397 \u0391\u039d\u03a4\u0391\u03a0\u039f\u039a\u03a1\u0399\u03a3\u0397",
            "\u039f\u0399\u039a\u039f\u039d\u039f\u039c\u0399\u039a\u0391 \u0393\u03a5\u039c\u039d\u0391\u03a3\u0399\u0391",
            "\u0392\u0399\u0392\u039b\u0399\u0391 \u039a\u0391\u0399 \u0395\u03a5\u03a1\u0395\u03a4\u0397\u03a1\u0399\u0391 \u03a3\u03a5\u039d\u0395\u03a4\u0391\u0399\u03a1\u0399\u03a3\u039c\u03a9\u039d",
            "\u0395\u03a0\u0399\u0394\u039f\u039c\u0391 \u0391\u039d\u0395\u03a1\u0393\u0399\u0391\u03a3",
            "\u0395\u0393\u0393\u03a1\u0391\u03a6\u0395\u03a3, \u0395\u039e\u0395\u03a4\u0391\u03a3\u0395\u0399\u03a3, \u03a0\u03a1\u039f\u0393\u03a1\u0391\u039c\u039c\u0391\u03a4\u0391 \u039a\u039b\u03a0",
            "\u03a3\u03a7\u039f\u039b\u0397 \u039c\u039f\u039d\u0399\u039c\u03a9\u039d \u03a5\u03a0\u0391\u039e\u0399\u03a9\u039c\u0391\u03a4\u0399\u039a\u03a9\u039d",
            "\u0395\u039a\u039a\u039b\u0397\u03a3\u0399\u0391 \u0391\u039c\u0395\u03a1\u0399\u039a\u0397\u03a3",
            "\u039c\u0395\u03a4\u039f\u03a7\u0399\u039a\u039f \u03a4\u0391\u039c\u0395\u0399\u039f \u03a3\u03a4\u03a1\u0391\u03a4\u039f\u03a5",
            "\u039d\u039f\u03a3\u0397\u039b\u0395\u0399\u0391",
            "\u03a3\u03a7\u039f\u039b\u0397 \u0395\u03a5\u0395\u039b\u03a0\u0399\u0394\u03a9\u039d",
            "\u03a5\u03a0\u039f\u03a5\u03a1\u0393\u0395\u0399\u039f \u0395\u03a1\u0393\u0391\u03a3\u0399\u0391\u03a3 \u039a\u0391\u0399 \u039a\u039f\u0399\u039d\u03a9\u039d\u0399\u039a\u03a9\u039d \u0391\u03a3\u03a6\u0391\u039b\u0399\u03a3\u0395\u03a9\u039d",
            "\u039a\u0391\u039d\u039f\u039d\u0399\u03a3\u039c\u039f\u03a3 \u03a7\u03a1\u0397\u039c\u0391\u03a4\u0399\u03a3\u03a4\u0397\u03a1\u0399\u039f\u03a5 \u0391\u039e\u0399\u03a9\u039d \u0391\u0398\u0397\u039d\u03a9\u039d",
            "\u0391\u039d\u03a4\u0399\u03a3\u0395\u0399\u03a3\u039c\u0399\u039a\u039f\u03a3 \u039a\u0391\u039d\u039f\u039d\u0399\u03a3\u039c\u039f\u03a3",
            "\u03a6\u0391\u03a1\u039c\u0391\u039a\u0395\u03a5\u03a4\u0399\u039a\u0397 \u0394\u0395\u039f\u039d\u03a4\u039f\u039b\u039f\u0393\u0399\u0391",
            "\u03a6\u039f\u03a1\u039f\u039b\u039f\u0393\u0399\u0391 \u0395\u039b\u0391\u0399\u03a9\u0394\u03a9\u039d \u03a0\u03a1\u039f\u0399\u039f\u039d\u03a4\u03a9\u039d",
            "\u0395\u0399\u0394\u0399\u039a\u0391 \u03a1\u0391\u0394\u0399\u039f\u03a4\u0397\u039b\u0395\u03a6\u03a9\u039d\u0399\u039a\u0391 \u0394\u0399\u039a\u03a4\u03a5\u0391",
            "\u03a4\u0395\u03a7\u039d\u0399\u039a\u0395\u03a3 \u03a5\u03a0\u0397\u03a1\u0395\u03a3\u0399\u0395\u03a3",
            "\u0391\u03a1\u03a7\u0395\u0399\u0391 \u03a5\u0393\u0399\u0395\u0399\u039d\u0397\u03a3",
            "\u039f\u0394\u039f\u0399\u03a0\u039f\u03a1\u0399\u039a\u0391 \u039a\u0391\u0399 \u0391\u03a0\u039f\u0396\u0397\u039c\u0399\u03a9\u03a3\u0395\u0399\u03a3 \u0391\u03a0\u039f\u03a3\u03a4\u039f\u039b\u03a9\u039d \u0395\u039e\u03a9\u03a4\u0395\u03a1\u0399\u039a\u039f\u03a5",
            "\u0394\u0399\u0391\u03a6\u039f\u03a1\u039f\u0399 \u039b\u039f\u0393\u0399\u03a3\u03a4\u0399\u039a\u039f\u0399 \u039d\u039f\u039c\u039f\u0399",
            "\u0395\u039a\u039a\u039b\u0397\u03a3\u0399\u0391\u03a3\u03a4\u0399\u039a\u039f\u0399 \u03a5\u03a0\u0391\u039b\u039b\u0397\u039b\u039f\u0399",
            "\u039d\u0391\u03a5\u03a4\u0399\u039a\u0391 \u0395\u03a0\u0391\u0393\u0393\u0395\u039b\u039c\u0391\u03a4\u0399\u039a\u0391 \u03a3\u03a9\u039c\u0391\u03a4\u0395\u0399\u0391 \u039a\u0391\u0399 \u039f\u039c\u039f\u03a3\u03a0\u039f\u039d\u0394\u0399\u0395\u03a3",
            "\u03a4\u0395\u039b\u0397 \u03a7\u03a1\u0397\u03a3\u0397\u03a3 \u0391\u0395\u03a1\u039f\u039b\u0399\u039c\u0395\u039d\u03a9\u039d",
            "\u03a0\u03a1\u039f\u0391\u0399\u03a1\u0395\u03a4\u0399\u039a\u0397 \u0391\u03a3\u03a6\u0391\u039b\u0399\u03a3\u0397",
            "\u039c\u0395 \u03a4\u0397 \u039b\u0399\u0392\u03a5\u0397",
            "\u03a0\u039f\u03a4\u0391\u039c\u039f\u03a0\u039b\u039f\u0399\u0391 \u03a6\u039f\u03a1\u03a4\u0399\u039f\u03a5 \u03a5\u0393\u03a1\u03a9\u039d \u039a\u0391\u03a5\u03a3\u0399\u039c\u03a9\u039d",
            "\u03a4\u0391\u039c\u0395\u0399\u039f \u03a3\u03a5\u039d\u03a4\u0391\u039e\u0395\u03a9\u039d \u03a0\u03a1\u039f\u03a3\u03a9\u03a0\u0399\u039a\u039f\u03a5 \u0395\u039b\u039b\u0397\u039d\u0399\u039a\u03a9\u039d \u0397\u039b\u0395\u039a\u03a4\u03a1\u0399\u039a\u03a9\u039d \u03a3\u0399\u0394\u0397\u03a1\u039f\u0394\u03a1\u039f\u039c\u03a9\u039d \u0391\u0398\u0397\u039d\u03a9\u039d-\u03a0\u0395\u0399\u03a1\u0391\u0399\u03a9\u03a3 (\u03a4.\u03a3.\u03a0.-\u0397.\u03a3.\u0391.\u03a0)",
            "\u039c\u0395\u03a3\u0391\u0396\u039f\u039d\u03a4\u0395\u03a3",
            "\u03a3\u03a4\u03a1\u0391\u03a4\u0399\u03a9\u03a4\u0399\u039a\u039f\u03a3 \u03a0\u039f\u0399\u039d\u0399\u039a\u039f\u03a3",
            "\u0394\u0399\u039a\u0391\u0399\u03a9\u039c\u0391\u03a4\u0391 \u039a\u0391\u0399 \u039a\u0391\u0398\u0397\u039a\u039f\u039d\u03a4\u0391 \u03a6\u039f\u0399\u03a4\u0397\u03a4\u03a9\u039d",
            "\u03a0\u03a1\u039f\u0395\u0394\u03a1\u0399\u0391 \u0394\u0397\u039c\u039f\u039a\u03a1\u0391\u03a4\u0399\u0391\u03a3",
            "\u039a\u03a9\u0394\u0399\u039a\u0391\u03a3 \u0395\u039c\u03a0\u039f\u03a1\u0399\u039a\u039f\u03a5 \u039d\u039f\u039c\u039f\u03a5",
            "\u03a3\u03a5\u039d\u03a4\u0391\u039e\u0399\u039f\u0394\u039f\u03a4\u0397\u03a3\u0397 \u039f.\u0393.\u0391",
            "\u03a3\u0391\u039d\u0391\u03a4\u039f\u03a1\u0399\u0391",
            "\u0395\u039b\u0395\u0393\u03a7\u039f\u03a3 \u0395\u039c\u03a0\u039f\u03a1\u0399\u039f\u03a5 \u0395\u0399\u0394\u03a9\u039d \u03a0\u03a1\u03a9\u03a4\u0397\u03a3 \u0391\u039d\u0391\u0393\u039a\u0397\u03a3",
            "\u0392\u0391\u039b\u0391\u039d\u0399\u0394\u0399\u0391",
            "\u03a0\u039f\u039b\u03a5\u03a4\u0395\u03a7\u039d\u0399\u039a\u0397 \u03a3\u03a7\u039f\u039b\u0397 \u03a0\u0391\u039d\u0395\u03a0\u0399\u03a3\u03a4\u0397\u039c\u0399\u039f\u03a5 \u03a0\u0391\u03a4\u03a1\u03a9\u039d",
            "\u03a3\u0395\u0399\u03a3\u039c\u039f\u03a0\u039b\u0397\u039a\u03a4\u039f\u0399 \u03a0\u0395\u039b\u039f\u03a0\u039f\u039d\u039d\u0397\u03a3\u039f\u03a5",
            "\u0394\u0399\u0395\u0398\u039d\u0397\u03a3 \u039f\u03a1\u0393\u0391\u039d\u0399\u03a3\u039c\u039f\u03a3 \u03a7\u03a1\u0397\u039c\u0391\u03a4\u039f\u0394\u039f\u03a4\u0397\u03a3\u0395\u03a9\u03a3",
            "\u039c\u0395\u03a4\u0391\u03a6\u039f\u03a1\u0391 \u03a3\u03a4\u039f \u0395\u03a3\u03a9\u03a4\u0395\u03a1\u0399\u039a\u039f",
            "\u0399\u03a3\u03a4\u039f\u03a1\u0399\u039a\u039f \u0391\u03a1\u03a7\u0395\u0399\u039f \u03a5\u0394\u03a1\u0391\u03a3",
            "\u0395\u0393\u039a\u0391\u03a4\u0391\u03a3\u03a4\u0391\u03a3\u0397 \u039a\u0391\u0399 \u039a\u0399\u039d\u0397\u03a3\u0397 \u0391\u039b\u039b\u039f\u0394\u0391\u03a0\u03a9\u039d",
            "\u03a3\u03a7\u039f\u039b\u0397 \u03a4\u0395\u03a7\u039d\u0399\u039a\u0397\u03a3 \u0395\u039a\u03a0\u0391\u0399\u0394\u0395\u03a5\u03a3\u0397\u03a3 \u0391\u039e\u0399\u03a9\u039c\u0391\u03a4\u0399\u039a\u03a9\u039d",
            "\u0393\u0391\u039c\u039f\u03a3 \u03a3\u03a4\u03a1\u0391\u03a4\u0399\u03a9\u03a4\u0399\u039a\u03a9\u039d",
            "\u0391\u03a0\u0391\u0393\u039f\u03a1\u0395\u03a5\u03a3\u0397 \u0395\u039e\u039f\u0394\u039f\u03a5 \u039f\u03a6\u0395\u0399\u039b\u0395\u03a4\u03a9\u039d",
            "\u03a0\u03a1\u03a9\u03a4\u0395\u03a3 \u03a5\u039b\u0395\u03a3 \u03a8\u0395\u039a\u0391\u03a3\u03a4\u0397\u03a1\u03a9\u039d",
            "\u03a6\u0399\u039b\u0395\u039a\u03a0\u0391\u0399\u0394\u0395\u03a5\u03a4\u0399\u039a\u0397 \u0395\u03a4\u0391\u0399\u03a1\u0395\u0399\u0391",
            "\u0391\u0394\u0395\u0399\u0395\u03a3 \u039f\u0394\u0397\u0393\u03a9\u039d \u0391\u03a5\u03a4\u039f\u039a\u0399\u039d\u0397\u03a4\u03a9\u039d",
            "\u0395\u0398\u039d\u0399\u039a\u0397 \u03a0\u0399\u039d\u0391\u039a\u039f\u0398\u0397\u039a\u0397 \u039a\u0391\u0399 \u039c\u039f\u03a5\u03a3\u0395\u0399\u039f \u0391\u039b. \u03a3\u039f\u03a5\u03a4\u03a3\u039f\u03a5",
            "\u03a4\u0391\u03a7\u03a5\u0394\u03a1\u039f\u039c\u0399\u039a\u0391 \u0394\u0395\u039c\u0391\u03a4\u0391",
            "\u0395\u0399\u03a3\u03a0\u03a1\u0391\u039e\u0397 \u03a0\u039f\u03a1\u03a9\u039d",
            "\u039f\u03a1\u0393\u0391\u039d\u03a9\u03a3\u0397 \u039a\u0391\u0399 \u039b\u0395\u0399\u03a4\u039f\u03a5\u03a1\u0393\u0399\u0391 \u03a4\u0395\u03a7\u039d\u0399\u039a\u03a9\u039d \u03a3\u03a7\u039f\u039b\u03a9\u039d",
            "\u0394\u0399\u0391\u0398\u0395\u03a3\u0397 \u0393\u0391\u0399\u03a9\u039d \u03a3\u03a4\u0397 \u0398\u0395\u03a3\u03a3\u0391\u039b\u0399\u0391",
            "\u0394\u0399\u0391\u039a\u03a1\u0399\u03a3\u0397 \u0391\u03a3\u03a6\u0391\u039b\u0399\u03a3\u039c\u0395\u039d\u03a9\u039d",
            "\u0391\u0393\u0391\u0398\u039f\u0395\u03a1\u0393\u0391 \u0399\u0394\u03a1\u03a5\u039c\u0391\u03a4\u0391 \u039a\u0395\u03a1\u039a\u03a5\u03a1\u0391\u03a3",
            "\u03a5\u03a0\u0391\u0399\u0398\u03a1\u0399\u039f-\u03a0\u039b\u0391\u039d\u039f\u0394\u0399\u039f \u0395\u039c\u03a0\u039f\u03a1\u0399\u039f \u039a\u0391\u0399 \u0395\u039c\u03a0\u039f\u03a1\u039f\u03a0\u0391\u039d\u0397\u0393\u03a5\u03a1\u0395\u0399\u03a3",
            "\u0395\u039e\u0391\u0393\u03a9\u0393\u0399\u039a\u0391 \u03a4\u0395\u039b\u0397",
            "\u03a5\u03a0\u039f\u03a5\u03a1\u0393\u0399\u039a\u039f \u03a3\u03a5\u039c\u0392\u039f\u03a5\u039b\u0399\u039f - \u039f\u03a1\u0393\u0391\u039d\u03a9\u03a3\u0397 \u03a5\u03a0\u039f\u03a5\u03a1\u0393\u0395\u0399\u03a9\u039d - \u039a\u03a5\u0392\u0395\u03a1\u039d\u0397\u03a4\u0399\u039a\u0395\u03a3 \u0395\u03a0\u0399\u03a4\u03a1\u039f\u03a0\u0395\u03a3",
            "\u0391\u03a5\u03a4\u039f\u039a\u0399\u039d\u0397\u03a4\u0391 \u039a\u0391\u0399 \u0391\u039c\u0391\u039e\u0399\u0394\u0399\u0391 \u0391\u039d\u0391\u03a0\u0397\u03a1\u03a9\u039d \u03a0\u039f\u039b\u0395\u039c\u039f\u03a5",
            "\u03a5\u03a0\u0397\u03a1\u0395\u03a3\u0399\u0395\u03a3 \u03a0\u0395\u03a1\u0399\u03a6\u0395\u03a1\u0395\u0399\u0391\u039a\u0397\u03a3 \u0391\u039d\u0391\u03a0\u03a4\u03a5\u039e\u0397\u03a3",
            "\u0394\u0399\u0391\u03a4\u0399\u039c\u0397\u03a3\u0397 \u03a6\u0391\u03a1\u039c\u0391\u039a\u03a9\u039d",
            "\u03a6\u039f\u03a1\u039f\u039b\u039f\u0393\u0399\u0391 \u0395\u0399\u0394\u03a9\u039d \u03a0\u039f\u039b\u03a5\u03a4\u0395\u039b\u0395\u0399\u0391\u03a3",
            "\u039d\u0391\u03a5\u03a4\u0399\u039a\u0397 \u03a0\u039f\u0399\u039d\u0399\u039a\u0397 \u039d\u039f\u039c\u039f\u0398\u0395\u03a3\u0399\u0391",
            "\u03a4\u0391\u039c\u0395\u0399\u039f \u0395\u03a0\u0399\u039a\u039f\u03a5\u03a1\u0399\u039a\u0397\u03a3 \u0391\u03a3\u03a6\u0391\u039b\u0399\u03a3\u0395\u03a9\u03a3 \u03a0\u03a1\u039f\u03a3\u03a9\u03a0\u0399\u039a\u039f\u03a5 \u0395\u03a4\u0391\u0399\u03a1\u0395\u0399\u03a9\u039d \u03a0\u0395\u03a4\u03a1\u0395\u039b\u0391\u0399\u039f\u0395\u0399\u0394\u03a9\u039d",
            "\u0394\u03a9\u03a1\u039f \u0395\u039f\u03a1\u03a4\u03a9\u039d \u0395\u03a6\u0397\u039c\u0395\u03a1\u0399\u0394\u039f\u03a0\u03a9\u039b\u03a9\u039d",
            "\u0394\u0399\u0395\u03a5\u039a\u039f\u039b\u03a5\u039d\u03a3\u0395\u0399\u03a3 \u0393\u0399\u0391 \u03a4\u0397\u039d \u0391\u039d\u039f\u0399\u039a\u039f\u0394\u039f\u039c\u0397\u03a3\u0397",
            "\u0395\u03a0\u0399\u03a3\u039a\u0395\u03a5\u0391\u03a3\u03a4\u0395\u03a3 - \u03a3\u03a5\u039d\u0395\u03a1\u0393\u0395\u0399\u0391 \u0395\u03a0\u0399\u03a3\u039a\u0395\u03a5\u0397\u03a3 \u0391\u03a5\u03a4\u039f\u039a\u0399\u039d\u0397\u03a4\u03a9\u039d\u039f\u0394\u0399\u039a\u0397 \u0392\u039f\u0397\u0398\u0395\u0399\u0391 \u039f\u03a7\u0397\u039c\u0391\u03a4\u03a9\u039d",
            "\u03a0\u0391\u03a1\u0391\u03a7\u03a9\u03a1\u0397\u03a3\u0397 \u0394\u0391\u03a3\u03a9\u039d",
            "\u03a4\u0391\u039c\u0395\u0399\u039f \u0391\u03a3\u03a6\u0391\u039b\u0399\u03a3\u0395\u03a9\u03a3 \u0391\u03a3\u0398\u0395\u039d\u0395\u0399\u0391\u03a3 \u03a0\u03a1\u039f\u03a3\u03a9\u03a0\u0399\u039a\u039f\u03a5 \u03a4\u03a1\u0391\u03a0\u0395\u0396\u03a9\u039d \u03a0\u0399\u03a3\u03a4\u0395\u03a9\u03a3, \u0393\u0395\u039d\u0399\u039a\u0397\u03a3 \u039a\u0391\u0399 \u0391\u039c\u0395\u03a1\u0399\u039a\u0391\u039d \u0395\u039e\u03a0\u03a1\u0395\u03a3",
            "\u03a0\u039b\u0397\u03a4\u03a4\u039f\u039c\u0395\u039d\u0391 \u0391\u03a0\u039f \u03a4\u0397\u039d \u0391\u039d\u0395\u03a1\u0393\u0399\u0391 \u0395\u03a0\u0391\u0393\u0393\u0395\u039b\u039c\u0391\u03a4\u0391",
            "\u03a4\u0391\u039c\u0395\u0399\u0391 \u039a.\u0391.\u03a4.\u0395",
            "\u0395\u0399\u0394\u0399\u039a\u039f\u0399 \u03a3\u03a4\u03a1\u0391\u03a4\u0399\u03a9\u03a4\u0399\u039a\u039f\u0399 \u039f\u03a1\u0393\u0391\u039d\u0399\u03a3\u039c\u039f\u0399",
            "\u03a4\u0391\u039c\u0395\u0399\u039f \u0391\u03a3\u03a6\u0391\u039b\u0399\u03a3\u0395\u03a9\u03a3 \u03a0\u03a1\u039f\u03a3\u03a9\u03a0\u0399\u039a\u039f\u03a5 \u0399\u039f\u039d\u0399\u039a\u0397\u03a3 \u039a\u0391\u0399 \u039b\u0391\u0399\u039a\u0397\u03a3 \u03a4\u03a1\u0391\u03a0\u0395\u0396\u0391\u03a3 (\u03a4.\u0391.\u03a0.- \u0399.\u039b.\u03a4.)",
            "\u03a0\u03a1\u039f\u03a3\u03a4\u0391\u03a3\u0399\u0391 \u0391\u03a0\u039f \u0391\u039a\u03a4\u0399\u039d\u039f\u0392\u039f\u039b\u0399\u0395\u03a3",
            "\u039a\u03a1\u0391\u03a4\u0399\u039a\u039f \u0398\u0395\u0391\u03a4\u03a1\u039f \u0392. \u0395\u039b\u039b\u0391\u0394\u039f\u03a3",
            "\u03a5\u0393\u0395\u0399\u039f\u039d\u039f\u039c\u0399\u039a\u039f\u03a3 \u0395\u039b\u0395\u0393\u03a7\u039f\u03a3 \u03a6\u039f\u0399\u03a4\u0397\u03a4\u03a9\u039d",
            "\u0394\u0399\u0391\u03a6\u039f\u03a1\u0391",
            "\u03a4\u0395\u039b\u03a9\u039d\u0395\u0399\u0391\u039a\u0397 \u03a5\u03a0\u0397\u03a1\u0395\u03a3\u0399\u0391 \u03a3\u0399\u0394\u0397\u03a1\u039f\u0394\u03a1\u039f\u039c\u03a9\u039d",
            "\u0395\u03a6\u0395\u03a5\u03a1\u0395\u03a3\u0395\u0399\u03a3 \u0391\u03a6\u039f\u03a1\u03a9\u03a3\u0391\u0399 \u0395\u0398\u039d. \u0391\u039c\u03a5\u039d\u0391",
            "\u03a5\u03a0\u039f\u0392\u03a1\u03a5\u03a7\u0399\u039f\u03a3 \u03a4\u0397\u039b\u0395\u0393\u03a1\u0391\u03a6\u039f\u03a3",
            "\u0391\u0394\u0395\u0399\u0395\u03a3 \u039f\u0399\u039a\u039f\u0394\u039f\u039c\u0397\u03a3 \u039e\u0395\u039d\u039f\u0394\u039f\u03a7\u0395\u0399\u03a9\u039d",
            "\u0399\u039d\u03a3\u03a4\u0399\u03a4\u039f\u03a5\u03a4\u039f \u0392\u03a5\u0396\u0391\u039d\u03a4\u0399\u039d\u03a9\u039d \u03a3\u03a0\u039f\u03a5\u0394\u03a9\u039d",
            "\u03a3\u03a7\u039f\u039b\u0397 \u0393\u0395\u03a9\u03a4\u0395\u03a7\u039d\u0399\u039a\u03a9\u039d \u0395\u03a0\u0399\u03a3\u03a4\u0397\u039c\u03a9\u039d \u03a0\u0391\u039d\u039c\u0399\u039f\u03a5 \u0398\u0395\u03a3\u039d\u0399\u039a\u0397\u03a3",
            "\u0392\u0399\u0392\u039b\u0399\u039f\u0398\u0397\u039a\u0395\u03a3",
            "\u03a4\u0391\u039c\u0395\u0399\u0391 \u0391\u039d\u0395\u0393\u0395\u03a1\u03a3\u0395\u03a9\u03a3 \u0394\u0399\u0394\u0391\u039a\u03a4\u0397\u03a1\u0399\u03a9\u039d",
            "\u0395\u03a0\u0399\u0394\u039f\u039c\u0391 \u0392\u0399\u0392\u039b\u0399\u039f\u0398\u0397\u039a\u0397\u03a3",
            "\u039a\u0391\u03a4\u0391\u03a3\u03a4\u0397\u039c\u0391\u03a4\u0391 \u0391\u03a6\u039f\u03a1\u039f\u039b\u039f\u0393\u0397\u03a4\u03a9\u039d \u0395\u0399\u0394\u03a9\u039d",
            "\u0395\u03a0\u0399\u03a7\u0395\u0399\u03a1\u0397\u03a3\u0395\u0399\u03a3 \u03a0\u0395\u03a1\u0399\u0398\u0391\u039b\u03a8\u0395\u03a9\u03a3 \u0397\u039b\u0399\u039a\u0399\u03a9\u039c\u0395\u039d\u03a9\u039d \u0397 \u0391\u039d\u0391\u03a0\u0397\u03a1\u03a9\u039d",
            "\u039b\u0399\u039c\u0395\u039d\u0399\u039a\u039f\u0399 \u03a3\u03a4\u0391\u0398\u039c\u039f\u0399",
            "\u039d\u039f\u039c\u039f\u0398\u0395\u03a4\u0399\u039a\u0395\u03a3 \u0395\u039e\u039f\u03a5\u03a3\u0399\u039f\u0394\u039f\u03a4\u0397\u03a3\u0395\u0399\u03a3",
            "\u0398\u0391\u039b\u0391\u039c\u039f\u0399 \u03a1\u0391\u0394\u0399\u039f\u0399\u03a3\u039f\u03a4\u039f\u03a0\u03a9\u039d",
            "\u0394\u0399\u039f\u0399\u039a\u0397\u03a3\u0397 \u0395\u039a\u039a\u039b\u0397\u03a3\u0399\u0391\u03a3\u03a4\u0399\u039a\u0397\u03a3 \u0395\u039a\u03a0\u0391\u0399\u0394\u0395\u03a5\u03a3\u0397\u03a3",
            "\u0391\u03a0\u0391\u0393\u039f\u03a1\u0395\u03a5\u039c\u0395\u039d\u0395\u03a3 \u039a\u0391\u0399",
            "\u0397\u0398\u039f\u03a0\u039f\u0399\u039f\u0399",
            "\u03a3\u03a5\u039c\u0392\u0391\u03a3\u0395\u0399\u03a3 \u03a0\u0395\u03a1\u0399 \u0394\u0399\u0395\u0398\u039d\u03a9\u039d \u0395\u039a\u0398\u0395\u03a3\u0395\u03a9\u039d",
            "\u03a3\u03a6\u03a1\u0391\u0393\u0399\u03a3\u03a4\u039f\u03a3 \u03a7\u0391\u03a1\u03a4\u0397\u03a3",
            "\u0395\u03a4\u0391\u0399\u03a1\u0395\u0399\u0395\u03a3 \u0394\u0399\u0391\u03a7\u0395\u0399\u03a1\u0399\u0396\u039f\u039c\u0395\u039d\u0395\u03a3 \u0394\u0397\u039c\u039f\u03a3\u0399\u0391 \u03a3\u03a5\u039c\u03a6\u0395\u03a1\u039f\u039d\u03a4\u0391",
            "\u03a4\u0395\u039b\u03a9\u039d\u0395\u0399\u0391\u039a\u0395\u03a3 \u0394\u0399\u0395\u03a5\u039a\u039f\u039b\u03a5\u039d\u03a3\u0395\u0399\u03a3",
            "\u0394\u0395\u039e\u0391\u039c\u0395\u039d\u039f\u03a0\u039b\u039f\u0399\u0391",
            "\u039a\u0395\u039d\u03a4\u03a1\u039f \u0394\u0399\u0395\u0398\u039d\u039f\u03a5\u03a3 \u039a\u0391\u0399 \u0395\u03a5\u03a1\u03a9\u03a0\u0391\u0399\u039a\u039f\u03a5",
            "\u0395\u03a0\u0399\u0392\u0391\u03a4\u0397\u0393\u0391 \u039c\u0395\u03a3\u039f\u0393\u0395\u0399\u0391\u039a\u0391 \u039a\u0391\u0399 \u03a4\u039f\u03a5\u03a1\u0399\u03a3\u03a4\u0399\u039a\u0391 \u03a0\u039b\u039f\u0399\u0391",
            "\u0395\u03a0\u0399\u0398\u0395\u03a9\u03a1\u0397\u03a3\u0397 \u0394\u0399\u039a\u0391\u03a3\u03a4\u0399\u039a\u03a9\u039d \u03a5\u03a0\u0391\u039b\u039b\u0397\u039b\u03a9\u039d",
            "\u039a\u0391\u039d\u039f\u039d\u0399\u03a3\u039c\u039f\u03a3 \u0398\u0395\u0391\u03a4\u03a1\u03a9\u039d \u039a\u0399\u039d\u0397\u039c\u0391\u03a4\u039f\u0393\u03a1\u0391\u03a6\u03a9\u039d \u039a\u039b\u03a0",
            "\u039c\u0395\u03a4\u0391\u039b\u039b\u0395\u03a5\u03a4\u0399\u039a\u039f\u03a3 \u039a\u03a9\u0394\u0399\u039a\u0391\u03a3",
            "\u039a\u0391\u03a4\u0391\u03a3\u03a4\u0391\u03a4\u0399\u039a\u039f \u03a4.\u0395.\u0391.\u0391.\u03a0.\u0391.\u0395",
            "\u03a0\u0391\u039d\u0395\u03a0\u0399\u03a3\u03a4\u0397\u039c\u0399\u0391\u039a\u0397 \u039b\u0395\u03a3\u03a7\u0397",
            "\u0395\u039c\u03a0\u039f\u03a1\u0399\u039a\u0391 \u039a\u0391\u0399 \u0392\u0399\u039f\u039c\u0397\u03a7\u0391\u039d\u0399\u039a\u0391 \u03a3\u0397\u039c\u0391\u03a4\u0391 - (\u0394\u0399\u0395\u0398\u039d\u0395\u0399\u03a3 \u03a3\u03a5\u039c\u0392\u0391\u03a3\u0395\u0399\u03a3)",
            "\u0395\u03a0\u0399\u0394\u039f\u039c\u0391\u03a4\u0391 \u0391\u03a0\u039f\u039b\u03a5\u039f\u039c\u0395\u039d\u03a9\u039d \u039f\u03a0\u039b\u0399\u03a4\u03a9\u039d \u03a9\u03a3 \u0391\u039d\u0399\u039a\u0391\u039d\u03a9\u039d",
            "\u03a3\u03a5\u039c\u0392\u039f\u03a5\u039b\u0399\u039f \u0395\u039d\u0395\u03a1\u0393\u0395\u0399\u0391\u03a3",
            "\u03a3\u03a7\u039f\u039b\u0397 \u039d\u039f\u039c\u0399\u039a\u03a9\u039d,\u039f\u0399\u039a\u039f\u039d\u039f\u039c\u0399\u039a\u03a9\u039d \u039a\u0391\u0399 \u03a0\u039f\u039b\u0399\u03a4\u0399\u039a\u03a9\u039d \u0395\u03a0\u0399\u03a3\u03a4\u0397\u039c\u03a9\u039d",
            "\u03a0\u03a1\u039f\u03a0\u039b\u0397\u03a1\u03a9\u039c\u0395\u03a3 \u039a\u0391\u0399 \u03a0\u03a1\u039f\u039a\u0391\u03a4\u0391\u0392\u039f\u039b\u0395\u03a3",
            "\u039a\u039b\u0391\u0394\u039f\u03a3 \u0391\u03a3\u0398\u0395\u039d\u0395\u0399\u0391\u03a3 \u03a4.\u0395.\u0392.\u0395",
            "\u0394\u0399\u0391\u039d\u039f\u039c\u0397 \u0393\u0391\u0399\u03a9\u039d \u039a\u03a9\u03a0\u0391\u0399\u0394\u0391\u03a3",
            "\u03a0\u03a1\u039f\u03a3\u03a9\u03a0\u0399\u039a\u039f \u0391\u03a3\u03a6\u0391\u039b\u0395\u0399\u0391\u03a3 \u039d.\u03a0.\u0394.\u0394. - \u039f\u03a1\u0393\u0391\u039d\u0399\u03a3\u039c\u03a9\u039d & \u0395\u03a0\u0399\u03a7\u0395\u0399\u03a1\u0397\u03a3\u0395\u03a9\u039d",
            "\u03a5\u03a0\u039f\u03a5\u03a1\u0393\u0395\u0399\u039f \u03a5\u03a0\u039f\u0394\u039f\u039c\u03a9\u039d, \u039c\u0395\u03a4\u0391\u03a6\u039f\u03a1\u03a9\u039d \u039a\u0391\u0399 \u0394\u0399\u039a\u03a4\u03a5\u03a9\u039d",
            "\u0391\u0395\u03a1\u039f\u039d\u0391\u03a5\u0391\u0393\u039f\u03a3\u03a9\u03a3\u03a4\u0399\u039a\u0397 \u039c\u039f\u039d\u0391\u0394\u0391",
            "\u039a\u039f\u03a5\u03a1\u0395\u0399\u0391, \u039a\u039f\u039c\u039c\u03a9\u03a4\u0397\u03a1\u0399\u0391 \u039a.\u039b.\u03a0",
            "\u03a4\u0391\u039c\u0395\u0399\u039f \u03a0\u03a1\u039f\u039d\u039f\u0399\u0391\u03a3 \u0394\u0399\u039a\u0391\u03a3\u03a4\u0399\u039a\u03a9\u039d \u0395\u03a0\u0399\u039c\u0395\u039b\u0397\u03a4\u03a9\u039d",
            "\u0395\u0399\u0394\u0399\u039a\u0391 \u03a3\u03a5\u039d\u0395\u03a1\u0393\u0395\u0399\u0391",
            "\u039a\u0391\u03a4\u0395\u03a8\u03a5\u0393\u039c\u0395\u039d\u0391 \u039a\u03a1\u0395\u0391\u03a4\u0391",
            "\u039c\u0395\u03a3\u039f\u0393\u0395\u0399\u0391\u039a\u0391 \u0394\u03a1\u039f\u039c\u039f\u039b\u039f\u0393\u0399\u0391 \u0395\u03a0\u0399\u0392\u0391\u03a4\u0397\u0393\u03a9\u039d \u03a0\u039b\u039f\u0399\u03a9\u039d",
            "\u03a3\u03a5\u0393\u039a\u03a1\u039f\u03a4\u0397\u03a3\u0397 \u03a0\u03a1\u039f\u03a3\u03a9\u03a0\u0399\u039a\u039f\u03a5 \u0391\u0395\u03a1\u039f\u03a0\u039f\u03a1\u0399\u0391\u03a3",
            "\u03a5\u03a0\u0391\u039b\u039b\u0397\u039b\u0399\u039a\u039f\u03a3 \u039a\u03a9\u0394\u0399\u039a\u0391\u03a3",
            "\u0393\u0395\u039d\u0399\u039a\u0395\u03a3 \u0394\u0399\u0391\u03a4\u0391\u039e\u0395\u0399\u03a3 \u03a0\u0395\u03a1\u0399 \u03a6\u0391\u03a1\u039c\u0391\u039a\u0395\u0399\u03a9\u039d",
            "\u0394\u0399\u0391\u03a6\u039f\u03a1\u039f\u0399 \u03a3\u03a4\u0395\u0393\u0391\u03a3\u03a4\u0399\u039a\u039f\u0399 \u039d\u039f\u039c\u039f\u0399",
            "\u03a5\u03a0\u039f\u03a5\u03a1\u0393\u0395\u0399\u039f \u03a3\u03a5\u039d\u03a4\u039f\u039d\u0399\u03a3\u039c\u039f\u03a5",
            "\u03a0\u03a1\u039f\u03a3\u039b\u0397\u03a8\u0395\u0399\u03a3 \u03a3\u03a4\u039f \u0394\u0397\u039c\u039f\u03a3\u0399\u039f",
            "\u03a4\u0391\u039c\u0395\u0399\u039f \u0395\u03a0\u0399\u039a. \u0391\u03a3\u03a6\u0391\u039b. \u03a0\u03a1\u039f\u03a3\u03a9\u03a0. \u039f.\u0395.\u0391.\u03a3. \u039a\u0391\u0399 \u03a5\u03a0\u0391\u039b\u039b. \u0393\u03a1\u0391\u03a6\u0395\u0399\u03a9\u039d \u039a\u039f\u0399\u039d\u03a9\u039d \u03a4\u0391\u039c\u0395\u0399\u03a9\u039d \u0399\u0394\u0399\u03a9\u03a4\u0399\u039a\u03a9\u039d \u039b\u0395\u03a9\u03a6\u039f\u03a1\u0395\u0399\u03a9\u039d",
            "\u03a3\u03a4\u03a1\u0391\u03a4\u0399\u03a9\u03a4\u0399\u039a\u0397 \u0391\u03a3\u03a4\u03a5\u039d\u039f\u039c\u0399\u0391",
            "\u039d\u039f\u039c\u0399\u03a3\u039c\u0391\u03a4\u0399\u039a\u0395\u03a3 \u03a3\u03a5\u039c\u0392\u0391\u03a3\u0395\u0399\u03a3",
            "\u0391\u03a1\u03a7\u0397 \u0394\u0399\u0391\u03a3\u03a6\u0391\u039b\u0399\u03a3\u0397\u03a3 \u0391\u03a0\u039f\u03a1\u03a1\u0397\u03a4\u039f\u03a5 \u0395\u03a0\u0399\u039a\u039f\u0399\u039d\u03a9\u039d\u0399\u03a9\u039d (\u0391.\u0394.\u0391.\u0395.)",
            "\u03a3\u03a4\u03a1\u0391\u03a4\u0399\u03a9\u03a4\u0399\u039a\u0391 \u03a3\u03a5\u039d\u0395\u03a1\u0393\u0395\u0399\u0391",
            "\u03a0\u03a1\u039f\u03a3\u03a9\u03a0\u0399\u039a\u0397 \u039a\u03a1\u0391\u03a4\u0397\u03a3\u0397",
            "\u0395\u03a6\u0397\u039c\u0395\u03a1\u0399\u0394\u0391 \u03a4\u0397\u03a3 \u039a\u03a5\u0392\u0395\u03a1\u039d\u0397\u03a3\u0395\u03a9\u03a3",
            "\u0391\u039d\u03a9\u03a4\u0391\u03a4\u039f \u03a5\u0393\u0395\u0399\u039f\u039d\u039f\u039c\u0399\u039a\u039f \u03a3\u03a5\u039c\u0392\u039f\u03a5\u039b\u0399\u039f",
            "\u0393\u03a1\u0391\u039c\u039c\u0391\u03a4\u0395\u0399\u03a3 \u03a3\u03a4\u03a1\u0391\u03a4\u039f\u0394\u0399\u039a\u0395\u0399\u03a9\u039d",
            "\u039a\u0391\u03a4\u0391\u03a3\u03a4\u0391\u03a3\u0397 \u0394\u0399\u039f\u03a0\u03a9\u039d, \u039d\u0391\u03a5\u03a4\u03a9\u039d \u039a\u0391\u0399 \u039d\u0391\u03a5\u03a4\u039f\u03a0\u0391\u0399\u0394\u03a9\u039d",
            "\u03a0\u0395\u03a1\u0399\u03a0\u03a4\u03a9\u03a3\u0395\u0399\u03a3 \u0391\u039c\u039f\u0399\u0392\u0391\u0399\u0391\u03a3 \u03a3\u03a5\u039d\u0394\u03a1\u039f\u039c\u0397\u03a3",
            "\u03a5\u03a0\u039f\u039d\u039f\u039c\u039f\u0399 \u03a0\u03a1\u03a9\u03a4\u0395\u03a5\u039f\u03a5\u03a3\u0391\u03a3",
            "\u03a4\u0395\u039b\u0397 \u0394\u0399\u0391\u0394\u03a1\u039f\u039c\u0397\u03a3 \u0395\u039d\u0391\u0395\u03a1\u0399\u039f\u03a5 \u03a7\u03a9\u03a1\u039f\u03a5",
            "\u03a5\u0393\u0395\u0399\u039f\u039d\u039f\u039c\u0399\u039a\u0391\u0399 \u0395\u03a0\u0399\u03a4\u03a1\u039f\u03a0\u0391\u0399",
            "\u0399\u0391\u03a4\u03a1\u0399\u039a\u0395\u03a3 \u0395\u0399\u0394\u0399\u039a\u039f\u03a4\u0397\u03a4\u0395\u03a3",
            "\u0395\u03a1\u03a4 \u2013 2",
            "\u0395\u039a\u03a4\u0395\u039b\u0395\u03a3\u0397 \u0395\u03a1\u0393\u03a9\u039d \u039f.\u03a3.\u0395.\u039a\u0391\u0399 \u03a3\u03a5\u039d\u0394\u0395\u0394\u0395\u039c\u0395\u039d\u03a9\u039d \u0395\u03a0\u0399\u03a7\u0395\u0399\u03a1\u0397\u03a3\u0395\u03a9\u039d",
            "\u0393\u0395\u03a9\u03a1\u0393\u0399\u039a\u0395\u03a3 \u03a3\u03a7\u039f\u039b\u0395\u03a3",
            "\u03a3\u03a5\u039c\u039c\u0395\u03a4\u039f\u03a7\u0397 \u03a3\u03a5\u039d\u0395\u03a4\u0391\u0399\u03a1\u0399\u03a3\u039c\u03a9\u039d \u03a3\u0395 \u03a0\u03a1\u039f\u039c\u0397\u0398\u0395\u0399\u0395\u03a3 \u0394\u0397\u039c\u039f\u03a3\u0399\u039f\u03a5",
            "\u0394\u0399\u039a\u0391\u0399\u03a9\u039c\u0391 \u03a7\u039f\u03a1\u03a4\u039f\u039d\u039f\u039c\u0397\u03a3",
            "\u039f\u0399\u039a\u039f\u039a\u03a5\u03a1\u0399\u039a\u0395\u03a3 \u03a3\u03a7\u039f\u039b\u0395\u03a3",
            "\u039a\u0395\u039d\u03a4\u03a1\u0391 \u03a5\u0393\u0395\u0399\u0391\u03a3-\u03a0\u039f\u039b\u03a5\u0399\u0391\u03a4\u03a1\u0395\u0399\u0391",
            "\u0394\u0399\u039a\u0391\u03a3\u03a4\u0397\u03a1\u0399\u039f \u03a3\u03a5\u039d\u0394\u0399\u0391\u039b\u039b\u0391\u0393\u0397\u03a3 \u039a\u0391\u0399 \u0394\u0399\u0391\u0399\u03a4\u0397\u03a3\u0399\u0391\u03a3",
            "\u0395\u03a0\u0399\u0398\u0395\u03a9\u03a1\u0397\u03a3\u0397 \u0399\u03a7\u0398\u03a5\u03a9\u039d",
            "\u03a3\u03a5\u039d\u0395\u03a4\u0391\u0399\u03a1\u0399\u03a3\u039c\u039f\u0399 \u0395\u039e\u0395\u03a5\u0393\u0395\u039d\u0399\u03a3\u039c\u039f\u03a5 \u0394\u0395\u039d\u0394\u03a1\u03a9\u039d",
            "\u03a6\u039f\u0399\u03a4\u0397\u03a4\u0395\u03a3",
            "\u0394\u039f\u039c\u0397\u03a3\u0397 \u0395\u03a0\u0399 \u03a1\u03a5\u039c\u039f\u03a4\u039f\u039c\u039f\u03a5\u039c\u0395\u039d\u03a9\u039d \u0391\u039a\u0399\u039d\u0397\u03a4\u03a9\u039d",
            "\u0391\u03a0\u0391\u03a3\u03a7\u039f\u039b\u0397\u03a3\u0397 - \u0395\u039e\u0395\u0399\u0394\u0399\u039a\u0395\u03a5\u03a3\u0397 - \u039a\u0391\u03a4\u0391\u03a1\u03a4\u0399\u03a3\u0397 \u0391\u039d\u0395\u03a1\u0393\u03a9\u039d",
            "\u03a4\u0391\u039c\u0395\u0399\u039f \u0395\u03a0\u0399\u039a\u039f\u03a5\u03a1\u0399\u039a\u0397\u03a3 \u0391\u03a3\u03a6\u0391\u039b\u0399\u03a3\u0395\u03a9\u03a3 \u03a5\u03a0\u0391\u039b\u039b\u0397\u039b\u03a9\u039d \u03a6\u0391\u03a1\u039c\u0391\u039a\u0395\u03a5\u03a4\u0399\u039a\u03a9\u039d \u0395\u03a1\u0393\u0391\u03a3\u0399\u03a9\u039d (\u03a4.\u0395.\u0391.\u03a5.\u03a6.\u0395.)",
            "\u039d\u039f\u039c\u0399\u03a3\u039c\u0391\u03a4\u0399\u039a\u039f \u03a3\u03a5\u03a3\u03a4\u0397\u039c\u0391",
            "\u0391\u03a0\u039f\u0393\u03a1\u0391\u03a6\u0397 \u039d\u0391\u03a5\u03a4\u0399\u039a\u03a9\u039d",
            "\u0395\u0398\u039d\u0399\u039a\u039f \u0398\u0395\u0391\u03a4\u03a1\u039f",
            "\u03a5\u03a0\u0397\u03a1\u0395\u03a3\u0399\u0391 \u0395\u03a0\u0399\u03a3\u03a4\u0397\u039c\u039f\u039d\u0399\u039a\u0397\u03a3 \u0384\u0395\u03a1\u0395\u03a5\u039d\u0391\u03a3 \u039a\u0391\u0399 \u0391\u039d\u0391\u03a0\u03a4\u03a5\u039e\u0395\u03a9\u03a3",
            "\u03a0\u0391\u03a1\u039f\u03a7\u0395\u03a3 \u0391\u03a3\u03a4\u03a5\u039d\u039f\u039c\u0399\u039a\u039f\u03a5 \u03a0\u03a1\u039f\u03a3\u03a9\u03a0\u0399\u039a\u039f\u03a5 \u0395\u039b\u039b\u0397\u039d\u0399\u039a\u0397\u03a3 \u0391\u03a3\u03a4\u03a5\u039d\u039f\u039c\u0399\u0391\u03a3",
            "\u03a3\u0399\u0392\u0399\u03a4\u0391\u039d\u0399\u0394\u0395\u0399\u039f\u03a3 \u03a3\u03a7\u039f\u039b\u0397",
            "\u03a3\u03a4\u03a1\u0391\u03a4\u0399\u03a9\u03a4\u0399\u039a\u0397 \u0399\u0391\u03a4\u03a1\u0399\u039a\u0397 \u03a3\u03a7\u039f\u039b\u0397",
            "\u03a5\u03a0\u039f\u03a5\u03a1\u0393\u0395\u0399\u039f \u039a\u039f\u0399\u039d\u03a9\u039d\u0399\u039a\u03a9\u039d \u03a5\u03a0\u0397\u03a1\u0395\u03a3\u0399\u03a9\u039d",
            "\u0391\u03a0\u0391\u0393\u039f\u03a1\u0395\u03a5\u03a3\u0397 \u0391\u03a0\u0391\u039b\u039b\u039f\u03a4\u03a1\u0399\u03a9\u03a3\u0397\u03a3 \u03a0\u039b\u039f\u0399\u03a9\u039d",
            "\u03a0\u0391\u039d\u0395\u03a0\u0399\u03a3\u03a4\u0397\u039c\u0399\u0391\u039a\u0391 \u03a3\u03a5\u0393\u0393\u03a1\u0391\u039c\u039c\u0391\u03a4\u0391",
            "\u039c\u039f\u03a5\u03a3\u039f\u03a5\u039b\u039c\u0391\u039d\u039f\u0399",
            "\u0394\u0399\u039a\u0391\u03a3\u03a4\u0399\u039a\u039f\u0399 \u03a3\u03a5\u039c\u0392\u039f\u03a5\u039b\u039f\u0399 \u03a0\u039f\u039b\u0395\u039c\u0399\u039a\u039f\u03a5 \u039d\u0391\u03a5\u03a4\u0399\u039a\u039f\u03a5",
            "\u0391\u0395\u03a1\u039f\u03a0\u039f\u03a1\u0399\u039a\u0391 \u0395\u03a1\u0393\u0391 \u039a\u0391\u0399 \u03a0\u03a1\u039f\u039c\u0397\u0398\u0395\u0399\u0395\u03a3",
            "\u03a4\u039f\u03a0\u0399\u039a\u0391 \u0395\u0393\u0393\u0395\u0399\u039f\u0392\u0395\u039b\u03a4\u0399\u03a9\u03a4\u0399\u039a\u0391 \u0395\u03a1\u0393\u0391",
            "\u03a6\u039f\u03a1\u039f\u039b\u039f\u0393\u0399\u0391 \u0396\u03a9\u03a9\u039d",
            "\u03a3\u03a5\u039d\u03a4\u0391\u0393\u039c\u0391",
            "\u039d\u039f\u039c\u039f\u0399 \u03a0\u0395\u03a1\u0399 \u03a7\u03a1\u0397\u039c\u0391\u03a4\u0399\u03a3\u03a4\u0397\u03a1\u0399\u039f\u03a5 - \u0395\u03a0\u0399\u03a4\u03a1\u039f\u03a0\u0397 \u039a\u0395\u03a6\u0391\u039b\u0391\u0399\u0391\u0393\u039f\u03a1\u0391\u03a3 - \u03a7\u03a1\u0397\u039c\u0391\u03a4\u0399\u03a3\u03a4\u0397\u03a1\u0399\u0391\u039a\u0397 \u0391\u0393\u039f\u03a1\u0391 \u03a0\u0391\u03a1\u0391\u0393\u03a9\u0393\u03a9\u039d",
            "\u0393\u0395\u03a9\u03a4\u03a1\u0397\u03a3\u0395\u0399\u03a3",
            "\u03a4\u0391\u039c\u0395\u0399\u0391 \u0395\u03a0\u0399\u039a\u039f\u03a5\u03a1\u0399\u039a\u0397\u03a3 \u0391\u03a3\u03a6\u0391\u039b\u0399\u03a3\u0395\u03a9\u03a3 \u039a\u0391\u0399 \u03a0\u03a1\u039f\u039d\u039f\u0399\u0391\u03a3 \u03a0\u03a1\u039f\u03a3\u03a9\u03a0\u0399\u039a\u039f\u03a5 \u0395\u039c\u03a0\u039f\u03a1\u0399\u039a\u0397\u03a3 \u03a4\u03a1\u0391\u03a0\u0395\u0396\u0391\u03a3 \u0395\u039b\u039b\u0391\u0394\u0391\u03a3 (\u03a4.\u0395.\u0391.\u03a0.\u0395.\u03a4.\u0395 \u039a\u0391\u0399 \u03a4.\u0391.\u03a0.\u0395.\u03a4.\u0395.)",
            "\u0395\u03a6\u0395\u0394\u03a1\u039f\u0399 \u0391\u0395\u03a1\u039f\u03a0\u039f\u03a1\u0399\u0391\u03a3",
            "\u039a\u0391\u03a4\u2019 \u0399\u0394\u0399\u0391\u039d \u0399\u0394\u0399\u03a9\u03a4\u0399\u039a\u0391 \u0395\u039a\u03a0\u0391\u0399\u0394\u0395\u03a5\u03a4\u0397\u03a1\u0399\u0391",
            "\u03a3\u03a7\u039f\u039b\u0397 \u039d\u039f\u039c\u0399\u039a\u03a9\u039d \u039a\u0391\u0399 \u039f\u0399\u039a\u039f\u039d\u039f\u039c\u0399\u039a\u03a9\u039d \u0395\u03a0\u0399\u03a3\u03a4\u0397\u039c\u03a9\u039d",
            "\u039a\u0391\u03a4\u0391\u0392\u039f\u039b\u0397 \u0395\u0399\u03a3\u03a6\u039f\u03a1\u03a9\u039d \u039c\u0395 \u0394\u039f\u03a3\u0395\u0399\u03a3",
            "\u03a0\u0391\u039b\u0391\u0399\u039f\u03a4\u0395\u03a1\u0395\u03a3 \u0391\u0395\u03a1\u039f\u03a0\u039f\u03a1\u0399\u039a\u0395\u03a3 \u0395\u03a4\u0391\u0399\u03a1\u0395\u0399\u0395\u03a3",
            "\u03a4\u03a1\u039f\u039c\u039f\u039a\u03a1\u0391\u03a4\u0399\u0391 - \u039f\u03a1\u0393\u0391\u039d\u03a9\u039c\u0395\u039d\u0397",
            "\u03a4\u0391\u039c\u0395\u0399\u0391 \u0395\u039b\u0399\u0391\u03a3-\u0394\u0391\u039a\u039f\u039a\u03a4\u039f\u039d\u0399\u0391",
            "\u0393\u03a1\u0391\u03a6\u0395\u0399\u0391 \u0395\u03a5\u03a1\u0395\u03a3\u0395\u03a9\u03a3 \u039d\u0391\u03a5\u03a4\u0399\u039a\u0397\u03a3 \u0395\u03a1\u0393\u0391\u03a3\u0399\u0391\u03a3",
            "\u0391\u03a1\u03a4\u039f\u03a0\u039f\u0399\u0395\u0399\u0391",
            "\u03a6\u039f\u03a1\u039f\u039b\u039f\u0393\u0399\u0391 \u039a\u03a5\u039a\u039b\u039f\u03a5 \u0395\u03a1\u0393\u0391\u03a3\u0399\u03a9\u039d",
            "\u03a3\u03a5\u039d\u0391\u039b\u039b\u0391\u0393\u039c\u0391\u03a4\u0399\u039a\u0397 \u039a\u0391\u0399 \u0393\u03a1\u0391\u039c\u039c\u0391\u03a4\u0399\u039f \u03a3\u0395 \u0394\u0399\u0391\u03a4\u0391\u0393\u0397",
            "\u03a0\u0395\u03a1\u0399\u03a6\u0395\u03a1\u0395\u0399\u0391\u039a\u0395\u03a3 \u03a5\u03a0\u0397\u03a1\u0395\u03a3\u0399\u0395\u03a3 \u03a5\u03a0\u039f\u03a5\u03a1\u0393\u0395\u0399\u039f\u03a5 \u039c\u0395\u03a4\u0391\u03a6\u039f\u03a1\u03a9\u039d \u039a\u0391\u0399 \u0395\u03a0\u0399\u039a\u039f\u0399\u039d\u03a9\u039d\u0399\u03a9\u039d",
            "\u0395\u039b\u039b\u0397\u039d\u0399\u039a\u039f\u03a3 \u039f\u03a1\u0393\u0391\u039d\u0399\u03a3\u039c\u039f\u03a3 \u03a4\u039f\u03a5\u03a1\u0399\u03a3\u039c\u039f\u03a5",
            "\u03a0\u03a1\u039f\u03a3\u03a4\u0391\u03a3\u0399\u0391 \u03a4\u03a1\u0391\u03a5\u039c\u0391\u03a4\u0399\u03a9\u039d, \u0391\u0399\u03a7\u039c\u0391\u039b\u03a9\u03a4\u03a9\u039d \u039a\u0391\u0399 \u0391\u039c\u0391\u03a7\u039f\u03a5 \u03a0\u039b\u0397\u0398\u03a5\u03a3\u039c\u039f\u03a5",
            "\u039a\u0391\u039d\u039f\u039d\u0399\u03a3\u039c\u039f\u03a3 \u039b\u0395\u0399\u03a4\u039f\u03a5\u03a1\u0393\u0399\u0391\u03a3 \u03a4.\u0395.\u0392.\u0395",
            "\u03a3\u03a4\u0395\u0393\u0391\u03a3\u0397 \u0391\u039d\u0391\u03a0\u0397\u03a1\u03a9\u039d \u03a0\u039f\u039b\u0395\u039c\u039f\u03a5",
            "\u0391\u0398\u039b\u0397\u03a4\u0399\u03a3\u039c\u039f\u03a3 \u039a\u0391\u0399 \u03a8\u03a5\u03a7\u0391\u0393\u03a9\u0393\u0399\u0391 \u03a0. \u039d\u0391\u03a5\u03a4\u0399\u039a\u039f\u03a5",
            "\u0391\u039d\u0395\u039b\u039a\u03a5\u03a3\u03a4\u0397\u03a1\u0395\u03a3 - \u0391\u039d\u03a5\u03a8\u03a9\u03a4\u0399\u039a\u0391 \u039c\u0395\u03a3\u0391 \u039a\u0391\u0399 \u039c\u0397\u03a7\u0391\u039d\u0397\u039c\u0391\u03a4\u0391",
            "\u03a3\u03a5\u039d\u03a4\u0391\u039e\u0395\u0399\u03a3 \u03a0\u039b\u0397\u03a1\u03a9\u039c\u0391\u03a4\u03a9\u039d \u0395\u03a0\u0399\u03a4\u0391\u039a\u03a4\u03a9\u039d \u03a0\u039b\u039f\u0399\u03a9\u039d",
            "\u0394\u0399\u039a\u0391\u0399\u03a9\u039c\u0391\u03a4\u0391 \u03a5\u03a0\u0395\u03a1\u0397\u039c\u0395\u03a1\u0399\u0391\u03a3",
            "\u039a\u03a9\u0394\u0399\u039a\u0391\u03a3 \u03a0\u039f\u039b\u0395\u039c\u0399\u039a\u03a9\u039d \u03a3\u03a5\u039d\u03a4\u0391\u039e\u0395\u03a9\u039d",
            "\u039a\u0391\u03a0\u039d\u039f\u03a3",
            "\u03a0\u03a1\u039f\u03a3\u03a4\u0391\u03a3\u0399\u0391 \u03a3\u0395\u0399\u03a3\u039c\u039f\u03a0\u039b\u0397\u039a\u03a4\u03a9\u039d",
            "\u0391\u03a0\u039f\u03a3\u03a4\u03a1\u0391\u03a4\u0395\u0399\u0395\u03a3 \u039a\u0391\u0399 \u0391\u03a0\u039f\u039a\u0391\u03a4\u0391\u03a3\u03a4\u0391\u03a3\u0395\u0399\u03a3",
            "\u03a0\u03a1\u039f\u03a3\u03a9\u03a0\u0399\u039a\u039f \u0395\u03a0\u0391\u0393\u0393\u0395\u039b\u039c\u0391\u03a4\u0399\u039a\u03a9\u039d \u03a3\u03a7\u039f\u039b\u03a9\u039d",
            "\u0394\u0399\u0395\u0398\u039d\u0395\u0399\u03a3 \u03a3\u03a5\u039c\u0392\u0391\u03a3\u0395\u0399\u03a3 \u0393\u0399\u0391 \u03a4\u0397\u039d \u03a0\u03a1\u039f\u03a3\u03a4\u0391\u03a3\u0399\u0391 \u03a4\u03a9\u039d \u0395\u03a1\u0393\u0391\u0396\u039f\u039c\u0395\u039d\u03a9\u039d \u0391\u039d\u0397\u039b\u0399\u039a\u03a9\u039d",
            "\u039a\u0395\u039d\u03a4\u03a1\u0399\u039a\u0397 \u0391\u0393\u039f\u03a1\u0391 \u0391\u0398\u0397\u039d\u03a9\u039d",
            "\u0395\u039d\u0399\u03a3\u03a7\u03a5\u03a3\u0397 \u0395\u039b\u0391\u0399\u039f\u03a0\u0391\u03a1\u0391\u0393\u03a9\u0393\u0397\u03a3",
            "\u0391\u039d\u039f\u0399\u039a\u03a4\u0391 \u03a3\u03a9\u03a6\u03a1\u039f\u039d\u0399\u03a3\u03a4\u0399\u039a\u0391 \u039a\u0391\u03a4\u0391\u03a3\u03a4\u0397\u039c\u0391\u03a4\u0391",
            "\u03a6\u0399\u039b\u0391\u039d\u0398\u03a1\u03a9\u03a0\u0399\u039a\u0391 \u0399\u0394\u03a1\u03a5\u039c\u0391\u03a4\u0391 \u0396\u0391\u039a\u03a5\u039d\u0398\u039f\u03a5",
            "\u0394\u0399\u0391\u03a6\u039f\u03a1\u0391 \u0395\u0399\u0394\u0397 \u03a4\u03a1\u039f\u03a6\u0399\u039c\u03a9\u039d, \u03a0\u039f\u03a4\u03a9\u039d & \u0391\u039d\u03a4\u0399\u039a\u0395\u0399\u039c\u0395\u039d\u03a9\u039d",
            "\u03a6\u039f\u03a1\u039f\u039b\u039f\u0393\u0399\u0391 \u0395\u03a0\u0399\u03a7\u0395\u0399\u03a1\u0397\u03a3\u0395\u03a9\u039d \u03a4\u03a5\u03a0\u039f\u03a5",
            "\u03a0\u0395\u03a1\u0399\u039f\u03a1\u0399\u03a3\u039c\u039f\u0399 \u0395\u0399\u03a3\u0391\u0393\u03a9\u0393\u0397\u03a3",
            "\u03a0\u03a1\u039f\u03a3\u03a9\u03a1\u0399\u039d\u0397 \u0395\u0399\u03a3\u0394\u039f\u03a7\u0397 \u0395\u039c\u03a0\u039f\u03a1\u0395\u03a5\u039c\u0391\u03a4\u03a9\u039d",
            "\u0391\u03a1\u03a7\u0395\u0399\u039f",
            "\u0394\u0399\u03a5\u039b\u0399\u03a3\u03a4\u0397\u03a1\u0399\u0391 \u03a0\u0395\u03a4\u03a1\u0395\u039b\u0391\u0399\u039f\u03a5",
            "\u0395\u0399\u03a3\u0391\u0393\u03a9\u0393\u0397 \u03a0\u0391\u0399\u0394\u0391\u0393\u03a9\u0393\u0399\u039a\u039f\u03a5 \u03a5\u039b\u0399\u039a\u039f\u03a5",
            "\u0395\u03a0\u0399\u0398\u0395\u03a9\u03a1\u0397\u03a3\u0397 \u039a\u039b\u0397\u03a1\u039f\u0394\u039f\u03a4\u0397\u039c\u0391\u03a4\u03a9\u039d",
            "\u03a3\u0399\u0394\u0397\u03a1\u039f\u0394\u03a1\u039f\u039c\u039f\u0399 \u0392\u039f\u03a1\u0395\u0399\u039f\u0394\u03a5\u03a4\u0399\u039a\u0397\u03a3 \u0395\u039b\u039b\u0391\u0394\u039f\u03a3",
            "\u03a4\u0391\u039c\u0395\u0399\u039f \u0395\u03a0\u0399\u039a\u039f\u03a5\u03a1\u0399\u039a\u0397\u03a3 \u0391\u03a3\u03a6\u0391\u039b\u0399\u03a3\u0395\u03a9\u03a3 \u0395\u03a1\u0393\u0391\u03a4\u039f\u03a4\u0395\u03a7\u039d\u0399\u03a4\u03a9\u039d \u0394\u039f\u039c\u0399\u039a\u03a9\u039d \u039a\u0391\u0399 \u039e\u03a5\u039b\u039f\u03a5\u03a1\u0393\u0399\u039a\u03a9\u039d \u0395\u03a1\u0393\u0391\u03a3\u0399\u03a9\u039d (\u03a4.\u0395.\u0391.\u0395.\u0394.\u039e.\u0395.)",
            "\u03a4\u0391\u039c\u0395\u0399\u0391 \u03a0\u03a1\u039f\u039d\u039f\u0399\u0391\u03a3 \u03a3\u03a4\u0399\u03a3 \u03a0\u03a1\u0395\u03a3\u0392\u0395\u0399\u0395\u03a3",
            "\u039f\u0399\u039a\u039f\u0393\u0395\u039d\u0395\u0399\u0391\u039a\u039f\u03a3 \u03a0\u03a1\u039f\u0393\u03a1\u0391\u039c\u039c\u0391\u03a4\u0399\u03a3\u039c\u039f\u03a3 - \u03a5\u0393\u0395\u0399\u0391 \u03a0\u0391\u0399\u0394\u0399\u039f\u03a5",
            "\u0391\u03a1\u03a7\u0399\u0395\u03a1\u0395\u0399\u03a3",
            "\u03a3\u03a5\u039c\u0392\u039f\u03a5\u039b\u0399\u0391 \u03a5\u03a0\u039f\u03a5\u03a1\u0393\u0395\u0399\u039f\u03a5 \u0394\u0399\u039a\u0391\u0399\u039f\u03a3\u03a5\u039d\u0397\u03a3",
            "\u039d\u039f\u03a3\u039f\u039a\u039f\u039c\u0395\u0399\u0391\u039a\u0397 \u03a0\u0395\u03a1\u0399\u0398\u0391\u039b\u03a8\u0397",
            "\u039a\u0391\u03a4\u0391\u03a3\u03a4\u0397\u039c\u0391\u03a4\u0391 \u03a0\u03a9\u039b\u0397\u03a3\u0395\u03a9\u03a3 \u039f\u0399\u039d\u039f\u03a0\u039d\u0395\u03a5\u039c\u0391\u03a4\u03a9\u0394\u03a9\u039d \u03a0\u039f\u03a4\u03a9\u039d \u039a\u0391\u0399 \u039a\u0395\u039d\u03a4\u03a1\u0391 \u0394\u0399\u0391\u03a3\u039a\u0395\u0394\u0391\u03a3\u0395\u03a9\u03a3",
            "\u03a0\u03a1\u03a9\u03a4\u0395\u03a5\u039f\u03a5\u03a3\u0391",
            "\u03a0\u039f\u039b\u03a5\u03a4\u0395\u03a7\u039d\u0395\u0399\u039f \u039a\u03a1\u0397\u03a4\u0397\u03a3",
            "\u03a4\u0391\u039c\u0395\u0399\u039f \u0395\u03a0\u0399\u039a\u039f\u03a5\u03a1\u0399\u039a\u0397\u03a3 \u0391\u03a3\u03a6\u0391\u039b\u0399\u03a3\u0395\u03a9\u03a3 \u03a0\u03a1\u039f\u03a3\u03a9\u03a0\u0399\u039a\u039f\u03a5 \u0395\u03a4\u0391\u0399\u03a1\u0395\u0399\u03a9\u039d \u03a4\u03a3\u0399\u039c\u0395\u039d\u03a4\u03a9\u039d (\u03a4.\u0395.\u0391.\u03a0.\u0395.\u03a4.)",
            "\u0395\u039b\u039b\u0397\u039d\u0399\u039a\u039f\u03a3 \u03a4\u0391\u03a0\u0397\u03a4\u039f\u03a5\u03a1\u0393\u0399\u039a\u039f\u03a3 \u039f\u03a1\u0393\u0391\u039d\u0399\u03a3\u039c\u039f\u03a3",
            "\u0395\u03a6\u0391\u03a1\u039c\u039f\u0393\u0397 \u0394\u0397\u039c\u039f\u03a3\u0399\u039f\u03a5\u03a0\u0391\u039b\u039b\u0397\u039b\u0399\u039a\u039f\u03a5 \u039a\u03a9\u0394\u0399\u039a\u0391",
            "\u0397\u039b\u0395\u039a\u03a4\u03a1\u039f\u039b\u039f\u0393\u0399\u039a\u039f \u0395\u03a1\u0393\u0391\u03a3\u03a4\u0397\u03a1\u0399\u039f",
            "\u03a4\u0391\u039c\u0395\u0399\u039f \u03a3\u03a5\u039d\u03a4\u0391\u039e\u0395\u03a9\u039d \u039c\u0397\u03a7\u0391\u039d\u0399\u039a\u03a9\u039d \u039a\u0391\u0399 \u0395\u03a1\u0393\u039f\u039b\u0397\u03a0\u03a4\u03a9\u039d",
            "\u039c\u0395\u03a3\u0399\u03a4\u0395\u03a3 \u0391\u03a3\u03a4\u0399\u039a\u03a9\u039d \u03a3\u03a5\u039c\u0392\u0391\u03a3\u0395\u03a9\u039d",
            "\u03a0\u039b\u03a9\u03a4\u0395\u03a3 \u0394\u0395\u039e\u0391\u039c\u0395\u039d\u0395\u03a3",
            "\u039a\u0391\u039d\u039f\u039d\u0399\u03a3\u039c\u039f\u0399 \u03a6\u039f\u03a1\u03a4\u03a9\u03a3\u0395\u03a9\u039d",
            "\u0395\u0399\u0394\u0399\u039a\u0391 \u0395\u03a0\u0399\u0394\u039f\u039c\u0391\u03a4\u0391",
            "\u03a0\u039f\u0399\u039d\u0399\u039a\u039f\u03a3 \u039a\u03a9\u0394\u0399\u039a\u0391\u03a3",
            "\u0395\u0399\u0394\u0399\u039a\u039f\u03a3 \u039b\u039f\u0393\u0391\u03a1\u0399\u0391\u03a3\u039c\u039f\u03a3 \u03a0\u03a1\u039f\u039d\u039f\u0399\u0391\u03a3 (\u03a4.\u03a3.\u0395.\u03a5.\u03a0.)",
            "\u0395\u0398\u039d\u0399\u039a\u0397 \u0391\u039d\u03a4\u0399\u03a3\u03a4\u0391\u03a3\u0397",
            "\u039f\u03a1\u0393\u0391\u039d\u0399\u03a3\u039c\u039f\u03a3 \u0392\u0399\u039f\u039c\u0397\u03a7\u0391\u039d\u0399\u039a\u0397\u03a3 \u0391\u039d\u0391\u03a0\u03a4\u03a5\u039e\u0397\u03a3",
            "\u0395\u03a1\u0393\u0391 \u039a\u039f\u0399\u039d\u0397\u03a3 \u03a5\u03a0\u039f\u0394\u039f\u039c\u0397\u03a3",
            "\u0394\u0399\u0395\u03a5\u0398\u03a5\u039d\u03a3\u0397 T\u0395\u039b\u03a9\u039d\u0395\u0399\u03a9\u039d \u03a0\u0395\u0399\u03a1\u0391\u0399\u0391",
            "\u0399\u0391\u03a4\u03a1\u0399\u039a\u0397 \u03a3\u03a7\u039f\u039b\u0397 \u0399\u03a9\u0391\u039d\u039d\u0399\u039d\u03a9\u039d",
            "\u0396\u03a9\u039f\u039a\u039b\u039f\u03a0\u0397 \u039a\u0391\u0399 \u0396\u03a9\u039f\u039a\u03a4\u039f\u039d\u0399\u0391",
            "\u03a1\u03a5\u0398\u039c\u0399\u03a3\u0399\u03a3 \u039a\u0399\u039d\u0397\u03a3\u0395\u03a9\u03a3 \u0395\u039d \u039f\u0394\u039f\u0399\u03a3",
            "\u0395\u03a4\u0391\u0399\u03a1\u0395\u0399\u0395\u03a3 \u03a0\u03a1\u039f\u03a3\u03a4\u0391\u03a3\u0399\u0391\u03a3 \u039a\u03a1\u0391\u03a4\u039f\u03a5\u039c\u0395\u039d\u03a9\u039d - \u0391\u03a0\u039f\u03a6\u03a5\u039b\u0391\u039a\u0399\u0396\u039f\u039c\u0395\u039d\u03a9\u039d",
            "\u0394\u0391\u03a3\u0399\u039a\u0397 \u0394\u0399\u0395\u03a5\u0398\u0395\u03a4\u0397\u03a3\u0397 \u03a7\u0395\u0399\u039c\u0391\u03a1\u03a1\u03a9\u039d",
            "\u03a3\u03a5\u039d\u039f\u03a1\u0399\u0391\u039a\u039f\u0399 \u03a6\u03a5\u039b\u0391\u039a\u0395\u03a3",
            "\u03a3\u03a7\u039f\u039b\u0397 \u0398\u0395\u03a4\u0399\u039a\u03a9\u039d \u0395\u03a0\u0399\u03a3\u03a4\u0397\u039c\u03a9\u039d \u03a0\u0391\u039d\u039c\u0399\u039f\u03a5 \u0399\u03a9\u0391\u039d\u039d\u0399\u039d\u03a9\u039d",
            "\u0395\u039a\u03a0\u0391\u0399\u0394\u0395\u03a5\u03a3\u0397 \u03a0.\u039d\u0391\u03a5\u03a4\u0399\u039a\u039f\u03a5",
            "\u0394\u0399\u039a\u0391\u0399\u039f\u03a3\u03a4\u0391\u03a3\u0399\u039f \u0395\u03a0\u0399\u03a3\u03a4\u03a1\u0391\u03a4\u0395\u03a5\u03a3\u0395\u03a9\u03a3 1974",
            "\u03a1\u0391\u0394\u0399\u039f\u03a4\u0397\u039b\u0395\u0393\u03a1\u0391\u03a6\u0399\u039a\u0397 \u039a\u0391\u0399 \u03a1\u0391\u0394\u0399\u039f\u03a4\u0397\u039b\u0395\u03a6\u03a9\u039d\u0399\u039a\u0397 \u03a5\u03a0\u0397\u03a1\u0395\u03a3\u0399\u0391",
            "\u03a6\u0391\u03a1\u039c\u0391\u039a\u0391-\u0399\u0394\u0399\u039f\u03a3\u039a\u0395\u03a5\u0391\u03a3\u039c\u0391\u03a4\u0391",
            "\u03a3\u03a5\u039d\u03a4\u0395\u039b\u0395\u03a3\u03a4\u0395\u03a3 \u039a\u0395\u03a1\u0394\u039f\u03a5\u03a3 \u0395\u03a0\u0391\u0393\u0393\u0395\u039b\u039c\u0391\u03a4\u0399\u03a9\u039d",
            "\u0395\u0398\u039d\u0399\u039a\u039f \u039a\u0395\u039d\u03a4\u03a1\u039f \u039a\u039f\u0399\u039d\u03a9\u039d\u0399\u039a\u03a9\u039d \u0395\u03a1\u0395\u03a5\u039d\u03a9\u039d",
            "\u039a\u0395\u03a6\u0391\u039b\u0391\u0399\u039f \u039d\u0391\u03a5\u03a4\u0399\u039a\u0397\u03a3 \u0395\u039a\u03a0\u0391\u0399\u0394\u0395\u03a5\u03a3\u0395\u03a9\u03a3",
            "\u0395\u0399\u03a3\u03a0\u03a1\u0391\u039e\u0397 \u0395\u03a3\u039f\u0394\u03a9\u039d \u03a0\u0391\u03a1\u0395\u039b\u0398\u039f\u03a5\u03a3\u03a9\u039d \u03a7\u03a1\u0397\u03a3\u0395\u03a9\u039d",
            "\u039f\u03a1\u0393\u0391\u039d\u0399\u03a3\u039c\u039f\u03a3 \u0397\u039d\u03a9\u039c\u0395\u039d\u03a9\u039d \u0395\u0398\u039d\u03a9\u039d",
            "\u03a3\u0395\u0399\u03a3\u039c\u039f\u03a0\u039b\u0397\u039a\u03a4\u039f\u0399 \u039d\u0397\u03a3\u039f\u03a5 \u0398\u0397\u03a1\u0391\u03a3",
            "\u039a\u0395\u039d\u03a4\u03a1\u0399\u039a\u0397 \u0391\u0393\u039f\u03a1\u0391 \u0398\u0395\u03a3\u03a3\u0391\u039b\u039f\u039d\u0399\u039a\u0397\u03a3",
            "\u0394\u0399\u0391\u03a6\u0398\u039f\u03a1\u0391 \u0391\u039b\u039b\u039f\u0394\u0391\u03a0\u03a9\u039d \u0394\u0397\u039c\u039f\u03a3\u0399\u03a9\u039d \u039b\u0395\u0399\u03a4\u039f\u03a5\u03a1\u0393\u03a9\u039d",
            "\u0393\u0395\u03a9\u03a0\u039f\u039d\u0399\u039a\u039f \u03a0\u0391\u039d\u0395\u03a0\u0399\u03a3\u03a4\u0397\u039c\u0399\u039f \u0391\u0398\u0397\u039d\u03a9\u039d",
            "\u039a\u0391\u039d\u039f\u039d\u0399\u03a3\u039c\u039f\u03a3 \u03a3\u03a4\u03a1\u0391\u03a4\u039f\u0394\u0399\u039a\u0395\u0399\u03a9\u039d",
            "\u0394\u0399\u0391\u03a6\u039f\u03a1\u0395\u03a3 \u03a5\u0393\u0395\u0399\u039f\u039d\u039f\u039c\u0399\u039a\u0395\u03a3 \u03a3\u03a5\u039c\u0392\u0391\u03a3\u0395\u0399\u03a3",
            "\u03a4\u039f\u03a5\u03a1\u0399\u03a3\u03a4\u0399\u039a\u0391 \u039b\u0395\u03a9\u03a6\u039f\u03a1\u0395\u0399\u0391",
            "\u0394\u0391\u039d\u0395\u0399\u0391 \u0391\u03a0\u039f \u0395\u039a\u0394\u039f\u03a4\u0399\u039a\u0395\u03a3 \u03a4\u03a1\u0391\u03a0\u0395\u0396\u0395\u03a3",
            "\u0395\u03a0\u0399\u0398\u0391\u039b\u0391\u03a3\u03a3\u0399\u0391 \u0391\u03a1\u03a9\u0393\u0397 - \u03a1\u03a5\u039c\u039f\u03a5\u039b\u039a\u0397\u03a3\u0397 \u03a0\u039b\u039f\u0399\u03a9\u039d",
            "\u03a0\u03a1\u039f\u03a3\u03a4\u0391\u03a3\u0399\u0391 \u03a4\u039f\u03a5 \u039a\u0391\u0398\u0395\u03a3\u03a4\u03a9\u03a4\u039f\u03a3",
            "\u03a3\u03a5\u039c\u0392\u0391\u03a3\u0395\u0399\u03a3 \u03a0\u0395\u03a1\u0399 \u03a5\u039b\u0399\u039a\u039f\u03a5 \u0395\u03a5\u0397\u039c\u0395\u03a1\u0399\u0391\u03a3 \u039d\u0391\u03a5\u03a4\u0399\u039b\u039b\u039f\u039c\u0395\u039d\u03a9\u039d",
            "\u039c\u0395\u03a3\u0399\u03a4\u0395\u03a3 \u0395\u0393\u03a7\u03a9\u03a1\u0399\u03a9\u039d \u03a0\u03a1\u039f\u0399\u039f\u039d\u03a4\u03a9\u039d",
            "\u039a\u03a1\u0391\u03a4\u0399\u039a\u0397 \u039f\u03a1\u03a7\u0397\u03a3\u03a4\u03a1\u0391 \u0391\u0398\u0397\u039d\u03a9\u039d",
            "\u03a4\u039c\u0397\u039c\u0391\u03a4\u0391 \u039c\u039f\u03a5\u03a3\u0399\u039a\u03a9\u039d - \u0398\u0395\u0391\u03a4\u03a1\u0399\u039a\u03a9\u039d \u03a3\u03a0\u039f\u03a5\u0394\u03a9\u039d \u039a\u0391\u0399 \u0395\u03a0\u0399\u039a\u039f\u0399\u039d\u03a9\u039d\u0399\u0391\u03a3 - \u039c\u0395\u03a3\u03a9\u039d \u039c\u0391\u0396\u0399\u039a\u0397\u03a3 \u0395\u039d\u0397\u039c\u0395\u03a1\u03a9\u03a3\u0397\u03a3",
            "\u03a0\u0395\u0399\u0398\u0391\u03a1\u03a7\u0399\u039a\u0397 \u0395\u039e\u039f\u03a5\u03a3\u0399\u0391 \u039b\u0399\u039c\u0395\u039d\u0399\u039a\u03a9\u039d \u0391\u03a1\u03a7\u03a9\u039d",
            "\u0399\u039d\u03a3\u03a4\u0399\u03a4\u039f\u03a5\u03a4\u039f \u0391\u039c\u03a5\u039d\u03a4\u0399\u039a\u03a9\u039d \u0391\u039d\u0391\u039b\u03a5\u03a3\u0395\u03a9\u039d (\u0399.\u0391.\u0391.)",
            "\u0399\u0394\u0399\u03a9\u03a4\u0399\u039a\u039f\u0399 \u03a3\u03a4\u0391\u0398\u039c\u039f\u0399 \u0391\u03a3\u03a5\u03a1\u039c\u0391\u03a4\u039f\u03a5 - \u03a7\u03a1\u0397\u03a3\u0397 \u03a1\u0391\u0394\u0399\u039f\u03a3\u03a5\u03a7\u039d\u039f\u03a4\u0397\u03a4\u03a9\u039d",
            "\u0391\u039d\u0391\u0393\u039d\u03a9\u03a1\u0399\u03a3\u0397 \u039e\u0395\u039d\u03a9\u039d \u039a\u0391\u03a4\u0391\u039c\u0395\u03a4\u03a1\u0397\u03a3\u0395\u03a9\u039d",
            "\u0393\u0395\u039d\u039f\u039a\u03a4\u039f\u039d\u0399\u0391",
            "\u0395\u03a0\u0395\u039e\u0395\u03a1\u0393\u0391\u03a3\u0399\u0391 \u039a\u0391\u03a0\u039d\u039f\u03a5",
            "\u03a3\u03a5\u039c\u0392\u039f\u03a5\u039b\u0399\u039f \u0395\u03a0\u0399\u039a\u03a1\u0391\u03a4\u0395\u0399\u0391\u03a3",
            "\u0399\u0391\u03a4\u03a1\u039f\u0399 \u0399.\u039a.\u0391",
            "\u03a5\u03a0\u039f\u0398\u0397\u039a\u0397",
            "\u0391\u03a1\u039c\u039f\u0394\u0399\u039f\u03a4\u0397\u03a4\u0391 \u039b\u0399\u039c\u0395\u039d\u0399\u039a\u039f\u03a5 \u03a3\u03a9\u039c\u0391\u03a4\u039f\u03a3",
            "\u0395\u0399\u03a3\u0391\u0393\u03a9\u0393\u0395\u03a3 \u0393\u0399\u0391 \u0395\u039a\u0398\u0395\u03a3\u0395\u0399\u03a3, \u03a3\u03a5\u039d\u0395\u0394\u03a1\u0399\u0391 \u039a\u039b\u03a0",
            "\u0395\u03a5\u03a1\u03a9\u03a0\u0391\u0399\u039a\u0397 \u03a4\u03a1\u0391\u03a0\u0395\u0396\u0391 \u0391\u039d\u0391\u03a3\u03a5\u0393\u039a\u03a1\u039f\u03a4\u0397\u03a3\u0397-\u0391\u039d\u0391\u03a0\u03a4\u03a5\u039e\u0397",
            "\u0391\u0395\u03a1\u039f\u0394\u03a1\u039f\u039c\u0399\u039f \u03a3\u03a0\u0391\u03a4\u03a9\u039d",
            "\u03a4\u039c\u0397\u039c\u0391 \u0394\u0397\u039c\u039f\u03a3\u0399\u039f\u0393\u03a1\u0391\u03a6\u0399\u0391\u03a3 - \u039c\u0395\u03a3\u03a9\u039d \u039c\u0391\u0396\u0399\u039a\u0397\u03a3 \u0395\u03a0\u0399\u039a\u039f\u0399\u039d\u03a9\u039d\u0399\u0391\u03a3",
            "\u03a4\u039f\u039a\u039f\u03a3",
            "\u0395\u039d\u0399\u03a3\u03a7\u03a5\u03a3\u0397 \u03a0\u039f\u039b\u0395\u039c\u039f\u03a0\u0391\u0398\u03a9\u039d \u039a\u039b\u03a0. \u0391\u0393\u03a1\u039f\u03a4\u03a9\u039d",
            "\u0395\u039e\u039f\u0394\u0391 \u039a\u0397\u0394\u0395\u0399\u0391\u03a3 \u03a3\u03a4\u03a1\u0391\u03a4\u0399\u03a9\u03a4\u0399\u039a\u03a9\u039d",
            "\u03a0\u0391\u03a1\u039f\u03a7\u0395\u03a3 \u03a5\u03a0\u0391\u039b\u039b\u0397\u039b\u03a9\u039d",
            "\u03a0\u03a1\u039f\u03a3\u03a4\u0391\u03a3\u0399\u0391 \u03a3\u0399\u03a4\u039f\u03a0\u0391\u03a1\u0391\u0393\u03a9\u0393\u0397\u03a3",
            "\u0391\u03a3\u03a6\u0391\u039b\u0399\u03a3\u0397 \u039f.\u0393.\u0391 \u0391\u03a0\u039f \u0391\u039d\u0395\u039c\u039f\u0398\u03a5\u0395\u039b\u039b\u0391 \u039a\u0391\u0399 \u03a0\u039b\u0397\u039c\u039c\u03a5\u03a1\u0391",
            "\u0394\u0399\u0395\u03a5\u0398\u03a5\u039d\u03a3\u0397 \u039a\u0391\u03a4\u0391\u03a3\u039a\u0395\u03a5\u03a9\u039d \u039a\u0391\u0399 \u0395\u039e\u039f\u03a0\u039b\u0399\u03a3\u039c\u039f\u03a5",
            "\u03a4\u0395\u039b\u03a9\u039d\u0395\u0399\u0391\u039a\u039f\u0399 \u03a5\u03a0\u039f\u039b\u039f\u0393\u039f\u0399",
            "\u0393\u0395\u039d\u0399\u039a\u0397 \u0393\u03a1\u0391\u039c\u039c\u0391\u03a4\u0395\u0399\u0391 \u0391\u0398\u039b\u0397\u03a4\u0399\u03a3\u039c\u039f\u03a5",
            "\u03a3\u03a5\u039d\u03a4\u0391\u039e\u0395\u0399\u03a3",
            "\u0391\u0394\u0395\u0399\u0395\u03a3 \u03a0\u03a1\u039f\u03a3\u03a9\u03a0\u0399\u039a\u039f\u03a5 \u039b.\u03a3",
            "\u03a3\u03a5\u039d\u03a4\u0391\u039e\u0395\u0399\u03a3 \u03a3\u03a4\u03a1\u0391\u03a4\u0399\u03a9\u03a4\u0399\u039a\u03a9\u039d \u03a0\u0391\u0398\u039f\u039d\u03a4\u03a9\u039d \u03a3\u03a4\u0397\u039d",
            "\u0391\u03a3\u03a6\u0391\u039b\u0399\u03a3\u0397 \u0395\u03a0\u0399\u0392\u0391\u03a4\u03a9\u039d",
            "\u0391\u03a0\u0391\u039b\u039b\u039f\u03a4\u03a1\u0399\u03a9\u03a3\u0397 \u0391\u039a\u0399\u039d\u0397\u03a4\u03a9\u039d",
            "\u03a3\u03a7\u039f\u039b\u0397 \u0395\u03a0\u0399\u03a3\u03a4\u0397\u039c\u03a9\u039d \u03a5\u0393\u0395\u0399\u0391\u03a3",
            "\u0395\u039d\u039f\u0399\u039a\u0399\u039f\u03a3\u03a4\u0391\u03a3\u0399\u039f \u0392\u039f\u03a3\u039a\u03a9\u039d",
            "\u03a4\u0391\u039c\u0395\u0399\u039f \u03a3\u03a5\u039d\u03a4\u0391\u039e\u0395\u03a9\u039d \u0397\u0398\u039f\u03a0\u039f\u0399\u03a9\u039d - \u03a3\u03a5\u0393\u0393\u03a1\u0391\u03a6\u0395\u03a9\u039d \u03a4\u0395\u03a7\u039d\u0399\u039a\u03a9\u039d \u0398\u0395\u0391\u03a4\u03a1\u039f\u03a5",
            "\u0395\u03a5\u03a1\u03a9\u03a0\u0391\u0399\u039a\u039f \u0395\u039d\u03a4\u0391\u039b\u039c\u0391 \u03a3\u03a5\u039b\u039b\u0397\u03a8\u0397\u03a3",
            "\u0391\u039d\u03a4\u0399\u039a\u0395\u0399\u039c\u0395\u039d\u0391 \u0394\u0395\u0394\u0397\u039b\u03a9\u039c\u0395\u039d\u0397\u03a3 \u0391\u039e\u0399\u0391\u03a3  \u0391\u039d\u03a4\u0399\u039a\u0391\u03a4\u0391\u0392\u039f\u039b\u0395\u03a3",
            "\u0393\u0395\u039d\u0399\u039a\u0397 \u0394\u0399\u0395\u03a5\u0398\u03a5\u039d\u03a3\u0397 \u039c\u0395\u03a4\u0391\u03a6\u039f\u03a1\u03a9\u039d",
            "\u039f\u03a1\u0393\u0391\u039d\u0399\u03a3\u039c\u039f\u03a3 \u03a5\u03a0\u039f\u03a5\u03a1\u0393\u0395\u0399\u039f\u03a5 \u0394\u0399\u039a\u0391\u0399\u039f\u03a3\u03a5\u039d\u0397\u03a3",
            "\u0395\u03a5\u0398\u03a5\u039d\u0397 \u03a5\u03a0\u039f\u03a5\u03a1\u0393\u03a9\u039d",
            "\u03a4\u039c\u0397\u039c\u0391 \u039a\u03a4\u0397\u039d\u0399\u0391\u03a4\u03a1\u0399\u039a\u0397\u03a3",
            "\u0394\u0399\u039a\u0391\u03a3\u03a4\u0399\u039a\u039f \u03a3\u03a9\u039c\u0391 \u0395\u039d\u039f\u03a0\u039b\u03a9\u039d \u0394\u03a5\u039d\u0391\u039c\u0395\u03a9\u039d",
            "\u0395\u039d\u039f\u03a1\u0399\u0391\u039a\u039f\u0399 \u039d\u0391\u039f\u0399 \u039a\u0391\u0399 \u0395\u03a6\u0397\u039c\u0395\u03a1\u0399\u039f\u0399",
            "\u03a5\u0393\u0395\u0399\u039f\u039d\u039f\u039c\u0399\u039a\u0395\u03a3 \u0395\u03a0\u0399\u03a4\u03a1\u039f\u03a0\u0395\u03a3 \u039d\u0391\u03a5\u03a4\u0399\u039a\u039f\u03a5",
            "\u03a4\u0391\u039c\u0395\u0399\u039f \u0395\u03a0\u0399\u039a\u039f\u03a5\u03a1\u0399\u039a\u0397\u03a3 \u0391\u03a3\u03a6\u0391\u039b\u0399\u03a3\u0395\u03a9\u03a3 \u039a\u0391\u0399 \u03a0\u03a1\u039f\u039d\u039f\u0399\u0391\u03a3 \u03a0\u03a1\u039f\u03a3\u03a9\u03a0\u0399\u039a\u039f\u03a5 \u0395\u039b\u039b\u0397\u039d\u0399\u039a\u0397\u03a3 \u03a1\u0391\u03a1\u0399\u039f\u03a6\u03a9\u039d\u0399\u0391\u03a3-\u03a4\u0397\u039b\u0395\u039f\u03a1\u0391\u03a3\u0395\u03a9\u03a3-\u03a4\u039f\u03a5\u03a1\u0399\u03a3\u039c\u039f\u03a5 (\u03a4.\u0395.\u0391.\u03a0.\u03a0. \u0395.\u03a1.\u03a4. \u03a4.)",
            "\u03a3\u03a4\u03a1\u0391\u03a4\u0399\u03a9\u03a4\u0399\u039a\u0397 \u0392\u039f\u0397\u0398\u0395\u0399\u0391 \u0397.\u03a0.\u0391",
            "\u03a3\u03a5\u039d\u03a4\u0391\u039e\u0395\u0399\u03a3 \u03a0\u03a1\u039f\u03a3\u03a9\u03a0\u0399\u039a\u039f\u03a5",
            "\u03a7\u03a1\u0397\u039c\u0391\u03a4\u0399\u039a\u0397 \u0394\u0399\u0391\u03a7\u0395\u0399\u03a1\u0399\u03a3\u0397 \u03a0. \u039d\u0391\u03a5\u03a4\u0399\u039a\u039f\u03a5",
            "\u03a0\u039f\u039b\u0399\u03a4\u0399\u039a\u039f \u0393\u03a1\u0391\u03a6\u0395\u0399\u039f \u03a0\u03a1\u03a9\u0398\u03a5\u03a0\u039f\u03a5\u03a1\u0393\u039f\u03a5",
            "\u039b\u039f\u03a5\u03a4\u03a1\u039f\u0398\u0395\u03a1\u0391\u03a0\u0395\u0399\u0391 \u039a\u0391\u0399 \u0391\u0395\u03a1\u039f\u0398\u0395\u03a1\u0391\u03a0\u0395\u0399\u0391",
            "\u03a3\u03a5\u039c\u0392\u039f\u03a5\u039b\u0399\u039f \u039a\u039f\u0399\u039d\u03a9\u039d\u0399\u039a\u03a9\u039d \u0391\u03a3\u03a6\u0391\u039b\u0399\u03a3\u0395\u03a9\u039d",
            "\u0395\u039d\u03a4\u039f\u039a\u0391 \u0393\u03a1\u0391\u039c\u039c\u0391\u03a4\u0399\u0391",
            "\u03a3\u03a9\u03a6\u03a1\u039f\u039d\u0399\u03a3\u03a4\u0399\u039a\u039f\u03a3 \u039a\u03a9\u0394\u0399\u039a\u0391\u03a3",
            "\u0394\u0397\u039c\u039f\u03a4\u0399\u039a\u0395\u03a3 \u0395\u03a0\u0399\u03a7\u0395\u0399\u03a1\u0397\u03a3\u0395\u0399\u03a3",
            "\u039a\u03a9\u0394\u0399\u039a\u0391\u03a3 \u03a0\u039f\u039b\u0399\u03a4\u0399\u039a\u0397\u03a3 \u0394\u0399\u039a\u039f\u039d\u039f\u039c\u0399\u0391\u03a3 - \u039d\u0395\u039f\u03a3",
            "\u03a4\u0391\u039c\u0395\u0399\u039f \u0395\u03a0\u0399\u039a\u039f\u03a5\u03a1\u0399\u039a\u0397\u03a3 \u0391\u03a3\u03a6\u0391\u039b\u0399\u03a3\u0395\u03a9\u03a3 \u03a5\u03a0\u0391\u039b\u039b\u0397\u039b\u03a9\u039d \u039a\u039f\u03a5\u03a1\u0395\u0399\u03a9\u039d \u039a\u0391\u0399 \u039a\u039f\u039c\u039c\u03a9\u03a4\u0397\u03a1\u0399\u03a9\u039d",
            "\u03a0\u03a1\u039f\u03a3\u03a9\u03a0\u0399\u039a\u039f \u03a3\u0399\u0394\u0397\u03a1\u039f\u0394\u03a1\u039f\u039c\u03a9\u039d- \u039f.\u03a3.\u0395.- \u03a3\u0399\u0394\u0397\u03a1\u039f\u0394\u03a1\u039f\u039c\u0399\u039a\u03a9\u039d \u0395\u03a0\u0399\u03a7\u0395\u0399\u03a1\u0397\u03a3\u0395\u03a9\u039d",
            "\u0394\u0399\u0391\u03a6\u039f\u03a1\u039f\u0399 \u039d\u039f\u039c\u039f\u0399 \u0393\u0399\u0391 \u03a4\u039f\u039d \u03a4\u03a5\u03a0\u039f",
            "\u03a4\u0391\u03a7\u03a5\u0394\u03a1\u039f\u039c\u0399\u039a\u0391 \u0394\u0395\u039b\u03a4\u0391\u03a1\u0399\u0391",
            "\u03a4\u0391\u039c\u0395\u0399\u039f \u0391\u03a3\u03a6\u0391\u039b\u0399\u03a3\u0395\u03a9\u03a3 \u03a0\u03a1\u039f\u03a3\u03a9\u03a0\u0399\u039a\u039f\u03a5 \u0397\u039b\u0395\u039a\u03a4\u03a1. \u0395\u03a4. \u0391\u0398\u0397\u039d\u03a9\u039d - \u03a0\u0395\u0399\u03a1\u0391\u0399\u03a9\u03a3 \u039a\u0391\u0399 \u0395\u039b\u039b\u0397\u039d. \u0397\u039b\u0395\u039a\u03a4\u03a1. \u0395\u03a4\u0391\u0399\u03a1\u0399\u0391\u03a3 (\u03a4.\u0391.\u03a0  \u0397.\u0395.\u0391.\u03a0.- \u0395.\u0397.\u0395.)",
            "\u03a4\u0391\u039c\u0395\u0399\u039f \u0395\u03a0\u0399\u039a\u039f\u03a5\u03a1\u0399\u039a\u0397\u03a3 \u0391\u03a3\u03a6\u0391\u039b\u0399\u03a3\u0397\u03a3 \u0391\u03a1\u03a4\u039f\u03a0\u039f\u0399\u03a9\u039d",
            "\u0394\u0397\u039c\u039f\u03a4\u0399\u039a\u039f\u0399 \u039a\u0391\u0399 \u039a\u039f\u0399\u039d\u039f\u03a4\u0399\u039a\u039f\u0399 \u0391\u03a1\u03a7\u039f\u039d\u03a4\u0395\u03a3",
            "\u039c\u0395\u03a4\u0391\u03a6\u039f\u03a1\u0391 \u03a4\u0391\u03a7\u03a5\u0394\u03a1\u039f\u039c\u0395\u0399\u039f\u03a5",
            "\u039a\u0391\u039d\u039f\u039d\u0399\u03a3\u039c\u039f\u03a3 \u03a0\u0391\u03a1\u039f\u03a7\u03a9\u039d \u03a4\u0391\u039c\u0395\u0399\u039f\u03a5 \u0395\u03a0\u0399\u039a\u039f\u03a5\u03a1\u0399\u039a\u0397\u03a3 \u0391\u03a3\u03a6\u0391\u039b\u0399\u03a3\u0395\u03a9\u03a3 \u0391\u03a3\u03a6\u0391\u039b\u0399\u03a3\u03a4\u03a9\u039d \u039a\u0391\u0399 \u03a0\u03a1\u039f\u03a3\u03a9\u03a0\u0399\u039a\u039f\u03a5 \u0391\u03a3\u03a6\u0391\u039b\u0399\u03a3\u03a4\u0399\u039a\u03a9\u039d \u0395\u03a0\u0399\u03a7\u0395\u0399\u03a1\u0397\u03a3\u0395\u03a9\u039d (\u03a4.\u0395.\u0391.\u0391.\u03a0.\u0391.\u0395.)",
            "\u03a0\u03a1\u039f\u03a3\u03a9\u03a0\u0399\u039a\u039f",
            "\u0394\u0397\u039c\u039f\u03a3\u0399\u0391 \u0395\u03a0\u0399\u03a7\u0395\u0399\u03a1\u0397\u03a3\u0397 \u0397\u039b\u0395\u039a\u03a4\u03a1\u0399\u03a3\u039c\u039f\u03a5",
            "\u039a\u0391\u039d\u039f\u039d\u0399\u03a3\u039c\u039f\u0399 \u0395\u03a1\u0393\u03a9\u039d \u03a9\u03a0\u039b\u0399\u03a3\u039c\u0395\u039d\u039f\u03a5 \u03a3\u039a\u03a5\u03a1\u039f\u0394\u0395\u039c\u0391\u03a4\u039f\u03a3",
            "\u0391\u039b\u0395\u03a5\u03a1\u0391-\u0391\u03a1\u03a4\u039f\u03a3",
            "\u03a4\u0395\u039b\u0397 \u03a0\u03a1\u039f\u03a3\u039f\u03a1\u039c\u0399\u03a3\u0395\u03a9\u03a3, \u03a0\u0391\u03a1\u0391\u0392\u039f\u039b\u0397\u03a3 \u039a\u0391\u0399 \u03a0\u0391\u03a1\u039f\u03a0\u039b\u0399\u03a3\u039c\u039f\u03a5",
            "\u0399\u0394\u0399\u03a9\u03a4\u0399\u039a\u0391 \u0395\u039a\u03a0\u0391\u0399\u0394\u0395\u03a5\u03a4\u0397\u03a1\u0399\u0391 \u03a6\u03a1\u039f\u039d\u03a4\u0399\u03a3\u03a4\u0397\u03a1\u0399\u0391",
            "\u0391\u03a1\u03a7\u0391\u0399\u039f\u039b\u039f\u0393\u0399\u039a\u0397 \u03a5\u03a0\u0397\u03a1\u0395\u03a3\u0399\u0391",
            "\u03a4\u0391\u039c\u0395\u0399\u039f \u0391\u03a3\u03a6\u0391\u039b\u0399\u03a3\u0395\u03a9\u03a3 \u03a4\u03a5\u03a0\u039f\u0393\u03a1\u0391\u03a6\u03a9\u039d \u039a\u0391\u0399 \u039c\u0399\u03a3\u0398\u03a9\u03a4\u03a9\u039d \u0393\u03a1\u0391\u03a6\u0399\u039a\u03a9\u039d \u03a4\u0395\u03a7\u039d\u03a9\u039d (\u03a4.\u0391.\u03a4. & \u039c.\u0393.\u03a4)",
            "\u0395\u0399\u0394\u0399\u039a\u0395\u03a3 \u0395\u03a6\u0391\u03a1\u039c\u039f\u0393\u0395\u03a3 \u039a\u03a5\u03a1\u0399\u0391\u039a\u0397\u03a3 \u0391\u03a1\u0393\u0399\u0391\u03a3",
            "\u0394\u0399\u0391\u03a6\u039f\u03a1\u039f\u0399 \u039d\u039f\u039c\u039f\u0399 \u0393\u0399\u0391 \u03a4\u0391 \u03a0\u039b\u0397\u03a1\u03a9\u039c\u0391\u03a4\u0391",
            "\u0391\u03a3\u03a4\u0399\u039a\u0391 \u03a3\u03a7\u039f\u039b\u0395\u0399\u0391",
            "\u03a4\u0391\u039c\u0395\u0399\u0391 \u03a3\u03a5\u039d\u03a4\u0391\u039e\u0395\u03a9\u039d \u0395\u03a6\u0397\u039c\u0395\u03a1\u0399\u0394\u039f\u03a0\u03a9\u039b\u03a9\u039d \u039a\u0391\u0399 \u03a5\u03a0\u0391\u039b\u039b\u0397\u039b\u03a9\u039d \u03a0\u03a1\u0391\u039a\u03a4\u039f\u03a1\u0395\u0399\u03a9\u039d \u0391\u0398\u0397\u039d\u03a9\u039d-\u0398\u0395\u03a3\u039d\u0399\u039a\u0397\u03a3 (\u03a4.\u03a3.\u0395.\u03a5.\u03a0.)",
            "\u0394\u039f\u039c\u0399\u039a\u0391 \u0395\u03a1\u0393\u0391",
            "\u039d\u0391\u03a5\u03a3\u03a4\u0391\u0398\u039c\u039f\u03a3",
            "\u0391\u039d\u03a4\u0399\u0393\u03a1\u0391\u03a6\u0399\u039a\u0391 \u0394\u0399\u039a\u0391\u0399\u03a9\u039c\u0391\u03a4\u0391",
            "\u0395\u03a0\u0399\u0394\u039f\u039c\u0391 \u039f\u0399\u039a\u039f\u0393\u0395\u039d\u0395\u0399\u0391\u039a\u03a9\u039d \u0392\u0391\u03a1\u03a9\u039d",
            "\u0395\u039b\u039b\u0397\u039d\u0399\u039a\u0397-\u0395\u03a5\u03a1\u03a9\u03a0\u0391\u0399\u039a\u0397 \u03a6\u0391\u03a1\u039c\u0391\u039a\u039f\u03a0\u039f\u0399\u0399\u0391",
            "\u0394\u0395\u039b\u03a4\u0399\u0391 \u03a4\u0391\u03a5\u03a4\u039f\u03a4\u0397\u03a4\u039f\u03a3",
            "\u03a3\u03a7\u039f\u039b\u0399\u0391\u03a4\u03a1\u0399\u039a\u0397 \u03a5\u03a0\u0397\u03a1\u0395\u03a3\u0399\u0391",
            "\u03a5\u0394\u03a1\u039f\u0393\u039f\u039d\u0391\u039d\u0398\u03a1\u0391\u039a\u0395\u03a3",
            "\u0393\u0395\u039d\u0399\u039a\u0391 \u03a0\u0395\u03a1\u0399 \u0395\u039a\u0398\u0395\u03a3\u0395\u03a9\u039d",
            "\u03a6\u039f\u03a1\u039f\u039b\u039f\u0393\u0399\u039a\u0395\u03a3 \u0394\u0399\u0395\u03a5\u039a\u039f\u039b\u03a5\u039d\u03a3\u0395\u0399\u03a3",
            "\u039b\u03a3\u039c\u039f\u03a3 \u03a0\u03a1\u039f\u039d\u039f\u0399\u0391\u03a3 \u03a0\u03a1\u039f\u03a3\u03a9\u03a0\u0399\u039a\u039f\u03a5 \u0399.\u039a.\u0391",
            "\u0395\u039b\u0395\u0393\u03a7\u039f\u03a3 \u039a\u03a4\u0399\u03a1\u0399\u0391\u039a\u03a9\u039d \u0395\u03a1\u0393\u03a9\u039d",
            "\u03a4\u0391\u039c\u0395\u0399\u039f \u0395\u03a0\u0399\u039a\u039f\u03a5\u03a1\u0399\u039a\u0397\u03a3 \u0391\u03a3\u03a6\u0391\u039b\u0399\u03a3\u0397\u03a3",
            "\u0395\u039b\u0391\u0399\u039f\u03a0\u03a5\u03a1\u0397\u039d\u0395\u03a3",
            "\u0395\u039c\u03a6\u03a5\u03a4\u0395\u03a5\u03a4\u0399\u039a\u0391 \u039a\u03a4\u0397\u039c\u0391\u03a4\u0391",
            "\u03a4\u039f\u03a5\u03a1\u0399\u03a3\u03a4\u0399\u039a\u0395\u03a3 \u03a3\u03a5\u039c\u0392\u0391\u03a3\u0395\u0399\u03a3",
            "\u039a\u039b\u0391\u0394\u039f\u03a3 \u0391\u03a3\u03a6\u0391\u039b\u0399\u03a3\u0395\u03a9\u03a3 \u03a4\u0395\u03a7\u039d\u0399\u039a\u03a9\u039d \u03a4\u03a5\u03a0\u039f\u03a5 \u0398\u0395\u03a3\u03a3\u0391\u039b\u039f\u039d\u0399\u039a\u0397\u03a3 (\u039a.\u0391.\u03a4.\u03a4.\u0398.)",
            "\u039c\u0395\u03a4\u0395\u03a9\u03a1\u039f\u039b\u039f\u0393\u0399\u039a\u0397 \u03a5\u03a0\u0397\u03a1\u0395\u03a3\u0399\u0391",
            "\u0391\u0393\u03a1\u039f\u03a4\u0399\u039a\u039f\u03a3 \u039a\u03a9\u0394\u0399\u039a\u0391\u03a3",
            "\u03a4\u0395\u03a7\u039d\u0399\u039a\u039f \u0395\u03a0\u0399\u039c\u0395\u039b\u0397\u03a4\u0397\u03a1\u0399\u039f",
            "\u0395\u039b\u0395\u0393\u03a7\u039f\u03a3 \u039d\u039f\u039c\u0399\u039c\u039f\u03a6\u03a1\u039f\u03a3\u03a5\u039d\u0397\u03a3",
            "\u0391\u03a1\u03a7\u0391\u0399\u039f\u039b\u039f\u0393\u0399\u039a\u0397 \u0395\u03a4\u0391\u0399\u03a1\u0399\u0391",
            "\u03a3\u03a7\u039f\u039b\u0391\u0396\u039f\u03a5\u03a3\u0395\u03a3 \u039a\u039b\u0397\u03a1\u039f\u039d\u039f\u039c\u0399\u0395\u03a3",
            "\u0393\u0395\u03a6\u03a5\u03a1\u0391 \u03a1\u0399\u039f\u03a5 - \u0391\u039d\u03a4\u0399\u03a1\u03a1\u0399\u039f\u03a5",
            "\u03a6\u039f\u0399\u03a4\u0397\u03a3\u0397, \u0395\u039e\u0395\u03a4\u0391\u03a3\u0395\u0399\u03a3 \u039a\u039b\u03a0",
            "\u03a4\u03a5\u03a7\u0395\u03a1\u0391, \u039c\u0399\u039a\u03a4\u0391 \u039a\u0391\u0399 \u03a4\u0395\u03a7\u039d\u0399\u039a\u0391 \u03a0\u0391\u0399\u0393\u039d\u0399\u0391",
            "\u039f\u03a1\u0393\u0391\u039d\u0399\u039a\u039f\u0399 \u0391\u03a1\u0399\u0398\u039c\u039f\u0399 \u03a5\u03a0\u0391\u039e\u0399\u03a9\u039c\u0391\u03a4\u0399\u039a\u03a9\u039d",
            "\u03a6\u039f\u03a1\u039f\u039b\u039f\u0393\u0399\u0391 \u039a\u0399\u039d\u0397\u03a4\u0397\u03a3 \u039a\u0391\u0399 \u0391\u039a\u0399\u039d\u0397\u03a4\u0397\u03a3 \u03a0\u0395\u03a1\u0399\u039f\u03a5\u03a3\u0399\u0391\u03a3",
            "\u0391\u03a4\u0395\u039b\u0395\u0399\u0395\u03a3 \u0391\u0393\u0399\u039f\u03a5 \u039f\u03a1\u039f\u03a5\u03a3",
            "\u039c\u039f\u039d\u039f\u03a0\u03a9\u039b\u0399\u039f \u0391\u039b\u0391\u03a4\u0399\u039f\u03a5",
            "\u0391\u03a3\u03a6\u0391\u039b\u0399\u03a3\u0397 \u0395\u039b\u039b\u0397\u039d\u03a9\u039d \u0395\u039e\u03a9\u03a4\u0395\u03a1\u0399\u039a\u039f\u03a5",
            "\u0394\u0399\u0395\u0398\u039d\u0395\u03a3 \u039a\u0395\u039d\u03a4\u03a1\u039f \u0391\u039d\u03a9\u03a4\u0391\u03a4\u03a9\u039d",
            "\u0391\u039d\u0391\u03a0\u03a1\u039f\u03a3\u0391\u03a1\u039c\u039f\u0393\u0395\u03a3 \u03a3\u03a5\u039d\u03a4\u0391\u039e\u0395\u03a9\u039d",
            "\u0393\u0395\u039d\u0399\u039a\u0395\u03a3 \u0395\u03a0\u0399\u0398\u0395\u03a9\u03a1\u0397\u03a3\u0395\u0399\u03a3-\u0394\u0399\u0395\u03a5\u0398\u03a5\u039d\u03a3\u0395\u0399\u03a3",
            "\u03a3\u03a9\u039c\u0391 \u039f\u03a1\u039a\u03a9\u03a4\u03a9\u039d \u039b\u039f\u0393\u0399\u03a3\u03a4\u03a9\u039d",
            "\u03a3\u0395\u0399\u03a3\u039c\u039f\u03a0\u039b\u0397\u039a\u03a4\u039f\u0399 \u0392\u039f\u03a1\u0395\u0399\u039f\u03a5 \u0395\u039b\u039b\u0391\u0394\u039f\u03a3",
            "\u03a0\u0391\u039d\u0395\u03a0\u0399\u03a3\u03a4\u0397\u039c\u0399\u0391 \u03a0\u0395\u0399\u03a1\u0391\u0399\u03a9\u03a3-\u039c\u0391\u039a\u0395\u0394\u039f\u039d\u0399\u0391\u03a3",
            "\u03a7\u03a9\u03a1\u039f\u03a4\u0391\u039e\u0399\u0391 \u039a\u0391\u0399 \u03a0\u0395\u03a1\u0399\u0392\u0391\u039b\u039b\u039f\u039d",
            "\u0395\u03a3\u03a9\u03a4\u0395\u03a1\u0399\u039a\u039f\u0399 \u039a\u0391\u039d\u039f\u039d\u0399\u03a3\u039c\u039f\u0399 \u0395\u03a1\u0393\u0391\u03a3\u0399\u0391\u03a3",
            "\u0395\u039b\u0395\u0393\u03a7\u039f\u03a3 \u039d\u0391\u03a5\u03a4\u0399\u039a\u03a9\u039d \u0391\u03a4\u03a5\u03a7\u0397\u039c\u0391\u03a4\u03a9\u039d",
            "\u03a0\u039d\u0395\u03a5\u039c\u0391\u03a4\u0399\u039a\u0391 \u039a\u0395\u039d\u03a4\u03a1\u0391",
            "\u03a0\u039b\u039f\u0397\u0393\u0399\u039a\u0391 \u0394\u0399\u039a\u0391\u0399\u03a9\u039c\u0391\u03a4\u0391",
            "\u03a3\u03a4\u03a1\u0391\u03a4\u0395\u03a5\u039f\u039c\u0395\u039d\u039f\u0399 \u0394\u0399\u039a\u0397\u0393\u039f\u03a1\u039f\u0399",
            "\u03a3\u03a5\u03a3\u03a4\u0391\u03a4\u0399\u039a\u0391 \u0391\u03a5\u03a4\u039f\u039a\u0399\u039d\u0397\u03a4\u03a9\u039d",
            "\u03a3\u0399\u0394\u0397\u03a1\u039f\u0394\u03a1\u039f\u039c\u039f\u0399 \u03a0\u0395\u039b\u039f\u03a0\u039f\u039d\u039d\u0397\u03a3\u039f\u03a5",
            "\u03a4\u039c\u0397\u039c\u0391 \u039c\u0395\u0398\u039f\u0394\u039f\u039b\u039f\u0393\u0399\u0391\u03a3, \u0399\u03a3\u03a4\u039f\u03a1\u0399\u0391\u03a3 \u039a\u0391\u0399 \u0398\u0395\u03a9\u03a1\u0399\u0391\u03a3 \u03a4\u0397\u03a3 \u0395\u03a0\u0399\u03a3\u03a4\u0397\u039c\u0397\u03a3",
            "\u0395\u03a5\u03a1\u03a9\u03a0\u0391\u0399\u039a\u039f \u03a0\u039f\u039b\u0399\u03a4\u0399\u03a3\u03a4\u0399\u039a\u039f \u039a\u0395\u039d\u03a4\u03a1\u039f \u0394\u0395\u039b\u03a6\u03a9\u039d",
            "\u03a3\u03a5\u039d\u0395\u03a4\u0391\u0399\u03a1\u0399\u03a3\u039c\u039f\u0399 \u0395\u0393\u0393\u0395\u0399\u03a9\u039d \u0392\u0395\u039b\u03a4\u0399\u03a9\u03a3\u0395\u03a9\u039d",
            "\u03a4\u0391\u039c\u0395\u0399\u039f \u0395\u03a0\u0399\u039a\u039f\u03a5\u03a1\u0399\u039a\u0397\u03a3 \u0391\u03a3\u03a6\u0391\u039b\u0399\u03a3\u0397\u03a3 \u0394\u0397\u039c\u039f\u03a3\u0399\u03a9\u039d \u03a5\u03a0\u0391\u039b\u039b\u0397\u039b\u03a9\u039d (\u03a4.\u0395.\u0391.\u0394.\u03a5.)",
            "\u0399\u0395\u03a1\u039f\u039a\u0397\u03a1\u03a5\u039a\u0395\u03a3",
            "\u0395\u0399\u03a1\u0397\u039d\u039f\u0394\u0399\u039a\u0395\u0399\u0391 - \u03a0\u03a4\u0391\u0399\u03a3\u039c\u0391\u03a4\u039f\u0394\u0399\u039a\u0395\u0399\u0391",
            "\u0391\u0393\u039f\u03a1\u0391\u039d\u039f\u039c\u0399\u039a\u0397 \u039d\u039f\u039c\u039f\u0398\u0395\u03a3\u0399\u0391",
            "\u03a4\u03a1\u0391\u03a0\u0395\u0396\u0399\u03a4\u0399\u039a\u0397 \u0395\u03a0\u0399\u03a4\u0391\u0393\u0397",
            "\u039d\u0391\u03a5\u0391\u0393\u039f\u03a3\u03a9\u03a3\u03a4\u0399\u039a\u0391 \u039a\u0391\u0399 \u03a1\u03a5\u039c\u039f\u03a5\u039b\u039a\u0391",
            "\u03a6\u039f\u03a1\u039f\u039b\u039f\u0393\u0399\u039a\u0395\u03a3 \u0394\u0399\u0391\u03a6\u039f\u03a1\u0395\u03a3\u0399",
            "\u039c\u0395\u03a4\u03a1\u0391 \u039a\u0391\u0399 \u03a3\u03a4\u0391\u0398\u039c\u0391",
            "\u0393\u0395\u039d\u0399\u039a\u039f \u03a7\u0397\u039c\u0395\u0399\u039f \u03a4\u039f\u03a5 \u039a\u03a1\u0391\u03a4\u039f\u03a5\u03a3",
            "\u03a3\u03a5\u039c\u03a6\u03a9\u039d\u0399\u0391 \u0393\u0399\u0391 \u0399\u03a3\u0391 \u039f\u0399\u039a\u039f\u039d\u039f\u039c\u0399\u039a\u0391 \u039a\u039f\u0399\u039d\u03a9\u039d\u0399\u039a\u0391",
            "\u03a3\u03a5\u039d\u039f\u03a1\u0399\u0391\u039a\u039f\u0399 \u03a3\u03a4\u0391\u0398\u039c\u039f\u0399",
            "\u0391\u039e\u0399\u03a9\u039c\u0391\u03a4\u0399\u039a\u039f\u0399 \u03a3\u03a9\u039c\u0391\u03a4\u03a9\u039d \u0391\u03a3\u03a6\u0391\u039b\u0395\u0399\u0391\u03a3",
            "\u03a5\u03a0\u0397\u03a1\u0395\u03a3\u0399\u0391\u039a\u0391 \u03a3\u03a5\u039c\u0392\u039f\u03a5\u039b\u0399\u0391",
            "\u0395\u0399\u03a3\u0391\u0393\u03a9\u0393\u0399\u039a\u039f\u03a3 \u039d\u039f\u039c\u039f\u03a3",
            "\u039a\u03a4\u0397\u039c\u0391\u03a4\u039f\u039b\u039f\u0393\u0399\u039f",
            "\u0395\u03a4\u0391\u0399\u03a1\u0395\u0399\u0391 \u0394\u0399\u0391\u03a7\u0395\u0399\u03a1\u0399\u03a3\u0395\u03a9\u03a3 \u03a5\u03a0\u0395\u0393\u0393\u03a5\u03a9\u039d \u03a0\u03a1\u039f\u03a3\u039f\u0394\u03a9\u039d",
            "\u03a5\u03a0\u039f\u03a5\u03a1\u0393\u0395\u0399\u039f \u039c\u0391\u039a\u0395\u0394\u039f\u039d\u0399\u0391\u03a3 \u2013 \u0398\u03a1\u0391\u039a\u0397\u03a3",
            "\u03a4\u039f\u03a5\u03a1\u0399\u03a3\u03a4\u0399\u039a\u0391 \u0393\u03a1\u0391\u03a6\u0395\u0399\u0391 \u039a\u0391\u0399 \u03a3\u03a9\u039c\u0391\u03a4\u0395\u0399\u0391",
            "\u0394\u0391\u039d\u0395\u0399\u0391 \u0391\u039d\u0391\u03a3\u03a5\u0393\u039a\u03a1\u039f\u03a4\u0397\u03a3\u0397\u03a3",
            "\u0391\u03a3\u03a4\u0399\u039a\u0395\u03a3 \u03a3\u03a5\u0393\u039a\u039f\u0399\u039d\u03a9\u039d\u0399\u0395\u03a3 \u0398\u0395\u03a3\u03a3\u0391\u039b\u039f\u039d\u0399\u039a\u0397\u03a3-\u039f.\u0391.\u03a3.\u0398",
            "\u0395\u0398\u0395\u039b\u039f\u039d\u03a4\u0395\u03a3 \u0391\u0395\u03a1\u039f\u03a0\u039f\u03a1\u0399\u0391\u03a3",
            "\u03a3\u0397\u039c\u0395\u0399\u03a9\u03a4\u0395\u03a3",
            "\u03a4\u0395\u039b\u0397 \u0395\u0393\u039a\u0391\u03a4\u0391\u03a3\u03a4\u0391\u03a3\u0397\u03a3 - \u039b\u0395\u0399\u03a4\u039f\u03a5\u03a1\u0393\u0399\u0391\u03a3 \u039a\u0395\u03a1\u0391\u0399\u03a9\u039d",
            "\u0397.\u03a0.\u0391",
            "\u03a0\u0391\u039d\u0395\u03a0\u0399\u03a3\u03a4\u0397\u039c\u0399\u0391 \u0391\u0399\u0393\u0391\u0399\u039f\u03a5, \u0399\u039f\u039d\u0399\u039f\u03a5 \u039a\u0391\u0399 \u0398\u0395\u03a3\u03a3\u0391\u039b\u0399\u0391\u03a3",
            "\u03a4\u0391\u039c\u0395\u0399\u039f \u03a0\u03a1\u039f\u039d\u039f\u0399\u0391\u03a3 \u039e\u0395\u039d\u039f\u0394\u039f\u03a7\u03a9\u039d",
            "\u03a3\u03a5\u039c\u0392\u039f\u03a5\u039b\u0399\u0391 \u03a3\u03a4\u0395\u0393\u0391\u03a3\u0395\u03a9\u03a3",
            "\u03a4\u0395\u03a7\u039d\u0399\u039a\u0397 \u0395\u039a\u039c\u0395\u03a4\u0391\u039b\u039b\u0395\u03a5\u03a3\u0397 \u0399\u0394\u0399\u03a9\u03a4\u0399\u039a\u03a9\u039d \u0391\u0395\u03a1\u039f\u03a0\u039b\u0391\u039d\u03a9\u039d",
            "\u03a6\u039f\u03a1\u039f\u039b\u039f\u0393\u0399\u0391 \u0394\u0397\u039c\u039f\u03a3\u0399\u03a9\u039d \u0398\u0395\u0391\u039c\u0391\u03a4\u03a9\u039d",
            "\u03a3\u03a4\u03a1\u0391\u03a4\u039f\u039b\u039f\u0393\u0399\u0391 \u039f\u03a0\u039b\u0399\u03a4\u03a9\u039d \u03a7\u03a9\u03a1\u039f\u03a6\u03a5\u039b\u0391\u039a\u0397\u03a3",
            "\u0393\u03a5\u039c\u039d\u0391\u03a3\u0399\u0391 \u0391\u03a1\u0399\u03a3\u03a4\u039f\u03a5\u03a7\u03a9\u039d",
            "\u03a3\u03a7\u039f\u039b\u0399\u039a\u0397 \u0391\u039d\u03a4\u0399\u039b\u0397\u03a8\u0397",
            "\u0395\u03a5\u0398\u03a5\u039d\u0397 \u03a3\u03a4\u03a1\u0391\u03a4\u0399\u03a9\u03a4\u0399\u039a\u03a9\u039d",
            "\u03a3\u03a4\u0391\u0398\u039c\u039f\u0399 \u0395\u03a0\u0399\u0392\u0397\u03a4\u039f\u03a1\u03a9\u039d",
            "\u0392\u0395\u0392\u0391\u0399\u03a9\u03a3\u0397 \u03a0\u03a4\u0391\u0399\u03a3\u039c\u0391\u03a4\u03a9\u039d \u0391\u03a0\u039f",
            "\u0394\u0399\u0391\u0396\u03a5\u0393\u0399\u039f",
            "\u0394\u0399\u0395\u0398\u039d\u0397\u03a3 \u03a3\u03a5\u039c\u0392\u0391\u03a3\u0397 \u03a0\u0395\u03a1\u0399 \u0391\u039d\u0391\u0393\u039a\u0391\u03a3\u03a4\u0399\u039a\u0397\u03a3 \u0395\u03a1\u0393\u0391\u03a3\u0399\u0391\u03a3",
            "\u0394\u0399\u0395\u03a5\u039a\u039f\u039b\u03a5\u039d\u03a3\u0397 \u0394\u0399\u0395\u0398\u039d\u039f\u03a5\u03a3 \u039d\u0391\u03a5\u03a4\u0399\u039b\u0399\u0391\u039a\u0397\u03a3 \u039a\u0399\u039d\u0397\u03a3\u0395\u03a9\u03a3",
            "\u0395\u039d\u039f\u0399\u039a\u0399\u039f\u03a3\u03a4\u0391\u03a3\u0399\u039f",
            "\u0395\u039a\u0398\u0395\u03a3\u0395\u0399\u03a3 \u0396\u0391\u03a0\u03a0\u0395\u0399\u039f\u03a5 \u039c\u0395\u0393\u0391\u03a1\u039f\u03a5",
            "\u0394\u0399\u0391\u03a7\u0395\u0399\u03a1\u0399\u03a3\u0397 \u03a5\u039b\u0399\u039a\u039f\u03a5 \u03a0. \u039d\u0391\u03a5\u03a4\u0399\u039a\u039f\u03a5",
            "\u0395\u03a6\u0395\u0394\u03a1\u0399\u039a\u0391 \u03a4\u0391\u039c\u0395\u0399\u0391 \u039a\u03a1\u0397\u03a4\u0397\u03a3",
            "\u03a3\u0399\u03a4\u0391\u03a1\u0399",
            "\u03a6\u039f\u03a1\u03a4\u0397\u0393\u0391 501-4500 \u03a4\u039f\u039d\u039d\u03a9\u039d",
            "\u03a4\u03a1\u0391\u03a0\u0395\u0396\u0391 \u0395\u03a1\u0393\u0391\u03a3\u0399\u0391\u03a3",
            "\u0391\u03a4\u0395\u039b\u0395\u0399\u0395\u03a3 \u03a5\u03a0\u0395\u03a1 \u03a4\u0397\u03a3 \u0393\u0395\u03a9\u03a1\u0393\u0399\u0391\u03a3",
            "\u0391\u0399\u0393\u0399\u0391\u039b\u039f\u03a3 \u039a\u0391\u0399 \u03a0\u0391\u03a1\u0391\u039b\u0399\u0391",
            "\u0394\u0391\u03a3\u0397 \u0399\u0394\u03a1\u03a5\u039c\u0391\u03a4\u03a9\u039d",
            "\u0399\u03a7\u0398\u03a5\u039f\u03a4\u03a1\u039f\u03a6\u0395\u0399\u0391",
            "\u0391\u03a0\u039f\u0393\u03a1\u0391\u03a6\u0395\u03a3 \u03a0. \u039d\u0391\u03a5\u03a4\u0399\u039a\u039f\u03a5",
            "\u03a3\u0397\u039c\u0391\u03a4\u0391 \u039a\u0391\u0399 \u0394\u0395\u039b\u03a4\u0399\u0391 \u0391\u039d\u0391\u03a0\u0397\u03a1\u03a9\u039d \u03a0\u039f\u039b\u0395\u039c\u039f\u03a5",
            "\u03a0\u0395\u0399\u0398\u0391\u03a1\u03a7\u0399\u039a\u039f \u0394\u0399\u039a\u0391\u0399\u039f \u0391\u03a3\u03a4\u03a5\u039d\u039f\u039c\u0399\u039a\u039f\u03a5 \u03a0\u03a1\u039f\u03a3\u03a9\u03a0\u0399\u039a\u039f\u03a5 \u0395\u039b\u039b\u0397\u039d\u0399\u039a\u0397\u03a3 \u0391\u03a3\u03a4\u03a5\u039d\u039f\u039c\u0399\u0391\u03a3",
            "\u0391\u03a4\u039c\u039f\u039b\u0395\u0392\u0397\u03a4\u0395\u03a3",
            "\u03a4\u0391\u03a7\u03a5\u0394\u03a1\u039f\u039c\u0399\u039a\u0397 \u03a5\u03a0\u0397\u03a1\u0395\u03a3\u0399\u0391 \u03a3\u03a4\u03a1\u0391\u03a4\u039f\u03a5",
            "\u03a0\u03a1\u039f\u03a3\u03a4\u0391\u03a3\u0399\u0391 \u03a0\u0399\u039d\u0391\u039a\u0399\u0394\u03a9\u039d",
            "\u0391\u0393\u03a1\u039f\u03a4\u0399\u039a\u0391 \u039a\u03a4\u0397\u039d\u0399\u0391\u03a4\u03a1\u0395\u0399\u0391",
            "\u03a7\u03a1\u0397\u039c\u0391\u03a4\u0399\u03a3\u03a4\u0397\u03a1\u0399\u0391\u039a\u0391 \u0394\u0399\u039a\u0391\u03a3\u03a4\u0397\u03a1\u0399\u0391",
            "\u0395\u0393\u0393\u03a1\u0391\u03a6\u0397 \u03a0\u03a1\u039f\u0395\u03a1\u03a7\u039f\u039c\u0395\u039d\u03a9\u039d \u0391\u03a0\u039f \u03a4\u0397\u039d \u0391\u039b\u039b\u039f\u0394\u0391\u03a0\u0397",
            "\u039f\u03a1\u0393\u0391\u039d\u0399\u03a3\u039c\u039f\u03a3 \u0394\u0399\u0391\u03a7\u0395\u0399\u03a1\u0399\u03a3\u0397\u03a3 \u0394\u0397\u039c\u039f\u03a3\u0399\u039f\u03a5 \u03a5\u039b\u0399\u039a\u039f\u03a5",
            "\u03a0\u0391\u039d\u0395\u03a0\u0399\u03a3\u03a4\u0397\u039c\u0399\u039f \u039a\u03a5\u03a0\u03a1\u039f\u03a5",
            "\u039a\u0391\u03a4\u0395\u03a1\u0393\u0391\u03a3\u0399\u0391 \u039e\u0397\u03a1\u0391\u03a3 \u03a3\u03a4\u0391\u03a6\u0399\u0394\u0391\u03a3",
            "\u03a4\u0395\u039b\u03a9\u039d\u0395\u0399\u0391\u039a\u0397 \u0394\u0399\u0391\u0399\u03a1\u0395\u03a3\u0397",
            "\u0391\u0396\u0397\u03a4\u0397\u03a4\u0391",
            "\u039c\u0395\u039b\u0399\u03a3\u03a3\u039f\u03a4\u03a1\u039f\u03a6\u0399\u0391",
            "\u0394\u0399\u0395\u03a5\u0398\u03a5\u039d\u03a3\u0397 \u0398\u0391\u039b\u0391\u03a3\u03a3\u0399\u03a9\u039d \u039a\u03a1\u0391\u03a4\u0399\u039a\u03a9\u039d \u039c\u0395\u03a4\u0391\u03a6\u039f\u03a1\u03a9\u039d",
            "\u0395\u039a\u039c\u0395\u03a4\u0391\u039b\u039b\u0395\u03a5\u03a3\u0397 \u039c\u0395\u03a4\u0391\u039b\u039b\u0395\u0399\u03a9\u039d \u039c\u0395 \u0395\u0393\u0393\u03a5\u0397\u03a3\u0397",
            "\u0399\u0394\u0399\u03a9\u03a4\u0399\u039a\u0395\u03a3 \u0395\u03a0\u0391\u0393\u0393\u0395\u039b\u039c\u0391\u03a4\u0399\u039a\u0395\u03a3 \u03a3\u03a7\u039f\u039b\u0395\u03a3",
            "\u0394\u0399\u0391\u0398\u0395\u03a3\u0397 \u0391\u03a7\u03a1\u0397\u03a3\u03a4\u039f\u03a5 \u03a5\u039b\u0399\u039a\u039f\u03a5",
            "\u03a4\u0391\u03a7\u03a5\u0394\u03a1\u039f\u039c\u0399\u039a\u0395\u03a3 \u039c\u0395\u03a4\u0391\u03a6\u039f\u03a1\u0395\u03a3",
            "\u0395\u03a1\u03a5\u0398\u03a1\u039f \u03a0\u0399\u03a0\u0395\u03a1\u0399",
            "\u03a0\u0399\u039a\u03a0\u0391-\u0395\u039f\u03a0-\u039a\u0395\u039d\u03a4\u03a1\u039f \u0392\u03a1\u0395\u03a6\u03a9\u039d \u0397 \u039c\u0397\u03a4\u0395\u03a1\u0391-\u0395\u039b\u0395\u03a0\u0391\u03a0",
            "\u03a3\u03a5\u039c\u039c\u0395\u03a4\u039f\u03a7\u0397 \u03a3\u0395 \u03a3\u03a5\u039c\u0392\u039f\u03a5\u039b\u0399\u0391",
            "\u0393\u03a5\u039c\u039d\u0391\u03a3\u03a4\u0397\u03a1\u0399\u039f",
            "\u0399\u0391\u03a4\u03a1\u0399\u039a\u039f\u0399- \u039f\u0394\u039f\u039d\u03a4\u0399\u0391\u03a4\u03a1\u0399\u039a\u039f\u0399 \u03a3\u03a5\u039b\u039b\u039f\u0393\u039f\u0399",
            "\u0395\u0399\u03a3\u0391\u0393\u03a9\u0393\u0397 \u03a6\u039f\u0399\u03a4\u0397\u03a4\u03a9\u039d",
            "\u0395\u039b\u039b\u0397\u039d\u0399\u039a\u039f \u0384\u0399\u0394\u03a1\u03a5\u039c\u0391 \u03a0\u039f\u039b\u0399\u03a4\u0399\u03a3\u039c\u039f\u03a5",
            "\u039b\u039f\u0399\u039c\u039f\u039a\u0391\u0398\u0391\u03a1\u03a4\u0397\u03a1\u0399\u0391 \u0396\u03a9\u03a9\u039d",
            "\u0394\u0399\u0395\u0398\u039d\u0397\u03a3 \u039f\u03a1\u0393\u0391\u039d\u0399\u03a3\u039c\u039f\u03a3 \u0391\u03a4\u039f\u039c\u0399\u039a\u0397\u03a3 \u0395\u039d\u0395\u03a1\u0393\u0395\u0399\u0391\u03a3",
            "\u03a4\u0391\u039c\u0395\u0399\u039f \u0395\u039e\u039f\u0394\u039f\u03a5 \u039a\u0391\u0399 \u0395\u03a0\u0399\u039a\u039f\u03a5\u03a1\u0399\u039a\u0397\u03a3 \u0391\u03a3\u03a6\u0391\u039b\u0399\u03a3\u0395\u03a9\u03a3 \u039c\u0399\u03a3\u0398\u03a9\u03a4\u03a9\u039d \u0392\u0399\u039f\u039c\u0397\u03a7\u0391\u039d\u0399\u0391\u03a3 \u039a\u0391\u03a0\u039d\u039f\u03a5",
            "\u039a\u0391\u0398\u0397\u0393\u0397\u03a4\u0395\u03a3 \u0395.\u039c.\u03a0",
            "\u039f\u0399\u039a\u039f\u039d\u039f\u039c\u0399\u039a\u0397 \u0394\u0399\u039f\u0399\u039a\u0397\u03a3\u0397",
            "\u0392\u0395\u0392\u0391\u0399\u03a9\u03a3\u0397 \u03a6\u039f\u03a1\u039f\u039b\u039f\u0393\u0399\u0391\u03a3 \u039a\u0391\u0398\u0391\u03a1\u0391\u03a3 \u03a0\u03a1\u039f\u03a3\u039f\u0394\u039f\u03a5",
            "\u03a4\u0391\u039c\u0395\u0399\u039f \u03a3\u03a5\u039d\u03a4\u0391\u039e\u0395\u03a9\u039d \u03a0\u03a1\u039f\u03a3\u03a9\u03a0\u0399\u039a\u039f\u03a5 \u03a4\u03a1\u0391\u03a0\u0395\u0396\u03a9\u039d \u0395\u039b\u039b\u0391\u0394\u039f\u03a3 \u039a\u0391\u0399 \u039a\u03a4\u0397\u039c\u0391\u03a4\u0399\u039a\u0397\u03a3",
            "\u0394\u0397\u039c\u039f\u03a8\u0397\u03a6\u0399\u03a3\u039c\u0391\u03a4\u0391",
            "\u0395\u039b\u039b\u0397\u039d\u0399\u039a\u039f \u0391\u039d\u039f\u0399\u039a\u03a4\u039f \u03a0\u0391\u039d\u0395\u03a0\u0399\u03a3\u03a4\u0397\u039c\u0399\u039f",
            "\u039a\u0391\u039b\u039b\u0399\u03a4\u0395\u03a7\u039d\u0399\u039a\u039f \u0395\u03a0\u0391\u0393\u0393\u0395\u039b\u039c\u0391\u03a4\u0399\u039a\u039f \u0395\u03a0\u0399\u039c\u0395\u039b\u0397\u03a4\u0397\u03a1\u0399\u039f",
            "\u0391\u039d\u039f\u0399\u039a\u039f\u0394\u039f\u039c\u0397\u03a3\u0399\u03a3",
            "\u0394\u0391\u03a3\u0399\u039a\u039f\u03a3 \u039a\u03a9\u0394\u0399\u039a\u0391\u03a3",
            "\u039a\u0391\u039d\u039f\u039d\u0399\u03a3\u039c\u039f\u03a3 \u03a0\u03a5\u03a1\u039f\u03a3\u0392\u0395\u03a3\u03a4\u0399\u039a\u03a9\u039d \u039c\u0395\u03a3\u03a9\u039d \u03a4\u03a9\u039d \u03a0\u039b\u039f\u0399\u03a9\u039d",
            "\u0394\u0399\u03a6\u0398\u0395\u03a1\u0399\u03a4\u0399\u0394\u0391",
            "\u0392\u0399\u0392\u039b\u0399\u0391 \u039a\u0391\u0399 \u03a6\u039f\u03a1\u039f\u039b\u039f\u0393\u0399\u039a\u0391 \u03a3\u03a4\u039f\u0399\u03a7\u0395\u0399\u0391",
            "\u0395\u039b\u0395\u0393\u03a7\u039f\u03a3 \u0395\u039e\u0391\u0393\u039f\u039c\u0395\u039d\u03a9\u039d \u0395\u039b\u0391\u0399\u03a9\u039d",
            "\u0395\u03a0\u0399\u0394\u039f\u039c\u0391\u03a4\u0391 \u039f\u0399\u039a\u039f\u0393\u0395\u039d\u0395\u0399\u03a9\u039d \u03a3\u03a4\u03a1\u0391\u03a4\u0399\u03a9\u03a4\u0399\u039a\u03a9\u039d",
            "\u0395\u03a5\u03a1\u03a9\u03a0\u0391\u0399\u039a\u0395\u03a3 \u03a3\u03a5\u039c\u03a6\u03a9\u039d\u0399\u0395\u03a3 \u03a0\u039f\u03a5 \u0391\u03a6\u039f\u03a1\u039f\u03a5\u039d \u03a4\u0397\u039d \u03a4\u0397\u039b\u0395\u039f\u03a1\u0391\u03a3\u0397",
            "\u0395\u039a\u03a4\u0391\u039a\u03a4\u0391 \u03a3\u03a4\u03a1\u0391\u03a4\u039f\u0394\u0399\u039a\u0395\u0399\u0391",
            "\u03a0\u039f\u039b\u0395\u039c\u0399\u039a\u0397 \u0392\u0399\u039f\u039c\u0397\u03a7\u0391\u039d\u0399\u0391",
            "\u0391\u03a3\u0395\u039c\u039d\u039f\u0399 \u0393\u03a5\u039d\u0391\u0399\u039a\u0395\u03a3",
            "\u0391\u03a0\u0395\u039b\u0395\u03a5\u0398\u0395\u03a1\u03a9\u03a3\u0397 \u0391\u0393\u039f\u03a1\u0391\u03a3 \u0397\u039b\u0395\u039a\u03a4\u03a1\u0399\u039a\u0397\u03a3 \u0395\u039d\u0395\u03a1\u0393\u0395\u0399\u0391\u03a3 \u0395\u039d\u0395\u03a1\u0393\u0395\u0399\u0391\u039a\u0397 \u03a0\u039f\u039b\u0399\u03a4\u0399\u039a\u0397 \u03a1.\u0391.\u0395",
            "\u03a0\u03a1\u039f\u0395\u0399\u03a3\u03a0\u03a1\u0391\u039e\u0397 \u0394\u0399\u039a\u0397\u0393\u039f\u03a1\u0399\u039a\u0397\u03a3 \u0391\u039c\u039f\u0399\u0392\u0397\u03a3",
            "\u0395\u0398\u039d\u0399\u039a\u0397 \u03a3\u03a7\u039f\u039b\u0397 \u0394\u0397\u039c\u039f\u03a3\u0399\u0391\u03a3 \u03a5\u0393\u0395\u0399\u0391\u03a3 (\u0395.\u03a3.\u0394.\u03a5.)",
            "\u03a0\u03a1\u039f\u039c\u0397\u0398\u0395\u0399\u0391 \u0398\u0395\u0399\u039f\u03a5 \u039a\u0391\u0399 \u0398\u0395\u0399\u0399\u039a\u039f\u03a5 \u03a7\u0391\u039b\u039a\u039f\u03a5",
            "\u03a7\u0397\u039c\u0399\u039a\u039f\u0399 - \u03a7\u0397\u039c\u0399\u039a\u0395\u03a3 \u0392\u0399\u039f\u039c\u0397\u03a7\u0391\u039d\u0399\u0395\u03a3",
            "\u0391\u03a3\u03a6\u0391\u039b\u0399\u03a3\u0397 \u039a\u0391\u03a4\u0391 \u03a4\u0397\u03a3 \u0391\u03a3\u0398\u0395\u039d\u0395\u0399\u0391\u03a3",
            "\u03a4\u0391\u039c\u0395\u0399\u039f \u0391\u039b\u039b\u0397\u039b\u039f\u0392\u039f\u0397\u0398\u0395\u0399\u0391\u03a3 \u03a0\u03a1\u039f\u03a3\u03a9\u03a0\u0399\u039a\u039f\u03a5 \u0395\u0398\u039d\u0399\u039a\u039f\u03a5 \u03a4\u03a5\u03a0\u039f\u0393\u03a1\u0391\u03a6\u0395\u0399\u039f\u03a5 (\u03a4.\u0391.\u03a0.\u0395.\u03a4.)",
            "\u039f\u03a1\u0393\u0391\u039d\u0399\u03a3\u039c\u039f\u03a3 \u03a5\u03a0\u039f\u03a5\u03a1\u0393\u0395\u0399\u039f\u03a5 \u039f\u0399\u039a\u039f\u039d\u039f\u039c\u0399\u039a\u03a9\u039d",
            "\u03a0\u0395\u03a1\u0399\u0395\u03a7\u039f\u039c\u0395\u039d\u039f \u0394\u0397\u039b\u03a9\u03a3\u0397\u03a3 \u03a6\u039f\u03a1\u039f\u03a5 \u0395\u0399\u03a3\u039f\u0394\u0397\u039c\u0391\u03a4\u039f\u03a3",
            "\u03a0\u03a1\u03a9\u03a4\u0395\u03a3 \u03a5\u039b\u0395\u03a3 \u03a3\u0399\u0394\u0395\u03a1\u0395\u039d\u0399\u03a9\u039d \u0392\u0391\u03a1\u0395\u039b\u0399\u03a9\u039d",
            "\u0395\u03a5\u03a1\u03a9\u03a0\u0391\u0399\u039a\u039f\u03a3 \u039a\u03a9\u0394\u0399\u039a\u0391\u03a3 \u039a\u039f\u0399\u039d\u03a9\u039d\u0399\u039a\u0397\u03a3 \u0391\u03a3\u03a6\u0391\u039b\u0395\u0399\u0391\u03a3",
            "\u0394\u0399\u0391\u03a6\u039f\u03a1\u039f\u0399 \u0393\u0395\u03a9\u03a1\u0393\u0399\u039a\u039f\u0399 \u03a3\u03a5\u039d\u0395\u03a4\u0391\u0399\u03a1\u0399\u03a3\u039c\u039f\u0399",
            "\u03a3\u03a7\u0395\u0394\u0399\u0391 \u03a0\u039f\u039b\u0395\u03a9\u039d \u0399\u039f\u039d\u0399\u03a9\u039d \u039d\u0397\u03a3\u03a9\u039d",
            "\u0395\u03a5\u03a1\u03a9\u03a0\u0391\u0399\u039a\u0397 \u039f\u0399\u039a\u039f\u039d\u039f\u039c\u0399\u039a\u0397 \u039a\u039f\u0399\u039d\u039f\u03a4\u0397\u03a4\u0391 \u0395\u03a5\u03a1\u03a9\u03a0\u0391\u0399\u039a\u0397 \u0395\u039d\u03a9\u03a3\u0397",
            "\u03a3\u03a7\u039f\u039b\u0397 \u0394\u0399\u039f\u0399\u039a\u0397\u03a3\u0395\u03a9\u03a3 \u039d\u039f\u03a3\u0397\u039b\u0395\u03a5\u03a4. \u0399\u0394\u03a1\u03a5\u039c\u0391\u03a4\u03a9\u039d",
            "\u0394\u0399\u0391\u03a6\u039f\u03a1\u039f\u0399 \u039d\u039f\u039c\u039f\u0399 \u0395\u039c\u03a0\u03a1\u0391\u0393\u039c\u0391\u03a4\u039f\u03a5 \u0394\u0399\u039a\u0391\u0399\u039f\u03a5",
            "\u0395\u03a0\u0399\u039c\u0395\u039b\u0397\u03a4\u0395\u0399\u0391 \u039a\u0391\u0399 \u039f\u0399\u039a\u039f\u039d\u039f\u039c\u0399\u039a\u0395\u03a3 \u03a5\u03a0\u0397\u03a1\u0395\u03a3\u0399\u0395\u03a3",
            "\u0394\u0399\u0391\u0394\u0399\u039a\u0391\u03a3\u0399\u0391 \u0391\u03a4\u0395\u039b\u0395\u0399\u0391\u03a3",
            "\u03a0\u0391\u0399\u0394\u0399\u039a\u0395\u03a3 \u0395\u039e\u039f\u03a7\u0395\u03a3",
            "\u03a4\u0391\u039c\u0395\u0399\u039f \u03a3\u03a5\u039d\u03a4\u0391\u039e\u0395\u03a9\u039d \u03a0\u03a1\u039f\u03a3\u03a9\u03a0\u0399\u039a\u039f\u03a5 \u0395\u0398\u039d\u0399\u039a\u0397\u03a3 \u03a4\u03a1\u0391\u03a0\u0395\u0396\u0391\u03a3 \u03a4\u0397\u03a3 \u0395\u039b\u039b\u0391\u0394\u039f\u03a3",
            "\u039a\u03a1\u0391\u03a4\u0399\u039a\u0397 \u0395\u039a\u039c\u0395\u03a4\u0391\u039b\u039b\u0395\u03a5\u03a3\u0397 \u0394\u0391\u03a3\u03a9\u039d",
            "\u0391\u039d\u0395\u039e\u0391\u03a1\u03a4\u0397\u03a3\u0399\u0391 \u03a4\u0397\u03a3 \u0395\u039a\u039a\u039b\u0397\u03a3\u0399\u0391\u03a3 \u03a4\u0397\u03a3 \u0395\u039b\u039b\u0391\u0394\u039f\u03a3",
            "\u03a4\u0395\u03a7\u039d\u0399\u039a\u0391 \u03a0\u03a4\u03a5\u03a7\u0399\u0391",
            "\u0395\u03a0\u0399\u0392\u0391\u03a4\u0399\u039a\u0391 \u0391\u03a5\u03a4\u039f\u039a\u0399\u039d\u0397\u03a4\u0391 (\u0394\u0397\u039c\u039f\u03a3\u0399\u0391\u03a3 \u039a\u0391\u0399 \u0399\u0394\u0399\u03a9\u03a4\u0399\u039a\u0397\u03a3 \u03a7\u03a1\u0397\u03a3\u0397\u03a3)",
            "\u03a3\u03a5\u039c\u0392\u0391\u03a3\u0395\u0399\u03a3 \u0392\u039f\u03a5\u039b\u0395\u03a5\u03a4\u03a9\u039d",
            "\u039f\u03a1\u0393\u0391\u039d\u0399\u03a3\u039c\u039f\u03a3 \u03a4\u03a9\u039d \u0394\u0399\u039a\u0391\u03a3\u03a4\u0397\u03a1\u0399\u03a9\u039d",
            "\u0395\u039a\u03a0\u0391\u0399\u0394\u0395\u03a5\u03a4\u0399\u039a\u039f\u0399 \u039b\u0395\u0399\u03a4\u039f\u03a5\u03a1\u0393\u039f\u0399 \u0395\u039d \u0393\u0395\u039d\u0395\u0399",
            "\u0391\u03a1\u039c\u039f\u0394\u0399\u039f\u03a4\u0397\u03a4\u0391 \u03a4\u0395\u039b\u03a9\u039d\u0395\u0399\u0391\u039a\u03a9\u039d \u0391\u03a1\u03a7\u03a9\u039d",
            "\u0395\u0399\u0394\u0399\u039a\u0391 \u0395\u03a6\u0395\u03a4\u0395\u0399\u0391",
            "\u0391\u039e\u0399\u03a9\u039c\u0391\u03a4\u0399\u039a\u039f\u0399 \u0391\u0395\u03a1\u039f\u03a0\u039f\u03a1\u0399\u0391\u03a3",
            "\u03a0\u0391\u039d\u0395\u03a0\u0399\u03a3\u03a4\u0397\u039c\u0399\u0391\u039a\u0397 \u0392\u0399\u0392\u039b\u0399\u039f\u0398\u0397\u039a\u0397",
            "\u0395\u03a0\u0399\u03a4\u03a1\u039f\u03a0\u0397 \u03a3\u03a5\u039d\u03a4\u0391\u039e\u0397\u03a3 \u03a3\u03a7\u0395\u0394\u0399\u039f\u03a5 \u039a\u03a9\u0394\u0399\u039a\u0391 \u0395\u03a1\u0393\u0391\u03a3\u0399\u0391\u03a3",
            "\u0395\u039b\u039f\u039d\u039f\u03a3\u0399\u0391",
            "\u039d\u0391\u03a5\u039b\u039f\u03a3\u03a5\u039c\u03a6\u03a9\u039d\u0391",
            "\u03a3\u0399\u0394\u0397\u03a1\u039f\u0394\u03a1\u039f\u039c\u039f\u0399 \u0398\u0395\u03a3\u03a3\u0391\u039b\u0399\u039a\u039f\u0399",
            "\u03a1\u0391\u0394\u0399\u039f\u03a6\u03a9\u039d\u0399\u039a\u0395\u03a3 \u03a3\u03a5\u039c\u0392\u0391\u03a3\u0395\u0399\u03a3",
            "\u03a0\u03a1\u039f\u03a9\u0398\u0397\u03a3\u0397 \u0393\u0395\u03a9\u03a1\u0393\u0399\u039a\u0397\u03a3 \u03a0\u0391\u03a1\u0391\u0393\u03a9\u0393\u0397\u03a3-\u0395\u0398.\u0399.\u0391\u0393.\u0395",
            "\u0395\u03a0\u039f\u03a7\u0399\u0391\u039a\u03a9\u03a3 \u0395\u03a1\u0393\u0391\u0396\u039f\u039c\u0395\u039d\u039f\u0399 \u039c\u0399\u03a3\u0398\u03a9\u03a4\u039f\u0399",
            "\u0394\u0399\u0394\u0391\u039a\u03a4\u0399\u039a\u039f \u03a0\u03a1\u039f\u03a3\u03a9\u03a0\u0399\u039a\u039f",
            "\u039a\u03a9\u0394\u0399\u039a\u0391\u03a3 \u039a\u0395\u039d\u03a4\u03a1\u0399\u039a\u0397\u03a3, \u03a0\u03a1\u0395\u03a3\u0392\u0395\u03a5\u03a4\u0399\u039a\u0397\u03a3 \u039a\u0391\u0399",
            "\u03a0\u039f\u039b\u0399\u03a4\u0399\u039a\u039f \u03a0\u03a1\u039f\u03a3\u03a9\u03a0\u0399\u039a\u039f \u03a5\u03a0\u039f\u03a5\u03a1\u0393\u0395\u0399\u039f\u03a5 \u0395\u0398\u039d\u0399\u039a\u0397\u03a3 \u0391\u039c\u03a5\u039d\u0391\u03a3",
            "\u0394\u0399\u03a0\u039b\u03a9\u039c\u0391\u03a4\u0391 \u0395\u03a5\u03a1\u0395\u03a3\u0399\u03a4\u0395\u03a7\u039d\u0399\u0391\u03a3",
            "\u03a3\u03a9\u039c\u0391\u03a4\u0395\u0399\u0391 \u0393\u0395\u03a9\u03a1\u0393\u0399\u039a\u03a9\u039d \u0395\u03a1\u0393\u0391\u03a4\u03a9\u039d",
            "\u039a\u03a9\u0394\u0399\u039a\u0391\u03a3 \u03a0\u0395\u03a1\u0399 \u0395\u0399\u03a3\u03a0\u03a1\u0391\u039e\u0395\u03a9\u03a3 \u0394\u0397\u039c\u039f\u03a3\u0399\u03a9\u039d \u0395\u03a3\u039f\u0394\u03a9\u039d",
            "\u03a4\u03a1\u0391\u03a0\u0395\u0396\u039f\u0393\u03a1\u0391\u039c\u039c\u0391\u03a4\u0399\u0391",
            "\u03a0\u03a1\u039f\u039c\u0397\u0398\u0395\u03a5\u03a4\u0399\u039a\u039f\u03a3 \u039f\u03a1\u0393\u0391\u039d\u0399\u03a3\u039c\u039f\u03a3 \u0395.\u0392.\u0391",
            "\u0395\u039b\u0395\u0393\u03a7\u039f\u03a3 \u0391\u03a3\u03a6\u0391\u039b\u0395\u0399\u0391\u03a3 \u0391\u03a5\u03a4\u039f\u039a\u0399\u039d\u0397\u03a4\u03a9\u039d\u039a\u0395\u039d\u03a4\u03a1\u0391 \u03a4\u0395\u03a7\u039d\u0399\u039a\u039f\u03a5 \u0395\u039b\u0395\u0393\u03a7\u039f\u03a5 \u039f\u03a7\u0397\u039c\u0391\u03a4\u03a9\u039d (\u039a.\u03a4.\u0395.\u039f.)",
            "\u0395\u039e\u0391\u0393\u03a9\u0393\u0397 \u03a4\u03a5\u03a1\u039f\u03a5",
            "\u039d\u0391\u03a5\u03a4\u0399\u039b\u0399\u0391\u039a\u039f \u03a3\u03a5\u039d\u0391\u039b\u039b\u0391\u0393\u039c\u0391",
            "\u03a4\u0391\u039c\u0395\u0399\u039f \u0395\u03a0\u0399\u039a\u039f\u03a5\u03a1\u0399\u039a\u0397\u03a3 \u0391\u03a3\u03a6\u0391\u039b\u0399\u03a3\u0395\u03a9\u03a3 \u0397\u039b\u0395\u03a4\u03a1\u039f\u03a4\u0395\u03a7\u039d\u0399\u03a4\u03a9\u039d \u0395\u039b\u039b\u0391\u0394\u039f\u03a3 (T.E.A.H.E.)",
            "\u039c\u0399\u03a3\u0398\u039f\u0399 \u03a3\u03a4\u03a1\u0391\u03a4\u0399\u03a9\u03a4\u0399\u039a\u03a9\u039d \u039a\u0391\u0399 \u03a0\u03a1\u039f\u03a3\u0391\u03a5\u039e\u0397\u03a3\u0395\u0399\u03a3",
            "\u0391\u03a3\u03a4\u0399\u039a\u039f\u03a3 \u039a\u03a9\u0394\u0399\u039a\u0391\u03a3",
            "\u039c\u0395 \u03a4\u0399\u03a3 \u0397\u039d\u03a9\u039c\u0395\u039d\u0395\u03a3 \u03a0\u039f\u039b\u0399\u03a4\u0395\u0399\u0395\u03a3 \u0391\u039c\u0395\u03a1\u0399\u039a\u0397\u03a3",
            "\u03a4\u0391\u039c\u0395\u0399\u039f \u0391\u03a3\u03a6\u0391\u039b\u0399\u03a3\u0395\u03a9\u03a3 \u03a0\u03a1\u039f\u03a3\u03a9\u03a0\u0399\u039a\u039f\u03a5 \u039f.\u03a4.\u0395. (\u03a4.\u0391.\u03a0.-\u039f.\u03a4.\u0395.)",
            "\u039c\u0391\u0399\u0395\u03a3",
            "\u03a6\u03a5\u0393\u039f\u0394\u0399\u039a\u0399\u0391",
            "\u039f\u03a1\u0393\u0391\u039d\u0399\u03a3\u039c\u039f\u03a3 \u039e\u0395\u039d\u039f\u0394\u039f\u03a7\u0395\u0399\u0391\u039a\u0397\u03a3 \u03a0\u0399\u03a3\u03a4\u0397\u03a3",
            "\u0394\u0397\u039c\u039f\u03a4\u0399\u039a\u039f\u0399 \u03a3\u03a4\u03a1\u0391\u03a4\u039f\u039b\u039f\u0393\u039f\u0399",
            "\u0391\u039d\u03a9\u03a4\u0391\u03a4\u039f \u0394\u0399\u039a\u0391\u03a3\u03a4\u0399\u039a\u039f \u03a3\u03a5\u039c\u0392\u039f\u03a5\u039b\u0399\u039f",
            "\u0399\u03a3\u03a4\u039f\u03a1\u0399\u039a\u039f \u0391\u03a1\u03a7\u0395\u0399\u039f \u039a\u03a1\u0397\u03a4\u0397\u03a3",
            "\u0395\u039b\u039b\u0397\u039d\u0399\u039a\u0397 \u0398\u0391\u039b\u0391\u03a3\u03a3\u0399\u0391 \u0384\u0395\u039d\u03a9\u03a3\u0397",
            "\u0395\u039a\u03a0\u039f\u0399\u0397\u03a3\u0395\u0399\u03a3 \u039a\u0391\u0399 \u0395\u039a\u039c\u0399\u03a3\u0398\u03a9\u03a3\u0395\u0399\u03a3",
            "\u03a4\u0391\u03a7\u03a5\u0394\u03a1\u039f\u039c\u0399\u039a\u0395\u03a3 \u0395\u03a0\u0399\u03a4\u0391\u0393\u0395\u03a3",
            "\u03a5\u03a0\u0397\u03a1\u0395\u03a3\u0399\u0391 \u039c\u0397\u03a4\u03a1\u03a9\u039f\u03a5",
            "\u0394\u0399\u0391\u03a6\u039f\u03a1\u0391 \u039f\u0399\u039a\u039f\u039d\u039f\u039c\u0399\u039a\u0391 \u0398\u0395\u039c\u0391\u03a4\u0391",
            "\u0395\u039d\u0394\u0399\u039a\u0391 \u039c\u0395\u03a3\u0391",
            "\u03a4\u0395\u039b\u0397 \u0391\u0395\u03a1\u039f\u03a0\u039f\u03a1\u0399\u039a\u03a9\u039d \u03a4\u0391\u039e\u0399\u0394\u0399\u03a9\u039d",
            "\u039c\u0395 \u03a4\u0397\u039d \u0391\u0399\u0393\u03a5\u03a0\u03a4\u039f",
            "\u0394\u0399\u0391\u03a6\u039f\u03a1\u0395\u03a3 \u0392\u0399\u0392\u039b\u0399\u039f\u0398\u0397\u039a\u0395\u03a3",
            "\u039a\u0395\u039d\u03a4\u03a1\u0399\u039a\u0397 \u03a5\u03a0\u0397\u03a1\u0395\u03a3\u0399\u0391"
        ],
        "names_file": null,
        "id": null,
        "_type": "ClassLabel"
    }
}
```


