# quickdraw

References:

*   [Code](https://github.com/huggingface/datasets/blob/master/datasets/quickdraw)
*   [Huggingface](https://huggingface.co/datasets/quickdraw)


## raw


Use the following command to load this dataset in TFDS:

```python
ds = tfds.load('huggingface:quickdraw/raw')
```

*   **Description**:

```
The Quick Draw Dataset is a collection of 50 million drawings across 345 categories, contributed by players of the game Quick, Draw!.
The drawings were captured as timestamped vectors, tagged with metadata including what the player was asked to draw and in which country the player was located.
```

*   **License**: CC BY 4.0
*   **Version**: 1.0.0
*   **Splits**:

Split  | Examples
:----- | -------:
`'train'` | 50426266

*   **Features**:

```json
{
    "key_id": {
        "dtype": "string",
        "id": null,
        "_type": "Value"
    },
    "word": {
        "num_classes": 345,
        "names": [
            "aircraft carrier",
            "airplane",
            "alarm clock",
            "ambulance",
            "angel",
            "animal migration",
            "ant",
            "anvil",
            "apple",
            "arm",
            "asparagus",
            "axe",
            "backpack",
            "banana",
            "bandage",
            "barn",
            "baseball bat",
            "baseball",
            "basket",
            "basketball",
            "bat",
            "bathtub",
            "beach",
            "bear",
            "beard",
            "bed",
            "bee",
            "belt",
            "bench",
            "bicycle",
            "binoculars",
            "bird",
            "birthday cake",
            "blackberry",
            "blueberry",
            "book",
            "boomerang",
            "bottlecap",
            "bowtie",
            "bracelet",
            "brain",
            "bread",
            "bridge",
            "broccoli",
            "broom",
            "bucket",
            "bulldozer",
            "bus",
            "bush",
            "butterfly",
            "cactus",
            "cake",
            "calculator",
            "calendar",
            "camel",
            "camera",
            "camouflage",
            "campfire",
            "candle",
            "cannon",
            "canoe",
            "car",
            "carrot",
            "castle",
            "cat",
            "ceiling fan",
            "cell phone",
            "cello",
            "chair",
            "chandelier",
            "church",
            "circle",
            "clarinet",
            "clock",
            "cloud",
            "coffee cup",
            "compass",
            "computer",
            "cookie",
            "cooler",
            "couch",
            "cow",
            "crab",
            "crayon",
            "crocodile",
            "crown",
            "cruise ship",
            "cup",
            "diamond",
            "dishwasher",
            "diving board",
            "dog",
            "dolphin",
            "donut",
            "door",
            "dragon",
            "dresser",
            "drill",
            "drums",
            "duck",
            "dumbbell",
            "ear",
            "elbow",
            "elephant",
            "envelope",
            "eraser",
            "eye",
            "eyeglasses",
            "face",
            "fan",
            "feather",
            "fence",
            "finger",
            "fire hydrant",
            "fireplace",
            "firetruck",
            "fish",
            "flamingo",
            "flashlight",
            "flip flops",
            "floor lamp",
            "flower",
            "flying saucer",
            "foot",
            "fork",
            "frog",
            "frying pan",
            "garden hose",
            "garden",
            "giraffe",
            "goatee",
            "golf club",
            "grapes",
            "grass",
            "guitar",
            "hamburger",
            "hammer",
            "hand",
            "harp",
            "hat",
            "headphones",
            "hedgehog",
            "helicopter",
            "helmet",
            "hexagon",
            "hockey puck",
            "hockey stick",
            "horse",
            "hospital",
            "hot air balloon",
            "hot dog",
            "hot tub",
            "hourglass",
            "house plant",
            "house",
            "hurricane",
            "ice cream",
            "jacket",
            "jail",
            "kangaroo",
            "key",
            "keyboard",
            "knee",
            "knife",
            "ladder",
            "lantern",
            "laptop",
            "leaf",
            "leg",
            "light bulb",
            "lighter",
            "lighthouse",
            "lightning",
            "line",
            "lion",
            "lipstick",
            "lobster",
            "lollipop",
            "mailbox",
            "map",
            "marker",
            "matches",
            "megaphone",
            "mermaid",
            "microphone",
            "microwave",
            "monkey",
            "moon",
            "mosquito",
            "motorbike",
            "mountain",
            "mouse",
            "moustache",
            "mouth",
            "mug",
            "mushroom",
            "nail",
            "necklace",
            "nose",
            "ocean",
            "octagon",
            "octopus",
            "onion",
            "oven",
            "owl",
            "paint can",
            "paintbrush",
            "palm tree",
            "panda",
            "pants",
            "paper clip",
            "parachute",
            "parrot",
            "passport",
            "peanut",
            "pear",
            "peas",
            "pencil",
            "penguin",
            "piano",
            "pickup truck",
            "picture frame",
            "pig",
            "pillow",
            "pineapple",
            "pizza",
            "pliers",
            "police car",
            "pond",
            "pool",
            "popsicle",
            "postcard",
            "potato",
            "power outlet",
            "purse",
            "rabbit",
            "raccoon",
            "radio",
            "rain",
            "rainbow",
            "rake",
            "remote control",
            "rhinoceros",
            "rifle",
            "river",
            "roller coaster",
            "rollerskates",
            "sailboat",
            "sandwich",
            "saw",
            "saxophone",
            "school bus",
            "scissors",
            "scorpion",
            "screwdriver",
            "sea turtle",
            "see saw",
            "shark",
            "sheep",
            "shoe",
            "shorts",
            "shovel",
            "sink",
            "skateboard",
            "skull",
            "skyscraper",
            "sleeping bag",
            "smiley face",
            "snail",
            "snake",
            "snorkel",
            "snowflake",
            "snowman",
            "soccer ball",
            "sock",
            "speedboat",
            "spider",
            "spoon",
            "spreadsheet",
            "square",
            "squiggle",
            "squirrel",
            "stairs",
            "star",
            "steak",
            "stereo",
            "stethoscope",
            "stitches",
            "stop sign",
            "stove",
            "strawberry",
            "streetlight",
            "string bean",
            "submarine",
            "suitcase",
            "sun",
            "swan",
            "sweater",
            "swing set",
            "sword",
            "syringe",
            "t-shirt",
            "table",
            "teapot",
            "teddy-bear",
            "telephone",
            "television",
            "tennis racquet",
            "tent",
            "The Eiffel Tower",
            "The Great Wall of China",
            "The Mona Lisa",
            "tiger",
            "toaster",
            "toe",
            "toilet",
            "tooth",
            "toothbrush",
            "toothpaste",
            "tornado",
            "tractor",
            "traffic light",
            "train",
            "tree",
            "triangle",
            "trombone",
            "truck",
            "trumpet",
            "umbrella",
            "underwear",
            "van",
            "vase",
            "violin",
            "washing machine",
            "watermelon",
            "waterslide",
            "whale",
            "wheel",
            "windmill",
            "wine bottle",
            "wine glass",
            "wristwatch",
            "yoga",
            "zebra",
            "zigzag"
        ],
        "id": null,
        "_type": "ClassLabel"
    },
    "recognized": {
        "dtype": "bool",
        "id": null,
        "_type": "Value"
    },
    "timestamp": {
        "dtype": "timestamp[us, tz=UTC]",
        "id": null,
        "_type": "Value"
    },
    "countrycode": {
        "dtype": "string",
        "id": null,
        "_type": "Value"
    },
    "drawing": {
        "feature": {
            "x": {
                "feature": {
                    "dtype": "float32",
                    "id": null,
                    "_type": "Value"
                },
                "length": -1,
                "id": null,
                "_type": "Sequence"
            },
            "y": {
                "feature": {
                    "dtype": "float32",
                    "id": null,
                    "_type": "Value"
                },
                "length": -1,
                "id": null,
                "_type": "Sequence"
            },
            "t": {
                "feature": {
                    "dtype": "int32",
                    "id": null,
                    "_type": "Value"
                },
                "length": -1,
                "id": null,
                "_type": "Sequence"
            }
        },
        "length": -1,
        "id": null,
        "_type": "Sequence"
    }
}
```



## preprocessed_simplified_drawings


Use the following command to load this dataset in TFDS:

```python
ds = tfds.load('huggingface:quickdraw/preprocessed_simplified_drawings')
```

*   **Description**:

```
The Quick Draw Dataset is a collection of 50 million drawings across 345 categories, contributed by players of the game Quick, Draw!.
The drawings were captured as timestamped vectors, tagged with metadata including what the player was asked to draw and in which country the player was located.
```

*   **License**: CC BY 4.0
*   **Version**: 1.0.0
*   **Splits**:

Split  | Examples
:----- | -------:
`'train'` | 50426266

*   **Features**:

```json
{
    "key_id": {
        "dtype": "string",
        "id": null,
        "_type": "Value"
    },
    "word": {
        "num_classes": 345,
        "names": [
            "aircraft carrier",
            "airplane",
            "alarm clock",
            "ambulance",
            "angel",
            "animal migration",
            "ant",
            "anvil",
            "apple",
            "arm",
            "asparagus",
            "axe",
            "backpack",
            "banana",
            "bandage",
            "barn",
            "baseball bat",
            "baseball",
            "basket",
            "basketball",
            "bat",
            "bathtub",
            "beach",
            "bear",
            "beard",
            "bed",
            "bee",
            "belt",
            "bench",
            "bicycle",
            "binoculars",
            "bird",
            "birthday cake",
            "blackberry",
            "blueberry",
            "book",
            "boomerang",
            "bottlecap",
            "bowtie",
            "bracelet",
            "brain",
            "bread",
            "bridge",
            "broccoli",
            "broom",
            "bucket",
            "bulldozer",
            "bus",
            "bush",
            "butterfly",
            "cactus",
            "cake",
            "calculator",
            "calendar",
            "camel",
            "camera",
            "camouflage",
            "campfire",
            "candle",
            "cannon",
            "canoe",
            "car",
            "carrot",
            "castle",
            "cat",
            "ceiling fan",
            "cell phone",
            "cello",
            "chair",
            "chandelier",
            "church",
            "circle",
            "clarinet",
            "clock",
            "cloud",
            "coffee cup",
            "compass",
            "computer",
            "cookie",
            "cooler",
            "couch",
            "cow",
            "crab",
            "crayon",
            "crocodile",
            "crown",
            "cruise ship",
            "cup",
            "diamond",
            "dishwasher",
            "diving board",
            "dog",
            "dolphin",
            "donut",
            "door",
            "dragon",
            "dresser",
            "drill",
            "drums",
            "duck",
            "dumbbell",
            "ear",
            "elbow",
            "elephant",
            "envelope",
            "eraser",
            "eye",
            "eyeglasses",
            "face",
            "fan",
            "feather",
            "fence",
            "finger",
            "fire hydrant",
            "fireplace",
            "firetruck",
            "fish",
            "flamingo",
            "flashlight",
            "flip flops",
            "floor lamp",
            "flower",
            "flying saucer",
            "foot",
            "fork",
            "frog",
            "frying pan",
            "garden hose",
            "garden",
            "giraffe",
            "goatee",
            "golf club",
            "grapes",
            "grass",
            "guitar",
            "hamburger",
            "hammer",
            "hand",
            "harp",
            "hat",
            "headphones",
            "hedgehog",
            "helicopter",
            "helmet",
            "hexagon",
            "hockey puck",
            "hockey stick",
            "horse",
            "hospital",
            "hot air balloon",
            "hot dog",
            "hot tub",
            "hourglass",
            "house plant",
            "house",
            "hurricane",
            "ice cream",
            "jacket",
            "jail",
            "kangaroo",
            "key",
            "keyboard",
            "knee",
            "knife",
            "ladder",
            "lantern",
            "laptop",
            "leaf",
            "leg",
            "light bulb",
            "lighter",
            "lighthouse",
            "lightning",
            "line",
            "lion",
            "lipstick",
            "lobster",
            "lollipop",
            "mailbox",
            "map",
            "marker",
            "matches",
            "megaphone",
            "mermaid",
            "microphone",
            "microwave",
            "monkey",
            "moon",
            "mosquito",
            "motorbike",
            "mountain",
            "mouse",
            "moustache",
            "mouth",
            "mug",
            "mushroom",
            "nail",
            "necklace",
            "nose",
            "ocean",
            "octagon",
            "octopus",
            "onion",
            "oven",
            "owl",
            "paint can",
            "paintbrush",
            "palm tree",
            "panda",
            "pants",
            "paper clip",
            "parachute",
            "parrot",
            "passport",
            "peanut",
            "pear",
            "peas",
            "pencil",
            "penguin",
            "piano",
            "pickup truck",
            "picture frame",
            "pig",
            "pillow",
            "pineapple",
            "pizza",
            "pliers",
            "police car",
            "pond",
            "pool",
            "popsicle",
            "postcard",
            "potato",
            "power outlet",
            "purse",
            "rabbit",
            "raccoon",
            "radio",
            "rain",
            "rainbow",
            "rake",
            "remote control",
            "rhinoceros",
            "rifle",
            "river",
            "roller coaster",
            "rollerskates",
            "sailboat",
            "sandwich",
            "saw",
            "saxophone",
            "school bus",
            "scissors",
            "scorpion",
            "screwdriver",
            "sea turtle",
            "see saw",
            "shark",
            "sheep",
            "shoe",
            "shorts",
            "shovel",
            "sink",
            "skateboard",
            "skull",
            "skyscraper",
            "sleeping bag",
            "smiley face",
            "snail",
            "snake",
            "snorkel",
            "snowflake",
            "snowman",
            "soccer ball",
            "sock",
            "speedboat",
            "spider",
            "spoon",
            "spreadsheet",
            "square",
            "squiggle",
            "squirrel",
            "stairs",
            "star",
            "steak",
            "stereo",
            "stethoscope",
            "stitches",
            "stop sign",
            "stove",
            "strawberry",
            "streetlight",
            "string bean",
            "submarine",
            "suitcase",
            "sun",
            "swan",
            "sweater",
            "swing set",
            "sword",
            "syringe",
            "t-shirt",
            "table",
            "teapot",
            "teddy-bear",
            "telephone",
            "television",
            "tennis racquet",
            "tent",
            "The Eiffel Tower",
            "The Great Wall of China",
            "The Mona Lisa",
            "tiger",
            "toaster",
            "toe",
            "toilet",
            "tooth",
            "toothbrush",
            "toothpaste",
            "tornado",
            "tractor",
            "traffic light",
            "train",
            "tree",
            "triangle",
            "trombone",
            "truck",
            "trumpet",
            "umbrella",
            "underwear",
            "van",
            "vase",
            "violin",
            "washing machine",
            "watermelon",
            "waterslide",
            "whale",
            "wheel",
            "windmill",
            "wine bottle",
            "wine glass",
            "wristwatch",
            "yoga",
            "zebra",
            "zigzag"
        ],
        "id": null,
        "_type": "ClassLabel"
    },
    "recognized": {
        "dtype": "bool",
        "id": null,
        "_type": "Value"
    },
    "timestamp": {
        "dtype": "timestamp[us, tz=UTC]",
        "id": null,
        "_type": "Value"
    },
    "countrycode": {
        "dtype": "string",
        "id": null,
        "_type": "Value"
    },
    "drawing": {
        "feature": {
            "x": {
                "feature": {
                    "dtype": "uint8",
                    "id": null,
                    "_type": "Value"
                },
                "length": -1,
                "id": null,
                "_type": "Sequence"
            },
            "y": {
                "feature": {
                    "dtype": "uint8",
                    "id": null,
                    "_type": "Value"
                },
                "length": -1,
                "id": null,
                "_type": "Sequence"
            }
        },
        "length": -1,
        "id": null,
        "_type": "Sequence"
    }
}
```



## preprocessed_bitmaps


Use the following command to load this dataset in TFDS:

```python
ds = tfds.load('huggingface:quickdraw/preprocessed_bitmaps')
```

*   **Description**:

```
The Quick Draw Dataset is a collection of 50 million drawings across 345 categories, contributed by players of the game Quick, Draw!.
The drawings were captured as timestamped vectors, tagged with metadata including what the player was asked to draw and in which country the player was located.
```

*   **License**: CC BY 4.0
*   **Version**: 1.0.0
*   **Splits**:

Split  | Examples
:----- | -------:
`'train'` | 50426266

*   **Features**:

```json
{
    "image": {
        "decode": true,
        "id": null,
        "_type": "Image"
    },
    "label": {
        "num_classes": 345,
        "names": [
            "aircraft carrier",
            "airplane",
            "alarm clock",
            "ambulance",
            "angel",
            "animal migration",
            "ant",
            "anvil",
            "apple",
            "arm",
            "asparagus",
            "axe",
            "backpack",
            "banana",
            "bandage",
            "barn",
            "baseball bat",
            "baseball",
            "basket",
            "basketball",
            "bat",
            "bathtub",
            "beach",
            "bear",
            "beard",
            "bed",
            "bee",
            "belt",
            "bench",
            "bicycle",
            "binoculars",
            "bird",
            "birthday cake",
            "blackberry",
            "blueberry",
            "book",
            "boomerang",
            "bottlecap",
            "bowtie",
            "bracelet",
            "brain",
            "bread",
            "bridge",
            "broccoli",
            "broom",
            "bucket",
            "bulldozer",
            "bus",
            "bush",
            "butterfly",
            "cactus",
            "cake",
            "calculator",
            "calendar",
            "camel",
            "camera",
            "camouflage",
            "campfire",
            "candle",
            "cannon",
            "canoe",
            "car",
            "carrot",
            "castle",
            "cat",
            "ceiling fan",
            "cell phone",
            "cello",
            "chair",
            "chandelier",
            "church",
            "circle",
            "clarinet",
            "clock",
            "cloud",
            "coffee cup",
            "compass",
            "computer",
            "cookie",
            "cooler",
            "couch",
            "cow",
            "crab",
            "crayon",
            "crocodile",
            "crown",
            "cruise ship",
            "cup",
            "diamond",
            "dishwasher",
            "diving board",
            "dog",
            "dolphin",
            "donut",
            "door",
            "dragon",
            "dresser",
            "drill",
            "drums",
            "duck",
            "dumbbell",
            "ear",
            "elbow",
            "elephant",
            "envelope",
            "eraser",
            "eye",
            "eyeglasses",
            "face",
            "fan",
            "feather",
            "fence",
            "finger",
            "fire hydrant",
            "fireplace",
            "firetruck",
            "fish",
            "flamingo",
            "flashlight",
            "flip flops",
            "floor lamp",
            "flower",
            "flying saucer",
            "foot",
            "fork",
            "frog",
            "frying pan",
            "garden hose",
            "garden",
            "giraffe",
            "goatee",
            "golf club",
            "grapes",
            "grass",
            "guitar",
            "hamburger",
            "hammer",
            "hand",
            "harp",
            "hat",
            "headphones",
            "hedgehog",
            "helicopter",
            "helmet",
            "hexagon",
            "hockey puck",
            "hockey stick",
            "horse",
            "hospital",
            "hot air balloon",
            "hot dog",
            "hot tub",
            "hourglass",
            "house plant",
            "house",
            "hurricane",
            "ice cream",
            "jacket",
            "jail",
            "kangaroo",
            "key",
            "keyboard",
            "knee",
            "knife",
            "ladder",
            "lantern",
            "laptop",
            "leaf",
            "leg",
            "light bulb",
            "lighter",
            "lighthouse",
            "lightning",
            "line",
            "lion",
            "lipstick",
            "lobster",
            "lollipop",
            "mailbox",
            "map",
            "marker",
            "matches",
            "megaphone",
            "mermaid",
            "microphone",
            "microwave",
            "monkey",
            "moon",
            "mosquito",
            "motorbike",
            "mountain",
            "mouse",
            "moustache",
            "mouth",
            "mug",
            "mushroom",
            "nail",
            "necklace",
            "nose",
            "ocean",
            "octagon",
            "octopus",
            "onion",
            "oven",
            "owl",
            "paint can",
            "paintbrush",
            "palm tree",
            "panda",
            "pants",
            "paper clip",
            "parachute",
            "parrot",
            "passport",
            "peanut",
            "pear",
            "peas",
            "pencil",
            "penguin",
            "piano",
            "pickup truck",
            "picture frame",
            "pig",
            "pillow",
            "pineapple",
            "pizza",
            "pliers",
            "police car",
            "pond",
            "pool",
            "popsicle",
            "postcard",
            "potato",
            "power outlet",
            "purse",
            "rabbit",
            "raccoon",
            "radio",
            "rain",
            "rainbow",
            "rake",
            "remote control",
            "rhinoceros",
            "rifle",
            "river",
            "roller coaster",
            "rollerskates",
            "sailboat",
            "sandwich",
            "saw",
            "saxophone",
            "school bus",
            "scissors",
            "scorpion",
            "screwdriver",
            "sea turtle",
            "see saw",
            "shark",
            "sheep",
            "shoe",
            "shorts",
            "shovel",
            "sink",
            "skateboard",
            "skull",
            "skyscraper",
            "sleeping bag",
            "smiley face",
            "snail",
            "snake",
            "snorkel",
            "snowflake",
            "snowman",
            "soccer ball",
            "sock",
            "speedboat",
            "spider",
            "spoon",
            "spreadsheet",
            "square",
            "squiggle",
            "squirrel",
            "stairs",
            "star",
            "steak",
            "stereo",
            "stethoscope",
            "stitches",
            "stop sign",
            "stove",
            "strawberry",
            "streetlight",
            "string bean",
            "submarine",
            "suitcase",
            "sun",
            "swan",
            "sweater",
            "swing set",
            "sword",
            "syringe",
            "t-shirt",
            "table",
            "teapot",
            "teddy-bear",
            "telephone",
            "television",
            "tennis racquet",
            "tent",
            "The Eiffel Tower",
            "The Great Wall of China",
            "The Mona Lisa",
            "tiger",
            "toaster",
            "toe",
            "toilet",
            "tooth",
            "toothbrush",
            "toothpaste",
            "tornado",
            "tractor",
            "traffic light",
            "train",
            "tree",
            "triangle",
            "trombone",
            "truck",
            "trumpet",
            "umbrella",
            "underwear",
            "van",
            "vase",
            "violin",
            "washing machine",
            "watermelon",
            "waterslide",
            "whale",
            "wheel",
            "windmill",
            "wine bottle",
            "wine glass",
            "wristwatch",
            "yoga",
            "zebra",
            "zigzag"
        ],
        "id": null,
        "_type": "ClassLabel"
    }
}
```



## sketch_rnn


Use the following command to load this dataset in TFDS:

```python
ds = tfds.load('huggingface:quickdraw/sketch_rnn')
```

*   **Description**:

```
The Quick Draw Dataset is a collection of 50 million drawings across 345 categories, contributed by players of the game Quick, Draw!.
The drawings were captured as timestamped vectors, tagged with metadata including what the player was asked to draw and in which country the player was located.
```

*   **License**: CC BY 4.0
*   **Version**: 1.0.0
*   **Splits**:

Split  | Examples
:----- | -------:
`'test'` | 862500
`'train'` | 24150000
`'validation'` | 862500

*   **Features**:

```json
{
    "word": {
        "num_classes": 345,
        "names": [
            "aircraft carrier",
            "airplane",
            "alarm clock",
            "ambulance",
            "angel",
            "animal migration",
            "ant",
            "anvil",
            "apple",
            "arm",
            "asparagus",
            "axe",
            "backpack",
            "banana",
            "bandage",
            "barn",
            "baseball bat",
            "baseball",
            "basket",
            "basketball",
            "bat",
            "bathtub",
            "beach",
            "bear",
            "beard",
            "bed",
            "bee",
            "belt",
            "bench",
            "bicycle",
            "binoculars",
            "bird",
            "birthday cake",
            "blackberry",
            "blueberry",
            "book",
            "boomerang",
            "bottlecap",
            "bowtie",
            "bracelet",
            "brain",
            "bread",
            "bridge",
            "broccoli",
            "broom",
            "bucket",
            "bulldozer",
            "bus",
            "bush",
            "butterfly",
            "cactus",
            "cake",
            "calculator",
            "calendar",
            "camel",
            "camera",
            "camouflage",
            "campfire",
            "candle",
            "cannon",
            "canoe",
            "car",
            "carrot",
            "castle",
            "cat",
            "ceiling fan",
            "cell phone",
            "cello",
            "chair",
            "chandelier",
            "church",
            "circle",
            "clarinet",
            "clock",
            "cloud",
            "coffee cup",
            "compass",
            "computer",
            "cookie",
            "cooler",
            "couch",
            "cow",
            "crab",
            "crayon",
            "crocodile",
            "crown",
            "cruise ship",
            "cup",
            "diamond",
            "dishwasher",
            "diving board",
            "dog",
            "dolphin",
            "donut",
            "door",
            "dragon",
            "dresser",
            "drill",
            "drums",
            "duck",
            "dumbbell",
            "ear",
            "elbow",
            "elephant",
            "envelope",
            "eraser",
            "eye",
            "eyeglasses",
            "face",
            "fan",
            "feather",
            "fence",
            "finger",
            "fire hydrant",
            "fireplace",
            "firetruck",
            "fish",
            "flamingo",
            "flashlight",
            "flip flops",
            "floor lamp",
            "flower",
            "flying saucer",
            "foot",
            "fork",
            "frog",
            "frying pan",
            "garden hose",
            "garden",
            "giraffe",
            "goatee",
            "golf club",
            "grapes",
            "grass",
            "guitar",
            "hamburger",
            "hammer",
            "hand",
            "harp",
            "hat",
            "headphones",
            "hedgehog",
            "helicopter",
            "helmet",
            "hexagon",
            "hockey puck",
            "hockey stick",
            "horse",
            "hospital",
            "hot air balloon",
            "hot dog",
            "hot tub",
            "hourglass",
            "house plant",
            "house",
            "hurricane",
            "ice cream",
            "jacket",
            "jail",
            "kangaroo",
            "key",
            "keyboard",
            "knee",
            "knife",
            "ladder",
            "lantern",
            "laptop",
            "leaf",
            "leg",
            "light bulb",
            "lighter",
            "lighthouse",
            "lightning",
            "line",
            "lion",
            "lipstick",
            "lobster",
            "lollipop",
            "mailbox",
            "map",
            "marker",
            "matches",
            "megaphone",
            "mermaid",
            "microphone",
            "microwave",
            "monkey",
            "moon",
            "mosquito",
            "motorbike",
            "mountain",
            "mouse",
            "moustache",
            "mouth",
            "mug",
            "mushroom",
            "nail",
            "necklace",
            "nose",
            "ocean",
            "octagon",
            "octopus",
            "onion",
            "oven",
            "owl",
            "paint can",
            "paintbrush",
            "palm tree",
            "panda",
            "pants",
            "paper clip",
            "parachute",
            "parrot",
            "passport",
            "peanut",
            "pear",
            "peas",
            "pencil",
            "penguin",
            "piano",
            "pickup truck",
            "picture frame",
            "pig",
            "pillow",
            "pineapple",
            "pizza",
            "pliers",
            "police car",
            "pond",
            "pool",
            "popsicle",
            "postcard",
            "potato",
            "power outlet",
            "purse",
            "rabbit",
            "raccoon",
            "radio",
            "rain",
            "rainbow",
            "rake",
            "remote control",
            "rhinoceros",
            "rifle",
            "river",
            "roller coaster",
            "rollerskates",
            "sailboat",
            "sandwich",
            "saw",
            "saxophone",
            "school bus",
            "scissors",
            "scorpion",
            "screwdriver",
            "sea turtle",
            "see saw",
            "shark",
            "sheep",
            "shoe",
            "shorts",
            "shovel",
            "sink",
            "skateboard",
            "skull",
            "skyscraper",
            "sleeping bag",
            "smiley face",
            "snail",
            "snake",
            "snorkel",
            "snowflake",
            "snowman",
            "soccer ball",
            "sock",
            "speedboat",
            "spider",
            "spoon",
            "spreadsheet",
            "square",
            "squiggle",
            "squirrel",
            "stairs",
            "star",
            "steak",
            "stereo",
            "stethoscope",
            "stitches",
            "stop sign",
            "stove",
            "strawberry",
            "streetlight",
            "string bean",
            "submarine",
            "suitcase",
            "sun",
            "swan",
            "sweater",
            "swing set",
            "sword",
            "syringe",
            "t-shirt",
            "table",
            "teapot",
            "teddy-bear",
            "telephone",
            "television",
            "tennis racquet",
            "tent",
            "The Eiffel Tower",
            "The Great Wall of China",
            "The Mona Lisa",
            "tiger",
            "toaster",
            "toe",
            "toilet",
            "tooth",
            "toothbrush",
            "toothpaste",
            "tornado",
            "tractor",
            "traffic light",
            "train",
            "tree",
            "triangle",
            "trombone",
            "truck",
            "trumpet",
            "umbrella",
            "underwear",
            "van",
            "vase",
            "violin",
            "washing machine",
            "watermelon",
            "waterslide",
            "whale",
            "wheel",
            "windmill",
            "wine bottle",
            "wine glass",
            "wristwatch",
            "yoga",
            "zebra",
            "zigzag"
        ],
        "id": null,
        "_type": "ClassLabel"
    },
    "drawing": {
        "shape": [
            null,
            3
        ],
        "dtype": "int16",
        "id": null,
        "_type": "Array2D"
    }
}
```



## sketch_rnn_full


Use the following command to load this dataset in TFDS:

```python
ds = tfds.load('huggingface:quickdraw/sketch_rnn_full')
```

*   **Description**:

```
The Quick Draw Dataset is a collection of 50 million drawings across 345 categories, contributed by players of the game Quick, Draw!.
The drawings were captured as timestamped vectors, tagged with metadata including what the player was asked to draw and in which country the player was located.
```

*   **License**: CC BY 4.0
*   **Version**: 1.0.0
*   **Splits**:

Split  | Examples
:----- | -------:
`'test'` | 862500
`'train'` | 43988874
`'validation'` | 862500

*   **Features**:

```json
{
    "word": {
        "num_classes": 345,
        "names": [
            "aircraft carrier",
            "airplane",
            "alarm clock",
            "ambulance",
            "angel",
            "animal migration",
            "ant",
            "anvil",
            "apple",
            "arm",
            "asparagus",
            "axe",
            "backpack",
            "banana",
            "bandage",
            "barn",
            "baseball bat",
            "baseball",
            "basket",
            "basketball",
            "bat",
            "bathtub",
            "beach",
            "bear",
            "beard",
            "bed",
            "bee",
            "belt",
            "bench",
            "bicycle",
            "binoculars",
            "bird",
            "birthday cake",
            "blackberry",
            "blueberry",
            "book",
            "boomerang",
            "bottlecap",
            "bowtie",
            "bracelet",
            "brain",
            "bread",
            "bridge",
            "broccoli",
            "broom",
            "bucket",
            "bulldozer",
            "bus",
            "bush",
            "butterfly",
            "cactus",
            "cake",
            "calculator",
            "calendar",
            "camel",
            "camera",
            "camouflage",
            "campfire",
            "candle",
            "cannon",
            "canoe",
            "car",
            "carrot",
            "castle",
            "cat",
            "ceiling fan",
            "cell phone",
            "cello",
            "chair",
            "chandelier",
            "church",
            "circle",
            "clarinet",
            "clock",
            "cloud",
            "coffee cup",
            "compass",
            "computer",
            "cookie",
            "cooler",
            "couch",
            "cow",
            "crab",
            "crayon",
            "crocodile",
            "crown",
            "cruise ship",
            "cup",
            "diamond",
            "dishwasher",
            "diving board",
            "dog",
            "dolphin",
            "donut",
            "door",
            "dragon",
            "dresser",
            "drill",
            "drums",
            "duck",
            "dumbbell",
            "ear",
            "elbow",
            "elephant",
            "envelope",
            "eraser",
            "eye",
            "eyeglasses",
            "face",
            "fan",
            "feather",
            "fence",
            "finger",
            "fire hydrant",
            "fireplace",
            "firetruck",
            "fish",
            "flamingo",
            "flashlight",
            "flip flops",
            "floor lamp",
            "flower",
            "flying saucer",
            "foot",
            "fork",
            "frog",
            "frying pan",
            "garden hose",
            "garden",
            "giraffe",
            "goatee",
            "golf club",
            "grapes",
            "grass",
            "guitar",
            "hamburger",
            "hammer",
            "hand",
            "harp",
            "hat",
            "headphones",
            "hedgehog",
            "helicopter",
            "helmet",
            "hexagon",
            "hockey puck",
            "hockey stick",
            "horse",
            "hospital",
            "hot air balloon",
            "hot dog",
            "hot tub",
            "hourglass",
            "house plant",
            "house",
            "hurricane",
            "ice cream",
            "jacket",
            "jail",
            "kangaroo",
            "key",
            "keyboard",
            "knee",
            "knife",
            "ladder",
            "lantern",
            "laptop",
            "leaf",
            "leg",
            "light bulb",
            "lighter",
            "lighthouse",
            "lightning",
            "line",
            "lion",
            "lipstick",
            "lobster",
            "lollipop",
            "mailbox",
            "map",
            "marker",
            "matches",
            "megaphone",
            "mermaid",
            "microphone",
            "microwave",
            "monkey",
            "moon",
            "mosquito",
            "motorbike",
            "mountain",
            "mouse",
            "moustache",
            "mouth",
            "mug",
            "mushroom",
            "nail",
            "necklace",
            "nose",
            "ocean",
            "octagon",
            "octopus",
            "onion",
            "oven",
            "owl",
            "paint can",
            "paintbrush",
            "palm tree",
            "panda",
            "pants",
            "paper clip",
            "parachute",
            "parrot",
            "passport",
            "peanut",
            "pear",
            "peas",
            "pencil",
            "penguin",
            "piano",
            "pickup truck",
            "picture frame",
            "pig",
            "pillow",
            "pineapple",
            "pizza",
            "pliers",
            "police car",
            "pond",
            "pool",
            "popsicle",
            "postcard",
            "potato",
            "power outlet",
            "purse",
            "rabbit",
            "raccoon",
            "radio",
            "rain",
            "rainbow",
            "rake",
            "remote control",
            "rhinoceros",
            "rifle",
            "river",
            "roller coaster",
            "rollerskates",
            "sailboat",
            "sandwich",
            "saw",
            "saxophone",
            "school bus",
            "scissors",
            "scorpion",
            "screwdriver",
            "sea turtle",
            "see saw",
            "shark",
            "sheep",
            "shoe",
            "shorts",
            "shovel",
            "sink",
            "skateboard",
            "skull",
            "skyscraper",
            "sleeping bag",
            "smiley face",
            "snail",
            "snake",
            "snorkel",
            "snowflake",
            "snowman",
            "soccer ball",
            "sock",
            "speedboat",
            "spider",
            "spoon",
            "spreadsheet",
            "square",
            "squiggle",
            "squirrel",
            "stairs",
            "star",
            "steak",
            "stereo",
            "stethoscope",
            "stitches",
            "stop sign",
            "stove",
            "strawberry",
            "streetlight",
            "string bean",
            "submarine",
            "suitcase",
            "sun",
            "swan",
            "sweater",
            "swing set",
            "sword",
            "syringe",
            "t-shirt",
            "table",
            "teapot",
            "teddy-bear",
            "telephone",
            "television",
            "tennis racquet",
            "tent",
            "The Eiffel Tower",
            "The Great Wall of China",
            "The Mona Lisa",
            "tiger",
            "toaster",
            "toe",
            "toilet",
            "tooth",
            "toothbrush",
            "toothpaste",
            "tornado",
            "tractor",
            "traffic light",
            "train",
            "tree",
            "triangle",
            "trombone",
            "truck",
            "trumpet",
            "umbrella",
            "underwear",
            "van",
            "vase",
            "violin",
            "washing machine",
            "watermelon",
            "waterslide",
            "whale",
            "wheel",
            "windmill",
            "wine bottle",
            "wine glass",
            "wristwatch",
            "yoga",
            "zebra",
            "zigzag"
        ],
        "id": null,
        "_type": "ClassLabel"
    },
    "drawing": {
        "shape": [
            null,
            3
        ],
        "dtype": "int16",
        "id": null,
        "_type": "Array2D"
    }
}
```


