/*
 @licstart  The following is the entire license notice for the JavaScript code in this file.

 The MIT License (MIT)

 Copyright (C) 1997-2020 by Dimitri van Heesch

 Permission is hereby granted, free of charge, to any person obtaining a copy of this software
 and associated documentation files (the "Software"), to deal in the Software without restriction,
 including without limitation the rights to use, copy, modify, merge, publish, distribute,
 sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in all copies or
 substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
 BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

 @licend  The above is the entire license notice for the JavaScript code in this file
*/
var NAVTREE =
[
  [ "Qore SmtpClient Module Reference", "index.html", [
    [ "SmtpClient Module @tableofcontents @section smtpclientintro SmtpClient Introduction The SmtpClient module provides a set of classes that can be used for easy communication with SMTP servers for sending emails, with or without TLS/SSL encryption. To use this module, use \\c \"requires SmtpClient\" in your code.  See examples/email.q for an example program using this module All the  symbols in the module are defined in the SmtpClient namespace Classes provided: - @ref SmtpClient::SmtpClient \"SmtpClient\": manages a connection to an SMTP server - @ref SmtpClient::SmtpConnection \"SmtpConnection\": provides a connection object to an SMTP server (based on the @ref connectionproviderintro \"ConnectionProvider\" module) The following supporting classes are provided by the MailMessage module: - MailMessage::Message: wraps a message to be sent via an @ref SmtpClient::SmtpClient \"SmtpClient\" object - MailMessage::Attachment: used to attach files to a MailMessage::Message object Note that the @ref SmtpClient::SmtpClient \"SmtpClient\" class automatically detects if the SMTP server supports ESMTP and a \\c \"EHLO\" command is executed automatically instead of \\c \"HELO\" if so.  Additionally, the class also automatically detects if the server supports the \\c \"STARTTLS\" command by parsing the response to the \\c \"EHLO\" command when talking to ESMTP servers. If the \\a tls flag is not set on the @ref SmtpClient::SmtpClient \"SmtpClient\" object and the server supports \\c \"STARTTLS\" (and a transport layer TLS/SSL connection was not already established), then the @ref SmtpClient::SmtpClient \"SmtpClient\" object will automatically execute a \\c \"STARTTLS\" command after connecting so that the rest of the SMTP session is performed securely.  This also allows transparent logins and communication with ESMTP servers that require secure connections. For the above reasons it's normally not required to use the \\c \"smtptls\" or \\c \"esmtptls\" protocols in the @ref SmtpClient::SmtpClient::constructor(string, *code, *code) \"SmtpClient::constructor(string, *code, *code)\" RL argument. @anchor smtpclient_protocols @ref SmtpClient::SmtpClient::constructor(string, *code, *code) \"SmtpClient::constructor(string, *code, *code)\" takes a URL argument, the protocol (scheme) component is handled as in the following table. <b>SmtpcClient Protocol Handling</b> |!Protocol|!Default Port|!Description |\\c \"smtp\"|25|standard SMTP port without encryption; ESMPT and \\c \"STARTTLS\" detection is supported automatically |\\c \"smtps\"|465|note that port 465 is currently assigned to source-specific multicast audio/video \\ (<a href=\"http://www.iana.org/assignments/port-numbers\">http://www.iana.org/assignments/port-numbers</a>); \\ its use as a port for secure SMTP listeners (where security is enforced at the transport layer because the \\ server immediately negotiates a TLS/SSL connection before the application protocol communication starts) is \\  but is included in this module because many SMTP servers still operate this way |\\c \"smtptls\"|25|a \\c \"STARTTLS\" command is executed unconditionally after the connection to ensure a secure \\ connection, even if the server does not declare support for this command in the login response.  It's \\ normally not necessary to use this protocol as \\c \"STARTTLS\" is used automatically when logging in to ESMTP \\ servers that declare support for this command in the response to the \\c \"EHLO\" command. |\\c \"esmtp\"|587|like \\c \"smtp\" just using port 587 |\\c \"esmtps\"|465|like \\c \"smtps\" |\\c \"esmtptls\"|587|like \\c \"smtptls\" just using port 587 @par Example: @code{.py} requires SmtpClient requires Mime Message msg(\"The Sender <sender@email.com>\", \"My Subject\"); msg.setBody(body); msg.addTO(\"My Best Friend <you@friend.com>\"); msg.attach(filename, Mime::MimeTypeText, data); code log = sub (string str) {printf(\"y: s\\n\", now_us(), str);}; SmtpClient::SmtpClient smtp(\"esmtptls://user@password:smtp.example.com\", log, log); smtp.sendMessage(msg);@endcode @section smtpclient_references SmtpClient References Based on: - http://james.apache.org/server/rfclist/smtp/rfc0821.txt - http://tools.ietf.org/html/rfc821: initial SMTP protocol spec - http://tools.ietf.org/html/rfc1521: quoted printable & base 64 transfer encodings - http://tools.ietf.org/html/rfc2045: mime headers, content types, etc - http://tools.ietf.org/html/rfc2047: \"Q\" and \"B\" encoded words (implemented by the Mime module) - http://tools.ietf.org/html/rfc2822: message structure, headers, body, etc @section smtpclient_relnotes SmtpClient Release Notes @subsection smtpclient_v2_1 SmtpClient 2.1 - added support for the data provider action catalog API (<a href=\"https://github.com/qorelanguage/qore/issues/4808\">issue 4808</a>) @subsection smtpclient_v2_0 SmtpClient 2.0 - added support for the DataProvider API (<a href=\"https://github.com/qorelanguage/qore/issues/4564\">issue 4564</a>) @subsection smtpclient_v1_9_3 SmtpClient 1.9.3 - fixed message serialization for SMTP handling in case of single \\c \".\" characters on a line in serialized data (issue <a href=\"https://github.com/qorelanguage/qore/issues/3275\">issue 3275</a>) @subsection smtpclient_v1_9_2 SmtpClient 1.9.2 - implemented support for a data provider scheme cache and rich option information for connections (<a href=\"https://github.com/qorelanguage/qore/issues/4025\">issue 4025</a>) @subsection smtpclient_v1_9_1 SmtpClient 1.9.1 - fixed type errors sending mails (<a href=\"https://github.com/qorelanguage/qore/issues/3813\">issue 3813</a>) @subsection smtpclient_v1_9 SmtpClient 1.9 - added the \\c \"estmps\" scheme for completeness (<a href=\"https://github.com/qorelanguage/qore/issues/2833\">issue 2833</a>) @subsection smtpclient_v1_8 SmtpClient 1.8 - removed the \\c SmtpConnection::getConstructorInfo() and \\c SmtpConnection::getConstructorInfoImpl() methods (<a href=\"https://github.com/qorelanguage/qore/issues/3696\">issue 3696</a>) - added support for socket events (<a href=\"https://github.com/qorelanguage/qore/issues/3425\">issue 3425</a>) @subsection smtpclient_v1_7 SmtpClient 1.7 - added the \\c SmtpConnection::getConstructorInfo() method to allow connections to be created dynamically, potentially in another process from a network call (removed in SmtpClient 1.8) (<a href=\"https://github.com/qorelanguage/qore/issues/2628\">issue 2628</a>) @subsection smtpclient_v1_6 SmtpClient 1.6 - added the @ref SmtpClient::SmtpConnection \"SmtpConnection\" class to support the <a href=\"../../ConnectionProvider/html/index.html\">ConnectionProvider</a> module - updated for complex types @subsection smtpclient_v1_5 SmtpClient 1.5 - converted to @ref new-style \"new-style\" @subsection smtpclient_v1_4 SmtpClient 1.4 - fixed missing username and missing password errors @subsection smtpclient_v1_3 SmtpClient 1.3 - added socket instrumention support from Qore 0.8.9 - optimized connection and login code; HELO/EHLO and authorization are performed when connecting only; not before each email @subsection smtpclient_v1_2 SmtpClient 1.2 - added support for parsing a full URL in the SmtpClient::constructor(); added protocol support and setting the username / password from the URL - use Message::checkSendPossible() to throw a more descriptive exception if the message is incomplete and not ready to be sent - implemented support for automatically detecting if the server accepts the STARTTLS command and, if so, automatically setting the STARTTLS flag if it's not already set @subsection smtpclient_v1_1 SmtpClient 1.1 - removed the Message and Attachment classes to the MailMessage module to be reused in the Pop3Client module @subsection smtpclient_v1_10 SmtpClient 1.0 - updated to a user module, added initial rudimentary ESMTP handling, STARTTLS and quoted-printable encoding support + documentation", "index.html", null ],
    [ "Classes", "annotated.html", [
      [ "Class List", "annotated.html", "annotated_dup" ],
      [ "Class Index", "classes.html", null ],
      [ "Class Members", "functions.html", [
        [ "All", "functions.html", null ],
        [ "Functions", "functions_func.html", null ],
        [ "Variables", "functions_vars.html", null ]
      ] ]
    ] ]
  ] ]
];

var NAVTREEINDEX =
[
"annotated.html"
];

var SYNCONMSG = 'click to disable panel synchronisation';
var SYNCOFFMSG = 'click to enable panel synchronisation';