/*
 *             Copyright Andrey Semashev 2018.
 * Distributed under the Boost Software License, Version 1.0.
 *    (See accompanying file LICENSE_1_0.txt or copy at
 *          http://www.boost.org/LICENSE_1_0.txt)
 */
/*!
 * \file   thread_pool_abi.cpp
 * \author Andrey Semashev
 * \date   10.03.2018
 *
 * \brief  This file contains ABI test for thread_pool.hpp
 */

#include <boost/winapi/thread_pool.hpp>
#include <windows.h>
#include "abi_test_tools.hpp"

int main()
{
#if BOOST_USE_WINAPI_VERSION >= BOOST_WINAPI_VERSION_WIN2K

    BOOST_WINAPI_TEST_CONSTANT(WT_EXECUTEDEFAULT);
    BOOST_WINAPI_TEST_CONSTANT(WT_EXECUTEINIOTHREAD);
#if !defined(BOOST_WINAPI_IS_MINGW)
    BOOST_WINAPI_TEST_CONSTANT(WT_EXECUTEINUITHREAD);
#endif
    BOOST_WINAPI_TEST_CONSTANT(WT_EXECUTEINWAITTHREAD);
    BOOST_WINAPI_TEST_CONSTANT(WT_EXECUTEONLYONCE);
    BOOST_WINAPI_TEST_CONSTANT(WT_EXECUTEINTIMERTHREAD);
    BOOST_WINAPI_TEST_CONSTANT(WT_EXECUTELONGFUNCTION);
#if !defined(BOOST_WINAPI_IS_MINGW)
    BOOST_WINAPI_TEST_CONSTANT(WT_EXECUTEINPERSISTENTIOTHREAD);
#endif
    BOOST_WINAPI_TEST_CONSTANT(WT_EXECUTEINPERSISTENTTHREAD);
    BOOST_WINAPI_TEST_CONSTANT(WT_TRANSFER_IMPERSONATION);

#if BOOST_WINAPI_PARTITION_DESKTOP
    BOOST_WINAPI_TEST_TYPE_SAME(WAITORTIMERCALLBACKFUNC);
    BOOST_WINAPI_TEST_TYPE_SAME(WAITORTIMERCALLBACK);

    BOOST_WINAPI_TEST_FUNCTION_SIGNATURE(RegisterWaitForSingleObject);
    BOOST_WINAPI_TEST_FUNCTION_SIGNATURE(UnregisterWait);
#endif

#if BOOST_WINAPI_PARTITION_DESKTOP || BOOST_WINAPI_PARTITION_SYSTEM
    BOOST_WINAPI_TEST_FUNCTION_SIGNATURE(UnregisterWaitEx);
#endif

#endif // BOOST_USE_WINAPI_VERSION >= BOOST_WINAPI_VERSION_WIN2K

    return boost::report_errors();
}
