/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.contracts;

import org.eclipse.fordiac.ide.contracts.model.Contract;
import org.eclipse.fordiac.ide.model.commands.change.ChangeCommentCommand;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.gef.commands.Command;

public class EvaluateContractOnlyCommand
extends Command {
    private ChangeCommentCommand cccmd;
    private final Contract contract;

    EvaluateContractOnlyCommand(Contract contract) {
        if (contract == null) {
            throw new IllegalArgumentException();
        }
        this.contract = contract;
    }

    public void execute() {
        FBNetworkElement owner = this.contract.getOwner();
        boolean isValid = this.contract.isValid();
        StringBuilder comment = new StringBuilder();
        if (isValid) {
            comment.append(this.contract.getAsString());
        } else {
            String oldComment = owner.getComment();
            int pos = oldComment.indexOf("ConstractState");
            if (pos == -1) {
                pos = oldComment.length();
            }
            comment.append(oldComment.subSequence(0, pos));
        }
        comment.append("\nConstractState(This contract only):");
        if (isValid) {
            comment.append(" Contract is Valid");
        } else {
            comment.append(" Contract is not Valid \n");
            comment.append(this.contract.getError());
        }
        this.cccmd = new ChangeCommentCommand((INamedElement)owner, comment.toString());
        if (this.cccmd.canExecute()) {
            this.cccmd.execute();
        }
    }

    public void undo() {
        this.cccmd.undo();
    }

    public void redo() {
        this.cccmd.redo();
    }
}

