/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.eval.fb;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.fordiac.ide.model.eval.Evaluator;
import org.eclipse.fordiac.ide.model.eval.EvaluatorFactory;
import org.eclipse.fordiac.ide.model.eval.fb.FBEvaluator;
import org.eclipse.fordiac.ide.model.eval.variable.FBVariable;
import org.eclipse.fordiac.ide.model.eval.variable.Variable;
import org.eclipse.fordiac.ide.model.libraryElement.Algorithm;
import org.eclipse.fordiac.ide.model.libraryElement.BaseFBType;
import org.eclipse.fordiac.ide.model.libraryElement.FB;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.ICallable;
import org.eclipse.fordiac.ide.model.libraryElement.Method;

public abstract class BaseFBEvaluator<T extends BaseFBType>
extends FBEvaluator<T> {
    private final Map<Algorithm, Evaluator> algorithmEvaluators;
    private final Map<FB, FBEvaluator<?>> internalFBEvaluators;

    protected BaseFBEvaluator(T type, Variable<?> context, Iterable<Variable<?>> variables, Evaluator parent) {
        super(type, context, variables, parent);
        this.algorithmEvaluators = type.getAlgorithm().stream().collect(Collectors.toUnmodifiableMap(Function.identity(), this::createAlgorithmEvaluator));
        this.internalFBEvaluators = type.getInternalFbs().stream().collect(Collectors.toUnmodifiableMap(Function.identity(), this::createInternalFBEvaluator));
    }

    @Override
    public void prepare() {
        this.algorithmEvaluators.values().forEach(Evaluator::prepare);
        this.internalFBEvaluators.values().forEach(Evaluator::prepare);
    }

    @Override
    public Set<String> getDependencies() {
        return Stream.concat(Stream.of(super.getDependencies()), Stream.concat(this.algorithmEvaluators.values().stream(), ((BaseFBType)this.getType()).getMethods().stream().map(this::createMethodEvaluator)).map(Evaluator::getDependencies)).flatMap(Collection::stream).collect(Collectors.toUnmodifiableSet());
    }

    @Override
    public Map<? extends ICallable, ? extends Evaluator> getChildren() {
        return Stream.of(this.algorithmEvaluators, this.internalFBEvaluators).map(Map::entrySet).flatMap(Collection::stream).collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public Map<Algorithm, Evaluator> getAlgorithmEvaluators() {
        return this.algorithmEvaluators;
    }

    public Map<FB, FBEvaluator<?>> getInternalFBEvaluators() {
        return this.internalFBEvaluators;
    }

    protected Evaluator createAlgorithmEvaluator(Algorithm algorithm) {
        return EvaluatorFactory.createEvaluator(algorithm, algorithm.eClass().getInstanceClass().asSubclass(Algorithm.class), this.getContext(), Collections.emptySet(), this);
    }

    protected Evaluator createMethodEvaluator(Method method) {
        return EvaluatorFactory.createEvaluator(method, method.eClass().getInstanceClass().asSubclass(Method.class), this.getContext(), Collections.emptySet(), this);
    }

    protected FBEvaluator<?> createInternalFBEvaluator(FB internalFB) {
        return (FBEvaluator)EvaluatorFactory.createEvaluator(internalFB.getType(), internalFB.getType().eClass().getInstanceClass().asSubclass(FBType.class), this.getContext(), ((FBVariable)this.getContext().getMembers().get(internalFB.getName())).getMembers().values(), this);
    }
}

