/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.eval.fb;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.fordiac.ide.model.eval.Evaluator;
import org.eclipse.fordiac.ide.model.eval.EvaluatorException;
import org.eclipse.fordiac.ide.model.eval.EvaluatorFactory;
import org.eclipse.fordiac.ide.model.eval.fb.FBEvaluator;
import org.eclipse.fordiac.ide.model.eval.fb.FBEvaluatorEventQueue;
import org.eclipse.fordiac.ide.model.eval.value.Value;
import org.eclipse.fordiac.ide.model.eval.variable.Variable;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.ICallable;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.With;

public class SamplingFBEvaluator
extends FBEvaluator<FBType> {
    private final FBEvaluator<?> delegate;

    public SamplingFBEvaluator(FBType type, Variable<?> context, Iterable<Variable<?>> variables, Evaluator parent) {
        super(type, context, variables, parent);
        this.delegate = (FBEvaluator)EvaluatorFactory.createEvaluator(type, type.eClass().getInstanceClass().asSubclass(FBType.class), this.getContext(), Collections.emptySet(), this);
        this.delegate.getContext().setValue(this.getContext().getValue());
        this.delegate.setEventQueue(new SamplingEventQueue());
    }

    @Override
    public void prepare() {
        this.delegate.prepare();
    }

    @Override
    public void evaluate(Event event) throws EvaluatorException, InterruptedException {
        this.getVariables(event).forEach(this::readData);
        this.delegate.evaluate(event);
    }

    @Override
    protected boolean sendOutputEvent(Event event) {
        List<Variable<?>> variables = this.getVariables(event);
        variables.forEach(this::writeData);
        this.update(variables);
        return super.sendOutputEvent(event);
    }

    private void readData(Variable<?> variable) {
        Variable<?> inner = this.getDelegateVariable(variable);
        if (inner != null) {
            inner.setValue((Value)variable.getValue());
        }
    }

    private void writeData(Variable<?> variable) {
        Variable<?> inner = this.getDelegateVariable(variable);
        if (inner != null) {
            variable.setValue((Value)inner.getValue());
        }
    }

    private List<Variable<?>> getVariables(Event event) {
        return event.getWith().stream().map(With::getVariables).map(INamedElement::getName).map(this.getVariables()::get).filter(Objects::nonNull).toList();
    }

    private Variable<?> getDelegateVariable(Variable<?> variable) {
        return this.delegate.getContext().getValue().get(variable.getName());
    }

    @Override
    public Set<String> getDependencies() {
        return this.delegate.getDependencies();
    }

    @Override
    public void reset(Iterable<Variable<?>> variables) {
        super.reset(variables);
        this.delegate.reset(Collections.emptySet());
    }

    @Override
    public Map<? extends ICallable, ? extends Evaluator> getChildren() {
        return Map.of(this.getType(), this.delegate);
    }

    public FBEvaluator<?> getDelegate() {
        return this.delegate;
    }

    private class SamplingEventQueue
    implements FBEvaluatorEventQueue {
        private SamplingEventQueue() {
        }

        @Override
        public Event receiveInputEvent() throws InterruptedException {
            return null;
        }

        @Override
        public boolean sendOutputEvent(Event event) {
            return SamplingFBEvaluator.this.sendOutputEvent(event);
        }
    }
}

