/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.search;

import java.util.Collection;
import java.util.Objects;
import java.util.stream.Stream;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.URI;
import org.eclipse.fordiac.ide.model.search.AbstractLiveSearchContext;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibrary;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibraryManager;

public class LiveSearchContext
extends AbstractLiveSearchContext {
    public LiveSearchContext(IProject project) {
        super(Objects.requireNonNull(TypeLibraryManager.INSTANCE.getTypeLibrary(project)));
    }

    public LiveSearchContext(TypeLibrary typelib) {
        super(Objects.requireNonNull(typelib));
    }

    @Override
    public Stream<URI> getTypes() {
        return this.getTypelib().getAllTypes().stream().map(TypeEntry::getURI).filter(Objects::nonNull);
    }

    @Override
    public Collection<URI> getAllTypes() {
        return this.getTypelib().getAllTypes().stream().map(TypeEntry::getURI).filter(Objects::nonNull).toList();
    }

    @Override
    public Collection<URI> getSubappTypes() {
        return this.getTypelib().getSubAppTypes().stream().map(TypeEntry::getURI).filter(Objects::nonNull).toList();
    }

    @Override
    public Collection<URI> getFBTypes() {
        return this.getTypelib().getFbTypes().stream().map(TypeEntry::getURI).filter(Objects::nonNull).toList();
    }
}

