/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.search.dialog;

import java.util.Set;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.ITypedElement;
import org.eclipse.fordiac.ide.model.libraryElement.StructManipulator;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.fordiac.ide.model.search.Messages;
import org.eclipse.fordiac.ide.model.search.SearchNameDictionary;
import org.eclipse.fordiac.ide.model.search.dialog.AbstractTypeEntryDataHandler;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;
import org.eclipse.fordiac.ide.ui.FordiacMessages;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.widgets.LabelFactory;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.Widget;

public class FBTypeSearchResultTable
extends Composite {
    protected static final int TABLE_COL_WIDTH = 150;
    private ColumnLabelProvider labelElement;
    private ColumnLabelProvider labelPath;
    private ColumnLabelProvider labelType;
    private ColumnLabelProvider labelDataType;
    final AbstractTypeEntryDataHandler<? extends TypeEntry> dataHandler;
    private static final SearchNameDictionary dictionary = new SearchNameDictionary();

    public FBTypeSearchResultTable(Composite parent, AbstractTypeEntryDataHandler<? extends TypeEntry> data) {
        this(parent, 0, data);
    }

    public FBTypeSearchResultTable(Composite parent, int style, AbstractTypeEntryDataHandler<? extends TypeEntry> data) {
        super(parent, style);
        this.dataHandler = data;
        this.createTreeViewer();
    }

    private Control createTreeViewer() {
        this.setLayout((Layout)new GridLayout(1, true));
        this.setLayoutData(new GridData(4, 4, true, true));
        if (this.dataHandler.loadInputSet()) {
            Label warningLabel = (Label)LabelFactory.newLabel((int)0).create((Widget)this);
            warningLabel.setText("No additional function blocks or types have been affected by this change!");
        } else {
            Label label = new Label(this.getParent(), 0);
            label.setText("Number of instances of " + this.dataHandler.typeEntry.getTypeName() + " : " + this.dataHandler.getInputSet().size());
            TreeViewer treeViewer = new TreeViewer((Composite)this);
            this.configureTableViewer(treeViewer);
            treeViewer.setInput(this.dataHandler.getInputSet().keySet());
            GridLayoutFactory.fillDefaults().generateLayout((Composite)this);
        }
        return this.getParent();
    }

    private void createLabelProviders() {
        this.labelElement = new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof INamedElement) {
                    INamedElement namedElem = (INamedElement)element;
                    return namedElem.getName();
                }
                return super.getText(element);
            }
        };
        this.labelPath = new ColumnLabelProvider(){

            public String getText(Object element) {
                return dictionary.hierarchicalName(element);
            }
        };
        this.labelType = new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof SubApp) {
                    SubApp subapp = (SubApp)element;
                    return subapp.isTyped() ? "Typed SubApp" : "Untyped SubApp";
                }
                if (element instanceof IInterfaceElement || element instanceof StructManipulator) {
                    return ((ITypedElement)element).getTypeName();
                }
                return element.getClass().getSimpleName();
            }
        };
        this.labelDataType = new ColumnLabelProvider(){

            public String getText(Object element) {
                if (FBTypeSearchResultTable.this.dataHandler.getTypeOfElement(element) != null) {
                    return FBTypeSearchResultTable.this.dataHandler.getTypeOfElement(element).getTypeEditable().getName();
                }
                return element.getClass().getSimpleName();
            }
        };
    }

    private static TableLayout createTableLayout() {
        TableLayout layout = new TableLayout();
        layout.addColumnData((ColumnLayoutData)new ColumnPixelData(150));
        layout.addColumnData((ColumnLayoutData)new ColumnPixelData(150));
        layout.addColumnData((ColumnLayoutData)new ColumnPixelData(150));
        layout.addColumnData((ColumnLayoutData)new ColumnPixelData(150));
        return layout;
    }

    protected void configureTableViewer(final TreeViewer viewer) {
        this.createLabelProviders();
        viewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public Object[] getElements(Object inputElement) {
                return ArrayContentProvider.getInstance().getElements(inputElement);
            }

            public Object[] getChildren(Object parentElement) {
                if (parentElement instanceof FBType) {
                    FBType type = (FBType)parentElement;
                    return FBTypeSearchResultTable.this.dataHandler.getChild(type.getName()).toArray();
                }
                return new Object[0];
            }

            public Object getParent(Object element) {
                SubApp subApp;
                if (element instanceof SubApp && !(subApp = (SubApp)element).isTyped()) {
                    return null;
                }
                if (element instanceof FBNetworkElement) {
                    FBNetworkElement elem = (FBNetworkElement)element;
                    return elem.getType();
                }
                return null;
            }

            public boolean hasChildren(Object element) {
                if (element instanceof FBType) {
                    FBType type = (FBType)element;
                    Set<INamedElement> child = FBTypeSearchResultTable.this.dataHandler.getChild(type.getName());
                    return child != null && !child.isEmpty();
                }
                return false;
            }
        });
        final Tree table = viewer.getTree();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.setLayout((Layout)FBTypeSearchResultTable.createTableLayout());
        table.setSortDirection(1024);
        SelectionListener sortListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TreeColumn selectedColumn = (TreeColumn)e.getSource();
                if (!table.getSortColumn().equals(selectedColumn)) {
                    table.setSortColumn(selectedColumn);
                } else {
                    table.setSortDirection(table.getSortDirection() == 1024 ? 128 : 1024);
                }
                table.redraw();
                viewer.refresh();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
        final TreeViewerColumn colElement = new TreeViewerColumn(viewer, 16384);
        colElement.getColumn().setText(Messages.Element);
        colElement.setLabelProvider((CellLabelProvider)this.labelElement);
        table.setSortColumn(colElement.getColumn());
        colElement.getColumn().addSelectionListener(sortListener);
        final TreeViewerColumn colPath = new TreeViewerColumn(viewer, 16384);
        colPath.getColumn().setText(Messages.Location);
        colPath.setLabelProvider((CellLabelProvider)this.labelPath);
        colPath.getColumn().addSelectionListener(sortListener);
        final TreeViewerColumn colType = new TreeViewerColumn(viewer, 16384);
        colType.getColumn().setText(FordiacMessages.Type);
        colType.setLabelProvider((CellLabelProvider)this.labelType);
        colType.getColumn().addSelectionListener(sortListener);
        final TreeViewerColumn colDataType = new TreeViewerColumn(viewer, 16384);
        colDataType.getColumn().setText(FordiacMessages.DataType);
        colDataType.setLabelProvider((CellLabelProvider)this.labelDataType);
        colDataType.getColumn().addSelectionListener(sortListener);
        viewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                TreeColumn sortCol = table.getSortColumn();
                String s1 = "";
                String s2 = "";
                if (sortCol.equals(colElement.getColumn())) {
                    s1 = FBTypeSearchResultTable.this.labelElement.getText(e1);
                    s2 = FBTypeSearchResultTable.this.labelElement.getText(e2);
                } else if (sortCol.equals(colPath.getColumn())) {
                    s1 = FBTypeSearchResultTable.this.labelPath.getText(e1);
                    s2 = FBTypeSearchResultTable.this.labelPath.getText(e2);
                } else if (sortCol.equals(colType.getColumn())) {
                    s1 = FBTypeSearchResultTable.this.labelType.getText(e1);
                    s2 = FBTypeSearchResultTable.this.labelType.getText(e2);
                } else if (sortCol.equals(colDataType.getColumn())) {
                    s1 = FBTypeSearchResultTable.this.labelDataType.getText(e1);
                    s2 = FBTypeSearchResultTable.this.labelDataType.getText(e2);
                }
                return table.getSortDirection() == 1024 ? s1.compareTo(s2) : s2.compareTo(s1);
            }
        });
    }
}

