/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.typelibrary.impl;

import java.util.Scanner;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.fordiac.ide.model.dataexport.AbstractTypeExporter;
import org.eclipse.fordiac.ide.model.dataexport.FbtExporter;
import org.eclipse.fordiac.ide.model.dataimport.BlockTypeImporter;
import org.eclipse.fordiac.ide.model.dataimport.FBTImporter;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementPackage;
import org.eclipse.fordiac.ide.model.typelibrary.FBTypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.impl.AbstractInterfaceTypeEntryImpl;
import org.eclipse.fordiac.ide.ui.FordiacLogHelper;

public class FBTypeEntryImpl
extends AbstractInterfaceTypeEntryImpl<FBType>
implements FBTypeEntry {
    private static final Pattern TYPE_CLASS_PATTERN = Pattern.compile("<BasicFB>|<FBNetwork>|<SimpleFB>");
    private final AtomicReference<EClass> typeEClass = new AtomicReference();

    public FBTypeEntryImpl() {
        super(FBType.class);
    }

    @Override
    protected BlockTypeImporter getImporter() {
        return new FBTImporter(this.getFile());
    }

    @Override
    protected AbstractTypeExporter getTypeExporter(FBType type) {
        return new FbtExporter(type);
    }

    @Override
    protected synchronized NotificationChain basicSetType(LibraryElement type, NotificationChain notifications) {
        if (type instanceof FBType) {
            this.typeEClass.set(type.eClass());
        }
        return super.basicSetType(type, notifications);
    }

    @Override
    public EClass getTypeEClass() {
        EClass result = this.typeEClass.get();
        if (result == null) {
            result = this.loadTypeEClassFromFile();
            this.typeEClass.compareAndSet(null, result);
        }
        return result;
    }

    private EClass loadTypeEClassFromFile() {
        IFile file = this.getFile();
        if (file != null && file.exists()) {
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (Scanner scanner = new Scanner(file.getContents());){
                    String match = scanner.findWithinHorizon(TYPE_CLASS_PATTERN, 0);
                    if (match != null) {
                        String typeClassString = match.substring(1, match.length() - 1);
                        if ("BasicFB".equals(typeClassString)) {
                            return LibraryElementPackage.Literals.BASIC_FB_TYPE;
                        }
                        if ("FBNetwork".equals(typeClassString)) {
                            return LibraryElementPackage.Literals.COMPOSITE_FB_TYPE;
                        }
                        if ("SimpleFB".equals(typeClassString)) {
                            return LibraryElementPackage.Literals.SIMPLE_FB_TYPE;
                        }
                    }
                    return LibraryElementPackage.Literals.SERVICE_INTERFACE_FB_TYPE;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                FordiacLogHelper.logWarning((String)e.getMessage(), (Exception)e);
            }
        }
        return LibraryElementPackage.Literals.FB_TYPE;
    }

    @Override
    public String getFileExtension() {
        return "FBT";
    }
}

