/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.set.mutable.primitive;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Arrays;
import java.util.NoSuchElementException;
import org.eclipse.collections.api.ByteIterable;
import org.eclipse.collections.api.LazyByteIterable;
import org.eclipse.collections.api.LazyIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.primitive.MutableByteBag;
import org.eclipse.collections.api.block.function.primitive.ByteToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectByteToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.BytePredicate;
import org.eclipse.collections.api.block.procedure.primitive.ByteProcedure;
import org.eclipse.collections.api.factory.Lists;
import org.eclipse.collections.api.factory.Sets;
import org.eclipse.collections.api.factory.primitive.ByteBags;
import org.eclipse.collections.api.factory.primitive.ByteLists;
import org.eclipse.collections.api.iterator.ByteIterator;
import org.eclipse.collections.api.iterator.MutableByteIterator;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.list.primitive.MutableByteList;
import org.eclipse.collections.api.set.ImmutableSet;
import org.eclipse.collections.api.set.MutableSet;
import org.eclipse.collections.api.set.primitive.ByteSet;
import org.eclipse.collections.api.set.primitive.ImmutableByteSet;
import org.eclipse.collections.api.set.primitive.MutableByteSet;
import org.eclipse.collections.api.tuple.primitive.ByteBytePair;
import org.eclipse.collections.impl.block.procedure.checked.primitive.CheckedByteProcedure;
import org.eclipse.collections.impl.factory.primitive.ByteSets;
import org.eclipse.collections.impl.lazy.primitive.LazyByteIterableAdapter;
import org.eclipse.collections.impl.set.immutable.primitive.ImmutableByteSetSerializationProxy;
import org.eclipse.collections.impl.set.mutable.primitive.BoxedMutableByteSet;
import org.eclipse.collections.impl.set.mutable.primitive.SynchronizedByteSet;
import org.eclipse.collections.impl.set.mutable.primitive.UnmodifiableByteSet;

public final class ByteHashSet
implements MutableByteSet,
Externalizable {
    private static final long serialVersionUID = 1L;
    private static final byte MAX_BYTE_GROUP_1 = -65;
    private static final byte MAX_BYTE_GROUP_2 = -1;
    private static final byte MAX_BYTE_GROUP_3 = 63;
    private long bitGroup1;
    private long bitGroup2;
    private long bitGroup3;
    private long bitGroup4;
    private short size;

    public ByteHashSet() {
    }

    @Deprecated
    public ByteHashSet(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("initial capacity cannot be less than 0");
        }
    }

    public ByteHashSet(byte ... elements) {
        this();
        this.addAll(elements);
    }

    public ByteHashSet(ByteHashSet set) {
        this.size = set.size;
        this.bitGroup3 = set.bitGroup3;
        this.bitGroup4 = set.bitGroup4;
        this.bitGroup1 = set.bitGroup1;
        this.bitGroup2 = set.bitGroup2;
    }

    public MutableSet<Byte> boxed() {
        return new BoxedMutableByteSet(this);
    }

    public static ByteHashSet newSet(ByteIterable source) {
        if (source instanceof ByteHashSet) {
            return new ByteHashSet((ByteHashSet)source);
        }
        return ByteHashSet.newSetWith(source.toArray());
    }

    public static ByteHashSet newSetWith(byte ... source) {
        return new ByteHashSet(source);
    }

    public boolean add(byte element) {
        if (element <= -65) {
            long initial = this.bitGroup1;
            this.bitGroup1 |= 1L << (byte)((element + 1) * -1);
            if (this.bitGroup1 != initial) {
                this.size = (short)(this.size + 1);
                return true;
            }
        } else if (element <= -1) {
            long initial = this.bitGroup2;
            this.bitGroup2 |= 1L << (byte)((element + 1) * -1);
            if (this.bitGroup2 != initial) {
                this.size = (short)(this.size + 1);
                return true;
            }
        } else if (element <= 63) {
            long initial = this.bitGroup3;
            this.bitGroup3 |= 1L << element;
            if (this.bitGroup3 != initial) {
                this.size = (short)(this.size + 1);
                return true;
            }
        } else {
            long initial = this.bitGroup4;
            this.bitGroup4 |= 1L << element;
            if (this.bitGroup4 != initial) {
                this.size = (short)(this.size + 1);
                return true;
            }
        }
        return false;
    }

    public boolean remove(byte value) {
        if (value <= -65) {
            long initial = this.bitGroup1;
            this.bitGroup1 &= 1L << (byte)((value + 1) * -1) ^ 0xFFFFFFFFFFFFFFFFL;
            if (this.bitGroup1 == initial) {
                return false;
            }
            this.size = (short)(this.size - 1);
            return true;
        }
        if (value <= -1) {
            long initial = this.bitGroup2;
            this.bitGroup2 &= 1L << (byte)((value + 1) * -1) ^ 0xFFFFFFFFFFFFFFFFL;
            if (this.bitGroup2 == initial) {
                return false;
            }
            this.size = (short)(this.size - 1);
            return true;
        }
        if (value <= 63) {
            long initial = this.bitGroup3;
            this.bitGroup3 &= 1L << value ^ 0xFFFFFFFFFFFFFFFFL;
            if (this.bitGroup3 == initial) {
                return false;
            }
            this.size = (short)(this.size - 1);
            return true;
        }
        long initial = this.bitGroup4;
        this.bitGroup4 &= 1L << value ^ 0xFFFFFFFFFFFFFFFFL;
        if (this.bitGroup4 == initial) {
            return false;
        }
        this.size = (short)(this.size - 1);
        return true;
    }

    public boolean contains(byte value) {
        if (value <= -65) {
            return (this.bitGroup1 >>> (byte)((value + 1) * -1) & 1L) != 0L;
        }
        if (value <= -1) {
            return (this.bitGroup2 >>> (byte)((value + 1) * -1) & 1L) != 0L;
        }
        if (value <= 63) {
            return (this.bitGroup3 >>> value & 1L) != 0L;
        }
        return (this.bitGroup4 >>> value & 1L) != 0L;
    }

    public LazyIterable<ByteBytePair> cartesianProduct(ByteSet set) {
        return ByteSets.cartesianProduct((ByteSet)this, set);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ByteSet)) {
            return false;
        }
        ByteSet other = (ByteSet)obj;
        return this.size() == other.size() && this.containsAll(other.toArray());
    }

    public int hashCode() {
        return (int)this.sum();
    }

    public String toString() {
        return this.makeString("[", ", ", "]");
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean notEmpty() {
        return this.size() != 0;
    }

    public String makeString() {
        return this.makeString(", ");
    }

    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            int count = 0;
            MutableByteIterator iterator = this.byteIterator();
            while (iterator.hasNext()) {
                if (count > 0) {
                    appendable.append(separator);
                }
                ++count;
                appendable.append(String.valueOf(iterator.next()));
            }
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean addAll(byte ... source) {
        int oldSize = this.size();
        for (byte item : source) {
            this.add(item);
        }
        return this.size() != oldSize;
    }

    public boolean addAll(ByteIterable source) {
        if (source.isEmpty()) {
            return false;
        }
        int oldSize = this.size();
        if (source instanceof ByteHashSet) {
            ByteHashSet hashSet = (ByteHashSet)source;
            this.size = 0;
            this.bitGroup3 |= hashSet.bitGroup3;
            this.size = (short)(this.size + Long.bitCount(this.bitGroup3));
            this.bitGroup4 |= hashSet.bitGroup4;
            this.size = (short)(this.size + Long.bitCount(this.bitGroup4));
            this.bitGroup2 |= hashSet.bitGroup2;
            this.size = (short)(this.size + Long.bitCount(this.bitGroup2));
            this.bitGroup1 |= hashSet.bitGroup1;
            this.size = (short)(this.size + Long.bitCount(this.bitGroup1));
        } else {
            ByteIterator iterator = source.byteIterator();
            while (iterator.hasNext()) {
                byte item = iterator.next();
                this.add(item);
            }
        }
        return this.size() != oldSize;
    }

    public boolean removeAll(ByteIterable source) {
        if (source.isEmpty()) {
            return false;
        }
        int oldSize = this.size();
        if (source instanceof ByteHashSet) {
            this.size = 0;
            ByteHashSet hashSet = (ByteHashSet)source;
            this.bitGroup3 &= hashSet.bitGroup3 ^ 0xFFFFFFFFFFFFFFFFL;
            this.size = (short)(this.size + Long.bitCount(this.bitGroup3));
            this.bitGroup4 &= hashSet.bitGroup4 ^ 0xFFFFFFFFFFFFFFFFL;
            this.size = (short)(this.size + Long.bitCount(this.bitGroup4));
            this.bitGroup2 &= hashSet.bitGroup2 ^ 0xFFFFFFFFFFFFFFFFL;
            this.size = (short)(this.size + Long.bitCount(this.bitGroup2));
            this.bitGroup1 &= hashSet.bitGroup1 ^ 0xFFFFFFFFFFFFFFFFL;
            this.size = (short)(this.size + Long.bitCount(this.bitGroup1));
        } else {
            ByteIterator iterator = source.byteIterator();
            while (iterator.hasNext()) {
                byte item = iterator.next();
                this.remove(item);
            }
        }
        return this.size() != oldSize;
    }

    public boolean removeAll(byte ... source) {
        if (source.length == 0) {
            return false;
        }
        int oldSize = this.size();
        for (byte item : source) {
            this.remove(item);
        }
        return this.size() != oldSize;
    }

    public boolean retainAll(ByteIterable source) {
        int oldSize = this.size();
        ByteSet sourceSet = source instanceof ByteSet ? (ByteSet)source : source.toSet();
        ByteHashSet retained = this.select(arg_0 -> ((ByteSet)sourceSet).contains(arg_0));
        if (retained.size() != oldSize) {
            this.bitGroup3 = retained.bitGroup3;
            this.bitGroup4 = retained.bitGroup4;
            this.bitGroup1 = retained.bitGroup1;
            this.bitGroup2 = retained.bitGroup2;
            this.size = retained.size;
            return true;
        }
        return false;
    }

    public boolean retainAll(byte ... source) {
        return this.retainAll((ByteIterable)ByteHashSet.newSetWith(source));
    }

    public void clear() {
        this.size = 0;
        this.bitGroup3 = 0L;
        this.bitGroup4 = 0L;
        this.bitGroup1 = 0L;
        this.bitGroup2 = 0L;
    }

    public ByteHashSet with(byte element) {
        this.add(element);
        return this;
    }

    public ByteHashSet without(byte element) {
        this.remove(element);
        return this;
    }

    public ByteHashSet withAll(ByteIterable elements) {
        this.addAll(elements.toArray());
        return this;
    }

    public ByteHashSet withoutAll(ByteIterable elements) {
        this.removeAll(elements);
        return this;
    }

    public MutableByteSet asUnmodifiable() {
        return new UnmodifiableByteSet(this);
    }

    public MutableByteSet asSynchronized() {
        return new SynchronizedByteSet(this);
    }

    public ImmutableByteSet toImmutable() {
        if (this.size() == 0) {
            return ByteSets.immutable.with();
        }
        if (this.size() == 1) {
            return ByteSets.immutable.with(this.byteIterator().next());
        }
        ByteHashSet mutableSet = ByteHashSet.newSetWith(this.toArray());
        return new ImmutableByteHashSet(mutableSet.bitGroup3, mutableSet.bitGroup4, mutableSet.bitGroup1, mutableSet.bitGroup2, mutableSet.size);
    }

    public ByteHashSet newEmpty() {
        return new ByteHashSet();
    }

    public MutableByteIterator byteIterator() {
        return new MutableInternalByteIterator();
    }

    public byte[] toArray() {
        byte[] array = new byte[this.size()];
        int index = 0;
        MutableByteIterator iterator = this.byteIterator();
        while (iterator.hasNext()) {
            byte nextByte;
            array[index] = nextByte = iterator.next();
            ++index;
        }
        return array;
    }

    public byte[] toArray(byte[] array) {
        if (array.length < this.size()) {
            array = new byte[this.size()];
        }
        int index = 0;
        MutableByteIterator iterator = this.byteIterator();
        while (iterator.hasNext()) {
            byte nextByte;
            array[index] = nextByte = iterator.next();
            ++index;
        }
        return array;
    }

    public boolean containsAll(byte ... source) {
        for (byte item : source) {
            if (this.contains(item)) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(ByteIterable source) {
        ByteIterator iterator = source.byteIterator();
        while (iterator.hasNext()) {
            if (this.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    public void forEach(ByteProcedure procedure) {
        this.each(procedure);
    }

    public void each(ByteProcedure procedure) {
        byte value;
        byte value2;
        byte value3;
        byte value4;
        for (long bitGroup1 = this.bitGroup1; bitGroup1 != 0L; bitGroup1 &= 1L << (byte)(value4 + 64) ^ 0xFFFFFFFFFFFFFFFFL) {
            value4 = (byte)Long.numberOfTrailingZeros(bitGroup1);
            procedure.value((byte)((value4 + 65) * -1));
        }
        for (long bitGroup2 = this.bitGroup2; bitGroup2 != 0L; bitGroup2 &= 1L << value3 ^ 0xFFFFFFFFFFFFFFFFL) {
            value3 = (byte)Long.numberOfTrailingZeros(bitGroup2);
            procedure.value((byte)((value3 + 1) * -1));
        }
        for (long bitGroup3 = this.bitGroup3; bitGroup3 != 0L; bitGroup3 &= 1L << value2 ^ 0xFFFFFFFFFFFFFFFFL) {
            value2 = (byte)Long.numberOfTrailingZeros(bitGroup3);
            procedure.value(value2);
        }
        for (long bitGroup4 = this.bitGroup4; bitGroup4 != 0L; bitGroup4 &= 1L << (byte)(value + 64) ^ 0xFFFFFFFFFFFFFFFFL) {
            value = (byte)Long.numberOfTrailingZeros(bitGroup4);
            procedure.value((byte)(value + 64));
        }
    }

    public ByteHashSet select(BytePredicate predicate) {
        ByteHashSet result = new ByteHashSet();
        this.forEach((ByteProcedure & Serializable)value -> {
            if (predicate.accept(value)) {
                result.add(value);
            }
        });
        return result;
    }

    public MutableByteSet reject(BytePredicate predicate) {
        ByteHashSet result = new ByteHashSet();
        this.forEach((ByteProcedure & Serializable)value -> {
            if (!predicate.accept(value)) {
                result.add(value);
            }
        });
        return result;
    }

    public <V> MutableSet<V> collect(ByteToObjectFunction<? extends V> function) {
        MutableSet target = Sets.mutable.withInitialCapacity(this.size());
        this.forEach((ByteProcedure & Serializable)each -> target.add(function.valueOf(each)));
        return target;
    }

    public byte detectIfNone(BytePredicate predicate, byte ifNone) {
        MutableByteIterator iterator = this.byteIterator();
        while (iterator.hasNext()) {
            byte nextByte = iterator.next();
            if (!predicate.accept(nextByte)) continue;
            return nextByte;
        }
        return ifNone;
    }

    public int count(BytePredicate predicate) {
        int count = 0;
        MutableByteIterator iterator = this.byteIterator();
        while (iterator.hasNext()) {
            if (!predicate.accept(iterator.next())) continue;
            ++count;
        }
        return count;
    }

    public boolean anySatisfy(BytePredicate predicate) {
        MutableByteIterator iterator = this.byteIterator();
        while (iterator.hasNext()) {
            if (!predicate.accept(iterator.next())) continue;
            return true;
        }
        return false;
    }

    public boolean allSatisfy(BytePredicate predicate) {
        MutableByteIterator iterator = this.byteIterator();
        while (iterator.hasNext()) {
            if (predicate.accept(iterator.next())) continue;
            return false;
        }
        return true;
    }

    public boolean noneSatisfy(BytePredicate predicate) {
        MutableByteIterator iterator = this.byteIterator();
        while (iterator.hasNext()) {
            if (!predicate.accept(iterator.next())) continue;
            return false;
        }
        return true;
    }

    public MutableByteList toList() {
        return ByteLists.mutable.withAll((ByteIterable)this);
    }

    public MutableByteSet toSet() {
        return ByteSets.mutable.withAll((ByteIterable)this);
    }

    public MutableByteBag toBag() {
        return ByteBags.mutable.withAll((ByteIterable)this);
    }

    public LazyByteIterable asLazy() {
        return new LazyByteIterableAdapter((ByteIterable)this);
    }

    public long sum() {
        long result = 0L;
        MutableByteIterator iterator = this.byteIterator();
        while (iterator.hasNext()) {
            result += (long)iterator.next();
        }
        return result;
    }

    public byte max() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        byte max = 0;
        if (this.bitGroup4 != 0L) {
            max = (byte)(127 - Long.numberOfLeadingZeros(this.bitGroup4));
        } else if (this.bitGroup3 != 0L) {
            max = (byte)(63 - Long.numberOfLeadingZeros(this.bitGroup3));
        } else if (this.bitGroup2 != 0L) {
            max = (byte)((Long.numberOfTrailingZeros(this.bitGroup2) + 1) * -1);
        } else if (this.bitGroup1 != 0L) {
            max = (byte)((Long.numberOfTrailingZeros(this.bitGroup1) + 65) * -1);
        }
        return max;
    }

    public byte maxIfEmpty(byte defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        return this.max();
    }

    public byte min() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        byte min = 0;
        if (this.bitGroup1 != 0L) {
            min = (byte)(128 - Long.numberOfLeadingZeros(this.bitGroup1));
            min = (byte)(min * -1);
        } else if (this.bitGroup2 != 0L) {
            min = (byte)((64 - Long.numberOfLeadingZeros(this.bitGroup2)) * -1);
        } else if (this.bitGroup3 != 0L) {
            min = (byte)Long.numberOfTrailingZeros(this.bitGroup3);
        } else if (this.bitGroup4 != 0L) {
            min = (byte)(Long.numberOfTrailingZeros(this.bitGroup4) + 64);
        }
        return min;
    }

    public byte minIfEmpty(byte defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        return this.min();
    }

    public double average() {
        if (this.isEmpty()) {
            throw new ArithmeticException();
        }
        return (double)this.sum() / (double)this.size();
    }

    public double median() {
        if (this.isEmpty()) {
            throw new ArithmeticException();
        }
        byte[] sortedArray = this.toSortedArray();
        int middleIndex = sortedArray.length >> 1;
        if (sortedArray.length > 1 && (sortedArray.length & 1) == 0) {
            byte first = sortedArray[middleIndex];
            byte second = sortedArray[middleIndex - 1];
            return ((double)first + (double)second) / 2.0;
        }
        return sortedArray[middleIndex];
    }

    public byte[] toSortedArray() {
        byte[] array = this.toArray();
        Arrays.sort(array);
        return array;
    }

    public MutableByteList toSortedList() {
        return ByteLists.mutable.withAll((ByteIterable)this).sortThis();
    }

    public ByteSet freeze() {
        if (this.size() == 0) {
            return ByteSets.immutable.with();
        }
        if (this.size() == 1) {
            return ByteSets.immutable.with(this.byteIterator().next());
        }
        return new ImmutableByteHashSet(this.bitGroup3, this.bitGroup4, this.bitGroup1, this.bitGroup2, this.size);
    }

    @Override
    public void writeExternal(final ObjectOutput out) throws IOException {
        out.writeInt(this.size());
        this.forEach(new CheckedByteProcedure(){

            @Override
            public void safeValue(byte each) throws IOException {
                out.writeByte(each);
            }
        });
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            this.add(in.readByte());
        }
    }

    public <T> T injectInto(T injectedValue, ObjectByteToObjectFunction<? super T, ? extends T> function) {
        Object result = injectedValue;
        MutableByteIterator iterator = this.byteIterator();
        while (iterator.hasNext()) {
            result = function.valueOf(result, iterator.next());
        }
        return result;
    }

    public RichIterable<ByteIterable> chunk(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Size for groups must be positive but was: " + size);
        }
        MutableList result = Lists.mutable.empty();
        if (this.notEmpty()) {
            if (this.size() <= size) {
                result.add((Object)ByteSets.mutable.withAll((ByteIterable)this));
            } else {
                MutableByteIterator iterator = this.byteIterator();
                while (iterator.hasNext()) {
                    MutableByteSet batch = ByteSets.mutable.empty();
                    for (int i = 0; i < size && iterator.hasNext(); ++i) {
                        batch.add(iterator.next());
                    }
                    result.add((Object)batch);
                }
            }
        }
        return result;
    }

    private static final class ImmutableByteHashSet
    implements ImmutableByteSet,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final long bitGroup1;
        private final long bitGroup2;
        private final long bitGroup3;
        private final long bitGroup4;
        private final short size;

        private ImmutableByteHashSet(long bitGroup3, long bitGroup4, long bitGroup1, long bitGroup2, short size) {
            this.bitGroup3 = bitGroup3;
            this.bitGroup4 = bitGroup4;
            this.bitGroup1 = bitGroup1;
            this.bitGroup2 = bitGroup2;
            this.size = size;
        }

        public LazyIterable<ByteBytePair> cartesianProduct(ByteSet set) {
            return ByteSets.cartesianProduct((ByteSet)this, set);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ByteSet)) {
                return false;
            }
            ByteSet other = (ByteSet)obj;
            return this.size() == other.size() && this.containsAll(other.toArray());
        }

        public int hashCode() {
            return (int)this.sum();
        }

        public String toString() {
            return this.makeString("[", ", ", "]");
        }

        public ImmutableByteSet newWith(byte element) {
            return ByteHashSet.newSet((ByteIterable)this).with(element).toImmutable();
        }

        public ImmutableByteSet newWithout(byte element) {
            return ByteHashSet.newSet((ByteIterable)this).without(element).toImmutable();
        }

        public ImmutableByteSet newWithAll(ByteIterable elements) {
            return ByteHashSet.newSet((ByteIterable)this).withAll(elements).toImmutable();
        }

        public ImmutableByteSet newWithoutAll(ByteIterable elements) {
            return ByteHashSet.newSet((ByteIterable)this).withoutAll(elements).toImmutable();
        }

        public int size() {
            return this.size;
        }

        public boolean isEmpty() {
            return this.size() == 0;
        }

        public boolean notEmpty() {
            return this.size() != 0;
        }

        public String makeString() {
            return this.makeString(", ");
        }

        public String makeString(String separator) {
            return this.makeString("", separator, "");
        }

        public String makeString(String start, String separator, String end) {
            StringBuilder stringBuilder = new StringBuilder();
            this.appendString(stringBuilder, start, separator, end);
            return ((Object)stringBuilder).toString();
        }

        public void appendString(Appendable appendable) {
            this.appendString(appendable, ", ");
        }

        public void appendString(Appendable appendable, String separator) {
            this.appendString(appendable, "", separator, "");
        }

        public void appendString(Appendable appendable, String start, String separator, String end) {
            try {
                appendable.append(start);
                int count = 0;
                ByteIterator iterator = this.byteIterator();
                while (iterator.hasNext()) {
                    byte nextByte = iterator.next();
                    if (count > 0) {
                        appendable.append(separator);
                    }
                    ++count;
                    appendable.append(String.valueOf(nextByte));
                }
                appendable.append(end);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public ByteIterator byteIterator() {
            return new InternalByteIterator();
        }

        public byte[] toArray() {
            byte[] array = new byte[this.size()];
            int index = 0;
            ByteIterator iterator = this.byteIterator();
            while (iterator.hasNext()) {
                byte nextByte;
                array[index] = nextByte = iterator.next();
                ++index;
            }
            return array;
        }

        public byte[] toArray(byte[] array) {
            if (array.length < this.size()) {
                array = new byte[this.size()];
            }
            int index = 0;
            ByteIterator iterator = this.byteIterator();
            while (iterator.hasNext()) {
                byte nextByte;
                array[index] = nextByte = iterator.next();
                ++index;
            }
            return array;
        }

        public boolean contains(byte value) {
            if (value <= -65) {
                return (this.bitGroup1 >>> (byte)((value + 1) * -1) & 1L) != 0L;
            }
            if (value <= -1) {
                return (this.bitGroup2 >>> (byte)((value + 1) * -1) & 1L) != 0L;
            }
            if (value <= 63) {
                return (this.bitGroup3 >>> value & 1L) != 0L;
            }
            return (this.bitGroup4 >>> value & 1L) != 0L;
        }

        public boolean containsAll(byte ... source) {
            for (byte item : source) {
                if (this.contains(item)) continue;
                return false;
            }
            return true;
        }

        public boolean containsAll(ByteIterable source) {
            ByteIterator iterator = source.byteIterator();
            while (iterator.hasNext()) {
                if (this.contains(iterator.next())) continue;
                return false;
            }
            return true;
        }

        public void forEach(ByteProcedure procedure) {
            this.each(procedure);
        }

        public void each(ByteProcedure procedure) {
            byte value;
            byte value2;
            byte value3;
            byte value4;
            for (long bitGroup1 = this.bitGroup1; bitGroup1 != 0L; bitGroup1 &= 1L << (byte)(value4 + 64) ^ 0xFFFFFFFFFFFFFFFFL) {
                value4 = (byte)Long.numberOfTrailingZeros(bitGroup1);
                procedure.value((byte)((value4 + 65) * -1));
            }
            for (long bitGroup2 = this.bitGroup2; bitGroup2 != 0L; bitGroup2 &= 1L << value3 ^ 0xFFFFFFFFFFFFFFFFL) {
                value3 = (byte)Long.numberOfTrailingZeros(bitGroup2);
                procedure.value((byte)((value3 + 1) * -1));
            }
            for (long bitGroup3 = this.bitGroup3; bitGroup3 != 0L; bitGroup3 &= 1L << value2 ^ 0xFFFFFFFFFFFFFFFFL) {
                value2 = (byte)Long.numberOfTrailingZeros(bitGroup3);
                procedure.value(value2);
            }
            for (long bitGroup4 = this.bitGroup4; bitGroup4 != 0L; bitGroup4 &= 1L << (byte)(value + 64) ^ 0xFFFFFFFFFFFFFFFFL) {
                value = (byte)Long.numberOfTrailingZeros(bitGroup4);
                procedure.value((byte)(value + 64));
            }
        }

        public ImmutableByteSet select(BytePredicate predicate) {
            ByteHashSet result = new ByteHashSet();
            this.forEach((ByteProcedure & Serializable)value -> {
                if (predicate.accept(value)) {
                    result.add(value);
                }
            });
            return result.toImmutable();
        }

        public ImmutableByteSet reject(BytePredicate predicate) {
            ByteHashSet result = new ByteHashSet();
            this.forEach((ByteProcedure & Serializable)value -> {
                if (!predicate.accept(value)) {
                    result.add(value);
                }
            });
            return result.toImmutable();
        }

        public <V> ImmutableSet<V> collect(ByteToObjectFunction<? extends V> function) {
            MutableSet target = Sets.mutable.withInitialCapacity(this.size());
            this.forEach((ByteProcedure & Serializable)each -> target.add(function.valueOf(each)));
            return target.toImmutable();
        }

        public byte detectIfNone(BytePredicate predicate, byte ifNone) {
            ByteIterator iterator = this.byteIterator();
            while (iterator.hasNext()) {
                byte nextByte = iterator.next();
                if (!predicate.accept(nextByte)) continue;
                return nextByte;
            }
            return ifNone;
        }

        public int count(BytePredicate predicate) {
            int count = 0;
            ByteIterator iterator = this.byteIterator();
            while (iterator.hasNext()) {
                if (!predicate.accept(iterator.next())) continue;
                ++count;
            }
            return count;
        }

        public boolean anySatisfy(BytePredicate predicate) {
            ByteIterator iterator = this.byteIterator();
            while (iterator.hasNext()) {
                if (!predicate.accept(iterator.next())) continue;
                return true;
            }
            return false;
        }

        public boolean allSatisfy(BytePredicate predicate) {
            ByteIterator iterator = this.byteIterator();
            while (iterator.hasNext()) {
                if (predicate.accept(iterator.next())) continue;
                return false;
            }
            return true;
        }

        public boolean noneSatisfy(BytePredicate predicate) {
            ByteIterator iterator = this.byteIterator();
            while (iterator.hasNext()) {
                if (!predicate.accept(iterator.next())) continue;
                return false;
            }
            return true;
        }

        public MutableByteList toList() {
            return ByteLists.mutable.withAll((ByteIterable)this);
        }

        public MutableByteSet toSet() {
            return ByteSets.mutable.withAll((ByteIterable)this);
        }

        public MutableByteBag toBag() {
            return ByteBags.mutable.withAll((ByteIterable)this);
        }

        public LazyByteIterable asLazy() {
            return new LazyByteIterableAdapter((ByteIterable)this);
        }

        public long sum() {
            long result = 0L;
            ByteIterator iterator = this.byteIterator();
            while (iterator.hasNext()) {
                result += (long)iterator.next();
            }
            return result;
        }

        public byte max() {
            byte max = 0;
            if (this.bitGroup4 != 0L) {
                max = (byte)(127 - Long.numberOfLeadingZeros(this.bitGroup4));
            } else if (this.bitGroup3 != 0L) {
                max = (byte)(63 - Long.numberOfLeadingZeros(this.bitGroup3));
            } else if (this.bitGroup2 != 0L) {
                max = (byte)((Long.numberOfTrailingZeros(this.bitGroup2) + 1) * -1);
            } else if (this.bitGroup1 != 0L) {
                max = (byte)((Long.numberOfTrailingZeros(this.bitGroup1) + 65) * -1);
            }
            return max;
        }

        public byte maxIfEmpty(byte defaultValue) {
            return this.max();
        }

        public byte min() {
            byte min = 0;
            if (this.bitGroup1 != 0L) {
                min = (byte)(128 - Long.numberOfLeadingZeros(this.bitGroup1));
                min = (byte)(min * -1);
            } else if (this.bitGroup2 != 0L) {
                min = (byte)((64 - Long.numberOfLeadingZeros(this.bitGroup2)) * -1);
            } else if (this.bitGroup3 != 0L) {
                min = (byte)Long.numberOfTrailingZeros(this.bitGroup3);
            } else if (this.bitGroup4 != 0L) {
                min = (byte)(Long.numberOfTrailingZeros(this.bitGroup4) + 64);
            }
            return min;
        }

        public byte minIfEmpty(byte defaultValue) {
            return this.min();
        }

        public double average() {
            return (double)this.sum() / (double)this.size();
        }

        public double median() {
            byte[] sortedArray = this.toSortedArray();
            int middleIndex = sortedArray.length >> 1;
            if (sortedArray.length > 1 && (sortedArray.length & 1) == 0) {
                byte first = sortedArray[middleIndex];
                byte second = sortedArray[middleIndex - 1];
                return ((double)first + (double)second) / 2.0;
            }
            return sortedArray[middleIndex];
        }

        public byte[] toSortedArray() {
            byte[] array = this.toArray();
            Arrays.sort(array);
            return array;
        }

        public MutableByteList toSortedList() {
            return ByteLists.mutable.withAll((ByteIterable)this).sortThis();
        }

        public <T> T injectInto(T injectedValue, ObjectByteToObjectFunction<? super T, ? extends T> function) {
            Object result = injectedValue;
            ByteIterator iterator = this.byteIterator();
            while (iterator.hasNext()) {
                result = function.valueOf(result, iterator.next());
            }
            return result;
        }

        public RichIterable<ByteIterable> chunk(int size) {
            if (size <= 0) {
                throw new IllegalArgumentException("Size for groups must be positive but was: " + size);
            }
            if (this.isEmpty()) {
                return Lists.mutable.empty();
            }
            ByteIterator iterator = this.byteIterator();
            MutableList result = Lists.mutable.empty();
            while (iterator.hasNext()) {
                MutableByteSet batch = ByteSets.mutable.empty();
                for (int i = 0; i < size && iterator.hasNext(); ++i) {
                    batch.add(iterator.next());
                }
                result.add((Object)batch);
            }
            return result;
        }

        public ByteSet freeze() {
            return this;
        }

        public ImmutableByteSet toImmutable() {
            return this;
        }

        private Object writeReplace() {
            return new ImmutableByteSetSerializationProxy((ByteSet)this);
        }

        private class InternalByteIterator
        implements ByteIterator {
            private int count;
            private byte minusOneTwentyEightToPlusOneTwentySeven = (byte)-128;

            private InternalByteIterator() {
            }

            public boolean hasNext() {
                return this.count < ImmutableByteHashSet.this.size();
            }

            public byte next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("next() called, but the iterator is exhausted");
                }
                ++this.count;
                while (this.minusOneTwentyEightToPlusOneTwentySeven <= 127) {
                    if (ImmutableByteHashSet.this.contains(this.minusOneTwentyEightToPlusOneTwentySeven)) {
                        byte result = this.minusOneTwentyEightToPlusOneTwentySeven;
                        this.minusOneTwentyEightToPlusOneTwentySeven = (byte)(this.minusOneTwentyEightToPlusOneTwentySeven + 1);
                        return result;
                    }
                    this.minusOneTwentyEightToPlusOneTwentySeven = (byte)(this.minusOneTwentyEightToPlusOneTwentySeven + 1);
                }
                throw new NoSuchElementException("no more element, unexpected situation");
            }
        }
    }

    private class MutableInternalByteIterator
    implements MutableByteIterator {
        private int count;
        private byte minusOneTwentyEightToPlusOneTwentySeven = (byte)-128;

        private MutableInternalByteIterator() {
        }

        public boolean hasNext() {
            return this.count < ByteHashSet.this.size();
        }

        public byte next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("next() called, but the iterator is exhausted");
            }
            ++this.count;
            while (this.minusOneTwentyEightToPlusOneTwentySeven <= 127) {
                if (ByteHashSet.this.contains(this.minusOneTwentyEightToPlusOneTwentySeven)) {
                    byte result = this.minusOneTwentyEightToPlusOneTwentySeven;
                    this.minusOneTwentyEightToPlusOneTwentySeven = (byte)(this.minusOneTwentyEightToPlusOneTwentySeven + 1);
                    return result;
                }
                this.minusOneTwentyEightToPlusOneTwentySeven = (byte)(this.minusOneTwentyEightToPlusOneTwentySeven + 1);
            }
            throw new NoSuchElementException("no more element, unexpected situation");
        }

        public void remove() {
            if (this.count == 0 || !ByteHashSet.this.remove((byte)(this.minusOneTwentyEightToPlusOneTwentySeven - 1))) {
                throw new IllegalStateException();
            }
            --this.count;
        }
    }
}

