/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.debug.st;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.emf.common.util.URI;
import org.eclipse.fordiac.ide.debug.CommonLaunchConfigurationDelegate;
import org.eclipse.fordiac.ide.debug.LaunchConfigurationAttributes;
import org.eclipse.fordiac.ide.debug.st.Messages;
import org.eclipse.fordiac.ide.debug.st.STLaunchConfigurationAttributes;
import org.eclipse.fordiac.ide.model.eval.Evaluator;
import org.eclipse.fordiac.ide.model.eval.st.STFunctionEvaluator;
import org.eclipse.fordiac.ide.model.eval.st.variable.STVariableOperations;
import org.eclipse.fordiac.ide.model.eval.variable.Variable;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STVarDeclaration;
import org.eclipse.fordiac.ide.structuredtextfunctioneditor.stfunction.STFunction;
import org.eclipse.fordiac.ide.structuredtextfunctioneditor.stfunction.STFunctionSource;
import org.eclipse.fordiac.ide.structuredtextfunctioneditor.util.STFunctionParseUtil;

public class STLaunchConfigurationDelegate
extends CommonLaunchConfigurationDelegate {
    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        IResource resource = LaunchConfigurationAttributes.getResource((ILaunchConfiguration)configuration);
        if (resource instanceof IFile) {
            ArrayList errors = new ArrayList();
            STFunctionSource source = STFunctionParseUtil.parse((URI)URI.createPlatformResourceURI((String)resource.getFullPath().toString(), (boolean)true), errors, null, null);
            if (source == null) {
                throw new CoreException(Status.error((String)errors.stream().collect(Collectors.joining("\n"))));
            }
            STFunction function = STLaunchConfigurationAttributes.getFunction(configuration, source, null);
            if (function == null) {
                throw new CoreException(Status.error((String)MessageFormat.format(Messages.STLaunchConfigurationDelegate_NoSuchFunction, configuration.getAttribute("org.eclipse.fordiac.ide.debug.st.function", ""), resource.getName())));
            }
            List<Variable<?>> defaultArguments = STLaunchConfigurationDelegate.getDefaultArguments(function);
            List variables = LaunchConfigurationAttributes.getArguments((ILaunchConfiguration)configuration, defaultArguments);
            Evaluator evaluator = this.createEvaluator(function, variables);
            this.launch(evaluator, configuration, mode, launch, resource, monitor);
        }
    }

    public Evaluator createEvaluator(STFunction function, List<Variable<?>> variables) {
        return new STFunctionEvaluator(function, null, variables, null);
    }

    public static List<Variable<?>> getDefaultArguments(STFunction function) throws CoreException {
        try {
            return Stream.concat(function.getInputParameters().stream(), function.getInOutParameters().stream()).map(STVarDeclaration.class::cast).map(STVariableOperations::newVariable).collect(Collectors.toList());
        }
        catch (Exception e) {
            throw new CoreException(Status.error((String)MessageFormat.format(Messages.STLaunchConfigurationDelegate_InvalidDefaultArguments, function.getName()), (Throwable)e));
        }
    }
}

