/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.widgets;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.provider.EcoreItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.fordiac.ide.gef.Messages;
import org.eclipse.fordiac.ide.gef.properties.AbstractSection;
import org.eclipse.fordiac.ide.gef.properties.ChangeDestinationSourceDialog;
import org.eclipse.fordiac.ide.gef.utilities.ElementSelector;
import org.eclipse.fordiac.ide.model.commands.change.ChangeConnectionCommentCommand;
import org.eclipse.fordiac.ide.model.commands.delete.DeleteConnectionCommand;
import org.eclipse.fordiac.ide.model.data.provider.DataItemProviderAdapterFactory;
import org.eclipse.fordiac.ide.model.libraryElement.CompositeFBType;
import org.eclipse.fordiac.ide.model.libraryElement.Connection;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.provider.LibraryElementItemProviderAdapterFactory;
import org.eclipse.fordiac.ide.ui.FordiacMessages;
import org.eclipse.fordiac.ide.ui.widget.AddDeleteChangeDestinationSourceWidget;
import org.eclipse.fordiac.ide.ui.widget.CommandExecutor;
import org.eclipse.fordiac.ide.ui.widget.CustomTextCellEditor;
import org.eclipse.fordiac.ide.ui.widget.TableWidgetFactory;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class ConnectionDisplayWidget {
    protected Section connectionSection;
    protected TableViewer connectionsViewer;
    protected AddDeleteChangeDestinationSourceWidget inputButtons;
    private static final int TARGET_PIN_WIDTH = 100;
    private static final int COMMENT_WIDTH = 200;
    private final TabbedPropertySheetWidgetFactory widgetFactory;
    protected IInterfaceElement type;
    private ComposedAdapterFactory adapterFactory;
    private final AbstractSection parentSection;
    protected boolean isInputViewer;

    public ConnectionDisplayWidget(TabbedPropertySheetWidgetFactory widgetFactory, Composite parent, AbstractSection section) {
        this.widgetFactory = widgetFactory;
        this.parentSection = section;
        this.createConnectionDisplaySection(parent);
    }

    private void createConnectionDisplaySection(Composite parent) {
        this.connectionSection = this.widgetFactory.createSection(parent, 322);
        this.connectionSection.setText(Messages.InterfaceElementSection_ConnectionGroup);
        this.connectionSection.setLayout((Layout)new GridLayout(1, false));
        this.connectionSection.setLayoutData((Object)GridDataFactory.fillDefaults().align(4, 4).grab(true, true).create());
        Composite composite = this.widgetFactory.createComposite((Composite)this.connectionSection);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.inputButtons = new AddDeleteChangeDestinationSourceWidget();
        this.inputButtons.createControls(composite, (FormToolkit)this.widgetFactory);
        this.inputButtons.setVisibleCreateButton(false);
        this.connectionsViewer = this.createConnectionsViewer(composite);
        this.inputButtons.bindToTableViewer(this.connectionsViewer, (CommandExecutor)this.parentSection, ref -> null, ref -> new DeleteConnectionCommand((Connection)ref), ref -> new ChangeDestinationSourceDialog(this.connectionsViewer.getControl().getShell(), (Connection)ref, this.getInterfaceElement((Connection)ref)));
        this.connectionSection.setClient((Control)composite);
    }

    protected TableViewer createConnectionsViewer(Composite parent) {
        TableViewer viewer = TableWidgetFactory.createTableViewer((Composite)parent);
        viewer.getTable().setLayout((Layout)ConnectionDisplayWidget.createTableLayout(viewer.getTable()));
        viewer.setColumnProperties(new String[]{FordiacMessages.Target, FordiacMessages.Pin, FordiacMessages.Comment});
        viewer.setCellModifier((ICellModifier)new ConnectionCellModifier(viewer));
        CellEditor[] cellEditorArray = new CellEditor[3];
        cellEditorArray[2] = new CustomTextCellEditor((Composite)viewer.getTable());
        viewer.setCellEditors(cellEditorArray);
        viewer.setLabelProvider((IBaseLabelProvider)new ConnectionTableLabelProvider());
        viewer.setContentProvider((IContentProvider)new ConnectionContentProvider());
        viewer.addDoubleClickListener(ElementSelector::jumpToPinFromDoubleClickEvent);
        return viewer;
    }

    protected static TableLayout createTableLayout(Table table) {
        TableColumn column1 = new TableColumn(table, 16384);
        column1.setText(FordiacMessages.Target);
        TableColumn column2 = new TableColumn(table, 16384);
        column2.setText(FordiacMessages.Pin);
        TableColumn column3 = new TableColumn(table, 16384);
        column3.setText(FordiacMessages.Comment);
        TableLayout layout = new TableLayout();
        layout.addColumnData((ColumnLayoutData)new ColumnPixelData(100));
        layout.addColumnData((ColumnLayoutData)new ColumnPixelData(100));
        layout.addColumnData((ColumnLayoutData)new ColumnPixelData(200));
        return layout;
    }

    public void refreshConnectionsViewer(IInterfaceElement type) {
        this.type = type;
        this.isInputViewer = type.isIsInput();
        this.refreshConnectionsViewerManual(this.isInputViewer);
    }

    public void refreshConnectionsViewerManual(boolean manualInputViewer) {
        this.isInputViewer = manualInputViewer;
        if (manualInputViewer) {
            this.connectionSection.setText(Messages.InterfaceElementSection_InConnections);
        } else {
            this.connectionSection.setText(Messages.InterfaceElementSection_OutConnections);
        }
        this.connectionsViewer.setInput((Object)this.type);
        this.connectionsViewer.getTable().requestLayout();
    }

    public void setEditable(boolean edit) {
        this.inputButtons.setVisible(edit);
        this.inputButtons.setEnabled(edit);
    }

    private IInterfaceElement getInterfaceElement(Connection con) {
        if (con != null) {
            return this.type.equals(con.getSource()) ? con.getDestination() : con.getSource();
        }
        return null;
    }

    private class ConnectionCellModifier
    implements ICellModifier {
        private final TableViewer viewer;

        public ConnectionCellModifier(TableViewer viewer) {
            this.viewer = viewer;
        }

        public boolean canModify(Object element, String property) {
            return FordiacMessages.Comment.equals(property);
        }

        public Object getValue(Object element, String property) {
            if (FordiacMessages.Comment.equals(property)) {
                Connection con = (Connection)element;
                return con.getComment() != null ? con.getComment() : "";
            }
            return null;
        }

        public void modify(Object element, String property, Object value) {
            TableItem tableItem = (TableItem)element;
            Object data = tableItem.getData();
            if (FordiacMessages.Comment.equals(property)) {
                Connection con = (Connection)data;
                ConnectionDisplayWidget.this.parentSection.executeCommand((Command)new ChangeConnectionCommentCommand(con, value.toString()));
                this.viewer.refresh(data);
            }
        }
    }

    private static class ConnectionContentProvider
    implements IStructuredContentProvider {
        private ConnectionContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof IInterfaceElement) {
                IInterfaceElement element = (IInterfaceElement)inputElement;
                if (element.isIsInput() && element.getBlockFBNetworkElement() != null || !element.isIsInput() && element.getBlockFBNetworkElement() == null) {
                    return element.getInputConnections().toArray();
                }
                return element.getOutputConnections().toArray();
            }
            return new Object[0];
        }
    }

    private class ConnectionTableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        public static final int TARGET_COL_INDEX = 0;
        public static final int PIN_COL_INDEX = 1;
        public static final int COMMENT_COL_INDEX = 2;
        AdapterFactoryLabelProvider labelProvider = new AdapterFactoryLabelProvider((AdapterFactory)this.getAdapterFactory());

        private ConnectionTableLabelProvider() {
        }

        private ComposedAdapterFactory getAdapterFactory() {
            if (ConnectionDisplayWidget.this.adapterFactory == null) {
                ConnectionDisplayWidget.this.adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
                ConnectionDisplayWidget.this.adapterFactory.addAdapterFactory((AdapterFactory)new ResourceItemProviderAdapterFactory());
                ConnectionDisplayWidget.this.adapterFactory.addAdapterFactory((AdapterFactory)new LibraryElementItemProviderAdapterFactory());
                ConnectionDisplayWidget.this.adapterFactory.addAdapterFactory((AdapterFactory)new DataItemProviderAdapterFactory());
                ConnectionDisplayWidget.this.adapterFactory.addAdapterFactory((AdapterFactory)new EcoreItemProviderAdapterFactory());
                ConnectionDisplayWidget.this.adapterFactory.addAdapterFactory((AdapterFactory)new ReflectiveItemProviderAdapterFactory());
            }
            return ConnectionDisplayWidget.this.adapterFactory;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            Connection con;
            IInterfaceElement ie;
            if (element instanceof Connection && (ie = ConnectionDisplayWidget.this.getInterfaceElement(con = (Connection)element)) != null) {
                switch (columnIndex) {
                    case 0: {
                        if (ie.getBlockFBNetworkElement() == null) break;
                        return this.labelProvider.getImage((Object)ie.getBlockFBNetworkElement());
                    }
                    case 1: {
                        return this.labelProvider.getImage((Object)ie);
                    }
                }
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            Connection con;
            IInterfaceElement ie;
            if (element instanceof Connection && (ie = ConnectionDisplayWidget.this.getInterfaceElement(con = (Connection)element)) != null) {
                switch (columnIndex) {
                    case 0: {
                        if (ie.getBlockFBNetworkElement() != null) {
                            return ie.getBlockFBNetworkElement().getName();
                        }
                        if (ie.eContainer() == null) {
                            return "";
                        }
                        FBType fBType = ie.getFBType();
                        if (!(fBType instanceof CompositeFBType)) break;
                        CompositeFBType compositeFBType = (CompositeFBType)fBType;
                        return compositeFBType.getName();
                    }
                    case 1: {
                        return ie.getName();
                    }
                    case 2: {
                        return con.getComment() != null ? con.getComment() : "";
                    }
                }
            }
            return element.toString();
        }
    }
}

