/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.ui.handlers;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.fordiac.ide.ui.errormessages.ErrorMessage;
import org.eclipse.fordiac.ide.ui.errormessages.ErrorMessenger;
import org.eclipse.fordiac.ide.ui.handlers.internal.ErrorMessageDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.BundleContext;
import org.osgi.service.event.EventHandler;

public class ErrorMessageHandler {
    private static final int MOUSE_HOVER_DELAY = 700;
    boolean hovering = false;
    private static final String TOPIC_ERRORMESSAGES = "ORG/ECLIPSE/FORDIAC/IDE/ERRORMESSAGES";
    private IEventBroker eventBroker;
    private boolean eventsRegistered = false;
    private final LinkedList<Composite> windows = new LinkedList();
    private final Set<ErrorMessage> messages = new HashSet<ErrorMessage>();
    private final EventHandler receiver = event -> {
        Object data = event.getProperty("org.eclipse.e4.data");
        if (this.eventsRegistered && data instanceof ErrorMessage) {
            ErrorMessage em = (ErrorMessage)data;
            this.showErrorMessageDialog(em);
        }
    };

    public synchronized void setHover(boolean hovering) {
        this.hovering = hovering;
        if (!hovering) {
            this.messages.stream().forEach(ErrorMessage::setInvalid);
            this.closeAllDialogs();
        }
    }

    public boolean isHovering() {
        return this.hovering;
    }

    public ErrorMessageHandler(BundleContext context) {
        this.initEventBroker(context);
    }

    public void stop() {
        if (this.eventsRegistered) {
            this.eventsRegistered = !this.eventBroker.unsubscribe(this.receiver);
        }
    }

    public void start() {
        if (!this.eventsRegistered) {
            this.eventsRegistered = this.eventBroker.subscribe(TOPIC_ERRORMESSAGES, this.receiver);
        }
    }

    private synchronized void initEventBroker(BundleContext context) {
        if (this.eventBroker == null) {
            this.eventBroker = (IEventBroker)EclipseContextFactory.getServiceContext((BundleContext)context).get(IEventBroker.class);
        }
    }

    public synchronized void clearDialog(Composite dialogArea) {
        if (dialogArea != null && !dialogArea.isDisposed()) {
            this.closeDialog(dialogArea);
        }
    }

    private synchronized void closeDialog(Composite dialogArea) {
        if (dialogArea != null && !dialogArea.isDisposed()) {
            this.windows.remove(dialogArea.getShell());
            dialogArea.getShell().close();
        }
        this.removeInvalidMessages();
    }

    private void removeInvalidMessages() {
        List<ErrorMessage> toRemove = this.messages.stream().filter(m -> !m.isStillValid()).toList();
        for (ErrorMessage m2 : toRemove) {
            ErrorMessenger.hashCleared((int)m2.hashCode());
        }
        this.messages.removeAll(toRemove);
    }

    private void showErrorMessageDialog(ErrorMessage m) {
        if (this.hovering) {
            this.updateMessageList(m);
            Display.getDefault().timerExec(700, () -> {
                if (this.hovering) {
                    this.closeAllDialogs();
                    this.showMessages(m);
                    m.setInvalid();
                } else {
                    ErrorMessenger.hashCleared((int)m.hashCode());
                }
            });
        } else {
            Display.getDefault().asyncExec(() -> this.activateErrorMessageDialog(m));
        }
    }

    private void activateErrorMessageDialog(ErrorMessage m) {
        this.updateMessageList(m);
        this.closeAllDialogs();
        this.showMessages(m);
        ErrorMessenger.hashCleared((int)m.hashCode());
    }

    private void updateMessageList(ErrorMessage m) {
        this.messages.add(m);
        this.removeInvalidMessages();
    }

    private void closeAllDialogs() {
        Composite w = this.windows.pollFirst();
        while (w != null) {
            this.closeDialog(w);
            w = this.windows.pollFirst();
        }
    }

    private void showMessages(ErrorMessage m) {
        if (!this.messages.isEmpty()) {
            String dialogContent = this.messages.stream().map(ErrorMessage::getMessage).collect(Collectors.joining("\n"));
            ErrorMessageDialog dialog = new ErrorMessageDialog(ErrorMessageHandler.getShell(), this, dialogContent, m.getTimeout());
            dialog.open();
            this.windows.push((Composite)dialog.getShell());
        }
    }

    private static Shell getShell() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null) {
            return window.getShell();
        }
        return null;
    }
}

