/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.dialogs;

import java.util.TreeSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.GlobalBuildAction;
import org.eclipse.ui.dialogs.ListSelectionDialog;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.util.PrefUtil;

public class BuildOrderPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private IWorkbench workbench;
    private Button defaultOrderButton;
    private Label buildLabel;
    private List buildList;
    private Composite buttonComposite;
    private IntegerFieldEditor maxItersField;
    private String[] defaultBuildOrder;
    private String[] customBuildOrder;
    private boolean notCheckedBuildOrder = true;
    private final String UP_LABEL = IDEWorkbenchMessages.BuildOrderPreference_up;
    private final String DOWN_LABEL = IDEWorkbenchMessages.BuildOrderPreference_down;
    private final String ADD_LABEL = IDEWorkbenchMessages.BuildOrderPreference_add;
    private final String REMOVE_LABEL = IDEWorkbenchMessages.BuildOrderPreference_remove;
    private final String PROJECT_SELECTION_MESSAGE = IDEWorkbenchMessages.BuildOrderPreference_selectOtherProjects;
    private final String DEFAULTS_LABEL = IDEWorkbenchMessages.BuildOrderPreference_useDefaults;
    private final String LIST_LABEL = IDEWorkbenchMessages.BuildOrderPreference_projectBuildOrder;
    private final String NOTE_LABEL = IDEWorkbenchMessages.Preference_note;
    private final String REMOVE_MESSAGE = IDEWorkbenchMessages.BuildOrderPreference_removeNote;
    private boolean defaultOrderInitiallySelected;
    private Button autoBuildButton;
    private IntegerFieldEditor maxSimultaneousBuilds;
    private Button autoSaveAllButton;
    private final IPropertyChangeListener validityChangeListener = event -> {
        if (event.getProperty().equals("field_editor_is_valid")) {
            this.updateValidState();
        }
    };

    private void addProject() {
        String[] currentItems = this.buildList.getItems();
        IProject[] allProjects = this.getWorkspace().getRoot().getProjects();
        LabelProvider labelProvider = new LabelProvider(){

            public String getText(Object element) {
                return (String)element;
            }
        };
        ListSelectionDialog dialog = new ListSelectionDialog(this.getShell(), this.sortedDifference(allProjects, currentItems), (IStructuredContentProvider)ArrayContentProvider.getInstance(), (ILabelProvider)labelProvider, this.PROJECT_SELECTION_MESSAGE){

            protected int getShellStyle() {
                return super.getShellStyle() | 0x10000000;
            }
        };
        if (dialog.open() != 0) {
            return;
        }
        Object[] result = dialog.getResult();
        int currentItemsLength = currentItems.length;
        int resultLength = result.length;
        String[] newItems = new String[currentItemsLength + resultLength];
        System.arraycopy(currentItems, 0, newItems, 0, currentItemsLength);
        System.arraycopy(result, 0, newItems, currentItemsLength, result.length);
        this.buildList.setItems(newItems);
    }

    private void updateValidState() {
        this.setValid(this.maxItersField.isValid());
    }

    private void createBuildOrderList(Composite composite, boolean enabled) {
        Font font = composite.getFont();
        this.buildLabel = new Label(composite, 0);
        this.buildLabel.setText(this.LIST_LABEL);
        this.buildLabel.setEnabled(enabled);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.horizontalSpan = 2;
        this.buildLabel.setLayoutData((Object)gridData);
        this.buildLabel.setFont(font);
        this.buildList = new List(composite, 2818);
        this.buildList.setEnabled(enabled);
        GridData data = new GridData();
        data.heightHint = this.buildList.getItemHeight();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        this.buildList.setLayoutData((Object)data);
        this.buildList.setFont(font);
    }

    protected Control createContents(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.ui.ide.build_order_preference_page_context");
        Font font = parent.getFont();
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        composite.setLayoutData((Object)data);
        composite.setFont(font);
        this.createSaveAllBeforeBuildPref(composite);
        this.createAutoBuildPref(composite);
        this.createSpacer(composite);
        String[] buildOrder = this.getCurrentBuildOrder();
        boolean useDefault = buildOrder == null;
        this.createDefaultPathButton(composite, useDefault);
        this.createBuildOrderList(composite, true);
        this.createListButtons(composite, !useDefault);
        Composite noteComposite = this.createNoteComposite(font, composite, this.NOTE_LABEL, this.REMOVE_MESSAGE);
        GridData noteData = new GridData();
        noteData.horizontalSpan = 2;
        noteComposite.setLayoutData((Object)noteData);
        this.createSpacer(composite);
        Composite intFieldsComposite = new Composite(composite, 0);
        intFieldsComposite.setLayout((Layout)new GridLayout(2, false));
        intFieldsComposite.setLayoutData((Object)new GridData(4, -1, true, false, 2, 1));
        this.createMaxIterationsField(intFieldsComposite);
        this.createMaxSimultaneousBuildsGroup(intFieldsComposite);
        if (useDefault) {
            this.buildList.setItems(this.getDefaultProjectOrder());
        } else {
            this.buildList.setItems(buildOrder);
        }
        return composite;
    }

    private void createSpacer(Composite composite) {
        Label spacer = new Label(composite, 0);
        GridData spacerData = new GridData();
        spacerData.horizontalSpan = 2;
        spacer.setLayoutData((Object)spacerData);
    }

    private void createDefaultPathButton(Composite composite, boolean selected) {
        this.defaultOrderInitiallySelected = selected;
        this.defaultOrderButton = new Button(composite, 16416);
        this.defaultOrderButton.setSelection(selected);
        this.defaultOrderButton.setText(this.DEFAULTS_LABEL);
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BuildOrderPreferencePage.this.defaultsButtonSelected(BuildOrderPreferencePage.this.defaultOrderButton.getSelection());
            }
        };
        this.defaultOrderButton.addSelectionListener((SelectionListener)listener);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.horizontalSpan = 2;
        this.defaultOrderButton.setLayoutData((Object)gridData);
        this.defaultOrderButton.setFont(composite.getFont());
    }

    private void createListButtons(Composite composite, boolean enableComposite) {
        Font font = composite.getFont();
        this.buttonComposite = new Composite(composite, 131072);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.buttonComposite.setLayout((Layout)layout);
        GridData gridData = new GridData();
        gridData.verticalAlignment = 4;
        gridData.horizontalAlignment = 4;
        this.buttonComposite.setLayoutData((Object)gridData);
        this.buttonComposite.setFont(font);
        Button upButton = new Button(this.buttonComposite, 0x1000008);
        upButton.setText(this.UP_LABEL);
        upButton.setEnabled(enableComposite);
        upButton.setFont(font);
        this.setButtonLayoutData(upButton);
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BuildOrderPreferencePage.this.moveSelectionUp();
            }
        };
        upButton.addSelectionListener((SelectionListener)listener);
        Button downButton = new Button(this.buttonComposite, 0x1000008);
        downButton.setText(this.DOWN_LABEL);
        downButton.setEnabled(enableComposite);
        listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BuildOrderPreferencePage.this.moveSelectionDown();
            }
        };
        downButton.addSelectionListener((SelectionListener)listener);
        downButton.setFont(font);
        this.setButtonLayoutData(downButton);
        Button addButton = new Button(this.buttonComposite, 0x1000008);
        addButton.setText(this.ADD_LABEL);
        listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BuildOrderPreferencePage.this.addProject();
            }
        };
        addButton.addSelectionListener((SelectionListener)listener);
        addButton.setEnabled(enableComposite);
        addButton.setFont(font);
        this.setButtonLayoutData(addButton);
        Button removeButton = new Button(this.buttonComposite, 0x1000008);
        removeButton.setText(this.REMOVE_LABEL);
        listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BuildOrderPreferencePage.this.removeSelection();
            }
        };
        removeButton.addSelectionListener((SelectionListener)listener);
        removeButton.setEnabled(enableComposite);
        removeButton.setFont(font);
        this.setButtonLayoutData(removeButton);
    }

    private void createMaxIterationsField(Composite composite) {
        this.maxItersField = new IntegerFieldEditor("", IDEWorkbenchMessages.BuildOrderPreference_maxIterationsLabel, composite){

            protected void doLoad() {
                Text text = this.getTextControl();
                if (text != null) {
                    int value = BuildOrderPreferencePage.this.getWorkspace().getDescription().getMaxBuildIterations();
                    text.setText(Integer.toString(value));
                }
            }

            protected void doLoadDefault() {
                Text text = this.getTextControl();
                if (text != null) {
                    IEclipsePreferences def = DefaultScope.INSTANCE.getNode("org.eclipse.core.resources");
                    int defaultValue = 10;
                    int value = def.getInt("description.maxbuilditerations", defaultValue);
                    text.setText(Integer.toString(value));
                }
                this.valueChanged();
            }

            protected void doStore() {
                throw new UnsupportedOperationException();
            }
        };
        this.maxItersField.setValidRange(1, Integer.MAX_VALUE);
        this.maxItersField.setPage((DialogPage)this);
        this.maxItersField.setPreferenceStore(this.getPreferenceStore());
        this.maxItersField.setPropertyChangeListener(this.validityChangeListener);
        this.maxItersField.load();
    }

    private void defaultsButtonSelected(boolean selected) {
        if (selected) {
            this.setBuildOrderWidgetsEnablement(false);
            this.customBuildOrder = this.buildList.getItems();
            this.buildList.setItems(this.getDefaultProjectOrder());
        } else {
            this.setBuildOrderWidgetsEnablement(true);
            String[] buildOrder = this.getCurrentBuildOrder();
            if (buildOrder == null) {
                this.buildList.setItems(this.getDefaultProjectOrder());
            } else {
                this.buildList.setItems(buildOrder);
            }
        }
    }

    private String[] getCurrentBuildOrder() {
        if (this.notCheckedBuildOrder) {
            this.customBuildOrder = this.getWorkspace().getDescription().getBuildOrder();
            this.notCheckedBuildOrder = false;
        }
        return this.customBuildOrder;
    }

    private String[] getDefaultProjectOrder() {
        if (this.defaultBuildOrder == null) {
            IWorkspace workspace = this.getWorkspace();
            IWorkspace.ProjectOrder projectOrder = this.getWorkspace().computeProjectOrder(workspace.getRoot().getProjects());
            IProject[] foundProjects = projectOrder.projects;
            this.defaultBuildOrder = new String[foundProjects.length];
            int foundSize = foundProjects.length;
            int i = 0;
            while (i < foundSize) {
                this.defaultBuildOrder[i] = foundProjects[i].getName();
                ++i;
            }
        }
        return this.defaultBuildOrder;
    }

    private IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    private boolean includes(String[] testArray, String searchElement) {
        String[] stringArray = testArray;
        int n = testArray.length;
        int n2 = 0;
        while (n2 < n) {
            String currentSearchElement = stringArray[n2];
            if (searchElement.equals(currentSearchElement)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void init(IWorkbench currentWorkbench) {
        this.workbench = currentWorkbench;
        this.setPreferenceStore(PrefUtil.getInternalPreferenceStore());
    }

    private void moveSelectionDown() {
        int currentIndex;
        if (this.buildList.getSelectionCount() == 1 && (currentIndex = this.buildList.getSelectionIndex()) < this.buildList.getItemCount() - 1) {
            String elementToMove = this.buildList.getItem(currentIndex);
            this.buildList.remove(currentIndex);
            this.buildList.add(elementToMove, currentIndex + 1);
            this.buildList.setSelection(currentIndex + 1);
        }
    }

    private void moveSelectionUp() {
        int currentIndex = this.buildList.getSelectionIndex();
        if (currentIndex > 0 && this.buildList.getSelectionCount() == 1) {
            String elementToMove = this.buildList.getItem(currentIndex);
            this.buildList.remove(currentIndex);
            this.buildList.add(elementToMove, currentIndex - 1);
            this.buildList.setSelection(currentIndex - 1);
        }
    }

    protected void performDefaults() {
        this.defaultOrderButton.setSelection(true);
        this.defaultsButtonSelected(true);
        this.maxItersField.loadDefault();
        IEclipsePreferences def = DefaultScope.INSTANCE.getNode("org.eclipse.core.resources");
        boolean autoBuild = def.getBoolean("description.autobuilding", true);
        this.autoBuildButton.setSelection(autoBuild);
        int simultaneousBuilds = def.getInt("maxConcurrentBuilds", 1);
        this.maxSimultaneousBuilds.setStringValue(Integer.toString(simultaneousBuilds));
        IPreferenceStore store = this.getIDEPreferenceStore();
        this.autoSaveAllButton.setSelection(store.getDefaultBoolean("SAVE_ALL_BEFORE_BUILD"));
        super.performDefaults();
    }

    public boolean performOk() {
        String[] buildOrder = null;
        boolean useDefault = this.defaultOrderButton.getSelection();
        if (!useDefault) {
            buildOrder = this.buildList.getItems();
        }
        IWorkspaceDescription description = this.getWorkspace().getDescription();
        if (this.autoBuildButton.getSelection() != this.getWorkspace().isAutoBuilding()) {
            try {
                description.setAutoBuilding(this.autoBuildButton.getSelection());
                this.getWorkspace().setDescription(description);
            }
            catch (CoreException e) {
                IDEWorkbenchPlugin.log("Error changing auto build workspace setting.", e.getStatus());
            }
        }
        if (this.maxSimultaneousBuilds.getIntValue() != description.getMaxConcurrentBuilds()) {
            try {
                description.setMaxConcurrentBuilds(this.maxSimultaneousBuilds.getIntValue());
                this.getWorkspace().setDescription(description);
            }
            catch (CoreException e) {
                IDEWorkbenchPlugin.log("Error changing max cucrrent builds workspace setting.", e.getStatus());
            }
        }
        IPreferenceStore store = this.getIDEPreferenceStore();
        store.setValue("SAVE_ALL_BEFORE_BUILD", this.autoSaveAllButton.getSelection());
        description.setBuildOrder(buildOrder);
        description.setMaxBuildIterations(this.maxItersField.getIntValue());
        try {
            this.getWorkspace().setDescription(description);
        }
        catch (CoreException exception) {
            return false;
        }
        if (!useDefault || useDefault != this.defaultOrderInitiallySelected) {
            this.defaultOrderInitiallySelected = useDefault;
            if (ResourcesPlugin.getWorkspace().isAutoBuilding()) {
                GlobalBuildAction action = new GlobalBuildAction(this.workbench.getActiveWorkbenchWindow(), 10);
                action.doBuild();
            }
        }
        this.customBuildOrder = null;
        return true;
    }

    private void removeSelection() {
        this.buildList.remove(this.buildList.getSelectionIndices());
    }

    private void setBuildOrderWidgetsEnablement(boolean value) {
        Control[] controlArray = this.buttonComposite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            child.setEnabled(value);
            ++n2;
        }
    }

    private String[] sortedDifference(IProject[] allProjects, String[] currentlyDisplayed) {
        TreeSet<String> difference = new TreeSet<String>();
        IProject[] iProjectArray = allProjects;
        int n = allProjects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject allProject = iProjectArray[n2];
            if (!this.includes(currentlyDisplayed, allProject.getName())) {
                difference.add(allProject.getName());
            }
            ++n2;
        }
        String[] returnValue = new String[difference.size()];
        difference.toArray(returnValue);
        return returnValue;
    }

    private void createMaxSimultaneousBuildsGroup(Composite composite) {
        this.maxSimultaneousBuilds = new IntegerFieldEditor("MAX_CONCURRENT_PROJECT_BUILDS", IDEWorkbenchMessages.WorkbenchPreference_maxSimultaneousBuilds, composite);
        this.maxSimultaneousBuilds.setPreferenceStore(this.getIDEPreferenceStore());
        this.maxSimultaneousBuilds.setPage((DialogPage)this);
        this.maxSimultaneousBuilds.setTextLimit(Integer.toString(1000).length());
        this.maxSimultaneousBuilds.setErrorMessage(NLS.bind((String)IDEWorkbenchMessages.WorkbenchPreference_maxSimultaneousBuildIntervalError, (Object)1000));
        this.maxSimultaneousBuilds.setValidateStrategy(0);
        this.maxSimultaneousBuilds.setValidRange(1, 1000);
        IWorkspaceDescription description = ResourcesPlugin.getWorkspace().getDescription();
        this.maxSimultaneousBuilds.setStringValue(Integer.toString(description.getMaxConcurrentBuilds()));
        this.maxSimultaneousBuilds.setPropertyChangeListener(event -> {
            if (event.getProperty().equals("field_editor_is_valid")) {
                this.setValid(this.maxSimultaneousBuilds.isValid());
            }
        });
    }

    protected void createSaveAllBeforeBuildPref(Composite composite) {
        this.autoSaveAllButton = new Button(composite, 32);
        this.autoSaveAllButton.setLayoutData((Object)new GridData(4, -1, true, false, 2, 1));
        this.autoSaveAllButton.setText(IDEWorkbenchMessages.IDEWorkspacePreference_savePriorToBuilding);
        this.autoSaveAllButton.setToolTipText(IDEWorkbenchMessages.IDEWorkspacePreference_savePriorToBuildingToolTip);
        this.autoSaveAllButton.setSelection(this.getIDEPreferenceStore().getBoolean("SAVE_ALL_BEFORE_BUILD"));
    }

    protected void createAutoBuildPref(Composite composite) {
        this.autoBuildButton = new Button(composite, 32);
        this.autoBuildButton.setLayoutData((Object)new GridData(4, -1, true, false, 2, 1));
        this.autoBuildButton.setText(IDEWorkbenchMessages.IDEWorkspacePreference_autobuild);
        this.autoBuildButton.setToolTipText(IDEWorkbenchMessages.IDEWorkspacePreference_autobuildToolTip);
        this.autoBuildButton.setSelection(ResourcesPlugin.getWorkspace().isAutoBuilding());
    }

    protected IPreferenceStore getIDEPreferenceStore() {
        return IDEWorkbenchPlugin.getDefault().getPreferenceStore();
    }
}

