/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.languageconfiguration.internal;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.io.Reader;
import java.util.List;
import org.eclipse.tm4e.languageconfiguration.internal.supports.AutoClosingPair;
import org.eclipse.tm4e.languageconfiguration.internal.supports.AutoClosingPairConditional;
import org.eclipse.tm4e.languageconfiguration.internal.supports.CharacterPair;
import org.eclipse.tm4e.languageconfiguration.internal.supports.OnEnterRule;

public class LanguageConfiguration {
    private List<CharacterPair> brackets;
    private List<OnEnterRule> onEnterRules;
    private List<AutoClosingPairConditional> autoClosingPairs;
    private List<AutoClosingPair> surroundingPairs;

    public static LanguageConfiguration load(Reader reader) {
        return (LanguageConfiguration)new GsonBuilder().registerTypeAdapter(CharacterPair.class, (json, typeOfT, context) -> {
            if (json.isJsonArray()) {
                JsonArray characterPairs = json.getAsJsonArray();
                return new CharacterPair(characterPairs.get(0).getAsString(), characterPairs.get(1).getAsString());
            }
            JsonObject object = json.getAsJsonObject();
            return new CharacterPair(object.get("open").getAsString(), object.get("close").getAsString());
        }).registerTypeAdapter(AutoClosingPair.class, (json, typeOfT, context) -> {
            if (json.isJsonArray()) {
                JsonArray autoClosingPairs = json.getAsJsonArray();
                return new AutoClosingPair(autoClosingPairs.get(0).getAsString(), autoClosingPairs.get(1).getAsString());
            }
            JsonObject object = json.getAsJsonObject();
            return new AutoClosingPair(object.get("open").getAsString(), object.get("close").getAsString());
        }).registerTypeAdapter(AutoClosingPairConditional.class, (json, typeOfT, context) -> {
            if (json.isJsonArray()) {
                JsonArray autoClosingPairs = json.getAsJsonArray();
                return new AutoClosingPairConditional(autoClosingPairs.get(0).getAsString(), autoClosingPairs.get(1).getAsString());
            }
            JsonObject object = json.getAsJsonObject();
            return new AutoClosingPairConditional(object.get("open").getAsString(), object.get("close").getAsString());
        }).create().fromJson(reader, LanguageConfiguration.class);
    }

    public List<CharacterPair> getBrackets() {
        return this.brackets;
    }

    public List<AutoClosingPairConditional> getAutoClosingPairs() {
        return this.autoClosingPairs;
    }

    public List<OnEnterRule> getOnEnterRules() {
        return this.onEnterRules;
    }

    public List<AutoClosingPair> getSurroundingPairs() {
        return this.surroundingPairs;
    }
}

