/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl.util;

import org.eclipse.birt.data.engine.impl.util.GraphNode;

public class DirectedGraphEdge {
    private GraphNode from;
    private GraphNode to;

    public DirectedGraphEdge(GraphNode from, GraphNode to) {
        if (from == null || to == null) {
            throw new IllegalArgumentException("from node or to node is null");
        }
        this.from = from;
        this.to = to;
    }

    public int hashCode() {
        int prime = 31;
        return 31 * this.from.hashCode() + this.to.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DirectedGraphEdge other = (DirectedGraphEdge)obj;
        return this.from.equals(other.getFrom()) && this.to.equals(other.getTo());
    }

    protected GraphNode getFrom() {
        return this.from;
    }

    protected GraphNode getTo() {
        return this.to;
    }
}

