/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.cubebuilder.joins.editpolicies;

import org.eclipse.birt.report.designer.ui.cubebuilder.joins.commands.SetConstraintCommand;
import org.eclipse.birt.report.designer.ui.cubebuilder.joins.editparts.DatasetNodeEditPart;
import org.eclipse.birt.report.designer.ui.cubebuilder.util.UIHelper;
import org.eclipse.birt.report.designer.util.ColorManager;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.olap.TabularCubeHandle;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.ResizableEditPolicy;
import org.eclipse.gef.editpolicies.XYLayoutEditPolicy;
import org.eclipse.gef.requests.CreateRequest;

public class JoinXYLayoutEditPolicy
extends XYLayoutEditPolicy {
    private TabularCubeHandle cube;

    public JoinXYLayoutEditPolicy(TabularCubeHandle cube) {
        this.cube = cube;
    }

    protected Command createAddCommand(EditPart child, Object constraint) {
        return null;
    }

    protected Command createChangeConstraintCommand(EditPart child, Object constraint) {
        SetConstraintCommand locationCommand = new SetConstraintCommand();
        if (child instanceof DatasetNodeEditPart) {
            locationCommand.setModuleHandle(((DatasetNodeEditPart)child).getCube().getRoot());
        } else {
            locationCommand.setModuleHandle(((DesignElementHandle)child.getModel()).getRoot());
        }
        locationCommand.setId(UIHelper.getId(child.getModel(), this.cube));
        Rectangle rect = new Rectangle((Rectangle)constraint);
        locationCommand.setLocation(rect);
        return locationCommand;
    }

    protected Command getCreateCommand(CreateRequest request) {
        return null;
    }

    protected Command getDeleteDependantCommand(Request request) {
        return null;
    }

    protected EditPolicy createChildEditPolicy(EditPart child) {
        return new ResizableEditPolicy(){

            protected IFigure createDragSourceFeedbackFigure() {
                Figure r = new Figure(){

                    protected void paintFigure(Graphics graphics) {
                        Rectangle rect = this.getBounds().getCopy();
                        graphics.setXORMode(true);
                        graphics.setForegroundColor(ColorConstants.white);
                        graphics.setBackgroundColor(ColorManager.getColor((int)31, (int)31, (int)31));
                        graphics.translate(this.getLocation());
                        PointList outline = new PointList();
                        outline.addPoint(0, 0);
                        outline.addPoint(rect.width, 0);
                        outline.addPoint(rect.width - 1, 0);
                        outline.addPoint(rect.width - 1, rect.height - 1);
                        outline.addPoint(0, rect.height - 1);
                        graphics.fillPolygon(outline);
                        PointList innerLine = new PointList();
                        innerLine.addPoint(rect.width - 0 - 1, 0);
                        innerLine.addPoint(rect.width - 0 - 1, 0);
                        innerLine.addPoint(rect.width - 1, 0);
                        innerLine.addPoint(rect.width - 0 - 1, 0);
                        innerLine.addPoint(0, 0);
                        innerLine.addPoint(0, rect.height - 1);
                        innerLine.addPoint(rect.width - 1, rect.height - 1);
                        innerLine.addPoint(rect.width - 1, 0);
                        graphics.drawPolygon(innerLine);
                        graphics.drawLine(rect.width - 0 - 1, 0, rect.width - 1, 0);
                        graphics.translate(this.getLocation().getNegated());
                    }
                };
                r.setBounds(this.getInitialFeedbackBounds());
                this.addFeedback((IFigure)r);
                return r;
            }
        };
    }
}

