/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.common.ui.tableviewer;

import java.text.Collator;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.datatools.sqltools.common.core.tableviewer.IRowData;
import org.eclipse.datatools.sqltools.common.core.tableviewer.ITableData;
import org.eclipse.datatools.sqltools.common.core.tableviewer.RowData;
import org.eclipse.datatools.sqltools.common.ui.internal.Activator;
import org.eclipse.datatools.sqltools.common.ui.tableviewer.AccessibleTableEditorImpl;
import org.eclipse.datatools.sqltools.common.ui.tableviewer.Messages;
import org.eclipse.datatools.sqltools.common.ui.tableviewer.TableCheckBoxCellEditor;
import org.eclipse.datatools.sqltools.common.ui.tableviewer.TableDataCellModifier;
import org.eclipse.datatools.sqltools.common.ui.tableviewer.TableDataTableCursor;
import org.eclipse.datatools.sqltools.common.ui.tableviewer.Util;
import org.eclipse.datatools.sqltools.common.ui.util.Images;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILazyContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableFontProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.IViewerLabelProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

public class AccessibleTableViewer
extends StructuredViewer {
    private TableDataTableCursor _cursor = null;
    protected boolean _dirty = false;
    private Color _backgroundColor = null;
    private Color _foregroundColor = null;
    public static final String GROUP_COPY = "group.copy";
    private VirtualManager _virtualManager;
    private AccessibleTableEditorImpl _accessibleTableEditorImpl;
    private Table _table;
    private TableEditor _tableEditor;
    private TableColorAndFontNoOp _tableColorAndFont = new TableColorAndFontNoOp();

    public AccessibleTableViewer(Composite parent) {
        this(parent, 2818);
    }

    public AccessibleTableViewer(Composite parent, int style) {
        this(new Table(parent, style));
    }

    public AccessibleTableViewer(Table table) {
        this._table = table;
        this._cursor = new TableDataTableCursor(this);
        this._tableEditor = new TableEditor(table);
        this.initTableViewerImpl();
        this.initializeVirtualManager(table.getStyle());
        this._backgroundColor = table.getBackground();
        this._foregroundColor = table.getForeground();
        this.init();
        this.registerMouseListener();
    }

    private void init() {
        TableColumn tableColumn = new TableColumn(this.getTable(), 0x1000000, 0);
        tableColumn.setWidth(0);
        tableColumn.setResizable(false);
    }

    public void setCellEditors(CellEditor[] editors) {
        this._accessibleTableEditorImpl.setCellEditors(editors);
        this._cursor.registerListeners();
        if (this.getTable().getItemCount() > 0) {
            this._cursor.setSelection(0, 0);
        }
    }

    public TableDataTableCursor getCursor() {
        return this._cursor;
    }

    public void setCursor(TableDataTableCursor cursor) {
        this._cursor = cursor;
    }

    public IRowData getRow() {
        TableItem tableItem = this._cursor.getRow();
        if (tableItem == null) {
            return null;
        }
        Object row = tableItem.getData();
        if (row instanceof IRowData) {
            return (IRowData)row;
        }
        return null;
    }

    public IRowData getOrCreateRow() {
        IRowData row = this.getRow();
        if (row == null) {
            ITableData tableData = (ITableData)this.getInput();
            IRowData newRow = tableData.insertRow();
            this.insert(newRow, this.getTable().getItemCount() - 1);
            this._cursor.setSelection(this.getTable().getItemCount() - 2, this._cursor.getColumn() + 1);
            this._cursor.redraw();
            return newRow;
        }
        return row;
    }

    public void setDirty(boolean value) {
        this._dirty = value;
    }

    public boolean isDirty() {
        return this._dirty;
    }

    public boolean isReadonly() {
        if (this.getInput() instanceof ITableData) {
            ITableData tableData = (ITableData)this.getInput();
            return tableData.isReadonly();
        }
        return false;
    }

    public void doInsertRow() {
        int column = 0;
        while (!((TableDataCellModifier)this.getCellModifier()).canChange(this.getRow(), column) && column < this.getTable().getColumnCount() - 2) {
            ++column;
        }
        if (column >= this.getTable().getColumnCount() - 2) {
            ITableData tableData = (ITableData)this.getInput();
            IRowData newRow = tableData.insertRow();
            this.insert(newRow, this.getTable().getItemCount() - 1);
            this._cursor.setSelection(this.getTable().getItemCount() - 2, this._cursor.getColumn());
            this.refresh();
        } else {
            this._cursor.setSelection(this.getTable().getItemCount() - 1, column + 1);
            this.doUpdateValue();
        }
    }

    public void doDelete() {
        IRowData row = this.getRow();
        if (row != null) {
            if (this.getInput() instanceof ITableData) {
                ITableData tableData = (ITableData)this.getInput();
                tableData.deleteRow(row);
                this.remove(row);
            }
            this.setDirty(true);
        }
    }

    public void doDeleteAll(boolean confirm) {
        int choice = 0;
        if (confirm) {
            String[] buttons = new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL};
            MessageDialog d = new MessageDialog(this.getControl().getShell(), Messages.AccessibleTableViewer_confirm_delete, null, Messages.AccessibleTableViewer_sure_to_delete, 3, buttons, 0);
            choice = d.open();
        }
        switch (choice) {
            case 0: {
                break;
            }
            case 1: {
                return;
            }
            default: {
                return;
            }
        }
        if (this.getInput() instanceof ITableData) {
            ITableData tableData = (ITableData)this.getInput();
            Vector rows = tableData.getRows();
            if (rows.size() < 1) {
                return;
            }
            int size = rows.size();
            int i = size - 1;
            while (i >= 0) {
                IRowData rowData = (IRowData)rows.get(i);
                if (rowData != null) {
                    tableData.deleteRow(rowData);
                }
                --i;
            }
            this.getTable().remove(0, this.getTable().getItemCount() - 2);
        }
        this.setDirty(true);
    }

    public void doUpdateValue() {
        this._cursor.edit();
    }

    public boolean setFocus() {
        return this._cursor.setFocus();
    }

    public boolean doSave() {
        boolean isSuccessful = true;
        try {
            ITableData tableData = null;
            if (this.getInput() instanceof ITableData) {
                tableData = (ITableData)this.getInput();
            }
            if (isSuccessful = tableData.save()) {
                this.setDirty(false);
            } else {
                tableData.resetRowsToOriginal();
            }
        }
        catch (Exception ex) {
            Activator.getDefault().log(Messages.AccessibleTableViewer_fail_to_save);
            this.displayException(Messages.AccessibleTableViewer_fail_to_save, ex);
        }
        return isSuccessful;
    }

    public void doRefresh(boolean confirm) {
        if (!this.isDirty()) {
            return;
        }
        int choice = 0;
        if (confirm) {
            String[] buttons = new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL};
            MessageDialog d = new MessageDialog(this.getControl().getShell(), Messages.AccessibleTableViewer_save, null, Messages.AccessibleTableViewer_save_changes, 3, buttons, 0);
            choice = d.open();
        }
        switch (choice) {
            case 0: {
                this.doSave();
                break;
            }
            case 1: {
                break;
            }
            default: {
                return;
            }
        }
        try {
            if (this.getInput() instanceof ITableData) {
                ITableData tableData = (ITableData)this.getInput();
                this.setInput(tableData);
                this._cursor.redraw();
                this.setDirty(false);
            }
        }
        catch (Exception ex) {
            Activator.getDefault().log(Messages.AccessibleTableViewer_fail_to_refresh);
            this.displayException(Messages.AccessibleTableViewer_fail_to_refresh, ex);
        }
    }

    public void doRevert() {
        if (this.getInput() instanceof ITableData) {
            ITableData tableData = (ITableData)this.getInput();
            tableData.revert();
        }
        this.refresh();
        this._cursor.redraw();
        this.setDirty(false);
    }

    protected void displayException(String msg, Exception ex) {
        Status warning = new Status(4, "org.eclipse.datatools.sqltools.common.ui", 1, ex.toString(), (Throwable)ex);
        ErrorDialog.openError((Shell)this.getControl().getShell(), (String)msg, null, (IStatus)warning);
    }

    public void doSetNull() {
        IRowData row = this.getOrCreateRow();
        row.updateValue(this._cursor.getColumn(), null);
        this.refresh(row);
        this._cursor.redraw();
        this.setDirty(true);
    }

    public void moveupRow() {
        Vector rows;
        int currentRow = this.getTable().indexOf(this.getCursor().getRow());
        if (currentRow == -1) {
            return;
        }
        if (currentRow == 0) {
            return;
        }
        if (this.getInput() instanceof ITableData) {
            rows = ((ITableData)this.getInput()).getRows();
            if (currentRow >= rows.size()) {
                return;
            }
        } else {
            return;
        }
        Object currentRowObj = rows.get(currentRow);
        Object previousRow = rows.get(currentRow - 1);
        rows.remove(currentRow);
        rows.add(currentRow, previousRow);
        rows.remove(currentRow - 1);
        rows.add(currentRow - 1, currentRowObj);
        this.refresh();
        this._cursor.setSelection(this.getTable().getItem(currentRow - 1), this._cursor.getColumn() + 1);
    }

    public void movedownRow() {
        Vector rows;
        Table table = this.getTable();
        int currentRow = this.getTable().indexOf(this.getCursor().getRow());
        if (currentRow == -1) {
            return;
        }
        if (currentRow + 1 == table.getItemCount()) {
            return;
        }
        if (this.getInput() instanceof ITableData) {
            rows = ((ITableData)this.getInput()).getRows();
            if (currentRow + 1 >= rows.size()) {
                return;
            }
        } else {
            return;
        }
        Object currentRowObj = rows.get(currentRow);
        Object nextRow = rows.get(currentRow + 1);
        rows.remove(currentRow);
        rows.add(currentRow, nextRow);
        rows.remove(currentRow + 1);
        rows.add(currentRow + 1, currentRowObj);
        this.refresh();
        this._cursor.setSelection(this.getTable().getItem(currentRow + 1), this._cursor.getColumn() + 1);
    }

    private void initializeVirtualManager(int style) {
        if ((style & 0x10000000) == 0) {
            return;
        }
        this._virtualManager = new VirtualManager();
    }

    public void add(Object[] elements) {
        this.assertElementsNotNull(elements);
        Object[] filtered = this.filter(elements);
        int i = 0;
        while (i < filtered.length) {
            Object element = filtered[i];
            int index = this.indexForElement(element);
            this.createItem(element, index);
            ++i;
        }
    }

    private void createItem(Object element, int index) {
        if (this._virtualManager == null) {
            this.updateItem((Widget)new TableItem(this.getTable(), 0, index), element);
        } else {
            this._virtualManager.notVisibleAdded(element, index);
        }
    }

    public void add(Object element) {
        this.add(new Object[]{element});
    }

    public void cancelEditing() {
        this._accessibleTableEditorImpl.cancelEditing();
    }

    protected Widget doFindInputItem(Object element) {
        if (this.equals(element, this.getRoot())) {
            return this.getTable();
        }
        return null;
    }

    protected Widget doFindItem(Object element) {
        TableItem[] children = this._table.getItems();
        int i = 0;
        while (i < children.length) {
            TableItem item = children[i];
            Object data = item.getData();
            if (data != null && this.equals(data, element)) {
                return item;
            }
            ++i;
        }
        return null;
    }

    protected void doUpdateItem(Widget widget, Object element, boolean fullMap) {
        if (widget instanceof TableItem) {
            TableItem item = (TableItem)widget;
            if (fullMap) {
                this.associate(element, (Item)item);
            } else {
                item.setData(element);
                this.mapElement(element, (Widget)item);
            }
            IBaseLabelProvider prov = this.getLabelProvider();
            ITableLabelProvider tprov = null;
            ILabelProvider lprov = null;
            if (prov instanceof ITableLabelProvider) {
                tprov = (ITableLabelProvider)prov;
            } else {
                lprov = (ILabelProvider)prov;
            }
            int columnCount = this._table.getColumnCount();
            TableItem ti = item;
            int column = 1;
            while (column < columnCount || column == 0) {
                String text = "";
                Image image = null;
                if (tprov != null) {
                    text = tprov.getColumnText(element, column - 1);
                    image = tprov.getColumnImage(element, column - 1);
                } else if (column == 0) {
                    if (lprov instanceof IViewerLabelProvider) {
                        IViewerLabelProvider itemProvider = (IViewerLabelProvider)lprov;
                        ViewerLabel updateLabel = new ViewerLabel(item.getText(), item.getImage());
                        itemProvider.updateLabel(updateLabel, element);
                        text = updateLabel.getText();
                        image = updateLabel.getImage();
                    } else {
                        text = lprov.getText(element);
                        image = lprov.getImage(element);
                    }
                }
                ti.setText(column, text);
                if (ti.getImage(column) != image) {
                    ti.setImage(column, image);
                }
                ++column;
            }
            if (prov instanceof IColorProvider) {
                IColorProvider cprov = (IColorProvider)prov;
                ti.setForeground(cprov.getForeground(element));
                ti.setBackground(cprov.getBackground(element));
            }
            if (prov instanceof IFontProvider) {
                IFontProvider fprov = (IFontProvider)prov;
                ti.setFont(fprov.getFont(element));
            }
        }
    }

    public void editElement(Object element, int column) {
        this._accessibleTableEditorImpl.editElement(element, column);
    }

    public CellEditor[] getCellEditors() {
        return this._accessibleTableEditorImpl.getCellEditors();
    }

    public ICellModifier getCellModifier() {
        if (this._accessibleTableEditorImpl == null) {
            return null;
        }
        return this._accessibleTableEditorImpl.getCellModifier();
    }

    public Object[] getColumnProperties() {
        return this._accessibleTableEditorImpl.getColumnProperties();
    }

    public Control getControl() {
        return this._table;
    }

    public Object getElementAt(int index) {
        TableItem i;
        if (index >= 0 && index < this._table.getItemCount() && (i = this._table.getItem(index)) != null) {
            return i.getData();
        }
        return null;
    }

    public IBaseLabelProvider getLabelProvider() {
        return super.getLabelProvider();
    }

    protected List getSelectionFromWidget() {
        TableItem[] items = this._table.getSelection();
        ArrayList<Object> list = new ArrayList<Object>(items.length);
        int i = 0;
        while (i < items.length) {
            TableItem item = items[i];
            Object e = item.getData();
            if (e != null) {
                list.add(e);
            }
            ++i;
        }
        return list;
    }

    public Table getTable() {
        return this._table;
    }

    protected int indexForElement(Object element) {
        ViewerSorter sorter = this.getSorter();
        if (sorter == null) {
            return this._table.getItemCount();
        }
        int count = this._table.getItemCount();
        int min = 0;
        int max = count - 1;
        while (min <= max) {
            int mid = (min + max) / 2;
            Object data = this._table.getItem(mid).getData();
            int compare = sorter.compare((Viewer)this, data, element);
            if (compare == 0) {
                while (compare == 0) {
                    if (++mid >= count) break;
                    data = this._table.getItem(mid).getData();
                    compare = sorter.compare((Viewer)this, data, element);
                }
                return mid;
            }
            if (compare < 0) {
                min = mid + 1;
                continue;
            }
            max = mid - 1;
        }
        return min;
    }

    private void initTableViewerImpl() {
        this._accessibleTableEditorImpl = new AccessibleTableEditorImpl(this){

            @Override
            Rectangle getBounds(Item item, int columnNumber) {
                return ((TableItem)item).getBounds(columnNumber);
            }

            @Override
            int getColumnCount() {
                return AccessibleTableViewer.this.getTable().getColumnCount();
            }

            @Override
            Item[] getSelection() {
                return AccessibleTableViewer.this.getTable().getSelection();
            }

            @Override
            void setEditor(Control w, Item item, int columnNumber) {
                AccessibleTableViewer.this._tableEditor.setEditor(w, (TableItem)item, columnNumber);
            }

            @Override
            void setSelection(StructuredSelection selection, boolean b) {
                AccessibleTableViewer.this.setSelection((ISelection)selection, b);
            }

            @Override
            void showSelection() {
                AccessibleTableViewer.this.getTable().showSelection();
            }

            @Override
            void setLayoutData(CellEditor.LayoutData layoutData) {
                ((AccessibleTableViewer)AccessibleTableViewer.this)._tableEditor.grabHorizontal = layoutData.grabHorizontal;
                ((AccessibleTableViewer)AccessibleTableViewer.this)._tableEditor.horizontalAlignment = layoutData.horizontalAlignment;
                ((AccessibleTableViewer)AccessibleTableViewer.this)._tableEditor.minimumWidth = layoutData.minimumWidth;
            }

            @Override
            void handleDoubleClickEvent() {
                StructuredViewer viewer = this.getViewer();
                AccessibleTableViewer.this.fireDoubleClick(new DoubleClickEvent((Viewer)viewer, viewer.getSelection()));
                AccessibleTableViewer.this.fireOpen(new OpenEvent((Viewer)viewer, viewer.getSelection()));
            }
        };
    }

    protected void inputChanged(Object input, Object oldInput) {
        this.getControl().setRedraw(false);
        try {
            this.refresh();
        }
        finally {
            this.setReadOnlyColor();
            this.getControl().setRedraw(true);
        }
    }

    private void setReadOnlyColor() {
        if (!(this.getInput() instanceof ITableData)) {
            return;
        }
        int itemCount = 0;
        itemCount = !((ITableData)this.getInput()).isNewRowDataAllowed() ? this.getTable().getItemCount() : this.getTable().getItemCount() - 1;
        if (itemCount < 1) {
            return;
        }
        int i = 0;
        while (i < itemCount) {
            this.setReadOnlyColor(this.getTable().getItem(i));
            ++i;
        }
    }

    protected void setReadOnlyColor(TableItem tableItem) {
        if (tableItem == null) {
            return;
        }
        int columnCount = this.getTable().getColumnCount();
        int i = 1;
        while (i < columnCount) {
            if (!(tableItem.getData() instanceof RowData)) {
                return;
            }
            ITableData tableData = ((RowData)tableItem.getData()).getTableData();
            boolean canChange = this.getCellModifier() != null && this.getCellModifier() instanceof TableDataCellModifier && ((TableDataCellModifier)this.getCellModifier()).canChange(tableItem.getData(), i - 1);
            Color backgroundColor = Util.getBackGroundColor((Device)this.getTable().getDisplay());
            Color foregroundColor = Util.getForeGroundColor((Device)this.getTable().getDisplay());
            if (tableData.isReadonly() || !canChange) {
                tableItem.setBackground(i, backgroundColor);
                tableItem.setForeground(i, foregroundColor);
                if (tableData.getColumnType(i - 1) == 16) {
                    Image image = Images.get("org.eclipse.datatools.sqltools.common.uiunchecked_readonly.gif");
                    if (((RowData)tableItem.getData()).getValue(i - 1) != null && ((RowData)tableItem.getData()).getValue(i - 1).toString().equalsIgnoreCase(Boolean.TRUE.toString())) {
                        image = Images.get("org.eclipse.datatools.sqltools.common.uichecked_readonly.gif");
                    }
                    tableItem.setImage(i, image);
                }
            } else {
                tableItem.setBackground(i, this._backgroundColor);
                tableItem.setForeground(i, this._foregroundColor);
            }
            ++i;
        }
    }

    public void insert(Object element, int position) {
        this._accessibleTableEditorImpl.applyEditorValue();
        if (this.getSorter() != null || this.hasFilters()) {
            this.add(element);
            return;
        }
        if (position == -1) {
            position = this._table.getItemCount();
        }
        this.createItem(element, position);
    }

    protected void internalRefresh(Object element) {
        this.internalRefresh(element, true);
        this.setReadOnlyColor(this.getCursor().getRow());
    }

    public void refreshViewer(Object element) {
        this.internalRefresh(element);
    }

    protected void internalRefresh(Object element, boolean updateLabels) {
        this._accessibleTableEditorImpl.applyEditorValue();
        if (element == null || this.equals(element, this.getRoot())) {
            if (this._virtualManager == null) {
                this.internalRefreshAll(updateLabels);
            } else {
                this.internalVirtualRefreshAll();
            }
        } else {
            Widget w = this.findItem(element);
            if (w != null) {
                this.updateItem(w, element);
            }
        }
    }

    private void internalVirtualRefreshAll() {
        Object root = this.getRoot();
        IContentProvider contentProvider = this.getContentProvider();
        if (!(contentProvider instanceof ILazyContentProvider) && contentProvider instanceof IStructuredContentProvider && root != null) {
            this._virtualManager.cachedElements = ((IStructuredContentProvider)this.getContentProvider()).getElements(root);
        }
        this.getTable().clearAll();
    }

    private void internalRefreshAll(boolean updateLabels) {
        TableItem item;
        Object[] children = this.getSortedChildren(this.getRoot());
        TableItem[] items = this.getTable().getItems();
        int min = Math.min(children.length, items.length);
        int i = 0;
        while (i < min) {
            item = items[i];
            if (this.equals(children[i], item.getData())) {
                if (updateLabels) {
                    this.updateItem((Widget)item, children[i]);
                } else {
                    this.associate(children[i], (Item)item);
                }
            } else {
                item.setText("");
                item.setImage(new Image[Math.max(1, this._table.getColumnCount())]);
                this.disassociate((Item)item);
            }
            ++i;
        }
        if (min < items.length) {
            i = items.length;
            while (--i >= min) {
                this.disassociate((Item)items[i]);
            }
            this._table.remove(min, items.length - 1);
        }
        if (this._table.getItemCount() == 0) {
            this._table.removeAll();
        }
        i = 0;
        while (i < min) {
            item = items[i];
            if (item.getData() == null) {
                this.updateItem((Widget)item, children[i]);
            }
            ++i;
        }
        i = min;
        while (i < children.length) {
            this.createItem(children[i], i);
            ++i;
        }
    }

    private void internalRemove(Object[] elements) {
        Object input = this.getInput();
        int i = 0;
        while (i < elements.length) {
            if (this.equals(elements[i], input)) {
                this.setInput(null);
                return;
            }
            ++i;
        }
        int[] indices = new int[elements.length];
        int count = 0;
        int i2 = 0;
        while (i2 < elements.length) {
            Widget w = this.findItem(elements[i2]);
            if (w instanceof TableItem) {
                TableItem item = (TableItem)w;
                this.disassociate((Item)item);
                indices[count++] = this._table.indexOf(item);
            }
            ++i2;
        }
        if (count < indices.length) {
            int[] nArray = indices;
            indices = new int[count];
            System.arraycopy(nArray, 0, indices, 0, count);
        }
        this._table.remove(indices);
        if (this._table.getItemCount() == 0) {
            this._table.removeAll();
        }
    }

    public boolean isCellEditorActive() {
        return this._accessibleTableEditorImpl.isCellEditorActive();
    }

    public void remove(final Object[] elements) {
        this.assertElementsNotNull(elements);
        this.preservingSelection(new Runnable(){

            @Override
            public void run() {
                AccessibleTableViewer.this.internalRemove(elements);
            }
        });
    }

    public void remove(Object element) {
        this.remove(new Object[]{element});
    }

    public void reveal(Object element) {
        Assert.isNotNull((Object)element);
        Widget w = this.findItem(element);
        if (w instanceof TableItem) {
            this.getTable().showItem((TableItem)w);
        }
    }

    public void setCellModifier(ICellModifier modifier) {
        this._accessibleTableEditorImpl.setCellModifier(modifier);
    }

    public void setColumnProperties(String[] columnProperties) {
        this._accessibleTableEditorImpl.setColumnProperties(columnProperties);
    }

    public void setLabelProvider(IBaseLabelProvider labelProvider) {
        Assert.isTrue((labelProvider instanceof ITableLabelProvider || labelProvider instanceof ILabelProvider ? 1 : 0) != 0);
        super.setLabelProvider(labelProvider);
        this._tableColorAndFont = labelProvider instanceof ITableFontProvider || labelProvider instanceof ITableColorProvider ? new TableColorAndFontCollector(labelProvider) : new TableColorAndFontNoOp();
    }

    protected void setSelectionToWidget(List list, boolean reveal) {
        if (list == null) {
            this._table.deselectAll();
            return;
        }
        int size = list.size();
        TableItem[] items = new TableItem[size];
        TableItem firstItem = null;
        int count = 0;
        int i = 0;
        while (i < size) {
            Object o = list.get(i);
            Widget w = this.findItem(o);
            if (w instanceof TableItem) {
                TableItem item = (TableItem)w;
                items[count++] = item;
                if (firstItem == null) {
                    firstItem = item;
                }
            }
            ++i;
        }
        if (count < size) {
            TableItem[] tableItemArray = items;
            items = new TableItem[count];
            System.arraycopy(tableItemArray, 0, items, 0, count);
        }
        this._table.setSelection(items);
        if (reveal && firstItem != null) {
            this._table.showItem(firstItem);
        }
    }

    public void setItemCount(int count) {
        this.getTable().setItemCount(count);
        this.getTable().redraw();
    }

    public void replace(Object element, int index) {
        TableItem item = this.getTable().getItem(index);
        this.refreshItem((Widget)item, element);
    }

    public void clear(int index) {
        TableItem item = this.getTable().getItem(index);
        if (item.getData() != null) {
            this.disassociate((Item)item);
        }
        this._table.clear(index);
    }

    protected Object[] getRawChildren(Object parent) {
        Assert.isTrue((!(this.getContentProvider() instanceof ILazyContentProvider) ? 1 : 0) != 0, (String)"Cannot get raw children with an ILazyContentProvider");
        return super.getRawChildren(parent);
    }

    protected void assertContentProviderType(IContentProvider provider) {
        Assert.isTrue((provider instanceof IStructuredContentProvider || provider instanceof ILazyContentProvider ? 1 : 0) != 0);
    }

    protected void setTableItemImage() {
        TableItem tableItem = this.getCursor().getRow();
        int columnNumber = this.getCursor().getColumn();
        if (this.getInput() instanceof ITableData) {
            ITableData tableData = (ITableData)this.getInput();
            int columnType = 0;
            try {
                columnType = tableData.getColumnType(columnNumber);
            }
            catch (RuntimeException runtimeException) {}
            if (columnType == 16) {
                IBaseLabelProvider labelProvider = this.getLabelProvider();
                ITableLabelProvider tableLabelProvider = null;
                if (labelProvider instanceof ITableLabelProvider) {
                    tableLabelProvider = (ITableLabelProvider)labelProvider;
                    Image image = tableLabelProvider.getColumnImage((Object)this.getRow(), columnNumber);
                    tableItem.setImage(columnNumber + 1, image);
                }
            }
        }
    }

    public void refresh() {
        super.refresh();
        this.setCursorVisible(true);
        this.getCursor().redraw();
        this.setReadOnlyColor();
    }

    private void setCursorVisible(boolean visible) {
        if (this.getCursor().getVisible() != visible) {
            this.refresh(this.getRow());
            this.getCursor().setVisible(visible);
        }
    }

    public void setSortable(boolean sort) {
        if (!sort) {
            return;
        }
        final Table table = this.getTable();
        Listener sortListener = new Listener(){
            private int order = -1;

            public void handleEvent(Event e) {
                TableItem[] items = table.getItems();
                Collator collator = Collator.getInstance(Locale.getDefault());
                TableColumn column = (TableColumn)e.widget;
                int index = 0;
                int columnCount = table.getColumnCount();
                int i = 0;
                while (i < columnCount) {
                    TableColumn tableColumn = table.getColumn(i);
                    if (tableColumn == column) {
                        index = i - 1;
                        break;
                    }
                    ++i;
                }
                ITableData tableData = (ITableData)AccessibleTableViewer.this.getInput();
                int sortLength = items.length;
                if (tableData.isNewRowDataAllowed()) {
                    sortLength = items.length - 1;
                }
                int i2 = 1;
                while (i2 < sortLength) {
                    Object value1 = ((IRowData)tableData.getRows().get(i2)).getValue(index);
                    if (value1 == null) {
                        value1 = "";
                    }
                    int j = 0;
                    while (j < i2) {
                        Object value2 = ((IRowData)tableData.getRows().get(j)).getValue(index);
                        if (value2 == null) {
                            value2 = "";
                        }
                        boolean b = true;
                        if (this.order == 1) {
                            b = collator.compare(value1, value2) > 0;
                        } else if (this.order == -1) {
                            boolean bl = b = collator.compare(value1, value2) < 0;
                        }
                        if (b) {
                            Vector vector = tableData.getRows();
                            Object tempObject = vector.get(i2);
                            vector.remove(i2);
                            vector.add(j, tempObject);
                            break;
                        }
                        ++j;
                    }
                    ++i2;
                }
                this.order *= -1;
                AccessibleTableViewer.this.refresh();
            }
        };
        TableColumn[] tableColumns = table.getColumns();
        int i = 0;
        while (i < tableColumns.length) {
            tableColumns[i].addListener(13, sortListener);
            ++i;
        }
    }

    private void registerMouseListener() {
        this.getTable().addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                if (e.button == 1) {
                    CellEditor editor = AccessibleTableViewer.this.getCellEditors()[AccessibleTableViewer.this.getCursor().getColumn()];
                    if (editor instanceof TableCheckBoxCellEditor) {
                        boolean isEditable = false;
                        if (AccessibleTableViewer.this.getCursor().getRow() == null) {
                            return;
                        }
                        AccessibleTableViewer.this.setSelection((ISelection)new StructuredSelection(AccessibleTableViewer.this.getCursor().getRow().getData()), true);
                        TableItem[] selection = AccessibleTableViewer.this.getTable().getSelection();
                        if (selection.length != 1) {
                            return;
                        }
                        TableItem item = selection[0];
                        int columns = AccessibleTableViewer.this.getTable().getColumnCount();
                        int i = 0;
                        while (i < columns) {
                            Rectangle bounds = item.getBounds(i);
                            if (bounds.contains(e.x, e.y)) {
                                isEditable = true;
                                break;
                            }
                            ++i;
                        }
                        if (isEditable) {
                            AccessibleTableViewer.this.getCursor().edit();
                            Boolean value = (Boolean)((TableCheckBoxCellEditor)editor).doGetValue();
                            ((TableCheckBoxCellEditor)editor).doSetValue(new Boolean(value == false));
                        }
                    } else {
                        AccessibleTableViewer.this.getCursor().forceFocus();
                    }
                }
            }

            public void mouseUp(MouseEvent e) {
            }
        });
    }

    private class TableColorAndFontCollector
    extends TableColorAndFontNoOp {
        ITableFontProvider _fontProvider;
        ITableColorProvider _colorProvider;

        public TableColorAndFontCollector(IBaseLabelProvider provider) {
            this._fontProvider = null;
            this._colorProvider = null;
            if (provider instanceof ITableFontProvider) {
                this._fontProvider = (ITableFontProvider)provider;
            }
            if (provider instanceof ITableColorProvider) {
                this._colorProvider = (ITableColorProvider)provider;
            }
        }

        @Override
        public void setFontsAndColors(TableItem tableItem, Object element, int column) {
            if (this._colorProvider != null) {
                tableItem.setBackground(column, this._colorProvider.getBackground(element, column));
                tableItem.setForeground(column, this._colorProvider.getForeground(element, column));
            }
            if (this._fontProvider != null) {
                tableItem.setFont(column, this._fontProvider.getFont(element, column));
            }
        }
    }

    private class TableColorAndFontNoOp {
        TableColorAndFontNoOp() {
        }

        public void setFontsAndColors(TableItem tableItem, Object element, int column) {
        }
    }

    private class VirtualManager {
        private Object[] cachedElements = new Object[0];

        public VirtualManager() {
            this.addTableListener();
        }

        private void addTableListener() {
            AccessibleTableViewer.this._table.addListener(36, new Listener(){

                public void handleEvent(Event event) {
                    IContentProvider contentProvider;
                    TableItem item = (TableItem)event.item;
                    int index = AccessibleTableViewer.this._table.indexOf(item);
                    Object element = VirtualManager.this.resolveElement(index);
                    if (element == null && (contentProvider = AccessibleTableViewer.this.getContentProvider()) instanceof ILazyContentProvider) {
                        ((ILazyContentProvider)contentProvider).updateElement(index);
                        return;
                    }
                    AccessibleTableViewer.this.associate(element, (Item)item);
                    AccessibleTableViewer.this.updateItem((Widget)item, element);
                }
            });
        }

        protected Object resolveElement(int index) {
            Object element = null;
            if (index < this.cachedElements.length) {
                element = this.cachedElements[index];
            }
            return element;
        }

        public void notVisibleAdded(Object element, int index) {
            int requiredCount = index + 1;
            if (requiredCount > AccessibleTableViewer.this.getTable().getItemCount()) {
                AccessibleTableViewer.this.getTable().setItemCount(requiredCount);
                Object[] newCache = new Object[requiredCount];
                System.arraycopy(this.cachedElements, 0, newCache, 0, this.cachedElements.length);
                this.cachedElements = newCache;
            }
            this.cachedElements[index] = element;
        }
    }
}

