/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cbi.targetplatform.ui.handler;

import com.google.common.base.Optional;
import java.io.File;
import java.lang.reflect.Method;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.core.target.ITargetHandle;
import org.eclipse.pde.core.target.ITargetPlatformService;
import org.eclipse.pde.core.target.LoadTargetDefinitionJob;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.target.WorkspaceFileTargetHandle;

public class PDEIntegration {
    private static final String ACQUIRE_SERVICE = "acquireService";
    private Optional<ITargetPlatformService> service = Optional.fromNullable((Object)PDEIntegration.acquireTargetPlatformService());

    private static ITargetPlatformService acquireTargetPlatformService() {
        RuntimeException toBeThrown = new RuntimeException("Method " + PDECore.class.getName() + ".acquireService(String|Class) cannot be found");
        try {
            Method acquireService = PDECore.getDefault().getClass().getMethod(ACQUIRE_SERVICE, String.class);
            return (ITargetPlatformService)acquireService.invoke((Object)PDECore.getDefault(), ITargetPlatformService.class.getName());
        }
        catch (ReflectiveOperationException e1) {
            toBeThrown.addSuppressed(e1);
            try {
                Method acquireService = PDECore.getDefault().getClass().getMethod(ACQUIRE_SERVICE, Class.class);
                return (ITargetPlatformService)acquireService.invoke((Object)PDECore.getDefault(), ITargetPlatformService.class);
            }
            catch (ReflectiveOperationException e2) {
                toBeThrown.addSuppressed(e2);
                throw toBeThrown;
            }
        }
    }

    public void setTargetPlatform(URI targetFileURIToSet, IProgressMonitor monitor) throws CoreException {
        if (this.service.isPresent()) {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            ITargetHandle[] targets = ((ITargetPlatformService)this.service.get()).getTargets((IProgressMonitor)subMonitor.newChild(20));
            boolean hasBeenSet = false;
            int i = 0;
            while (i < targets.length && !hasBeenSet) {
                if (targets[i] instanceof WorkspaceFileTargetHandle) {
                    WorkspaceFileTargetHandle fileHandle = (WorkspaceFileTargetHandle)targets[i];
                    hasBeenSet = this.trySetTargetPlatform(targetFileURIToSet, subMonitor, fileHandle);
                }
                ++i;
            }
        }
    }

    private boolean trySetTargetPlatform(URI targetFileURIToSet, SubMonitor subMonitor, WorkspaceFileTargetHandle fileHandle) throws CoreException {
        File targetFile = fileHandle.getTargetFile().getLocation().toFile();
        URI targetFileURI = URI.createFileURI((String)targetFile.getAbsolutePath());
        if (targetFileURI.equals(targetFileURIToSet)) {
            ITargetDefinition targetDefinitionToSet = fileHandle.getTargetDefinition();
            if (!targetDefinitionToSet.isResolved()) {
                targetDefinitionToSet.resolve((IProgressMonitor)subMonitor.newChild(80));
            }
            subMonitor.setWorkRemaining(0);
            IStatus compare = ((ITargetPlatformService)this.service.get()).compareWithTargetPlatform(targetDefinitionToSet);
            if (compare != null && !compare.isOK()) {
                LoadTargetDefinitionJob.load((ITargetDefinition)targetDefinitionToSet);
            }
            return true;
        }
        return false;
    }

    public Optional<URI> getActiveTargetPlatformFileURI() throws CoreException {
        ITargetDefinition currentlySelected;
        if (this.service.isPresent() && (currentlySelected = ((ITargetPlatformService)this.service.get()).getWorkspaceTargetHandle().getTargetDefinition()).getHandle() instanceof WorkspaceFileTargetHandle) {
            IFile targetFile = ((WorkspaceFileTargetHandle)currentlySelected.getHandle()).getTargetFile();
            URI targetFileURI = URI.createFileURI((String)targetFile.getLocation().toFile().getAbsolutePath());
            return Optional.of((Object)targetFileURI);
        }
        return Optional.absent();
    }
}

