/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.ui.internal.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.cft.server.core.internal.CloudFoundryServer;
import org.eclipse.cft.server.ui.internal.Messages;
import org.eclipse.cft.server.ui.internal.wizards.DeleteServicesWizardPage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.statushandlers.StatusManager;

public class DeleteServicesWizard
extends Wizard {
    private final CloudFoundryServer cloudServer;
    private DeleteServicesWizardPage page;
    private final List<String> services;

    public DeleteServicesWizard(CloudFoundryServer cloudServer, List<String> services) {
        this.cloudServer = cloudServer;
        this.services = services;
        this.setWindowTitle(Messages.DeleteServicesWizard_TITLE_DELETE_SERVICE);
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.page = new DeleteServicesWizardPage(this.cloudServer, this.services);
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        try {
            this.getContainer().run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        try {
                            List<String> selectedServices = DeleteServicesWizard.this.page.getSelectedServices();
                            if (selectedServices.size() > 0) {
                                DeleteServicesWizard.this.cloudServer.getBehaviour().operations().deleteServices(selectedServices).run(monitor);
                            }
                        }
                        catch (CoreException e) {
                            throw new InvocationTargetException(e);
                        }
                        catch (OperationCanceledException operationCanceledException) {
                            throw new InterruptedException();
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            });
            return true;
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof CoreException) {
                Status status = new Status(4, "org.eclipse.cft.server.core", NLS.bind((String)Messages.DeleteServicesWizard_ERROR_DELETE_SERVICE, (Object)this.cloudServer.getServer().getName(), (Object)e.getCause().getMessage()), (Throwable)e);
                StatusManager.getManager().handle((IStatus)status, 7);
            }
        }
        catch (InterruptedException interruptedException) {}
        return false;
    }
}

