/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.bag.immutable.primitive;

import aQute.bnd.annotation.spi.ServiceProvider;
import org.eclipse.collections.api.BooleanIterable;
import org.eclipse.collections.api.bag.primitive.ImmutableBooleanBag;
import org.eclipse.collections.api.bag.primitive.MutableBooleanBag;
import org.eclipse.collections.api.factory.bag.primitive.ImmutableBooleanBagFactory;
import org.eclipse.collections.impl.bag.immutable.primitive.ImmutableBooleanEmptyBag;
import org.eclipse.collections.impl.bag.immutable.primitive.ImmutableBooleanHashBag;
import org.eclipse.collections.impl.bag.immutable.primitive.ImmutableBooleanSingletonBag;
import org.eclipse.collections.impl.bag.mutable.primitive.BooleanHashBag;
import org.eclipse.collections.impl.factory.primitive.BooleanBags;

@ServiceProvider(value=ImmutableBooleanBagFactory.class)
public class ImmutableBooleanBagFactoryImpl
implements ImmutableBooleanBagFactory {
    public static final ImmutableBooleanBagFactory INSTANCE = new ImmutableBooleanBagFactoryImpl();

    public ImmutableBooleanBag empty() {
        return ImmutableBooleanEmptyBag.INSTANCE;
    }

    public ImmutableBooleanBag of() {
        return this.empty();
    }

    public ImmutableBooleanBag with() {
        return this.empty();
    }

    public ImmutableBooleanBag of(boolean one) {
        return this.with(one);
    }

    public ImmutableBooleanBag with(boolean one) {
        return new ImmutableBooleanSingletonBag(one);
    }

    public ImmutableBooleanBag of(boolean ... items) {
        return this.with(items);
    }

    public ImmutableBooleanBag with(boolean ... items) {
        if (items == null || items.length == 0) {
            return this.with();
        }
        if (items.length == 1) {
            return this.with(items[0]);
        }
        return ImmutableBooleanHashBag.newBagWith(items);
    }

    public ImmutableBooleanBag ofAll(BooleanIterable items) {
        return this.withAll(items);
    }

    public ImmutableBooleanBag withAll(BooleanIterable items) {
        if (items instanceof ImmutableBooleanBag) {
            return (ImmutableBooleanBag)items;
        }
        if (items == null) {
            return this.with();
        }
        BooleanHashBag bag = new BooleanHashBag();
        items.forEach(arg_0 -> ((MutableBooleanBag)bag).add(arg_0));
        if (bag.size() == 0) {
            return this.with();
        }
        if (bag.size() == 1) {
            return this.with(bag.toArray());
        }
        return ImmutableBooleanHashBag.newBagWith(bag);
    }

    public ImmutableBooleanBag ofAll(Iterable<Boolean> iterable) {
        return this.withAll(iterable);
    }

    public ImmutableBooleanBag withAll(Iterable<Boolean> iterable) {
        return BooleanBags.mutable.withAll(iterable).toImmutable();
    }
}

