/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.structures.binary;

import java.util.Collection;
import org.eclipse.emf.diffmerge.structures.IEqualityBasedStructure;
import org.eclipse.emf.diffmerge.structures.IEqualityTester;
import org.eclipse.emf.diffmerge.structures.IProperty;
import org.eclipse.emf.diffmerge.structures.IPropertyValue;
import org.eclipse.emf.diffmerge.structures.PropertyValue;
import org.eclipse.emf.diffmerge.structures.Relations;
import org.eclipse.emf.diffmerge.structures.binary.IBinaryRelation;

public abstract class AbstractBinaryRelation<T, U>
implements IBinaryRelation.WithProperties<T, U> {
    public static final IProperty<Boolean> PROPERTY_IS_FUNCTIONAL = new IProperty<Boolean>(){};
    public static final IProperty<Boolean> PROPERTY_IS_INJECTIVE = new IProperty<Boolean>(){};
    public static final IProperty<Boolean> PROPERTY_IS_ONE_TO_ONE = new IProperty<Boolean>(){};
    private final IEqualityTester _tester;

    protected AbstractBinaryRelation(IEqualityTester tester_p) {
        this._tester = tester_p != null ? tester_p : IEqualityBasedStructure.DEFAULT_TESTER;
    }

    @Override
    public IEqualityTester getEqualityTester() {
        return this._tester;
    }

    @Override
    public <V> IPropertyValue<V> getProperty(IProperty<V> property_p) {
        return Relations.binaryGetProperty(this, property_p);
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public IPropertyValue<Boolean> isFunctional() {
        return PropertyValue.unknownValue();
    }

    @Override
    public IPropertyValue<Boolean> isInjective() {
        return PropertyValue.unknownValue();
    }

    @Override
    public IPropertyValue<Boolean> isOneToOne() {
        IPropertyValue<Boolean> result = this.isFunctional();
        if (result.is(Boolean.TRUE)) {
            result = this.isInjective();
        }
        return result;
    }

    @Override
    public boolean maps(T source_p, U target_p) {
        assert (source_p != null && target_p != null);
        boolean result = false;
        Collection values = this.get(source_p);
        if (values != null) {
            result = values.contains(target_p);
        }
        return result;
    }

    @Override
    public IProperty<Boolean> propertyIsFunctional() {
        return PROPERTY_IS_FUNCTIONAL;
    }

    @Override
    public IProperty<Boolean> propertyIsInjective() {
        return PROPERTY_IS_INJECTIVE;
    }

    @Override
    public IProperty<Boolean> propertyIsOneToOne() {
        return PROPERTY_IS_ONE_TO_ONE;
    }
}

