/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.ui.util;

import java.util.regex.Matcher;
import org.eclipse.emf.common.ui.viewer.IUndecoratingLabelProvider;
import org.eclipse.emf.diffmerge.api.IMatch;
import org.eclipse.emf.diffmerge.api.IMatchPolicy;
import org.eclipse.emf.diffmerge.api.IPureMatch;
import org.eclipse.emf.diffmerge.api.Role;
import org.eclipse.emf.diffmerge.api.diff.IDifference;
import org.eclipse.emf.diffmerge.api.diff.IReferenceValuePresence;
import org.eclipse.emf.diffmerge.api.diff.IValuePresence;
import org.eclipse.emf.diffmerge.diffdata.EComparison;
import org.eclipse.emf.diffmerge.impl.policies.ConfigurableMatchPolicy;
import org.eclipse.emf.diffmerge.ui.EMFDiffMergeUIPlugin;
import org.eclipse.emf.diffmerge.ui.Messages;
import org.eclipse.emf.diffmerge.ui.diffuidata.MatchAndFeature;
import org.eclipse.emf.diffmerge.ui.util.DefaultDiffLabelDecorator;
import org.eclipse.emf.diffmerge.ui.util.DelegatingLabelProvider;
import org.eclipse.emf.diffmerge.ui.util.DifferenceKind;
import org.eclipse.emf.diffmerge.ui.util.IDiffLabelDecorator;
import org.eclipse.emf.diffmerge.ui.util.UIUtil;
import org.eclipse.emf.diffmerge.ui.viewers.CategoryManager;
import org.eclipse.emf.diffmerge.ui.viewers.EMFDiffNode;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreePathLabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;

public abstract class DiffDecoratingLabelProvider
extends DelegatingLabelProvider
implements IUndecoratingLabelProvider,
ITreePathLabelProvider,
IDiffLabelDecorator.Provider {
    private IDiffLabelDecorator _diffDecorator = this.getDefaultDiffLabelDecorator();
    private CacheEntry _diffCache = null;

    public DiffDecoratingLabelProvider() {
    }

    public DiffDecoratingLabelProvider(ILabelProvider delegate_p) {
        super(delegate_p);
    }

    protected void cacheClear() {
        this._diffCache = null;
    }

    protected CacheEntry cacheGet(Object element_p) {
        CacheEntry result = null;
        if (this._diffCache != null && element_p != null && element_p == this._diffCache.getElement()) {
            result = this._diffCache;
        }
        return result;
    }

    protected void cachePut(Object element_p) {
        if (element_p == null) {
            this.cacheClear();
        } else {
            DifferenceKind diffKind = this.doGetDiffStatus(element_p);
            Object representedElement = this.doGetElementToRepresent(element_p);
            this._diffCache = new CacheEntry(element_p, representedElement, diffKind);
        }
    }

    public void dispose() {
        super.dispose();
        this.cacheClear();
        this.setDiffLabelDecorator(null);
    }

    protected DifferenceKind doGetDiffStatus(Object element_p) {
        EMFDiffNode node;
        DifferenceKind result = DifferenceKind.NONE;
        if (element_p != null && (node = this.getDiffNode()) != null) {
            CategoryManager catManager = node.getCategoryManager();
            if (element_p instanceof IMatch && catManager.isComparisonPart((IMatch)element_p)) {
                result = catManager.getDifferenceKind((IMatch)element_p);
            } else if (element_p instanceof MatchAndFeature && catManager.isComparisonPart((IMatch)((MatchAndFeature)element_p).getMatch())) {
                result = catManager.getDifferenceKind((MatchAndFeature)element_p);
            } else if (element_p instanceof IDifference && catManager.isComparisonPart((IDifference)element_p)) {
                result = catManager.getDifferenceKind((IDifference)element_p);
            } else if (element_p instanceof EObject && this.getSide() != null) {
                result = catManager.getDifferenceKind((EObject)element_p, this.getSide());
            }
        }
        return result;
    }

    protected Object doGetElementToRepresent(Object element_p) {
        Object result = element_p;
        if (element_p instanceof IMatch) {
            result = this.getElementToRepresentFromMatch((IMatch)element_p);
        } else if (element_p instanceof MatchAndFeature) {
            result = ((MatchAndFeature)element_p).getFeature();
        } else if (element_p instanceof IValuePresence) {
            IValuePresence valuePresence = (IValuePresence)element_p;
            result = this.getElementToRepresent(this.isFromValue(valuePresence) ? valuePresence.getElementMatch() : valuePresence.getValue());
        } else if (element_p instanceof TreePath) {
            result = ((TreePath)element_p).getLastSegment();
        }
        return result;
    }

    @Override
    public Color getBackground(Object element_p) {
        Color result = this.getDiffLabelDecorator().getBackground(element_p, this.getUndecoratedBackground(element_p), this.getDifferenceKind(element_p), this.getSide(), this.getDiffNode());
        return result;
    }

    protected IDiffLabelDecorator getDefaultDiffLabelDecorator() {
        return DefaultDiffLabelDecorator.getInstance();
    }

    @Override
    public IDiffLabelDecorator getDiffLabelDecorator() {
        return this._diffDecorator;
    }

    protected DifferenceKind getDifferenceKind(Object element_p) {
        CacheEntry data = this.cacheGet(element_p);
        DifferenceKind result = data != null ? data.getDifferenceKind() : this.doGetDiffStatus(element_p);
        return result;
    }

    protected abstract EMFDiffNode getDiffNode();

    protected Object getElementToRepresent(Object element_p) {
        CacheEntry data = this.cacheGet(element_p);
        Object result = data != null ? data.getElementToRepresent() : this.doGetElementToRepresent(element_p);
        return result;
    }

    protected EObject getElementToRepresentFromMatch(IMatch match_p) {
        EMFDiffNode node;
        Role sideRole = this.getSide();
        if (sideRole == null && (node = this.getDiffNode()) != null) {
            sideRole = node.getDrivingRole();
        }
        if (sideRole == null) {
            sideRole = Role.TARGET;
        }
        EObject result = match_p.getUncoveredRole() == sideRole ? match_p.get(sideRole.opposite()) : match_p.get(sideRole);
        return result;
    }

    @Override
    public Font getFont(Object element_p) {
        Font result = this.getDiffLabelDecorator().getFont(element_p, this.getUndecoratedFont(element_p), this.getDifferenceKind(element_p), this.getSide(), this.getDiffNode());
        return result;
    }

    @Override
    public Color getForeground(Object element_p) {
        Color result = this.getDiffLabelDecorator().getForeground(element_p, this.getUndecoratedForeground(element_p), this.getDifferenceKind(element_p), this.getSide(), this.getDiffNode());
        return result;
    }

    @Override
    public Image getImage(Object element_p) {
        Image result = this.getDiffLabelDecorator().getImage(element_p, this.getUndecoratedImage(element_p), this.getDifferenceKind(element_p), this.getSide(), this.getDiffNode());
        return result;
    }

    protected String getMatchIDText(Object element_p) {
        String result = null;
        if (element_p instanceof IPureMatch) {
            IMatchPolicy policy = this.getMatchPolicy();
            Object matchID = ((IPureMatch)element_p).getMatchID();
            String matchIDText = null;
            if (matchID != null) {
                matchIDText = matchID.toString();
                if (policy instanceof ConfigurableMatchPolicy) {
                    ConfigurableMatchPolicy cPolicy = (ConfigurableMatchPolicy)policy;
                    for (String separator : cPolicy.getSeparators()) {
                        String outPattern = Matcher.quoteReplacement(String.valueOf('\n') + separator + ' ');
                        matchIDText = matchIDText.replaceAll(separator, outPattern);
                    }
                }
            } else if (policy != null && policy.keepMatchIDs()) {
                matchIDText = Messages.ComparisonTreeViewer_NoMatchID;
            }
            if (matchIDText != null) {
                result = String.valueOf(Messages.ComparisonTreeViewer_MatchIDTooltip) + matchIDText;
            }
        }
        return result;
    }

    protected IMatchPolicy getMatchPolicy() {
        EComparison comparison;
        IMatchPolicy result = null;
        EMFDiffNode node = this.getDiffNode();
        if (node != null && (comparison = node.getActualComparison()) != null) {
            result = comparison.getLastMatchPolicy();
        }
        return result;
    }

    protected Image getOrderDifferenceImage() {
        return EMFDiffMergeUIPlugin.getDefault().getImage(EMFDiffMergeUIPlugin.ImageID.SORT);
    }

    protected Image getOwnershipFeatureImage() {
        return EMFDiffMergeUIPlugin.getDefault().getImage(EMFDiffMergeUIPlugin.ImageID.TREE);
    }

    protected abstract Role getSide();

    @Override
    public StyledString getStyledText(Object element_p) {
        CharSequence label;
        Object base = this.getUndecoratedStyledText(element_p);
        if (base == null) {
            base = this.getUndecoratedText(element_p);
        }
        StyledString result = (label = this.getDiffLabelDecorator().getText(element_p, (CharSequence)base, this.getDifferenceKind(element_p), this.getSide(), this.getDiffNode())) instanceof StyledString ? (StyledString)label : new StyledString(label.toString());
        return result;
    }

    @Override
    public String getText(Object element_p) {
        CharSequence label = this.getDiffLabelDecorator().getText(element_p, this.getUndecoratedText(element_p), this.getDifferenceKind(element_p), this.getSide(), this.getDiffNode());
        String result = label instanceof StyledString || label == null ? null : label.toString();
        return result;
    }

    public String getToolTipText(Object element_p) {
        String result = this.getDiffLabelDecorator().getToolTipText(element_p, this.getUndecoratedToolTipText(element_p), this.getDifferenceKind(element_p), this.getSide(), this.getDiffNode());
        return result;
    }

    public Color getUndecoratedBackground(Object element_p) {
        Object elementToRepresent = this.getElementToRepresent(element_p);
        return elementToRepresent == element_p ? super.getBackground(elementToRepresent) : this.getUndecoratedBackground(elementToRepresent);
    }

    public Font getUndecoratedFont(Object element_p) {
        Object elementToRepresent = this.getElementToRepresent(element_p);
        return elementToRepresent == element_p ? super.getFont(elementToRepresent) : this.getUndecoratedFont(elementToRepresent);
    }

    public Color getUndecoratedForeground(Object element_p) {
        Object elementToRepresent = this.getElementToRepresent(element_p);
        return elementToRepresent == element_p ? super.getForeground(elementToRepresent) : this.getUndecoratedForeground(elementToRepresent);
    }

    public Image getUndecoratedImage(Object element_p) {
        Object elementToRepresent;
        Image result = this.isOwnershipFeature(element_p) ? this.getOwnershipFeatureImage() : (this.isOrderDifference(element_p) ? this.getOrderDifferenceImage() : ((elementToRepresent = this.getElementToRepresent(element_p)) == element_p ? super.getImage(elementToRepresent) : this.getUndecoratedImage(elementToRepresent)));
        return result;
    }

    public StyledString getUndecoratedStyledText(Object element_p) {
        Object elementToRepresent;
        StyledString result = element_p instanceof IValuePresence ? this.getUndecoratedStyledTextFromValuePresence((IValuePresence)element_p) : ((elementToRepresent = this.getElementToRepresent(element_p)) == element_p ? super.getStyledText(elementToRepresent) : this.getUndecoratedStyledText(elementToRepresent));
        return result;
    }

    protected StyledString getUndecoratedStyledTextFromHolder(String valueLabel_p, IValuePresence valuePresence_p) {
        StyledString result = new StyledString(valueLabel_p);
        if (valuePresence_p instanceof IReferenceValuePresence) {
            String containerLabel;
            EObject value = ((IReferenceValuePresence)valuePresence_p).getValue();
            EObject container = value.eContainer();
            String string = containerLabel = container == null ? null : this.getUndecoratedText(container);
            if (containerLabel != null) {
                containerLabel = String.format(Messages.ValuesViewer_ContainerLabel, containerLabel);
                result.append(' ');
                result.append(containerLabel, StyledString.QUALIFIER_STYLER);
            }
        }
        return result;
    }

    protected StyledString getUndecoratedStyledTextFromValue(String holderLabel_p, IValuePresence valuePresence_p) {
        String featureText;
        StyledString result = new StyledString(holderLabel_p);
        EStructuralFeature feature = valuePresence_p.getFeature();
        if (feature != null && (featureText = this.getUndecoratedText(feature)) != null) {
            featureText = String.format(Messages.ValuesViewer_FeatureLabel, featureText);
            result.append(' ');
            result.append(featureText, StyledString.QUALIFIER_STYLER);
        }
        return result;
    }

    protected StyledString getUndecoratedStyledTextFromValuePresence(IValuePresence valuePresence_p) {
        String base = this.getUndecoratedText(valuePresence_p);
        StyledString result = this.isFromValue(valuePresence_p) ? this.getUndecoratedStyledTextFromValue(base, valuePresence_p) : this.getUndecoratedStyledTextFromHolder(base, valuePresence_p);
        return result;
    }

    public String getUndecoratedText(Object element_p) {
        Object elementToRepresent;
        String result = this.isOrderDifference(element_p) ? Messages.ValuesViewer_OrderLabel : (element_p instanceof EStructuralFeature && !this.isTextTechnicalForMeta() ? UIUtil.getFormattedFeatureText((EStructuralFeature)element_p) : ((elementToRepresent = this.getElementToRepresent(element_p)) == element_p ? super.getText(elementToRepresent) : this.getUndecoratedText(elementToRepresent)));
        return result;
    }

    public String getUndecoratedToolTipText(Object element_p) {
        Object elementToRepresent = this.getElementToRepresent(element_p);
        return elementToRepresent == element_p ? super.getToolTipText(elementToRepresent) : this.getUndecoratedToolTipText(elementToRepresent);
    }

    protected boolean isFromValue(IValuePresence valuePresence_p) {
        return false;
    }

    protected boolean isOrderDifference(Object element_p) {
        return element_p instanceof IValuePresence && ((IValuePresence)element_p).isOrder();
    }

    protected boolean isOwnershipFeature(Object object_p) {
        return EMFDiffMergeUIPlugin.getDefault().getOwnershipFeature().equals(object_p);
    }

    protected boolean isTextTechnicalForMeta() {
        return false;
    }

    public void setDiffLabelDecorator(IDiffLabelDecorator diffDecorator_p) {
        IDiffLabelDecorator old = this._diffDecorator;
        this._diffDecorator = diffDecorator_p;
        if (this._diffDecorator == null) {
            this._diffDecorator = this.getDefaultDiffLabelDecorator();
        }
        if (this._diffDecorator != old) {
            this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)this));
        }
    }

    @Override
    public void update(ViewerCell cell_p) {
        Object element = cell_p.getElement();
        this.cachePut(element);
        super.update(cell_p);
        this.cacheClear();
    }

    public void updateLabel(ViewerLabel label_p, TreePath elementPath_p) {
        Object element = elementPath_p.getLastSegment();
        this.cachePut(element);
        label_p.setText(this.getText(element));
        label_p.setImage(this.getImage(element));
        label_p.setBackground(this.getBackground(element));
        label_p.setForeground(this.getForeground(element));
        this._defaultFont = label_p.getFont() != null ? UIUtil.getBase(label_p.getFont()) : null;
        label_p.setFont(this.getFont(element));
        this._defaultFont = null;
        this.cacheClear();
    }

    protected static class CacheEntry {
        private final Object _element;
        private final Object _elementToRepresent;
        private final DifferenceKind _differenceKind;

        public CacheEntry(Object element_p, Object elementToRepresent, DifferenceKind differenceKind_p) {
            this._element = element_p;
            this._elementToRepresent = elementToRepresent;
            this._differenceKind = differenceKind_p;
        }

        public boolean equals(Object object_p) {
            boolean result = false;
            if (object_p instanceof CacheEntry) {
                CacheEntry peer = (CacheEntry)object_p;
                result = this.getDifferenceKind().equals((Object)peer.getDifferenceKind()) && this.getElement().equals(peer.getElement()) && this.getElementToRepresent().equals(peer.getElementToRepresent());
            }
            return result;
        }

        public DifferenceKind getDifferenceKind() {
            return this._differenceKind;
        }

        public Object getElement() {
            return this._element;
        }

        public Object getElementToRepresent() {
            return this._elementToRepresent;
        }

        public int hashCode() {
            return this.getDifferenceKind().hashCode() + this.getElement().hashCode() + this.getElementToRepresent().hashCode();
        }
    }
}

