/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.helpgenerator.documentation;

import java.io.IOException;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.ease.helpgenerator.documentation.IClassNameResolver;

public class ReferenceTokenizer {
    private static final Pattern PATTERN_REFERENCE = Pattern.compile("\\{@(link|module)\\s+(.*?)(?:#([\\p{Alpha}-_]*)(?:\\((.*?)\\))?)?}");
    private String fType;
    private String fQualifiedName;
    private String fMethod;
    private String fParameters;

    public static String getSimpleClassName(String qualifiedClassName) {
        return qualifiedClassName.contains(".") ? qualifiedClassName.substring(qualifiedClassName.lastIndexOf(46) + 1) : qualifiedClassName;
    }

    public static String getPackageName(String qualifiedName) {
        return qualifiedName.contains(".") ? qualifiedName.substring(0, qualifiedName.lastIndexOf(46)) : "";
    }

    public ReferenceTokenizer(String reference, IClassNameResolver classNameResolver) throws IOException {
        Matcher matcher = PATTERN_REFERENCE.matcher(reference);
        if (!matcher.matches()) {
            throw new IOException("invalid reference detected: \"" + reference + "\"");
        }
        this.fType = matcher.group(1);
        this.fQualifiedName = classNameResolver.resolveClassName(matcher.group(2));
        this.fMethod = matcher.group(3);
        this.fParameters = matcher.group(4);
    }

    public ReferenceTokenizer(String reference) throws IOException {
        this(reference, name -> name);
    }

    public boolean isLink() {
        return "link".equals(this.fType);
    }

    public boolean isModule() {
        return "module".equals(this.fType);
    }

    public String getQualifiedName() {
        return this.fQualifiedName;
    }

    public String getMethod() {
        return this.fMethod;
    }

    public String getParameters() {
        return this.fParameters;
    }

    public boolean isConstructor() {
        return this.isLink() && this.getMethod() != null && Objects.equals(this.getMethod(), ReferenceTokenizer.getSimpleClassName(this.getQualifiedName()));
    }

    public boolean isMethod() {
        return this.getMethod() != null && this.getParameters() != null && !this.isConstructor();
    }

    public boolean isField() {
        return this.getMethod() != null && this.getParameters() == null;
    }

    public boolean isClass() {
        return this.getMethod() == null;
    }
}

