/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.controls.fx.util;

import com.ibm.icu.text.NumberFormat;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Locale;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.conversion.StringToNumberConverter;
import org.eclipse.emf.ecp.controls.fx.util.ECPTextFieldToModelUpdateValueStrategy;
import org.eclipse.emf.ecp.controls.fx.util.NumericalHelper;
import org.eclipse.emf.ecp.controls.internal.fx.Activator;

public class ECPNumericalFieldToModelUpdateValueStrategy
extends ECPTextFieldToModelUpdateValueStrategy {
    public ECPNumericalFieldToModelUpdateValueStrategy(Class<?> clazz) {
        IConverter converter = this.getConverter(clazz);
        this.setConverter(converter);
    }

    private IConverter getConverter(Class<?> clazz) {
        Locale locale = Locale.getDefault();
        NumberFormat numberInstance = NumberFormat.getNumberInstance((Locale)locale);
        numberInstance.setParseIntegerOnly(NumericalHelper.isInteger(clazz));
        numberInstance.setGroupingUsed(false);
        numberInstance.setMaximumFractionDigits(100);
        if (clazz.isPrimitive()) {
            try {
                if (Double.class.getField("TYPE").get(null).equals(clazz)) {
                    return StringToNumberConverter.toDouble((NumberFormat)numberInstance, (boolean)true);
                }
                if (Float.class.getField("TYPE").get(null).equals(clazz)) {
                    return StringToNumberConverter.toFloat((NumberFormat)numberInstance, (boolean)true);
                }
                if (Integer.class.getField("TYPE").get(null).equals(clazz)) {
                    return StringToNumberConverter.toInteger((NumberFormat)numberInstance, (boolean)true);
                }
                if (Long.class.getField("TYPE").get(null).equals(clazz)) {
                    return StringToNumberConverter.toLong((NumberFormat)numberInstance, (boolean)true);
                }
            }
            catch (IllegalArgumentException ex) {
                Activator.logException(ex);
            }
            catch (SecurityException ex) {
                Activator.logException(ex);
            }
            catch (IllegalAccessException ex) {
                Activator.logException(ex);
            }
            catch (NoSuchFieldException ex) {
                Activator.logException(ex);
            }
        } else {
            if (BigDecimal.class.isAssignableFrom(clazz)) {
                return StringToNumberConverter.toBigDecimal((NumberFormat)numberInstance);
            }
            if (BigInteger.class.isAssignableFrom(clazz)) {
                return StringToNumberConverter.toBigInteger((NumberFormat)numberInstance);
            }
            if (Double.class.isAssignableFrom(clazz)) {
                return StringToNumberConverter.toDouble((NumberFormat)numberInstance, (boolean)false);
            }
            if (Float.class.isAssignableFrom(clazz)) {
                return StringToNumberConverter.toFloat((NumberFormat)numberInstance, (boolean)false);
            }
            if (Integer.class.isAssignableFrom(clazz)) {
                return StringToNumberConverter.toInteger((NumberFormat)numberInstance, (boolean)false);
            }
            if (Long.class.isAssignableFrom(clazz)) {
                return StringToNumberConverter.toLong((NumberFormat)numberInstance, (boolean)false);
            }
        }
        return null;
    }
}

