/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.model.internal.fx;

import javafx.scene.Node;
import javafx.scene.control.Label;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.databinding.EMFDataBindingContext;
import org.eclipse.emf.databinding.EObjectObservableValue;
import org.eclipse.emf.databinding.edit.EMFEditObservables;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.view.model.internal.fx.RendererFX;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.model.LabelAlignment;
import org.eclipse.emf.ecp.view.spi.model.ModelChangeListener;
import org.eclipse.emf.ecp.view.spi.model.ModelChangeNotification;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.spi.model.VViewPackage;
import org.eclipse.emf.ecp.view.spi.renderer.NoPropertyDescriptorFoundExeption;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.AdapterFactoryItemDelegator;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.fx.core.databinding.JFXBeanProperties;

public abstract class AbstractControlRendererFX
extends RendererFX<VControl> {
    private EMFDataBindingContext dataBindingContext;
    private ComposedAdapterFactory composedAdapterFactory;
    private AdapterFactoryItemDelegator adapterFactoryItemDelegator;
    private ModelChangeListener viewChangeListener;
    private IObservableValue modelValue;

    @Override
    public void init(VControl control, ViewModelContext viewModelContext) {
        super.init(control, viewModelContext);
        this.composedAdapterFactory = new ComposedAdapterFactory(new AdapterFactory[]{new ReflectiveItemProviderAdapterFactory(), new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE)});
        this.adapterFactoryItemDelegator = new AdapterFactoryItemDelegator((AdapterFactory)this.composedAdapterFactory);
        if (this.getViewModelContext() != null) {
            this.viewChangeListener = new ModelChangeListener(){

                public void notifyChange(ModelChangeNotification notification) {
                    if (notification.getNotifier() != AbstractControlRendererFX.this.getVElement()) {
                        return;
                    }
                    if (notification.getStructuralFeature() == VViewPackage.eINSTANCE.getElement_Visible()) {
                        AbstractControlRendererFX.this.applyVisible();
                    }
                    if (notification.getStructuralFeature() == VViewPackage.eINSTANCE.getElement_Enabled() && !((VControl)AbstractControlRendererFX.this.getVElement()).isReadonly()) {
                        AbstractControlRendererFX.this.applyEnable();
                    }
                    if (notification.getStructuralFeature() == VViewPackage.eINSTANCE.getElement_Diagnostic()) {
                        AbstractControlRendererFX.this.applyValidation();
                    }
                }
            };
            this.getViewModelContext().registerViewChangeListener(this.viewChangeListener);
        }
    }

    protected void applyValidation() {
    }

    protected void applyEnable() {
    }

    protected void applyVisible() {
    }

    protected IItemPropertyDescriptor getItemPropertyDescriptor(EStructuralFeature.Setting setting) {
        return this.adapterFactoryItemDelegator.getPropertyDescriptor((Object)setting.getEObject(), (Object)setting.getEStructuralFeature());
    }

    protected final DataBindingContext getDataBindingContext() {
        if (this.dataBindingContext == null) {
            this.dataBindingContext = new EMFDataBindingContext();
        }
        return this.dataBindingContext;
    }

    protected IObservableValue getTargetObservable(Object source, String property) {
        return JFXBeanProperties.value((String)property).observe(source);
    }

    protected IObservableValue getModelObservable(EStructuralFeature.Setting setting) {
        return new EObjectObservableValue(setting.getEObject(), setting.getEStructuralFeature()){

            public Object getValueType() {
                return ((EStructuralFeature)super.getValueType()).getEType().getInstanceClass();
            }
        };
    }

    protected Binding bindModelToTarget(IObservableValue target, IObservableValue model, UpdateValueStrategy targetToModelStrategy, UpdateValueStrategy modelToTargetStrategy) {
        final Binding binding = this.getDataBindingContext().bindValue(target, model, targetToModelStrategy, modelToTargetStrategy);
        binding.getValidationStatus().addValueChangeListener(new IValueChangeListener(){

            public void handleValueChange(ValueChangeEvent event) {
                IStatus statusNew = (IStatus)event.diff.getNewValue();
                if (4 == statusNew.getSeverity()) {
                    binding.updateModelToTarget();
                }
            }
        });
        return binding;
    }

    protected void applyValidation(VControl control, Node node) {
        if (control.getDiagnostic() == null) {
            node.setId(null);
            return;
        }
        switch (control.getDiagnostic().getHighestSeverity()) {
            case 4: {
                node.setId("error");
                break;
            }
            case 0: {
                node.setId(null);
            }
        }
    }

    protected final IObservableValue getModelValue(EStructuralFeature.Setting setting) {
        if (this.modelValue == null) {
            this.modelValue = EMFEditObservables.observeValue((EditingDomain)this.getEditingDomain(setting), (EObject)setting.getEObject(), (EStructuralFeature)setting.getEStructuralFeature());
        }
        return this.modelValue;
    }

    protected final EditingDomain getEditingDomain(EStructuralFeature.Setting setting) {
        return AdapterFactoryEditingDomain.getEditingDomainFor((EObject)setting.getEObject());
    }

    protected Label createLabel() throws NoPropertyDescriptorFoundExeption {
        Label label = null;
        EStructuralFeature.Setting setting = (EStructuralFeature.Setting)((VControl)this.getVElement()).getDomainModelReference().getIterator().next();
        if (setting == null) {
            return null;
        }
        IItemPropertyDescriptor itemPropertyDescriptor = this.getItemPropertyDescriptor(setting);
        if (itemPropertyDescriptor == null) {
            throw new NoPropertyDescriptorFoundExeption(setting.getEObject(), setting.getEStructuralFeature());
        }
        if (((VControl)this.getVElement()).getLabelAlignment() == LabelAlignment.LEFT) {
            label = new Label();
            label.setText(itemPropertyDescriptor.getDisplayName((Object)setting.getEObject()));
        }
        return label;
    }

    protected Node createValidationIcon() {
        Label label = new Label();
        return label;
    }

    public AdapterFactoryItemDelegator getAdapterFactoryItemDelegator() {
        return this.adapterFactoryItemDelegator;
    }
}

