/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.internal.editor.handlers;

import java.util.Collection;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.DeleteCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emfforms.common.Optional;
import org.eclipse.emfforms.internal.editor.ui.CreateNewChildDialog;
import org.eclipse.emfforms.spi.editor.handler.DeleteShortCutHandler;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

public class ShortcutHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IEditorPart editor = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        StructuredSelection sSelection = (StructuredSelection)HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (sSelection == null) {
            return null;
        }
        Object selection = sSelection.getFirstElement();
        if (!(selection instanceof EObject)) {
            return null;
        }
        String commandName = event.getCommand().getId();
        EObject currentSelection = (EObject)selection;
        EditingDomain editingDomain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)currentSelection);
        if (this.getDeleteCmdName().equals(commandName)) {
            this.performDelete(sSelection, editingDomain);
        } else if (this.getNewChildCmdName().equals(commandName)) {
            this.createNewElementDialog(editingDomain, editor.getEditorSite().getSelectionProvider(), currentSelection, "Create Child").open();
        } else if (this.getNewSiblingCmdName().equals(commandName)) {
            EObject parent = currentSelection.eContainer();
            EditingDomain parentEditingDomain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)parent);
            this.createNewElementDialog(parentEditingDomain, editor.getEditorSite().getSelectionProvider(), parent, "Create Sibling").open();
        }
        return null;
    }

    private void performDelete(StructuredSelection sSelection, EditingDomain editingDomain) {
        Optional<DeleteShortCutHandler> deleteHandler = this.getDeleteHandler();
        if (deleteHandler.isPresent()) {
            ((DeleteShortCutHandler)deleteHandler.get()).handleDeleteShortcut(sSelection.toList());
            return;
        }
        Command command = DeleteCommand.create((EditingDomain)editingDomain, (Collection)sSelection.toList());
        if (!command.canExecute()) {
            return;
        }
        editingDomain.getCommandStack().execute(command);
    }

    private Optional<DeleteShortCutHandler> getDeleteHandler() {
        Bundle bundle = FrameworkUtil.getBundle(ShortcutHandler.class);
        BundleContext bundleContext = bundle.getBundleContext();
        ServiceReference serviceReference = bundleContext.getServiceReference(DeleteShortCutHandler.class);
        if (serviceReference == null) {
            return Optional.empty();
        }
        DeleteShortCutHandler service = (DeleteShortCutHandler)bundleContext.getService(serviceReference);
        Optional result = Optional.ofNullable((Object)service);
        bundleContext.ungetService(serviceReference);
        return result;
    }

    protected String getNewSiblingCmdName() {
        return "org.eclipse.emfforms.editor.new.sibling";
    }

    protected String getNewChildCmdName() {
        return "org.eclipse.emfforms.editor.new";
    }

    protected String getDeleteCmdName() {
        return "org.eclipse.emfforms.editor.delete";
    }

    protected Dialog createNewElementDialog(EditingDomain editingDomain, ISelectionProvider selectionProvider, EObject selection, String title) {
        return new CreateNewChildDialog(Display.getCurrent().getActiveShell(), title, selection, selectionProvider);
    }
}

