/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.internal.rule;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.common.spi.UniqueSetting;
import org.eclipse.emf.ecp.view.internal.rule.CompositeConditionService;
import org.eclipse.emf.ecp.view.spi.rule.ConditionService;
import org.eclipse.emf.ecp.view.spi.rule.model.Condition;
import org.eclipse.emf.ecp.view.spi.rule.model.IterateCondition;
import org.eclipse.emf.ecp.view.spi.rule.model.RulePackage;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedException;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedReport;
import org.eclipse.emfforms.spi.core.services.databinding.emf.EMFFormsDatabindingEMF;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ConditionService.class})
public class IterateConditionService
extends CompositeConditionService<IterateCondition> {
    private EMFFormsDatabindingEMF databindings;
    private ReportService reportService;

    @Reference
    void setDatabindings(EMFFormsDatabindingEMF databindings) {
        this.databindings = databindings;
    }

    @Reference
    void setReportService(ReportService reportService) {
        this.reportService = reportService;
    }

    @Override
    public EClass getConditionType() {
        return RulePackage.Literals.ITERATE_CONDITION;
    }

    @Override
    protected List<? extends EObject> getTargets(IterateCondition condition, EObject domainModel) {
        try {
            return this.databindings.getObservableList(condition.getItemReference(), domainModel);
        }
        catch (DatabindingFailedException e) {
            this.reportService.report((AbstractReport)new DatabindingFailedReport((Throwable)e));
            return Collections.emptyList();
        }
    }

    @Override
    protected Iterable<? extends Condition> components(IterateCondition condition) {
        Condition result = condition.getItemCondition();
        if (result == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(result);
    }

    @Override
    public Set<UniqueSetting> getConditionSettings(IterateCondition condition, EObject domainModel) {
        Set<UniqueSetting> result = super.getConditionSettings(condition, domainModel);
        try {
            result.add(UniqueSetting.createSetting((EStructuralFeature.Setting)this.databindings.getSetting(condition.getItemReference(), domainModel)));
        }
        catch (DatabindingFailedException e) {
            this.reportService.report((AbstractReport)new DatabindingFailedReport((Throwable)e));
        }
        return result;
    }
}

