/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.spi.common.ui;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecp.spi.common.ui.ECPWizard;
import org.eclipse.emf.ecp.spi.common.ui.composites.SelectionComposite;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class SelectModelElementWizard
extends ECPWizard<SelectionComposite<? extends ColumnViewer>> {
    private final String pageName;
    private final String description;
    private final String pageTitle;
    private final Class<?> classtoSelect;

    public SelectModelElementWizard(String windowTitle, String pageName, String pageTitle, String description) {
        this(windowTitle, pageName, pageTitle, description, EClass.class);
    }

    public SelectModelElementWizard(String windowTitle, String pageName, String pageTitle, String description, Class<?> classtoSelect) {
        this.classtoSelect = classtoSelect;
        this.setWindowTitle(windowTitle);
        this.pageName = pageName;
        this.description = description;
        this.pageTitle = pageTitle;
    }

    public void addPages() {
        super.addPages();
        WizardPageExtension wp = new WizardPageExtension(this.pageName);
        this.addPage((IWizardPage)wp);
        wp.setTitle(this.pageTitle);
        wp.setDescription(this.description);
    }

    public boolean performFinish() {
        return true;
    }

    public void dispose() {
        ((SelectionComposite)this.getCompositeProvider()).dispose();
        super.dispose();
    }

    public String getPageName() {
        return this.pageName;
    }

    public String getDescription() {
        return this.description;
    }

    public String getPageTitle() {
        return this.pageTitle;
    }

    public final class WizardPageExtension
    extends WizardPage {
        public WizardPageExtension(String pageName) {
            super(pageName);
        }

        public void createControl(Composite parent) {
            Composite composite = ((SelectionComposite)SelectModelElementWizard.this.getCompositeProvider()).createUI(parent);
            ((ColumnViewer)((SelectionComposite)SelectModelElementWizard.this.getCompositeProvider()).getViewer()).addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    IStructuredSelection sel = (IStructuredSelection)((ColumnViewer)((SelectionComposite)SelectModelElementWizard.this.getCompositeProvider()).getViewer()).getSelection();
                    if (sel != null && !sel.isEmpty() && SelectModelElementWizard.this.classtoSelect.isAssignableFrom(sel.getFirstElement().getClass())) {
                        WizardPageExtension.this.setPageComplete(true);
                    } else {
                        WizardPageExtension.this.setPageComplete(false);
                    }
                }
            });
            ((ColumnViewer)((SelectionComposite)SelectModelElementWizard.this.getCompositeProvider()).getViewer()).addDoubleClickListener(new IDoubleClickListener(){

                public void doubleClick(DoubleClickEvent event) {
                    if (WizardPageExtension.this.isPageComplete() && SelectModelElementWizard.this.performFinish()) {
                        ((WizardDialog)WizardPageExtension.this.getContainer()).close();
                    }
                }
            });
            this.setPageComplete(false);
            this.setControl((Control)composite);
        }
    }
}

