/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.internal.common.report;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.common.report.ReportServiceConsumer;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component
public class ReportServiceImpl
implements ReportService {
    private final List<AbstractReport> reports = new ArrayList<AbstractReport>();
    private final Set<ReportServiceConsumer> consumers = new LinkedHashSet<ReportServiceConsumer>();

    @Override
    public void report(AbstractReport reportEntity) {
        this.reports.add(reportEntity);
        for (ReportServiceConsumer consumer : this.consumers) {
            consumer.reported(reportEntity);
        }
    }

    @Override
    public List<AbstractReport> getReports() {
        return this.reports;
    }

    @Override
    public void clearReports() {
        this.reports.clear();
    }

    @Override
    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    public void addConsumer(ReportServiceConsumer consumer) {
        this.consumers.add(consumer);
    }

    @Override
    public void removeConsumer(ReportServiceConsumer consumer) {
        this.consumers.remove(consumer);
    }
}

