# Data TCK Signature Tests

This package is inherited from the Platform-TCK (https://github.com/eclipse-ee4j/jakartaee-tck/tree/master/src/com/sun/ts/tests/signaturetest)

The latest signature files are updated in the Jakarta Data TCK Repository 
(data/tck/src/main/resources/ee/jakarta/tck/data/framework/signature) 
generated using sigtest-maven-plugin.jar (version 2.3).

The signature tests are run using the sigtest-maven-plugin.jar and the framework available in this folder.

## For TCK developers

### The configuration

The signature file will be generated by the Data team using the `tck/pom.xml`. 
The pom.xml has a `signature-generation` profile configured for this purpose.
The plugin that generates the signature file has been copied below for reference:


```xml
  <!-- Run signature plugin to generate signature file -->
  <plugin>
    <groupId>jakarta.tck</groupId>
    <artifactId>sigtest-maven-plugin</artifactId>
    <version>${sigtest.version}</version>
    <executions>
      <execution>
        <id>createSigFile</id>
        <phase>generate-resources</phase>
        <goals>
          <goal>generate</goal>
        </goals>
      </execution>
    </executions>
    <configuration>
      <classes>${project.build.directory}/jakarta-data-api</classes>
      <classes>${project.build.directory}/jimage/java.base</classes><classes>${project.build.directory}/jimage/java.base</classes>
      <packages>
        jakarta.data,
        jakarta.data.exceptions,
        jakarta.data.page,
        jakarta.data.repository
      </packages>
      <attach>false</attach>
      <sigfile>${project.build.directory}/jakarta.data.sig_${java.version}</sigfile>
    </configuration>
  </plugin>
```

- The `classes` configuration points to a location where an earlier plugin has unpacked the api jar from which we are generating the signature file.
- The `packages` configuration specifies the packages we want to generate signatures from. 
- The `attach` configuration specifies that we do not want the plugin to use its default file extension
- The `sigfile` configurations specifies the signature file we want the plugin to generate

### Generating the Signature File

To generate the signature file first build the API:

```sh
cd api
mvn package
```

Then build the TCK with the `signature-generation` profile to re-generate the signature file:

```sh
cd ../tck
mvn package -Psignature-generation
```

The signature file will be generated in the `/target/` directory.

The signature file will be automatically copied to the `/src/main/resource/ee/jakarta/tck/data/framework/signature/` directory.

## For TCK users

### Running signature tests

#### Standalone Implementation

Signature tests will be automatically run as part of the TCK via the `ee.jakarta.tck.data.standalone.signature` package. 

This package will run the signature tests on the Java SE runtime.
The package runs the signature test using the signaturetest framework from the Platform TCK.

TCK users will need to set a JVM property `-Djimage.dir=<path-your-test-has-access-to>`.
This directory will be populated with class files extracted from the JDK modules.

TCK users will need to set a JVM property `-Dsignature.sigTestClasspath=<path-to-your-api-distribution>:<path-to-jimage-dir>`
This directory will be used to create a virtual classpath for the signature test plugin to use to compare API signatures.

#### Server Implementation

Signature tests will be automatically run as part of the TCK via the `ee.jakarta.tck.data.core.signature` package. 

This package will deploy an application to the Jakarta EE Server. 
The application runs the signature test using the signaturetest framework from the Platform TCK.

Note: The application protocol used for communication between client and application will depend on your Arquillian protocol:
- Core Profile: Should use the REST protocol
- Web Profile: Should use the servlet protocol

TCK users will only need to set a single JVM property `-Djimage.dir=<path-your-app-server-has-access-to>`.
This directory will be populated with class files extracted from the JDK modules.