/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.lite.extension.translator;

import jakarta.enterprise.inject.build.compatible.spi.BuildCompatibleExtension;
import jakarta.enterprise.inject.build.compatible.spi.SkipIfPortableExtensionPresent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ServiceLoader;

public class BuildCompatibleExtensionLoader {
    private static volatile List<Class<? extends BuildCompatibleExtension>> allKnownExtensions;
    private static final Object lock;

    private BuildCompatibleExtensionLoader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Class<? extends BuildCompatibleExtension>> getBuildCompatibleExtensions(ClassLoader classLoader) {
        List<Class<? extends BuildCompatibleExtension>> listCopy = allKnownExtensions;
        if (listCopy == null) {
            Object object = lock;
            synchronized (object) {
                if (allKnownExtensions == null) {
                    allKnownExtensions = new ArrayList<Class<? extends BuildCompatibleExtension>>();
                    for (BuildCompatibleExtension extension : ServiceLoader.load(BuildCompatibleExtension.class, classLoader)) {
                        Class<?> extensionClass = extension.getClass();
                        SkipIfPortableExtensionPresent skip = extensionClass.getAnnotation(SkipIfPortableExtensionPresent.class);
                        if (skip != null) continue;
                        allKnownExtensions.add(extensionClass);
                    }
                }
                return Collections.unmodifiableList(allKnownExtensions);
            }
        }
        return Collections.unmodifiableList(listCopy);
    }

    public static List<Class<? extends BuildCompatibleExtension>> getBuildCompatibleExtensions() {
        return BuildCompatibleExtensionLoader.getBuildCompatibleExtensions(Thread.currentThread().getContextClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearDiscoveredExtensions() {
        Object object = lock;
        synchronized (object) {
            allKnownExtensions = null;
        }
    }

    static {
        lock = new Object();
    }
}

