/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.common;

import com.sun.enterprise.util.LocalStringManagerImpl;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.glassfish.api.ActionReport;

public abstract class ActionReporter
extends ActionReport {
    protected Throwable exception = null;
    protected String actionDescription = null;
    protected List<ActionReporter> subActions = new ArrayList<ActionReporter>();
    protected ActionReport.ExitCode exitCode = ActionReport.ExitCode.SUCCESS;
    protected ActionReport.MessagePart topMessage = new ActionReport.MessagePart();
    protected String contentType = "text/html; charset=utf-8";
    public static final String EOL_MARKER = "%%%EOL%%%";

    public void setFailure() {
        this.setActionExitCode(ActionReport.ExitCode.FAILURE);
    }

    public boolean isFailure() {
        return this.getActionExitCode() == ActionReport.ExitCode.FAILURE;
    }

    public void setWarning() {
        this.setActionExitCode(ActionReport.ExitCode.WARNING);
    }

    public boolean isWarning() {
        return this.getActionExitCode() == ActionReport.ExitCode.WARNING;
    }

    public boolean isSuccess() {
        return this.getActionExitCode() == ActionReport.ExitCode.SUCCESS;
    }

    public void setSuccess() {
        this.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }

    public void setActionDescription(String message) {
        this.actionDescription = message;
    }

    public String getActionDescription() {
        return this.actionDescription;
    }

    public void setFailureCause(Throwable t) {
        this.exception = t;
    }

    public Throwable getFailureCause() {
        return this.exception;
    }

    public ActionReport.MessagePart getTopMessagePart() {
        return this.topMessage;
    }

    public ActionReport addSubActionsReport() {
        ActionReporter subAction;
        try {
            subAction = (ActionReporter)((Object)((Object)((Object)this)).getClass().newInstance());
        }
        catch (IllegalAccessException ex) {
            return null;
        }
        catch (InstantiationException ex) {
            return null;
        }
        this.subActions.add(subAction);
        return subAction;
    }

    public List<ActionReporter> getSubActionsReport() {
        return this.subActions;
    }

    public void setActionExitCode(ActionReport.ExitCode exitCode) {
        this.exitCode = exitCode;
    }

    public ActionReport.ExitCode getActionExitCode() {
        return this.exitCode;
    }

    public void setMessage(String message) {
        this.topMessage.setMessage(message);
    }

    public void appendMessage(String message) {
        this.topMessage.appendMessage(message);
    }

    public String getMessage() {
        return this.topMessage.getMessage();
    }

    public String getContentType() {
        return this.contentType;
    }

    public void getCombinedMessages(ActionReporter aReport, StringBuilder sb) {
        String failMsg;
        if (aReport == null || sb == null) {
            return;
        }
        String mainMsg = "";
        if (aReport.getMessage() != null && !aReport.getMessage().isEmpty()) {
            LocalStringManagerImpl localStrings;
            mainMsg = aReport.getMessage();
            String format = "{0}";
            if (ActionReport.ExitCode.WARNING.equals((Object)aReport.getActionExitCode())) {
                localStrings = new LocalStringManagerImpl(ActionReporter.class);
                format = localStrings.getLocalString("flag.message.as.warning", "Warning: {0}");
            }
            if (ActionReport.ExitCode.FAILURE.equals((Object)aReport.getActionExitCode())) {
                localStrings = new LocalStringManagerImpl(ActionReporter.class);
                format = localStrings.getLocalString("flag.message.as.failure", "Failure: {0}");
            }
            if (sb.length() > 0) {
                sb.append(EOL_MARKER);
            }
            sb.append(MessageFormat.format(format, mainMsg));
        }
        if (aReport.getFailureCause() != null && aReport.getFailureCause().getMessage() != null && !aReport.getFailureCause().getMessage().isEmpty() && !(failMsg = aReport.getFailureCause().getMessage()).equals(mainMsg)) {
            if (sb.length() > 0) {
                sb.append(EOL_MARKER);
            }
            sb.append(failMsg);
        }
        for (ActionReporter sub : aReport.subActions) {
            this.getCombinedMessages(sub, sb);
        }
    }

    public boolean hasSuccesses() {
        return ActionReporter.has(this, ActionReport.ExitCode.SUCCESS);
    }

    public boolean hasWarnings() {
        return ActionReporter.has(this, ActionReport.ExitCode.WARNING);
    }

    public boolean hasFailures() {
        return ActionReporter.has(this, ActionReport.ExitCode.FAILURE);
    }

    private static boolean has(ActionReporter ar, ActionReport.ExitCode value) {
        if (null != ar.exitCode && ar.exitCode.equals((Object)value)) {
            return true;
        }
        LinkedList<ActionReporter> q = new LinkedList<ActionReporter>();
        q.addAll(ar.subActions);
        while (!q.isEmpty()) {
            ActionReporter lar = (ActionReporter)((Object)q.remove());
            ActionReport.ExitCode ec = lar.getActionExitCode();
            if (ec != null && ec.equals((Object)value)) {
                return true;
            }
            q.addAll(lar.subActions);
        }
        return false;
    }
}

