/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.api.persistence.enhancer.impl;

import com.sun.jdo.api.persistence.enhancer.classfile.ClassFile;
import com.sun.jdo.api.persistence.enhancer.classfile.ConstClass;
import com.sun.jdo.api.persistence.enhancer.impl.ClassAction;
import com.sun.jdo.api.persistence.enhancer.impl.Environment;
import com.sun.jdo.api.persistence.enhancer.meta.JDOMetaData;
import com.sun.jdo.api.persistence.enhancer.util.ClassFileSource;
import com.sun.jdo.api.persistence.enhancer.util.Support;
import com.sun.jdo.api.persistence.enhancer.util.UserException;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;

public final class ClassControl
extends Support {
    public static final int TransientOnly = -1;
    public static final int PersistUnknown = 0;
    public static final int PersistAware = 1;
    public static final int PersistCapable = 2;
    public static final int UpdateNotNeeded = -1;
    public static final int UpdateUnknown = 0;
    public static final int UpdateNew = 1;
    public static final int UpdateNewer = 2;
    private final Environment env;
    private final ClassFileSource theClassSource;
    private ClassFile theClass;
    private int persistenceType = 0;
    private int updateType = 0;
    private final ClassAction classAction;
    private boolean classUpdated;

    public boolean updated() {
        return this.classUpdated;
    }

    public void noteUpdate() {
        this.classUpdated = true;
    }

    public ClassFile classFile() {
        return this.theClass;
    }

    public int persistType() {
        return this.persistenceType;
    }

    public boolean filterRequired() {
        if (this.updateType == 0) {
            this.checkUpdateType();
        }
        return this.updateType > 0 || this.env.forceOverwrite();
    }

    public void requireUpdate() {
        this.updateType = 1;
    }

    public boolean annotateable() {
        return this.persistenceType >= 0;
    }

    public ClassAction action() {
        return this.classAction;
    }

    public ClassControl(ClassFileSource theSource, Environment env) {
        this.theClassSource = theSource;
        this.buildTheClass(true);
        this.theClassSource.setExpectedClassName(this.className());
        this.classAction = new ClassAction(this, env);
        this.env = env;
    }

    public ClassControl(ClassFileSource theSource, ClassFile theFile, Environment env) {
        this.theClassSource = theSource;
        this.theClass = theFile;
        this.theClassSource.setExpectedClassName(this.className());
        this.classAction = new ClassAction(this, env);
        this.env = env;
    }

    private void setPersistenceType() {
        JDOMetaData meta = this.env.getJDOMetaData();
        if (this.persistenceType != 0) {
            return;
        }
        if (this.classFile().isInterface()) {
            this.persistenceType = -1;
            return;
        }
        String className = this.className();
        if (meta.isTransientClass(className)) {
            this.persistenceType = -1;
            return;
        }
        if (meta.isPersistenceCapableClass(className)) {
            this.persistenceType = 2;
            ClassControl.affirm(meta.isPersistenceCapableRootClass(className), "Sorry, not supported yet: the persistent-capable class " + this.userClassName() + "cannot extend a persistent-capable super-class.");
        }
    }

    public void scan1() {
        try {
            if (this.env.doTimingStatistics()) {
                Support.timer.push("ClassControl.scan1()");
            }
            this.setPersistenceType();
            if (this.annotateable()) {
                if (this.filterRequired()) {
                    this.classAction.scan1();
                } else {
                    this.env.message("skipping " + this.userClassName() + " because it is already up to date.");
                }
            }
        }
        finally {
            if (this.env.doTimingStatistics()) {
                Support.timer.pop();
            }
        }
    }

    public void augment() {
        try {
            if (this.env.doTimingStatistics()) {
                Support.timer.push("ClassControl.augment()");
            }
            if (this.annotateable()) {
                if (this.filterRequired()) {
                    this.classAction.augment();
                } else {
                    this.env.message("skipping " + this.userClassName() + " because it is already up to date.");
                }
            }
        }
        finally {
            if (this.env.doTimingStatistics()) {
                Support.timer.pop();
            }
        }
    }

    public void annotate() {
        try {
            if (this.env.doTimingStatistics()) {
                Support.timer.push("ClassControl.annotate()");
            }
            if (this.annotateable()) {
                if (this.filterRequired()) {
                    this.classAction.annotate();
                } else {
                    this.env.message("skipping " + this.userClassName() + " because it is already up to date.");
                }
            }
        }
        finally {
            if (this.env.doTimingStatistics()) {
                Support.timer.pop();
            }
        }
    }

    public String className() {
        ConstClass cname = this.theClass.className();
        return cname == null ? null : cname.asString();
    }

    public String userClassName() {
        return ClassControl.userClassFromVMClass(this.className());
    }

    public static String userClassFromVMClass(String vmName) {
        return vmName.replace('/', '.');
    }

    public static String vmClassFromUserClass(String userName) {
        return userName.replace('.', '/');
    }

    public String pkg() {
        return ClassControl.packageOf(this.className());
    }

    public static String packageOf(String vmName) {
        int last = vmName.lastIndexOf(47);
        if (last < 0) {
            return "";
        }
        return vmName.substring(0, last);
    }

    public String sourceName() {
        return this.theClassSource.containingFilePath();
    }

    public ClassFileSource source() {
        return this.theClassSource;
    }

    public void write(File destFile) throws IOException, FileNotFoundException {
        DataOutputStream dos = this.theClassSource.getOutputStream(destFile);
        this.theClass.write(dos);
        dos.close();
    }

    private void checkUpdateType() {
        if (this.updateType == 0) {
            String lookupName = this.className();
            ClassFileSource annotatedSource = this.env.updateInPlace() && !this.theClassSource.isZipped() ? this.theClassSource : this.env.lookupDestClass(lookupName);
            if (annotatedSource == null) {
                this.updateType = 1;
            } else {
                try {
                    long annModDate = annotatedSource.modificationDate();
                    long srcModDate = this.source().modificationDate();
                    this.updateType = annModDate < srcModDate ? 2 : (annotatedSource == this.theClassSource && !this.action().hasAnnotatedAttribute() ? (this.persistenceType == 2 || this.persistenceType == 1 ? 2 : -1) : -1);
                }
                catch (FileNotFoundException e) {
                    this.updateType = 1;
                }
            }
        }
    }

    private void buildTheClass(boolean allowJDK12ClassFiles) {
        try {
            DataInputStream dis = this.theClassSource.classFileContents();
            this.theClass = new ClassFile(dis);
            dis.close();
        }
        catch (FileNotFoundException e) {
            throw new UserException(ClassControl.getI18N("enhancer.file_not_found", this.sourceName()), e);
        }
        catch (IOException e) {
            throw new UserException(ClassControl.getI18N("enhancer.io_error_while_reading_file", this.sourceName()), e);
        }
    }
}

