/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.config;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import javax.xml.stream.XMLInputFactory;
import org.glassfish.grizzly.config.GrizzlyConfigException;
import org.glassfish.grizzly.config.dom.NetworkListener;
import org.glassfish.hk2.api.DescriptorFileFinder;
import org.glassfish.hk2.api.DynamicConfiguration;
import org.glassfish.hk2.api.DynamicConfigurationService;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.api.ServiceLocatorFactory;
import org.glassfish.hk2.bootstrap.HK2Populator;
import org.glassfish.hk2.bootstrap.impl.ClasspathDescriptorFileFinder;
import org.glassfish.hk2.utilities.ServiceLocatorUtilities;
import org.jvnet.hk2.config.ConfigParser;
import org.jvnet.hk2.config.DomDocument;

public class Utils {
    private static final System.Logger LOG = System.getLogger(Utils.class.getName());

    public static ServiceLocator getServiceLocator(String fileURL) {
        ServiceLocator locator;
        URL url = Utils.class.getClassLoader().getResource(fileURL);
        if (url == null) {
            try {
                url = new URL(fileURL);
            }
            catch (MalformedURLException e) {
                throw new GrizzlyConfigException(e.getMessage());
            }
        }
        try {
            locator = Utils.getServiceLocator(url.openStream(), url.toString());
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return locator;
    }

    public static ServiceLocator getServiceLocator(InputStream inputStream, String name) {
        try {
            ServiceLocator locator = Utils.getNewServiceLocator(name);
            ConfigParser parser = new ConfigParser(locator);
            XMLInputFactory xif = XMLInputFactory.class.getClassLoader() == null ? XMLInputFactory.newFactory() : XMLInputFactory.newFactory(XMLInputFactory.class.getName(), XMLInputFactory.class.getClassLoader());
            DomDocument document = parser.parse(xif.createXMLStreamReader(inputStream));
            ServiceLocatorUtilities.addOneConstant((ServiceLocator)locator, (Object)document);
            return locator;
        }
        catch (Exception e) {
            throw new GrizzlyConfigException(e.getMessage(), e);
        }
    }

    public static ServiceLocator getNewServiceLocator(String name) {
        ServiceLocator locator = null;
        ServiceLocatorFactory locatorFactory = ServiceLocatorFactory.getInstance();
        if (locatorFactory.find(name) == null) {
            ServiceLocator serviceLocator = locatorFactory.create(name);
            DynamicConfigurationService dcs = (DynamicConfigurationService)serviceLocator.getService(DynamicConfigurationService.class, new Annotation[0]);
            DynamicConfiguration config = dcs.createDynamicConfiguration();
            config.commit();
            locator = locatorFactory.create(name);
            try {
                HK2Populator.populate((ServiceLocator)serviceLocator, (DescriptorFileFinder)new ClasspathDescriptorFileFinder(Utils.class.getClassLoader()), null);
            }
            catch (IOException e) {
                LOG.log(System.Logger.Level.WARNING, "HK2 Populator failed.", (Throwable)e);
            }
        }
        return locator == null ? locatorFactory.create(name) : locator;
    }

    public static String composeThreadPoolName(NetworkListener networkListener) {
        return networkListener.getThreadPool() + "-" + networkListener.getPort();
    }

    public static <E> E newInstance(ServiceLocator locator, Class<E> clazz, String name, String realClassName) {
        return Utils.newInstance(locator, clazz, name, realClassName, null, null);
    }

    public static <E> E newInstance(ServiceLocator locator, Class<E> clazz, String name, String realClassName, Class<?>[] argTypes, Object[] args) {
        Object instance;
        Object object = instance = locator == null ? null : locator.getService(clazz, name, new Annotation[0]);
        if (instance != null) {
            return (E)instance;
        }
        try {
            if (argTypes == null || argTypes.length == 0) {
                return (E)Utils.newInstance(realClassName);
            }
            return (E)Utils.newInstance(realClassName, argTypes, args);
        }
        catch (Exception e) {
            LOG.log(System.Logger.Level.WARNING, () -> "Instance could not be initialized. Class=" + clazz.getName() + ", name=" + name + ", realClassName=" + realClassName, (Throwable)e);
            return null;
        }
    }

    public static Object newInstance(String classname) throws Exception {
        return Utils.loadClass(classname).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
    }

    public static Object newInstance(String classname, Class<?>[] argTypes, Object[] args) throws Exception {
        Class clazz = Utils.loadClass(classname);
        Constructor c = clazz.getConstructor(argTypes);
        assert (c != null);
        return c.newInstance(args);
    }

    public static Class loadClass(String classname) throws ClassNotFoundException {
        Class<?> clazz = null;
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl != null) {
            try {
                clazz = cl.loadClass(classname);
            }
            catch (Exception ignored) {
                LOG.log(System.Logger.Level.DEBUG, "Loading class " + classname + " failed", (Throwable)ignored);
            }
        }
        if (clazz == null) {
            clazz = Utils.class.getClassLoader().loadClass(classname);
        }
        return clazz;
    }

    public static boolean isDebugVM() {
        boolean debugMode = false;
        List<String> l = ManagementFactory.getRuntimeMXBean().getInputArguments();
        for (String s : l) {
            if (!s.trim().startsWith("-Xrunjdwp:") && !s.contains("jdwp")) continue;
            debugMode = true;
            break;
        }
        return debugMode;
    }
}

