/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging;

import com.sun.messaging.AdministeredObject;
import com.sun.messaging.jmq.DestinationName;
import jakarta.jms.InvalidDestinationException;
import jakarta.jms.JMSException;
import java.util.Properties;

public abstract class Destination
extends AdministeredObject
implements jakarta.jms.Destination {
    private static final long serialVersionUID = -9148065553435050339L;
    private static final String defaultsBase = "Destination";

    public Destination() {
        super(defaultsBase);
    }

    public Destination(String name) throws InvalidDestinationException {
        super(defaultsBase);
        if (name == null || "".equals(name)) {
            String errorString = AdministeredObject.cr.getKString("C4050");
            throw new InvalidDestinationException(errorString, "C4050");
        }
        if (this.isTemporary()) {
            this.configuration.put("imqDestinationName", name);
        } else if (DestinationName.isSyntaxValid(name)) {
            this.configuration.put("imqDestinationName", name);
        } else {
            String errorString = AdministeredObject.cr.getKString("C4050", name);
            throw new InvalidDestinationException(errorString, "C4050");
        }
    }

    public String getName() {
        try {
            return super.getProperty("imqDestinationName");
        }
        catch (JMSException e) {
            return "";
        }
    }

    public String getQueueName() throws JMSException {
        return this.getName();
    }

    public String getTopicName() throws JMSException {
        return this.getName();
    }

    @Override
    public String toString() {
        return "Eclipse OpenMQ Destination\ngetName():\t\t" + this.getName() + super.toString();
    }

    public abstract boolean isQueue();

    public abstract boolean isTemporary();

    @Override
    public void setDefaultConfiguration() {
        this.configuration = new Properties();
        this.configurationTypes = new Properties();
        this.configurationLabels = new Properties();
        this.configuration.put("imqDestinationName", "Untitled_Destination_Object");
        this.configurationTypes.put("imqDestinationName", "java.lang.String");
        this.configurationLabels.put("imqDestinationName", "L0570");
        this.configuration.put("imqDestinationDescription", "A Description for the Destination Object");
        this.configurationTypes.put("imqDestinationDescription", "java.lang.String");
        this.configurationLabels.put("imqDestinationDescription", "L0571");
    }

    public Boolean validate_imqDestinationName(String name) {
        if (this.isTemporary()) {
            if (name != null && name.startsWith("temporary_destination://")) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        return DestinationName.isSyntaxValid(name);
    }
}

