/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.util.proxy;

import com.sun.enterprise.admin.util.proxy.Call;
import com.sun.enterprise.admin.util.proxy.CallState;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Stack;

public class CallStack {
    private Stack callStack = new Stack();

    public int getStackSize() {
        return this.callStack.size();
    }

    public void beginCall(Method m, Object[] args) {
        Call call = new Call(m, args);
        this.beginCall(call);
    }

    public void beginCall(Call call) {
        this.callStack.push(call);
    }

    public void endCall() {
        Call call = (Call)this.callStack.pop();
        if (!call.getState().isFinished()) {
            call.setState(CallState.SUCCESS);
        }
    }

    public void endCallWithError(Throwable th) {
        Call call = (Call)this.callStack.peek();
        call.setState(CallState.FAILED);
        call.setFailureReason(th);
        this.endCall();
    }

    public Call getActiveCall() {
        return (Call)this.callStack.peek();
    }

    public Iterator getCallStack() {
        return this.callStack.iterator();
    }
}

