/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.enterprise.iiop.impl;

import com.sun.logging.LogDomains;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.enterprise.iiop.api.IIOPInterceptorFactory;
import org.glassfish.enterprise.iiop.util.IIOPUtils;
import org.omg.CORBA.LocalObject;
import org.omg.IOP.Codec;
import org.omg.IOP.CodecFactory;
import org.omg.IOP.Encoding;
import org.omg.PortableInterceptor.ClientRequestInterceptor;
import org.omg.PortableInterceptor.ORBInitInfo;
import org.omg.PortableInterceptor.ORBInitializer;
import org.omg.PortableInterceptor.ServerRequestInterceptor;

public class GlassFishORBInitializer
extends LocalObject
implements ORBInitializer {
    private static final Logger _logger = LogDomains.getLogger(GlassFishORBInitializer.class, (String)"jakarta.enterprise.resource.corba");

    private static void fineLog(String fmt, Object ... args) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, fmt, args);
        }
    }

    public void pre_init(ORBInitInfo info) {
    }

    public void post_init(ORBInitInfo info) {
        Codec codec = null;
        GlassFishORBInitializer.fineLog("J2EE Initializer post_init", new Object[0]);
        GlassFishORBInitializer.fineLog("Creating Codec for CDR encoding", new Object[0]);
        CodecFactory cf = info.codec_factory();
        byte major_version = 1;
        byte minor_version = 2;
        Encoding encoding = new Encoding(0, major_version, minor_version);
        try {
            codec = cf.create_codec(encoding);
            IIOPUtils iiopUtils = IIOPUtils.getInstance();
            Collection interceptorFactories = iiopUtils.getAllIIOPInterceptrFactories();
            for (IIOPInterceptorFactory factory : interceptorFactories) {
                GlassFishORBInitializer.fineLog("Processing interceptor factory: {0}", factory);
                ClientRequestInterceptor clientReq = factory.createClientRequestInterceptor(info, codec);
                ServerRequestInterceptor serverReq = factory.createServerRequestInterceptor(info, codec);
                if (clientReq != null) {
                    GlassFishORBInitializer.fineLog("Registering client interceptor: {0}", clientReq);
                    info.add_client_request_interceptor(clientReq);
                }
                if (serverReq == null) continue;
                GlassFishORBInitializer.fineLog("Registering server interceptor: {0}", serverReq);
                info.add_server_request_interceptor(serverReq);
            }
        }
        catch (Exception e) {
            if (_logger.isLoggable(Level.WARNING)) {
                _logger.log(Level.WARNING, "Exception registering interceptors", e);
            }
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

